# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['NetworkArgs', 'Network']

@pulumi.input_type
class NetworkArgs:
    def __init__(__self__, *,
                 auto_create_subnetworks: Optional[pulumi.Input[bool]] = None,
                 delete_default_routes_on_create: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_ula_internal_ipv6: Optional[pulumi.Input[bool]] = None,
                 internal_ipv6_range: Optional[pulumi.Input[str]] = None,
                 mtu: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 routing_mode: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Network resource.
        :param pulumi.Input[bool] auto_create_subnetworks: When set to `true`, the network is created in "auto subnet mode" and
               it will create a subnet for each region automatically across the
               `10.128.0.0/9` address range.
               When set to `false`, the network is created in "custom subnet mode" so
               the user can explicitly connect subnetwork resources.
        :param pulumi.Input[bool] delete_default_routes_on_create: If set to `true`, default routes (`0.0.0.0/0`) will be deleted
               immediately after network creation. Defaults to `false`.
        :param pulumi.Input[str] description: An optional description of this resource. The resource must be
               recreated to modify this field.
        :param pulumi.Input[bool] enable_ula_internal_ipv6: Enable ULA internal ipv6 on this network. Enabling this feature will assign
               a /48 from google defined ULA prefix fd20::/20.
        :param pulumi.Input[str] internal_ipv6_range: When enabling ula internal ipv6, caller optionally can specify the /48 range
               they want from the google defined ULA prefix fd20::/20. The input must be a
               valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will
               fail if the speficied /48 is already in used by another resource.
               If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field.
        :param pulumi.Input[int] mtu: Maximum Transmission Unit in bytes. The minimum value for this field is 1460
               and the maximum value is 1500 bytes.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] routing_mode: The network-wide routing mode to use. If set to `REGIONAL`, this
               network's cloud routers will only advertise routes with subnetworks
               of this network in the same region as the router. If set to `GLOBAL`,
               this network's cloud routers will advertise routes with all
               subnetworks of this network, across regions.
               Possible values are `REGIONAL` and `GLOBAL`.
        """
        if auto_create_subnetworks is not None:
            pulumi.set(__self__, "auto_create_subnetworks", auto_create_subnetworks)
        if delete_default_routes_on_create is not None:
            pulumi.set(__self__, "delete_default_routes_on_create", delete_default_routes_on_create)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ula_internal_ipv6 is not None:
            pulumi.set(__self__, "enable_ula_internal_ipv6", enable_ula_internal_ipv6)
        if internal_ipv6_range is not None:
            pulumi.set(__self__, "internal_ipv6_range", internal_ipv6_range)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if routing_mode is not None:
            pulumi.set(__self__, "routing_mode", routing_mode)

    @property
    @pulumi.getter(name="autoCreateSubnetworks")
    def auto_create_subnetworks(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to `true`, the network is created in "auto subnet mode" and
        it will create a subnet for each region automatically across the
        `10.128.0.0/9` address range.
        When set to `false`, the network is created in "custom subnet mode" so
        the user can explicitly connect subnetwork resources.
        """
        return pulumi.get(self, "auto_create_subnetworks")

    @auto_create_subnetworks.setter
    def auto_create_subnetworks(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_create_subnetworks", value)

    @property
    @pulumi.getter(name="deleteDefaultRoutesOnCreate")
    def delete_default_routes_on_create(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, default routes (`0.0.0.0/0`) will be deleted
        immediately after network creation. Defaults to `false`.
        """
        return pulumi.get(self, "delete_default_routes_on_create")

    @delete_default_routes_on_create.setter
    def delete_default_routes_on_create(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_default_routes_on_create", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. The resource must be
        recreated to modify this field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableUlaInternalIpv6")
    def enable_ula_internal_ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable ULA internal ipv6 on this network. Enabling this feature will assign
        a /48 from google defined ULA prefix fd20::/20.
        """
        return pulumi.get(self, "enable_ula_internal_ipv6")

    @enable_ula_internal_ipv6.setter
    def enable_ula_internal_ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ula_internal_ipv6", value)

    @property
    @pulumi.getter(name="internalIpv6Range")
    def internal_ipv6_range(self) -> Optional[pulumi.Input[str]]:
        """
        When enabling ula internal ipv6, caller optionally can specify the /48 range
        they want from the google defined ULA prefix fd20::/20. The input must be a
        valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will
        fail if the speficied /48 is already in used by another resource.
        If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field.
        """
        return pulumi.get(self, "internal_ipv6_range")

    @internal_ipv6_range.setter
    def internal_ipv6_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internal_ipv6_range", value)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum Transmission Unit in bytes. The minimum value for this field is 1460
        and the maximum value is 1500 bytes.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="routingMode")
    def routing_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The network-wide routing mode to use. If set to `REGIONAL`, this
        network's cloud routers will only advertise routes with subnetworks
        of this network in the same region as the router. If set to `GLOBAL`,
        this network's cloud routers will advertise routes with all
        subnetworks of this network, across regions.
        Possible values are `REGIONAL` and `GLOBAL`.
        """
        return pulumi.get(self, "routing_mode")

    @routing_mode.setter
    def routing_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "routing_mode", value)


@pulumi.input_type
class _NetworkState:
    def __init__(__self__, *,
                 auto_create_subnetworks: Optional[pulumi.Input[bool]] = None,
                 delete_default_routes_on_create: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_ula_internal_ipv6: Optional[pulumi.Input[bool]] = None,
                 gateway_ipv4: Optional[pulumi.Input[str]] = None,
                 internal_ipv6_range: Optional[pulumi.Input[str]] = None,
                 mtu: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 routing_mode: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Network resources.
        :param pulumi.Input[bool] auto_create_subnetworks: When set to `true`, the network is created in "auto subnet mode" and
               it will create a subnet for each region automatically across the
               `10.128.0.0/9` address range.
               When set to `false`, the network is created in "custom subnet mode" so
               the user can explicitly connect subnetwork resources.
        :param pulumi.Input[bool] delete_default_routes_on_create: If set to `true`, default routes (`0.0.0.0/0`) will be deleted
               immediately after network creation. Defaults to `false`.
        :param pulumi.Input[str] description: An optional description of this resource. The resource must be
               recreated to modify this field.
        :param pulumi.Input[bool] enable_ula_internal_ipv6: Enable ULA internal ipv6 on this network. Enabling this feature will assign
               a /48 from google defined ULA prefix fd20::/20.
        :param pulumi.Input[str] gateway_ipv4: The gateway address for default routing out of the network. This value is selected by GCP.
        :param pulumi.Input[str] internal_ipv6_range: When enabling ula internal ipv6, caller optionally can specify the /48 range
               they want from the google defined ULA prefix fd20::/20. The input must be a
               valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will
               fail if the speficied /48 is already in used by another resource.
               If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field.
        :param pulumi.Input[int] mtu: Maximum Transmission Unit in bytes. The minimum value for this field is 1460
               and the maximum value is 1500 bytes.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] routing_mode: The network-wide routing mode to use. If set to `REGIONAL`, this
               network's cloud routers will only advertise routes with subnetworks
               of this network in the same region as the router. If set to `GLOBAL`,
               this network's cloud routers will advertise routes with all
               subnetworks of this network, across regions.
               Possible values are `REGIONAL` and `GLOBAL`.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        """
        if auto_create_subnetworks is not None:
            pulumi.set(__self__, "auto_create_subnetworks", auto_create_subnetworks)
        if delete_default_routes_on_create is not None:
            pulumi.set(__self__, "delete_default_routes_on_create", delete_default_routes_on_create)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ula_internal_ipv6 is not None:
            pulumi.set(__self__, "enable_ula_internal_ipv6", enable_ula_internal_ipv6)
        if gateway_ipv4 is not None:
            pulumi.set(__self__, "gateway_ipv4", gateway_ipv4)
        if internal_ipv6_range is not None:
            pulumi.set(__self__, "internal_ipv6_range", internal_ipv6_range)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if routing_mode is not None:
            pulumi.set(__self__, "routing_mode", routing_mode)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)

    @property
    @pulumi.getter(name="autoCreateSubnetworks")
    def auto_create_subnetworks(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to `true`, the network is created in "auto subnet mode" and
        it will create a subnet for each region automatically across the
        `10.128.0.0/9` address range.
        When set to `false`, the network is created in "custom subnet mode" so
        the user can explicitly connect subnetwork resources.
        """
        return pulumi.get(self, "auto_create_subnetworks")

    @auto_create_subnetworks.setter
    def auto_create_subnetworks(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_create_subnetworks", value)

    @property
    @pulumi.getter(name="deleteDefaultRoutesOnCreate")
    def delete_default_routes_on_create(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, default routes (`0.0.0.0/0`) will be deleted
        immediately after network creation. Defaults to `false`.
        """
        return pulumi.get(self, "delete_default_routes_on_create")

    @delete_default_routes_on_create.setter
    def delete_default_routes_on_create(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_default_routes_on_create", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. The resource must be
        recreated to modify this field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableUlaInternalIpv6")
    def enable_ula_internal_ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable ULA internal ipv6 on this network. Enabling this feature will assign
        a /48 from google defined ULA prefix fd20::/20.
        """
        return pulumi.get(self, "enable_ula_internal_ipv6")

    @enable_ula_internal_ipv6.setter
    def enable_ula_internal_ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ula_internal_ipv6", value)

    @property
    @pulumi.getter(name="gatewayIpv4")
    def gateway_ipv4(self) -> Optional[pulumi.Input[str]]:
        """
        The gateway address for default routing out of the network. This value is selected by GCP.
        """
        return pulumi.get(self, "gateway_ipv4")

    @gateway_ipv4.setter
    def gateway_ipv4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_ipv4", value)

    @property
    @pulumi.getter(name="internalIpv6Range")
    def internal_ipv6_range(self) -> Optional[pulumi.Input[str]]:
        """
        When enabling ula internal ipv6, caller optionally can specify the /48 range
        they want from the google defined ULA prefix fd20::/20. The input must be a
        valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will
        fail if the speficied /48 is already in used by another resource.
        If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field.
        """
        return pulumi.get(self, "internal_ipv6_range")

    @internal_ipv6_range.setter
    def internal_ipv6_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internal_ipv6_range", value)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum Transmission Unit in bytes. The minimum value for this field is 1460
        and the maximum value is 1500 bytes.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="routingMode")
    def routing_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The network-wide routing mode to use. If set to `REGIONAL`, this
        network's cloud routers will only advertise routes with subnetworks
        of this network in the same region as the router. If set to `GLOBAL`,
        this network's cloud routers will advertise routes with all
        subnetworks of this network, across regions.
        Possible values are `REGIONAL` and `GLOBAL`.
        """
        return pulumi.get(self, "routing_mode")

    @routing_mode.setter
    def routing_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "routing_mode", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)


class Network(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_create_subnetworks: Optional[pulumi.Input[bool]] = None,
                 delete_default_routes_on_create: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_ula_internal_ipv6: Optional[pulumi.Input[bool]] = None,
                 internal_ipv6_range: Optional[pulumi.Input[str]] = None,
                 mtu: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 routing_mode: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a VPC network or legacy network resource on GCP.

        To get more information about Network, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/networks)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vpc/docs/vpc)

        ## Example Usage
        ### Network Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc_network = gcp.compute.Network("vpcNetwork")
        ```
        ### Network Custom Mtu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc_network = gcp.compute.Network("vpcNetwork",
            auto_create_subnetworks=True,
            mtu=1460,
            project="my-project-name")
        ```

        ## Import

        Network can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/network:Network default projects/{{project}}/global/networks/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/network:Network default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/network:Network default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_create_subnetworks: When set to `true`, the network is created in "auto subnet mode" and
               it will create a subnet for each region automatically across the
               `10.128.0.0/9` address range.
               When set to `false`, the network is created in "custom subnet mode" so
               the user can explicitly connect subnetwork resources.
        :param pulumi.Input[bool] delete_default_routes_on_create: If set to `true`, default routes (`0.0.0.0/0`) will be deleted
               immediately after network creation. Defaults to `false`.
        :param pulumi.Input[str] description: An optional description of this resource. The resource must be
               recreated to modify this field.
        :param pulumi.Input[bool] enable_ula_internal_ipv6: Enable ULA internal ipv6 on this network. Enabling this feature will assign
               a /48 from google defined ULA prefix fd20::/20.
        :param pulumi.Input[str] internal_ipv6_range: When enabling ula internal ipv6, caller optionally can specify the /48 range
               they want from the google defined ULA prefix fd20::/20. The input must be a
               valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will
               fail if the speficied /48 is already in used by another resource.
               If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field.
        :param pulumi.Input[int] mtu: Maximum Transmission Unit in bytes. The minimum value for this field is 1460
               and the maximum value is 1500 bytes.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] routing_mode: The network-wide routing mode to use. If set to `REGIONAL`, this
               network's cloud routers will only advertise routes with subnetworks
               of this network in the same region as the router. If set to `GLOBAL`,
               this network's cloud routers will advertise routes with all
               subnetworks of this network, across regions.
               Possible values are `REGIONAL` and `GLOBAL`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NetworkArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPC network or legacy network resource on GCP.

        To get more information about Network, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/networks)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vpc/docs/vpc)

        ## Example Usage
        ### Network Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc_network = gcp.compute.Network("vpcNetwork")
        ```
        ### Network Custom Mtu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc_network = gcp.compute.Network("vpcNetwork",
            auto_create_subnetworks=True,
            mtu=1460,
            project="my-project-name")
        ```

        ## Import

        Network can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/network:Network default projects/{{project}}/global/networks/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/network:Network default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/network:Network default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param NetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_create_subnetworks: Optional[pulumi.Input[bool]] = None,
                 delete_default_routes_on_create: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_ula_internal_ipv6: Optional[pulumi.Input[bool]] = None,
                 internal_ipv6_range: Optional[pulumi.Input[str]] = None,
                 mtu: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 routing_mode: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkArgs.__new__(NetworkArgs)

            __props__.__dict__["auto_create_subnetworks"] = auto_create_subnetworks
            __props__.__dict__["delete_default_routes_on_create"] = delete_default_routes_on_create
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_ula_internal_ipv6"] = enable_ula_internal_ipv6
            __props__.__dict__["internal_ipv6_range"] = internal_ipv6_range
            __props__.__dict__["mtu"] = mtu
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["routing_mode"] = routing_mode
            __props__.__dict__["gateway_ipv4"] = None
            __props__.__dict__["self_link"] = None
        super(Network, __self__).__init__(
            'gcp:compute/network:Network',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_create_subnetworks: Optional[pulumi.Input[bool]] = None,
            delete_default_routes_on_create: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enable_ula_internal_ipv6: Optional[pulumi.Input[bool]] = None,
            gateway_ipv4: Optional[pulumi.Input[str]] = None,
            internal_ipv6_range: Optional[pulumi.Input[str]] = None,
            mtu: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            routing_mode: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None) -> 'Network':
        """
        Get an existing Network resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_create_subnetworks: When set to `true`, the network is created in "auto subnet mode" and
               it will create a subnet for each region automatically across the
               `10.128.0.0/9` address range.
               When set to `false`, the network is created in "custom subnet mode" so
               the user can explicitly connect subnetwork resources.
        :param pulumi.Input[bool] delete_default_routes_on_create: If set to `true`, default routes (`0.0.0.0/0`) will be deleted
               immediately after network creation. Defaults to `false`.
        :param pulumi.Input[str] description: An optional description of this resource. The resource must be
               recreated to modify this field.
        :param pulumi.Input[bool] enable_ula_internal_ipv6: Enable ULA internal ipv6 on this network. Enabling this feature will assign
               a /48 from google defined ULA prefix fd20::/20.
        :param pulumi.Input[str] gateway_ipv4: The gateway address for default routing out of the network. This value is selected by GCP.
        :param pulumi.Input[str] internal_ipv6_range: When enabling ula internal ipv6, caller optionally can specify the /48 range
               they want from the google defined ULA prefix fd20::/20. The input must be a
               valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will
               fail if the speficied /48 is already in used by another resource.
               If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field.
        :param pulumi.Input[int] mtu: Maximum Transmission Unit in bytes. The minimum value for this field is 1460
               and the maximum value is 1500 bytes.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] routing_mode: The network-wide routing mode to use. If set to `REGIONAL`, this
               network's cloud routers will only advertise routes with subnetworks
               of this network in the same region as the router. If set to `GLOBAL`,
               this network's cloud routers will advertise routes with all
               subnetworks of this network, across regions.
               Possible values are `REGIONAL` and `GLOBAL`.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkState.__new__(_NetworkState)

        __props__.__dict__["auto_create_subnetworks"] = auto_create_subnetworks
        __props__.__dict__["delete_default_routes_on_create"] = delete_default_routes_on_create
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_ula_internal_ipv6"] = enable_ula_internal_ipv6
        __props__.__dict__["gateway_ipv4"] = gateway_ipv4
        __props__.__dict__["internal_ipv6_range"] = internal_ipv6_range
        __props__.__dict__["mtu"] = mtu
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["routing_mode"] = routing_mode
        __props__.__dict__["self_link"] = self_link
        return Network(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoCreateSubnetworks")
    def auto_create_subnetworks(self) -> pulumi.Output[Optional[bool]]:
        """
        When set to `true`, the network is created in "auto subnet mode" and
        it will create a subnet for each region automatically across the
        `10.128.0.0/9` address range.
        When set to `false`, the network is created in "custom subnet mode" so
        the user can explicitly connect subnetwork resources.
        """
        return pulumi.get(self, "auto_create_subnetworks")

    @property
    @pulumi.getter(name="deleteDefaultRoutesOnCreate")
    def delete_default_routes_on_create(self) -> pulumi.Output[Optional[bool]]:
        """
        If set to `true`, default routes (`0.0.0.0/0`) will be deleted
        immediately after network creation. Defaults to `false`.
        """
        return pulumi.get(self, "delete_default_routes_on_create")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource. The resource must be
        recreated to modify this field.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableUlaInternalIpv6")
    def enable_ula_internal_ipv6(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable ULA internal ipv6 on this network. Enabling this feature will assign
        a /48 from google defined ULA prefix fd20::/20.
        """
        return pulumi.get(self, "enable_ula_internal_ipv6")

    @property
    @pulumi.getter(name="gatewayIpv4")
    def gateway_ipv4(self) -> pulumi.Output[str]:
        """
        The gateway address for default routing out of the network. This value is selected by GCP.
        """
        return pulumi.get(self, "gateway_ipv4")

    @property
    @pulumi.getter(name="internalIpv6Range")
    def internal_ipv6_range(self) -> pulumi.Output[str]:
        """
        When enabling ula internal ipv6, caller optionally can specify the /48 range
        they want from the google defined ULA prefix fd20::/20. The input must be a
        valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will
        fail if the speficied /48 is already in used by another resource.
        If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field.
        """
        return pulumi.get(self, "internal_ipv6_range")

    @property
    @pulumi.getter
    def mtu(self) -> pulumi.Output[int]:
        """
        Maximum Transmission Unit in bytes. The minimum value for this field is 1460
        and the maximum value is 1500 bytes.
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="routingMode")
    def routing_mode(self) -> pulumi.Output[str]:
        """
        The network-wide routing mode to use. If set to `REGIONAL`, this
        network's cloud routers will only advertise routes with subnetworks
        of this network in the same region as the router. If set to `GLOBAL`,
        this network's cloud routers will advertise routes with all
        subnetworks of this network, across regions.
        Possible values are `REGIONAL` and `GLOBAL`.
        """
        return pulumi.get(self, "routing_mode")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

