# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'InstanceCryptoKeyConfig',
    'InstanceEventPublishConfig',
    'InstanceNetworkConfig',
]

@pulumi.output_type
class InstanceCryptoKeyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyReference":
            suggest = "key_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceCryptoKeyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceCryptoKeyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceCryptoKeyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_reference: str):
        """
        :param str key_reference: The name of the key which is used to encrypt/decrypt customer data. For key in Cloud KMS, the key should be in the format of projects/*/locations/*/keyRings/*/cryptoKeys/*.
        """
        pulumi.set(__self__, "key_reference", key_reference)

    @property
    @pulumi.getter(name="keyReference")
    def key_reference(self) -> str:
        """
        The name of the key which is used to encrypt/decrypt customer data. For key in Cloud KMS, the key should be in the format of projects/*/locations/*/keyRings/*/cryptoKeys/*.
        """
        return pulumi.get(self, "key_reference")


@pulumi.output_type
class InstanceEventPublishConfig(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 topic: str):
        """
        :param bool enabled: Option to enable Event Publishing.
        :param str topic: The resource name of the Pub/Sub topic. Format: projects/{projectId}/topics/{topic_id}
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Option to enable Event Publishing.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The resource name of the Pub/Sub topic. Format: projects/{projectId}/topics/{topic_id}
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class InstanceNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAllocation":
            suggest = "ip_allocation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_allocation: str,
                 network: str):
        """
        :param str ip_allocation: The IP range in CIDR notation to use for the managed Data Fusion instance
               nodes. This range must not overlap with any other ranges used in the Data Fusion instance network.
        :param str network: Name of the network in the project with which the tenant project
               will be peered for executing pipelines. In case of shared VPC where the network resides in another host
               project the network should specified in the form of projects/{host-project-id}/global/networks/{network}
        """
        pulumi.set(__self__, "ip_allocation", ip_allocation)
        pulumi.set(__self__, "network", network)

    @property
    @pulumi.getter(name="ipAllocation")
    def ip_allocation(self) -> str:
        """
        The IP range in CIDR notation to use for the managed Data Fusion instance
        nodes. This range must not overlap with any other ranges used in the Data Fusion instance network.
        """
        return pulumi.get(self, "ip_allocation")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        Name of the network in the project with which the tenant project
        will be peered for executing pipelines. In case of shared VPC where the network resides in another host
        project the network should specified in the form of projects/{host-project-id}/global/networks/{network}
        """
        return pulumi.get(self, "network")


