# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ConnectionProfileBigqueryProfile',
    'ConnectionProfileForwardSshConnectivity',
    'ConnectionProfileGcsProfile',
    'ConnectionProfileMysqlProfile',
    'ConnectionProfileMysqlProfileSslConfig',
    'ConnectionProfileOracleProfile',
    'ConnectionProfilePostgresqlProfile',
    'ConnectionProfilePrivateConnectivity',
    'PrivateConnectionError',
    'PrivateConnectionVpcPeeringConfig',
]

@pulumi.output_type
class ConnectionProfileBigqueryProfile(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class ConnectionProfileForwardSshConnectivity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileForwardSshConnectivity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileForwardSshConnectivity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileForwardSshConnectivity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: str,
                 username: str,
                 password: Optional[str] = None,
                 port: Optional[int] = None,
                 private_key: Optional[str] = None):
        """
        :param str hostname: Hostname for the SSH tunnel.
        :param str username: Username for the SSH tunnel.
        :param str password: SSH password.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param int port: Port for the SSH tunnel.
        :param str private_key: SSH private key.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "username", username)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Hostname for the SSH tunnel.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username for the SSH tunnel.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        SSH password.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port for the SSH tunnel.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[str]:
        """
        SSH private key.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "private_key")


@pulumi.output_type
class ConnectionProfileGcsProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rootPath":
            suggest = "root_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileGcsProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileGcsProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileGcsProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 root_path: Optional[str] = None):
        """
        :param str bucket: The Cloud Storage bucket name.
        :param str root_path: The root path inside the Cloud Storage bucket.
        """
        pulumi.set(__self__, "bucket", bucket)
        if root_path is not None:
            pulumi.set(__self__, "root_path", root_path)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The Cloud Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="rootPath")
    def root_path(self) -> Optional[str]:
        """
        The root path inside the Cloud Storage bucket.
        """
        return pulumi.get(self, "root_path")


@pulumi.output_type
class ConnectionProfileMysqlProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sslConfig":
            suggest = "ssl_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileMysqlProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileMysqlProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileMysqlProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: str,
                 password: str,
                 username: str,
                 port: Optional[int] = None,
                 ssl_config: Optional['outputs.ConnectionProfileMysqlProfileSslConfig'] = None):
        """
        :param str hostname: Hostname for the SSH tunnel.
        :param str password: SSH password.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str username: Username for the SSH tunnel.
        :param int port: Port for the SSH tunnel.
        :param 'ConnectionProfileMysqlProfileSslConfigArgs' ssl_config: SSL configuration for the MySQL connection.
               Structure is documented below.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssl_config is not None:
            pulumi.set(__self__, "ssl_config", ssl_config)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Hostname for the SSH tunnel.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        SSH password.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username for the SSH tunnel.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port for the SSH tunnel.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="sslConfig")
    def ssl_config(self) -> Optional['outputs.ConnectionProfileMysqlProfileSslConfig']:
        """
        SSL configuration for the MySQL connection.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl_config")


@pulumi.output_type
class ConnectionProfileMysqlProfileSslConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificate":
            suggest = "ca_certificate"
        elif key == "caCertificateSet":
            suggest = "ca_certificate_set"
        elif key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientCertificateSet":
            suggest = "client_certificate_set"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "clientKeySet":
            suggest = "client_key_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileMysqlProfileSslConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileMysqlProfileSslConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileMysqlProfileSslConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate: Optional[str] = None,
                 ca_certificate_set: Optional[bool] = None,
                 client_certificate: Optional[str] = None,
                 client_certificate_set: Optional[bool] = None,
                 client_key: Optional[str] = None,
                 client_key_set: Optional[bool] = None):
        """
        :param str ca_certificate: PEM-encoded certificate of the CA that signed the source database
               server's certificate.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param bool ca_certificate_set: -
               Indicates whether the clientKey field is set.
        :param str client_certificate: PEM-encoded certificate that will be used by the replica to
               authenticate against the source database server. If this field
               is used then the 'clientKey' and the 'caCertificate' fields are
               mandatory.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param bool client_certificate_set: -
               Indicates whether the clientCertificate field is set.
        :param str client_key: PEM-encoded private key associated with the Client Certificate.
               If this field is used then the 'client_certificate' and the
               'ca_certificate' fields are mandatory.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param bool client_key_set: -
               Indicates whether the clientKey field is set.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if ca_certificate_set is not None:
            pulumi.set(__self__, "ca_certificate_set", ca_certificate_set)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_certificate_set is not None:
            pulumi.set(__self__, "client_certificate_set", client_certificate_set)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if client_key_set is not None:
            pulumi.set(__self__, "client_key_set", client_key_set)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[str]:
        """
        PEM-encoded certificate of the CA that signed the source database
        server's certificate.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="caCertificateSet")
    def ca_certificate_set(self) -> Optional[bool]:
        """
        -
        Indicates whether the clientKey field is set.
        """
        return pulumi.get(self, "ca_certificate_set")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[str]:
        """
        PEM-encoded certificate that will be used by the replica to
        authenticate against the source database server. If this field
        is used then the 'clientKey' and the 'caCertificate' fields are
        mandatory.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientCertificateSet")
    def client_certificate_set(self) -> Optional[bool]:
        """
        -
        Indicates whether the clientCertificate field is set.
        """
        return pulumi.get(self, "client_certificate_set")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[str]:
        """
        PEM-encoded private key associated with the Client Certificate.
        If this field is used then the 'client_certificate' and the
        'ca_certificate' fields are mandatory.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clientKeySet")
    def client_key_set(self) -> Optional[bool]:
        """
        -
        Indicates whether the clientKey field is set.
        """
        return pulumi.get(self, "client_key_set")


@pulumi.output_type
class ConnectionProfileOracleProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseService":
            suggest = "database_service"
        elif key == "connectionAttributes":
            suggest = "connection_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfileOracleProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfileOracleProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfileOracleProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_service: str,
                 hostname: str,
                 password: str,
                 username: str,
                 connection_attributes: Optional[Mapping[str, str]] = None,
                 port: Optional[int] = None):
        """
        :param str database_service: Database for the Oracle connection.
        :param str hostname: Hostname for the SSH tunnel.
        :param str password: SSH password.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str username: Username for the SSH tunnel.
        :param Mapping[str, str] connection_attributes: Connection string attributes
        :param int port: Port for the SSH tunnel.
        """
        pulumi.set(__self__, "database_service", database_service)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if connection_attributes is not None:
            pulumi.set(__self__, "connection_attributes", connection_attributes)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="databaseService")
    def database_service(self) -> str:
        """
        Database for the Oracle connection.
        """
        return pulumi.get(self, "database_service")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Hostname for the SSH tunnel.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        SSH password.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username for the SSH tunnel.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="connectionAttributes")
    def connection_attributes(self) -> Optional[Mapping[str, str]]:
        """
        Connection string attributes
        """
        return pulumi.get(self, "connection_attributes")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port for the SSH tunnel.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ConnectionProfilePostgresqlProfile(dict):
    def __init__(__self__, *,
                 database: str,
                 hostname: str,
                 password: str,
                 username: str,
                 port: Optional[int] = None):
        """
        :param str database: Database for the PostgreSQL connection.
        :param str hostname: Hostname for the SSH tunnel.
        :param str password: SSH password.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str username: Username for the SSH tunnel.
        :param int port: Port for the SSH tunnel.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        Database for the PostgreSQL connection.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Hostname for the SSH tunnel.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        SSH password.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username for the SSH tunnel.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port for the SSH tunnel.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ConnectionProfilePrivateConnectivity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateConnection":
            suggest = "private_connection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionProfilePrivateConnectivity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionProfilePrivateConnectivity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionProfilePrivateConnectivity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_connection: str):
        """
        :param str private_connection: A reference to a private connection resource. Format: `projects/{project}/locations/{location}/privateConnections/{name}`
        """
        pulumi.set(__self__, "private_connection", private_connection)

    @property
    @pulumi.getter(name="privateConnection")
    def private_connection(self) -> str:
        """
        A reference to a private connection resource. Format: `projects/{project}/locations/{location}/privateConnections/{name}`
        """
        return pulumi.get(self, "private_connection")


@pulumi.output_type
class PrivateConnectionError(dict):
    def __init__(__self__, *,
                 details: Optional[Mapping[str, str]] = None,
                 message: Optional[str] = None):
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def details(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        return pulumi.get(self, "message")


@pulumi.output_type
class PrivateConnectionVpcPeeringConfig(dict):
    def __init__(__self__, *,
                 subnet: str,
                 vpc: str):
        """
        :param str subnet: A free subnet for peering. (CIDR of /29)
        :param str vpc: Fully qualified name of the VPC that Datastream will peer to.
               Format: projects/{project}/global/{networks}/{name}
        """
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter
    def subnet(self) -> str:
        """
        A free subnet for peering. (CIDR of /29)
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def vpc(self) -> str:
        """
        Fully qualified name of the VPC that Datastream will peer to.
        Format: projects/{project}/global/{networks}/{name}
        """
        return pulumi.get(self, "vpc")


