# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResponsePolicyRuleArgs', 'ResponsePolicyRule']

@pulumi.input_type
class ResponsePolicyRuleArgs:
    def __init__(__self__, *,
                 dns_name: pulumi.Input[str],
                 response_policy: pulumi.Input[str],
                 rule_name: pulumi.Input[str],
                 behavior: Optional[pulumi.Input[str]] = None,
                 local_data: Optional[pulumi.Input['ResponsePolicyRuleLocalDataArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ResponsePolicyRule resource.
        :param pulumi.Input[str] dns_name: The DNS name (wildcard or exact) to apply this rule to. Must be unique within the Response Policy Rule.
        :param pulumi.Input[str] response_policy: Identifies the response policy addressed by this request.
        :param pulumi.Input[str] rule_name: An identifier for this rule. Must be unique with the ResponsePolicy.
        :param pulumi.Input[str] behavior: Answer this query with a behavior rather than DNS data. Acceptable values are 'behaviorUnspecified', and 'bypassResponsePolicy'
        :param pulumi.Input['ResponsePolicyRuleLocalDataArgs'] local_data: Answer this query directly with DNS data. These ResourceRecordSets override any other DNS behavior for the matched name;
               in particular they override private zones, the public internet, and GCP internal DNS. No SOA nor NS types are allowed.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "dns_name", dns_name)
        pulumi.set(__self__, "response_policy", response_policy)
        pulumi.set(__self__, "rule_name", rule_name)
        if behavior is not None:
            pulumi.set(__self__, "behavior", behavior)
        if local_data is not None:
            pulumi.set(__self__, "local_data", local_data)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Input[str]:
        """
        The DNS name (wildcard or exact) to apply this rule to. Must be unique within the Response Policy Rule.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="responsePolicy")
    def response_policy(self) -> pulumi.Input[str]:
        """
        Identifies the response policy addressed by this request.
        """
        return pulumi.get(self, "response_policy")

    @response_policy.setter
    def response_policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "response_policy", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[str]:
        """
        An identifier for this rule. Must be unique with the ResponsePolicy.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter
    def behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Answer this query with a behavior rather than DNS data. Acceptable values are 'behaviorUnspecified', and 'bypassResponsePolicy'
        """
        return pulumi.get(self, "behavior")

    @behavior.setter
    def behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "behavior", value)

    @property
    @pulumi.getter(name="localData")
    def local_data(self) -> Optional[pulumi.Input['ResponsePolicyRuleLocalDataArgs']]:
        """
        Answer this query directly with DNS data. These ResourceRecordSets override any other DNS behavior for the matched name;
        in particular they override private zones, the public internet, and GCP internal DNS. No SOA nor NS types are allowed.
        Structure is documented below.
        """
        return pulumi.get(self, "local_data")

    @local_data.setter
    def local_data(self, value: Optional[pulumi.Input['ResponsePolicyRuleLocalDataArgs']]):
        pulumi.set(self, "local_data", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ResponsePolicyRuleState:
    def __init__(__self__, *,
                 behavior: Optional[pulumi.Input[str]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 local_data: Optional[pulumi.Input['ResponsePolicyRuleLocalDataArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 response_policy: Optional[pulumi.Input[str]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ResponsePolicyRule resources.
        :param pulumi.Input[str] behavior: Answer this query with a behavior rather than DNS data. Acceptable values are 'behaviorUnspecified', and 'bypassResponsePolicy'
        :param pulumi.Input[str] dns_name: The DNS name (wildcard or exact) to apply this rule to. Must be unique within the Response Policy Rule.
        :param pulumi.Input['ResponsePolicyRuleLocalDataArgs'] local_data: Answer this query directly with DNS data. These ResourceRecordSets override any other DNS behavior for the matched name;
               in particular they override private zones, the public internet, and GCP internal DNS. No SOA nor NS types are allowed.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] response_policy: Identifies the response policy addressed by this request.
        :param pulumi.Input[str] rule_name: An identifier for this rule. Must be unique with the ResponsePolicy.
        """
        if behavior is not None:
            pulumi.set(__self__, "behavior", behavior)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if local_data is not None:
            pulumi.set(__self__, "local_data", local_data)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if response_policy is not None:
            pulumi.set(__self__, "response_policy", response_policy)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)

    @property
    @pulumi.getter
    def behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Answer this query with a behavior rather than DNS data. Acceptable values are 'behaviorUnspecified', and 'bypassResponsePolicy'
        """
        return pulumi.get(self, "behavior")

    @behavior.setter
    def behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "behavior", value)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS name (wildcard or exact) to apply this rule to. Must be unique within the Response Policy Rule.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="localData")
    def local_data(self) -> Optional[pulumi.Input['ResponsePolicyRuleLocalDataArgs']]:
        """
        Answer this query directly with DNS data. These ResourceRecordSets override any other DNS behavior for the matched name;
        in particular they override private zones, the public internet, and GCP internal DNS. No SOA nor NS types are allowed.
        Structure is documented below.
        """
        return pulumi.get(self, "local_data")

    @local_data.setter
    def local_data(self, value: Optional[pulumi.Input['ResponsePolicyRuleLocalDataArgs']]):
        pulumi.set(self, "local_data", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="responsePolicy")
    def response_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the response policy addressed by this request.
        """
        return pulumi.get(self, "response_policy")

    @response_policy.setter
    def response_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_policy", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for this rule. Must be unique with the ResponsePolicy.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_name", value)


class ResponsePolicyRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 behavior: Optional[pulumi.Input[str]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 local_data: Optional[pulumi.Input[pulumi.InputType['ResponsePolicyRuleLocalDataArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 response_policy: Optional[pulumi.Input[str]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Dns Response Policy Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_1 = gcp.compute.Network("network-1", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        network_2 = gcp.compute.Network("network-2", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        response_policy = gcp.dns.ResponsePolicy("response-policy",
            response_policy_name="example-response-policy",
            networks=[
                gcp.dns.ResponsePolicyNetworkArgs(
                    network_url=network_1.id,
                ),
                gcp.dns.ResponsePolicyNetworkArgs(
                    network_url=network_2.id,
                ),
            ],
            opts=pulumi.ResourceOptions(provider=google_beta))
        example_response_policy_rule = gcp.dns.ResponsePolicyRule("example-response-policy-rule",
            response_policy=response_policy.response_policy_name,
            rule_name="example-rule",
            dns_name="dns.example.com.",
            local_data=gcp.dns.ResponsePolicyRuleLocalDataArgs(
                local_datas=[gcp.dns.ResponsePolicyRuleLocalDataLocalDataArgs(
                    name="dns.example.com.",
                    type="A",
                    ttl=300,
                    rrdatas=["192.0.2.91"],
                )],
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        ResponsePolicyRule can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:dns/responsePolicyRule:ResponsePolicyRule default projects/{{project}}/responsePolicies/{{response_policy}}/rules/{{rule_name}}
        ```

        ```sh
         $ pulumi import gcp:dns/responsePolicyRule:ResponsePolicyRule default {{project}}/{{response_policy}}/{{rule_name}}
        ```

        ```sh
         $ pulumi import gcp:dns/responsePolicyRule:ResponsePolicyRule default {{response_policy}}/{{rule_name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] behavior: Answer this query with a behavior rather than DNS data. Acceptable values are 'behaviorUnspecified', and 'bypassResponsePolicy'
        :param pulumi.Input[str] dns_name: The DNS name (wildcard or exact) to apply this rule to. Must be unique within the Response Policy Rule.
        :param pulumi.Input[pulumi.InputType['ResponsePolicyRuleLocalDataArgs']] local_data: Answer this query directly with DNS data. These ResourceRecordSets override any other DNS behavior for the matched name;
               in particular they override private zones, the public internet, and GCP internal DNS. No SOA nor NS types are allowed.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] response_policy: Identifies the response policy addressed by this request.
        :param pulumi.Input[str] rule_name: An identifier for this rule. Must be unique with the ResponsePolicy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResponsePolicyRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Dns Response Policy Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_1 = gcp.compute.Network("network-1", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        network_2 = gcp.compute.Network("network-2", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        response_policy = gcp.dns.ResponsePolicy("response-policy",
            response_policy_name="example-response-policy",
            networks=[
                gcp.dns.ResponsePolicyNetworkArgs(
                    network_url=network_1.id,
                ),
                gcp.dns.ResponsePolicyNetworkArgs(
                    network_url=network_2.id,
                ),
            ],
            opts=pulumi.ResourceOptions(provider=google_beta))
        example_response_policy_rule = gcp.dns.ResponsePolicyRule("example-response-policy-rule",
            response_policy=response_policy.response_policy_name,
            rule_name="example-rule",
            dns_name="dns.example.com.",
            local_data=gcp.dns.ResponsePolicyRuleLocalDataArgs(
                local_datas=[gcp.dns.ResponsePolicyRuleLocalDataLocalDataArgs(
                    name="dns.example.com.",
                    type="A",
                    ttl=300,
                    rrdatas=["192.0.2.91"],
                )],
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        ResponsePolicyRule can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:dns/responsePolicyRule:ResponsePolicyRule default projects/{{project}}/responsePolicies/{{response_policy}}/rules/{{rule_name}}
        ```

        ```sh
         $ pulumi import gcp:dns/responsePolicyRule:ResponsePolicyRule default {{project}}/{{response_policy}}/{{rule_name}}
        ```

        ```sh
         $ pulumi import gcp:dns/responsePolicyRule:ResponsePolicyRule default {{response_policy}}/{{rule_name}}
        ```

        :param str resource_name: The name of the resource.
        :param ResponsePolicyRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResponsePolicyRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 behavior: Optional[pulumi.Input[str]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 local_data: Optional[pulumi.Input[pulumi.InputType['ResponsePolicyRuleLocalDataArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 response_policy: Optional[pulumi.Input[str]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResponsePolicyRuleArgs.__new__(ResponsePolicyRuleArgs)

            __props__.__dict__["behavior"] = behavior
            if dns_name is None and not opts.urn:
                raise TypeError("Missing required property 'dns_name'")
            __props__.__dict__["dns_name"] = dns_name
            __props__.__dict__["local_data"] = local_data
            __props__.__dict__["project"] = project
            if response_policy is None and not opts.urn:
                raise TypeError("Missing required property 'response_policy'")
            __props__.__dict__["response_policy"] = response_policy
            if rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_name'")
            __props__.__dict__["rule_name"] = rule_name
        super(ResponsePolicyRule, __self__).__init__(
            'gcp:dns/responsePolicyRule:ResponsePolicyRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            behavior: Optional[pulumi.Input[str]] = None,
            dns_name: Optional[pulumi.Input[str]] = None,
            local_data: Optional[pulumi.Input[pulumi.InputType['ResponsePolicyRuleLocalDataArgs']]] = None,
            project: Optional[pulumi.Input[str]] = None,
            response_policy: Optional[pulumi.Input[str]] = None,
            rule_name: Optional[pulumi.Input[str]] = None) -> 'ResponsePolicyRule':
        """
        Get an existing ResponsePolicyRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] behavior: Answer this query with a behavior rather than DNS data. Acceptable values are 'behaviorUnspecified', and 'bypassResponsePolicy'
        :param pulumi.Input[str] dns_name: The DNS name (wildcard or exact) to apply this rule to. Must be unique within the Response Policy Rule.
        :param pulumi.Input[pulumi.InputType['ResponsePolicyRuleLocalDataArgs']] local_data: Answer this query directly with DNS data. These ResourceRecordSets override any other DNS behavior for the matched name;
               in particular they override private zones, the public internet, and GCP internal DNS. No SOA nor NS types are allowed.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] response_policy: Identifies the response policy addressed by this request.
        :param pulumi.Input[str] rule_name: An identifier for this rule. Must be unique with the ResponsePolicy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResponsePolicyRuleState.__new__(_ResponsePolicyRuleState)

        __props__.__dict__["behavior"] = behavior
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["local_data"] = local_data
        __props__.__dict__["project"] = project
        __props__.__dict__["response_policy"] = response_policy
        __props__.__dict__["rule_name"] = rule_name
        return ResponsePolicyRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def behavior(self) -> pulumi.Output[Optional[str]]:
        """
        Answer this query with a behavior rather than DNS data. Acceptable values are 'behaviorUnspecified', and 'bypassResponsePolicy'
        """
        return pulumi.get(self, "behavior")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[str]:
        """
        The DNS name (wildcard or exact) to apply this rule to. Must be unique within the Response Policy Rule.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="localData")
    def local_data(self) -> pulumi.Output[Optional['outputs.ResponsePolicyRuleLocalData']]:
        """
        Answer this query directly with DNS data. These ResourceRecordSets override any other DNS behavior for the matched name;
        in particular they override private zones, the public internet, and GCP internal DNS. No SOA nor NS types are allowed.
        Structure is documented below.
        """
        return pulumi.get(self, "local_data")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="responsePolicy")
    def response_policy(self) -> pulumi.Output[str]:
        """
        Identifies the response policy addressed by this request.
        """
        return pulumi.get(self, "response_policy")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[str]:
        """
        An identifier for this rule. Must be unique with the ResponsePolicy.
        """
        return pulumi.get(self, "rule_name")

