# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AndroidAppArgs', 'AndroidApp']

@pulumi.input_type
class AndroidAppArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 package_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AndroidApp resource.
        :param pulumi.Input[str] display_name: The user-assigned display name of the App.
        :param pulumi.Input[str] deletion_policy: (Optional) Set to 'ABANDON' to allow the AndroidApp to be untracked from terraform state rather than deleted upon
               'terraform destroy'. This is useful because the AndroidApp may be serving traffic. Set to 'DELETE' to delete the
               AndroidApp. Default to 'DELETE'.
        :param pulumi.Input[str] package_name: Immutable. The canonical package name of the Android app as would appear in the Google Play
               Developer Console.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "display_name", display_name)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if package_name is not None:
            pulumi.set(__self__, "package_name", package_name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The user-assigned display name of the App.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) Set to 'ABANDON' to allow the AndroidApp to be untracked from terraform state rather than deleted upon
        'terraform destroy'. This is useful because the AndroidApp may be serving traffic. Set to 'DELETE' to delete the
        AndroidApp. Default to 'DELETE'.
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter(name="packageName")
    def package_name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The canonical package name of the Android app as would appear in the Google Play
        Developer Console.
        """
        return pulumi.get(self, "package_name")

    @package_name.setter
    def package_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _AndroidAppState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[str]] = None,
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 package_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AndroidApp resources.
        :param pulumi.Input[str] app_id: The globally unique, Firebase-assigned identifier of the App. This identifier should be treated as an opaque token, as
               the data format is not specified.
        :param pulumi.Input[str] deletion_policy: (Optional) Set to 'ABANDON' to allow the AndroidApp to be untracked from terraform state rather than deleted upon
               'terraform destroy'. This is useful because the AndroidApp may be serving traffic. Set to 'DELETE' to delete the
               AndroidApp. Default to 'DELETE'.
        :param pulumi.Input[str] display_name: The user-assigned display name of the App.
        :param pulumi.Input[str] name: The fully qualified resource name of the App, for example: projects/projectId/androidApps/appId
        :param pulumi.Input[str] package_name: Immutable. The canonical package name of the Android app as would appear in the Google Play
               Developer Console.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if package_name is not None:
            pulumi.set(__self__, "package_name", package_name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The globally unique, Firebase-assigned identifier of the App. This identifier should be treated as an opaque token, as
        the data format is not specified.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) Set to 'ABANDON' to allow the AndroidApp to be untracked from terraform state rather than deleted upon
        'terraform destroy'. This is useful because the AndroidApp may be serving traffic. Set to 'DELETE' to delete the
        AndroidApp. Default to 'DELETE'.
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-assigned display name of the App.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified resource name of the App, for example: projects/projectId/androidApps/appId
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="packageName")
    def package_name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The canonical package name of the Android app as would appear in the Google Play
        Developer Console.
        """
        return pulumi.get(self, "package_name")

    @package_name.setter
    def package_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class AndroidApp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 package_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Firebase Android App Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.firebase.AndroidApp("basic",
            project="my-project-name",
            display_name="Display Name Basic",
            package_name="",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        AndroidApp can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:firebase/androidApp:AndroidApp default projects/{{project}}/androidApps/{{appId}}
        ```

        ```sh
         $ pulumi import gcp:firebase/androidApp:AndroidApp default {{project}}/{{appId}}
        ```

        ```sh
         $ pulumi import gcp:firebase/androidApp:AndroidApp default androidApps/{{appId}}
        ```

        ```sh
         $ pulumi import gcp:firebase/androidApp:AndroidApp default {{appId}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] deletion_policy: (Optional) Set to 'ABANDON' to allow the AndroidApp to be untracked from terraform state rather than deleted upon
               'terraform destroy'. This is useful because the AndroidApp may be serving traffic. Set to 'DELETE' to delete the
               AndroidApp. Default to 'DELETE'.
        :param pulumi.Input[str] display_name: The user-assigned display name of the App.
        :param pulumi.Input[str] package_name: Immutable. The canonical package name of the Android app as would appear in the Google Play
               Developer Console.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AndroidAppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Firebase Android App Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.firebase.AndroidApp("basic",
            project="my-project-name",
            display_name="Display Name Basic",
            package_name="",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        AndroidApp can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:firebase/androidApp:AndroidApp default projects/{{project}}/androidApps/{{appId}}
        ```

        ```sh
         $ pulumi import gcp:firebase/androidApp:AndroidApp default {{project}}/{{appId}}
        ```

        ```sh
         $ pulumi import gcp:firebase/androidApp:AndroidApp default androidApps/{{appId}}
        ```

        ```sh
         $ pulumi import gcp:firebase/androidApp:AndroidApp default {{appId}}
        ```

        :param str resource_name: The name of the resource.
        :param AndroidAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AndroidAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 package_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AndroidAppArgs.__new__(AndroidAppArgs)

            __props__.__dict__["deletion_policy"] = deletion_policy
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["package_name"] = package_name
            __props__.__dict__["project"] = project
            __props__.__dict__["app_id"] = None
            __props__.__dict__["name"] = None
        super(AndroidApp, __self__).__init__(
            'gcp:firebase/androidApp:AndroidApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[str]] = None,
            deletion_policy: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            package_name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None) -> 'AndroidApp':
        """
        Get an existing AndroidApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: The globally unique, Firebase-assigned identifier of the App. This identifier should be treated as an opaque token, as
               the data format is not specified.
        :param pulumi.Input[str] deletion_policy: (Optional) Set to 'ABANDON' to allow the AndroidApp to be untracked from terraform state rather than deleted upon
               'terraform destroy'. This is useful because the AndroidApp may be serving traffic. Set to 'DELETE' to delete the
               AndroidApp. Default to 'DELETE'.
        :param pulumi.Input[str] display_name: The user-assigned display name of the App.
        :param pulumi.Input[str] name: The fully qualified resource name of the App, for example: projects/projectId/androidApps/appId
        :param pulumi.Input[str] package_name: Immutable. The canonical package name of the Android app as would appear in the Google Play
               Developer Console.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AndroidAppState.__new__(_AndroidAppState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["deletion_policy"] = deletion_policy
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["name"] = name
        __props__.__dict__["package_name"] = package_name
        __props__.__dict__["project"] = project
        return AndroidApp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[str]:
        """
        The globally unique, Firebase-assigned identifier of the App. This identifier should be treated as an opaque token, as
        the data format is not specified.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> pulumi.Output[Optional[str]]:
        """
        (Optional) Set to 'ABANDON' to allow the AndroidApp to be untracked from terraform state rather than deleted upon
        'terraform destroy'. This is useful because the AndroidApp may be serving traffic. Set to 'DELETE' to delete the
        AndroidApp. Default to 'DELETE'.
        """
        return pulumi.get(self, "deletion_policy")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The user-assigned display name of the App.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The fully qualified resource name of the App, for example: projects/projectId/androidApps/appId
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="packageName")
    def package_name(self) -> pulumi.Output[Optional[str]]:
        """
        Immutable. The canonical package name of the Android app as would appear in the Google Play
        Developer Console.
        """
        return pulumi.get(self, "package_name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

