# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AppleAppArgs', 'AppleApp']

@pulumi.input_type
class AppleAppArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 app_store_id: Optional[pulumi.Input[str]] = None,
                 bundle_id: Optional[pulumi.Input[str]] = None,
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AppleApp resource.
        :param pulumi.Input[str] display_name: The user-assigned display name of the App.
        :param pulumi.Input[str] app_store_id: The automatically generated Apple ID assigned to the Apple app by Apple in the Apple App Store.
        :param pulumi.Input[str] bundle_id: The canonical bundle ID of the Apple app as it would appear in the Apple AppStore.
        :param pulumi.Input[str] deletion_policy: (Optional) Set to 'ABANDON' to allow the AppleApp to be untracked from terraform state rather than deleted upon
               'terraform destroy'. This is useful because the AppleApp may be serving traffic. Set to 'DELETE' to delete the AppleApp.
               Default to 'DELETE'.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] team_id: The Apple Developer Team ID associated with the App in the App Store.
        """
        pulumi.set(__self__, "display_name", display_name)
        if app_store_id is not None:
            pulumi.set(__self__, "app_store_id", app_store_id)
        if bundle_id is not None:
            pulumi.set(__self__, "bundle_id", bundle_id)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The user-assigned display name of the App.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="appStoreId")
    def app_store_id(self) -> Optional[pulumi.Input[str]]:
        """
        The automatically generated Apple ID assigned to the Apple app by Apple in the Apple App Store.
        """
        return pulumi.get(self, "app_store_id")

    @app_store_id.setter
    def app_store_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_store_id", value)

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> Optional[pulumi.Input[str]]:
        """
        The canonical bundle ID of the Apple app as it would appear in the Apple AppStore.
        """
        return pulumi.get(self, "bundle_id")

    @bundle_id.setter
    def bundle_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bundle_id", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) Set to 'ABANDON' to allow the AppleApp to be untracked from terraform state rather than deleted upon
        'terraform destroy'. This is useful because the AppleApp may be serving traffic. Set to 'DELETE' to delete the AppleApp.
        Default to 'DELETE'.
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Apple Developer Team ID associated with the App in the App Store.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


@pulumi.input_type
class _AppleAppState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[str]] = None,
                 app_store_id: Optional[pulumi.Input[str]] = None,
                 bundle_id: Optional[pulumi.Input[str]] = None,
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AppleApp resources.
        :param pulumi.Input[str] app_id: The globally unique, Firebase-assigned identifier of the App. This identifier should be treated as an opaque token, as
               the data format is not specified.
        :param pulumi.Input[str] app_store_id: The automatically generated Apple ID assigned to the Apple app by Apple in the Apple App Store.
        :param pulumi.Input[str] bundle_id: The canonical bundle ID of the Apple app as it would appear in the Apple AppStore.
        :param pulumi.Input[str] deletion_policy: (Optional) Set to 'ABANDON' to allow the AppleApp to be untracked from terraform state rather than deleted upon
               'terraform destroy'. This is useful because the AppleApp may be serving traffic. Set to 'DELETE' to delete the AppleApp.
               Default to 'DELETE'.
        :param pulumi.Input[str] display_name: The user-assigned display name of the App.
        :param pulumi.Input[str] name: The fully qualified resource name of the App, for example: projects/projectId/iosApps/appId
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] team_id: The Apple Developer Team ID associated with the App in the App Store.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_store_id is not None:
            pulumi.set(__self__, "app_store_id", app_store_id)
        if bundle_id is not None:
            pulumi.set(__self__, "bundle_id", bundle_id)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The globally unique, Firebase-assigned identifier of the App. This identifier should be treated as an opaque token, as
        the data format is not specified.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="appStoreId")
    def app_store_id(self) -> Optional[pulumi.Input[str]]:
        """
        The automatically generated Apple ID assigned to the Apple app by Apple in the Apple App Store.
        """
        return pulumi.get(self, "app_store_id")

    @app_store_id.setter
    def app_store_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_store_id", value)

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> Optional[pulumi.Input[str]]:
        """
        The canonical bundle ID of the Apple app as it would appear in the Apple AppStore.
        """
        return pulumi.get(self, "bundle_id")

    @bundle_id.setter
    def bundle_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bundle_id", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[str]]:
        """
        (Optional) Set to 'ABANDON' to allow the AppleApp to be untracked from terraform state rather than deleted upon
        'terraform destroy'. This is useful because the AppleApp may be serving traffic. Set to 'DELETE' to delete the AppleApp.
        Default to 'DELETE'.
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-assigned display name of the App.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified resource name of the App, for example: projects/projectId/iosApps/appId
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Apple Developer Team ID associated with the App in the App Store.
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team_id", value)


class AppleApp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_store_id: Optional[pulumi.Input[str]] = None,
                 bundle_id: Optional[pulumi.Input[str]] = None,
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Firebase Apple App Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.AppleApp("default",
            project="my-project-name",
            display_name="Display Name Basic",
            bundle_id="apple.app.12345",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Firebase Apple App Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        full = gcp.firebase.AppleApp("full",
            project="my-project-name",
            display_name="Display Name Full",
            bundle_id="apple.app.12345",
            app_store_id="12345",
            team_id="9987654321",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        AppleApp can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:firebase/appleApp:AppleApp default projects/{{project}}/iosApps/{{appId}}
        ```

        ```sh
         $ pulumi import gcp:firebase/appleApp:AppleApp default {{project}}/{{appId}}
        ```

        ```sh
         $ pulumi import gcp:firebase/appleApp:AppleApp default iosApps/{{appId}}
        ```

        ```sh
         $ pulumi import gcp:firebase/appleApp:AppleApp default {{appId}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_store_id: The automatically generated Apple ID assigned to the Apple app by Apple in the Apple App Store.
        :param pulumi.Input[str] bundle_id: The canonical bundle ID of the Apple app as it would appear in the Apple AppStore.
        :param pulumi.Input[str] deletion_policy: (Optional) Set to 'ABANDON' to allow the AppleApp to be untracked from terraform state rather than deleted upon
               'terraform destroy'. This is useful because the AppleApp may be serving traffic. Set to 'DELETE' to delete the AppleApp.
               Default to 'DELETE'.
        :param pulumi.Input[str] display_name: The user-assigned display name of the App.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] team_id: The Apple Developer Team ID associated with the App in the App Store.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppleAppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Firebase Apple App Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.AppleApp("default",
            project="my-project-name",
            display_name="Display Name Basic",
            bundle_id="apple.app.12345",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Firebase Apple App Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        full = gcp.firebase.AppleApp("full",
            project="my-project-name",
            display_name="Display Name Full",
            bundle_id="apple.app.12345",
            app_store_id="12345",
            team_id="9987654321",
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        AppleApp can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:firebase/appleApp:AppleApp default projects/{{project}}/iosApps/{{appId}}
        ```

        ```sh
         $ pulumi import gcp:firebase/appleApp:AppleApp default {{project}}/{{appId}}
        ```

        ```sh
         $ pulumi import gcp:firebase/appleApp:AppleApp default iosApps/{{appId}}
        ```

        ```sh
         $ pulumi import gcp:firebase/appleApp:AppleApp default {{appId}}
        ```

        :param str resource_name: The name of the resource.
        :param AppleAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppleAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_store_id: Optional[pulumi.Input[str]] = None,
                 bundle_id: Optional[pulumi.Input[str]] = None,
                 deletion_policy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 team_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppleAppArgs.__new__(AppleAppArgs)

            __props__.__dict__["app_store_id"] = app_store_id
            __props__.__dict__["bundle_id"] = bundle_id
            __props__.__dict__["deletion_policy"] = deletion_policy
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["project"] = project
            __props__.__dict__["team_id"] = team_id
            __props__.__dict__["app_id"] = None
            __props__.__dict__["name"] = None
        super(AppleApp, __self__).__init__(
            'gcp:firebase/appleApp:AppleApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[str]] = None,
            app_store_id: Optional[pulumi.Input[str]] = None,
            bundle_id: Optional[pulumi.Input[str]] = None,
            deletion_policy: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            team_id: Optional[pulumi.Input[str]] = None) -> 'AppleApp':
        """
        Get an existing AppleApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: The globally unique, Firebase-assigned identifier of the App. This identifier should be treated as an opaque token, as
               the data format is not specified.
        :param pulumi.Input[str] app_store_id: The automatically generated Apple ID assigned to the Apple app by Apple in the Apple App Store.
        :param pulumi.Input[str] bundle_id: The canonical bundle ID of the Apple app as it would appear in the Apple AppStore.
        :param pulumi.Input[str] deletion_policy: (Optional) Set to 'ABANDON' to allow the AppleApp to be untracked from terraform state rather than deleted upon
               'terraform destroy'. This is useful because the AppleApp may be serving traffic. Set to 'DELETE' to delete the AppleApp.
               Default to 'DELETE'.
        :param pulumi.Input[str] display_name: The user-assigned display name of the App.
        :param pulumi.Input[str] name: The fully qualified resource name of the App, for example: projects/projectId/iosApps/appId
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] team_id: The Apple Developer Team ID associated with the App in the App Store.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppleAppState.__new__(_AppleAppState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["app_store_id"] = app_store_id
        __props__.__dict__["bundle_id"] = bundle_id
        __props__.__dict__["deletion_policy"] = deletion_policy
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["team_id"] = team_id
        return AppleApp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[str]:
        """
        The globally unique, Firebase-assigned identifier of the App. This identifier should be treated as an opaque token, as
        the data format is not specified.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="appStoreId")
    def app_store_id(self) -> pulumi.Output[Optional[str]]:
        """
        The automatically generated Apple ID assigned to the Apple app by Apple in the Apple App Store.
        """
        return pulumi.get(self, "app_store_id")

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> pulumi.Output[Optional[str]]:
        """
        The canonical bundle ID of the Apple app as it would appear in the Apple AppStore.
        """
        return pulumi.get(self, "bundle_id")

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> pulumi.Output[Optional[str]]:
        """
        (Optional) Set to 'ABANDON' to allow the AppleApp to be untracked from terraform state rather than deleted upon
        'terraform destroy'. This is useful because the AppleApp may be serving traffic. Set to 'DELETE' to delete the AppleApp.
        Default to 'DELETE'.
        """
        return pulumi.get(self, "deletion_policy")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The user-assigned display name of the App.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The fully qualified resource name of the App, for example: projects/projectId/iosApps/appId
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Apple Developer Team ID associated with the App in the App Store.
        """
        return pulumi.get(self, "team_id")

