# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'BackupPlanBackupConfigArgs',
    'BackupPlanBackupConfigEncryptionKeyArgs',
    'BackupPlanBackupConfigSelectedApplicationsArgs',
    'BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgs',
    'BackupPlanBackupConfigSelectedNamespacesArgs',
    'BackupPlanBackupScheduleArgs',
    'BackupPlanRetentionPolicyArgs',
]

@pulumi.input_type
class BackupPlanBackupConfigArgs:
    def __init__(__self__, *,
                 all_namespaces: Optional[pulumi.Input[bool]] = None,
                 encryption_key: Optional[pulumi.Input['BackupPlanBackupConfigEncryptionKeyArgs']] = None,
                 include_secrets: Optional[pulumi.Input[bool]] = None,
                 include_volume_data: Optional[pulumi.Input[bool]] = None,
                 selected_applications: Optional[pulumi.Input['BackupPlanBackupConfigSelectedApplicationsArgs']] = None,
                 selected_namespaces: Optional[pulumi.Input['BackupPlanBackupConfigSelectedNamespacesArgs']] = None):
        """
        :param pulumi.Input[bool] all_namespaces: If True, include all namespaced resources.
        :param pulumi.Input['BackupPlanBackupConfigEncryptionKeyArgs'] encryption_key: This defines a customer managed encryption key that will be used to encrypt the "config"
               portion (the Kubernetes resources) of Backups created via this plan.
               Structure is documented below.
        :param pulumi.Input[bool] include_secrets: This flag specifies whether Kubernetes Secret resources should be included
               when they fall into the scope of Backups.
        :param pulumi.Input[bool] include_volume_data: This flag specifies whether volume data should be backed up when PVCs are
               included in the scope of a Backup.
        :param pulumi.Input['BackupPlanBackupConfigSelectedApplicationsArgs'] selected_applications: A list of namespaced Kubernetes Resources.
               Structure is documented below.
        :param pulumi.Input['BackupPlanBackupConfigSelectedNamespacesArgs'] selected_namespaces: If set, include just the resources in the listed namespaces.
               Structure is documented below.
        """
        if all_namespaces is not None:
            pulumi.set(__self__, "all_namespaces", all_namespaces)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if include_secrets is not None:
            pulumi.set(__self__, "include_secrets", include_secrets)
        if include_volume_data is not None:
            pulumi.set(__self__, "include_volume_data", include_volume_data)
        if selected_applications is not None:
            pulumi.set(__self__, "selected_applications", selected_applications)
        if selected_namespaces is not None:
            pulumi.set(__self__, "selected_namespaces", selected_namespaces)

    @property
    @pulumi.getter(name="allNamespaces")
    def all_namespaces(self) -> Optional[pulumi.Input[bool]]:
        """
        If True, include all namespaced resources.
        """
        return pulumi.get(self, "all_namespaces")

    @all_namespaces.setter
    def all_namespaces(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_namespaces", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input['BackupPlanBackupConfigEncryptionKeyArgs']]:
        """
        This defines a customer managed encryption key that will be used to encrypt the "config"
        portion (the Kubernetes resources) of Backups created via this plan.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input['BackupPlanBackupConfigEncryptionKeyArgs']]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="includeSecrets")
    def include_secrets(self) -> Optional[pulumi.Input[bool]]:
        """
        This flag specifies whether Kubernetes Secret resources should be included
        when they fall into the scope of Backups.
        """
        return pulumi.get(self, "include_secrets")

    @include_secrets.setter
    def include_secrets(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_secrets", value)

    @property
    @pulumi.getter(name="includeVolumeData")
    def include_volume_data(self) -> Optional[pulumi.Input[bool]]:
        """
        This flag specifies whether volume data should be backed up when PVCs are
        included in the scope of a Backup.
        """
        return pulumi.get(self, "include_volume_data")

    @include_volume_data.setter
    def include_volume_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_volume_data", value)

    @property
    @pulumi.getter(name="selectedApplications")
    def selected_applications(self) -> Optional[pulumi.Input['BackupPlanBackupConfigSelectedApplicationsArgs']]:
        """
        A list of namespaced Kubernetes Resources.
        Structure is documented below.
        """
        return pulumi.get(self, "selected_applications")

    @selected_applications.setter
    def selected_applications(self, value: Optional[pulumi.Input['BackupPlanBackupConfigSelectedApplicationsArgs']]):
        pulumi.set(self, "selected_applications", value)

    @property
    @pulumi.getter(name="selectedNamespaces")
    def selected_namespaces(self) -> Optional[pulumi.Input['BackupPlanBackupConfigSelectedNamespacesArgs']]:
        """
        If set, include just the resources in the listed namespaces.
        Structure is documented below.
        """
        return pulumi.get(self, "selected_namespaces")

    @selected_namespaces.setter
    def selected_namespaces(self, value: Optional[pulumi.Input['BackupPlanBackupConfigSelectedNamespacesArgs']]):
        pulumi.set(self, "selected_namespaces", value)


@pulumi.input_type
class BackupPlanBackupConfigEncryptionKeyArgs:
    def __init__(__self__, *,
                 gcp_kms_encryption_key: pulumi.Input[str]):
        """
        :param pulumi.Input[str] gcp_kms_encryption_key: Google Cloud KMS encryption key. Format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        """
        pulumi.set(__self__, "gcp_kms_encryption_key", gcp_kms_encryption_key)

    @property
    @pulumi.getter(name="gcpKmsEncryptionKey")
    def gcp_kms_encryption_key(self) -> pulumi.Input[str]:
        """
        Google Cloud KMS encryption key. Format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        """
        return pulumi.get(self, "gcp_kms_encryption_key")

    @gcp_kms_encryption_key.setter
    def gcp_kms_encryption_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "gcp_kms_encryption_key", value)


@pulumi.input_type
class BackupPlanBackupConfigSelectedApplicationsArgs:
    def __init__(__self__, *,
                 namespaced_names: pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgs']]] namespaced_names: A list of namespaced Kubernetes resources.
               Structure is documented below.
        """
        pulumi.set(__self__, "namespaced_names", namespaced_names)

    @property
    @pulumi.getter(name="namespacedNames")
    def namespaced_names(self) -> pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgs']]]:
        """
        A list of namespaced Kubernetes resources.
        Structure is documented below.
        """
        return pulumi.get(self, "namespaced_names")

    @namespaced_names.setter
    def namespaced_names(self, value: pulumi.Input[Sequence[pulumi.Input['BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgs']]]):
        pulumi.set(self, "namespaced_names", value)


@pulumi.input_type
class BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 namespace: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The name of a Kubernetes Resource.
        :param pulumi.Input[str] namespace: The namespace of a Kubernetes Resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of a Kubernetes Resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The namespace of a Kubernetes Resource.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class BackupPlanBackupConfigSelectedNamespacesArgs:
    def __init__(__self__, *,
                 namespaces: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] namespaces: A list of Kubernetes Namespaces.
        """
        pulumi.set(__self__, "namespaces", namespaces)

    @property
    @pulumi.getter
    def namespaces(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of Kubernetes Namespaces.
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "namespaces", value)


@pulumi.input_type
class BackupPlanBackupScheduleArgs:
    def __init__(__self__, *,
                 cron_schedule: Optional[pulumi.Input[str]] = None,
                 paused: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] cron_schedule: A standard cron string that defines a repeating schedule for
               creating Backups via this BackupPlan.
               If this is defined, then backupRetainDays must also be defined.
        :param pulumi.Input[bool] paused: This flag denotes whether automatic Backup creation is paused for this BackupPlan.
        """
        if cron_schedule is not None:
            pulumi.set(__self__, "cron_schedule", cron_schedule)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)

    @property
    @pulumi.getter(name="cronSchedule")
    def cron_schedule(self) -> Optional[pulumi.Input[str]]:
        """
        A standard cron string that defines a repeating schedule for
        creating Backups via this BackupPlan.
        If this is defined, then backupRetainDays must also be defined.
        """
        return pulumi.get(self, "cron_schedule")

    @cron_schedule.setter
    def cron_schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cron_schedule", value)

    @property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[bool]]:
        """
        This flag denotes whether automatic Backup creation is paused for this BackupPlan.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "paused", value)


@pulumi.input_type
class BackupPlanRetentionPolicyArgs:
    def __init__(__self__, *,
                 backup_delete_lock_days: Optional[pulumi.Input[int]] = None,
                 backup_retain_days: Optional[pulumi.Input[int]] = None,
                 locked: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[int] backup_delete_lock_days: Minimum age for a Backup created via this BackupPlan (in days).
               Must be an integer value between 0-90 (inclusive).
               A Backup created under this BackupPlan will not be deletable
               until it reaches Backup's (create time + backup_delete_lock_days).
               Updating this field of a BackupPlan does not affect existing Backups.
               Backups created after a successful update will inherit this new value.
        :param pulumi.Input[int] backup_retain_days: The default maximum age of a Backup created via this BackupPlan.
               This field MUST be an integer value >= 0 and <= 365. If specified,
               a Backup created under this BackupPlan will be automatically deleted
               after its age reaches (createTime + backupRetainDays).
               If not specified, Backups created under this BackupPlan will NOT be
               subject to automatic deletion. Updating this field does NOT affect
               existing Backups under it. Backups created AFTER a successful update
               will automatically pick up the new value.
               NOTE: backupRetainDays must be >= backupDeleteLockDays.
               If cronSchedule is defined, then this must be <= 360 * the creation interval.]
        :param pulumi.Input[bool] locked: This flag denotes whether the retention policy of this BackupPlan is locked.
               If set to True, no further update is allowed on this policy, including
               the locked field itself.
        """
        if backup_delete_lock_days is not None:
            pulumi.set(__self__, "backup_delete_lock_days", backup_delete_lock_days)
        if backup_retain_days is not None:
            pulumi.set(__self__, "backup_retain_days", backup_retain_days)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)

    @property
    @pulumi.getter(name="backupDeleteLockDays")
    def backup_delete_lock_days(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum age for a Backup created via this BackupPlan (in days).
        Must be an integer value between 0-90 (inclusive).
        A Backup created under this BackupPlan will not be deletable
        until it reaches Backup's (create time + backup_delete_lock_days).
        Updating this field of a BackupPlan does not affect existing Backups.
        Backups created after a successful update will inherit this new value.
        """
        return pulumi.get(self, "backup_delete_lock_days")

    @backup_delete_lock_days.setter
    def backup_delete_lock_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_delete_lock_days", value)

    @property
    @pulumi.getter(name="backupRetainDays")
    def backup_retain_days(self) -> Optional[pulumi.Input[int]]:
        """
        The default maximum age of a Backup created via this BackupPlan.
        This field MUST be an integer value >= 0 and <= 365. If specified,
        a Backup created under this BackupPlan will be automatically deleted
        after its age reaches (createTime + backupRetainDays).
        If not specified, Backups created under this BackupPlan will NOT be
        subject to automatic deletion. Updating this field does NOT affect
        existing Backups under it. Backups created AFTER a successful update
        will automatically pick up the new value.
        NOTE: backupRetainDays must be >= backupDeleteLockDays.
        If cronSchedule is defined, then this must be <= 360 * the creation interval.]
        """
        return pulumi.get(self, "backup_retain_days")

    @backup_retain_days.setter
    def backup_retain_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_retain_days", value)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[bool]]:
        """
        This flag denotes whether the retention policy of this BackupPlan is locked.
        If set to True, no further update is allowed on this policy, including
        the locked field itself.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "locked", value)


