# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpokeArgs', 'Spoke']

@pulumi.input_type
class SpokeArgs:
    def __init__(__self__, *,
                 hub: pulumi.Input[str],
                 location: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linked_interconnect_attachments: Optional[pulumi.Input['SpokeLinkedInterconnectAttachmentsArgs']] = None,
                 linked_router_appliance_instances: Optional[pulumi.Input['SpokeLinkedRouterApplianceInstancesArgs']] = None,
                 linked_vpn_tunnels: Optional[pulumi.Input['SpokeLinkedVpnTunnelsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Spoke resource.
        :param pulumi.Input[str] hub: Immutable. The URI of the hub that this spoke is attached to.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] description: An optional description of the spoke.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        :param pulumi.Input['SpokeLinkedInterconnectAttachmentsArgs'] linked_interconnect_attachments: A collection of VLAN attachment resources. These resources should be redundant attachments that all advertise the same prefixes to Google Cloud. Alternatively, in active/passive configurations, all attachments should be capable of advertising the same prefixes.
        :param pulumi.Input['SpokeLinkedRouterApplianceInstancesArgs'] linked_router_appliance_instances: The URIs of linked Router appliance resources
        :param pulumi.Input['SpokeLinkedVpnTunnelsArgs'] linked_vpn_tunnels: The URIs of linked VPN tunnel resources
        :param pulumi.Input[str] name: Immutable. The name of the spoke. Spoke names must be unique.
        :param pulumi.Input[str] project: The project for the resource
        """
        pulumi.set(__self__, "hub", hub)
        pulumi.set(__self__, "location", location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linked_interconnect_attachments is not None:
            pulumi.set(__self__, "linked_interconnect_attachments", linked_interconnect_attachments)
        if linked_router_appliance_instances is not None:
            pulumi.set(__self__, "linked_router_appliance_instances", linked_router_appliance_instances)
        if linked_vpn_tunnels is not None:
            pulumi.set(__self__, "linked_vpn_tunnels", linked_vpn_tunnels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def hub(self) -> pulumi.Input[str]:
        """
        Immutable. The URI of the hub that this spoke is attached to.
        """
        return pulumi.get(self, "hub")

    @hub.setter
    def hub(self, value: pulumi.Input[str]):
        pulumi.set(self, "hub", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of the spoke.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="linkedInterconnectAttachments")
    def linked_interconnect_attachments(self) -> Optional[pulumi.Input['SpokeLinkedInterconnectAttachmentsArgs']]:
        """
        A collection of VLAN attachment resources. These resources should be redundant attachments that all advertise the same prefixes to Google Cloud. Alternatively, in active/passive configurations, all attachments should be capable of advertising the same prefixes.
        """
        return pulumi.get(self, "linked_interconnect_attachments")

    @linked_interconnect_attachments.setter
    def linked_interconnect_attachments(self, value: Optional[pulumi.Input['SpokeLinkedInterconnectAttachmentsArgs']]):
        pulumi.set(self, "linked_interconnect_attachments", value)

    @property
    @pulumi.getter(name="linkedRouterApplianceInstances")
    def linked_router_appliance_instances(self) -> Optional[pulumi.Input['SpokeLinkedRouterApplianceInstancesArgs']]:
        """
        The URIs of linked Router appliance resources
        """
        return pulumi.get(self, "linked_router_appliance_instances")

    @linked_router_appliance_instances.setter
    def linked_router_appliance_instances(self, value: Optional[pulumi.Input['SpokeLinkedRouterApplianceInstancesArgs']]):
        pulumi.set(self, "linked_router_appliance_instances", value)

    @property
    @pulumi.getter(name="linkedVpnTunnels")
    def linked_vpn_tunnels(self) -> Optional[pulumi.Input['SpokeLinkedVpnTunnelsArgs']]:
        """
        The URIs of linked VPN tunnel resources
        """
        return pulumi.get(self, "linked_vpn_tunnels")

    @linked_vpn_tunnels.setter
    def linked_vpn_tunnels(self, value: Optional[pulumi.Input['SpokeLinkedVpnTunnelsArgs']]):
        pulumi.set(self, "linked_vpn_tunnels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The name of the spoke. Spoke names must be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _SpokeState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hub: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linked_interconnect_attachments: Optional[pulumi.Input['SpokeLinkedInterconnectAttachmentsArgs']] = None,
                 linked_router_appliance_instances: Optional[pulumi.Input['SpokeLinkedRouterApplianceInstancesArgs']] = None,
                 linked_vpn_tunnels: Optional[pulumi.Input['SpokeLinkedVpnTunnelsArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 unique_id: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Spoke resources.
        :param pulumi.Input[str] create_time: Output only. The time the spoke was created.
        :param pulumi.Input[str] description: An optional description of the spoke.
        :param pulumi.Input[str] hub: Immutable. The URI of the hub that this spoke is attached to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        :param pulumi.Input['SpokeLinkedInterconnectAttachmentsArgs'] linked_interconnect_attachments: A collection of VLAN attachment resources. These resources should be redundant attachments that all advertise the same prefixes to Google Cloud. Alternatively, in active/passive configurations, all attachments should be capable of advertising the same prefixes.
        :param pulumi.Input['SpokeLinkedRouterApplianceInstancesArgs'] linked_router_appliance_instances: The URIs of linked Router appliance resources
        :param pulumi.Input['SpokeLinkedVpnTunnelsArgs'] linked_vpn_tunnels: The URIs of linked VPN tunnel resources
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Immutable. The name of the spoke. Spoke names must be unique.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[str] state: Output only. The current lifecycle state of this spoke. Possible values: STATE_UNSPECIFIED, CREATING, ACTIVE, DELETING
        :param pulumi.Input[str] unique_id: Output only. The Google-generated UUID for the spoke. This value is unique across all spoke resources. If a spoke is
               deleted and another with the same name is created, the new spoke is assigned a different unique_id.
        :param pulumi.Input[str] update_time: Output only. The time the spoke was last updated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hub is not None:
            pulumi.set(__self__, "hub", hub)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linked_interconnect_attachments is not None:
            pulumi.set(__self__, "linked_interconnect_attachments", linked_interconnect_attachments)
        if linked_router_appliance_instances is not None:
            pulumi.set(__self__, "linked_router_appliance_instances", linked_router_appliance_instances)
        if linked_vpn_tunnels is not None:
            pulumi.set(__self__, "linked_vpn_tunnels", linked_vpn_tunnels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if unique_id is not None:
            pulumi.set(__self__, "unique_id", unique_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The time the spoke was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of the spoke.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def hub(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The URI of the hub that this spoke is attached to.
        """
        return pulumi.get(self, "hub")

    @hub.setter
    def hub(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hub", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="linkedInterconnectAttachments")
    def linked_interconnect_attachments(self) -> Optional[pulumi.Input['SpokeLinkedInterconnectAttachmentsArgs']]:
        """
        A collection of VLAN attachment resources. These resources should be redundant attachments that all advertise the same prefixes to Google Cloud. Alternatively, in active/passive configurations, all attachments should be capable of advertising the same prefixes.
        """
        return pulumi.get(self, "linked_interconnect_attachments")

    @linked_interconnect_attachments.setter
    def linked_interconnect_attachments(self, value: Optional[pulumi.Input['SpokeLinkedInterconnectAttachmentsArgs']]):
        pulumi.set(self, "linked_interconnect_attachments", value)

    @property
    @pulumi.getter(name="linkedRouterApplianceInstances")
    def linked_router_appliance_instances(self) -> Optional[pulumi.Input['SpokeLinkedRouterApplianceInstancesArgs']]:
        """
        The URIs of linked Router appliance resources
        """
        return pulumi.get(self, "linked_router_appliance_instances")

    @linked_router_appliance_instances.setter
    def linked_router_appliance_instances(self, value: Optional[pulumi.Input['SpokeLinkedRouterApplianceInstancesArgs']]):
        pulumi.set(self, "linked_router_appliance_instances", value)

    @property
    @pulumi.getter(name="linkedVpnTunnels")
    def linked_vpn_tunnels(self) -> Optional[pulumi.Input['SpokeLinkedVpnTunnelsArgs']]:
        """
        The URIs of linked VPN tunnel resources
        """
        return pulumi.get(self, "linked_vpn_tunnels")

    @linked_vpn_tunnels.setter
    def linked_vpn_tunnels(self, value: Optional[pulumi.Input['SpokeLinkedVpnTunnelsArgs']]):
        pulumi.set(self, "linked_vpn_tunnels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The name of the spoke. Spoke names must be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The current lifecycle state of this spoke. Possible values: STATE_UNSPECIFIED, CREATING, ACTIVE, DELETING
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="uniqueId")
    def unique_id(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The Google-generated UUID for the spoke. This value is unique across all spoke resources. If a spoke is
        deleted and another with the same name is created, the new spoke is assigned a different unique_id.
        """
        return pulumi.get(self, "unique_id")

    @unique_id.setter
    def unique_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unique_id", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The time the spoke was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class Spoke(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hub: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linked_interconnect_attachments: Optional[pulumi.Input[pulumi.InputType['SpokeLinkedInterconnectAttachmentsArgs']]] = None,
                 linked_router_appliance_instances: Optional[pulumi.Input[pulumi.InputType['SpokeLinkedRouterApplianceInstancesArgs']]] = None,
                 linked_vpn_tunnels: Optional[pulumi.Input[pulumi.InputType['SpokeLinkedVpnTunnelsArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The NetworkConnectivity Spoke resource

        ## Example Usage
        ### Router_appliance
        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network", auto_create_subnetworks=False)
        subnetwork = gcp.compute.Subnetwork("subnetwork",
            ip_cidr_range="10.0.0.0/28",
            region="us-west1",
            network=network.self_link)
        instance = gcp.compute.Instance("instance",
            machine_type="e2-medium",
            can_ip_forward=True,
            zone="us-west1-a",
            boot_disk=gcp.compute.InstanceBootDiskArgs(
                initialize_params=gcp.compute.InstanceBootDiskInitializeParamsArgs(
                    image="projects/debian-cloud/global/images/debian-10-buster-v20210817",
                ),
            ),
            network_interfaces=[gcp.compute.InstanceNetworkInterfaceArgs(
                subnetwork=subnetwork.name,
                network_ip="10.0.0.2",
                access_configs=[gcp.compute.InstanceNetworkInterfaceAccessConfigArgs(
                    network_tier="PREMIUM",
                )],
            )])
        basic_hub = gcp.networkconnectivity.Hub("basicHub",
            description="A sample hub",
            labels={
                "label-two": "value-one",
            })
        primary = gcp.networkconnectivity.Spoke("primary",
            location="us-west1",
            description="A sample spoke with a linked routher appliance instance",
            labels={
                "label-one": "value-one",
            },
            hub=basic_hub.id,
            linked_router_appliance_instances=gcp.networkconnectivity.SpokeLinkedRouterApplianceInstancesArgs(
                instances=[gcp.networkconnectivity.SpokeLinkedRouterApplianceInstancesInstanceArgs(
                    virtual_machine=instance.self_link,
                    ip_address="10.0.0.2",
                )],
                site_to_site_data_transfer=True,
            ))
        ```

        ## Import

        Spoke can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:networkconnectivity/spoke:Spoke default projects/{{project}}/locations/{{location}}/spokes/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkconnectivity/spoke:Spoke default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkconnectivity/spoke:Spoke default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description of the spoke.
        :param pulumi.Input[str] hub: Immutable. The URI of the hub that this spoke is attached to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        :param pulumi.Input[pulumi.InputType['SpokeLinkedInterconnectAttachmentsArgs']] linked_interconnect_attachments: A collection of VLAN attachment resources. These resources should be redundant attachments that all advertise the same prefixes to Google Cloud. Alternatively, in active/passive configurations, all attachments should be capable of advertising the same prefixes.
        :param pulumi.Input[pulumi.InputType['SpokeLinkedRouterApplianceInstancesArgs']] linked_router_appliance_instances: The URIs of linked Router appliance resources
        :param pulumi.Input[pulumi.InputType['SpokeLinkedVpnTunnelsArgs']] linked_vpn_tunnels: The URIs of linked VPN tunnel resources
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Immutable. The name of the spoke. Spoke names must be unique.
        :param pulumi.Input[str] project: The project for the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpokeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The NetworkConnectivity Spoke resource

        ## Example Usage
        ### Router_appliance
        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network", auto_create_subnetworks=False)
        subnetwork = gcp.compute.Subnetwork("subnetwork",
            ip_cidr_range="10.0.0.0/28",
            region="us-west1",
            network=network.self_link)
        instance = gcp.compute.Instance("instance",
            machine_type="e2-medium",
            can_ip_forward=True,
            zone="us-west1-a",
            boot_disk=gcp.compute.InstanceBootDiskArgs(
                initialize_params=gcp.compute.InstanceBootDiskInitializeParamsArgs(
                    image="projects/debian-cloud/global/images/debian-10-buster-v20210817",
                ),
            ),
            network_interfaces=[gcp.compute.InstanceNetworkInterfaceArgs(
                subnetwork=subnetwork.name,
                network_ip="10.0.0.2",
                access_configs=[gcp.compute.InstanceNetworkInterfaceAccessConfigArgs(
                    network_tier="PREMIUM",
                )],
            )])
        basic_hub = gcp.networkconnectivity.Hub("basicHub",
            description="A sample hub",
            labels={
                "label-two": "value-one",
            })
        primary = gcp.networkconnectivity.Spoke("primary",
            location="us-west1",
            description="A sample spoke with a linked routher appliance instance",
            labels={
                "label-one": "value-one",
            },
            hub=basic_hub.id,
            linked_router_appliance_instances=gcp.networkconnectivity.SpokeLinkedRouterApplianceInstancesArgs(
                instances=[gcp.networkconnectivity.SpokeLinkedRouterApplianceInstancesInstanceArgs(
                    virtual_machine=instance.self_link,
                    ip_address="10.0.0.2",
                )],
                site_to_site_data_transfer=True,
            ))
        ```

        ## Import

        Spoke can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:networkconnectivity/spoke:Spoke default projects/{{project}}/locations/{{location}}/spokes/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkconnectivity/spoke:Spoke default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkconnectivity/spoke:Spoke default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param SpokeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpokeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hub: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linked_interconnect_attachments: Optional[pulumi.Input[pulumi.InputType['SpokeLinkedInterconnectAttachmentsArgs']]] = None,
                 linked_router_appliance_instances: Optional[pulumi.Input[pulumi.InputType['SpokeLinkedRouterApplianceInstancesArgs']]] = None,
                 linked_vpn_tunnels: Optional[pulumi.Input[pulumi.InputType['SpokeLinkedVpnTunnelsArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpokeArgs.__new__(SpokeArgs)

            __props__.__dict__["description"] = description
            if hub is None and not opts.urn:
                raise TypeError("Missing required property 'hub'")
            __props__.__dict__["hub"] = hub
            __props__.__dict__["labels"] = labels
            __props__.__dict__["linked_interconnect_attachments"] = linked_interconnect_attachments
            __props__.__dict__["linked_router_appliance_instances"] = linked_router_appliance_instances
            __props__.__dict__["linked_vpn_tunnels"] = linked_vpn_tunnels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["unique_id"] = None
            __props__.__dict__["update_time"] = None
        super(Spoke, __self__).__init__(
            'gcp:networkconnectivity/spoke:Spoke',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            hub: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            linked_interconnect_attachments: Optional[pulumi.Input[pulumi.InputType['SpokeLinkedInterconnectAttachmentsArgs']]] = None,
            linked_router_appliance_instances: Optional[pulumi.Input[pulumi.InputType['SpokeLinkedRouterApplianceInstancesArgs']]] = None,
            linked_vpn_tunnels: Optional[pulumi.Input[pulumi.InputType['SpokeLinkedVpnTunnelsArgs']]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            unique_id: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'Spoke':
        """
        Get an existing Spoke resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: Output only. The time the spoke was created.
        :param pulumi.Input[str] description: An optional description of the spoke.
        :param pulumi.Input[str] hub: Immutable. The URI of the hub that this spoke is attached to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        :param pulumi.Input[pulumi.InputType['SpokeLinkedInterconnectAttachmentsArgs']] linked_interconnect_attachments: A collection of VLAN attachment resources. These resources should be redundant attachments that all advertise the same prefixes to Google Cloud. Alternatively, in active/passive configurations, all attachments should be capable of advertising the same prefixes.
        :param pulumi.Input[pulumi.InputType['SpokeLinkedRouterApplianceInstancesArgs']] linked_router_appliance_instances: The URIs of linked Router appliance resources
        :param pulumi.Input[pulumi.InputType['SpokeLinkedVpnTunnelsArgs']] linked_vpn_tunnels: The URIs of linked VPN tunnel resources
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Immutable. The name of the spoke. Spoke names must be unique.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[str] state: Output only. The current lifecycle state of this spoke. Possible values: STATE_UNSPECIFIED, CREATING, ACTIVE, DELETING
        :param pulumi.Input[str] unique_id: Output only. The Google-generated UUID for the spoke. This value is unique across all spoke resources. If a spoke is
               deleted and another with the same name is created, the new spoke is assigned a different unique_id.
        :param pulumi.Input[str] update_time: Output only. The time the spoke was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpokeState.__new__(_SpokeState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["hub"] = hub
        __props__.__dict__["labels"] = labels
        __props__.__dict__["linked_interconnect_attachments"] = linked_interconnect_attachments
        __props__.__dict__["linked_router_appliance_instances"] = linked_router_appliance_instances
        __props__.__dict__["linked_vpn_tunnels"] = linked_vpn_tunnels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["state"] = state
        __props__.__dict__["unique_id"] = unique_id
        __props__.__dict__["update_time"] = update_time
        return Spoke(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Output only. The time the spoke was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of the spoke.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def hub(self) -> pulumi.Output[str]:
        """
        Immutable. The URI of the hub that this spoke is attached to.
        """
        return pulumi.get(self, "hub")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linkedInterconnectAttachments")
    def linked_interconnect_attachments(self) -> pulumi.Output[Optional['outputs.SpokeLinkedInterconnectAttachments']]:
        """
        A collection of VLAN attachment resources. These resources should be redundant attachments that all advertise the same prefixes to Google Cloud. Alternatively, in active/passive configurations, all attachments should be capable of advertising the same prefixes.
        """
        return pulumi.get(self, "linked_interconnect_attachments")

    @property
    @pulumi.getter(name="linkedRouterApplianceInstances")
    def linked_router_appliance_instances(self) -> pulumi.Output[Optional['outputs.SpokeLinkedRouterApplianceInstances']]:
        """
        The URIs of linked Router appliance resources
        """
        return pulumi.get(self, "linked_router_appliance_instances")

    @property
    @pulumi.getter(name="linkedVpnTunnels")
    def linked_vpn_tunnels(self) -> pulumi.Output[Optional['outputs.SpokeLinkedVpnTunnels']]:
        """
        The URIs of linked VPN tunnel resources
        """
        return pulumi.get(self, "linked_vpn_tunnels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Immutable. The name of the spoke. Spoke names must be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Output only. The current lifecycle state of this spoke. Possible values: STATE_UNSPECIFIED, CREATING, ACTIVE, DELETING
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="uniqueId")
    def unique_id(self) -> pulumi.Output[str]:
        """
        Output only. The Google-generated UUID for the spoke. This value is unique across all spoke resources. If a spoke is
        deleted and another with the same name is created, the new spoke is assigned a different unique_id.
        """
        return pulumi.get(self, "unique_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Output only. The time the spoke was last updated.
        """
        return pulumi.get(self, "update_time")

