# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EdgeCacheOriginArgs', 'EdgeCacheOrigin']

@pulumi.input_type
class EdgeCacheOriginArgs:
    def __init__(__self__, *,
                 origin_address: pulumi.Input[str],
                 aws_v4_authentication: Optional[pulumi.Input['EdgeCacheOriginAwsV4AuthenticationArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 failover_origin: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_attempts: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 origin_override_action: Optional[pulumi.Input['EdgeCacheOriginOriginOverrideActionArgs']] = None,
                 origin_redirect: Optional[pulumi.Input['EdgeCacheOriginOriginRedirectArgs']] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 retry_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input['EdgeCacheOriginTimeoutArgs']] = None):
        """
        The set of arguments for constructing a EdgeCacheOrigin resource.
        :param pulumi.Input[str] origin_address: A fully qualified domain name (FQDN) or IP address reachable over the public Internet, or the address of a Google Cloud Storage bucket.
               This address will be used as the origin for cache requests - e.g. FQDN: media-backend.example.com, IPv4: 35.218.1.1, IPv6: 2607:f8b0:4012:809::200e, Cloud Storage: gs://bucketname
               When providing an FQDN (hostname), it must be publicly resolvable (e.g. via Google public DNS) and IP addresses must be publicly routable.  It must not contain a protocol (e.g., https://) and it must not contain any slashes.
               If a Cloud Storage bucket is provided, it must be in the canonical "gs://bucketname" format. Other forms, such as "storage.googleapis.com", will be rejected.
        :param pulumi.Input['EdgeCacheOriginAwsV4AuthenticationArgs'] aws_v4_authentication: Enable AWS Signature Version 4 origin authentication.
               Structure is documented below.
        :param pulumi.Input[str] description: A human-readable description of the resource.
        :param pulumi.Input[str] failover_origin: The Origin resource to try when the current origin cannot be reached.
               After maxAttempts is reached, the configured failoverOrigin will be used to fulfil the request.
               The value of timeout.maxAttemptsTimeout dictates the timeout across all origins.
               A reference to a Topic resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the EdgeCache resource.
        :param pulumi.Input[int] max_attempts: The maximum number of attempts to cache fill from this origin. Another attempt is made when a cache fill fails with one of the retryConditions.
               Once maxAttempts to this origin have failed the failoverOrigin will be used, if one is specified. That failoverOrigin may specify its own maxAttempts,
               retryConditions and failoverOrigin to control its own cache fill failures.
               The total number of allowed attempts to cache fill across this and failover origins is limited to four.
               The total time allowed for cache fill attempts across this and failover origins can be controlled with maxAttemptsTimeout.
               The last valid, non-retried response from all origins will be returned to the client.
               If no origin returns a valid response, an HTTP 502 will be returned to the client.
               Defaults to 1. Must be a value greater than 0 and less than 4.
        :param pulumi.Input[str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
        :param pulumi.Input['EdgeCacheOriginOriginOverrideActionArgs'] origin_override_action: The override actions, including url rewrites and header
               additions, for requests that use this origin.
               Structure is documented below.
        :param pulumi.Input['EdgeCacheOriginOriginRedirectArgs'] origin_redirect: Follow redirects from this origin.
               Structure is documented below.
        :param pulumi.Input[int] port: The port to connect to the origin on.
               Defaults to port 443 for HTTP2 and HTTPS protocols, and port 80 for HTTP.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] protocol: The protocol to use to connect to the configured origin. Defaults to HTTP2, and it is strongly recommended that users use HTTP2 for both security & performance.
               When using HTTP2 or HTTPS as the protocol, a valid, publicly-signed, unexpired TLS (SSL) certificate must be presented by the origin server.
               Possible values are `HTTP2`, `HTTPS`, and `HTTP`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] retry_conditions: Specifies one or more retry conditions for the configured origin.
               If the failure mode during a connection attempt to the origin matches the configured retryCondition(s),
               the origin request will be retried up to maxAttempts times. The failoverOrigin, if configured, will then be used to satisfy the request.
               The default retryCondition is "CONNECT_FAILURE".
               retryConditions apply to this origin, and not subsequent failoverOrigin(s),
               which may specify their own retryConditions and maxAttempts.
               Valid values are:
               - CONNECT_FAILURE: Retry on failures connecting to origins, for example due to connection timeouts.
               - HTTP_5XX: Retry if the origin responds with any 5xx response code, or if the origin does not respond at all, example: disconnects, reset, read timeout, connection failure, and refused streams.
               - GATEWAY_ERROR: Similar to 5xx, but only applies to response codes 502, 503 or 504.
               - RETRIABLE_4XX: Retry for retriable 4xx response codes, which include HTTP 409 (Conflict) and HTTP 429 (Too Many Requests)
               - NOT_FOUND: Retry if the origin returns a HTTP 404 (Not Found). This can be useful when generating video content, and the segment is not available yet.
               - FORBIDDEN: Retry if the origin returns a HTTP 403 (Forbidden).
               Each value may be one of `CONNECT_FAILURE`, `HTTP_5XX`, `GATEWAY_ERROR`, `RETRIABLE_4XX`, `NOT_FOUND`, and `FORBIDDEN`.
        :param pulumi.Input['EdgeCacheOriginTimeoutArgs'] timeout: The connection and HTTP timeout configuration for this origin.
               Structure is documented below.
        """
        pulumi.set(__self__, "origin_address", origin_address)
        if aws_v4_authentication is not None:
            pulumi.set(__self__, "aws_v4_authentication", aws_v4_authentication)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if failover_origin is not None:
            pulumi.set(__self__, "failover_origin", failover_origin)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_attempts is not None:
            pulumi.set(__self__, "max_attempts", max_attempts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if origin_override_action is not None:
            pulumi.set(__self__, "origin_override_action", origin_override_action)
        if origin_redirect is not None:
            pulumi.set(__self__, "origin_redirect", origin_redirect)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if retry_conditions is not None:
            pulumi.set(__self__, "retry_conditions", retry_conditions)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="originAddress")
    def origin_address(self) -> pulumi.Input[str]:
        """
        A fully qualified domain name (FQDN) or IP address reachable over the public Internet, or the address of a Google Cloud Storage bucket.
        This address will be used as the origin for cache requests - e.g. FQDN: media-backend.example.com, IPv4: 35.218.1.1, IPv6: 2607:f8b0:4012:809::200e, Cloud Storage: gs://bucketname
        When providing an FQDN (hostname), it must be publicly resolvable (e.g. via Google public DNS) and IP addresses must be publicly routable.  It must not contain a protocol (e.g., https://) and it must not contain any slashes.
        If a Cloud Storage bucket is provided, it must be in the canonical "gs://bucketname" format. Other forms, such as "storage.googleapis.com", will be rejected.
        """
        return pulumi.get(self, "origin_address")

    @origin_address.setter
    def origin_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "origin_address", value)

    @property
    @pulumi.getter(name="awsV4Authentication")
    def aws_v4_authentication(self) -> Optional[pulumi.Input['EdgeCacheOriginAwsV4AuthenticationArgs']]:
        """
        Enable AWS Signature Version 4 origin authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "aws_v4_authentication")

    @aws_v4_authentication.setter
    def aws_v4_authentication(self, value: Optional[pulumi.Input['EdgeCacheOriginAwsV4AuthenticationArgs']]):
        pulumi.set(self, "aws_v4_authentication", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="failoverOrigin")
    def failover_origin(self) -> Optional[pulumi.Input[str]]:
        """
        The Origin resource to try when the current origin cannot be reached.
        After maxAttempts is reached, the configured failoverOrigin will be used to fulfil the request.
        The value of timeout.maxAttemptsTimeout dictates the timeout across all origins.
        A reference to a Topic resource.
        """
        return pulumi.get(self, "failover_origin")

    @failover_origin.setter
    def failover_origin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failover_origin", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Set of label tags associated with the EdgeCache resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxAttempts")
    def max_attempts(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of attempts to cache fill from this origin. Another attempt is made when a cache fill fails with one of the retryConditions.
        Once maxAttempts to this origin have failed the failoverOrigin will be used, if one is specified. That failoverOrigin may specify its own maxAttempts,
        retryConditions and failoverOrigin to control its own cache fill failures.
        The total number of allowed attempts to cache fill across this and failover origins is limited to four.
        The total time allowed for cache fill attempts across this and failover origins can be controlled with maxAttemptsTimeout.
        The last valid, non-retried response from all origins will be returned to the client.
        If no origin returns a valid response, an HTTP 502 will be returned to the client.
        Defaults to 1. Must be a value greater than 0 and less than 4.
        """
        return pulumi.get(self, "max_attempts")

    @max_attempts.setter
    def max_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_attempts", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
        and all following characters must be a dash, underscore, letter or digit.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="originOverrideAction")
    def origin_override_action(self) -> Optional[pulumi.Input['EdgeCacheOriginOriginOverrideActionArgs']]:
        """
        The override actions, including url rewrites and header
        additions, for requests that use this origin.
        Structure is documented below.
        """
        return pulumi.get(self, "origin_override_action")

    @origin_override_action.setter
    def origin_override_action(self, value: Optional[pulumi.Input['EdgeCacheOriginOriginOverrideActionArgs']]):
        pulumi.set(self, "origin_override_action", value)

    @property
    @pulumi.getter(name="originRedirect")
    def origin_redirect(self) -> Optional[pulumi.Input['EdgeCacheOriginOriginRedirectArgs']]:
        """
        Follow redirects from this origin.
        Structure is documented below.
        """
        return pulumi.get(self, "origin_redirect")

    @origin_redirect.setter
    def origin_redirect(self, value: Optional[pulumi.Input['EdgeCacheOriginOriginRedirectArgs']]):
        pulumi.set(self, "origin_redirect", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port to connect to the origin on.
        Defaults to port 443 for HTTP2 and HTTPS protocols, and port 80 for HTTP.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol to use to connect to the configured origin. Defaults to HTTP2, and it is strongly recommended that users use HTTP2 for both security & performance.
        When using HTTP2 or HTTPS as the protocol, a valid, publicly-signed, unexpired TLS (SSL) certificate must be presented by the origin server.
        Possible values are `HTTP2`, `HTTPS`, and `HTTP`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="retryConditions")
    def retry_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies one or more retry conditions for the configured origin.
        If the failure mode during a connection attempt to the origin matches the configured retryCondition(s),
        the origin request will be retried up to maxAttempts times. The failoverOrigin, if configured, will then be used to satisfy the request.
        The default retryCondition is "CONNECT_FAILURE".
        retryConditions apply to this origin, and not subsequent failoverOrigin(s),
        which may specify their own retryConditions and maxAttempts.
        Valid values are:
        - CONNECT_FAILURE: Retry on failures connecting to origins, for example due to connection timeouts.
        - HTTP_5XX: Retry if the origin responds with any 5xx response code, or if the origin does not respond at all, example: disconnects, reset, read timeout, connection failure, and refused streams.
        - GATEWAY_ERROR: Similar to 5xx, but only applies to response codes 502, 503 or 504.
        - RETRIABLE_4XX: Retry for retriable 4xx response codes, which include HTTP 409 (Conflict) and HTTP 429 (Too Many Requests)
        - NOT_FOUND: Retry if the origin returns a HTTP 404 (Not Found). This can be useful when generating video content, and the segment is not available yet.
        - FORBIDDEN: Retry if the origin returns a HTTP 403 (Forbidden).
        Each value may be one of `CONNECT_FAILURE`, `HTTP_5XX`, `GATEWAY_ERROR`, `RETRIABLE_4XX`, `NOT_FOUND`, and `FORBIDDEN`.
        """
        return pulumi.get(self, "retry_conditions")

    @retry_conditions.setter
    def retry_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "retry_conditions", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input['EdgeCacheOriginTimeoutArgs']]:
        """
        The connection and HTTP timeout configuration for this origin.
        Structure is documented below.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input['EdgeCacheOriginTimeoutArgs']]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class _EdgeCacheOriginState:
    def __init__(__self__, *,
                 aws_v4_authentication: Optional[pulumi.Input['EdgeCacheOriginAwsV4AuthenticationArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 failover_origin: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_attempts: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 origin_address: Optional[pulumi.Input[str]] = None,
                 origin_override_action: Optional[pulumi.Input['EdgeCacheOriginOriginOverrideActionArgs']] = None,
                 origin_redirect: Optional[pulumi.Input['EdgeCacheOriginOriginRedirectArgs']] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 retry_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input['EdgeCacheOriginTimeoutArgs']] = None):
        """
        Input properties used for looking up and filtering EdgeCacheOrigin resources.
        :param pulumi.Input['EdgeCacheOriginAwsV4AuthenticationArgs'] aws_v4_authentication: Enable AWS Signature Version 4 origin authentication.
               Structure is documented below.
        :param pulumi.Input[str] description: A human-readable description of the resource.
        :param pulumi.Input[str] failover_origin: The Origin resource to try when the current origin cannot be reached.
               After maxAttempts is reached, the configured failoverOrigin will be used to fulfil the request.
               The value of timeout.maxAttemptsTimeout dictates the timeout across all origins.
               A reference to a Topic resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the EdgeCache resource.
        :param pulumi.Input[int] max_attempts: The maximum number of attempts to cache fill from this origin. Another attempt is made when a cache fill fails with one of the retryConditions.
               Once maxAttempts to this origin have failed the failoverOrigin will be used, if one is specified. That failoverOrigin may specify its own maxAttempts,
               retryConditions and failoverOrigin to control its own cache fill failures.
               The total number of allowed attempts to cache fill across this and failover origins is limited to four.
               The total time allowed for cache fill attempts across this and failover origins can be controlled with maxAttemptsTimeout.
               The last valid, non-retried response from all origins will be returned to the client.
               If no origin returns a valid response, an HTTP 502 will be returned to the client.
               Defaults to 1. Must be a value greater than 0 and less than 4.
        :param pulumi.Input[str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
        :param pulumi.Input[str] origin_address: A fully qualified domain name (FQDN) or IP address reachable over the public Internet, or the address of a Google Cloud Storage bucket.
               This address will be used as the origin for cache requests - e.g. FQDN: media-backend.example.com, IPv4: 35.218.1.1, IPv6: 2607:f8b0:4012:809::200e, Cloud Storage: gs://bucketname
               When providing an FQDN (hostname), it must be publicly resolvable (e.g. via Google public DNS) and IP addresses must be publicly routable.  It must not contain a protocol (e.g., https://) and it must not contain any slashes.
               If a Cloud Storage bucket is provided, it must be in the canonical "gs://bucketname" format. Other forms, such as "storage.googleapis.com", will be rejected.
        :param pulumi.Input['EdgeCacheOriginOriginOverrideActionArgs'] origin_override_action: The override actions, including url rewrites and header
               additions, for requests that use this origin.
               Structure is documented below.
        :param pulumi.Input['EdgeCacheOriginOriginRedirectArgs'] origin_redirect: Follow redirects from this origin.
               Structure is documented below.
        :param pulumi.Input[int] port: The port to connect to the origin on.
               Defaults to port 443 for HTTP2 and HTTPS protocols, and port 80 for HTTP.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] protocol: The protocol to use to connect to the configured origin. Defaults to HTTP2, and it is strongly recommended that users use HTTP2 for both security & performance.
               When using HTTP2 or HTTPS as the protocol, a valid, publicly-signed, unexpired TLS (SSL) certificate must be presented by the origin server.
               Possible values are `HTTP2`, `HTTPS`, and `HTTP`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] retry_conditions: Specifies one or more retry conditions for the configured origin.
               If the failure mode during a connection attempt to the origin matches the configured retryCondition(s),
               the origin request will be retried up to maxAttempts times. The failoverOrigin, if configured, will then be used to satisfy the request.
               The default retryCondition is "CONNECT_FAILURE".
               retryConditions apply to this origin, and not subsequent failoverOrigin(s),
               which may specify their own retryConditions and maxAttempts.
               Valid values are:
               - CONNECT_FAILURE: Retry on failures connecting to origins, for example due to connection timeouts.
               - HTTP_5XX: Retry if the origin responds with any 5xx response code, or if the origin does not respond at all, example: disconnects, reset, read timeout, connection failure, and refused streams.
               - GATEWAY_ERROR: Similar to 5xx, but only applies to response codes 502, 503 or 504.
               - RETRIABLE_4XX: Retry for retriable 4xx response codes, which include HTTP 409 (Conflict) and HTTP 429 (Too Many Requests)
               - NOT_FOUND: Retry if the origin returns a HTTP 404 (Not Found). This can be useful when generating video content, and the segment is not available yet.
               - FORBIDDEN: Retry if the origin returns a HTTP 403 (Forbidden).
               Each value may be one of `CONNECT_FAILURE`, `HTTP_5XX`, `GATEWAY_ERROR`, `RETRIABLE_4XX`, `NOT_FOUND`, and `FORBIDDEN`.
        :param pulumi.Input['EdgeCacheOriginTimeoutArgs'] timeout: The connection and HTTP timeout configuration for this origin.
               Structure is documented below.
        """
        if aws_v4_authentication is not None:
            pulumi.set(__self__, "aws_v4_authentication", aws_v4_authentication)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if failover_origin is not None:
            pulumi.set(__self__, "failover_origin", failover_origin)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_attempts is not None:
            pulumi.set(__self__, "max_attempts", max_attempts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if origin_address is not None:
            pulumi.set(__self__, "origin_address", origin_address)
        if origin_override_action is not None:
            pulumi.set(__self__, "origin_override_action", origin_override_action)
        if origin_redirect is not None:
            pulumi.set(__self__, "origin_redirect", origin_redirect)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if retry_conditions is not None:
            pulumi.set(__self__, "retry_conditions", retry_conditions)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="awsV4Authentication")
    def aws_v4_authentication(self) -> Optional[pulumi.Input['EdgeCacheOriginAwsV4AuthenticationArgs']]:
        """
        Enable AWS Signature Version 4 origin authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "aws_v4_authentication")

    @aws_v4_authentication.setter
    def aws_v4_authentication(self, value: Optional[pulumi.Input['EdgeCacheOriginAwsV4AuthenticationArgs']]):
        pulumi.set(self, "aws_v4_authentication", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="failoverOrigin")
    def failover_origin(self) -> Optional[pulumi.Input[str]]:
        """
        The Origin resource to try when the current origin cannot be reached.
        After maxAttempts is reached, the configured failoverOrigin will be used to fulfil the request.
        The value of timeout.maxAttemptsTimeout dictates the timeout across all origins.
        A reference to a Topic resource.
        """
        return pulumi.get(self, "failover_origin")

    @failover_origin.setter
    def failover_origin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failover_origin", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Set of label tags associated with the EdgeCache resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxAttempts")
    def max_attempts(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of attempts to cache fill from this origin. Another attempt is made when a cache fill fails with one of the retryConditions.
        Once maxAttempts to this origin have failed the failoverOrigin will be used, if one is specified. That failoverOrigin may specify its own maxAttempts,
        retryConditions and failoverOrigin to control its own cache fill failures.
        The total number of allowed attempts to cache fill across this and failover origins is limited to four.
        The total time allowed for cache fill attempts across this and failover origins can be controlled with maxAttemptsTimeout.
        The last valid, non-retried response from all origins will be returned to the client.
        If no origin returns a valid response, an HTTP 502 will be returned to the client.
        Defaults to 1. Must be a value greater than 0 and less than 4.
        """
        return pulumi.get(self, "max_attempts")

    @max_attempts.setter
    def max_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_attempts", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
        and all following characters must be a dash, underscore, letter or digit.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="originAddress")
    def origin_address(self) -> Optional[pulumi.Input[str]]:
        """
        A fully qualified domain name (FQDN) or IP address reachable over the public Internet, or the address of a Google Cloud Storage bucket.
        This address will be used as the origin for cache requests - e.g. FQDN: media-backend.example.com, IPv4: 35.218.1.1, IPv6: 2607:f8b0:4012:809::200e, Cloud Storage: gs://bucketname
        When providing an FQDN (hostname), it must be publicly resolvable (e.g. via Google public DNS) and IP addresses must be publicly routable.  It must not contain a protocol (e.g., https://) and it must not contain any slashes.
        If a Cloud Storage bucket is provided, it must be in the canonical "gs://bucketname" format. Other forms, such as "storage.googleapis.com", will be rejected.
        """
        return pulumi.get(self, "origin_address")

    @origin_address.setter
    def origin_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "origin_address", value)

    @property
    @pulumi.getter(name="originOverrideAction")
    def origin_override_action(self) -> Optional[pulumi.Input['EdgeCacheOriginOriginOverrideActionArgs']]:
        """
        The override actions, including url rewrites and header
        additions, for requests that use this origin.
        Structure is documented below.
        """
        return pulumi.get(self, "origin_override_action")

    @origin_override_action.setter
    def origin_override_action(self, value: Optional[pulumi.Input['EdgeCacheOriginOriginOverrideActionArgs']]):
        pulumi.set(self, "origin_override_action", value)

    @property
    @pulumi.getter(name="originRedirect")
    def origin_redirect(self) -> Optional[pulumi.Input['EdgeCacheOriginOriginRedirectArgs']]:
        """
        Follow redirects from this origin.
        Structure is documented below.
        """
        return pulumi.get(self, "origin_redirect")

    @origin_redirect.setter
    def origin_redirect(self, value: Optional[pulumi.Input['EdgeCacheOriginOriginRedirectArgs']]):
        pulumi.set(self, "origin_redirect", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port to connect to the origin on.
        Defaults to port 443 for HTTP2 and HTTPS protocols, and port 80 for HTTP.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol to use to connect to the configured origin. Defaults to HTTP2, and it is strongly recommended that users use HTTP2 for both security & performance.
        When using HTTP2 or HTTPS as the protocol, a valid, publicly-signed, unexpired TLS (SSL) certificate must be presented by the origin server.
        Possible values are `HTTP2`, `HTTPS`, and `HTTP`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="retryConditions")
    def retry_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies one or more retry conditions for the configured origin.
        If the failure mode during a connection attempt to the origin matches the configured retryCondition(s),
        the origin request will be retried up to maxAttempts times. The failoverOrigin, if configured, will then be used to satisfy the request.
        The default retryCondition is "CONNECT_FAILURE".
        retryConditions apply to this origin, and not subsequent failoverOrigin(s),
        which may specify their own retryConditions and maxAttempts.
        Valid values are:
        - CONNECT_FAILURE: Retry on failures connecting to origins, for example due to connection timeouts.
        - HTTP_5XX: Retry if the origin responds with any 5xx response code, or if the origin does not respond at all, example: disconnects, reset, read timeout, connection failure, and refused streams.
        - GATEWAY_ERROR: Similar to 5xx, but only applies to response codes 502, 503 or 504.
        - RETRIABLE_4XX: Retry for retriable 4xx response codes, which include HTTP 409 (Conflict) and HTTP 429 (Too Many Requests)
        - NOT_FOUND: Retry if the origin returns a HTTP 404 (Not Found). This can be useful when generating video content, and the segment is not available yet.
        - FORBIDDEN: Retry if the origin returns a HTTP 403 (Forbidden).
        Each value may be one of `CONNECT_FAILURE`, `HTTP_5XX`, `GATEWAY_ERROR`, `RETRIABLE_4XX`, `NOT_FOUND`, and `FORBIDDEN`.
        """
        return pulumi.get(self, "retry_conditions")

    @retry_conditions.setter
    def retry_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "retry_conditions", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input['EdgeCacheOriginTimeoutArgs']]:
        """
        The connection and HTTP timeout configuration for this origin.
        Structure is documented below.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input['EdgeCacheOriginTimeoutArgs']]):
        pulumi.set(self, "timeout", value)


class EdgeCacheOrigin(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_v4_authentication: Optional[pulumi.Input[pulumi.InputType['EdgeCacheOriginAwsV4AuthenticationArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 failover_origin: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_attempts: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 origin_address: Optional[pulumi.Input[str]] = None,
                 origin_override_action: Optional[pulumi.Input[pulumi.InputType['EdgeCacheOriginOriginOverrideActionArgs']]] = None,
                 origin_redirect: Optional[pulumi.Input[pulumi.InputType['EdgeCacheOriginOriginRedirectArgs']]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 retry_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[pulumi.InputType['EdgeCacheOriginTimeoutArgs']]] = None,
                 __props__=None):
        """
        EdgeCacheOrigin represents a HTTP-reachable backend for an EdgeCacheService.

        ## Example Usage
        ### Network Services Edge Cache Origin Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.EdgeCacheOrigin("default",
            description="The default bucket for media edge test",
            origin_address="gs://media-edge-default")
        ```
        ### Network Services Edge Cache Origin Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        fallback = gcp.networkservices.EdgeCacheOrigin("fallback",
            origin_address="fallback.example.com",
            description="The default bucket for media edge test",
            max_attempts=3,
            protocol="HTTP",
            port=80,
            retry_conditions=[
                "CONNECT_FAILURE",
                "NOT_FOUND",
                "HTTP_5XX",
                "FORBIDDEN",
            ],
            timeout=gcp.networkservices.EdgeCacheOriginTimeoutArgs(
                connect_timeout="10s",
                max_attempts_timeout="20s",
                response_timeout="60s",
                read_timeout="5s",
            ),
            origin_override_action=gcp.networkservices.EdgeCacheOriginOriginOverrideActionArgs(
                url_rewrite=gcp.networkservices.EdgeCacheOriginOriginOverrideActionUrlRewriteArgs(
                    host_rewrite="example.com",
                ),
                header_action=gcp.networkservices.EdgeCacheOriginOriginOverrideActionHeaderActionArgs(
                    request_headers_to_adds=[gcp.networkservices.EdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAddArgs(
                        header_name="x-header",
                        header_value="value",
                        replace=True,
                    )],
                ),
            ),
            origin_redirect=gcp.networkservices.EdgeCacheOriginOriginRedirectArgs(
                redirect_conditions=[
                    "MOVED_PERMANENTLY",
                    "FOUND",
                    "SEE_OTHER",
                    "TEMPORARY_REDIRECT",
                    "PERMANENT_REDIRECT",
                ],
            ))
        default = gcp.networkservices.EdgeCacheOrigin("default",
            origin_address="gs://media-edge-default",
            failover_origin=fallback.id,
            description="The default bucket for media edge test",
            max_attempts=2,
            labels={
                "a": "b",
            },
            timeout=gcp.networkservices.EdgeCacheOriginTimeoutArgs(
                connect_timeout="10s",
            ))
        ```
        ### Network Services Edge Cache Origin V4auth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.Secret("secret-basic",
            secret_id="secret-name",
            replication=gcp.secretmanager.SecretReplicationArgs(
                automatic=True,
            ))
        secret_version_basic = gcp.secretmanager.SecretVersion("secret-version-basic",
            secret=secret_basic.id,
            secret_data="secret-data")
        default = gcp.networkservices.EdgeCacheOrigin("default",
            origin_address="gs://media-edge-default",
            description="The default bucket for V4 authentication",
            aws_v4_authentication=gcp.networkservices.EdgeCacheOriginAwsV4AuthenticationArgs(
                access_key_id="ACCESSKEYID",
                secret_access_key_version=secret_version_basic.id,
                origin_region="auto",
            ))
        ```

        ## Import

        EdgeCacheOrigin can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:networkservices/edgeCacheOrigin:EdgeCacheOrigin default projects/{{project}}/locations/global/edgeCacheOrigins/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkservices/edgeCacheOrigin:EdgeCacheOrigin default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkservices/edgeCacheOrigin:EdgeCacheOrigin default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['EdgeCacheOriginAwsV4AuthenticationArgs']] aws_v4_authentication: Enable AWS Signature Version 4 origin authentication.
               Structure is documented below.
        :param pulumi.Input[str] description: A human-readable description of the resource.
        :param pulumi.Input[str] failover_origin: The Origin resource to try when the current origin cannot be reached.
               After maxAttempts is reached, the configured failoverOrigin will be used to fulfil the request.
               The value of timeout.maxAttemptsTimeout dictates the timeout across all origins.
               A reference to a Topic resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the EdgeCache resource.
        :param pulumi.Input[int] max_attempts: The maximum number of attempts to cache fill from this origin. Another attempt is made when a cache fill fails with one of the retryConditions.
               Once maxAttempts to this origin have failed the failoverOrigin will be used, if one is specified. That failoverOrigin may specify its own maxAttempts,
               retryConditions and failoverOrigin to control its own cache fill failures.
               The total number of allowed attempts to cache fill across this and failover origins is limited to four.
               The total time allowed for cache fill attempts across this and failover origins can be controlled with maxAttemptsTimeout.
               The last valid, non-retried response from all origins will be returned to the client.
               If no origin returns a valid response, an HTTP 502 will be returned to the client.
               Defaults to 1. Must be a value greater than 0 and less than 4.
        :param pulumi.Input[str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
        :param pulumi.Input[str] origin_address: A fully qualified domain name (FQDN) or IP address reachable over the public Internet, or the address of a Google Cloud Storage bucket.
               This address will be used as the origin for cache requests - e.g. FQDN: media-backend.example.com, IPv4: 35.218.1.1, IPv6: 2607:f8b0:4012:809::200e, Cloud Storage: gs://bucketname
               When providing an FQDN (hostname), it must be publicly resolvable (e.g. via Google public DNS) and IP addresses must be publicly routable.  It must not contain a protocol (e.g., https://) and it must not contain any slashes.
               If a Cloud Storage bucket is provided, it must be in the canonical "gs://bucketname" format. Other forms, such as "storage.googleapis.com", will be rejected.
        :param pulumi.Input[pulumi.InputType['EdgeCacheOriginOriginOverrideActionArgs']] origin_override_action: The override actions, including url rewrites and header
               additions, for requests that use this origin.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['EdgeCacheOriginOriginRedirectArgs']] origin_redirect: Follow redirects from this origin.
               Structure is documented below.
        :param pulumi.Input[int] port: The port to connect to the origin on.
               Defaults to port 443 for HTTP2 and HTTPS protocols, and port 80 for HTTP.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] protocol: The protocol to use to connect to the configured origin. Defaults to HTTP2, and it is strongly recommended that users use HTTP2 for both security & performance.
               When using HTTP2 or HTTPS as the protocol, a valid, publicly-signed, unexpired TLS (SSL) certificate must be presented by the origin server.
               Possible values are `HTTP2`, `HTTPS`, and `HTTP`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] retry_conditions: Specifies one or more retry conditions for the configured origin.
               If the failure mode during a connection attempt to the origin matches the configured retryCondition(s),
               the origin request will be retried up to maxAttempts times. The failoverOrigin, if configured, will then be used to satisfy the request.
               The default retryCondition is "CONNECT_FAILURE".
               retryConditions apply to this origin, and not subsequent failoverOrigin(s),
               which may specify their own retryConditions and maxAttempts.
               Valid values are:
               - CONNECT_FAILURE: Retry on failures connecting to origins, for example due to connection timeouts.
               - HTTP_5XX: Retry if the origin responds with any 5xx response code, or if the origin does not respond at all, example: disconnects, reset, read timeout, connection failure, and refused streams.
               - GATEWAY_ERROR: Similar to 5xx, but only applies to response codes 502, 503 or 504.
               - RETRIABLE_4XX: Retry for retriable 4xx response codes, which include HTTP 409 (Conflict) and HTTP 429 (Too Many Requests)
               - NOT_FOUND: Retry if the origin returns a HTTP 404 (Not Found). This can be useful when generating video content, and the segment is not available yet.
               - FORBIDDEN: Retry if the origin returns a HTTP 403 (Forbidden).
               Each value may be one of `CONNECT_FAILURE`, `HTTP_5XX`, `GATEWAY_ERROR`, `RETRIABLE_4XX`, `NOT_FOUND`, and `FORBIDDEN`.
        :param pulumi.Input[pulumi.InputType['EdgeCacheOriginTimeoutArgs']] timeout: The connection and HTTP timeout configuration for this origin.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeCacheOriginArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        EdgeCacheOrigin represents a HTTP-reachable backend for an EdgeCacheService.

        ## Example Usage
        ### Network Services Edge Cache Origin Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.networkservices.EdgeCacheOrigin("default",
            description="The default bucket for media edge test",
            origin_address="gs://media-edge-default")
        ```
        ### Network Services Edge Cache Origin Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        fallback = gcp.networkservices.EdgeCacheOrigin("fallback",
            origin_address="fallback.example.com",
            description="The default bucket for media edge test",
            max_attempts=3,
            protocol="HTTP",
            port=80,
            retry_conditions=[
                "CONNECT_FAILURE",
                "NOT_FOUND",
                "HTTP_5XX",
                "FORBIDDEN",
            ],
            timeout=gcp.networkservices.EdgeCacheOriginTimeoutArgs(
                connect_timeout="10s",
                max_attempts_timeout="20s",
                response_timeout="60s",
                read_timeout="5s",
            ),
            origin_override_action=gcp.networkservices.EdgeCacheOriginOriginOverrideActionArgs(
                url_rewrite=gcp.networkservices.EdgeCacheOriginOriginOverrideActionUrlRewriteArgs(
                    host_rewrite="example.com",
                ),
                header_action=gcp.networkservices.EdgeCacheOriginOriginOverrideActionHeaderActionArgs(
                    request_headers_to_adds=[gcp.networkservices.EdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAddArgs(
                        header_name="x-header",
                        header_value="value",
                        replace=True,
                    )],
                ),
            ),
            origin_redirect=gcp.networkservices.EdgeCacheOriginOriginRedirectArgs(
                redirect_conditions=[
                    "MOVED_PERMANENTLY",
                    "FOUND",
                    "SEE_OTHER",
                    "TEMPORARY_REDIRECT",
                    "PERMANENT_REDIRECT",
                ],
            ))
        default = gcp.networkservices.EdgeCacheOrigin("default",
            origin_address="gs://media-edge-default",
            failover_origin=fallback.id,
            description="The default bucket for media edge test",
            max_attempts=2,
            labels={
                "a": "b",
            },
            timeout=gcp.networkservices.EdgeCacheOriginTimeoutArgs(
                connect_timeout="10s",
            ))
        ```
        ### Network Services Edge Cache Origin V4auth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret_basic = gcp.secretmanager.Secret("secret-basic",
            secret_id="secret-name",
            replication=gcp.secretmanager.SecretReplicationArgs(
                automatic=True,
            ))
        secret_version_basic = gcp.secretmanager.SecretVersion("secret-version-basic",
            secret=secret_basic.id,
            secret_data="secret-data")
        default = gcp.networkservices.EdgeCacheOrigin("default",
            origin_address="gs://media-edge-default",
            description="The default bucket for V4 authentication",
            aws_v4_authentication=gcp.networkservices.EdgeCacheOriginAwsV4AuthenticationArgs(
                access_key_id="ACCESSKEYID",
                secret_access_key_version=secret_version_basic.id,
                origin_region="auto",
            ))
        ```

        ## Import

        EdgeCacheOrigin can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:networkservices/edgeCacheOrigin:EdgeCacheOrigin default projects/{{project}}/locations/global/edgeCacheOrigins/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkservices/edgeCacheOrigin:EdgeCacheOrigin default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkservices/edgeCacheOrigin:EdgeCacheOrigin default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param EdgeCacheOriginArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeCacheOriginArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_v4_authentication: Optional[pulumi.Input[pulumi.InputType['EdgeCacheOriginAwsV4AuthenticationArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 failover_origin: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_attempts: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 origin_address: Optional[pulumi.Input[str]] = None,
                 origin_override_action: Optional[pulumi.Input[pulumi.InputType['EdgeCacheOriginOriginOverrideActionArgs']]] = None,
                 origin_redirect: Optional[pulumi.Input[pulumi.InputType['EdgeCacheOriginOriginRedirectArgs']]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 retry_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[pulumi.InputType['EdgeCacheOriginTimeoutArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeCacheOriginArgs.__new__(EdgeCacheOriginArgs)

            __props__.__dict__["aws_v4_authentication"] = aws_v4_authentication
            __props__.__dict__["description"] = description
            __props__.__dict__["failover_origin"] = failover_origin
            __props__.__dict__["labels"] = labels
            __props__.__dict__["max_attempts"] = max_attempts
            __props__.__dict__["name"] = name
            if origin_address is None and not opts.urn:
                raise TypeError("Missing required property 'origin_address'")
            __props__.__dict__["origin_address"] = origin_address
            __props__.__dict__["origin_override_action"] = origin_override_action
            __props__.__dict__["origin_redirect"] = origin_redirect
            __props__.__dict__["port"] = port
            __props__.__dict__["project"] = project
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["retry_conditions"] = retry_conditions
            __props__.__dict__["timeout"] = timeout
        super(EdgeCacheOrigin, __self__).__init__(
            'gcp:networkservices/edgeCacheOrigin:EdgeCacheOrigin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_v4_authentication: Optional[pulumi.Input[pulumi.InputType['EdgeCacheOriginAwsV4AuthenticationArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            failover_origin: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            max_attempts: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            origin_address: Optional[pulumi.Input[str]] = None,
            origin_override_action: Optional[pulumi.Input[pulumi.InputType['EdgeCacheOriginOriginOverrideActionArgs']]] = None,
            origin_redirect: Optional[pulumi.Input[pulumi.InputType['EdgeCacheOriginOriginRedirectArgs']]] = None,
            port: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            retry_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            timeout: Optional[pulumi.Input[pulumi.InputType['EdgeCacheOriginTimeoutArgs']]] = None) -> 'EdgeCacheOrigin':
        """
        Get an existing EdgeCacheOrigin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['EdgeCacheOriginAwsV4AuthenticationArgs']] aws_v4_authentication: Enable AWS Signature Version 4 origin authentication.
               Structure is documented below.
        :param pulumi.Input[str] description: A human-readable description of the resource.
        :param pulumi.Input[str] failover_origin: The Origin resource to try when the current origin cannot be reached.
               After maxAttempts is reached, the configured failoverOrigin will be used to fulfil the request.
               The value of timeout.maxAttemptsTimeout dictates the timeout across all origins.
               A reference to a Topic resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the EdgeCache resource.
        :param pulumi.Input[int] max_attempts: The maximum number of attempts to cache fill from this origin. Another attempt is made when a cache fill fails with one of the retryConditions.
               Once maxAttempts to this origin have failed the failoverOrigin will be used, if one is specified. That failoverOrigin may specify its own maxAttempts,
               retryConditions and failoverOrigin to control its own cache fill failures.
               The total number of allowed attempts to cache fill across this and failover origins is limited to four.
               The total time allowed for cache fill attempts across this and failover origins can be controlled with maxAttemptsTimeout.
               The last valid, non-retried response from all origins will be returned to the client.
               If no origin returns a valid response, an HTTP 502 will be returned to the client.
               Defaults to 1. Must be a value greater than 0 and less than 4.
        :param pulumi.Input[str] name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
        :param pulumi.Input[str] origin_address: A fully qualified domain name (FQDN) or IP address reachable over the public Internet, or the address of a Google Cloud Storage bucket.
               This address will be used as the origin for cache requests - e.g. FQDN: media-backend.example.com, IPv4: 35.218.1.1, IPv6: 2607:f8b0:4012:809::200e, Cloud Storage: gs://bucketname
               When providing an FQDN (hostname), it must be publicly resolvable (e.g. via Google public DNS) and IP addresses must be publicly routable.  It must not contain a protocol (e.g., https://) and it must not contain any slashes.
               If a Cloud Storage bucket is provided, it must be in the canonical "gs://bucketname" format. Other forms, such as "storage.googleapis.com", will be rejected.
        :param pulumi.Input[pulumi.InputType['EdgeCacheOriginOriginOverrideActionArgs']] origin_override_action: The override actions, including url rewrites and header
               additions, for requests that use this origin.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['EdgeCacheOriginOriginRedirectArgs']] origin_redirect: Follow redirects from this origin.
               Structure is documented below.
        :param pulumi.Input[int] port: The port to connect to the origin on.
               Defaults to port 443 for HTTP2 and HTTPS protocols, and port 80 for HTTP.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] protocol: The protocol to use to connect to the configured origin. Defaults to HTTP2, and it is strongly recommended that users use HTTP2 for both security & performance.
               When using HTTP2 or HTTPS as the protocol, a valid, publicly-signed, unexpired TLS (SSL) certificate must be presented by the origin server.
               Possible values are `HTTP2`, `HTTPS`, and `HTTP`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] retry_conditions: Specifies one or more retry conditions for the configured origin.
               If the failure mode during a connection attempt to the origin matches the configured retryCondition(s),
               the origin request will be retried up to maxAttempts times. The failoverOrigin, if configured, will then be used to satisfy the request.
               The default retryCondition is "CONNECT_FAILURE".
               retryConditions apply to this origin, and not subsequent failoverOrigin(s),
               which may specify their own retryConditions and maxAttempts.
               Valid values are:
               - CONNECT_FAILURE: Retry on failures connecting to origins, for example due to connection timeouts.
               - HTTP_5XX: Retry if the origin responds with any 5xx response code, or if the origin does not respond at all, example: disconnects, reset, read timeout, connection failure, and refused streams.
               - GATEWAY_ERROR: Similar to 5xx, but only applies to response codes 502, 503 or 504.
               - RETRIABLE_4XX: Retry for retriable 4xx response codes, which include HTTP 409 (Conflict) and HTTP 429 (Too Many Requests)
               - NOT_FOUND: Retry if the origin returns a HTTP 404 (Not Found). This can be useful when generating video content, and the segment is not available yet.
               - FORBIDDEN: Retry if the origin returns a HTTP 403 (Forbidden).
               Each value may be one of `CONNECT_FAILURE`, `HTTP_5XX`, `GATEWAY_ERROR`, `RETRIABLE_4XX`, `NOT_FOUND`, and `FORBIDDEN`.
        :param pulumi.Input[pulumi.InputType['EdgeCacheOriginTimeoutArgs']] timeout: The connection and HTTP timeout configuration for this origin.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeCacheOriginState.__new__(_EdgeCacheOriginState)

        __props__.__dict__["aws_v4_authentication"] = aws_v4_authentication
        __props__.__dict__["description"] = description
        __props__.__dict__["failover_origin"] = failover_origin
        __props__.__dict__["labels"] = labels
        __props__.__dict__["max_attempts"] = max_attempts
        __props__.__dict__["name"] = name
        __props__.__dict__["origin_address"] = origin_address
        __props__.__dict__["origin_override_action"] = origin_override_action
        __props__.__dict__["origin_redirect"] = origin_redirect
        __props__.__dict__["port"] = port
        __props__.__dict__["project"] = project
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["retry_conditions"] = retry_conditions
        __props__.__dict__["timeout"] = timeout
        return EdgeCacheOrigin(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsV4Authentication")
    def aws_v4_authentication(self) -> pulumi.Output[Optional['outputs.EdgeCacheOriginAwsV4Authentication']]:
        """
        Enable AWS Signature Version 4 origin authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "aws_v4_authentication")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="failoverOrigin")
    def failover_origin(self) -> pulumi.Output[Optional[str]]:
        """
        The Origin resource to try when the current origin cannot be reached.
        After maxAttempts is reached, the configured failoverOrigin will be used to fulfil the request.
        The value of timeout.maxAttemptsTimeout dictates the timeout across all origins.
        A reference to a Topic resource.
        """
        return pulumi.get(self, "failover_origin")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Set of label tags associated with the EdgeCache resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxAttempts")
    def max_attempts(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of attempts to cache fill from this origin. Another attempt is made when a cache fill fails with one of the retryConditions.
        Once maxAttempts to this origin have failed the failoverOrigin will be used, if one is specified. That failoverOrigin may specify its own maxAttempts,
        retryConditions and failoverOrigin to control its own cache fill failures.
        The total number of allowed attempts to cache fill across this and failover origins is limited to four.
        The total time allowed for cache fill attempts across this and failover origins can be controlled with maxAttemptsTimeout.
        The last valid, non-retried response from all origins will be returned to the client.
        If no origin returns a valid response, an HTTP 502 will be returned to the client.
        Defaults to 1. Must be a value greater than 0 and less than 4.
        """
        return pulumi.get(self, "max_attempts")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
        and all following characters must be a dash, underscore, letter or digit.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="originAddress")
    def origin_address(self) -> pulumi.Output[str]:
        """
        A fully qualified domain name (FQDN) or IP address reachable over the public Internet, or the address of a Google Cloud Storage bucket.
        This address will be used as the origin for cache requests - e.g. FQDN: media-backend.example.com, IPv4: 35.218.1.1, IPv6: 2607:f8b0:4012:809::200e, Cloud Storage: gs://bucketname
        When providing an FQDN (hostname), it must be publicly resolvable (e.g. via Google public DNS) and IP addresses must be publicly routable.  It must not contain a protocol (e.g., https://) and it must not contain any slashes.
        If a Cloud Storage bucket is provided, it must be in the canonical "gs://bucketname" format. Other forms, such as "storage.googleapis.com", will be rejected.
        """
        return pulumi.get(self, "origin_address")

    @property
    @pulumi.getter(name="originOverrideAction")
    def origin_override_action(self) -> pulumi.Output[Optional['outputs.EdgeCacheOriginOriginOverrideAction']]:
        """
        The override actions, including url rewrites and header
        additions, for requests that use this origin.
        Structure is documented below.
        """
        return pulumi.get(self, "origin_override_action")

    @property
    @pulumi.getter(name="originRedirect")
    def origin_redirect(self) -> pulumi.Output[Optional['outputs.EdgeCacheOriginOriginRedirect']]:
        """
        Follow redirects from this origin.
        Structure is documented below.
        """
        return pulumi.get(self, "origin_redirect")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        The port to connect to the origin on.
        Defaults to port 443 for HTTP2 and HTTPS protocols, and port 80 for HTTP.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        The protocol to use to connect to the configured origin. Defaults to HTTP2, and it is strongly recommended that users use HTTP2 for both security & performance.
        When using HTTP2 or HTTPS as the protocol, a valid, publicly-signed, unexpired TLS (SSL) certificate must be presented by the origin server.
        Possible values are `HTTP2`, `HTTPS`, and `HTTP`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="retryConditions")
    def retry_conditions(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies one or more retry conditions for the configured origin.
        If the failure mode during a connection attempt to the origin matches the configured retryCondition(s),
        the origin request will be retried up to maxAttempts times. The failoverOrigin, if configured, will then be used to satisfy the request.
        The default retryCondition is "CONNECT_FAILURE".
        retryConditions apply to this origin, and not subsequent failoverOrigin(s),
        which may specify their own retryConditions and maxAttempts.
        Valid values are:
        - CONNECT_FAILURE: Retry on failures connecting to origins, for example due to connection timeouts.
        - HTTP_5XX: Retry if the origin responds with any 5xx response code, or if the origin does not respond at all, example: disconnects, reset, read timeout, connection failure, and refused streams.
        - GATEWAY_ERROR: Similar to 5xx, but only applies to response codes 502, 503 or 504.
        - RETRIABLE_4XX: Retry for retriable 4xx response codes, which include HTTP 409 (Conflict) and HTTP 429 (Too Many Requests)
        - NOT_FOUND: Retry if the origin returns a HTTP 404 (Not Found). This can be useful when generating video content, and the segment is not available yet.
        - FORBIDDEN: Retry if the origin returns a HTTP 403 (Forbidden).
        Each value may be one of `CONNECT_FAILURE`, `HTTP_5XX`, `GATEWAY_ERROR`, `RETRIABLE_4XX`, `NOT_FOUND`, and `FORBIDDEN`.
        """
        return pulumi.get(self, "retry_conditions")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional['outputs.EdgeCacheOriginTimeout']]:
        """
        The connection and HTTP timeout configuration for this origin.
        Structure is documented below.
        """
        return pulumi.get(self, "timeout")

