# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EdgeCacheServiceArgs', 'EdgeCacheService']

@pulumi.input_type
class EdgeCacheServiceArgs:
    def __init__(__self__, *,
                 routing: pulumi.Input['EdgeCacheServiceRoutingArgs'],
                 description: Optional[pulumi.Input[str]] = None,
                 disable_http2: Optional[pulumi.Input[bool]] = None,
                 disable_quic: Optional[pulumi.Input[bool]] = None,
                 edge_security_policy: Optional[pulumi.Input[str]] = None,
                 edge_ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 log_config: Optional[pulumi.Input['EdgeCacheServiceLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 require_tls: Optional[pulumi.Input[bool]] = None,
                 ssl_policy: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EdgeCacheService resource.
        :param pulumi.Input['EdgeCacheServiceRoutingArgs'] routing: Defines how requests are routed, modified, cached and/or which origin content is filled from.
               Structure is documented below.
        :param pulumi.Input[str] description: A human-readable description of the resource.
        :param pulumi.Input[bool] disable_http2: Disables HTTP/2.
               HTTP/2 (h2) is enabled by default and recommended for performance. HTTP/2 improves connection re-use and reduces connection setup overhead by sending multiple streams over the same connection.
               Some legacy HTTP clients may have issues with HTTP/2 connections due to broken HTTP/2 implementations. Setting this to true will prevent HTTP/2 from being advertised and negotiated.
        :param pulumi.Input[bool] disable_quic: HTTP/3 (IETF QUIC) and Google QUIC are enabled by default.
        :param pulumi.Input[str] edge_security_policy: Resource URL that points at the Cloud Armor edge security policy that is applied on each request against the EdgeCacheService.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] edge_ssl_certificates: URLs to sslCertificate resources that are used to authenticate connections between users and the EdgeCacheService.
               Note that only "global" certificates with a "scope" of "EDGE_CACHE" can be attached to an EdgeCacheService.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the EdgeCache resource.
        :param pulumi.Input['EdgeCacheServiceLogConfigArgs'] log_config: Specifies the logging options for the traffic served by this service. If logging is enabled, logs will be exported to Cloud Logging.
               Structure is documented below.
        :param pulumi.Input[str] name: The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] require_tls: Require TLS (HTTPS) for all clients connecting to this service.
               Clients who connect over HTTP (port 80) will receive a HTTP 301 to the same URL over HTTPS (port 443).
               You must have at least one (1) edgeSslCertificate specified to enable this.
        :param pulumi.Input[str] ssl_policy: URL of the SslPolicy resource that will be associated with the EdgeCacheService.
               If not set, the EdgeCacheService has no SSL policy configured, and will default to the "COMPATIBLE" policy.
        """
        pulumi.set(__self__, "routing", routing)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_http2 is not None:
            pulumi.set(__self__, "disable_http2", disable_http2)
        if disable_quic is not None:
            pulumi.set(__self__, "disable_quic", disable_quic)
        if edge_security_policy is not None:
            pulumi.set(__self__, "edge_security_policy", edge_security_policy)
        if edge_ssl_certificates is not None:
            pulumi.set(__self__, "edge_ssl_certificates", edge_ssl_certificates)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if require_tls is not None:
            pulumi.set(__self__, "require_tls", require_tls)
        if ssl_policy is not None:
            pulumi.set(__self__, "ssl_policy", ssl_policy)

    @property
    @pulumi.getter
    def routing(self) -> pulumi.Input['EdgeCacheServiceRoutingArgs']:
        """
        Defines how requests are routed, modified, cached and/or which origin content is filled from.
        Structure is documented below.
        """
        return pulumi.get(self, "routing")

    @routing.setter
    def routing(self, value: pulumi.Input['EdgeCacheServiceRoutingArgs']):
        pulumi.set(self, "routing", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableHttp2")
    def disable_http2(self) -> Optional[pulumi.Input[bool]]:
        """
        Disables HTTP/2.
        HTTP/2 (h2) is enabled by default and recommended for performance. HTTP/2 improves connection re-use and reduces connection setup overhead by sending multiple streams over the same connection.
        Some legacy HTTP clients may have issues with HTTP/2 connections due to broken HTTP/2 implementations. Setting this to true will prevent HTTP/2 from being advertised and negotiated.
        """
        return pulumi.get(self, "disable_http2")

    @disable_http2.setter
    def disable_http2(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_http2", value)

    @property
    @pulumi.getter(name="disableQuic")
    def disable_quic(self) -> Optional[pulumi.Input[bool]]:
        """
        HTTP/3 (IETF QUIC) and Google QUIC are enabled by default.
        """
        return pulumi.get(self, "disable_quic")

    @disable_quic.setter
    def disable_quic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_quic", value)

    @property
    @pulumi.getter(name="edgeSecurityPolicy")
    def edge_security_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Resource URL that points at the Cloud Armor edge security policy that is applied on each request against the EdgeCacheService.
        """
        return pulumi.get(self, "edge_security_policy")

    @edge_security_policy.setter
    def edge_security_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edge_security_policy", value)

    @property
    @pulumi.getter(name="edgeSslCertificates")
    def edge_ssl_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs to sslCertificate resources that are used to authenticate connections between users and the EdgeCacheService.
        Note that only "global" certificates with a "scope" of "EDGE_CACHE" can be attached to an EdgeCacheService.
        """
        return pulumi.get(self, "edge_ssl_certificates")

    @edge_ssl_certificates.setter
    def edge_ssl_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "edge_ssl_certificates", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Set of label tags associated with the EdgeCache resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['EdgeCacheServiceLogConfigArgs']]:
        """
        Specifies the logging options for the traffic served by this service. If logging is enabled, logs will be exported to Cloud Logging.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['EdgeCacheServiceLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requireTls")
    def require_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Require TLS (HTTPS) for all clients connecting to this service.
        Clients who connect over HTTP (port 80) will receive a HTTP 301 to the same URL over HTTPS (port 443).
        You must have at least one (1) edgeSslCertificate specified to enable this.
        """
        return pulumi.get(self, "require_tls")

    @require_tls.setter
    def require_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_tls", value)

    @property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the SslPolicy resource that will be associated with the EdgeCacheService.
        If not set, the EdgeCacheService has no SSL policy configured, and will default to the "COMPATIBLE" policy.
        """
        return pulumi.get(self, "ssl_policy")

    @ssl_policy.setter
    def ssl_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_policy", value)


@pulumi.input_type
class _EdgeCacheServiceState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_http2: Optional[pulumi.Input[bool]] = None,
                 disable_quic: Optional[pulumi.Input[bool]] = None,
                 edge_security_policy: Optional[pulumi.Input[str]] = None,
                 edge_ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv4_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 log_config: Optional[pulumi.Input['EdgeCacheServiceLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 require_tls: Optional[pulumi.Input[bool]] = None,
                 routing: Optional[pulumi.Input['EdgeCacheServiceRoutingArgs']] = None,
                 ssl_policy: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EdgeCacheService resources.
        :param pulumi.Input[str] description: A human-readable description of the resource.
        :param pulumi.Input[bool] disable_http2: Disables HTTP/2.
               HTTP/2 (h2) is enabled by default and recommended for performance. HTTP/2 improves connection re-use and reduces connection setup overhead by sending multiple streams over the same connection.
               Some legacy HTTP clients may have issues with HTTP/2 connections due to broken HTTP/2 implementations. Setting this to true will prevent HTTP/2 from being advertised and negotiated.
        :param pulumi.Input[bool] disable_quic: HTTP/3 (IETF QUIC) and Google QUIC are enabled by default.
        :param pulumi.Input[str] edge_security_policy: Resource URL that points at the Cloud Armor edge security policy that is applied on each request against the EdgeCacheService.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] edge_ssl_certificates: URLs to sslCertificate resources that are used to authenticate connections between users and the EdgeCacheService.
               Note that only "global" certificates with a "scope" of "EDGE_CACHE" can be attached to an EdgeCacheService.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv4_addresses: The IPv4 addresses associated with this service. Addresses are static for the lifetime of the service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv6_addresses: The IPv6 addresses associated with this service. Addresses are static for the lifetime of the service.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the EdgeCache resource.
        :param pulumi.Input['EdgeCacheServiceLogConfigArgs'] log_config: Specifies the logging options for the traffic served by this service. If logging is enabled, logs will be exported to Cloud Logging.
               Structure is documented below.
        :param pulumi.Input[str] name: The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] require_tls: Require TLS (HTTPS) for all clients connecting to this service.
               Clients who connect over HTTP (port 80) will receive a HTTP 301 to the same URL over HTTPS (port 443).
               You must have at least one (1) edgeSslCertificate specified to enable this.
        :param pulumi.Input['EdgeCacheServiceRoutingArgs'] routing: Defines how requests are routed, modified, cached and/or which origin content is filled from.
               Structure is documented below.
        :param pulumi.Input[str] ssl_policy: URL of the SslPolicy resource that will be associated with the EdgeCacheService.
               If not set, the EdgeCacheService has no SSL policy configured, and will default to the "COMPATIBLE" policy.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_http2 is not None:
            pulumi.set(__self__, "disable_http2", disable_http2)
        if disable_quic is not None:
            pulumi.set(__self__, "disable_quic", disable_quic)
        if edge_security_policy is not None:
            pulumi.set(__self__, "edge_security_policy", edge_security_policy)
        if edge_ssl_certificates is not None:
            pulumi.set(__self__, "edge_ssl_certificates", edge_ssl_certificates)
        if ipv4_addresses is not None:
            pulumi.set(__self__, "ipv4_addresses", ipv4_addresses)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if require_tls is not None:
            pulumi.set(__self__, "require_tls", require_tls)
        if routing is not None:
            pulumi.set(__self__, "routing", routing)
        if ssl_policy is not None:
            pulumi.set(__self__, "ssl_policy", ssl_policy)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableHttp2")
    def disable_http2(self) -> Optional[pulumi.Input[bool]]:
        """
        Disables HTTP/2.
        HTTP/2 (h2) is enabled by default and recommended for performance. HTTP/2 improves connection re-use and reduces connection setup overhead by sending multiple streams over the same connection.
        Some legacy HTTP clients may have issues with HTTP/2 connections due to broken HTTP/2 implementations. Setting this to true will prevent HTTP/2 from being advertised and negotiated.
        """
        return pulumi.get(self, "disable_http2")

    @disable_http2.setter
    def disable_http2(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_http2", value)

    @property
    @pulumi.getter(name="disableQuic")
    def disable_quic(self) -> Optional[pulumi.Input[bool]]:
        """
        HTTP/3 (IETF QUIC) and Google QUIC are enabled by default.
        """
        return pulumi.get(self, "disable_quic")

    @disable_quic.setter
    def disable_quic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_quic", value)

    @property
    @pulumi.getter(name="edgeSecurityPolicy")
    def edge_security_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Resource URL that points at the Cloud Armor edge security policy that is applied on each request against the EdgeCacheService.
        """
        return pulumi.get(self, "edge_security_policy")

    @edge_security_policy.setter
    def edge_security_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edge_security_policy", value)

    @property
    @pulumi.getter(name="edgeSslCertificates")
    def edge_ssl_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs to sslCertificate resources that are used to authenticate connections between users and the EdgeCacheService.
        Note that only "global" certificates with a "scope" of "EDGE_CACHE" can be attached to an EdgeCacheService.
        """
        return pulumi.get(self, "edge_ssl_certificates")

    @edge_ssl_certificates.setter
    def edge_ssl_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "edge_ssl_certificates", value)

    @property
    @pulumi.getter(name="ipv4Addresses")
    def ipv4_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IPv4 addresses associated with this service. Addresses are static for the lifetime of the service.
        """
        return pulumi.get(self, "ipv4_addresses")

    @ipv4_addresses.setter
    def ipv4_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipv4_addresses", value)

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IPv6 addresses associated with this service. Addresses are static for the lifetime of the service.
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Set of label tags associated with the EdgeCache resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['EdgeCacheServiceLogConfigArgs']]:
        """
        Specifies the logging options for the traffic served by this service. If logging is enabled, logs will be exported to Cloud Logging.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['EdgeCacheServiceLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requireTls")
    def require_tls(self) -> Optional[pulumi.Input[bool]]:
        """
        Require TLS (HTTPS) for all clients connecting to this service.
        Clients who connect over HTTP (port 80) will receive a HTTP 301 to the same URL over HTTPS (port 443).
        You must have at least one (1) edgeSslCertificate specified to enable this.
        """
        return pulumi.get(self, "require_tls")

    @require_tls.setter
    def require_tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_tls", value)

    @property
    @pulumi.getter
    def routing(self) -> Optional[pulumi.Input['EdgeCacheServiceRoutingArgs']]:
        """
        Defines how requests are routed, modified, cached and/or which origin content is filled from.
        Structure is documented below.
        """
        return pulumi.get(self, "routing")

    @routing.setter
    def routing(self, value: Optional[pulumi.Input['EdgeCacheServiceRoutingArgs']]):
        pulumi.set(self, "routing", value)

    @property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the SslPolicy resource that will be associated with the EdgeCacheService.
        If not set, the EdgeCacheService has no SSL policy configured, and will default to the "COMPATIBLE" policy.
        """
        return pulumi.get(self, "ssl_policy")

    @ssl_policy.setter
    def ssl_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_policy", value)


class EdgeCacheService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_http2: Optional[pulumi.Input[bool]] = None,
                 disable_quic: Optional[pulumi.Input[bool]] = None,
                 edge_security_policy: Optional[pulumi.Input[str]] = None,
                 edge_ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 log_config: Optional[pulumi.Input[pulumi.InputType['EdgeCacheServiceLogConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 require_tls: Optional[pulumi.Input[bool]] = None,
                 routing: Optional[pulumi.Input[pulumi.InputType['EdgeCacheServiceRoutingArgs']]] = None,
                 ssl_policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        EdgeCacheService defines the IP addresses, protocols, security policies, cache policies and routing configuration.

        > **Warning:** These resources require allow-listing to use, and are not openly available to all Cloud customers. Engage with your Cloud account team to discuss how to onboard.

        ## Example Usage
        ### Network Services Edge Cache Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dest = gcp.storage.Bucket("dest",
            location="US",
            force_destroy=True)
        instance_edge_cache_origin = gcp.networkservices.EdgeCacheOrigin("instanceEdgeCacheOrigin",
            origin_address=dest.url,
            description="The default bucket for media edge test",
            max_attempts=2,
            timeout=gcp.networkservices.EdgeCacheOriginTimeoutArgs(
                connect_timeout="10s",
            ))
        instance_edge_cache_service = gcp.networkservices.EdgeCacheService("instanceEdgeCacheService",
            description="some description",
            routing=gcp.networkservices.EdgeCacheServiceRoutingArgs(
                host_rules=[gcp.networkservices.EdgeCacheServiceRoutingHostRuleArgs(
                    description="host rule description",
                    hosts=["sslcert.tf-test.club"],
                    path_matcher="routes",
                )],
                path_matchers=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherArgs(
                    name="routes",
                    route_rules=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleArgs(
                        description="a route rule to match against",
                        priority="1",
                        match_rules=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs(
                            prefix_match="/",
                        )],
                        origin=instance_edge_cache_origin.name,
                        route_action=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionArgs(
                            cdn_policy=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyArgs(
                                cache_mode="CACHE_ALL_STATIC",
                                default_ttl="3600s",
                            ),
                        ),
                        header_action=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionArgs(
                            response_header_to_adds=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAddArgs(
                                header_name="x-cache-status",
                                header_value="{cdn_cache_status}",
                            )],
                        ),
                    )],
                )],
            ))
        ```
        ### Network Services Edge Cache Service Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dest = gcp.storage.Bucket("dest",
            location="US",
            force_destroy=True)
        google = gcp.networkservices.EdgeCacheOrigin("google",
            origin_address="google.com",
            description="The default bucket for media edge test",
            max_attempts=2,
            timeout=gcp.networkservices.EdgeCacheOriginTimeoutArgs(
                connect_timeout="10s",
            ))
        instance_edge_cache_origin = gcp.networkservices.EdgeCacheOrigin("instanceEdgeCacheOrigin",
            origin_address=dest.url,
            description="The default bucket for media edge test",
            max_attempts=2,
            timeout=gcp.networkservices.EdgeCacheOriginTimeoutArgs(
                connect_timeout="10s",
            ))
        instance_edge_cache_service = gcp.networkservices.EdgeCacheService("instanceEdgeCacheService",
            description="some description",
            disable_quic=True,
            disable_http2=True,
            labels={
                "a": "b",
            },
            routing=gcp.networkservices.EdgeCacheServiceRoutingArgs(
                host_rules=[
                    gcp.networkservices.EdgeCacheServiceRoutingHostRuleArgs(
                        description="host rule description",
                        hosts=["sslcert.tf-test.club"],
                        path_matcher="routes",
                    ),
                    gcp.networkservices.EdgeCacheServiceRoutingHostRuleArgs(
                        description="host rule2",
                        hosts=["sslcert.tf-test2.club"],
                        path_matcher="routes",
                    ),
                    gcp.networkservices.EdgeCacheServiceRoutingHostRuleArgs(
                        description="host rule3",
                        hosts=["sslcert.tf-test3.club"],
                        path_matcher="routesAdvanced",
                    ),
                ],
                path_matchers=[
                    gcp.networkservices.EdgeCacheServiceRoutingPathMatcherArgs(
                        name="routes",
                        route_rules=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleArgs(
                            description="a route rule to match against",
                            priority="1",
                            match_rules=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs(
                                prefix_match="/",
                            )],
                            origin=instance_edge_cache_origin.name,
                            route_action=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionArgs(
                                cdn_policy=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyArgs(
                                    cache_mode="CACHE_ALL_STATIC",
                                    default_ttl="3600s",
                                ),
                            ),
                            header_action=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionArgs(
                                response_header_to_adds=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAddArgs(
                                    header_name="x-cache-status",
                                    header_value="{cdn_cache_status}",
                                )],
                            ),
                        )],
                    ),
                    gcp.networkservices.EdgeCacheServiceRoutingPathMatcherArgs(
                        name="routesAdvanced",
                        description="an advanced ruleset",
                        route_rules=[
                            gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleArgs(
                                description="an advanced route rule to match against",
                                priority="1",
                                match_rules=[
                                    gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs(
                                        prefix_match="/potato/",
                                        query_parameter_matches=[
                                            gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatchArgs(
                                                name="debug",
                                                present_match=True,
                                            ),
                                            gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatchArgs(
                                                name="state",
                                                exact_match="debug",
                                            ),
                                        ],
                                    ),
                                    gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs(
                                        full_path_match="/apple",
                                    ),
                                ],
                                header_action=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionArgs(
                                    request_header_to_adds=[
                                        gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAddArgs(
                                            header_name="debug",
                                            header_value="true",
                                            replace=True,
                                        ),
                                        gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAddArgs(
                                            header_name="potato",
                                            header_value="plant",
                                        ),
                                    ],
                                    response_header_to_adds=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAddArgs(
                                        header_name="potato",
                                        header_value="plant",
                                        replace=True,
                                    )],
                                    request_header_to_removes=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemoveArgs(
                                        header_name="prod",
                                    )],
                                    response_header_to_removes=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemoveArgs(
                                        header_name="prod",
                                    )],
                                ),
                                origin=instance_edge_cache_origin.name,
                                route_action=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionArgs(
                                    cdn_policy=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyArgs(
                                        cache_mode="CACHE_ALL_STATIC",
                                        default_ttl="3800s",
                                        client_ttl="3600s",
                                        max_ttl="9000s",
                                        cache_key_policy=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyArgs(
                                            include_protocol=True,
                                            exclude_host=True,
                                            included_query_parameters=[
                                                "apple",
                                                "dev",
                                                "santa",
                                                "claus",
                                            ],
                                            included_header_names=["banana"],
                                            included_cookie_names=["orange"],
                                        ),
                                        negative_caching=True,
                                        signed_request_mode="DISABLED",
                                        negative_caching_policy={
                                            "500": "3000s",
                                        },
                                    ),
                                    url_rewrite=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteArgs(
                                        path_prefix_rewrite="/dev",
                                        host_rewrite="dev.club",
                                    ),
                                    cors_policy=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyArgs(
                                        max_age="2500s",
                                        allow_credentials=True,
                                        allow_origins=["*"],
                                        allow_methods=["GET"],
                                        allow_headers=["dev"],
                                        expose_headers=["prod"],
                                    ),
                                ),
                            ),
                            gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleArgs(
                                description="a second route rule to match against",
                                priority="2",
                                match_rules=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs(
                                    full_path_match="/yay",
                                )],
                                origin=instance_edge_cache_origin.name,
                                route_action=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionArgs(
                                    cdn_policy=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyArgs(
                                        cache_mode="CACHE_ALL_STATIC",
                                        default_ttl="3600s",
                                        cache_key_policy=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyArgs(
                                            excluded_query_parameters=["dev"],
                                        ),
                                    ),
                                    cors_policy=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyArgs(
                                        max_age="3000s",
                                        allow_headers=["dev"],
                                        disabled=True,
                                    ),
                                ),
                            ),
                        ],
                    ),
                ],
            ),
            log_config=gcp.networkservices.EdgeCacheServiceLogConfigArgs(
                enable=True,
                sample_rate=0.01,
            ))
        ```

        ## Import

        EdgeCacheService can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:networkservices/edgeCacheService:EdgeCacheService default projects/{{project}}/locations/global/edgeCacheServices/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkservices/edgeCacheService:EdgeCacheService default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkservices/edgeCacheService:EdgeCacheService default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A human-readable description of the resource.
        :param pulumi.Input[bool] disable_http2: Disables HTTP/2.
               HTTP/2 (h2) is enabled by default and recommended for performance. HTTP/2 improves connection re-use and reduces connection setup overhead by sending multiple streams over the same connection.
               Some legacy HTTP clients may have issues with HTTP/2 connections due to broken HTTP/2 implementations. Setting this to true will prevent HTTP/2 from being advertised and negotiated.
        :param pulumi.Input[bool] disable_quic: HTTP/3 (IETF QUIC) and Google QUIC are enabled by default.
        :param pulumi.Input[str] edge_security_policy: Resource URL that points at the Cloud Armor edge security policy that is applied on each request against the EdgeCacheService.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] edge_ssl_certificates: URLs to sslCertificate resources that are used to authenticate connections between users and the EdgeCacheService.
               Note that only "global" certificates with a "scope" of "EDGE_CACHE" can be attached to an EdgeCacheService.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the EdgeCache resource.
        :param pulumi.Input[pulumi.InputType['EdgeCacheServiceLogConfigArgs']] log_config: Specifies the logging options for the traffic served by this service. If logging is enabled, logs will be exported to Cloud Logging.
               Structure is documented below.
        :param pulumi.Input[str] name: The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] require_tls: Require TLS (HTTPS) for all clients connecting to this service.
               Clients who connect over HTTP (port 80) will receive a HTTP 301 to the same URL over HTTPS (port 443).
               You must have at least one (1) edgeSslCertificate specified to enable this.
        :param pulumi.Input[pulumi.InputType['EdgeCacheServiceRoutingArgs']] routing: Defines how requests are routed, modified, cached and/or which origin content is filled from.
               Structure is documented below.
        :param pulumi.Input[str] ssl_policy: URL of the SslPolicy resource that will be associated with the EdgeCacheService.
               If not set, the EdgeCacheService has no SSL policy configured, and will default to the "COMPATIBLE" policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeCacheServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        EdgeCacheService defines the IP addresses, protocols, security policies, cache policies and routing configuration.

        > **Warning:** These resources require allow-listing to use, and are not openly available to all Cloud customers. Engage with your Cloud account team to discuss how to onboard.

        ## Example Usage
        ### Network Services Edge Cache Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dest = gcp.storage.Bucket("dest",
            location="US",
            force_destroy=True)
        instance_edge_cache_origin = gcp.networkservices.EdgeCacheOrigin("instanceEdgeCacheOrigin",
            origin_address=dest.url,
            description="The default bucket for media edge test",
            max_attempts=2,
            timeout=gcp.networkservices.EdgeCacheOriginTimeoutArgs(
                connect_timeout="10s",
            ))
        instance_edge_cache_service = gcp.networkservices.EdgeCacheService("instanceEdgeCacheService",
            description="some description",
            routing=gcp.networkservices.EdgeCacheServiceRoutingArgs(
                host_rules=[gcp.networkservices.EdgeCacheServiceRoutingHostRuleArgs(
                    description="host rule description",
                    hosts=["sslcert.tf-test.club"],
                    path_matcher="routes",
                )],
                path_matchers=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherArgs(
                    name="routes",
                    route_rules=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleArgs(
                        description="a route rule to match against",
                        priority="1",
                        match_rules=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs(
                            prefix_match="/",
                        )],
                        origin=instance_edge_cache_origin.name,
                        route_action=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionArgs(
                            cdn_policy=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyArgs(
                                cache_mode="CACHE_ALL_STATIC",
                                default_ttl="3600s",
                            ),
                        ),
                        header_action=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionArgs(
                            response_header_to_adds=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAddArgs(
                                header_name="x-cache-status",
                                header_value="{cdn_cache_status}",
                            )],
                        ),
                    )],
                )],
            ))
        ```
        ### Network Services Edge Cache Service Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dest = gcp.storage.Bucket("dest",
            location="US",
            force_destroy=True)
        google = gcp.networkservices.EdgeCacheOrigin("google",
            origin_address="google.com",
            description="The default bucket for media edge test",
            max_attempts=2,
            timeout=gcp.networkservices.EdgeCacheOriginTimeoutArgs(
                connect_timeout="10s",
            ))
        instance_edge_cache_origin = gcp.networkservices.EdgeCacheOrigin("instanceEdgeCacheOrigin",
            origin_address=dest.url,
            description="The default bucket for media edge test",
            max_attempts=2,
            timeout=gcp.networkservices.EdgeCacheOriginTimeoutArgs(
                connect_timeout="10s",
            ))
        instance_edge_cache_service = gcp.networkservices.EdgeCacheService("instanceEdgeCacheService",
            description="some description",
            disable_quic=True,
            disable_http2=True,
            labels={
                "a": "b",
            },
            routing=gcp.networkservices.EdgeCacheServiceRoutingArgs(
                host_rules=[
                    gcp.networkservices.EdgeCacheServiceRoutingHostRuleArgs(
                        description="host rule description",
                        hosts=["sslcert.tf-test.club"],
                        path_matcher="routes",
                    ),
                    gcp.networkservices.EdgeCacheServiceRoutingHostRuleArgs(
                        description="host rule2",
                        hosts=["sslcert.tf-test2.club"],
                        path_matcher="routes",
                    ),
                    gcp.networkservices.EdgeCacheServiceRoutingHostRuleArgs(
                        description="host rule3",
                        hosts=["sslcert.tf-test3.club"],
                        path_matcher="routesAdvanced",
                    ),
                ],
                path_matchers=[
                    gcp.networkservices.EdgeCacheServiceRoutingPathMatcherArgs(
                        name="routes",
                        route_rules=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleArgs(
                            description="a route rule to match against",
                            priority="1",
                            match_rules=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs(
                                prefix_match="/",
                            )],
                            origin=instance_edge_cache_origin.name,
                            route_action=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionArgs(
                                cdn_policy=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyArgs(
                                    cache_mode="CACHE_ALL_STATIC",
                                    default_ttl="3600s",
                                ),
                            ),
                            header_action=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionArgs(
                                response_header_to_adds=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAddArgs(
                                    header_name="x-cache-status",
                                    header_value="{cdn_cache_status}",
                                )],
                            ),
                        )],
                    ),
                    gcp.networkservices.EdgeCacheServiceRoutingPathMatcherArgs(
                        name="routesAdvanced",
                        description="an advanced ruleset",
                        route_rules=[
                            gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleArgs(
                                description="an advanced route rule to match against",
                                priority="1",
                                match_rules=[
                                    gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs(
                                        prefix_match="/potato/",
                                        query_parameter_matches=[
                                            gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatchArgs(
                                                name="debug",
                                                present_match=True,
                                            ),
                                            gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatchArgs(
                                                name="state",
                                                exact_match="debug",
                                            ),
                                        ],
                                    ),
                                    gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs(
                                        full_path_match="/apple",
                                    ),
                                ],
                                header_action=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionArgs(
                                    request_header_to_adds=[
                                        gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAddArgs(
                                            header_name="debug",
                                            header_value="true",
                                            replace=True,
                                        ),
                                        gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAddArgs(
                                            header_name="potato",
                                            header_value="plant",
                                        ),
                                    ],
                                    response_header_to_adds=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAddArgs(
                                        header_name="potato",
                                        header_value="plant",
                                        replace=True,
                                    )],
                                    request_header_to_removes=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemoveArgs(
                                        header_name="prod",
                                    )],
                                    response_header_to_removes=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemoveArgs(
                                        header_name="prod",
                                    )],
                                ),
                                origin=instance_edge_cache_origin.name,
                                route_action=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionArgs(
                                    cdn_policy=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyArgs(
                                        cache_mode="CACHE_ALL_STATIC",
                                        default_ttl="3800s",
                                        client_ttl="3600s",
                                        max_ttl="9000s",
                                        cache_key_policy=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyArgs(
                                            include_protocol=True,
                                            exclude_host=True,
                                            included_query_parameters=[
                                                "apple",
                                                "dev",
                                                "santa",
                                                "claus",
                                            ],
                                            included_header_names=["banana"],
                                            included_cookie_names=["orange"],
                                        ),
                                        negative_caching=True,
                                        signed_request_mode="DISABLED",
                                        negative_caching_policy={
                                            "500": "3000s",
                                        },
                                    ),
                                    url_rewrite=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteArgs(
                                        path_prefix_rewrite="/dev",
                                        host_rewrite="dev.club",
                                    ),
                                    cors_policy=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyArgs(
                                        max_age="2500s",
                                        allow_credentials=True,
                                        allow_origins=["*"],
                                        allow_methods=["GET"],
                                        allow_headers=["dev"],
                                        expose_headers=["prod"],
                                    ),
                                ),
                            ),
                            gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleArgs(
                                description="a second route rule to match against",
                                priority="2",
                                match_rules=[gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs(
                                    full_path_match="/yay",
                                )],
                                origin=instance_edge_cache_origin.name,
                                route_action=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionArgs(
                                    cdn_policy=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyArgs(
                                        cache_mode="CACHE_ALL_STATIC",
                                        default_ttl="3600s",
                                        cache_key_policy=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyArgs(
                                            excluded_query_parameters=["dev"],
                                        ),
                                    ),
                                    cors_policy=gcp.networkservices.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyArgs(
                                        max_age="3000s",
                                        allow_headers=["dev"],
                                        disabled=True,
                                    ),
                                ),
                            ),
                        ],
                    ),
                ],
            ),
            log_config=gcp.networkservices.EdgeCacheServiceLogConfigArgs(
                enable=True,
                sample_rate=0.01,
            ))
        ```

        ## Import

        EdgeCacheService can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:networkservices/edgeCacheService:EdgeCacheService default projects/{{project}}/locations/global/edgeCacheServices/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkservices/edgeCacheService:EdgeCacheService default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:networkservices/edgeCacheService:EdgeCacheService default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param EdgeCacheServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeCacheServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_http2: Optional[pulumi.Input[bool]] = None,
                 disable_quic: Optional[pulumi.Input[bool]] = None,
                 edge_security_policy: Optional[pulumi.Input[str]] = None,
                 edge_ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 log_config: Optional[pulumi.Input[pulumi.InputType['EdgeCacheServiceLogConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 require_tls: Optional[pulumi.Input[bool]] = None,
                 routing: Optional[pulumi.Input[pulumi.InputType['EdgeCacheServiceRoutingArgs']]] = None,
                 ssl_policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeCacheServiceArgs.__new__(EdgeCacheServiceArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["disable_http2"] = disable_http2
            __props__.__dict__["disable_quic"] = disable_quic
            __props__.__dict__["edge_security_policy"] = edge_security_policy
            __props__.__dict__["edge_ssl_certificates"] = edge_ssl_certificates
            __props__.__dict__["labels"] = labels
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["require_tls"] = require_tls
            if routing is None and not opts.urn:
                raise TypeError("Missing required property 'routing'")
            __props__.__dict__["routing"] = routing
            __props__.__dict__["ssl_policy"] = ssl_policy
            __props__.__dict__["ipv4_addresses"] = None
            __props__.__dict__["ipv6_addresses"] = None
        super(EdgeCacheService, __self__).__init__(
            'gcp:networkservices/edgeCacheService:EdgeCacheService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            disable_http2: Optional[pulumi.Input[bool]] = None,
            disable_quic: Optional[pulumi.Input[bool]] = None,
            edge_security_policy: Optional[pulumi.Input[str]] = None,
            edge_ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ipv4_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            log_config: Optional[pulumi.Input[pulumi.InputType['EdgeCacheServiceLogConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            require_tls: Optional[pulumi.Input[bool]] = None,
            routing: Optional[pulumi.Input[pulumi.InputType['EdgeCacheServiceRoutingArgs']]] = None,
            ssl_policy: Optional[pulumi.Input[str]] = None) -> 'EdgeCacheService':
        """
        Get an existing EdgeCacheService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A human-readable description of the resource.
        :param pulumi.Input[bool] disable_http2: Disables HTTP/2.
               HTTP/2 (h2) is enabled by default and recommended for performance. HTTP/2 improves connection re-use and reduces connection setup overhead by sending multiple streams over the same connection.
               Some legacy HTTP clients may have issues with HTTP/2 connections due to broken HTTP/2 implementations. Setting this to true will prevent HTTP/2 from being advertised and negotiated.
        :param pulumi.Input[bool] disable_quic: HTTP/3 (IETF QUIC) and Google QUIC are enabled by default.
        :param pulumi.Input[str] edge_security_policy: Resource URL that points at the Cloud Armor edge security policy that is applied on each request against the EdgeCacheService.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] edge_ssl_certificates: URLs to sslCertificate resources that are used to authenticate connections between users and the EdgeCacheService.
               Note that only "global" certificates with a "scope" of "EDGE_CACHE" can be attached to an EdgeCacheService.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv4_addresses: The IPv4 addresses associated with this service. Addresses are static for the lifetime of the service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv6_addresses: The IPv6 addresses associated with this service. Addresses are static for the lifetime of the service.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Set of label tags associated with the EdgeCache resource.
        :param pulumi.Input[pulumi.InputType['EdgeCacheServiceLogConfigArgs']] log_config: Specifies the logging options for the traffic served by this service. If logging is enabled, logs will be exported to Cloud Logging.
               Structure is documented below.
        :param pulumi.Input[str] name: The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] require_tls: Require TLS (HTTPS) for all clients connecting to this service.
               Clients who connect over HTTP (port 80) will receive a HTTP 301 to the same URL over HTTPS (port 443).
               You must have at least one (1) edgeSslCertificate specified to enable this.
        :param pulumi.Input[pulumi.InputType['EdgeCacheServiceRoutingArgs']] routing: Defines how requests are routed, modified, cached and/or which origin content is filled from.
               Structure is documented below.
        :param pulumi.Input[str] ssl_policy: URL of the SslPolicy resource that will be associated with the EdgeCacheService.
               If not set, the EdgeCacheService has no SSL policy configured, and will default to the "COMPATIBLE" policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeCacheServiceState.__new__(_EdgeCacheServiceState)

        __props__.__dict__["description"] = description
        __props__.__dict__["disable_http2"] = disable_http2
        __props__.__dict__["disable_quic"] = disable_quic
        __props__.__dict__["edge_security_policy"] = edge_security_policy
        __props__.__dict__["edge_ssl_certificates"] = edge_ssl_certificates
        __props__.__dict__["ipv4_addresses"] = ipv4_addresses
        __props__.__dict__["ipv6_addresses"] = ipv6_addresses
        __props__.__dict__["labels"] = labels
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["require_tls"] = require_tls
        __props__.__dict__["routing"] = routing
        __props__.__dict__["ssl_policy"] = ssl_policy
        return EdgeCacheService(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableHttp2")
    def disable_http2(self) -> pulumi.Output[Optional[bool]]:
        """
        Disables HTTP/2.
        HTTP/2 (h2) is enabled by default and recommended for performance. HTTP/2 improves connection re-use and reduces connection setup overhead by sending multiple streams over the same connection.
        Some legacy HTTP clients may have issues with HTTP/2 connections due to broken HTTP/2 implementations. Setting this to true will prevent HTTP/2 from being advertised and negotiated.
        """
        return pulumi.get(self, "disable_http2")

    @property
    @pulumi.getter(name="disableQuic")
    def disable_quic(self) -> pulumi.Output[bool]:
        """
        HTTP/3 (IETF QUIC) and Google QUIC are enabled by default.
        """
        return pulumi.get(self, "disable_quic")

    @property
    @pulumi.getter(name="edgeSecurityPolicy")
    def edge_security_policy(self) -> pulumi.Output[Optional[str]]:
        """
        Resource URL that points at the Cloud Armor edge security policy that is applied on each request against the EdgeCacheService.
        """
        return pulumi.get(self, "edge_security_policy")

    @property
    @pulumi.getter(name="edgeSslCertificates")
    def edge_ssl_certificates(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        URLs to sslCertificate resources that are used to authenticate connections between users and the EdgeCacheService.
        Note that only "global" certificates with a "scope" of "EDGE_CACHE" can be attached to an EdgeCacheService.
        """
        return pulumi.get(self, "edge_ssl_certificates")

    @property
    @pulumi.getter(name="ipv4Addresses")
    def ipv4_addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        The IPv4 addresses associated with this service. Addresses are static for the lifetime of the service.
        """
        return pulumi.get(self, "ipv4_addresses")

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        The IPv6 addresses associated with this service. Addresses are static for the lifetime of the service.
        """
        return pulumi.get(self, "ipv6_addresses")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Set of label tags associated with the EdgeCache resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output[Optional['outputs.EdgeCacheServiceLogConfig']]:
        """
        Specifies the logging options for the traffic served by this service. If logging is enabled, logs will be exported to Cloud Logging.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="requireTls")
    def require_tls(self) -> pulumi.Output[bool]:
        """
        Require TLS (HTTPS) for all clients connecting to this service.
        Clients who connect over HTTP (port 80) will receive a HTTP 301 to the same URL over HTTPS (port 443).
        You must have at least one (1) edgeSslCertificate specified to enable this.
        """
        return pulumi.get(self, "require_tls")

    @property
    @pulumi.getter
    def routing(self) -> pulumi.Output['outputs.EdgeCacheServiceRouting']:
        """
        Defines how requests are routed, modified, cached and/or which origin content is filled from.
        Structure is documented below.
        """
        return pulumi.get(self, "routing")

    @property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> pulumi.Output[Optional[str]]:
        """
        URL of the SslPolicy resource that will be associated with the EdgeCacheService.
        If not set, the EdgeCacheService has no SSL policy configured, and will default to the "COMPATIBLE" policy.
        """
        return pulumi.get(self, "ssl_policy")

