# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnterpriseKeyArgs', 'EnterpriseKey']

@pulumi.input_type
class EnterpriseKeyArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 android_settings: Optional[pulumi.Input['EnterpriseKeyAndroidSettingsArgs']] = None,
                 ios_settings: Optional[pulumi.Input['EnterpriseKeyIosSettingsArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 testing_options: Optional[pulumi.Input['EnterpriseKeyTestingOptionsArgs']] = None,
                 web_settings: Optional[pulumi.Input['EnterpriseKeyWebSettingsArgs']] = None):
        """
        The set of arguments for constructing a EnterpriseKey resource.
        :param pulumi.Input[str] display_name: Human-readable display name of this key. Modifiable by user.
        :param pulumi.Input['EnterpriseKeyAndroidSettingsArgs'] android_settings: Settings for keys that can be used by Android apps.
        :param pulumi.Input['EnterpriseKeyIosSettingsArgs'] ios_settings: Settings for keys that can be used by iOS apps.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: See [Creating and managing labels](https://cloud.google.com/recaptcha-enterprise/docs/labels).
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input['EnterpriseKeyTestingOptionsArgs'] testing_options: Options for user acceptance testing.
        :param pulumi.Input['EnterpriseKeyWebSettingsArgs'] web_settings: Settings for keys that can be used by websites.
        """
        pulumi.set(__self__, "display_name", display_name)
        if android_settings is not None:
            pulumi.set(__self__, "android_settings", android_settings)
        if ios_settings is not None:
            pulumi.set(__self__, "ios_settings", ios_settings)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if testing_options is not None:
            pulumi.set(__self__, "testing_options", testing_options)
        if web_settings is not None:
            pulumi.set(__self__, "web_settings", web_settings)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        Human-readable display name of this key. Modifiable by user.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="androidSettings")
    def android_settings(self) -> Optional[pulumi.Input['EnterpriseKeyAndroidSettingsArgs']]:
        """
        Settings for keys that can be used by Android apps.
        """
        return pulumi.get(self, "android_settings")

    @android_settings.setter
    def android_settings(self, value: Optional[pulumi.Input['EnterpriseKeyAndroidSettingsArgs']]):
        pulumi.set(self, "android_settings", value)

    @property
    @pulumi.getter(name="iosSettings")
    def ios_settings(self) -> Optional[pulumi.Input['EnterpriseKeyIosSettingsArgs']]:
        """
        Settings for keys that can be used by iOS apps.
        """
        return pulumi.get(self, "ios_settings")

    @ios_settings.setter
    def ios_settings(self, value: Optional[pulumi.Input['EnterpriseKeyIosSettingsArgs']]):
        pulumi.set(self, "ios_settings", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        See [Creating and managing labels](https://cloud.google.com/recaptcha-enterprise/docs/labels).
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="testingOptions")
    def testing_options(self) -> Optional[pulumi.Input['EnterpriseKeyTestingOptionsArgs']]:
        """
        Options for user acceptance testing.
        """
        return pulumi.get(self, "testing_options")

    @testing_options.setter
    def testing_options(self, value: Optional[pulumi.Input['EnterpriseKeyTestingOptionsArgs']]):
        pulumi.set(self, "testing_options", value)

    @property
    @pulumi.getter(name="webSettings")
    def web_settings(self) -> Optional[pulumi.Input['EnterpriseKeyWebSettingsArgs']]:
        """
        Settings for keys that can be used by websites.
        """
        return pulumi.get(self, "web_settings")

    @web_settings.setter
    def web_settings(self, value: Optional[pulumi.Input['EnterpriseKeyWebSettingsArgs']]):
        pulumi.set(self, "web_settings", value)


@pulumi.input_type
class _EnterpriseKeyState:
    def __init__(__self__, *,
                 android_settings: Optional[pulumi.Input['EnterpriseKeyAndroidSettingsArgs']] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 ios_settings: Optional[pulumi.Input['EnterpriseKeyIosSettingsArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 testing_options: Optional[pulumi.Input['EnterpriseKeyTestingOptionsArgs']] = None,
                 web_settings: Optional[pulumi.Input['EnterpriseKeyWebSettingsArgs']] = None):
        """
        Input properties used for looking up and filtering EnterpriseKey resources.
        :param pulumi.Input['EnterpriseKeyAndroidSettingsArgs'] android_settings: Settings for keys that can be used by Android apps.
        :param pulumi.Input[str] create_time: The timestamp corresponding to the creation of this Key.
        :param pulumi.Input[str] display_name: Human-readable display name of this key. Modifiable by user.
        :param pulumi.Input['EnterpriseKeyIosSettingsArgs'] ios_settings: Settings for keys that can be used by iOS apps.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: See [Creating and managing labels](https://cloud.google.com/recaptcha-enterprise/docs/labels).
        :param pulumi.Input[str] name: The resource name for the Key in the format "projects/{project}/keys/{key}".
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input['EnterpriseKeyTestingOptionsArgs'] testing_options: Options for user acceptance testing.
        :param pulumi.Input['EnterpriseKeyWebSettingsArgs'] web_settings: Settings for keys that can be used by websites.
        """
        if android_settings is not None:
            pulumi.set(__self__, "android_settings", android_settings)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if ios_settings is not None:
            pulumi.set(__self__, "ios_settings", ios_settings)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if testing_options is not None:
            pulumi.set(__self__, "testing_options", testing_options)
        if web_settings is not None:
            pulumi.set(__self__, "web_settings", web_settings)

    @property
    @pulumi.getter(name="androidSettings")
    def android_settings(self) -> Optional[pulumi.Input['EnterpriseKeyAndroidSettingsArgs']]:
        """
        Settings for keys that can be used by Android apps.
        """
        return pulumi.get(self, "android_settings")

    @android_settings.setter
    def android_settings(self, value: Optional[pulumi.Input['EnterpriseKeyAndroidSettingsArgs']]):
        pulumi.set(self, "android_settings", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp corresponding to the creation of this Key.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable display name of this key. Modifiable by user.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="iosSettings")
    def ios_settings(self) -> Optional[pulumi.Input['EnterpriseKeyIosSettingsArgs']]:
        """
        Settings for keys that can be used by iOS apps.
        """
        return pulumi.get(self, "ios_settings")

    @ios_settings.setter
    def ios_settings(self, value: Optional[pulumi.Input['EnterpriseKeyIosSettingsArgs']]):
        pulumi.set(self, "ios_settings", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        See [Creating and managing labels](https://cloud.google.com/recaptcha-enterprise/docs/labels).
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name for the Key in the format "projects/{project}/keys/{key}".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="testingOptions")
    def testing_options(self) -> Optional[pulumi.Input['EnterpriseKeyTestingOptionsArgs']]:
        """
        Options for user acceptance testing.
        """
        return pulumi.get(self, "testing_options")

    @testing_options.setter
    def testing_options(self, value: Optional[pulumi.Input['EnterpriseKeyTestingOptionsArgs']]):
        pulumi.set(self, "testing_options", value)

    @property
    @pulumi.getter(name="webSettings")
    def web_settings(self) -> Optional[pulumi.Input['EnterpriseKeyWebSettingsArgs']]:
        """
        Settings for keys that can be used by websites.
        """
        return pulumi.get(self, "web_settings")

    @web_settings.setter
    def web_settings(self, value: Optional[pulumi.Input['EnterpriseKeyWebSettingsArgs']]):
        pulumi.set(self, "web_settings", value)


class EnterpriseKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 android_settings: Optional[pulumi.Input[pulumi.InputType['EnterpriseKeyAndroidSettingsArgs']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 ios_settings: Optional[pulumi.Input[pulumi.InputType['EnterpriseKeyIosSettingsArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 testing_options: Optional[pulumi.Input[pulumi.InputType['EnterpriseKeyTestingOptionsArgs']]] = None,
                 web_settings: Optional[pulumi.Input[pulumi.InputType['EnterpriseKeyWebSettingsArgs']]] = None,
                 __props__=None):
        """
        The RecaptchaEnterprise Key resource

        ## Example Usage
        ### Android_key
        A basic test of recaptcha enterprise key that can be used by Android apps
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            android_settings=gcp.recaptcha.EnterpriseKeyAndroidSettingsArgs(
                allow_all_package_names=True,
                allowed_package_names=[],
            ),
            display_name="display-name-one",
            labels={
                "label-one": "value-one",
            },
            project="my-project-name",
            testing_options=gcp.recaptcha.EnterpriseKeyTestingOptionsArgs(
                testing_score=0.8,
            ))
        ```
        ### Ios_key
        A basic test of recaptcha enterprise key that can be used by iOS apps
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            ios_settings=gcp.recaptcha.EnterpriseKeyIosSettingsArgs(
                allow_all_bundle_ids=True,
                allowed_bundle_ids=[],
            ),
            labels={
                "label-one": "value-one",
            },
            project="my-project-name",
            testing_options=gcp.recaptcha.EnterpriseKeyTestingOptionsArgs(
                testing_score=1,
            ))
        ```
        ### Minimal_key
        A minimal test of recaptcha enterprise key
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            labels={},
            project="my-project-name",
            web_settings=gcp.recaptcha.EnterpriseKeyWebSettingsArgs(
                allow_all_domains=True,
                integration_type="SCORE",
            ))
        ```
        ### Web_key
        A basic test of recaptcha enterprise key that can be used by websites
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            labels={
                "label-one": "value-one",
            },
            project="my-project-name",
            testing_options=gcp.recaptcha.EnterpriseKeyTestingOptionsArgs(
                testing_challenge="NOCAPTCHA",
                testing_score=0.5,
            ),
            web_settings=gcp.recaptcha.EnterpriseKeyWebSettingsArgs(
                allow_all_domains=True,
                allowed_domains=[],
                challenge_security_preference="USABILITY",
                integration_type="CHECKBOX",
            ))
        ```
        ### Web_score_key
        A basic test of recaptcha enterprise key with score integration type that can be used by websites
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            labels={
                "label-one": "value-one",
            },
            project="my-project-name",
            testing_options=gcp.recaptcha.EnterpriseKeyTestingOptionsArgs(
                testing_score=0.5,
            ),
            web_settings=gcp.recaptcha.EnterpriseKeyWebSettingsArgs(
                allow_all_domains=True,
                allow_amp_traffic=False,
                allowed_domains=[],
                integration_type="SCORE",
            ))
        ```

        ## Import

        Key can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:recaptcha/enterpriseKey:EnterpriseKey default projects/{{project}}/keys/{{name}}
        ```

        ```sh
         $ pulumi import gcp:recaptcha/enterpriseKey:EnterpriseKey default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:recaptcha/enterpriseKey:EnterpriseKey default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['EnterpriseKeyAndroidSettingsArgs']] android_settings: Settings for keys that can be used by Android apps.
        :param pulumi.Input[str] display_name: Human-readable display name of this key. Modifiable by user.
        :param pulumi.Input[pulumi.InputType['EnterpriseKeyIosSettingsArgs']] ios_settings: Settings for keys that can be used by iOS apps.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: See [Creating and managing labels](https://cloud.google.com/recaptcha-enterprise/docs/labels).
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[pulumi.InputType['EnterpriseKeyTestingOptionsArgs']] testing_options: Options for user acceptance testing.
        :param pulumi.Input[pulumi.InputType['EnterpriseKeyWebSettingsArgs']] web_settings: Settings for keys that can be used by websites.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnterpriseKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The RecaptchaEnterprise Key resource

        ## Example Usage
        ### Android_key
        A basic test of recaptcha enterprise key that can be used by Android apps
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            android_settings=gcp.recaptcha.EnterpriseKeyAndroidSettingsArgs(
                allow_all_package_names=True,
                allowed_package_names=[],
            ),
            display_name="display-name-one",
            labels={
                "label-one": "value-one",
            },
            project="my-project-name",
            testing_options=gcp.recaptcha.EnterpriseKeyTestingOptionsArgs(
                testing_score=0.8,
            ))
        ```
        ### Ios_key
        A basic test of recaptcha enterprise key that can be used by iOS apps
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            ios_settings=gcp.recaptcha.EnterpriseKeyIosSettingsArgs(
                allow_all_bundle_ids=True,
                allowed_bundle_ids=[],
            ),
            labels={
                "label-one": "value-one",
            },
            project="my-project-name",
            testing_options=gcp.recaptcha.EnterpriseKeyTestingOptionsArgs(
                testing_score=1,
            ))
        ```
        ### Minimal_key
        A minimal test of recaptcha enterprise key
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            labels={},
            project="my-project-name",
            web_settings=gcp.recaptcha.EnterpriseKeyWebSettingsArgs(
                allow_all_domains=True,
                integration_type="SCORE",
            ))
        ```
        ### Web_key
        A basic test of recaptcha enterprise key that can be used by websites
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            labels={
                "label-one": "value-one",
            },
            project="my-project-name",
            testing_options=gcp.recaptcha.EnterpriseKeyTestingOptionsArgs(
                testing_challenge="NOCAPTCHA",
                testing_score=0.5,
            ),
            web_settings=gcp.recaptcha.EnterpriseKeyWebSettingsArgs(
                allow_all_domains=True,
                allowed_domains=[],
                challenge_security_preference="USABILITY",
                integration_type="CHECKBOX",
            ))
        ```
        ### Web_score_key
        A basic test of recaptcha enterprise key with score integration type that can be used by websites
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.recaptcha.EnterpriseKey("primary",
            display_name="display-name-one",
            labels={
                "label-one": "value-one",
            },
            project="my-project-name",
            testing_options=gcp.recaptcha.EnterpriseKeyTestingOptionsArgs(
                testing_score=0.5,
            ),
            web_settings=gcp.recaptcha.EnterpriseKeyWebSettingsArgs(
                allow_all_domains=True,
                allow_amp_traffic=False,
                allowed_domains=[],
                integration_type="SCORE",
            ))
        ```

        ## Import

        Key can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:recaptcha/enterpriseKey:EnterpriseKey default projects/{{project}}/keys/{{name}}
        ```

        ```sh
         $ pulumi import gcp:recaptcha/enterpriseKey:EnterpriseKey default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:recaptcha/enterpriseKey:EnterpriseKey default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param EnterpriseKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnterpriseKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 android_settings: Optional[pulumi.Input[pulumi.InputType['EnterpriseKeyAndroidSettingsArgs']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 ios_settings: Optional[pulumi.Input[pulumi.InputType['EnterpriseKeyIosSettingsArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 testing_options: Optional[pulumi.Input[pulumi.InputType['EnterpriseKeyTestingOptionsArgs']]] = None,
                 web_settings: Optional[pulumi.Input[pulumi.InputType['EnterpriseKeyWebSettingsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnterpriseKeyArgs.__new__(EnterpriseKeyArgs)

            __props__.__dict__["android_settings"] = android_settings
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["ios_settings"] = ios_settings
            __props__.__dict__["labels"] = labels
            __props__.__dict__["project"] = project
            __props__.__dict__["testing_options"] = testing_options
            __props__.__dict__["web_settings"] = web_settings
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
        super(EnterpriseKey, __self__).__init__(
            'gcp:recaptcha/enterpriseKey:EnterpriseKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            android_settings: Optional[pulumi.Input[pulumi.InputType['EnterpriseKeyAndroidSettingsArgs']]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            ios_settings: Optional[pulumi.Input[pulumi.InputType['EnterpriseKeyIosSettingsArgs']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            testing_options: Optional[pulumi.Input[pulumi.InputType['EnterpriseKeyTestingOptionsArgs']]] = None,
            web_settings: Optional[pulumi.Input[pulumi.InputType['EnterpriseKeyWebSettingsArgs']]] = None) -> 'EnterpriseKey':
        """
        Get an existing EnterpriseKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['EnterpriseKeyAndroidSettingsArgs']] android_settings: Settings for keys that can be used by Android apps.
        :param pulumi.Input[str] create_time: The timestamp corresponding to the creation of this Key.
        :param pulumi.Input[str] display_name: Human-readable display name of this key. Modifiable by user.
        :param pulumi.Input[pulumi.InputType['EnterpriseKeyIosSettingsArgs']] ios_settings: Settings for keys that can be used by iOS apps.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: See [Creating and managing labels](https://cloud.google.com/recaptcha-enterprise/docs/labels).
        :param pulumi.Input[str] name: The resource name for the Key in the format "projects/{project}/keys/{key}".
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[pulumi.InputType['EnterpriseKeyTestingOptionsArgs']] testing_options: Options for user acceptance testing.
        :param pulumi.Input[pulumi.InputType['EnterpriseKeyWebSettingsArgs']] web_settings: Settings for keys that can be used by websites.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnterpriseKeyState.__new__(_EnterpriseKeyState)

        __props__.__dict__["android_settings"] = android_settings
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["ios_settings"] = ios_settings
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["testing_options"] = testing_options
        __props__.__dict__["web_settings"] = web_settings
        return EnterpriseKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="androidSettings")
    def android_settings(self) -> pulumi.Output[Optional['outputs.EnterpriseKeyAndroidSettings']]:
        """
        Settings for keys that can be used by Android apps.
        """
        return pulumi.get(self, "android_settings")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The timestamp corresponding to the creation of this Key.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Human-readable display name of this key. Modifiable by user.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="iosSettings")
    def ios_settings(self) -> pulumi.Output[Optional['outputs.EnterpriseKeyIosSettings']]:
        """
        Settings for keys that can be used by iOS apps.
        """
        return pulumi.get(self, "ios_settings")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        See [Creating and managing labels](https://cloud.google.com/recaptcha-enterprise/docs/labels).
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name for the Key in the format "projects/{project}/keys/{key}".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="testingOptions")
    def testing_options(self) -> pulumi.Output[Optional['outputs.EnterpriseKeyTestingOptions']]:
        """
        Options for user acceptance testing.
        """
        return pulumi.get(self, "testing_options")

    @property
    @pulumi.getter(name="webSettings")
    def web_settings(self) -> pulumi.Output[Optional['outputs.EnterpriseKeyWebSettings']]:
        """
        Settings for keys that can be used by websites.
        """
        return pulumi.get(self, "web_settings")

