class Avatar(object):
    def handle_turn(self, avatar_state, world_map):
        from simulation.action import MoveAction
        from simulation import direction
        import random
        from simulation.action import WaitAction

        self.world_map = world_map
        self.avatar_state = avatar_state

        if world_map.get_cell(avatar_state.location).generates_score:
            return WaitAction()

        possible_directions = self.get_possible_directions()
        directions_to_emphasise = [d for d in possible_directions if self.is_towards(d, self.get_closest_score_location())]
        return MoveAction(random.choice(possible_directions + (directions_to_emphasise * 5)))

    def is_towards(self, direction, location):
        if location:
            return self.distance_between(self.avatar_state.location, location) > \
                self.distance_between(self.avatar_state.location + direction, location)
        else:
            return False

    def distance_between(self, a, b):
        return abs(a.x - b.x) + abs(a.y - b.y)

    def get_closest_score_location(self):
        score_cells = list(self.world_map.score_cells())
        if score_cells:
            return min(score_cells, key=lambda cell: self.distance_between(cell.location, self.avatar_state.location)).location
        else:
            return None

    def get_possible_directions(self):
        from simulation import direction
        directions = (direction.EAST, direction.SOUTH, direction.WEST, direction.NORTH)
        return [d for d in directions if self.world_map.can_move_to(self.avatar_state.location + d)]
