Module["preRun"].push((function() {
 var unityFileSystemInit = Module["unityFileSystemInit"] || (function() {
  if (!Module.indexedDB) {
   console.log("IndexedDB is not available. Data will not persist in cache and PlayerPrefs will not be saved.");
  }
  FS.mkdir("/idbfs");
  FS.mount(IDBFS, {}, "/idbfs");
  Module.addRunDependency("JS_FileSystem_Mount");
  FS.syncfs(true, (function(err) {
   Module.removeRunDependency("JS_FileSystem_Mount");
  }));
 });
 unityFileSystemInit();
}));
var MediaDevices = [];
Module["preRun"].push((function() {
 var enumerateMediaDevices = (function() {
  var getMedia = navigator.getUserMedia || navigator.webkitGetUserMedia || navigator.mozGetUserMedia || navigator.msGetUserMedia;
  if (!getMedia) return;
  function addDevice(label) {
   label = label ? label : "device #" + MediaDevices.length;
   var device = {
    deviceName: label,
    refCount: 0,
    video: null
   };
   MediaDevices.push(device);
  }
  if (!navigator.mediaDevices || !navigator.mediaDevices.enumerateDevices) {
   if (typeof MediaStreamTrack == "undefined" || typeof MediaStreamTrack.getSources == "undefined") {
    console.log("Media Devices cannot be enumerated on this browser.");
    return;
   }
   function gotSources(sourceInfos) {
    for (var i = 0; i !== sourceInfos.length; ++i) {
     var sourceInfo = sourceInfos[i];
     if (sourceInfo.kind === "video") addDevice(sourceInfo.label);
    }
   }
   MediaStreamTrack.getSources(gotSources);
  }
  navigator.mediaDevices.enumerateDevices().then((function(devices) {
   devices.forEach((function(device) {
    if (device.kind == "videoinput") addDevice(device.label);
   }));
  })).catch((function(err) {
   console.log(err.name + ": " + error.message);
  }));
 });
 enumerateMediaDevices();
}));
function SendMessage(gameObject, func, param) {
 if (param === undefined) Module.ccall("SendMessage", null, [ "string", "string" ], [ gameObject, func ]); else if (typeof param === "string") Module.ccall("SendMessageString", null, [ "string", "string", "string" ], [ gameObject, func, param ]); else if (typeof param === "number") Module.ccall("SendMessageFloat", null, [ "string", "string", "number" ], [ gameObject, func, param ]); else throw "" + param + " is does not have a type which is supported by SendMessage.";
}
Module["SendMessage"] = SendMessage;
var Module;
if (!Module) Module = (typeof Module !== "undefined" ? Module : null) || {};
var moduleOverrides = {};
for (var key in Module) {
 if (Module.hasOwnProperty(key)) {
  moduleOverrides[key] = Module[key];
 }
}
var ENVIRONMENT_IS_WEB = false;
var ENVIRONMENT_IS_WORKER = false;
var ENVIRONMENT_IS_NODE = false;
var ENVIRONMENT_IS_SHELL = false;
if (Module["ENVIRONMENT"]) {
 if (Module["ENVIRONMENT"] === "WEB") {
  ENVIRONMENT_IS_WEB = true;
 } else if (Module["ENVIRONMENT"] === "WORKER") {
  ENVIRONMENT_IS_WORKER = true;
 } else if (Module["ENVIRONMENT"] === "NODE") {
  ENVIRONMENT_IS_NODE = true;
 } else if (Module["ENVIRONMENT"] === "SHELL") {
  ENVIRONMENT_IS_SHELL = true;
 } else {
  throw new Error("The provided Module['ENVIRONMENT'] value is not valid. It must be one of: WEB|WORKER|NODE|SHELL.");
 }
} else {
 ENVIRONMENT_IS_WEB = typeof window === "object";
 ENVIRONMENT_IS_WORKER = typeof importScripts === "function";
 ENVIRONMENT_IS_NODE = typeof process === "object" && typeof require === "function" && !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_WORKER;
 ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;
}
if (ENVIRONMENT_IS_NODE) {
 if (!Module["print"]) Module["print"] = console.log;
 if (!Module["printErr"]) Module["printErr"] = console.warn;
 var nodeFS;
 var nodePath;
 Module["read"] = function read(filename, binary) {
  if (!nodeFS) nodeFS = require("fs");
  if (!nodePath) nodePath = require("path");
  filename = nodePath["normalize"](filename);
  var ret = nodeFS["readFileSync"](filename);
  return binary ? ret : ret.toString();
 };
 Module["readBinary"] = function readBinary(filename) {
  var ret = Module["read"](filename, true);
  if (!ret.buffer) {
   ret = new Uint8Array(ret);
  }
  assert(ret.buffer);
  return ret;
 };
 Module["load"] = function load(f) {
  globalEval(read(f));
 };
 if (!Module["thisProgram"]) {
  if (process["argv"].length > 1) {
   Module["thisProgram"] = process["argv"][1].replace(/\\/g, "/");
  } else {
   Module["thisProgram"] = "unknown-program";
  }
 }
 Module["arguments"] = process["argv"].slice(2);
 if (typeof module !== "undefined") {
  module["exports"] = Module;
 }
 process["on"]("uncaughtException", (function(ex) {
  if (!(ex instanceof ExitStatus)) {
   throw ex;
  }
 }));
 Module["inspect"] = (function() {
  return "[Emscripten Module object]";
 });
} else if (ENVIRONMENT_IS_SHELL) {
 if (!Module["print"]) Module["print"] = print;
 if (typeof printErr != "undefined") Module["printErr"] = printErr;
 if (typeof read != "undefined") {
  Module["read"] = read;
 } else {
  Module["read"] = function read() {
   throw "no read() available (jsc?)";
  };
 }
 Module["readBinary"] = function readBinary(f) {
  if (typeof readbuffer === "function") {
   return new Uint8Array(readbuffer(f));
  }
  var data = read(f, "binary");
  assert(typeof data === "object");
  return data;
 };
 if (typeof scriptArgs != "undefined") {
  Module["arguments"] = scriptArgs;
 } else if (typeof arguments != "undefined") {
  Module["arguments"] = arguments;
 }
} else if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
 Module["read"] = function read(url) {
  var xhr = new XMLHttpRequest;
  xhr.open("GET", url, false);
  xhr.send(null);
  return xhr.responseText;
 };
 Module["readAsync"] = function readAsync(url, onload, onerror) {
  var xhr = new XMLHttpRequest;
  xhr.open("GET", url, true);
  xhr.responseType = "arraybuffer";
  xhr.onload = function xhr_onload() {
   if (xhr.status == 200 || xhr.status == 0 && xhr.response) {
    onload(xhr.response);
   } else {
    onerror();
   }
  };
  xhr.onerror = onerror;
  xhr.send(null);
 };
 if (typeof arguments != "undefined") {
  Module["arguments"] = arguments;
 }
 if (typeof console !== "undefined") {
  if (!Module["print"]) Module["print"] = function print(x) {
   console.log(x);
  };
  if (!Module["printErr"]) Module["printErr"] = function printErr(x) {
   console.warn(x);
  };
 } else {
  var TRY_USE_DUMP = false;
  if (!Module["print"]) Module["print"] = TRY_USE_DUMP && typeof dump !== "undefined" ? (function(x) {
   dump(x);
  }) : (function(x) {});
 }
 if (ENVIRONMENT_IS_WORKER) {
  Module["load"] = importScripts;
 }
 if (typeof Module["setWindowTitle"] === "undefined") {
  Module["setWindowTitle"] = (function(title) {
   document.title = title;
  });
 }
} else {
 throw "Unknown runtime environment. Where are we?";
}
function globalEval(x) {
 eval.call(null, x);
}
if (!Module["load"] && Module["read"]) {
 Module["load"] = function load(f) {
  globalEval(Module["read"](f));
 };
}
if (!Module["print"]) {
 Module["print"] = (function() {});
}
if (!Module["printErr"]) {
 Module["printErr"] = Module["print"];
}
if (!Module["arguments"]) {
 Module["arguments"] = [];
}
if (!Module["thisProgram"]) {
 Module["thisProgram"] = "./this.program";
}
Module.print = Module["print"];
Module.printErr = Module["printErr"];
Module["preRun"] = [];
Module["postRun"] = [];
for (var key in moduleOverrides) {
 if (moduleOverrides.hasOwnProperty(key)) {
  Module[key] = moduleOverrides[key];
 }
}
moduleOverrides = undefined;
var Runtime = {
 setTempRet0: (function(x) {
  Runtime.tempRet0 = x;
 }),
 getTempRet0: (function() {
  return Runtime.tempRet0;
 }),
 stackSave: (function() {
  return STACKTOP;
 }),
 stackRestore: (function(stackTop) {
  STACKTOP = stackTop;
 }),
 getNativeTypeSize: (function(type) {
  switch (type) {
  case "i1":
  case "i8":
   return 1;
  case "i16":
   return 2;
  case "i32":
   return 4;
  case "i64":
   return 8;
  case "float":
   return 4;
  case "double":
   return 8;
  default:
   {
    if (type[type.length - 1] === "*") {
     return Runtime.QUANTUM_SIZE;
    } else if (type[0] === "i") {
     var bits = parseInt(type.substr(1));
     assert(bits % 8 === 0);
     return bits / 8;
    } else {
     return 0;
    }
   }
  }
 }),
 getNativeFieldSize: (function(type) {
  return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE);
 }),
 STACK_ALIGN: 16,
 prepVararg: (function(ptr, type) {
  if (type === "double" || type === "i64") {
   if (ptr & 7) {
    assert((ptr & 7) === 4);
    ptr += 4;
   }
  } else {
   assert((ptr & 3) === 0);
  }
  return ptr;
 }),
 getAlignSize: (function(type, size, vararg) {
  if (!vararg && (type == "i64" || type == "double")) return 8;
  if (!type) return Math.min(size, 8);
  return Math.min(size || (type ? Runtime.getNativeFieldSize(type) : 0), Runtime.QUANTUM_SIZE);
 }),
 dynCall: (function(sig, ptr, args) {
  if (args && args.length) {
   assert(args.length == sig.length - 1);
   assert("dynCall_" + sig in Module, "bad function pointer type - no table for sig '" + sig + "'");
   return Module["dynCall_" + sig].apply(null, [ ptr ].concat(args));
  } else {
   assert(sig.length == 1);
   assert("dynCall_" + sig in Module, "bad function pointer type - no table for sig '" + sig + "'");
   return Module["dynCall_" + sig].call(null, ptr);
  }
 }),
 getFunctionTables: (function(module) {
  if (!module) module = Module;
  var tables = {};
  for (var t in module) {
   if (/^FUNCTION_TABLE_.*/.test(t)) {
    var table = module[t];
    if (typeof table === "object") tables[t.substr("FUNCTION_TABLE_".length)] = table;
   }
  }
  return tables;
 }),
 alignFunctionTables: (function(module) {
  var tables = Runtime.getFunctionTables(module);
  var maxx = 0;
  for (var sig in tables) {
   maxx = Math.max(maxx, tables[sig].length);
  }
  assert(maxx >= 0);
  for (var sig in tables) {
   var table = tables[sig];
   while (table.length < maxx) table.push(0);
  }
  return maxx;
 }),
 registerFunctions: (function(sigs, newModule) {
  sigs.forEach((function(sig) {
   if (!Module["FUNCTION_TABLE_" + sig]) {
    Module["FUNCTION_TABLE_" + sig] = [];
   }
  }));
  var oldMaxx = Runtime.alignFunctionTables();
  var newMaxx = Runtime.alignFunctionTables(newModule);
  var maxx = oldMaxx + newMaxx;
  sigs.forEach((function(sig) {
   var newTable = newModule["FUNCTION_TABLE_" + sig];
   var oldTable = Module["FUNCTION_TABLE_" + sig];
   assert(newTable !== oldTable);
   assert(oldTable.length === oldMaxx);
   for (var i = 0; i < newTable.length; i++) {
    oldTable.push(newTable[i]);
   }
   assert(oldTable.length === maxx);
  }));
  assert(maxx === Runtime.alignFunctionTables());
 }),
 functionPointers: [],
 addFunction: (function(func) {
  Runtime.alignFunctionTables();
  var tables = Runtime.getFunctionTables();
  var ret = -1;
  for (var sig in tables) {
   var table = tables[sig];
   if (ret < 0) ret = table.length; else assert(ret === table.length);
   table.push(func);
  }
  return ret;
 }),
 removeFunction: (function(index) {
  Runtime.alignFunctionTables();
  var tables = Runtime.getFunctionTables();
  for (var sig in tables) {
   tables[sig][index] = null;
  }
 }),
 loadedDynamicLibraries: [],
 loadDynamicLibrary: (function(lib) {
  var src = Module["read"](lib);
  var libModule = eval(src)(Runtime.alignFunctionTables(), Module);
  for (var sym in libModule) {
   if (!Module.hasOwnProperty(sym)) {
    Module[sym] = libModule[sym];
   }
  }
  Runtime.loadedDynamicLibraries.push(libModule);
 }),
 warnOnce: (function(text) {
  if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
  if (!Runtime.warnOnce.shown[text]) {
   Runtime.warnOnce.shown[text] = 1;
   Module.printErr(text);
  }
 }),
 funcWrappers: {},
 getFuncWrapper: (function(func, sig) {
  assert(sig);
  if (!Runtime.funcWrappers[sig]) {
   Runtime.funcWrappers[sig] = {};
  }
  var sigCache = Runtime.funcWrappers[sig];
  if (!sigCache[func]) {
   if (sig.length === 1) {
    sigCache[func] = function dynCall_wrapper() {
     return Runtime.dynCall(sig, func);
    };
   } else if (sig.length === 2) {
    sigCache[func] = function dynCall_wrapper(arg) {
     return Runtime.dynCall(sig, func, [ arg ]);
    };
   } else {
    sigCache[func] = function dynCall_wrapper() {
     return Runtime.dynCall(sig, func, Array.prototype.slice.call(arguments));
    };
   }
  }
  return sigCache[func];
 }),
 getCompilerSetting: (function(name) {
  throw "You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work";
 }),
 stackAlloc: (function(size) {
  var ret = STACKTOP;
  STACKTOP = STACKTOP + size | 0;
  STACKTOP = STACKTOP + 15 & -16;
  assert((STACKTOP | 0) < (STACK_MAX | 0) | 0) | 0;
  return ret;
 }),
 staticAlloc: (function(size) {
  var ret = STATICTOP;
  STATICTOP = STATICTOP + (assert(!staticSealed), size) | 0;
  STATICTOP = STATICTOP + 15 & -16;
  return ret;
 }),
 dynamicAlloc: (function(size) {
  var ret = DYNAMICTOP;
  DYNAMICTOP = DYNAMICTOP + (assert(DYNAMICTOP > 0), size) | 0;
  DYNAMICTOP = DYNAMICTOP + 15 & -16;
  if (DYNAMICTOP >= TOTAL_MEMORY) {
   var success = enlargeMemory();
   if (!success) {
    DYNAMICTOP = ret;
    return 0;
   }
  }
  return ret;
 }),
 alignMemory: (function(size, quantum) {
  var ret = size = Math.ceil(size / (quantum ? quantum : 16)) * (quantum ? quantum : 16);
  return ret;
 }),
 makeBigInt: (function(low, high, unsigned) {
  var ret = unsigned ? +(low >>> 0) + +(high >>> 0) * +4294967296 : +(low >>> 0) + +(high | 0) * +4294967296;
  return ret;
 }),
 tempRet0: 0,
 GLOBAL_BASE: 8,
 QUANTUM_SIZE: 4,
 __dummy__: 0
};
Runtime.GLOBAL_BASE = Runtime.alignMemory(Runtime.GLOBAL_BASE, 16);
Module["Runtime"] = Runtime;
var ABORT = false;
var EXITSTATUS = 0;
function assert(condition, text) {
 if (!condition) {
  abort("Assertion failed: " + text);
 }
}
function getCFunc(ident) {
 var func = Module["_" + ident];
 if (!func) {
  try {
   func = eval("_" + ident);
  } catch (e) {}
 }
 assert(func, "Cannot call unknown function " + ident + " (perhaps LLVM optimizations or closure removed it?)");
 return func;
}
var cwrap, ccall;
((function() {
 var JSfuncs = {
  "stackSave": (function() {
   Runtime.stackSave();
  }),
  "stackRestore": (function() {
   Runtime.stackRestore();
  }),
  "arrayToC": (function(arr) {
   var ret = Runtime.stackAlloc(arr.length);
   writeArrayToMemory(arr, ret);
   return ret;
  }),
  "stringToC": (function(str) {
   var ret = 0;
   if (str !== null && str !== undefined && str !== 0) {
    ret = Runtime.stackAlloc((str.length << 2) + 1);
    writeStringToMemory(str, ret);
   }
   return ret;
  })
 };
 var toC = {
  "string": JSfuncs["stringToC"],
  "array": JSfuncs["arrayToC"]
 };
 ccall = function ccallFunc(ident, returnType, argTypes, args, opts) {
  var func = getCFunc(ident);
  var cArgs = [];
  var stack = 0;
  assert(returnType !== "array", 'Return type should not be "array".');
  if (args) {
   for (var i = 0; i < args.length; i++) {
    var converter = toC[argTypes[i]];
    if (converter) {
     if (stack === 0) stack = Runtime.stackSave();
     cArgs[i] = converter(args[i]);
    } else {
     cArgs[i] = args[i];
    }
   }
  }
  var ret = func.apply(null, cArgs);
  if ((!opts || !opts.async) && typeof EmterpreterAsync === "object") {
   assert(!EmterpreterAsync.state, "cannot start async op with normal JS calling ccall");
  }
  if (opts && opts.async) assert(!returnType, "async ccalls cannot return values");
  if (returnType === "string") ret = Pointer_stringify(ret);
  if (stack !== 0) {
   if (opts && opts.async) {
    EmterpreterAsync.asyncFinalizers.push((function() {
     Runtime.stackRestore(stack);
    }));
    return;
   }
   Runtime.stackRestore(stack);
  }
  return ret;
 };
 var sourceRegex = /^function\s*[a-zA-Z$_0-9]*\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;
 function parseJSFunc(jsfunc) {
  var parsed = jsfunc.toString().match(sourceRegex).slice(1);
  return {
   arguments: parsed[0],
   body: parsed[1],
   returnValue: parsed[2]
  };
 }
 var JSsource = null;
 function ensureJSsource() {
  if (!JSsource) {
   JSsource = {};
   for (var fun in JSfuncs) {
    if (JSfuncs.hasOwnProperty(fun)) {
     JSsource[fun] = parseJSFunc(JSfuncs[fun]);
    }
   }
  }
 }
 cwrap = function cwrap(ident, returnType, argTypes) {
  argTypes = argTypes || [];
  var cfunc = getCFunc(ident);
  var numericArgs = argTypes.every((function(type) {
   return type === "number";
  }));
  var numericRet = returnType !== "string";
  if (numericRet && numericArgs) {
   return cfunc;
  }
  var argNames = argTypes.map((function(x, i) {
   return "$" + i;
  }));
  var funcstr = "(function(" + argNames.join(",") + ") {";
  var nargs = argTypes.length;
  if (!numericArgs) {
   ensureJSsource();
   funcstr += "var stack = " + JSsource["stackSave"].body + ";";
   for (var i = 0; i < nargs; i++) {
    var arg = argNames[i], type = argTypes[i];
    if (type === "number") continue;
    var convertCode = JSsource[type + "ToC"];
    funcstr += "var " + convertCode.arguments + " = " + arg + ";";
    funcstr += convertCode.body + ";";
    funcstr += arg + "=(" + convertCode.returnValue + ");";
   }
  }
  var cfuncname = parseJSFunc((function() {
   return cfunc;
  })).returnValue;
  funcstr += "var ret = " + cfuncname + "(" + argNames.join(",") + ");";
  if (!numericRet) {
   var strgfy = parseJSFunc((function() {
    return Pointer_stringify;
   })).returnValue;
   funcstr += "ret = " + strgfy + "(ret);";
  }
  funcstr += "if (typeof EmterpreterAsync === 'object') { assert(!EmterpreterAsync.state, 'cannot start async op with normal JS calling cwrap') }";
  if (!numericArgs) {
   ensureJSsource();
   funcstr += JSsource["stackRestore"].body.replace("()", "(stack)") + ";";
  }
  funcstr += "return ret})";
  return eval(funcstr);
 };
}))();
Module["ccall"] = ccall;
Module["cwrap"] = cwrap;
function setValue(ptr, value, type, noSafe) {
 type = type || "i8";
 if (type.charAt(type.length - 1) === "*") type = "i32";
 switch (type) {
 case "i1":
  HEAP8[ptr >> 0] = value;
  break;
 case "i8":
  HEAP8[ptr >> 0] = value;
  break;
 case "i16":
  HEAP16[ptr >> 1] = value;
  break;
 case "i32":
  HEAP32[ptr >> 2] = value;
  break;
 case "i64":
  tempI64 = [ value >>> 0, (tempDouble = value, +Math_abs(tempDouble) >= +1 ? tempDouble > +0 ? (Math_min(+Math_floor(tempDouble / +4294967296), +4294967295) | 0) >>> 0 : ~~+Math_ceil((tempDouble - +(~~tempDouble >>> 0)) / +4294967296) >>> 0 : 0) ], HEAP32[ptr >> 2] = tempI64[0], HEAP32[ptr + 4 >> 2] = tempI64[1];
  break;
 case "float":
  HEAPF32[ptr >> 2] = value;
  break;
 case "double":
  HEAPF64[ptr >> 3] = value;
  break;
 default:
  abort("invalid type for setValue: " + type);
 }
}
Module["setValue"] = setValue;
function getValue(ptr, type, noSafe) {
 type = type || "i8";
 if (type.charAt(type.length - 1) === "*") type = "i32";
 switch (type) {
 case "i1":
  return HEAP8[ptr >> 0];
 case "i8":
  return HEAP8[ptr >> 0];
 case "i16":
  return HEAP16[ptr >> 1];
 case "i32":
  return HEAP32[ptr >> 2];
 case "i64":
  return HEAP32[ptr >> 2];
 case "float":
  return HEAPF32[ptr >> 2];
 case "double":
  return HEAPF64[ptr >> 3];
 default:
  abort("invalid type for setValue: " + type);
 }
 return null;
}
Module["getValue"] = getValue;
var ALLOC_NORMAL = 0;
var ALLOC_STACK = 1;
var ALLOC_STATIC = 2;
var ALLOC_DYNAMIC = 3;
var ALLOC_NONE = 4;
Module["ALLOC_NORMAL"] = ALLOC_NORMAL;
Module["ALLOC_STACK"] = ALLOC_STACK;
Module["ALLOC_STATIC"] = ALLOC_STATIC;
Module["ALLOC_DYNAMIC"] = ALLOC_DYNAMIC;
Module["ALLOC_NONE"] = ALLOC_NONE;
function allocate(slab, types, allocator, ptr) {
 var zeroinit, size;
 if (typeof slab === "number") {
  zeroinit = true;
  size = slab;
 } else {
  zeroinit = false;
  size = slab.length;
 }
 var singleType = typeof types === "string" ? types : null;
 var ret;
 if (allocator == ALLOC_NONE) {
  ret = ptr;
 } else {
  ret = [ typeof _malloc === "function" ? _malloc : Runtime.staticAlloc, Runtime.stackAlloc, Runtime.staticAlloc, Runtime.dynamicAlloc ][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
 }
 if (zeroinit) {
  var ptr = ret, stop;
  assert((ret & 3) == 0);
  stop = ret + (size & ~3);
  for (; ptr < stop; ptr += 4) {
   HEAP32[ptr >> 2] = 0;
  }
  stop = ret + size;
  while (ptr < stop) {
   HEAP8[ptr++ >> 0] = 0;
  }
  return ret;
 }
 if (singleType === "i8") {
  if (slab.subarray || slab.slice) {
   HEAPU8.set(slab, ret);
  } else {
   HEAPU8.set(new Uint8Array(slab), ret);
  }
  return ret;
 }
 var i = 0, type, typeSize, previousType;
 while (i < size) {
  var curr = slab[i];
  if (typeof curr === "function") {
   curr = Runtime.getFunctionIndex(curr);
  }
  type = singleType || types[i];
  if (type === 0) {
   i++;
   continue;
  }
  assert(type, "Must know what type to store in allocate!");
  if (type == "i64") type = "i32";
  setValue(ret + i, curr, type);
  if (previousType !== type) {
   typeSize = Runtime.getNativeTypeSize(type);
   previousType = type;
  }
  i += typeSize;
 }
 return ret;
}
Module["allocate"] = allocate;
function getMemory(size) {
 if (!staticSealed) return Runtime.staticAlloc(size);
 if (typeof _sbrk !== "undefined" && !_sbrk.called || !runtimeInitialized) return Runtime.dynamicAlloc(size);
 return _malloc(size);
}
Module["getMemory"] = getMemory;
function Pointer_stringify(ptr, length) {
 if (length === 0 || !ptr) return "";
 var hasUtf = 0;
 var t;
 var i = 0;
 while (1) {
  assert(ptr + i < TOTAL_MEMORY);
  t = HEAPU8[ptr + i >> 0];
  hasUtf |= t;
  if (t == 0 && !length) break;
  i++;
  if (length && i == length) break;
 }
 if (!length) length = i;
 var ret = "";
 if (hasUtf < 128) {
  var MAX_CHUNK = 1024;
  var curr;
  while (length > 0) {
   curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
   ret = ret ? ret + curr : curr;
   ptr += MAX_CHUNK;
   length -= MAX_CHUNK;
  }
  return ret;
 }
 return Module["UTF8ToString"](ptr);
}
Module["Pointer_stringify"] = Pointer_stringify;
function AsciiToString(ptr) {
 var str = "";
 while (1) {
  var ch = HEAP8[ptr++ >> 0];
  if (!ch) return str;
  str += String.fromCharCode(ch);
 }
}
Module["AsciiToString"] = AsciiToString;
function stringToAscii(str, outPtr) {
 return writeAsciiToMemory(str, outPtr, false);
}
Module["stringToAscii"] = stringToAscii;
var UTF8Decoder = typeof TextDecoder !== "undefined" ? new TextDecoder("utf8") : undefined;
function UTF8ArrayToString(u8Array, idx) {
 var endPtr = idx;
 while (u8Array[endPtr]) ++endPtr;
 if (endPtr - idx > 16 && u8Array.subarray && UTF8Decoder) {
  return UTF8Decoder.decode(u8Array.subarray(idx, endPtr));
 } else {
  var u0, u1, u2, u3, u4, u5;
  var str = "";
  while (1) {
   u0 = u8Array[idx++];
   if (!u0) return str;
   if (!(u0 & 128)) {
    str += String.fromCharCode(u0);
    continue;
   }
   u1 = u8Array[idx++] & 63;
   if ((u0 & 224) == 192) {
    str += String.fromCharCode((u0 & 31) << 6 | u1);
    continue;
   }
   u2 = u8Array[idx++] & 63;
   if ((u0 & 240) == 224) {
    u0 = (u0 & 15) << 12 | u1 << 6 | u2;
   } else {
    u3 = u8Array[idx++] & 63;
    if ((u0 & 248) == 240) {
     u0 = (u0 & 7) << 18 | u1 << 12 | u2 << 6 | u3;
    } else {
     u4 = u8Array[idx++] & 63;
     if ((u0 & 252) == 248) {
      u0 = (u0 & 3) << 24 | u1 << 18 | u2 << 12 | u3 << 6 | u4;
     } else {
      u5 = u8Array[idx++] & 63;
      u0 = (u0 & 1) << 30 | u1 << 24 | u2 << 18 | u3 << 12 | u4 << 6 | u5;
     }
    }
   }
   if (u0 < 65536) {
    str += String.fromCharCode(u0);
   } else {
    var ch = u0 - 65536;
    str += String.fromCharCode(55296 | ch >> 10, 56320 | ch & 1023);
   }
  }
 }
}
Module["UTF8ArrayToString"] = UTF8ArrayToString;
function UTF8ToString(ptr) {
 return UTF8ArrayToString(HEAPU8, ptr);
}
Module["UTF8ToString"] = UTF8ToString;
function stringToUTF8Array(str, outU8Array, outIdx, maxBytesToWrite) {
 if (!(maxBytesToWrite > 0)) return 0;
 var startIdx = outIdx;
 var endIdx = outIdx + maxBytesToWrite - 1;
 for (var i = 0; i < str.length; ++i) {
  var u = str.charCodeAt(i);
  if (u >= 55296 && u <= 57343) u = 65536 + ((u & 1023) << 10) | str.charCodeAt(++i) & 1023;
  if (u <= 127) {
   if (outIdx >= endIdx) break;
   outU8Array[outIdx++] = u;
  } else if (u <= 2047) {
   if (outIdx + 1 >= endIdx) break;
   outU8Array[outIdx++] = 192 | u >> 6;
   outU8Array[outIdx++] = 128 | u & 63;
  } else if (u <= 65535) {
   if (outIdx + 2 >= endIdx) break;
   outU8Array[outIdx++] = 224 | u >> 12;
   outU8Array[outIdx++] = 128 | u >> 6 & 63;
   outU8Array[outIdx++] = 128 | u & 63;
  } else if (u <= 2097151) {
   if (outIdx + 3 >= endIdx) break;
   outU8Array[outIdx++] = 240 | u >> 18;
   outU8Array[outIdx++] = 128 | u >> 12 & 63;
   outU8Array[outIdx++] = 128 | u >> 6 & 63;
   outU8Array[outIdx++] = 128 | u & 63;
  } else if (u <= 67108863) {
   if (outIdx + 4 >= endIdx) break;
   outU8Array[outIdx++] = 248 | u >> 24;
   outU8Array[outIdx++] = 128 | u >> 18 & 63;
   outU8Array[outIdx++] = 128 | u >> 12 & 63;
   outU8Array[outIdx++] = 128 | u >> 6 & 63;
   outU8Array[outIdx++] = 128 | u & 63;
  } else {
   if (outIdx + 5 >= endIdx) break;
   outU8Array[outIdx++] = 252 | u >> 30;
   outU8Array[outIdx++] = 128 | u >> 24 & 63;
   outU8Array[outIdx++] = 128 | u >> 18 & 63;
   outU8Array[outIdx++] = 128 | u >> 12 & 63;
   outU8Array[outIdx++] = 128 | u >> 6 & 63;
   outU8Array[outIdx++] = 128 | u & 63;
  }
 }
 outU8Array[outIdx] = 0;
 return outIdx - startIdx;
}
Module["stringToUTF8Array"] = stringToUTF8Array;
function stringToUTF8(str, outPtr, maxBytesToWrite) {
 assert(typeof maxBytesToWrite == "number", "stringToUTF8(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!");
 return stringToUTF8Array(str, HEAPU8, outPtr, maxBytesToWrite);
}
Module["stringToUTF8"] = stringToUTF8;
function lengthBytesUTF8(str) {
 var len = 0;
 for (var i = 0; i < str.length; ++i) {
  var u = str.charCodeAt(i);
  if (u >= 55296 && u <= 57343) u = 65536 + ((u & 1023) << 10) | str.charCodeAt(++i) & 1023;
  if (u <= 127) {
   ++len;
  } else if (u <= 2047) {
   len += 2;
  } else if (u <= 65535) {
   len += 3;
  } else if (u <= 2097151) {
   len += 4;
  } else if (u <= 67108863) {
   len += 5;
  } else {
   len += 6;
  }
 }
 return len;
}
Module["lengthBytesUTF8"] = lengthBytesUTF8;
var UTF16Decoder = typeof TextDecoder !== "undefined" ? new TextDecoder("utf-16le") : undefined;
function demangle(func) {
 var hasLibcxxabi = !!Module["___cxa_demangle"];
 if (hasLibcxxabi) {
  try {
   var buf = _malloc(func.length);
   writeStringToMemory(func.substr(1), buf);
   var status = _malloc(4);
   var ret = Module["___cxa_demangle"](buf, 0, 0, status);
   if (getValue(status, "i32") === 0 && ret) {
    return Pointer_stringify(ret);
   }
  } catch (e) {} finally {
   if (buf) _free(buf);
   if (status) _free(status);
   if (ret) _free(ret);
  }
  return func;
 }
 Runtime.warnOnce("warning: build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling");
 return func;
}
function demangleAll(text) {
 return text.replace(/__Z[\w\d_]+/g, (function(x) {
  var y = demangle(x);
  return x === y ? x : x + " [" + y + "]";
 }));
}
function jsStackTrace() {
 var err = new Error;
 if (!err.stack) {
  try {
   throw new Error(0);
  } catch (e) {
   err = e;
  }
  if (!err.stack) {
   return "(no stack trace available)";
  }
 }
 return err.stack.toString();
}
function stackTrace() {
 var js = jsStackTrace();
 if (Module["extraStackTrace"]) js += "\n" + Module["extraStackTrace"]();
 return demangleAll(js);
}
Module["stackTrace"] = stackTrace;
var PAGE_SIZE = 4096;
function alignMemoryPage(x) {
 if (x % 4096 > 0) {
  x += 4096 - x % 4096;
 }
 return x;
}
var HEAP;
var buffer;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;
function updateGlobalBufferViews() {
 Module["HEAP8"] = HEAP8 = new Int8Array(buffer);
 Module["HEAP16"] = HEAP16 = new Int16Array(buffer);
 Module["HEAP32"] = HEAP32 = new Int32Array(buffer);
 Module["HEAPU8"] = HEAPU8 = new Uint8Array(buffer);
 Module["HEAPU16"] = HEAPU16 = new Uint16Array(buffer);
 Module["HEAPU32"] = HEAPU32 = new Uint32Array(buffer);
 Module["HEAPF32"] = HEAPF32 = new Float32Array(buffer);
 Module["HEAPF64"] = HEAPF64 = new Float64Array(buffer);
}
var STATIC_BASE = 0, STATICTOP = 0, staticSealed = false;
var STACK_BASE = 0, STACKTOP = 0, STACK_MAX = 0;
var DYNAMIC_BASE = 0, DYNAMICTOP = 0;
function writeStackCookie() {
 assert((STACK_MAX & 3) == 0);
 HEAPU32[(STACK_MAX >> 2) - 1] = 34821223;
 HEAPU32[(STACK_MAX >> 2) - 2] = 2310721022;
}
function checkStackCookie() {
 if (HEAPU32[(STACK_MAX >> 2) - 1] != 34821223 || HEAPU32[(STACK_MAX >> 2) - 2] != 2310721022) {
  abort("Stack overflow! Stack cookie has been overwritten, expected hex dwords 0x89BACDFE and 0x02135467, but received 0x" + HEAPU32[(STACK_MAX >> 2) - 2].toString(16) + " " + HEAPU32[(STACK_MAX >> 2) - 1].toString(16));
 }
 if (HEAP32[0] !== 1668509029) throw "Runtime error: The application has corrupted its heap memory area (address zero)!";
}
function abortStackOverflow(allocSize) {
 abort("Stack overflow! Attempted to allocate " + allocSize + " bytes on the stack, but stack has only " + (STACK_MAX - asm.stackSave() + allocSize) + " bytes available!");
}
function abortOnCannotGrowMemory() {
 abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value " + TOTAL_MEMORY + ", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which adjusts the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ");
}
function enlargeMemory() {
 abortOnCannotGrowMemory();
}
var TOTAL_STACK = Module["TOTAL_STACK"] || 5242880;
var TOTAL_MEMORY = Module["TOTAL_MEMORY"] || 16777216;
var totalMemory = 64 * 1024;
while (totalMemory < TOTAL_MEMORY || totalMemory < 2 * TOTAL_STACK) {
 if (totalMemory < 16 * 1024 * 1024) {
  totalMemory *= 2;
 } else {
  totalMemory += 16 * 1024 * 1024;
 }
}
if (totalMemory !== TOTAL_MEMORY) {
 Module.printErr("increasing TOTAL_MEMORY to " + totalMemory + " to be compliant with the asm.js spec (and given that TOTAL_STACK=" + TOTAL_STACK + ")");
 TOTAL_MEMORY = totalMemory;
}
assert(typeof Int32Array !== "undefined" && typeof Float64Array !== "undefined" && !!(new Int32Array(1))["subarray"] && !!(new Int32Array(1))["set"], "JS engine does not provide full typed array support");
if (Module["buffer"]) {
 buffer = Module["buffer"];
 assert(buffer.byteLength === TOTAL_MEMORY, "provided buffer should be " + TOTAL_MEMORY + " bytes, but it is " + buffer.byteLength);
} else {
 buffer = new ArrayBuffer(TOTAL_MEMORY);
}
updateGlobalBufferViews();
HEAP32[0] = 1668509029;
HEAP16[1] = 25459;
if (HEAPU8[2] !== 115 || HEAPU8[3] !== 99) throw "Runtime error: expected the system to be little-endian!";
Module["HEAP"] = HEAP;
Module["buffer"] = buffer;
Module["HEAP8"] = HEAP8;
Module["HEAP16"] = HEAP16;
Module["HEAP32"] = HEAP32;
Module["HEAPU8"] = HEAPU8;
Module["HEAPU16"] = HEAPU16;
Module["HEAPU32"] = HEAPU32;
Module["HEAPF32"] = HEAPF32;
Module["HEAPF64"] = HEAPF64;
function callRuntimeCallbacks(callbacks) {
 while (callbacks.length > 0) {
  var callback = callbacks.shift();
  if (typeof callback == "function") {
   callback();
   continue;
  }
  var func = callback.func;
  if (typeof func === "number") {
   if (callback.arg === undefined) {
    Runtime.dynCall("v", func);
   } else {
    Runtime.dynCall("vi", func, [ callback.arg ]);
   }
  } else {
   func(callback.arg === undefined ? null : callback.arg);
  }
 }
}
var __ATPRERUN__ = [];
var __ATINIT__ = [];
var __ATMAIN__ = [];
var __ATEXIT__ = [];
var __ATPOSTRUN__ = [];
var runtimeInitialized = false;
var runtimeExited = false;
function preRun() {
 if (Module["preRun"]) {
  if (typeof Module["preRun"] == "function") Module["preRun"] = [ Module["preRun"] ];
  while (Module["preRun"].length) {
   addOnPreRun(Module["preRun"].shift());
  }
 }
 callRuntimeCallbacks(__ATPRERUN__);
}
function ensureInitRuntime() {
 checkStackCookie();
 if (runtimeInitialized) return;
 runtimeInitialized = true;
 callRuntimeCallbacks(__ATINIT__);
}
function preMain() {
 checkStackCookie();
 callRuntimeCallbacks(__ATMAIN__);
}
function exitRuntime() {
 checkStackCookie();
 callRuntimeCallbacks(__ATEXIT__);
 runtimeExited = true;
}
function postRun() {
 checkStackCookie();
 if (Module["postRun"]) {
  if (typeof Module["postRun"] == "function") Module["postRun"] = [ Module["postRun"] ];
  while (Module["postRun"].length) {
   addOnPostRun(Module["postRun"].shift());
  }
 }
 callRuntimeCallbacks(__ATPOSTRUN__);
}
function addOnPreRun(cb) {
 __ATPRERUN__.unshift(cb);
}
Module["addOnPreRun"] = addOnPreRun;
function addOnInit(cb) {
 __ATINIT__.unshift(cb);
}
Module["addOnInit"] = addOnInit;
function addOnPreMain(cb) {
 __ATMAIN__.unshift(cb);
}
Module["addOnPreMain"] = addOnPreMain;
function addOnExit(cb) {
 __ATEXIT__.unshift(cb);
}
Module["addOnExit"] = addOnExit;
function addOnPostRun(cb) {
 __ATPOSTRUN__.unshift(cb);
}
Module["addOnPostRun"] = addOnPostRun;
function intArrayFromString(stringy, dontAddNull, length) {
 var len = length > 0 ? length : lengthBytesUTF8(stringy) + 1;
 var u8array = new Array(len);
 var numBytesWritten = stringToUTF8Array(stringy, u8array, 0, u8array.length);
 if (dontAddNull) u8array.length = numBytesWritten;
 return u8array;
}
Module["intArrayFromString"] = intArrayFromString;
function intArrayToString(array) {
 var ret = [];
 for (var i = 0; i < array.length; i++) {
  var chr = array[i];
  if (chr > 255) {
   assert(false, "Character code " + chr + " (" + String.fromCharCode(chr) + ")  at offset " + i + " not in 0x00-0xFF.");
   chr &= 255;
  }
  ret.push(String.fromCharCode(chr));
 }
 return ret.join("");
}
Module["intArrayToString"] = intArrayToString;
function writeStringToMemory(string, buffer, dontAddNull) {
 var array = intArrayFromString(string, dontAddNull);
 var i = 0;
 while (i < array.length) {
  var chr = array[i];
  HEAP8[buffer + i >> 0] = chr;
  i = i + 1;
 }
}
Module["writeStringToMemory"] = writeStringToMemory;
function writeArrayToMemory(array, buffer) {
 for (var i = 0; i < array.length; i++) {
  HEAP8[buffer++ >> 0] = array[i];
 }
}
Module["writeArrayToMemory"] = writeArrayToMemory;
function writeAsciiToMemory(str, buffer, dontAddNull) {
 for (var i = 0; i < str.length; ++i) {
  assert(str.charCodeAt(i) === str.charCodeAt(i) & 255);
  HEAP8[buffer++ >> 0] = str.charCodeAt(i);
 }
 if (!dontAddNull) HEAP8[buffer >> 0] = 0;
}
Module["writeAsciiToMemory"] = writeAsciiToMemory;
function unSign(value, bits, ignore) {
 if (value >= 0) {
  return value;
 }
 return bits <= 32 ? 2 * Math.abs(1 << bits - 1) + value : Math.pow(2, bits) + value;
}
function reSign(value, bits, ignore) {
 if (value <= 0) {
  return value;
 }
 var half = bits <= 32 ? Math.abs(1 << bits - 1) : Math.pow(2, bits - 1);
 if (value >= half && (bits <= 32 || value > half)) {
  value = -2 * half + value;
 }
 return value;
}
if (!Math["imul"] || Math["imul"](4294967295, 5) !== -5) Math["imul"] = function imul(a, b) {
 var ah = a >>> 16;
 var al = a & 65535;
 var bh = b >>> 16;
 var bl = b & 65535;
 return al * bl + (ah * bl + al * bh << 16) | 0;
};
Math.imul = Math["imul"];
if (!Math["fround"]) Math["fround"] = (function(x) {
 return x;
});
Math.fround = Math["fround"];
if (!Math["clz32"]) Math["clz32"] = (function(x) {
 x = x >>> 0;
 for (var i = 0; i < 32; i++) {
  if (x & 1 << 31 - i) return i;
 }
 return 32;
});
Math.clz32 = Math["clz32"];
if (!Math["trunc"]) Math["trunc"] = (function(x) {
 return x < 0 ? Math.ceil(x) : Math.floor(x);
});
Math.trunc = Math["trunc"];
var Math_abs = Math.abs;
var Math_cos = Math.cos;
var Math_sin = Math.sin;
var Math_tan = Math.tan;
var Math_acos = Math.acos;
var Math_asin = Math.asin;
var Math_atan = Math.atan;
var Math_atan2 = Math.atan2;
var Math_exp = Math.exp;
var Math_log = Math.log;
var Math_sqrt = Math.sqrt;
var Math_ceil = Math.ceil;
var Math_floor = Math.floor;
var Math_pow = Math.pow;
var Math_imul = Math.imul;
var Math_fround = Math.fround;
var Math_min = Math.min;
var Math_clz32 = Math.clz32;
var Math_trunc = Math.trunc;
var runDependencies = 0;
var runDependencyWatcher = null;
var dependenciesFulfilled = null;
var runDependencyTracking = {};
function getUniqueRunDependency(id) {
 var orig = id;
 while (1) {
  if (!runDependencyTracking[id]) return id;
  id = orig + Math.random();
 }
 return id;
}
function addRunDependency(id) {
 runDependencies++;
 if (Module["monitorRunDependencies"]) {
  Module["monitorRunDependencies"](runDependencies);
 }
 if (id) {
  assert(!runDependencyTracking[id]);
  runDependencyTracking[id] = 1;
  if (runDependencyWatcher === null && typeof setInterval !== "undefined") {
   runDependencyWatcher = setInterval((function() {
    if (ABORT) {
     clearInterval(runDependencyWatcher);
     runDependencyWatcher = null;
     return;
    }
    var shown = false;
    for (var dep in runDependencyTracking) {
     if (!shown) {
      shown = true;
      Module.printErr("still waiting on run dependencies:");
     }
     Module.printErr("dependency: " + dep);
    }
    if (shown) {
     Module.printErr("(end of list)");
    }
   }), 1e4);
  }
 } else {
  Module.printErr("warning: run dependency added without ID");
 }
}
Module["addRunDependency"] = addRunDependency;
function removeRunDependency(id) {
 runDependencies--;
 if (Module["monitorRunDependencies"]) {
  Module["monitorRunDependencies"](runDependencies);
 }
 if (id) {
  assert(runDependencyTracking[id]);
  delete runDependencyTracking[id];
 } else {
  Module.printErr("warning: run dependency removed without ID");
 }
 if (runDependencies == 0) {
  if (runDependencyWatcher !== null) {
   clearInterval(runDependencyWatcher);
   runDependencyWatcher = null;
  }
  if (dependenciesFulfilled) {
   var callback = dependenciesFulfilled;
   dependenciesFulfilled = null;
   callback();
  }
 }
}
Module["removeRunDependency"] = removeRunDependency;
Module["preloadedImages"] = {};
Module["preloadedAudios"] = {};
addOnPreRun((function() {
 if (Module["dynamicLibraries"]) {
  Module["dynamicLibraries"].forEach((function(lib) {
   Runtime.loadDynamicLibrary(lib);
  }));
 }
 asm["runPostSets"]();
}));
var memoryInitializer = null;
var ASM_CONSTS = [ (function($0, $1) {
 {
  Module.printErr("bad name in getProcAddress: " + [ Pointer_stringify($0), Pointer_stringify($1) ]);
 }
}) ];
function _emscripten_asm_const_iii(code, a0, a1) {
 return ASM_CONSTS[code](a0, a1);
}
STATIC_BASE = 8;
STATICTOP = STATIC_BASE + 1576272;
__ATINIT__.push({
 func: (function() {
  __GLOBAL__I_000101();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_allocator_lump_cpp();
 })
}, {
 func: (function() {
  ___cxx_global_var_init_2();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_allocator2_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_application_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_assetbundles_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_baseclasses_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_baseclasses2_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_camera_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_camera2_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_camera3_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_camera4_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_camera_culling_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_camera_renderlayers_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_camera_renderloops_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_camera_renderloops2_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_containers_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_core_callbacks_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_gamecode_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_geometry_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_gfxdevice_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_graphics_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_graphics3_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_graphics4_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_graphics5_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_graphics6_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_graphics_billboard_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_graphics_commandbuffer_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_graphics_lod_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_graphics_mesh_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_graphics_mesh2_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_graphics_mesh3_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_input_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_jobs_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_math_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_math_random_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_misc_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_misc2_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_misc3_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_modules_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_mono_serializationbackend_directmemoryaccess_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_plugininterface_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_preloadmanager_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_profiler_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_scenemanager_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_scripting_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_serialize_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_serialize_transferfunctions_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_shaders_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_shaders_gpuprograms_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_shaders_shaderimpl_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_terrain_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_utilities_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_utilities2_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_utilities3_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_virtualfilesystem_archivefilesystem_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_virtualfilesystem_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_virtualfilesystem_memoryfilesystem_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_artifacts_generated_webgl_runtime3_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_MemoryManager_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_DirectorManager_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_half_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_LogAssert_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_Player_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_PlayerPaths_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_SaveAndLoadHelper_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_ProfilerImpl_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_SamplerManager_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_AssetBundleFileSystem_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_GpuProgramParamsGLES_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_SparseTextureGLES_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_TimerQueryGLES_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_TransformFeedbackSkinning_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_UnityWebStream_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_GfxDeviceNull_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_umbra_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_particlesystem_modules_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_particlesystem_modules2_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_particlesystem_modules3_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_particlesystem_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_SizeByVelocityModule_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_ExtDefaultSimulationFilterShader_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_NpActor_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_PxsFluidDynamics_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_CmEventProfiler_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_dynamics_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_dynamics2_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_physics2d_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_physics2d2_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_vehicles_lump_cpp();
 })
}, {
 func: (function() {
  ___cxx_global_var_init13();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_SwCollision_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_SwInterCollision_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_SwSelfCollision_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_SwSolverKernel_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_cloth_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_ai_internal_crowd_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_ai_internal_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_ai_internal_obstacles_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_audio_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_audio2_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_video_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_animation_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_animation2_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_animation_director_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_mecanim_animation_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_terrain_lump_cpp_3661();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_terrain2_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_FontImpl_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_GUIText_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_TextMeshGenerator_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_ui_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_imgui_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_artifacts_generated_webgl_modules_imgui_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_webrequest_downloadhandler_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_webrequest_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_runtime_unityconnect_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_UnityAdsSettings_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_VRDevice_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_VRGfxHelpers_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_PluginInterfaceVR_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_modules_particleslegacy_private_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_platformdependent_webgl_source_lump_cpp();
 })
}, {
 func: (function() {
  __GLOBAL__sub_I_iostream_cpp();
 })
});
memoryInitializer = "UnityNative.js.mem";
var tempDoublePtr = STATICTOP;
STATICTOP += 16;
assert(tempDoublePtr % 8 == 0);
function ___setErrNo(value) {
 if (Module["___errno_location"]) HEAP32[Module["___errno_location"]() >> 2] = value; else Module.printErr("failed to set errno from JS");
 return value;
}
Module["___setErrNo"] = ___setErrNo;
var ERRNO_CODES = {
 EPERM: 1,
 ENOENT: 2,
 ESRCH: 3,
 EINTR: 4,
 EIO: 5,
 ENXIO: 6,
 E2BIG: 7,
 ENOEXEC: 8,
 EBADF: 9,
 ECHILD: 10,
 EAGAIN: 11,
 EWOULDBLOCK: 11,
 ENOMEM: 12,
 EACCES: 13,
 EFAULT: 14,
 ENOTBLK: 15,
 EBUSY: 16,
 EEXIST: 17,
 EXDEV: 18,
 ENODEV: 19,
 ENOTDIR: 20,
 EISDIR: 21,
 EINVAL: 22,
 ENFILE: 23,
 EMFILE: 24,
 ENOTTY: 25,
 ETXTBSY: 26,
 EFBIG: 27,
 ENOSPC: 28,
 ESPIPE: 29,
 EROFS: 30,
 EMLINK: 31,
 EPIPE: 32,
 EDOM: 33,
 ERANGE: 34,
 ENOMSG: 42,
 EIDRM: 43,
 ECHRNG: 44,
 EL2NSYNC: 45,
 EL3HLT: 46,
 EL3RST: 47,
 ELNRNG: 48,
 EUNATCH: 49,
 ENOCSI: 50,
 EL2HLT: 51,
 EDEADLK: 35,
 ENOLCK: 37,
 EBADE: 52,
 EBADR: 53,
 EXFULL: 54,
 ENOANO: 55,
 EBADRQC: 56,
 EBADSLT: 57,
 EDEADLOCK: 35,
 EBFONT: 59,
 ENOSTR: 60,
 ENODATA: 61,
 ETIME: 62,
 ENOSR: 63,
 ENONET: 64,
 ENOPKG: 65,
 EREMOTE: 66,
 ENOLINK: 67,
 EADV: 68,
 ESRMNT: 69,
 ECOMM: 70,
 EPROTO: 71,
 EMULTIHOP: 72,
 EDOTDOT: 73,
 EBADMSG: 74,
 ENOTUNIQ: 76,
 EBADFD: 77,
 EREMCHG: 78,
 ELIBACC: 79,
 ELIBBAD: 80,
 ELIBSCN: 81,
 ELIBMAX: 82,
 ELIBEXEC: 83,
 ENOSYS: 38,
 ENOTEMPTY: 39,
 ENAMETOOLONG: 36,
 ELOOP: 40,
 EOPNOTSUPP: 95,
 EPFNOSUPPORT: 96,
 ECONNRESET: 104,
 ENOBUFS: 105,
 EAFNOSUPPORT: 97,
 EPROTOTYPE: 91,
 ENOTSOCK: 88,
 ENOPROTOOPT: 92,
 ESHUTDOWN: 108,
 ECONNREFUSED: 111,
 EADDRINUSE: 98,
 ECONNABORTED: 103,
 ENETUNREACH: 101,
 ENETDOWN: 100,
 ETIMEDOUT: 110,
 EHOSTDOWN: 112,
 EHOSTUNREACH: 113,
 EINPROGRESS: 115,
 EALREADY: 114,
 EDESTADDRREQ: 89,
 EMSGSIZE: 90,
 EPROTONOSUPPORT: 93,
 ESOCKTNOSUPPORT: 94,
 EADDRNOTAVAIL: 99,
 ENETRESET: 102,
 EISCONN: 106,
 ENOTCONN: 107,
 ETOOMANYREFS: 109,
 EUSERS: 87,
 EDQUOT: 122,
 ESTALE: 116,
 ENOTSUP: 95,
 ENOMEDIUM: 123,
 EILSEQ: 84,
 EOVERFLOW: 75,
 ECANCELED: 125,
 ENOTRECOVERABLE: 131,
 EOWNERDEAD: 130,
 ESTRPIPE: 86
};
Module["ERRNO_CODES"] = ERRNO_CODES;
var Sockets = {
 BUFFER_SIZE: 10240,
 MAX_BUFFER_SIZE: 10485760,
 nextFd: 1,
 fds: {},
 nextport: 1,
 maxport: 65535,
 peer: null,
 connections: {},
 portmap: {},
 localAddr: 4261412874,
 addrPool: [ 33554442, 50331658, 67108874, 83886090, 100663306, 117440522, 134217738, 150994954, 167772170, 184549386, 201326602, 218103818, 234881034 ]
};
Module["Sockets"] = Sockets;
function __inet_pton4_raw(str) {
 var b = str.split(".");
 for (var i = 0; i < 4; i++) {
  var tmp = Number(b[i]);
  if (isNaN(tmp)) return null;
  b[i] = tmp;
 }
 return (b[0] | b[1] << 8 | b[2] << 16 | b[3] << 24) >>> 0;
}
Module["__inet_pton4_raw"] = __inet_pton4_raw;
var _htons = undefined;
function __inet_pton6_raw(str) {
 var words;
 var w, offset, z;
 var valid6regx = /^((?=.*::)(?!.*::.+::)(::)?([\dA-F]{1,4}:(:|\b)|){5}|([\dA-F]{1,4}:){6})((([\dA-F]{1,4}((?!\3)::|:\b|$))|(?!\2\3)){2}|(((2[0-4]|1\d|[1-9])?\d|25[0-5])\.?\b){4})$/i;
 var parts = [];
 if (!valid6regx.test(str)) {
  return null;
 }
 if (str === "::") {
  return [ 0, 0, 0, 0, 0, 0, 0, 0 ];
 }
 if (str.indexOf("::") === 0) {
  str = str.replace("::", "Z:");
 } else {
  str = str.replace("::", ":Z:");
 }
 if (str.indexOf(".") > 0) {
  str = str.replace(new RegExp("[.]", "g"), ":");
  words = str.split(":");
  words[words.length - 4] = parseInt(words[words.length - 4]) + parseInt(words[words.length - 3]) * 256;
  words[words.length - 3] = parseInt(words[words.length - 2]) + parseInt(words[words.length - 1]) * 256;
  words = words.slice(0, words.length - 2);
 } else {
  words = str.split(":");
 }
 offset = 0;
 z = 0;
 for (w = 0; w < words.length; w++) {
  if (typeof words[w] === "string") {
   if (words[w] === "Z") {
    for (z = 0; z < 8 - words.length + 1; z++) {
     parts[w + z] = 0;
    }
    offset = z - 1;
   } else {
    parts[w + offset] = _htons(parseInt(words[w], 16));
   }
  } else {
   parts[w + offset] = words[w];
  }
 }
 return [ parts[1] << 16 | parts[0], parts[3] << 16 | parts[2], parts[5] << 16 | parts[4], parts[7] << 16 | parts[6] ];
}
Module["__inet_pton6_raw"] = __inet_pton6_raw;
var DNS = {
 address_map: {
  id: 1,
  addrs: {},
  names: {}
 },
 lookup_name: (function(name) {
  var res = __inet_pton4_raw(name);
  if (res !== null) {
   return name;
  }
  res = __inet_pton6_raw(name);
  if (res !== null) {
   return name;
  }
  var addr;
  if (DNS.address_map.addrs[name]) {
   addr = DNS.address_map.addrs[name];
  } else {
   var id = DNS.address_map.id++;
   assert(id < 65535, "exceeded max address mappings of 65535");
   addr = "172.29." + (id & 255) + "." + (id & 65280);
   DNS.address_map.names[addr] = name;
   DNS.address_map.addrs[name] = addr;
  }
  return addr;
 }),
 lookup_addr: (function(addr) {
  if (DNS.address_map.names[addr]) {
   return DNS.address_map.names[addr];
  }
  return null;
 })
};
Module["DNS"] = DNS;
function __inet_ntop4_raw(addr) {
 return (addr & 255) + "." + (addr >> 8 & 255) + "." + (addr >> 16 & 255) + "." + (addr >> 24 & 255);
}
Module["__inet_ntop4_raw"] = __inet_ntop4_raw;
function __inet_ntop6_raw(ints) {
 var str = "";
 var word = 0;
 var longest = 0;
 var lastzero = 0;
 var zstart = 0;
 var len = 0;
 var i = 0;
 var parts = [ ints[0] & 65535, ints[0] >> 16, ints[1] & 65535, ints[1] >> 16, ints[2] & 65535, ints[2] >> 16, ints[3] & 65535, ints[3] >> 16 ];
 var hasipv4 = true;
 var v4part = "";
 for (i = 0; i < 5; i++) {
  if (parts[i] !== 0) {
   hasipv4 = false;
   break;
  }
 }
 if (hasipv4) {
  v4part = __inet_ntop4_raw(parts[6] | parts[7] << 16);
  if (parts[5] === -1) {
   str = "::ffff:";
   str += v4part;
   return str;
  }
  if (parts[5] === 0) {
   str = "::";
   if (v4part === "0.0.0.0") v4part = "";
   if (v4part === "0.0.0.1") v4part = "1";
   str += v4part;
   return str;
  }
 }
 for (word = 0; word < 8; word++) {
  if (parts[word] === 0) {
   if (word - lastzero > 1) {
    len = 0;
   }
   lastzero = word;
   len++;
  }
  if (len > longest) {
   longest = len;
   zstart = word - longest + 1;
  }
 }
 for (word = 0; word < 8; word++) {
  if (longest > 1) {
   if (parts[word] === 0 && word >= zstart && word < zstart + longest) {
    if (word === zstart) {
     str += ":";
     if (zstart === 0) str += ":";
    }
    continue;
   }
  }
  str += Number(_ntohs(parts[word] & 65535)).toString(16);
  str += word < 7 ? ":" : "";
 }
 return str;
}
Module["__inet_ntop6_raw"] = __inet_ntop6_raw;
function __write_sockaddr(sa, family, addr, port) {
 switch (family) {
 case 2:
  addr = __inet_pton4_raw(addr);
  HEAP16[sa >> 1] = family;
  HEAP32[sa + 4 >> 2] = addr;
  HEAP16[sa + 2 >> 1] = _htons(port);
  break;
 case 10:
  addr = __inet_pton6_raw(addr);
  HEAP32[sa >> 2] = family;
  HEAP32[sa + 8 >> 2] = addr[0];
  HEAP32[sa + 12 >> 2] = addr[1];
  HEAP32[sa + 16 >> 2] = addr[2];
  HEAP32[sa + 20 >> 2] = addr[3];
  HEAP16[sa + 2 >> 1] = _htons(port);
  HEAP32[sa + 4 >> 2] = 0;
  HEAP32[sa + 24 >> 2] = 0;
  break;
 default:
  return {
   errno: ERRNO_CODES.EAFNOSUPPORT
  };
 }
 return {};
}
Module["__write_sockaddr"] = __write_sockaddr;
function _getaddrinfo(node, service, hint, out) {
 var addrs = [];
 var addr = 0;
 var port = 0;
 var flags = 0;
 var family = 0;
 var type = 0;
 var proto = 0;
 var ai;
 function allocaddrinfo(family, type, proto, canon, addr, port) {
  var sa, salen, ai;
  var res;
  salen = family === 10 ? 28 : 16;
  addr = family === 10 ? __inet_ntop6_raw(addr) : __inet_ntop4_raw(addr);
  sa = _malloc(salen);
  res = __write_sockaddr(sa, family, addr, port);
  assert(!res.errno);
  ai = _malloc(32);
  HEAP32[ai + 4 >> 2] = family;
  HEAP32[ai + 8 >> 2] = type;
  HEAP32[ai + 12 >> 2] = proto;
  if (canon) {
   HEAP32[ai + 24 >> 2] = canon;
  }
  HEAP32[ai + 20 >> 2] = sa;
  if (family === 10) {
   HEAP32[ai + 16 >> 2] = 28;
  } else {
   HEAP32[ai + 16 >> 2] = 16;
  }
  HEAP32[ai + 28 >> 2] = 0;
  return ai;
 }
 if (hint) {
  flags = HEAP32[hint >> 2];
  family = HEAP32[hint + 4 >> 2];
  type = HEAP32[hint + 8 >> 2];
  proto = HEAP32[hint + 12 >> 2];
 }
 if (type && !proto) {
  proto = type === 2 ? 17 : 6;
 }
 if (!type && proto) {
  type = proto === 17 ? 2 : 1;
 }
 if (proto === 0) {
  proto = 6;
 }
 if (type === 0) {
  type = 1;
 }
 if (!node && !service) {
  return -2;
 }
 if (flags & ~(1 | 2 | 4 | 1024 | 8 | 16 | 32)) {
  return -1;
 }
 if (hint !== 0 && HEAP32[hint >> 2] & 2 && !node) {
  return -1;
 }
 if (flags & 32) {
  return -2;
 }
 if (type !== 0 && type !== 1 && type !== 2) {
  return -7;
 }
 if (family !== 0 && family !== 2 && family !== 10) {
  return -6;
 }
 if (service) {
  service = Pointer_stringify(service);
  port = parseInt(service, 10);
  if (isNaN(port)) {
   if (flags & 1024) {
    return -2;
   }
   return -8;
  }
 }
 if (!node) {
  if (family === 0) {
   family = 2;
  }
  if ((flags & 1) === 0) {
   if (family === 2) {
    addr = _htonl(2130706433);
   } else {
    addr = [ 0, 0, 0, 1 ];
   }
  }
  ai = allocaddrinfo(family, type, proto, null, addr, port);
  HEAP32[out >> 2] = ai;
  return 0;
 }
 node = Pointer_stringify(node);
 addr = __inet_pton4_raw(node);
 if (addr !== null) {
  if (family === 0 || family === 2) {
   family = 2;
  } else if (family === 10 && flags & 8) {
   addr = [ 0, 0, _htonl(65535), addr ];
   family = 10;
  } else {
   return -2;
  }
 } else {
  addr = __inet_pton6_raw(node);
  if (addr !== null) {
   if (family === 0 || family === 10) {
    family = 10;
   } else {
    return -2;
   }
  }
 }
 if (addr != null) {
  ai = allocaddrinfo(family, type, proto, node, addr, port);
  HEAP32[out >> 2] = ai;
  return 0;
 }
 if (flags & 4) {
  return -2;
 }
 node = DNS.lookup_name(node);
 addr = __inet_pton4_raw(node);
 if (family === 0) {
  family = 2;
 } else if (family === 10) {
  addr = [ 0, 0, _htonl(65535), addr ];
 }
 ai = allocaddrinfo(family, type, proto, null, addr, port);
 HEAP32[out >> 2] = ai;
 return 0;
}
Module["_getaddrinfo"] = _getaddrinfo;
var GL = {
 counter: 1,
 lastError: 0,
 buffers: [],
 mappedBuffers: {},
 programs: [],
 framebuffers: [],
 renderbuffers: [],
 textures: [],
 uniforms: [],
 shaders: [],
 vaos: [],
 contexts: [],
 currentContext: null,
 offscreenCanvases: {},
 queries: [],
 samplers: [],
 transformFeedbacks: [],
 syncs: [],
 byteSizeByTypeRoot: 5120,
 byteSizeByType: [ 1, 1, 2, 2, 4, 4, 4, 2, 3, 4, 8 ],
 programInfos: {},
 stringCache: {},
 stringiCache: {},
 packAlignment: 4,
 unpackAlignment: 4,
 init: (function() {
  GL.miniTempBuffer = new Float32Array(GL.MINI_TEMP_BUFFER_SIZE);
  for (var i = 0; i < GL.MINI_TEMP_BUFFER_SIZE; i++) {
   GL.miniTempBufferViews[i] = GL.miniTempBuffer.subarray(0, i + 1);
  }
 }),
 recordError: function recordError(errorCode) {
  if (!GL.lastError) {
   GL.lastError = errorCode;
  }
 },
 getNewId: (function(table) {
  var ret = GL.counter++;
  for (var i = table.length; i < ret; i++) {
   table[i] = null;
  }
  return ret;
 }),
 MINI_TEMP_BUFFER_SIZE: 256,
 miniTempBuffer: null,
 miniTempBufferViews: [ 0 ],
 getSource: (function(shader, count, string, length) {
  var source = "";
  for (var i = 0; i < count; ++i) {
   var frag;
   if (length) {
    var len = HEAP32[length + i * 4 >> 2];
    if (len < 0) {
     frag = Pointer_stringify(HEAP32[string + i * 4 >> 2]);
    } else {
     frag = Pointer_stringify(HEAP32[string + i * 4 >> 2], len);
    }
   } else {
    frag = Pointer_stringify(HEAP32[string + i * 4 >> 2]);
   }
   source += frag;
  }
  return source;
 }),
 createContext: (function(canvas, webGLContextAttributes) {
  if (typeof webGLContextAttributes.majorVersion === "undefined" && typeof webGLContextAttributes.minorVersion === "undefined") {
   webGLContextAttributes.majorVersion = 2;
   webGLContextAttributes.minorVersion = 0;
  }
  var ctx;
  var errorInfo = "?";
  function onContextCreationError(event) {
   errorInfo = event.statusMessage || errorInfo;
  }
  try {
   canvas.addEventListener("webglcontextcreationerror", onContextCreationError, false);
   try {
    if (webGLContextAttributes.majorVersion == 1 && webGLContextAttributes.minorVersion == 0) {
     ctx = canvas.getContext("webgl", webGLContextAttributes) || canvas.getContext("experimental-webgl", webGLContextAttributes);
    } else if (webGLContextAttributes.majorVersion == 2 && webGLContextAttributes.minorVersion == 0) {
     ctx = canvas.getContext("webgl2", webGLContextAttributes) || canvas.getContext("experimental-webgl2", webGLContextAttributes);
    } else {
     throw "Unsupported WebGL context version " + majorVersion + "." + minorVersion + "!";
    }
   } finally {
    canvas.removeEventListener("webglcontextcreationerror", onContextCreationError, false);
   }
   if (!ctx) throw ":(";
  } catch (e) {
   Module.print("Could not create canvas: " + [ errorInfo, e, JSON.stringify(webGLContextAttributes) ]);
   return 0;
  }
  if (!ctx) return 0;
  return GL.registerContext(ctx, webGLContextAttributes);
 }),
 registerContext: (function(ctx, webGLContextAttributes) {
  var handle = GL.getNewId(GL.contexts);
  var context = {
   handle: handle,
   attributes: webGLContextAttributes,
   version: webGLContextAttributes.majorVersion,
   GLctx: ctx
  };
  if (ctx.canvas) ctx.canvas.GLctxObject = context;
  GL.contexts[handle] = context;
  if (typeof webGLContextAttributes["enableExtensionsByDefault"] === "undefined" || webGLContextAttributes.enableExtensionsByDefault) {
   GL.initExtensions(context);
  }
  return handle;
 }),
 makeContextCurrent: (function(contextHandle) {
  var context = GL.contexts[contextHandle];
  if (!context) return false;
  GLctx = Module.ctx = context.GLctx;
  GL.currentContext = context;
  return true;
 }),
 getContext: (function(contextHandle) {
  return GL.contexts[contextHandle];
 }),
 deleteContext: (function(contextHandle) {
  if (GL.currentContext === GL.contexts[contextHandle]) GL.currentContext = null;
  if (typeof JSEvents === "object") JSEvents.removeAllHandlersOnTarget(GL.contexts[contextHandle].GLctx.canvas);
  if (GL.contexts[contextHandle] && GL.contexts[contextHandle].GLctx.canvas) GL.contexts[contextHandle].GLctx.canvas.GLctxObject = undefined;
  GL.contexts[contextHandle] = null;
 }),
 initExtensions: (function(context) {
  if (!context) context = GL.currentContext;
  if (context.initExtensionsDone) return;
  context.initExtensionsDone = true;
  var GLctx = context.GLctx;
  context.maxVertexAttribs = GLctx.getParameter(GLctx.MAX_VERTEX_ATTRIBS);
  if (context.version < 2) {
   var instancedArraysExt = GLctx.getExtension("ANGLE_instanced_arrays");
   if (instancedArraysExt) {
    GLctx["vertexAttribDivisor"] = (function(index, divisor) {
     instancedArraysExt["vertexAttribDivisorANGLE"](index, divisor);
    });
    GLctx["drawArraysInstanced"] = (function(mode, first, count, primcount) {
     instancedArraysExt["drawArraysInstancedANGLE"](mode, first, count, primcount);
    });
    GLctx["drawElementsInstanced"] = (function(mode, count, type, indices, primcount) {
     instancedArraysExt["drawElementsInstancedANGLE"](mode, count, type, indices, primcount);
    });
   }
   var vaoExt = GLctx.getExtension("OES_vertex_array_object");
   if (vaoExt) {
    GLctx["createVertexArray"] = (function() {
     return vaoExt["createVertexArrayOES"]();
    });
    GLctx["deleteVertexArray"] = (function(vao) {
     vaoExt["deleteVertexArrayOES"](vao);
    });
    GLctx["bindVertexArray"] = (function(vao) {
     vaoExt["bindVertexArrayOES"](vao);
    });
    GLctx["isVertexArray"] = (function(vao) {
     return vaoExt["isVertexArrayOES"](vao);
    });
   }
   var drawBuffersExt = GLctx.getExtension("WEBGL_draw_buffers");
   if (drawBuffersExt) {
    GLctx["drawBuffers"] = (function(n, bufs) {
     drawBuffersExt["drawBuffersWEBGL"](n, bufs);
    });
   }
  }
  var automaticallyEnabledExtensions = [ "OES_texture_float", "OES_texture_half_float", "OES_standard_derivatives", "OES_vertex_array_object", "WEBGL_compressed_texture_s3tc", "WEBGL_depth_texture", "OES_element_index_uint", "EXT_texture_filter_anisotropic", "ANGLE_instanced_arrays", "OES_texture_float_linear", "OES_texture_half_float_linear", "WEBGL_compressed_texture_atc", "WEBGL_compressed_texture_pvrtc", "EXT_color_buffer_half_float", "WEBGL_color_buffer_float", "EXT_frag_depth", "EXT_sRGB", "WEBGL_draw_buffers", "WEBGL_shared_resources", "EXT_shader_texture_lod", "EXT_color_buffer_float" ];
  var exts = GLctx.getSupportedExtensions();
  if (exts && exts.length > 0) {
   GLctx.getSupportedExtensions().forEach((function(ext) {
    if (automaticallyEnabledExtensions.indexOf(ext) != -1) {
     GLctx.getExtension(ext);
    }
   }));
  }
 }),
 populateUniformTable: (function(program) {
  var p = GL.programs[program];
  GL.programInfos[program] = {
   uniforms: {},
   maxUniformLength: 0,
   maxAttributeLength: -1
  };
  var ptable = GL.programInfos[program];
  var utable = ptable.uniforms;
  var numUniforms = GLctx.getProgramParameter(p, GLctx.ACTIVE_UNIFORMS);
  for (var i = 0; i < numUniforms; ++i) {
   var u = GLctx.getActiveUniform(p, i);
   var name = u.name;
   ptable.maxUniformLength = Math.max(ptable.maxUniformLength, name.length + 1);
   if (name.indexOf("]", name.length - 1) !== -1) {
    var ls = name.lastIndexOf("[");
    name = name.slice(0, ls);
   }
   var loc = GLctx.getUniformLocation(p, name);
   var id = GL.getNewId(GL.uniforms);
   utable[name] = [ u.size, id ];
   GL.uniforms[id] = loc;
   for (var j = 1; j < u.size; ++j) {
    var n = name + "[" + j + "]";
    loc = GLctx.getUniformLocation(p, n);
    id = GL.getNewId(GL.uniforms);
    GL.uniforms[id] = loc;
   }
  }
 })
};
Module["GL"] = GL;
function _emscripten_glStencilMaskSeparate(x0, x1) {
 GLctx.stencilMaskSeparate(x0, x1);
}
Module["_emscripten_glStencilMaskSeparate"] = _emscripten_glStencilMaskSeparate;
function __read_sockaddr(sa, salen) {
 var family = HEAP16[sa >> 1];
 var port = _ntohs(HEAP16[sa + 2 >> 1]);
 var addr;
 switch (family) {
 case 2:
  if (salen !== 16) {
   return {
    errno: ERRNO_CODES.EINVAL
   };
  }
  addr = HEAP32[sa + 4 >> 2];
  addr = __inet_ntop4_raw(addr);
  break;
 case 10:
  if (salen !== 28) {
   return {
    errno: ERRNO_CODES.EINVAL
   };
  }
  addr = [ HEAP32[sa + 8 >> 2], HEAP32[sa + 12 >> 2], HEAP32[sa + 16 >> 2], HEAP32[sa + 20 >> 2] ];
  addr = __inet_ntop6_raw(addr);
  break;
 default:
  return {
   errno: ERRNO_CODES.EAFNOSUPPORT
  };
 }
 return {
  family: family,
  addr: addr,
  port: port
 };
}
Module["__read_sockaddr"] = __read_sockaddr;
function _getnameinfo(sa, salen, node, nodelen, serv, servlen, flags) {
 var info = __read_sockaddr(sa, salen);
 if (info.errno) {
  return -6;
 }
 var port = info.port;
 var addr = info.addr;
 if (node && nodelen) {
  var lookup;
  if (flags & 1 || !(lookup = DNS.lookup_addr(addr))) {
   if (flags & 8) {
    return -2;
   }
  } else {
   addr = lookup;
  }
  if (addr.length >= nodelen) {
   return -12;
  }
  writeStringToMemory(addr, node);
 }
 if (serv && servlen) {
  port = "" + port;
  if (port.length > servlen) {
   return -12;
  }
  writeStringToMemory(port, serv);
 }
 return 0;
}
Module["_getnameinfo"] = _getnameinfo;
function _emscripten_get_now() {
 abort();
}
Module["_emscripten_get_now"] = _emscripten_get_now;
function _emscripten_set_main_loop(func, fps, simulateInfiniteLoop, arg, noSetTiming) {
 Module["noExitRuntime"] = true;
 assert(!Browser.mainLoop.func, "emscripten_set_main_loop: there can only be one main loop function at once: call emscripten_cancel_main_loop to cancel the previous one before setting a new one with different parameters.");
 Browser.mainLoop.func = func;
 Browser.mainLoop.arg = arg;
 var browserIterationFunc;
 if (typeof arg !== "undefined") {
  var argArray = [ arg ];
  browserIterationFunc = (function() {
   Runtime.dynCall("vi", func, argArray);
  });
 } else {
  browserIterationFunc = (function() {
   Runtime.dynCall("v", func);
  });
 }
 var thisMainLoopId = Browser.mainLoop.currentlyRunningMainloop;
 Browser.mainLoop.runner = function Browser_mainLoop_runner() {
  if (ABORT) return;
  if (Browser.mainLoop.queue.length > 0) {
   var start = Date.now();
   var blocker = Browser.mainLoop.queue.shift();
   blocker.func(blocker.arg);
   if (Browser.mainLoop.remainingBlockers) {
    var remaining = Browser.mainLoop.remainingBlockers;
    var next = remaining % 1 == 0 ? remaining - 1 : Math.floor(remaining);
    if (blocker.counted) {
     Browser.mainLoop.remainingBlockers = next;
    } else {
     next = next + .5;
     Browser.mainLoop.remainingBlockers = (8 * remaining + next) / 9;
    }
   }
   console.log('main loop blocker "' + blocker.name + '" took ' + (Date.now() - start) + " ms");
   Browser.mainLoop.updateStatus();
   if (thisMainLoopId < Browser.mainLoop.currentlyRunningMainloop) return;
   setTimeout(Browser.mainLoop.runner, 0);
   return;
  }
  if (thisMainLoopId < Browser.mainLoop.currentlyRunningMainloop) return;
  Browser.mainLoop.currentFrameNumber = Browser.mainLoop.currentFrameNumber + 1 | 0;
  if (Browser.mainLoop.timingMode == 1 && Browser.mainLoop.timingValue > 1 && Browser.mainLoop.currentFrameNumber % Browser.mainLoop.timingValue != 0) {
   Browser.mainLoop.scheduler();
   return;
  } else if (Browser.mainLoop.timingMode == 0) {
   Browser.mainLoop.tickStartTime = _emscripten_get_now();
  }
  if (Browser.mainLoop.method === "timeout" && Module.ctx) {
   Module.printErr("Looks like you are rendering without using requestAnimationFrame for the main loop. You should use 0 for the frame rate in emscripten_set_main_loop in order to use requestAnimationFrame, as that can greatly improve your frame rates!");
   Browser.mainLoop.method = "";
  }
  Browser.mainLoop.runIter(browserIterationFunc);
  checkStackCookie();
  if (thisMainLoopId < Browser.mainLoop.currentlyRunningMainloop) return;
  if (typeof SDL === "object" && SDL.audio && SDL.audio.queueNewAudioData) SDL.audio.queueNewAudioData();
  Browser.mainLoop.scheduler();
 };
 if (!noSetTiming) {
  if (fps && fps > 0) _emscripten_set_main_loop_timing(0, 1e3 / fps); else _emscripten_set_main_loop_timing(1, 1);
  Browser.mainLoop.scheduler();
 }
 if (simulateInfiniteLoop) {
  throw "SimulateInfiniteLoop";
 }
}
Module["_emscripten_set_main_loop"] = _emscripten_set_main_loop;
var Browser = {
 mainLoop: {
  scheduler: null,
  method: "",
  currentlyRunningMainloop: 0,
  func: null,
  arg: 0,
  timingMode: 0,
  timingValue: 0,
  currentFrameNumber: 0,
  queue: [],
  pause: (function() {
   Browser.mainLoop.scheduler = null;
   Browser.mainLoop.currentlyRunningMainloop++;
  }),
  resume: (function() {
   Browser.mainLoop.currentlyRunningMainloop++;
   var timingMode = Browser.mainLoop.timingMode;
   var timingValue = Browser.mainLoop.timingValue;
   var func = Browser.mainLoop.func;
   Browser.mainLoop.func = null;
   _emscripten_set_main_loop(func, 0, false, Browser.mainLoop.arg, true);
   _emscripten_set_main_loop_timing(timingMode, timingValue);
   Browser.mainLoop.scheduler();
  }),
  updateStatus: (function() {
   if (Module["setStatus"]) {
    var message = Module["statusMessage"] || "Please wait...";
    var remaining = Browser.mainLoop.remainingBlockers;
    var expected = Browser.mainLoop.expectedBlockers;
    if (remaining) {
     if (remaining < expected) {
      Module["setStatus"](message + " (" + (expected - remaining) + "/" + expected + ")");
     } else {
      Module["setStatus"](message);
     }
    } else {
     Module["setStatus"]("");
    }
   }
  }),
  runIter: (function(func) {
   if (ABORT) return;
   if (Module["preMainLoop"]) {
    var preRet = Module["preMainLoop"]();
    if (preRet === false) {
     return;
    }
   }
   try {
    func();
   } catch (e) {
    if (e instanceof ExitStatus) {
     return;
    } else {
     if (e && typeof e === "object" && e.stack) Module.printErr("exception thrown: " + [ e, e.stack ]);
     throw e;
    }
   }
   if (Module["postMainLoop"]) Module["postMainLoop"]();
  })
 },
 isFullscreen: false,
 pointerLock: false,
 moduleContextCreatedCallbacks: [],
 workers: [],
 init: (function() {
  if (!Module["preloadPlugins"]) Module["preloadPlugins"] = [];
  if (Browser.initted) return;
  Browser.initted = true;
  try {
   new Blob;
   Browser.hasBlobConstructor = true;
  } catch (e) {
   Browser.hasBlobConstructor = false;
   console.log("warning: no blob constructor, cannot create blobs with mimetypes");
  }
  Browser.BlobBuilder = typeof MozBlobBuilder != "undefined" ? MozBlobBuilder : typeof WebKitBlobBuilder != "undefined" ? WebKitBlobBuilder : !Browser.hasBlobConstructor ? console.log("warning: no BlobBuilder") : null;
  Browser.URLObject = typeof window != "undefined" ? window.URL ? window.URL : window.webkitURL : undefined;
  if (!Module.noImageDecoding && typeof Browser.URLObject === "undefined") {
   console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");
   Module.noImageDecoding = true;
  }
  var imagePlugin = {};
  imagePlugin["canHandle"] = function imagePlugin_canHandle(name) {
   return !Module.noImageDecoding && /\.(jpg|jpeg|png|bmp)$/i.test(name);
  };
  imagePlugin["handle"] = function imagePlugin_handle(byteArray, name, onload, onerror) {
   var b = null;
   if (Browser.hasBlobConstructor) {
    try {
     b = new Blob([ byteArray ], {
      type: Browser.getMimetype(name)
     });
     if (b.size !== byteArray.length) {
      b = new Blob([ (new Uint8Array(byteArray)).buffer ], {
       type: Browser.getMimetype(name)
      });
     }
    } catch (e) {
     Runtime.warnOnce("Blob constructor present but fails: " + e + "; falling back to blob builder");
    }
   }
   if (!b) {
    var bb = new Browser.BlobBuilder;
    bb.append((new Uint8Array(byteArray)).buffer);
    b = bb.getBlob();
   }
   var url = Browser.URLObject.createObjectURL(b);
   assert(typeof url == "string", "createObjectURL must return a url as a string");
   var img = new Image;
   img.onload = function img_onload() {
    assert(img.complete, "Image " + name + " could not be decoded");
    var canvas = document.createElement("canvas");
    canvas.width = img.width;
    canvas.height = img.height;
    var ctx = canvas.getContext("2d");
    ctx.drawImage(img, 0, 0);
    Module["preloadedImages"][name] = canvas;
    Browser.URLObject.revokeObjectURL(url);
    if (onload) onload(byteArray);
   };
   img.onerror = function img_onerror(event) {
    console.log("Image " + url + " could not be decoded");
    if (onerror) onerror();
   };
   img.src = url;
  };
  Module["preloadPlugins"].push(imagePlugin);
  var audioPlugin = {};
  audioPlugin["canHandle"] = function audioPlugin_canHandle(name) {
   return !Module.noAudioDecoding && name.substr(-4) in {
    ".ogg": 1,
    ".wav": 1,
    ".mp3": 1
   };
  };
  audioPlugin["handle"] = function audioPlugin_handle(byteArray, name, onload, onerror) {
   var done = false;
   function finish(audio) {
    if (done) return;
    done = true;
    Module["preloadedAudios"][name] = audio;
    if (onload) onload(byteArray);
   }
   function fail() {
    if (done) return;
    done = true;
    Module["preloadedAudios"][name] = new Audio;
    if (onerror) onerror();
   }
   if (Browser.hasBlobConstructor) {
    try {
     var b = new Blob([ byteArray ], {
      type: Browser.getMimetype(name)
     });
    } catch (e) {
     return fail();
    }
    var url = Browser.URLObject.createObjectURL(b);
    assert(typeof url == "string", "createObjectURL must return a url as a string");
    var audio = new Audio;
    audio.addEventListener("canplaythrough", (function() {
     finish(audio);
    }), false);
    audio.onerror = function audio_onerror(event) {
     if (done) return;
     console.log("warning: browser could not fully decode audio " + name + ", trying slower base64 approach");
     function encode64(data) {
      var BASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
      var PAD = "=";
      var ret = "";
      var leftchar = 0;
      var leftbits = 0;
      for (var i = 0; i < data.length; i++) {
       leftchar = leftchar << 8 | data[i];
       leftbits += 8;
       while (leftbits >= 6) {
        var curr = leftchar >> leftbits - 6 & 63;
        leftbits -= 6;
        ret += BASE[curr];
       }
      }
      if (leftbits == 2) {
       ret += BASE[(leftchar & 3) << 4];
       ret += PAD + PAD;
      } else if (leftbits == 4) {
       ret += BASE[(leftchar & 15) << 2];
       ret += PAD;
      }
      return ret;
     }
     audio.src = "data:audio/x-" + name.substr(-3) + ";base64," + encode64(byteArray);
     finish(audio);
    };
    audio.src = url;
    Browser.safeSetTimeout((function() {
     finish(audio);
    }), 1e4);
   } else {
    return fail();
   }
  };
  Module["preloadPlugins"].push(audioPlugin);
  var canvas = Module["canvas"];
  function pointerLockChange() {
   Browser.pointerLock = document["pointerLockElement"] === canvas || document["mozPointerLockElement"] === canvas || document["webkitPointerLockElement"] === canvas || document["msPointerLockElement"] === canvas;
  }
  if (canvas) {
   canvas.requestPointerLock = canvas["requestPointerLock"] || canvas["mozRequestPointerLock"] || canvas["webkitRequestPointerLock"] || canvas["msRequestPointerLock"] || (function() {});
   canvas.exitPointerLock = document["exitPointerLock"] || document["mozExitPointerLock"] || document["webkitExitPointerLock"] || document["msExitPointerLock"] || (function() {});
   canvas.exitPointerLock = canvas.exitPointerLock.bind(document);
   document.addEventListener("pointerlockchange", pointerLockChange, false);
   document.addEventListener("mozpointerlockchange", pointerLockChange, false);
   document.addEventListener("webkitpointerlockchange", pointerLockChange, false);
   document.addEventListener("mspointerlockchange", pointerLockChange, false);
   if (Module["elementPointerLock"]) {
    canvas.addEventListener("click", (function(ev) {
     if (!Browser.pointerLock && canvas.requestPointerLock) {
      canvas.requestPointerLock();
      ev.preventDefault();
     }
    }), false);
   }
  }
 }),
 createContext: (function(canvas, useWebGL, setInModule, webGLContextAttributes) {
  if (useWebGL && Module.ctx && canvas == Module.canvas) return Module.ctx;
  var ctx;
  var contextHandle;
  if (useWebGL) {
   var contextAttributes = {
    antialias: false,
    alpha: false
   };
   if (webGLContextAttributes) {
    for (var attribute in webGLContextAttributes) {
     contextAttributes[attribute] = webGLContextAttributes[attribute];
    }
   }
   contextHandle = GL.createContext(canvas, contextAttributes);
   if (contextHandle) {
    ctx = GL.getContext(contextHandle).GLctx;
   }
  } else {
   ctx = canvas.getContext("2d");
  }
  if (!ctx) return null;
  if (setInModule) {
   if (!useWebGL) assert(typeof GLctx === "undefined", "cannot set in module if GLctx is used, but we are a non-GL context that would replace it");
   Module.ctx = ctx;
   if (useWebGL) GL.makeContextCurrent(contextHandle);
   Module.useWebGL = useWebGL;
   Browser.moduleContextCreatedCallbacks.forEach((function(callback) {
    callback();
   }));
   Browser.init();
  }
  return ctx;
 }),
 destroyContext: (function(canvas, useWebGL, setInModule) {}),
 fullscreenHandlersInstalled: false,
 lockPointer: undefined,
 resizeCanvas: undefined,
 requestFullscreen: (function(lockPointer, resizeCanvas, vrDevice) {
  Browser.lockPointer = lockPointer;
  Browser.resizeCanvas = resizeCanvas;
  Browser.vrDevice = vrDevice;
  if (typeof Browser.lockPointer === "undefined") Browser.lockPointer = true;
  if (typeof Browser.resizeCanvas === "undefined") Browser.resizeCanvas = false;
  if (typeof Browser.vrDevice === "undefined") Browser.vrDevice = null;
  var canvas = Module["canvas"];
  function fullscreenChange() {
   Browser.isFullscreen = false;
   var canvasContainer = canvas.parentNode;
   if ((document["fullscreenElement"] || document["mozFullScreenElement"] || document["msFullscreenElement"] || document["webkitFullscreenElement"] || document["webkitCurrentFullScreenElement"]) === canvasContainer) {
    canvas.exitFullscreen = document["exitFullscreen"] || document["cancelFullScreen"] || document["mozCancelFullScreen"] || document["msExitFullscreen"] || document["webkitCancelFullScreen"] || (function() {});
    canvas.exitFullscreen = canvas.exitFullscreen.bind(document);
    if (Browser.lockPointer) canvas.requestPointerLock();
    Browser.isFullscreen = true;
    if (Browser.resizeCanvas) Browser.setFullscreenCanvasSize();
   } else {
    canvasContainer.parentNode.insertBefore(canvas, canvasContainer);
    canvasContainer.parentNode.removeChild(canvasContainer);
    if (Browser.resizeCanvas) Browser.setWindowedCanvasSize();
   }
   if (Module["onFullScreen"]) Module["onFullScreen"](Browser.isFullscreen);
   if (Module["onFullscreen"]) Module["onFullscreen"](Browser.isFullscreen);
   Browser.updateCanvasDimensions(canvas);
  }
  if (!Browser.fullscreenHandlersInstalled) {
   Browser.fullscreenHandlersInstalled = true;
   document.addEventListener("fullscreenchange", fullscreenChange, false);
   document.addEventListener("mozfullscreenchange", fullscreenChange, false);
   document.addEventListener("webkitfullscreenchange", fullscreenChange, false);
   document.addEventListener("MSFullscreenChange", fullscreenChange, false);
  }
  var canvasContainer = document.createElement("div");
  canvas.parentNode.insertBefore(canvasContainer, canvas);
  canvasContainer.appendChild(canvas);
  canvasContainer.requestFullscreen = canvasContainer["requestFullscreen"] || canvasContainer["mozRequestFullScreen"] || canvasContainer["msRequestFullscreen"] || (canvasContainer["webkitRequestFullscreen"] ? (function() {
   canvasContainer["webkitRequestFullscreen"](Element["ALLOW_KEYBOARD_INPUT"]);
  }) : null) || (canvasContainer["webkitRequestFullScreen"] ? (function() {
   canvasContainer["webkitRequestFullScreen"](Element["ALLOW_KEYBOARD_INPUT"]);
  }) : null);
  if (vrDevice) {
   canvasContainer.requestFullscreen({
    vrDisplay: vrDevice
   });
  } else {
   canvasContainer.requestFullscreen();
  }
 }),
 requestFullScreen: (function(lockPointer, resizeCanvas, vrDevice) {
  Module.printErr("Browser.requestFullScreen() is deprecated. Please call Browser.requestFullscreen instead.");
  Browser.requestFullScreen = (function(lockPointer, resizeCanvas, vrDevice) {
   return Browser.requestFullscreen(lockPointer, resizeCanvas, vrDevice);
  });
  return Browser.requestFullscreen(lockPointer, resizeCanvas, vrDevice);
 }),
 nextRAF: 0,
 fakeRequestAnimationFrame: (function(func) {
  var now = Date.now();
  if (Browser.nextRAF === 0) {
   Browser.nextRAF = now + 1e3 / 60;
  } else {
   while (now + 2 >= Browser.nextRAF) {
    Browser.nextRAF += 1e3 / 60;
   }
  }
  var delay = Math.max(Browser.nextRAF - now, 0);
  setTimeout(func, delay);
 }),
 requestAnimationFrame: function requestAnimationFrame(func) {
  if (typeof window === "undefined") {
   Browser.fakeRequestAnimationFrame(func);
  } else {
   if (!window.requestAnimationFrame) {
    window.requestAnimationFrame = window["requestAnimationFrame"] || window["mozRequestAnimationFrame"] || window["webkitRequestAnimationFrame"] || window["msRequestAnimationFrame"] || window["oRequestAnimationFrame"] || Browser.fakeRequestAnimationFrame;
   }
   window.requestAnimationFrame(func);
  }
 },
 safeCallback: (function(func) {
  return (function() {
   if (!ABORT) return func.apply(null, arguments);
  });
 }),
 allowAsyncCallbacks: true,
 queuedAsyncCallbacks: [],
 pauseAsyncCallbacks: (function() {
  Browser.allowAsyncCallbacks = false;
 }),
 resumeAsyncCallbacks: (function() {
  Browser.allowAsyncCallbacks = true;
  if (Browser.queuedAsyncCallbacks.length > 0) {
   var callbacks = Browser.queuedAsyncCallbacks;
   Browser.queuedAsyncCallbacks = [];
   callbacks.forEach((function(func) {
    func();
   }));
  }
 }),
 safeRequestAnimationFrame: (function(func) {
  return Browser.requestAnimationFrame((function() {
   if (ABORT) return;
   if (Browser.allowAsyncCallbacks) {
    func();
   } else {
    Browser.queuedAsyncCallbacks.push(func);
   }
  }));
 }),
 safeSetTimeout: (function(func, timeout) {
  Module["noExitRuntime"] = true;
  return setTimeout((function() {
   if (ABORT) return;
   if (Browser.allowAsyncCallbacks) {
    func();
   } else {
    Browser.queuedAsyncCallbacks.push(func);
   }
  }), timeout);
 }),
 safeSetInterval: (function(func, timeout) {
  Module["noExitRuntime"] = true;
  return setInterval((function() {
   if (ABORT) return;
   if (Browser.allowAsyncCallbacks) {
    func();
   }
  }), timeout);
 }),
 getMimetype: (function(name) {
  return {
   "jpg": "image/jpeg",
   "jpeg": "image/jpeg",
   "png": "image/png",
   "bmp": "image/bmp",
   "ogg": "audio/ogg",
   "wav": "audio/wav",
   "mp3": "audio/mpeg"
  }[name.substr(name.lastIndexOf(".") + 1)];
 }),
 getUserMedia: (function(func) {
  if (!window.getUserMedia) {
   window.getUserMedia = navigator["getUserMedia"] || navigator["mozGetUserMedia"];
  }
  window.getUserMedia(func);
 }),
 getMovementX: (function(event) {
  return event["movementX"] || event["mozMovementX"] || event["webkitMovementX"] || 0;
 }),
 getMovementY: (function(event) {
  return event["movementY"] || event["mozMovementY"] || event["webkitMovementY"] || 0;
 }),
 getMouseWheelDelta: (function(event) {
  var delta = 0;
  switch (event.type) {
  case "DOMMouseScroll":
   delta = event.detail;
   break;
  case "mousewheel":
   delta = event.wheelDelta;
   break;
  case "wheel":
   delta = event["deltaY"];
   break;
  default:
   throw "unrecognized mouse wheel event: " + event.type;
  }
  return delta;
 }),
 mouseX: 0,
 mouseY: 0,
 mouseMovementX: 0,
 mouseMovementY: 0,
 touches: {},
 lastTouches: {},
 calculateMouseEvent: (function(event) {
  if (Browser.pointerLock) {
   if (event.type != "mousemove" && "mozMovementX" in event) {
    Browser.mouseMovementX = Browser.mouseMovementY = 0;
   } else {
    Browser.mouseMovementX = Browser.getMovementX(event);
    Browser.mouseMovementY = Browser.getMovementY(event);
   }
   if (typeof SDL != "undefined") {
    Browser.mouseX = SDL.mouseX + Browser.mouseMovementX;
    Browser.mouseY = SDL.mouseY + Browser.mouseMovementY;
   } else {
    Browser.mouseX += Browser.mouseMovementX;
    Browser.mouseY += Browser.mouseMovementY;
   }
  } else {
   var rect = Module["canvas"].getBoundingClientRect();
   var cw = Module["canvas"].width;
   var ch = Module["canvas"].height;
   var scrollX = typeof window.scrollX !== "undefined" ? window.scrollX : window.pageXOffset;
   var scrollY = typeof window.scrollY !== "undefined" ? window.scrollY : window.pageYOffset;
   assert(typeof scrollX !== "undefined" && typeof scrollY !== "undefined", "Unable to retrieve scroll position, mouse positions likely broken.");
   if (event.type === "touchstart" || event.type === "touchend" || event.type === "touchmove") {
    var touch = event.touch;
    if (touch === undefined) {
     return;
    }
    var adjustedX = touch.pageX - (scrollX + rect.left);
    var adjustedY = touch.pageY - (scrollY + rect.top);
    adjustedX = adjustedX * (cw / rect.width);
    adjustedY = adjustedY * (ch / rect.height);
    var coords = {
     x: adjustedX,
     y: adjustedY
    };
    if (event.type === "touchstart") {
     Browser.lastTouches[touch.identifier] = coords;
     Browser.touches[touch.identifier] = coords;
    } else if (event.type === "touchend" || event.type === "touchmove") {
     var last = Browser.touches[touch.identifier];
     if (!last) last = coords;
     Browser.lastTouches[touch.identifier] = last;
     Browser.touches[touch.identifier] = coords;
    }
    return;
   }
   var x = event.pageX - (scrollX + rect.left);
   var y = event.pageY - (scrollY + rect.top);
   x = x * (cw / rect.width);
   y = y * (ch / rect.height);
   Browser.mouseMovementX = x - Browser.mouseX;
   Browser.mouseMovementY = y - Browser.mouseY;
   Browser.mouseX = x;
   Browser.mouseY = y;
  }
 }),
 asyncLoad: (function(url, onload, onerror, noRunDep) {
  Module["readAsync"](url, (function(arrayBuffer) {
   assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
   onload(new Uint8Array(arrayBuffer));
   if (!noRunDep) removeRunDependency("al " + url);
  }), (function(event) {
   if (onerror) {
    onerror();
   } else {
    throw 'Loading data file "' + url + '" failed.';
   }
  }));
  if (!noRunDep) addRunDependency("al " + url);
 }),
 resizeListeners: [],
 updateResizeListeners: (function() {
  var canvas = Module["canvas"];
  Browser.resizeListeners.forEach((function(listener) {
   listener(canvas.width, canvas.height);
  }));
 }),
 setCanvasSize: (function(width, height, noUpdates) {
  var canvas = Module["canvas"];
  Browser.updateCanvasDimensions(canvas, width, height);
  if (!noUpdates) Browser.updateResizeListeners();
 }),
 windowedWidth: 0,
 windowedHeight: 0,
 setFullscreenCanvasSize: (function() {
  if (typeof SDL != "undefined") {
   var flags = HEAPU32[SDL.screen + Runtime.QUANTUM_SIZE * 0 >> 2];
   flags = flags | 8388608;
   HEAP32[SDL.screen + Runtime.QUANTUM_SIZE * 0 >> 2] = flags;
  }
  Browser.updateResizeListeners();
 }),
 setWindowedCanvasSize: (function() {
  if (typeof SDL != "undefined") {
   var flags = HEAPU32[SDL.screen + Runtime.QUANTUM_SIZE * 0 >> 2];
   flags = flags & ~8388608;
   HEAP32[SDL.screen + Runtime.QUANTUM_SIZE * 0 >> 2] = flags;
  }
  Browser.updateResizeListeners();
 }),
 updateCanvasDimensions: (function(canvas, wNative, hNative) {
  if (wNative && hNative) {
   canvas.widthNative = wNative;
   canvas.heightNative = hNative;
  } else {
   wNative = canvas.widthNative;
   hNative = canvas.heightNative;
  }
  var w = wNative;
  var h = hNative;
  if (Module["forcedAspectRatio"] && Module["forcedAspectRatio"] > 0) {
   if (w / h < Module["forcedAspectRatio"]) {
    w = Math.round(h * Module["forcedAspectRatio"]);
   } else {
    h = Math.round(w / Module["forcedAspectRatio"]);
   }
  }
  if ((document["fullscreenElement"] || document["mozFullScreenElement"] || document["msFullscreenElement"] || document["webkitFullscreenElement"] || document["webkitCurrentFullScreenElement"]) === canvas.parentNode && typeof screen != "undefined") {
   var factor = Math.min(screen.width / w, screen.height / h);
   w = Math.round(w * factor);
   h = Math.round(h * factor);
  }
  if (Browser.resizeCanvas) {
   if (canvas.width != w) canvas.width = w;
   if (canvas.height != h) canvas.height = h;
   if (typeof canvas.style != "undefined") {
    canvas.style.removeProperty("width");
    canvas.style.removeProperty("height");
   }
  } else {
   if (canvas.width != wNative) canvas.width = wNative;
   if (canvas.height != hNative) canvas.height = hNative;
   if (typeof canvas.style != "undefined") {
    if (w != wNative || h != hNative) {
     canvas.style.setProperty("width", w + "px", "important");
     canvas.style.setProperty("height", h + "px", "important");
    } else {
     canvas.style.removeProperty("width");
     canvas.style.removeProperty("height");
    }
   }
  }
 }),
 wgetRequests: {},
 nextWgetRequestHandle: 0,
 getNextWgetRequestHandle: (function() {
  var handle = Browser.nextWgetRequestHandle;
  Browser.nextWgetRequestHandle++;
  return handle;
 })
};
Module["Browser"] = Browser;
function _emscripten_set_main_loop_timing(mode, value) {
 Browser.mainLoop.timingMode = mode;
 Browser.mainLoop.timingValue = value;
 if (!Browser.mainLoop.func) {
  console.error("emscripten_set_main_loop_timing: Cannot set timing mode for main loop since a main loop does not exist! Call emscripten_set_main_loop first to set one up.");
  return 1;
 }
 if (mode == 0) {
  Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler_setTimeout() {
   var timeUntilNextTick = Math.max(0, Browser.mainLoop.tickStartTime + value - _emscripten_get_now()) | 0;
   setTimeout(Browser.mainLoop.runner, timeUntilNextTick);
  };
  Browser.mainLoop.method = "timeout";
 } else if (mode == 1) {
  Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler_rAF() {
   Browser.requestAnimationFrame(Browser.mainLoop.runner);
  };
  Browser.mainLoop.method = "rAF";
 } else if (mode == 2) {
  if (!window["setImmediate"]) {
   var setImmediates = [];
   var emscriptenMainLoopMessageId = "__emcc";
   function Browser_setImmediate_messageHandler(event) {
    if (event.source === window && event.data === emscriptenMainLoopMessageId) {
     event.stopPropagation();
     setImmediates.shift()();
    }
   }
   window.addEventListener("message", Browser_setImmediate_messageHandler, true);
   window["setImmediate"] = function Browser_emulated_setImmediate(func) {
    setImmediates.push(func);
    window.postMessage(emscriptenMainLoopMessageId, "*");
   };
  }
  Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler_setImmediate() {
   window["setImmediate"](Browser.mainLoop.runner);
  };
  Browser.mainLoop.method = "immediate";
 }
 return 0;
}
Module["_emscripten_set_main_loop_timing"] = _emscripten_set_main_loop_timing;
function _il2cpp_class_get_type() {
 if (!Module["_il2cpp_class_get_type"]) abort("external function 'il2cpp_class_get_type' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_get_type"].apply(null, arguments);
}
function _fork() {
 ___setErrNo(ERRNO_CODES.EAGAIN);
 return -1;
}
Module["_fork"] = _fork;
function _posix_spawn() {
 return _fork.apply(null, arguments);
}
Module["_posix_spawn"] = _posix_spawn;
function _inet_addr(ptr) {
 var addr = __inet_pton4_raw(Pointer_stringify(ptr));
 if (addr === null) {
  return -1;
 }
 return addr;
}
Module["_inet_addr"] = _inet_addr;
Module["_pthread_mutex_lock"] = _pthread_mutex_lock;
function _free() {}
Module["_free"] = _free;
function ___cxa_free_exception(ptr) {
 try {
  return _free(ptr);
 } catch (e) {
  Module.printErr("exception during cxa_free_exception: " + e);
 }
}
Module["___cxa_free_exception"] = ___cxa_free_exception;
var EXCEPTIONS = {
 last: 0,
 caught: [],
 infos: {},
 deAdjust: (function(adjusted) {
  if (!adjusted || EXCEPTIONS.infos[adjusted]) return adjusted;
  for (var ptr in EXCEPTIONS.infos) {
   var info = EXCEPTIONS.infos[ptr];
   if (info.adjusted === adjusted) {
    return ptr;
   }
  }
  return adjusted;
 }),
 addRef: (function(ptr) {
  if (!ptr) return;
  var info = EXCEPTIONS.infos[ptr];
  info.refcount++;
 }),
 decRef: (function(ptr) {
  if (!ptr) return;
  var info = EXCEPTIONS.infos[ptr];
  assert(info.refcount > 0);
  info.refcount--;
  if (info.refcount === 0) {
   if (info.destructor) {
    Runtime.dynCall("vi", info.destructor, [ ptr ]);
   }
   delete EXCEPTIONS.infos[ptr];
   ___cxa_free_exception(ptr);
  }
 }),
 clearRef: (function(ptr) {
  if (!ptr) return;
  var info = EXCEPTIONS.infos[ptr];
  info.refcount = 0;
 })
};
Module["EXCEPTIONS"] = EXCEPTIONS;
function ___cxa_end_catch() {
 if (___cxa_end_catch.rethrown) {
  ___cxa_end_catch.rethrown = false;
  return;
 }
 asm["setThrew"](0);
 var ptr = EXCEPTIONS.caught.pop();
 if (ptr) {
  EXCEPTIONS.decRef(EXCEPTIONS.deAdjust(ptr));
  EXCEPTIONS.last = 0;
 }
}
Module["___cxa_end_catch"] = ___cxa_end_catch;
function _emscripten_glStencilFunc(x0, x1, x2) {
 GLctx.stencilFunc(x0, x1, x2);
}
Module["_emscripten_glStencilFunc"] = _emscripten_glStencilFunc;
var fs = {
 numPendingSync: 0,
 syncIntervalID: 0,
 syncInProgress: false,
 sync: (function(onlyPendingSync) {
  if (onlyPendingSync) {
   if (fs.numPendingSync == 0) return;
  } else if (fs.syncInProgress) {
   fs.numPendingSync++;
   return;
  }
  fs.syncInProgress = true;
  FS.syncfs(false, (function(err) {
   fs.syncInProgress = false;
  }));
  fs.numPendingSync = 0;
 })
};
Module["fs"] = fs;
function _JS_FileSystem_HasIndexedDB() {
 return !!Module.indexedDB;
}
Module["_JS_FileSystem_HasIndexedDB"] = _JS_FileSystem_HasIndexedDB;
function emscriptenWebGLGetUniform(program, location, params, type) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 var data = GLctx.getUniform(GL.programs[program], GL.uniforms[location]);
 if (typeof data == "number" || typeof data == "boolean") {
  switch (type) {
  case "Integer":
   HEAP32[params >> 2] = data;
   break;
  case "Float":
   HEAPF32[params >> 2] = data;
   break;
  default:
   throw "internal emscriptenWebGLGetUniform() error, bad type: " + type;
  }
 } else {
  for (var i = 0; i < data.length; i++) {
   switch (type) {
   case "Integer":
    HEAP32[params + i >> 2] = data[i];
    break;
   case "Float":
    HEAPF32[params + i >> 2] = data[i];
    break;
   default:
    throw "internal emscriptenWebGLGetUniform() error, bad type: " + type;
   }
  }
 }
}
Module["emscriptenWebGLGetUniform"] = emscriptenWebGLGetUniform;
function _glGetUniformiv(program, location, params) {
 emscriptenWebGLGetUniform(program, location, params, "Integer");
}
Module["_glGetUniformiv"] = _glGetUniformiv;
function _il2cpp_method_get_name() {
 if (!Module["_il2cpp_method_get_name"]) abort("external function 'il2cpp_method_get_name' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_method_get_name"].apply(null, arguments);
}
function _emscripten_glVertexPointer() {
 throw "Legacy GL function (glVertexPointer) called. If you want legacy GL emulation, you need to compile with -s LEGACY_GL_EMULATION=1 to enable legacy GL emulation.";
}
Module["_emscripten_glVertexPointer"] = _emscripten_glVertexPointer;
var ERRNO_MESSAGES = {
 0: "Success",
 1: "Not super-user",
 2: "No such file or directory",
 3: "No such process",
 4: "Interrupted system call",
 5: "I/O error",
 6: "No such device or address",
 7: "Arg list too long",
 8: "Exec format error",
 9: "Bad file number",
 10: "No children",
 11: "No more processes",
 12: "Not enough core",
 13: "Permission denied",
 14: "Bad address",
 15: "Block device required",
 16: "Mount device busy",
 17: "File exists",
 18: "Cross-device link",
 19: "No such device",
 20: "Not a directory",
 21: "Is a directory",
 22: "Invalid argument",
 23: "Too many open files in system",
 24: "Too many open files",
 25: "Not a typewriter",
 26: "Text file busy",
 27: "File too large",
 28: "No space left on device",
 29: "Illegal seek",
 30: "Read only file system",
 31: "Too many links",
 32: "Broken pipe",
 33: "Math arg out of domain of func",
 34: "Math result not representable",
 35: "File locking deadlock error",
 36: "File or path name too long",
 37: "No record locks available",
 38: "Function not implemented",
 39: "Directory not empty",
 40: "Too many symbolic links",
 42: "No message of desired type",
 43: "Identifier removed",
 44: "Channel number out of range",
 45: "Level 2 not synchronized",
 46: "Level 3 halted",
 47: "Level 3 reset",
 48: "Link number out of range",
 49: "Protocol driver not attached",
 50: "No CSI structure available",
 51: "Level 2 halted",
 52: "Invalid exchange",
 53: "Invalid request descriptor",
 54: "Exchange full",
 55: "No anode",
 56: "Invalid request code",
 57: "Invalid slot",
 59: "Bad font file fmt",
 60: "Device not a stream",
 61: "No data (for no delay io)",
 62: "Timer expired",
 63: "Out of streams resources",
 64: "Machine is not on the network",
 65: "Package not installed",
 66: "The object is remote",
 67: "The link has been severed",
 68: "Advertise error",
 69: "Srmount error",
 70: "Communication error on send",
 71: "Protocol error",
 72: "Multihop attempted",
 73: "Cross mount point (not really error)",
 74: "Trying to read unreadable message",
 75: "Value too large for defined data type",
 76: "Given log. name not unique",
 77: "f.d. invalid for this operation",
 78: "Remote address changed",
 79: "Can   access a needed shared lib",
 80: "Accessing a corrupted shared lib",
 81: ".lib section in a.out corrupted",
 82: "Attempting to link in too many libs",
 83: "Attempting to exec a shared library",
 84: "Illegal byte sequence",
 86: "Streams pipe error",
 87: "Too many users",
 88: "Socket operation on non-socket",
 89: "Destination address required",
 90: "Message too long",
 91: "Protocol wrong type for socket",
 92: "Protocol not available",
 93: "Unknown protocol",
 94: "Socket type not supported",
 95: "Not supported",
 96: "Protocol family not supported",
 97: "Address family not supported by protocol family",
 98: "Address already in use",
 99: "Address not available",
 100: "Network interface is not configured",
 101: "Network is unreachable",
 102: "Connection reset by network",
 103: "Connection aborted",
 104: "Connection reset by peer",
 105: "No buffer space available",
 106: "Socket is already connected",
 107: "Socket is not connected",
 108: "Can't send after socket shutdown",
 109: "Too many references",
 110: "Connection timed out",
 111: "Connection refused",
 112: "Host is down",
 113: "Host is unreachable",
 114: "Socket already connected",
 115: "Connection already in progress",
 116: "Stale file handle",
 122: "Quota exceeded",
 123: "No medium (in tape drive)",
 125: "Operation canceled",
 130: "Previous owner died",
 131: "State not recoverable"
};
Module["ERRNO_MESSAGES"] = ERRNO_MESSAGES;
var PATH = {
 splitPath: (function(filename) {
  var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
  return splitPathRe.exec(filename).slice(1);
 }),
 normalizeArray: (function(parts, allowAboveRoot) {
  var up = 0;
  for (var i = parts.length - 1; i >= 0; i--) {
   var last = parts[i];
   if (last === ".") {
    parts.splice(i, 1);
   } else if (last === "..") {
    parts.splice(i, 1);
    up++;
   } else if (up) {
    parts.splice(i, 1);
    up--;
   }
  }
  if (allowAboveRoot) {
   for (; up--; up) {
    parts.unshift("..");
   }
  }
  return parts;
 }),
 normalize: (function(path) {
  var isAbsolute = path.charAt(0) === "/", trailingSlash = path.substr(-1) === "/";
  path = PATH.normalizeArray(path.split("/").filter((function(p) {
   return !!p;
  })), !isAbsolute).join("/");
  if (!path && !isAbsolute) {
   path = ".";
  }
  if (path && trailingSlash) {
   path += "/";
  }
  return (isAbsolute ? "/" : "") + path;
 }),
 dirname: (function(path) {
  var result = PATH.splitPath(path), root = result[0], dir = result[1];
  if (!root && !dir) {
   return ".";
  }
  if (dir) {
   dir = dir.substr(0, dir.length - 1);
  }
  return root + dir;
 }),
 basename: (function(path) {
  if (path === "/") return "/";
  var lastSlash = path.lastIndexOf("/");
  if (lastSlash === -1) return path;
  return path.substr(lastSlash + 1);
 }),
 extname: (function(path) {
  return PATH.splitPath(path)[3];
 }),
 join: (function() {
  var paths = Array.prototype.slice.call(arguments, 0);
  return PATH.normalize(paths.join("/"));
 }),
 join2: (function(l, r) {
  return PATH.normalize(l + "/" + r);
 }),
 resolve: (function() {
  var resolvedPath = "", resolvedAbsolute = false;
  for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
   var path = i >= 0 ? arguments[i] : FS.cwd();
   if (typeof path !== "string") {
    throw new TypeError("Arguments to path.resolve must be strings");
   } else if (!path) {
    return "";
   }
   resolvedPath = path + "/" + resolvedPath;
   resolvedAbsolute = path.charAt(0) === "/";
  }
  resolvedPath = PATH.normalizeArray(resolvedPath.split("/").filter((function(p) {
   return !!p;
  })), !resolvedAbsolute).join("/");
  return (resolvedAbsolute ? "/" : "") + resolvedPath || ".";
 }),
 relative: (function(from, to) {
  from = PATH.resolve(from).substr(1);
  to = PATH.resolve(to).substr(1);
  function trim(arr) {
   var start = 0;
   for (; start < arr.length; start++) {
    if (arr[start] !== "") break;
   }
   var end = arr.length - 1;
   for (; end >= 0; end--) {
    if (arr[end] !== "") break;
   }
   if (start > end) return [];
   return arr.slice(start, end - start + 1);
  }
  var fromParts = trim(from.split("/"));
  var toParts = trim(to.split("/"));
  var length = Math.min(fromParts.length, toParts.length);
  var samePartsLength = length;
  for (var i = 0; i < length; i++) {
   if (fromParts[i] !== toParts[i]) {
    samePartsLength = i;
    break;
   }
  }
  var outputParts = [];
  for (var i = samePartsLength; i < fromParts.length; i++) {
   outputParts.push("..");
  }
  outputParts = outputParts.concat(toParts.slice(samePartsLength));
  return outputParts.join("/");
 })
};
Module["PATH"] = PATH;
var TTY = {
 ttys: [],
 init: (function() {}),
 shutdown: (function() {}),
 register: (function(dev, ops) {
  TTY.ttys[dev] = {
   input: [],
   output: [],
   ops: ops
  };
  FS.registerDevice(dev, TTY.stream_ops);
 }),
 stream_ops: {
  open: (function(stream) {
   var tty = TTY.ttys[stream.node.rdev];
   if (!tty) {
    throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
   }
   stream.tty = tty;
   stream.seekable = false;
  }),
  close: (function(stream) {
   stream.tty.ops.flush(stream.tty);
  }),
  flush: (function(stream) {
   stream.tty.ops.flush(stream.tty);
  }),
  read: (function(stream, buffer, offset, length, pos) {
   if (!stream.tty || !stream.tty.ops.get_char) {
    throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
   }
   var bytesRead = 0;
   for (var i = 0; i < length; i++) {
    var result;
    try {
     result = stream.tty.ops.get_char(stream.tty);
    } catch (e) {
     throw new FS.ErrnoError(ERRNO_CODES.EIO);
    }
    if (result === undefined && bytesRead === 0) {
     throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
    }
    if (result === null || result === undefined) break;
    bytesRead++;
    buffer[offset + i] = result;
   }
   if (bytesRead) {
    stream.node.timestamp = Date.now();
   }
   return bytesRead;
  }),
  write: (function(stream, buffer, offset, length, pos) {
   if (!stream.tty || !stream.tty.ops.put_char) {
    throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
   }
   for (var i = 0; i < length; i++) {
    try {
     stream.tty.ops.put_char(stream.tty, buffer[offset + i]);
    } catch (e) {
     throw new FS.ErrnoError(ERRNO_CODES.EIO);
    }
   }
   if (length) {
    stream.node.timestamp = Date.now();
   }
   return i;
  })
 },
 default_tty_ops: {
  get_char: (function(tty) {
   if (!tty.input.length) {
    var result = null;
    if (ENVIRONMENT_IS_NODE) {
     var BUFSIZE = 256;
     var buf = new Buffer(BUFSIZE);
     var bytesRead = 0;
     var isPosixPlatform = process.platform != "win32";
     var fd = process.stdin.fd;
     if (isPosixPlatform) {
      var usingDevice = false;
      try {
       fd = fs.openSync("/dev/stdin", "r");
       usingDevice = true;
      } catch (e) {}
     }
     try {
      bytesRead = fs.readSync(fd, buf, 0, BUFSIZE, null);
     } catch (e) {
      if (e.toString().indexOf("EOF") != -1) bytesRead = 0; else throw e;
     }
     if (usingDevice) {
      fs.closeSync(fd);
     }
     if (bytesRead > 0) {
      result = buf.slice(0, bytesRead).toString("utf-8");
     } else {
      result = null;
     }
    } else if (typeof window != "undefined" && typeof window.prompt == "function") {
     result = window.prompt("Input: ");
     if (result !== null) {
      result += "\n";
     }
    } else if (typeof readline == "function") {
     result = readline();
     if (result !== null) {
      result += "\n";
     }
    }
    if (!result) {
     return null;
    }
    tty.input = intArrayFromString(result, true);
   }
   return tty.input.shift();
  }),
  put_char: (function(tty, val) {
   if (val === null || val === 10) {
    Module["print"](UTF8ArrayToString(tty.output, 0));
    tty.output = [];
   } else {
    if (val != 0) tty.output.push(val);
   }
  }),
  flush: (function(tty) {
   if (tty.output && tty.output.length > 0) {
    Module["print"](UTF8ArrayToString(tty.output, 0));
    tty.output = [];
   }
  })
 },
 default_tty1_ops: {
  put_char: (function(tty, val) {
   if (val === null || val === 10) {
    Module["printErr"](UTF8ArrayToString(tty.output, 0));
    tty.output = [];
   } else {
    if (val != 0) tty.output.push(val);
   }
  }),
  flush: (function(tty) {
   if (tty.output && tty.output.length > 0) {
    Module["printErr"](UTF8ArrayToString(tty.output, 0));
    tty.output = [];
   }
  })
 }
};
Module["TTY"] = TTY;
var MEMFS = {
 ops_table: null,
 mount: (function(mount) {
  return MEMFS.createNode(null, "/", 16384 | 511, 0);
 }),
 createNode: (function(parent, name, mode, dev) {
  if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
   throw new FS.ErrnoError(ERRNO_CODES.EPERM);
  }
  if (!MEMFS.ops_table) {
   MEMFS.ops_table = {
    dir: {
     node: {
      getattr: MEMFS.node_ops.getattr,
      setattr: MEMFS.node_ops.setattr,
      lookup: MEMFS.node_ops.lookup,
      mknod: MEMFS.node_ops.mknod,
      rename: MEMFS.node_ops.rename,
      unlink: MEMFS.node_ops.unlink,
      rmdir: MEMFS.node_ops.rmdir,
      readdir: MEMFS.node_ops.readdir,
      symlink: MEMFS.node_ops.symlink
     },
     stream: {
      llseek: MEMFS.stream_ops.llseek
     }
    },
    file: {
     node: {
      getattr: MEMFS.node_ops.getattr,
      setattr: MEMFS.node_ops.setattr
     },
     stream: {
      llseek: MEMFS.stream_ops.llseek,
      read: MEMFS.stream_ops.read,
      write: MEMFS.stream_ops.write,
      allocate: MEMFS.stream_ops.allocate,
      mmap: MEMFS.stream_ops.mmap,
      msync: MEMFS.stream_ops.msync
     }
    },
    link: {
     node: {
      getattr: MEMFS.node_ops.getattr,
      setattr: MEMFS.node_ops.setattr,
      readlink: MEMFS.node_ops.readlink
     },
     stream: {}
    },
    chrdev: {
     node: {
      getattr: MEMFS.node_ops.getattr,
      setattr: MEMFS.node_ops.setattr
     },
     stream: FS.chrdev_stream_ops
    }
   };
  }
  var node = FS.createNode(parent, name, mode, dev);
  if (FS.isDir(node.mode)) {
   node.node_ops = MEMFS.ops_table.dir.node;
   node.stream_ops = MEMFS.ops_table.dir.stream;
   node.contents = {};
  } else if (FS.isFile(node.mode)) {
   node.node_ops = MEMFS.ops_table.file.node;
   node.stream_ops = MEMFS.ops_table.file.stream;
   node.usedBytes = 0;
   node.contents = null;
  } else if (FS.isLink(node.mode)) {
   node.node_ops = MEMFS.ops_table.link.node;
   node.stream_ops = MEMFS.ops_table.link.stream;
  } else if (FS.isChrdev(node.mode)) {
   node.node_ops = MEMFS.ops_table.chrdev.node;
   node.stream_ops = MEMFS.ops_table.chrdev.stream;
  }
  node.timestamp = Date.now();
  if (parent) {
   parent.contents[name] = node;
  }
  return node;
 }),
 getFileDataAsRegularArray: (function(node) {
  if (node.contents && node.contents.subarray) {
   var arr = [];
   for (var i = 0; i < node.usedBytes; ++i) arr.push(node.contents[i]);
   return arr;
  }
  return node.contents;
 }),
 getFileDataAsTypedArray: (function(node) {
  if (!node.contents) return new Uint8Array;
  if (node.contents.subarray) return node.contents.subarray(0, node.usedBytes);
  return new Uint8Array(node.contents);
 }),
 expandFileStorage: (function(node, newCapacity) {
  if (!node.contents || node.contents.subarray) {
   var prevCapacity = node.contents ? node.contents.length : 0;
   if (prevCapacity >= newCapacity) return;
   var CAPACITY_DOUBLING_MAX = 1024 * 1024;
   newCapacity = Math.max(newCapacity, prevCapacity * (prevCapacity < CAPACITY_DOUBLING_MAX ? 2 : 1.125) | 0);
   if (prevCapacity != 0) newCapacity = Math.max(newCapacity, 256);
   var oldContents = node.contents;
   node.contents = new Uint8Array(newCapacity);
   if (node.usedBytes > 0) node.contents.set(oldContents.subarray(0, node.usedBytes), 0);
   return;
  }
  if (!node.contents && newCapacity > 0) node.contents = [];
  while (node.contents.length < newCapacity) node.contents.push(0);
 }),
 resizeFileStorage: (function(node, newSize) {
  if (node.usedBytes == newSize) return;
  if (newSize == 0) {
   node.contents = null;
   node.usedBytes = 0;
   return;
  }
  if (!node.contents || node.contents.subarray) {
   var oldContents = node.contents;
   node.contents = new Uint8Array(new ArrayBuffer(newSize));
   if (oldContents) {
    node.contents.set(oldContents.subarray(0, Math.min(newSize, node.usedBytes)));
   }
   node.usedBytes = newSize;
   return;
  }
  if (!node.contents) node.contents = [];
  if (node.contents.length > newSize) node.contents.length = newSize; else while (node.contents.length < newSize) node.contents.push(0);
  node.usedBytes = newSize;
 }),
 node_ops: {
  getattr: (function(node) {
   var attr = {};
   attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
   attr.ino = node.id;
   attr.mode = node.mode;
   attr.nlink = 1;
   attr.uid = 0;
   attr.gid = 0;
   attr.rdev = node.rdev;
   if (FS.isDir(node.mode)) {
    attr.size = 4096;
   } else if (FS.isFile(node.mode)) {
    attr.size = node.usedBytes;
   } else if (FS.isLink(node.mode)) {
    attr.size = node.link.length;
   } else {
    attr.size = 0;
   }
   attr.atime = new Date(node.timestamp);
   attr.mtime = new Date(node.timestamp);
   attr.ctime = new Date(node.timestamp);
   attr.blksize = 4096;
   attr.blocks = Math.ceil(attr.size / attr.blksize);
   return attr;
  }),
  setattr: (function(node, attr) {
   if (attr.mode !== undefined) {
    node.mode = attr.mode;
   }
   if (attr.timestamp !== undefined) {
    node.timestamp = attr.timestamp;
   }
   if (attr.size !== undefined) {
    MEMFS.resizeFileStorage(node, attr.size);
   }
  }),
  lookup: (function(parent, name) {
   throw FS.genericErrors[ERRNO_CODES.ENOENT];
  }),
  mknod: (function(parent, name, mode, dev) {
   return MEMFS.createNode(parent, name, mode, dev);
  }),
  rename: (function(old_node, new_dir, new_name) {
   if (FS.isDir(old_node.mode)) {
    var new_node;
    try {
     new_node = FS.lookupNode(new_dir, new_name);
    } catch (e) {}
    if (new_node) {
     for (var i in new_node.contents) {
      throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
     }
    }
   }
   delete old_node.parent.contents[old_node.name];
   old_node.name = new_name;
   new_dir.contents[new_name] = old_node;
   old_node.parent = new_dir;
  }),
  unlink: (function(parent, name) {
   delete parent.contents[name];
  }),
  rmdir: (function(parent, name) {
   var node = FS.lookupNode(parent, name);
   for (var i in node.contents) {
    throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
   }
   delete parent.contents[name];
  }),
  readdir: (function(node) {
   var entries = [ ".", ".." ];
   for (var key in node.contents) {
    if (!node.contents.hasOwnProperty(key)) {
     continue;
    }
    entries.push(key);
   }
   return entries;
  }),
  symlink: (function(parent, newname, oldpath) {
   var node = MEMFS.createNode(parent, newname, 511 | 40960, 0);
   node.link = oldpath;
   return node;
  }),
  readlink: (function(node) {
   if (!FS.isLink(node.mode)) {
    throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
   }
   return node.link;
  })
 },
 stream_ops: {
  read: (function(stream, buffer, offset, length, position) {
   var contents = stream.node.contents;
   if (position >= stream.node.usedBytes) return 0;
   var size = Math.min(stream.node.usedBytes - position, length);
   assert(size >= 0);
   if (size > 8 && contents.subarray) {
    buffer.set(contents.subarray(position, position + size), offset);
   } else {
    for (var i = 0; i < size; i++) buffer[offset + i] = contents[position + i];
   }
   return size;
  }),
  write: (function(stream, buffer, offset, length, position, canOwn) {
   if (!length) return 0;
   var node = stream.node;
   node.timestamp = Date.now();
   if (buffer.subarray && (!node.contents || node.contents.subarray)) {
    if (canOwn) {
     assert(position === 0, "canOwn must imply no weird position inside the file");
     node.contents = buffer.subarray(offset, offset + length);
     node.usedBytes = length;
     return length;
    } else if (node.usedBytes === 0 && position === 0) {
     node.contents = new Uint8Array(buffer.subarray(offset, offset + length));
     node.usedBytes = length;
     return length;
    } else if (position + length <= node.usedBytes) {
     node.contents.set(buffer.subarray(offset, offset + length), position);
     return length;
    }
   }
   MEMFS.expandFileStorage(node, position + length);
   if (node.contents.subarray && buffer.subarray) node.contents.set(buffer.subarray(offset, offset + length), position); else {
    for (var i = 0; i < length; i++) {
     node.contents[position + i] = buffer[offset + i];
    }
   }
   node.usedBytes = Math.max(node.usedBytes, position + length);
   return length;
  }),
  llseek: (function(stream, offset, whence) {
   var position = offset;
   if (whence === 1) {
    position += stream.position;
   } else if (whence === 2) {
    if (FS.isFile(stream.node.mode)) {
     position += stream.node.usedBytes;
    }
   }
   if (position < 0) {
    throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
   }
   return position;
  }),
  allocate: (function(stream, offset, length) {
   MEMFS.expandFileStorage(stream.node, offset + length);
   stream.node.usedBytes = Math.max(stream.node.usedBytes, offset + length);
  }),
  mmap: (function(stream, buffer, offset, length, position, prot, flags) {
   if (!FS.isFile(stream.node.mode)) {
    throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
   }
   var ptr;
   var allocated;
   var contents = stream.node.contents;
   if (!(flags & 2) && (contents.buffer === buffer || contents.buffer === buffer.buffer)) {
    allocated = false;
    ptr = contents.byteOffset;
   } else {
    if (position > 0 || position + length < stream.node.usedBytes) {
     if (contents.subarray) {
      contents = contents.subarray(position, position + length);
     } else {
      contents = Array.prototype.slice.call(contents, position, position + length);
     }
    }
    allocated = true;
    ptr = _malloc(length);
    if (!ptr) {
     throw new FS.ErrnoError(ERRNO_CODES.ENOMEM);
    }
    buffer.set(contents, ptr);
   }
   return {
    ptr: ptr,
    allocated: allocated
   };
  }),
  msync: (function(stream, buffer, offset, length, mmapFlags) {
   if (!FS.isFile(stream.node.mode)) {
    throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
   }
   if (mmapFlags & 2) {
    return 0;
   }
   var bytesWritten = MEMFS.stream_ops.write(stream, buffer, 0, length, offset, false);
   return 0;
  })
 }
};
Module["MEMFS"] = MEMFS;
var IDBFS = {
 dbs: {},
 indexedDB: (function() {
  return Module.indexedDB;
 }),
 DB_VERSION: 21,
 DB_STORE_NAME: "FILE_DATA",
 mount: (function(mount) {
  return MEMFS.mount.apply(null, arguments);
 }),
 syncfs: (function(mount, populate, callback) {
  IDBFS.getLocalSet(mount, (function(err, local) {
   if (err) return callback(err);
   IDBFS.getRemoteSet(mount, (function(err, remote) {
    if (err) return callback(err);
    var src = populate ? remote : local;
    var dst = populate ? local : remote;
    IDBFS.reconcile(src, dst, callback);
   }));
  }));
 }),
 getDB: (function(name, callback) {
  var db = IDBFS.dbs[name];
  if (db) {
   return callback(null, db);
  }
  var req;
  try {
   req = IDBFS.indexedDB().open(name, IDBFS.DB_VERSION);
  } catch (e) {
   return callback(e);
  }
  if (!req) {
   return callback("Unable to connect to IndexedDB");
  }
  req.onupgradeneeded = (function(e) {
   var db = e.target.result;
   var transaction = e.target.transaction;
   var fileStore;
   if (db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)) {
    fileStore = transaction.objectStore(IDBFS.DB_STORE_NAME);
   } else {
    fileStore = db.createObjectStore(IDBFS.DB_STORE_NAME);
   }
   if (!fileStore.indexNames.contains("timestamp")) {
    fileStore.createIndex("timestamp", "timestamp", {
     unique: false
    });
   }
  });
  req.onsuccess = (function() {
   db = req.result;
   IDBFS.dbs[name] = db;
   callback(null, db);
  });
  req.onerror = (function(e) {
   callback(this.error);
   e.preventDefault();
  });
 }),
 getLocalSet: (function(mount, callback) {
  var entries = {};
  function isRealDir(p) {
   return p !== "." && p !== "..";
  }
  function toAbsolute(root) {
   return (function(p) {
    return PATH.join2(root, p);
   });
  }
  var check = FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));
  while (check.length) {
   var path = check.pop();
   var stat;
   try {
    stat = FS.stat(path);
   } catch (e) {
    return callback(e);
   }
   if (FS.isDir(stat.mode)) {
    check.push.apply(check, FS.readdir(path).filter(isRealDir).map(toAbsolute(path)));
   }
   entries[path] = {
    timestamp: stat.mtime
   };
  }
  return callback(null, {
   type: "local",
   entries: entries
  });
 }),
 getRemoteSet: (function(mount, callback) {
  var entries = {};
  IDBFS.getDB(mount.mountpoint, (function(err, db) {
   if (err) return callback(err);
   var transaction = db.transaction([ IDBFS.DB_STORE_NAME ], "readonly");
   transaction.onerror = (function(e) {
    callback(this.error);
    e.preventDefault();
   });
   var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
   var index = store.index("timestamp");
   index.openKeyCursor().onsuccess = (function(event) {
    var cursor = event.target.result;
    if (!cursor) {
     return callback(null, {
      type: "remote",
      db: db,
      entries: entries
     });
    }
    entries[cursor.primaryKey] = {
     timestamp: cursor.key
    };
    cursor.continue();
   });
  }));
 }),
 loadLocalEntry: (function(path, callback) {
  var stat, node;
  try {
   var lookup = FS.lookupPath(path);
   node = lookup.node;
   stat = FS.stat(path);
  } catch (e) {
   return callback(e);
  }
  if (FS.isDir(stat.mode)) {
   return callback(null, {
    timestamp: stat.mtime,
    mode: stat.mode
   });
  } else if (FS.isFile(stat.mode)) {
   node.contents = MEMFS.getFileDataAsTypedArray(node);
   return callback(null, {
    timestamp: stat.mtime,
    mode: stat.mode,
    contents: node.contents
   });
  } else {
   return callback(new Error("node type not supported"));
  }
 }),
 storeLocalEntry: (function(path, entry, callback) {
  try {
   if (FS.isDir(entry.mode)) {
    FS.mkdir(path, entry.mode);
   } else if (FS.isFile(entry.mode)) {
    FS.writeFile(path, entry.contents, {
     encoding: "binary",
     canOwn: true
    });
   } else {
    return callback(new Error("node type not supported"));
   }
   FS.chmod(path, entry.mode);
   FS.utime(path, entry.timestamp, entry.timestamp);
  } catch (e) {
   return callback(e);
  }
  callback(null);
 }),
 removeLocalEntry: (function(path, callback) {
  try {
   var lookup = FS.lookupPath(path);
   var stat = FS.stat(path);
   if (FS.isDir(stat.mode)) {
    FS.rmdir(path);
   } else if (FS.isFile(stat.mode)) {
    FS.unlink(path);
   }
  } catch (e) {
   return callback(e);
  }
  callback(null);
 }),
 loadRemoteEntry: (function(store, path, callback) {
  var req = store.get(path);
  req.onsuccess = (function(event) {
   callback(null, event.target.result);
  });
  req.onerror = (function(e) {
   callback(this.error);
   e.preventDefault();
  });
 }),
 storeRemoteEntry: (function(store, path, entry, callback) {
  var req = store.put(entry, path);
  req.onsuccess = (function() {
   callback(null);
  });
  req.onerror = (function(e) {
   callback(this.error);
   e.preventDefault();
  });
 }),
 removeRemoteEntry: (function(store, path, callback) {
  var req = store.delete(path);
  req.onsuccess = (function() {
   callback(null);
  });
  req.onerror = (function(e) {
   callback(this.error);
   e.preventDefault();
  });
 }),
 reconcile: (function(src, dst, callback) {
  var total = 0;
  var create = [];
  Object.keys(src.entries).forEach((function(key) {
   var e = src.entries[key];
   var e2 = dst.entries[key];
   if (!e2 || e.timestamp > e2.timestamp) {
    create.push(key);
    total++;
   }
  }));
  var remove = [];
  Object.keys(dst.entries).forEach((function(key) {
   var e = dst.entries[key];
   var e2 = src.entries[key];
   if (!e2) {
    remove.push(key);
    total++;
   }
  }));
  if (!total) {
   return callback(null);
  }
  var completed = 0;
  var db = src.type === "remote" ? src.db : dst.db;
  var transaction = db.transaction([ IDBFS.DB_STORE_NAME ], "readwrite");
  var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
  function done(err) {
   if (err) {
    if (!done.errored) {
     done.errored = true;
     return callback(err);
    }
    return;
   }
   if (++completed >= total) {
    return callback(null);
   }
  }
  transaction.onerror = (function(e) {
   done(this.error);
   e.preventDefault();
  });
  create.sort().forEach((function(path) {
   if (dst.type === "local") {
    IDBFS.loadRemoteEntry(store, path, (function(err, entry) {
     if (err) return done(err);
     IDBFS.storeLocalEntry(path, entry, done);
    }));
   } else {
    IDBFS.loadLocalEntry(path, (function(err, entry) {
     if (err) return done(err);
     IDBFS.storeRemoteEntry(store, path, entry, done);
    }));
   }
  }));
  remove.sort().reverse().forEach((function(path) {
   if (dst.type === "local") {
    IDBFS.removeLocalEntry(path, done);
   } else {
    IDBFS.removeRemoteEntry(store, path, done);
   }
  }));
 })
};
Module["IDBFS"] = IDBFS;
var NODEFS = {
 isWindows: false,
 staticInit: (function() {
  NODEFS.isWindows = !!process.platform.match(/^win/);
 }),
 mount: (function(mount) {
  assert(ENVIRONMENT_IS_NODE);
  return NODEFS.createNode(null, "/", NODEFS.getMode(mount.opts.root), 0);
 }),
 createNode: (function(parent, name, mode, dev) {
  if (!FS.isDir(mode) && !FS.isFile(mode) && !FS.isLink(mode)) {
   throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
  }
  var node = FS.createNode(parent, name, mode);
  node.node_ops = NODEFS.node_ops;
  node.stream_ops = NODEFS.stream_ops;
  return node;
 }),
 getMode: (function(path) {
  var stat;
  try {
   stat = fs.lstatSync(path);
   if (NODEFS.isWindows) {
    stat.mode = stat.mode | (stat.mode & 146) >> 1;
   }
  } catch (e) {
   if (!e.code) throw e;
   throw new FS.ErrnoError(ERRNO_CODES[e.code]);
  }
  return stat.mode;
 }),
 realPath: (function(node) {
  var parts = [];
  while (node.parent !== node) {
   parts.push(node.name);
   node = node.parent;
  }
  parts.push(node.mount.opts.root);
  parts.reverse();
  return PATH.join.apply(null, parts);
 }),
 flagsToPermissionStringMap: {
  0: "r",
  1: "r+",
  2: "r+",
  64: "r",
  65: "r+",
  66: "r+",
  129: "rx+",
  193: "rx+",
  514: "w+",
  577: "w",
  578: "w+",
  705: "wx",
  706: "wx+",
  1024: "a",
  1025: "a",
  1026: "a+",
  1089: "a",
  1090: "a+",
  1153: "ax",
  1154: "ax+",
  1217: "ax",
  1218: "ax+",
  4096: "rs",
  4098: "rs+"
 },
 flagsToPermissionString: (function(flags) {
  flags &= ~2097152;
  flags &= ~2048;
  flags &= ~32768;
  flags &= ~524288;
  if (flags in NODEFS.flagsToPermissionStringMap) {
   return NODEFS.flagsToPermissionStringMap[flags];
  } else {
   throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
  }
 }),
 node_ops: {
  getattr: (function(node) {
   var path = NODEFS.realPath(node);
   var stat;
   try {
    stat = fs.lstatSync(path);
   } catch (e) {
    if (!e.code) throw e;
    throw new FS.ErrnoError(ERRNO_CODES[e.code]);
   }
   if (NODEFS.isWindows && !stat.blksize) {
    stat.blksize = 4096;
   }
   if (NODEFS.isWindows && !stat.blocks) {
    stat.blocks = (stat.size + stat.blksize - 1) / stat.blksize | 0;
   }
   return {
    dev: stat.dev,
    ino: stat.ino,
    mode: stat.mode,
    nlink: stat.nlink,
    uid: stat.uid,
    gid: stat.gid,
    rdev: stat.rdev,
    size: stat.size,
    atime: stat.atime,
    mtime: stat.mtime,
    ctime: stat.ctime,
    blksize: stat.blksize,
    blocks: stat.blocks
   };
  }),
  setattr: (function(node, attr) {
   var path = NODEFS.realPath(node);
   try {
    if (attr.mode !== undefined) {
     fs.chmodSync(path, attr.mode);
     node.mode = attr.mode;
    }
    if (attr.timestamp !== undefined) {
     var date = new Date(attr.timestamp);
     fs.utimesSync(path, date, date);
    }
    if (attr.size !== undefined) {
     fs.truncateSync(path, attr.size);
    }
   } catch (e) {
    if (!e.code) throw e;
    throw new FS.ErrnoError(ERRNO_CODES[e.code]);
   }
  }),
  lookup: (function(parent, name) {
   var path = PATH.join2(NODEFS.realPath(parent), name);
   var mode = NODEFS.getMode(path);
   return NODEFS.createNode(parent, name, mode);
  }),
  mknod: (function(parent, name, mode, dev) {
   var node = NODEFS.createNode(parent, name, mode, dev);
   var path = NODEFS.realPath(node);
   try {
    if (FS.isDir(node.mode)) {
     fs.mkdirSync(path, node.mode);
    } else {
     fs.writeFileSync(path, "", {
      mode: node.mode
     });
    }
   } catch (e) {
    if (!e.code) throw e;
    throw new FS.ErrnoError(ERRNO_CODES[e.code]);
   }
   return node;
  }),
  rename: (function(oldNode, newDir, newName) {
   var oldPath = NODEFS.realPath(oldNode);
   var newPath = PATH.join2(NODEFS.realPath(newDir), newName);
   try {
    fs.renameSync(oldPath, newPath);
   } catch (e) {
    if (!e.code) throw e;
    throw new FS.ErrnoError(ERRNO_CODES[e.code]);
   }
  }),
  unlink: (function(parent, name) {
   var path = PATH.join2(NODEFS.realPath(parent), name);
   try {
    fs.unlinkSync(path);
   } catch (e) {
    if (!e.code) throw e;
    throw new FS.ErrnoError(ERRNO_CODES[e.code]);
   }
  }),
  rmdir: (function(parent, name) {
   var path = PATH.join2(NODEFS.realPath(parent), name);
   try {
    fs.rmdirSync(path);
   } catch (e) {
    if (!e.code) throw e;
    throw new FS.ErrnoError(ERRNO_CODES[e.code]);
   }
  }),
  readdir: (function(node) {
   var path = NODEFS.realPath(node);
   try {
    return fs.readdirSync(path);
   } catch (e) {
    if (!e.code) throw e;
    throw new FS.ErrnoError(ERRNO_CODES[e.code]);
   }
  }),
  symlink: (function(parent, newName, oldPath) {
   var newPath = PATH.join2(NODEFS.realPath(parent), newName);
   try {
    fs.symlinkSync(oldPath, newPath);
   } catch (e) {
    if (!e.code) throw e;
    throw new FS.ErrnoError(ERRNO_CODES[e.code]);
   }
  }),
  readlink: (function(node) {
   var path = NODEFS.realPath(node);
   try {
    path = fs.readlinkSync(path);
    path = NODEJS_PATH.relative(NODEJS_PATH.resolve(node.mount.opts.root), path);
    return path;
   } catch (e) {
    if (!e.code) throw e;
    throw new FS.ErrnoError(ERRNO_CODES[e.code]);
   }
  })
 },
 stream_ops: {
  open: (function(stream) {
   var path = NODEFS.realPath(stream.node);
   try {
    if (FS.isFile(stream.node.mode)) {
     stream.nfd = fs.openSync(path, NODEFS.flagsToPermissionString(stream.flags));
    }
   } catch (e) {
    if (!e.code) throw e;
    throw new FS.ErrnoError(ERRNO_CODES[e.code]);
   }
  }),
  close: (function(stream) {
   try {
    if (FS.isFile(stream.node.mode) && stream.nfd) {
     fs.closeSync(stream.nfd);
    }
   } catch (e) {
    if (!e.code) throw e;
    throw new FS.ErrnoError(ERRNO_CODES[e.code]);
   }
  }),
  read: (function(stream, buffer, offset, length, position) {
   if (length === 0) return 0;
   var nbuffer = new Buffer(length);
   var res;
   try {
    res = fs.readSync(stream.nfd, nbuffer, 0, length, position);
   } catch (e) {
    throw new FS.ErrnoError(ERRNO_CODES[e.code]);
   }
   if (res > 0) {
    for (var i = 0; i < res; i++) {
     buffer[offset + i] = nbuffer[i];
    }
   }
   return res;
  }),
  write: (function(stream, buffer, offset, length, position) {
   var nbuffer = new Buffer(buffer.subarray(offset, offset + length));
   var res;
   try {
    res = fs.writeSync(stream.nfd, nbuffer, 0, length, position);
   } catch (e) {
    throw new FS.ErrnoError(ERRNO_CODES[e.code]);
   }
   return res;
  }),
  llseek: (function(stream, offset, whence) {
   var position = offset;
   if (whence === 1) {
    position += stream.position;
   } else if (whence === 2) {
    if (FS.isFile(stream.node.mode)) {
     try {
      var stat = fs.fstatSync(stream.nfd);
      position += stat.size;
     } catch (e) {
      throw new FS.ErrnoError(ERRNO_CODES[e.code]);
     }
    }
   }
   if (position < 0) {
    throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
   }
   return position;
  })
 }
};
Module["NODEFS"] = NODEFS;
var WORKERFS = {
 DIR_MODE: 16895,
 FILE_MODE: 33279,
 reader: null,
 mount: (function(mount) {
  assert(ENVIRONMENT_IS_WORKER);
  if (!WORKERFS.reader) WORKERFS.reader = new FileReaderSync;
  var root = WORKERFS.createNode(null, "/", WORKERFS.DIR_MODE, 0);
  var createdParents = {};
  function ensureParent(path) {
   var parts = path.split("/");
   var parent = root;
   for (var i = 0; i < parts.length - 1; i++) {
    var curr = parts.slice(0, i + 1).join("/");
    if (!createdParents[curr]) {
     createdParents[curr] = WORKERFS.createNode(parent, parts[i], WORKERFS.DIR_MODE, 0);
    }
    parent = createdParents[curr];
   }
   return parent;
  }
  function base(path) {
   var parts = path.split("/");
   return parts[parts.length - 1];
  }
  Array.prototype.forEach.call(mount.opts["files"] || [], (function(file) {
   WORKERFS.createNode(ensureParent(file.name), base(file.name), WORKERFS.FILE_MODE, 0, file, file.lastModifiedDate);
  }));
  (mount.opts["blobs"] || []).forEach((function(obj) {
   WORKERFS.createNode(ensureParent(obj["name"]), base(obj["name"]), WORKERFS.FILE_MODE, 0, obj["data"]);
  }));
  (mount.opts["packages"] || []).forEach((function(pack) {
   pack["metadata"].files.forEach((function(file) {
    var name = file.filename.substr(1);
    WORKERFS.createNode(ensureParent(name), base(name), WORKERFS.FILE_MODE, 0, pack["blob"].slice(file.start, file.end));
   }));
  }));
  return root;
 }),
 createNode: (function(parent, name, mode, dev, contents, mtime) {
  var node = FS.createNode(parent, name, mode);
  node.mode = mode;
  node.node_ops = WORKERFS.node_ops;
  node.stream_ops = WORKERFS.stream_ops;
  node.timestamp = (mtime || new Date).getTime();
  assert(WORKERFS.FILE_MODE !== WORKERFS.DIR_MODE);
  if (mode === WORKERFS.FILE_MODE) {
   node.size = contents.size;
   node.contents = contents;
  } else {
   node.size = 4096;
   node.contents = {};
  }
  if (parent) {
   parent.contents[name] = node;
  }
  return node;
 }),
 node_ops: {
  getattr: (function(node) {
   return {
    dev: 1,
    ino: undefined,
    mode: node.mode,
    nlink: 1,
    uid: 0,
    gid: 0,
    rdev: undefined,
    size: node.size,
    atime: new Date(node.timestamp),
    mtime: new Date(node.timestamp),
    ctime: new Date(node.timestamp),
    blksize: 4096,
    blocks: Math.ceil(node.size / 4096)
   };
  }),
  setattr: (function(node, attr) {
   if (attr.mode !== undefined) {
    node.mode = attr.mode;
   }
   if (attr.timestamp !== undefined) {
    node.timestamp = attr.timestamp;
   }
  }),
  lookup: (function(parent, name) {
   throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
  }),
  mknod: (function(parent, name, mode, dev) {
   throw new FS.ErrnoError(ERRNO_CODES.EPERM);
  }),
  rename: (function(oldNode, newDir, newName) {
   throw new FS.ErrnoError(ERRNO_CODES.EPERM);
  }),
  unlink: (function(parent, name) {
   throw new FS.ErrnoError(ERRNO_CODES.EPERM);
  }),
  rmdir: (function(parent, name) {
   throw new FS.ErrnoError(ERRNO_CODES.EPERM);
  }),
  readdir: (function(node) {
   throw new FS.ErrnoError(ERRNO_CODES.EPERM);
  }),
  symlink: (function(parent, newName, oldPath) {
   throw new FS.ErrnoError(ERRNO_CODES.EPERM);
  }),
  readlink: (function(node) {
   throw new FS.ErrnoError(ERRNO_CODES.EPERM);
  })
 },
 stream_ops: {
  read: (function(stream, buffer, offset, length, position) {
   if (position >= stream.node.size) return 0;
   var chunk = stream.node.contents.slice(position, position + length);
   var ab = WORKERFS.reader.readAsArrayBuffer(chunk);
   buffer.set(new Uint8Array(ab), offset);
   return chunk.size;
  }),
  write: (function(stream, buffer, offset, length, position) {
   throw new FS.ErrnoError(ERRNO_CODES.EIO);
  }),
  llseek: (function(stream, offset, whence) {
   var position = offset;
   if (whence === 1) {
    position += stream.position;
   } else if (whence === 2) {
    if (FS.isFile(stream.node.mode)) {
     position += stream.node.size;
    }
   }
   if (position < 0) {
    throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
   }
   return position;
  })
 }
};
Module["WORKERFS"] = WORKERFS;
var _stdin = STATICTOP;
STATICTOP += 16;
Module["_stdin"] = _stdin;
var _stdout = STATICTOP;
STATICTOP += 16;
Module["_stdout"] = _stdout;
var _stderr = STATICTOP;
STATICTOP += 16;
Module["_stderr"] = _stderr;
var FS = {
 root: null,
 mounts: [],
 devices: [ null ],
 streams: [],
 nextInode: 1,
 nameTable: null,
 currentPath: "/",
 initialized: false,
 ignorePermissions: true,
 trackingDelegate: {},
 tracking: {
  openFlags: {
   READ: 1,
   WRITE: 2
  }
 },
 ErrnoError: null,
 genericErrors: {},
 filesystems: null,
 syncFSRequests: 0,
 handleFSError: (function(e) {
  if (!(e instanceof FS.ErrnoError)) throw e + " : " + stackTrace();
  return ___setErrNo(e.errno);
 }),
 lookupPath: (function(path, opts) {
  path = PATH.resolve(FS.cwd(), path);
  opts = opts || {};
  if (!path) return {
   path: "",
   node: null
  };
  var defaults = {
   follow_mount: true,
   recurse_count: 0
  };
  for (var key in defaults) {
   if (opts[key] === undefined) {
    opts[key] = defaults[key];
   }
  }
  if (opts.recurse_count > 8) {
   throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
  }
  var parts = PATH.normalizeArray(path.split("/").filter((function(p) {
   return !!p;
  })), false);
  var current = FS.root;
  var current_path = "/";
  for (var i = 0; i < parts.length; i++) {
   var islast = i === parts.length - 1;
   if (islast && opts.parent) {
    break;
   }
   current = FS.lookupNode(current, parts[i]);
   current_path = PATH.join2(current_path, parts[i]);
   if (FS.isMountpoint(current)) {
    if (!islast || islast && opts.follow_mount) {
     current = current.mounted.root;
    }
   }
   if (!islast || opts.follow) {
    var count = 0;
    while (FS.isLink(current.mode)) {
     var link = FS.readlink(current_path);
     current_path = PATH.resolve(PATH.dirname(current_path), link);
     var lookup = FS.lookupPath(current_path, {
      recurse_count: opts.recurse_count
     });
     current = lookup.node;
     if (count++ > 40) {
      throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
     }
    }
   }
  }
  return {
   path: current_path,
   node: current
  };
 }),
 getPath: (function(node) {
  var path;
  while (true) {
   if (FS.isRoot(node)) {
    var mount = node.mount.mountpoint;
    if (!path) return mount;
    return mount[mount.length - 1] !== "/" ? mount + "/" + path : mount + path;
   }
   path = path ? node.name + "/" + path : node.name;
   node = node.parent;
  }
 }),
 hashName: (function(parentid, name) {
  var hash = 0;
  for (var i = 0; i < name.length; i++) {
   hash = (hash << 5) - hash + name.charCodeAt(i) | 0;
  }
  return (parentid + hash >>> 0) % FS.nameTable.length;
 }),
 hashAddNode: (function(node) {
  var hash = FS.hashName(node.parent.id, node.name);
  node.name_next = FS.nameTable[hash];
  FS.nameTable[hash] = node;
 }),
 hashRemoveNode: (function(node) {
  var hash = FS.hashName(node.parent.id, node.name);
  if (FS.nameTable[hash] === node) {
   FS.nameTable[hash] = node.name_next;
  } else {
   var current = FS.nameTable[hash];
   while (current) {
    if (current.name_next === node) {
     current.name_next = node.name_next;
     break;
    }
    current = current.name_next;
   }
  }
 }),
 lookupNode: (function(parent, name) {
  var err = FS.mayLookup(parent);
  if (err) {
   throw new FS.ErrnoError(err, parent);
  }
  var hash = FS.hashName(parent.id, name);
  for (var node = FS.nameTable[hash]; node; node = node.name_next) {
   var nodeName = node.name;
   if (node.parent.id === parent.id && nodeName === name) {
    return node;
   }
  }
  return FS.lookup(parent, name);
 }),
 createNode: (function(parent, name, mode, rdev) {
  if (!FS.FSNode) {
   FS.FSNode = (function(parent, name, mode, rdev) {
    if (!parent) {
     parent = this;
    }
    this.parent = parent;
    this.mount = parent.mount;
    this.mounted = null;
    this.id = FS.nextInode++;
    this.name = name;
    this.mode = mode;
    this.node_ops = {};
    this.stream_ops = {};
    this.rdev = rdev;
   });
   FS.FSNode.prototype = {};
   var readMode = 292 | 73;
   var writeMode = 146;
   Object.defineProperties(FS.FSNode.prototype, {
    read: {
     get: (function() {
      return (this.mode & readMode) === readMode;
     }),
     set: (function(val) {
      val ? this.mode |= readMode : this.mode &= ~readMode;
     })
    },
    write: {
     get: (function() {
      return (this.mode & writeMode) === writeMode;
     }),
     set: (function(val) {
      val ? this.mode |= writeMode : this.mode &= ~writeMode;
     })
    },
    isFolder: {
     get: (function() {
      return FS.isDir(this.mode);
     })
    },
    isDevice: {
     get: (function() {
      return FS.isChrdev(this.mode);
     })
    }
   });
  }
  var node = new FS.FSNode(parent, name, mode, rdev);
  FS.hashAddNode(node);
  return node;
 }),
 destroyNode: (function(node) {
  FS.hashRemoveNode(node);
 }),
 isRoot: (function(node) {
  return node === node.parent;
 }),
 isMountpoint: (function(node) {
  return !!node.mounted;
 }),
 isFile: (function(mode) {
  return (mode & 61440) === 32768;
 }),
 isDir: (function(mode) {
  return (mode & 61440) === 16384;
 }),
 isLink: (function(mode) {
  return (mode & 61440) === 40960;
 }),
 isChrdev: (function(mode) {
  return (mode & 61440) === 8192;
 }),
 isBlkdev: (function(mode) {
  return (mode & 61440) === 24576;
 }),
 isFIFO: (function(mode) {
  return (mode & 61440) === 4096;
 }),
 isSocket: (function(mode) {
  return (mode & 49152) === 49152;
 }),
 flagModes: {
  "r": 0,
  "rs": 1052672,
  "r+": 2,
  "w": 577,
  "wx": 705,
  "xw": 705,
  "w+": 578,
  "wx+": 706,
  "xw+": 706,
  "a": 1089,
  "ax": 1217,
  "xa": 1217,
  "a+": 1090,
  "ax+": 1218,
  "xa+": 1218
 },
 modeStringToFlags: (function(str) {
  var flags = FS.flagModes[str];
  if (typeof flags === "undefined") {
   throw new Error("Unknown file open mode: " + str);
  }
  return flags;
 }),
 flagsToPermissionString: (function(flag) {
  var perms = [ "r", "w", "rw" ][flag & 3];
  if (flag & 512) {
   perms += "w";
  }
  return perms;
 }),
 nodePermissions: (function(node, perms) {
  if (FS.ignorePermissions) {
   return 0;
  }
  if (perms.indexOf("r") !== -1 && !(node.mode & 292)) {
   return ERRNO_CODES.EACCES;
  } else if (perms.indexOf("w") !== -1 && !(node.mode & 146)) {
   return ERRNO_CODES.EACCES;
  } else if (perms.indexOf("x") !== -1 && !(node.mode & 73)) {
   return ERRNO_CODES.EACCES;
  }
  return 0;
 }),
 mayLookup: (function(dir) {
  var err = FS.nodePermissions(dir, "x");
  if (err) return err;
  if (!dir.node_ops.lookup) return ERRNO_CODES.EACCES;
  return 0;
 }),
 mayCreate: (function(dir, name) {
  try {
   var node = FS.lookupNode(dir, name);
   return ERRNO_CODES.EEXIST;
  } catch (e) {}
  return FS.nodePermissions(dir, "wx");
 }),
 mayDelete: (function(dir, name, isdir) {
  var node;
  try {
   node = FS.lookupNode(dir, name);
  } catch (e) {
   return e.errno;
  }
  var err = FS.nodePermissions(dir, "wx");
  if (err) {
   return err;
  }
  if (isdir) {
   if (!FS.isDir(node.mode)) {
    return ERRNO_CODES.ENOTDIR;
   }
   if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
    return ERRNO_CODES.EBUSY;
   }
  } else {
   if (FS.isDir(node.mode)) {
    return ERRNO_CODES.EISDIR;
   }
  }
  return 0;
 }),
 mayOpen: (function(node, flags) {
  if (!node) {
   return ERRNO_CODES.ENOENT;
  }
  if (FS.isLink(node.mode)) {
   return ERRNO_CODES.ELOOP;
  } else if (FS.isDir(node.mode)) {
   if (FS.flagsToPermissionString(flags) !== "r" || flags & 512) {
    return ERRNO_CODES.EISDIR;
   }
  }
  return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
 }),
 MAX_OPEN_FDS: 4096,
 nextfd: (function(fd_start, fd_end) {
  fd_start = fd_start || 0;
  fd_end = fd_end || FS.MAX_OPEN_FDS;
  for (var fd = fd_start; fd <= fd_end; fd++) {
   if (!FS.streams[fd]) {
    return fd;
   }
  }
  throw new FS.ErrnoError(ERRNO_CODES.EMFILE);
 }),
 getStream: (function(fd) {
  return FS.streams[fd];
 }),
 createStream: (function(stream, fd_start, fd_end) {
  if (!FS.FSStream) {
   FS.FSStream = (function() {});
   FS.FSStream.prototype = {};
   Object.defineProperties(FS.FSStream.prototype, {
    object: {
     get: (function() {
      return this.node;
     }),
     set: (function(val) {
      this.node = val;
     })
    },
    isRead: {
     get: (function() {
      return (this.flags & 2097155) !== 1;
     })
    },
    isWrite: {
     get: (function() {
      return (this.flags & 2097155) !== 0;
     })
    },
    isAppend: {
     get: (function() {
      return this.flags & 1024;
     })
    }
   });
  }
  var newStream = new FS.FSStream;
  for (var p in stream) {
   newStream[p] = stream[p];
  }
  stream = newStream;
  var fd = FS.nextfd(fd_start, fd_end);
  stream.fd = fd;
  FS.streams[fd] = stream;
  return stream;
 }),
 closeStream: (function(fd) {
  FS.streams[fd] = null;
 }),
 chrdev_stream_ops: {
  open: (function(stream) {
   var device = FS.getDevice(stream.node.rdev);
   stream.stream_ops = device.stream_ops;
   if (stream.stream_ops.open) {
    stream.stream_ops.open(stream);
   }
  }),
  llseek: (function() {
   throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
  })
 },
 major: (function(dev) {
  return dev >> 8;
 }),
 minor: (function(dev) {
  return dev & 255;
 }),
 makedev: (function(ma, mi) {
  return ma << 8 | mi;
 }),
 registerDevice: (function(dev, ops) {
  FS.devices[dev] = {
   stream_ops: ops
  };
 }),
 getDevice: (function(dev) {
  return FS.devices[dev];
 }),
 getMounts: (function(mount) {
  var mounts = [];
  var check = [ mount ];
  while (check.length) {
   var m = check.pop();
   mounts.push(m);
   check.push.apply(check, m.mounts);
  }
  return mounts;
 }),
 syncfs: (function(populate, callback) {
  if (typeof populate === "function") {
   callback = populate;
   populate = false;
  }
  FS.syncFSRequests++;
  if (FS.syncFSRequests > 1) {
   console.log("warning: " + FS.syncFSRequests + " FS.syncfs operations in flight at once, probably just doing extra work");
  }
  var mounts = FS.getMounts(FS.root.mount);
  var completed = 0;
  function doCallback(err) {
   assert(FS.syncFSRequests > 0);
   FS.syncFSRequests--;
   return callback(err);
  }
  function done(err) {
   if (err) {
    if (!done.errored) {
     done.errored = true;
     return doCallback(err);
    }
    return;
   }
   if (++completed >= mounts.length) {
    doCallback(null);
   }
  }
  mounts.forEach((function(mount) {
   if (!mount.type.syncfs) {
    return done(null);
   }
   mount.type.syncfs(mount, populate, done);
  }));
 }),
 mount: (function(type, opts, mountpoint) {
  var root = mountpoint === "/";
  var pseudo = !mountpoint;
  var node;
  if (root && FS.root) {
   throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
  } else if (!root && !pseudo) {
   var lookup = FS.lookupPath(mountpoint, {
    follow_mount: false
   });
   mountpoint = lookup.path;
   node = lookup.node;
   if (FS.isMountpoint(node)) {
    throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
   }
   if (!FS.isDir(node.mode)) {
    throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
   }
  }
  var mount = {
   type: type,
   opts: opts,
   mountpoint: mountpoint,
   mounts: []
  };
  var mountRoot = type.mount(mount);
  mountRoot.mount = mount;
  mount.root = mountRoot;
  if (root) {
   FS.root = mountRoot;
  } else if (node) {
   node.mounted = mount;
   if (node.mount) {
    node.mount.mounts.push(mount);
   }
  }
  return mountRoot;
 }),
 unmount: (function(mountpoint) {
  var lookup = FS.lookupPath(mountpoint, {
   follow_mount: false
  });
  if (!FS.isMountpoint(lookup.node)) {
   throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
  }
  var node = lookup.node;
  var mount = node.mounted;
  var mounts = FS.getMounts(mount);
  Object.keys(FS.nameTable).forEach((function(hash) {
   var current = FS.nameTable[hash];
   while (current) {
    var next = current.name_next;
    if (mounts.indexOf(current.mount) !== -1) {
     FS.destroyNode(current);
    }
    current = next;
   }
  }));
  node.mounted = null;
  var idx = node.mount.mounts.indexOf(mount);
  assert(idx !== -1);
  node.mount.mounts.splice(idx, 1);
 }),
 lookup: (function(parent, name) {
  return parent.node_ops.lookup(parent, name);
 }),
 mknod: (function(path, mode, dev) {
  var lookup = FS.lookupPath(path, {
   parent: true
  });
  var parent = lookup.node;
  var name = PATH.basename(path);
  if (!name || name === "." || name === "..") {
   throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
  }
  var err = FS.mayCreate(parent, name);
  if (err) {
   throw new FS.ErrnoError(err);
  }
  if (!parent.node_ops.mknod) {
   throw new FS.ErrnoError(ERRNO_CODES.EPERM);
  }
  return parent.node_ops.mknod(parent, name, mode, dev);
 }),
 create: (function(path, mode) {
  mode = mode !== undefined ? mode : 438;
  mode &= 4095;
  mode |= 32768;
  return FS.mknod(path, mode, 0);
 }),
 mkdir: (function(path, mode) {
  mode = mode !== undefined ? mode : 511;
  mode &= 511 | 512;
  mode |= 16384;
  return FS.mknod(path, mode, 0);
 }),
 mkdev: (function(path, mode, dev) {
  if (typeof dev === "undefined") {
   dev = mode;
   mode = 438;
  }
  mode |= 8192;
  return FS.mknod(path, mode, dev);
 }),
 symlink: (function(oldpath, newpath) {
  if (!PATH.resolve(oldpath)) {
   throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
  }
  var lookup = FS.lookupPath(newpath, {
   parent: true
  });
  var parent = lookup.node;
  if (!parent) {
   throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
  }
  var newname = PATH.basename(newpath);
  var err = FS.mayCreate(parent, newname);
  if (err) {
   throw new FS.ErrnoError(err);
  }
  if (!parent.node_ops.symlink) {
   throw new FS.ErrnoError(ERRNO_CODES.EPERM);
  }
  return parent.node_ops.symlink(parent, newname, oldpath);
 }),
 rename: (function(old_path, new_path) {
  var old_dirname = PATH.dirname(old_path);
  var new_dirname = PATH.dirname(new_path);
  var old_name = PATH.basename(old_path);
  var new_name = PATH.basename(new_path);
  var lookup, old_dir, new_dir;
  try {
   lookup = FS.lookupPath(old_path, {
    parent: true
   });
   old_dir = lookup.node;
   lookup = FS.lookupPath(new_path, {
    parent: true
   });
   new_dir = lookup.node;
  } catch (e) {
   throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
  }
  if (!old_dir || !new_dir) throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
  if (old_dir.mount !== new_dir.mount) {
   throw new FS.ErrnoError(ERRNO_CODES.EXDEV);
  }
  var old_node = FS.lookupNode(old_dir, old_name);
  var relative = PATH.relative(old_path, new_dirname);
  if (relative.charAt(0) !== ".") {
   throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
  }
  relative = PATH.relative(new_path, old_dirname);
  if (relative.charAt(0) !== ".") {
   throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
  }
  var new_node;
  try {
   new_node = FS.lookupNode(new_dir, new_name);
  } catch (e) {}
  if (old_node === new_node) {
   return;
  }
  var isdir = FS.isDir(old_node.mode);
  var err = FS.mayDelete(old_dir, old_name, isdir);
  if (err) {
   throw new FS.ErrnoError(err);
  }
  err = new_node ? FS.mayDelete(new_dir, new_name, isdir) : FS.mayCreate(new_dir, new_name);
  if (err) {
   throw new FS.ErrnoError(err);
  }
  if (!old_dir.node_ops.rename) {
   throw new FS.ErrnoError(ERRNO_CODES.EPERM);
  }
  if (FS.isMountpoint(old_node) || new_node && FS.isMountpoint(new_node)) {
   throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
  }
  if (new_dir !== old_dir) {
   err = FS.nodePermissions(old_dir, "w");
   if (err) {
    throw new FS.ErrnoError(err);
   }
  }
  try {
   if (FS.trackingDelegate["willMovePath"]) {
    FS.trackingDelegate["willMovePath"](old_path, new_path);
   }
  } catch (e) {
   console.log("FS.trackingDelegate['willMovePath']('" + old_path + "', '" + new_path + "') threw an exception: " + e.message);
  }
  FS.hashRemoveNode(old_node);
  try {
   old_dir.node_ops.rename(old_node, new_dir, new_name);
  } catch (e) {
   throw e;
  } finally {
   FS.hashAddNode(old_node);
  }
  try {
   if (FS.trackingDelegate["onMovePath"]) FS.trackingDelegate["onMovePath"](old_path, new_path);
  } catch (e) {
   console.log("FS.trackingDelegate['onMovePath']('" + old_path + "', '" + new_path + "') threw an exception: " + e.message);
  }
 }),
 rmdir: (function(path) {
  var lookup = FS.lookupPath(path, {
   parent: true
  });
  var parent = lookup.node;
  var name = PATH.basename(path);
  var node = FS.lookupNode(parent, name);
  var err = FS.mayDelete(parent, name, true);
  if (err) {
   throw new FS.ErrnoError(err);
  }
  if (!parent.node_ops.rmdir) {
   throw new FS.ErrnoError(ERRNO_CODES.EPERM);
  }
  if (FS.isMountpoint(node)) {
   throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
  }
  try {
   if (FS.trackingDelegate["willDeletePath"]) {
    FS.trackingDelegate["willDeletePath"](path);
   }
  } catch (e) {
   console.log("FS.trackingDelegate['willDeletePath']('" + path + "') threw an exception: " + e.message);
  }
  parent.node_ops.rmdir(parent, name);
  FS.destroyNode(node);
  try {
   if (FS.trackingDelegate["onDeletePath"]) FS.trackingDelegate["onDeletePath"](path);
  } catch (e) {
   console.log("FS.trackingDelegate['onDeletePath']('" + path + "') threw an exception: " + e.message);
  }
 }),
 readdir: (function(path) {
  var lookup = FS.lookupPath(path, {
   follow: true
  });
  var node = lookup.node;
  if (!node.node_ops.readdir) {
   throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
  }
  return node.node_ops.readdir(node);
 }),
 unlink: (function(path) {
  var lookup = FS.lookupPath(path, {
   parent: true
  });
  var parent = lookup.node;
  var name = PATH.basename(path);
  var node = FS.lookupNode(parent, name);
  var err = FS.mayDelete(parent, name, false);
  if (err) {
   throw new FS.ErrnoError(err);
  }
  if (!parent.node_ops.unlink) {
   throw new FS.ErrnoError(ERRNO_CODES.EPERM);
  }
  if (FS.isMountpoint(node)) {
   throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
  }
  try {
   if (FS.trackingDelegate["willDeletePath"]) {
    FS.trackingDelegate["willDeletePath"](path);
   }
  } catch (e) {
   console.log("FS.trackingDelegate['willDeletePath']('" + path + "') threw an exception: " + e.message);
  }
  parent.node_ops.unlink(parent, name);
  FS.destroyNode(node);
  try {
   if (FS.trackingDelegate["onDeletePath"]) FS.trackingDelegate["onDeletePath"](path);
  } catch (e) {
   console.log("FS.trackingDelegate['onDeletePath']('" + path + "') threw an exception: " + e.message);
  }
 }),
 readlink: (function(path) {
  var lookup = FS.lookupPath(path);
  var link = lookup.node;
  if (!link) {
   throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
  }
  if (!link.node_ops.readlink) {
   throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
  }
  return PATH.resolve(FS.getPath(link.parent), link.node_ops.readlink(link));
 }),
 stat: (function(path, dontFollow) {
  var lookup = FS.lookupPath(path, {
   follow: !dontFollow
  });
  var node = lookup.node;
  if (!node) {
   throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
  }
  if (!node.node_ops.getattr) {
   throw new FS.ErrnoError(ERRNO_CODES.EPERM);
  }
  return node.node_ops.getattr(node);
 }),
 lstat: (function(path) {
  return FS.stat(path, true);
 }),
 chmod: (function(path, mode, dontFollow) {
  var node;
  if (typeof path === "string") {
   var lookup = FS.lookupPath(path, {
    follow: !dontFollow
   });
   node = lookup.node;
  } else {
   node = path;
  }
  if (!node.node_ops.setattr) {
   throw new FS.ErrnoError(ERRNO_CODES.EPERM);
  }
  node.node_ops.setattr(node, {
   mode: mode & 4095 | node.mode & ~4095,
   timestamp: Date.now()
  });
 }),
 lchmod: (function(path, mode) {
  FS.chmod(path, mode, true);
 }),
 fchmod: (function(fd, mode) {
  var stream = FS.getStream(fd);
  if (!stream) {
   throw new FS.ErrnoError(ERRNO_CODES.EBADF);
  }
  FS.chmod(stream.node, mode);
 }),
 chown: (function(path, uid, gid, dontFollow) {
  var node;
  if (typeof path === "string") {
   var lookup = FS.lookupPath(path, {
    follow: !dontFollow
   });
   node = lookup.node;
  } else {
   node = path;
  }
  if (!node.node_ops.setattr) {
   throw new FS.ErrnoError(ERRNO_CODES.EPERM);
  }
  node.node_ops.setattr(node, {
   timestamp: Date.now()
  });
 }),
 lchown: (function(path, uid, gid) {
  FS.chown(path, uid, gid, true);
 }),
 fchown: (function(fd, uid, gid) {
  var stream = FS.getStream(fd);
  if (!stream) {
   throw new FS.ErrnoError(ERRNO_CODES.EBADF);
  }
  FS.chown(stream.node, uid, gid);
 }),
 truncate: (function(path, len) {
  if (len < 0) {
   throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
  }
  var node;
  if (typeof path === "string") {
   var lookup = FS.lookupPath(path, {
    follow: true
   });
   node = lookup.node;
  } else {
   node = path;
  }
  if (!node.node_ops.setattr) {
   throw new FS.ErrnoError(ERRNO_CODES.EPERM);
  }
  if (FS.isDir(node.mode)) {
   throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
  }
  if (!FS.isFile(node.mode)) {
   throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
  }
  var err = FS.nodePermissions(node, "w");
  if (err) {
   throw new FS.ErrnoError(err);
  }
  node.node_ops.setattr(node, {
   size: len,
   timestamp: Date.now()
  });
 }),
 ftruncate: (function(fd, len) {
  var stream = FS.getStream(fd);
  if (!stream) {
   throw new FS.ErrnoError(ERRNO_CODES.EBADF);
  }
  if ((stream.flags & 2097155) === 0) {
   throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
  }
  FS.truncate(stream.node, len);
 }),
 utime: (function(path, atime, mtime) {
  var lookup = FS.lookupPath(path, {
   follow: true
  });
  var node = lookup.node;
  node.node_ops.setattr(node, {
   timestamp: Math.max(atime, mtime)
  });
 }),
 open: (function(path, flags, mode, fd_start, fd_end) {
  if (path === "") {
   throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
  }
  flags = typeof flags === "string" ? FS.modeStringToFlags(flags) : flags;
  mode = typeof mode === "undefined" ? 438 : mode;
  if (flags & 64) {
   mode = mode & 4095 | 32768;
  } else {
   mode = 0;
  }
  var node;
  if (typeof path === "object") {
   node = path;
  } else {
   path = PATH.normalize(path);
   try {
    var lookup = FS.lookupPath(path, {
     follow: !(flags & 131072)
    });
    node = lookup.node;
   } catch (e) {}
  }
  var created = false;
  if (flags & 64) {
   if (node) {
    if (flags & 128) {
     throw new FS.ErrnoError(ERRNO_CODES.EEXIST);
    }
   } else {
    node = FS.mknod(path, mode, 0);
    created = true;
   }
  }
  if (!node) {
   throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
  }
  if (FS.isChrdev(node.mode)) {
   flags &= ~512;
  }
  if (flags & 65536 && !FS.isDir(node.mode)) {
   throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
  }
  if (!created) {
   var err = FS.mayOpen(node, flags);
   if (err) {
    throw new FS.ErrnoError(err);
   }
  }
  if (flags & 512) {
   FS.truncate(node, 0);
  }
  flags &= ~(128 | 512);
  var stream = FS.createStream({
   node: node,
   path: FS.getPath(node),
   flags: flags,
   seekable: true,
   position: 0,
   stream_ops: node.stream_ops,
   ungotten: [],
   error: false
  }, fd_start, fd_end);
  if (stream.stream_ops.open) {
   stream.stream_ops.open(stream);
  }
  if (Module["logReadFiles"] && !(flags & 1)) {
   if (!FS.readFiles) FS.readFiles = {};
   if (!(path in FS.readFiles)) {
    FS.readFiles[path] = 1;
    Module["printErr"]("read file: " + path);
   }
  }
  try {
   if (FS.trackingDelegate["onOpenFile"]) {
    var trackingFlags = 0;
    if ((flags & 2097155) !== 1) {
     trackingFlags |= FS.tracking.openFlags.READ;
    }
    if ((flags & 2097155) !== 0) {
     trackingFlags |= FS.tracking.openFlags.WRITE;
    }
    FS.trackingDelegate["onOpenFile"](path, trackingFlags);
   }
  } catch (e) {
   console.log("FS.trackingDelegate['onOpenFile']('" + path + "', flags) threw an exception: " + e.message);
  }
  return stream;
 }),
 close: (function(stream) {
  if (stream.getdents) stream.getdents = null;
  try {
   if (stream.stream_ops.close) {
    stream.stream_ops.close(stream);
   }
  } catch (e) {
   throw e;
  } finally {
   FS.closeStream(stream.fd);
  }
 }),
 llseek: (function(stream, offset, whence) {
  if (!stream.seekable || !stream.stream_ops.llseek) {
   throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
  }
  stream.position = stream.stream_ops.llseek(stream, offset, whence);
  stream.ungotten = [];
  return stream.position;
 }),
 read: (function(stream, buffer, offset, length, position) {
  if (length < 0 || position < 0) {
   throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
  }
  if ((stream.flags & 2097155) === 1) {
   throw new FS.ErrnoError(ERRNO_CODES.EBADF);
  }
  if (FS.isDir(stream.node.mode)) {
   throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
  }
  if (!stream.stream_ops.read) {
   throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
  }
  var seeking = true;
  if (typeof position === "undefined") {
   position = stream.position;
   seeking = false;
  } else if (!stream.seekable) {
   throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
  }
  var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
  if (!seeking) stream.position += bytesRead;
  return bytesRead;
 }),
 write: (function(stream, buffer, offset, length, position, canOwn) {
  if (length < 0 || position < 0) {
   throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
  }
  if ((stream.flags & 2097155) === 0) {
   throw new FS.ErrnoError(ERRNO_CODES.EBADF);
  }
  if (FS.isDir(stream.node.mode)) {
   throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
  }
  if (!stream.stream_ops.write) {
   throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
  }
  if (stream.flags & 1024) {
   FS.llseek(stream, 0, 2);
  }
  var seeking = true;
  if (typeof position === "undefined") {
   position = stream.position;
   seeking = false;
  } else if (!stream.seekable) {
   throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
  }
  var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
  if (!seeking) stream.position += bytesWritten;
  try {
   if (stream.path && FS.trackingDelegate["onWriteToFile"]) FS.trackingDelegate["onWriteToFile"](stream.path);
  } catch (e) {
   console.log("FS.trackingDelegate['onWriteToFile']('" + path + "') threw an exception: " + e.message);
  }
  return bytesWritten;
 }),
 allocate: (function(stream, offset, length) {
  if (offset < 0 || length <= 0) {
   throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
  }
  if ((stream.flags & 2097155) === 0) {
   throw new FS.ErrnoError(ERRNO_CODES.EBADF);
  }
  if (!FS.isFile(stream.node.mode) && !FS.isDir(node.mode)) {
   throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
  }
  if (!stream.stream_ops.allocate) {
   throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
  }
  stream.stream_ops.allocate(stream, offset, length);
 }),
 mmap: (function(stream, buffer, offset, length, position, prot, flags) {
  if ((stream.flags & 2097155) === 1) {
   throw new FS.ErrnoError(ERRNO_CODES.EACCES);
  }
  if (!stream.stream_ops.mmap) {
   throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
  }
  return stream.stream_ops.mmap(stream, buffer, offset, length, position, prot, flags);
 }),
 msync: (function(stream, buffer, offset, length, mmapFlags) {
  if (!stream || !stream.stream_ops.msync) {
   return 0;
  }
  return stream.stream_ops.msync(stream, buffer, offset, length, mmapFlags);
 }),
 munmap: (function(stream) {
  return 0;
 }),
 ioctl: (function(stream, cmd, arg) {
  if (!stream.stream_ops.ioctl) {
   throw new FS.ErrnoError(ERRNO_CODES.ENOTTY);
  }
  return stream.stream_ops.ioctl(stream, cmd, arg);
 }),
 readFile: (function(path, opts) {
  opts = opts || {};
  opts.flags = opts.flags || "r";
  opts.encoding = opts.encoding || "binary";
  if (opts.encoding !== "utf8" && opts.encoding !== "binary") {
   throw new Error('Invalid encoding type "' + opts.encoding + '"');
  }
  var ret;
  var stream = FS.open(path, opts.flags);
  var stat = FS.stat(path);
  var length = stat.size;
  var buf = new Uint8Array(length);
  FS.read(stream, buf, 0, length, 0);
  if (opts.encoding === "utf8") {
   ret = UTF8ArrayToString(buf, 0);
  } else if (opts.encoding === "binary") {
   ret = buf;
  }
  FS.close(stream);
  return ret;
 }),
 writeFile: (function(path, data, opts) {
  opts = opts || {};
  opts.flags = opts.flags || "w";
  opts.encoding = opts.encoding || "utf8";
  if (opts.encoding !== "utf8" && opts.encoding !== "binary") {
   throw new Error('Invalid encoding type "' + opts.encoding + '"');
  }
  var stream = FS.open(path, opts.flags, opts.mode);
  if (opts.encoding === "utf8") {
   var buf = new Uint8Array(lengthBytesUTF8(data) + 1);
   var actualNumBytes = stringToUTF8Array(data, buf, 0, buf.length);
   FS.write(stream, buf, 0, actualNumBytes, 0, opts.canOwn);
  } else if (opts.encoding === "binary") {
   FS.write(stream, data, 0, data.length, 0, opts.canOwn);
  }
  FS.close(stream);
 }),
 cwd: (function() {
  return FS.currentPath;
 }),
 chdir: (function(path) {
  var lookup = FS.lookupPath(path, {
   follow: true
  });
  if (!FS.isDir(lookup.node.mode)) {
   throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
  }
  var err = FS.nodePermissions(lookup.node, "x");
  if (err) {
   throw new FS.ErrnoError(err);
  }
  FS.currentPath = lookup.path;
 }),
 createDefaultDirectories: (function() {
  FS.mkdir("/tmp");
  FS.mkdir("/home");
  FS.mkdir("/home/web_user");
 }),
 createDefaultDevices: (function() {
  FS.mkdir("/dev");
  FS.registerDevice(FS.makedev(1, 3), {
   read: (function() {
    return 0;
   }),
   write: (function(stream, buffer, offset, length, pos) {
    return length;
   })
  });
  FS.mkdev("/dev/null", FS.makedev(1, 3));
  TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
  TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
  FS.mkdev("/dev/tty", FS.makedev(5, 0));
  FS.mkdev("/dev/tty1", FS.makedev(6, 0));
  var random_device;
  if (typeof crypto !== "undefined") {
   var randomBuffer = new Uint8Array(1);
   random_device = (function() {
    crypto.getRandomValues(randomBuffer);
    return randomBuffer[0];
   });
  } else if (ENVIRONMENT_IS_NODE) {
   random_device = (function() {
    return require("crypto").randomBytes(1)[0];
   });
  } else {
   random_device = (function() {
    return Math.random() * 256 | 0;
   });
  }
  FS.createDevice("/dev", "random", random_device);
  FS.createDevice("/dev", "urandom", random_device);
  FS.mkdir("/dev/shm");
  FS.mkdir("/dev/shm/tmp");
 }),
 createSpecialDirectories: (function() {
  FS.mkdir("/proc");
  FS.mkdir("/proc/self");
  FS.mkdir("/proc/self/fd");
  FS.mount({
   mount: (function() {
    var node = FS.createNode("/proc/self", "fd", 16384 | 511, 73);
    node.node_ops = {
     lookup: (function(parent, name) {
      var fd = +name;
      var stream = FS.getStream(fd);
      if (!stream) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
      var ret = {
       parent: null,
       mount: {
        mountpoint: "fake"
       },
       node_ops: {
        readlink: (function() {
         return stream.path;
        })
       }
      };
      ret.parent = ret;
      return ret;
     })
    };
    return node;
   })
  }, {}, "/proc/self/fd");
 }),
 createStandardStreams: (function() {
  if (Module["stdin"]) {
   FS.createDevice("/dev", "stdin", Module["stdin"]);
  } else {
   FS.symlink("/dev/tty", "/dev/stdin");
  }
  if (Module["stdout"]) {
   FS.createDevice("/dev", "stdout", null, Module["stdout"]);
  } else {
   FS.symlink("/dev/tty", "/dev/stdout");
  }
  if (Module["stderr"]) {
   FS.createDevice("/dev", "stderr", null, Module["stderr"]);
  } else {
   FS.symlink("/dev/tty1", "/dev/stderr");
  }
  var stdin = FS.open("/dev/stdin", "r");
  assert(stdin.fd === 0, "invalid handle for stdin (" + stdin.fd + ")");
  var stdout = FS.open("/dev/stdout", "w");
  assert(stdout.fd === 1, "invalid handle for stdout (" + stdout.fd + ")");
  var stderr = FS.open("/dev/stderr", "w");
  assert(stderr.fd === 2, "invalid handle for stderr (" + stderr.fd + ")");
 }),
 ensureErrnoError: (function() {
  if (FS.ErrnoError) return;
  FS.ErrnoError = function ErrnoError(errno, node) {
   this.node = node;
   this.setErrno = (function(errno) {
    this.errno = errno;
    for (var key in ERRNO_CODES) {
     if (ERRNO_CODES[key] === errno) {
      this.code = key;
      break;
     }
    }
   });
   this.setErrno(errno);
   this.message = ERRNO_MESSAGES[errno];
   if (this.stack) this.stack = demangleAll(this.stack);
  };
  FS.ErrnoError.prototype = new Error;
  FS.ErrnoError.prototype.constructor = FS.ErrnoError;
  [ ERRNO_CODES.ENOENT ].forEach((function(code) {
   FS.genericErrors[code] = new FS.ErrnoError(code);
   FS.genericErrors[code].stack = "<generic error, no stack>";
  }));
 }),
 staticInit: (function() {
  FS.ensureErrnoError();
  FS.nameTable = new Array(4096);
  FS.mount(MEMFS, {}, "/");
  FS.createDefaultDirectories();
  FS.createDefaultDevices();
  FS.createSpecialDirectories();
  FS.filesystems = {
   "MEMFS": MEMFS,
   "IDBFS": IDBFS,
   "NODEFS": NODEFS,
   "WORKERFS": WORKERFS
  };
 }),
 init: (function(input, output, error) {
  assert(!FS.init.initialized, "FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)");
  FS.init.initialized = true;
  FS.ensureErrnoError();
  Module["stdin"] = input || Module["stdin"];
  Module["stdout"] = output || Module["stdout"];
  Module["stderr"] = error || Module["stderr"];
  FS.createStandardStreams();
 }),
 quit: (function() {
  FS.init.initialized = false;
  var fflush = Module["_fflush"];
  if (fflush) fflush(0);
  for (var i = 0; i < FS.streams.length; i++) {
   var stream = FS.streams[i];
   if (!stream) {
    continue;
   }
   FS.close(stream);
  }
 }),
 getMode: (function(canRead, canWrite) {
  var mode = 0;
  if (canRead) mode |= 292 | 73;
  if (canWrite) mode |= 146;
  return mode;
 }),
 joinPath: (function(parts, forceRelative) {
  var path = PATH.join.apply(null, parts);
  if (forceRelative && path[0] == "/") path = path.substr(1);
  return path;
 }),
 absolutePath: (function(relative, base) {
  return PATH.resolve(base, relative);
 }),
 standardizePath: (function(path) {
  return PATH.normalize(path);
 }),
 findObject: (function(path, dontResolveLastLink) {
  var ret = FS.analyzePath(path, dontResolveLastLink);
  if (ret.exists) {
   return ret.object;
  } else {
   ___setErrNo(ret.error);
   return null;
  }
 }),
 analyzePath: (function(path, dontResolveLastLink) {
  try {
   var lookup = FS.lookupPath(path, {
    follow: !dontResolveLastLink
   });
   path = lookup.path;
  } catch (e) {}
  var ret = {
   isRoot: false,
   exists: false,
   error: 0,
   name: null,
   path: null,
   object: null,
   parentExists: false,
   parentPath: null,
   parentObject: null
  };
  try {
   var lookup = FS.lookupPath(path, {
    parent: true
   });
   ret.parentExists = true;
   ret.parentPath = lookup.path;
   ret.parentObject = lookup.node;
   ret.name = PATH.basename(path);
   lookup = FS.lookupPath(path, {
    follow: !dontResolveLastLink
   });
   ret.exists = true;
   ret.path = lookup.path;
   ret.object = lookup.node;
   ret.name = lookup.node.name;
   ret.isRoot = lookup.path === "/";
  } catch (e) {
   ret.error = e.errno;
  }
  return ret;
 }),
 createFolder: (function(parent, name, canRead, canWrite) {
  var path = PATH.join2(typeof parent === "string" ? parent : FS.getPath(parent), name);
  var mode = FS.getMode(canRead, canWrite);
  return FS.mkdir(path, mode);
 }),
 createPath: (function(parent, path, canRead, canWrite) {
  parent = typeof parent === "string" ? parent : FS.getPath(parent);
  var parts = path.split("/").reverse();
  while (parts.length) {
   var part = parts.pop();
   if (!part) continue;
   var current = PATH.join2(parent, part);
   try {
    FS.mkdir(current);
   } catch (e) {}
   parent = current;
  }
  return current;
 }),
 createFile: (function(parent, name, properties, canRead, canWrite) {
  var path = PATH.join2(typeof parent === "string" ? parent : FS.getPath(parent), name);
  var mode = FS.getMode(canRead, canWrite);
  return FS.create(path, mode);
 }),
 createDataFile: (function(parent, name, data, canRead, canWrite, canOwn) {
  var path = name ? PATH.join2(typeof parent === "string" ? parent : FS.getPath(parent), name) : parent;
  var mode = FS.getMode(canRead, canWrite);
  var node = FS.create(path, mode);
  if (data) {
   if (typeof data === "string") {
    var arr = new Array(data.length);
    for (var i = 0, len = data.length; i < len; ++i) arr[i] = data.charCodeAt(i);
    data = arr;
   }
   FS.chmod(node, mode | 146);
   var stream = FS.open(node, "w");
   FS.write(stream, data, 0, data.length, 0, canOwn);
   FS.close(stream);
   FS.chmod(node, mode);
  }
  return node;
 }),
 createDevice: (function(parent, name, input, output) {
  var path = PATH.join2(typeof parent === "string" ? parent : FS.getPath(parent), name);
  var mode = FS.getMode(!!input, !!output);
  if (!FS.createDevice.major) FS.createDevice.major = 64;
  var dev = FS.makedev(FS.createDevice.major++, 0);
  FS.registerDevice(dev, {
   open: (function(stream) {
    stream.seekable = false;
   }),
   close: (function(stream) {
    if (output && output.buffer && output.buffer.length) {
     output(10);
    }
   }),
   read: (function(stream, buffer, offset, length, pos) {
    var bytesRead = 0;
    for (var i = 0; i < length; i++) {
     var result;
     try {
      result = input();
     } catch (e) {
      throw new FS.ErrnoError(ERRNO_CODES.EIO);
     }
     if (result === undefined && bytesRead === 0) {
      throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
     }
     if (result === null || result === undefined) break;
     bytesRead++;
     buffer[offset + i] = result;
    }
    if (bytesRead) {
     stream.node.timestamp = Date.now();
    }
    return bytesRead;
   }),
   write: (function(stream, buffer, offset, length, pos) {
    for (var i = 0; i < length; i++) {
     try {
      output(buffer[offset + i]);
     } catch (e) {
      throw new FS.ErrnoError(ERRNO_CODES.EIO);
     }
    }
    if (length) {
     stream.node.timestamp = Date.now();
    }
    return i;
   })
  });
  return FS.mkdev(path, mode, dev);
 }),
 createLink: (function(parent, name, target, canRead, canWrite) {
  var path = PATH.join2(typeof parent === "string" ? parent : FS.getPath(parent), name);
  return FS.symlink(target, path);
 }),
 forceLoadFile: (function(obj) {
  if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
  var success = true;
  if (typeof XMLHttpRequest !== "undefined") {
   throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
  } else if (Module["read"]) {
   try {
    obj.contents = intArrayFromString(Module["read"](obj.url), true);
    obj.usedBytes = obj.contents.length;
   } catch (e) {
    success = false;
   }
  } else {
   throw new Error("Cannot load without read() or XMLHttpRequest.");
  }
  if (!success) ___setErrNo(ERRNO_CODES.EIO);
  return success;
 }),
 createLazyFile: (function(parent, name, url, canRead, canWrite) {
  function LazyUint8Array() {
   this.lengthKnown = false;
   this.chunks = [];
  }
  LazyUint8Array.prototype.get = function LazyUint8Array_get(idx) {
   if (idx > this.length - 1 || idx < 0) {
    return undefined;
   }
   var chunkOffset = idx % this.chunkSize;
   var chunkNum = idx / this.chunkSize | 0;
   return this.getter(chunkNum)[chunkOffset];
  };
  LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(getter) {
   this.getter = getter;
  };
  LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
   var xhr = new XMLHttpRequest;
   xhr.open("HEAD", url, false);
   xhr.send(null);
   if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
   var datalength = Number(xhr.getResponseHeader("Content-length"));
   var header;
   var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
   var usesGzip = (header = xhr.getResponseHeader("Content-Encoding")) && header === "gzip";
   var chunkSize = 1024 * 1024;
   if (!hasByteServing) chunkSize = datalength;
   var doXHR = (function(from, to) {
    if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
    if (to > datalength - 1) throw new Error("only " + datalength + " bytes available! programmer error!");
    var xhr = new XMLHttpRequest;
    xhr.open("GET", url, false);
    if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
    if (typeof Uint8Array != "undefined") xhr.responseType = "arraybuffer";
    if (xhr.overrideMimeType) {
     xhr.overrideMimeType("text/plain; charset=x-user-defined");
    }
    xhr.send(null);
    if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
    if (xhr.response !== undefined) {
     return new Uint8Array(xhr.response || []);
    } else {
     return intArrayFromString(xhr.responseText || "", true);
    }
   });
   var lazyArray = this;
   lazyArray.setDataGetter((function(chunkNum) {
    var start = chunkNum * chunkSize;
    var end = (chunkNum + 1) * chunkSize - 1;
    end = Math.min(end, datalength - 1);
    if (typeof lazyArray.chunks[chunkNum] === "undefined") {
     lazyArray.chunks[chunkNum] = doXHR(start, end);
    }
    if (typeof lazyArray.chunks[chunkNum] === "undefined") throw new Error("doXHR failed!");
    return lazyArray.chunks[chunkNum];
   }));
   if (usesGzip || !datalength) {
    chunkSize = datalength = 1;
    datalength = this.getter(0).length;
    chunkSize = datalength;
    console.log("LazyFiles on gzip forces download of the whole file when length is accessed");
   }
   this._length = datalength;
   this._chunkSize = chunkSize;
   this.lengthKnown = true;
  };
  if (typeof XMLHttpRequest !== "undefined") {
   if (!ENVIRONMENT_IS_WORKER) throw "Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";
   var lazyArray = new LazyUint8Array;
   Object.defineProperties(lazyArray, {
    length: {
     get: (function() {
      if (!this.lengthKnown) {
       this.cacheLength();
      }
      return this._length;
     })
    },
    chunkSize: {
     get: (function() {
      if (!this.lengthKnown) {
       this.cacheLength();
      }
      return this._chunkSize;
     })
    }
   });
   var properties = {
    isDevice: false,
    contents: lazyArray
   };
  } else {
   var properties = {
    isDevice: false,
    url: url
   };
  }
  var node = FS.createFile(parent, name, properties, canRead, canWrite);
  if (properties.contents) {
   node.contents = properties.contents;
  } else if (properties.url) {
   node.contents = null;
   node.url = properties.url;
  }
  Object.defineProperties(node, {
   usedBytes: {
    get: (function() {
     return this.contents.length;
    })
   }
  });
  var stream_ops = {};
  var keys = Object.keys(node.stream_ops);
  keys.forEach((function(key) {
   var fn = node.stream_ops[key];
   stream_ops[key] = function forceLoadLazyFile() {
    if (!FS.forceLoadFile(node)) {
     throw new FS.ErrnoError(ERRNO_CODES.EIO);
    }
    return fn.apply(null, arguments);
   };
  }));
  stream_ops.read = function stream_ops_read(stream, buffer, offset, length, position) {
   if (!FS.forceLoadFile(node)) {
    throw new FS.ErrnoError(ERRNO_CODES.EIO);
   }
   var contents = stream.node.contents;
   if (position >= contents.length) return 0;
   var size = Math.min(contents.length - position, length);
   assert(size >= 0);
   if (contents.slice) {
    for (var i = 0; i < size; i++) {
     buffer[offset + i] = contents[position + i];
    }
   } else {
    for (var i = 0; i < size; i++) {
     buffer[offset + i] = contents.get(position + i);
    }
   }
   return size;
  };
  node.stream_ops = stream_ops;
  return node;
 }),
 createPreloadedFile: (function(parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn, preFinish) {
  Browser.init();
  var fullname = name ? PATH.resolve(PATH.join2(parent, name)) : parent;
  var dep = getUniqueRunDependency("cp " + fullname);
  function processData(byteArray) {
   function finish(byteArray) {
    if (preFinish) preFinish();
    if (!dontCreateFile) {
     FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn);
    }
    if (onload) onload();
    removeRunDependency(dep);
   }
   var handled = false;
   Module["preloadPlugins"].forEach((function(plugin) {
    if (handled) return;
    if (plugin["canHandle"](fullname)) {
     plugin["handle"](byteArray, fullname, finish, (function() {
      if (onerror) onerror();
      removeRunDependency(dep);
     }));
     handled = true;
    }
   }));
   if (!handled) finish(byteArray);
  }
  addRunDependency(dep);
  if (typeof url == "string") {
   Browser.asyncLoad(url, (function(byteArray) {
    processData(byteArray);
   }), onerror);
  } else {
   processData(url);
  }
 }),
 indexedDB: (function() {
  return Module.indexedDB;
 }),
 DB_NAME: (function() {
  return "EM_FS_" + window.location.pathname;
 }),
 DB_VERSION: 20,
 DB_STORE_NAME: "FILE_DATA",
 saveFilesToDB: (function(paths, onload, onerror) {
  onload = onload || (function() {});
  onerror = onerror || (function() {});
  var indexedDB = FS.indexedDB();
  try {
   var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
  } catch (e) {
   return onerror(e);
  }
  openRequest.onupgradeneeded = function openRequest_onupgradeneeded() {
   console.log("creating db");
   var db = openRequest.result;
   db.createObjectStore(FS.DB_STORE_NAME);
  };
  openRequest.onsuccess = function openRequest_onsuccess() {
   var db = openRequest.result;
   var transaction = db.transaction([ FS.DB_STORE_NAME ], "readwrite");
   var files = transaction.objectStore(FS.DB_STORE_NAME);
   var ok = 0, fail = 0, total = paths.length;
   function finish() {
    if (fail == 0) onload(); else onerror();
   }
   paths.forEach((function(path) {
    var putRequest = files.put(FS.analyzePath(path).object.contents, path);
    putRequest.onsuccess = function putRequest_onsuccess() {
     ok++;
     if (ok + fail == total) finish();
    };
    putRequest.onerror = function putRequest_onerror() {
     fail++;
     if (ok + fail == total) finish();
    };
   }));
   transaction.onerror = onerror;
  };
  openRequest.onerror = onerror;
 }),
 loadFilesFromDB: (function(paths, onload, onerror) {
  onload = onload || (function() {});
  onerror = onerror || (function() {});
  var indexedDB = FS.indexedDB();
  try {
   var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
  } catch (e) {
   return onerror(e);
  }
  openRequest.onupgradeneeded = onerror;
  openRequest.onsuccess = function openRequest_onsuccess() {
   var db = openRequest.result;
   try {
    var transaction = db.transaction([ FS.DB_STORE_NAME ], "readonly");
   } catch (e) {
    onerror(e);
    return;
   }
   var files = transaction.objectStore(FS.DB_STORE_NAME);
   var ok = 0, fail = 0, total = paths.length;
   function finish() {
    if (fail == 0) onload(); else onerror();
   }
   paths.forEach((function(path) {
    var getRequest = files.get(path);
    getRequest.onsuccess = function getRequest_onsuccess() {
     if (FS.analyzePath(path).exists) {
      FS.unlink(path);
     }
     FS.createDataFile(PATH.dirname(path), PATH.basename(path), getRequest.result, true, true, true);
     ok++;
     if (ok + fail == total) finish();
    };
    getRequest.onerror = function getRequest_onerror() {
     fail++;
     if (ok + fail == total) finish();
    };
   }));
   transaction.onerror = onerror;
  };
  openRequest.onerror = onerror;
 })
};
Module["FS"] = FS;
var SYSCALLS = {
 DEFAULT_POLLMASK: 5,
 mappings: {},
 umask: 511,
 calculateAt: (function(dirfd, path) {
  if (path[0] !== "/") {
   var dir;
   if (dirfd === -100) {
    dir = FS.cwd();
   } else {
    var dirstream = FS.getStream(dirfd);
    if (!dirstream) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
    dir = dirstream.path;
   }
   path = PATH.join2(dir, path);
  }
  return path;
 }),
 doStat: (function(func, path, buf) {
  try {
   var stat = func(path);
  } catch (e) {
   if (e && e.node && PATH.normalize(path) !== PATH.normalize(FS.getPath(e.node))) {
    return -ERRNO_CODES.ENOTDIR;
   }
   throw e;
  }
  HEAP32[buf >> 2] = stat.dev;
  HEAP32[buf + 4 >> 2] = 0;
  HEAP32[buf + 8 >> 2] = stat.ino;
  HEAP32[buf + 12 >> 2] = stat.mode;
  HEAP32[buf + 16 >> 2] = stat.nlink;
  HEAP32[buf + 20 >> 2] = stat.uid;
  HEAP32[buf + 24 >> 2] = stat.gid;
  HEAP32[buf + 28 >> 2] = stat.rdev;
  HEAP32[buf + 32 >> 2] = 0;
  HEAP32[buf + 36 >> 2] = stat.size;
  HEAP32[buf + 40 >> 2] = 4096;
  HEAP32[buf + 44 >> 2] = stat.blocks;
  HEAP32[buf + 48 >> 2] = stat.atime.getTime() / 1e3 | 0;
  HEAP32[buf + 52 >> 2] = 0;
  HEAP32[buf + 56 >> 2] = stat.mtime.getTime() / 1e3 | 0;
  HEAP32[buf + 60 >> 2] = 0;
  HEAP32[buf + 64 >> 2] = stat.ctime.getTime() / 1e3 | 0;
  HEAP32[buf + 68 >> 2] = 0;
  HEAP32[buf + 72 >> 2] = stat.ino;
  return 0;
 }),
 doMsync: (function(addr, stream, len, flags) {
  var buffer = new Uint8Array(HEAPU8.subarray(addr, addr + len));
  FS.msync(stream, buffer, 0, len, flags);
 }),
 doMkdir: (function(path, mode) {
  path = PATH.normalize(path);
  if (path[path.length - 1] === "/") path = path.substr(0, path.length - 1);
  FS.mkdir(path, mode, 0);
  return 0;
 }),
 doMknod: (function(path, mode, dev) {
  switch (mode & 61440) {
  case 32768:
  case 8192:
  case 24576:
  case 4096:
  case 49152:
   break;
  default:
   return -ERRNO_CODES.EINVAL;
  }
  FS.mknod(path, mode, dev);
  return 0;
 }),
 doReadlink: (function(path, buf, bufsize) {
  if (bufsize <= 0) return -ERRNO_CODES.EINVAL;
  var ret = FS.readlink(path);
  ret = ret.slice(0, Math.max(0, bufsize));
  writeStringToMemory(ret, buf, true);
  return ret.length;
 }),
 doAccess: (function(path, amode) {
  if (amode & ~7) {
   return -ERRNO_CODES.EINVAL;
  }
  var node;
  var lookup = FS.lookupPath(path, {
   follow: true
  });
  node = lookup.node;
  var perms = "";
  if (amode & 4) perms += "r";
  if (amode & 2) perms += "w";
  if (amode & 1) perms += "x";
  if (perms && FS.nodePermissions(node, perms)) {
   return -ERRNO_CODES.EACCES;
  }
  return 0;
 }),
 doDup: (function(path, flags, suggestFD) {
  var suggest = FS.getStream(suggestFD);
  if (suggest) FS.close(suggest);
  return FS.open(path, flags, 0, suggestFD, suggestFD).fd;
 }),
 doReadv: (function(stream, iov, iovcnt, offset) {
  var ret = 0;
  for (var i = 0; i < iovcnt; i++) {
   var ptr = HEAP32[iov + i * 8 >> 2];
   var len = HEAP32[iov + (i * 8 + 4) >> 2];
   var curr = FS.read(stream, HEAP8, ptr, len, offset);
   if (curr < 0) return -1;
   ret += curr;
   if (curr < len) break;
  }
  return ret;
 }),
 doWritev: (function(stream, iov, iovcnt, offset) {
  var ret = 0;
  for (var i = 0; i < iovcnt; i++) {
   var ptr = HEAP32[iov + i * 8 >> 2];
   var len = HEAP32[iov + (i * 8 + 4) >> 2];
   var curr = FS.write(stream, HEAP8, ptr, len, offset);
   if (curr < 0) return -1;
   ret += curr;
  }
  return ret;
 }),
 varargs: 0,
 get: (function(varargs) {
  SYSCALLS.varargs += 4;
  var ret = HEAP32[SYSCALLS.varargs - 4 >> 2];
  return ret;
 }),
 getStr: (function() {
  var ret = Pointer_stringify(SYSCALLS.get());
  return ret;
 }),
 getStreamFromFD: (function() {
  var stream = FS.getStream(SYSCALLS.get());
  if (!stream) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
  return stream;
 }),
 getSocketFromFD: (function() {
  var socket = SOCKFS.getSocket(SYSCALLS.get());
  if (!socket) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
  return socket;
 }),
 getSocketAddress: (function(allowNull) {
  var addrp = SYSCALLS.get(), addrlen = SYSCALLS.get();
  if (allowNull && addrp === 0) return null;
  var info = __read_sockaddr(addrp, addrlen);
  if (info.errno) throw new FS.ErrnoError(info.errno);
  info.addr = DNS.lookup_addr(info.addr) || info.addr;
  return info;
 }),
 get64: (function() {
  var low = SYSCALLS.get(), high = SYSCALLS.get();
  if (low >= 0) assert(high === 0); else assert(high === -1);
  return low;
 }),
 getZero: (function() {
  assert(SYSCALLS.get() === 0);
 })
};
Module["SYSCALLS"] = SYSCALLS;
function ___syscall296(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var dirfd = SYSCALLS.get(), path = SYSCALLS.getStr(), mode = SYSCALLS.get();
  path = SYSCALLS.calculateAt(dirfd, path);
  return SYSCALLS.doMkdir(path, mode);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall296"] = ___syscall296;
function _emscripten_glUniform3iv(location, count, value) {
 location = GL.uniforms[location];
 count *= 3;
 value = HEAP32.subarray(value >> 2, value + count * 4 >> 2);
 GLctx.uniform3iv(location, value);
}
Module["_emscripten_glUniform3iv"] = _emscripten_glUniform3iv;
function ___syscall295(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var dirfd = SYSCALLS.get(), path = SYSCALLS.getStr(), flags = SYSCALLS.get(), mode = SYSCALLS.get();
  path = SYSCALLS.calculateAt(dirfd, path);
  return FS.open(path, flags, mode).fd;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall295"] = ___syscall295;
function _glCompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data) {
 var heapView;
 if (data) {
  heapView = HEAPU8.subarray(data, data + imageSize);
 } else {
  heapView = null;
 }
 GLctx["compressedTexSubImage2D"](target, level, xoffset, yoffset, zoffset, width, height, depth, format, heapView);
}
Module["_glCompressedTexSubImage3D"] = _glCompressedTexSubImage3D;
function ___syscall298(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var dirfd = SYSCALLS.get(), path = SYSCALLS.getStr(), owner = SYSCALLS.get(), group = SYSCALLS.get(), flags = SYSCALLS.get();
  assert(flags === 0);
  path = SYSCALLS.calculateAt(dirfd, path);
  FS.chown(path, owner, group);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall298"] = ___syscall298;
function ___syscall299(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  abort("futimesat is obsolete");
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall299"] = ___syscall299;
function ___syscall114(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  abort("cannot wait on child processes");
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall114"] = ___syscall114;
function _il2cpp_string_chars() {
 if (!Module["_il2cpp_string_chars"]) abort("external function 'il2cpp_string_chars' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_string_chars"].apply(null, arguments);
}
var _llvm_pow_f32 = Math_pow;
Module["_llvm_pow_f32"] = _llvm_pow_f32;
function _glBindSampler(unit, sampler) {
 GLctx["bindSampler"](unit, sampler ? GL.samplers[sampler] : null);
}
Module["_glBindSampler"] = _glBindSampler;
function _glProgramParameteri(program, pname, value) {
 GL.recordError(1280);
}
Module["_glProgramParameteri"] = _glProgramParameteri;
function _emscripten_glTexParameterf(x0, x1, x2) {
 GLctx.texParameterf(x0, x1, x2);
}
Module["_emscripten_glTexParameterf"] = _emscripten_glTexParameterf;
var JSEvents = {
 keyEvent: 0,
 mouseEvent: 0,
 wheelEvent: 0,
 uiEvent: 0,
 focusEvent: 0,
 deviceOrientationEvent: 0,
 deviceMotionEvent: 0,
 fullscreenChangeEvent: 0,
 pointerlockChangeEvent: 0,
 visibilityChangeEvent: 0,
 touchEvent: 0,
 lastGamepadState: null,
 lastGamepadStateFrame: null,
 previousFullscreenElement: null,
 previousScreenX: null,
 previousScreenY: null,
 removeEventListenersRegistered: false,
 registerRemoveEventListeners: (function() {
  if (!JSEvents.removeEventListenersRegistered) {
   __ATEXIT__.push((function() {
    for (var i = JSEvents.eventHandlers.length - 1; i >= 0; --i) {
     JSEvents._removeHandler(i);
    }
   }));
   JSEvents.removeEventListenersRegistered = true;
  }
 }),
 findEventTarget: (function(target) {
  if (target) {
   if (typeof target == "number") {
    target = Pointer_stringify(target);
   }
   if (target == "#window") return window; else if (target == "#document") return document; else if (target == "#screen") return window.screen; else if (target == "#canvas") return Module["canvas"];
   if (typeof target == "string") return document.getElementById(target); else return target;
  } else {
   return window;
  }
 }),
 deferredCalls: [],
 deferCall: (function(targetFunction, precedence, argsList) {
  function arraysHaveEqualContent(arrA, arrB) {
   if (arrA.length != arrB.length) return false;
   for (var i in arrA) {
    if (arrA[i] != arrB[i]) return false;
   }
   return true;
  }
  for (var i in JSEvents.deferredCalls) {
   var call = JSEvents.deferredCalls[i];
   if (call.targetFunction == targetFunction && arraysHaveEqualContent(call.argsList, argsList)) {
    return;
   }
  }
  JSEvents.deferredCalls.push({
   targetFunction: targetFunction,
   precedence: precedence,
   argsList: argsList
  });
  JSEvents.deferredCalls.sort((function(x, y) {
   return x.precedence < y.precedence;
  }));
 }),
 removeDeferredCalls: (function(targetFunction) {
  for (var i = 0; i < JSEvents.deferredCalls.length; ++i) {
   if (JSEvents.deferredCalls[i].targetFunction == targetFunction) {
    JSEvents.deferredCalls.splice(i, 1);
    --i;
   }
  }
 }),
 canPerformEventHandlerRequests: (function() {
  return JSEvents.inEventHandler && JSEvents.currentEventHandler.allowsDeferredCalls;
 }),
 runDeferredCalls: (function() {
  if (!JSEvents.canPerformEventHandlerRequests()) {
   return;
  }
  for (var i = 0; i < JSEvents.deferredCalls.length; ++i) {
   var call = JSEvents.deferredCalls[i];
   JSEvents.deferredCalls.splice(i, 1);
   --i;
   call.targetFunction.apply(this, call.argsList);
  }
 }),
 inEventHandler: 0,
 currentEventHandler: null,
 eventHandlers: [],
 isInternetExplorer: (function() {
  return navigator.userAgent.indexOf("MSIE") !== -1 || navigator.appVersion.indexOf("Trident/") > 0;
 }),
 removeAllHandlersOnTarget: (function(target, eventTypeString) {
  for (var i = 0; i < JSEvents.eventHandlers.length; ++i) {
   if (JSEvents.eventHandlers[i].target == target && (!eventTypeString || eventTypeString == JSEvents.eventHandlers[i].eventTypeString)) {
    JSEvents._removeHandler(i--);
   }
  }
 }),
 _removeHandler: (function(i) {
  var h = JSEvents.eventHandlers[i];
  h.target.removeEventListener(h.eventTypeString, h.eventListenerFunc, h.useCapture);
  JSEvents.eventHandlers.splice(i, 1);
 }),
 registerOrRemoveHandler: (function(eventHandler) {
  var jsEventHandler = function jsEventHandler(event) {
   ++JSEvents.inEventHandler;
   JSEvents.currentEventHandler = eventHandler;
   JSEvents.runDeferredCalls();
   eventHandler.handlerFunc(event);
   JSEvents.runDeferredCalls();
   --JSEvents.inEventHandler;
  };
  if (eventHandler.callbackfunc) {
   eventHandler.eventListenerFunc = jsEventHandler;
   eventHandler.target.addEventListener(eventHandler.eventTypeString, jsEventHandler, eventHandler.useCapture);
   JSEvents.eventHandlers.push(eventHandler);
   JSEvents.registerRemoveEventListeners();
  } else {
   for (var i = 0; i < JSEvents.eventHandlers.length; ++i) {
    if (JSEvents.eventHandlers[i].target == eventHandler.target && JSEvents.eventHandlers[i].eventTypeString == eventHandler.eventTypeString) {
     JSEvents._removeHandler(i--);
    }
   }
  }
 }),
 registerKeyEventCallback: (function(target, userData, useCapture, callbackfunc, eventTypeId, eventTypeString) {
  if (!JSEvents.keyEvent) {
   JSEvents.keyEvent = _malloc(164);
  }
  var handlerFunc = (function(event) {
   var e = event || window.event;
   writeStringToMemory(e.key ? e.key : "", JSEvents.keyEvent + 0);
   writeStringToMemory(e.code ? e.code : "", JSEvents.keyEvent + 32);
   HEAP32[JSEvents.keyEvent + 64 >> 2] = e.location;
   HEAP32[JSEvents.keyEvent + 68 >> 2] = e.ctrlKey;
   HEAP32[JSEvents.keyEvent + 72 >> 2] = e.shiftKey;
   HEAP32[JSEvents.keyEvent + 76 >> 2] = e.altKey;
   HEAP32[JSEvents.keyEvent + 80 >> 2] = e.metaKey;
   HEAP32[JSEvents.keyEvent + 84 >> 2] = e.repeat;
   writeStringToMemory(e.locale ? e.locale : "", JSEvents.keyEvent + 88);
   writeStringToMemory(e.char ? e.char : "", JSEvents.keyEvent + 120);
   HEAP32[JSEvents.keyEvent + 152 >> 2] = e.charCode;
   HEAP32[JSEvents.keyEvent + 156 >> 2] = e.keyCode;
   HEAP32[JSEvents.keyEvent + 160 >> 2] = e.which;
   var shouldCancel = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, JSEvents.keyEvent, userData ]);
   if (shouldCancel) {
    e.preventDefault();
   }
  });
  var eventHandler = {
   target: JSEvents.findEventTarget(target),
   allowsDeferredCalls: JSEvents.isInternetExplorer() ? false : true,
   eventTypeString: eventTypeString,
   callbackfunc: callbackfunc,
   handlerFunc: handlerFunc,
   useCapture: useCapture
  };
  JSEvents.registerOrRemoveHandler(eventHandler);
 }),
 getBoundingClientRectOrZeros: (function(target) {
  return target.getBoundingClientRect ? target.getBoundingClientRect() : {
   left: 0,
   top: 0
  };
 }),
 fillMouseEventData: (function(eventStruct, e, target) {
  HEAPF64[eventStruct >> 3] = JSEvents.tick();
  HEAP32[eventStruct + 8 >> 2] = e.screenX;
  HEAP32[eventStruct + 12 >> 2] = e.screenY;
  HEAP32[eventStruct + 16 >> 2] = e.clientX;
  HEAP32[eventStruct + 20 >> 2] = e.clientY;
  HEAP32[eventStruct + 24 >> 2] = e.ctrlKey;
  HEAP32[eventStruct + 28 >> 2] = e.shiftKey;
  HEAP32[eventStruct + 32 >> 2] = e.altKey;
  HEAP32[eventStruct + 36 >> 2] = e.metaKey;
  HEAP16[eventStruct + 40 >> 1] = e.button;
  HEAP16[eventStruct + 42 >> 1] = e.buttons;
  HEAP32[eventStruct + 44 >> 2] = e["movementX"] || e["mozMovementX"] || e["webkitMovementX"] || e.screenX - JSEvents.previousScreenX;
  HEAP32[eventStruct + 48 >> 2] = e["movementY"] || e["mozMovementY"] || e["webkitMovementY"] || e.screenY - JSEvents.previousScreenY;
  if (Module["canvas"]) {
   var rect = Module["canvas"].getBoundingClientRect();
   HEAP32[eventStruct + 60 >> 2] = e.clientX - rect.left;
   HEAP32[eventStruct + 64 >> 2] = e.clientY - rect.top;
  } else {
   HEAP32[eventStruct + 60 >> 2] = 0;
   HEAP32[eventStruct + 64 >> 2] = 0;
  }
  if (target) {
   var rect = JSEvents.getBoundingClientRectOrZeros(target);
   HEAP32[eventStruct + 52 >> 2] = e.clientX - rect.left;
   HEAP32[eventStruct + 56 >> 2] = e.clientY - rect.top;
  } else {
   HEAP32[eventStruct + 52 >> 2] = 0;
   HEAP32[eventStruct + 56 >> 2] = 0;
  }
  JSEvents.previousScreenX = e.screenX;
  JSEvents.previousScreenY = e.screenY;
 }),
 registerMouseEventCallback: (function(target, userData, useCapture, callbackfunc, eventTypeId, eventTypeString) {
  if (!JSEvents.mouseEvent) {
   JSEvents.mouseEvent = _malloc(72);
  }
  target = JSEvents.findEventTarget(target);
  var handlerFunc = (function(event) {
   var e = event || window.event;
   JSEvents.fillMouseEventData(JSEvents.mouseEvent, e, target);
   var shouldCancel = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, JSEvents.mouseEvent, userData ]);
   if (shouldCancel) {
    e.preventDefault();
   }
  });
  var eventHandler = {
   target: target,
   allowsDeferredCalls: eventTypeString != "mousemove" && eventTypeString != "mouseenter" && eventTypeString != "mouseleave",
   eventTypeString: eventTypeString,
   callbackfunc: callbackfunc,
   handlerFunc: handlerFunc,
   useCapture: useCapture
  };
  if (JSEvents.isInternetExplorer() && eventTypeString == "mousedown") eventHandler.allowsDeferredCalls = false;
  JSEvents.registerOrRemoveHandler(eventHandler);
 }),
 registerWheelEventCallback: (function(target, userData, useCapture, callbackfunc, eventTypeId, eventTypeString) {
  if (!JSEvents.wheelEvent) {
   JSEvents.wheelEvent = _malloc(104);
  }
  target = JSEvents.findEventTarget(target);
  var wheelHandlerFunc = (function(event) {
   var e = event || window.event;
   JSEvents.fillMouseEventData(JSEvents.wheelEvent, e, target);
   HEAPF64[JSEvents.wheelEvent + 72 >> 3] = e["deltaX"];
   HEAPF64[JSEvents.wheelEvent + 80 >> 3] = e["deltaY"];
   HEAPF64[JSEvents.wheelEvent + 88 >> 3] = e["deltaZ"];
   HEAP32[JSEvents.wheelEvent + 96 >> 2] = e["deltaMode"];
   var shouldCancel = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, JSEvents.wheelEvent, userData ]);
   if (shouldCancel) {
    e.preventDefault();
   }
  });
  var mouseWheelHandlerFunc = (function(event) {
   var e = event || window.event;
   JSEvents.fillMouseEventData(JSEvents.wheelEvent, e, target);
   HEAPF64[JSEvents.wheelEvent + 72 >> 3] = e["wheelDeltaX"];
   HEAPF64[JSEvents.wheelEvent + 80 >> 3] = -(e["wheelDeltaY"] ? e["wheelDeltaY"] : e["wheelDelta"]);
   HEAPF64[JSEvents.wheelEvent + 88 >> 3] = 0;
   HEAP32[JSEvents.wheelEvent + 96 >> 2] = 0;
   var shouldCancel = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, JSEvents.wheelEvent, userData ]);
   if (shouldCancel) {
    e.preventDefault();
   }
  });
  var eventHandler = {
   target: target,
   allowsDeferredCalls: true,
   eventTypeString: eventTypeString,
   callbackfunc: callbackfunc,
   handlerFunc: eventTypeString == "wheel" ? wheelHandlerFunc : mouseWheelHandlerFunc,
   useCapture: useCapture
  };
  JSEvents.registerOrRemoveHandler(eventHandler);
 }),
 pageScrollPos: (function() {
  if (window.pageXOffset > 0 || window.pageYOffset > 0) {
   return [ window.pageXOffset, window.pageYOffset ];
  }
  if (typeof document.documentElement.scrollLeft !== "undefined" || typeof document.documentElement.scrollTop !== "undefined") {
   return [ document.documentElement.scrollLeft, document.documentElement.scrollTop ];
  }
  return [ document.body.scrollLeft | 0, document.body.scrollTop | 0 ];
 }),
 registerUiEventCallback: (function(target, userData, useCapture, callbackfunc, eventTypeId, eventTypeString) {
  if (!JSEvents.uiEvent) {
   JSEvents.uiEvent = _malloc(36);
  }
  if (eventTypeString == "scroll" && !target) {
   target = document;
  } else {
   target = JSEvents.findEventTarget(target);
  }
  var handlerFunc = (function(event) {
   var e = event || window.event;
   if (e.target != target) {
    return;
   }
   var scrollPos = JSEvents.pageScrollPos();
   HEAP32[JSEvents.uiEvent >> 2] = e.detail;
   HEAP32[JSEvents.uiEvent + 4 >> 2] = document.body.clientWidth;
   HEAP32[JSEvents.uiEvent + 8 >> 2] = document.body.clientHeight;
   HEAP32[JSEvents.uiEvent + 12 >> 2] = window.innerWidth;
   HEAP32[JSEvents.uiEvent + 16 >> 2] = window.innerHeight;
   HEAP32[JSEvents.uiEvent + 20 >> 2] = window.outerWidth;
   HEAP32[JSEvents.uiEvent + 24 >> 2] = window.outerHeight;
   HEAP32[JSEvents.uiEvent + 28 >> 2] = scrollPos[0];
   HEAP32[JSEvents.uiEvent + 32 >> 2] = scrollPos[1];
   var shouldCancel = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, JSEvents.uiEvent, userData ]);
   if (shouldCancel) {
    e.preventDefault();
   }
  });
  var eventHandler = {
   target: target,
   allowsDeferredCalls: false,
   eventTypeString: eventTypeString,
   callbackfunc: callbackfunc,
   handlerFunc: handlerFunc,
   useCapture: useCapture
  };
  JSEvents.registerOrRemoveHandler(eventHandler);
 }),
 getNodeNameForTarget: (function(target) {
  if (!target) return "";
  if (target == window) return "#window";
  if (target == window.screen) return "#screen";
  return target && target.nodeName ? target.nodeName : "";
 }),
 registerFocusEventCallback: (function(target, userData, useCapture, callbackfunc, eventTypeId, eventTypeString) {
  if (!JSEvents.focusEvent) {
   JSEvents.focusEvent = _malloc(256);
  }
  var handlerFunc = (function(event) {
   var e = event || window.event;
   var nodeName = JSEvents.getNodeNameForTarget(e.target);
   var id = e.target.id ? e.target.id : "";
   writeStringToMemory(nodeName, JSEvents.focusEvent + 0);
   writeStringToMemory(id, JSEvents.focusEvent + 128);
   var shouldCancel = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, JSEvents.focusEvent, userData ]);
   if (shouldCancel) {
    e.preventDefault();
   }
  });
  var eventHandler = {
   target: JSEvents.findEventTarget(target),
   allowsDeferredCalls: false,
   eventTypeString: eventTypeString,
   callbackfunc: callbackfunc,
   handlerFunc: handlerFunc,
   useCapture: useCapture
  };
  JSEvents.registerOrRemoveHandler(eventHandler);
 }),
 tick: (function() {
  if (window["performance"] && window["performance"]["now"]) return window["performance"]["now"](); else return Date.now();
 }),
 registerDeviceOrientationEventCallback: (function(target, userData, useCapture, callbackfunc, eventTypeId, eventTypeString) {
  if (!JSEvents.deviceOrientationEvent) {
   JSEvents.deviceOrientationEvent = _malloc(40);
  }
  var handlerFunc = (function(event) {
   var e = event || window.event;
   HEAPF64[JSEvents.deviceOrientationEvent >> 3] = JSEvents.tick();
   HEAPF64[JSEvents.deviceOrientationEvent + 8 >> 3] = e.alpha;
   HEAPF64[JSEvents.deviceOrientationEvent + 16 >> 3] = e.beta;
   HEAPF64[JSEvents.deviceOrientationEvent + 24 >> 3] = e.gamma;
   HEAP32[JSEvents.deviceOrientationEvent + 32 >> 2] = e.absolute;
   var shouldCancel = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, JSEvents.deviceOrientationEvent, userData ]);
   if (shouldCancel) {
    e.preventDefault();
   }
  });
  var eventHandler = {
   target: JSEvents.findEventTarget(target),
   allowsDeferredCalls: false,
   eventTypeString: eventTypeString,
   callbackfunc: callbackfunc,
   handlerFunc: handlerFunc,
   useCapture: useCapture
  };
  JSEvents.registerOrRemoveHandler(eventHandler);
 }),
 registerDeviceMotionEventCallback: (function(target, userData, useCapture, callbackfunc, eventTypeId, eventTypeString) {
  if (!JSEvents.deviceMotionEvent) {
   JSEvents.deviceMotionEvent = _malloc(80);
  }
  var handlerFunc = (function(event) {
   var e = event || window.event;
   HEAPF64[JSEvents.deviceOrientationEvent >> 3] = JSEvents.tick();
   HEAPF64[JSEvents.deviceMotionEvent + 8 >> 3] = e.acceleration.x;
   HEAPF64[JSEvents.deviceMotionEvent + 16 >> 3] = e.acceleration.y;
   HEAPF64[JSEvents.deviceMotionEvent + 24 >> 3] = e.acceleration.z;
   HEAPF64[JSEvents.deviceMotionEvent + 32 >> 3] = e.accelerationIncludingGravity.x;
   HEAPF64[JSEvents.deviceMotionEvent + 40 >> 3] = e.accelerationIncludingGravity.y;
   HEAPF64[JSEvents.deviceMotionEvent + 48 >> 3] = e.accelerationIncludingGravity.z;
   HEAPF64[JSEvents.deviceMotionEvent + 56 >> 3] = e.rotationRate.alpha;
   HEAPF64[JSEvents.deviceMotionEvent + 64 >> 3] = e.rotationRate.beta;
   HEAPF64[JSEvents.deviceMotionEvent + 72 >> 3] = e.rotationRate.gamma;
   var shouldCancel = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, JSEvents.deviceMotionEvent, userData ]);
   if (shouldCancel) {
    e.preventDefault();
   }
  });
  var eventHandler = {
   target: JSEvents.findEventTarget(target),
   allowsDeferredCalls: false,
   eventTypeString: eventTypeString,
   callbackfunc: callbackfunc,
   handlerFunc: handlerFunc,
   useCapture: useCapture
  };
  JSEvents.registerOrRemoveHandler(eventHandler);
 }),
 screenOrientation: (function() {
  if (!window.screen) return undefined;
  return window.screen.orientation || window.screen.mozOrientation || window.screen.webkitOrientation || window.screen.msOrientation;
 }),
 fillOrientationChangeEventData: (function(eventStruct, e) {
  var orientations = [ "portrait-primary", "portrait-secondary", "landscape-primary", "landscape-secondary" ];
  var orientations2 = [ "portrait", "portrait", "landscape", "landscape" ];
  var orientationString = JSEvents.screenOrientation();
  var orientation = orientations.indexOf(orientationString);
  if (orientation == -1) {
   orientation = orientations2.indexOf(orientationString);
  }
  HEAP32[eventStruct >> 2] = 1 << orientation;
  HEAP32[eventStruct + 4 >> 2] = window.orientation;
 }),
 registerOrientationChangeEventCallback: (function(target, userData, useCapture, callbackfunc, eventTypeId, eventTypeString) {
  if (!JSEvents.orientationChangeEvent) {
   JSEvents.orientationChangeEvent = _malloc(8);
  }
  if (!target) {
   target = window.screen;
  } else {
   target = JSEvents.findEventTarget(target);
  }
  var handlerFunc = (function(event) {
   var e = event || window.event;
   JSEvents.fillOrientationChangeEventData(JSEvents.orientationChangeEvent, e);
   var shouldCancel = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, JSEvents.orientationChangeEvent, userData ]);
   if (shouldCancel) {
    e.preventDefault();
   }
  });
  if (eventTypeString == "orientationchange" && window.screen.mozOrientation !== undefined) {
   eventTypeString = "mozorientationchange";
  }
  var eventHandler = {
   target: target,
   allowsDeferredCalls: false,
   eventTypeString: eventTypeString,
   callbackfunc: callbackfunc,
   handlerFunc: handlerFunc,
   useCapture: useCapture
  };
  JSEvents.registerOrRemoveHandler(eventHandler);
 }),
 fullscreenEnabled: (function() {
  return document.fullscreenEnabled || document.mozFullScreenEnabled || document.webkitFullscreenEnabled || document.msFullscreenEnabled;
 }),
 fillFullscreenChangeEventData: (function(eventStruct, e) {
  var fullscreenElement = document.fullscreenElement || document.mozFullScreenElement || document.webkitFullscreenElement || document.msFullscreenElement;
  var isFullscreen = !!fullscreenElement;
  HEAP32[eventStruct >> 2] = isFullscreen;
  HEAP32[eventStruct + 4 >> 2] = JSEvents.fullscreenEnabled();
  var reportedElement = isFullscreen ? fullscreenElement : JSEvents.previousFullscreenElement;
  var nodeName = JSEvents.getNodeNameForTarget(reportedElement);
  var id = reportedElement && reportedElement.id ? reportedElement.id : "";
  writeStringToMemory(nodeName, eventStruct + 8);
  writeStringToMemory(id, eventStruct + 136);
  HEAP32[eventStruct + 264 >> 2] = reportedElement ? reportedElement.clientWidth : 0;
  HEAP32[eventStruct + 268 >> 2] = reportedElement ? reportedElement.clientHeight : 0;
  HEAP32[eventStruct + 272 >> 2] = screen.width;
  HEAP32[eventStruct + 276 >> 2] = screen.height;
  if (isFullscreen) {
   JSEvents.previousFullscreenElement = fullscreenElement;
  }
 }),
 registerFullscreenChangeEventCallback: (function(target, userData, useCapture, callbackfunc, eventTypeId, eventTypeString) {
  if (!JSEvents.fullscreenChangeEvent) {
   JSEvents.fullscreenChangeEvent = _malloc(280);
  }
  if (!target) {
   target = document;
  } else {
   target = JSEvents.findEventTarget(target);
  }
  var handlerFunc = (function(event) {
   var e = event || window.event;
   JSEvents.fillFullscreenChangeEventData(JSEvents.fullscreenChangeEvent, e);
   var shouldCancel = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, JSEvents.fullscreenChangeEvent, userData ]);
   if (shouldCancel) {
    e.preventDefault();
   }
  });
  var eventHandler = {
   target: target,
   allowsDeferredCalls: false,
   eventTypeString: eventTypeString,
   callbackfunc: callbackfunc,
   handlerFunc: handlerFunc,
   useCapture: useCapture
  };
  JSEvents.registerOrRemoveHandler(eventHandler);
 }),
 resizeCanvasForFullscreen: (function(target, strategy) {
  var restoreOldStyle = __registerRestoreOldStyle(target);
  var cssWidth = strategy.softFullscreen ? window.innerWidth : screen.width;
  var cssHeight = strategy.softFullscreen ? window.innerHeight : screen.height;
  var rect = target.getBoundingClientRect();
  var windowedCssWidth = rect.right - rect.left;
  var windowedCssHeight = rect.bottom - rect.top;
  var windowedRttWidth = target.width;
  var windowedRttHeight = target.height;
  if (strategy.scaleMode == 3) {
   __setLetterbox(target, (cssHeight - windowedCssHeight) / 2, (cssWidth - windowedCssWidth) / 2);
   cssWidth = windowedCssWidth;
   cssHeight = windowedCssHeight;
  } else if (strategy.scaleMode == 2) {
   if (cssWidth * windowedRttHeight < windowedRttWidth * cssHeight) {
    var desiredCssHeight = windowedRttHeight * cssWidth / windowedRttWidth;
    __setLetterbox(target, (cssHeight - desiredCssHeight) / 2, 0);
    cssHeight = desiredCssHeight;
   } else {
    var desiredCssWidth = windowedRttWidth * cssHeight / windowedRttHeight;
    __setLetterbox(target, 0, (cssWidth - desiredCssWidth) / 2);
    cssWidth = desiredCssWidth;
   }
  }
  if (!target.style.backgroundColor) target.style.backgroundColor = "black";
  if (!document.body.style.backgroundColor) document.body.style.backgroundColor = "black";
  target.style.width = cssWidth + "px";
  target.style.height = cssHeight + "px";
  if (strategy.filteringMode == 1) {
   target.style.imageRendering = "optimizeSpeed";
   target.style.imageRendering = "-moz-crisp-edges";
   target.style.imageRendering = "-o-crisp-edges";
   target.style.imageRendering = "-webkit-optimize-contrast";
   target.style.imageRendering = "optimize-contrast";
   target.style.imageRendering = "crisp-edges";
   target.style.imageRendering = "pixelated";
  }
  var dpiScale = strategy.canvasResolutionScaleMode == 2 ? window.devicePixelRatio : 1;
  if (strategy.canvasResolutionScaleMode != 0) {
   target.width = cssWidth * dpiScale;
   target.height = cssHeight * dpiScale;
   if (target.GLctxObject) target.GLctxObject.GLctx.viewport(0, 0, target.width, target.height);
  }
  return restoreOldStyle;
 }),
 requestFullscreen: (function(target, strategy) {
  if (strategy.scaleMode != 0 || strategy.canvasResolutionScaleMode != 0) {
   JSEvents.resizeCanvasForFullscreen(target, strategy);
  }
  if (target.requestFullscreen) {
   target.requestFullscreen();
  } else if (target.msRequestFullscreen) {
   target.msRequestFullscreen();
  } else if (target.mozRequestFullScreen) {
   target.mozRequestFullScreen();
  } else if (target.mozRequestFullscreen) {
   target.mozRequestFullscreen();
  } else if (target.webkitRequestFullscreen) {
   target.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT);
  } else {
   if (typeof JSEvents.fullscreenEnabled() === "undefined") {
    return -1;
   } else {
    return -3;
   }
  }
  if (strategy.canvasResizedCallback) {
   Runtime.dynCall("iiii", strategy.canvasResizedCallback, [ 37, 0, strategy.canvasResizedCallbackUserData ]);
  }
  return 0;
 }),
 fillPointerlockChangeEventData: (function(eventStruct, e) {
  var pointerLockElement = document.pointerLockElement || document.mozPointerLockElement || document.webkitPointerLockElement || document.msPointerLockElement;
  var isPointerlocked = !!pointerLockElement;
  HEAP32[eventStruct >> 2] = isPointerlocked;
  var nodeName = JSEvents.getNodeNameForTarget(pointerLockElement);
  var id = pointerLockElement && pointerLockElement.id ? pointerLockElement.id : "";
  writeStringToMemory(nodeName, eventStruct + 4);
  writeStringToMemory(id, eventStruct + 132);
 }),
 registerPointerlockChangeEventCallback: (function(target, userData, useCapture, callbackfunc, eventTypeId, eventTypeString) {
  if (!JSEvents.pointerlockChangeEvent) {
   JSEvents.pointerlockChangeEvent = _malloc(260);
  }
  if (!target) {
   target = document;
  } else {
   target = JSEvents.findEventTarget(target);
  }
  var handlerFunc = (function(event) {
   var e = event || window.event;
   JSEvents.fillPointerlockChangeEventData(JSEvents.pointerlockChangeEvent, e);
   var shouldCancel = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, JSEvents.pointerlockChangeEvent, userData ]);
   if (shouldCancel) {
    e.preventDefault();
   }
  });
  var eventHandler = {
   target: target,
   allowsDeferredCalls: false,
   eventTypeString: eventTypeString,
   callbackfunc: callbackfunc,
   handlerFunc: handlerFunc,
   useCapture: useCapture
  };
  JSEvents.registerOrRemoveHandler(eventHandler);
 }),
 registerPointerlockErrorEventCallback: (function(target, userData, useCapture, callbackfunc, eventTypeId, eventTypeString) {
  if (!target) {
   target = document;
  } else {
   target = JSEvents.findEventTarget(target);
  }
  var handlerFunc = (function(event) {
   var e = event || window.event;
   var shouldCancel = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, 0, userData ]);
   if (shouldCancel) {
    e.preventDefault();
   }
  });
  var eventHandler = {
   target: target,
   allowsDeferredCalls: false,
   eventTypeString: eventTypeString,
   callbackfunc: callbackfunc,
   handlerFunc: handlerFunc,
   useCapture: useCapture
  };
  JSEvents.registerOrRemoveHandler(eventHandler);
 }),
 requestPointerLock: (function(target) {
  if (target.requestPointerLock) {
   target.requestPointerLock();
  } else if (target.mozRequestPointerLock) {
   target.mozRequestPointerLock();
  } else if (target.webkitRequestPointerLock) {
   target.webkitRequestPointerLock();
  } else if (target.msRequestPointerLock) {
   target.msRequestPointerLock();
  } else {
   if (document.body.requestPointerLock || document.body.mozRequestPointerLock || document.body.webkitRequestPointerLock || document.body.msRequestPointerLock) {
    return -3;
   } else {
    return -1;
   }
  }
  return 0;
 }),
 fillVisibilityChangeEventData: (function(eventStruct, e) {
  var visibilityStates = [ "hidden", "visible", "prerender", "unloaded" ];
  var visibilityState = visibilityStates.indexOf(document.visibilityState);
  HEAP32[eventStruct >> 2] = document.hidden;
  HEAP32[eventStruct + 4 >> 2] = visibilityState;
 }),
 registerVisibilityChangeEventCallback: (function(target, userData, useCapture, callbackfunc, eventTypeId, eventTypeString) {
  if (!JSEvents.visibilityChangeEvent) {
   JSEvents.visibilityChangeEvent = _malloc(8);
  }
  if (!target) {
   target = document;
  } else {
   target = JSEvents.findEventTarget(target);
  }
  var handlerFunc = (function(event) {
   var e = event || window.event;
   JSEvents.fillVisibilityChangeEventData(JSEvents.visibilityChangeEvent, e);
   var shouldCancel = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, JSEvents.visibilityChangeEvent, userData ]);
   if (shouldCancel) {
    e.preventDefault();
   }
  });
  var eventHandler = {
   target: target,
   allowsDeferredCalls: false,
   eventTypeString: eventTypeString,
   callbackfunc: callbackfunc,
   handlerFunc: handlerFunc,
   useCapture: useCapture
  };
  JSEvents.registerOrRemoveHandler(eventHandler);
 }),
 registerTouchEventCallback: (function(target, userData, useCapture, callbackfunc, eventTypeId, eventTypeString) {
  if (!JSEvents.touchEvent) {
   JSEvents.touchEvent = _malloc(1684);
  }
  target = JSEvents.findEventTarget(target);
  var handlerFunc = (function(event) {
   var e = event || window.event;
   var touches = {};
   for (var i = 0; i < e.touches.length; ++i) {
    var touch = e.touches[i];
    touches[touch.identifier] = touch;
   }
   for (var i = 0; i < e.changedTouches.length; ++i) {
    var touch = e.changedTouches[i];
    touches[touch.identifier] = touch;
    touch.changed = true;
   }
   for (var i = 0; i < e.targetTouches.length; ++i) {
    var touch = e.targetTouches[i];
    touches[touch.identifier].onTarget = true;
   }
   var ptr = JSEvents.touchEvent;
   HEAP32[ptr + 4 >> 2] = e.ctrlKey;
   HEAP32[ptr + 8 >> 2] = e.shiftKey;
   HEAP32[ptr + 12 >> 2] = e.altKey;
   HEAP32[ptr + 16 >> 2] = e.metaKey;
   ptr += 20;
   var canvasRect = Module["canvas"] ? Module["canvas"].getBoundingClientRect() : undefined;
   var targetRect = JSEvents.getBoundingClientRectOrZeros(target);
   var numTouches = 0;
   for (var i in touches) {
    var t = touches[i];
    HEAP32[ptr >> 2] = t.identifier;
    HEAP32[ptr + 4 >> 2] = t.screenX;
    HEAP32[ptr + 8 >> 2] = t.screenY;
    HEAP32[ptr + 12 >> 2] = t.clientX;
    HEAP32[ptr + 16 >> 2] = t.clientY;
    HEAP32[ptr + 20 >> 2] = t.pageX;
    HEAP32[ptr + 24 >> 2] = t.pageY;
    HEAP32[ptr + 28 >> 2] = t.changed;
    HEAP32[ptr + 32 >> 2] = t.onTarget;
    if (canvasRect) {
     HEAP32[ptr + 44 >> 2] = t.clientX - canvasRect.left;
     HEAP32[ptr + 48 >> 2] = t.clientY - canvasRect.top;
    } else {
     HEAP32[ptr + 44 >> 2] = 0;
     HEAP32[ptr + 48 >> 2] = 0;
    }
    HEAP32[ptr + 36 >> 2] = t.clientX - targetRect.left;
    HEAP32[ptr + 40 >> 2] = t.clientY - targetRect.top;
    ptr += 52;
    if (++numTouches >= 32) {
     break;
    }
   }
   HEAP32[JSEvents.touchEvent >> 2] = numTouches;
   var shouldCancel = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, JSEvents.touchEvent, userData ]);
   if (shouldCancel) {
    e.preventDefault();
   }
  });
  var eventHandler = {
   target: target,
   allowsDeferredCalls: false,
   eventTypeString: eventTypeString,
   callbackfunc: callbackfunc,
   handlerFunc: handlerFunc,
   useCapture: useCapture
  };
  JSEvents.registerOrRemoveHandler(eventHandler);
 }),
 fillGamepadEventData: (function(eventStruct, e) {
  HEAPF64[eventStruct >> 3] = e.timestamp;
  for (var i = 0; i < e.axes.length; ++i) {
   HEAPF64[eventStruct + i * 8 + 16 >> 3] = e.axes[i];
  }
  for (var i = 0; i < e.buttons.length; ++i) {
   if (typeof e.buttons[i] === "object") {
    HEAPF64[eventStruct + i * 8 + 528 >> 3] = e.buttons[i].value;
   } else {
    HEAPF64[eventStruct + i * 8 + 528 >> 3] = e.buttons[i];
   }
  }
  for (var i = 0; i < e.buttons.length; ++i) {
   if (typeof e.buttons[i] === "object") {
    HEAP32[eventStruct + i * 4 + 1040 >> 2] = e.buttons[i].pressed;
   } else {
    HEAP32[eventStruct + i * 4 + 1040 >> 2] = e.buttons[i] == 1;
   }
  }
  HEAP32[eventStruct + 1296 >> 2] = e.connected;
  HEAP32[eventStruct + 1300 >> 2] = e.index;
  HEAP32[eventStruct + 8 >> 2] = e.axes.length;
  HEAP32[eventStruct + 12 >> 2] = e.buttons.length;
  writeStringToMemory(e.id, eventStruct + 1304);
  writeStringToMemory(e.mapping, eventStruct + 1368);
 }),
 registerGamepadEventCallback: (function(target, userData, useCapture, callbackfunc, eventTypeId, eventTypeString) {
  if (!JSEvents.gamepadEvent) {
   JSEvents.gamepadEvent = _malloc(1432);
  }
  var handlerFunc = (function(event) {
   var e = event || window.event;
   JSEvents.fillGamepadEventData(JSEvents.gamepadEvent, e.gamepad);
   var shouldCancel = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, JSEvents.gamepadEvent, userData ]);
   if (shouldCancel) {
    e.preventDefault();
   }
  });
  var eventHandler = {
   target: JSEvents.findEventTarget(target),
   allowsDeferredCalls: true,
   eventTypeString: eventTypeString,
   callbackfunc: callbackfunc,
   handlerFunc: handlerFunc,
   useCapture: useCapture
  };
  JSEvents.registerOrRemoveHandler(eventHandler);
 }),
 registerBeforeUnloadEventCallback: (function(target, userData, useCapture, callbackfunc, eventTypeId, eventTypeString) {
  var handlerFunc = (function(event) {
   var e = event || window.event;
   var confirmationMessage = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, 0, userData ]);
   if (confirmationMessage) {
    confirmationMessage = Pointer_stringify(confirmationMessage);
   }
   if (confirmationMessage) {
    e.preventDefault();
    e.returnValue = confirmationMessage;
    return confirmationMessage;
   }
  });
  var eventHandler = {
   target: JSEvents.findEventTarget(target),
   allowsDeferredCalls: false,
   eventTypeString: eventTypeString,
   callbackfunc: callbackfunc,
   handlerFunc: handlerFunc,
   useCapture: useCapture
  };
  JSEvents.registerOrRemoveHandler(eventHandler);
 }),
 battery: (function() {
  return navigator.battery || navigator.mozBattery || navigator.webkitBattery;
 }),
 fillBatteryEventData: (function(eventStruct, e) {
  HEAPF64[eventStruct >> 3] = e.chargingTime;
  HEAPF64[eventStruct + 8 >> 3] = e.dischargingTime;
  HEAPF64[eventStruct + 16 >> 3] = e.level;
  HEAP32[eventStruct + 24 >> 2] = e.charging;
 }),
 registerBatteryEventCallback: (function(target, userData, useCapture, callbackfunc, eventTypeId, eventTypeString) {
  if (!JSEvents.batteryEvent) {
   JSEvents.batteryEvent = _malloc(32);
  }
  var handlerFunc = (function(event) {
   var e = event || window.event;
   JSEvents.fillBatteryEventData(JSEvents.batteryEvent, JSEvents.battery());
   var shouldCancel = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, JSEvents.batteryEvent, userData ]);
   if (shouldCancel) {
    e.preventDefault();
   }
  });
  var eventHandler = {
   target: JSEvents.findEventTarget(target),
   allowsDeferredCalls: false,
   eventTypeString: eventTypeString,
   callbackfunc: callbackfunc,
   handlerFunc: handlerFunc,
   useCapture: useCapture
  };
  JSEvents.registerOrRemoveHandler(eventHandler);
 }),
 registerWebGlEventCallback: (function(target, userData, useCapture, callbackfunc, eventTypeId, eventTypeString) {
  if (!target) {
   target = Module["canvas"];
  }
  var handlerFunc = (function(event) {
   var e = event || window.event;
   var shouldCancel = Runtime.dynCall("iiii", callbackfunc, [ eventTypeId, 0, userData ]);
   if (shouldCancel) {
    e.preventDefault();
   }
  });
  var eventHandler = {
   target: JSEvents.findEventTarget(target),
   allowsDeferredCalls: false,
   eventTypeString: eventTypeString,
   callbackfunc: callbackfunc,
   handlerFunc: handlerFunc,
   useCapture: useCapture
  };
  JSEvents.registerOrRemoveHandler(eventHandler);
 })
};
Module["JSEvents"] = JSEvents;
function _emscripten_webgl_destroy_context(contextHandle) {
 GL.deleteContext(contextHandle);
}
Module["_emscripten_webgl_destroy_context"] = _emscripten_webgl_destroy_context;
function emscriptenWebGLGetIndexed(target, index, data, type) {
 if (!data) {
  GL.recordError(1281);
  return;
 }
 var result = GLctx["getIndexedParameter"](target, index);
 var ret;
 switch (typeof result) {
 case "boolean":
  ret = result ? 1 : 0;
  break;
 case "number":
  ret = result;
  break;
 case "object":
  if (result === null) {
   switch (target) {
   case 35983:
   case 35368:
    ret = 0;
    break;
   default:
    {
     GL.recordError(1280);
     return;
    }
   }
  } else if (result instanceof WebGLBuffer) {
   ret = result.name | 0;
  } else {
   GL.recordError(1280);
   return;
  }
  break;
 default:
  GL.recordError(1280);
  return;
 }
 switch (type) {
 case "Integer64":
  tempI64 = [ ret >>> 0, (tempDouble = ret, +Math_abs(tempDouble) >= +1 ? tempDouble > +0 ? (Math_min(+Math_floor(tempDouble / +4294967296), +4294967295) | 0) >>> 0 : ~~+Math_ceil((tempDouble - +(~~tempDouble >>> 0)) / +4294967296) >>> 0 : 0) ], HEAP32[data >> 2] = tempI64[0], HEAP32[data + 4 >> 2] = tempI64[1];
  break;
 case "Integer":
  HEAP32[data >> 2] = ret;
  break;
 case "Float":
  HEAPF32[data >> 2] = ret;
  break;
 case "Boolean":
  HEAP8[data >> 0] = ret ? 1 : 0;
  break;
 default:
  throw "internal emscriptenWebGLGetIndexed() error, bad type: " + type;
 }
}
Module["emscriptenWebGLGetIndexed"] = emscriptenWebGLGetIndexed;
function _glGetIntegeri_v(target, index, data) {
 emscriptenWebGLGetIndexed(target, index, data, "Integer");
}
Module["_glGetIntegeri_v"] = _glGetIntegeri_v;
function _emscripten_glTexParameteri(x0, x1, x2) {
 GLctx.texParameteri(x0, x1, x2);
}
Module["_emscripten_glTexParameteri"] = _emscripten_glTexParameteri;
function _glCompileShader(shader) {
 GLctx.compileShader(GL.shaders[shader]);
}
Module["_glCompileShader"] = _glCompileShader;
var ___tm_current = STATICTOP;
STATICTOP += 48;
Module["___tm_current"] = ___tm_current;
var ___tm_timezone = allocate(intArrayFromString("GMT"), "i8", ALLOC_STATIC);
Module["___tm_timezone"] = ___tm_timezone;
var _tzname = STATICTOP;
STATICTOP += 16;
Module["_tzname"] = _tzname;
var _daylight = STATICTOP;
STATICTOP += 16;
Module["_daylight"] = _daylight;
var _timezone = STATICTOP;
STATICTOP += 16;
Module["_timezone"] = _timezone;
function _tzset() {
 if (_tzset.called) return;
 _tzset.called = true;
 HEAP32[_timezone >> 2] = -(new Date).getTimezoneOffset() * 60;
 var winter = new Date(2e3, 0, 1);
 var summer = new Date(2e3, 6, 1);
 HEAP32[_daylight >> 2] = Number(winter.getTimezoneOffset() != summer.getTimezoneOffset());
 function extractZone(date) {
  var match = date.toTimeString().match(/\(([A-Za-z ]+)\)$/);
  return match ? match[1] : "GMT";
 }
 var winterName = extractZone(winter);
 var summerName = extractZone(summer);
 var winterNamePtr = allocate(intArrayFromString(winterName), "i8", ALLOC_NORMAL);
 var summerNamePtr = allocate(intArrayFromString(summerName), "i8", ALLOC_NORMAL);
 if (summer.getTimezoneOffset() < winter.getTimezoneOffset()) {
  HEAP32[_tzname >> 2] = winterNamePtr;
  HEAP32[_tzname + 4 >> 2] = summerNamePtr;
 } else {
  HEAP32[_tzname >> 2] = summerNamePtr;
  HEAP32[_tzname + 4 >> 2] = winterNamePtr;
 }
}
Module["_tzset"] = _tzset;
function _localtime_r(time, tmPtr) {
 _tzset();
 var date = new Date(HEAP32[time >> 2] * 1e3);
 HEAP32[tmPtr >> 2] = date.getSeconds();
 HEAP32[tmPtr + 4 >> 2] = date.getMinutes();
 HEAP32[tmPtr + 8 >> 2] = date.getHours();
 HEAP32[tmPtr + 12 >> 2] = date.getDate();
 HEAP32[tmPtr + 16 >> 2] = date.getMonth();
 HEAP32[tmPtr + 20 >> 2] = date.getFullYear() - 1900;
 HEAP32[tmPtr + 24 >> 2] = date.getDay();
 var start = new Date(date.getFullYear(), 0, 1);
 var yday = (date.getTime() - start.getTime()) / (1e3 * 60 * 60 * 24) | 0;
 HEAP32[tmPtr + 28 >> 2] = yday;
 HEAP32[tmPtr + 36 >> 2] = -(date.getTimezoneOffset() * 60);
 var summerOffset = (new Date(2e3, 6, 1)).getTimezoneOffset();
 var winterOffset = start.getTimezoneOffset();
 var dst = date.getTimezoneOffset() == Math.min(winterOffset, summerOffset) | 0;
 HEAP32[tmPtr + 32 >> 2] = dst;
 var zonePtr = HEAP32[_tzname + (dst ? Runtime.QUANTUM_SIZE : 0) >> 2];
 HEAP32[tmPtr + 40 >> 2] = zonePtr;
 return tmPtr;
}
Module["_localtime_r"] = _localtime_r;
function _localtime(time) {
 return _localtime_r(time, ___tm_current);
}
Module["_localtime"] = _localtime;
function _il2cpp_array_new_full() {
 if (!Module["_il2cpp_array_new_full"]) abort("external function 'il2cpp_array_new_full' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_array_new_full"].apply(null, arguments);
}
function _emscripten_glFrustum() {
 if (!Module["_emscripten_glFrustum"]) abort("external function 'emscripten_glFrustum' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_emscripten_glFrustum"].apply(null, arguments);
}
function _il2cpp_gchandle_get_target() {
 if (!Module["_il2cpp_gchandle_get_target"]) abort("external function 'il2cpp_gchandle_get_target' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_gchandle_get_target"].apply(null, arguments);
}
function _emscripten_glGetTexParameterfv(target, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 HEAPF32[params >> 2] = GLctx.getTexParameter(target, pname);
}
Module["_emscripten_glGetTexParameterfv"] = _emscripten_glGetTexParameterfv;
function _emscripten_glBindRenderbuffer(target, renderbuffer) {
 GLctx.bindRenderbuffer(target, renderbuffer ? GL.renderbuffers[renderbuffer] : null);
}
Module["_emscripten_glBindRenderbuffer"] = _emscripten_glBindRenderbuffer;
function _glVertexAttribIPointer(index, size, type, stride, ptr) {
 GLctx.vertexAttribIPointer(index, size, type, stride, ptr);
}
Module["_glVertexAttribIPointer"] = _glVertexAttribIPointer;
function __Z15ComputeSHA1HashPKhjPh() {
 if (!Module["__Z15ComputeSHA1HashPKhjPh"]) abort("external function '_Z15ComputeSHA1HashPKhjPh' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["__Z15ComputeSHA1HashPKhjPh"].apply(null, arguments);
}
function __emscripten_sample_gamepad_data() {
 if (Browser.mainLoop.currentFrameNumber !== JSEvents.lastGamepadStateFrame || !Browser.mainLoop.currentFrameNumber) {
  JSEvents.lastGamepadState = navigator.getGamepads ? navigator.getGamepads() : navigator.webkitGetGamepads ? navigator.webkitGetGamepads : null;
  JSEvents.lastGamepadStateFrame = Browser.mainLoop.currentFrameNumber;
 }
}
Module["__emscripten_sample_gamepad_data"] = __emscripten_sample_gamepad_data;
function _emscripten_get_gamepad_status(index, gamepadState) {
 __emscripten_sample_gamepad_data();
 if (!JSEvents.lastGamepadState) return -1;
 if (index < 0 || index >= JSEvents.lastGamepadState.length) return -5;
 if (!JSEvents.lastGamepadState[index]) return -7;
 JSEvents.fillGamepadEventData(gamepadState, JSEvents.lastGamepadState[index]);
 return 0;
}
Module["_emscripten_get_gamepad_status"] = _emscripten_get_gamepad_status;
function _utime(path, times) {
 var time;
 if (times) {
  var offset = 4;
  time = HEAP32[times + offset >> 2];
  time *= 1e3;
 } else {
  time = Date.now();
 }
 path = Pointer_stringify(path);
 try {
  FS.utime(path, time, time);
  return 0;
 } catch (e) {
  FS.handleFSError(e);
  return -1;
 }
}
Module["_utime"] = _utime;
function _emscripten_glCopyTexImage2D(x0, x1, x2, x3, x4, x5, x6, x7) {
 GLctx.copyTexImage2D(x0, x1, x2, x3, x4, x5, x6, x7);
}
Module["_emscripten_glCopyTexImage2D"] = _emscripten_glCopyTexImage2D;
function _il2cpp_object_unbox() {
 if (!Module["_il2cpp_object_unbox"]) abort("external function 'il2cpp_object_unbox' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_object_unbox"].apply(null, arguments);
}
function _il2cpp_gchandle_new_weakref() {
 if (!Module["_il2cpp_gchandle_new_weakref"]) abort("external function 'il2cpp_gchandle_new_weakref' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_gchandle_new_weakref"].apply(null, arguments);
}
function _emscripten_set_devicemotion_callback(userData, useCapture, callbackfunc) {
 JSEvents.registerDeviceMotionEventCallback(window, userData, useCapture, callbackfunc, 17, "devicemotion");
 return 0;
}
Module["_emscripten_set_devicemotion_callback"] = _emscripten_set_devicemotion_callback;
var systemInfo = {
 get: (function() {
  if (systemInfo.hasOwnProperty("hasWebGL")) return this;
  var unknown = "-";
  this.width = screen.width ? screen.width : 0;
  this.height = screen.height ? screen.height : 0;
  var nVer = navigator.appVersion;
  var nAgt = navigator.userAgent;
  var browser = navigator.appName;
  var version = "" + parseFloat(navigator.appVersion);
  var majorVersion = parseInt(navigator.appVersion, 10);
  var nameOffset, verOffset, ix;
  if ((verOffset = nAgt.indexOf("Opera")) != -1) {
   browser = "Opera";
   version = nAgt.substring(verOffset + 6);
   if ((verOffset = nAgt.indexOf("Version")) != -1) {
    version = nAgt.substring(verOffset + 8);
   }
  } else if ((verOffset = nAgt.indexOf("MSIE")) != -1) {
   browser = "Microsoft Internet Explorer";
   version = nAgt.substring(verOffset + 5);
  } else if ((verOffset = nAgt.indexOf("Chrome")) != -1) {
   browser = "Chrome";
   version = nAgt.substring(verOffset + 7);
  } else if ((verOffset = nAgt.indexOf("Safari")) != -1) {
   browser = "Safari";
   version = nAgt.substring(verOffset + 7);
   if ((verOffset = nAgt.indexOf("Version")) != -1) {
    version = nAgt.substring(verOffset + 8);
   }
  } else if ((verOffset = nAgt.indexOf("Firefox")) != -1) {
   browser = "Firefox";
   version = nAgt.substring(verOffset + 8);
  } else if (nAgt.indexOf("Trident/") != -1) {
   browser = "Microsoft Internet Explorer";
   version = nAgt.substring(nAgt.indexOf("rv:") + 3);
  } else if ((nameOffset = nAgt.lastIndexOf(" ") + 1) < (verOffset = nAgt.lastIndexOf("/"))) {
   browser = nAgt.substring(nameOffset, verOffset);
   version = nAgt.substring(verOffset + 1);
   if (browser.toLowerCase() == browser.toUpperCase()) {
    browser = navigator.appName;
   }
  }
  if ((ix = version.indexOf(";")) != -1) version = version.substring(0, ix);
  if ((ix = version.indexOf(" ")) != -1) version = version.substring(0, ix);
  if ((ix = version.indexOf(")")) != -1) version = version.substring(0, ix);
  majorVersion = parseInt("" + version, 10);
  if (isNaN(majorVersion)) {
   version = "" + parseFloat(navigator.appVersion);
   majorVersion = parseInt(navigator.appVersion, 10);
  }
  var mobile = /Mobile|mini|Fennec|Android|iP(ad|od|hone)/.test(nVer);
  var os = unknown;
  var clientStrings = [ {
   s: "Windows 3.11",
   r: /Win16/
  }, {
   s: "Windows 95",
   r: /(Windows 95|Win95|Windows_95)/
  }, {
   s: "Windows ME",
   r: /(Win 9x 4.90|Windows ME)/
  }, {
   s: "Windows 98",
   r: /(Windows 98|Win98)/
  }, {
   s: "Windows CE",
   r: /Windows CE/
  }, {
   s: "Windows 2000",
   r: /(Windows NT 5.0|Windows 2000)/
  }, {
   s: "Windows XP",
   r: /(Windows NT 5.1|Windows XP)/
  }, {
   s: "Windows Server 2003",
   r: /Windows NT 5.2/
  }, {
   s: "Windows Vista",
   r: /Windows NT 6.0/
  }, {
   s: "Windows 7",
   r: /(Windows 7|Windows NT 6.1)/
  }, {
   s: "Windows 8.1",
   r: /(Windows 8.1|Windows NT 6.3)/
  }, {
   s: "Windows 8",
   r: /(Windows 8|Windows NT 6.2)/
  }, {
   s: "Windows 10",
   r: /(Windows 10|Windows NT 10.0)/
  }, {
   s: "Windows NT 4.0",
   r: /(Windows NT 4.0|WinNT4.0|WinNT|Windows NT)/
  }, {
   s: "Windows ME",
   r: /Windows ME/
  }, {
   s: "Android",
   r: /Android/
  }, {
   s: "Open BSD",
   r: /OpenBSD/
  }, {
   s: "Sun OS",
   r: /SunOS/
  }, {
   s: "Linux",
   r: /(Linux|X11)/
  }, {
   s: "iOS",
   r: /(iPhone|iPad|iPod)/
  }, {
   s: "Mac OS X",
   r: /Mac OS X/
  }, {
   s: "Mac OS",
   r: /(MacPPC|MacIntel|Mac_PowerPC|Macintosh)/
  }, {
   s: "QNX",
   r: /QNX/
  }, {
   s: "UNIX",
   r: /UNIX/
  }, {
   s: "BeOS",
   r: /BeOS/
  }, {
   s: "OS/2",
   r: /OS\/2/
  }, {
   s: "Search Bot",
   r: /(nuhk|Googlebot|Yammybot|Openbot|Slurp|MSNBot|Ask Jeeves\/Teoma|ia_archiver)/
  } ];
  for (var id in clientStrings) {
   var cs = clientStrings[id];
   if (cs.r.test(nAgt)) {
    os = cs.s;
    break;
   }
  }
  var osVersion = unknown;
  if (/Windows/.test(os)) {
   osVersion = /Windows (.*)/.exec(os)[1];
   os = "Windows";
  }
  switch (os) {
  case "Mac OS X":
   osVersion = /Mac OS X (10[\.\_\d]+)/.exec(nAgt)[1];
   break;
  case "Android":
   osVersion = /Android ([\.\_\d]+)/.exec(nAgt)[1];
   break;
  case "iOS":
   osVersion = /OS (\d+)_(\d+)_?(\d+)?/.exec(nVer);
   osVersion = osVersion[1] + "." + osVersion[2] + "." + (osVersion[3] | 0);
   break;
  }
  this.browser = browser;
  this.browserVersion = version;
  this.mobile = mobile;
  this.os = os;
  this.osVersion = osVersion;
  this.hasWebGL = (function() {
   if (!window.WebGLRenderingContext) {
    return 0;
   }
   var canvas = document.createElement("canvas");
   var gl = canvas.getContext("webgl2");
   if (!gl) {
    var gl = canvas.getContext("experimental-webgl2");
    if (!gl) {
     var gl = canvas.getContext("webgl");
     if (!gl) {
      gl = canvas.getContext("experimental-webgl");
      if (!gl) {
       return 0;
      }
     }
     return 1;
    }
    return 2;
   }
   return 2;
  })();
  this.hasCursorLock = (function() {
   var e = document.createElement("canvas");
   if (e["requestPointerLock"] || e["mozRequestPointerLock"] || e["webkitRequestPointerLock"] || e["msRequestPointerLock"]) return 1; else return 0;
  })();
  this.hasFullscreen = (function() {
   var e = document.createElement("canvas");
   if (e["requestFullScreen"] || e["mozRequestFullScreen"] || e["msRequestFullscreen"] || e["webkitRequestFullScreen"]) {
    if (browser.indexOf("Safari") == -1) return 1;
   }
   return 0;
  })();
  this.language = window.navigator.userLanguage || window.navigator.language;
  return this;
 })
};
Module["systemInfo"] = systemInfo;
function _JS_SystemInfo_HasFullscreen() {
 return systemInfo.get().hasFullscreen;
}
Module["_JS_SystemInfo_HasFullscreen"] = _JS_SystemInfo_HasFullscreen;
function _emscripten_glTexParameterfv(target, pname, params) {
 var param = HEAPF32[params >> 2];
 GLctx.texParameterf(target, pname, param);
}
Module["_emscripten_glTexParameterfv"] = _emscripten_glTexParameterfv;
function _emscripten_glDepthRangef(x0, x1) {
 GLctx.depthRange(x0, x1);
}
Module["_emscripten_glDepthRangef"] = _emscripten_glDepthRangef;
function ___syscall214(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var uid = SYSCALLS.get();
  if (uid !== 0) return -ERRNO_CODES.EPERM;
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall214"] = ___syscall214;
function ___syscall204() {
 return ___syscall214.apply(null, arguments);
}
Module["___syscall204"] = ___syscall204;
function _sched_get_priority_max() {
 if (!Module["_sched_get_priority_max"]) abort("external function 'sched_get_priority_max' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_sched_get_priority_max"].apply(null, arguments);
}
function ___syscall168(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var fds = SYSCALLS.get(), nfds = SYSCALLS.get(), timeout = SYSCALLS.get();
  var nonzero = 0;
  for (var i = 0; i < nfds; i++) {
   var pollfd = fds + 8 * i;
   var fd = HEAP32[pollfd >> 2];
   var events = HEAP16[pollfd + 4 >> 1];
   var mask = 32;
   var stream = FS.getStream(fd);
   if (stream) {
    mask = SYSCALLS.DEFAULT_POLLMASK;
    if (stream.stream_ops.poll) {
     mask = stream.stream_ops.poll(stream);
    }
   }
   mask &= events | 8 | 16;
   if (mask) nonzero++;
   HEAP16[pollfd + 6 >> 1] = mask;
  }
  return nonzero;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall168"] = ___syscall168;
function ___syscall202(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall202"] = ___syscall202;
function ___syscall200() {
 return ___syscall202.apply(null, arguments);
}
Module["___syscall200"] = ___syscall200;
function ___syscall203() {
 return ___syscall214.apply(null, arguments);
}
Module["___syscall203"] = ___syscall203;
function _JS_SystemInfo_GetBrowserName(buffer, bufferSize) {
 var browser = systemInfo.get().browser;
 var result = browser;
 result = result.slice(0, Math.max(0, bufferSize));
 if (buffer) writeStringToMemory(result, buffer, true);
 return browser.length;
}
Module["_JS_SystemInfo_GetBrowserName"] = _JS_SystemInfo_GetBrowserName;
function _emscripten_glGetObjectParameterivARB() {
 if (!Module["_emscripten_glGetObjectParameterivARB"]) abort("external function 'emscripten_glGetObjectParameterivARB' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_emscripten_glGetObjectParameterivARB"].apply(null, arguments);
}
function _glCreateShader(shaderType) {
 var id = GL.getNewId(GL.shaders);
 GL.shaders[id] = GLctx.createShader(shaderType);
 return id;
}
Module["_glCreateShader"] = _glCreateShader;
Module["_round"] = _round;
function _emscripten_glBindAttribLocation(program, index, name) {
 name = Pointer_stringify(name);
 GLctx.bindAttribLocation(GL.programs[program], index, name);
}
Module["_emscripten_glBindAttribLocation"] = _emscripten_glBindAttribLocation;
function _glGenRenderbuffers(n, renderbuffers) {
 for (var i = 0; i < n; i++) {
  var renderbuffer = GLctx.createRenderbuffer();
  if (!renderbuffer) {
   GL.recordError(1282);
   while (i < n) HEAP32[renderbuffers + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.renderbuffers);
  renderbuffer.name = id;
  GL.renderbuffers[id] = renderbuffer;
  HEAP32[renderbuffers + i * 4 >> 2] = id;
 }
}
Module["_glGenRenderbuffers"] = _glGenRenderbuffers;
function _glCopyTexSubImage2D(x0, x1, x2, x3, x4, x5, x6, x7) {
 GLctx.copyTexSubImage2D(x0, x1, x2, x3, x4, x5, x6, x7);
}
Module["_glCopyTexSubImage2D"] = _glCopyTexSubImage2D;
function _glCompressedTexImage2D(target, level, internalFormat, width, height, border, imageSize, data) {
 var heapView;
 if (data) {
  heapView = HEAPU8.subarray(data, data + imageSize);
 } else {
  heapView = null;
 }
 GLctx["compressedTexImage2D"](target, level, internalFormat, width, height, border, heapView);
}
Module["_glCompressedTexImage2D"] = _glCompressedTexImage2D;
function _il2cpp_runtime_unhandled_exception_policy_set() {
 if (!Module["_il2cpp_runtime_unhandled_exception_policy_set"]) abort("external function 'il2cpp_runtime_unhandled_exception_policy_set' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_runtime_unhandled_exception_policy_set"].apply(null, arguments);
}
function _il2cpp_class_from_name() {
 if (!Module["_il2cpp_class_from_name"]) abort("external function 'il2cpp_class_from_name' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_from_name"].apply(null, arguments);
}
function _glBlendFuncSeparate(x0, x1, x2, x3) {
 GLctx.blendFuncSeparate(x0, x1, x2, x3);
}
Module["_glBlendFuncSeparate"] = _glBlendFuncSeparate;
function _il2cpp_class_is_inflated() {
 if (!Module["_il2cpp_class_is_inflated"]) abort("external function 'il2cpp_class_is_inflated' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_is_inflated"].apply(null, arguments);
}
Module["_memset"] = _memset;
function _glDrawBuffers(n, bufs) {
 var bufArray = [];
 for (var i = 0; i < n; i++) bufArray.push(HEAP32[bufs + i * 4 >> 2]);
 if (n == 0) {
  if (GLctx.getParameter(GLctx["DRAW_FRAMEBUFFER_BINDING"]) != 0) bufArray.push(GLctx["NONE"]); else {
   GL.recordError(1282);
   return;
  }
 }
 GLctx["drawBuffers"](bufArray);
}
Module["_glDrawBuffers"] = _glDrawBuffers;
function _JS_SystemInfo_HasCursorLock() {
 return systemInfo.get().hasCursorLock;
}
Module["_JS_SystemInfo_HasCursorLock"] = _JS_SystemInfo_HasCursorLock;
function _glBindBufferBase(target, index, buffer) {
 var bufferObj = buffer ? GL.buffers[buffer] : null;
 GLctx["bindBufferBase"](target, index, bufferObj);
}
Module["_glBindBufferBase"] = _glBindBufferBase;
var wr = {
 requestInstances: {},
 nextRequestId: 1
};
Module["wr"] = wr;
function _JS_WebRequest_Send(request, ptr, length) {
 var http = wr.requestInstances[request];
 try {
  if (length > 0) http.send(HEAPU8.subarray(ptr, ptr + length)); else http.send();
 } catch (e) {
  console.error(e.name + ": " + e.message);
 }
}
Module["_JS_WebRequest_Send"] = _JS_WebRequest_Send;
function ___lock() {}
Module["___lock"] = ___lock;
function _glCopyTexImage2D(x0, x1, x2, x3, x4, x5, x6, x7) {
 GLctx.copyTexImage2D(x0, x1, x2, x3, x4, x5, x6, x7);
}
Module["_glCopyTexImage2D"] = _glCopyTexImage2D;
function _emscripten_glGetVertexAttribPointerv(index, pname, pointer) {
 if (!pointer) {
  GL.recordError(1281);
  return;
 }
 HEAP32[pointer >> 2] = GLctx.getVertexAttribOffset(index, pname);
}
Module["_emscripten_glGetVertexAttribPointerv"] = _emscripten_glGetVertexAttribPointerv;
function _emscripten_glVertexAttrib3f(x0, x1, x2, x3) {
 GLctx.vertexAttrib3f(x0, x1, x2, x3);
}
Module["_emscripten_glVertexAttrib3f"] = _emscripten_glVertexAttrib3f;
function _il2cpp_string_length() {
 if (!Module["_il2cpp_string_length"]) abort("external function 'il2cpp_string_length' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_string_length"].apply(null, arguments);
}
function _emscripten_set_mousemove_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerMouseEventCallback(target, userData, useCapture, callbackfunc, 8, "mousemove");
 return 0;
}
Module["_emscripten_set_mousemove_callback"] = _emscripten_set_mousemove_callback;
function _glGetInternalformativ() {
 if (!Module["_glGetInternalformativ"]) abort("external function 'glGetInternalformativ' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_glGetInternalformativ"].apply(null, arguments);
}
function _glDeleteProgram(id) {
 if (!id) return;
 var program = GL.programs[id];
 if (!program) {
  GL.recordError(1281);
  return;
 }
 GLctx.deleteProgram(program);
 program.name = 0;
 GL.programs[id] = null;
 GL.programInfos[id] = null;
}
Module["_glDeleteProgram"] = _glDeleteProgram;
function ___clone() {
 if (!Module["___clone"]) abort("external function '__clone' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["___clone"].apply(null, arguments);
}
function _glRenderbufferStorage(x0, x1, x2, x3) {
 GLctx.renderbufferStorage(x0, x1, x2, x3);
}
Module["_glRenderbufferStorage"] = _glRenderbufferStorage;
var WEBAudio = {
 audioInstances: [],
 audioContext: {},
 audioWebEnabled: 0
};
Module["WEBAudio"] = WEBAudio;
function _JS_Sound_SetListenerPosition(x, y, z) {
 if (WEBAudio.audioWebEnabled == 0) return;
 WEBAudio.audioContext.listener.setPosition(x, y, z);
}
Module["_JS_Sound_SetListenerPosition"] = _JS_Sound_SetListenerPosition;
function _pthread_detach() {}
Module["_pthread_detach"] = _pthread_detach;
function _il2cpp_free_captured_memory_snapshot() {
 if (!Module["_il2cpp_free_captured_memory_snapshot"]) abort("external function 'il2cpp_free_captured_memory_snapshot' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_free_captured_memory_snapshot"].apply(null, arguments);
}
function _emscripten_set_touchstart_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerTouchEventCallback(target, userData, useCapture, callbackfunc, 22, "touchstart");
 return 0;
}
Module["_emscripten_set_touchstart_callback"] = _emscripten_set_touchstart_callback;
function _il2cpp_class_from_system_type() {
 if (!Module["_il2cpp_class_from_system_type"]) abort("external function 'il2cpp_class_from_system_type' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_from_system_type"].apply(null, arguments);
}
function _il2cpp_class_is_generic() {
 if (!Module["_il2cpp_class_is_generic"]) abort("external function 'il2cpp_class_is_generic' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_is_generic"].apply(null, arguments);
}
function _emscripten_glDeleteShader(id) {
 if (!id) return;
 var shader = GL.shaders[id];
 if (!shader) {
  GL.recordError(1281);
  return;
 }
 GLctx.deleteShader(shader);
 GL.shaders[id] = null;
}
Module["_emscripten_glDeleteShader"] = _emscripten_glDeleteShader;
function ___syscall9(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var oldpath = SYSCALLS.get(), newpath = SYSCALLS.get();
  return -ERRNO_CODES.EMLINK;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall9"] = ___syscall9;
function _pthread_attr_init(attr) {
 return 0;
}
Module["_pthread_attr_init"] = _pthread_attr_init;
function _emscripten_glDrawArraysInstanced(mode, first, count, primcount) {
 GLctx["drawArraysInstanced"](mode, first, count, primcount);
}
Module["_emscripten_glDrawArraysInstanced"] = _emscripten_glDrawArraysInstanced;
function _emscripten_glDeleteBuffers(n, buffers) {
 for (var i = 0; i < n; i++) {
  var id = HEAP32[buffers + i * 4 >> 2];
  var buffer = GL.buffers[id];
  if (!buffer) continue;
  GLctx.deleteBuffer(buffer);
  buffer.name = 0;
  GL.buffers[id] = null;
  if (id == GL.currArrayBuffer) GL.currArrayBuffer = 0;
  if (id == GL.currElementArrayBuffer) GL.currElementArrayBuffer = 0;
 }
}
Module["_emscripten_glDeleteBuffers"] = _emscripten_glDeleteBuffers;
function _emscripten_glTexParameteriv(target, pname, params) {
 var param = HEAP32[params >> 2];
 GLctx.texParameteri(target, pname, param);
}
Module["_emscripten_glTexParameteriv"] = _emscripten_glTexParameteriv;
function ___syscall1(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var status = SYSCALLS.get();
  Module["exit"](status);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall1"] = ___syscall1;
function _emscripten_glUniformMatrix2fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (4 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[4 * count - 1];
  for (var i = 0; i < 4 * count; i += 4) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 16 >> 2);
 }
 GLctx.uniformMatrix2fv(location, transpose, view);
}
Module["_emscripten_glUniformMatrix2fv"] = _emscripten_glUniformMatrix2fv;
function ___syscall5(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var pathname = SYSCALLS.getStr(), flags = SYSCALLS.get(), mode = SYSCALLS.get();
  var stream = FS.open(pathname, flags, mode);
  return stream.fd;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall5"] = ___syscall5;
function ___syscall4(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD(), buf = SYSCALLS.get(), count = SYSCALLS.get();
  return FS.write(stream, HEAP8, buf, count);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall4"] = ___syscall4;
function ___syscall297(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var dirfd = SYSCALLS.get(), path = SYSCALLS.getStr(), mode = SYSCALLS.get(), dev = SYSCALLS.get();
  path = SYSCALLS.calculateAt(dirfd, path);
  return SYSCALLS.doMknod(path, mode, dev);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall297"] = ___syscall297;
function _glGenVertexArrays(n, arrays) {
 for (var i = 0; i < n; i++) {
  var vao = GLctx["createVertexArray"]();
  if (!vao) {
   GL.recordError(1282);
   while (i < n) HEAP32[arrays + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.vaos);
  vao.name = id;
  GL.vaos[id] = vao;
  HEAP32[arrays + i * 4 >> 2] = id;
 }
}
Module["_glGenVertexArrays"] = _glGenVertexArrays;
function ___syscall118(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD();
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall118"] = ___syscall118;
function _llvm_stacksave() {
 var self = _llvm_stacksave;
 if (!self.LLVM_SAVEDSTACKS) {
  self.LLVM_SAVEDSTACKS = [];
 }
 self.LLVM_SAVEDSTACKS.push(Runtime.stackSave());
 return self.LLVM_SAVEDSTACKS.length - 1;
}
Module["_llvm_stacksave"] = _llvm_stacksave;
function _il2cpp_class_enum_basetype() {
 if (!Module["_il2cpp_class_enum_basetype"]) abort("external function 'il2cpp_class_enum_basetype' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_enum_basetype"].apply(null, arguments);
}
function _glTexStorage3D(x0, x1, x2, x3, x4, x5) {
 GLctx.texStorage3D(x0, x1, x2, x3, x4, x5);
}
Module["_glTexStorage3D"] = _glTexStorage3D;
function _il2cpp_field_has_attribute() {
 if (!Module["_il2cpp_field_has_attribute"]) abort("external function 'il2cpp_field_has_attribute' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_field_has_attribute"].apply(null, arguments);
}
function __ZN4FMOD13DSPConnection6getMixEPf() {
 if (!Module["__ZN4FMOD13DSPConnection6getMixEPf"]) abort("external function '_ZN4FMOD13DSPConnection6getMixEPf' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["__ZN4FMOD13DSPConnection6getMixEPf"].apply(null, arguments);
}
function _il2cpp_class_is_abstract() {
 if (!Module["_il2cpp_class_is_abstract"]) abort("external function 'il2cpp_class_is_abstract' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_is_abstract"].apply(null, arguments);
}
function _emscripten_glEnableClientState() {
 if (!Module["_emscripten_glEnableClientState"]) abort("external function 'emscripten_glEnableClientState' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_emscripten_glEnableClientState"].apply(null, arguments);
}
function _il2cpp_string_new_wrapper() {
 if (!Module["_il2cpp_string_new_wrapper"]) abort("external function 'il2cpp_string_new_wrapper' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_string_new_wrapper"].apply(null, arguments);
}
function _JS_Cursor_SetCursorString(cursor) {
 try {
  if (document.styleSheets.length == 0) {
   console.log("can't set cursor because there is no style sheet.");
   return;
  }
  var styleSheet = document.styleSheets[0];
  var rule = "canvas.emscripten { border: 0px none; cursor: " + cursor + "; }";
  for (var i = 0; i < styleSheet.cssRules.length; i++) {
   if (styleSheet.cssRules[i].cssText.indexOf("canvas.emscripten") != -1) {
    styleSheet.deleteRule(i);
    styleSheet.insertRule(rule, 0);
    return;
   }
  }
  styleSheet.insertRule(rule, 0);
 } catch (e) {
  console.error("Could not set cursor due to exception " + e);
 }
}
Module["_JS_Cursor_SetCursorString"] = _JS_Cursor_SetCursorString;
function _JS_Cursor_SetShow(show) {
 var cursor = show ? "default" : "none";
 _JS_Cursor_SetCursorString(cursor);
}
Module["_JS_Cursor_SetShow"] = _JS_Cursor_SetShow;
function __ZN4FMOD3DSP11getCPUUsageEPt() {
 if (!Module["__ZN4FMOD3DSP11getCPUUsageEPt"]) abort("external function '_ZN4FMOD3DSP11getCPUUsageEPt' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["__ZN4FMOD3DSP11getCPUUsageEPt"].apply(null, arguments);
}
function _emscripten_glStencilMask(x0) {
 GLctx.stencilMask(x0);
}
Module["_emscripten_glStencilMask"] = _emscripten_glStencilMask;
function _JS_Sound_SetListenerOrientation(x, y, z, xUp, yUp, zUp) {
 if (WEBAudio.audioWebEnabled == 0) return;
 WEBAudio.audioContext.listener.setOrientation(-x, -y, -z, xUp, yUp, zUp);
}
Module["_JS_Sound_SetListenerOrientation"] = _JS_Sound_SetListenerOrientation;
function _JS_Eval_SetTimeout(func, arg, millis) {
 Module["noExitRuntime"] = true;
 function wrapper() {
  Runtime.getFuncWrapper(func, "vi")(arg);
 }
 return Browser.safeSetTimeout(wrapper, millis);
}
Module["_JS_Eval_SetTimeout"] = _JS_Eval_SetTimeout;
function _glIsVertexArray(array) {
 var vao = GL.vaos[array];
 if (!vao) return 0;
 return GLctx["isVertexArray"](vao);
}
Module["_glIsVertexArray"] = _glIsVertexArray;
function _emscripten_webgl_init_context_attributes(attributes) {
 HEAP32[attributes >> 2] = 1;
 HEAP32[attributes + 4 >> 2] = 1;
 HEAP32[attributes + 8 >> 2] = 0;
 HEAP32[attributes + 12 >> 2] = 1;
 HEAP32[attributes + 16 >> 2] = 1;
 HEAP32[attributes + 20 >> 2] = 0;
 HEAP32[attributes + 24 >> 2] = 0;
 HEAP32[attributes + 28 >> 2] = 0;
 HEAP32[attributes + 32 >> 2] = 1;
 HEAP32[attributes + 36 >> 2] = 0;
 HEAP32[attributes + 40 >> 2] = 1;
 HEAP32[attributes + 44 >> 2] = 0;
}
Module["_emscripten_webgl_init_context_attributes"] = _emscripten_webgl_init_context_attributes;
function _JS_Eval_EvalJS(ptr) {
 var str = Pointer_stringify(ptr);
 try {
  window.eval(str);
 } catch (exception) {
  console.error(exception);
 }
}
Module["_JS_Eval_EvalJS"] = _JS_Eval_EvalJS;
function _glDisableVertexAttribArray(index) {
 GLctx.disableVertexAttribArray(index);
}
Module["_glDisableVertexAttribArray"] = _glDisableVertexAttribArray;
function _il2cpp_runtime_invoke_convert_args() {
 if (!Module["_il2cpp_runtime_invoke_convert_args"]) abort("external function 'il2cpp_runtime_invoke_convert_args' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_runtime_invoke_convert_args"].apply(null, arguments);
}
function _glDeleteFramebuffers(n, framebuffers) {
 for (var i = 0; i < n; ++i) {
  var id = HEAP32[framebuffers + i * 4 >> 2];
  var framebuffer = GL.framebuffers[id];
  if (!framebuffer) continue;
  GLctx.deleteFramebuffer(framebuffer);
  framebuffer.name = 0;
  GL.framebuffers[id] = null;
 }
}
Module["_glDeleteFramebuffers"] = _glDeleteFramebuffers;
function _glDrawArrays(mode, first, count) {
 GLctx.drawArrays(mode, first, count);
}
Module["_glDrawArrays"] = _glDrawArrays;
function _emscripten_webgl_enable_extension(contextHandle, extension) {
 var context = GL.getContext(contextHandle);
 var extString = Pointer_stringify(extension);
 if (extString.indexOf("GL_") == 0) extString = extString.substr(3);
 var ext = context.GLctx.getExtension(extString);
 return ext ? 1 : 0;
}
Module["_emscripten_webgl_enable_extension"] = _emscripten_webgl_enable_extension;
function _emscripten_get_num_gamepads() {
 __emscripten_sample_gamepad_data();
 if (!JSEvents.lastGamepadState) return -1;
 return JSEvents.lastGamepadState.length;
}
Module["_emscripten_get_num_gamepads"] = _emscripten_get_num_gamepads;
function _emscripten_set_blur_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerFocusEventCallback(target, userData, useCapture, callbackfunc, 12, "blur");
 return 0;
}
Module["_emscripten_set_blur_callback"] = _emscripten_set_blur_callback;
function _mktime(tmPtr) {
 _tzset();
 var date = new Date(HEAP32[tmPtr + 20 >> 2] + 1900, HEAP32[tmPtr + 16 >> 2], HEAP32[tmPtr + 12 >> 2], HEAP32[tmPtr + 8 >> 2], HEAP32[tmPtr + 4 >> 2], HEAP32[tmPtr >> 2], 0);
 var dst = HEAP32[tmPtr + 32 >> 2];
 var guessedOffset = date.getTimezoneOffset();
 var start = new Date(date.getFullYear(), 0, 1);
 var summerOffset = (new Date(2e3, 6, 1)).getTimezoneOffset();
 var winterOffset = start.getTimezoneOffset();
 var dstOffset = Math.min(winterOffset, summerOffset);
 if (dst < 0) {
  HEAP32[tmPtr + 32 >> 2] = Number(dstOffset == guessedOffset);
 } else if (dst > 0 != (dstOffset == guessedOffset)) {
  var nonDstOffset = Math.max(winterOffset, summerOffset);
  var trueOffset = dst > 0 ? dstOffset : nonDstOffset;
  date.setTime(date.getTime() + (trueOffset - guessedOffset) * 6e4);
 }
 HEAP32[tmPtr + 24 >> 2] = date.getDay();
 var yday = (date.getTime() - start.getTime()) / (1e3 * 60 * 60 * 24) | 0;
 HEAP32[tmPtr + 28 >> 2] = yday;
 return date.getTime() / 1e3 | 0;
}
Module["_mktime"] = _mktime;
function _glClear(x0) {
 GLctx.clear(x0);
}
Module["_glClear"] = _glClear;
function _glUniform2iv(location, count, value) {
 location = GL.uniforms[location];
 count *= 2;
 value = HEAP32.subarray(value >> 2, value + count * 4 >> 2);
 GLctx.uniform2iv(location, value);
}
Module["_glUniform2iv"] = _glUniform2iv;
function _glIsEnabled(x0) {
 return GLctx.isEnabled(x0);
}
Module["_glIsEnabled"] = _glIsEnabled;
function _il2cpp_type_get_class_or_element_class() {
 if (!Module["_il2cpp_type_get_class_or_element_class"]) abort("external function 'il2cpp_type_get_class_or_element_class' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_type_get_class_or_element_class"].apply(null, arguments);
}
function _glFramebufferTexture2D(target, attachment, textarget, texture, level) {
 GLctx.framebufferTexture2D(target, attachment, textarget, GL.textures[texture], level);
}
Module["_glFramebufferTexture2D"] = _glFramebufferTexture2D;
function _glGetFramebufferAttachmentParameteriv(target, attachment, pname, params) {
 var result = GLctx.getFramebufferAttachmentParameter(target, attachment, pname);
 HEAP32[params >> 2] = result;
}
Module["_glGetFramebufferAttachmentParameteriv"] = _glGetFramebufferAttachmentParameteriv;
function _emscripten_request_pointerlock(target, deferUntilInEventHandler) {
 if (!target) target = "#canvas";
 target = JSEvents.findEventTarget(target);
 if (!target) return -4;
 if (!target.requestPointerLock && !target.mozRequestPointerLock && !target.webkitRequestPointerLock && !target.msRequestPointerLock) {
  return -1;
 }
 var canPerformRequests = JSEvents.canPerformEventHandlerRequests();
 if (!canPerformRequests) {
  if (deferUntilInEventHandler) {
   JSEvents.deferCall(JSEvents.requestPointerLock, 2, [ target ]);
   return 1;
  } else {
   return -2;
  }
 }
 return JSEvents.requestPointerLock(target);
}
Module["_emscripten_request_pointerlock"] = _emscripten_request_pointerlock;
var webcam = {
 canvas: null
};
Module["webcam"] = webcam;
function _JS_WebCamVideo_GetNativeHeight(deviceId) {
 return MediaDevices[deviceId].video ? MediaDevices[deviceId].video.videoHeight : 0;
}
Module["_JS_WebCamVideo_GetNativeHeight"] = _JS_WebCamVideo_GetNativeHeight;
Module["_pthread_cond_broadcast"] = _pthread_cond_broadcast;
function _gettimeofday(ptr) {
 var now = Date.now();
 HEAP32[ptr >> 2] = now / 1e3 | 0;
 HEAP32[ptr + 4 >> 2] = now % 1e3 * 1e3 | 0;
 return 0;
}
Module["_gettimeofday"] = _gettimeofday;
function _il2cpp_object_get_class() {
 if (!Module["_il2cpp_object_get_class"]) abort("external function 'il2cpp_object_get_class' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_object_get_class"].apply(null, arguments);
}
function _glTexParameteriv(target, pname, params) {
 var param = HEAP32[params >> 2];
 GLctx.texParameteri(target, pname, param);
}
Module["_glTexParameteriv"] = _glTexParameteriv;
function _llvm_trap() {
 abort("trap!");
}
Module["_llvm_trap"] = _llvm_trap;
function _JS_Sound_SetVolume(channelInstance, v) {
 if (WEBAudio.audioWebEnabled == 0) return;
 WEBAudio.audioInstances[channelInstance].gain.gain.value = v;
}
Module["_JS_Sound_SetVolume"] = _JS_Sound_SetVolume;
function _il2cpp_method_get_param_count() {
 if (!Module["_il2cpp_method_get_param_count"]) abort("external function 'il2cpp_method_get_param_count' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_method_get_param_count"].apply(null, arguments);
}
function _glGenFramebuffers(n, ids) {
 for (var i = 0; i < n; ++i) {
  var framebuffer = GLctx.createFramebuffer();
  if (!framebuffer) {
   GL.recordError(1282);
   while (i < n) HEAP32[ids + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.framebuffers);
  framebuffer.name = id;
  GL.framebuffers[id] = framebuffer;
  HEAP32[ids + i * 4 >> 2] = id;
 }
}
Module["_glGenFramebuffers"] = _glGenFramebuffers;
function _glFramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer) {
 GLctx.framebufferRenderbuffer(target, attachment, renderbuffertarget, GL.renderbuffers[renderbuffer]);
}
Module["_glFramebufferRenderbuffer"] = _glFramebufferRenderbuffer;
function _il2cpp_class_from_type() {
 if (!Module["_il2cpp_class_from_type"]) abort("external function 'il2cpp_class_from_type' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_from_type"].apply(null, arguments);
}
function _emscripten_glGetTexParameteriv(target, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 HEAP32[params >> 2] = GLctx.getTexParameter(target, pname);
}
Module["_emscripten_glGetTexParameteriv"] = _emscripten_glGetTexParameteriv;
function ___syscall121(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return -ERRNO_CODES.EPERM;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall121"] = ___syscall121;
function ___syscall122(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var buf = SYSCALLS.get();
  if (!buf) return -ERRNO_CODES.EFAULT;
  var layout = {
   "sysname": 0,
   "nodename": 65,
   "domainname": 325,
   "machine": 260,
   "version": 195,
   "release": 130,
   "__size__": 390
  };
  function copyString(element, value) {
   var offset = layout[element];
   writeAsciiToMemory(value, buf + offset);
  }
  copyString("sysname", "Emscripten");
  copyString("nodename", "emscripten");
  copyString("release", "1.0");
  copyString("version", "#1");
  copyString("machine", "x86-JS");
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall122"] = ___syscall122;
function ___syscall125(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall125"] = ___syscall125;
var _llvm_ctlz_i32 = true;
Module["_llvm_ctlz_i32"] = _llvm_ctlz_i32;
function _glDeleteVertexArrays(n, vaos) {
 for (var i = 0; i < n; i++) {
  var id = HEAP32[vaos + i * 4 >> 2];
  GLctx["deleteVertexArray"](GL.vaos[id]);
  GL.vaos[id] = null;
 }
}
Module["_glDeleteVertexArrays"] = _glDeleteVertexArrays;
function _emscripten_glSampleCoverage(x0, x1) {
 GLctx.sampleCoverage(x0, x1);
}
Module["_emscripten_glSampleCoverage"] = _emscripten_glSampleCoverage;
function _JS_WebCamVideo_GrabFrame(deviceId, buffer, destWidth, destHeight) {
 if (!MediaDevices[deviceId].video) {
  console.error("WebCam not initialized.");
  return;
 }
 var context = webcam.canvas.getContext("2d");
 if (context) {
  canvas.width = destWidth;
  canvas.height = destHeight;
  context.drawImage(MediaDevices[deviceId].video, 0, 0, MediaDevices[deviceId].video.videoWidth, MediaDevices[deviceId].video.videoHeight, 0, 0, destWidth, destHeight);
  var imageData = context.getImageData(0, 0, destWidth, destHeight);
  writeArrayToMemory(imageData.data, buffer);
 } else {
  console.log("2d Context is null");
 }
}
Module["_JS_WebCamVideo_GrabFrame"] = _JS_WebCamVideo_GrabFrame;
var PROCINFO = {
 ppid: 1,
 pid: 42,
 sid: 42,
 pgid: 42
};
Module["PROCINFO"] = PROCINFO;
function ___syscall65(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return PROCINFO.pgid;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall65"] = ___syscall65;
function ___syscall66(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall66"] = ___syscall66;
function ___syscall60(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var mask = SYSCALLS.get();
  var old = SYSCALLS.umask;
  SYSCALLS.umask = mask;
  return old;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall60"] = ___syscall60;
function _sysconf(name) {
 switch (name) {
 case 30:
  return PAGE_SIZE;
 case 85:
  return totalMemory / PAGE_SIZE;
 case 132:
 case 133:
 case 12:
 case 137:
 case 138:
 case 15:
 case 235:
 case 16:
 case 17:
 case 18:
 case 19:
 case 20:
 case 149:
 case 13:
 case 10:
 case 236:
 case 153:
 case 9:
 case 21:
 case 22:
 case 159:
 case 154:
 case 14:
 case 77:
 case 78:
 case 139:
 case 80:
 case 81:
 case 82:
 case 68:
 case 67:
 case 164:
 case 11:
 case 29:
 case 47:
 case 48:
 case 95:
 case 52:
 case 51:
 case 46:
  return 200809;
 case 79:
  return 0;
 case 27:
 case 246:
 case 127:
 case 128:
 case 23:
 case 24:
 case 160:
 case 161:
 case 181:
 case 182:
 case 242:
 case 183:
 case 184:
 case 243:
 case 244:
 case 245:
 case 165:
 case 178:
 case 179:
 case 49:
 case 50:
 case 168:
 case 169:
 case 175:
 case 170:
 case 171:
 case 172:
 case 97:
 case 76:
 case 32:
 case 173:
 case 35:
  return -1;
 case 176:
 case 177:
 case 7:
 case 155:
 case 8:
 case 157:
 case 125:
 case 126:
 case 92:
 case 93:
 case 129:
 case 130:
 case 131:
 case 94:
 case 91:
  return 1;
 case 74:
 case 60:
 case 69:
 case 70:
 case 4:
  return 1024;
 case 31:
 case 42:
 case 72:
  return 32;
 case 87:
 case 26:
 case 33:
  return 2147483647;
 case 34:
 case 1:
  return 47839;
 case 38:
 case 36:
  return 99;
 case 43:
 case 37:
  return 2048;
 case 0:
  return 2097152;
 case 3:
  return 65536;
 case 28:
  return 32768;
 case 44:
  return 32767;
 case 75:
  return 16384;
 case 39:
  return 1e3;
 case 89:
  return 700;
 case 71:
  return 256;
 case 40:
  return 255;
 case 2:
  return 100;
 case 180:
  return 64;
 case 25:
  return 20;
 case 5:
  return 16;
 case 6:
  return 6;
 case 73:
  return 4;
 case 84:
  {
   if (typeof navigator === "object") return navigator["hardwareConcurrency"] || 1;
   return 1;
  }
 }
 ___setErrNo(ERRNO_CODES.EINVAL);
 return -1;
}
Module["_sysconf"] = _sysconf;
function ___syscall63(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var old = SYSCALLS.getStreamFromFD(), suggestFD = SYSCALLS.get();
  if (old.fd === suggestFD) return suggestFD;
  return SYSCALLS.doDup(old.path, old.flags, suggestFD);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall63"] = ___syscall63;
function _il2cpp_gc_collect() {
 if (!Module["_il2cpp_gc_collect"]) abort("external function 'il2cpp_gc_collect' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_gc_collect"].apply(null, arguments);
}
function ___wait() {
 if (!Module["___wait"]) abort("external function '__wait' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["___wait"].apply(null, arguments);
}
function _il2cpp_string_new_len() {
 if (!Module["_il2cpp_string_new_len"]) abort("external function 'il2cpp_string_new_len' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_string_new_len"].apply(null, arguments);
}
function _emscripten_glMatrixMode() {
 throw "Legacy GL function (glMatrixMode) called. If you want legacy GL emulation, you need to compile with -s LEGACY_GL_EMULATION=1 to enable legacy GL emulation.";
}
Module["_emscripten_glMatrixMode"] = _emscripten_glMatrixMode;
function _abort() {
 Module["abort"]();
}
Module["_abort"] = _abort;
function _JS_Log_Dump(ptr, type) {
 var str = Pointer_stringify(ptr);
 if (typeof dump == "function") dump(str);
 switch (type) {
 case 0:
 case 1:
 case 4:
  console.error(str);
  return;
 case 2:
  console.warn(str);
  return;
 case 3:
 case 5:
  console.log(str);
  return;
 default:
  console.error("Unknown console message type!");
  console.error(str);
 }
}
Module["_JS_Log_Dump"] = _JS_Log_Dump;
function _JS_WebCamVideo_CanPlay(deviceId) {
 return MediaDevices[deviceId].video && MediaDevices[deviceId].video.videoWidth > 0 && MediaDevices[deviceId].video.videoHeight > 0;
}
Module["_JS_WebCamVideo_CanPlay"] = _JS_WebCamVideo_CanPlay;
function _emscripten_glPolygonOffset(x0, x1) {
 GLctx.polygonOffset(x0, x1);
}
Module["_emscripten_glPolygonOffset"] = _emscripten_glPolygonOffset;
function _emscripten_glIsBuffer(buffer) {
 var b = GL.buffers[buffer];
 if (!b) return 0;
 return GLctx.isBuffer(b);
}
Module["_emscripten_glIsBuffer"] = _emscripten_glIsBuffer;
function _JS_WebCamVideo_GetNumDevices() {
 return MediaDevices.length;
}
Module["_JS_WebCamVideo_GetNumDevices"] = _JS_WebCamVideo_GetNumDevices;
function _il2cpp_profiler_install_allocation() {
 if (!Module["_il2cpp_profiler_install_allocation"]) abort("external function 'il2cpp_profiler_install_allocation' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_profiler_install_allocation"].apply(null, arguments);
}
var PTHREAD_SPECIFIC = {};
Module["PTHREAD_SPECIFIC"] = PTHREAD_SPECIFIC;
function _pthread_getspecific(key) {
 return PTHREAD_SPECIFIC[key] || 0;
}
Module["_pthread_getspecific"] = _pthread_getspecific;
function _glEnable(x0) {
 GLctx.enable(x0);
}
Module["_glEnable"] = _glEnable;
function _glGetActiveUniformsiv(program, uniformCount, uniformIndices, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 if (uniformCount > 0 && uniformIndices == 0) {
  GL.recordError(1281);
  return;
 }
 program = GL.programs[program];
 var ids = [];
 for (var i = 0; i < uniformCount; i++) {
  ids.push(HEAP32[uniformIndices + i * 4 >> 2]);
 }
 var result = GLctx["getActiveUniforms"](program, ids, pname);
 if (!result) return;
 var len = result.length;
 for (var i = 0; i < len; i++) {
  HEAP32[params + i * 4 >> 2] = result[i];
 }
}
Module["_glGetActiveUniformsiv"] = _glGetActiveUniformsiv;
function _il2cpp_gc_enable() {
 if (!Module["_il2cpp_gc_enable"]) abort("external function 'il2cpp_gc_enable' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_gc_enable"].apply(null, arguments);
}
function emscriptenWebGLComputeImageSize(width, height, sizePerPixel, alignment) {
 function roundedToNextMultipleOf(x, y) {
  return Math.floor((x + y - 1) / y) * y;
 }
 var plainRowSize = width * sizePerPixel;
 var alignedRowSize = roundedToNextMultipleOf(plainRowSize, alignment);
 return height <= 0 ? 0 : (height - 1) * alignedRowSize + plainRowSize;
}
Module["emscriptenWebGLComputeImageSize"] = emscriptenWebGLComputeImageSize;
function emscriptenWebGLGetTexPixelData(type, format, width, height, pixels, internalFormat) {
 var sizePerPixel;
 var numChannels;
 switch (format) {
 case 6406:
 case 6409:
 case 6402:
 case 6403:
 case 36244:
  numChannels = 1;
  break;
 case 6410:
 case 33319:
 case 33320:
  numChannels = 2;
  break;
 case 6407:
 case 35904:
 case 36248:
  numChannels = 3;
  break;
 case 6408:
 case 35906:
 case 36249:
  numChannels = 4;
  break;
 default:
  GL.recordError(1280);
  return null;
 }
 switch (type) {
 case 5121:
 case 5120:
  sizePerPixel = numChannels * 1;
  break;
 case 5123:
 case 36193:
 case 5131:
 case 5122:
  sizePerPixel = numChannels * 2;
  break;
 case 5125:
 case 5126:
 case 5124:
  sizePerPixel = numChannels * 4;
  break;
 case 34042:
 case 35902:
 case 33640:
 case 35899:
 case 34042:
  sizePerPixel = 4;
  break;
 case 33635:
 case 32819:
 case 32820:
  sizePerPixel = 2;
  break;
 default:
  GL.recordError(1280);
  return null;
 }
 var bytes = emscriptenWebGLComputeImageSize(width, height, sizePerPixel, GL.unpackAlignment);
 switch (type) {
 case 5120:
  return HEAP8.subarray(pixels, pixels + bytes);
 case 5121:
  return HEAPU8.subarray(pixels, pixels + bytes);
 case 5122:
  return HEAP16.subarray(pixels >> 1, pixels + bytes >> 1);
 case 5124:
  return HEAP32.subarray(pixels >> 2, pixels + bytes >> 2);
 case 5126:
  return HEAPF32.subarray(pixels >> 2, pixels + bytes >> 2);
 case 5125:
 case 34042:
 case 35902:
 case 33640:
 case 35899:
 case 34042:
  return HEAPU32.subarray(pixels >> 2, pixels + bytes >> 2);
 case 5123:
 case 33635:
 case 32819:
 case 32820:
 case 36193:
 case 5131:
  return HEAPU16.subarray(pixels >> 1, pixels + bytes >> 1);
 default:
  GL.recordError(1280);
  return null;
 }
}
Module["emscriptenWebGLGetTexPixelData"] = emscriptenWebGLGetTexPixelData;
function _emscripten_glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels) {
 var pixelData = null;
 if (pixels) pixelData = emscriptenWebGLGetTexPixelData(type, format, width, height, pixels, 0);
 GLctx.texSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixelData);
}
Module["_emscripten_glTexSubImage2D"] = _emscripten_glTexSubImage2D;
function ___syscall334(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD(), iov = SYSCALLS.get(), iovcnt = SYSCALLS.get(), offset = SYSCALLS.get();
  return SYSCALLS.doWritev(stream, iov, iovcnt, offset);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall334"] = ___syscall334;
function _emscripten_glUniform2f(location, v0, v1) {
 location = GL.uniforms[location];
 GLctx.uniform2f(location, v0, v1);
}
Module["_emscripten_glUniform2f"] = _emscripten_glUniform2f;
function ___syscall331(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return -ERRNO_CODES.ENOSYS;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall331"] = ___syscall331;
function _glGetAttribLocation(program, name) {
 program = GL.programs[program];
 name = Pointer_stringify(name);
 return GLctx.getAttribLocation(program, name);
}
Module["_glGetAttribLocation"] = _glGetAttribLocation;
function ___syscall333(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD(), iov = SYSCALLS.get(), iovcnt = SYSCALLS.get(), offset = SYSCALLS.get();
  return SYSCALLS.doReadv(stream, iov, iovcnt, offset);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall333"] = ___syscall333;
function _emscripten_glUniform2i(location, v0, v1) {
 location = GL.uniforms[location];
 GLctx.uniform2i(location, v0, v1);
}
Module["_emscripten_glUniform2i"] = _emscripten_glUniform2i;
function _JS_WebCam_IsSupported() {
 var getMedia = navigator.getUserMedia || navigator.webkitGetUserMedia || navigator.mozGetUserMedia || navigator.msGetUserMedia;
 return getMedia != null;
}
Module["_JS_WebCam_IsSupported"] = _JS_WebCam_IsSupported;
function _il2cpp_class_has_parent() {
 if (!Module["_il2cpp_class_has_parent"]) abort("external function 'il2cpp_class_has_parent' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_has_parent"].apply(null, arguments);
}
function ___cxa_pure_virtual() {
 ABORT = true;
 throw "Pure virtual function called!";
}
Module["___cxa_pure_virtual"] = ___cxa_pure_virtual;
function _emscripten_set_mousedown_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerMouseEventCallback(target, userData, useCapture, callbackfunc, 5, "mousedown");
 return 0;
}
Module["_emscripten_set_mousedown_callback"] = _emscripten_set_mousedown_callback;
function _il2cpp_field_get_name() {
 if (!Module["_il2cpp_field_get_name"]) abort("external function 'il2cpp_field_get_name' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_field_get_name"].apply(null, arguments);
}
function _emscripten_set_fullscreenchange_callback(target, userData, useCapture, callbackfunc) {
 if (typeof JSEvents.fullscreenEnabled() === "undefined") return -1;
 if (!target) target = document; else {
  target = JSEvents.findEventTarget(target);
  if (!target) return -4;
 }
 JSEvents.registerFullscreenChangeEventCallback(target, userData, useCapture, callbackfunc, 19, "fullscreenchange");
 JSEvents.registerFullscreenChangeEventCallback(target, userData, useCapture, callbackfunc, 19, "mozfullscreenchange");
 JSEvents.registerFullscreenChangeEventCallback(target, userData, useCapture, callbackfunc, 19, "webkitfullscreenchange");
 JSEvents.registerFullscreenChangeEventCallback(target, userData, useCapture, callbackfunc, 19, "msfullscreenchange");
 return 0;
}
Module["_emscripten_set_fullscreenchange_callback"] = _emscripten_set_fullscreenchange_callback;
function _glPolygonOffset(x0, x1) {
 GLctx.polygonOffset(x0, x1);
}
Module["_glPolygonOffset"] = _glPolygonOffset;
function _setgroups(ngroups, gidset) {
 if (ngroups < 1 || ngroups > _sysconf(3)) {
  ___setErrNo(ERRNO_CODES.EINVAL);
  return -1;
 } else {
  ___setErrNo(ERRNO_CODES.EPERM);
  return -1;
 }
}
Module["_setgroups"] = _setgroups;
function _JS_WebRequest_SetProgressHandler(request, arg, onprogress) {
 var http = wr.requestInstances[request];
 http.onprogress = function http_onprogress(e) {
  if (onprogress) {
   if (e.lengthComputable) Runtime.dynCall("viii", onprogress, [ arg, e.loaded, e.total ]);
  }
 };
}
Module["_JS_WebRequest_SetProgressHandler"] = _JS_WebRequest_SetProgressHandler;
function _emscripten_glBlendEquationSeparate(x0, x1) {
 GLctx.blendEquationSeparate(x0, x1);
}
Module["_emscripten_glBlendEquationSeparate"] = _emscripten_glBlendEquationSeparate;
function _emscripten_glGetShaderPrecisionFormat(shaderType, precisionType, range, precision) {
 var result = GLctx.getShaderPrecisionFormat(shaderType, precisionType);
 HEAP32[range >> 2] = result.rangeMin;
 HEAP32[range + 4 >> 2] = result.rangeMax;
 HEAP32[precision >> 2] = result.precision;
}
Module["_emscripten_glGetShaderPrecisionFormat"] = _emscripten_glGetShaderPrecisionFormat;
function _JS_WebRequest_GetStatusLine(request, buffer, bufferSize) {
 var status = wr.requestInstances[request].status + " " + wr.requestInstances[request].statusText;
 var statusTruncated = status.slice(0, Math.max(0, bufferSize));
 if (buffer) writeStringToMemory(statusTruncated, buffer, true);
 return status.length;
}
Module["_JS_WebRequest_GetStatusLine"] = _JS_WebRequest_GetStatusLine;
function _glGetShaderiv(shader, pname, p) {
 if (!p) {
  GL.recordError(1281);
  return;
 }
 if (pname == 35716) {
  var log = GLctx.getShaderInfoLog(GL.shaders[shader]);
  if (log === null) log = "(unknown error)";
  HEAP32[p >> 2] = log.length + 1;
 } else {
  HEAP32[p >> 2] = GLctx.getShaderParameter(GL.shaders[shader], pname);
 }
}
Module["_glGetShaderiv"] = _glGetShaderiv;
function _emscripten_set_wheel_callback(target, userData, useCapture, callbackfunc) {
 target = JSEvents.findEventTarget(target);
 if (typeof target.onwheel !== "undefined") {
  JSEvents.registerWheelEventCallback(target, userData, useCapture, callbackfunc, 9, "wheel");
  return 0;
 } else if (typeof target.onmousewheel !== "undefined") {
  JSEvents.registerWheelEventCallback(target, userData, useCapture, callbackfunc, 9, "mousewheel");
  return 0;
 } else {
  return -1;
 }
}
Module["_emscripten_set_wheel_callback"] = _emscripten_set_wheel_callback;
function _glDrawElementsInstanced(mode, count, type, indices, primcount) {
 GLctx["drawElementsInstanced"](mode, count, type, indices, primcount);
}
Module["_glDrawElementsInstanced"] = _glDrawElementsInstanced;
function _emscripten_glBindProgramARB() {
 if (!Module["_emscripten_glBindProgramARB"]) abort("external function 'emscripten_glBindProgramARB' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_emscripten_glBindProgramARB"].apply(null, arguments);
}
function _il2cpp_method_has_attribute() {
 if (!Module["_il2cpp_method_has_attribute"]) abort("external function 'il2cpp_method_has_attribute' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_method_has_attribute"].apply(null, arguments);
}
function _glFlush() {
 GLctx.flush();
}
Module["_glFlush"] = _glFlush;
function _emscripten_glIsFramebuffer(framebuffer) {
 var fb = GL.framebuffers[framebuffer];
 if (!fb) return 0;
 return GLctx.isFramebuffer(fb);
}
Module["_emscripten_glIsFramebuffer"] = _emscripten_glIsFramebuffer;
function ___syscall191(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var resource = SYSCALLS.get(), rlim = SYSCALLS.get();
  HEAP32[rlim >> 2] = -1;
  HEAP32[rlim + 4 >> 2] = -1;
  HEAP32[rlim + 8 >> 2] = -1;
  HEAP32[rlim + 12 >> 2] = -1;
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall191"] = ___syscall191;
function ___syscall193(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var path = SYSCALLS.getStr(), zero = SYSCALLS.getZero(), length = SYSCALLS.get64();
  FS.truncate(path, length);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall193"] = ___syscall193;
function ___syscall192(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var addr = SYSCALLS.get(), len = SYSCALLS.get(), prot = SYSCALLS.get(), flags = SYSCALLS.get(), fd = SYSCALLS.get(), off = SYSCALLS.get();
  off <<= 12;
  var ptr;
  var allocated = false;
  if (fd === -1) {
   ptr = _malloc(len);
   if (!ptr) return -ERRNO_CODES.ENOMEM;
   _memset(ptr, 0, len);
   allocated = true;
  } else {
   var info = FS.getStream(fd);
   if (!info) return -ERRNO_CODES.EBADF;
   var res = FS.mmap(info, HEAPU8, addr, len, off, prot, flags);
   ptr = res.ptr;
   allocated = res.allocated;
  }
  SYSCALLS.mappings[ptr] = {
   malloc: ptr,
   len: len,
   allocated: allocated,
   fd: fd,
   flags: flags
  };
  return ptr;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall192"] = ___syscall192;
function ___syscall195(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var path = SYSCALLS.getStr(), buf = SYSCALLS.get();
  return SYSCALLS.doStat(FS.stat, path, buf);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall195"] = ___syscall195;
function ___syscall194(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var fd = SYSCALLS.get(), zero = SYSCALLS.getZero(), length = SYSCALLS.get64();
  FS.ftruncate(fd, length);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall194"] = ___syscall194;
function ___syscall197(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD(), buf = SYSCALLS.get();
  return SYSCALLS.doStat(FS.stat, stream.path, buf);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall197"] = ___syscall197;
function ___syscall196(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var path = SYSCALLS.getStr(), buf = SYSCALLS.get();
  return SYSCALLS.doStat(FS.lstat, path, buf);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall196"] = ___syscall196;
function ___syscall199() {
 return ___syscall202.apply(null, arguments);
}
Module["___syscall199"] = ___syscall199;
function _il2cpp_class_get_methods() {
 if (!Module["_il2cpp_class_get_methods"]) abort("external function 'il2cpp_class_get_methods' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_get_methods"].apply(null, arguments);
}
Module["_llvm_ctpop_i32"] = _llvm_ctpop_i32;
function _glFenceSync(condition, flags) {
 var sync = GLctx.fenceSync(condition, flags);
 if (sync) {
  var id = GL.getNewId(GL.syncs);
  sync.name = id;
  GL.syncs[id] = sync;
  return id;
 } else {
  return 0;
 }
}
Module["_glFenceSync"] = _glFenceSync;
function _glBlendEquationSeparate(x0, x1) {
 GLctx.blendEquationSeparate(x0, x1);
}
Module["_glBlendEquationSeparate"] = _glBlendEquationSeparate;
function _il2cpp_unity_liveness_calculation_from_statics() {
 if (!Module["_il2cpp_unity_liveness_calculation_from_statics"]) abort("external function 'il2cpp_unity_liveness_calculation_from_statics' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_unity_liveness_calculation_from_statics"].apply(null, arguments);
}
function _emscripten_glGetActiveUniform(program, index, bufSize, length, size, type, name) {
 program = GL.programs[program];
 var info = GLctx.getActiveUniform(program, index);
 if (!info) return;
 var infoname = info.name.slice(0, Math.max(0, bufSize - 1));
 if (bufSize > 0 && name) {
  writeStringToMemory(infoname, name);
  if (length) HEAP32[length >> 2] = infoname.length;
 } else {
  if (length) HEAP32[length >> 2] = 0;
 }
 if (size) HEAP32[size >> 2] = info.size;
 if (type) HEAP32[type >> 2] = info.type;
}
Module["_emscripten_glGetActiveUniform"] = _emscripten_glGetActiveUniform;
function _emscripten_set_focus_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerFocusEventCallback(target, userData, useCapture, callbackfunc, 13, "focus");
 return 0;
}
Module["_emscripten_set_focus_callback"] = _emscripten_set_focus_callback;
Module["_roundf"] = _roundf;
function _JS_WebCamVideo_Stop(deviceId) {
 if (!MediaDevices[deviceId].video) {
  console.error("WebCam not initialized.");
  return;
 }
 if (--MediaDevices[deviceId].refCount == 0) {
  webcam.canvas.removeChild(MediaDevices[deviceId].video);
  MediaDevices[deviceId].video = null;
 }
}
Module["_JS_WebCamVideo_Stop"] = _JS_WebCamVideo_Stop;
function _emscripten_glGetShaderInfoLog(shader, maxLength, length, infoLog) {
 var log = GLctx.getShaderInfoLog(GL.shaders[shader]);
 if (log === null) log = "(unknown error)";
 log = log.substr(0, maxLength - 1);
 if (maxLength > 0 && infoLog) {
  writeStringToMemory(log, infoLog);
  if (length) HEAP32[length >> 2] = log.length;
 } else {
  if (length) HEAP32[length >> 2] = 0;
 }
}
Module["_emscripten_glGetShaderInfoLog"] = _emscripten_glGetShaderInfoLog;
function _emscripten_set_mouseup_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerMouseEventCallback(target, userData, useCapture, callbackfunc, 6, "mouseup");
 return 0;
}
Module["_emscripten_set_mouseup_callback"] = _emscripten_set_mouseup_callback;
function _emscripten_glStencilOpSeparate(x0, x1, x2, x3) {
 GLctx.stencilOpSeparate(x0, x1, x2, x3);
}
Module["_emscripten_glStencilOpSeparate"] = _emscripten_glStencilOpSeparate;
function _emscripten_glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data) {
 var heapView;
 if (data) {
  heapView = HEAPU8.subarray(data, data + imageSize);
 } else {
  heapView = null;
 }
 GLctx["compressedTexSubImage2D"](target, level, xoffset, yoffset, width, height, format, heapView);
}
Module["_emscripten_glCompressedTexSubImage2D"] = _emscripten_glCompressedTexSubImage2D;
function ___syscall330(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var old = SYSCALLS.getStreamFromFD(), suggestFD = SYSCALLS.get(), flags = SYSCALLS.get();
  assert(!flags);
  if (old.fd === suggestFD) return -ERRNO_CODES.EINVAL;
  return SYSCALLS.doDup(old.path, old.flags, suggestFD);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall330"] = ___syscall330;
Module["_bitshift64Ashr"] = _bitshift64Ashr;
function _il2cpp_class_get_nested_types() {
 if (!Module["_il2cpp_class_get_nested_types"]) abort("external function 'il2cpp_class_get_nested_types' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_get_nested_types"].apply(null, arguments);
}
function _glStencilFuncSeparate(x0, x1, x2, x3) {
 GLctx.stencilFuncSeparate(x0, x1, x2, x3);
}
Module["_glStencilFuncSeparate"] = _glStencilFuncSeparate;
function _glGenSamplers(n, samplers) {
 for (var i = 0; i < n; i++) {
  var sampler = GLctx["createSampler"]();
  if (!sampler) {
   GL.recordError(1282);
   while (i < n) HEAP32[samplers + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.samplers);
  sampler.name = id;
  GL.samplers[id] = sampler;
  HEAP32[samplers + i * 4 >> 2] = id;
 }
}
Module["_glGenSamplers"] = _glGenSamplers;
function _sched_get_priority_min() {
 if (!Module["_sched_get_priority_min"]) abort("external function 'sched_get_priority_min' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_sched_get_priority_min"].apply(null, arguments);
}
function _emscripten_glIsEnabled(x0) {
 return GLctx.isEnabled(x0);
}
Module["_emscripten_glIsEnabled"] = _emscripten_glIsEnabled;
function _glUniform4iv(location, count, value) {
 location = GL.uniforms[location];
 count *= 4;
 value = HEAP32.subarray(value >> 2, value + count * 4 >> 2);
 GLctx.uniform4iv(location, value);
}
Module["_glUniform4iv"] = _glUniform4iv;
function _glClearStencil(x0) {
 GLctx.clearStencil(x0);
}
Module["_glClearStencil"] = _glClearStencil;
function _il2cpp_object_get_size() {
 if (!Module["_il2cpp_object_get_size"]) abort("external function 'il2cpp_object_get_size' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_object_get_size"].apply(null, arguments);
}
Module["_llvm_bswap_i32"] = _llvm_bswap_i32;
function _llvm_bswap_i64(l, h) {
 var retl = _llvm_bswap_i32(h) >>> 0;
 var reth = _llvm_bswap_i32(l) >>> 0;
 return (Runtime.setTempRet0(reth), retl) | 0;
}
Module["_llvm_bswap_i64"] = _llvm_bswap_i64;
function _JS_Sound_SetPosition(channelInstance, x, y, z) {
 if (WEBAudio.audioWebEnabled == 0) return;
 WEBAudio.audioInstances[channelInstance].panner.setPosition(x, y, z);
}
Module["_JS_Sound_SetPosition"] = _JS_Sound_SetPosition;
function _execl() {
 ___setErrNo(ERRNO_CODES.ENOEXEC);
 return -1;
}
Module["_execl"] = _execl;
function _emscripten_glClearDepthf(x0) {
 GLctx.clearDepth(x0);
}
Module["_emscripten_glClearDepthf"] = _emscripten_glClearDepthf;
function _emscripten_glVertexAttrib4f(x0, x1, x2, x3, x4) {
 GLctx.vertexAttrib4f(x0, x1, x2, x3, x4);
}
Module["_emscripten_glVertexAttrib4f"] = _emscripten_glVertexAttrib4f;
function _pthread_cancel() {
 if (!Module["_pthread_cancel"]) abort("external function 'pthread_cancel' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_pthread_cancel"].apply(null, arguments);
}
function ___cxa_rethrow() {
 ___cxa_end_catch.rethrown = true;
 var ptr = EXCEPTIONS.caught.pop();
 EXCEPTIONS.last = ptr;
 throw ptr;
}
Module["___cxa_rethrow"] = ___cxa_rethrow;
function _il2cpp_class_is_interface() {
 if (!Module["_il2cpp_class_is_interface"]) abort("external function 'il2cpp_class_is_interface' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_is_interface"].apply(null, arguments);
}
function _emscripten_glClear(x0) {
 GLctx.clear(x0);
}
Module["_emscripten_glClear"] = _emscripten_glClear;
function _il2cpp_field_get_type() {
 if (!Module["_il2cpp_field_get_type"]) abort("external function 'il2cpp_field_get_type' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_field_get_type"].apply(null, arguments);
}
function _il2cpp_gc_disable() {
 if (!Module["_il2cpp_gc_disable"]) abort("external function 'il2cpp_gc_disable' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_gc_disable"].apply(null, arguments);
}
function _il2cpp_profiler_install_gc() {
 if (!Module["_il2cpp_profiler_install_gc"]) abort("external function 'il2cpp_profiler_install_gc' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_profiler_install_gc"].apply(null, arguments);
}
function _emscripten_get_now_is_monotonic() {
 return ENVIRONMENT_IS_NODE || typeof dateNow !== "undefined" || (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) && self["performance"] && self["performance"]["now"];
}
Module["_emscripten_get_now_is_monotonic"] = _emscripten_get_now_is_monotonic;
function _clock_gettime(clk_id, tp) {
 var now;
 if (clk_id === 0) {
  now = Date.now();
 } else if (clk_id === 1 && _emscripten_get_now_is_monotonic()) {
  now = _emscripten_get_now();
 } else {
  ___setErrNo(ERRNO_CODES.EINVAL);
  return -1;
 }
 HEAP32[tp >> 2] = now / 1e3 | 0;
 HEAP32[tp + 4 >> 2] = now % 1e3 * 1e3 * 1e3 | 0;
 return 0;
}
Module["_clock_gettime"] = _clock_gettime;
function _glDeleteRenderbuffers(n, renderbuffers) {
 for (var i = 0; i < n; i++) {
  var id = HEAP32[renderbuffers + i * 4 >> 2];
  var renderbuffer = GL.renderbuffers[id];
  if (!renderbuffer) continue;
  GLctx.deleteRenderbuffer(renderbuffer);
  renderbuffer.name = 0;
  GL.renderbuffers[id] = null;
 }
}
Module["_glDeleteRenderbuffers"] = _glDeleteRenderbuffers;
function _il2cpp_runtime_object_init_exception() {
 if (!Module["_il2cpp_runtime_object_init_exception"]) abort("external function 'il2cpp_runtime_object_init_exception' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_runtime_object_init_exception"].apply(null, arguments);
}
function _emscripten_glDeleteRenderbuffers(n, renderbuffers) {
 for (var i = 0; i < n; i++) {
  var id = HEAP32[renderbuffers + i * 4 >> 2];
  var renderbuffer = GL.renderbuffers[id];
  if (!renderbuffer) continue;
  GLctx.deleteRenderbuffer(renderbuffer);
  renderbuffer.name = 0;
  GL.renderbuffers[id] = null;
 }
}
Module["_emscripten_glDeleteRenderbuffers"] = _emscripten_glDeleteRenderbuffers;
function _glGetProgramiv(program, pname, p) {
 if (!p) {
  GL.recordError(1281);
  return;
 }
 if (pname == 35716) {
  var log = GLctx.getProgramInfoLog(GL.programs[program]);
  if (log === null) log = "(unknown error)";
  HEAP32[p >> 2] = log.length + 1;
 } else if (pname == 35719) {
  var ptable = GL.programInfos[program];
  if (ptable) {
   HEAP32[p >> 2] = ptable.maxUniformLength;
   return;
  } else if (program < GL.counter) {
   GL.recordError(1282);
  } else {
   GL.recordError(1281);
  }
 } else if (pname == 35722) {
  var ptable = GL.programInfos[program];
  if (ptable) {
   if (ptable.maxAttributeLength == -1) {
    var program = GL.programs[program];
    var numAttribs = GLctx.getProgramParameter(program, GLctx.ACTIVE_ATTRIBUTES);
    ptable.maxAttributeLength = 0;
    for (var i = 0; i < numAttribs; ++i) {
     var activeAttrib = GLctx.getActiveAttrib(program, i);
     ptable.maxAttributeLength = Math.max(ptable.maxAttributeLength, activeAttrib.name.length + 1);
    }
   }
   HEAP32[p >> 2] = ptable.maxAttributeLength;
   return;
  } else if (program < GL.counter) {
   GL.recordError(1282);
  } else {
   GL.recordError(1281);
  }
 } else {
  HEAP32[p >> 2] = GLctx.getProgramParameter(GL.programs[program], pname);
 }
}
Module["_glGetProgramiv"] = _glGetProgramiv;
function _glVertexAttribPointer(index, size, type, normalized, stride, ptr) {
 GLctx.vertexAttribPointer(index, size, type, normalized, stride, ptr);
}
Module["_glVertexAttribPointer"] = _glVertexAttribPointer;
function _pthread_cond_signal() {
 return 0;
}
Module["_pthread_cond_signal"] = _pthread_cond_signal;
function _glFramebufferTextureLayer(target, attachment, texture, level, layer) {
 GLctx.framebufferTextureLayer(target, attachment, GL.textures[texture], level, layer);
}
Module["_glFramebufferTextureLayer"] = _glFramebufferTextureLayer;
function _emscripten_glGetAttachedShaders(program, maxCount, count, shaders) {
 var result = GLctx.getAttachedShaders(GL.programs[program]);
 var len = result.length;
 if (len > maxCount) {
  len = maxCount;
 }
 HEAP32[count >> 2] = len;
 for (var i = 0; i < len; ++i) {
  var id = GL.shaders.indexOf(result[i]);
  assert(id !== -1, "shader not bound to local id");
  HEAP32[shaders + i * 4 >> 2] = id;
 }
}
Module["_emscripten_glGetAttachedShaders"] = _emscripten_glGetAttachedShaders;
function _flock(fd, operation) {
 return 0;
}
Module["_flock"] = _flock;
function _emscripten_glFrontFace(x0) {
 GLctx.frontFace(x0);
}
Module["_emscripten_glFrontFace"] = _emscripten_glFrontFace;
function _glFlushMappedBufferRange() {
 if (!Module["_glFlushMappedBufferRange"]) abort("external function 'glFlushMappedBufferRange' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_glFlushMappedBufferRange"].apply(null, arguments);
}
function _glTexStorage2D(x0, x1, x2, x3, x4) {
 GLctx.texStorage2D(x0, x1, x2, x3, x4);
}
Module["_glTexStorage2D"] = _glTexStorage2D;
function _il2cpp_gchandle_free() {
 if (!Module["_il2cpp_gchandle_free"]) abort("external function 'il2cpp_gchandle_free' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_gchandle_free"].apply(null, arguments);
}
function ___syscall207(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var fd = SYSCALLS.get(), owner = SYSCALLS.get(), group = SYSCALLS.get();
  FS.fchown(fd, owner, group);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall207"] = ___syscall207;
function _il2cpp_profiler_set_events() {
 if (!Module["_il2cpp_profiler_set_events"]) abort("external function 'il2cpp_profiler_set_events' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_profiler_set_events"].apply(null, arguments);
}
function _pthread_key_delete(key) {
 if (key in PTHREAD_SPECIFIC) {
  delete PTHREAD_SPECIFIC[key];
  return 0;
 }
 return ERRNO_CODES.EINVAL;
}
Module["_pthread_key_delete"] = _pthread_key_delete;
function _il2cpp_domain_assembly_open() {
 if (!Module["_il2cpp_domain_assembly_open"]) abort("external function 'il2cpp_domain_assembly_open' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_domain_assembly_open"].apply(null, arguments);
}
function ___syscall272(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall272"] = ___syscall272;
function _glGenQueries(n, ids) {
 for (var i = 0; i < n; i++) {
  var query = GLctx["createQuery"]();
  if (!query) {
   GL.recordError(1282);
   while (i < n) HEAP32[ids + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.queries);
  query.name = id;
  GL.queries[id] = query;
  HEAP32[ids + i * 4 >> 2] = id;
 }
}
Module["_glGenQueries"] = _glGenQueries;
function ___syscall201() {
 return ___syscall202.apply(null, arguments);
}
Module["___syscall201"] = ___syscall201;
function _pthread_attr_setstacksize() {
 if (!Module["_pthread_attr_setstacksize"]) abort("external function 'pthread_attr_setstacksize' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_pthread_attr_setstacksize"].apply(null, arguments);
}
function _pthread_setcancelstate() {
 return 0;
}
Module["_pthread_setcancelstate"] = _pthread_setcancelstate;
function _gethostbyname(name) {
 name = Pointer_stringify(name);
 var ret = _malloc(20);
 var nameBuf = _malloc(name.length + 1);
 writeStringToMemory(name, nameBuf);
 HEAP32[ret >> 2] = nameBuf;
 var aliasesBuf = _malloc(4);
 HEAP32[aliasesBuf >> 2] = 0;
 HEAP32[ret + 4 >> 2] = aliasesBuf;
 var afinet = 2;
 HEAP32[ret + 8 >> 2] = afinet;
 HEAP32[ret + 12 >> 2] = 4;
 var addrListBuf = _malloc(12);
 HEAP32[addrListBuf >> 2] = addrListBuf + 8;
 HEAP32[addrListBuf + 4 >> 2] = 0;
 HEAP32[addrListBuf + 8 >> 2] = __inet_pton4_raw(DNS.lookup_name(name));
 HEAP32[ret + 16 >> 2] = addrListBuf;
 return ret;
}
Module["_gethostbyname"] = _gethostbyname;
function _gethostbyaddr(addr, addrlen, type) {
 if (type !== 2) {
  ___setErrNo(ERRNO_CODES.EAFNOSUPPORT);
  return null;
 }
 addr = HEAP32[addr >> 2];
 var host = __inet_ntop4_raw(addr);
 var lookup = DNS.lookup_addr(host);
 if (lookup) {
  host = lookup;
 }
 var hostp = allocate(intArrayFromString(host), "i8", ALLOC_STACK);
 return _gethostbyname(hostp);
}
Module["_gethostbyaddr"] = _gethostbyaddr;
function _emscripten_glRenderbufferStorage(x0, x1, x2, x3) {
 GLctx.renderbufferStorage(x0, x1, x2, x3);
}
Module["_emscripten_glRenderbufferStorage"] = _emscripten_glRenderbufferStorage;
function _il2cpp_array_element_size() {
 if (!Module["_il2cpp_array_element_size"]) abort("external function 'il2cpp_array_element_size' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_array_element_size"].apply(null, arguments);
}
function _glTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data) {
 GLctx["texSubImage3D"](target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, HEAPU8.subarray(data));
}
Module["_glTexSubImage3D"] = _glTexSubImage3D;
function ___syscall15(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var path = SYSCALLS.getStr(), mode = SYSCALLS.get();
  FS.chmod(path, mode);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall15"] = ___syscall15;
function ___syscall14(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var path = SYSCALLS.getStr(), mode = SYSCALLS.get(), dev = SYSCALLS.get();
  return SYSCALLS.doMknod(path, mode, dev);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall14"] = ___syscall14;
function _glDeleteSamplers(n, samplers) {
 for (var i = 0; i < n; i++) {
  var id = HEAP32[samplers + i * 4 >> 2];
  var sampler = GL.samplers[id];
  if (!sampler) continue;
  GLctx["deleteSampler"](sampler);
  sampler.name = 0;
  GL.samplers[id] = null;
 }
}
Module["_glDeleteSamplers"] = _glDeleteSamplers;
function ___syscall10(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var path = SYSCALLS.getStr();
  FS.unlink(path);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall10"] = ___syscall10;
function ___syscall12(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var path = SYSCALLS.getStr();
  FS.chdir(path);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall12"] = ___syscall12;
function _glBlitFramebuffer(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9) {
 GLctx.blitFramebuffer(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
Module["_glBlitFramebuffer"] = _glBlitFramebuffer;
function _il2cpp_runtime_object_init() {
 if (!Module["_il2cpp_runtime_object_init"]) abort("external function 'il2cpp_runtime_object_init' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_runtime_object_init"].apply(null, arguments);
}
function ___syscall340(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var pid = SYSCALLS.get(), resource = SYSCALLS.get(), new_limit = SYSCALLS.get(), old_limit = SYSCALLS.get();
  if (old_limit) {
   HEAP32[old_limit >> 2] = -1;
   HEAP32[old_limit + 4 >> 2] = -1;
   HEAP32[old_limit + 8 >> 2] = -1;
   HEAP32[old_limit + 12 >> 2] = -1;
  }
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall340"] = ___syscall340;
function _emscripten_glIsProgram(program) {
 var program = GL.programs[program];
 if (!program) return 0;
 return GLctx.isProgram(program);
}
Module["_emscripten_glIsProgram"] = _emscripten_glIsProgram;
function __ZSt18uncaught_exceptionv() {
 return !!__ZSt18uncaught_exceptionv.uncaught_exception;
}
Module["__ZSt18uncaught_exceptionv"] = __ZSt18uncaught_exceptionv;
function ___cxa_begin_catch(ptr) {
 var info = EXCEPTIONS.infos[ptr];
 if (info && !info.caught) {
  info.caught = true;
  __ZSt18uncaught_exceptionv.uncaught_exception--;
 }
 EXCEPTIONS.caught.push(ptr);
 EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));
 return ptr;
}
Module["___cxa_begin_catch"] = ___cxa_begin_catch;
function _JS_WebRequest_Create(url, method) {
 var http = new XMLHttpRequest;
 var _url = Pointer_stringify(url);
 var _method = Pointer_stringify(method);
 http.open(_method, _url, true);
 http.responseType = "arraybuffer";
 wr.requestInstances[wr.nextRequestId] = http;
 return wr.nextRequestId++;
}
Module["_JS_WebRequest_Create"] = _JS_WebRequest_Create;
function _JS_Sound_SetLoopPoints(channelInstance, loopStart, loopEnd) {
 if (WEBAudio.audioWebEnabled == 0) return;
 var channel = WEBAudio.audioInstances[channelInstance];
 channel.source.loopStart = loopStart;
 channel.source.loopEnd = loopEnd;
}
Module["_JS_Sound_SetLoopPoints"] = _JS_Sound_SetLoopPoints;
function _emscripten_glGetShaderiv(shader, pname, p) {
 if (!p) {
  GL.recordError(1281);
  return;
 }
 if (pname == 35716) {
  var log = GLctx.getShaderInfoLog(GL.shaders[shader]);
  if (log === null) log = "(unknown error)";
  HEAP32[p >> 2] = log.length + 1;
 } else {
  HEAP32[p >> 2] = GLctx.getShaderParameter(GL.shaders[shader], pname);
 }
}
Module["_emscripten_glGetShaderiv"] = _emscripten_glGetShaderiv;
function _emscripten_glUniformMatrix3fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (9 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[9 * count - 1];
  for (var i = 0; i < 9 * count; i += 9) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
   view[i + 4] = HEAPF32[value + (4 * i + 16) >> 2];
   view[i + 5] = HEAPF32[value + (4 * i + 20) >> 2];
   view[i + 6] = HEAPF32[value + (4 * i + 24) >> 2];
   view[i + 7] = HEAPF32[value + (4 * i + 28) >> 2];
   view[i + 8] = HEAPF32[value + (4 * i + 32) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 36 >> 2);
 }
 GLctx.uniformMatrix3fv(location, transpose, view);
}
Module["_emscripten_glUniformMatrix3fv"] = _emscripten_glUniformMatrix3fv;
function _JS_SystemInfo_GetCurrentCanvasWidth() {
 return Module["canvas"].clientWidth;
}
Module["_JS_SystemInfo_GetCurrentCanvasWidth"] = _JS_SystemInfo_GetCurrentCanvasWidth;
function ___syscall211(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var ruid = SYSCALLS.get(), euid = SYSCALLS.get(), suid = SYSCALLS.get();
  HEAP32[ruid >> 2] = 0;
  HEAP32[euid >> 2] = 0;
  HEAP32[suid >> 2] = 0;
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall211"] = ___syscall211;
function ___syscall209() {
 return ___syscall211.apply(null, arguments);
}
Module["___syscall209"] = ___syscall209;
function _il2cpp_array_length() {
 if (!Module["_il2cpp_array_length"]) abort("external function 'il2cpp_array_length' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_array_length"].apply(null, arguments);
}
function _emscripten_glGenFramebuffers(n, ids) {
 for (var i = 0; i < n; ++i) {
  var framebuffer = GLctx.createFramebuffer();
  if (!framebuffer) {
   GL.recordError(1282);
   while (i < n) HEAP32[ids + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.framebuffers);
  framebuffer.name = id;
  GL.framebuffers[id] = framebuffer;
  HEAP32[ids + i * 4 >> 2] = id;
 }
}
Module["_emscripten_glGenFramebuffers"] = _emscripten_glGenFramebuffers;
function _JS_Sound_Play(bufferInstance, channelInstance, offset, delay) {
 _JS_Sound_Stop(channelInstance, 0);
 if (WEBAudio.audioWebEnabled == 0) return;
 var sound = WEBAudio.audioInstances[bufferInstance];
 var channel = WEBAudio.audioInstances[channelInstance];
 if (sound.buffer) channel.playBuffer(WEBAudio.audioContext.currentTime + delay, sound.buffer, offset); else console.log("Trying to play sound which is not loaded.");
}
Module["_JS_Sound_Play"] = _JS_Sound_Play;
function ___syscall308(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return -ERRNO_CODES.ENOSYS;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall308"] = ___syscall308;
function ___syscall304(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var target = SYSCALLS.get(), newdirfd = SYSCALLS.get(), linkpath = SYSCALLS.get();
  linkpath = SYSCALLS.calculateAt(newdirfd, linkpath);
  FS.symlink(target, linkpath);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall304"] = ___syscall304;
function _il2cpp_gc_collect_a_little() {
 if (!Module["_il2cpp_gc_collect_a_little"]) abort("external function 'il2cpp_gc_collect_a_little' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_gc_collect_a_little"].apply(null, arguments);
}
function ___syscall306(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var dirfd = SYSCALLS.get(), path = SYSCALLS.getStr(), mode = SYSCALLS.get(), flags = SYSCALLS.get();
  assert(flags === 0);
  path = SYSCALLS.calculateAt(dirfd, path);
  FS.chmod(path, mode);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall306"] = ___syscall306;
function ___syscall307(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var dirfd = SYSCALLS.get(), path = SYSCALLS.getStr(), amode = SYSCALLS.get(), flags = SYSCALLS.get();
  assert(flags === 0);
  path = SYSCALLS.calculateAt(dirfd, path);
  return SYSCALLS.doAccess(path, amode);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall307"] = ___syscall307;
function ___syscall300(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var dirfd = SYSCALLS.get(), path = SYSCALLS.getStr(), buf = SYSCALLS.get(), flags = SYSCALLS.get();
  var nofollow = flags & 256;
  flags = flags & ~256;
  assert(!flags, flags);
  path = SYSCALLS.calculateAt(dirfd, path);
  return SYSCALLS.doStat(nofollow ? FS.lstat : FS.stat, path, buf);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall300"] = ___syscall300;
function ___syscall301(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var dirfd = SYSCALLS.get(), path = SYSCALLS.getStr(), flags = SYSCALLS.get();
  assert(flags === 0);
  path = SYSCALLS.calculateAt(dirfd, path);
  FS.unlink(path);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall301"] = ___syscall301;
function ___syscall302(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var olddirfd = SYSCALLS.get(), oldpath = SYSCALLS.getStr(), newdirfd = SYSCALLS.get(), newpath = SYSCALLS.getStr();
  oldpath = SYSCALLS.calculateAt(olddirfd, oldpath);
  newpath = SYSCALLS.calculateAt(newdirfd, newpath);
  FS.rename(oldpath, newpath);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall302"] = ___syscall302;
function ___syscall303(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return -ERRNO_CODES.EMLINK;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall303"] = ___syscall303;
function _emscripten_glDrawElements(mode, count, type, indices) {
 GLctx.drawElements(mode, count, type, indices);
}
Module["_emscripten_glDrawElements"] = _emscripten_glDrawElements;
function _emscripten_glDrawRangeElements(mode, start, end, count, type, indices) {
 _emscripten_glDrawElements(mode, count, type, indices);
 GLctx.drawElements(mode, count, type, indices);
}
Module["_emscripten_glDrawRangeElements"] = _emscripten_glDrawRangeElements;
function _glInvalidateFramebuffer(target, numAttachments, attachments) {
 var list = [];
 for (var i = 0; i < numAttachments; i++) list.push(HEAP32[attachments + i * 4 >> 2]);
 GLctx["invalidateFramebuffer"](target, list);
}
Module["_glInvalidateFramebuffer"] = _glInvalidateFramebuffer;
function _emscripten_glGenTextures(n, textures) {
 for (var i = 0; i < n; i++) {
  var texture = GLctx.createTexture();
  if (!texture) {
   GL.recordError(1282);
   while (i < n) HEAP32[textures + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.textures);
  texture.name = id;
  GL.textures[id] = texture;
  HEAP32[textures + i * 4 >> 2] = id;
 }
}
Module["_emscripten_glGenTextures"] = _emscripten_glGenTextures;
function _emscripten_glReleaseShaderCompiler() {}
Module["_emscripten_glReleaseShaderCompiler"] = _emscripten_glReleaseShaderCompiler;
function ___syscall29(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return -ERRNO_CODES.EINTR;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall29"] = ___syscall29;
function _pthread_join() {}
Module["_pthread_join"] = _pthread_join;
function _JS_Sound_ReleaseInstance(instance) {
 WEBAudio.audioInstances[instance] = null;
}
Module["_JS_Sound_ReleaseInstance"] = _JS_Sound_ReleaseInstance;
function _il2cpp_type_get_object() {
 if (!Module["_il2cpp_type_get_object"]) abort("external function 'il2cpp_type_get_object' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_type_get_object"].apply(null, arguments);
}
var __currentFullscreenStrategy = {};
Module["__currentFullscreenStrategy"] = __currentFullscreenStrategy;
function _emscripten_exit_fullscreen() {
 if (typeof JSEvents.fullscreenEnabled() === "undefined") return -1;
 JSEvents.removeDeferredCalls(JSEvents.requestFullscreen);
 if (document.exitFullscreen) {
  document.exitFullscreen();
 } else if (document.msExitFullscreen) {
  document.msExitFullscreen();
 } else if (document.mozCancelFullScreen) {
  document.mozCancelFullScreen();
 } else if (document.webkitExitFullscreen) {
  document.webkitExitFullscreen();
 } else {
  return -1;
 }
 if (__currentFullscreenStrategy.canvasResizedCallback) {
  Runtime.dynCall("iiii", __currentFullscreenStrategy.canvasResizedCallback, [ 37, 0, __currentFullscreenStrategy.canvasResizedCallbackUserData ]);
 }
 return 0;
}
Module["_emscripten_exit_fullscreen"] = _emscripten_exit_fullscreen;
function _emscripten_glDrawArrays(mode, first, count) {
 GLctx.drawArrays(mode, first, count);
}
Module["_emscripten_glDrawArrays"] = _emscripten_glDrawArrays;
function _setgrent() {
 if (!Module["_setgrent"]) abort("external function 'setgrent' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_setgrent"].apply(null, arguments);
}
function ___syscall205(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var size = SYSCALLS.get(), list = SYSCALLS.get();
  if (size < 1) return -ERRNO_CODES.EINVAL;
  HEAP32[list >> 2] = 0;
  return 1;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall205"] = ___syscall205;
function _JS_FileSystem_SetSyncInterval(ms) {
 if (!Module.indexedDB) return;
 fs.syncIntervalID = window.setInterval((function() {
  fs.sync(true);
 }), ms);
}
Module["_JS_FileSystem_SetSyncInterval"] = _JS_FileSystem_SetSyncInterval;
function ___syscall20(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return PROCINFO.pid;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall20"] = ___syscall20;
function _emscripten_glGetUniformLocation(program, name) {
 name = Pointer_stringify(name);
 var arrayOffset = 0;
 if (name.indexOf("]", name.length - 1) !== -1) {
  var ls = name.lastIndexOf("[");
  var arrayIndex = name.slice(ls + 1, -1);
  if (arrayIndex.length > 0) {
   arrayOffset = parseInt(arrayIndex);
   if (arrayOffset < 0) {
    return -1;
   }
  }
  name = name.slice(0, ls);
 }
 var ptable = GL.programInfos[program];
 if (!ptable) {
  return -1;
 }
 var utable = ptable.uniforms;
 var uniformInfo = utable[name];
 if (uniformInfo && arrayOffset < uniformInfo[0]) {
  return uniformInfo[1] + arrayOffset;
 } else {
  return -1;
 }
}
Module["_emscripten_glGetUniformLocation"] = _emscripten_glGetUniformLocation;
function _glUniform3fv(location, count, value) {
 location = GL.uniforms[location];
 var view;
 if (3 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[3 * count - 1];
  for (var i = 0; i < 3 * count; i += 3) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 12 >> 2);
 }
 GLctx.uniform3fv(location, view);
}
Module["_glUniform3fv"] = _glUniform3fv;
function _glBeginQuery(target, id) {
 GLctx["beginQuery"](target, id ? GL.queries[id] : null);
}
Module["_glBeginQuery"] = _glBeginQuery;
function _emscripten_glVertexAttrib4fv(index, v) {
 var view = GL.miniTempBufferViews[3];
 view[0] = HEAPF32[v >> 2];
 view[1] = HEAPF32[v + 4 >> 2];
 view[2] = HEAPF32[v + 8 >> 2];
 view[3] = HEAPF32[v + 12 >> 2];
 GLctx.vertexAttrib4fv(index, view);
}
Module["_emscripten_glVertexAttrib4fv"] = _emscripten_glVertexAttrib4fv;
function _il2cpp_free() {
 if (!Module["_il2cpp_free"]) abort("external function 'il2cpp_free' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_free"].apply(null, arguments);
}
function _emscripten_glScissor(x0, x1, x2, x3) {
 GLctx.scissor(x0, x1, x2, x3);
}
Module["_emscripten_glScissor"] = _emscripten_glScissor;
Module["_bitshift64Lshr"] = _bitshift64Lshr;
function _JS_Sound_Set3D(channelInstance, threeD) {
 var channel = WEBAudio.audioInstances[channelInstance];
 if (channel.threeD != threeD) {
  channel.threeD = threeD;
  channel.setupPanning();
 }
}
Module["_JS_Sound_Set3D"] = _JS_Sound_Set3D;
function _glBindBuffer(target, buffer) {
 var bufferObj = buffer ? GL.buffers[buffer] : null;
 GLctx.bindBuffer(target, bufferObj);
}
Module["_glBindBuffer"] = _glBindBuffer;
function _JS_SystemInfo_GetDocumentURL(buffer, bufferSize) {
 var result = document.URL;
 result = result.slice(0, Math.max(0, bufferSize));
 if (buffer) writeStringToMemory(result, buffer, true);
 return document.URL.length;
}
Module["_JS_SystemInfo_GetDocumentURL"] = _JS_SystemInfo_GetDocumentURL;
function _emscripten_glLinkProgram(program) {
 GLctx.linkProgram(GL.programs[program]);
 GL.programInfos[program] = null;
 GL.populateUniformTable(program);
}
Module["_emscripten_glLinkProgram"] = _emscripten_glLinkProgram;
function _JS_Sound_GetLength(bufferInstance) {
 if (WEBAudio.audioWebEnabled == 0) return 0;
 var sound = WEBAudio.audioInstances[bufferInstance];
 var sampleRateRatio = 44100 / sound.buffer.sampleRate;
 return sound.buffer.length * sampleRateRatio;
}
Module["_JS_Sound_GetLength"] = _JS_Sound_GetLength;
function ___syscall153(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall153"] = ___syscall153;
function ___syscall152() {
 return ___syscall153.apply(null, arguments);
}
Module["___syscall152"] = ___syscall152;
function _glDeleteSync(id) {
 if (!id) return;
 var sync = GL.syncs[id];
 if (!sync) {
  GL.recordError(1281);
  return;
 }
 GLctx.deleteSync(sync);
 sync.name = 0;
 GL.syncs[id] = null;
}
Module["_glDeleteSync"] = _glDeleteSync;
function _realloc() {
 throw "bad";
}
Module["_realloc"] = _realloc;
Module["_saveSetjmp"] = _saveSetjmp;
Module["_testSetjmp"] = _testSetjmp;
function _longjmp(env, value) {
 asm["setThrew"](env, value || 1);
 throw "longjmp";
}
Module["_longjmp"] = _longjmp;
function _emscripten_longjmp(env, value) {
 _longjmp(env, value);
}
Module["_emscripten_longjmp"] = _emscripten_longjmp;
function _llvm_fma_f64() {
 if (!Module["_llvm_fma_f64"]) abort("external function 'llvm_fma_f64' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_llvm_fma_f64"].apply(null, arguments);
}
function __isLeapYear(year) {
 return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
}
Module["__isLeapYear"] = __isLeapYear;
function __arraySum(array, index) {
 var sum = 0;
 for (var i = 0; i <= index; sum += array[i++]) ;
 return sum;
}
Module["__arraySum"] = __arraySum;
var __MONTH_DAYS_LEAP = [ 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 ];
Module["__MONTH_DAYS_LEAP"] = __MONTH_DAYS_LEAP;
var __MONTH_DAYS_REGULAR = [ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 ];
Module["__MONTH_DAYS_REGULAR"] = __MONTH_DAYS_REGULAR;
function __addDays(date, days) {
 var newDate = new Date(date.getTime());
 while (days > 0) {
  var leap = __isLeapYear(newDate.getFullYear());
  var currentMonth = newDate.getMonth();
  var daysInCurrentMonth = (leap ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR)[currentMonth];
  if (days > daysInCurrentMonth - newDate.getDate()) {
   days -= daysInCurrentMonth - newDate.getDate() + 1;
   newDate.setDate(1);
   if (currentMonth < 11) {
    newDate.setMonth(currentMonth + 1);
   } else {
    newDate.setMonth(0);
    newDate.setFullYear(newDate.getFullYear() + 1);
   }
  } else {
   newDate.setDate(newDate.getDate() + days);
   return newDate;
  }
 }
 return newDate;
}
Module["__addDays"] = __addDays;
function _strftime(s, maxsize, format, tm) {
 var tm_zone = HEAP32[tm + 40 >> 2];
 var date = {
  tm_sec: HEAP32[tm >> 2],
  tm_min: HEAP32[tm + 4 >> 2],
  tm_hour: HEAP32[tm + 8 >> 2],
  tm_mday: HEAP32[tm + 12 >> 2],
  tm_mon: HEAP32[tm + 16 >> 2],
  tm_year: HEAP32[tm + 20 >> 2],
  tm_wday: HEAP32[tm + 24 >> 2],
  tm_yday: HEAP32[tm + 28 >> 2],
  tm_isdst: HEAP32[tm + 32 >> 2],
  tm_gmtoff: HEAP32[tm + 36 >> 2],
  tm_zone: tm_zone ? Pointer_stringify(tm_zone) : ""
 };
 var pattern = Pointer_stringify(format);
 var EXPANSION_RULES_1 = {
  "%c": "%a %b %d %H:%M:%S %Y",
  "%D": "%m/%d/%y",
  "%F": "%Y-%m-%d",
  "%h": "%b",
  "%r": "%I:%M:%S %p",
  "%R": "%H:%M",
  "%T": "%H:%M:%S",
  "%x": "%m/%d/%y",
  "%X": "%H:%M:%S"
 };
 for (var rule in EXPANSION_RULES_1) {
  pattern = pattern.replace(new RegExp(rule, "g"), EXPANSION_RULES_1[rule]);
 }
 var WEEKDAYS = [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ];
 var MONTHS = [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ];
 function leadingSomething(value, digits, character) {
  var str = typeof value === "number" ? value.toString() : value || "";
  while (str.length < digits) {
   str = character[0] + str;
  }
  return str;
 }
 function leadingNulls(value, digits) {
  return leadingSomething(value, digits, "0");
 }
 function compareByDay(date1, date2) {
  function sgn(value) {
   return value < 0 ? -1 : value > 0 ? 1 : 0;
  }
  var compare;
  if ((compare = sgn(date1.getFullYear() - date2.getFullYear())) === 0) {
   if ((compare = sgn(date1.getMonth() - date2.getMonth())) === 0) {
    compare = sgn(date1.getDate() - date2.getDate());
   }
  }
  return compare;
 }
 function getFirstWeekStartDate(janFourth) {
  switch (janFourth.getDay()) {
  case 0:
   return new Date(janFourth.getFullYear() - 1, 11, 29);
  case 1:
   return janFourth;
  case 2:
   return new Date(janFourth.getFullYear(), 0, 3);
  case 3:
   return new Date(janFourth.getFullYear(), 0, 2);
  case 4:
   return new Date(janFourth.getFullYear(), 0, 1);
  case 5:
   return new Date(janFourth.getFullYear() - 1, 11, 31);
  case 6:
   return new Date(janFourth.getFullYear() - 1, 11, 30);
  }
 }
 function getWeekBasedYear(date) {
  var thisDate = __addDays(new Date(date.tm_year + 1900, 0, 1), date.tm_yday);
  var janFourthThisYear = new Date(thisDate.getFullYear(), 0, 4);
  var janFourthNextYear = new Date(thisDate.getFullYear() + 1, 0, 4);
  var firstWeekStartThisYear = getFirstWeekStartDate(janFourthThisYear);
  var firstWeekStartNextYear = getFirstWeekStartDate(janFourthNextYear);
  if (compareByDay(firstWeekStartThisYear, thisDate) <= 0) {
   if (compareByDay(firstWeekStartNextYear, thisDate) <= 0) {
    return thisDate.getFullYear() + 1;
   } else {
    return thisDate.getFullYear();
   }
  } else {
   return thisDate.getFullYear() - 1;
  }
 }
 var EXPANSION_RULES_2 = {
  "%a": (function(date) {
   return WEEKDAYS[date.tm_wday].substring(0, 3);
  }),
  "%A": (function(date) {
   return WEEKDAYS[date.tm_wday];
  }),
  "%b": (function(date) {
   return MONTHS[date.tm_mon].substring(0, 3);
  }),
  "%B": (function(date) {
   return MONTHS[date.tm_mon];
  }),
  "%C": (function(date) {
   var year = date.tm_year + 1900;
   return leadingNulls(year / 100 | 0, 2);
  }),
  "%d": (function(date) {
   return leadingNulls(date.tm_mday, 2);
  }),
  "%e": (function(date) {
   return leadingSomething(date.tm_mday, 2, " ");
  }),
  "%g": (function(date) {
   return getWeekBasedYear(date).toString().substring(2);
  }),
  "%G": (function(date) {
   return getWeekBasedYear(date);
  }),
  "%H": (function(date) {
   return leadingNulls(date.tm_hour, 2);
  }),
  "%I": (function(date) {
   var twelveHour = date.tm_hour;
   if (twelveHour == 0) twelveHour = 12; else if (twelveHour > 12) twelveHour -= 12;
   return leadingNulls(twelveHour, 2);
  }),
  "%j": (function(date) {
   return leadingNulls(date.tm_mday + __arraySum(__isLeapYear(date.tm_year + 1900) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, date.tm_mon - 1), 3);
  }),
  "%m": (function(date) {
   return leadingNulls(date.tm_mon + 1, 2);
  }),
  "%M": (function(date) {
   return leadingNulls(date.tm_min, 2);
  }),
  "%n": (function() {
   return "\n";
  }),
  "%p": (function(date) {
   if (date.tm_hour >= 0 && date.tm_hour < 12) {
    return "AM";
   } else {
    return "PM";
   }
  }),
  "%S": (function(date) {
   return leadingNulls(date.tm_sec, 2);
  }),
  "%t": (function() {
   return "\t";
  }),
  "%u": (function(date) {
   var day = new Date(date.tm_year + 1900, date.tm_mon + 1, date.tm_mday, 0, 0, 0, 0);
   return day.getDay() || 7;
  }),
  "%U": (function(date) {
   var janFirst = new Date(date.tm_year + 1900, 0, 1);
   var firstSunday = janFirst.getDay() === 0 ? janFirst : __addDays(janFirst, 7 - janFirst.getDay());
   var endDate = new Date(date.tm_year + 1900, date.tm_mon, date.tm_mday);
   if (compareByDay(firstSunday, endDate) < 0) {
    var februaryFirstUntilEndMonth = __arraySum(__isLeapYear(endDate.getFullYear()) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, endDate.getMonth() - 1) - 31;
    var firstSundayUntilEndJanuary = 31 - firstSunday.getDate();
    var days = firstSundayUntilEndJanuary + februaryFirstUntilEndMonth + endDate.getDate();
    return leadingNulls(Math.ceil(days / 7), 2);
   }
   return compareByDay(firstSunday, janFirst) === 0 ? "01" : "00";
  }),
  "%V": (function(date) {
   var janFourthThisYear = new Date(date.tm_year + 1900, 0, 4);
   var janFourthNextYear = new Date(date.tm_year + 1901, 0, 4);
   var firstWeekStartThisYear = getFirstWeekStartDate(janFourthThisYear);
   var firstWeekStartNextYear = getFirstWeekStartDate(janFourthNextYear);
   var endDate = __addDays(new Date(date.tm_year + 1900, 0, 1), date.tm_yday);
   if (compareByDay(endDate, firstWeekStartThisYear) < 0) {
    return "53";
   }
   if (compareByDay(firstWeekStartNextYear, endDate) <= 0) {
    return "01";
   }
   var daysDifference;
   if (firstWeekStartThisYear.getFullYear() < date.tm_year + 1900) {
    daysDifference = date.tm_yday + 32 - firstWeekStartThisYear.getDate();
   } else {
    daysDifference = date.tm_yday + 1 - firstWeekStartThisYear.getDate();
   }
   return leadingNulls(Math.ceil(daysDifference / 7), 2);
  }),
  "%w": (function(date) {
   var day = new Date(date.tm_year + 1900, date.tm_mon + 1, date.tm_mday, 0, 0, 0, 0);
   return day.getDay();
  }),
  "%W": (function(date) {
   var janFirst = new Date(date.tm_year, 0, 1);
   var firstMonday = janFirst.getDay() === 1 ? janFirst : __addDays(janFirst, janFirst.getDay() === 0 ? 1 : 7 - janFirst.getDay() + 1);
   var endDate = new Date(date.tm_year + 1900, date.tm_mon, date.tm_mday);
   if (compareByDay(firstMonday, endDate) < 0) {
    var februaryFirstUntilEndMonth = __arraySum(__isLeapYear(endDate.getFullYear()) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, endDate.getMonth() - 1) - 31;
    var firstMondayUntilEndJanuary = 31 - firstMonday.getDate();
    var days = firstMondayUntilEndJanuary + februaryFirstUntilEndMonth + endDate.getDate();
    return leadingNulls(Math.ceil(days / 7), 2);
   }
   return compareByDay(firstMonday, janFirst) === 0 ? "01" : "00";
  }),
  "%y": (function(date) {
   return (date.tm_year + 1900).toString().substring(2);
  }),
  "%Y": (function(date) {
   return date.tm_year + 1900;
  }),
  "%z": (function(date) {
   var off = date.tm_gmtoff;
   var ahead = off >= 0;
   off = Math.abs(off) / 60;
   off = off / 60 * 100 + off % 60;
   return (ahead ? "+" : "-") + String("0000" + off).slice(-4);
  }),
  "%Z": (function(date) {
   return date.tm_zone;
  }),
  "%%": (function() {
   return "%";
  })
 };
 for (var rule in EXPANSION_RULES_2) {
  if (pattern.indexOf(rule) >= 0) {
   pattern = pattern.replace(new RegExp(rule, "g"), EXPANSION_RULES_2[rule](date));
  }
 }
 var bytes = intArrayFromString(pattern, false);
 if (bytes.length > maxsize) {
  return 0;
 }
 writeArrayToMemory(bytes, s);
 return bytes.length - 1;
}
Module["_strftime"] = _strftime;
function _strftime_l(s, maxsize, format, tm) {
 return _strftime(s, maxsize, format, tm);
}
Module["_strftime_l"] = _strftime_l;
function _glGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, length, uniformBlockName) {
 program = GL.programs[program];
 var result = GLctx["getActiveUniformBlockName"](program, uniformBlockIndex);
 if (!result) return;
 var name = result.slice(0, Math.max(0, bufSize - 1));
 if (uniformBlockName && bufSize > 0) {
  writeStringToMemory(name, uniformBlockName);
  if (length) HEAP32[length >> 2] = name.length;
 } else {
  if (length) HEAP32[length >> 2] = 0;
 }
}
Module["_glGetActiveUniformBlockName"] = _glGetActiveUniformBlockName;
function emscriptenWebGLGetVertexAttrib(index, pname, params, type) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 var data = GLctx.getVertexAttrib(index, pname);
 if (typeof data == "number" || typeof data == "boolean") {
  switch (type) {
  case "Integer":
   HEAP32[params >> 2] = data;
   break;
  case "Float":
   HEAPF32[params >> 2] = data;
   break;
  case "FloatToInteger":
   HEAP32[params >> 2] = Math.fround(data);
   break;
  default:
   throw "internal emscriptenWebGLGetVertexAttrib() error, bad type: " + type;
  }
 } else {
  for (var i = 0; i < data.length; i++) {
   switch (type) {
   case "Integer":
    HEAP32[params + i >> 2] = data[i];
    break;
   case "Float":
    HEAPF32[params + i >> 2] = data[i];
    break;
   case "FloatToInteger":
    HEAP32[params + i >> 2] = Math.fround(data[i]);
    break;
   default:
    throw "internal emscriptenWebGLGetVertexAttrib() error, bad type: " + type;
   }
  }
 }
}
Module["emscriptenWebGLGetVertexAttrib"] = emscriptenWebGLGetVertexAttrib;
function _glGetVertexAttribiv(index, pname, params) {
 emscriptenWebGLGetVertexAttrib(index, pname, params, "FloatToInteger");
}
Module["_glGetVertexAttribiv"] = _glGetVertexAttribiv;
function ___cxa_find_matching_catch_2() {
 return ___cxa_find_matching_catch.apply(null, arguments);
}
Module["___cxa_find_matching_catch_2"] = ___cxa_find_matching_catch_2;
function ___cxa_find_matching_catch_3() {
 return ___cxa_find_matching_catch.apply(null, arguments);
}
Module["___cxa_find_matching_catch_3"] = ___cxa_find_matching_catch_3;
function _il2cpp_image_get_name() {
 if (!Module["_il2cpp_image_get_name"]) abort("external function 'il2cpp_image_get_name' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_image_get_name"].apply(null, arguments);
}
function __exit(status) {
 Module["exit"](status);
}
Module["__exit"] = __exit;
function _exit(status) {
 __exit(status);
}
Module["_exit"] = _exit;
function __Exit(status) {
 __exit(status);
}
Module["__Exit"] = __Exit;
function _JS_FileSystem_Sync() {
 if (!Module.indexedDB) return;
 fs.sync(false);
}
Module["_JS_FileSystem_Sync"] = _JS_FileSystem_Sync;
function _emscripten_glEnable(x0) {
 GLctx.enable(x0);
}
Module["_emscripten_glEnable"] = _emscripten_glEnable;
var _llvm_pow_f64 = Math_pow;
Module["_llvm_pow_f64"] = _llvm_pow_f64;
function ___syscall305(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var dirfd = SYSCALLS.get(), path = SYSCALLS.getStr(), buf = SYSCALLS.get(), bufsize = SYSCALLS.get();
  path = SYSCALLS.calculateAt(dirfd, path);
  return SYSCALLS.doReadlink(path, buf, bufsize);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall305"] = ___syscall305;
function _il2cpp_profiler_install_enter_leave() {
 if (!Module["_il2cpp_profiler_install_enter_leave"]) abort("external function 'il2cpp_profiler_install_enter_leave' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_profiler_install_enter_leave"].apply(null, arguments);
}
function _il2cpp_thread_attach() {
 if (!Module["_il2cpp_thread_attach"]) abort("external function 'il2cpp_thread_attach' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_thread_attach"].apply(null, arguments);
}
function _emscripten_glGetShaderSource(shader, bufSize, length, source) {
 var result = GLctx.getShaderSource(GL.shaders[shader]);
 if (!result) return;
 result = result.slice(0, Math.max(0, bufSize - 1));
 if (bufSize > 0 && source) {
  writeStringToMemory(result, source);
  if (length) HEAP32[length >> 2] = result.length;
 } else {
  if (length) HEAP32[length >> 2] = 0;
 }
}
Module["_emscripten_glGetShaderSource"] = _emscripten_glGetShaderSource;
function _emscripten_glClearDepth(x0) {
 GLctx.clearDepth(x0);
}
Module["_emscripten_glClearDepth"] = _emscripten_glClearDepth;
function _JS_Sound_GetLoadState(bufferInstance) {
 if (WEBAudio.audioWebEnabled == 0) return 2;
 var sound = WEBAudio.audioInstances[bufferInstance];
 if (sound.error) return 2;
 if (sound.buffer) return 0;
 return 1;
}
Module["_JS_Sound_GetLoadState"] = _JS_Sound_GetLoadState;
function _JS_Sound_SetPitch(channelInstance, v) {
 if (WEBAudio.audioWebEnabled == 0) return;
 WEBAudio.audioInstances[channelInstance].source.playbackRate.value = v;
}
Module["_JS_Sound_SetPitch"] = _JS_Sound_SetPitch;
function _gmtime_r(time, tmPtr) {
 var date = new Date(HEAP32[time >> 2] * 1e3);
 HEAP32[tmPtr >> 2] = date.getUTCSeconds();
 HEAP32[tmPtr + 4 >> 2] = date.getUTCMinutes();
 HEAP32[tmPtr + 8 >> 2] = date.getUTCHours();
 HEAP32[tmPtr + 12 >> 2] = date.getUTCDate();
 HEAP32[tmPtr + 16 >> 2] = date.getUTCMonth();
 HEAP32[tmPtr + 20 >> 2] = date.getUTCFullYear() - 1900;
 HEAP32[tmPtr + 24 >> 2] = date.getUTCDay();
 HEAP32[tmPtr + 36 >> 2] = 0;
 HEAP32[tmPtr + 32 >> 2] = 0;
 var start = Date.UTC(date.getUTCFullYear(), 0, 1, 0, 0, 0, 0);
 var yday = (date.getTime() - start) / (1e3 * 60 * 60 * 24) | 0;
 HEAP32[tmPtr + 28 >> 2] = yday;
 HEAP32[tmPtr + 40 >> 2] = ___tm_timezone;
 return tmPtr;
}
Module["_gmtime_r"] = _gmtime_r;
function _glUseProgram(program) {
 GLctx.useProgram(program ? GL.programs[program] : null);
}
Module["_glUseProgram"] = _glUseProgram;
function _glGetProgramInfoLog(program, maxLength, length, infoLog) {
 var log = GLctx.getProgramInfoLog(GL.programs[program]);
 if (log === null) log = "(unknown error)";
 log = log.substr(0, maxLength - 1);
 if (maxLength > 0 && infoLog) {
  writeStringToMemory(log, infoLog);
  if (length) HEAP32[length >> 2] = log.length;
 } else {
  if (length) HEAP32[length >> 2] = 0;
 }
}
Module["_glGetProgramInfoLog"] = _glGetProgramInfoLog;
function _emscripten_glUniform3fv(location, count, value) {
 location = GL.uniforms[location];
 var view;
 if (3 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[3 * count - 1];
  for (var i = 0; i < 3 * count; i += 3) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 12 >> 2);
 }
 GLctx.uniform3fv(location, view);
}
Module["_emscripten_glUniform3fv"] = _emscripten_glUniform3fv;
function _glBindTransformFeedback(target, id) {
 var transformFeedback = id ? GL.transformFeedbacks[id] : null;
 if (id && !transformFeedback) {
  GL.recordError(1282);
  return;
 }
 GLctx["bindTransformFeedback"](target, transformFeedback);
}
Module["_glBindTransformFeedback"] = _glBindTransformFeedback;
function _il2cpp_class_is_subclass_of() {
 if (!Module["_il2cpp_class_is_subclass_of"]) abort("external function 'il2cpp_class_is_subclass_of' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_is_subclass_of"].apply(null, arguments);
}
function _glBindVertexArray(vao) {
 GLctx["bindVertexArray"](GL.vaos[vao]);
}
Module["_glBindVertexArray"] = _glBindVertexArray;
function ___resumeException(ptr) {
 if (!EXCEPTIONS.last) {
  EXCEPTIONS.last = ptr;
 }
 EXCEPTIONS.clearRef(EXCEPTIONS.deAdjust(ptr));
 throw ptr;
}
Module["___resumeException"] = ___resumeException;
function _emscripten_glCreateProgram() {
 var id = GL.getNewId(GL.programs);
 var program = GLctx.createProgram();
 program.name = id;
 GL.programs[id] = program;
 return id;
}
Module["_emscripten_glCreateProgram"] = _emscripten_glCreateProgram;
function _pthread_once(ptr, func) {
 if (!_pthread_once.seen) _pthread_once.seen = {};
 if (ptr in _pthread_once.seen) return;
 Runtime.dynCall("v", func);
 _pthread_once.seen[ptr] = 1;
}
Module["_pthread_once"] = _pthread_once;
function _emscripten_glCompressedTexImage2D(target, level, internalFormat, width, height, border, imageSize, data) {
 var heapView;
 if (data) {
  heapView = HEAPU8.subarray(data, data + imageSize);
 } else {
  heapView = null;
 }
 GLctx["compressedTexImage2D"](target, level, internalFormat, width, height, border, heapView);
}
Module["_emscripten_glCompressedTexImage2D"] = _emscripten_glCompressedTexImage2D;
function _emscripten_glClearColor(x0, x1, x2, x3) {
 GLctx.clearColor(x0, x1, x2, x3);
}
Module["_emscripten_glClearColor"] = _emscripten_glClearColor;
function _posix_spawn_file_actions_adddup2() {
 if (!Module["_posix_spawn_file_actions_adddup2"]) abort("external function 'posix_spawn_file_actions_adddup2' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_posix_spawn_file_actions_adddup2"].apply(null, arguments);
}
function ___syscall133(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD();
  FS.chdir(stream.path);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall133"] = ___syscall133;
function _pthread_attr_destroy(attr) {
 return 0;
}
Module["_pthread_attr_destroy"] = _pthread_attr_destroy;
function _JS_SystemInfo_HasWebGL() {
 return systemInfo.get().hasWebGL;
}
Module["_JS_SystemInfo_HasWebGL"] = _JS_SystemInfo_HasWebGL;
function _glFinish() {
 GLctx.finish();
}
Module["_glFinish"] = _glFinish;
function _il2cpp_class_get_parent() {
 if (!Module["_il2cpp_class_get_parent"]) abort("external function 'il2cpp_class_get_parent' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_get_parent"].apply(null, arguments);
}
function _emscripten_glLoadMatrixf() {
 if (!Module["_emscripten_glLoadMatrixf"]) abort("external function 'emscripten_glLoadMatrixf' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_emscripten_glLoadMatrixf"].apply(null, arguments);
}
function _glDeleteShader(id) {
 if (!id) return;
 var shader = GL.shaders[id];
 if (!shader) {
  GL.recordError(1281);
  return;
 }
 GLctx.deleteShader(shader);
 GL.shaders[id] = null;
}
Module["_glDeleteShader"] = _glDeleteShader;
function _il2cpp_type_get_type() {
 if (!Module["_il2cpp_type_get_type"]) abort("external function 'il2cpp_type_get_type' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_type_get_type"].apply(null, arguments);
}
function _pthread_setschedparam() {
 if (!Module["_pthread_setschedparam"]) abort("external function 'pthread_setschedparam' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_pthread_setschedparam"].apply(null, arguments);
}
function _emscripten_glDepthMask(x0) {
 GLctx.depthMask(x0);
}
Module["_emscripten_glDepthMask"] = _emscripten_glDepthMask;
function _glTransformFeedbackVaryings(program, count, varyings, bufferMode) {
 program = GL.programs[program];
 var vars = [];
 for (var i = 0; i < count; i++) vars.push(Pointer_stringify(HEAP32[varyings + i * 4 >> 2]));
 GLctx["transformFeedbackVaryings"](program, vars, bufferMode);
}
Module["_glTransformFeedbackVaryings"] = _glTransformFeedbackVaryings;
function _JS_Sound_Init() {
 try {
  window.AudioContext = window.AudioContext || window.webkitAudioContext;
  WEBAudio.audioContext = new AudioContext;
  WEBAudio.audioWebEnabled = 1;
 } catch (e) {
  alert("Web Audio API is not supported in this browser");
 }
}
Module["_JS_Sound_Init"] = _JS_Sound_Init;
function _emscripten_glFlush() {
 GLctx.flush();
}
Module["_emscripten_glFlush"] = _emscripten_glFlush;
function __ZN4FMOD13DSPConnection6setMixEf() {
 if (!Module["__ZN4FMOD13DSPConnection6setMixEf"]) abort("external function '_ZN4FMOD13DSPConnection6setMixEf' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["__ZN4FMOD13DSPConnection6setMixEf"].apply(null, arguments);
}
function _emscripten_glCreateShader(shaderType) {
 var id = GL.getNewId(GL.shaders);
 GL.shaders[id] = GLctx.createShader(shaderType);
 return id;
}
Module["_emscripten_glCreateShader"] = _emscripten_glCreateShader;
function _pthread_cond_init() {
 return 0;
}
Module["_pthread_cond_init"] = _pthread_cond_init;
function _emscripten_glIsShader(shader) {
 var s = GL.shaders[shader];
 if (!s) return 0;
 return GLctx.isShader(s);
}
Module["_emscripten_glIsShader"] = _emscripten_glIsShader;
function _JS_WebCamVideo_Start(deviceId) {
 if (MediaDevices[deviceId].video) {
  MediaDevices[deviceId].refCount++;
  return;
 }
 if (!navigator.mediaDevices || !navigator.mediaDevices.getUserMedia) {
  navigator.getMedia = navigator.getUserMedia || navigator.webkitGetUserMedia || navigator.mozGetUserMedia || navigator.msGetUserMedia;
 } else {
  navigator.getMedia = (function(constraints, success, error) {
   navigator.mediaDevices.getUserMedia(constraints).then(success).catch(error);
  });
 }
 if (!navigator.getMedia) {
  console.log("WebCam is not supported. Try a different browser.");
  return;
 }
 if (!webcam.canvas) {
  canvas = document.createElement("canvas");
  canvas.style.display = "none";
  var context2d = canvas.getContext("2d");
  if (!context2d) {
   console.log("context2d is null");
   return;
  }
  document.body.appendChild(canvas);
  webcam.canvas = canvas;
 }
 var video = document.createElement("video");
 navigator.getMedia({
  video: true,
  audio: false
 }, (function(stream) {
  if (navigator.mozGetUserMedia) {
   video.mozSrcObject = stream;
  } else {
   var vendorURL = window.URL || window.webkitURL;
   video.src = vendorURL ? vendorURL.createObjectURL(stream) : stream;
  }
  webcam.canvas.appendChild(video);
  video.play();
  MediaDevices[deviceId].video = video;
  MediaDevices[deviceId].refCount++;
 }), (function(err) {
  console.log("An error occurred! " + err);
 }));
}
Module["_JS_WebCamVideo_Start"] = _JS_WebCamVideo_Start;
function _glTexParameterf(x0, x1, x2) {
 GLctx.texParameterf(x0, x1, x2);
}
Module["_glTexParameterf"] = _glTexParameterf;
function _glTexParameteri(x0, x1, x2) {
 GLctx.texParameteri(x0, x1, x2);
}
Module["_glTexParameteri"] = _glTexParameteri;
function _emscripten_glColorMask(x0, x1, x2, x3) {
 GLctx.colorMask(x0, x1, x2, x3);
}
Module["_emscripten_glColorMask"] = _emscripten_glColorMask;
function _glGetShaderSource(shader, bufSize, length, source) {
 var result = GLctx.getShaderSource(GL.shaders[shader]);
 if (!result) return;
 result = result.slice(0, Math.max(0, bufSize - 1));
 if (bufSize > 0 && source) {
  writeStringToMemory(result, source);
  if (length) HEAP32[length >> 2] = result.length;
 } else {
  if (length) HEAP32[length >> 2] = 0;
 }
}
Module["_glGetShaderSource"] = _glGetShaderSource;
function _emscripten_set_canvas_size(width, height) {
 Browser.setCanvasSize(width, height);
}
Module["_emscripten_set_canvas_size"] = _emscripten_set_canvas_size;
function _il2cpp_runtime_invoke() {
 if (!Module["_il2cpp_runtime_invoke"]) abort("external function 'il2cpp_runtime_invoke' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_runtime_invoke"].apply(null, arguments);
}
function _glPixelStorei(pname, param) {
 if (pname == 3333) {
  GL.packAlignment = param;
 } else if (pname == 3317) {
  GL.unpackAlignment = param;
 }
 GLctx.pixelStorei(pname, param);
}
Module["_glPixelStorei"] = _glPixelStorei;
function _glValidateProgram(program) {
 GLctx.validateProgram(GL.programs[program]);
}
Module["_glValidateProgram"] = _glValidateProgram;
function _JS_WebRequest_Abort(request) {
 wr.requestInstances[request].abort();
}
Module["_JS_WebRequest_Abort"] = _JS_WebRequest_Abort;
function _emscripten_set_dblclick_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerMouseEventCallback(target, userData, useCapture, callbackfunc, 7, "dblclick");
 return 0;
}
Module["_emscripten_set_dblclick_callback"] = _emscripten_set_dblclick_callback;
function ___syscall221(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD(), cmd = SYSCALLS.get();
  switch (cmd) {
  case 0:
   {
    var arg = SYSCALLS.get();
    if (arg < 0) {
     return -ERRNO_CODES.EINVAL;
    }
    var newStream;
    newStream = FS.open(stream.path, stream.flags, 0, arg);
    return newStream.fd;
   }
  case 1:
  case 2:
   return 0;
  case 3:
   return stream.flags;
  case 4:
   {
    var arg = SYSCALLS.get();
    stream.flags |= arg;
    return 0;
   }
  case 12:
  case 12:
   {
    var arg = SYSCALLS.get();
    var offset = 0;
    HEAP16[arg + offset >> 1] = 2;
    return 0;
   }
  case 13:
  case 14:
  case 13:
  case 14:
   return 0;
  case 16:
  case 8:
   return -ERRNO_CODES.EINVAL;
  case 9:
   ___setErrNo(ERRNO_CODES.EINVAL);
   return -1;
  default:
   {
    return -ERRNO_CODES.EINVAL;
   }
  }
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall221"] = ___syscall221;
function ___syscall220(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD(), dirp = SYSCALLS.get(), count = SYSCALLS.get();
  if (!stream.getdents) {
   stream.getdents = FS.readdir(stream.path);
  }
  var pos = 0;
  while (stream.getdents.length > 0 && pos + 268 < count) {
   var id;
   var type;
   var name = stream.getdents.pop();
   assert(name.length < 256);
   if (name[0] === ".") {
    id = 1;
    type = 4;
   } else {
    var child = FS.lookupNode(stream.node, name);
    id = child.id;
    type = FS.isChrdev(child.mode) ? 2 : FS.isDir(child.mode) ? 4 : FS.isLink(child.mode) ? 10 : 8;
   }
   HEAP32[dirp + pos >> 2] = id;
   HEAP32[dirp + pos + 4 >> 2] = stream.position;
   HEAP16[dirp + pos + 8 >> 1] = 268;
   HEAP8[dirp + pos + 10 >> 0] = type;
   for (var i = 0; i < name.length; i++) {
    HEAP8[dirp + pos + (11 + i) >> 0] = name.charCodeAt(i);
   }
   HEAP8[dirp + pos + (11 + i) >> 0] = 0;
   pos += 268;
  }
  return pos;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall220"] = ___syscall220;
function _emscripten_glIsRenderbuffer(renderbuffer) {
 var rb = GL.renderbuffers[renderbuffer];
 if (!rb) return 0;
 return GLctx.isRenderbuffer(rb);
}
Module["_emscripten_glIsRenderbuffer"] = _emscripten_glIsRenderbuffer;
function _emscripten_glVertexAttrib3fv(index, v) {
 var view = GL.miniTempBufferViews[2];
 view[0] = HEAPF32[v >> 2];
 view[1] = HEAPF32[v + 4 >> 2];
 view[2] = HEAPF32[v + 8 >> 2];
 GLctx.vertexAttrib3fv(index, view);
}
Module["_emscripten_glVertexAttrib3fv"] = _emscripten_glVertexAttrib3fv;
function ___cxa_increment_exception_refcount(ptr) {
 EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));
}
Module["___cxa_increment_exception_refcount"] = ___cxa_increment_exception_refcount;
function _glLinkProgram(program) {
 GLctx.linkProgram(GL.programs[program]);
 GL.programInfos[program] = null;
 GL.populateUniformTable(program);
}
Module["_glLinkProgram"] = _glLinkProgram;
function _glBindTexture(target, texture) {
 GLctx.bindTexture(target, texture ? GL.textures[texture] : null);
}
Module["_glBindTexture"] = _glBindTexture;
function _glClearColor(x0, x1, x2, x3) {
 GLctx.clearColor(x0, x1, x2, x3);
}
Module["_glClearColor"] = _glClearColor;
function _glUniform3iv(location, count, value) {
 location = GL.uniforms[location];
 count *= 3;
 value = HEAP32.subarray(value >> 2, value + count * 4 >> 2);
 GLctx.uniform3iv(location, value);
}
Module["_glUniform3iv"] = _glUniform3iv;
function _il2cpp_set_find_plugin_callback() {
 if (!Module["_il2cpp_set_find_plugin_callback"]) abort("external function 'il2cpp_set_find_plugin_callback' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_set_find_plugin_callback"].apply(null, arguments);
}
function _posix_spawn_file_actions_init() {
 if (!Module["_posix_spawn_file_actions_init"]) abort("external function 'posix_spawn_file_actions_init' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_posix_spawn_file_actions_init"].apply(null, arguments);
}
function _emscripten_glShaderSource(shader, count, string, length) {
 var source = GL.getSource(shader, count, string, length);
 GLctx.shaderSource(GL.shaders[shader], source);
}
Module["_emscripten_glShaderSource"] = _emscripten_glShaderSource;
function _glEndQuery(x0) {
 GLctx.endQuery(x0);
}
Module["_glEndQuery"] = _glEndQuery;
function _pthread_mutex_init() {}
Module["_pthread_mutex_init"] = _pthread_mutex_init;
function _glUniform2fv(location, count, value) {
 location = GL.uniforms[location];
 var view;
 if (2 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[2 * count - 1];
  for (var i = 0; i < 2 * count; i += 2) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 8 >> 2);
 }
 GLctx.uniform2fv(location, view);
}
Module["_glUniform2fv"] = _glUniform2fv;
function _emscripten_glIsTexture(texture) {
 var texture = GL.textures[texture];
 if (!texture) return 0;
 return GLctx.isTexture(texture);
}
Module["_emscripten_glIsTexture"] = _emscripten_glIsTexture;
function ___syscall51(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return -ERRNO_CODES.ENOSYS;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall51"] = ___syscall51;
function __Z18RegisterAllClassesv() {
 if (!Module["__Z18RegisterAllClassesv"]) abort("external function '_Z18RegisterAllClassesv' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["__Z18RegisterAllClassesv"].apply(null, arguments);
}
Module["_pthread_mutex_trylock"] = _pthread_mutex_trylock;
function ___syscall54(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD(), op = SYSCALLS.get();
  switch (op) {
  case 21505:
   {
    if (!stream.tty) return -ERRNO_CODES.ENOTTY;
    return 0;
   }
  case 21506:
   {
    if (!stream.tty) return -ERRNO_CODES.ENOTTY;
    return 0;
   }
  case 21519:
   {
    if (!stream.tty) return -ERRNO_CODES.ENOTTY;
    var argp = SYSCALLS.get();
    HEAP32[argp >> 2] = 0;
    return 0;
   }
  case 21520:
   {
    if (!stream.tty) return -ERRNO_CODES.ENOTTY;
    return -ERRNO_CODES.EINVAL;
   }
  case 21531:
   {
    var argp = SYSCALLS.get();
    return FS.ioctl(stream, op, argp);
   }
  default:
   abort("bad ioctl syscall " + op);
  }
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall54"] = ___syscall54;
function ___syscall57(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var pid = SYSCALLS.get(), pgid = SYSCALLS.get();
  if (pid && pid !== PROCINFO.pid) return -ERRNO_CODES.ESRCH;
  if (pgid && pgid !== PROCINFO.pgid) return -ERRNO_CODES.EPERM;
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall57"] = ___syscall57;
function ___cxa_current_primary_exception() {
 var ret = EXCEPTIONS.caught[EXCEPTIONS.caught.length - 1] || 0;
 if (ret) EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ret));
 return ret;
}
Module["___cxa_current_primary_exception"] = ___cxa_current_primary_exception;
function _il2cpp_unity_liveness_calculation_end() {
 if (!Module["_il2cpp_unity_liveness_calculation_end"]) abort("external function 'il2cpp_unity_liveness_calculation_end' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_unity_liveness_calculation_end"].apply(null, arguments);
}
function _glStencilOpSeparate(x0, x1, x2, x3) {
 GLctx.stencilOpSeparate(x0, x1, x2, x3);
}
Module["_glStencilOpSeparate"] = _glStencilOpSeparate;
function ___muldc3() {
 if (!Module["___muldc3"]) abort("external function '__muldc3' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["___muldc3"].apply(null, arguments);
}
function _glDeleteQueries(n, ids) {
 for (var i = 0; i < n; i++) {
  var id = HEAP32[ids + i * 4 >> 2];
  var query = GL.queries[id];
  if (!query) continue;
  GLctx["deleteQuery"](query);
  query.name = 0;
  GL.queries[id] = null;
 }
}
Module["_glDeleteQueries"] = _glDeleteQueries;
function _il2cpp_field_get_parent() {
 if (!Module["_il2cpp_field_get_parent"]) abort("external function 'il2cpp_field_get_parent' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_field_get_parent"].apply(null, arguments);
}
function _glVertexAttrib4f(x0, x1, x2, x3, x4) {
 GLctx.vertexAttrib4f(x0, x1, x2, x3, x4);
}
Module["_glVertexAttrib4f"] = _glVertexAttrib4f;
function _emscripten_glUniform4i(location, v0, v1, v2, v3) {
 location = GL.uniforms[location];
 GLctx.uniform4i(location, v0, v1, v2, v3);
}
Module["_emscripten_glUniform4i"] = _emscripten_glUniform4i;
function _glGetTexParameteriv(target, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 HEAP32[params >> 2] = GLctx.getTexParameter(target, pname);
}
Module["_glGetTexParameteriv"] = _glGetTexParameteriv;
function _emscripten_glViewport(x0, x1, x2, x3) {
 GLctx.viewport(x0, x1, x2, x3);
}
Module["_emscripten_glViewport"] = _emscripten_glViewport;
function _emscripten_memcpy_big(dest, src, num) {
 HEAPU8.set(HEAPU8.subarray(src, src + num), dest);
 return dest;
}
Module["_emscripten_memcpy_big"] = _emscripten_memcpy_big;
Module["_memcpy"] = _memcpy;
function _emscripten_glBufferData(target, size, data, usage) {
 switch (usage) {
 case 35041:
 case 35042:
  usage = 35040;
  break;
 case 35045:
 case 35046:
  usage = 35044;
  break;
 case 35049:
 case 35050:
  usage = 35048;
  break;
 }
 if (!data) {
  GLctx.bufferData(target, size, usage);
 } else {
  GLctx.bufferData(target, HEAPU8.subarray(data, data + size), usage);
 }
}
Module["_emscripten_glBufferData"] = _emscripten_glBufferData;
function _glSamplerParameteri(sampler, pname, param) {
 GLctx["samplerParameteri"](sampler ? GL.samplers[sampler] : null, pname, param);
}
Module["_glSamplerParameteri"] = _glSamplerParameteri;
function _pthread_getschedparam() {
 if (!Module["_pthread_getschedparam"]) abort("external function 'pthread_getschedparam' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_pthread_getschedparam"].apply(null, arguments);
}
function _il2cpp_class_get_image() {
 if (!Module["_il2cpp_class_get_image"]) abort("external function 'il2cpp_class_get_image' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_get_image"].apply(null, arguments);
}
function _pthread_mutexattr_init() {}
Module["_pthread_mutexattr_init"] = _pthread_mutexattr_init;
var _llvm_fabs_f32 = Math_abs;
Module["_llvm_fabs_f32"] = _llvm_fabs_f32;
function _il2cpp_get_corlib() {
 if (!Module["_il2cpp_get_corlib"]) abort("external function 'il2cpp_get_corlib' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_get_corlib"].apply(null, arguments);
}
function _emscripten_glUniform3f(location, v0, v1, v2) {
 location = GL.uniforms[location];
 GLctx.uniform3f(location, v0, v1, v2);
}
Module["_emscripten_glUniform3f"] = _emscripten_glUniform3f;
function _emscripten_glBlendFunc(x0, x1) {
 GLctx.blendFunc(x0, x1);
}
Module["_emscripten_glBlendFunc"] = _emscripten_glBlendFunc;
function _emscripten_glUniform3i(location, v0, v1, v2) {
 location = GL.uniforms[location];
 GLctx.uniform3i(location, v0, v1, v2);
}
Module["_emscripten_glUniform3i"] = _emscripten_glUniform3i;
function _emscripten_glStencilOp(x0, x1, x2) {
 GLctx.stencilOp(x0, x1, x2);
}
Module["_emscripten_glStencilOp"] = _emscripten_glStencilOp;
function _glGetActiveUniformBlockiv(program, uniformBlockIndex, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 program = GL.programs[program];
 var result = GLctx["getActiveUniformBlockParameter"](program, uniformBlockIndex, pname);
 if (!result) return;
 if (typeof result == "number") {
  HEAP32[params >> 2] = result;
 } else {
  for (var i = 0; i < result.length; i++) {
   HEAP32[params + i * 4 >> 2] = result[i];
  }
 }
}
Module["_glGetActiveUniformBlockiv"] = _glGetActiveUniformBlockiv;
function _glUniform1i(location, v0) {
 location = GL.uniforms[location];
 GLctx.uniform1i(location, v0);
}
Module["_glUniform1i"] = _glUniform1i;
function _glGetActiveAttrib(program, index, bufSize, length, size, type, name) {
 program = GL.programs[program];
 var info = GLctx.getActiveAttrib(program, index);
 if (!info) return;
 var infoname = info.name.slice(0, Math.max(0, bufSize - 1));
 if (bufSize > 0 && name) {
  writeStringToMemory(infoname, name);
  if (length) HEAP32[length >> 2] = infoname.length;
 } else {
  if (length) HEAP32[length >> 2] = 0;
 }
 if (size) HEAP32[size >> 2] = info.size;
 if (type) HEAP32[type >> 2] = info.type;
}
Module["_glGetActiveAttrib"] = _glGetActiveAttrib;
function _glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels) {
 var pixelData = null;
 if (pixels) pixelData = emscriptenWebGLGetTexPixelData(type, format, width, height, pixels, 0);
 GLctx.texSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixelData);
}
Module["_glTexSubImage2D"] = _glTexSubImage2D;
function _glDisable(x0) {
 GLctx.disable(x0);
}
Module["_glDisable"] = _glDisable;
function _emscripten_glEnableVertexAttribArray(index) {
 GLctx.enableVertexAttribArray(index);
}
Module["_emscripten_glEnableVertexAttribArray"] = _emscripten_glEnableVertexAttribArray;
function _JS_SystemInfo_GetMemory() {
 return TOTAL_MEMORY / (1024 * 1024);
}
Module["_JS_SystemInfo_GetMemory"] = _JS_SystemInfo_GetMemory;
function _il2cpp_array_class_get() {
 if (!Module["_il2cpp_array_class_get"]) abort("external function 'il2cpp_array_class_get' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_array_class_get"].apply(null, arguments);
}
function _emscripten_glRotatef() {
 if (!Module["_emscripten_glRotatef"]) abort("external function 'emscripten_glRotatef' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_emscripten_glRotatef"].apply(null, arguments);
}
function _il2cpp_field_get_flags() {
 if (!Module["_il2cpp_field_get_flags"]) abort("external function 'il2cpp_field_get_flags' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_field_get_flags"].apply(null, arguments);
}
function _emscripten_glCopyTexSubImage2D(x0, x1, x2, x3, x4, x5, x6, x7) {
 GLctx.copyTexSubImage2D(x0, x1, x2, x3, x4, x5, x6, x7);
}
Module["_emscripten_glCopyTexSubImage2D"] = _emscripten_glCopyTexSubImage2D;
function _emscripten_set_touchcancel_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerTouchEventCallback(target, userData, useCapture, callbackfunc, 25, "touchcancel");
 return 0;
}
Module["_emscripten_set_touchcancel_callback"] = _emscripten_set_touchcancel_callback;
function ___syscall85(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var path = SYSCALLS.getStr(), buf = SYSCALLS.get(), bufsize = SYSCALLS.get();
  return SYSCALLS.doReadlink(path, buf, bufsize);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall85"] = ___syscall85;
function _glBindFramebuffer(target, framebuffer) {
 GLctx.bindFramebuffer(target, framebuffer ? GL.framebuffers[framebuffer] : null);
}
Module["_glBindFramebuffer"] = _glBindFramebuffer;
function _emscripten_glBlendFuncSeparate(x0, x1, x2, x3) {
 GLctx.blendFuncSeparate(x0, x1, x2, x3);
}
Module["_emscripten_glBlendFuncSeparate"] = _emscripten_glBlendFuncSeparate;
function _glCullFace(x0) {
 GLctx.cullFace(x0);
}
Module["_glCullFace"] = _glCullFace;
function _emscripten_glColorPointer() {
 if (!Module["_emscripten_glColorPointer"]) abort("external function 'emscripten_glColorPointer' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_emscripten_glColorPointer"].apply(null, arguments);
}
function _glDeleteTextures(n, textures) {
 for (var i = 0; i < n; i++) {
  var id = HEAP32[textures + i * 4 >> 2];
  var texture = GL.textures[id];
  if (!texture) continue;
  GLctx.deleteTexture(texture);
  texture.name = 0;
  GL.textures[id] = null;
 }
}
Module["_glDeleteTextures"] = _glDeleteTextures;
function _emscripten_glNormalPointer() {
 if (!Module["_emscripten_glNormalPointer"]) abort("external function 'emscripten_glNormalPointer' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_emscripten_glNormalPointer"].apply(null, arguments);
}
function _emscripten_glGetFramebufferAttachmentParameteriv(target, attachment, pname, params) {
 var result = GLctx.getFramebufferAttachmentParameter(target, attachment, pname);
 HEAP32[params >> 2] = result;
}
Module["_emscripten_glGetFramebufferAttachmentParameteriv"] = _emscripten_glGetFramebufferAttachmentParameteriv;
function _emscripten_get_pointerlock_status(pointerlockStatus) {
 if (pointerlockStatus) JSEvents.fillPointerlockChangeEventData(pointerlockStatus);
 if (!document.body.requestPointerLock && !document.body.mozRequestPointerLock && !document.body.webkitRequestPointerLock && !document.body.msRequestPointerLock) {
  return -1;
 }
 return 0;
}
Module["_emscripten_get_pointerlock_status"] = _emscripten_get_pointerlock_status;
function _glAttachShader(program, shader) {
 GLctx.attachShader(GL.programs[program], GL.shaders[shader]);
}
Module["_glAttachShader"] = _glAttachShader;
function _pthread_cleanup_push(routine, arg) {
 __ATEXIT__.push((function() {
  Runtime.dynCall("vi", routine, [ arg ]);
 }));
 _pthread_cleanup_push.level = __ATEXIT__.length;
}
Module["_pthread_cleanup_push"] = _pthread_cleanup_push;
function _emscripten_glGetVertexAttribfv(index, pname, params) {
 emscriptenWebGLGetVertexAttrib(index, pname, params, "Float");
}
Module["_emscripten_glGetVertexAttribfv"] = _emscripten_glGetVertexAttribfv;
function _emscripten_set_keyup_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerKeyEventCallback(target, userData, useCapture, callbackfunc, 3, "keyup");
 return 0;
}
Module["_emscripten_set_keyup_callback"] = _emscripten_set_keyup_callback;
function _il2cpp_gc_get_used_size() {
 if (!Module["_il2cpp_gc_get_used_size"]) abort("external function 'il2cpp_gc_get_used_size' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_gc_get_used_size"].apply(null, arguments);
}
function _il2cpp_value_box() {
 if (!Module["_il2cpp_value_box"]) abort("external function 'il2cpp_value_box' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_value_box"].apply(null, arguments);
}
function _glDrawElements(mode, count, type, indices) {
 GLctx.drawElements(mode, count, type, indices);
}
Module["_glDrawElements"] = _glDrawElements;
function _il2cpp_raise_exception() {
 if (!Module["_il2cpp_raise_exception"]) abort("external function 'il2cpp_raise_exception' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_raise_exception"].apply(null, arguments);
}
Module["_i64Add"] = _i64Add;
Module["_i64Subtract"] = _i64Subtract;
var cttz_i8 = allocate([ 8, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0 ], "i8", ALLOC_STATIC);
Module["_llvm_cttz_i32"] = _llvm_cttz_i32;
Module["___udivmoddi4"] = ___udivmoddi4;
Module["___remdi3"] = ___remdi3;
function _emscripten_get_fullscreen_status(fullscreenStatus) {
 if (typeof JSEvents.fullscreenEnabled() === "undefined") return -1;
 JSEvents.fillFullscreenChangeEventData(fullscreenStatus);
 return 0;
}
Module["_emscripten_get_fullscreen_status"] = _emscripten_get_fullscreen_status;
function _emscripten_glGetInfoLogARB() {
 if (!Module["_emscripten_glGetInfoLogARB"]) abort("external function 'emscripten_glGetInfoLogARB' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_emscripten_glGetInfoLogARB"].apply(null, arguments);
}
function _malloc(bytes) {
 var ptr = Runtime.dynamicAlloc(bytes + 8);
 return ptr + 8 & 4294967288;
}
Module["_malloc"] = _malloc;
var _environ = STATICTOP;
STATICTOP += 16;
Module["_environ"] = _environ;
var ___environ = _environ;
Module["___environ"] = ___environ;
function ___buildEnvironment(env) {
 var MAX_ENV_VALUES = 64;
 var TOTAL_ENV_SIZE = 1024;
 var poolPtr;
 var envPtr;
 if (!___buildEnvironment.called) {
  ___buildEnvironment.called = true;
  ENV["USER"] = ENV["LOGNAME"] = "web_user";
  ENV["PATH"] = "/";
  ENV["PWD"] = "/";
  ENV["HOME"] = "/home/web_user";
  ENV["LANG"] = "C";
  ENV["_"] = Module["thisProgram"];
  poolPtr = allocate(TOTAL_ENV_SIZE, "i8", ALLOC_STATIC);
  envPtr = allocate(MAX_ENV_VALUES * 4, "i8*", ALLOC_STATIC);
  HEAP32[envPtr >> 2] = poolPtr;
  HEAP32[_environ >> 2] = envPtr;
 } else {
  envPtr = HEAP32[_environ >> 2];
  poolPtr = HEAP32[envPtr >> 2];
 }
 var strings = [];
 var totalSize = 0;
 for (var key in env) {
  if (typeof env[key] === "string") {
   var line = key + "=" + env[key];
   strings.push(line);
   totalSize += line.length;
  }
 }
 if (totalSize > TOTAL_ENV_SIZE) {
  throw new Error("Environment size exceeded TOTAL_ENV_SIZE!");
 }
 var ptrSize = 4;
 for (var i = 0; i < strings.length; i++) {
  var line = strings[i];
  writeAsciiToMemory(line, poolPtr);
  HEAP32[envPtr + i * ptrSize >> 2] = poolPtr;
  poolPtr += line.length + 1;
 }
 HEAP32[envPtr + strings.length * ptrSize >> 2] = 0;
}
Module["___buildEnvironment"] = ___buildEnvironment;
var ENV = {};
Module["ENV"] = ENV;
function _getenv(name) {
 if (name === 0) return 0;
 name = Pointer_stringify(name);
 if (!ENV.hasOwnProperty(name)) return 0;
 if (_getenv.ret) _free(_getenv.ret);
 _getenv.ret = allocate(intArrayFromString(ENV[name]), "i8", ALLOC_NORMAL);
 return _getenv.ret;
}
Module["_getenv"] = _getenv;
function _putenv(string) {
 if (string === 0) {
  ___setErrNo(ERRNO_CODES.EINVAL);
  return -1;
 }
 string = Pointer_stringify(string);
 var splitPoint = string.indexOf("=");
 if (string === "" || string.indexOf("=") === -1) {
  ___setErrNo(ERRNO_CODES.EINVAL);
  return -1;
 }
 var name = string.slice(0, splitPoint);
 var value = string.slice(splitPoint + 1);
 if (!(name in ENV) || ENV[name] !== value) {
  ENV[name] = value;
  ___buildEnvironment(ENV);
 }
 return 0;
}
Module["_putenv"] = _putenv;
function _SDL_RWFromConstMem(mem, size) {
 var id = SDL.rwops.length;
 SDL.rwops.push({
  bytes: mem,
  count: size
 });
 return id;
}
Module["_SDL_RWFromConstMem"] = _SDL_RWFromConstMem;
function _TTF_FontHeight(font) {
 var fontData = SDL.fonts[font];
 return fontData.size;
}
Module["_TTF_FontHeight"] = _TTF_FontHeight;
function _TTF_SizeText(font, text, w, h) {
 var fontData = SDL.fonts[font];
 if (w) {
  HEAP32[w >> 2] = SDL.estimateTextWidth(fontData, Pointer_stringify(text));
 }
 if (h) {
  HEAP32[h >> 2] = fontData.size;
 }
 return 0;
}
Module["_TTF_SizeText"] = _TTF_SizeText;
function _TTF_RenderText_Solid(font, text, color) {
 text = Pointer_stringify(text) || " ";
 var fontData = SDL.fonts[font];
 var w = SDL.estimateTextWidth(fontData, text);
 var h = fontData.size;
 var color = SDL.loadColorToCSSRGB(color);
 var fontString = h + "px " + fontData.name;
 var surf = SDL.makeSurface(w, h, 0, false, "text:" + text);
 var surfData = SDL.surfaces[surf];
 surfData.ctx.save();
 surfData.ctx.fillStyle = color;
 surfData.ctx.font = fontString;
 surfData.ctx.textBaseline = "top";
 surfData.ctx.fillText(text, 0, 0);
 surfData.ctx.restore();
 return surf;
}
Module["_TTF_RenderText_Solid"] = _TTF_RenderText_Solid;
function _Mix_HaltMusic() {
 var audio = SDL.music.audio;
 if (audio) {
  audio.src = audio.src;
  audio.currentPosition = 0;
  audio.pause();
 }
 SDL.music.audio = null;
 if (SDL.hookMusicFinished) {
  Runtime.dynCall("v", SDL.hookMusicFinished);
 }
 return 0;
}
Module["_Mix_HaltMusic"] = _Mix_HaltMusic;
function _Mix_PlayMusic(id, loops) {
 if (SDL.music.audio) {
  if (!SDL.music.audio.paused) Module.printErr("Music is already playing. " + SDL.music.source);
  SDL.music.audio.pause();
 }
 var info = SDL.audios[id];
 var audio;
 if (info.webAudio) {
  audio = {};
  audio.resource = info;
  audio.paused = false;
  audio.currentPosition = 0;
  audio.play = (function() {
   SDL.playWebAudio(this);
  });
  audio.pause = (function() {
   SDL.pauseWebAudio(this);
  });
 } else if (info.audio) {
  audio = info.audio;
 }
 audio["onended"] = (function() {
  if (SDL.music.audio == this) _Mix_HaltMusic();
 });
 audio.loop = loops != 0;
 audio.volume = SDL.music.volume;
 SDL.music.audio = audio;
 audio.play();
 return 0;
}
Module["_Mix_PlayMusic"] = _Mix_PlayMusic;
function _Mix_FreeChunk(id) {
 SDL.audios[id] = null;
}
Module["_Mix_FreeChunk"] = _Mix_FreeChunk;
function _Mix_LoadWAV_RW(rwopsID, freesrc) {
 var rwops = SDL.rwops[rwopsID];
 if (rwops === undefined) return 0;
 var filename = "";
 var audio;
 var webAudio;
 var bytes;
 if (rwops.filename !== undefined) {
  filename = PATH.resolve(rwops.filename);
  var raw = Module["preloadedAudios"][filename];
  if (!raw) {
   if (raw === null) Module.printErr("Trying to reuse preloaded audio, but freePreloadedMediaOnUse is set!");
   if (!Module.noAudioDecoding) Runtime.warnOnce("Cannot find preloaded audio " + filename);
   try {
    bytes = FS.readFile(filename);
   } catch (e) {
    Module.printErr("Couldn't find file for: " + filename);
    return 0;
   }
  }
  if (Module["freePreloadedMediaOnUse"]) {
   Module["preloadedAudios"][filename] = null;
  }
  audio = raw;
 } else if (rwops.bytes !== undefined) {
  if (SDL.webAudioAvailable()) bytes = HEAPU8.buffer.slice(rwops.bytes, rwops.bytes + rwops.count); else bytes = HEAPU8.subarray(rwops.bytes, rwops.bytes + rwops.count);
 } else {
  return 0;
 }
 var arrayBuffer = bytes ? bytes.buffer || bytes : bytes;
 var canPlayWithWebAudio = Module["SDL_canPlayWithWebAudio"] === undefined || Module["SDL_canPlayWithWebAudio"](filename, arrayBuffer);
 if (bytes !== undefined && SDL.webAudioAvailable() && canPlayWithWebAudio) {
  audio = undefined;
  webAudio = {};
  webAudio.onDecodeComplete = [];
  function onDecodeComplete(data) {
   webAudio.decodedBuffer = data;
   webAudio.onDecodeComplete.forEach((function(e) {
    e();
   }));
   webAudio.onDecodeComplete = undefined;
  }
  SDL.audioContext["decodeAudioData"](arrayBuffer, onDecodeComplete);
 } else if (audio === undefined && bytes) {
  var blob = new Blob([ bytes ], {
   type: rwops.mimetype
  });
  var url = URL.createObjectURL(blob);
  audio = new Audio;
  audio.src = url;
  audio.mozAudioChannelType = "content";
 }
 var id = SDL.audios.length;
 SDL.audios.push({
  source: filename,
  audio: audio,
  webAudio: webAudio
 });
 return id;
}
Module["_Mix_LoadWAV_RW"] = _Mix_LoadWAV_RW;
function _Mix_PlayChannel(channel, id, loops) {
 var info = SDL.audios[id];
 if (!info) return -1;
 if (!info.audio && !info.webAudio) return -1;
 if (channel == -1) {
  for (var i = SDL.channelMinimumNumber; i < SDL.numChannels; i++) {
   if (!SDL.channels[i].audio) {
    channel = i;
    break;
   }
  }
  if (channel == -1) {
   Module.printErr("All " + SDL.numChannels + " channels in use!");
   return -1;
  }
 }
 var channelInfo = SDL.channels[channel];
 var audio;
 if (info.webAudio) {
  audio = {};
  audio.resource = info;
  audio.paused = false;
  audio.currentPosition = 0;
  audio.play = (function() {
   SDL.playWebAudio(this);
  });
  audio.pause = (function() {
   SDL.pauseWebAudio(this);
  });
 } else {
  audio = info.audio.cloneNode(true);
  audio.numChannels = info.audio.numChannels;
  audio.frequency = info.audio.frequency;
 }
 audio["onended"] = function SDL_audio_onended() {
  if (channelInfo.audio == this) {
   channelInfo.audio.paused = true;
   channelInfo.audio = null;
  }
  if (SDL.channelFinished) Runtime.getFuncWrapper(SDL.channelFinished, "vi")(channel);
 };
 channelInfo.audio = audio;
 audio.loop = loops != 0;
 audio.volume = channelInfo.volume;
 audio.play();
 return channel;
}
Module["_Mix_PlayChannel"] = _Mix_PlayChannel;
function _SDL_PauseAudio(pauseOn) {
 if (!SDL.audio) {
  return;
 }
 if (pauseOn) {
  if (SDL.audio.timer !== undefined) {
   clearTimeout(SDL.audio.timer);
   SDL.audio.numAudioTimersPending = 0;
   SDL.audio.timer = undefined;
  }
 } else if (!SDL.audio.timer) {
  SDL.audio.numAudioTimersPending = 1;
  SDL.audio.timer = Browser.safeSetTimeout(SDL.audio.caller, 1);
 }
 SDL.audio.paused = pauseOn;
}
Module["_SDL_PauseAudio"] = _SDL_PauseAudio;
function _SDL_CloseAudio() {
 if (SDL.audio) {
  _SDL_PauseAudio(1);
  _free(SDL.audio.buffer);
  SDL.audio = null;
  SDL.allocateChannels(0);
 }
}
Module["_SDL_CloseAudio"] = _SDL_CloseAudio;
function _SDL_LockSurface(surf) {
 var surfData = SDL.surfaces[surf];
 surfData.locked++;
 if (surfData.locked > 1) return 0;
 if (!surfData.buffer) {
  surfData.buffer = _malloc(surfData.width * surfData.height * 4);
  HEAP32[surf + 20 >> 2] = surfData.buffer;
 }
 HEAP32[surf + 20 >> 2] = surfData.buffer;
 if (surf == SDL.screen && Module.screenIsReadOnly && surfData.image) return 0;
 if (SDL.defaults.discardOnLock) {
  if (!surfData.image) {
   surfData.image = surfData.ctx.createImageData(surfData.width, surfData.height);
  }
  if (!SDL.defaults.opaqueFrontBuffer) return;
 } else {
  surfData.image = surfData.ctx.getImageData(0, 0, surfData.width, surfData.height);
 }
 if (surf == SDL.screen && SDL.defaults.opaqueFrontBuffer) {
  var data = surfData.image.data;
  var num = data.length;
  for (var i = 0; i < num / 4; i++) {
   data[i * 4 + 3] = 255;
  }
 }
 if (SDL.defaults.copyOnLock && !SDL.defaults.discardOnLock) {
  if (surfData.isFlagSet(2097152)) {
   throw "CopyOnLock is not supported for SDL_LockSurface with SDL_HWPALETTE flag set" + (new Error).stack;
  } else {
   HEAPU8.set(surfData.image.data, surfData.buffer);
  }
 }
 return 0;
}
Module["_SDL_LockSurface"] = _SDL_LockSurface;
function _SDL_FreeRW(rwopsID) {
 SDL.rwops[rwopsID] = null;
 while (SDL.rwops.length > 0 && SDL.rwops[SDL.rwops.length - 1] === null) {
  SDL.rwops.pop();
 }
}
Module["_SDL_FreeRW"] = _SDL_FreeRW;
function _IMG_Load_RW(rwopsID, freeSrc) {
 try {
  function cleanup() {
   if (rwops && freeSrc) _SDL_FreeRW(rwopsID);
  }
  function addCleanup(func) {
   var old = cleanup;
   cleanup = function added_cleanup() {
    old();
    func();
   };
  }
  var rwops = SDL.rwops[rwopsID];
  if (rwops === undefined) {
   return 0;
  }
  var filename = rwops.filename;
  if (filename === undefined) {
   Runtime.warnOnce("Only file names that have been preloaded are supported for IMG_Load_RW. Consider using STB_IMAGE=1 if you want synchronous image decoding (see settings.js), or package files with --use-preload-plugins");
   return 0;
  }
  if (!raw) {
   filename = PATH.resolve(filename);
   var raw = Module["preloadedImages"][filename];
   if (!raw) {
    if (raw === null) Module.printErr("Trying to reuse preloaded image, but freePreloadedMediaOnUse is set!");
    Runtime.warnOnce("Cannot find preloaded image " + filename);
    Runtime.warnOnce("Cannot find preloaded image " + filename + ". Consider using STB_IMAGE=1 if you want synchronous image decoding (see settings.js), or package files with --use-preload-plugins");
    return 0;
   } else if (Module["freePreloadedMediaOnUse"]) {
    Module["preloadedImages"][filename] = null;
   }
  }
  var surf = SDL.makeSurface(raw.width, raw.height, 0, false, "load:" + filename);
  var surfData = SDL.surfaces[surf];
  surfData.ctx.globalCompositeOperation = "copy";
  if (!raw.rawData) {
   surfData.ctx.drawImage(raw, 0, 0, raw.width, raw.height, 0, 0, raw.width, raw.height);
  } else {
   var imageData = surfData.ctx.getImageData(0, 0, surfData.width, surfData.height);
   if (raw.bpp == 4) {
    imageData.data.set(HEAPU8.subarray(raw.data, raw.data + raw.size));
   } else if (raw.bpp == 3) {
    var pixels = raw.size / 3;
    var data = imageData.data;
    var sourcePtr = raw.data;
    var destPtr = 0;
    for (var i = 0; i < pixels; i++) {
     data[destPtr++] = HEAPU8[sourcePtr++ >> 0];
     data[destPtr++] = HEAPU8[sourcePtr++ >> 0];
     data[destPtr++] = HEAPU8[sourcePtr++ >> 0];
     data[destPtr++] = 255;
    }
   } else if (raw.bpp == 1) {
    var pixels = raw.size;
    var data = imageData.data;
    var sourcePtr = raw.data;
    var destPtr = 0;
    for (var i = 0; i < pixels; i++) {
     var value = HEAPU8[sourcePtr++ >> 0];
     data[destPtr++] = value;
     data[destPtr++] = value;
     data[destPtr++] = value;
     data[destPtr++] = 255;
    }
   } else {
    Module.printErr("cannot handle bpp " + raw.bpp);
    return 0;
   }
   surfData.ctx.putImageData(imageData, 0, 0);
  }
  surfData.ctx.globalCompositeOperation = "source-over";
  _SDL_LockSurface(surf);
  surfData.locked--;
  if (SDL.GL) {
   surfData.canvas = surfData.ctx = null;
  }
  return surf;
 } finally {
  cleanup();
 }
}
Module["_IMG_Load_RW"] = _IMG_Load_RW;
function _SDL_RWFromFile(_name, mode) {
 var id = SDL.rwops.length;
 var name = Pointer_stringify(_name);
 SDL.rwops.push({
  filename: name,
  mimetype: Browser.getMimetype(name)
 });
 return id;
}
Module["_SDL_RWFromFile"] = _SDL_RWFromFile;
function _IMG_Load(filename) {
 var rwops = _SDL_RWFromFile(filename);
 var result = _IMG_Load_RW(rwops, 1);
 return result;
}
Module["_IMG_Load"] = _IMG_Load;
function _SDL_UpperBlitScaled(src, srcrect, dst, dstrect) {
 return SDL.blitSurface(src, srcrect, dst, dstrect, true);
}
Module["_SDL_UpperBlitScaled"] = _SDL_UpperBlitScaled;
function _SDL_UpperBlit(src, srcrect, dst, dstrect) {
 return SDL.blitSurface(src, srcrect, dst, dstrect, false);
}
Module["_SDL_UpperBlit"] = _SDL_UpperBlit;
function _SDL_GetTicks() {
 return Date.now() - SDL.startTime | 0;
}
Module["_SDL_GetTicks"] = _SDL_GetTicks;
var SDL = {
 defaults: {
  width: 320,
  height: 200,
  copyOnLock: true,
  discardOnLock: false,
  opaqueFrontBuffer: true
 },
 version: null,
 surfaces: {},
 canvasPool: [],
 events: [],
 fonts: [ null ],
 audios: [ null ],
 rwops: [ null ],
 music: {
  audio: null,
  volume: 1
 },
 mixerFrequency: 22050,
 mixerFormat: 32784,
 mixerNumChannels: 2,
 mixerChunkSize: 1024,
 channelMinimumNumber: 0,
 GL: false,
 glAttributes: {
  0: 3,
  1: 3,
  2: 2,
  3: 0,
  4: 0,
  5: 1,
  6: 16,
  7: 0,
  8: 0,
  9: 0,
  10: 0,
  11: 0,
  12: 0,
  13: 0,
  14: 0,
  15: 1,
  16: 0,
  17: 0,
  18: 0
 },
 keyboardState: null,
 keyboardMap: {},
 canRequestFullscreen: false,
 isRequestingFullscreen: false,
 textInput: false,
 startTime: null,
 initFlags: 0,
 buttonState: 0,
 modState: 0,
 DOMButtons: [ 0, 0, 0 ],
 DOMEventToSDLEvent: {},
 TOUCH_DEFAULT_ID: 0,
 eventHandler: null,
 eventHandlerContext: null,
 eventHandlerTemp: 0,
 keyCodes: {
  16: 1249,
  17: 1248,
  18: 1250,
  20: 1081,
  33: 1099,
  34: 1102,
  35: 1101,
  36: 1098,
  37: 1104,
  38: 1106,
  39: 1103,
  40: 1105,
  44: 316,
  45: 1097,
  46: 127,
  91: 1251,
  93: 1125,
  96: 1122,
  97: 1113,
  98: 1114,
  99: 1115,
  100: 1116,
  101: 1117,
  102: 1118,
  103: 1119,
  104: 1120,
  105: 1121,
  106: 1109,
  107: 1111,
  109: 1110,
  110: 1123,
  111: 1108,
  112: 1082,
  113: 1083,
  114: 1084,
  115: 1085,
  116: 1086,
  117: 1087,
  118: 1088,
  119: 1089,
  120: 1090,
  121: 1091,
  122: 1092,
  123: 1093,
  124: 1128,
  125: 1129,
  126: 1130,
  127: 1131,
  128: 1132,
  129: 1133,
  130: 1134,
  131: 1135,
  132: 1136,
  133: 1137,
  134: 1138,
  135: 1139,
  144: 1107,
  160: 94,
  161: 33,
  162: 34,
  163: 35,
  164: 36,
  165: 37,
  166: 38,
  167: 95,
  168: 40,
  169: 41,
  170: 42,
  171: 43,
  172: 124,
  173: 45,
  174: 123,
  175: 125,
  176: 126,
  181: 127,
  182: 129,
  183: 128,
  188: 44,
  190: 46,
  191: 47,
  192: 96,
  219: 91,
  220: 92,
  221: 93,
  222: 39,
  224: 1251
 },
 scanCodes: {
  8: 42,
  9: 43,
  13: 40,
  27: 41,
  32: 44,
  35: 204,
  39: 53,
  44: 54,
  46: 55,
  47: 56,
  48: 39,
  49: 30,
  50: 31,
  51: 32,
  52: 33,
  53: 34,
  54: 35,
  55: 36,
  56: 37,
  57: 38,
  58: 203,
  59: 51,
  61: 46,
  91: 47,
  92: 49,
  93: 48,
  96: 52,
  97: 4,
  98: 5,
  99: 6,
  100: 7,
  101: 8,
  102: 9,
  103: 10,
  104: 11,
  105: 12,
  106: 13,
  107: 14,
  108: 15,
  109: 16,
  110: 17,
  111: 18,
  112: 19,
  113: 20,
  114: 21,
  115: 22,
  116: 23,
  117: 24,
  118: 25,
  119: 26,
  120: 27,
  121: 28,
  122: 29,
  127: 76,
  305: 224,
  308: 226,
  316: 70
 },
 loadRect: (function(rect) {
  return {
   x: HEAP32[rect + 0 >> 2],
   y: HEAP32[rect + 4 >> 2],
   w: HEAP32[rect + 8 >> 2],
   h: HEAP32[rect + 12 >> 2]
  };
 }),
 updateRect: (function(rect, r) {
  HEAP32[rect >> 2] = r.x;
  HEAP32[rect + 4 >> 2] = r.y;
  HEAP32[rect + 8 >> 2] = r.w;
  HEAP32[rect + 12 >> 2] = r.h;
 }),
 intersectionOfRects: (function(first, second) {
  var leftX = Math.max(first.x, second.x);
  var leftY = Math.max(first.y, second.y);
  var rightX = Math.min(first.x + first.w, second.x + second.w);
  var rightY = Math.min(first.y + first.h, second.y + second.h);
  return {
   x: leftX,
   y: leftY,
   w: Math.max(leftX, rightX) - leftX,
   h: Math.max(leftY, rightY) - leftY
  };
 }),
 checkPixelFormat: (function(fmt) {
  var format = HEAP32[fmt >> 2];
  if (format != -2042224636) {
   Runtime.warnOnce("Unsupported pixel format!");
  }
 }),
 loadColorToCSSRGB: (function(color) {
  var rgba = HEAP32[color >> 2];
  return "rgb(" + (rgba & 255) + "," + (rgba >> 8 & 255) + "," + (rgba >> 16 & 255) + ")";
 }),
 loadColorToCSSRGBA: (function(color) {
  var rgba = HEAP32[color >> 2];
  return "rgba(" + (rgba & 255) + "," + (rgba >> 8 & 255) + "," + (rgba >> 16 & 255) + "," + (rgba >> 24 & 255) / 255 + ")";
 }),
 translateColorToCSSRGBA: (function(rgba) {
  return "rgba(" + (rgba & 255) + "," + (rgba >> 8 & 255) + "," + (rgba >> 16 & 255) + "," + (rgba >>> 24) / 255 + ")";
 }),
 translateRGBAToCSSRGBA: (function(r, g, b, a) {
  return "rgba(" + (r & 255) + "," + (g & 255) + "," + (b & 255) + "," + (a & 255) / 255 + ")";
 }),
 translateRGBAToColor: (function(r, g, b, a) {
  return r | g << 8 | b << 16 | a << 24;
 }),
 makeSurface: (function(width, height, flags, usePageCanvas, source, rmask, gmask, bmask, amask) {
  flags = flags || 0;
  var is_SDL_HWSURFACE = flags & 1;
  var is_SDL_HWPALETTE = flags & 2097152;
  var is_SDL_OPENGL = flags & 67108864;
  var surf = _malloc(60);
  var pixelFormat = _malloc(44);
  var bpp = is_SDL_HWPALETTE ? 1 : 4;
  var buffer = 0;
  if (!is_SDL_HWSURFACE && !is_SDL_OPENGL) {
   buffer = _malloc(width * height * 4);
  }
  HEAP32[surf >> 2] = flags;
  HEAP32[surf + 4 >> 2] = pixelFormat;
  HEAP32[surf + 8 >> 2] = width;
  HEAP32[surf + 12 >> 2] = height;
  HEAP32[surf + 16 >> 2] = width * bpp;
  HEAP32[surf + 20 >> 2] = buffer;
  HEAP32[surf + 36 >> 2] = 0;
  HEAP32[surf + 40 >> 2] = 0;
  HEAP32[surf + 44 >> 2] = Module["canvas"].width;
  HEAP32[surf + 48 >> 2] = Module["canvas"].height;
  HEAP32[surf + 56 >> 2] = 1;
  HEAP32[pixelFormat >> 2] = -2042224636;
  HEAP32[pixelFormat + 4 >> 2] = 0;
  HEAP8[pixelFormat + 8 >> 0] = bpp * 8;
  HEAP8[pixelFormat + 9 >> 0] = bpp;
  HEAP32[pixelFormat + 12 >> 2] = rmask || 255;
  HEAP32[pixelFormat + 16 >> 2] = gmask || 65280;
  HEAP32[pixelFormat + 20 >> 2] = bmask || 16711680;
  HEAP32[pixelFormat + 24 >> 2] = amask || 4278190080;
  SDL.GL = SDL.GL || is_SDL_OPENGL;
  var canvas;
  if (!usePageCanvas) {
   if (SDL.canvasPool.length > 0) {
    canvas = SDL.canvasPool.pop();
   } else {
    canvas = document.createElement("canvas");
   }
   canvas.width = width;
   canvas.height = height;
  } else {
   canvas = Module["canvas"];
  }
  var webGLContextAttributes = {
   antialias: SDL.glAttributes[13] != 0 && SDL.glAttributes[14] > 1,
   depth: SDL.glAttributes[6] > 0,
   stencil: SDL.glAttributes[7] > 0,
   alpha: SDL.glAttributes[3] > 0
  };
  var ctx = Browser.createContext(canvas, is_SDL_OPENGL, usePageCanvas, webGLContextAttributes);
  SDL.surfaces[surf] = {
   width: width,
   height: height,
   canvas: canvas,
   ctx: ctx,
   surf: surf,
   buffer: buffer,
   pixelFormat: pixelFormat,
   alpha: 255,
   flags: flags,
   locked: 0,
   usePageCanvas: usePageCanvas,
   source: source,
   isFlagSet: (function(flag) {
    return flags & flag;
   })
  };
  return surf;
 }),
 copyIndexedColorData: (function(surfData, rX, rY, rW, rH) {
  if (!surfData.colors) {
   return;
  }
  var fullWidth = Module["canvas"].width;
  var fullHeight = Module["canvas"].height;
  var startX = rX || 0;
  var startY = rY || 0;
  var endX = (rW || fullWidth - startX) + startX;
  var endY = (rH || fullHeight - startY) + startY;
  var buffer = surfData.buffer;
  if (!surfData.image.data32) {
   surfData.image.data32 = new Uint32Array(surfData.image.data.buffer);
  }
  var data32 = surfData.image.data32;
  var colors32 = surfData.colors32;
  for (var y = startY; y < endY; ++y) {
   var base = y * fullWidth;
   for (var x = startX; x < endX; ++x) {
    data32[base + x] = colors32[HEAPU8[buffer + base + x >> 0]];
   }
  }
 }),
 freeSurface: (function(surf) {
  var refcountPointer = surf + 56;
  var refcount = HEAP32[refcountPointer >> 2];
  if (refcount > 1) {
   HEAP32[refcountPointer >> 2] = refcount - 1;
   return;
  }
  var info = SDL.surfaces[surf];
  if (!info.usePageCanvas && info.canvas) SDL.canvasPool.push(info.canvas);
  if (info.buffer) _free(info.buffer);
  _free(info.pixelFormat);
  _free(surf);
  SDL.surfaces[surf] = null;
  if (surf === SDL.screen) {
   SDL.screen = null;
  }
 }),
 blitSurface__deps: [ "SDL_LockSurface" ],
 blitSurface: (function(src, srcrect, dst, dstrect, scale) {
  var srcData = SDL.surfaces[src];
  var dstData = SDL.surfaces[dst];
  var sr, dr;
  if (srcrect) {
   sr = SDL.loadRect(srcrect);
  } else {
   sr = {
    x: 0,
    y: 0,
    w: srcData.width,
    h: srcData.height
   };
  }
  if (dstrect) {
   dr = SDL.loadRect(dstrect);
  } else {
   dr = {
    x: 0,
    y: 0,
    w: srcData.width,
    h: srcData.height
   };
  }
  if (dstData.clipRect) {
   var widthScale = !scale || sr.w === 0 ? 1 : sr.w / dr.w;
   var heightScale = !scale || sr.h === 0 ? 1 : sr.h / dr.h;
   dr = SDL.intersectionOfRects(dstData.clipRect, dr);
   sr.w = dr.w * widthScale;
   sr.h = dr.h * heightScale;
   if (dstrect) {
    SDL.updateRect(dstrect, dr);
   }
  }
  var blitw, blith;
  if (scale) {
   blitw = dr.w;
   blith = dr.h;
  } else {
   blitw = sr.w;
   blith = sr.h;
  }
  if (sr.w === 0 || sr.h === 0 || blitw === 0 || blith === 0) {
   return 0;
  }
  var oldAlpha = dstData.ctx.globalAlpha;
  dstData.ctx.globalAlpha = srcData.alpha / 255;
  dstData.ctx.drawImage(srcData.canvas, sr.x, sr.y, sr.w, sr.h, dr.x, dr.y, blitw, blith);
  dstData.ctx.globalAlpha = oldAlpha;
  if (dst != SDL.screen) {
   Runtime.warnOnce("WARNING: copying canvas data to memory for compatibility");
   _SDL_LockSurface(dst);
   dstData.locked--;
  }
  return 0;
 }),
 downFingers: {},
 savedKeydown: null,
 receiveEvent: (function(event) {
  function unpressAllPressedKeys() {
   for (var code in SDL.keyboardMap) {
    SDL.events.push({
     type: "keyup",
     keyCode: SDL.keyboardMap[code]
    });
   }
  }
  switch (event.type) {
  case "touchstart":
  case "touchmove":
   {
    event.preventDefault();
    var touches = [];
    if (event.type === "touchstart") {
     for (var i = 0; i < event.touches.length; i++) {
      var touch = event.touches[i];
      if (SDL.downFingers[touch.identifier] != true) {
       SDL.downFingers[touch.identifier] = true;
       touches.push(touch);
      }
     }
    } else {
     touches = event.touches;
    }
    var firstTouch = touches[0];
    if (event.type == "touchstart") {
     SDL.DOMButtons[0] = 1;
    }
    var mouseEventType;
    switch (event.type) {
    case "touchstart":
     mouseEventType = "mousedown";
     break;
    case "touchmove":
     mouseEventType = "mousemove";
     break;
    }
    var mouseEvent = {
     type: mouseEventType,
     button: 0,
     pageX: firstTouch.clientX,
     pageY: firstTouch.clientY
    };
    SDL.events.push(mouseEvent);
    for (var i = 0; i < touches.length; i++) {
     var touch = touches[i];
     SDL.events.push({
      type: event.type,
      touch: touch
     });
    }
    break;
   }
  case "touchend":
   {
    event.preventDefault();
    for (var i = 0; i < event.changedTouches.length; i++) {
     var touch = event.changedTouches[i];
     if (SDL.downFingers[touch.identifier] === true) {
      delete SDL.downFingers[touch.identifier];
     }
    }
    var mouseEvent = {
     type: "mouseup",
     button: 0,
     pageX: event.changedTouches[0].clientX,
     pageY: event.changedTouches[0].clientY
    };
    SDL.DOMButtons[0] = 0;
    SDL.events.push(mouseEvent);
    for (var i = 0; i < event.changedTouches.length; i++) {
     var touch = event.changedTouches[i];
     SDL.events.push({
      type: "touchend",
      touch: touch
     });
    }
    break;
   }
  case "DOMMouseScroll":
  case "mousewheel":
  case "wheel":
   var delta = -Browser.getMouseWheelDelta(event);
   delta = delta == 0 ? 0 : delta > 0 ? Math.max(delta, 1) : Math.min(delta, -1);
   var button = delta > 0 ? 3 : 4;
   SDL.events.push({
    type: "mousedown",
    button: button,
    pageX: event.pageX,
    pageY: event.pageY
   });
   SDL.events.push({
    type: "mouseup",
    button: button,
    pageX: event.pageX,
    pageY: event.pageY
   });
   SDL.events.push({
    type: "wheel",
    deltaX: 0,
    deltaY: delta
   });
   event.preventDefault();
   break;
  case "mousemove":
   if (SDL.DOMButtons[0] === 1) {
    SDL.events.push({
     type: "touchmove",
     touch: {
      identifier: 0,
      deviceID: -1,
      pageX: event.pageX,
      pageY: event.pageY
     }
    });
   }
   if (Browser.pointerLock) {
    if ("mozMovementX" in event) {
     event["movementX"] = event["mozMovementX"];
     event["movementY"] = event["mozMovementY"];
    }
    if (event["movementX"] == 0 && event["movementY"] == 0) {
     event.preventDefault();
     return;
    }
   }
  case "keydown":
  case "keyup":
  case "keypress":
  case "mousedown":
  case "mouseup":
   if (event.type !== "keydown" || !SDL.unicode && !SDL.textInput || event.keyCode === 8 || event.keyCode === 9) {
    event.preventDefault();
   }
   if (event.type == "mousedown") {
    SDL.DOMButtons[event.button] = 1;
    SDL.events.push({
     type: "touchstart",
     touch: {
      identifier: 0,
      deviceID: -1,
      pageX: event.pageX,
      pageY: event.pageY
     }
    });
   } else if (event.type == "mouseup") {
    if (!SDL.DOMButtons[event.button]) {
     return;
    }
    SDL.events.push({
     type: "touchend",
     touch: {
      identifier: 0,
      deviceID: -1,
      pageX: event.pageX,
      pageY: event.pageY
     }
    });
    SDL.DOMButtons[event.button] = 0;
   }
   if (event.type === "keydown" || event.type === "mousedown") {
    SDL.canRequestFullscreen = true;
   } else if (event.type === "keyup" || event.type === "mouseup") {
    if (SDL.isRequestingFullscreen) {
     Module["requestFullscreen"](true, true);
     SDL.isRequestingFullscreen = false;
    }
    SDL.canRequestFullscreen = false;
   }
   if (event.type === "keypress" && SDL.savedKeydown) {
    SDL.savedKeydown.keypressCharCode = event.charCode;
    SDL.savedKeydown = null;
   } else if (event.type === "keydown") {
    SDL.savedKeydown = event;
   }
   if (event.type !== "keypress" || SDL.textInput) {
    SDL.events.push(event);
   }
   break;
  case "mouseout":
   for (var i = 0; i < 3; i++) {
    if (SDL.DOMButtons[i]) {
     SDL.events.push({
      type: "mouseup",
      button: i,
      pageX: event.pageX,
      pageY: event.pageY
     });
     SDL.DOMButtons[i] = 0;
    }
   }
   event.preventDefault();
   break;
  case "focus":
   SDL.events.push(event);
   event.preventDefault();
   break;
  case "blur":
   SDL.events.push(event);
   unpressAllPressedKeys();
   event.preventDefault();
   break;
  case "visibilitychange":
   SDL.events.push({
    type: "visibilitychange",
    visible: !document.hidden
   });
   unpressAllPressedKeys();
   event.preventDefault();
   break;
  case "unload":
   if (Browser.mainLoop.runner) {
    SDL.events.push(event);
    Browser.mainLoop.runner();
   }
   return;
  case "resize":
   SDL.events.push(event);
   if (event.preventDefault) {
    event.preventDefault();
   }
   break;
  }
  if (SDL.events.length >= 1e4) {
   Module.printErr("SDL event queue full, dropping events");
   SDL.events = SDL.events.slice(0, 1e4);
  }
  SDL.flushEventsToHandler();
  return;
 }),
 lookupKeyCodeForEvent: (function(event) {
  var code = event.keyCode;
  if (code >= 65 && code <= 90) {
   code += 32;
  } else {
   code = SDL.keyCodes[event.keyCode] || event.keyCode;
   if (event.location === KeyboardEvent.DOM_KEY_LOCATION_RIGHT && code >= (224 | 1 << 10) && code <= (227 | 1 << 10)) {
    code += 4;
   }
  }
  return code;
 }),
 handleEvent: (function(event) {
  if (event.handled) return;
  event.handled = true;
  switch (event.type) {
  case "touchstart":
  case "touchend":
  case "touchmove":
   {
    Browser.calculateMouseEvent(event);
    break;
   }
  case "keydown":
  case "keyup":
   {
    var down = event.type === "keydown";
    var code = SDL.lookupKeyCodeForEvent(event);
    HEAP8[SDL.keyboardState + code >> 0] = down;
    SDL.modState = (HEAP8[SDL.keyboardState + 1248 >> 0] ? 64 : 0) | (HEAP8[SDL.keyboardState + 1249 >> 0] ? 1 : 0) | (HEAP8[SDL.keyboardState + 1250 >> 0] ? 256 : 0) | (HEAP8[SDL.keyboardState + 1252 >> 0] ? 128 : 0) | (HEAP8[SDL.keyboardState + 1253 >> 0] ? 2 : 0) | (HEAP8[SDL.keyboardState + 1254 >> 0] ? 512 : 0);
    if (down) {
     SDL.keyboardMap[code] = event.keyCode;
    } else {
     delete SDL.keyboardMap[code];
    }
    break;
   }
  case "mousedown":
  case "mouseup":
   if (event.type == "mousedown") {
    SDL.buttonState |= 1 << event.button;
   } else if (event.type == "mouseup") {
    SDL.buttonState &= ~(1 << event.button);
   }
  case "mousemove":
   {
    Browser.calculateMouseEvent(event);
    break;
   }
  }
 }),
 flushEventsToHandler: (function() {
  if (!SDL.eventHandler) return;
  while (SDL.pollEvent(SDL.eventHandlerTemp)) {
   Runtime.dynCall("iii", SDL.eventHandler, [ SDL.eventHandlerContext, SDL.eventHandlerTemp ]);
  }
 }),
 pollEvent: (function(ptr) {
  if (SDL.initFlags & 512 && SDL.joystickEventState) {
   SDL.queryJoysticks();
  }
  if (ptr) {
   while (SDL.events.length > 0) {
    if (SDL.makeCEvent(SDL.events.shift(), ptr) !== false) return 1;
   }
   return 0;
  } else {
   return SDL.events.length > 0;
  }
 }),
 makeCEvent: (function(event, ptr) {
  if (typeof event === "number") {
   _memcpy(ptr, event, 28);
   _free(event);
   return;
  }
  SDL.handleEvent(event);
  switch (event.type) {
  case "keydown":
  case "keyup":
   {
    var down = event.type === "keydown";
    var key = SDL.lookupKeyCodeForEvent(event);
    var scan;
    if (key >= 1024) {
     scan = key - 1024;
    } else {
     scan = SDL.scanCodes[key] || key;
    }
    HEAP32[ptr >> 2] = SDL.DOMEventToSDLEvent[event.type];
    HEAP8[ptr + 8 >> 0] = down ? 1 : 0;
    HEAP8[ptr + 9 >> 0] = 0;
    HEAP32[ptr + 12 >> 2] = scan;
    HEAP32[ptr + 16 >> 2] = key;
    HEAP16[ptr + 20 >> 1] = SDL.modState;
    HEAP32[ptr + 24 >> 2] = event.keypressCharCode || key;
    break;
   }
  case "keypress":
   {
    HEAP32[ptr >> 2] = SDL.DOMEventToSDLEvent[event.type];
    var cStr = intArrayFromString(String.fromCharCode(event.charCode));
    for (var i = 0; i < cStr.length; ++i) {
     HEAP8[ptr + (8 + i) >> 0] = cStr[i];
    }
    break;
   }
  case "mousedown":
  case "mouseup":
  case "mousemove":
   {
    if (event.type != "mousemove") {
     var down = event.type === "mousedown";
     HEAP32[ptr >> 2] = SDL.DOMEventToSDLEvent[event.type];
     HEAP32[ptr + 4 >> 2] = 0;
     HEAP32[ptr + 8 >> 2] = 0;
     HEAP32[ptr + 12 >> 2] = 0;
     HEAP8[ptr + 16 >> 0] = event.button + 1;
     HEAP8[ptr + 17 >> 0] = down ? 1 : 0;
     HEAP32[ptr + 20 >> 2] = Browser.mouseX;
     HEAP32[ptr + 24 >> 2] = Browser.mouseY;
    } else {
     HEAP32[ptr >> 2] = SDL.DOMEventToSDLEvent[event.type];
     HEAP32[ptr + 4 >> 2] = 0;
     HEAP32[ptr + 8 >> 2] = 0;
     HEAP32[ptr + 12 >> 2] = 0;
     HEAP32[ptr + 16 >> 2] = SDL.buttonState;
     HEAP32[ptr + 20 >> 2] = Browser.mouseX;
     HEAP32[ptr + 24 >> 2] = Browser.mouseY;
     HEAP32[ptr + 28 >> 2] = Browser.mouseMovementX;
     HEAP32[ptr + 32 >> 2] = Browser.mouseMovementY;
    }
    break;
   }
  case "wheel":
   {
    HEAP32[ptr >> 2] = SDL.DOMEventToSDLEvent[event.type];
    HEAP32[ptr + 16 >> 2] = event.deltaX;
    HEAP32[ptr + 20 >> 2] = event.deltaY;
    break;
   }
  case "touchstart":
  case "touchend":
  case "touchmove":
   {
    var touch = event.touch;
    if (!Browser.touches[touch.identifier]) break;
    var w = Module["canvas"].width;
    var h = Module["canvas"].height;
    var x = Browser.touches[touch.identifier].x / w;
    var y = Browser.touches[touch.identifier].y / h;
    var lx = Browser.lastTouches[touch.identifier].x / w;
    var ly = Browser.lastTouches[touch.identifier].y / h;
    var dx = x - lx;
    var dy = y - ly;
    if (touch["deviceID"] === undefined) touch.deviceID = SDL.TOUCH_DEFAULT_ID;
    if (dx === 0 && dy === 0 && event.type === "touchmove") return false;
    HEAP32[ptr >> 2] = SDL.DOMEventToSDLEvent[event.type];
    HEAP32[ptr + 4 >> 2] = _SDL_GetTicks();
    tempI64 = [ touch.deviceID >>> 0, (tempDouble = touch.deviceID, +Math_abs(tempDouble) >= +1 ? tempDouble > +0 ? (Math_min(+Math_floor(tempDouble / +4294967296), +4294967295) | 0) >>> 0 : ~~+Math_ceil((tempDouble - +(~~tempDouble >>> 0)) / +4294967296) >>> 0 : 0) ], HEAP32[ptr + 8 >> 2] = tempI64[0], HEAP32[ptr + 12 >> 2] = tempI64[1];
    tempI64 = [ touch.identifier >>> 0, (tempDouble = touch.identifier, +Math_abs(tempDouble) >= +1 ? tempDouble > +0 ? (Math_min(+Math_floor(tempDouble / +4294967296), +4294967295) | 0) >>> 0 : ~~+Math_ceil((tempDouble - +(~~tempDouble >>> 0)) / +4294967296) >>> 0 : 0) ], HEAP32[ptr + 16 >> 2] = tempI64[0], HEAP32[ptr + 20 >> 2] = tempI64[1];
    HEAPF32[ptr + 24 >> 2] = x;
    HEAPF32[ptr + 28 >> 2] = y;
    HEAPF32[ptr + 32 >> 2] = dx;
    HEAPF32[ptr + 36 >> 2] = dy;
    if (touch.force !== undefined) {
     HEAPF32[ptr + 40 >> 2] = touch.force;
    } else {
     HEAPF32[ptr + 40 >> 2] = event.type == "touchend" ? 0 : 1;
    }
    break;
   }
  case "unload":
   {
    HEAP32[ptr >> 2] = SDL.DOMEventToSDLEvent[event.type];
    break;
   }
  case "resize":
   {
    HEAP32[ptr >> 2] = SDL.DOMEventToSDLEvent[event.type];
    HEAP32[ptr + 4 >> 2] = event.w;
    HEAP32[ptr + 8 >> 2] = event.h;
    break;
   }
  case "joystick_button_up":
  case "joystick_button_down":
   {
    var state = event.type === "joystick_button_up" ? 0 : 1;
    HEAP32[ptr >> 2] = SDL.DOMEventToSDLEvent[event.type];
    HEAP8[ptr + 4 >> 0] = event.index;
    HEAP8[ptr + 5 >> 0] = event.button;
    HEAP8[ptr + 6 >> 0] = state;
    break;
   }
  case "joystick_axis_motion":
   {
    HEAP32[ptr >> 2] = SDL.DOMEventToSDLEvent[event.type];
    HEAP8[ptr + 4 >> 0] = event.index;
    HEAP8[ptr + 5 >> 0] = event.axis;
    HEAP32[ptr + 8 >> 2] = SDL.joystickAxisValueConversion(event.value);
    break;
   }
  case "focus":
   {
    var SDL_WINDOWEVENT_FOCUS_GAINED = 12;
    HEAP32[ptr >> 2] = SDL.DOMEventToSDLEvent[event.type];
    HEAP32[ptr + 4 >> 2] = 0;
    HEAP8[ptr + 8 >> 0] = SDL_WINDOWEVENT_FOCUS_GAINED;
    break;
   }
  case "blur":
   {
    var SDL_WINDOWEVENT_FOCUS_LOST = 13;
    HEAP32[ptr >> 2] = SDL.DOMEventToSDLEvent[event.type];
    HEAP32[ptr + 4 >> 2] = 0;
    HEAP8[ptr + 8 >> 0] = SDL_WINDOWEVENT_FOCUS_LOST;
    break;
   }
  case "visibilitychange":
   {
    var SDL_WINDOWEVENT_SHOWN = 1;
    var SDL_WINDOWEVENT_HIDDEN = 2;
    var visibilityEventID = event.visible ? SDL_WINDOWEVENT_SHOWN : SDL_WINDOWEVENT_HIDDEN;
    HEAP32[ptr >> 2] = SDL.DOMEventToSDLEvent[event.type];
    HEAP32[ptr + 4 >> 2] = 0;
    HEAP8[ptr + 8 >> 0] = visibilityEventID;
    break;
   }
  default:
   throw "Unhandled SDL event: " + event.type;
  }
 }),
 estimateTextWidth: (function(fontData, text) {
  var h = fontData.size;
  var fontString = h + "px " + fontData.name;
  var tempCtx = SDL.ttfContext;
  assert(tempCtx, "TTF_Init must have been called");
  tempCtx.save();
  tempCtx.font = fontString;
  var ret = tempCtx.measureText(text).width | 0;
  tempCtx.restore();
  return ret;
 }),
 allocateChannels: (function(num) {
  if (SDL.numChannels && SDL.numChannels >= num && num != 0) return;
  SDL.numChannels = num;
  SDL.channels = [];
  for (var i = 0; i < num; i++) {
   SDL.channels[i] = {
    audio: null,
    volume: 1
   };
  }
 }),
 setGetVolume: (function(info, volume) {
  if (!info) return 0;
  var ret = info.volume * 128;
  if (volume != -1) {
   info.volume = Math.min(Math.max(volume, 0), 128) / 128;
   if (info.audio) {
    try {
     info.audio.volume = info.volume;
     if (info.audio.webAudioGainNode) info.audio.webAudioGainNode["gain"]["value"] = info.volume;
    } catch (e) {
     Module.printErr("setGetVolume failed to set audio volume: " + e);
    }
   }
  }
  return ret;
 }),
 setPannerPosition: (function(info, x, y, z) {
  if (!info) return;
  if (info.audio) {
   if (info.audio.webAudioPannerNode) {
    info.audio.webAudioPannerNode["setPosition"](x, y, z);
   }
  }
 }),
 playWebAudio: (function(audio) {
  if (!audio) return;
  if (audio.webAudioNode) return;
  if (!SDL.webAudioAvailable()) return;
  try {
   var webAudio = audio.resource.webAudio;
   audio.paused = false;
   if (!webAudio.decodedBuffer) {
    if (webAudio.onDecodeComplete === undefined) abort("Cannot play back audio object that was not loaded");
    webAudio.onDecodeComplete.push((function() {
     if (!audio.paused) SDL.playWebAudio(audio);
    }));
    return;
   }
   audio.webAudioNode = SDL.audioContext["createBufferSource"]();
   audio.webAudioNode["buffer"] = webAudio.decodedBuffer;
   audio.webAudioNode["loop"] = audio.loop;
   audio.webAudioNode["onended"] = (function() {
    audio["onended"]();
   });
   audio.webAudioPannerNode = SDL.audioContext["createPanner"]();
   audio.webAudioPannerNode["panningModel"] = "equalpower";
   audio.webAudioGainNode = SDL.audioContext["createGain"]();
   audio.webAudioGainNode["gain"]["value"] = audio.volume;
   audio.webAudioNode["connect"](audio.webAudioPannerNode);
   audio.webAudioPannerNode["connect"](audio.webAudioGainNode);
   audio.webAudioGainNode["connect"](SDL.audioContext["destination"]);
   audio.webAudioNode["start"](0, audio.currentPosition);
   audio.startTime = SDL.audioContext["currentTime"] - audio.currentPosition;
  } catch (e) {
   Module.printErr("playWebAudio failed: " + e);
  }
 }),
 pauseWebAudio: (function(audio) {
  if (!audio) return;
  if (audio.webAudioNode) {
   try {
    audio.currentPosition = (SDL.audioContext["currentTime"] - audio.startTime) % audio.resource.webAudio.decodedBuffer.duration;
    audio.webAudioNode["onended"] = undefined;
    audio.webAudioNode.stop(0);
    audio.webAudioNode = undefined;
   } catch (e) {
    Module.printErr("pauseWebAudio failed: " + e);
   }
  }
  audio.paused = true;
 }),
 openAudioContext: (function() {
  if (!SDL.audioContext) {
   if (typeof AudioContext !== "undefined") SDL.audioContext = new AudioContext; else if (typeof webkitAudioContext !== "undefined") SDL.audioContext = new webkitAudioContext;
  }
 }),
 webAudioAvailable: (function() {
  return !!SDL.audioContext;
 }),
 fillWebAudioBufferFromHeap: (function(heapPtr, sizeSamplesPerChannel, dstAudioBuffer) {
  var numChannels = SDL.audio.channels;
  for (var c = 0; c < numChannels; ++c) {
   var channelData = dstAudioBuffer["getChannelData"](c);
   if (channelData.length != sizeSamplesPerChannel) {
    throw "Web Audio output buffer length mismatch! Destination size: " + channelData.length + " samples vs expected " + sizeSamplesPerChannel + " samples!";
   }
   if (SDL.audio.format == 32784) {
    for (var j = 0; j < sizeSamplesPerChannel; ++j) {
     channelData[j] = HEAP16[heapPtr + (j * numChannels + c) * 2 >> 1] / 32768;
    }
   } else if (SDL.audio.format == 8) {
    for (var j = 0; j < sizeSamplesPerChannel; ++j) {
     var v = HEAP8[heapPtr + (j * numChannels + c) >> 0];
     channelData[j] = (v >= 0 ? v - 128 : v + 128) / 128;
    }
   }
  }
 }),
 debugSurface: (function(surfData) {
  console.log("dumping surface " + [ surfData.surf, surfData.source, surfData.width, surfData.height ]);
  var image = surfData.ctx.getImageData(0, 0, surfData.width, surfData.height);
  var data = image.data;
  var num = Math.min(surfData.width, surfData.height);
  for (var i = 0; i < num; i++) {
   console.log("   diagonal " + i + ":" + [ data[i * surfData.width * 4 + i * 4 + 0], data[i * surfData.width * 4 + i * 4 + 1], data[i * surfData.width * 4 + i * 4 + 2], data[i * surfData.width * 4 + i * 4 + 3] ]);
  }
 }),
 joystickEventState: 1,
 lastJoystickState: {},
 joystickNamePool: {},
 recordJoystickState: (function(joystick, state) {
  var buttons = new Array(state.buttons.length);
  for (var i = 0; i < state.buttons.length; i++) {
   buttons[i] = SDL.getJoystickButtonState(state.buttons[i]);
  }
  SDL.lastJoystickState[joystick] = {
   buttons: buttons,
   axes: state.axes.slice(0),
   timestamp: state.timestamp,
   index: state.index,
   id: state.id
  };
 }),
 getJoystickButtonState: (function(button) {
  if (typeof button === "object") {
   return button.pressed;
  } else {
   return button > 0;
  }
 }),
 queryJoysticks: (function() {
  for (var joystick in SDL.lastJoystickState) {
   var state = SDL.getGamepad(joystick - 1);
   var prevState = SDL.lastJoystickState[joystick];
   if (typeof state.timestamp !== "number" || state.timestamp !== prevState.timestamp) {
    var i;
    for (i = 0; i < state.buttons.length; i++) {
     var buttonState = SDL.getJoystickButtonState(state.buttons[i]);
     if (buttonState !== prevState.buttons[i]) {
      SDL.events.push({
       type: buttonState ? "joystick_button_down" : "joystick_button_up",
       joystick: joystick,
       index: joystick - 1,
       button: i
      });
     }
    }
    for (i = 0; i < state.axes.length; i++) {
     if (state.axes[i] !== prevState.axes[i]) {
      SDL.events.push({
       type: "joystick_axis_motion",
       joystick: joystick,
       index: joystick - 1,
       axis: i,
       value: state.axes[i]
      });
     }
    }
    SDL.recordJoystickState(joystick, state);
   }
  }
 }),
 joystickAxisValueConversion: (function(value) {
  value = Math.min(1, Math.max(value, -1));
  return Math.ceil((value + 1) * 32767.5 - 32768);
 }),
 getGamepads: (function() {
  var fcn = navigator.getGamepads || navigator.webkitGamepads || navigator.mozGamepads || navigator.gamepads || navigator.webkitGetGamepads;
  if (fcn !== undefined) {
   return fcn.apply(navigator);
  } else {
   return [];
  }
 }),
 getGamepad: (function(deviceIndex) {
  var gamepads = SDL.getGamepads();
  if (gamepads.length > deviceIndex && deviceIndex >= 0) {
   return gamepads[deviceIndex];
  }
  return null;
 })
};
Module["SDL"] = SDL;
function _SDL_GL_SwapBuffers() {
 if (Browser.doSwapBuffers) Browser.doSwapBuffers();
}
Module["_SDL_GL_SwapBuffers"] = _SDL_GL_SwapBuffers;
function _glUniform1iv(location, count, value) {
 location = GL.uniforms[location];
 value = HEAP32.subarray(value >> 2, value + count * 4 >> 2);
 GLctx.uniform1iv(location, value);
}
Module["_glUniform1iv"] = _glUniform1iv;
function ___syscall() {
 if (!Module["___syscall"]) abort("external function '__syscall' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["___syscall"].apply(null, arguments);
}
function _emscripten_glGetVertexAttribiv(index, pname, params) {
 emscriptenWebGLGetVertexAttrib(index, pname, params, "FloatToInteger");
}
Module["_emscripten_glGetVertexAttribiv"] = _emscripten_glGetVertexAttribiv;
function _glReadBuffer(x0) {
 GLctx.readBuffer(x0);
}
Module["_glReadBuffer"] = _glReadBuffer;
function _il2cpp_class_is_enum() {
 if (!Module["_il2cpp_class_is_enum"]) abort("external function 'il2cpp_class_is_enum' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_is_enum"].apply(null, arguments);
}
function _glDrawArraysInstanced(mode, first, count, primcount) {
 GLctx["drawArraysInstanced"](mode, first, count, primcount);
}
Module["_glDrawArraysInstanced"] = _glDrawArraysInstanced;
function ___syscall148(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD();
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall148"] = ___syscall148;
function _il2cpp_gc_get_heap_size() {
 if (!Module["_il2cpp_gc_get_heap_size"]) abort("external function 'il2cpp_gc_get_heap_size' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_gc_get_heap_size"].apply(null, arguments);
}
function _glGenerateMipmap(x0) {
 GLctx.generateMipmap(x0);
}
Module["_glGenerateMipmap"] = _glGenerateMipmap;
function _il2cpp_method_get_class() {
 if (!Module["_il2cpp_method_get_class"]) abort("external function 'il2cpp_method_get_class' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_method_get_class"].apply(null, arguments);
}
function ___syscall265(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall265"] = ___syscall265;
function _il2cpp_class_instance_size() {
 if (!Module["_il2cpp_class_instance_size"]) abort("external function 'il2cpp_class_instance_size' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_instance_size"].apply(null, arguments);
}
function ___syscall142(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var nfds = SYSCALLS.get(), readfds = SYSCALLS.get(), writefds = SYSCALLS.get(), exceptfds = SYSCALLS.get(), timeout = SYSCALLS.get();
  assert(nfds <= 64, "nfds must be less than or equal to 64");
  assert(!exceptfds, "exceptfds not supported");
  var total = 0;
  var srcReadLow = readfds ? HEAP32[readfds >> 2] : 0, srcReadHigh = readfds ? HEAP32[readfds + 4 >> 2] : 0;
  var srcWriteLow = writefds ? HEAP32[writefds >> 2] : 0, srcWriteHigh = writefds ? HEAP32[writefds + 4 >> 2] : 0;
  var srcExceptLow = exceptfds ? HEAP32[exceptfds >> 2] : 0, srcExceptHigh = exceptfds ? HEAP32[exceptfds + 4 >> 2] : 0;
  var dstReadLow = 0, dstReadHigh = 0;
  var dstWriteLow = 0, dstWriteHigh = 0;
  var dstExceptLow = 0, dstExceptHigh = 0;
  var allLow = (readfds ? HEAP32[readfds >> 2] : 0) | (writefds ? HEAP32[writefds >> 2] : 0) | (exceptfds ? HEAP32[exceptfds >> 2] : 0);
  var allHigh = (readfds ? HEAP32[readfds + 4 >> 2] : 0) | (writefds ? HEAP32[writefds + 4 >> 2] : 0) | (exceptfds ? HEAP32[exceptfds + 4 >> 2] : 0);
  function check(fd, low, high, val) {
   return fd < 32 ? low & val : high & val;
  }
  for (var fd = 0; fd < nfds; fd++) {
   var mask = 1 << fd % 32;
   if (!check(fd, allLow, allHigh, mask)) {
    continue;
   }
   var stream = FS.getStream(fd);
   if (!stream) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
   var flags = SYSCALLS.DEFAULT_POLLMASK;
   if (stream.stream_ops.poll) {
    flags = stream.stream_ops.poll(stream);
   }
   if (flags & 1 && check(fd, srcReadLow, srcReadHigh, mask)) {
    fd < 32 ? dstReadLow = dstReadLow | mask : dstReadHigh = dstReadHigh | mask;
    total++;
   }
   if (flags & 4 && check(fd, srcWriteLow, srcWriteHigh, mask)) {
    fd < 32 ? dstWriteLow = dstWriteLow | mask : dstWriteHigh = dstWriteHigh | mask;
    total++;
   }
   if (flags & 2 && check(fd, srcExceptLow, srcExceptHigh, mask)) {
    fd < 32 ? dstExceptLow = dstExceptLow | mask : dstExceptHigh = dstExceptHigh | mask;
    total++;
   }
  }
  if (readfds) {
   HEAP32[readfds >> 2] = dstReadLow;
   HEAP32[readfds + 4 >> 2] = dstReadHigh;
  }
  if (writefds) {
   HEAP32[writefds >> 2] = dstWriteLow;
   HEAP32[writefds + 4 >> 2] = dstWriteHigh;
  }
  if (exceptfds) {
   HEAP32[exceptfds >> 2] = dstExceptLow;
   HEAP32[exceptfds + 4 >> 2] = dstExceptHigh;
  }
  return total;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall142"] = ___syscall142;
function _il2cpp_add_internal_call() {
 if (!Module["_il2cpp_add_internal_call"]) abort("external function 'il2cpp_add_internal_call' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_add_internal_call"].apply(null, arguments);
}
function ___syscall140(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD(), offset_high = SYSCALLS.get(), offset_low = SYSCALLS.get(), result = SYSCALLS.get(), whence = SYSCALLS.get();
  var offset = offset_low;
  assert(offset_high === 0);
  FS.llseek(stream, offset, whence);
  HEAP32[result >> 2] = stream.position;
  if (stream.getdents && offset === 0 && whence === 0) stream.getdents = null;
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall140"] = ___syscall140;
function ___syscall268(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var path = SYSCALLS.getStr(), size = SYSCALLS.get(), buf = SYSCALLS.get();
  assert(size === 64);
  HEAP32[buf + 4 >> 2] = 4096;
  HEAP32[buf + 40 >> 2] = 4096;
  HEAP32[buf + 8 >> 2] = 1e6;
  HEAP32[buf + 12 >> 2] = 5e5;
  HEAP32[buf + 16 >> 2] = 5e5;
  HEAP32[buf + 20 >> 2] = FS.nextInode;
  HEAP32[buf + 24 >> 2] = 1e6;
  HEAP32[buf + 28 >> 2] = 42;
  HEAP32[buf + 44 >> 2] = 2;
  HEAP32[buf + 36 >> 2] = 255;
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall268"] = ___syscall268;
function ___syscall146(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD(), iov = SYSCALLS.get(), iovcnt = SYSCALLS.get();
  return SYSCALLS.doWritev(stream, iov, iovcnt);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall146"] = ___syscall146;
function ___syscall147(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var pid = SYSCALLS.get();
  if (pid && pid !== PROCINFO.pid) return -ERRNO_CODES.ESRCH;
  return PROCINFO.sid;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall147"] = ___syscall147;
function ___syscall144(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var addr = SYSCALLS.get(), len = SYSCALLS.get(), flags = SYSCALLS.get();
  var info = SYSCALLS.mappings[addr];
  if (!info) return 0;
  SYSCALLS.doMsync(addr, FS.getStream(info.fd), len, info.flags);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall144"] = ___syscall144;
function _il2cpp_method_is_generic() {
 if (!Module["_il2cpp_method_is_generic"]) abort("external function 'il2cpp_method_is_generic' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_method_is_generic"].apply(null, arguments);
}
function _emscripten_glStencilFuncSeparate(x0, x1, x2, x3) {
 GLctx.stencilFuncSeparate(x0, x1, x2, x3);
}
Module["_emscripten_glStencilFuncSeparate"] = _emscripten_glStencilFuncSeparate;
function _glUnmapBuffer() {
 if (!Module["_glUnmapBuffer"]) abort("external function 'glUnmapBuffer' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_glUnmapBuffer"].apply(null, arguments);
}
function ___cxa_find_matching_catch() {
 var thrown = EXCEPTIONS.last;
 if (!thrown) {
  return (Runtime.setTempRet0(0), 0) | 0;
 }
 var info = EXCEPTIONS.infos[thrown];
 var throwntype = info.type;
 if (!throwntype) {
  return (Runtime.setTempRet0(0), thrown) | 0;
 }
 var typeArray = Array.prototype.slice.call(arguments);
 var pointer = Module["___cxa_is_pointer_type"](throwntype);
 if (!___cxa_find_matching_catch.buffer) ___cxa_find_matching_catch.buffer = _malloc(4);
 HEAP32[___cxa_find_matching_catch.buffer >> 2] = thrown;
 thrown = ___cxa_find_matching_catch.buffer;
 for (var i = 0; i < typeArray.length; i++) {
  if (typeArray[i] && Module["___cxa_can_catch"](typeArray[i], throwntype, thrown)) {
   thrown = HEAP32[thrown >> 2];
   info.adjusted = thrown;
   return (Runtime.setTempRet0(typeArray[i]), thrown) | 0;
  }
 }
 thrown = HEAP32[thrown >> 2];
 return (Runtime.setTempRet0(throwntype), thrown) | 0;
}
Module["___cxa_find_matching_catch"] = ___cxa_find_matching_catch;
function ___cxa_throw(ptr, type, destructor) {
 EXCEPTIONS.infos[ptr] = {
  ptr: ptr,
  adjusted: ptr,
  type: type,
  destructor: destructor,
  refcount: 0,
  caught: false
 };
 EXCEPTIONS.last = ptr;
 if (!("uncaught_exception" in __ZSt18uncaught_exceptionv)) {
  __ZSt18uncaught_exceptionv.uncaught_exception = 1;
 } else {
  __ZSt18uncaught_exceptionv.uncaught_exception++;
 }
 throw ptr;
}
Module["___cxa_throw"] = ___cxa_throw;
function _emscripten_set_touchend_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerTouchEventCallback(target, userData, useCapture, callbackfunc, 23, "touchend");
 return 0;
}
Module["_emscripten_set_touchend_callback"] = _emscripten_set_touchend_callback;
function emscriptenWebGLGet(name_, p, type) {
 if (!p) {
  GL.recordError(1281);
  return;
 }
 var ret = undefined;
 switch (name_) {
 case 36346:
  ret = 1;
  break;
 case 36344:
  if (type !== "Integer" && type !== "Integer64") {
   GL.recordError(1280);
  }
  return;
 case 34814:
 case 36345:
  ret = 0;
  break;
 case 34466:
  var formats = GLctx.getParameter(34467);
  ret = formats.length;
  break;
 case 35738:
  ret = 5121;
  break;
 case 35739:
  ret = 6408;
  break;
 case 33309:
  if (GLctx.canvas.GLctxObject.version < 2) {
   GL.recordError(1282);
   return;
  }
  var exts = GLctx.getSupportedExtensions();
  ret = 2 * exts.length;
  break;
 case 33307:
 case 33308:
  if (GLctx.canvas.GLctxObject.version < 2) {
   GL.recordError(1280);
   return;
  }
  ret = name_ == 33307 ? 3 : 0;
  break;
 }
 if (ret === undefined) {
  var result = GLctx.getParameter(name_);
  switch (typeof result) {
  case "number":
   ret = result;
   break;
  case "boolean":
   ret = result ? 1 : 0;
   break;
  case "string":
   GL.recordError(1280);
   return;
  case "object":
   if (result === null) {
    switch (name_) {
    case 34964:
    case 35725:
    case 34965:
    case 36006:
    case 36007:
    case 32873:
    case 34068:
     {
      ret = 0;
      break;
     }
    default:
     {
      GL.recordError(1280);
      return;
     }
    }
   } else if (result instanceof Float32Array || result instanceof Uint32Array || result instanceof Int32Array || result instanceof Array) {
    for (var i = 0; i < result.length; ++i) {
     switch (type) {
     case "Integer":
      HEAP32[p + i * 4 >> 2] = result[i];
      break;
     case "Float":
      HEAPF32[p + i * 4 >> 2] = result[i];
      break;
     case "Boolean":
      HEAP8[p + i >> 0] = result[i] ? 1 : 0;
      break;
     default:
      throw "internal glGet error, bad type: " + type;
     }
    }
    return;
   } else if (result instanceof WebGLBuffer || result instanceof WebGLProgram || result instanceof WebGLFramebuffer || result instanceof WebGLRenderbuffer || result instanceof WebGLTexture) {
    ret = result.name | 0;
   } else {
    GL.recordError(1280);
    return;
   }
   break;
  default:
   GL.recordError(1280);
   return;
  }
 }
 switch (type) {
 case "Integer64":
  tempI64 = [ ret >>> 0, (tempDouble = ret, +Math_abs(tempDouble) >= +1 ? tempDouble > +0 ? (Math_min(+Math_floor(tempDouble / +4294967296), +4294967295) | 0) >>> 0 : ~~+Math_ceil((tempDouble - +(~~tempDouble >>> 0)) / +4294967296) >>> 0 : 0) ], HEAP32[p >> 2] = tempI64[0], HEAP32[p + 4 >> 2] = tempI64[1];
  break;
 case "Integer":
  HEAP32[p >> 2] = ret;
  break;
 case "Float":
  HEAPF32[p >> 2] = ret;
  break;
 case "Boolean":
  HEAP8[p >> 0] = ret ? 1 : 0;
  break;
 default:
  throw "internal glGet error, bad type: " + type;
 }
}
Module["emscriptenWebGLGet"] = emscriptenWebGLGet;
function _emscripten_glGetFloatv(name_, p) {
 emscriptenWebGLGet(name_, p, "Float");
}
Module["_emscripten_glGetFloatv"] = _emscripten_glGetFloatv;
function _il2cpp_gchandle_new() {
 if (!Module["_il2cpp_gchandle_new"]) abort("external function 'il2cpp_gchandle_new' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_gchandle_new"].apply(null, arguments);
}
function _emscripten_glDisableVertexAttribArray(index) {
 GLctx.disableVertexAttribArray(index);
}
Module["_emscripten_glDisableVertexAttribArray"] = _emscripten_glDisableVertexAttribArray;
function _glBindRenderbuffer(target, renderbuffer) {
 GLctx.bindRenderbuffer(target, renderbuffer ? GL.renderbuffers[renderbuffer] : null);
}
Module["_glBindRenderbuffer"] = _glBindRenderbuffer;
function _emscripten_glGenRenderbuffers(n, renderbuffers) {
 for (var i = 0; i < n; i++) {
  var renderbuffer = GLctx.createRenderbuffer();
  if (!renderbuffer) {
   GL.recordError(1282);
   while (i < n) HEAP32[renderbuffers + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.renderbuffers);
  renderbuffer.name = id;
  GL.renderbuffers[id] = renderbuffer;
  HEAP32[renderbuffers + i * 4 >> 2] = id;
 }
}
Module["_emscripten_glGenRenderbuffers"] = _emscripten_glGenRenderbuffers;
function _emscripten_glBlendEquation(x0) {
 GLctx.blendEquation(x0);
}
Module["_emscripten_glBlendEquation"] = _emscripten_glBlendEquation;
function ___syscall3(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD(), buf = SYSCALLS.get(), count = SYSCALLS.get();
  return FS.read(stream, HEAP8, buf, count);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall3"] = ___syscall3;
function _emscripten_glDepthFunc(x0) {
 GLctx.depthFunc(x0);
}
Module["_emscripten_glDepthFunc"] = _emscripten_glDepthFunc;
function _emscripten_set_deviceorientation_callback(userData, useCapture, callbackfunc) {
 JSEvents.registerDeviceOrientationEventCallback(window, userData, useCapture, callbackfunc, 16, "deviceorientation");
 return 0;
}
Module["_emscripten_set_deviceorientation_callback"] = _emscripten_set_deviceorientation_callback;
function ___assert_fail(condition, filename, line, func) {
 ABORT = true;
 throw "Assertion failed: " + Pointer_stringify(condition) + ", at: " + [ filename ? Pointer_stringify(filename) : "unknown filename", line, func ? Pointer_stringify(func) : "unknown function" ] + " at " + stackTrace();
}
Module["___assert_fail"] = ___assert_fail;
function _il2cpp_class_get_assemblyname() {
 if (!Module["_il2cpp_class_get_assemblyname"]) abort("external function 'il2cpp_class_get_assemblyname' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_get_assemblyname"].apply(null, arguments);
}
function _usleep(useconds) {
 var msec = useconds / 1e3;
 if ((ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) && self["performance"] && self["performance"]["now"]) {
  var start = self["performance"]["now"]();
  while (self["performance"]["now"]() - start < msec) {}
 } else {
  var start = Date.now();
  while (Date.now() - start < msec) {}
 }
 return 0;
}
Module["_usleep"] = _usleep;
function _nanosleep(rqtp, rmtp) {
 var seconds = HEAP32[rqtp >> 2];
 var nanoseconds = HEAP32[rqtp + 4 >> 2];
 if (rmtp !== 0) {
  HEAP32[rmtp >> 2] = 0;
  HEAP32[rmtp + 4 >> 2] = 0;
 }
 return _usleep(seconds * 1e6 + nanoseconds / 1e3);
}
Module["_nanosleep"] = _nanosleep;
function _emscripten_glGetUniformiv(program, location, params) {
 emscriptenWebGLGetUniform(program, location, params, "Integer");
}
Module["_emscripten_glGetUniformiv"] = _emscripten_glGetUniformiv;
function _emscripten_glLoadIdentity() {
 throw "Legacy GL function (glLoadIdentity) called. If you want legacy GL emulation, you need to compile with -s LEGACY_GL_EMULATION=1 to enable legacy GL emulation.";
}
Module["_emscripten_glLoadIdentity"] = _emscripten_glLoadIdentity;
function _emscripten_glVertexAttribDivisor(index, divisor) {
 GLctx["vertexAttribDivisor"](index, divisor);
}
Module["_emscripten_glVertexAttribDivisor"] = _emscripten_glVertexAttribDivisor;
function ___syscall97(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return -ERRNO_CODES.EPERM;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall97"] = ___syscall97;
function _glActiveTexture(x0) {
 GLctx.activeTexture(x0);
}
Module["_glActiveTexture"] = _glActiveTexture;
function _glEnableVertexAttribArray(index) {
 GLctx.enableVertexAttribArray(index);
}
Module["_glEnableVertexAttribArray"] = _glEnableVertexAttribArray;
function _glReadPixels(x, y, width, height, format, type, pixels) {
 var pixelData = emscriptenWebGLGetTexPixelData(type, format, width, height, pixels, format);
 if (!pixelData) {
  GL.recordError(1280);
  return;
 }
 GLctx.readPixels(x, y, width, height, format, type, pixelData);
}
Module["_glReadPixels"] = _glReadPixels;
function ___syscall6(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD();
  FS.close(stream);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall6"] = ___syscall6;
function _emscripten_glDrawElementsInstanced(mode, count, type, indices, primcount) {
 GLctx["drawElementsInstanced"](mode, count, type, indices, primcount);
}
Module["_emscripten_glDrawElementsInstanced"] = _emscripten_glDrawElementsInstanced;
function _glRenderbufferStorageMultisample(x0, x1, x2, x3, x4) {
 GLctx.renderbufferStorageMultisample(x0, x1, x2, x3, x4);
}
Module["_glRenderbufferStorageMultisample"] = _glRenderbufferStorageMultisample;
function _il2cpp_type_get_name() {
 if (!Module["_il2cpp_type_get_name"]) abort("external function 'il2cpp_type_get_name' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_type_get_name"].apply(null, arguments);
}
function _glUniformMatrix3fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (9 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[9 * count - 1];
  for (var i = 0; i < 9 * count; i += 9) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
   view[i + 4] = HEAPF32[value + (4 * i + 16) >> 2];
   view[i + 5] = HEAPF32[value + (4 * i + 20) >> 2];
   view[i + 6] = HEAPF32[value + (4 * i + 24) >> 2];
   view[i + 7] = HEAPF32[value + (4 * i + 28) >> 2];
   view[i + 8] = HEAPF32[value + (4 * i + 32) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 36 >> 2);
 }
 GLctx.uniformMatrix3fv(location, transpose, view);
}
Module["_glUniformMatrix3fv"] = _glUniformMatrix3fv;
function _JS_SystemInfo_GetLanguage(buffer, bufferSize) {
 var language = systemInfo.get().language;
 var result = language;
 result = result.slice(0, Math.max(0, bufferSize));
 if (buffer) writeStringToMemory(result, buffer, true);
 return language.length;
}
Module["_JS_SystemInfo_GetLanguage"] = _JS_SystemInfo_GetLanguage;
var GAI_ERRNO_MESSAGES = {};
Module["GAI_ERRNO_MESSAGES"] = GAI_ERRNO_MESSAGES;
function _gai_strerror(val) {
 var buflen = 256;
 if (!_gai_strerror.buffer) {
  _gai_strerror.buffer = _malloc(buflen);
  GAI_ERRNO_MESSAGES["0"] = "Success";
  GAI_ERRNO_MESSAGES["" + -1] = "Invalid value for 'ai_flags' field";
  GAI_ERRNO_MESSAGES["" + -2] = "NAME or SERVICE is unknown";
  GAI_ERRNO_MESSAGES["" + -3] = "Temporary failure in name resolution";
  GAI_ERRNO_MESSAGES["" + -4] = "Non-recoverable failure in name res";
  GAI_ERRNO_MESSAGES["" + -6] = "'ai_family' not supported";
  GAI_ERRNO_MESSAGES["" + -7] = "'ai_socktype' not supported";
  GAI_ERRNO_MESSAGES["" + -8] = "SERVICE not supported for 'ai_socktype'";
  GAI_ERRNO_MESSAGES["" + -10] = "Memory allocation failure";
  GAI_ERRNO_MESSAGES["" + -11] = "System error returned in 'errno'";
  GAI_ERRNO_MESSAGES["" + -12] = "Argument buffer overflow";
 }
 var msg = "Unknown error";
 if (val in GAI_ERRNO_MESSAGES) {
  if (GAI_ERRNO_MESSAGES[val].length > buflen - 1) {
   msg = "Message too long";
  } else {
   msg = GAI_ERRNO_MESSAGES[val];
  }
 }
 writeAsciiToMemory(msg, _gai_strerror.buffer);
 return _gai_strerror.buffer;
}
Module["_gai_strerror"] = _gai_strerror;
function _JS_Log_StackTrace(buffer, bufferSize) {
 var trace = stackTrace();
 var result = trace;
 result = result.slice(0, Math.max(0, bufferSize));
 if (buffer) writeStringToMemory(result, buffer, true);
 return trace.length;
}
Module["_JS_Log_StackTrace"] = _JS_Log_StackTrace;
function _emscripten_glUniform4f(location, v0, v1, v2, v3) {
 location = GL.uniforms[location];
 GLctx.uniform4f(location, v0, v1, v2, v3);
}
Module["_emscripten_glUniform4f"] = _emscripten_glUniform4f;
function _emscripten_webgl_create_context(target, attributes) {
 var contextAttributes = {};
 contextAttributes.alpha = !!HEAP32[attributes >> 2];
 contextAttributes.depth = !!HEAP32[attributes + 4 >> 2];
 contextAttributes.stencil = !!HEAP32[attributes + 8 >> 2];
 contextAttributes.antialias = !!HEAP32[attributes + 12 >> 2];
 contextAttributes.premultipliedAlpha = !!HEAP32[attributes + 16 >> 2];
 contextAttributes.preserveDrawingBuffer = !!HEAP32[attributes + 20 >> 2];
 contextAttributes.preferLowPowerToHighPerformance = !!HEAP32[attributes + 24 >> 2];
 contextAttributes.failIfMajorPerformanceCaveat = !!HEAP32[attributes + 28 >> 2];
 contextAttributes.majorVersion = HEAP32[attributes + 32 >> 2];
 contextAttributes.minorVersion = HEAP32[attributes + 36 >> 2];
 contextAttributes.explicitSwapControl = HEAP32[attributes + 44 >> 2];
 target = target ? Pointer_stringify(target) : "#canvas";
 var canvas;
 if (target) {
  if (target === "#canvas" && Module["canvas"]) {
   target = Module["canvas"].id;
  }
  canvas = GL.offscreenCanvases[target] || JSEvents.findEventTarget(target);
 } else {
  canvas = GL.offscreenCanvases[Module["canvas"].id] || Module["canvas"];
 }
 if (!canvas) {
  return 0;
 }
 if (contextAttributes.explicitSwapControl) {
  console.error("emscripten_webgl_create_context failed: explicitSwapControl is not supported, please rebuild with -s OFFSCREENCANVAS_SUPPORT=1 to enable targeting the experimental OffscreenCanvas specification!");
  return 0;
 }
 var contextHandle = GL.createContext(canvas, contextAttributes);
 return contextHandle;
}
Module["_emscripten_webgl_create_context"] = _emscripten_webgl_create_context;
function _pthread_cleanup_pop() {
 assert(_pthread_cleanup_push.level == __ATEXIT__.length, "cannot pop if something else added meanwhile!");
 __ATEXIT__.pop();
 _pthread_cleanup_push.level = __ATEXIT__.length;
}
Module["_pthread_cleanup_pop"] = _pthread_cleanup_pop;
function _emscripten_glClearStencil(x0) {
 GLctx.clearStencil(x0);
}
Module["_emscripten_glClearStencil"] = _emscripten_glClearStencil;
function _JS_WebCamVideo_GetNativeWidth(deviceId) {
 return MediaDevices[deviceId].video ? MediaDevices[deviceId].video.videoWidth : 0;
}
Module["_JS_WebCamVideo_GetNativeWidth"] = _JS_WebCamVideo_GetNativeWidth;
function _emscripten_glDetachShader(program, shader) {
 GLctx.detachShader(GL.programs[program], GL.shaders[shader]);
}
Module["_emscripten_glDetachShader"] = _emscripten_glDetachShader;
function _JS_Sound_Stop(channelInstance, delay) {
 if (WEBAudio.audioWebEnabled == 0) return;
 var channel = WEBAudio.audioInstances[channelInstance];
 if (channel.source.buffer) {
  try {
   channel.source.stop(WEBAudio.audioContext.currentTime + delay);
  } catch (e) {
   channel.source.disconnect();
  }
  if (delay == 0) {
   channel.source.onended = (function() {});
   channel.setup();
  }
 }
}
Module["_JS_Sound_Stop"] = _JS_Sound_Stop;
function _emscripten_glDeleteVertexArrays(n, vaos) {
 for (var i = 0; i < n; i++) {
  var id = HEAP32[vaos + i * 4 >> 2];
  GLctx["deleteVertexArray"](GL.vaos[id]);
  GL.vaos[id] = null;
 }
}
Module["_emscripten_glDeleteVertexArrays"] = _emscripten_glDeleteVertexArrays;
function ___block_all_sigs() {
 if (!Module["___block_all_sigs"]) abort("external function '__block_all_sigs' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["___block_all_sigs"].apply(null, arguments);
}
function _JS_Eval_OpenURL(ptr) {
 var str = Pointer_stringify(ptr);
 location.href = str;
}
Module["_JS_Eval_OpenURL"] = _JS_Eval_OpenURL;
function ___syscall163(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return -ERRNO_CODES.ENOMEM;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall163"] = ___syscall163;
function _pthread_mutex_destroy() {}
Module["_pthread_mutex_destroy"] = _pthread_mutex_destroy;
function _glUniformBlockBinding(program, uniformBlockIndex, uniformBlockBinding) {
 program = GL.programs[program];
 GLctx["uniformBlockBinding"](program, uniformBlockIndex, uniformBlockBinding);
}
Module["_glUniformBlockBinding"] = _glUniformBlockBinding;
function _il2cpp_get_exception_argument_null() {
 if (!Module["_il2cpp_get_exception_argument_null"]) abort("external function 'il2cpp_get_exception_argument_null' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_get_exception_argument_null"].apply(null, arguments);
}
function _glUniform1fv(location, count, value) {
 location = GL.uniforms[location];
 var view;
 if (count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[count - 1];
  for (var i = 0; i < count; ++i) {
   view[i] = HEAPF32[value + 4 * i >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 4 >> 2);
 }
 GLctx.uniform1fv(location, view);
}
Module["_glUniform1fv"] = _glUniform1fv;
function _emscripten_glGenerateMipmap(x0) {
 GLctx.generateMipmap(x0);
}
Module["_emscripten_glGenerateMipmap"] = _emscripten_glGenerateMipmap;
function _getpwuid(uid) {
 return 0;
}
Module["_getpwuid"] = _getpwuid;
function _emscripten_glCullFace(x0) {
 GLctx.cullFace(x0);
}
Module["_emscripten_glCullFace"] = _emscripten_glCullFace;
function _emscripten_glUseProgram(program) {
 GLctx.useProgram(program ? GL.programs[program] : null);
}
Module["_emscripten_glUseProgram"] = _emscripten_glUseProgram;
function _emscripten_glUniformMatrix4fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (16 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[16 * count - 1];
  for (var i = 0; i < 16 * count; i += 16) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
   view[i + 4] = HEAPF32[value + (4 * i + 16) >> 2];
   view[i + 5] = HEAPF32[value + (4 * i + 20) >> 2];
   view[i + 6] = HEAPF32[value + (4 * i + 24) >> 2];
   view[i + 7] = HEAPF32[value + (4 * i + 28) >> 2];
   view[i + 8] = HEAPF32[value + (4 * i + 32) >> 2];
   view[i + 9] = HEAPF32[value + (4 * i + 36) >> 2];
   view[i + 10] = HEAPF32[value + (4 * i + 40) >> 2];
   view[i + 11] = HEAPF32[value + (4 * i + 44) >> 2];
   view[i + 12] = HEAPF32[value + (4 * i + 48) >> 2];
   view[i + 13] = HEAPF32[value + (4 * i + 52) >> 2];
   view[i + 14] = HEAPF32[value + (4 * i + 56) >> 2];
   view[i + 15] = HEAPF32[value + (4 * i + 60) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 64 >> 2);
 }
 GLctx.uniformMatrix4fv(location, transpose, view);
}
Module["_emscripten_glUniformMatrix4fv"] = _emscripten_glUniformMatrix4fv;
function _il2cpp_class_array_element_size() {
 if (!Module["_il2cpp_class_array_element_size"]) abort("external function 'il2cpp_class_array_element_size' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_array_element_size"].apply(null, arguments);
}
function _emscripten_glUniform2fv(location, count, value) {
 location = GL.uniforms[location];
 var view;
 if (2 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[2 * count - 1];
  for (var i = 0; i < 2 * count; i += 2) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 8 >> 2);
 }
 GLctx.uniform2fv(location, view);
}
Module["_emscripten_glUniform2fv"] = _emscripten_glUniform2fv;
function _glGetShaderInfoLog(shader, maxLength, length, infoLog) {
 var log = GLctx.getShaderInfoLog(GL.shaders[shader]);
 if (log === null) log = "(unknown error)";
 log = log.substr(0, maxLength - 1);
 if (maxLength > 0 && infoLog) {
  writeStringToMemory(log, infoLog);
  if (length) HEAP32[length >> 2] = log.length;
 } else {
  if (length) HEAP32[length >> 2] = 0;
 }
}
Module["_glGetShaderInfoLog"] = _glGetShaderInfoLog;
function _emscripten_glFramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer) {
 GLctx.framebufferRenderbuffer(target, attachment, renderbuffertarget, GL.renderbuffers[renderbuffer]);
}
Module["_emscripten_glFramebufferRenderbuffer"] = _emscripten_glFramebufferRenderbuffer;
function _emscripten_glDeleteFramebuffers(n, framebuffers) {
 for (var i = 0; i < n; ++i) {
  var id = HEAP32[framebuffers + i * 4 >> 2];
  var framebuffer = GL.framebuffers[id];
  if (!framebuffer) continue;
  GLctx.deleteFramebuffer(framebuffer);
  framebuffer.name = 0;
  GL.framebuffers[id] = null;
 }
}
Module["_emscripten_glDeleteFramebuffers"] = _emscripten_glDeleteFramebuffers;
function _emscripten_glUniform2iv(location, count, value) {
 location = GL.uniforms[location];
 count *= 2;
 value = HEAP32.subarray(value >> 2, value + count * 4 >> 2);
 GLctx.uniform2iv(location, value);
}
Module["_emscripten_glUniform2iv"] = _emscripten_glUniform2iv;
function _emscripten_glVertexAttrib1fv(index, v) {
 var view = GL.miniTempBufferViews[0];
 view[0] = HEAPF32[v >> 2];
 GLctx.vertexAttrib1fv(index, view);
}
Module["_emscripten_glVertexAttrib1fv"] = _emscripten_glVertexAttrib1fv;
function _il2cpp_method_is_instance() {
 if (!Module["_il2cpp_method_is_instance"]) abort("external function 'il2cpp_method_is_instance' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_method_is_instance"].apply(null, arguments);
}
var _emscripten_asm_const_int = true;
Module["_emscripten_asm_const_int"] = _emscripten_asm_const_int;
function _il2cpp_set_config_dir() {
 if (!Module["_il2cpp_set_config_dir"]) abort("external function 'il2cpp_set_config_dir' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_set_config_dir"].apply(null, arguments);
}
function _glGenBuffers(n, buffers) {
 for (var i = 0; i < n; i++) {
  var buffer = GLctx.createBuffer();
  if (!buffer) {
   GL.recordError(1282);
   while (i < n) HEAP32[buffers + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.buffers);
  buffer.name = id;
  GL.buffers[id] = buffer;
  HEAP32[buffers + i * 4 >> 2] = id;
 }
}
Module["_glGenBuffers"] = _glGenBuffers;
function _emscripten_glBindVertexArray(vao) {
 GLctx["bindVertexArray"](GL.vaos[vao]);
}
Module["_emscripten_glBindVertexArray"] = _emscripten_glBindVertexArray;
function __Z43InvokeRegisterStaticallyLinkedModuleClassesv() {
 if (!Module["__Z43InvokeRegisterStaticallyLinkedModuleClassesv"]) abort("external function '_Z43InvokeRegisterStaticallyLinkedModuleClassesv' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["__Z43InvokeRegisterStaticallyLinkedModuleClassesv"].apply(null, arguments);
}
function _il2cpp_field_get_offset() {
 if (!Module["_il2cpp_field_get_offset"]) abort("external function 'il2cpp_field_get_offset' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_field_get_offset"].apply(null, arguments);
}
function _wait(stat_loc) {
 ___setErrNo(ERRNO_CODES.ECHILD);
 return -1;
}
Module["_wait"] = _wait;
function _waitpid() {
 return _wait.apply(null, arguments);
}
Module["_waitpid"] = _waitpid;
function _glCreateProgram() {
 var id = GL.getNewId(GL.programs);
 var program = GLctx.createProgram();
 program.name = id;
 GL.programs[id] = program;
 return id;
}
Module["_glCreateProgram"] = _glCreateProgram;
function _glTexImage3D(target, level, internalFormat, width, height, depth, border, format, type, data) {
 GLctx["texImage3D"](target, level, internalFormat, width, height, depth, border, format, type, HEAPU8.subarray(data));
}
Module["_glTexImage3D"] = _glTexImage3D;
function _il2cpp_object_get_virtual_method() {
 if (!Module["_il2cpp_object_get_virtual_method"]) abort("external function 'il2cpp_object_get_virtual_method' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_object_get_virtual_method"].apply(null, arguments);
}
function _JS_SystemInfo_GetBrowserVersionString(buffer, bufferSize) {
 var browserVer = systemInfo.get().browserVersion;
 var result = browserVer;
 result = result.slice(0, Math.max(0, bufferSize));
 if (buffer) writeStringToMemory(result, buffer, true);
 return browserVer.length;
}
Module["_JS_SystemInfo_GetBrowserVersionString"] = _JS_SystemInfo_GetBrowserVersionString;
function _pthread_cond_wait() {
 return 0;
}
Module["_pthread_cond_wait"] = _pthread_cond_wait;
function _emscripten_glGetPointerv() {
 if (!Module["_emscripten_glGetPointerv"]) abort("external function 'emscripten_glGetPointerv' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_emscripten_glGetPointerv"].apply(null, arguments);
}
function ___clock_gettime() {
 return _clock_gettime.apply(null, arguments);
}
Module["___clock_gettime"] = ___clock_gettime;
function _JS_WebRequest_SetRequestHeader(request, header, value) {
 var _header = Pointer_stringify(header);
 var _value = Pointer_stringify(value);
 wr.requestInstances[request].setRequestHeader(_header, _value);
}
Module["_JS_WebRequest_SetRequestHeader"] = _JS_WebRequest_SetRequestHeader;
function _il2cpp_shutdown() {
 if (!Module["_il2cpp_shutdown"]) abort("external function 'il2cpp_shutdown' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_shutdown"].apply(null, arguments);
}
function _JS_Sound_Load(ptr, length) {
 if (WEBAudio.audioWebEnabled == 0) return 0;
 var sound = {
  buffer: null,
  error: false
 };
 var instance = WEBAudio.audioInstances.push(sound) - 1;
 WEBAudio.audioContext.decodeAudioData(HEAPU8.buffer.slice(ptr, ptr + length), (function(buffer) {
  sound.buffer = buffer;
 }), (function() {
  sound.error = true;
  console.log("Decode error.");
 }));
 return instance;
}
Module["_JS_Sound_Load"] = _JS_Sound_Load;
function _JS_Eval_ClearTimeout(id) {
 window.clearTimeout(id);
}
Module["_JS_Eval_ClearTimeout"] = _JS_Eval_ClearTimeout;
function ___syscall269(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD(), size = SYSCALLS.get(), buf = SYSCALLS.get();
  return ___syscall([ 268, 0, size, buf ], 0);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall269"] = ___syscall269;
Module["___muldsi3"] = ___muldsi3;
Module["___muldi3"] = ___muldi3;
function _setitimer() {
 throw "setitimer() is not implemented yet";
}
Module["_setitimer"] = _setitimer;
function _emscripten_glUniform1fv(location, count, value) {
 location = GL.uniforms[location];
 var view;
 if (count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[count - 1];
  for (var i = 0; i < count; ++i) {
   view[i] = HEAPF32[value + 4 * i >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 4 >> 2);
 }
 GLctx.uniform1fv(location, view);
}
Module["_emscripten_glUniform1fv"] = _emscripten_glUniform1fv;
var SOCKFS = {
 mount: (function(mount) {
  Module["websocket"] = Module["websocket"] && "object" === typeof Module["websocket"] ? Module["websocket"] : {};
  Module["websocket"]._callbacks = {};
  Module["websocket"]["on"] = (function(event, callback) {
   if ("function" === typeof callback) {
    this._callbacks[event] = callback;
   }
   return this;
  });
  Module["websocket"].emit = (function(event, param) {
   if ("function" === typeof this._callbacks[event]) {
    this._callbacks[event].call(this, param);
   }
  });
  return FS.createNode(null, "/", 16384 | 511, 0);
 }),
 createSocket: (function(family, type, protocol) {
  var streaming = type == 1;
  if (protocol) {
   assert(streaming == (protocol == 6));
  }
  var sock = {
   family: family,
   type: type,
   protocol: protocol,
   server: null,
   error: null,
   peers: {},
   pending: [],
   recv_queue: [],
   sock_ops: SOCKFS.websocket_sock_ops
  };
  var name = SOCKFS.nextname();
  var node = FS.createNode(SOCKFS.root, name, 49152, 0);
  node.sock = sock;
  var stream = FS.createStream({
   path: name,
   node: node,
   flags: FS.modeStringToFlags("r+"),
   seekable: false,
   stream_ops: SOCKFS.stream_ops
  });
  sock.stream = stream;
  return sock;
 }),
 getSocket: (function(fd) {
  var stream = FS.getStream(fd);
  if (!stream || !FS.isSocket(stream.node.mode)) {
   return null;
  }
  return stream.node.sock;
 }),
 stream_ops: {
  poll: (function(stream) {
   var sock = stream.node.sock;
   return sock.sock_ops.poll(sock);
  }),
  ioctl: (function(stream, request, varargs) {
   var sock = stream.node.sock;
   return sock.sock_ops.ioctl(sock, request, varargs);
  }),
  read: (function(stream, buffer, offset, length, position) {
   var sock = stream.node.sock;
   var msg = sock.sock_ops.recvmsg(sock, length);
   if (!msg) {
    return 0;
   }
   buffer.set(msg.buffer, offset);
   return msg.buffer.length;
  }),
  write: (function(stream, buffer, offset, length, position) {
   var sock = stream.node.sock;
   return sock.sock_ops.sendmsg(sock, buffer, offset, length);
  }),
  close: (function(stream) {
   var sock = stream.node.sock;
   sock.sock_ops.close(sock);
  })
 },
 nextname: (function() {
  if (!SOCKFS.nextname.current) {
   SOCKFS.nextname.current = 0;
  }
  return "socket[" + SOCKFS.nextname.current++ + "]";
 }),
 websocket_sock_ops: {
  createPeer: (function(sock, addr, port) {
   var ws;
   if (typeof addr === "object") {
    ws = addr;
    addr = null;
    port = null;
   }
   if (ws) {
    if (ws._socket) {
     addr = ws._socket.remoteAddress;
     port = ws._socket.remotePort;
    } else {
     var result = /ws[s]?:\/\/([^:]+):(\d+)/.exec(ws.url);
     if (!result) {
      throw new Error("WebSocket URL must be in the format ws(s)://address:port");
     }
     addr = result[1];
     port = parseInt(result[2], 10);
    }
   } else {
    try {
     var runtimeConfig = Module["websocket"] && "object" === typeof Module["websocket"];
     var url = "ws:#".replace("#", "//");
     if (runtimeConfig) {
      if ("string" === typeof Module["websocket"]["url"]) {
       url = Module["websocket"]["url"];
      }
     }
     if (url === "ws://" || url === "wss://") {
      var parts = addr.split("/");
      url = url + parts[0] + ":" + port + "/" + parts.slice(1).join("/");
     }
     var subProtocols = "binary";
     if (runtimeConfig) {
      if ("string" === typeof Module["websocket"]["subprotocol"]) {
       subProtocols = Module["websocket"]["subprotocol"];
      }
     }
     subProtocols = subProtocols.replace(/^ +| +$/g, "").split(/ *, */);
     var opts = ENVIRONMENT_IS_NODE ? {
      "protocol": subProtocols.toString()
     } : subProtocols;
     var WebSocketConstructor;
     if (ENVIRONMENT_IS_NODE) {
      WebSocketConstructor = require("ws");
     } else if (ENVIRONMENT_IS_WEB) {
      WebSocketConstructor = window["WebSocket"];
     } else {
      WebSocketConstructor = WebSocket;
     }
     ws = new WebSocketConstructor(url, opts);
     ws.binaryType = "arraybuffer";
    } catch (e) {
     throw new FS.ErrnoError(ERRNO_CODES.EHOSTUNREACH);
    }
   }
   var peer = {
    addr: addr,
    port: port,
    socket: ws,
    dgram_send_queue: []
   };
   SOCKFS.websocket_sock_ops.addPeer(sock, peer);
   SOCKFS.websocket_sock_ops.handlePeerEvents(sock, peer);
   if (sock.type === 2 && typeof sock.sport !== "undefined") {
    peer.dgram_send_queue.push(new Uint8Array([ 255, 255, 255, 255, "p".charCodeAt(0), "o".charCodeAt(0), "r".charCodeAt(0), "t".charCodeAt(0), (sock.sport & 65280) >> 8, sock.sport & 255 ]));
   }
   return peer;
  }),
  getPeer: (function(sock, addr, port) {
   return sock.peers[addr + ":" + port];
  }),
  addPeer: (function(sock, peer) {
   sock.peers[peer.addr + ":" + peer.port] = peer;
  }),
  removePeer: (function(sock, peer) {
   delete sock.peers[peer.addr + ":" + peer.port];
  }),
  handlePeerEvents: (function(sock, peer) {
   var first = true;
   var handleOpen = (function() {
    Module["websocket"].emit("open", sock.stream.fd);
    try {
     var queued = peer.dgram_send_queue.shift();
     while (queued) {
      peer.socket.send(queued);
      queued = peer.dgram_send_queue.shift();
     }
    } catch (e) {
     peer.socket.close();
    }
   });
   function handleMessage(data) {
    assert(typeof data !== "string" && data.byteLength !== undefined);
    if (data.byteLength == 0) {
     return;
    }
    data = new Uint8Array(data);
    var wasfirst = first;
    first = false;
    if (wasfirst && data.length === 10 && data[0] === 255 && data[1] === 255 && data[2] === 255 && data[3] === 255 && data[4] === "p".charCodeAt(0) && data[5] === "o".charCodeAt(0) && data[6] === "r".charCodeAt(0) && data[7] === "t".charCodeAt(0)) {
     var newport = data[8] << 8 | data[9];
     SOCKFS.websocket_sock_ops.removePeer(sock, peer);
     peer.port = newport;
     SOCKFS.websocket_sock_ops.addPeer(sock, peer);
     return;
    }
    sock.recv_queue.push({
     addr: peer.addr,
     port: peer.port,
     data: data
    });
    Module["websocket"].emit("message", sock.stream.fd);
   }
   if (ENVIRONMENT_IS_NODE) {
    peer.socket.on("open", handleOpen);
    peer.socket.on("message", (function(data, flags) {
     if (!flags.binary) {
      return;
     }
     handleMessage((new Uint8Array(data)).buffer);
    }));
    peer.socket.on("close", (function() {
     Module["websocket"].emit("close", sock.stream.fd);
    }));
    peer.socket.on("error", (function(error) {
     sock.error = ERRNO_CODES.ECONNREFUSED;
     Module["websocket"].emit("error", [ sock.stream.fd, sock.error, "ECONNREFUSED: Connection refused" ]);
    }));
   } else {
    peer.socket.onopen = handleOpen;
    peer.socket.onclose = (function() {
     Module["websocket"].emit("close", sock.stream.fd);
    });
    peer.socket.onmessage = function peer_socket_onmessage(event) {
     handleMessage(event.data);
    };
    peer.socket.onerror = (function(error) {
     sock.error = ERRNO_CODES.ECONNREFUSED;
     Module["websocket"].emit("error", [ sock.stream.fd, sock.error, "ECONNREFUSED: Connection refused" ]);
    });
   }
  }),
  poll: (function(sock) {
   if (sock.type === 1 && sock.server) {
    return sock.pending.length ? 64 | 1 : 0;
   }
   var mask = 0;
   var dest = sock.type === 1 ? SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport) : null;
   if (sock.recv_queue.length || !dest || dest && dest.socket.readyState === dest.socket.CLOSING || dest && dest.socket.readyState === dest.socket.CLOSED) {
    mask |= 64 | 1;
   }
   if (!dest || dest && dest.socket.readyState === dest.socket.OPEN) {
    mask |= 4;
   }
   if (dest && dest.socket.readyState === dest.socket.CLOSING || dest && dest.socket.readyState === dest.socket.CLOSED) {
    mask |= 16;
   }
   return mask;
  }),
  ioctl: (function(sock, request, arg) {
   switch (request) {
   case 21531:
    var bytes = 0;
    if (sock.recv_queue.length) {
     bytes = sock.recv_queue[0].data.length;
    }
    HEAP32[arg >> 2] = bytes;
    return 0;
   default:
    return ERRNO_CODES.EINVAL;
   }
  }),
  close: (function(sock) {
   if (sock.server) {
    try {
     sock.server.close();
    } catch (e) {}
    sock.server = null;
   }
   var peers = Object.keys(sock.peers);
   for (var i = 0; i < peers.length; i++) {
    var peer = sock.peers[peers[i]];
    try {
     peer.socket.close();
    } catch (e) {}
    SOCKFS.websocket_sock_ops.removePeer(sock, peer);
   }
   return 0;
  }),
  bind: (function(sock, addr, port) {
   if (typeof sock.saddr !== "undefined" || typeof sock.sport !== "undefined") {
    throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
   }
   sock.saddr = addr;
   sock.sport = port;
   if (sock.type === 2) {
    if (sock.server) {
     sock.server.close();
     sock.server = null;
    }
    try {
     sock.sock_ops.listen(sock, 0);
    } catch (e) {
     if (!(e instanceof FS.ErrnoError)) throw e;
     if (e.errno !== ERRNO_CODES.EOPNOTSUPP) throw e;
    }
   }
  }),
  connect: (function(sock, addr, port) {
   if (sock.server) {
    throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
   }
   if (typeof sock.daddr !== "undefined" && typeof sock.dport !== "undefined") {
    var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
    if (dest) {
     if (dest.socket.readyState === dest.socket.CONNECTING) {
      throw new FS.ErrnoError(ERRNO_CODES.EALREADY);
     } else {
      throw new FS.ErrnoError(ERRNO_CODES.EISCONN);
     }
    }
   }
   var peer = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
   sock.daddr = peer.addr;
   sock.dport = peer.port;
   throw new FS.ErrnoError(ERRNO_CODES.EINPROGRESS);
  }),
  listen: (function(sock, backlog) {
   if (!ENVIRONMENT_IS_NODE) {
    throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
   }
   if (sock.server) {
    throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
   }
   var WebSocketServer = require("ws").Server;
   var host = sock.saddr;
   sock.server = new WebSocketServer({
    host: host,
    port: sock.sport
   });
   Module["websocket"].emit("listen", sock.stream.fd);
   sock.server.on("connection", (function(ws) {
    if (sock.type === 1) {
     var newsock = SOCKFS.createSocket(sock.family, sock.type, sock.protocol);
     var peer = SOCKFS.websocket_sock_ops.createPeer(newsock, ws);
     newsock.daddr = peer.addr;
     newsock.dport = peer.port;
     sock.pending.push(newsock);
     Module["websocket"].emit("connection", newsock.stream.fd);
    } else {
     SOCKFS.websocket_sock_ops.createPeer(sock, ws);
     Module["websocket"].emit("connection", sock.stream.fd);
    }
   }));
   sock.server.on("closed", (function() {
    Module["websocket"].emit("close", sock.stream.fd);
    sock.server = null;
   }));
   sock.server.on("error", (function(error) {
    sock.error = ERRNO_CODES.EHOSTUNREACH;
    Module["websocket"].emit("error", [ sock.stream.fd, sock.error, "EHOSTUNREACH: Host is unreachable" ]);
   }));
  }),
  accept: (function(listensock) {
   if (!listensock.server) {
    throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
   }
   var newsock = listensock.pending.shift();
   newsock.stream.flags = listensock.stream.flags;
   return newsock;
  }),
  getname: (function(sock, peer) {
   var addr, port;
   if (peer) {
    if (sock.daddr === undefined || sock.dport === undefined) {
     throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
    }
    addr = sock.daddr;
    port = sock.dport;
   } else {
    addr = sock.saddr || 0;
    port = sock.sport || 0;
   }
   return {
    addr: addr,
    port: port
   };
  }),
  sendmsg: (function(sock, buffer, offset, length, addr, port) {
   if (sock.type === 2) {
    if (addr === undefined || port === undefined) {
     addr = sock.daddr;
     port = sock.dport;
    }
    if (addr === undefined || port === undefined) {
     throw new FS.ErrnoError(ERRNO_CODES.EDESTADDRREQ);
    }
   } else {
    addr = sock.daddr;
    port = sock.dport;
   }
   var dest = SOCKFS.websocket_sock_ops.getPeer(sock, addr, port);
   if (sock.type === 1) {
    if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
     throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
    } else if (dest.socket.readyState === dest.socket.CONNECTING) {
     throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
    }
   }
   var data;
   if (buffer instanceof Array || buffer instanceof ArrayBuffer) {
    data = buffer.slice(offset, offset + length);
   } else {
    data = buffer.buffer.slice(buffer.byteOffset + offset, buffer.byteOffset + offset + length);
   }
   if (sock.type === 2) {
    if (!dest || dest.socket.readyState !== dest.socket.OPEN) {
     if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
      dest = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
     }
     dest.dgram_send_queue.push(data);
     return length;
    }
   }
   try {
    dest.socket.send(data);
    return length;
   } catch (e) {
    throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
   }
  }),
  recvmsg: (function(sock, length) {
   if (sock.type === 1 && sock.server) {
    throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
   }
   var queued = sock.recv_queue.shift();
   if (!queued) {
    if (sock.type === 1) {
     var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
     if (!dest) {
      throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
     } else if (dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
      return null;
     } else {
      throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
     }
    } else {
     throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
    }
   }
   var queuedLength = queued.data.byteLength || queued.data.length;
   var queuedOffset = queued.data.byteOffset || 0;
   var queuedBuffer = queued.data.buffer || queued.data;
   var bytesRead = Math.min(length, queuedLength);
   var res = {
    buffer: new Uint8Array(queuedBuffer, queuedOffset, bytesRead),
    addr: queued.addr,
    port: queued.port
   };
   if (sock.type === 1 && bytesRead < queuedLength) {
    var bytesRemaining = queuedLength - bytesRead;
    queued.data = new Uint8Array(queuedBuffer, queuedOffset + bytesRead, bytesRemaining);
    sock.recv_queue.unshift(queued);
   }
   return res;
  })
 }
};
Module["SOCKFS"] = SOCKFS;
function ___syscall102(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var call = SYSCALLS.get(), socketvararg = SYSCALLS.get();
  SYSCALLS.varargs = socketvararg;
  switch (call) {
  case 1:
   {
    var domain = SYSCALLS.get(), type = SYSCALLS.get(), protocol = SYSCALLS.get();
    var sock = SOCKFS.createSocket(domain, type, protocol);
    assert(sock.stream.fd < 64);
    return sock.stream.fd;
   }
  case 2:
   {
    var sock = SYSCALLS.getSocketFromFD(), info = SYSCALLS.getSocketAddress();
    sock.sock_ops.bind(sock, info.addr, info.port);
    return 0;
   }
  case 3:
   {
    var sock = SYSCALLS.getSocketFromFD(), info = SYSCALLS.getSocketAddress();
    sock.sock_ops.connect(sock, info.addr, info.port);
    return 0;
   }
  case 4:
   {
    var sock = SYSCALLS.getSocketFromFD(), backlog = SYSCALLS.get();
    sock.sock_ops.listen(sock, backlog);
    return 0;
   }
  case 5:
   {
    var sock = SYSCALLS.getSocketFromFD(), addr = SYSCALLS.get(), addrlen = SYSCALLS.get();
    var newsock = sock.sock_ops.accept(sock);
    if (addr) {
     var res = __write_sockaddr(addr, newsock.family, DNS.lookup_name(newsock.daddr), newsock.dport);
     assert(!res.errno);
    }
    return newsock.stream.fd;
   }
  case 6:
   {
    var sock = SYSCALLS.getSocketFromFD(), addr = SYSCALLS.get(), addrlen = SYSCALLS.get();
    var res = __write_sockaddr(addr, sock.family, DNS.lookup_name(sock.saddr || "0.0.0.0"), sock.sport);
    assert(!res.errno);
    return 0;
   }
  case 7:
   {
    var sock = SYSCALLS.getSocketFromFD(), addr = SYSCALLS.get(), addrlen = SYSCALLS.get();
    if (!sock.daddr) {
     return -ERRNO_CODES.ENOTCONN;
    }
    var res = __write_sockaddr(addr, sock.family, DNS.lookup_name(sock.daddr), sock.dport);
    assert(!res.errno);
    return 0;
   }
  case 11:
   {
    var sock = SYSCALLS.getSocketFromFD(), message = SYSCALLS.get(), length = SYSCALLS.get(), flags = SYSCALLS.get(), dest = SYSCALLS.getSocketAddress(true);
    if (!dest) {
     return FS.write(sock.stream, HEAP8, message, length);
    } else {
     return sock.sock_ops.sendmsg(sock, HEAP8, message, length, dest.addr, dest.port);
    }
   }
  case 12:
   {
    var sock = SYSCALLS.getSocketFromFD(), buf = SYSCALLS.get(), len = SYSCALLS.get(), flags = SYSCALLS.get(), addr = SYSCALLS.get(), addrlen = SYSCALLS.get();
    var msg = sock.sock_ops.recvmsg(sock, len);
    if (!msg) return 0;
    if (addr) {
     var res = __write_sockaddr(addr, sock.family, DNS.lookup_name(msg.addr), msg.port);
     assert(!res.errno);
    }
    HEAPU8.set(msg.buffer, buf);
    return msg.buffer.byteLength;
   }
  case 14:
   {
    return -ERRNO_CODES.ENOPROTOOPT;
   }
  case 15:
   {
    var sock = SYSCALLS.getSocketFromFD(), level = SYSCALLS.get(), optname = SYSCALLS.get(), optval = SYSCALLS.get(), optlen = SYSCALLS.get();
    if (level === 1) {
     if (optname === 4) {
      HEAP32[optval >> 2] = sock.error;
      HEAP32[optlen >> 2] = 4;
      sock.error = null;
      return 0;
     }
    }
    return -ERRNO_CODES.ENOPROTOOPT;
   }
  case 16:
   {
    var sock = SYSCALLS.getSocketFromFD(), message = SYSCALLS.get(), flags = SYSCALLS.get();
    var iov = HEAP32[message + 8 >> 2];
    var num = HEAP32[message + 12 >> 2];
    var addr, port;
    var name = HEAP32[message >> 2];
    var namelen = HEAP32[message + 4 >> 2];
    if (name) {
     var info = __read_sockaddr(name, namelen);
     if (info.errno) return -info.errno;
     port = info.port;
     addr = DNS.lookup_addr(info.addr) || info.addr;
    }
    var total = 0;
    for (var i = 0; i < num; i++) {
     total += HEAP32[iov + (8 * i + 4) >> 2];
    }
    var view = new Uint8Array(total);
    var offset = 0;
    for (var i = 0; i < num; i++) {
     var iovbase = HEAP32[iov + (8 * i + 0) >> 2];
     var iovlen = HEAP32[iov + (8 * i + 4) >> 2];
     for (var j = 0; j < iovlen; j++) {
      view[offset++] = HEAP8[iovbase + j >> 0];
     }
    }
    return sock.sock_ops.sendmsg(sock, view, 0, total, addr, port);
   }
  case 17:
   {
    var sock = SYSCALLS.getSocketFromFD(), message = SYSCALLS.get(), flags = SYSCALLS.get();
    var iov = HEAP32[message + 8 >> 2];
    var num = HEAP32[message + 12 >> 2];
    var total = 0;
    for (var i = 0; i < num; i++) {
     total += HEAP32[iov + (8 * i + 4) >> 2];
    }
    var msg = sock.sock_ops.recvmsg(sock, total);
    if (!msg) return 0;
    var name = HEAP32[message >> 2];
    if (name) {
     var res = __write_sockaddr(name, sock.family, DNS.lookup_name(msg.addr), msg.port);
     assert(!res.errno);
    }
    var bytesRead = 0;
    var bytesRemaining = msg.buffer.byteLength;
    for (var i = 0; bytesRemaining > 0 && i < num; i++) {
     var iovbase = HEAP32[iov + (8 * i + 0) >> 2];
     var iovlen = HEAP32[iov + (8 * i + 4) >> 2];
     if (!iovlen) {
      continue;
     }
     var length = Math.min(iovlen, bytesRemaining);
     var buf = msg.buffer.subarray(bytesRead, bytesRead + length);
     HEAPU8.set(buf, iovbase + bytesRead);
     bytesRead += length;
     bytesRemaining -= length;
    }
    return bytesRead;
   }
  default:
   abort("unsupported socketcall syscall " + call);
  }
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall102"] = ___syscall102;
function _glDeleteBuffers(n, buffers) {
 for (var i = 0; i < n; i++) {
  var id = HEAP32[buffers + i * 4 >> 2];
  var buffer = GL.buffers[id];
  if (!buffer) continue;
  GLctx.deleteBuffer(buffer);
  buffer.name = 0;
  GL.buffers[id] = null;
  if (id == GL.currArrayBuffer) GL.currArrayBuffer = 0;
  if (id == GL.currElementArrayBuffer) GL.currElementArrayBuffer = 0;
 }
}
Module["_glDeleteBuffers"] = _glDeleteBuffers;
function _glScissor(x0, x1, x2, x3) {
 GLctx.scissor(x0, x1, x2, x3);
}
Module["_glScissor"] = _glScissor;
function _getgrent() {
 if (!Module["_getgrent"]) abort("external function 'getgrent' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_getgrent"].apply(null, arguments);
}
function _emscripten_glCheckFramebufferStatus(x0) {
 return GLctx.checkFramebufferStatus(x0);
}
Module["_emscripten_glCheckFramebufferStatus"] = _emscripten_glCheckFramebufferStatus;
function _emscripten_glDeleteProgram(id) {
 if (!id) return;
 var program = GL.programs[id];
 if (!program) {
  GL.recordError(1281);
  return;
 }
 GLctx.deleteProgram(program);
 program.name = 0;
 GL.programs[id] = null;
 GL.programInfos[id] = null;
}
Module["_emscripten_glDeleteProgram"] = _emscripten_glDeleteProgram;
function _JS_WebCamVideo_GetDeviceName(deviceId, buffer) {
 if (buffer) writeStringToMemory(MediaDevices[deviceId].deviceName, buffer, false);
 return MediaDevices[deviceId].length;
}
Module["_JS_WebCamVideo_GetDeviceName"] = _JS_WebCamVideo_GetDeviceName;
function ___syscall145(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD(), iov = SYSCALLS.get(), iovcnt = SYSCALLS.get();
  return SYSCALLS.doReadv(stream, iov, iovcnt);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall145"] = ___syscall145;
function _emscripten_glDisable(x0) {
 GLctx.disable(x0);
}
Module["_emscripten_glDisable"] = _emscripten_glDisable;
function ___syscall198(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var path = SYSCALLS.getStr(), owner = SYSCALLS.get(), group = SYSCALLS.get();
  FS.chown(path, owner, group);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall198"] = ___syscall198;
function ___cxa_decrement_exception_refcount(ptr) {
 EXCEPTIONS.decRef(EXCEPTIONS.deAdjust(ptr));
}
Module["___cxa_decrement_exception_refcount"] = ___cxa_decrement_exception_refcount;
function _emscripten_glGetActiveAttrib(program, index, bufSize, length, size, type, name) {
 program = GL.programs[program];
 var info = GLctx.getActiveAttrib(program, index);
 if (!info) return;
 var infoname = info.name.slice(0, Math.max(0, bufSize - 1));
 if (bufSize > 0 && name) {
  writeStringToMemory(infoname, name);
  if (length) HEAP32[length >> 2] = infoname.length;
 } else {
  if (length) HEAP32[length >> 2] = 0;
 }
 if (size) HEAP32[size >> 2] = info.size;
 if (type) HEAP32[type >> 2] = info.type;
}
Module["_emscripten_glGetActiveAttrib"] = _emscripten_glGetActiveAttrib;
function _emscripten_glLineWidth(x0) {
 GLctx.lineWidth(x0);
}
Module["_emscripten_glLineWidth"] = _emscripten_glLineWidth;
function __Z32RegisterAllStrippedInternalCallsv() {
 if (!Module["__Z32RegisterAllStrippedInternalCallsv"]) abort("external function '_Z32RegisterAllStrippedInternalCallsv' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["__Z32RegisterAllStrippedInternalCallsv"].apply(null, arguments);
}
function _emscripten_glGetString(name_) {
 if (GL.stringCache[name_]) return GL.stringCache[name_];
 var ret;
 switch (name_) {
 case 7936:
 case 7937:
 case 37445:
 case 37446:
  ret = allocate(intArrayFromString(GLctx.getParameter(name_)), "i8", ALLOC_NORMAL);
  break;
 case 7938:
  var glVersion = GLctx.getParameter(GLctx.VERSION);
  if (GLctx.canvas.GLctxObject.version >= 2) glVersion = "OpenGL ES 3.0 (" + glVersion + ")"; else {
   glVersion = "OpenGL ES 2.0 (" + glVersion + ")";
  }
  ret = allocate(intArrayFromString(glVersion), "i8", ALLOC_NORMAL);
  break;
 case 7939:
  var exts = GLctx.getSupportedExtensions();
  var gl_exts = [];
  for (var i in exts) {
   gl_exts.push(exts[i]);
   gl_exts.push("GL_" + exts[i]);
  }
  ret = allocate(intArrayFromString(gl_exts.join(" ")), "i8", ALLOC_NORMAL);
  break;
 case 35724:
  var glslVersion = GLctx.getParameter(GLctx.SHADING_LANGUAGE_VERSION);
  var ver_re = /^WebGL GLSL ES ([0-9]\.[0-9][0-9]?)(?:$| .*)/;
  var ver_num = glslVersion.match(ver_re);
  if (ver_num !== null) {
   if (ver_num[1].length == 3) ver_num[1] = ver_num[1] + "0";
   glslVersion = "OpenGL ES GLSL ES " + ver_num[1] + " (" + glslVersion + ")";
  }
  ret = allocate(intArrayFromString(glslVersion), "i8", ALLOC_NORMAL);
  break;
 default:
  GL.recordError(1280);
  return 0;
 }
 GL.stringCache[name_] = ret;
 return ret;
}
Module["_emscripten_glGetString"] = _emscripten_glGetString;
function _emscripten_glGetBufferParameteriv(target, value, data) {
 if (!data) {
  GL.recordError(1281);
  return;
 }
 HEAP32[data >> 2] = GLctx.getBufferParameter(target, value);
}
Module["_emscripten_glGetBufferParameteriv"] = _emscripten_glGetBufferParameteriv;
function _kill(pid, sig) {
 Module.printErr("Calling stub instead of kill()");
 ___setErrNo(ERRNO_CODES.EPERM);
 return -1;
}
Module["_kill"] = _kill;
function _emscripten_glGetAttribLocation(program, name) {
 program = GL.programs[program];
 name = Pointer_stringify(name);
 return GLctx.getAttribLocation(program, name);
}
Module["_emscripten_glGetAttribLocation"] = _emscripten_glGetAttribLocation;
function _emscripten_glVertexAttrib2f(x0, x1, x2) {
 GLctx.vertexAttrib2f(x0, x1, x2);
}
Module["_emscripten_glVertexAttrib2f"] = _emscripten_glVertexAttrib2f;
function _emscripten_glGetIntegerv(name_, p) {
 emscriptenWebGLGet(name_, p, "Integer");
}
Module["_emscripten_glGetIntegerv"] = _emscripten_glGetIntegerv;
function _glGetStringi(name, index) {
 if (GLctx.canvas.GLctxObject.version < 2) {
  GL.recordError(1282);
  return 0;
 }
 var stringiCache = GL.stringiCache[name];
 if (stringiCache) {
  if (index < 0 || index >= stringiCache.length) {
   GL.recordError(1281);
   return 0;
  }
  return stringiCache[index];
 }
 switch (name) {
 case 7939:
  var exts = GLctx.getSupportedExtensions();
  var gl_exts = [];
  for (var i in exts) {
   gl_exts.push(allocate(intArrayFromString(exts[i]), "i8", ALLOC_NORMAL));
   gl_exts.push(allocate(intArrayFromString("GL_" + exts[i]), "i8", ALLOC_NORMAL));
  }
  stringiCache = GL.stringiCache[name] = gl_exts;
  if (index < 0 || index >= stringiCache.length) {
   GL.recordError(1281);
   return 0;
  }
  return stringiCache[index];
 default:
  GL.recordError(1280);
  return 0;
 }
}
Module["_glGetStringi"] = _glGetStringi;
function _JS_Sound_SetLoop(channelInstance, loop) {
 if (WEBAudio.audioWebEnabled == 0) return;
 WEBAudio.audioInstances[channelInstance].source.loop = loop;
}
Module["_JS_Sound_SetLoop"] = _JS_Sound_SetLoop;
function _llvm_stackrestore(p) {
 var self = _llvm_stacksave;
 var ret = self.LLVM_SAVEDSTACKS[p];
 self.LLVM_SAVEDSTACKS.splice(p, 1);
 Runtime.stackRestore(ret);
}
Module["_llvm_stackrestore"] = _llvm_stackrestore;
function _JS_Sound_Load_PCM(channels, length, sampleRate, ptr) {
 if (WEBAudio.audioWebEnabled == 0) return 0;
 var sound = {
  buffer: WEBAudio.audioContext.createBuffer(channels, length, sampleRate),
  error: false
 };
 for (var i = 0; i < channels; i++) {
  var offs = (ptr >> 2) + length * i;
  var buffer = sound.buffer;
  var copyToChannel = buffer["copyToChannel"] || (function(source, channelNumber, startInChannel) {
   var clipped = source.subarray(0, Math.min(source.length, this.length - (startInChannel | 0)));
   this.getChannelData(channelNumber | 0).set(clipped, startInChannel | 0);
  });
  copyToChannel.apply(buffer, [ HEAPF32.subarray(offs, offs + length), i, 0 ]);
 }
 var instance = WEBAudio.audioInstances.push(sound) - 1;
 return instance;
}
Module["_JS_Sound_Load_PCM"] = _JS_Sound_Load_PCM;
function ___syscall218(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return -ERRNO_CODES.ENOSYS;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall218"] = ___syscall218;
function ___syscall219(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall219"] = ___syscall219;
function _il2cpp_unity_liveness_calculation_from_root() {
 if (!Module["_il2cpp_unity_liveness_calculation_from_root"]) abort("external function 'il2cpp_unity_liveness_calculation_from_root' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_unity_liveness_calculation_from_root"].apply(null, arguments);
}
function ___syscall212(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var path = SYSCALLS.getStr(), owner = SYSCALLS.get(), group = SYSCALLS.get();
  FS.chown(path, owner, group);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall212"] = ___syscall212;
function _emscripten_glReadPixels(x, y, width, height, format, type, pixels) {
 var pixelData = emscriptenWebGLGetTexPixelData(type, format, width, height, pixels, format);
 if (!pixelData) {
  GL.recordError(1280);
  return;
 }
 GLctx.readPixels(x, y, width, height, format, type, pixelData);
}
Module["_emscripten_glReadPixels"] = _emscripten_glReadPixels;
function __setLetterbox(element, topBottom, leftRight) {
 if (JSEvents.isInternetExplorer()) {
  element.style.marginLeft = element.style.marginRight = leftRight + "px";
  element.style.marginTop = element.style.marginBottom = topBottom + "px";
 } else {
  element.style.paddingLeft = element.style.paddingRight = leftRight + "px";
  element.style.paddingTop = element.style.paddingBottom = topBottom + "px";
 }
}
Module["__setLetterbox"] = __setLetterbox;
function _emscripten_do_request_fullscreen(target, strategy) {
 if (typeof JSEvents.fullscreenEnabled() === "undefined") return -1;
 if (!JSEvents.fullscreenEnabled()) return -3;
 if (!target) target = "#canvas";
 target = JSEvents.findEventTarget(target);
 if (!target) return -4;
 if (!target.requestFullscreen && !target.msRequestFullscreen && !target.mozRequestFullScreen && !target.mozRequestFullscreen && !target.webkitRequestFullscreen) {
  return -3;
 }
 var canPerformRequests = JSEvents.canPerformEventHandlerRequests();
 if (!canPerformRequests) {
  if (strategy.deferUntilInEventHandler) {
   JSEvents.deferCall(JSEvents.requestFullscreen, 1, [ target, strategy ]);
   return 1;
  } else {
   return -2;
  }
 }
 return JSEvents.requestFullscreen(target, strategy);
}
Module["_emscripten_do_request_fullscreen"] = _emscripten_do_request_fullscreen;
function _emscripten_request_fullscreen(target, deferUntilInEventHandler) {
 var strategy = {};
 strategy.scaleMode = 0;
 strategy.canvasResolutionScaleMode = 0;
 strategy.filteringMode = 0;
 strategy.deferUntilInEventHandler = deferUntilInEventHandler;
 return _emscripten_do_request_fullscreen(target, strategy);
}
Module["_emscripten_request_fullscreen"] = _emscripten_request_fullscreen;
function _emscripten_glGetError() {
 if (GL.lastError) {
  var error = GL.lastError;
  GL.lastError = 0;
  return error;
 } else {
  return GLctx.getError();
 }
}
Module["_emscripten_glGetError"] = _emscripten_glGetError;
function _emscripten_glFramebufferTexture2D(target, attachment, textarget, texture, level) {
 GLctx.framebufferTexture2D(target, attachment, textarget, GL.textures[texture], level);
}
Module["_emscripten_glFramebufferTexture2D"] = _emscripten_glFramebufferTexture2D;
function ___syscall39(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var path = SYSCALLS.getStr(), mode = SYSCALLS.get();
  return SYSCALLS.doMkdir(path, mode);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall39"] = ___syscall39;
function ___syscall38(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var old_path = SYSCALLS.getStr(), new_path = SYSCALLS.getStr();
  FS.rename(old_path, new_path);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall38"] = ___syscall38;
function ___syscall33(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var path = SYSCALLS.getStr(), amode = SYSCALLS.get();
  return SYSCALLS.doAccess(path, amode);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall33"] = ___syscall33;
function ___syscall36(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall36"] = ___syscall36;
function ___syscall34(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var inc = SYSCALLS.get();
  return -ERRNO_CODES.EPERM;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall34"] = ___syscall34;
function _il2cpp_thread_detach() {
 if (!Module["_il2cpp_thread_detach"]) abort("external function 'il2cpp_thread_detach' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_thread_detach"].apply(null, arguments);
}
function _glClearDepthf(x0) {
 GLctx.clearDepth(x0);
}
Module["_glClearDepthf"] = _glClearDepthf;
function _il2cpp_class_has_attribute() {
 if (!Module["_il2cpp_class_has_attribute"]) abort("external function 'il2cpp_class_has_attribute' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_has_attribute"].apply(null, arguments);
}
function _glGenTransformFeedbacks(n, ids) {
 for (var i = 0; i < n; i++) {
  var transformFeedback = GLctx["createTransformFeedback"]();
  if (!transformFeedback) {
   GL.recordError(1282);
   while (i < n) HEAP32[ids + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.transformFeedbacks);
  transformFeedback.name = id;
  GL.transformFeedbacks[id] = transformFeedback;
  HEAP32[ids + i * 4 >> 2] = id;
 }
}
Module["_glGenTransformFeedbacks"] = _glGenTransformFeedbacks;
Module["_memmove"] = _memmove;
function _il2cpp_class_get_field_from_name() {
 if (!Module["_il2cpp_class_get_field_from_name"]) abort("external function 'il2cpp_class_get_field_from_name' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_get_field_from_name"].apply(null, arguments);
}
function _glColorMask(x0, x1, x2, x3) {
 GLctx.colorMask(x0, x1, x2, x3);
}
Module["_glColorMask"] = _glColorMask;
Module["___uremdi3"] = ___uremdi3;
function _glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data) {
 var heapView;
 if (data) {
  heapView = HEAPU8.subarray(data, data + imageSize);
 } else {
  heapView = null;
 }
 GLctx["compressedTexSubImage2D"](target, level, xoffset, yoffset, width, height, format, heapView);
}
Module["_glCompressedTexSubImage2D"] = _glCompressedTexSubImage2D;
function _glGenTextures(n, textures) {
 for (var i = 0; i < n; i++) {
  var texture = GLctx.createTexture();
  if (!texture) {
   GL.recordError(1282);
   while (i < n) HEAP32[textures + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.textures);
  texture.name = id;
  GL.textures[id] = texture;
  HEAP32[textures + i * 4 >> 2] = id;
 }
}
Module["_glGenTextures"] = _glGenTextures;
function _glProgramBinary(program, binaryFormat, binary, length) {
 GL.recordError(1280);
}
Module["_glProgramBinary"] = _glProgramBinary;
function _il2cpp_assembly_get_image() {
 if (!Module["_il2cpp_assembly_get_image"]) abort("external function 'il2cpp_assembly_get_image' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_assembly_get_image"].apply(null, arguments);
}
function _JS_SystemInfo_GetHeight() {
 return systemInfo.get().height;
}
Module["_JS_SystemInfo_GetHeight"] = _JS_SystemInfo_GetHeight;
function _JS_SystemInfo_GetOS(buffer, bufferSize) {
 var browser = systemInfo.get().os + " " + systemInfo.get().osVersion;
 var result = browser;
 result = result.slice(0, Math.max(0, bufferSize));
 if (buffer) writeStringToMemory(result, buffer, true);
 return browser.length;
}
Module["_JS_SystemInfo_GetOS"] = _JS_SystemInfo_GetOS;
function ___syscall42() {
 return ___syscall51.apply(null, arguments);
}
Module["___syscall42"] = ___syscall42;
function _il2cpp_class_get_name() {
 if (!Module["_il2cpp_class_get_name"]) abort("external function 'il2cpp_class_get_name' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_get_name"].apply(null, arguments);
}
function ___syscall40(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var path = SYSCALLS.getStr();
  FS.rmdir(path);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall40"] = ___syscall40;
function _JS_WebRequest_SetResponseHandler(request, arg, onresponse) {
 var http = wr.requestInstances[request];
 http.onload = function http_onload(e) {
  if (onresponse) {
   var byteArray = new Uint8Array(http.response);
   if (byteArray.length != 0) {
    var buffer = _malloc(byteArray.length);
    HEAPU8.set(byteArray, buffer);
    Runtime.dynCall("viiiii", onresponse, [ arg, http.status, buffer, byteArray.length, 0 ]);
   } else {
    Runtime.dynCall("viiiii", onresponse, [ arg, http.status, 0, 0, 0 ]);
   }
  }
 };
 function HandleError(err) {
  if (onresponse) {
   var buffer = _malloc(err.length + 1);
   writeStringToMemory(err, buffer);
   Runtime.dynCall("viiiii", onresponse, [ arg, http.status, 0, 0, buffer ]);
   _free(buffer);
  }
 }
 http.onerror = function http_onerror(e) {
  HandleError("Unknown error.");
 };
 http.ontimeout = function http_onerror(e) {
  HandleError("Connection timed out.");
 };
 http.onabort = function http_onerror(e) {
  HandleError("Aborted.");
 };
}
Module["_JS_WebRequest_SetResponseHandler"] = _JS_WebRequest_SetResponseHandler;
function _il2cpp_init() {
 if (!Module["_il2cpp_init"]) abort("external function 'il2cpp_init' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_init"].apply(null, arguments);
}
function _emscripten_glGetProgramInfoLog(program, maxLength, length, infoLog) {
 var log = GLctx.getProgramInfoLog(GL.programs[program]);
 if (log === null) log = "(unknown error)";
 log = log.substr(0, maxLength - 1);
 if (maxLength > 0 && infoLog) {
  writeStringToMemory(log, infoLog);
  if (length) HEAP32[length >> 2] = log.length;
 } else {
  if (length) HEAP32[length >> 2] = 0;
 }
}
Module["_emscripten_glGetProgramInfoLog"] = _emscripten_glGetProgramInfoLog;
function _endgrent() {
 if (!Module["_endgrent"]) abort("external function 'endgrent' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_endgrent"].apply(null, arguments);
}
function _glClientWaitSync(sync, flags, timeoutLo, timeoutHi) {
 timeoutLo == timeoutLo >>> 0;
 timeoutHi == timeoutHi >>> 0;
 var timeout = timeoutLo == 4294967295 && timeoutHi == 4294967295 ? -1 : Runtime.makeBigInt(timeoutLo, timeoutHi, true);
 return GLctx.clientWaitSync(GL.syncs[sync], flags, timeout);
}
Module["_glClientWaitSync"] = _glClientWaitSync;
function _il2cpp_unity_liveness_calculation_begin() {
 if (!Module["_il2cpp_unity_liveness_calculation_begin"]) abort("external function 'il2cpp_unity_liveness_calculation_begin' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_unity_liveness_calculation_begin"].apply(null, arguments);
}
function _emscripten_glGetUniformfv(program, location, params) {
 emscriptenWebGLGetUniform(program, location, params, "Float");
}
Module["_emscripten_glGetUniformfv"] = _emscripten_glGetUniformfv;
function _glDepthFunc(x0) {
 GLctx.depthFunc(x0);
}
Module["_glDepthFunc"] = _glDepthFunc;
function _emscripten_exit_pointerlock() {
 JSEvents.removeDeferredCalls(JSEvents.requestPointerLock);
 if (document.exitPointerLock) {
  document.exitPointerLock();
 } else if (document.msExitPointerLock) {
  document.msExitPointerLock();
 } else if (document.mozExitPointerLock) {
  document.mozExitPointerLock();
 } else if (document.webkitExitPointerLock) {
  document.webkitExitPointerLock();
 } else {
  return -1;
 }
 return 0;
}
Module["_emscripten_exit_pointerlock"] = _emscripten_exit_pointerlock;
function _emscripten_glBindBuffer(target, buffer) {
 var bufferObj = buffer ? GL.buffers[buffer] : null;
 GLctx.bindBuffer(target, bufferObj);
}
Module["_emscripten_glBindBuffer"] = _emscripten_glBindBuffer;
function _glBlendEquation(x0) {
 GLctx.blendEquation(x0);
}
Module["_glBlendEquation"] = _glBlendEquation;
function _glGetUniformLocation(program, name) {
 name = Pointer_stringify(name);
 var arrayOffset = 0;
 if (name.indexOf("]", name.length - 1) !== -1) {
  var ls = name.lastIndexOf("[");
  var arrayIndex = name.slice(ls + 1, -1);
  if (arrayIndex.length > 0) {
   arrayOffset = parseInt(arrayIndex);
   if (arrayOffset < 0) {
    return -1;
   }
  }
  name = name.slice(0, ls);
 }
 var ptable = GL.programInfos[program];
 if (!ptable) {
  return -1;
 }
 var utable = ptable.uniforms;
 var uniformInfo = utable[name];
 if (uniformInfo && arrayOffset < uniformInfo[0]) {
  return uniformInfo[1] + arrayOffset;
 } else {
  return -1;
 }
}
Module["_glGetUniformLocation"] = _glGetUniformLocation;
function _il2cpp_class_is_valuetype() {
 if (!Module["_il2cpp_class_is_valuetype"]) abort("external function 'il2cpp_class_is_valuetype' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_is_valuetype"].apply(null, arguments);
}
function _emscripten_glFinish() {
 GLctx.finish();
}
Module["_emscripten_glFinish"] = _emscripten_glFinish;
function _glEndTransformFeedback() {
 GLctx.endTransformFeedback();
}
Module["_glEndTransformFeedback"] = _glEndTransformFeedback;
function _il2cpp_profiler_install() {
 if (!Module["_il2cpp_profiler_install"]) abort("external function 'il2cpp_profiler_install' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_profiler_install"].apply(null, arguments);
}
function _emscripten_glUniform1iv(location, count, value) {
 location = GL.uniforms[location];
 value = HEAP32.subarray(value >> 2, value + count * 4 >> 2);
 GLctx.uniform1iv(location, value);
}
Module["_emscripten_glUniform1iv"] = _emscripten_glUniform1iv;
function _glUniform4fv(location, count, value) {
 location = GL.uniforms[location];
 var view;
 if (4 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[4 * count - 1];
  for (var i = 0; i < 4 * count; i += 4) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 16 >> 2);
 }
 GLctx.uniform4fv(location, view);
}
Module["_glUniform4fv"] = _glUniform4fv;
function _emscripten_glTexCoordPointer() {
 if (!Module["_emscripten_glTexCoordPointer"]) abort("external function 'emscripten_glTexCoordPointer' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_emscripten_glTexCoordPointer"].apply(null, arguments);
}
function _glBeginTransformFeedback(x0) {
 GLctx.beginTransformFeedback(x0);
}
Module["_glBeginTransformFeedback"] = _glBeginTransformFeedback;
function _pthread_setspecific(key, value) {
 if (!(key in PTHREAD_SPECIFIC)) {
  return ERRNO_CODES.EINVAL;
 }
 PTHREAD_SPECIFIC[key] = value;
 return 0;
}
Module["_pthread_setspecific"] = _pthread_setspecific;
function _glViewport(x0, x1, x2, x3) {
 GLctx.viewport(x0, x1, x2, x3);
}
Module["_glViewport"] = _glViewport;
function _emscripten_glVertexAttrib1f(x0, x1) {
 GLctx.vertexAttrib1f(x0, x1);
}
Module["_emscripten_glVertexAttrib1f"] = _emscripten_glVertexAttrib1f;
function _glDeleteTransformFeedbacks(n, ids) {
 for (var i = 0; i < n; i++) {
  var id = HEAP32[ids + i * 4 >> 2];
  var transformFeedback = GL.transformFeedbacks[id];
  if (!transformFeedback) continue;
  GLctx["deleteTransformFeedback"](transformFeedback);
  transformFeedback.name = 0;
  GL.transformFeedbacks[id] = null;
 }
}
Module["_glDeleteTransformFeedbacks"] = _glDeleteTransformFeedbacks;
function _pthread_exit() {}
Module["_pthread_exit"] = _pthread_exit;
function _glCheckFramebufferStatus(x0) {
 return GLctx.checkFramebufferStatus(x0);
}
Module["_glCheckFramebufferStatus"] = _glCheckFramebufferStatus;
function _gmtime(time) {
 return _gmtime_r(time, ___tm_current);
}
Module["_gmtime"] = _gmtime;
function _il2cpp_array_new() {
 if (!Module["_il2cpp_array_new"]) abort("external function 'il2cpp_array_new' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_array_new"].apply(null, arguments);
}
function _glBindAttribLocation(program, index, name) {
 name = Pointer_stringify(name);
 GLctx.bindAttribLocation(GL.programs[program], index, name);
}
Module["_glBindAttribLocation"] = _glBindAttribLocation;
function _emscripten_glHint(x0, x1) {
 GLctx.hint(x0, x1);
}
Module["_emscripten_glHint"] = _emscripten_glHint;
function _emscripten_glShaderBinary() {
 GL.recordError(1280);
}
Module["_emscripten_glShaderBinary"] = _emscripten_glShaderBinary;
function _emscripten_glDepthRange(x0, x1) {
 GLctx.depthRange(x0, x1);
}
Module["_emscripten_glDepthRange"] = _emscripten_glDepthRange;
function _emscripten_glBlendColor(x0, x1, x2, x3) {
 GLctx.blendColor(x0, x1, x2, x3);
}
Module["_emscripten_glBlendColor"] = _emscripten_glBlendColor;
function ___mulsc3() {
 if (!Module["___mulsc3"]) abort("external function '__mulsc3' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["___mulsc3"].apply(null, arguments);
}
Module["___udivdi3"] = ___udivdi3;
function _emscripten_glUniform4fv(location, count, value) {
 location = GL.uniforms[location];
 var view;
 if (4 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[4 * count - 1];
  for (var i = 0; i < 4 * count; i += 4) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 16 >> 2);
 }
 GLctx.uniform4fv(location, view);
}
Module["_emscripten_glUniform4fv"] = _emscripten_glUniform4fv;
function _glBufferSubData(target, offset, size, data) {
 GLctx.bufferSubData(target, offset, HEAPU8.subarray(data, data + size));
}
Module["_glBufferSubData"] = _glBufferSubData;
function _glMapBufferRange() {
 if (!Module["_glMapBufferRange"]) abort("external function 'glMapBufferRange' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_glMapBufferRange"].apply(null, arguments);
}
function __Z39RegisterStaticallyLinkedModulesGranularv() {
 if (!Module["__Z39RegisterStaticallyLinkedModulesGranularv"]) abort("external function '_Z39RegisterStaticallyLinkedModulesGranularv' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["__Z39RegisterStaticallyLinkedModulesGranularv"].apply(null, arguments);
}
Module["_llvm_ctlz_i64"] = _llvm_ctlz_i64;
function _il2cpp_thread_current() {
 if (!Module["_il2cpp_thread_current"]) abort("external function 'il2cpp_thread_current' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_thread_current"].apply(null, arguments);
}
function ___syscall41(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var old = SYSCALLS.getStreamFromFD();
  return FS.open(old.path, old.flags, 0).fd;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall41"] = ___syscall41;
function _emscripten_glUniform4iv(location, count, value) {
 location = GL.uniforms[location];
 count *= 4;
 value = HEAP32.subarray(value >> 2, value + count * 4 >> 2);
 GLctx.uniform4iv(location, value);
}
Module["_emscripten_glUniform4iv"] = _emscripten_glUniform4iv;
function _emscripten_glBindTexture(target, texture) {
 GLctx.bindTexture(target, texture ? GL.textures[texture] : null);
}
Module["_emscripten_glBindTexture"] = _emscripten_glBindTexture;
function _emscripten_glUniform1i(location, v0) {
 location = GL.uniforms[location];
 GLctx.uniform1i(location, v0);
}
Module["_emscripten_glUniform1i"] = _emscripten_glUniform1i;
function _JS_SystemInfo_GetWidth() {
 return systemInfo.get().width;
}
Module["_JS_SystemInfo_GetWidth"] = _JS_SystemInfo_GetWidth;
function _emscripten_glVertexAttrib2fv(index, v) {
 var view = GL.miniTempBufferViews[1];
 view[0] = HEAPF32[v >> 2];
 view[1] = HEAPF32[v + 4 >> 2];
 GLctx.vertexAttrib2fv(index, view);
}
Module["_emscripten_glVertexAttrib2fv"] = _emscripten_glVertexAttrib2fv;
function _glGetShaderPrecisionFormat(shaderType, precisionType, range, precision) {
 var result = GLctx.getShaderPrecisionFormat(shaderType, precisionType);
 HEAP32[range >> 2] = result.rangeMin;
 HEAP32[range + 4 >> 2] = result.rangeMax;
 HEAP32[precision >> 2] = result.precision;
}
Module["_glGetShaderPrecisionFormat"] = _glGetShaderPrecisionFormat;
function _il2cpp_class_get_flags() {
 if (!Module["_il2cpp_class_get_flags"]) abort("external function 'il2cpp_class_get_flags' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_get_flags"].apply(null, arguments);
}
function _emscripten_glDeleteObjectARB() {
 if (!Module["_emscripten_glDeleteObjectARB"]) abort("external function 'emscripten_glDeleteObjectARB' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_emscripten_glDeleteObjectARB"].apply(null, arguments);
}
function _emscripten_set_touchmove_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerTouchEventCallback(target, userData, useCapture, callbackfunc, 24, "touchmove");
 return 0;
}
Module["_emscripten_set_touchmove_callback"] = _emscripten_set_touchmove_callback;
function _emscripten_glUniform1f(location, v0) {
 location = GL.uniforms[location];
 GLctx.uniform1f(location, v0);
}
Module["_emscripten_glUniform1f"] = _emscripten_glUniform1f;
function _emscripten_glVertexAttribPointer(index, size, type, normalized, stride, ptr) {
 GLctx.vertexAttribPointer(index, size, type, normalized, stride, ptr);
}
Module["_emscripten_glVertexAttribPointer"] = _emscripten_glVertexAttribPointer;
function _glShaderSource(shader, count, string, length) {
 var source = GL.getSource(shader, count, string, length);
 GLctx.shaderSource(GL.shaders[shader], source);
}
Module["_glShaderSource"] = _glShaderSource;
function _pthread_create() {
 return 11;
}
Module["_pthread_create"] = _pthread_create;
function _emscripten_glGenBuffers(n, buffers) {
 for (var i = 0; i < n; i++) {
  var buffer = GLctx.createBuffer();
  if (!buffer) {
   GL.recordError(1282);
   while (i < n) HEAP32[buffers + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.buffers);
  buffer.name = id;
  GL.buffers[id] = buffer;
  HEAP32[buffers + i * 4 >> 2] = id;
 }
}
Module["_emscripten_glGenBuffers"] = _emscripten_glGenBuffers;
function _emscripten_set_keypress_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerKeyEventCallback(target, userData, useCapture, callbackfunc, 1, "keypress");
 return 0;
}
Module["_emscripten_set_keypress_callback"] = _emscripten_set_keypress_callback;
function ___syscall94(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var fd = SYSCALLS.get(), mode = SYSCALLS.get();
  FS.fchmod(fd, mode);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall94"] = ___syscall94;
function _JS_SystemInfo_GetCurrentCanvasHeight() {
 return Module["canvas"].clientHeight;
}
Module["_JS_SystemInfo_GetCurrentCanvasHeight"] = _JS_SystemInfo_GetCurrentCanvasHeight;
var PTHREAD_SPECIFIC_NEXT_KEY = 1;
Module["PTHREAD_SPECIFIC_NEXT_KEY"] = PTHREAD_SPECIFIC_NEXT_KEY;
function _pthread_key_create(key, destructor) {
 if (key == 0) {
  return ERRNO_CODES.EINVAL;
 }
 HEAP32[key >> 2] = PTHREAD_SPECIFIC_NEXT_KEY;
 PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY] = 0;
 PTHREAD_SPECIFIC_NEXT_KEY++;
 return 0;
}
Module["_pthread_key_create"] = _pthread_key_create;
function _il2cpp_method_is_inflated() {
 if (!Module["_il2cpp_method_is_inflated"]) abort("external function 'il2cpp_method_is_inflated' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_method_is_inflated"].apply(null, arguments);
}
function _il2cpp_object_new() {
 if (!Module["_il2cpp_object_new"]) abort("external function 'il2cpp_object_new' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_object_new"].apply(null, arguments);
}
function ___syscall96(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall96"] = ___syscall96;
function ___syscall151() {
 return ___syscall153.apply(null, arguments);
}
Module["___syscall151"] = ___syscall151;
function ___syscall150() {
 return ___syscall153.apply(null, arguments);
}
Module["___syscall150"] = ___syscall150;
function _JS_Sound_Create_Channel(callback, userData) {
 if (WEBAudio.audioWebEnabled == 0) return;
 var channel = {
  gain: WEBAudio.audioContext.createGain(),
  panner: WEBAudio.audioContext.createPanner(),
  threeD: false,
  playBuffer: (function(delay, buffer, offset) {
   this.source.buffer = buffer;
   var chan = this;
   this.source.onended = (function() {
    if (callback) Runtime.dynCall("vi", callback, [ userData ]);
    chan.setup();
   });
   this.source.start(delay, offset);
  }),
  setup: (function() {
   this.source = WEBAudio.audioContext.createBufferSource();
   this.setupPanning();
  }),
  setupPanning: (function() {
   if (this.threeD) {
    this.source.disconnect();
    this.source.connect(this.panner);
    this.panner.connect(this.gain);
   } else {
    this.panner.disconnect();
    this.source.connect(this.gain);
   }
  })
 };
 channel.panner.rolloffFactor = 0;
 channel.gain.connect(WEBAudio.audioContext.destination);
 channel.setup();
 return WEBAudio.audioInstances.push(channel) - 1;
}
Module["_JS_Sound_Create_Channel"] = _JS_Sound_Create_Channel;
function ___syscall91(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var addr = SYSCALLS.get(), len = SYSCALLS.get();
  var info = SYSCALLS.mappings[addr];
  if (!info) return 0;
  if (len === info.len) {
   var stream = FS.getStream(info.fd);
   SYSCALLS.doMsync(addr, stream, len, info.flags);
   FS.munmap(stream);
   SYSCALLS.mappings[addr] = null;
   if (info.allocated) {
    _free(info.malloc);
   }
  }
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall91"] = ___syscall91;
function _pthread_cond_timedwait() {
 return 0;
}
Module["_pthread_cond_timedwait"] = _pthread_cond_timedwait;
function ___restore_sigs() {
 if (!Module["___restore_sigs"]) abort("external function '__restore_sigs' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["___restore_sigs"].apply(null, arguments);
}
function _emscripten_glAttachShader(program, shader) {
 GLctx.attachShader(GL.programs[program], GL.shaders[shader]);
}
Module["_emscripten_glAttachShader"] = _emscripten_glAttachShader;
function ___syscall77(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var who = SYSCALLS.get(), usage = SYSCALLS.get();
  _memset(usage, 0, 136);
  HEAP32[usage >> 2] = 1;
  HEAP32[usage + 4 >> 2] = 2;
  HEAP32[usage + 8 >> 2] = 3;
  HEAP32[usage + 12 >> 2] = 4;
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall77"] = ___syscall77;
function ___syscall75(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall75"] = ___syscall75;
function _glBufferData(target, size, data, usage) {
 switch (usage) {
 case 35041:
 case 35042:
  usage = 35040;
  break;
 case 35045:
 case 35046:
  usage = 35044;
  break;
 case 35049:
 case 35050:
  usage = 35048;
  break;
 }
 if (!data) {
  GLctx.bufferData(target, size, usage);
 } else {
  GLctx.bufferData(target, HEAPU8.subarray(data, data + size), usage);
 }
}
Module["_glBufferData"] = _glBufferData;
function _il2cpp_domain_get() {
 if (!Module["_il2cpp_domain_get"]) abort("external function 'il2cpp_domain_get' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_domain_get"].apply(null, arguments);
}
function _sched_yield() {
 return 0;
}
Module["_sched_yield"] = _sched_yield;
function _emscripten_glGetRenderbufferParameteriv(target, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 HEAP32[params >> 2] = GLctx.getRenderbufferParameter(target, pname);
}
Module["_emscripten_glGetRenderbufferParameteriv"] = _emscripten_glGetRenderbufferParameteriv;
function _glGetError() {
 if (GL.lastError) {
  var error = GL.lastError;
  GL.lastError = 0;
  return error;
 } else {
  return GLctx.getError();
 }
}
Module["_glGetError"] = _glGetError;
function _emscripten_glDrawBuffers(n, bufs) {
 var bufArray = [];
 for (var i = 0; i < n; i++) bufArray.push(HEAP32[bufs + i * 4 >> 2]);
 if (n == 0) {
  if (GLctx.getParameter(GLctx["DRAW_FRAMEBUFFER_BINDING"]) != 0) bufArray.push(GLctx["NONE"]); else {
   GL.recordError(1282);
   return;
  }
 }
 GLctx["drawBuffers"](bufArray);
}
Module["_emscripten_glDrawBuffers"] = _emscripten_glDrawBuffers;
function _il2cpp_capture_memory_snapshot() {
 if (!Module["_il2cpp_capture_memory_snapshot"]) abort("external function 'il2cpp_capture_memory_snapshot' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_capture_memory_snapshot"].apply(null, arguments);
}
function _glGetProgramBinary(program, bufSize, length, binaryFormat, binary) {
 GL.recordError(1282);
}
Module["_glGetProgramBinary"] = _glGetProgramBinary;
Module["_pthread_mutex_unlock"] = _pthread_mutex_unlock;
function _emscripten_glBindFramebuffer(target, framebuffer) {
 GLctx.bindFramebuffer(target, framebuffer ? GL.framebuffers[framebuffer] : null);
}
Module["_emscripten_glBindFramebuffer"] = _emscripten_glBindFramebuffer;
function _emscripten_glBufferSubData(target, offset, size, data) {
 GLctx.bufferSubData(target, offset, HEAPU8.subarray(data, data + size));
}
Module["_emscripten_glBufferSubData"] = _emscripten_glBufferSubData;
function _JS_WebRequest_GetResponseHeaders(request, buffer, bufferSize) {
 var headers = wr.requestInstances[request].getAllResponseHeaders();
 var headersTruncated = headers.slice(0, Math.max(0, bufferSize));
 if (buffer) writeStringToMemory(headersTruncated, buffer, true);
 return headers.length;
}
Module["_JS_WebRequest_GetResponseHeaders"] = _JS_WebRequest_GetResponseHeaders;
function _emscripten_set_keydown_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerKeyEventCallback(target, userData, useCapture, callbackfunc, 2, "keydown");
 return 0;
}
Module["_emscripten_set_keydown_callback"] = _emscripten_set_keydown_callback;
function _sbrk(bytes) {
 var self = _sbrk;
 if (!self.called) {
  DYNAMICTOP = alignMemoryPage(DYNAMICTOP);
  self.called = true;
  assert(Runtime.dynamicAlloc);
  self.alloc = Runtime.dynamicAlloc;
  Runtime.dynamicAlloc = (function() {
   abort("cannot dynamically allocate, sbrk now has control");
  });
 }
 var ret = DYNAMICTOP;
 if (bytes != 0) {
  var success = self.alloc(bytes);
  if (!success) return -1 >>> 0;
 }
 return ret;
}
Module["_sbrk"] = _sbrk;
Module["_bitshift64Shl"] = _bitshift64Shl;
function ___syscall83(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var target = SYSCALLS.getStr(), linkpath = SYSCALLS.getStr();
  FS.symlink(target, linkpath);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall83"] = ___syscall83;
function _il2cpp_method_get_param() {
 if (!Module["_il2cpp_method_get_param"]) abort("external function 'il2cpp_method_get_param' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_method_get_param"].apply(null, arguments);
}
function ___gxx_personality_v0() {}
Module["___gxx_personality_v0"] = ___gxx_personality_v0;
function _glGetIntegerv(name_, p) {
 emscriptenWebGLGet(name_, p, "Integer");
}
Module["_glGetIntegerv"] = _glGetIntegerv;
function _posix_spawn_file_actions_destroy() {
 if (!Module["_posix_spawn_file_actions_destroy"]) abort("external function 'posix_spawn_file_actions_destroy' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_posix_spawn_file_actions_destroy"].apply(null, arguments);
}
function _glFrontFace(x0) {
 GLctx.frontFace(x0);
}
Module["_glFrontFace"] = _glFrontFace;
function _glDepthMask(x0) {
 GLctx.depthMask(x0);
}
Module["_glDepthMask"] = _glDepthMask;
function _il2cpp_class_get_declaring_type() {
 if (!Module["_il2cpp_class_get_declaring_type"]) abort("external function 'il2cpp_class_get_declaring_type' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_get_declaring_type"].apply(null, arguments);
}
function ___syscall320(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var dirfd = SYSCALLS.get(), path = SYSCALLS.getStr(), times = SYSCALLS.get(), flags = SYSCALLS.get();
  assert(flags === 0);
  path = SYSCALLS.calculateAt(dirfd, path);
  var seconds = HEAP32[times >> 2];
  var nanoseconds = HEAP32[times + 4 >> 2];
  var atime = seconds * 1e3 + nanoseconds / (1e3 * 1e3);
  times += 8;
  seconds = HEAP32[times >> 2];
  nanoseconds = HEAP32[times + 4 >> 2];
  var mtime = seconds * 1e3 + nanoseconds / (1e3 * 1e3);
  FS.utime(path, atime, mtime);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall320"] = ___syscall320;
function _emscripten_webgl_make_context_current(contextHandle) {
 var success = GL.makeContextCurrent(contextHandle);
 return success ? 0 : -5;
}
Module["_emscripten_webgl_make_context_current"] = _emscripten_webgl_make_context_current;
function ___syscall324(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD(), mode = SYSCALLS.get(), offset = SYSCALLS.get64(), len = SYSCALLS.get64();
  assert(mode === 0);
  FS.allocate(stream, offset, len);
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall324"] = ___syscall324;
function _glTexImage2D(target, level, internalFormat, width, height, border, format, type, pixels) {
 var pixelData = null;
 if (pixels) pixelData = emscriptenWebGLGetTexPixelData(type, format, width, height, pixels, internalFormat);
 GLctx.texImage2D(target, level, internalFormat, width, height, border, format, type, pixelData);
}
Module["_glTexImage2D"] = _glTexImage2D;
function _syscall() {
 if (!Module["_syscall"]) abort("external function 'syscall' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_syscall"].apply(null, arguments);
}
function _il2cpp_class_get_fields() {
 if (!Module["_il2cpp_class_get_fields"]) abort("external function 'il2cpp_class_get_fields' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_get_fields"].apply(null, arguments);
}
function _glStencilMask(x0) {
 GLctx.stencilMask(x0);
}
Module["_glStencilMask"] = _glStencilMask;
function _pthread_mutexattr_settype() {}
Module["_pthread_mutexattr_settype"] = _pthread_mutexattr_settype;
function ___syscall64(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return PROCINFO.ppid;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall64"] = ___syscall64;
function _pthread_cond_destroy() {
 return 0;
}
Module["_pthread_cond_destroy"] = _pthread_cond_destroy;
Module["___divdi3"] = ___divdi3;
function _JS_Cursor_SetImage(ptr, length) {
 var binary = "";
 for (var i = 0; i < length; i++) {
  binary += String.fromCharCode(HEAPU8[ptr + i]);
 }
 var base64 = btoa(binary);
 var cursor = "url(data:image/cur;base64," + base64 + "),default";
 _JS_Cursor_SetCursorString(cursor);
}
Module["_JS_Cursor_SetImage"] = _JS_Cursor_SetImage;
function ___unlock() {}
Module["___unlock"] = ___unlock;
function ___syscall132(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var pid = SYSCALLS.get();
  if (pid && pid !== PROCINFO.pid) return -ERRNO_CODES.ESRCH;
  return PROCINFO.pgid;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall132"] = ___syscall132;
function _JS_WebRequest_Release(request) {
 var http = wr.requestInstances[request];
 http.onload = null;
 http.onerror = null;
 http.ontimeout = null;
 http.onabort = null;
 delete http;
 wr.requestInstances[request] = null;
}
Module["_JS_WebRequest_Release"] = _JS_WebRequest_Release;
function _il2cpp_exception_from_name_msg() {
 if (!Module["_il2cpp_exception_from_name_msg"]) abort("external function 'il2cpp_exception_from_name_msg' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_exception_from_name_msg"].apply(null, arguments);
}
function _il2cpp_method_get_return_type() {
 if (!Module["_il2cpp_method_get_return_type"]) abort("external function 'il2cpp_method_get_return_type' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_method_get_return_type"].apply(null, arguments);
}
function ___cxa_allocate_exception(size) {
 return _malloc(size);
}
Module["___cxa_allocate_exception"] = ___cxa_allocate_exception;
function _emscripten_glGetProgramiv(program, pname, p) {
 if (!p) {
  GL.recordError(1281);
  return;
 }
 if (pname == 35716) {
  var log = GLctx.getProgramInfoLog(GL.programs[program]);
  if (log === null) log = "(unknown error)";
  HEAP32[p >> 2] = log.length + 1;
 } else if (pname == 35719) {
  var ptable = GL.programInfos[program];
  if (ptable) {
   HEAP32[p >> 2] = ptable.maxUniformLength;
   return;
  } else if (program < GL.counter) {
   GL.recordError(1282);
  } else {
   GL.recordError(1281);
  }
 } else if (pname == 35722) {
  var ptable = GL.programInfos[program];
  if (ptable) {
   if (ptable.maxAttributeLength == -1) {
    var program = GL.programs[program];
    var numAttribs = GLctx.getProgramParameter(program, GLctx.ACTIVE_ATTRIBUTES);
    ptable.maxAttributeLength = 0;
    for (var i = 0; i < numAttribs; ++i) {
     var activeAttrib = GLctx.getActiveAttrib(program, i);
     ptable.maxAttributeLength = Math.max(ptable.maxAttributeLength, activeAttrib.name.length + 1);
    }
   }
   HEAP32[p >> 2] = ptable.maxAttributeLength;
   return;
  } else if (program < GL.counter) {
   GL.recordError(1282);
  } else {
   GL.recordError(1281);
  }
 } else {
  HEAP32[p >> 2] = GLctx.getProgramParameter(GL.programs[program], pname);
 }
}
Module["_emscripten_glGetProgramiv"] = _emscripten_glGetProgramiv;
function _emscripten_glTexImage2D(target, level, internalFormat, width, height, border, format, type, pixels) {
 var pixelData = null;
 if (pixels) pixelData = emscriptenWebGLGetTexPixelData(type, format, width, height, pixels, internalFormat);
 GLctx.texImage2D(target, level, internalFormat, width, height, border, format, type, pixelData);
}
Module["_emscripten_glTexImage2D"] = _emscripten_glTexImage2D;
function ___cxa_rethrow_primary_exception(ptr) {
 if (!ptr) return;
 EXCEPTIONS.caught.push(ptr);
 ___cxa_rethrow();
}
Module["___cxa_rethrow_primary_exception"] = ___cxa_rethrow_primary_exception;
function _emscripten_glGenVertexArrays(n, arrays) {
 for (var i = 0; i < n; i++) {
  var vao = GLctx["createVertexArray"]();
  if (!vao) {
   GL.recordError(1282);
   while (i < n) HEAP32[arrays + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.vaos);
  vao.name = id;
  GL.vaos[id] = vao;
  HEAP32[arrays + i * 4 >> 2] = id;
 }
}
Module["_emscripten_glGenVertexArrays"] = _emscripten_glGenVertexArrays;
function _emscripten_glActiveTexture(x0) {
 GLctx.activeTexture(x0);
}
Module["_emscripten_glActiveTexture"] = _emscripten_glActiveTexture;
function _glUniformMatrix4fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (16 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[16 * count - 1];
  for (var i = 0; i < 16 * count; i += 16) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
   view[i + 4] = HEAPF32[value + (4 * i + 16) >> 2];
   view[i + 5] = HEAPF32[value + (4 * i + 20) >> 2];
   view[i + 6] = HEAPF32[value + (4 * i + 24) >> 2];
   view[i + 7] = HEAPF32[value + (4 * i + 28) >> 2];
   view[i + 8] = HEAPF32[value + (4 * i + 32) >> 2];
   view[i + 9] = HEAPF32[value + (4 * i + 36) >> 2];
   view[i + 10] = HEAPF32[value + (4 * i + 40) >> 2];
   view[i + 11] = HEAPF32[value + (4 * i + 44) >> 2];
   view[i + 12] = HEAPF32[value + (4 * i + 48) >> 2];
   view[i + 13] = HEAPF32[value + (4 * i + 52) >> 2];
   view[i + 14] = HEAPF32[value + (4 * i + 56) >> 2];
   view[i + 15] = HEAPF32[value + (4 * i + 60) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 64 >> 2);
 }
 GLctx.uniformMatrix4fv(location, transpose, view);
}
Module["_glUniformMatrix4fv"] = _glUniformMatrix4fv;
function _glCopyBufferSubData(x0, x1, x2, x3, x4) {
 GLctx.copyBufferSubData(x0, x1, x2, x3, x4);
}
Module["_glCopyBufferSubData"] = _glCopyBufferSubData;
function _il2cpp_set_commandline_arguments() {
 if (!Module["_il2cpp_set_commandline_arguments"]) abort("external function 'il2cpp_set_commandline_arguments' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_set_commandline_arguments"].apply(null, arguments);
}
function ___syscall183(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var buf = SYSCALLS.get(), size = SYSCALLS.get();
  if (size === 0) return -ERRNO_CODES.EINVAL;
  var cwd = FS.cwd();
  if (size < cwd.length + 1) return -ERRNO_CODES.ERANGE;
  writeAsciiToMemory(cwd, buf);
  return buf;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall183"] = ___syscall183;
function ___syscall180(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD(), buf = SYSCALLS.get(), count = SYSCALLS.get(), zero = SYSCALLS.getZero(), offset = SYSCALLS.get64();
  return FS.read(stream, HEAP8, buf, count, offset);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall180"] = ___syscall180;
function ___syscall181(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var stream = SYSCALLS.getStreamFromFD(), buf = SYSCALLS.get(), count = SYSCALLS.get(), zero = SYSCALLS.getZero(), offset = SYSCALLS.get64();
  return FS.write(stream, HEAP8, buf, nbyte, offset);
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall181"] = ___syscall181;
function _il2cpp_set_data_dir() {
 if (!Module["_il2cpp_set_data_dir"]) abort("external function 'il2cpp_set_data_dir' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_set_data_dir"].apply(null, arguments);
}
function _glGetUniformBlockIndex(program, uniformBlockName) {
 program = GL.programs[program];
 uniformBlockName = Pointer_stringify(uniformBlockName);
 return GLctx["getUniformBlockIndex"](program, uniformBlockName);
}
Module["_glGetUniformBlockIndex"] = _glGetUniformBlockIndex;
function _emscripten_glClientActiveTexture() {
 if (!Module["_emscripten_glClientActiveTexture"]) abort("external function 'emscripten_glClientActiveTexture' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_emscripten_glClientActiveTexture"].apply(null, arguments);
}
function _glGetActiveUniform(program, index, bufSize, length, size, type, name) {
 program = GL.programs[program];
 var info = GLctx.getActiveUniform(program, index);
 if (!info) return;
 var infoname = info.name.slice(0, Math.max(0, bufSize - 1));
 if (bufSize > 0 && name) {
  writeStringToMemory(infoname, name);
  if (length) HEAP32[length >> 2] = infoname.length;
 } else {
  if (length) HEAP32[length >> 2] = 0;
 }
 if (size) HEAP32[size >> 2] = info.size;
 if (type) HEAP32[type >> 2] = info.type;
}
Module["_glGetActiveUniform"] = _glGetActiveUniform;
function _emscripten_glValidateProgram(program) {
 GLctx.validateProgram(GL.programs[program]);
}
Module["_emscripten_glValidateProgram"] = _emscripten_glValidateProgram;
function _emscripten_get_main_loop_timing(mode, value) {
 if (mode) HEAP32[mode >> 2] = Browser.mainLoop.timingMode;
 if (value) HEAP32[value >> 2] = Browser.mainLoop.timingValue;
}
Module["_emscripten_get_main_loop_timing"] = _emscripten_get_main_loop_timing;
function _JS_WebRequest_SetTimeout(request, timeout) {
 wr.requestInstances[request].timeout = timeout;
}
Module["_JS_WebRequest_SetTimeout"] = _JS_WebRequest_SetTimeout;
function _difftime(time1, time0) {
 return time1 - time0;
}
Module["_difftime"] = _difftime;
function _emscripten_webgl_get_current_context() {
 return GL.currentContext ? GL.currentContext.handle : 0;
}
Module["_emscripten_webgl_get_current_context"] = _emscripten_webgl_get_current_context;
function _emscripten_glPixelStorei(pname, param) {
 if (pname == 3333) {
  GL.packAlignment = param;
 } else if (pname == 3317) {
  GL.unpackAlignment = param;
 }
 GLctx.pixelStorei(pname, param);
}
Module["_emscripten_glPixelStorei"] = _emscripten_glPixelStorei;
function _emscripten_glDeleteTextures(n, textures) {
 for (var i = 0; i < n; i++) {
  var id = HEAP32[textures + i * 4 >> 2];
  var texture = GL.textures[id];
  if (!texture) continue;
  GLctx.deleteTexture(texture);
  texture.name = 0;
  GL.textures[id] = null;
 }
}
Module["_emscripten_glDeleteTextures"] = _emscripten_glDeleteTextures;
function _glGetString(name_) {
 if (GL.stringCache[name_]) return GL.stringCache[name_];
 var ret;
 switch (name_) {
 case 7936:
 case 7937:
 case 37445:
 case 37446:
  ret = allocate(intArrayFromString(GLctx.getParameter(name_)), "i8", ALLOC_NORMAL);
  break;
 case 7938:
  var glVersion = GLctx.getParameter(GLctx.VERSION);
  if (GLctx.canvas.GLctxObject.version >= 2) glVersion = "OpenGL ES 3.0 (" + glVersion + ")"; else {
   glVersion = "OpenGL ES 2.0 (" + glVersion + ")";
  }
  ret = allocate(intArrayFromString(glVersion), "i8", ALLOC_NORMAL);
  break;
 case 7939:
  var exts = GLctx.getSupportedExtensions();
  var gl_exts = [];
  for (var i in exts) {
   gl_exts.push(exts[i]);
   gl_exts.push("GL_" + exts[i]);
  }
  ret = allocate(intArrayFromString(gl_exts.join(" ")), "i8", ALLOC_NORMAL);
  break;
 case 35724:
  var glslVersion = GLctx.getParameter(GLctx.SHADING_LANGUAGE_VERSION);
  var ver_re = /^WebGL GLSL ES ([0-9]\.[0-9][0-9]?)(?:$| .*)/;
  var ver_num = glslVersion.match(ver_re);
  if (ver_num !== null) {
   if (ver_num[1].length == 3) ver_num[1] = ver_num[1] + "0";
   glslVersion = "OpenGL ES GLSL ES " + ver_num[1] + " (" + glslVersion + ")";
  }
  ret = allocate(intArrayFromString(glslVersion), "i8", ALLOC_NORMAL);
  break;
 default:
  GL.recordError(1280);
  return 0;
 }
 GL.stringCache[name_] = ret;
 return ret;
}
Module["_glGetString"] = _glGetString;
function _pthread_mutexattr_destroy() {}
Module["_pthread_mutexattr_destroy"] = _pthread_mutexattr_destroy;
function _il2cpp_class_get_namespace() {
 if (!Module["_il2cpp_class_get_namespace"]) abort("external function 'il2cpp_class_get_namespace' is missing. perhaps a side module was not linked in? if this function was expected to arrive from a system library, try to build the MAIN_MODULE with EMCC_FORCE_STDLIBS=1 in the environment");
 return Module["_il2cpp_class_get_namespace"].apply(null, arguments);
}
var _llvm_nacl_atomic_cmpxchg_i32 = undefined;
Module["_llvm_nacl_atomic_cmpxchg_i32"] = _llvm_nacl_atomic_cmpxchg_i32;
Module["_llvm_bswap_i16"] = _llvm_bswap_i16;
function _time(ptr) {
 var ret = Date.now() / 1e3 | 0;
 if (ptr) {
  HEAP32[ptr >> 2] = ret;
 }
 return ret;
}
Module["_time"] = _time;
Module["_pthread_self"] = _pthread_self;
function _emscripten_glGetBooleanv(name_, p) {
 emscriptenWebGLGet(name_, p, "Boolean");
}
Module["_emscripten_glGetBooleanv"] = _emscripten_glGetBooleanv;
function _emscripten_glCompileShader(shader) {
 GLctx.compileShader(GL.shaders[shader]);
}
Module["_emscripten_glCompileShader"] = _emscripten_glCompileShader;
var __impure_ptr = STATICTOP;
STATICTOP += 16;
Module["__impure_ptr"] = __impure_ptr;
var ___dso_handle = STATICTOP;
STATICTOP += 16;
Module["___dso_handle"] = ___dso_handle;
function _utimes(path, times) {
 var time;
 if (times) {
  var offset = 8 + 0;
  time = HEAP32[times + offset >> 2] * 1e3;
  offset = 8 + 4;
  time += HEAP32[times + offset >> 2] / 1e3;
 } else {
  time = Date.now();
 }
 path = Pointer_stringify(path);
 try {
  FS.utime(path, time, time);
  return 0;
 } catch (e) {
  FS.handleFSError(e);
  return -1;
 }
}
Module["_utimes"] = _utimes;
function _chroot(path) {
 ___setErrNo(ERRNO_CODES.EACCES);
 return -1;
}
Module["_chroot"] = _chroot;
function _fpathconf(fildes, name) {
 switch (name) {
 case 0:
  return 32e3;
 case 1:
 case 2:
 case 3:
  return 255;
 case 4:
 case 5:
 case 16:
 case 17:
 case 18:
  return 4096;
 case 6:
 case 7:
 case 20:
  return 1;
 case 8:
  return 0;
 case 9:
 case 10:
 case 11:
 case 12:
 case 14:
 case 15:
 case 19:
  return -1;
 case 13:
  return 64;
 }
 ___setErrNo(ERRNO_CODES.EINVAL);
 return -1;
}
Module["_fpathconf"] = _fpathconf;
function _pathconf() {
 return _fpathconf.apply(null, arguments);
}
Module["_pathconf"] = _pathconf;
function _confstr(name, buf, len) {
 var value;
 switch (name) {
 case 0:
  value = ENV["PATH"] || "/";
  break;
 case 1:
  value = "POSIX_V6_ILP32_OFF32\nPOSIX_V6_ILP32_OFFBIG";
  break;
 case 2:
  value = "glibc 2.14";
  break;
 case 3:
  value = "";
  break;
 case 1118:
 case 1122:
 case 1124:
 case 1125:
 case 1126:
 case 1128:
 case 1129:
 case 1130:
  value = "";
  break;
 case 1116:
 case 1117:
 case 1121:
  value = "-m32";
  break;
 case 1120:
  value = "-m32 -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64";
  break;
 default:
  ___setErrNo(ERRNO_CODES.EINVAL);
  return 0;
 }
 if (len == 0 || buf == 0) {
  return value.length + 1;
 } else {
  var length = Math.min(len, value.length);
  for (var i = 0; i < length; i++) {
   HEAP8[buf + i >> 0] = value.charCodeAt(i);
  }
  if (len > length) HEAP8[buf + i++ >> 0] = 0;
  return i;
 }
}
Module["_confstr"] = _confstr;
function _execle() {
 return _execl.apply(null, arguments);
}
Module["_execle"] = _execle;
function _execlp() {
 return _execl.apply(null, arguments);
}
Module["_execlp"] = _execlp;
function _execv() {
 return _execl.apply(null, arguments);
}
Module["_execv"] = _execv;
function _execve() {
 return _execl.apply(null, arguments);
}
Module["_execve"] = _execve;
function _execvp() {
 return _execl.apply(null, arguments);
}
Module["_execvp"] = _execvp;
function ___execvpe() {
 return _execl.apply(null, arguments);
}
Module["___execvpe"] = ___execvpe;
function _fexecve() {
 return _execl.apply(null, arguments);
}
Module["_fexecve"] = _fexecve;
function _vfork() {
 return _fork.apply(null, arguments);
}
Module["_vfork"] = _vfork;
function _posix_spawnp() {
 return _fork.apply(null, arguments);
}
Module["_posix_spawnp"] = _posix_spawnp;
function _getpagesize() {
 return PAGE_SIZE;
}
Module["_getpagesize"] = _getpagesize;
function _system(command) {
 ___setErrNo(ERRNO_CODES.EAGAIN);
 return -1;
}
Module["_system"] = _system;
var _abs = Math_abs;
Module["_abs"] = _abs;
var _labs = Math_abs;
Module["_labs"] = _labs;
function __ZSt9terminatev() {
 _exit(-1234);
}
Module["__ZSt9terminatev"] = __ZSt9terminatev;
function _atexit(func, arg) {
 __ATEXIT__.unshift({
  func: func,
  arg: arg
 });
}
Module["_atexit"] = _atexit;
function ___cxa_atexit() {
 return _atexit.apply(null, arguments);
}
Module["___cxa_atexit"] = ___cxa_atexit;
function ___cxa_thread_atexit_impl() {
 return _atexit.apply(null, arguments);
}
Module["___cxa_thread_atexit_impl"] = ___cxa_thread_atexit_impl;
function _clearenv(name) {
 ENV = {};
 ___buildEnvironment(ENV);
 return 0;
}
Module["_clearenv"] = _clearenv;
function _setenv(envname, envval, overwrite) {
 if (envname === 0) {
  ___setErrNo(ERRNO_CODES.EINVAL);
  return -1;
 }
 var name = Pointer_stringify(envname);
 var val = Pointer_stringify(envval);
 if (name === "" || name.indexOf("=") !== -1) {
  ___setErrNo(ERRNO_CODES.EINVAL);
  return -1;
 }
 if (ENV.hasOwnProperty(name) && !overwrite) return 0;
 ENV[name] = val;
 ___buildEnvironment(ENV);
 return 0;
}
Module["_setenv"] = _setenv;
function _unsetenv(name) {
 if (name === 0) {
  ___setErrNo(ERRNO_CODES.EINVAL);
  return -1;
 }
 name = Pointer_stringify(name);
 if (name === "" || name.indexOf("=") !== -1) {
  ___setErrNo(ERRNO_CODES.EINVAL);
  return -1;
 }
 if (ENV.hasOwnProperty(name)) {
  delete ENV[name];
  ___buildEnvironment(ENV);
 }
 return 0;
}
Module["_unsetenv"] = _unsetenv;
function _getloadavg(loadavg, nelem) {
 var limit = Math.min(nelem, 3);
 var doubleSize = 8;
 for (var i = 0; i < limit; i++) {
  HEAPF64[loadavg + i * doubleSize >> 3] = .1;
 }
 return limit;
}
Module["_getloadavg"] = _getloadavg;
var _rand = undefined;
function _arc4random() {
 return _rand.apply(null, arguments);
}
Module["_arc4random"] = _arc4random;
var _llvm_memcpy_i32 = _memcpy;
Module["_llvm_memcpy_i32"] = _llvm_memcpy_i32;
var _llvm_memcpy_i64 = _memcpy;
Module["_llvm_memcpy_i64"] = _llvm_memcpy_i64;
var _llvm_memcpy_p0i8_p0i8_i32 = _memcpy;
Module["_llvm_memcpy_p0i8_p0i8_i32"] = _llvm_memcpy_p0i8_p0i8_i32;
var _llvm_memcpy_p0i8_p0i8_i64 = _memcpy;
Module["_llvm_memcpy_p0i8_p0i8_i64"] = _llvm_memcpy_p0i8_p0i8_i64;
var _llvm_memmove_i32 = _memmove;
Module["_llvm_memmove_i32"] = _llvm_memmove_i32;
var _llvm_memmove_i64 = _memmove;
Module["_llvm_memmove_i64"] = _llvm_memmove_i64;
var _llvm_memmove_p0i8_p0i8_i32 = _memmove;
Module["_llvm_memmove_p0i8_p0i8_i32"] = _llvm_memmove_p0i8_p0i8_i32;
var _llvm_memmove_p0i8_p0i8_i64 = _memmove;
Module["_llvm_memmove_p0i8_p0i8_i64"] = _llvm_memmove_p0i8_p0i8_i64;
var _llvm_memset_i32 = _memset;
Module["_llvm_memset_i32"] = _llvm_memset_i32;
var _llvm_memset_p0i8_i32 = _memset;
Module["_llvm_memset_p0i8_i32"] = _llvm_memset_p0i8_i32;
var _llvm_memset_p0i8_i64 = _memset;
Module["_llvm_memset_p0i8_i64"] = _llvm_memset_p0i8_i64;
function ___builtin_prefetch() {}
Module["___builtin_prefetch"] = ___builtin_prefetch;
function _llvm_va_end() {}
Module["_llvm_va_end"] = _llvm_va_end;
function _llvm_va_copy(ppdest, ppsrc) {
 HEAP8[ppdest >> 0] = HEAP8[ppsrc >> 0];
 HEAP8[ppdest + 1 >> 0] = HEAP8[ppsrc + 1 >> 0];
 HEAP8[ppdest + 2 >> 0] = HEAP8[ppsrc + 2 >> 0];
 HEAP8[ppdest + 3 >> 0] = HEAP8[ppsrc + 3 >> 0];
 HEAP8[ppdest + 4 >> 0] = HEAP8[ppsrc + 4 >> 0];
 HEAP8[ppdest + 4 + 1 >> 0] = HEAP8[ppsrc + 4 + 1 >> 0];
 HEAP8[ppdest + 4 + 2 >> 0] = HEAP8[ppsrc + 4 + 2 >> 0];
 HEAP8[ppdest + 4 + 3 >> 0] = HEAP8[ppsrc + 4 + 3 >> 0];
}
Module["_llvm_va_copy"] = _llvm_va_copy;
function _llvm_cttz_i64(l, h) {
 var ret = _llvm_cttz_i32(l);
 if (ret == 32) ret += _llvm_cttz_i32(h);
 return (Runtime.setTempRet0(0), ret) | 0;
}
Module["_llvm_cttz_i64"] = _llvm_cttz_i64;
Module["_llvm_ctpop_i64"] = _llvm_ctpop_i64;
function _llvm_prefetch() {}
Module["_llvm_prefetch"] = _llvm_prefetch;
function ___assert_func(filename, line, func, condition) {
 throw "Assertion failed: " + (condition ? Pointer_stringify(condition) : "unknown condition") + ", at: " + [ filename ? Pointer_stringify(filename) : "unknown filename", line, func ? Pointer_stringify(func) : "unknown function" ] + " at " + stackTrace();
}
Module["___assert_func"] = ___assert_func;
function _llvm_eh_exception() {
 return EXCEPTIONS.last;
}
Module["_llvm_eh_exception"] = _llvm_eh_exception;
var _llvm_eh_selector__jsargs = true;
Module["_llvm_eh_selector__jsargs"] = _llvm_eh_selector__jsargs;
function _llvm_eh_selector(unused_exception_value, personality) {
 var type = EXCEPTIONS.last;
 for (var i = 2; i < arguments.length; i++) {
  if (arguments[i] == type) return type;
 }
 return 0;
}
Module["_llvm_eh_selector"] = _llvm_eh_selector;
function _llvm_eh_typeid_for(type) {
 return type;
}
Module["_llvm_eh_typeid_for"] = _llvm_eh_typeid_for;
function ___cxa_get_exception_ptr(ptr) {
 return ptr;
}
Module["___cxa_get_exception_ptr"] = ___cxa_get_exception_ptr;
function ___cxa_uncaught_exception() {
 return !!__ZSt18uncaught_exceptionv.uncaught_exception;
}
Module["___cxa_uncaught_exception"] = ___cxa_uncaught_exception;
function ___cxa_call_unexpected(exception) {
 Module.printErr("Unexpected exception thrown, this is not properly supported - aborting");
 ABORT = true;
 throw exception;
}
Module["___cxa_call_unexpected"] = ___cxa_call_unexpected;
function _terminate() {
 return ___cxa_call_unexpected.apply(null, arguments);
}
Module["_terminate"] = _terminate;
function ___gcc_personality_v0() {}
Module["___gcc_personality_v0"] = ___gcc_personality_v0;
function _llvm_flt_rounds() {
 return -1;
}
Module["_llvm_flt_rounds"] = _llvm_flt_rounds;
function _llvm_lifetime_start() {}
Module["_llvm_lifetime_start"] = _llvm_lifetime_start;
function _llvm_lifetime_end() {}
Module["_llvm_lifetime_end"] = _llvm_lifetime_end;
function _llvm_invariant_start() {}
Module["_llvm_invariant_start"] = _llvm_invariant_start;
function _llvm_invariant_end() {}
Module["_llvm_invariant_end"] = _llvm_invariant_end;
function _llvm_objectsize_i32() {
 return -1;
}
Module["_llvm_objectsize_i32"] = _llvm_objectsize_i32;
Module["_llvm_bitreverse_i32"] = _llvm_bitreverse_i32;
function _llvm_mono_load_i8_p0i8(ptr) {
 return HEAP8[ptr >> 0];
}
Module["_llvm_mono_load_i8_p0i8"] = _llvm_mono_load_i8_p0i8;
function _llvm_mono_store_i8_p0i8(value, ptr) {
 HEAP8[ptr >> 0] = value;
}
Module["_llvm_mono_store_i8_p0i8"] = _llvm_mono_store_i8_p0i8;
function _llvm_mono_load_i16_p0i16(ptr) {
 return HEAP16[ptr >> 1];
}
Module["_llvm_mono_load_i16_p0i16"] = _llvm_mono_load_i16_p0i16;
function _llvm_mono_store_i16_p0i16(value, ptr) {
 HEAP16[ptr >> 1] = value;
}
Module["_llvm_mono_store_i16_p0i16"] = _llvm_mono_store_i16_p0i16;
function _llvm_mono_load_i32_p0i32(ptr) {
 return HEAP32[ptr >> 2];
}
Module["_llvm_mono_load_i32_p0i32"] = _llvm_mono_load_i32_p0i32;
function _llvm_mono_store_i32_p0i32(value, ptr) {
 HEAP32[ptr >> 2] = value;
}
Module["_llvm_mono_store_i32_p0i32"] = _llvm_mono_store_i32_p0i32;
var _cos = Math_cos;
Module["_cos"] = _cos;
var _cosf = Math_cos;
Module["_cosf"] = _cosf;
var _cosl = Math_cos;
Module["_cosl"] = _cosl;
var _sin = Math_sin;
Module["_sin"] = _sin;
var _sinf = Math_sin;
Module["_sinf"] = _sinf;
var _sinl = Math_sin;
Module["_sinl"] = _sinl;
var _tan = Math_tan;
Module["_tan"] = _tan;
var _tanf = Math_tan;
Module["_tanf"] = _tanf;
var _tanl = Math_tan;
Module["_tanl"] = _tanl;
var _acos = Math_acos;
Module["_acos"] = _acos;
var _acosf = Math_acos;
Module["_acosf"] = _acosf;
var _acosl = Math_acos;
Module["_acosl"] = _acosl;
var _asin = Math_asin;
Module["_asin"] = _asin;
var _asinf = Math_asin;
Module["_asinf"] = _asinf;
var _asinl = Math_asin;
Module["_asinl"] = _asinl;
var _atan = Math_atan;
Module["_atan"] = _atan;
var _atanf = Math_atan;
Module["_atanf"] = _atanf;
var _atanl = Math_atan;
Module["_atanl"] = _atanl;
var _atan2 = Math_atan2;
Module["_atan2"] = _atan2;
var _atan2f = Math_atan2;
Module["_atan2f"] = _atan2f;
var _atan2l = Math_atan2;
Module["_atan2l"] = _atan2l;
var _exp = Math_exp;
Module["_exp"] = _exp;
var _expf = Math_exp;
Module["_expf"] = _expf;
var _expl = Math_exp;
Module["_expl"] = _expl;
var _log = Math_log;
Module["_log"] = _log;
var _logf = Math_log;
Module["_logf"] = _logf;
var _logl = Math_log;
Module["_logl"] = _logl;
var _sqrt = Math_sqrt;
Module["_sqrt"] = _sqrt;
var _sqrtf = Math_sqrt;
Module["_sqrtf"] = _sqrtf;
var _sqrtl = Math_sqrt;
Module["_sqrtl"] = _sqrtl;
var _fabs = Math_abs;
Module["_fabs"] = _fabs;
var _fabsf = Math_abs;
Module["_fabsf"] = _fabsf;
var _fabsl = Math_abs;
Module["_fabsl"] = _fabsl;
var _llvm_fabs_f64 = Math_abs;
Module["_llvm_fabs_f64"] = _llvm_fabs_f64;
var _ceil = Math_ceil;
Module["_ceil"] = _ceil;
var _ceilf = Math_ceil;
Module["_ceilf"] = _ceilf;
var _ceill = Math_ceil;
Module["_ceill"] = _ceill;
var _floor = Math_floor;
Module["_floor"] = _floor;
var _floorf = Math_floor;
Module["_floorf"] = _floorf;
var _floorl = Math_floor;
Module["_floorl"] = _floorl;
var _pow = Math_pow;
Module["_pow"] = _pow;
var _powf = Math_pow;
Module["_powf"] = _powf;
var _powl = Math_pow;
Module["_powl"] = _powl;
var _llvm_sqrt_f32 = Math_sqrt;
Module["_llvm_sqrt_f32"] = _llvm_sqrt_f32;
var _llvm_sqrt_f64 = Math_sqrt;
Module["_llvm_sqrt_f64"] = _llvm_sqrt_f64;
var _llvm_powi_f32 = Math_pow;
Module["_llvm_powi_f32"] = _llvm_powi_f32;
var _llvm_powi_f64 = Math_pow;
Module["_llvm_powi_f64"] = _llvm_powi_f64;
var _llvm_log_f32 = Math_log;
Module["_llvm_log_f32"] = _llvm_log_f32;
var _llvm_log_f64 = Math_log;
Module["_llvm_log_f64"] = _llvm_log_f64;
var _llvm_exp_f32 = Math_exp;
Module["_llvm_exp_f32"] = _llvm_exp_f32;
var _llvm_exp_f64 = Math_exp;
Module["_llvm_exp_f64"] = _llvm_exp_f64;
var _llvm_sin_f32 = Math_sin;
Module["_llvm_sin_f32"] = _llvm_sin_f32;
var _llvm_sin_f64 = Math_sin;
Module["_llvm_sin_f64"] = _llvm_sin_f64;
var _llvm_trunc_f32 = Math_trunc;
Module["_llvm_trunc_f32"] = _llvm_trunc_f32;
var _llvm_trunc_f64 = Math_trunc;
Module["_llvm_trunc_f64"] = _llvm_trunc_f64;
var _llvm_floor_f32 = Math_floor;
Module["_llvm_floor_f32"] = _llvm_floor_f32;
var _llvm_floor_f64 = Math_floor;
Module["_llvm_floor_f64"] = _llvm_floor_f64;
function _llvm_copysign_f32(x, y) {
 return y < 0 || y === 0 && 1 / y < 0 ? -Math_abs(x) : Math_abs(x);
}
Module["_llvm_copysign_f32"] = _llvm_copysign_f32;
function _llvm_copysign_f64(x, y) {
 return y < 0 || y === 0 && 1 / y < 0 ? -Math_abs(x) : Math_abs(x);
}
Module["_llvm_copysign_f64"] = _llvm_copysign_f64;
function __reallyNegative(x) {
 return x < 0 || x === 0 && 1 / x === -Infinity;
}
Module["__reallyNegative"] = __reallyNegative;
var DLFCN = {
 error: null,
 errorMsg: null,
 loadedLibs: {},
 loadedLibNames: {}
};
Module["DLFCN"] = DLFCN;
function _dlopen(filename, flag) {
 filename = filename === 0 ? "__self__" : (ENV["LD_LIBRARY_PATH"] || "/") + Pointer_stringify(filename);
 if (DLFCN.loadedLibNames[filename]) {
  var handle = DLFCN.loadedLibNames[filename];
  DLFCN.loadedLibs[handle].refcount++;
  return handle;
 }
 if (filename === "__self__") {
  var handle = -1;
  var lib_module = Module;
  var cached_functions = {};
 } else {
  var target = FS.findObject(filename);
  if (!target || target.isFolder || target.isDevice) {
   DLFCN.errorMsg = "Could not find dynamic lib: " + filename;
   return 0;
  } else {
   FS.forceLoadFile(target);
   var lib_data = FS.readFile(filename, {
    encoding: "utf8"
   });
  }
  try {
   var lib_module = eval(lib_data)(Runtime.alignFunctionTables(), Module);
  } catch (e) {
   Module.printErr("Error in loading dynamic library: " + e);
   DLFCN.errorMsg = "Could not evaluate dynamic lib: " + filename;
   return 0;
  }
  var handle = 1;
  for (var key in DLFCN.loadedLibs) {
   if (DLFCN.loadedLibs.hasOwnProperty(key)) handle++;
  }
  if (flag & 256) {
   for (var ident in lib_module) {
    if (lib_module.hasOwnProperty(ident)) {
     Module[ident] = lib_module[ident];
    }
   }
  }
  var cached_functions = {};
 }
 DLFCN.loadedLibs[handle] = {
  refcount: 1,
  name: filename,
  module: lib_module,
  cached_functions: cached_functions
 };
 DLFCN.loadedLibNames[filename] = handle;
 return handle;
}
Module["_dlopen"] = _dlopen;
function _dlclose(handle) {
 if (!DLFCN.loadedLibs[handle]) {
  DLFCN.errorMsg = "Tried to dlclose() unopened handle: " + handle;
  return 1;
 } else {
  var lib_record = DLFCN.loadedLibs[handle];
  if (--lib_record.refcount == 0) {
   if (lib_record.module.cleanups) {
    lib_record.module.cleanups.forEach((function(cleanup) {
     cleanup();
    }));
   }
   delete DLFCN.loadedLibNames[lib_record.name];
   delete DLFCN.loadedLibs[handle];
  }
  return 0;
 }
}
Module["_dlclose"] = _dlclose;
function _dlsym(handle, symbol) {
 symbol = Pointer_stringify(symbol);
 if (!DLFCN.loadedLibs[handle]) {
  DLFCN.errorMsg = "Tried to dlsym() from an unopened handle: " + handle;
  return 0;
 } else {
  var lib = DLFCN.loadedLibs[handle];
  symbol = "_" + symbol;
  if (lib.cached_functions.hasOwnProperty(symbol)) {
   return lib.cached_functions[symbol];
  }
  if (!lib.module.hasOwnProperty(symbol)) {
   DLFCN.errorMsg = 'Tried to lookup unknown symbol "' + symbol + '" in dynamic lib: ' + lib.name;
   return 0;
  } else {
   var result = lib.module[symbol];
   if (typeof result == "function") {
    result = Runtime.addFunction(result);
    lib.cached_functions = result;
   }
   return result;
  }
 }
}
Module["_dlsym"] = _dlsym;
function _dlerror() {
 if (DLFCN.errorMsg === null) {
  return 0;
 } else {
  if (DLFCN.error) _free(DLFCN.error);
  var msgArr = intArrayFromString(DLFCN.errorMsg);
  DLFCN.error = allocate(msgArr, "i8", ALLOC_NORMAL);
  DLFCN.errorMsg = null;
  return DLFCN.error;
 }
}
Module["_dlerror"] = _dlerror;
function _dladdr(addr, info) {
 var fname = allocate(intArrayFromString(Module["thisProgram"] || "./this.program"), "i8", ALLOC_NORMAL);
 HEAP32[addr >> 2] = fname;
 HEAP32[addr + 4 >> 2] = 0;
 HEAP32[addr + 8 >> 2] = 0;
 HEAP32[addr + 12 >> 2] = 0;
 return 1;
}
Module["_dladdr"] = _dladdr;
function _clock() {
 if (_clock.start === undefined) _clock.start = Date.now();
 return (Date.now() - _clock.start) * (1e6 / 1e3) | 0;
}
Module["_clock"] = _clock;
var ___tm_formatted = STATICTOP;
STATICTOP += 48;
Module["___tm_formatted"] = ___tm_formatted;
function _timelocal() {
 return _mktime.apply(null, arguments);
}
Module["_timelocal"] = _timelocal;
function _timegm(tmPtr) {
 _tzset();
 var time = Date.UTC(HEAP32[tmPtr + 20 >> 2] + 1900, HEAP32[tmPtr + 16 >> 2], HEAP32[tmPtr + 12 >> 2], HEAP32[tmPtr + 8 >> 2], HEAP32[tmPtr + 4 >> 2], HEAP32[tmPtr >> 2], 0);
 var date = new Date(time);
 HEAP32[tmPtr + 24 >> 2] = date.getUTCDay();
 var start = Date.UTC(date.getUTCFullYear(), 0, 1, 0, 0, 0, 0);
 var yday = (date.getTime() - start) / (1e3 * 60 * 60 * 24) | 0;
 HEAP32[tmPtr + 28 >> 2] = yday;
 return date.getTime() / 1e3 | 0;
}
Module["_timegm"] = _timegm;
function _asctime_r(tmPtr, buf) {
 var date = {
  tm_sec: HEAP32[tmPtr >> 2],
  tm_min: HEAP32[tmPtr + 4 >> 2],
  tm_hour: HEAP32[tmPtr + 8 >> 2],
  tm_mday: HEAP32[tmPtr + 12 >> 2],
  tm_mon: HEAP32[tmPtr + 16 >> 2],
  tm_year: HEAP32[tmPtr + 20 >> 2],
  tm_wday: HEAP32[tmPtr + 24 >> 2]
 };
 var days = [ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" ];
 var months = [ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" ];
 var s = days[date.tm_wday] + " " + months[date.tm_mon] + (date.tm_mday < 10 ? "  " : " ") + date.tm_mday + (date.tm_hour < 10 ? " 0" : " ") + date.tm_hour + (date.tm_min < 10 ? ":0" : ":") + date.tm_min + (date.tm_sec < 10 ? ":0" : ":") + date.tm_sec + " " + (1900 + date.tm_year) + "\n";
 writeStringToMemory(s, buf);
 return buf;
}
Module["_asctime_r"] = _asctime_r;
function _asctime(tmPtr) {
 return _asctime_r(tmPtr, ___tm_formatted);
}
Module["_asctime"] = _asctime;
function _ctime_r(time, buf) {
 var stack = Runtime.stackSave();
 var rv = _asctime_r(_localtime_r(time, Runtime.stackAlloc(44)), buf);
 Runtime.stackRestore(stack);
 return rv;
}
Module["_ctime_r"] = _ctime_r;
function _ctime(timer) {
 return _ctime_r(timer, ___tm_current);
}
Module["_ctime"] = _ctime;
function _dysize(year) {
 var leap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
 return leap ? 366 : 365;
}
Module["_dysize"] = _dysize;
function _stime(when) {
 ___setErrNo(ERRNO_CODES.EPERM);
 return -1;
}
Module["_stime"] = _stime;
function _strptime(buf, format, tm) {
 var pattern = Pointer_stringify(format);
 var SPECIAL_CHARS = "\\!@#$^&*()+=-[]/{}|:<>?,.";
 for (var i = 0, ii = SPECIAL_CHARS.length; i < ii; ++i) {
  pattern = pattern.replace(new RegExp("\\" + SPECIAL_CHARS[i], "g"), "\\" + SPECIAL_CHARS[i]);
 }
 var EQUIVALENT_MATCHERS = {
  "%A": "%a",
  "%B": "%b",
  "%c": "%x\\s+%X",
  "%D": "%m\\/%d\\/%y",
  "%e": "%d",
  "%h": "%b",
  "%R": "%H\\:%M",
  "%r": "%I\\:%M\\:%S\\s%p",
  "%T": "%H\\:%M\\:%S",
  "%x": "%m\\/%d\\/(?:%y|%Y)",
  "%X": "%H\\:%M\\:%S"
 };
 for (var matcher in EQUIVALENT_MATCHERS) {
  pattern = pattern.replace(matcher, EQUIVALENT_MATCHERS[matcher]);
 }
 var DATE_PATTERNS = {
  "%a": "(?:Sun(?:day)?)|(?:Mon(?:day)?)|(?:Tue(?:sday)?)|(?:Wed(?:nesday)?)|(?:Thu(?:rsday)?)|(?:Fri(?:day)?)|(?:Sat(?:urday)?)",
  "%b": "(?:Jan(?:uary)?)|(?:Feb(?:ruary)?)|(?:Mar(?:ch)?)|(?:Apr(?:il)?)|May|(?:Jun(?:e)?)|(?:Jul(?:y)?)|(?:Aug(?:ust)?)|(?:Sep(?:tember)?)|(?:Oct(?:ober)?)|(?:Nov(?:ember)?)|(?:Dec(?:ember)?)",
  "%C": "\\d\\d",
  "%d": "0[1-9]|[1-9](?!\\d)|1\\d|2\\d|30|31",
  "%H": "\\d(?!\\d)|[0,1]\\d|20|21|22|23",
  "%I": "\\d(?!\\d)|0\\d|10|11|12",
  "%j": "00[1-9]|0?[1-9](?!\\d)|0?[1-9]\\d(?!\\d)|[1,2]\\d\\d|3[0-6]\\d",
  "%m": "0[1-9]|[1-9](?!\\d)|10|11|12",
  "%M": "0\\d|\\d(?!\\d)|[1-5]\\d",
  "%n": "\\s",
  "%p": "AM|am|PM|pm|A\\.M\\.|a\\.m\\.|P\\.M\\.|p\\.m\\.",
  "%S": "0\\d|\\d(?!\\d)|[1-5]\\d|60",
  "%U": "0\\d|\\d(?!\\d)|[1-4]\\d|50|51|52|53",
  "%W": "0\\d|\\d(?!\\d)|[1-4]\\d|50|51|52|53",
  "%w": "[0-6]",
  "%y": "\\d\\d",
  "%Y": "\\d\\d\\d\\d",
  "%%": "%",
  "%t": "\\s"
 };
 var MONTH_NUMBERS = {
  JAN: 0,
  FEB: 1,
  MAR: 2,
  APR: 3,
  MAY: 4,
  JUN: 5,
  JUL: 6,
  AUG: 7,
  SEP: 8,
  OCT: 9,
  NOV: 10,
  DEC: 11
 };
 var DAY_NUMBERS_SUN_FIRST = {
  SUN: 0,
  MON: 1,
  TUE: 2,
  WED: 3,
  THU: 4,
  FRI: 5,
  SAT: 6
 };
 var DAY_NUMBERS_MON_FIRST = {
  MON: 0,
  TUE: 1,
  WED: 2,
  THU: 3,
  FRI: 4,
  SAT: 5,
  SUN: 6
 };
 for (var datePattern in DATE_PATTERNS) {
  pattern = pattern.replace(datePattern, "(" + datePattern + DATE_PATTERNS[datePattern] + ")");
 }
 var capture = [];
 for (var i = pattern.indexOf("%"); i >= 0; i = pattern.indexOf("%")) {
  capture.push(pattern[i + 1]);
  pattern = pattern.replace(new RegExp("\\%" + pattern[i + 1], "g"), "");
 }
 var matches = (new RegExp("^" + pattern, "i")).exec(Pointer_stringify(buf));
 function initDate() {
  function fixup(value, min, max) {
   return typeof value !== "number" || isNaN(value) ? min : value >= min ? value <= max ? value : max : min;
  }
  return {
   year: fixup(HEAP32[tm + 20 >> 2] + 1900, 1970, 9999),
   month: fixup(HEAP32[tm + 16 >> 2], 0, 11),
   day: fixup(HEAP32[tm + 12 >> 2], 1, 31),
   hour: fixup(HEAP32[tm + 8 >> 2], 0, 23),
   min: fixup(HEAP32[tm + 4 >> 2], 0, 59),
   sec: fixup(HEAP32[tm >> 2], 0, 59)
  };
 }
 if (matches) {
  var date = initDate();
  var value;
  function getMatch(symbol) {
   var pos = capture.indexOf(symbol);
   if (pos >= 0) {
    return matches[pos + 1];
   }
   return;
  }
  if (value = getMatch("S")) {
   date.sec = parseInt(value);
  }
  if (value = getMatch("M")) {
   date.min = parseInt(value);
  }
  if (value = getMatch("H")) {
   date.hour = parseInt(value);
  } else if (value = getMatch("I")) {
   var hour = parseInt(value);
   if (value = getMatch("p")) {
    hour += value.toUpperCase()[0] === "P" ? 12 : 0;
   }
   date.hour = hour;
  }
  if (value = getMatch("Y")) {
   date.year = parseInt(value);
  } else if (value = getMatch("y")) {
   var year = parseInt(value);
   if (value = getMatch("C")) {
    year += parseInt(value) * 100;
   } else {
    year += year < 69 ? 2e3 : 1900;
   }
   date.year = year;
  }
  if (value = getMatch("m")) {
   date.month = parseInt(value) - 1;
  } else if (value = getMatch("b")) {
   date.month = MONTH_NUMBERS[value.substring(0, 3).toUpperCase()] || 0;
  }
  if (value = getMatch("d")) {
   date.day = parseInt(value);
  } else if (value = getMatch("j")) {
   var day = parseInt(value);
   var leapYear = __isLeapYear(date.year);
   for (var month = 0; month < 12; ++month) {
    var daysUntilMonth = __arraySum(leapYear ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, month - 1);
    if (day <= daysUntilMonth + (leapYear ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR)[month]) {
     date.day = day - daysUntilMonth;
    }
   }
  } else if (value = getMatch("a")) {
   var weekDay = value.substring(0, 3).toUpperCase();
   if (value = getMatch("U")) {
    var weekDayNumber = DAY_NUMBERS_SUN_FIRST[weekDay];
    var weekNumber = parseInt(value);
    var janFirst = new Date(date.year, 0, 1);
    var endDate;
    if (janFirst.getDay() === 0) {
     endDate = __addDays(janFirst, weekDayNumber + 7 * (weekNumber - 1));
    } else {
     endDate = __addDays(janFirst, 7 - janFirst.getDay() + weekDayNumber + 7 * (weekNumber - 1));
    }
    date.day = endDate.getDate();
    date.month = endDate.getMonth();
   } else if (value = getMatch("W")) {
    var weekDayNumber = DAY_NUMBERS_MON_FIRST[weekDay];
    var weekNumber = parseInt(value);
    var janFirst = new Date(date.year, 0, 1);
    var endDate;
    if (janFirst.getDay() === 1) {
     endDate = __addDays(janFirst, weekDayNumber + 7 * (weekNumber - 1));
    } else {
     endDate = __addDays(janFirst, 7 - janFirst.getDay() + 1 + weekDayNumber + 7 * (weekNumber - 1));
    }
    date.day = endDate.getDate();
    date.month = endDate.getMonth();
   }
  }
  var fullDate = new Date(date.year, date.month, date.day, date.hour, date.min, date.sec, 0);
  HEAP32[tm >> 2] = fullDate.getSeconds();
  HEAP32[tm + 4 >> 2] = fullDate.getMinutes();
  HEAP32[tm + 8 >> 2] = fullDate.getHours();
  HEAP32[tm + 12 >> 2] = fullDate.getDate();
  HEAP32[tm + 16 >> 2] = fullDate.getMonth();
  HEAP32[tm + 20 >> 2] = fullDate.getFullYear() - 1900;
  HEAP32[tm + 24 >> 2] = fullDate.getDay();
  HEAP32[tm + 28 >> 2] = __arraySum(__isLeapYear(fullDate.getFullYear()) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, fullDate.getMonth() - 1) + fullDate.getDate() - 1;
  HEAP32[tm + 32 >> 2] = 0;
  return buf + intArrayFromString(matches[0]).length - 1;
 }
 return 0;
}
Module["_strptime"] = _strptime;
function _strptime_l(buf, format, tm) {
 return _strptime(buf, format, tm);
}
Module["_strptime_l"] = _strptime_l;
function _getdate(string) {
 return 0;
}
Module["_getdate"] = _getdate;
function _clock_settime(clk_id, tp) {
 ___setErrNo(clk_id === 0 ? ERRNO_CODES.EPERM : ERRNO_CODES.EINVAL);
 return -1;
}
Module["_clock_settime"] = _clock_settime;
function _emscripten_get_now_res() {
 if (ENVIRONMENT_IS_NODE) {
  return 1;
 } else if (typeof dateNow !== "undefined" || (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) && self["performance"] && self["performance"]["now"]) {
  return 1e3;
 } else {
  return 1e3 * 1e3;
 }
}
Module["_emscripten_get_now_res"] = _emscripten_get_now_res;
function _clock_getres(clk_id, res) {
 var nsec;
 if (clk_id === 0) {
  nsec = 1e3 * 1e3;
 } else if (clk_id === 1 && _emscripten_get_now_is_monotonic()) {
  nsec = _emscripten_get_now_res();
 } else {
  ___setErrNo(ERRNO_CODES.EINVAL);
  return -1;
 }
 HEAP32[res >> 2] = nsec / 1e9 | 0;
 HEAP32[res + 4 >> 2] = nsec;
 return 0;
}
Module["_clock_getres"] = _clock_getres;
function _clock_getcpuclockid(pid, clk_id) {
 if (pid < 0) return ERRNO_CODES.ESRCH;
 if (pid !== 0 && pid !== PROCINFO.pid) return ERRNO_CODES.ENOSYS;
 if (clk_id) HEAP32[clk_id >> 2] = 2;
 return 0;
}
Module["_clock_getcpuclockid"] = _clock_getcpuclockid;
function _ftime(p) {
 var millis = Date.now();
 HEAP32[p >> 2] = millis / 1e3 | 0;
 HEAP16[p + 4 >> 1] = millis % 1e3;
 HEAP16[p + 6 >> 1] = 0;
 HEAP16[p + 8 >> 1] = 0;
 return 0;
}
Module["_ftime"] = _ftime;
function _times(buffer) {
 if (buffer !== 0) {
  _memset(buffer, 0, 16);
 }
 return 0;
}
Module["_times"] = _times;
function _makedev(maj, min) {
 return maj << 8 | min;
}
Module["_makedev"] = _makedev;
function _gnu_dev_makedev() {
 return _makedev.apply(null, arguments);
}
Module["_gnu_dev_makedev"] = _gnu_dev_makedev;
function _major(dev) {
 return dev >> 8;
}
Module["_major"] = _major;
function _gnu_dev_major() {
 return _major.apply(null, arguments);
}
Module["_gnu_dev_major"] = _gnu_dev_major;
function _minor(dev) {
 return dev & 255;
}
Module["_minor"] = _minor;
function _gnu_dev_minor() {
 return _minor.apply(null, arguments);
}
Module["_gnu_dev_minor"] = _gnu_dev_minor;
function _waitid() {
 return _wait.apply(null, arguments);
}
Module["_waitid"] = _waitid;
function _wait3() {
 return _wait.apply(null, arguments);
}
Module["_wait3"] = _wait3;
function _wait4() {
 return _wait.apply(null, arguments);
}
Module["_wait4"] = _wait4;
var _in6addr_any = allocate([ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ], "i8", ALLOC_STATIC);
Module["_in6addr_any"] = _in6addr_any;
var _in6addr_loopback = allocate([ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], "i8", ALLOC_STATIC);
Module["_in6addr_loopback"] = _in6addr_loopback;
function __inet_pton6(src, dst) {
 var ints = __inet_pton6_raw(Pointer_stringify(src));
 if (ints === null) {
  return 0;
 }
 for (var i = 0; i < 4; i++) {
  HEAP32[dst + i * 4 >> 2] = ints[i];
 }
 return 1;
}
Module["__inet_pton6"] = __inet_pton6;
function _gethostbyname_r(name, ret, buf, buflen, out, err) {
 var data = _gethostbyname(name);
 _memcpy(ret, data, 20);
 _free(data);
 HEAP32[err >> 2] = 0;
 HEAP32[out >> 2] = ret;
 return 0;
}
Module["_gethostbyname_r"] = _gethostbyname_r;
var Protocols = {
 list: [],
 map: {}
};
Module["Protocols"] = Protocols;
function _setprotoent(stayopen) {
 function allocprotoent(name, proto, aliases) {
  var nameBuf = _malloc(name.length + 1);
  writeAsciiToMemory(name, nameBuf);
  var j = 0;
  var length = aliases.length;
  var aliasListBuf = _malloc((length + 1) * 4);
  for (var i = 0; i < length; i++, j += 4) {
   var alias = aliases[i];
   var aliasBuf = _malloc(alias.length + 1);
   writeAsciiToMemory(alias, aliasBuf);
   HEAP32[aliasListBuf + j >> 2] = aliasBuf;
  }
  HEAP32[aliasListBuf + j >> 2] = 0;
  var pe = _malloc(12);
  HEAP32[pe >> 2] = nameBuf;
  HEAP32[pe + 4 >> 2] = aliasListBuf;
  HEAP32[pe + 8 >> 2] = proto;
  return pe;
 }
 var list = Protocols.list;
 var map = Protocols.map;
 if (list.length === 0) {
  var entry = allocprotoent("tcp", 6, [ "TCP" ]);
  list.push(entry);
  map["tcp"] = map["6"] = entry;
  entry = allocprotoent("udp", 17, [ "UDP" ]);
  list.push(entry);
  map["udp"] = map["17"] = entry;
 }
 _setprotoent.index = 0;
}
Module["_setprotoent"] = _setprotoent;
function _endprotoent() {}
Module["_endprotoent"] = _endprotoent;
function _getprotoent(number) {
 if (_setprotoent.index === Protocols.list.length) {
  return 0;
 } else {
  var result = Protocols.list[_setprotoent.index++];
  return result;
 }
}
Module["_getprotoent"] = _getprotoent;
function _getprotobyname(name) {
 name = Pointer_stringify(name);
 _setprotoent(true);
 var result = Protocols.map[name];
 return result;
}
Module["_getprotobyname"] = _getprotobyname;
function _getprotobynumber(number) {
 _setprotoent(true);
 var result = Protocols.map[number];
 return result;
}
Module["_getprotobynumber"] = _getprotobynumber;
function _getpwnam() {
 throw "getpwnam: TODO";
}
Module["_getpwnam"] = _getpwnam;
function _setpwent() {
 throw "setpwent: TODO";
}
Module["_setpwent"] = _setpwent;
function _getpwent() {
 throw "getpwent: TODO";
}
Module["_getpwent"] = _getpwent;
function _endpwent() {
 throw "endpwent: TODO";
}
Module["_endpwent"] = _endpwent;
function _emscripten_run_script(ptr) {
 eval(Pointer_stringify(ptr));
}
Module["_emscripten_run_script"] = _emscripten_run_script;
function _emscripten_run_script_int(ptr) {
 return eval(Pointer_stringify(ptr)) | 0;
}
Module["_emscripten_run_script_int"] = _emscripten_run_script_int;
function _emscripten_run_script_string(ptr) {
 var s = eval(Pointer_stringify(ptr)) + "";
 var me = _emscripten_run_script_string;
 if (!me.bufferSize || me.bufferSize < s.length + 1) {
  if (me.bufferSize) _free(me.buffer);
  me.bufferSize = s.length + 1;
  me.buffer = _malloc(me.bufferSize);
 }
 writeStringToMemory(s, me.buffer);
 return me.buffer;
}
Module["_emscripten_run_script_string"] = _emscripten_run_script_string;
function _emscripten_random() {
 return Math.random();
}
Module["_emscripten_random"] = _emscripten_random;
function __emscripten_traverse_stack(args) {
 if (!args || !args.callee || !args.callee.name) {
  return [ null, "", "" ];
 }
 var funstr = args.callee.toString();
 var funcname = args.callee.name;
 var str = "(";
 var first = true;
 for (i in args) {
  var a = args[i];
  if (!first) {
   str += ", ";
  }
  first = false;
  if (typeof a === "number" || typeof a === "string") {
   str += a;
  } else {
   str += "(" + typeof a + ")";
  }
 }
 str += ")";
 var caller = args.callee.caller;
 args = caller ? caller.arguments : [];
 if (first) str = "";
 return [ args, funcname, str ];
}
Module["__emscripten_traverse_stack"] = __emscripten_traverse_stack;
function _emscripten_get_callstack_js(flags) {
 var callstack = jsStackTrace();
 var iThisFunc = callstack.lastIndexOf("_emscripten_log");
 var iThisFunc2 = callstack.lastIndexOf("_emscripten_get_callstack");
 var iNextLine = callstack.indexOf("\n", Math.max(iThisFunc, iThisFunc2)) + 1;
 callstack = callstack.slice(iNextLine);
 if (flags & 8 && typeof emscripten_source_map === "undefined") {
  Runtime.warnOnce('Source map information is not available, emscripten_log with EM_LOG_C_STACK will be ignored. Build with "--pre-js $EMSCRIPTEN/src/emscripten-source-map.min.js" linker flag to add source map loading to code.');
  flags ^= 8;
  flags |= 16;
 }
 var stack_args = null;
 if (flags & 128) {
  var stack_args = __emscripten_traverse_stack(arguments);
  while (stack_args[1].indexOf("_emscripten_") >= 0) stack_args = __emscripten_traverse_stack(stack_args[0]);
 }
 lines = callstack.split("\n");
 callstack = "";
 var newFirefoxRe = new RegExp("\\s*(.*?)@(.*?):([0-9]+):([0-9]+)");
 var firefoxRe = new RegExp("\\s*(.*?)@(.*):(.*)(:(.*))?");
 var chromeRe = new RegExp("\\s*at (.*?) \\((.*):(.*):(.*)\\)");
 for (l in lines) {
  var line = lines[l];
  var jsSymbolName = "";
  var file = "";
  var lineno = 0;
  var column = 0;
  var parts = chromeRe.exec(line);
  if (parts && parts.length == 5) {
   jsSymbolName = parts[1];
   file = parts[2];
   lineno = parts[3];
   column = parts[4];
  } else {
   parts = newFirefoxRe.exec(line);
   if (!parts) parts = firefoxRe.exec(line);
   if (parts && parts.length >= 4) {
    jsSymbolName = parts[1];
    file = parts[2];
    lineno = parts[3];
    column = parts[4] | 0;
   } else {
    callstack += line + "\n";
    continue;
   }
  }
  var cSymbolName = flags & 32 ? demangle(jsSymbolName) : jsSymbolName;
  if (!cSymbolName) {
   cSymbolName = jsSymbolName;
  }
  var haveSourceMap = false;
  if (flags & 8) {
   var orig = emscripten_source_map.originalPositionFor({
    line: lineno,
    column: column
   });
   haveSourceMap = orig && orig.source;
   if (haveSourceMap) {
    if (flags & 64) {
     orig.source = orig.source.substring(orig.source.replace(/\\/g, "/").lastIndexOf("/") + 1);
    }
    callstack += "    at " + cSymbolName + " (" + orig.source + ":" + orig.line + ":" + orig.column + ")\n";
   }
  }
  if (flags & 16 || !haveSourceMap) {
   if (flags & 64) {
    file = file.substring(file.replace(/\\/g, "/").lastIndexOf("/") + 1);
   }
   callstack += (haveSourceMap ? "     = " + jsSymbolName : "    at " + cSymbolName) + " (" + file + ":" + lineno + ":" + column + ")\n";
  }
  if (flags & 128 && stack_args[0]) {
   if (stack_args[1] == jsSymbolName && stack_args[2].length > 0) {
    callstack = callstack.replace(/\s+$/, "");
    callstack += " with values: " + stack_args[1] + stack_args[2] + "\n";
   }
   stack_args = __emscripten_traverse_stack(stack_args[0]);
  }
 }
 callstack = callstack.replace(/\s+$/, "");
 return callstack;
}
Module["_emscripten_get_callstack_js"] = _emscripten_get_callstack_js;
function _emscripten_get_callstack(flags, str, maxbytes) {
 var callstack = _emscripten_get_callstack_js(flags);
 if (!str || maxbytes <= 0) {
  return callstack.length + 1;
 }
 if (callstack.length > maxbytes - 1) {
  callstack = callstack.slice(0, maxbytes - 1);
 }
 writeStringToMemory(callstack, str, false);
 return callstack.length + 1;
}
Module["_emscripten_get_callstack"] = _emscripten_get_callstack;
function _emscripten_log_js(flags, str) {
 if (flags & 24) {
  str = str.replace(/\s+$/, "");
  str += (str.length > 0 ? "\n" : "") + _emscripten_get_callstack_js(flags);
 }
 if (flags & 1) {
  if (flags & 4) {
   console.error(str);
  } else if (flags & 2) {
   console.warn(str);
  } else {
   console.log(str);
  }
 } else if (flags & 6) {
  Module.printErr(str);
 } else {
  Module.print(str);
 }
}
Module["_emscripten_log_js"] = _emscripten_log_js;
var _strlen = undefined;
function __formatString(format, varargs) {
 assert((varargs & 3) === 0);
 var textIndex = format;
 var argIndex = varargs;
 function getNextArg(type) {
  var ret;
  argIndex = Runtime.prepVararg(argIndex, type);
  if (type === "double") {
   ret = HEAPF64[argIndex >> 3];
   argIndex += 8;
  } else if (type == "i64") {
   ret = [ HEAP32[argIndex >> 2], HEAP32[argIndex + 4 >> 2] ];
   argIndex += 8;
  } else {
   assert((argIndex & 3) === 0);
   type = "i32";
   ret = HEAP32[argIndex >> 2];
   argIndex += 4;
  }
  return ret;
 }
 var ret = [];
 var curr, next, currArg;
 while (1) {
  var startTextIndex = textIndex;
  curr = HEAP8[textIndex >> 0];
  if (curr === 0) break;
  next = HEAP8[textIndex + 1 >> 0];
  if (curr == 37) {
   var flagAlwaysSigned = false;
   var flagLeftAlign = false;
   var flagAlternative = false;
   var flagZeroPad = false;
   var flagPadSign = false;
   flagsLoop : while (1) {
    switch (next) {
    case 43:
     flagAlwaysSigned = true;
     break;
    case 45:
     flagLeftAlign = true;
     break;
    case 35:
     flagAlternative = true;
     break;
    case 48:
     if (flagZeroPad) {
      break flagsLoop;
     } else {
      flagZeroPad = true;
      break;
     }
    case 32:
     flagPadSign = true;
     break;
    default:
     break flagsLoop;
    }
    textIndex++;
    next = HEAP8[textIndex + 1 >> 0];
   }
   var width = 0;
   if (next == 42) {
    width = getNextArg("i32");
    textIndex++;
    next = HEAP8[textIndex + 1 >> 0];
   } else {
    while (next >= 48 && next <= 57) {
     width = width * 10 + (next - 48);
     textIndex++;
     next = HEAP8[textIndex + 1 >> 0];
    }
   }
   var precisionSet = false, precision = -1;
   if (next == 46) {
    precision = 0;
    precisionSet = true;
    textIndex++;
    next = HEAP8[textIndex + 1 >> 0];
    if (next == 42) {
     precision = getNextArg("i32");
     textIndex++;
    } else {
     while (1) {
      var precisionChr = HEAP8[textIndex + 1 >> 0];
      if (precisionChr < 48 || precisionChr > 57) break;
      precision = precision * 10 + (precisionChr - 48);
      textIndex++;
     }
    }
    next = HEAP8[textIndex + 1 >> 0];
   }
   if (precision < 0) {
    precision = 6;
    precisionSet = false;
   }
   var argSize;
   switch (String.fromCharCode(next)) {
   case "h":
    var nextNext = HEAP8[textIndex + 2 >> 0];
    if (nextNext == 104) {
     textIndex++;
     argSize = 1;
    } else {
     argSize = 2;
    }
    break;
   case "l":
    var nextNext = HEAP8[textIndex + 2 >> 0];
    if (nextNext == 108) {
     textIndex++;
     argSize = 8;
    } else {
     argSize = 4;
    }
    break;
   case "L":
   case "q":
   case "j":
    argSize = 8;
    break;
   case "z":
   case "t":
   case "I":
    argSize = 4;
    break;
   default:
    argSize = null;
   }
   if (argSize) textIndex++;
   next = HEAP8[textIndex + 1 >> 0];
   switch (String.fromCharCode(next)) {
   case "d":
   case "i":
   case "u":
   case "o":
   case "x":
   case "X":
   case "p":
    {
     var signed = next == 100 || next == 105;
     argSize = argSize || 4;
     var currArg = getNextArg("i" + argSize * 8);
     var origArg = currArg;
     var argText;
     if (argSize == 8) {
      currArg = Runtime.makeBigInt(currArg[0], currArg[1], next == 117);
     }
     if (argSize <= 4) {
      var limit = Math.pow(256, argSize) - 1;
      currArg = (signed ? reSign : unSign)(currArg & limit, argSize * 8);
     }
     var currAbsArg = Math.abs(currArg);
     var prefix = "";
     if (next == 100 || next == 105) {
      if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], null); else argText = reSign(currArg, 8 * argSize, 1).toString(10);
     } else if (next == 117) {
      if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], true); else argText = unSign(currArg, 8 * argSize, 1).toString(10);
      currArg = Math.abs(currArg);
     } else if (next == 111) {
      argText = (flagAlternative ? "0" : "") + currAbsArg.toString(8);
     } else if (next == 120 || next == 88) {
      prefix = flagAlternative && currArg != 0 ? "0x" : "";
      if (argSize == 8 && i64Math) {
       if (origArg[1]) {
        argText = (origArg[1] >>> 0).toString(16);
        var lower = (origArg[0] >>> 0).toString(16);
        while (lower.length < 8) lower = "0" + lower;
        argText += lower;
       } else {
        argText = (origArg[0] >>> 0).toString(16);
       }
      } else if (currArg < 0) {
       currArg = -currArg;
       argText = (currAbsArg - 1).toString(16);
       var buffer = [];
       for (var i = 0; i < argText.length; i++) {
        buffer.push((15 - parseInt(argText[i], 16)).toString(16));
       }
       argText = buffer.join("");
       while (argText.length < argSize * 2) argText = "f" + argText;
      } else {
       argText = currAbsArg.toString(16);
      }
      if (next == 88) {
       prefix = prefix.toUpperCase();
       argText = argText.toUpperCase();
      }
     } else if (next == 112) {
      if (currAbsArg === 0) {
       argText = "(nil)";
      } else {
       prefix = "0x";
       argText = currAbsArg.toString(16);
      }
     }
     if (precisionSet) {
      while (argText.length < precision) {
       argText = "0" + argText;
      }
     }
     if (currArg >= 0) {
      if (flagAlwaysSigned) {
       prefix = "+" + prefix;
      } else if (flagPadSign) {
       prefix = " " + prefix;
      }
     }
     if (argText.charAt(0) == "-") {
      prefix = "-" + prefix;
      argText = argText.substr(1);
     }
     while (prefix.length + argText.length < width) {
      if (flagLeftAlign) {
       argText += " ";
      } else {
       if (flagZeroPad) {
        argText = "0" + argText;
       } else {
        prefix = " " + prefix;
       }
      }
     }
     argText = prefix + argText;
     argText.split("").forEach((function(chr) {
      ret.push(chr.charCodeAt(0));
     }));
     break;
    }
   case "f":
   case "F":
   case "e":
   case "E":
   case "g":
   case "G":
    {
     var currArg = getNextArg("double");
     var argText;
     if (isNaN(currArg)) {
      argText = "nan";
      flagZeroPad = false;
     } else if (!isFinite(currArg)) {
      argText = (currArg < 0 ? "-" : "") + "inf";
      flagZeroPad = false;
     } else {
      var isGeneral = false;
      var effectivePrecision = Math.min(precision, 20);
      if (next == 103 || next == 71) {
       isGeneral = true;
       precision = precision || 1;
       var exponent = parseInt(currArg.toExponential(effectivePrecision).split("e")[1], 10);
       if (precision > exponent && exponent >= -4) {
        next = (next == 103 ? "f" : "F").charCodeAt(0);
        precision -= exponent + 1;
       } else {
        next = (next == 103 ? "e" : "E").charCodeAt(0);
        precision--;
       }
       effectivePrecision = Math.min(precision, 20);
      }
      if (next == 101 || next == 69) {
       argText = currArg.toExponential(effectivePrecision);
       if (/[eE][-+]\d$/.test(argText)) {
        argText = argText.slice(0, -1) + "0" + argText.slice(-1);
       }
      } else if (next == 102 || next == 70) {
       argText = currArg.toFixed(effectivePrecision);
       if (currArg === 0 && __reallyNegative(currArg)) {
        argText = "-" + argText;
       }
      }
      var parts = argText.split("e");
      if (isGeneral && !flagAlternative) {
       while (parts[0].length > 1 && parts[0].indexOf(".") != -1 && (parts[0].slice(-1) == "0" || parts[0].slice(-1) == ".")) {
        parts[0] = parts[0].slice(0, -1);
       }
      } else {
       if (flagAlternative && argText.indexOf(".") == -1) parts[0] += ".";
       while (precision > effectivePrecision++) parts[0] += "0";
      }
      argText = parts[0] + (parts.length > 1 ? "e" + parts[1] : "");
      if (next == 69) argText = argText.toUpperCase();
      if (currArg >= 0) {
       if (flagAlwaysSigned) {
        argText = "+" + argText;
       } else if (flagPadSign) {
        argText = " " + argText;
       }
      }
     }
     while (argText.length < width) {
      if (flagLeftAlign) {
       argText += " ";
      } else {
       if (flagZeroPad && (argText[0] == "-" || argText[0] == "+")) {
        argText = argText[0] + "0" + argText.slice(1);
       } else {
        argText = (flagZeroPad ? "0" : " ") + argText;
       }
      }
     }
     if (next < 97) argText = argText.toUpperCase();
     argText.split("").forEach((function(chr) {
      ret.push(chr.charCodeAt(0));
     }));
     break;
    }
   case "s":
    {
     var arg = getNextArg("i8*");
     var argLength = arg ? _strlen(arg) : "(null)".length;
     if (precisionSet) argLength = Math.min(argLength, precision);
     if (!flagLeftAlign) {
      while (argLength < width--) {
       ret.push(32);
      }
     }
     if (arg) {
      for (var i = 0; i < argLength; i++) {
       ret.push(HEAPU8[arg++ >> 0]);
      }
     } else {
      ret = ret.concat(intArrayFromString("(null)".substr(0, argLength), true));
     }
     if (flagLeftAlign) {
      while (argLength < width--) {
       ret.push(32);
      }
     }
     break;
    }
   case "c":
    {
     if (flagLeftAlign) ret.push(getNextArg("i8"));
     while (--width > 0) {
      ret.push(32);
     }
     if (!flagLeftAlign) ret.push(getNextArg("i8"));
     break;
    }
   case "n":
    {
     var ptr = getNextArg("i32*");
     HEAP32[ptr >> 2] = ret.length;
     break;
    }
   case "%":
    {
     ret.push(curr);
     break;
    }
   default:
    {
     for (var i = startTextIndex; i < textIndex + 2; i++) {
      ret.push(HEAP8[i >> 0]);
     }
    }
   }
   textIndex += 2;
  } else {
   ret.push(curr);
   textIndex += 1;
  }
 }
 return ret;
}
Module["__formatString"] = __formatString;
function _emscripten_log(flags, varargs) {
 var format = HEAP32[varargs >> 2];
 varargs += Math.max(Runtime.getNativeFieldSize("i32"), Runtime.getAlignSize("i32", null, true));
 var str = "";
 if (format) {
  var result = __formatString(format, varargs);
  for (var i = 0; i < result.length; ++i) {
   str += String.fromCharCode(result[i]);
  }
 }
 _emscripten_log_js(flags, str);
}
Module["_emscripten_log"] = _emscripten_log;
function _emscripten_get_compiler_setting(name) {
 name = Pointer_stringify(name);
 var ret = Runtime.getCompilerSetting(name);
 if (typeof ret === "number") return ret;
 if (!_emscripten_get_compiler_setting.cache) _emscripten_get_compiler_setting.cache = {};
 var cache = _emscripten_get_compiler_setting.cache;
 var fullname = name + "__str";
 var fullret = cache[fullname];
 if (fullret) return fullret;
 return cache[fullname] = allocate(intArrayFromString(ret + ""), "i8", ALLOC_NORMAL);
}
Module["_emscripten_get_compiler_setting"] = _emscripten_get_compiler_setting;
function _emscripten_debugger() {
 debugger;
}
Module["_emscripten_debugger"] = _emscripten_debugger;
function _emscripten_print_double(x, to, max) {
 var str = x + "";
 var ret = str.length;
 if (str.length + 1 > max) str = str.substring(0, max - 1);
 if (to) writeStringToMemory(str, to);
 return ret;
}
Module["_emscripten_print_double"] = _emscripten_print_double;
function ___lockfile() {
 return 1;
}
Module["___lockfile"] = ___lockfile;
function ___unlockfile() {}
Module["___unlockfile"] = ___unlockfile;
function ___ubsan_handle_float_cast_overflow(id, post) {
 abort("Undefined behavior! ubsan_handle_float_cast_overflow: " + [ id, post ]);
}
Module["___ubsan_handle_float_cast_overflow"] = ___ubsan_handle_float_cast_overflow;
function __pthread_cleanup_push() {}
Module["__pthread_cleanup_push"] = __pthread_cleanup_push;
function __pthread_cleanup_pop() {}
Module["__pthread_cleanup_pop"] = __pthread_cleanup_pop;
function ___pthread_self() {
 abort();
}
Module["___pthread_self"] = ___pthread_self;
function __Unwind_Backtrace(func, arg) {
 var trace = _emscripten_get_callstack_js();
 var parts = trace.split("\n");
 for (var i = 0; i < parts.length; i++) {
  var ret = Module.dynCall("iii", [ 0, arg ]);
  if (ret !== 0) return;
 }
}
Module["__Unwind_Backtrace"] = __Unwind_Backtrace;
function __Unwind_GetIPInfo() {
 abort("Unwind_GetIPInfo");
}
Module["__Unwind_GetIPInfo"] = __Unwind_GetIPInfo;
function __Unwind_FindEnclosingFunction() {
 return 0;
}
Module["__Unwind_FindEnclosingFunction"] = __Unwind_FindEnclosingFunction;
function __Unwind_RaiseException(ex) {
 Module.printErr("Warning: _Unwind_RaiseException is not correctly implemented");
 return ___cxa_throw(ex, 0, 0);
}
Module["__Unwind_RaiseException"] = __Unwind_RaiseException;
function __Unwind_DeleteException(ex) {
 Module.printErr("TODO: Unwind_DeleteException");
}
Module["__Unwind_DeleteException"] = __Unwind_DeleteException;
function _emscripten_autodebug_i64(line, valuel, valueh) {
 Module.print("AD:" + [ line, valuel, valueh ]);
}
Module["_emscripten_autodebug_i64"] = _emscripten_autodebug_i64;
function _emscripten_autodebug_i32(line, value) {
 Module.print("AD:" + [ line, value ]);
}
Module["_emscripten_autodebug_i32"] = _emscripten_autodebug_i32;
function _emscripten_autodebug_i16(line, value) {
 Module.print("AD:" + [ line, value ]);
}
Module["_emscripten_autodebug_i16"] = _emscripten_autodebug_i16;
function _emscripten_autodebug_i8(line, value) {
 Module.print("AD:" + [ line, value ]);
}
Module["_emscripten_autodebug_i8"] = _emscripten_autodebug_i8;
function _emscripten_autodebug_float(line, value) {
 Module.print("AD:" + [ line, value ]);
}
Module["_emscripten_autodebug_float"] = _emscripten_autodebug_float;
function _emscripten_autodebug_double(line, value) {
 Module.print("AD:" + [ line, value ]);
}
Module["_emscripten_autodebug_double"] = _emscripten_autodebug_double;
var _emscripten_prep_setjmp = true;
Module["_emscripten_prep_setjmp"] = _emscripten_prep_setjmp;
var _emscripten_cleanup_setjmp = true;
Module["_emscripten_cleanup_setjmp"] = _emscripten_cleanup_setjmp;
var _emscripten_check_longjmp = true;
Module["_emscripten_check_longjmp"] = _emscripten_check_longjmp;
var _emscripten_get_longjmp_result = true;
Module["_emscripten_get_longjmp_result"] = _emscripten_get_longjmp_result;
var _emscripten_setjmp = true;
Module["_emscripten_setjmp"] = _emscripten_setjmp;
var _emscripten_preinvoke = true;
Module["_emscripten_preinvoke"] = _emscripten_preinvoke;
var _emscripten_postinvoke = true;
Module["_emscripten_postinvoke"] = _emscripten_postinvoke;
var _emscripten_resume = true;
Module["_emscripten_resume"] = _emscripten_resume;
var _emscripten_landingpad = true;
Module["_emscripten_landingpad"] = _emscripten_landingpad;
var _getHigh32 = true;
Module["_getHigh32"] = _getHigh32;
var _setHigh32 = true;
Module["_setHigh32"] = _setHigh32;
var _FtoILow = true;
Module["_FtoILow"] = _FtoILow;
var _FtoIHigh = true;
Module["_FtoIHigh"] = _FtoIHigh;
var _DtoILow = true;
Module["_DtoILow"] = _DtoILow;
var _DtoIHigh = true;
Module["_DtoIHigh"] = _DtoIHigh;
var _BDtoILow = true;
Module["_BDtoILow"] = _BDtoILow;
var _BDtoIHigh = true;
Module["_BDtoIHigh"] = _BDtoIHigh;
var _SItoF = true;
Module["_SItoF"] = _SItoF;
var _UItoF = true;
Module["_UItoF"] = _UItoF;
var _SItoD = true;
Module["_SItoD"] = _SItoD;
var _UItoD = true;
Module["_UItoD"] = _UItoD;
var _BItoD = true;
Module["_BItoD"] = _BItoD;
var _llvm_dbg_value = true;
Module["_llvm_dbg_value"] = _llvm_dbg_value;
var _llvm_debugtrap = true;
Module["_llvm_debugtrap"] = _llvm_debugtrap;
var _llvm_maxnum_f32 = true;
Module["_llvm_maxnum_f32"] = _llvm_maxnum_f32;
var _llvm_maxnum_f64 = true;
Module["_llvm_maxnum_f64"] = _llvm_maxnum_f64;
var _emscripten_asm_const = true;
Module["_emscripten_asm_const"] = _emscripten_asm_const;
var _emscripten_asm_const_double = true;
Module["_emscripten_asm_const_double"] = _emscripten_asm_const_double;
function _emscripten_wget(url, file) {
 throw "Please compile your program with -s ASYNCIFY=1 in order to use asynchronous operations like emscripten_wget";
}
Module["_emscripten_wget"] = _emscripten_wget;
function _emscripten_async_wget(url, file, onload, onerror) {
 Module["noExitRuntime"] = true;
 var _url = Pointer_stringify(url);
 var _file = Pointer_stringify(file);
 function doCallback(callback) {
  if (callback) {
   var stack = Runtime.stackSave();
   Runtime.dynCall("vi", callback, [ allocate(intArrayFromString(_file), "i8", ALLOC_STACK) ]);
   Runtime.stackRestore(stack);
  }
 }
 FS.createPreloadedFile(PATH.dirname(_file), PATH.basename(_file), _url, true, true, (function() {
  doCallback(onload);
 }), (function() {
  doCallback(onerror);
 }), false, false, (function() {
  try {
   FS.unlink(_file);
  } catch (e) {}
 }));
}
Module["_emscripten_async_wget"] = _emscripten_async_wget;
function _emscripten_wget_data(url, file) {
 throw "Please compile your program with -s EMTERPRETER_ASYNC=1 in order to use asynchronous operations like emscripten_wget_data";
}
Module["_emscripten_wget_data"] = _emscripten_wget_data;
function _emscripten_async_wget_data(url, arg, onload, onerror) {
 Browser.asyncLoad(Pointer_stringify(url), (function(byteArray) {
  var buffer = _malloc(byteArray.length);
  HEAPU8.set(byteArray, buffer);
  Runtime.dynCall("viii", onload, [ arg, buffer, byteArray.length ]);
  _free(buffer);
 }), (function() {
  if (onerror) Runtime.dynCall("vi", onerror, [ arg ]);
 }), true);
}
Module["_emscripten_async_wget_data"] = _emscripten_async_wget_data;
function _emscripten_async_wget2(url, file, request, param, arg, onload, onerror, onprogress) {
 Module["noExitRuntime"] = true;
 var _url = Pointer_stringify(url);
 var _file = Pointer_stringify(file);
 var _request = Pointer_stringify(request);
 var _param = Pointer_stringify(param);
 var index = _file.lastIndexOf("/");
 var http = new XMLHttpRequest;
 http.open(_request, _url, true);
 http.responseType = "arraybuffer";
 var handle = Browser.getNextWgetRequestHandle();
 http.onload = function http_onload(e) {
  if (http.status == 200) {
   try {
    FS.unlink(_file);
   } catch (e) {}
   FS.createDataFile(_file.substr(0, index), _file.substr(index + 1), new Uint8Array(http.response), true, true, false);
   if (onload) {
    var stack = Runtime.stackSave();
    Runtime.dynCall("viii", onload, [ handle, arg, allocate(intArrayFromString(_file), "i8", ALLOC_STACK) ]);
    Runtime.stackRestore(stack);
   }
  } else {
   if (onerror) Runtime.dynCall("viii", onerror, [ handle, arg, http.status ]);
  }
  delete Browser.wgetRequests[handle];
 };
 http.onerror = function http_onerror(e) {
  if (onerror) Runtime.dynCall("viii", onerror, [ handle, arg, http.status ]);
  delete Browser.wgetRequests[handle];
 };
 http.onprogress = function http_onprogress(e) {
  if (e.lengthComputable || e.lengthComputable === undefined && e.total != 0) {
   var percentComplete = e.loaded / e.total * 100;
   if (onprogress) Runtime.dynCall("viii", onprogress, [ handle, arg, percentComplete ]);
  }
 };
 http.onabort = function http_onabort(e) {
  delete Browser.wgetRequests[handle];
 };
 try {
  if (http.channel instanceof Ci.nsIHttpChannel) http.channel.redirectionLimit = 0;
 } catch (ex) {}
 if (_request == "POST") {
  http.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
  http.send(_param);
 } else {
  http.send(null);
 }
 Browser.wgetRequests[handle] = http;
 return handle;
}
Module["_emscripten_async_wget2"] = _emscripten_async_wget2;
function _emscripten_async_wget2_data(url, request, param, arg, free, onload, onerror, onprogress) {
 var _url = Pointer_stringify(url);
 var _request = Pointer_stringify(request);
 var _param = Pointer_stringify(param);
 var http = new XMLHttpRequest;
 http.open(_request, _url, true);
 http.responseType = "arraybuffer";
 var handle = Browser.getNextWgetRequestHandle();
 http.onload = function http_onload(e) {
  if (http.status == 200 || _url.substr(0, 4).toLowerCase() != "http") {
   var byteArray = new Uint8Array(http.response);
   var buffer = _malloc(byteArray.length);
   HEAPU8.set(byteArray, buffer);
   if (onload) Runtime.dynCall("viiii", onload, [ handle, arg, buffer, byteArray.length ]);
   if (free) _free(buffer);
  } else {
   if (onerror) Runtime.dynCall("viiii", onerror, [ handle, arg, http.status, http.statusText ]);
  }
  delete Browser.wgetRequests[handle];
 };
 http.onerror = function http_onerror(e) {
  if (onerror) {
   Runtime.dynCall("viiii", onerror, [ handle, arg, http.status, http.statusText ]);
  }
  delete Browser.wgetRequests[handle];
 };
 http.onprogress = function http_onprogress(e) {
  if (onprogress) Runtime.dynCall("viiii", onprogress, [ handle, arg, e.loaded, e.lengthComputable || e.lengthComputable === undefined ? e.total : 0 ]);
 };
 http.onabort = function http_onabort(e) {
  delete Browser.wgetRequests[handle];
 };
 try {
  if (http.channel instanceof Ci.nsIHttpChannel) http.channel.redirectionLimit = 0;
 } catch (ex) {}
 if (_request == "POST") {
  http.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
  http.send(_param);
 } else {
  http.send(null);
 }
 Browser.wgetRequests[handle] = http;
 return handle;
}
Module["_emscripten_async_wget2_data"] = _emscripten_async_wget2_data;
function _emscripten_async_wget2_abort(handle) {
 var http = Browser.wgetRequests[handle];
 if (http) {
  http.abort();
 }
}
Module["_emscripten_async_wget2_abort"] = _emscripten_async_wget2_abort;
function _emscripten_run_preload_plugins(file, onload, onerror) {
 Module["noExitRuntime"] = true;
 var _file = Pointer_stringify(file);
 var data = FS.analyzePath(_file);
 if (!data.exists) return -1;
 FS.createPreloadedFile(PATH.dirname(_file), PATH.basename(_file), new Uint8Array(data.object.contents), true, true, (function() {
  if (onload) Runtime.dynCall("vi", onload, [ file ]);
 }), (function() {
  if (onerror) Runtime.dynCall("vi", onerror, [ file ]);
 }), true);
 return 0;
}
Module["_emscripten_run_preload_plugins"] = _emscripten_run_preload_plugins;
function _emscripten_run_preload_plugins_data(data, size, suffix, arg, onload, onerror) {
 Module["noExitRuntime"] = true;
 var _suffix = Pointer_stringify(suffix);
 if (!Browser.asyncPrepareDataCounter) Browser.asyncPrepareDataCounter = 0;
 var name = "prepare_data_" + Browser.asyncPrepareDataCounter++ + "." + _suffix;
 var cname = _malloc(name.length + 1);
 writeStringToMemory(name, cname);
 FS.createPreloadedFile("/", name, HEAPU8.subarray(data, data + size), true, true, (function() {
  if (onload) Runtime.dynCall("vii", onload, [ arg, cname ]);
 }), (function() {
  if (onerror) Runtime.dynCall("vi", onerror, [ arg ]);
 }), true);
 return 0;
}
Module["_emscripten_run_preload_plugins_data"] = _emscripten_run_preload_plugins_data;
function _emscripten_async_run_script(script, millis) {
 Module["noExitRuntime"] = true;
 Browser.safeSetTimeout((function() {
  _emscripten_run_script(script);
 }), millis);
}
Module["_emscripten_async_run_script"] = _emscripten_async_run_script;
function _emscripten_async_load_script(url, onload, onerror) {
 Module["noExitRuntime"] = true;
 onload = Runtime.getFuncWrapper(onload, "v");
 assert(runDependencies === 0, "async_load_script must be run when no other dependencies are active");
 var script = document.createElement("script");
 script.onload = function script_onload() {
  if (runDependencies > 0) {
   dependenciesFulfilled = onload;
  } else {
   onload();
  }
 };
 script.onerror = onerror;
 script.src = Pointer_stringify(url);
 document.body.appendChild(script);
}
Module["_emscripten_async_load_script"] = _emscripten_async_load_script;
function _emscripten_set_main_loop_arg(func, arg, fps, simulateInfiniteLoop) {
 _emscripten_set_main_loop(func, fps, simulateInfiniteLoop, arg);
}
Module["_emscripten_set_main_loop_arg"] = _emscripten_set_main_loop_arg;
function _emscripten_cancel_main_loop() {
 Browser.mainLoop.pause();
 Browser.mainLoop.func = null;
}
Module["_emscripten_cancel_main_loop"] = _emscripten_cancel_main_loop;
function _emscripten_pause_main_loop() {
 Browser.mainLoop.pause();
}
Module["_emscripten_pause_main_loop"] = _emscripten_pause_main_loop;
function _emscripten_resume_main_loop() {
 Browser.mainLoop.resume();
}
Module["_emscripten_resume_main_loop"] = _emscripten_resume_main_loop;
function __emscripten_push_main_loop_blocker(func, arg, name) {
 Browser.mainLoop.queue.push({
  func: (function() {
   Runtime.dynCall("vi", func, [ arg ]);
  }),
  name: Pointer_stringify(name),
  counted: true
 });
 Browser.mainLoop.updateStatus();
}
Module["__emscripten_push_main_loop_blocker"] = __emscripten_push_main_loop_blocker;
function __emscripten_push_uncounted_main_loop_blocker(func, arg, name) {
 Browser.mainLoop.queue.push({
  func: (function() {
   Runtime.dynCall("vi", func, [ arg ]);
  }),
  name: Pointer_stringify(name),
  counted: false
 });
 Browser.mainLoop.updateStatus();
}
Module["__emscripten_push_uncounted_main_loop_blocker"] = __emscripten_push_uncounted_main_loop_blocker;
function _emscripten_set_main_loop_expected_blockers(num) {
 Browser.mainLoop.expectedBlockers = num;
 Browser.mainLoop.remainingBlockers = num;
 Browser.mainLoop.updateStatus();
}
Module["_emscripten_set_main_loop_expected_blockers"] = _emscripten_set_main_loop_expected_blockers;
function _emscripten_async_call(func, arg, millis) {
 Module["noExitRuntime"] = true;
 function wrapper() {
  Runtime.getFuncWrapper(func, "vi")(arg);
 }
 if (millis >= 0) {
  Browser.safeSetTimeout(wrapper, millis);
 } else {
  Browser.safeRequestAnimationFrame(wrapper);
 }
}
Module["_emscripten_async_call"] = _emscripten_async_call;
function _emscripten_exit_with_live_runtime() {
 Module["noExitRuntime"] = true;
 throw "SimulateInfiniteLoop";
}
Module["_emscripten_exit_with_live_runtime"] = _emscripten_exit_with_live_runtime;
function _emscripten_force_exit(status) {
 Module["noExitRuntime"] = false;
 Module["exit"](status);
}
Module["_emscripten_force_exit"] = _emscripten_force_exit;
function _emscripten_get_device_pixel_ratio() {
 return window.devicePixelRatio || 1;
}
Module["_emscripten_get_device_pixel_ratio"] = _emscripten_get_device_pixel_ratio;
function _emscripten_hide_mouse() {
 var styleSheet = document.styleSheets[0];
 var rules = styleSheet.cssRules;
 for (var i = 0; i < rules.length; i++) {
  if (rules[i].cssText.substr(0, 6) == "canvas") {
   styleSheet.deleteRule(i);
   i--;
  }
 }
 styleSheet.insertRule("canvas.emscripten { border: 1px solid black; cursor: none; }", 0);
}
Module["_emscripten_hide_mouse"] = _emscripten_hide_mouse;
function _emscripten_get_canvas_size(width, height, isFullscreen) {
 var canvas = Module["canvas"];
 HEAP32[width >> 2] = canvas.width;
 HEAP32[height >> 2] = canvas.height;
 HEAP32[isFullscreen >> 2] = Browser.isFullscreen ? 1 : 0;
}
Module["_emscripten_get_canvas_size"] = _emscripten_get_canvas_size;
function _emscripten_create_worker(url) {
 url = Pointer_stringify(url);
 var id = Browser.workers.length;
 var info = {
  worker: new Worker(url),
  callbacks: [],
  awaited: 0,
  buffer: 0,
  bufferSize: 0
 };
 info.worker.onmessage = function info_worker_onmessage(msg) {
  if (ABORT) return;
  var info = Browser.workers[id];
  if (!info) return;
  var callbackId = msg.data["callbackId"];
  var callbackInfo = info.callbacks[callbackId];
  if (!callbackInfo) return;
  if (msg.data["finalResponse"]) {
   info.awaited--;
   info.callbacks[callbackId] = null;
  }
  var data = msg.data["data"];
  if (data) {
   if (!data.byteLength) data = new Uint8Array(data);
   if (!info.buffer || info.bufferSize < data.length) {
    if (info.buffer) _free(info.buffer);
    info.bufferSize = data.length;
    info.buffer = _malloc(data.length);
   }
   HEAPU8.set(data, info.buffer);
   callbackInfo.func(info.buffer, data.length, callbackInfo.arg);
  } else {
   callbackInfo.func(0, 0, callbackInfo.arg);
  }
 };
 Browser.workers.push(info);
 return id;
}
Module["_emscripten_create_worker"] = _emscripten_create_worker;
function _emscripten_destroy_worker(id) {
 var info = Browser.workers[id];
 info.worker.terminate();
 if (info.buffer) _free(info.buffer);
 Browser.workers[id] = null;
}
Module["_emscripten_destroy_worker"] = _emscripten_destroy_worker;
function _emscripten_call_worker(id, funcName, data, size, callback, arg) {
 Module["noExitRuntime"] = true;
 funcName = Pointer_stringify(funcName);
 var info = Browser.workers[id];
 var callbackId = -1;
 if (callback) {
  callbackId = info.callbacks.length;
  info.callbacks.push({
   func: Runtime.getFuncWrapper(callback, "viii"),
   arg: arg
  });
  info.awaited++;
 }
 var transferObject = {
  "funcName": funcName,
  "callbackId": callbackId,
  "data": data ? new Uint8Array(HEAPU8.subarray(data, data + size)) : 0
 };
 if (data) {
  info.worker.postMessage(transferObject, [ transferObject.data.buffer ]);
 } else {
  info.worker.postMessage(transferObject);
 }
}
Module["_emscripten_call_worker"] = _emscripten_call_worker;
function _emscripten_worker_respond_provisionally(data, size) {
 if (workerResponded) throw "already responded with final response!";
 var transferObject = {
  "callbackId": workerCallbackId,
  "finalResponse": false,
  "data": data ? new Uint8Array(HEAPU8.subarray(data, data + size)) : 0
 };
 if (data) {
  postMessage(transferObject, [ transferObject.data.buffer ]);
 } else {
  postMessage(transferObject);
 }
}
Module["_emscripten_worker_respond_provisionally"] = _emscripten_worker_respond_provisionally;
function _emscripten_worker_respond(data, size) {
 if (workerResponded) throw "already responded with final response!";
 workerResponded = true;
 var transferObject = {
  "callbackId": workerCallbackId,
  "finalResponse": true,
  "data": data ? new Uint8Array(HEAPU8.subarray(data, data + size)) : 0
 };
 if (data) {
  postMessage(transferObject, [ transferObject.data.buffer ]);
 } else {
  postMessage(transferObject);
 }
}
Module["_emscripten_worker_respond"] = _emscripten_worker_respond;
function _emscripten_get_worker_queue_size(id) {
 var info = Browser.workers[id];
 if (!info) return -1;
 return info.awaited;
}
Module["_emscripten_get_worker_queue_size"] = _emscripten_get_worker_queue_size;
function _emscripten_get_preloaded_image_data(path, w, h) {
 if (typeof path === "number") {
  path = Pointer_stringify(path);
 }
 path = PATH.resolve(path);
 var canvas = Module["preloadedImages"][path];
 if (canvas) {
  var ctx = canvas.getContext("2d");
  var image = ctx.getImageData(0, 0, canvas.width, canvas.height);
  var buf = _malloc(canvas.width * canvas.height * 4);
  HEAPU8.set(image.data, buf);
  HEAP32[w >> 2] = canvas.width;
  HEAP32[h >> 2] = canvas.height;
  return buf;
 }
 return 0;
}
Module["_emscripten_get_preloaded_image_data"] = _emscripten_get_preloaded_image_data;
function _emscripten_get_preloaded_image_data_from_FILE(file, w, h) {
 var fd = Module["_fileno"](file);
 var stream = FS.getStream(fd);
 if (stream) {
  return _emscripten_get_preloaded_image_data(stream.path, w, h);
 }
 return 0;
}
Module["_emscripten_get_preloaded_image_data_from_FILE"] = _emscripten_get_preloaded_image_data_from_FILE;
function _printf(format, varargs) {
 var result = __formatString(format, varargs);
 var string = intArrayToString(result);
 if (string[string.length - 1] === "\n") string = string.substr(0, string.length - 1);
 Module.print(string);
 return result.length;
}
Module["_printf"] = _printf;
function _puts(s) {
 var result = Pointer_stringify(s);
 var string = result.substr(0);
 if (string[string.length - 1] === "\n") string = string.substr(0, string.length - 1);
 Module.print(string);
 return result.length;
}
Module["_puts"] = _puts;
function ___syscall104(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  return -ERRNO_CODES.ENOSYS;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall104"] = ___syscall104;
function ___syscall213() {
 return ___syscall214.apply(null, arguments);
}
Module["___syscall213"] = ___syscall213;
function ___syscall210(which, varargs) {
 SYSCALLS.varargs = varargs;
 try {
  var ruid = SYSCALLS.get(), euid = SYSCALLS.get(), suid = SYSCALLS.get();
  if (euid !== 0) return -ERRNO_CODES.EPERM;
  return 0;
 } catch (e) {
  if (typeof FS === "undefined" || !(e instanceof FS.ErrnoError)) abort(e);
  return -e.errno;
 }
}
Module["___syscall210"] = ___syscall210;
function ___syscall208() {
 return ___syscall210.apply(null, arguments);
}
Module["___syscall208"] = ___syscall208;
function ___set_network_callback(event, userData, callback) {
 function _callback(data) {
  try {
   if (event === "error") {
    var sp = Runtime.stackSave();
    var msg = allocate(intArrayFromString(data[2]), "i8", ALLOC_STACK);
    Runtime.dynCall("viiii", callback, [ data[0], data[1], msg, userData ]);
    Runtime.stackRestore(sp);
   } else {
    Runtime.dynCall("vii", callback, [ data, userData ]);
   }
  } catch (e) {
   if (e instanceof ExitStatus) {
    return;
   } else {
    if (e && typeof e === "object" && e.stack) Module.printErr("exception thrown: " + [ e, e.stack ]);
    throw e;
   }
  }
 }
 Module["noExitRuntime"] = true;
 Module["websocket"]["on"](event, callback ? _callback : null);
}
Module["___set_network_callback"] = ___set_network_callback;
function _emscripten_set_socket_error_callback(userData, callback) {
 ___set_network_callback("error", userData, callback);
}
Module["_emscripten_set_socket_error_callback"] = _emscripten_set_socket_error_callback;
function _emscripten_set_socket_open_callback(userData, callback) {
 ___set_network_callback("open", userData, callback);
}
Module["_emscripten_set_socket_open_callback"] = _emscripten_set_socket_open_callback;
function _emscripten_set_socket_listen_callback(userData, callback) {
 ___set_network_callback("listen", userData, callback);
}
Module["_emscripten_set_socket_listen_callback"] = _emscripten_set_socket_listen_callback;
function _emscripten_set_socket_connection_callback(userData, callback) {
 ___set_network_callback("connection", userData, callback);
}
Module["_emscripten_set_socket_connection_callback"] = _emscripten_set_socket_connection_callback;
function _emscripten_set_socket_message_callback(userData, callback) {
 ___set_network_callback("message", userData, callback);
}
Module["_emscripten_set_socket_message_callback"] = _emscripten_set_socket_message_callback;
function _emscripten_set_socket_close_callback(userData, callback) {
 ___set_network_callback("close", userData, callback);
}
Module["_emscripten_set_socket_close_callback"] = _emscripten_set_socket_close_callback;
function _SDL_Linked_Version() {
 if (SDL.version === null) {
  SDL.version = _malloc(3);
  HEAP8[SDL.version + 0 >> 0] = 1;
  HEAP8[SDL.version + 1 >> 0] = 3;
  HEAP8[SDL.version + 2 >> 0] = 0;
 }
 return SDL.version;
}
Module["_SDL_Linked_Version"] = _SDL_Linked_Version;
function _SDL_Init(initFlags) {
 SDL.startTime = Date.now();
 SDL.initFlags = initFlags;
 if (!Module["doNotCaptureKeyboard"]) {
  var keyboardListeningElement = Module["keyboardListeningElement"] || document;
  keyboardListeningElement.addEventListener("keydown", SDL.receiveEvent);
  keyboardListeningElement.addEventListener("keyup", SDL.receiveEvent);
  keyboardListeningElement.addEventListener("keypress", SDL.receiveEvent);
  window.addEventListener("focus", SDL.receiveEvent);
  window.addEventListener("blur", SDL.receiveEvent);
  document.addEventListener("visibilitychange", SDL.receiveEvent);
 }
 if (initFlags & 512) {
  addEventListener("gamepadconnected", (function() {}));
 }
 window.addEventListener("unload", SDL.receiveEvent);
 SDL.keyboardState = _malloc(65536);
 _memset(SDL.keyboardState, 0, 65536);
 SDL.DOMEventToSDLEvent["keydown"] = 768;
 SDL.DOMEventToSDLEvent["keyup"] = 769;
 SDL.DOMEventToSDLEvent["keypress"] = 771;
 SDL.DOMEventToSDLEvent["mousedown"] = 1025;
 SDL.DOMEventToSDLEvent["mouseup"] = 1026;
 SDL.DOMEventToSDLEvent["mousemove"] = 1024;
 SDL.DOMEventToSDLEvent["wheel"] = 1027;
 SDL.DOMEventToSDLEvent["touchstart"] = 1792;
 SDL.DOMEventToSDLEvent["touchend"] = 1793;
 SDL.DOMEventToSDLEvent["touchmove"] = 1794;
 SDL.DOMEventToSDLEvent["unload"] = 256;
 SDL.DOMEventToSDLEvent["resize"] = 28673;
 SDL.DOMEventToSDLEvent["visibilitychange"] = 512;
 SDL.DOMEventToSDLEvent["focus"] = 512;
 SDL.DOMEventToSDLEvent["blur"] = 512;
 SDL.DOMEventToSDLEvent["joystick_axis_motion"] = 1536;
 SDL.DOMEventToSDLEvent["joystick_button_down"] = 1539;
 SDL.DOMEventToSDLEvent["joystick_button_up"] = 1540;
 return 0;
}
Module["_SDL_Init"] = _SDL_Init;
function _SDL_WasInit() {
 if (SDL.startTime === null) {
  _SDL_Init();
 }
 return 1;
}
Module["_SDL_WasInit"] = _SDL_WasInit;
function _SDL_GetVideoInfo() {
 var ret = _malloc(5 * Runtime.QUANTUM_SIZE);
 HEAP32[ret + Runtime.QUANTUM_SIZE * 0 >> 2] = 0;
 HEAP32[ret + Runtime.QUANTUM_SIZE * 1 >> 2] = 0;
 HEAP32[ret + Runtime.QUANTUM_SIZE * 2 >> 2] = 0;
 HEAP32[ret + Runtime.QUANTUM_SIZE * 3 >> 2] = Module["canvas"].width;
 HEAP32[ret + Runtime.QUANTUM_SIZE * 4 >> 2] = Module["canvas"].height;
 return ret;
}
Module["_SDL_GetVideoInfo"] = _SDL_GetVideoInfo;
function _SDL_ListModes(format, flags) {
 return -1;
}
Module["_SDL_ListModes"] = _SDL_ListModes;
function _SDL_VideoModeOK(width, height, depth, flags) {
 return depth;
}
Module["_SDL_VideoModeOK"] = _SDL_VideoModeOK;
function _SDL_VideoDriverName(buf, max_size) {
 if (SDL.startTime === null) {
  return 0;
 }
 var driverName = [ 101, 109, 115, 99, 114, 105, 112, 116, 101, 110, 95, 115, 100, 108, 95, 100, 114, 105, 118, 101, 114 ];
 var index = 0;
 var size = driverName.length;
 if (max_size <= size) {
  size = max_size - 1;
 }
 while (index < size) {
  var value = driverName[index];
  HEAP8[buf + index >> 0] = value;
  index++;
 }
 HEAP8[buf + index >> 0] = 0;
 return buf;
}
Module["_SDL_VideoDriverName"] = _SDL_VideoDriverName;
function _SDL_AudioDriverName(buf, max_size) {
 return _SDL_VideoDriverName(buf, max_size);
}
Module["_SDL_AudioDriverName"] = _SDL_AudioDriverName;
function _SDL_SetVideoMode(width, height, depth, flags) {
 [ "touchstart", "touchend", "touchmove", "mousedown", "mouseup", "mousemove", "DOMMouseScroll", "mousewheel", "wheel", "mouseout" ].forEach((function(event) {
  Module["canvas"].addEventListener(event, SDL.receiveEvent, true);
 }));
 var canvas = Module["canvas"];
 if (width == 0 && height == 0) {
  width = canvas.width;
  height = canvas.height;
 }
 if (!SDL.addedResizeListener) {
  SDL.addedResizeListener = true;
  Browser.resizeListeners.push((function(w, h) {
   if (!SDL.settingVideoMode) {
    SDL.receiveEvent({
     type: "resize",
     w: w,
     h: h
    });
   }
  }));
 }
 if (width !== canvas.width || height !== canvas.height) {
  SDL.settingVideoMode = true;
  Browser.setCanvasSize(width, height);
  SDL.settingVideoMode = false;
 }
 if (SDL.screen) {
  SDL.freeSurface(SDL.screen);
  assert(!SDL.screen);
 }
 if (SDL.GL) flags = flags | 67108864;
 SDL.screen = SDL.makeSurface(width, height, flags, true, "screen");
 return SDL.screen;
}
Module["_SDL_SetVideoMode"] = _SDL_SetVideoMode;
function _SDL_GetVideoSurface() {
 return SDL.screen;
}
Module["_SDL_GetVideoSurface"] = _SDL_GetVideoSurface;
function _SDL_AudioQuit() {
 for (var i = 0; i < SDL.numChannels; ++i) {
  if (SDL.channels[i].audio) {
   SDL.channels[i].audio.pause();
   SDL.channels[i].audio = undefined;
  }
 }
 if (SDL.music.audio) SDL.music.audio.pause();
 SDL.music.audio = undefined;
}
Module["_SDL_AudioQuit"] = _SDL_AudioQuit;
function _SDL_VideoQuit() {
 Module.print("SDL_VideoQuit called (and ignored)");
}
Module["_SDL_VideoQuit"] = _SDL_VideoQuit;
function _SDL_QuitSubSystem(flags) {
 Module.print("SDL_QuitSubSystem called (and ignored)");
}
Module["_SDL_QuitSubSystem"] = _SDL_QuitSubSystem;
function _SDL_Quit() {
 _SDL_AudioQuit();
 Module.print("SDL_Quit called (and ignored)");
}
Module["_SDL_Quit"] = _SDL_Quit;
function _SDL_UnlockSurface(surf) {
 assert(!SDL.GL);
 var surfData = SDL.surfaces[surf];
 if (!surfData.locked || --surfData.locked > 0) {
  return;
 }
 if (surfData.isFlagSet(2097152)) {
  SDL.copyIndexedColorData(surfData);
 } else if (!surfData.colors) {
  var data = surfData.image.data;
  var buffer = surfData.buffer;
  assert(buffer % 4 == 0, "Invalid buffer offset: " + buffer);
  var src = buffer >> 2;
  var dst = 0;
  var isScreen = surf == SDL.screen;
  var num;
  if (typeof CanvasPixelArray !== "undefined" && data instanceof CanvasPixelArray) {
   num = data.length;
   while (dst < num) {
    var val = HEAP32[src];
    data[dst] = val & 255;
    data[dst + 1] = val >> 8 & 255;
    data[dst + 2] = val >> 16 & 255;
    data[dst + 3] = isScreen ? 255 : val >> 24 & 255;
    src++;
    dst += 4;
   }
  } else {
   var data32 = new Uint32Array(data.buffer);
   if (isScreen && SDL.defaults.opaqueFrontBuffer) {
    num = data32.length;
    data32.set(HEAP32.subarray(src, src + num));
    var data8 = new Uint8Array(data.buffer);
    var i = 3;
    var j = i + 4 * num;
    if (num % 8 == 0) {
     while (i < j) {
      data8[i] = 255;
      i = i + 4 | 0;
      data8[i] = 255;
      i = i + 4 | 0;
      data8[i] = 255;
      i = i + 4 | 0;
      data8[i] = 255;
      i = i + 4 | 0;
      data8[i] = 255;
      i = i + 4 | 0;
      data8[i] = 255;
      i = i + 4 | 0;
      data8[i] = 255;
      i = i + 4 | 0;
      data8[i] = 255;
      i = i + 4 | 0;
     }
    } else {
     while (i < j) {
      data8[i] = 255;
      i = i + 4 | 0;
     }
    }
   } else {
    data32.set(HEAP32.subarray(src, src + data32.length));
   }
  }
 } else {
  var width = Module["canvas"].width;
  var height = Module["canvas"].height;
  var s = surfData.buffer;
  var data = surfData.image.data;
  var colors = surfData.colors;
  for (var y = 0; y < height; y++) {
   var base = y * width * 4;
   for (var x = 0; x < width; x++) {
    var val = HEAPU8[s++ >> 0] * 4;
    var start = base + x * 4;
    data[start] = colors[val];
    data[start + 1] = colors[val + 1];
    data[start + 2] = colors[val + 2];
   }
   s += width * 3;
  }
 }
 surfData.ctx.putImageData(surfData.image, 0, 0);
}
Module["_SDL_UnlockSurface"] = _SDL_UnlockSurface;
function _SDL_Flip(surf) {}
Module["_SDL_Flip"] = _SDL_Flip;
function _SDL_UpdateRect(surf, x, y, w, h) {}
Module["_SDL_UpdateRect"] = _SDL_UpdateRect;
function _SDL_UpdateRects(surf, numrects, rects) {}
Module["_SDL_UpdateRects"] = _SDL_UpdateRects;
function _SDL_Delay(delay) {
 if (!ENVIRONMENT_IS_WORKER) abort("SDL_Delay called on the main thread! Potential infinite loop, quitting.");
 var now = Date.now();
 while (Date.now() - now < delay) {}
}
Module["_SDL_Delay"] = _SDL_Delay;
function _SDL_WM_SetCaption(title, icon) {
 if (title && typeof Module["setWindowTitle"] !== "undefined") {
  Module["setWindowTitle"](Pointer_stringify(title));
 }
 icon = icon && Pointer_stringify(icon);
}
Module["_SDL_WM_SetCaption"] = _SDL_WM_SetCaption;
function _SDL_EnableKeyRepeat(delay, interval) {}
Module["_SDL_EnableKeyRepeat"] = _SDL_EnableKeyRepeat;
function _SDL_GetKeyboardState(numKeys) {
 if (numKeys) {
  HEAP32[numKeys >> 2] = 65536;
 }
 return SDL.keyboardState;
}
Module["_SDL_GetKeyboardState"] = _SDL_GetKeyboardState;
function _SDL_GetKeyState() {
 return _SDL_GetKeyboardState();
}
Module["_SDL_GetKeyState"] = _SDL_GetKeyState;
function _SDL_GetKeyName(key) {
 if (!SDL.keyName) {
  SDL.keyName = allocate(intArrayFromString("unknown key"), "i8", ALLOC_NORMAL);
 }
 return SDL.keyName;
}
Module["_SDL_GetKeyName"] = _SDL_GetKeyName;
function _SDL_GetModState() {
 return SDL.modState;
}
Module["_SDL_GetModState"] = _SDL_GetModState;
function _SDL_GetMouseState(x, y) {
 if (x) HEAP32[x >> 2] = Browser.mouseX;
 if (y) HEAP32[y >> 2] = Browser.mouseY;
 return SDL.buttonState;
}
Module["_SDL_GetMouseState"] = _SDL_GetMouseState;
function _SDL_WarpMouse(x, y) {
 return;
 var rect = Module["canvas"].getBoundingClientRect();
 SDL.events.push({
  type: "mousemove",
  pageX: x + (window.scrollX + rect.left),
  pageY: y + (window.scrollY + rect.top)
 });
}
Module["_SDL_WarpMouse"] = _SDL_WarpMouse;
function _SDL_ShowCursor(toggle) {
 switch (toggle) {
 case 0:
  if (Browser.isFullscreen) {
   Module["canvas"].requestPointerLock();
   return 0;
  } else {
   return 1;
  }
  break;
 case 1:
  Module["canvas"].exitPointerLock();
  return 1;
  break;
 case -1:
  return !Browser.pointerLock;
  break;
 default:
  console.log("SDL_ShowCursor called with unknown toggle parameter value: " + toggle + ".");
  break;
 }
}
Module["_SDL_ShowCursor"] = _SDL_ShowCursor;
function _SDL_GetError() {
 if (!SDL.errorMessage) {
  SDL.errorMessage = allocate(intArrayFromString("unknown SDL-emscripten error"), "i8", ALLOC_NORMAL);
 }
 return SDL.errorMessage;
}
Module["_SDL_GetError"] = _SDL_GetError;
function _SDL_SetError() {}
Module["_SDL_SetError"] = _SDL_SetError;
function _SDL_malloc() {
 return _malloc.apply(null, arguments);
}
Module["_SDL_malloc"] = _SDL_malloc;
function _SDL_free() {
 return _free.apply(null, arguments);
}
Module["_SDL_free"] = _SDL_free;
function _SDL_CreateRGBSurface(flags, width, height, depth, rmask, gmask, bmask, amask) {
 return SDL.makeSurface(width, height, flags, false, "CreateRGBSurface", rmask, gmask, bmask, amask);
}
Module["_SDL_CreateRGBSurface"] = _SDL_CreateRGBSurface;
function _SDL_CreateRGBSurfaceFrom(pixels, width, height, depth, pitch, rmask, gmask, bmask, amask) {
 var surf = SDL.makeSurface(width, height, 0, false, "CreateRGBSurfaceFrom", rmask, gmask, bmask, amask);
 if (depth !== 32) {
  console.log("TODO: Partially unimplemented SDL_CreateRGBSurfaceFrom called!");
  return surf;
 }
 var data = SDL.surfaces[surf];
 var image = data.ctx.createImageData(width, height);
 var pitchOfDst = width * 4;
 for (var row = 0; row < height; ++row) {
  var baseOfDst = row * pitchOfDst;
  for (var col = 0; col < width * 4; ++col) {
   image.data[baseOfDst + col] = HEAPU8[pixels + (baseOfDst + col) >> 0];
  }
 }
 data.ctx.putImageData(image, 0, 0);
 return surf;
}
Module["_SDL_CreateRGBSurfaceFrom"] = _SDL_CreateRGBSurfaceFrom;
function _SDL_ConvertSurface(surf, format, flags) {
 if (format) {
  SDL.checkPixelFormat(format);
 }
 var oldData = SDL.surfaces[surf];
 var ret = SDL.makeSurface(oldData.width, oldData.height, oldData.flags, false, "copy:" + oldData.source);
 var newData = SDL.surfaces[ret];
 newData.ctx.globalCompositeOperation = "copy";
 newData.ctx.drawImage(oldData.canvas, 0, 0);
 newData.ctx.globalCompositeOperation = oldData.ctx.globalCompositeOperation;
 return ret;
}
Module["_SDL_ConvertSurface"] = _SDL_ConvertSurface;
function _SDL_DisplayFormatAlpha(surf) {
 return _SDL_ConvertSurface(surf);
}
Module["_SDL_DisplayFormatAlpha"] = _SDL_DisplayFormatAlpha;
function _SDL_FreeSurface(surf) {
 if (surf) SDL.freeSurface(surf);
}
Module["_SDL_FreeSurface"] = _SDL_FreeSurface;
function _SDL_LowerBlit() {
 return _SDL_UpperBlit.apply(null, arguments);
}
Module["_SDL_LowerBlit"] = _SDL_LowerBlit;
function _SDL_LowerBlitScaled() {
 return _SDL_UpperBlitScaled.apply(null, arguments);
}
Module["_SDL_LowerBlitScaled"] = _SDL_LowerBlitScaled;
function _SDL_GetClipRect(surf, rect) {
 assert(rect);
 var surfData = SDL.surfaces[surf];
 var r = surfData.clipRect || {
  x: 0,
  y: 0,
  w: surfData.width,
  h: surfData.height
 };
 SDL.updateRect(rect, r);
}
Module["_SDL_GetClipRect"] = _SDL_GetClipRect;
function _SDL_SetClipRect(surf, rect) {
 var surfData = SDL.surfaces[surf];
 if (rect) {
  surfData.clipRect = SDL.intersectionOfRects({
   x: 0,
   y: 0,
   w: surfData.width,
   h: surfData.height
  }, SDL.loadRect(rect));
 } else {
  delete surfData.clipRect;
 }
}
Module["_SDL_SetClipRect"] = _SDL_SetClipRect;
function _SDL_FillRect(surf, rect, color) {
 var surfData = SDL.surfaces[surf];
 assert(!surfData.locked);
 if (surfData.isFlagSet(2097152)) {
  color = surfData.colors32[color];
 }
 var r = rect ? SDL.loadRect(rect) : {
  x: 0,
  y: 0,
  w: surfData.width,
  h: surfData.height
 };
 if (surfData.clipRect) {
  r = SDL.intersectionOfRects(surfData.clipRect, r);
  if (rect) {
   SDL.updateRect(rect, r);
  }
 }
 surfData.ctx.save();
 surfData.ctx.fillStyle = SDL.translateColorToCSSRGBA(color);
 surfData.ctx.fillRect(r.x, r.y, r.w, r.h);
 surfData.ctx.restore();
 return 0;
}
Module["_SDL_FillRect"] = _SDL_FillRect;
function _SDL_BlitSurface(src, srcrect, dst, dstrect) {
 return SDL.blitSurface(src, srcrect, dst, dstrect, false);
}
Module["_SDL_BlitSurface"] = _SDL_BlitSurface;
function _SDL_BlitScaled(src, srcrect, dst, dstrect) {
 return SDL.blitSurface(src, srcrect, dst, dstrect, true);
}
Module["_SDL_BlitScaled"] = _SDL_BlitScaled;
function _zoomSurface(src, x, y, smooth) {
 var srcData = SDL.surfaces[src];
 var w = srcData.width * x;
 var h = srcData.height * y;
 var ret = SDL.makeSurface(Math.abs(w), Math.abs(h), srcData.flags, false, "zoomSurface");
 var dstData = SDL.surfaces[ret];
 if (x >= 0 && y >= 0) dstData.ctx.drawImage(srcData.canvas, 0, 0, w, h); else {
  dstData.ctx.save();
  dstData.ctx.scale(x < 0 ? -1 : 1, y < 0 ? -1 : 1);
  dstData.ctx.drawImage(srcData.canvas, w < 0 ? w : 0, h < 0 ? h : 0, Math.abs(w), Math.abs(h));
  dstData.ctx.restore();
 }
 return ret;
}
Module["_zoomSurface"] = _zoomSurface;
function _rotozoomSurface(src, angle, zoom, smooth) {
 if (angle % 360 === 0) {
  return _zoomSurface(src, zoom, zoom, smooth);
 }
 var srcData = SDL.surfaces[src];
 var w = srcData.width * zoom;
 var h = srcData.height * zoom;
 var diagonal = Math.ceil(Math.sqrt(Math.pow(w, 2) + Math.pow(h, 2)));
 var ret = SDL.makeSurface(diagonal, diagonal, srcData.flags, false, "rotozoomSurface");
 var dstData = SDL.surfaces[ret];
 dstData.ctx.translate(diagonal / 2, diagonal / 2);
 dstData.ctx.rotate(-angle * Math.PI / 180);
 dstData.ctx.drawImage(srcData.canvas, -w / 2, -h / 2, w, h);
 return ret;
}
Module["_rotozoomSurface"] = _rotozoomSurface;
function _SDL_SetAlpha(surf, flag, alpha) {
 var surfData = SDL.surfaces[surf];
 surfData.alpha = alpha;
 if (!(flag & 65536)) {
  surfData.alpha = 255;
 }
}
Module["_SDL_SetAlpha"] = _SDL_SetAlpha;
function _SDL_SetColorKey(surf, flag, key) {
 Runtime.warnOnce("SDL_SetColorKey is a no-op for performance reasons");
 return 0;
}
Module["_SDL_SetColorKey"] = _SDL_SetColorKey;
function _SDL_PollEvent(ptr) {
 return SDL.pollEvent(ptr);
}
Module["_SDL_PollEvent"] = _SDL_PollEvent;
function _SDL_PushEvent(ptr) {
 var copy = _malloc(28);
 _memcpy(copy, ptr, 28);
 SDL.events.push(copy);
 return 0;
}
Module["_SDL_PushEvent"] = _SDL_PushEvent;
function _SDL_PeepEvents(events, requestedEventCount, action, from, to) {
 switch (action) {
 case 2:
  {
   assert(requestedEventCount == 1);
   var index = 0;
   var retrievedEventCount = 0;
   while (index < SDL.events.length && retrievedEventCount < requestedEventCount) {
    var event = SDL.events[index];
    var type = SDL.DOMEventToSDLEvent[event.type];
    if (from <= type && type <= to) {
     if (SDL.makeCEvent(event, events) === false) {
      index++;
     } else {
      SDL.events.splice(index, 1);
      retrievedEventCount++;
     }
    } else {
     index++;
    }
   }
   return retrievedEventCount;
  }
 default:
  throw "SDL_PeepEvents does not yet support that action: " + action;
 }
}
Module["_SDL_PeepEvents"] = _SDL_PeepEvents;
function _SDL_PumpEvents() {
 SDL.events.forEach((function(event) {
  SDL.handleEvent(event);
 }));
}
Module["_SDL_PumpEvents"] = _SDL_PumpEvents;
function _emscripten_SDL_SetEventHandler(handler, userdata) {
 SDL.eventHandler = handler;
 SDL.eventHandlerContext = userdata;
 if (!SDL.eventHandlerTemp) SDL.eventHandlerTemp = _malloc(28);
}
Module["_emscripten_SDL_SetEventHandler"] = _emscripten_SDL_SetEventHandler;
function _SDL_SetColors(surf, colors, firstColor, nColors) {
 var surfData = SDL.surfaces[surf];
 if (!surfData.colors) {
  var buffer = new ArrayBuffer(256 * 4);
  surfData.colors = new Uint8Array(buffer);
  surfData.colors32 = new Uint32Array(buffer);
 }
 for (var i = 0; i < nColors; ++i) {
  var index = (firstColor + i) * 4;
  surfData.colors[index] = HEAPU8[colors + i * 4 >> 0];
  surfData.colors[index + 1] = HEAPU8[colors + (i * 4 + 1) >> 0];
  surfData.colors[index + 2] = HEAPU8[colors + (i * 4 + 2) >> 0];
  surfData.colors[index + 3] = 255;
 }
 return 1;
}
Module["_SDL_SetColors"] = _SDL_SetColors;
function _SDL_SetPalette(surf, flags, colors, firstColor, nColors) {
 return _SDL_SetColors(surf, colors, firstColor, nColors);
}
Module["_SDL_SetPalette"] = _SDL_SetPalette;
function _SDL_MapRGB(fmt, r, g, b) {
 SDL.checkPixelFormat(fmt);
 return r & 255 | (g & 255) << 8 | (b & 255) << 16 | 4278190080;
}
Module["_SDL_MapRGB"] = _SDL_MapRGB;
function _SDL_MapRGBA(fmt, r, g, b, a) {
 SDL.checkPixelFormat(fmt);
 return r & 255 | (g & 255) << 8 | (b & 255) << 16 | (a & 255) << 24;
}
Module["_SDL_MapRGBA"] = _SDL_MapRGBA;
function _SDL_GetRGB(pixel, fmt, r, g, b) {
 SDL.checkPixelFormat(fmt);
 if (r) {
  HEAP8[r >> 0] = pixel & 255;
 }
 if (g) {
  HEAP8[g >> 0] = pixel >> 8 & 255;
 }
 if (b) {
  HEAP8[b >> 0] = pixel >> 16 & 255;
 }
}
Module["_SDL_GetRGB"] = _SDL_GetRGB;
function _SDL_GetRGBA(pixel, fmt, r, g, b, a) {
 SDL.checkPixelFormat(fmt);
 if (r) {
  HEAP8[r >> 0] = pixel & 255;
 }
 if (g) {
  HEAP8[g >> 0] = pixel >> 8 & 255;
 }
 if (b) {
  HEAP8[b >> 0] = pixel >> 16 & 255;
 }
 if (a) {
  HEAP8[a >> 0] = pixel >> 24 & 255;
 }
}
Module["_SDL_GetRGBA"] = _SDL_GetRGBA;
function _SDL_GetAppState() {
 var state = 0;
 if (Browser.pointerLock) {
  state |= 1;
 }
 if (document.hasFocus()) {
  state |= 2;
 }
 state |= 4;
 return state;
}
Module["_SDL_GetAppState"] = _SDL_GetAppState;
function _SDL_WM_GrabInput() {}
Module["_SDL_WM_GrabInput"] = _SDL_WM_GrabInput;
function _SDL_WM_ToggleFullScreen(surf) {
 if (Browser.isFullscreen) {
  Module["canvas"].exitFullscreen();
  return 1;
 } else {
  if (!SDL.canRequestFullscreen) {
   return 0;
  }
  SDL.isRequestingFullscreen = true;
  return 1;
 }
}
Module["_SDL_WM_ToggleFullScreen"] = _SDL_WM_ToggleFullScreen;
function _IMG_Init(flags) {
 return flags;
}
Module["_IMG_Init"] = _IMG_Init;
function _SDL_LoadBMP() {
 return _IMG_Load.apply(null, arguments);
}
Module["_SDL_LoadBMP"] = _SDL_LoadBMP;
function _SDL_LoadBMP_RW() {
 return _IMG_Load_RW.apply(null, arguments);
}
Module["_SDL_LoadBMP_RW"] = _SDL_LoadBMP_RW;
function _IMG_Quit() {
 Module.print("IMG_Quit called (and ignored)");
}
Module["_IMG_Quit"] = _IMG_Quit;
function _SDL_OpenAudio(desired, obtained) {
 try {
  SDL.audio = {
   freq: HEAPU32[desired >> 2],
   format: HEAPU16[desired + 4 >> 1],
   channels: HEAPU8[desired + 6 >> 0],
   samples: HEAPU16[desired + 8 >> 1],
   callback: HEAPU32[desired + 16 >> 2],
   userdata: HEAPU32[desired + 20 >> 2],
   paused: true,
   timer: null
  };
  if (SDL.audio.format == 8) {
   SDL.audio.silence = 128;
  } else if (SDL.audio.format == 32784) {
   SDL.audio.silence = 0;
  } else {
   throw "Invalid SDL audio format " + SDL.audio.format + "!";
  }
  if (SDL.audio.freq <= 0) {
   throw "Unsupported sound frequency " + SDL.audio.freq + "!";
  } else if (SDL.audio.freq <= 22050) {
   SDL.audio.freq = 22050;
  } else if (SDL.audio.freq <= 32e3) {
   SDL.audio.freq = 32e3;
  } else if (SDL.audio.freq <= 44100) {
   SDL.audio.freq = 44100;
  } else if (SDL.audio.freq <= 48e3) {
   SDL.audio.freq = 48e3;
  } else if (SDL.audio.freq <= 96e3) {
   SDL.audio.freq = 96e3;
  } else {
   throw "Unsupported sound frequency " + SDL.audio.freq + "!";
  }
  if (SDL.audio.channels == 0) {
   SDL.audio.channels = 1;
  } else if (SDL.audio.channels < 0 || SDL.audio.channels > 32) {
   throw "Unsupported number of audio channels for SDL audio: " + SDL.audio.channels + "!";
  } else if (SDL.audio.channels != 1 && SDL.audio.channels != 2) {
   console.log("Warning: Using untested number of audio channels " + SDL.audio.channels);
  }
  if (SDL.audio.samples < 128 || SDL.audio.samples > 524288) {
   throw "Unsupported audio callback buffer size " + SDL.audio.samples + "!";
  } else if ((SDL.audio.samples & SDL.audio.samples - 1) != 0) {
   throw "Audio callback buffer size " + SDL.audio.samples + " must be a power-of-two!";
  }
  var totalSamples = SDL.audio.samples * SDL.audio.channels;
  SDL.audio.bytesPerSample = SDL.audio.format == 8 || SDL.audio.format == 32776 ? 1 : 2;
  SDL.audio.bufferSize = totalSamples * SDL.audio.bytesPerSample;
  SDL.audio.bufferDurationSecs = SDL.audio.bufferSize / SDL.audio.bytesPerSample / SDL.audio.channels / SDL.audio.freq;
  SDL.audio.bufferingDelay = 50 / 1e3;
  SDL.audio.buffer = _malloc(SDL.audio.bufferSize);
  SDL.audio.numSimultaneouslyQueuedBuffers = Module["SDL_numSimultaneouslyQueuedBuffers"] || 5;
  SDL.audio.queueNewAudioData = function SDL_queueNewAudioData() {
   if (!SDL.audio) return;
   for (var i = 0; i < SDL.audio.numSimultaneouslyQueuedBuffers; ++i) {
    var secsUntilNextPlayStart = SDL.audio.nextPlayTime - SDL.audioContext["currentTime"];
    if (secsUntilNextPlayStart >= SDL.audio.bufferingDelay + SDL.audio.bufferDurationSecs * SDL.audio.numSimultaneouslyQueuedBuffers) return;
    Runtime.dynCall("viii", SDL.audio.callback, [ SDL.audio.userdata, SDL.audio.buffer, SDL.audio.bufferSize ]);
    SDL.audio.pushAudio(SDL.audio.buffer, SDL.audio.bufferSize);
   }
  };
  SDL.audio.caller = function SDL_audioCaller() {
   if (!SDL.audio) return;
   --SDL.audio.numAudioTimersPending;
   SDL.audio.queueNewAudioData();
   var secsUntilNextPlayStart = SDL.audio.nextPlayTime - SDL.audioContext["currentTime"];
   var preemptBufferFeedSecs = SDL.audio.bufferDurationSecs / 2;
   if (SDL.audio.numAudioTimersPending < SDL.audio.numSimultaneouslyQueuedBuffers) {
    ++SDL.audio.numAudioTimersPending;
    SDL.audio.timer = Browser.safeSetTimeout(SDL.audio.caller, Math.max(0, 1e3 * (secsUntilNextPlayStart - preemptBufferFeedSecs)));
    if (SDL.audio.numAudioTimersPending < SDL.audio.numSimultaneouslyQueuedBuffers) {
     ++SDL.audio.numAudioTimersPending;
     Browser.safeSetTimeout(SDL.audio.caller, 1);
    }
   }
  };
  SDL.audio.audioOutput = new Audio;
  SDL.openAudioContext();
  if (!SDL.audioContext) throw "Web Audio API is not available!";
  SDL.audio.nextPlayTime = 0;
  SDL.audio.pushAudio = (function(ptr, sizeBytes) {
   try {
    if (SDL.audio.paused) return;
    var sizeSamples = sizeBytes / SDL.audio.bytesPerSample;
    var sizeSamplesPerChannel = sizeSamples / SDL.audio.channels;
    if (sizeSamplesPerChannel != SDL.audio.samples) {
     throw "Received mismatching audio buffer size!";
    }
    var source = SDL.audioContext["createBufferSource"]();
    var soundBuffer = SDL.audioContext["createBuffer"](SDL.audio.channels, sizeSamplesPerChannel, SDL.audio.freq);
    source["connect"](SDL.audioContext["destination"]);
    SDL.fillWebAudioBufferFromHeap(ptr, sizeSamplesPerChannel, soundBuffer);
    source["buffer"] = soundBuffer;
    var curtime = SDL.audioContext["currentTime"];
    if (curtime > SDL.audio.nextPlayTime && SDL.audio.nextPlayTime != 0) {
     console.log("warning: Audio callback had starved sending audio by " + (curtime - SDL.audio.nextPlayTime) + " seconds.");
    }
    var playtime = Math.max(curtime + SDL.audio.bufferingDelay, SDL.audio.nextPlayTime);
    if (typeof source["start"] !== "undefined") {
     source["start"](playtime);
    } else if (typeof source["noteOn"] !== "undefined") {
     source["noteOn"](playtime);
    }
    SDL.audio.nextPlayTime = playtime + SDL.audio.bufferDurationSecs;
   } catch (e) {
    console.log("Web Audio API error playing back audio: " + e.toString());
   }
  });
  if (obtained) {
   HEAP32[obtained >> 2] = SDL.audio.freq;
   HEAP16[obtained + 4 >> 1] = SDL.audio.format;
   HEAP8[obtained + 6 >> 0] = SDL.audio.channels;
   HEAP8[obtained + 7 >> 0] = SDL.audio.silence;
   HEAP16[obtained + 8 >> 1] = SDL.audio.samples;
   HEAP32[obtained + 16 >> 2] = SDL.audio.callback;
   HEAP32[obtained + 20 >> 2] = SDL.audio.userdata;
  }
  SDL.allocateChannels(32);
 } catch (e) {
  console.log('Initializing SDL audio threw an exception: "' + e.toString() + '"! Continuing without audio.');
  SDL.audio = null;
  SDL.allocateChannels(0);
  if (obtained) {
   HEAP32[obtained >> 2] = 0;
   HEAP16[obtained + 4 >> 1] = 0;
   HEAP8[obtained + 6 >> 0] = 0;
   HEAP8[obtained + 7 >> 0] = 0;
   HEAP16[obtained + 8 >> 1] = 0;
   HEAP32[obtained + 16 >> 2] = 0;
   HEAP32[obtained + 20 >> 2] = 0;
  }
 }
 if (!SDL.audio) {
  return -1;
 }
 return 0;
}
Module["_SDL_OpenAudio"] = _SDL_OpenAudio;
function _SDL_LockAudio() {}
Module["_SDL_LockAudio"] = _SDL_LockAudio;
function _SDL_UnlockAudio() {}
Module["_SDL_UnlockAudio"] = _SDL_UnlockAudio;
function _SDL_CreateMutex() {
 return 0;
}
Module["_SDL_CreateMutex"] = _SDL_CreateMutex;
function _SDL_LockMutex() {}
Module["_SDL_LockMutex"] = _SDL_LockMutex;
function _SDL_UnlockMutex() {}
Module["_SDL_UnlockMutex"] = _SDL_UnlockMutex;
function _SDL_mutexP() {
 return 0;
}
Module["_SDL_mutexP"] = _SDL_mutexP;
function _SDL_mutexV() {
 return 0;
}
Module["_SDL_mutexV"] = _SDL_mutexV;
function _SDL_DestroyMutex() {}
Module["_SDL_DestroyMutex"] = _SDL_DestroyMutex;
function _SDL_CreateCond() {
 return 0;
}
Module["_SDL_CreateCond"] = _SDL_CreateCond;
function _SDL_CondSignal() {}
Module["_SDL_CondSignal"] = _SDL_CondSignal;
function _SDL_CondWait() {}
Module["_SDL_CondWait"] = _SDL_CondWait;
function _SDL_DestroyCond() {}
Module["_SDL_DestroyCond"] = _SDL_DestroyCond;
function _SDL_StartTextInput() {
 SDL.textInput = true;
}
Module["_SDL_StartTextInput"] = _SDL_StartTextInput;
function _SDL_StopTextInput() {
 SDL.textInput = false;
}
Module["_SDL_StopTextInput"] = _SDL_StopTextInput;
function _Mix_Init(flags) {
 if (!flags) return 0;
 return 8;
}
Module["_Mix_Init"] = _Mix_Init;
function _Mix_Quit() {}
Module["_Mix_Quit"] = _Mix_Quit;
function _Mix_OpenAudio(frequency, format, channels, chunksize) {
 SDL.openAudioContext();
 SDL.allocateChannels(32);
 SDL.mixerFrequency = frequency;
 SDL.mixerFormat = format;
 SDL.mixerNumChannels = channels;
 SDL.mixerChunkSize = chunksize;
 return 0;
}
Module["_Mix_OpenAudio"] = _Mix_OpenAudio;
function _Mix_CloseAudio() {
 return _SDL_CloseAudio.apply(null, arguments);
}
Module["_Mix_CloseAudio"] = _Mix_CloseAudio;
function _Mix_AllocateChannels(num) {
 SDL.allocateChannels(num);
 return num;
}
Module["_Mix_AllocateChannels"] = _Mix_AllocateChannels;
function _Mix_ChannelFinished(func) {
 SDL.channelFinished = func;
}
Module["_Mix_ChannelFinished"] = _Mix_ChannelFinished;
function _Mix_Volume(channel, volume) {
 if (channel == -1) {
  for (var i = 0; i < SDL.numChannels - 1; i++) {
   _Mix_Volume(i, volume);
  }
  return _Mix_Volume(SDL.numChannels - 1, volume);
 }
 return SDL.setGetVolume(SDL.channels[channel], volume);
}
Module["_Mix_Volume"] = _Mix_Volume;
function _Mix_SetPanning(channel, left, right) {
 left /= 255;
 right /= 255;
 SDL.setPannerPosition(SDL.channels[channel], right - left, 0, .1);
 return 1;
}
Module["_Mix_SetPanning"] = _Mix_SetPanning;
function _Mix_LoadWAV(filename) {
 var rwops = _SDL_RWFromFile(filename);
 var result = _Mix_LoadWAV_RW(rwops);
 _SDL_FreeRW(rwops);
 return result;
}
Module["_Mix_LoadWAV"] = _Mix_LoadWAV;
function _Mix_QuickLoad_RAW(mem, len) {
 var audio;
 var webAudio;
 var numSamples = len >> 1;
 var buffer = new Float32Array(numSamples);
 for (var i = 0; i < numSamples; ++i) {
  buffer[i] = HEAP16[mem + i * 2 >> 1] / 32768;
 }
 if (SDL.webAudioAvailable()) {
  webAudio = {};
  webAudio.decodedBuffer = buffer;
 } else {
  var audio = new Audio;
  audio.mozAudioChannelType = "content";
  audio.numChannels = SDL.mixerNumChannels;
  audio.frequency = SDL.mixerFrequency;
 }
 var id = SDL.audios.length;
 SDL.audios.push({
  source: "",
  audio: audio,
  webAudio: webAudio,
  buffer: buffer
 });
 return id;
}
Module["_Mix_QuickLoad_RAW"] = _Mix_QuickLoad_RAW;
function _Mix_ReserveChannels(num) {
 SDL.channelMinimumNumber = num;
}
Module["_Mix_ReserveChannels"] = _Mix_ReserveChannels;
function _Mix_PlayChannelTimed() {
 return _Mix_PlayChannel.apply(null, arguments);
}
Module["_Mix_PlayChannelTimed"] = _Mix_PlayChannelTimed;
function _Mix_FadingChannel(channel) {
 return 0;
}
Module["_Mix_FadingChannel"] = _Mix_FadingChannel;
function _Mix_HaltChannel(channel) {
 function halt(channel) {
  var info = SDL.channels[channel];
  if (info.audio) {
   info.audio.pause();
   info.audio = null;
  }
  if (SDL.channelFinished) {
   Runtime.getFuncWrapper(SDL.channelFinished, "vi")(channel);
  }
 }
 if (channel != -1) {
  halt(channel);
 } else {
  for (var i = 0; i < SDL.channels.length; ++i) halt(i);
 }
 return 0;
}
Module["_Mix_HaltChannel"] = _Mix_HaltChannel;
function _Mix_HookMusicFinished(func) {
 SDL.hookMusicFinished = func;
 if (SDL.music.audio) {
  SDL.music.audio["onended"] = _Mix_HaltMusic;
 }
}
Module["_Mix_HookMusicFinished"] = _Mix_HookMusicFinished;
function _Mix_VolumeMusic(volume) {
 return SDL.setGetVolume(SDL.music, volume);
}
Module["_Mix_VolumeMusic"] = _Mix_VolumeMusic;
function _Mix_LoadMUS_RW() {
 return _Mix_LoadWAV_RW.apply(null, arguments);
}
Module["_Mix_LoadMUS_RW"] = _Mix_LoadMUS_RW;
function _Mix_LoadMUS(filename) {
 var rwops = _SDL_RWFromFile(filename);
 var result = _Mix_LoadMUS_RW(rwops);
 _SDL_FreeRW(rwops);
 return result;
}
Module["_Mix_LoadMUS"] = _Mix_LoadMUS;
function _Mix_FreeMusic() {
 return _Mix_FreeChunk.apply(null, arguments);
}
Module["_Mix_FreeMusic"] = _Mix_FreeMusic;
function _Mix_PauseMusic() {
 var audio = SDL.music.audio;
 if (audio) audio.pause();
 return 0;
}
Module["_Mix_PauseMusic"] = _Mix_PauseMusic;
function _Mix_ResumeMusic() {
 var audio = SDL.music.audio;
 if (audio) audio.play();
 return 0;
}
Module["_Mix_ResumeMusic"] = _Mix_ResumeMusic;
function _Mix_FadeInMusicPos() {
 return _Mix_PlayMusic.apply(null, arguments);
}
Module["_Mix_FadeInMusicPos"] = _Mix_FadeInMusicPos;
function _Mix_FadeOutMusic() {
 return _Mix_HaltMusic.apply(null, arguments);
}
Module["_Mix_FadeOutMusic"] = _Mix_FadeOutMusic;
function _Mix_PlayingMusic() {
 return SDL.music.audio && !SDL.music.audio.paused ? 1 : 0;
}
Module["_Mix_PlayingMusic"] = _Mix_PlayingMusic;
function _Mix_Playing(channel) {
 if (channel === -1) {
  var count = 0;
  for (var i = 0; i < SDL.channels.length; i++) {
   count += _Mix_Playing(i);
  }
  return count;
 }
 var info = SDL.channels[channel];
 if (info && info.audio && !info.audio.paused) {
  return 1;
 }
 return 0;
}
Module["_Mix_Playing"] = _Mix_Playing;
function _Mix_Pause(channel) {
 if (channel === -1) {
  for (var i = 0; i < SDL.channels.length; i++) {
   _Mix_Pause(i);
  }
  return;
 }
 var info = SDL.channels[channel];
 if (info && info.audio) {
  info.audio.pause();
 } else {}
}
Module["_Mix_Pause"] = _Mix_Pause;
function _Mix_Paused(channel) {
 if (channel === -1) {
  var pausedCount = 0;
  for (var i = 0; i < SDL.channels.length; i++) {
   pausedCount += _Mix_Paused(i);
  }
  return pausedCount;
 }
 var info = SDL.channels[channel];
 if (info && info.audio && info.audio.paused) {
  return 1;
 }
 return 0;
}
Module["_Mix_Paused"] = _Mix_Paused;
function _Mix_PausedMusic() {
 return SDL.music.audio && SDL.music.audio.paused ? 1 : 0;
}
Module["_Mix_PausedMusic"] = _Mix_PausedMusic;
function _Mix_Resume(channel) {
 if (channel === -1) {
  for (var i = 0; i < SDL.channels.length; i++) {
   _Mix_Resume(i);
  }
  return;
 }
 var info = SDL.channels[channel];
 if (info && info.audio) info.audio.play();
}
Module["_Mix_Resume"] = _Mix_Resume;
function _TTF_Init() {
 var canvas = document.createElement("canvas");
 SDL.ttfContext = canvas.getContext("2d");
 return 0;
}
Module["_TTF_Init"] = _TTF_Init;
function _TTF_OpenFont(filename, size) {
 filename = PATH.normalize(Pointer_stringify(filename));
 var id = SDL.fonts.length;
 SDL.fonts.push({
  name: filename,
  size: size
 });
 return id;
}
Module["_TTF_OpenFont"] = _TTF_OpenFont;
function _TTF_CloseFont(font) {
 SDL.fonts[font] = null;
}
Module["_TTF_CloseFont"] = _TTF_CloseFont;
function _TTF_RenderText_Blended() {
 return _TTF_RenderText_Solid.apply(null, arguments);
}
Module["_TTF_RenderText_Blended"] = _TTF_RenderText_Blended;
function _TTF_RenderText_Shaded() {
 return _TTF_RenderText_Solid.apply(null, arguments);
}
Module["_TTF_RenderText_Shaded"] = _TTF_RenderText_Shaded;
function _TTF_RenderUTF8_Solid() {
 return _TTF_RenderText_Solid.apply(null, arguments);
}
Module["_TTF_RenderUTF8_Solid"] = _TTF_RenderUTF8_Solid;
function _TTF_SizeUTF8() {
 return _TTF_SizeText.apply(null, arguments);
}
Module["_TTF_SizeUTF8"] = _TTF_SizeUTF8;
function _TTF_GlyphMetrics(font, ch, minx, maxx, miny, maxy, advance) {
 var fontData = SDL.fonts[font];
 var width = SDL.estimateTextWidth(fontData, String.fromCharCode(ch));
 if (advance) {
  HEAP32[advance >> 2] = width;
 }
 if (minx) {
  HEAP32[minx >> 2] = 0;
 }
 if (maxx) {
  HEAP32[maxx >> 2] = width;
 }
 if (miny) {
  HEAP32[miny >> 2] = 0;
 }
 if (maxy) {
  HEAP32[maxy >> 2] = fontData.size;
 }
}
Module["_TTF_GlyphMetrics"] = _TTF_GlyphMetrics;
function _TTF_FontAscent(font) {
 var fontData = SDL.fonts[font];
 return fontData.size * .98 | 0;
}
Module["_TTF_FontAscent"] = _TTF_FontAscent;
function _TTF_FontDescent(font) {
 var fontData = SDL.fonts[font];
 return fontData.size * .02 | 0;
}
Module["_TTF_FontDescent"] = _TTF_FontDescent;
function _TTF_FontLineSkip() {
 return _TTF_FontHeight.apply(null, arguments);
}
Module["_TTF_FontLineSkip"] = _TTF_FontLineSkip;
function _TTF_Quit() {
 Module.print("TTF_Quit called (and ignored)");
}
Module["_TTF_Quit"] = _TTF_Quit;
var SDL_gfx = {
 drawRectangle: (function(surf, x1, y1, x2, y2, action, cssColor) {
  x1 = x1 << 16 >> 16;
  y1 = y1 << 16 >> 16;
  x2 = x2 << 16 >> 16;
  y2 = y2 << 16 >> 16;
  var surfData = SDL.surfaces[surf];
  assert(!surfData.locked);
  var x = x1 < x2 ? x1 : x2;
  var y = y1 < y2 ? y1 : y2;
  var w = Math.abs(x2 - x1);
  var h = Math.abs(y2 - y1);
  surfData.ctx.save();
  surfData.ctx[action + "Style"] = cssColor;
  surfData.ctx[action + "Rect"](x, y, w, h);
  surfData.ctx.restore();
 }),
 drawLine: (function(surf, x1, y1, x2, y2, cssColor) {
  x1 = x1 << 16 >> 16;
  y1 = y1 << 16 >> 16;
  x2 = x2 << 16 >> 16;
  y2 = y2 << 16 >> 16;
  var surfData = SDL.surfaces[surf];
  assert(!surfData.locked);
  surfData.ctx.save();
  surfData.ctx.strokeStyle = cssColor;
  surfData.ctx.beginPath();
  surfData.ctx.moveTo(x1, y1);
  surfData.ctx.lineTo(x2, y2);
  surfData.ctx.stroke();
  surfData.ctx.restore();
 }),
 drawEllipse: (function(surf, x, y, rx, ry, action, cssColor) {
  x = x << 16 >> 16;
  y = y << 16 >> 16;
  rx = rx << 16 >> 16;
  ry = ry << 16 >> 16;
  var surfData = SDL.surfaces[surf];
  assert(!surfData.locked);
  surfData.ctx.save();
  surfData.ctx.beginPath();
  surfData.ctx.translate(x, y);
  surfData.ctx.scale(rx, ry);
  surfData.ctx.arc(0, 0, 1, 0, 2 * Math.PI);
  surfData.ctx.restore();
  surfData.ctx.save();
  surfData.ctx[action + "Style"] = cssColor;
  surfData.ctx[action]();
  surfData.ctx.restore();
 }),
 translateColorToCSSRGBA: (function(rgba) {
  return "rgba(" + (rgba >>> 24) + "," + (rgba >> 16 & 255) + "," + (rgba >> 8 & 255) + "," + (rgba & 255) + ")";
 })
};
Module["SDL_gfx"] = SDL_gfx;
function _boxColor(surf, x1, y1, x2, y2, color) {
 return SDL_gfx.drawRectangle(surf, x1, y1, x2, y2, "fill", SDL_gfx.translateColorToCSSRGBA(color));
}
Module["_boxColor"] = _boxColor;
function _boxRGBA(surf, x1, y1, x2, y2, r, g, b, a) {
 return SDL_gfx.drawRectangle(surf, x1, y1, x2, y2, "fill", SDL.translateRGBAToCSSRGBA(r, g, b, a));
}
Module["_boxRGBA"] = _boxRGBA;
function _rectangleColor(surf, x1, y1, x2, y2, color) {
 return SDL_gfx.drawRectangle(surf, x1, y1, x2, y2, "stroke", SDL_gfx.translateColorToCSSRGBA(color));
}
Module["_rectangleColor"] = _rectangleColor;
function _rectangleRGBA(surf, x1, y1, x2, y2, r, g, b, a) {
 return SDL_gfx.drawRectangle(surf, x1, y1, x2, y2, "stroke", SDL.translateRGBAToCSSRGBA(r, g, b, a));
}
Module["_rectangleRGBA"] = _rectangleRGBA;
function _ellipseColor(surf, x, y, rx, ry, color) {
 return SDL_gfx.drawEllipse(surf, x, y, rx, ry, "stroke", SDL_gfx.translateColorToCSSRGBA(color));
}
Module["_ellipseColor"] = _ellipseColor;
function _ellipseRGBA(surf, x, y, rx, ry, r, g, b, a) {
 return SDL_gfx.drawEllipse(surf, x, y, rx, ry, "stroke", SDL.translateRGBAToCSSRGBA(r, g, b, a));
}
Module["_ellipseRGBA"] = _ellipseRGBA;
function _filledEllipseColor(surf, x, y, rx, ry, color) {
 return SDL_gfx.drawEllipse(surf, x, y, rx, ry, "fill", SDL_gfx.translateColorToCSSRGBA(color));
}
Module["_filledEllipseColor"] = _filledEllipseColor;
function _filledEllipseRGBA(surf, x, y, rx, ry, r, g, b, a) {
 return SDL_gfx.drawEllipse(surf, x, y, rx, ry, "fill", SDL.translateRGBAToCSSRGBA(r, g, b, a));
}
Module["_filledEllipseRGBA"] = _filledEllipseRGBA;
function _lineColor(surf, x1, y1, x2, y2, color) {
 return SDL_gfx.drawLine(surf, x1, y1, x2, y2, SDL_gfx.translateColorToCSSRGBA(color));
}
Module["_lineColor"] = _lineColor;
function _lineRGBA(surf, x1, y1, x2, y2, r, g, b, a) {
 return SDL_gfx.drawLine(surf, x1, y1, x2, y2, SDL.translateRGBAToCSSRGBA(r, g, b, a));
}
Module["_lineRGBA"] = _lineRGBA;
function _pixelRGBA(surf, x1, y1, r, g, b, a) {
 _boxRGBA(surf, x1, y1, x1, y1, r, g, b, a);
}
Module["_pixelRGBA"] = _pixelRGBA;
function _SDL_GL_SetAttribute(attr, value) {
 if (!(attr in SDL.glAttributes)) {
  abort("Unknown SDL GL attribute (" + attr + "). Please check if your SDL version is supported.");
 }
 SDL.glAttributes[attr] = value;
}
Module["_SDL_GL_SetAttribute"] = _SDL_GL_SetAttribute;
function _SDL_GL_GetAttribute(attr, value) {
 if (!(attr in SDL.glAttributes)) {
  abort("Unknown SDL GL attribute (" + attr + "). Please check if your SDL version is supported.");
 }
 if (value) HEAP32[value >> 2] = SDL.glAttributes[attr];
 return 0;
}
Module["_SDL_GL_GetAttribute"] = _SDL_GL_GetAttribute;
var _emscripten_GetProcAddress = undefined;
function _SDL_GL_GetProcAddress(name_) {
 return _emscripten_GetProcAddress(name_);
}
Module["_SDL_GL_GetProcAddress"] = _SDL_GL_GetProcAddress;
function _SDL_GL_ExtensionSupported(extension) {
 return Module.ctx.getExtension(extension) | 0;
}
Module["_SDL_GL_ExtensionSupported"] = _SDL_GL_ExtensionSupported;
function _SDL_DestroyWindow(window) {}
Module["_SDL_DestroyWindow"] = _SDL_DestroyWindow;
function _SDL_DestroyRenderer(renderer) {}
Module["_SDL_DestroyRenderer"] = _SDL_DestroyRenderer;
function _SDL_GetWindowFlags() {}
Module["_SDL_GetWindowFlags"] = _SDL_GetWindowFlags;
function _SDL_GL_SwapWindow(window) {}
Module["_SDL_GL_SwapWindow"] = _SDL_GL_SwapWindow;
function _SDL_GL_MakeCurrent(window, context) {}
Module["_SDL_GL_MakeCurrent"] = _SDL_GL_MakeCurrent;
function _SDL_GL_DeleteContext(context) {}
Module["_SDL_GL_DeleteContext"] = _SDL_GL_DeleteContext;
function _SDL_GL_GetSwapInterval(state) {
 if (Browser.mainLoop.timingMode == 1) return Browser.mainLoop.timingValue; else return 0;
}
Module["_SDL_GL_GetSwapInterval"] = _SDL_GL_GetSwapInterval;
function _SDL_GL_SetSwapInterval(state) {
 _emscripten_set_main_loop_timing(1, state);
}
Module["_SDL_GL_SetSwapInterval"] = _SDL_GL_SetSwapInterval;
function _SDL_SetWindowTitle(window, title) {
 if (title) document.title = Pointer_stringify(title);
}
Module["_SDL_SetWindowTitle"] = _SDL_SetWindowTitle;
function _SDL_GetWindowSize(window, width, height) {
 var w = Module["canvas"].width;
 var h = Module["canvas"].height;
 if (width) HEAP32[width >> 2] = w;
 if (height) HEAP32[height >> 2] = h;
}
Module["_SDL_GetWindowSize"] = _SDL_GetWindowSize;
function _SDL_LogSetOutputFunction(callback, userdata) {}
Module["_SDL_LogSetOutputFunction"] = _SDL_LogSetOutputFunction;
function _SDL_SetWindowFullscreen(window, fullscreen) {
 if (Browser.isFullscreen) {
  Module["canvas"].exitFullscreen();
  return 1;
 } else {
  return 0;
 }
}
Module["_SDL_SetWindowFullscreen"] = _SDL_SetWindowFullscreen;
function _SDL_ClearError() {}
Module["_SDL_ClearError"] = _SDL_ClearError;
function _SDL_getenv() {
 return _getenv.apply(null, arguments);
}
Module["_SDL_getenv"] = _SDL_getenv;
function _SDL_putenv() {
 return _putenv.apply(null, arguments);
}
Module["_SDL_putenv"] = _SDL_putenv;
function _SDL_SetGamma(r, g, b) {
 return -1;
}
Module["_SDL_SetGamma"] = _SDL_SetGamma;
function _SDL_SetGammaRamp(redTable, greenTable, blueTable) {
 return -1;
}
Module["_SDL_SetGammaRamp"] = _SDL_SetGammaRamp;
function _SDL_NumJoysticks() {
 var count = 0;
 var gamepads = SDL.getGamepads();
 for (var i = 0; i < gamepads.length; i++) {
  if (gamepads[i] !== undefined) count++;
 }
 return count;
}
Module["_SDL_NumJoysticks"] = _SDL_NumJoysticks;
function _SDL_JoystickName(deviceIndex) {
 var gamepad = SDL.getGamepad(deviceIndex);
 if (gamepad) {
  var name = gamepad.id;
  if (SDL.joystickNamePool.hasOwnProperty(name)) {
   return SDL.joystickNamePool[name];
  }
  return SDL.joystickNamePool[name] = allocate(intArrayFromString(name), "i8", ALLOC_NORMAL);
 }
 return 0;
}
Module["_SDL_JoystickName"] = _SDL_JoystickName;
function _SDL_JoystickOpen(deviceIndex) {
 var gamepad = SDL.getGamepad(deviceIndex);
 if (gamepad) {
  var joystick = deviceIndex + 1;
  SDL.recordJoystickState(joystick, gamepad);
  return joystick;
 }
 return 0;
}
Module["_SDL_JoystickOpen"] = _SDL_JoystickOpen;
function _SDL_JoystickOpened(deviceIndex) {
 return SDL.lastJoystickState.hasOwnProperty(deviceIndex + 1) ? 1 : 0;
}
Module["_SDL_JoystickOpened"] = _SDL_JoystickOpened;
function _SDL_JoystickIndex(joystick) {
 return joystick - 1;
}
Module["_SDL_JoystickIndex"] = _SDL_JoystickIndex;
function _SDL_JoystickNumAxes(joystick) {
 var gamepad = SDL.getGamepad(joystick - 1);
 if (gamepad) {
  return gamepad.axes.length;
 }
 return 0;
}
Module["_SDL_JoystickNumAxes"] = _SDL_JoystickNumAxes;
function _SDL_JoystickNumBalls(joystick) {
 return 0;
}
Module["_SDL_JoystickNumBalls"] = _SDL_JoystickNumBalls;
function _SDL_JoystickNumHats(joystick) {
 return 0;
}
Module["_SDL_JoystickNumHats"] = _SDL_JoystickNumHats;
function _SDL_JoystickNumButtons(joystick) {
 var gamepad = SDL.getGamepad(joystick - 1);
 if (gamepad) {
  return gamepad.buttons.length;
 }
 return 0;
}
Module["_SDL_JoystickNumButtons"] = _SDL_JoystickNumButtons;
function _SDL_JoystickUpdate() {
 SDL.queryJoysticks();
}
Module["_SDL_JoystickUpdate"] = _SDL_JoystickUpdate;
function _SDL_JoystickEventState(state) {
 if (state < 0) {
  return SDL.joystickEventState;
 }
 return SDL.joystickEventState = state;
}
Module["_SDL_JoystickEventState"] = _SDL_JoystickEventState;
function _SDL_JoystickGetAxis(joystick, axis) {
 var gamepad = SDL.getGamepad(joystick - 1);
 if (gamepad && gamepad.axes.length > axis) {
  return SDL.joystickAxisValueConversion(gamepad.axes[axis]);
 }
 return 0;
}
Module["_SDL_JoystickGetAxis"] = _SDL_JoystickGetAxis;
function _SDL_JoystickGetHat(joystick, hat) {
 return 0;
}
Module["_SDL_JoystickGetHat"] = _SDL_JoystickGetHat;
function _SDL_JoystickGetBall(joystick, ball, dxptr, dyptr) {
 return -1;
}
Module["_SDL_JoystickGetBall"] = _SDL_JoystickGetBall;
function _SDL_JoystickGetButton(joystick, button) {
 var gamepad = SDL.getGamepad(joystick - 1);
 if (gamepad && gamepad.buttons.length > button) {
  return SDL.getJoystickButtonState(gamepad.buttons[button]) ? 1 : 0;
 }
 return 0;
}
Module["_SDL_JoystickGetButton"] = _SDL_JoystickGetButton;
function _SDL_JoystickClose(joystick) {
 delete SDL.lastJoystickState[joystick];
}
Module["_SDL_JoystickClose"] = _SDL_JoystickClose;
function _SDL_InitSubSystem(flags) {
 return 0;
}
Module["_SDL_InitSubSystem"] = _SDL_InitSubSystem;
function _SDL_RWFromMem() {
 return _SDL_RWFromConstMem.apply(null, arguments);
}
Module["_SDL_RWFromMem"] = _SDL_RWFromMem;
function _SDL_GetNumAudioDrivers() {
 return 1;
}
Module["_SDL_GetNumAudioDrivers"] = _SDL_GetNumAudioDrivers;
function _SDL_GetCurrentAudioDriver() {
 return allocate(intArrayFromString("Emscripten Audio"), "i8", ALLOC_NORMAL);
}
Module["_SDL_GetCurrentAudioDriver"] = _SDL_GetCurrentAudioDriver;
function _SDL_GetAudioDriver(index) {
 return _SDL_GetCurrentAudioDriver();
}
Module["_SDL_GetAudioDriver"] = _SDL_GetAudioDriver;
function _SDL_EnableUNICODE(on) {
 var ret = SDL.unicode || 0;
 SDL.unicode = on;
 return ret;
}
Module["_SDL_EnableUNICODE"] = _SDL_EnableUNICODE;
function _SDL_AddTimer(interval, callback, param) {
 return window.setTimeout((function() {
  Runtime.dynCall("iii", callback, [ interval, param ]);
 }), interval);
}
Module["_SDL_AddTimer"] = _SDL_AddTimer;
function _SDL_RemoveTimer(id) {
 window.clearTimeout(id);
 return true;
}
Module["_SDL_RemoveTimer"] = _SDL_RemoveTimer;
function _SDL_CreateThread() {
 throw "SDL threads cannot be supported in the web platform because they assume shared state. See emscripten_create_worker etc. for a message-passing concurrency model that does let you run code in another thread.";
}
Module["_SDL_CreateThread"] = _SDL_CreateThread;
function _SDL_WaitThread() {
 throw "SDL_WaitThread";
}
Module["_SDL_WaitThread"] = _SDL_WaitThread;
function _SDL_GetThreadID() {
 throw "SDL_GetThreadID";
}
Module["_SDL_GetThreadID"] = _SDL_GetThreadID;
function _SDL_ThreadID() {
 return 0;
}
Module["_SDL_ThreadID"] = _SDL_ThreadID;
function _SDL_AllocRW() {
 throw "SDL_AllocRW: TODO";
}
Module["_SDL_AllocRW"] = _SDL_AllocRW;
function _SDL_CondBroadcast() {
 throw "SDL_CondBroadcast: TODO";
}
Module["_SDL_CondBroadcast"] = _SDL_CondBroadcast;
function _SDL_CondWaitTimeout() {
 throw "SDL_CondWaitTimeout: TODO";
}
Module["_SDL_CondWaitTimeout"] = _SDL_CondWaitTimeout;
function _SDL_WM_IconifyWindow() {
 throw "SDL_WM_IconifyWindow TODO";
}
Module["_SDL_WM_IconifyWindow"] = _SDL_WM_IconifyWindow;
function _Mix_SetPostMix() {
 Runtime.warnOnce("Mix_SetPostMix: TODO");
}
Module["_Mix_SetPostMix"] = _Mix_SetPostMix;
function _Mix_VolumeChunk(chunk, volume) {
 throw "Mix_VolumeChunk: TODO";
}
Module["_Mix_VolumeChunk"] = _Mix_VolumeChunk;
function _Mix_SetPosition(channel, angle, distance) {
 throw "Mix_SetPosition: TODO";
}
Module["_Mix_SetPosition"] = _Mix_SetPosition;
function _Mix_QuerySpec() {
 throw "Mix_QuerySpec: TODO";
}
Module["_Mix_QuerySpec"] = _Mix_QuerySpec;
function _Mix_FadeInChannelTimed() {
 throw "Mix_FadeInChannelTimed";
}
Module["_Mix_FadeInChannelTimed"] = _Mix_FadeInChannelTimed;
function _Mix_FadeOutChannel() {
 throw "Mix_FadeOutChannel";
}
Module["_Mix_FadeOutChannel"] = _Mix_FadeOutChannel;
function _Mix_Linked_Version() {
 throw "Mix_Linked_Version: TODO";
}
Module["_Mix_Linked_Version"] = _Mix_Linked_Version;
function _SDL_SaveBMP_RW() {
 throw "SDL_SaveBMP_RW: TODO";
}
Module["_SDL_SaveBMP_RW"] = _SDL_SaveBMP_RW;
function _SDL_WM_SetIcon() {}
Module["_SDL_WM_SetIcon"] = _SDL_WM_SetIcon;
function _SDL_HasRDTSC() {
 return 0;
}
Module["_SDL_HasRDTSC"] = _SDL_HasRDTSC;
function _SDL_HasMMX() {
 return 0;
}
Module["_SDL_HasMMX"] = _SDL_HasMMX;
function _SDL_HasMMXExt() {
 return 0;
}
Module["_SDL_HasMMXExt"] = _SDL_HasMMXExt;
function _SDL_Has3DNow() {
 return 0;
}
Module["_SDL_Has3DNow"] = _SDL_Has3DNow;
function _SDL_Has3DNowExt() {
 return 0;
}
Module["_SDL_Has3DNowExt"] = _SDL_Has3DNowExt;
function _SDL_HasSSE() {
 return 0;
}
Module["_SDL_HasSSE"] = _SDL_HasSSE;
function _SDL_HasSSE2() {
 return 0;
}
Module["_SDL_HasSSE2"] = _SDL_HasSSE2;
function _SDL_HasAltiVec() {
 return 0;
}
Module["_SDL_HasAltiVec"] = _SDL_HasAltiVec;
function _glGetInteger64v(name_, p) {
 emscriptenWebGLGet(name_, p, "Integer64");
}
Module["_glGetInteger64v"] = _glGetInteger64v;
function _glGetFloatv(name_, p) {
 emscriptenWebGLGet(name_, p, "Float");
}
Module["_glGetFloatv"] = _glGetFloatv;
function _glGetBooleanv(name_, p) {
 emscriptenWebGLGet(name_, p, "Boolean");
}
Module["_glGetBooleanv"] = _glGetBooleanv;
function _glCompressedTexImage3D(target, level, internalFormat, width, height, depth, border, imageSize, data) {
 var heapView;
 if (data) {
  heapView = HEAPU8.subarray(data, data + imageSize);
 } else {
  heapView = null;
 }
 GLctx["compressedTexImage3D"](target, level, internalFormat, width, height, depth, border, heapView);
}
Module["_glCompressedTexImage3D"] = _glCompressedTexImage3D;
function _glGetTexParameterfv(target, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 HEAPF32[params >> 2] = GLctx.getTexParameter(target, pname);
}
Module["_glGetTexParameterfv"] = _glGetTexParameterfv;
function _glTexParameterfv(target, pname, params) {
 var param = HEAPF32[params >> 2];
 GLctx.texParameterf(target, pname, param);
}
Module["_glTexParameterfv"] = _glTexParameterfv;
function _glIsTexture(texture) {
 var texture = GL.textures[texture];
 if (!texture) return 0;
 return GLctx.isTexture(texture);
}
Module["_glIsTexture"] = _glIsTexture;
function _glGetBufferParameteriv(target, value, data) {
 if (!data) {
  GL.recordError(1281);
  return;
 }
 HEAP32[data >> 2] = GLctx.getBufferParameter(target, value);
}
Module["_glGetBufferParameteriv"] = _glGetBufferParameteriv;
function _glGetBufferParameteri64v(target, value, data) {
 if (!data) {
  GL.recordError(1281);
  return;
 }
 tempI64 = [ GLctx.getBufferParameter(target, value) >>> 0, (tempDouble = GLctx.getBufferParameter(target, value), +Math_abs(tempDouble) >= +1 ? tempDouble > +0 ? (Math_min(+Math_floor(tempDouble / +4294967296), +4294967295) | 0) >>> 0 : ~~+Math_ceil((tempDouble - +(~~tempDouble >>> 0)) / +4294967296) >>> 0 : 0) ], HEAP32[data >> 2] = tempI64[0], HEAP32[data + 4 >> 2] = tempI64[1];
}
Module["_glGetBufferParameteri64v"] = _glGetBufferParameteri64v;
function _glInvalidateSubFramebuffer(target, numAttachments, attachments, x, y, width, height) {
 var list = [];
 for (var i = 0; i < numAttachments; i++) list.push(HEAP32[attachments + i * 4 >> 2]);
 GLctx["invalidateSubFramebuffer"](target, list, x, y, width, height);
}
Module["_glInvalidateSubFramebuffer"] = _glInvalidateSubFramebuffer;
function _glIsQuery(id) {
 var query = GL.queries[query];
 if (!query) return 0;
 return GLctx["isQuery"](query);
}
Module["_glIsQuery"] = _glIsQuery;
function _glGetQueryiv(target, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 HEAP32[params >> 2] = GLctx["getQuery"](target, pname);
}
Module["_glGetQueryiv"] = _glGetQueryiv;
function _glGetQueryObjectuiv(id, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 var query = GL.queries[id];
 var param = GLctx["getQueryParameter"](query, pname);
 var ret;
 if (typeof param == "boolean") {
  ret = param ? 1 : 0;
 } else {
  ret = param;
 }
 HEAP32[params >> 2] = ret;
}
Module["_glGetQueryObjectuiv"] = _glGetQueryObjectuiv;
function _glIsSampler(id) {
 var sampler = GL.samplers[id];
 if (!sampler) return 0;
 return GLctx["isSampler"](sampler);
}
Module["_glIsSampler"] = _glIsSampler;
function _glSamplerParameterf(sampler, pname, param) {
 GLctx["samplerParameterf"](sampler ? GL.samplers[sampler] : null, pname, param);
}
Module["_glSamplerParameterf"] = _glSamplerParameterf;
function _glSamplerParameterfv(sampler, pname, params) {
 var param = HEAPF32[params >> 2];
 GLctx["samplerParameterf"](sampler ? GL.samplers[sampler] : null, pname, param);
}
Module["_glSamplerParameterfv"] = _glSamplerParameterfv;
function _glSamplerParameteriv(sampler, pname, params) {
 var param = HEAP32[params >> 2];
 GLctx["samplerParameteri"](sampler ? GL.samplers[sampler] : null, pname, param);
}
Module["_glSamplerParameteriv"] = _glSamplerParameteriv;
function _glGetSamplerParameterfv(sampler, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 sampler = GL.samplers[sampler];
 HEAPF32[params >> 2] = GLctx["getSamplerParameter"](sampler, pname);
}
Module["_glGetSamplerParameterfv"] = _glGetSamplerParameterfv;
function _glGetSamplerParameteriv(sampler, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 sampler = GL.samplers[sampler];
 HEAP32[params >> 2] = GLctx["getSamplerParameter"](sampler, pname);
}
Module["_glGetSamplerParameteriv"] = _glGetSamplerParameteriv;
function _glIsTransformFeedback(transformFeedback) {
 var transformFeedback = GL.transformFeedbacks[transformFeedback];
 if (!transformFeedback) return 0;
 return GLctx["isTransformFeedback"](transformFeedback);
}
Module["_glIsTransformFeedback"] = _glIsTransformFeedback;
function _glGetTransformFeedbackVarying(program, index, bufSize, length, size, type, name) {
 program = GL.programs[program];
 var info = GLctx["getTransformFeedbackVarying"](program, index);
 if (!info) return;
 var infoname = info.name.slice(0, Math.max(0, bufSize - 1));
 if (name && bufSize > 0) {
  writeStringToMemory(infoname, name);
  if (length) HEAP32[length >> 2] = infoname.length;
 } else {
  if (length) HEAP32[length >> 2] = 0;
 }
 if (size) HEAP32[size >> 2] = info.size;
 if (type) HEAP32[type >> 2] = info.type;
}
Module["_glGetTransformFeedbackVarying"] = _glGetTransformFeedbackVarying;
function _glGetInteger64i_v(target, index, data) {
 emscriptenWebGLGetIndexed(target, index, data, "Integer64");
}
Module["_glGetInteger64i_v"] = _glGetInteger64i_v;
function _glBindBufferRange(target, index, buffer, offset, ptrsize) {
 var bufferObj = buffer ? GL.buffers[buffer] : null;
 GLctx["bindBufferRange"](target, index, bufferObj, offset, ptrsize);
}
Module["_glBindBufferRange"] = _glBindBufferRange;
function _glGetUniformIndices(program, uniformCount, uniformNames, uniformIndices) {
 if (!uniformIndices) {
  GL.recordError(1281);
  return;
 }
 if (uniformCount > 0 && (uniformNames == 0 || uniformIndices == 0)) {
  GL.recordError(1281);
  return;
 }
 program = GL.programs[program];
 var names = [];
 for (var i = 0; i < uniformCount; i++) names.push(Pointer_stringify(HEAP32[uniformNames + i * 4 >> 2]));
 var result = GLctx["getUniformIndices"](program, names);
 if (!result) return;
 var len = result.length;
 for (var i = 0; i < len; i++) {
  HEAP32[uniformIndices + i * 4 >> 2] = result[i];
 }
}
Module["_glGetUniformIndices"] = _glGetUniformIndices;
function _glClearBufferiv(buffer, drawbuffer, value) {
 var view = HEAP32.subarray(value >> 2, value + 16 >> 2);
 GLctx["clearBufferiv"](buffer, drawbuffer, view);
}
Module["_glClearBufferiv"] = _glClearBufferiv;
function _glClearBufferuiv(buffer, drawbuffer, value) {
 var view = HEAPU32.subarray(value >> 2, value + 16 >> 2);
 GLctx["clearBufferuiv"](buffer, drawbuffer, view);
}
Module["_glClearBufferuiv"] = _glClearBufferuiv;
function _glClearBufferfv(buffer, drawbuffer, value) {
 view = GL.miniTempBufferViews[3];
 view[0] = HEAPF32[value >> 2];
 view[1] = HEAPF32[value + 4 >> 2];
 view[2] = HEAPF32[value + 8 >> 2];
 view[3] = HEAPF32[value + 12 >> 2];
 GLctx["clearBufferfv"](buffer, drawbuffer, view);
}
Module["_glClearBufferfv"] = _glClearBufferfv;
function _glWaitSync(sync, flags, timeoutLo, timeoutHi) {
 timeoutLo == timeoutLo >>> 0;
 timeoutHi == timeoutHi >>> 0;
 var timeout = timeoutLo == 4294967295 && timeoutHi == 4294967295 ? -1 : Runtime.makeBigInt(timeoutLo, timeoutHi, true);
 GLctx.waitSync(GL.syncs[sync], flags, timeout);
}
Module["_glWaitSync"] = _glWaitSync;
function _glGetSynciv(sync, pname, bufSize, length, values) {
 if (bufSize < 0) {
  GL.recordError(1281);
  return;
 }
 if (!values) {
  GL.recordError(1281);
  return;
 }
 var ret = GLctx.getSyncParameter(GL.syncs[sync], pname);
 HEAP32[length >> 2] = ret;
 if (ret !== null && length) HEAP32[length >> 2] = 1;
}
Module["_glGetSynciv"] = _glGetSynciv;
function _glIsSync(sync) {
 var sync = GL.syncs[sync];
 if (!sync) return 0;
 return GLctx.isSync(sync);
}
Module["_glIsSync"] = _glIsSync;
function _glGetInternalFormativ(target, internalformat, pname, bufSize, params) {
 if (bufSize < 0) {
  GL.recordError(1281);
  return;
 }
 if (!params) {
  GL.recordError(1281);
  return;
 }
 var ret = GLctx.getInternalFormatParameter(target, internalformat, pname);
 if (ret === null) return;
 for (var i = 0; i < ret.length && i < bufSize; ++i) {
  HEAP32[params + i >> 2] = ret[i];
 }
}
Module["_glGetInternalFormativ"] = _glGetInternalFormativ;
function _glIsBuffer(buffer) {
 var b = GL.buffers[buffer];
 if (!b) return 0;
 return GLctx.isBuffer(b);
}
Module["_glIsBuffer"] = _glIsBuffer;
function _glGetRenderbufferParameteriv(target, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 HEAP32[params >> 2] = GLctx.getRenderbufferParameter(target, pname);
}
Module["_glGetRenderbufferParameteriv"] = _glGetRenderbufferParameteriv;
function _glIsRenderbuffer(renderbuffer) {
 var rb = GL.renderbuffers[renderbuffer];
 if (!rb) return 0;
 return GLctx.isRenderbuffer(rb);
}
Module["_glIsRenderbuffer"] = _glIsRenderbuffer;
function _glGetUniformfv(program, location, params) {
 emscriptenWebGLGetUniform(program, location, params, "Float");
}
Module["_glGetUniformfv"] = _glGetUniformfv;
function _glGetUniformuiv(program, location, params) {
 emscriptenWebGLGetUniform(program, location, params, "Integer");
}
Module["_glGetUniformuiv"] = _glGetUniformuiv;
function _glGetFragDataLocation(program, name) {
 return GLctx["getFragDataLocation"](GL.programs[program], Pointer_stringify(name));
}
Module["_glGetFragDataLocation"] = _glGetFragDataLocation;
function _glGetVertexAttribfv(index, pname, params) {
 emscriptenWebGLGetVertexAttrib(index, pname, params, "Float");
}
Module["_glGetVertexAttribfv"] = _glGetVertexAttribfv;
function _glGetVertexAttribIiv(index, pname, params) {
 emscriptenWebGLGetVertexAttrib(index, pname, params, "Integer");
}
Module["_glGetVertexAttribIiv"] = _glGetVertexAttribIiv;
function _glGetVertexAttribIuiv(index, pname, params) {
 emscriptenWebGLGetVertexAttrib(index, pname, params, "Integer");
}
Module["_glGetVertexAttribIuiv"] = _glGetVertexAttribIuiv;
function _glGetVertexAttribPointerv(index, pname, pointer) {
 if (!pointer) {
  GL.recordError(1281);
  return;
 }
 HEAP32[pointer >> 2] = GLctx.getVertexAttribOffset(index, pname);
}
Module["_glGetVertexAttribPointerv"] = _glGetVertexAttribPointerv;
function _glUniform1f(location, v0) {
 location = GL.uniforms[location];
 GLctx.uniform1f(location, v0);
}
Module["_glUniform1f"] = _glUniform1f;
function _glUniform2f(location, v0, v1) {
 location = GL.uniforms[location];
 GLctx.uniform2f(location, v0, v1);
}
Module["_glUniform2f"] = _glUniform2f;
function _glUniform3f(location, v0, v1, v2) {
 location = GL.uniforms[location];
 GLctx.uniform3f(location, v0, v1, v2);
}
Module["_glUniform3f"] = _glUniform3f;
function _glUniform4f(location, v0, v1, v2, v3) {
 location = GL.uniforms[location];
 GLctx.uniform4f(location, v0, v1, v2, v3);
}
Module["_glUniform4f"] = _glUniform4f;
function _glUniform2i(location, v0, v1) {
 location = GL.uniforms[location];
 GLctx.uniform2i(location, v0, v1);
}
Module["_glUniform2i"] = _glUniform2i;
function _glUniform3i(location, v0, v1, v2) {
 location = GL.uniforms[location];
 GLctx.uniform3i(location, v0, v1, v2);
}
Module["_glUniform3i"] = _glUniform3i;
function _glUniform4i(location, v0, v1, v2, v3) {
 location = GL.uniforms[location];
 GLctx.uniform4i(location, v0, v1, v2, v3);
}
Module["_glUniform4i"] = _glUniform4i;
function _glUniform1ui(location, v0) {
 location = GL.uniforms[location];
 GLctx.uniform1ui(location, v0);
}
Module["_glUniform1ui"] = _glUniform1ui;
function _glUniform2ui(location, v0, v1) {
 location = GL.uniforms[location];
 GLctx.uniform2ui(location, v0, v1);
}
Module["_glUniform2ui"] = _glUniform2ui;
function _glUniform3ui(location, v0, v1, v2) {
 location = GL.uniforms[location];
 GLctx.uniform3ui(location, v0, v1, v2);
}
Module["_glUniform3ui"] = _glUniform3ui;
function _glUniform4ui(location, v0, v1, v2, v3) {
 location = GL.uniforms[location];
 GLctx.uniform4ui(location, v0, v1, v2, v3);
}
Module["_glUniform4ui"] = _glUniform4ui;
function _glUniform1uiv(location, count, value) {
 location = GL.uniforms[location];
 value = HEAPU32.subarray(value >> 2, value + count * 4 >> 2);
 GLctx.uniform1uiv(location, value);
}
Module["_glUniform1uiv"] = _glUniform1uiv;
function _glUniform2uiv(location, count, value) {
 location = GL.uniforms[location];
 count *= 2;
 value = HEAPU32.subarray(value >> 2, value + count * 4 >> 2);
 GLctx.uniform2uiv(location, value);
}
Module["_glUniform2uiv"] = _glUniform2uiv;
function _glUniform3uiv(location, count, value) {
 location = GL.uniforms[location];
 count *= 3;
 value = HEAPU32.subarray(value >> 2, value + count * 4 >> 2);
 GLctx.uniform3uiv(location, value);
}
Module["_glUniform3uiv"] = _glUniform3uiv;
function _glUniform4uiv(location, count, value) {
 location = GL.uniforms[location];
 count *= 4;
 value = HEAPU32.subarray(value >> 2, value + count * 4 >> 2);
 GLctx.uniform4uiv(location, value);
}
Module["_glUniform4uiv"] = _glUniform4uiv;
function _glUniformMatrix2fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (4 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[4 * count - 1];
  for (var i = 0; i < 4 * count; i += 4) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 16 >> 2);
 }
 GLctx.uniformMatrix2fv(location, transpose, view);
}
Module["_glUniformMatrix2fv"] = _glUniformMatrix2fv;
function _glUniformMatrix2x3fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (6 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[6 * count - 1];
  for (var i = 0; i < 6 * count; i += 6) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
   view[i + 4] = HEAPF32[value + (4 * i + 16) >> 2];
   view[i + 5] = HEAPF32[value + (4 * i + 20) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 24 >> 2);
 }
 GLctx.uniformMatrix2x3fv(location, transpose, view);
}
Module["_glUniformMatrix2x3fv"] = _glUniformMatrix2x3fv;
function _glUniformMatrix3x2fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (6 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[6 * count - 1];
  for (var i = 0; i < 6 * count; i += 6) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
   view[i + 4] = HEAPF32[value + (4 * i + 16) >> 2];
   view[i + 5] = HEAPF32[value + (4 * i + 20) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 24 >> 2);
 }
 GLctx.uniformMatrix3x2fv(location, transpose, view);
}
Module["_glUniformMatrix3x2fv"] = _glUniformMatrix3x2fv;
function _glUniformMatrix2x4fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (8 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[8 * count - 1];
  for (var i = 0; i < 8 * count; i += 8) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
   view[i + 4] = HEAPF32[value + (4 * i + 16) >> 2];
   view[i + 5] = HEAPF32[value + (4 * i + 20) >> 2];
   view[i + 6] = HEAPF32[value + (4 * i + 24) >> 2];
   view[i + 7] = HEAPF32[value + (4 * i + 28) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 32 >> 2);
 }
 GLctx.uniformMatrix2x4fv(location, transpose, view);
}
Module["_glUniformMatrix2x4fv"] = _glUniformMatrix2x4fv;
function _glUniformMatrix4x2fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (8 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[8 * count - 1];
  for (var i = 0; i < 8 * count; i += 8) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
   view[i + 4] = HEAPF32[value + (4 * i + 16) >> 2];
   view[i + 5] = HEAPF32[value + (4 * i + 20) >> 2];
   view[i + 6] = HEAPF32[value + (4 * i + 24) >> 2];
   view[i + 7] = HEAPF32[value + (4 * i + 28) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 32 >> 2);
 }
 GLctx.uniformMatrix4x2fv(location, transpose, view);
}
Module["_glUniformMatrix4x2fv"] = _glUniformMatrix4x2fv;
function _glUniformMatrix3x4fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (12 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[12 * count - 1];
  for (var i = 0; i < 12 * count; i += 12) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
   view[i + 4] = HEAPF32[value + (4 * i + 16) >> 2];
   view[i + 5] = HEAPF32[value + (4 * i + 20) >> 2];
   view[i + 6] = HEAPF32[value + (4 * i + 24) >> 2];
   view[i + 7] = HEAPF32[value + (4 * i + 28) >> 2];
   view[i + 8] = HEAPF32[value + (4 * i + 32) >> 2];
   view[i + 9] = HEAPF32[value + (4 * i + 36) >> 2];
   view[i + 10] = HEAPF32[value + (4 * i + 40) >> 2];
   view[i + 11] = HEAPF32[value + (4 * i + 44) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 48 >> 2);
 }
 GLctx.uniformMatrix3x4fv(location, transpose, view);
}
Module["_glUniformMatrix3x4fv"] = _glUniformMatrix3x4fv;
function _glUniformMatrix4x3fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (12 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[12 * count - 1];
  for (var i = 0; i < 12 * count; i += 12) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
   view[i + 4] = HEAPF32[value + (4 * i + 16) >> 2];
   view[i + 5] = HEAPF32[value + (4 * i + 20) >> 2];
   view[i + 6] = HEAPF32[value + (4 * i + 24) >> 2];
   view[i + 7] = HEAPF32[value + (4 * i + 28) >> 2];
   view[i + 8] = HEAPF32[value + (4 * i + 32) >> 2];
   view[i + 9] = HEAPF32[value + (4 * i + 36) >> 2];
   view[i + 10] = HEAPF32[value + (4 * i + 40) >> 2];
   view[i + 11] = HEAPF32[value + (4 * i + 44) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 48 >> 2);
 }
 GLctx.uniformMatrix4x3fv(location, transpose, view);
}
Module["_glUniformMatrix4x3fv"] = _glUniformMatrix4x3fv;
function _glVertexAttrib1fv(index, v) {
 var view = GL.miniTempBufferViews[0];
 view[0] = HEAPF32[v >> 2];
 GLctx.vertexAttrib1fv(index, view);
}
Module["_glVertexAttrib1fv"] = _glVertexAttrib1fv;
function _glVertexAttrib2fv(index, v) {
 var view = GL.miniTempBufferViews[1];
 view[0] = HEAPF32[v >> 2];
 view[1] = HEAPF32[v + 4 >> 2];
 GLctx.vertexAttrib2fv(index, view);
}
Module["_glVertexAttrib2fv"] = _glVertexAttrib2fv;
function _glVertexAttrib3fv(index, v) {
 var view = GL.miniTempBufferViews[2];
 view[0] = HEAPF32[v >> 2];
 view[1] = HEAPF32[v + 4 >> 2];
 view[2] = HEAPF32[v + 8 >> 2];
 GLctx.vertexAttrib3fv(index, view);
}
Module["_glVertexAttrib3fv"] = _glVertexAttrib3fv;
function _glVertexAttrib4fv(index, v) {
 var view = GL.miniTempBufferViews[3];
 view[0] = HEAPF32[v >> 2];
 view[1] = HEAPF32[v + 4 >> 2];
 view[2] = HEAPF32[v + 8 >> 2];
 view[3] = HEAPF32[v + 12 >> 2];
 GLctx.vertexAttrib4fv(index, view);
}
Module["_glVertexAttrib4fv"] = _glVertexAttrib4fv;
function _glVertexAttribI4iv(index, v) {
 v = HEAP32.subarray(v >> 2, v + 16 >> 2);
 GLctx.vertexAttribI4iv(index, v);
}
Module["_glVertexAttribI4iv"] = _glVertexAttribI4iv;
function _glVertexAttribI4uiv(index, v) {
 v = HEAPU32.subarray(v >> 2, v + 16 >> 2);
 GLctx.vertexAttribI4uiv(index, v);
}
Module["_glVertexAttribI4uiv"] = _glVertexAttribI4uiv;
function _glGetAttachedShaders(program, maxCount, count, shaders) {
 var result = GLctx.getAttachedShaders(GL.programs[program]);
 var len = result.length;
 if (len > maxCount) {
  len = maxCount;
 }
 HEAP32[count >> 2] = len;
 for (var i = 0; i < len; ++i) {
  var id = GL.shaders.indexOf(result[i]);
  assert(id !== -1, "shader not bound to local id");
  HEAP32[shaders + i * 4 >> 2] = id;
 }
}
Module["_glGetAttachedShaders"] = _glGetAttachedShaders;
function _glIsShader(shader) {
 var s = GL.shaders[shader];
 if (!s) return 0;
 return GLctx.isShader(s);
}
Module["_glIsShader"] = _glIsShader;
function _glDetachShader(program, shader) {
 GLctx.detachShader(GL.programs[program], GL.shaders[shader]);
}
Module["_glDetachShader"] = _glDetachShader;
function _glIsProgram(program) {
 var program = GL.programs[program];
 if (!program) return 0;
 return GLctx.isProgram(program);
}
Module["_glIsProgram"] = _glIsProgram;
function _glIsFramebuffer(framebuffer) {
 var fb = GL.framebuffers[framebuffer];
 if (!fb) return 0;
 return GLctx.isFramebuffer(fb);
}
Module["_glIsFramebuffer"] = _glIsFramebuffer;
function _glVertexPointer() {
 throw "Legacy GL function (glVertexPointer) called. If you want legacy GL emulation, you need to compile with -s LEGACY_GL_EMULATION=1 to enable legacy GL emulation.";
}
Module["_glVertexPointer"] = _glVertexPointer;
function _glMatrixMode() {
 throw "Legacy GL function (glMatrixMode) called. If you want legacy GL emulation, you need to compile with -s LEGACY_GL_EMULATION=1 to enable legacy GL emulation.";
}
Module["_glMatrixMode"] = _glMatrixMode;
function _glBegin() {
 throw "Legacy GL function (glBegin) called. If you want legacy GL emulation, you need to compile with -s LEGACY_GL_EMULATION=1 to enable legacy GL emulation.";
}
Module["_glBegin"] = _glBegin;
function _glLoadIdentity() {
 throw "Legacy GL function (glLoadIdentity) called. If you want legacy GL emulation, you need to compile with -s LEGACY_GL_EMULATION=1 to enable legacy GL emulation.";
}
Module["_glLoadIdentity"] = _glLoadIdentity;
function _glGenVertexArraysOES(n, arrays) {
 for (var i = 0; i < n; i++) {
  var vao = GLctx["createVertexArray"]();
  if (!vao) {
   GL.recordError(1282);
   while (i < n) HEAP32[arrays + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.vaos);
  vao.name = id;
  GL.vaos[id] = vao;
  HEAP32[arrays + i * 4 >> 2] = id;
 }
}
Module["_glGenVertexArraysOES"] = _glGenVertexArraysOES;
function _glDeleteVertexArraysOES(n, vaos) {
 for (var i = 0; i < n; i++) {
  var id = HEAP32[vaos + i * 4 >> 2];
  GLctx["deleteVertexArray"](GL.vaos[id]);
  GL.vaos[id] = null;
 }
}
Module["_glDeleteVertexArraysOES"] = _glDeleteVertexArraysOES;
function _glBindVertexArrayOES(vao) {
 GLctx["bindVertexArray"](GL.vaos[vao]);
}
Module["_glBindVertexArrayOES"] = _glBindVertexArrayOES;
function _gluPerspective(fov, aspect, near, far) {
 GLImmediate.matricesModified = true;
 GLImmediate.matrixVersion[GLImmediate.currentMatrix] = GLImmediate.matrixVersion[GLImmediate.currentMatrix] + 1 | 0;
 GLImmediate.matrix[GLImmediate.currentMatrix] = GLImmediate.matrixLib.mat4.perspective(fov, aspect, near, far, GLImmediate.matrix[GLImmediate.currentMatrix]);
}
Module["_gluPerspective"] = _gluPerspective;
function _gluLookAt(ex, ey, ez, cx, cy, cz, ux, uy, uz) {
 GLImmediate.matricesModified = true;
 GLImmediate.matrixVersion[GLImmediate.currentMatrix] = GLImmediate.matrixVersion[GLImmediate.currentMatrix] + 1 | 0;
 GLImmediate.matrixLib.mat4.lookAt(GLImmediate.matrix[GLImmediate.currentMatrix], [ ex, ey, ez ], [ cx, cy, cz ], [ ux, uy, uz ]);
}
Module["_gluLookAt"] = _gluLookAt;
function _gluProject(objX, objY, objZ, model, proj, view, winX, winY, winZ) {
 var inVec = new Float32Array(4);
 var outVec = new Float32Array(4);
 GLImmediate.matrixLib.mat4.multiplyVec4(HEAPF64.subarray(model >> 3, model + 128 >> 3), [ objX, objY, objZ, 1 ], outVec);
 GLImmediate.matrixLib.mat4.multiplyVec4(HEAPF64.subarray(proj >> 3, proj + 128 >> 3), outVec, inVec);
 if (inVec[3] == 0) {
  return 0;
 }
 inVec[0] /= inVec[3];
 inVec[1] /= inVec[3];
 inVec[2] /= inVec[3];
 inVec[0] = inVec[0] * .5 + .5;
 inVec[1] = inVec[1] * .5 + .5;
 inVec[2] = inVec[2] * .5 + .5;
 inVec[0] = inVec[0] * HEAP32[view + 8 >> 2] + HEAP32[view >> 2];
 inVec[1] = inVec[1] * HEAP32[view + 12 >> 2] + HEAP32[view + 4 >> 2];
 HEAPF64[winX >> 3] = inVec[0];
 HEAPF64[winY >> 3] = inVec[1];
 HEAPF64[winZ >> 3] = inVec[2];
 return 1;
}
Module["_gluProject"] = _gluProject;
function _gluUnProject(winX, winY, winZ, model, proj, view, objX, objY, objZ) {
 var result = GLImmediate.matrixLib.mat4.unproject([ winX, winY, winZ ], HEAPF64.subarray(model >> 3, model + 128 >> 3), HEAPF64.subarray(proj >> 3, proj + 128 >> 3), HEAP32.subarray(view >> 2, view + 16 >> 2));
 if (result === null) {
  return 0;
 }
 HEAPF64[objX >> 3] = result[0];
 HEAPF64[objY >> 3] = result[1];
 HEAPF64[objZ >> 3] = result[2];
 return 1;
}
Module["_gluUnProject"] = _gluUnProject;
var _glOrtho = undefined;
function _gluOrtho2D(left, right, bottom, top) {
 _glOrtho(left, right, bottom, top, -1, 1);
}
Module["_gluOrtho2D"] = _gluOrtho2D;
function _glDrawRangeElements(mode, start, end, count, type, indices) {
 _emscripten_glDrawElements(mode, count, type, indices);
 GLctx.drawElements(mode, count, type, indices);
}
Module["_glDrawRangeElements"] = _glDrawRangeElements;
function _glShaderBinary() {
 GL.recordError(1280);
}
Module["_glShaderBinary"] = _glShaderBinary;
function _glReleaseShaderCompiler() {}
Module["_glReleaseShaderCompiler"] = _glReleaseShaderCompiler;
function _glVertexAttribDivisor(index, divisor) {
 GLctx["vertexAttribDivisor"](index, divisor);
}
Module["_glVertexAttribDivisor"] = _glVertexAttribDivisor;
function _glVertexAttribDivisorNV(index, divisor) {
 GLctx["vertexAttribDivisor"](index, divisor);
}
Module["_glVertexAttribDivisorNV"] = _glVertexAttribDivisorNV;
function _glDrawArraysInstancedNV(mode, first, count, primcount) {
 GLctx["drawArraysInstanced"](mode, first, count, primcount);
}
Module["_glDrawArraysInstancedNV"] = _glDrawArraysInstancedNV;
function _glDrawElementsInstancedNV(mode, count, type, indices, primcount) {
 GLctx["drawElementsInstanced"](mode, count, type, indices, primcount);
}
Module["_glDrawElementsInstancedNV"] = _glDrawElementsInstancedNV;
function _glVertexAttribDivisorEXT(index, divisor) {
 GLctx["vertexAttribDivisor"](index, divisor);
}
Module["_glVertexAttribDivisorEXT"] = _glVertexAttribDivisorEXT;
function _glDrawArraysInstancedEXT(mode, first, count, primcount) {
 GLctx["drawArraysInstanced"](mode, first, count, primcount);
}
Module["_glDrawArraysInstancedEXT"] = _glDrawArraysInstancedEXT;
function _glDrawElementsInstancedEXT(mode, count, type, indices, primcount) {
 GLctx["drawElementsInstanced"](mode, count, type, indices, primcount);
}
Module["_glDrawElementsInstancedEXT"] = _glDrawElementsInstancedEXT;
function _glVertexAttribDivisorARB(index, divisor) {
 GLctx["vertexAttribDivisor"](index, divisor);
}
Module["_glVertexAttribDivisorARB"] = _glVertexAttribDivisorARB;
function _glDrawArraysInstancedARB(mode, first, count, primcount) {
 GLctx["drawArraysInstanced"](mode, first, count, primcount);
}
Module["_glDrawArraysInstancedARB"] = _glDrawArraysInstancedARB;
function _glDrawElementsInstancedARB(mode, count, type, indices, primcount) {
 GLctx["drawElementsInstanced"](mode, count, type, indices, primcount);
}
Module["_glDrawElementsInstancedARB"] = _glDrawElementsInstancedARB;
function _glVertexAttribDivisorANGLE(index, divisor) {
 GLctx["vertexAttribDivisor"](index, divisor);
}
Module["_glVertexAttribDivisorANGLE"] = _glVertexAttribDivisorANGLE;
function _glDrawArraysInstancedANGLE(mode, first, count, primcount) {
 GLctx["drawArraysInstanced"](mode, first, count, primcount);
}
Module["_glDrawArraysInstancedANGLE"] = _glDrawArraysInstancedANGLE;
function _glDrawElementsInstancedANGLE(mode, count, type, indices, primcount) {
 GLctx["drawElementsInstanced"](mode, count, type, indices, primcount);
}
Module["_glDrawElementsInstancedANGLE"] = _glDrawElementsInstancedANGLE;
function _glDrawBuffersEXT(n, bufs) {
 var bufArray = [];
 for (var i = 0; i < n; i++) bufArray.push(HEAP32[bufs + i * 4 >> 2]);
 if (n == 0) {
  if (GLctx.getParameter(GLctx["DRAW_FRAMEBUFFER_BINDING"]) != 0) bufArray.push(GLctx["NONE"]); else {
   GL.recordError(1282);
   return;
  }
 }
 GLctx["drawBuffers"](bufArray);
}
Module["_glDrawBuffersEXT"] = _glDrawBuffersEXT;
function _glPauseTransformFeedback() {
 GLctx.pauseTransformFeedback();
}
Module["_glPauseTransformFeedback"] = _glPauseTransformFeedback;
function _glResumeTransformFeedback() {
 GLctx.resumeTransformFeedback();
}
Module["_glResumeTransformFeedback"] = _glResumeTransformFeedback;
function _glClearDepth(x0) {
 GLctx.clearDepth(x0);
}
Module["_glClearDepth"] = _glClearDepth;
function _glLineWidth(x0) {
 GLctx.lineWidth(x0);
}
Module["_glLineWidth"] = _glLineWidth;
function _glBlendFunc(x0, x1) {
 GLctx.blendFunc(x0, x1);
}
Module["_glBlendFunc"] = _glBlendFunc;
function _glDepthRange(x0, x1) {
 GLctx.depthRange(x0, x1);
}
Module["_glDepthRange"] = _glDepthRange;
function _glDepthRangef(x0, x1) {
 GLctx.depthRange(x0, x1);
}
Module["_glDepthRangef"] = _glDepthRangef;
function _glStencilMaskSeparate(x0, x1) {
 GLctx.stencilMaskSeparate(x0, x1);
}
Module["_glStencilMaskSeparate"] = _glStencilMaskSeparate;
function _glHint(x0, x1) {
 GLctx.hint(x0, x1);
}
Module["_glHint"] = _glHint;
function _glVertexAttrib1f(x0, x1) {
 GLctx.vertexAttrib1f(x0, x1);
}
Module["_glVertexAttrib1f"] = _glVertexAttrib1f;
function _glSampleCoverage(x0, x1) {
 GLctx.sampleCoverage(x0, x1);
}
Module["_glSampleCoverage"] = _glSampleCoverage;
function _glVertexAttrib2f(x0, x1, x2) {
 GLctx.vertexAttrib2f(x0, x1, x2);
}
Module["_glVertexAttrib2f"] = _glVertexAttrib2f;
function _glStencilFunc(x0, x1, x2) {
 GLctx.stencilFunc(x0, x1, x2);
}
Module["_glStencilFunc"] = _glStencilFunc;
function _glStencilOp(x0, x1, x2) {
 GLctx.stencilOp(x0, x1, x2);
}
Module["_glStencilOp"] = _glStencilOp;
function _glVertexAttrib3f(x0, x1, x2, x3) {
 GLctx.vertexAttrib3f(x0, x1, x2, x3);
}
Module["_glVertexAttrib3f"] = _glVertexAttrib3f;
function _glBlendColor(x0, x1, x2, x3) {
 GLctx.blendColor(x0, x1, x2, x3);
}
Module["_glBlendColor"] = _glBlendColor;
function _glClearBufferfi(x0, x1, x2, x3) {
 GLctx.clearBufferfi(x0, x1, x2, x3);
}
Module["_glClearBufferfi"] = _glClearBufferfi;
function _glVertexAttribI4i(x0, x1, x2, x3, x4) {
 GLctx.vertexAttribI4i(x0, x1, x2, x3, x4);
}
Module["_glVertexAttribI4i"] = _glVertexAttribI4i;
function _glVertexAttribI4ui(x0, x1, x2, x3, x4) {
 GLctx.vertexAttribI4ui(x0, x1, x2, x3, x4);
}
Module["_glVertexAttribI4ui"] = _glVertexAttribI4ui;
function _glCopyTexSubImage3D(x0, x1, x2, x3, x4, x5, x6, x7, x8) {
 GLctx.copyTexSubImage3D(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
Module["_glCopyTexSubImage3D"] = _glCopyTexSubImage3D;
function _emscripten_glGetStringi(name, index) {
 if (GLctx.canvas.GLctxObject.version < 2) {
  GL.recordError(1282);
  return 0;
 }
 var stringiCache = GL.stringiCache[name];
 if (stringiCache) {
  if (index < 0 || index >= stringiCache.length) {
   GL.recordError(1281);
   return 0;
  }
  return stringiCache[index];
 }
 switch (name) {
 case 7939:
  var exts = GLctx.getSupportedExtensions();
  var gl_exts = [];
  for (var i in exts) {
   gl_exts.push(allocate(intArrayFromString(exts[i]), "i8", ALLOC_NORMAL));
   gl_exts.push(allocate(intArrayFromString("GL_" + exts[i]), "i8", ALLOC_NORMAL));
  }
  stringiCache = GL.stringiCache[name] = gl_exts;
  if (index < 0 || index >= stringiCache.length) {
   GL.recordError(1281);
   return 0;
  }
  return stringiCache[index];
 default:
  GL.recordError(1280);
  return 0;
 }
}
Module["_emscripten_glGetStringi"] = _emscripten_glGetStringi;
function _emscripten_glGetInteger64v(name_, p) {
 emscriptenWebGLGet(name_, p, "Integer64");
}
Module["_emscripten_glGetInteger64v"] = _emscripten_glGetInteger64v;
function _emscripten_glCompressedTexImage3D(target, level, internalFormat, width, height, depth, border, imageSize, data) {
 var heapView;
 if (data) {
  heapView = HEAPU8.subarray(data, data + imageSize);
 } else {
  heapView = null;
 }
 GLctx["compressedTexImage3D"](target, level, internalFormat, width, height, depth, border, heapView);
}
Module["_emscripten_glCompressedTexImage3D"] = _emscripten_glCompressedTexImage3D;
function _emscripten_glCompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data) {
 var heapView;
 if (data) {
  heapView = HEAPU8.subarray(data, data + imageSize);
 } else {
  heapView = null;
 }
 GLctx["compressedTexSubImage2D"](target, level, xoffset, yoffset, zoffset, width, height, depth, format, heapView);
}
Module["_emscripten_glCompressedTexSubImage3D"] = _emscripten_glCompressedTexSubImage3D;
function _emscripten_glGetBufferParameteri64v(target, value, data) {
 if (!data) {
  GL.recordError(1281);
  return;
 }
 tempI64 = [ GLctx.getBufferParameter(target, value) >>> 0, (tempDouble = GLctx.getBufferParameter(target, value), +Math_abs(tempDouble) >= +1 ? tempDouble > +0 ? (Math_min(+Math_floor(tempDouble / +4294967296), +4294967295) | 0) >>> 0 : ~~+Math_ceil((tempDouble - +(~~tempDouble >>> 0)) / +4294967296) >>> 0 : 0) ], HEAP32[data >> 2] = tempI64[0], HEAP32[data + 4 >> 2] = tempI64[1];
}
Module["_emscripten_glGetBufferParameteri64v"] = _emscripten_glGetBufferParameteri64v;
function _emscripten_glInvalidateFramebuffer(target, numAttachments, attachments) {
 var list = [];
 for (var i = 0; i < numAttachments; i++) list.push(HEAP32[attachments + i * 4 >> 2]);
 GLctx["invalidateFramebuffer"](target, list);
}
Module["_emscripten_glInvalidateFramebuffer"] = _emscripten_glInvalidateFramebuffer;
function _emscripten_glInvalidateSubFramebuffer(target, numAttachments, attachments, x, y, width, height) {
 var list = [];
 for (var i = 0; i < numAttachments; i++) list.push(HEAP32[attachments + i * 4 >> 2]);
 GLctx["invalidateSubFramebuffer"](target, list, x, y, width, height);
}
Module["_emscripten_glInvalidateSubFramebuffer"] = _emscripten_glInvalidateSubFramebuffer;
function _emscripten_glTexImage3D(target, level, internalFormat, width, height, depth, border, format, type, data) {
 GLctx["texImage3D"](target, level, internalFormat, width, height, depth, border, format, type, HEAPU8.subarray(data));
}
Module["_emscripten_glTexImage3D"] = _emscripten_glTexImage3D;
function _emscripten_glTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data) {
 GLctx["texSubImage3D"](target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, HEAPU8.subarray(data));
}
Module["_emscripten_glTexSubImage3D"] = _emscripten_glTexSubImage3D;
function _emscripten_glGenQueries(n, ids) {
 for (var i = 0; i < n; i++) {
  var query = GLctx["createQuery"]();
  if (!query) {
   GL.recordError(1282);
   while (i < n) HEAP32[ids + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.queries);
  query.name = id;
  GL.queries[id] = query;
  HEAP32[ids + i * 4 >> 2] = id;
 }
}
Module["_emscripten_glGenQueries"] = _emscripten_glGenQueries;
function _emscripten_glDeleteQueries(n, ids) {
 for (var i = 0; i < n; i++) {
  var id = HEAP32[ids + i * 4 >> 2];
  var query = GL.queries[id];
  if (!query) continue;
  GLctx["deleteQuery"](query);
  query.name = 0;
  GL.queries[id] = null;
 }
}
Module["_emscripten_glDeleteQueries"] = _emscripten_glDeleteQueries;
function _emscripten_glIsQuery(id) {
 var query = GL.queries[query];
 if (!query) return 0;
 return GLctx["isQuery"](query);
}
Module["_emscripten_glIsQuery"] = _emscripten_glIsQuery;
function _emscripten_glBeginQuery(target, id) {
 GLctx["beginQuery"](target, id ? GL.queries[id] : null);
}
Module["_emscripten_glBeginQuery"] = _emscripten_glBeginQuery;
function _emscripten_glGetQueryiv(target, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 HEAP32[params >> 2] = GLctx["getQuery"](target, pname);
}
Module["_emscripten_glGetQueryiv"] = _emscripten_glGetQueryiv;
function _emscripten_glGetQueryObjectuiv(id, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 var query = GL.queries[id];
 var param = GLctx["getQueryParameter"](query, pname);
 var ret;
 if (typeof param == "boolean") {
  ret = param ? 1 : 0;
 } else {
  ret = param;
 }
 HEAP32[params >> 2] = ret;
}
Module["_emscripten_glGetQueryObjectuiv"] = _emscripten_glGetQueryObjectuiv;
function _emscripten_glGenSamplers(n, samplers) {
 for (var i = 0; i < n; i++) {
  var sampler = GLctx["createSampler"]();
  if (!sampler) {
   GL.recordError(1282);
   while (i < n) HEAP32[samplers + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.samplers);
  sampler.name = id;
  GL.samplers[id] = sampler;
  HEAP32[samplers + i * 4 >> 2] = id;
 }
}
Module["_emscripten_glGenSamplers"] = _emscripten_glGenSamplers;
function _emscripten_glDeleteSamplers(n, samplers) {
 for (var i = 0; i < n; i++) {
  var id = HEAP32[samplers + i * 4 >> 2];
  var sampler = GL.samplers[id];
  if (!sampler) continue;
  GLctx["deleteSampler"](sampler);
  sampler.name = 0;
  GL.samplers[id] = null;
 }
}
Module["_emscripten_glDeleteSamplers"] = _emscripten_glDeleteSamplers;
function _emscripten_glIsSampler(id) {
 var sampler = GL.samplers[id];
 if (!sampler) return 0;
 return GLctx["isSampler"](sampler);
}
Module["_emscripten_glIsSampler"] = _emscripten_glIsSampler;
function _emscripten_glBindSampler(unit, sampler) {
 GLctx["bindSampler"](unit, sampler ? GL.samplers[sampler] : null);
}
Module["_emscripten_glBindSampler"] = _emscripten_glBindSampler;
function _emscripten_glSamplerParameterf(sampler, pname, param) {
 GLctx["samplerParameterf"](sampler ? GL.samplers[sampler] : null, pname, param);
}
Module["_emscripten_glSamplerParameterf"] = _emscripten_glSamplerParameterf;
function _emscripten_glSamplerParameteri(sampler, pname, param) {
 GLctx["samplerParameteri"](sampler ? GL.samplers[sampler] : null, pname, param);
}
Module["_emscripten_glSamplerParameteri"] = _emscripten_glSamplerParameteri;
function _emscripten_glSamplerParameterfv(sampler, pname, params) {
 var param = HEAPF32[params >> 2];
 GLctx["samplerParameterf"](sampler ? GL.samplers[sampler] : null, pname, param);
}
Module["_emscripten_glSamplerParameterfv"] = _emscripten_glSamplerParameterfv;
function _emscripten_glSamplerParameteriv(sampler, pname, params) {
 var param = HEAP32[params >> 2];
 GLctx["samplerParameteri"](sampler ? GL.samplers[sampler] : null, pname, param);
}
Module["_emscripten_glSamplerParameteriv"] = _emscripten_glSamplerParameteriv;
function _emscripten_glGetSamplerParameterfv(sampler, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 sampler = GL.samplers[sampler];
 HEAPF32[params >> 2] = GLctx["getSamplerParameter"](sampler, pname);
}
Module["_emscripten_glGetSamplerParameterfv"] = _emscripten_glGetSamplerParameterfv;
function _emscripten_glGetSamplerParameteriv(sampler, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 sampler = GL.samplers[sampler];
 HEAP32[params >> 2] = GLctx["getSamplerParameter"](sampler, pname);
}
Module["_emscripten_glGetSamplerParameteriv"] = _emscripten_glGetSamplerParameteriv;
function _emscripten_glGenTransformFeedbacks(n, ids) {
 for (var i = 0; i < n; i++) {
  var transformFeedback = GLctx["createTransformFeedback"]();
  if (!transformFeedback) {
   GL.recordError(1282);
   while (i < n) HEAP32[ids + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.transformFeedbacks);
  transformFeedback.name = id;
  GL.transformFeedbacks[id] = transformFeedback;
  HEAP32[ids + i * 4 >> 2] = id;
 }
}
Module["_emscripten_glGenTransformFeedbacks"] = _emscripten_glGenTransformFeedbacks;
function _emscripten_glDeleteTransformFeedbacks(n, ids) {
 for (var i = 0; i < n; i++) {
  var id = HEAP32[ids + i * 4 >> 2];
  var transformFeedback = GL.transformFeedbacks[id];
  if (!transformFeedback) continue;
  GLctx["deleteTransformFeedback"](transformFeedback);
  transformFeedback.name = 0;
  GL.transformFeedbacks[id] = null;
 }
}
Module["_emscripten_glDeleteTransformFeedbacks"] = _emscripten_glDeleteTransformFeedbacks;
function _emscripten_glIsTransformFeedback(transformFeedback) {
 var transformFeedback = GL.transformFeedbacks[transformFeedback];
 if (!transformFeedback) return 0;
 return GLctx["isTransformFeedback"](transformFeedback);
}
Module["_emscripten_glIsTransformFeedback"] = _emscripten_glIsTransformFeedback;
function _emscripten_glBindTransformFeedback(target, id) {
 var transformFeedback = id ? GL.transformFeedbacks[id] : null;
 if (id && !transformFeedback) {
  GL.recordError(1282);
  return;
 }
 GLctx["bindTransformFeedback"](target, transformFeedback);
}
Module["_emscripten_glBindTransformFeedback"] = _emscripten_glBindTransformFeedback;
function _emscripten_glTransformFeedbackVaryings(program, count, varyings, bufferMode) {
 program = GL.programs[program];
 var vars = [];
 for (var i = 0; i < count; i++) vars.push(Pointer_stringify(HEAP32[varyings + i * 4 >> 2]));
 GLctx["transformFeedbackVaryings"](program, vars, bufferMode);
}
Module["_emscripten_glTransformFeedbackVaryings"] = _emscripten_glTransformFeedbackVaryings;
function _emscripten_glGetTransformFeedbackVarying(program, index, bufSize, length, size, type, name) {
 program = GL.programs[program];
 var info = GLctx["getTransformFeedbackVarying"](program, index);
 if (!info) return;
 var infoname = info.name.slice(0, Math.max(0, bufSize - 1));
 if (name && bufSize > 0) {
  writeStringToMemory(infoname, name);
  if (length) HEAP32[length >> 2] = infoname.length;
 } else {
  if (length) HEAP32[length >> 2] = 0;
 }
 if (size) HEAP32[size >> 2] = info.size;
 if (type) HEAP32[type >> 2] = info.type;
}
Module["_emscripten_glGetTransformFeedbackVarying"] = _emscripten_glGetTransformFeedbackVarying;
function _emscripten_glGetIntegeri_v(target, index, data) {
 emscriptenWebGLGetIndexed(target, index, data, "Integer");
}
Module["_emscripten_glGetIntegeri_v"] = _emscripten_glGetIntegeri_v;
function _emscripten_glGetInteger64i_v(target, index, data) {
 emscriptenWebGLGetIndexed(target, index, data, "Integer64");
}
Module["_emscripten_glGetInteger64i_v"] = _emscripten_glGetInteger64i_v;
function _emscripten_glBindBufferBase(target, index, buffer) {
 var bufferObj = buffer ? GL.buffers[buffer] : null;
 GLctx["bindBufferBase"](target, index, bufferObj);
}
Module["_emscripten_glBindBufferBase"] = _emscripten_glBindBufferBase;
function _emscripten_glBindBufferRange(target, index, buffer, offset, ptrsize) {
 var bufferObj = buffer ? GL.buffers[buffer] : null;
 GLctx["bindBufferRange"](target, index, bufferObj, offset, ptrsize);
}
Module["_emscripten_glBindBufferRange"] = _emscripten_glBindBufferRange;
function _emscripten_glGetUniformIndices(program, uniformCount, uniformNames, uniformIndices) {
 if (!uniformIndices) {
  GL.recordError(1281);
  return;
 }
 if (uniformCount > 0 && (uniformNames == 0 || uniformIndices == 0)) {
  GL.recordError(1281);
  return;
 }
 program = GL.programs[program];
 var names = [];
 for (var i = 0; i < uniformCount; i++) names.push(Pointer_stringify(HEAP32[uniformNames + i * 4 >> 2]));
 var result = GLctx["getUniformIndices"](program, names);
 if (!result) return;
 var len = result.length;
 for (var i = 0; i < len; i++) {
  HEAP32[uniformIndices + i * 4 >> 2] = result[i];
 }
}
Module["_emscripten_glGetUniformIndices"] = _emscripten_glGetUniformIndices;
function _emscripten_glGetActiveUniformsiv(program, uniformCount, uniformIndices, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 if (uniformCount > 0 && uniformIndices == 0) {
  GL.recordError(1281);
  return;
 }
 program = GL.programs[program];
 var ids = [];
 for (var i = 0; i < uniformCount; i++) {
  ids.push(HEAP32[uniformIndices + i * 4 >> 2]);
 }
 var result = GLctx["getActiveUniforms"](program, ids, pname);
 if (!result) return;
 var len = result.length;
 for (var i = 0; i < len; i++) {
  HEAP32[params + i * 4 >> 2] = result[i];
 }
}
Module["_emscripten_glGetActiveUniformsiv"] = _emscripten_glGetActiveUniformsiv;
function _emscripten_glGetUniformBlockIndex(program, uniformBlockName) {
 program = GL.programs[program];
 uniformBlockName = Pointer_stringify(uniformBlockName);
 return GLctx["getUniformBlockIndex"](program, uniformBlockName);
}
Module["_emscripten_glGetUniformBlockIndex"] = _emscripten_glGetUniformBlockIndex;
function _emscripten_glGetActiveUniformBlockiv(program, uniformBlockIndex, pname, params) {
 if (!params) {
  GL.recordError(1281);
  return;
 }
 program = GL.programs[program];
 var result = GLctx["getActiveUniformBlockParameter"](program, uniformBlockIndex, pname);
 if (!result) return;
 if (typeof result == "number") {
  HEAP32[params >> 2] = result;
 } else {
  for (var i = 0; i < result.length; i++) {
   HEAP32[params + i * 4 >> 2] = result[i];
  }
 }
}
Module["_emscripten_glGetActiveUniformBlockiv"] = _emscripten_glGetActiveUniformBlockiv;
function _emscripten_glGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, length, uniformBlockName) {
 program = GL.programs[program];
 var result = GLctx["getActiveUniformBlockName"](program, uniformBlockIndex);
 if (!result) return;
 var name = result.slice(0, Math.max(0, bufSize - 1));
 if (uniformBlockName && bufSize > 0) {
  writeStringToMemory(name, uniformBlockName);
  if (length) HEAP32[length >> 2] = name.length;
 } else {
  if (length) HEAP32[length >> 2] = 0;
 }
}
Module["_emscripten_glGetActiveUniformBlockName"] = _emscripten_glGetActiveUniformBlockName;
function _emscripten_glUniformBlockBinding(program, uniformBlockIndex, uniformBlockBinding) {
 program = GL.programs[program];
 GLctx["uniformBlockBinding"](program, uniformBlockIndex, uniformBlockBinding);
}
Module["_emscripten_glUniformBlockBinding"] = _emscripten_glUniformBlockBinding;
function _emscripten_glClearBufferiv(buffer, drawbuffer, value) {
 var view = HEAP32.subarray(value >> 2, value + 16 >> 2);
 GLctx["clearBufferiv"](buffer, drawbuffer, view);
}
Module["_emscripten_glClearBufferiv"] = _emscripten_glClearBufferiv;
function _emscripten_glClearBufferuiv(buffer, drawbuffer, value) {
 var view = HEAPU32.subarray(value >> 2, value + 16 >> 2);
 GLctx["clearBufferuiv"](buffer, drawbuffer, view);
}
Module["_emscripten_glClearBufferuiv"] = _emscripten_glClearBufferuiv;
function _emscripten_glClearBufferfv(buffer, drawbuffer, value) {
 view = GL.miniTempBufferViews[3];
 view[0] = HEAPF32[value >> 2];
 view[1] = HEAPF32[value + 4 >> 2];
 view[2] = HEAPF32[value + 8 >> 2];
 view[3] = HEAPF32[value + 12 >> 2];
 GLctx["clearBufferfv"](buffer, drawbuffer, view);
}
Module["_emscripten_glClearBufferfv"] = _emscripten_glClearBufferfv;
function _emscripten_glFenceSync(condition, flags) {
 var sync = GLctx.fenceSync(condition, flags);
 if (sync) {
  var id = GL.getNewId(GL.syncs);
  sync.name = id;
  GL.syncs[id] = sync;
  return id;
 } else {
  return 0;
 }
}
Module["_emscripten_glFenceSync"] = _emscripten_glFenceSync;
function _emscripten_glDeleteSync(id) {
 if (!id) return;
 var sync = GL.syncs[id];
 if (!sync) {
  GL.recordError(1281);
  return;
 }
 GLctx.deleteSync(sync);
 sync.name = 0;
 GL.syncs[id] = null;
}
Module["_emscripten_glDeleteSync"] = _emscripten_glDeleteSync;
function _emscripten_glClientWaitSync(sync, flags, timeoutLo, timeoutHi) {
 timeoutLo == timeoutLo >>> 0;
 timeoutHi == timeoutHi >>> 0;
 var timeout = timeoutLo == 4294967295 && timeoutHi == 4294967295 ? -1 : Runtime.makeBigInt(timeoutLo, timeoutHi, true);
 return GLctx.clientWaitSync(GL.syncs[sync], flags, timeout);
}
Module["_emscripten_glClientWaitSync"] = _emscripten_glClientWaitSync;
function _emscripten_glWaitSync(sync, flags, timeoutLo, timeoutHi) {
 timeoutLo == timeoutLo >>> 0;
 timeoutHi == timeoutHi >>> 0;
 var timeout = timeoutLo == 4294967295 && timeoutHi == 4294967295 ? -1 : Runtime.makeBigInt(timeoutLo, timeoutHi, true);
 GLctx.waitSync(GL.syncs[sync], flags, timeout);
}
Module["_emscripten_glWaitSync"] = _emscripten_glWaitSync;
function _emscripten_glGetSynciv(sync, pname, bufSize, length, values) {
 if (bufSize < 0) {
  GL.recordError(1281);
  return;
 }
 if (!values) {
  GL.recordError(1281);
  return;
 }
 var ret = GLctx.getSyncParameter(GL.syncs[sync], pname);
 HEAP32[length >> 2] = ret;
 if (ret !== null && length) HEAP32[length >> 2] = 1;
}
Module["_emscripten_glGetSynciv"] = _emscripten_glGetSynciv;
function _emscripten_glIsSync(sync) {
 var sync = GL.syncs[sync];
 if (!sync) return 0;
 return GLctx.isSync(sync);
}
Module["_emscripten_glIsSync"] = _emscripten_glIsSync;
function _emscripten_glGetInternalFormativ(target, internalformat, pname, bufSize, params) {
 if (bufSize < 0) {
  GL.recordError(1281);
  return;
 }
 if (!params) {
  GL.recordError(1281);
  return;
 }
 var ret = GLctx.getInternalFormatParameter(target, internalformat, pname);
 if (ret === null) return;
 for (var i = 0; i < ret.length && i < bufSize; ++i) {
  HEAP32[params + i >> 2] = ret[i];
 }
}
Module["_emscripten_glGetInternalFormativ"] = _emscripten_glGetInternalFormativ;
function _emscripten_glGetUniformuiv(program, location, params) {
 emscriptenWebGLGetUniform(program, location, params, "Integer");
}
Module["_emscripten_glGetUniformuiv"] = _emscripten_glGetUniformuiv;
function _emscripten_glGetFragDataLocation(program, name) {
 return GLctx["getFragDataLocation"](GL.programs[program], Pointer_stringify(name));
}
Module["_emscripten_glGetFragDataLocation"] = _emscripten_glGetFragDataLocation;
function _emscripten_glGetVertexAttribIiv(index, pname, params) {
 emscriptenWebGLGetVertexAttrib(index, pname, params, "Integer");
}
Module["_emscripten_glGetVertexAttribIiv"] = _emscripten_glGetVertexAttribIiv;
function _emscripten_glGetVertexAttribIuiv(index, pname, params) {
 emscriptenWebGLGetVertexAttrib(index, pname, params, "Integer");
}
Module["_emscripten_glGetVertexAttribIuiv"] = _emscripten_glGetVertexAttribIuiv;
function _emscripten_glUniform1ui(location, v0) {
 location = GL.uniforms[location];
 GLctx.uniform1ui(location, v0);
}
Module["_emscripten_glUniform1ui"] = _emscripten_glUniform1ui;
function _emscripten_glUniform2ui(location, v0, v1) {
 location = GL.uniforms[location];
 GLctx.uniform2ui(location, v0, v1);
}
Module["_emscripten_glUniform2ui"] = _emscripten_glUniform2ui;
function _emscripten_glUniform3ui(location, v0, v1, v2) {
 location = GL.uniforms[location];
 GLctx.uniform3ui(location, v0, v1, v2);
}
Module["_emscripten_glUniform3ui"] = _emscripten_glUniform3ui;
function _emscripten_glUniform4ui(location, v0, v1, v2, v3) {
 location = GL.uniforms[location];
 GLctx.uniform4ui(location, v0, v1, v2, v3);
}
Module["_emscripten_glUniform4ui"] = _emscripten_glUniform4ui;
function _emscripten_glUniform1uiv(location, count, value) {
 location = GL.uniforms[location];
 value = HEAPU32.subarray(value >> 2, value + count * 4 >> 2);
 GLctx.uniform1uiv(location, value);
}
Module["_emscripten_glUniform1uiv"] = _emscripten_glUniform1uiv;
function _emscripten_glUniform2uiv(location, count, value) {
 location = GL.uniforms[location];
 count *= 2;
 value = HEAPU32.subarray(value >> 2, value + count * 4 >> 2);
 GLctx.uniform2uiv(location, value);
}
Module["_emscripten_glUniform2uiv"] = _emscripten_glUniform2uiv;
function _emscripten_glUniform3uiv(location, count, value) {
 location = GL.uniforms[location];
 count *= 3;
 value = HEAPU32.subarray(value >> 2, value + count * 4 >> 2);
 GLctx.uniform3uiv(location, value);
}
Module["_emscripten_glUniform3uiv"] = _emscripten_glUniform3uiv;
function _emscripten_glUniform4uiv(location, count, value) {
 location = GL.uniforms[location];
 count *= 4;
 value = HEAPU32.subarray(value >> 2, value + count * 4 >> 2);
 GLctx.uniform4uiv(location, value);
}
Module["_emscripten_glUniform4uiv"] = _emscripten_glUniform4uiv;
function _emscripten_glUniformMatrix2x3fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (6 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[6 * count - 1];
  for (var i = 0; i < 6 * count; i += 6) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
   view[i + 4] = HEAPF32[value + (4 * i + 16) >> 2];
   view[i + 5] = HEAPF32[value + (4 * i + 20) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 24 >> 2);
 }
 GLctx.uniformMatrix2x3fv(location, transpose, view);
}
Module["_emscripten_glUniformMatrix2x3fv"] = _emscripten_glUniformMatrix2x3fv;
function _emscripten_glUniformMatrix3x2fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (6 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[6 * count - 1];
  for (var i = 0; i < 6 * count; i += 6) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
   view[i + 4] = HEAPF32[value + (4 * i + 16) >> 2];
   view[i + 5] = HEAPF32[value + (4 * i + 20) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 24 >> 2);
 }
 GLctx.uniformMatrix3x2fv(location, transpose, view);
}
Module["_emscripten_glUniformMatrix3x2fv"] = _emscripten_glUniformMatrix3x2fv;
function _emscripten_glUniformMatrix2x4fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (8 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[8 * count - 1];
  for (var i = 0; i < 8 * count; i += 8) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
   view[i + 4] = HEAPF32[value + (4 * i + 16) >> 2];
   view[i + 5] = HEAPF32[value + (4 * i + 20) >> 2];
   view[i + 6] = HEAPF32[value + (4 * i + 24) >> 2];
   view[i + 7] = HEAPF32[value + (4 * i + 28) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 32 >> 2);
 }
 GLctx.uniformMatrix2x4fv(location, transpose, view);
}
Module["_emscripten_glUniformMatrix2x4fv"] = _emscripten_glUniformMatrix2x4fv;
function _emscripten_glUniformMatrix4x2fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (8 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[8 * count - 1];
  for (var i = 0; i < 8 * count; i += 8) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
   view[i + 4] = HEAPF32[value + (4 * i + 16) >> 2];
   view[i + 5] = HEAPF32[value + (4 * i + 20) >> 2];
   view[i + 6] = HEAPF32[value + (4 * i + 24) >> 2];
   view[i + 7] = HEAPF32[value + (4 * i + 28) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 32 >> 2);
 }
 GLctx.uniformMatrix4x2fv(location, transpose, view);
}
Module["_emscripten_glUniformMatrix4x2fv"] = _emscripten_glUniformMatrix4x2fv;
function _emscripten_glUniformMatrix3x4fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (12 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[12 * count - 1];
  for (var i = 0; i < 12 * count; i += 12) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
   view[i + 4] = HEAPF32[value + (4 * i + 16) >> 2];
   view[i + 5] = HEAPF32[value + (4 * i + 20) >> 2];
   view[i + 6] = HEAPF32[value + (4 * i + 24) >> 2];
   view[i + 7] = HEAPF32[value + (4 * i + 28) >> 2];
   view[i + 8] = HEAPF32[value + (4 * i + 32) >> 2];
   view[i + 9] = HEAPF32[value + (4 * i + 36) >> 2];
   view[i + 10] = HEAPF32[value + (4 * i + 40) >> 2];
   view[i + 11] = HEAPF32[value + (4 * i + 44) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 48 >> 2);
 }
 GLctx.uniformMatrix3x4fv(location, transpose, view);
}
Module["_emscripten_glUniformMatrix3x4fv"] = _emscripten_glUniformMatrix3x4fv;
function _emscripten_glUniformMatrix4x3fv(location, count, transpose, value) {
 location = GL.uniforms[location];
 var view;
 if (12 * count <= GL.MINI_TEMP_BUFFER_SIZE) {
  view = GL.miniTempBufferViews[12 * count - 1];
  for (var i = 0; i < 12 * count; i += 12) {
   view[i] = HEAPF32[value + 4 * i >> 2];
   view[i + 1] = HEAPF32[value + (4 * i + 4) >> 2];
   view[i + 2] = HEAPF32[value + (4 * i + 8) >> 2];
   view[i + 3] = HEAPF32[value + (4 * i + 12) >> 2];
   view[i + 4] = HEAPF32[value + (4 * i + 16) >> 2];
   view[i + 5] = HEAPF32[value + (4 * i + 20) >> 2];
   view[i + 6] = HEAPF32[value + (4 * i + 24) >> 2];
   view[i + 7] = HEAPF32[value + (4 * i + 28) >> 2];
   view[i + 8] = HEAPF32[value + (4 * i + 32) >> 2];
   view[i + 9] = HEAPF32[value + (4 * i + 36) >> 2];
   view[i + 10] = HEAPF32[value + (4 * i + 40) >> 2];
   view[i + 11] = HEAPF32[value + (4 * i + 44) >> 2];
  }
 } else {
  view = HEAPF32.subarray(value >> 2, value + count * 48 >> 2);
 }
 GLctx.uniformMatrix4x3fv(location, transpose, view);
}
Module["_emscripten_glUniformMatrix4x3fv"] = _emscripten_glUniformMatrix4x3fv;
function _emscripten_glVertexAttribI4iv(index, v) {
 v = HEAP32.subarray(v >> 2, v + 16 >> 2);
 GLctx.vertexAttribI4iv(index, v);
}
Module["_emscripten_glVertexAttribI4iv"] = _emscripten_glVertexAttribI4iv;
function _emscripten_glVertexAttribI4uiv(index, v) {
 v = HEAPU32.subarray(v >> 2, v + 16 >> 2);
 GLctx.vertexAttribI4uiv(index, v);
}
Module["_emscripten_glVertexAttribI4uiv"] = _emscripten_glVertexAttribI4uiv;
function _emscripten_glProgramParameteri(program, pname, value) {
 GL.recordError(1280);
}
Module["_emscripten_glProgramParameteri"] = _emscripten_glProgramParameteri;
function _emscripten_glGetProgramBinary(program, bufSize, length, binaryFormat, binary) {
 GL.recordError(1282);
}
Module["_emscripten_glGetProgramBinary"] = _emscripten_glGetProgramBinary;
function _emscripten_glProgramBinary(program, binaryFormat, binary, length) {
 GL.recordError(1280);
}
Module["_emscripten_glProgramBinary"] = _emscripten_glProgramBinary;
function _emscripten_glFramebufferTextureLayer(target, attachment, texture, level, layer) {
 GLctx.framebufferTextureLayer(target, attachment, GL.textures[texture], level, layer);
}
Module["_emscripten_glFramebufferTextureLayer"] = _emscripten_glFramebufferTextureLayer;
function _emscripten_glIsVertexArray(array) {
 var vao = GL.vaos[array];
 if (!vao) return 0;
 return GLctx["isVertexArray"](vao);
}
Module["_emscripten_glIsVertexArray"] = _emscripten_glIsVertexArray;
function _emscripten_glBegin() {
 throw "Legacy GL function (glBegin) called. If you want legacy GL emulation, you need to compile with -s LEGACY_GL_EMULATION=1 to enable legacy GL emulation.";
}
Module["_emscripten_glBegin"] = _emscripten_glBegin;
function _emscripten_glGenVertexArraysOES(n, arrays) {
 for (var i = 0; i < n; i++) {
  var vao = GLctx["createVertexArray"]();
  if (!vao) {
   GL.recordError(1282);
   while (i < n) HEAP32[arrays + i++ * 4 >> 2] = 0;
   return;
  }
  var id = GL.getNewId(GL.vaos);
  vao.name = id;
  GL.vaos[id] = vao;
  HEAP32[arrays + i * 4 >> 2] = id;
 }
}
Module["_emscripten_glGenVertexArraysOES"] = _emscripten_glGenVertexArraysOES;
function _emscripten_glDeleteVertexArraysOES(n, vaos) {
 for (var i = 0; i < n; i++) {
  var id = HEAP32[vaos + i * 4 >> 2];
  GLctx["deleteVertexArray"](GL.vaos[id]);
  GL.vaos[id] = null;
 }
}
Module["_emscripten_glDeleteVertexArraysOES"] = _emscripten_glDeleteVertexArraysOES;
function _emscripten_glBindVertexArrayOES(vao) {
 GLctx["bindVertexArray"](GL.vaos[vao]);
}
Module["_emscripten_glBindVertexArrayOES"] = _emscripten_glBindVertexArrayOES;
function _emscripten_gluPerspective(fov, aspect, near, far) {
 GLImmediate.matricesModified = true;
 GLImmediate.matrixVersion[GLImmediate.currentMatrix] = GLImmediate.matrixVersion[GLImmediate.currentMatrix] + 1 | 0;
 GLImmediate.matrix[GLImmediate.currentMatrix] = GLImmediate.matrixLib.mat4.perspective(fov, aspect, near, far, GLImmediate.matrix[GLImmediate.currentMatrix]);
}
Module["_emscripten_gluPerspective"] = _emscripten_gluPerspective;
function _emscripten_gluLookAt(ex, ey, ez, cx, cy, cz, ux, uy, uz) {
 GLImmediate.matricesModified = true;
 GLImmediate.matrixVersion[GLImmediate.currentMatrix] = GLImmediate.matrixVersion[GLImmediate.currentMatrix] + 1 | 0;
 GLImmediate.matrixLib.mat4.lookAt(GLImmediate.matrix[GLImmediate.currentMatrix], [ ex, ey, ez ], [ cx, cy, cz ], [ ux, uy, uz ]);
}
Module["_emscripten_gluLookAt"] = _emscripten_gluLookAt;
function _emscripten_gluProject(objX, objY, objZ, model, proj, view, winX, winY, winZ) {
 var inVec = new Float32Array(4);
 var outVec = new Float32Array(4);
 GLImmediate.matrixLib.mat4.multiplyVec4(HEAPF64.subarray(model >> 3, model + 128 >> 3), [ objX, objY, objZ, 1 ], outVec);
 GLImmediate.matrixLib.mat4.multiplyVec4(HEAPF64.subarray(proj >> 3, proj + 128 >> 3), outVec, inVec);
 if (inVec[3] == 0) {
  return 0;
 }
 inVec[0] /= inVec[3];
 inVec[1] /= inVec[3];
 inVec[2] /= inVec[3];
 inVec[0] = inVec[0] * .5 + .5;
 inVec[1] = inVec[1] * .5 + .5;
 inVec[2] = inVec[2] * .5 + .5;
 inVec[0] = inVec[0] * HEAP32[view + 8 >> 2] + HEAP32[view >> 2];
 inVec[1] = inVec[1] * HEAP32[view + 12 >> 2] + HEAP32[view + 4 >> 2];
 HEAPF64[winX >> 3] = inVec[0];
 HEAPF64[winY >> 3] = inVec[1];
 HEAPF64[winZ >> 3] = inVec[2];
 return 1;
}
Module["_emscripten_gluProject"] = _emscripten_gluProject;
function _emscripten_gluUnProject(winX, winY, winZ, model, proj, view, objX, objY, objZ) {
 var result = GLImmediate.matrixLib.mat4.unproject([ winX, winY, winZ ], HEAPF64.subarray(model >> 3, model + 128 >> 3), HEAPF64.subarray(proj >> 3, proj + 128 >> 3), HEAP32.subarray(view >> 2, view + 16 >> 2));
 if (result === null) {
  return 0;
 }
 HEAPF64[objX >> 3] = result[0];
 HEAPF64[objY >> 3] = result[1];
 HEAPF64[objZ >> 3] = result[2];
 return 1;
}
Module["_emscripten_gluUnProject"] = _emscripten_gluUnProject;
function _emscripten_gluOrtho2D(left, right, bottom, top) {
 _glOrtho(left, right, bottom, top, -1, 1);
}
Module["_emscripten_gluOrtho2D"] = _emscripten_gluOrtho2D;
function _emscripten_glVertexAttribIPointer(index, size, type, stride, ptr) {
 GLctx.vertexAttribIPointer(index, size, type, stride, ptr);
}
Module["_emscripten_glVertexAttribIPointer"] = _emscripten_glVertexAttribIPointer;
function _emscripten_glVertexAttribDivisorNV(index, divisor) {
 GLctx["vertexAttribDivisor"](index, divisor);
}
Module["_emscripten_glVertexAttribDivisorNV"] = _emscripten_glVertexAttribDivisorNV;
function _emscripten_glDrawArraysInstancedNV(mode, first, count, primcount) {
 GLctx["drawArraysInstanced"](mode, first, count, primcount);
}
Module["_emscripten_glDrawArraysInstancedNV"] = _emscripten_glDrawArraysInstancedNV;
function _emscripten_glDrawElementsInstancedNV(mode, count, type, indices, primcount) {
 GLctx["drawElementsInstanced"](mode, count, type, indices, primcount);
}
Module["_emscripten_glDrawElementsInstancedNV"] = _emscripten_glDrawElementsInstancedNV;
function _emscripten_glVertexAttribDivisorEXT(index, divisor) {
 GLctx["vertexAttribDivisor"](index, divisor);
}
Module["_emscripten_glVertexAttribDivisorEXT"] = _emscripten_glVertexAttribDivisorEXT;
function _emscripten_glDrawArraysInstancedEXT(mode, first, count, primcount) {
 GLctx["drawArraysInstanced"](mode, first, count, primcount);
}
Module["_emscripten_glDrawArraysInstancedEXT"] = _emscripten_glDrawArraysInstancedEXT;
function _emscripten_glDrawElementsInstancedEXT(mode, count, type, indices, primcount) {
 GLctx["drawElementsInstanced"](mode, count, type, indices, primcount);
}
Module["_emscripten_glDrawElementsInstancedEXT"] = _emscripten_glDrawElementsInstancedEXT;
function _emscripten_glVertexAttribDivisorARB(index, divisor) {
 GLctx["vertexAttribDivisor"](index, divisor);
}
Module["_emscripten_glVertexAttribDivisorARB"] = _emscripten_glVertexAttribDivisorARB;
function _emscripten_glDrawArraysInstancedARB(mode, first, count, primcount) {
 GLctx["drawArraysInstanced"](mode, first, count, primcount);
}
Module["_emscripten_glDrawArraysInstancedARB"] = _emscripten_glDrawArraysInstancedARB;
function _emscripten_glDrawElementsInstancedARB(mode, count, type, indices, primcount) {
 GLctx["drawElementsInstanced"](mode, count, type, indices, primcount);
}
Module["_emscripten_glDrawElementsInstancedARB"] = _emscripten_glDrawElementsInstancedARB;
function _emscripten_glVertexAttribDivisorANGLE(index, divisor) {
 GLctx["vertexAttribDivisor"](index, divisor);
}
Module["_emscripten_glVertexAttribDivisorANGLE"] = _emscripten_glVertexAttribDivisorANGLE;
function _emscripten_glDrawArraysInstancedANGLE(mode, first, count, primcount) {
 GLctx["drawArraysInstanced"](mode, first, count, primcount);
}
Module["_emscripten_glDrawArraysInstancedANGLE"] = _emscripten_glDrawArraysInstancedANGLE;
function _emscripten_glDrawElementsInstancedANGLE(mode, count, type, indices, primcount) {
 GLctx["drawElementsInstanced"](mode, count, type, indices, primcount);
}
Module["_emscripten_glDrawElementsInstancedANGLE"] = _emscripten_glDrawElementsInstancedANGLE;
function _emscripten_glDrawBuffersEXT(n, bufs) {
 var bufArray = [];
 for (var i = 0; i < n; i++) bufArray.push(HEAP32[bufs + i * 4 >> 2]);
 if (n == 0) {
  if (GLctx.getParameter(GLctx["DRAW_FRAMEBUFFER_BINDING"]) != 0) bufArray.push(GLctx["NONE"]); else {
   GL.recordError(1282);
   return;
  }
 }
 GLctx["drawBuffers"](bufArray);
}
Module["_emscripten_glDrawBuffersEXT"] = _emscripten_glDrawBuffersEXT;
function _emscripten_glEndTransformFeedback() {
 GLctx.endTransformFeedback();
}
Module["_emscripten_glEndTransformFeedback"] = _emscripten_glEndTransformFeedback;
function _emscripten_glPauseTransformFeedback() {
 GLctx.pauseTransformFeedback();
}
Module["_emscripten_glPauseTransformFeedback"] = _emscripten_glPauseTransformFeedback;
function _emscripten_glResumeTransformFeedback() {
 GLctx.resumeTransformFeedback();
}
Module["_emscripten_glResumeTransformFeedback"] = _emscripten_glResumeTransformFeedback;
function _emscripten_glBeginTransformFeedback(x0) {
 GLctx.beginTransformFeedback(x0);
}
Module["_emscripten_glBeginTransformFeedback"] = _emscripten_glBeginTransformFeedback;
function _emscripten_glReadBuffer(x0) {
 GLctx.readBuffer(x0);
}
Module["_emscripten_glReadBuffer"] = _emscripten_glReadBuffer;
function _emscripten_glEndQuery(x0) {
 GLctx.endQuery(x0);
}
Module["_emscripten_glEndQuery"] = _emscripten_glEndQuery;
function _emscripten_glClearBufferfi(x0, x1, x2, x3) {
 GLctx.clearBufferfi(x0, x1, x2, x3);
}
Module["_emscripten_glClearBufferfi"] = _emscripten_glClearBufferfi;
function _emscripten_glVertexAttribI4i(x0, x1, x2, x3, x4) {
 GLctx.vertexAttribI4i(x0, x1, x2, x3, x4);
}
Module["_emscripten_glVertexAttribI4i"] = _emscripten_glVertexAttribI4i;
function _emscripten_glVertexAttribI4ui(x0, x1, x2, x3, x4) {
 GLctx.vertexAttribI4ui(x0, x1, x2, x3, x4);
}
Module["_emscripten_glVertexAttribI4ui"] = _emscripten_glVertexAttribI4ui;
function _emscripten_glCopyBufferSubData(x0, x1, x2, x3, x4) {
 GLctx.copyBufferSubData(x0, x1, x2, x3, x4);
}
Module["_emscripten_glCopyBufferSubData"] = _emscripten_glCopyBufferSubData;
function _emscripten_glTexStorage2D(x0, x1, x2, x3, x4) {
 GLctx.texStorage2D(x0, x1, x2, x3, x4);
}
Module["_emscripten_glTexStorage2D"] = _emscripten_glTexStorage2D;
function _emscripten_glRenderbufferStorageMultisample(x0, x1, x2, x3, x4) {
 GLctx.renderbufferStorageMultisample(x0, x1, x2, x3, x4);
}
Module["_emscripten_glRenderbufferStorageMultisample"] = _emscripten_glRenderbufferStorageMultisample;
function _emscripten_glTexStorage3D(x0, x1, x2, x3, x4, x5) {
 GLctx.texStorage3D(x0, x1, x2, x3, x4, x5);
}
Module["_emscripten_glTexStorage3D"] = _emscripten_glTexStorage3D;
function _emscripten_glCopyTexSubImage3D(x0, x1, x2, x3, x4, x5, x6, x7, x8) {
 GLctx.copyTexSubImage3D(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
Module["_emscripten_glCopyTexSubImage3D"] = _emscripten_glCopyTexSubImage3D;
function _emscripten_glBlitFramebuffer(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9) {
 GLctx.blitFramebuffer(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9);
}
Module["_emscripten_glBlitFramebuffer"] = _emscripten_glBlitFramebuffer;
var GLUT = {
 initTime: null,
 idleFunc: null,
 displayFunc: null,
 keyboardFunc: null,
 keyboardUpFunc: null,
 specialFunc: null,
 specialUpFunc: null,
 reshapeFunc: null,
 motionFunc: null,
 passiveMotionFunc: null,
 mouseFunc: null,
 buttons: 0,
 modifiers: 0,
 initWindowWidth: 256,
 initWindowHeight: 256,
 initDisplayMode: 18,
 windowX: 0,
 windowY: 0,
 windowWidth: 0,
 windowHeight: 0,
 requestedAnimationFrame: false,
 saveModifiers: (function(event) {
  GLUT.modifiers = 0;
  if (event["shiftKey"]) GLUT.modifiers += 1;
  if (event["ctrlKey"]) GLUT.modifiers += 2;
  if (event["altKey"]) GLUT.modifiers += 4;
 }),
 onMousemove: (function(event) {
  var lastX = Browser.mouseX;
  var lastY = Browser.mouseY;
  Browser.calculateMouseEvent(event);
  var newX = Browser.mouseX;
  var newY = Browser.mouseY;
  if (newX == lastX && newY == lastY) return;
  if (GLUT.buttons == 0 && event.target == Module["canvas"] && GLUT.passiveMotionFunc) {
   event.preventDefault();
   GLUT.saveModifiers(event);
   Runtime.dynCall("vii", GLUT.passiveMotionFunc, [ lastX, lastY ]);
  } else if (GLUT.buttons != 0 && GLUT.motionFunc) {
   event.preventDefault();
   GLUT.saveModifiers(event);
   Runtime.dynCall("vii", GLUT.motionFunc, [ lastX, lastY ]);
  }
 }),
 getSpecialKey: (function(keycode) {
  var key = null;
  switch (keycode) {
  case 8:
   key = 120;
   break;
  case 46:
   key = 111;
   break;
  case 112:
   key = 1;
   break;
  case 113:
   key = 2;
   break;
  case 114:
   key = 3;
   break;
  case 115:
   key = 4;
   break;
  case 116:
   key = 5;
   break;
  case 117:
   key = 6;
   break;
  case 118:
   key = 7;
   break;
  case 119:
   key = 8;
   break;
  case 120:
   key = 9;
   break;
  case 121:
   key = 10;
   break;
  case 122:
   key = 11;
   break;
  case 123:
   key = 12;
   break;
  case 37:
   key = 100;
   break;
  case 38:
   key = 101;
   break;
  case 39:
   key = 102;
   break;
  case 40:
   key = 103;
   break;
  case 33:
   key = 104;
   break;
  case 34:
   key = 105;
   break;
  case 36:
   key = 106;
   break;
  case 35:
   key = 107;
   break;
  case 45:
   key = 108;
   break;
  case 16:
  case 5:
   key = 112;
   break;
  case 6:
   key = 113;
   break;
  case 17:
  case 3:
   key = 114;
   break;
  case 4:
   key = 115;
   break;
  case 18:
  case 2:
   key = 116;
   break;
  case 1:
   key = 117;
   break;
  }
  return key;
 }),
 getASCIIKey: (function(event) {
  if (event["ctrlKey"] || event["altKey"] || event["metaKey"]) return null;
  var keycode = event["keyCode"];
  if (48 <= keycode && keycode <= 57) return keycode;
  if (65 <= keycode && keycode <= 90) return event["shiftKey"] ? keycode : keycode + 32;
  if (96 <= keycode && keycode <= 105) return keycode - 48;
  if (106 <= keycode && keycode <= 111) return keycode - 106 + 42;
  switch (keycode) {
  case 9:
  case 13:
  case 27:
  case 32:
  case 61:
   return keycode;
  }
  var s = event["shiftKey"];
  switch (keycode) {
  case 186:
   return s ? 58 : 59;
  case 187:
   return s ? 43 : 61;
  case 188:
   return s ? 60 : 44;
  case 189:
   return s ? 95 : 45;
  case 190:
   return s ? 62 : 46;
  case 191:
   return s ? 63 : 47;
  case 219:
   return s ? 123 : 91;
  case 220:
   return s ? 124 : 47;
  case 221:
   return s ? 125 : 93;
  case 222:
   return s ? 34 : 39;
  }
  return null;
 }),
 onKeydown: (function(event) {
  if (GLUT.specialFunc || GLUT.keyboardFunc) {
   var key = GLUT.getSpecialKey(event["keyCode"]);
   if (key !== null) {
    if (GLUT.specialFunc) {
     event.preventDefault();
     GLUT.saveModifiers(event);
     Runtime.dynCall("viii", GLUT.specialFunc, [ key, Browser.mouseX, Browser.mouseY ]);
    }
   } else {
    key = GLUT.getASCIIKey(event);
    if (key !== null && GLUT.keyboardFunc) {
     event.preventDefault();
     GLUT.saveModifiers(event);
     Runtime.dynCall("viii", GLUT.keyboardFunc, [ key, Browser.mouseX, Browser.mouseY ]);
    }
   }
  }
 }),
 onKeyup: (function(event) {
  if (GLUT.specialUpFunc || GLUT.keyboardUpFunc) {
   var key = GLUT.getSpecialKey(event["keyCode"]);
   if (key !== null) {
    if (GLUT.specialUpFunc) {
     event.preventDefault();
     GLUT.saveModifiers(event);
     Runtime.dynCall("viii", GLUT.specialUpFunc, [ key, Browser.mouseX, Browser.mouseY ]);
    }
   } else {
    key = GLUT.getASCIIKey(event);
    if (key !== null && GLUT.keyboardUpFunc) {
     event.preventDefault();
     GLUT.saveModifiers(event);
     Runtime.dynCall("viii", GLUT.keyboardUpFunc, [ key, Browser.mouseX, Browser.mouseY ]);
    }
   }
  }
 }),
 onMouseButtonDown: (function(event) {
  Browser.calculateMouseEvent(event);
  GLUT.buttons |= 1 << event["button"];
  if (event.target == Module["canvas"] && GLUT.mouseFunc) {
   try {
    event.target.setCapture();
   } catch (e) {}
   event.preventDefault();
   GLUT.saveModifiers(event);
   Runtime.dynCall("viiii", GLUT.mouseFunc, [ event["button"], 0, Browser.mouseX, Browser.mouseY ]);
  }
 }),
 onMouseButtonUp: (function(event) {
  Browser.calculateMouseEvent(event);
  GLUT.buttons &= ~(1 << event["button"]);
  if (GLUT.mouseFunc) {
   event.preventDefault();
   GLUT.saveModifiers(event);
   Runtime.dynCall("viiii", GLUT.mouseFunc, [ event["button"], 1, Browser.mouseX, Browser.mouseY ]);
  }
 }),
 onMouseWheel: (function(event) {
  Browser.calculateMouseEvent(event);
  var e = window.event || event;
  var delta = -Browser.getMouseWheelDelta(event);
  delta = delta == 0 ? 0 : delta > 0 ? Math.max(delta, 1) : Math.min(delta, -1);
  var button = 3;
  if (delta < 0) {
   button = 4;
  }
  if (GLUT.mouseFunc) {
   event.preventDefault();
   GLUT.saveModifiers(event);
   Runtime.dynCall("viiii", GLUT.mouseFunc, [ button, 0, Browser.mouseX, Browser.mouseY ]);
  }
 }),
 onFullscreenEventChange: (function(event) {
  var width;
  var height;
  if (document["fullscreen"] || document["fullScreen"] || document["mozFullScreen"] || document["webkitIsFullScreen"]) {
   width = screen["width"];
   height = screen["height"];
  } else {
   width = GLUT.windowWidth;
   height = GLUT.windowHeight;
   document.removeEventListener("fullscreenchange", GLUT.onFullscreenEventChange, true);
   document.removeEventListener("mozfullscreenchange", GLUT.onFullscreenEventChange, true);
   document.removeEventListener("webkitfullscreenchange", GLUT.onFullscreenEventChange, true);
  }
  Browser.setCanvasSize(width, height);
  if (GLUT.reshapeFunc) {
   Runtime.dynCall("vii", GLUT.reshapeFunc, [ width, height ]);
  }
  _glutPostRedisplay();
 }),
 requestFullscreen: (function() {
  Browser.requestFullscreen(false, false);
 }),
 requestFullScreen: (function() {
  Module.printErr("GLUT.requestFullScreen() is deprecated. Please call GLUT.requestFullscreen instead.");
  GLUT.requestFullScreen = (function() {
   return GLUT.requestFullscreen();
  });
  return GLUT.requestFullscreen();
 }),
 exitFullscreen: (function() {
  var CFS = document["exitFullscreen"] || document["cancelFullScreen"] || document["mozCancelFullScreen"] || document["webkitCancelFullScreen"] || (function() {});
  CFS.apply(document, []);
 }),
 cancelFullScreen: (function() {
  Module.printErr("GLUT.cancelFullScreen() is deprecated. Please call GLUT.exitFullscreen instead.");
  GLUT.cancelFullScreen = (function() {
   return GLUT.exitFullscreen();
  });
  return GLUT.exitFullscreen();
 })
};
Module["GLUT"] = GLUT;
function _glutGetModifiers() {
 return GLUT.modifiers;
}
Module["_glutGetModifiers"] = _glutGetModifiers;
function _glutInit(argcp, argv) {
 GLUT.initTime = Date.now();
 var isTouchDevice = "ontouchstart" in document.documentElement;
 window.addEventListener("keydown", GLUT.onKeydown, true);
 window.addEventListener("keyup", GLUT.onKeyup, true);
 if (isTouchDevice) {
  window.addEventListener("touchmove", GLUT.onMousemove, true);
  window.addEventListener("touchstart", GLUT.onMouseButtonDown, true);
  window.addEventListener("touchend", GLUT.onMouseButtonUp, true);
 } else {
  window.addEventListener("mousemove", GLUT.onMousemove, true);
  window.addEventListener("mousedown", GLUT.onMouseButtonDown, true);
  window.addEventListener("mouseup", GLUT.onMouseButtonUp, true);
  window.addEventListener("mousewheel", GLUT.onMouseWheel, true);
  window.addEventListener("DOMMouseScroll", GLUT.onMouseWheel, true);
 }
 Browser.resizeListeners.push((function(width, height) {
  if (GLUT.reshapeFunc) {
   Runtime.dynCall("vii", GLUT.reshapeFunc, [ width, height ]);
  }
 }));
 __ATEXIT__.push((function() {
  window.removeEventListener("keydown", GLUT.onKeydown, true);
  window.removeEventListener("keyup", GLUT.onKeyup, true);
  if (isTouchDevice) {
   window.removeEventListener("touchmove", GLUT.onMousemove, true);
   window.removeEventListener("touchstart", GLUT.onMouseButtonDown, true);
   window.removeEventListener("touchend", GLUT.onMouseButtonUp, true);
  } else {
   window.removeEventListener("mousemove", GLUT.onMousemove, true);
   window.removeEventListener("mousedown", GLUT.onMouseButtonDown, true);
   window.removeEventListener("mouseup", GLUT.onMouseButtonUp, true);
   window.removeEventListener("mousewheel", GLUT.onMouseWheel, true);
   window.removeEventListener("DOMMouseScroll", GLUT.onMouseWheel, true);
  }
  Module["canvas"].width = Module["canvas"].height = 1;
 }));
}
Module["_glutInit"] = _glutInit;
function _glutInitWindowSize(width, height) {
 Browser.setCanvasSize(GLUT.initWindowWidth = width, GLUT.initWindowHeight = height);
}
Module["_glutInitWindowSize"] = _glutInitWindowSize;
function _glutInitWindowPosition(x, y) {}
Module["_glutInitWindowPosition"] = _glutInitWindowPosition;
function _glutGet(type) {
 switch (type) {
 case 100:
  return 0;
 case 101:
  return 0;
 case 102:
  return Module["canvas"].width;
 case 103:
  return Module["canvas"].height;
 case 200:
  return Module["canvas"].width;
 case 201:
  return Module["canvas"].height;
 case 500:
  return 0;
 case 501:
  return 0;
 case 502:
  return GLUT.initWindowWidth;
 case 503:
  return GLUT.initWindowHeight;
 case 700:
  var now = Date.now();
  return now - GLUT.initTime;
 default:
  throw "glutGet(" + type + ") not implemented yet";
 }
}
Module["_glutGet"] = _glutGet;
function _glutIdleFunc(func) {
 function callback() {
  if (GLUT.idleFunc) {
   Runtime.dynCall("v", GLUT.idleFunc);
   Browser.safeSetTimeout(callback, 4);
  }
 }
 if (!GLUT.idleFunc) {
  Browser.safeSetTimeout(callback, 0);
 }
 GLUT.idleFunc = func;
}
Module["_glutIdleFunc"] = _glutIdleFunc;
function _glutTimerFunc(msec, func, value) {
 Browser.safeSetTimeout((function() {
  Runtime.dynCall("vi", func, [ value ]);
 }), msec);
}
Module["_glutTimerFunc"] = _glutTimerFunc;
function _glutDisplayFunc(func) {
 GLUT.displayFunc = func;
}
Module["_glutDisplayFunc"] = _glutDisplayFunc;
function _glutKeyboardFunc(func) {
 GLUT.keyboardFunc = func;
}
Module["_glutKeyboardFunc"] = _glutKeyboardFunc;
function _glutKeyboardUpFunc(func) {
 GLUT.keyboardUpFunc = func;
}
Module["_glutKeyboardUpFunc"] = _glutKeyboardUpFunc;
function _glutSpecialFunc(func) {
 GLUT.specialFunc = func;
}
Module["_glutSpecialFunc"] = _glutSpecialFunc;
function _glutSpecialUpFunc(func) {
 GLUT.specialUpFunc = func;
}
Module["_glutSpecialUpFunc"] = _glutSpecialUpFunc;
function _glutReshapeFunc(func) {
 GLUT.reshapeFunc = func;
}
Module["_glutReshapeFunc"] = _glutReshapeFunc;
function _glutMotionFunc(func) {
 GLUT.motionFunc = func;
}
Module["_glutMotionFunc"] = _glutMotionFunc;
function _glutPassiveMotionFunc(func) {
 GLUT.passiveMotionFunc = func;
}
Module["_glutPassiveMotionFunc"] = _glutPassiveMotionFunc;
function _glutMouseFunc(func) {
 GLUT.mouseFunc = func;
}
Module["_glutMouseFunc"] = _glutMouseFunc;
function _glutSetCursor(cursor) {
 var cursorStyle = "auto";
 switch (cursor) {
 case 0:
  break;
 case 1:
  break;
 case 2:
  cursorStyle = "pointer";
  break;
 case 3:
  break;
 case 4:
  cursorStyle = "help";
  break;
 case 5:
  break;
 case 6:
  break;
 case 7:
  cursorStyle = "wait";
  break;
 case 8:
  cursorStyle = "text";
  break;
 case 9:
 case 102:
  cursorStyle = "crosshair";
  break;
 case 10:
  cursorStyle = "ns-resize";
  break;
 case 11:
  cursorStyle = "ew-resize";
  break;
 case 12:
  cursorStyle = "n-resize";
  break;
 case 13:
  cursorStyle = "s-resize";
  break;
 case 14:
  cursorStyle = "w-resize";
  break;
 case 15:
  cursorStyle = "e-resize";
  break;
 case 16:
  cursorStyle = "nw-resize";
  break;
 case 17:
  cursorStyle = "ne-resize";
  break;
 case 18:
  cursorStyle = "se-resize";
  break;
 case 19:
  cursorStyle = "sw-resize";
  break;
 case 100:
  break;
 case 101:
  cursorStyle = "none";
  break;
 default:
  throw "glutSetCursor: Unknown cursor type: " + cursor;
 }
 Module["canvas"].style.cursor = cursorStyle;
}
Module["_glutSetCursor"] = _glutSetCursor;
function _glutCreateWindow(name) {
 var contextAttributes = {
  antialias: (GLUT.initDisplayMode & 128) != 0,
  depth: (GLUT.initDisplayMode & 16) != 0,
  stencil: (GLUT.initDisplayMode & 32) != 0,
  alpha: (GLUT.initDisplayMode & 8) != 0
 };
 Module.ctx = Browser.createContext(Module["canvas"], true, true, contextAttributes);
 return Module.ctx ? 1 : 0;
}
Module["_glutCreateWindow"] = _glutCreateWindow;
function _glutDestroyWindow(name) {
 Module.ctx = Browser.destroyContext(Module["canvas"], true, true);
 return 1;
}
Module["_glutDestroyWindow"] = _glutDestroyWindow;
function _glutPostRedisplay() {
 if (GLUT.displayFunc && !GLUT.requestedAnimationFrame) {
  GLUT.requestedAnimationFrame = true;
  Browser.requestAnimationFrame((function() {
   GLUT.requestedAnimationFrame = false;
   Browser.mainLoop.runIter((function() {
    Runtime.dynCall("v", GLUT.displayFunc);
   }));
  }));
 }
}
Module["_glutPostRedisplay"] = _glutPostRedisplay;
function _glutReshapeWindow(width, height) {
 GLUT.exitFullscreen();
 Browser.setCanvasSize(width, height);
 if (GLUT.reshapeFunc) {
  Runtime.dynCall("vii", GLUT.reshapeFunc, [ width, height ]);
 }
 _glutPostRedisplay();
}
Module["_glutReshapeWindow"] = _glutReshapeWindow;
function _glutPositionWindow(x, y) {
 GLUT.exitFullscreen();
 _glutPostRedisplay();
}
Module["_glutPositionWindow"] = _glutPositionWindow;
function _glutFullScreen() {
 GLUT.windowX = 0;
 GLUT.windowY = 0;
 GLUT.windowWidth = Module["canvas"].width;
 GLUT.windowHeight = Module["canvas"].height;
 document.addEventListener("fullscreenchange", GLUT.onFullscreenEventChange, true);
 document.addEventListener("mozfullscreenchange", GLUT.onFullscreenEventChange, true);
 document.addEventListener("webkitfullscreenchange", GLUT.onFullscreenEventChange, true);
 GLUT.requestFullscreen();
}
Module["_glutFullScreen"] = _glutFullScreen;
function _glutInitDisplayMode(mode) {
 GLUT.initDisplayMode = mode;
}
Module["_glutInitDisplayMode"] = _glutInitDisplayMode;
function _glutSwapBuffers() {}
Module["_glutSwapBuffers"] = _glutSwapBuffers;
function _glutMainLoop() {
 _glutReshapeWindow(Module["canvas"].width, Module["canvas"].height);
 _glutPostRedisplay();
 throw "SimulateInfiniteLoop";
}
Module["_glutMainLoop"] = _glutMainLoop;
function _XOpenDisplay() {
 return 1;
}
Module["_XOpenDisplay"] = _XOpenDisplay;
function _XCreateWindow(display, parent, x, y, width, height, border_width, depth, class_, visual, valuemask, attributes) {
 Browser.setCanvasSize(width, height);
 return 2;
}
Module["_XCreateWindow"] = _XCreateWindow;
function _XChangeWindowAttributes() {}
Module["_XChangeWindowAttributes"] = _XChangeWindowAttributes;
function _XSetWMHints() {}
Module["_XSetWMHints"] = _XSetWMHints;
function _XMapWindow() {}
Module["_XMapWindow"] = _XMapWindow;
function _XStoreName() {}
Module["_XStoreName"] = _XStoreName;
function _XInternAtom(display, name_, hmm) {
 return 0;
}
Module["_XInternAtom"] = _XInternAtom;
function _XSendEvent() {}
Module["_XSendEvent"] = _XSendEvent;
function _XPending(display) {
 return 0;
}
Module["_XPending"] = _XPending;
var EGL = {
 errorCode: 12288,
 defaultDisplayInitialized: false,
 currentContext: 0,
 currentReadSurface: 0,
 currentDrawSurface: 0,
 stringCache: {},
 setErrorCode: (function(code) {
  EGL.errorCode = code;
 }),
 chooseConfig: (function(display, attribList, config, config_size, numConfigs) {
  if (display != 62e3) {
   EGL.setErrorCode(12296);
   return 0;
  }
  if ((!config || !config_size) && !numConfigs) {
   EGL.setErrorCode(12300);
   return 0;
  }
  if (numConfigs) {
   HEAP32[numConfigs >> 2] = 1;
  }
  if (config && config_size > 0) {
   HEAP32[config >> 2] = 62002;
  }
  EGL.setErrorCode(12288);
  return 1;
 })
};
Module["EGL"] = EGL;
function _eglWaitClient() {
 EGL.setErrorCode(12288);
 return 1;
}
Module["_eglWaitClient"] = _eglWaitClient;
function _eglGetDisplay(nativeDisplayType) {
 EGL.setErrorCode(12288);
 return 62e3;
}
Module["_eglGetDisplay"] = _eglGetDisplay;
function _eglInitialize(display, majorVersion, minorVersion) {
 if (display == 62e3) {
  if (majorVersion) {
   HEAP32[majorVersion >> 2] = 1;
  }
  if (minorVersion) {
   HEAP32[minorVersion >> 2] = 4;
  }
  EGL.defaultDisplayInitialized = true;
  EGL.setErrorCode(12288);
  return 1;
 } else {
  EGL.setErrorCode(12296);
  return 0;
 }
}
Module["_eglInitialize"] = _eglInitialize;
function _eglTerminate(display) {
 if (display != 62e3) {
  EGL.setErrorCode(12296);
  return 0;
 }
 EGL.currentContext = 0;
 EGL.currentReadSurface = 0;
 EGL.currentDrawSurface = 0;
 EGL.defaultDisplayInitialized = false;
 EGL.setErrorCode(12288);
 return 1;
}
Module["_eglTerminate"] = _eglTerminate;
function _eglGetConfigs(display, configs, config_size, numConfigs) {
 return EGL.chooseConfig(display, 0, configs, config_size, numConfigs);
}
Module["_eglGetConfigs"] = _eglGetConfigs;
function _eglChooseConfig(display, attrib_list, configs, config_size, numConfigs) {
 return EGL.chooseConfig(display, attrib_list, configs, config_size, numConfigs);
}
Module["_eglChooseConfig"] = _eglChooseConfig;
function _eglGetConfigAttrib(display, config, attribute, value) {
 if (display != 62e3) {
  EGL.setErrorCode(12296);
  return 0;
 }
 if (config != 62002) {
  EGL.setErrorCode(12293);
  return 0;
 }
 if (!value) {
  EGL.setErrorCode(12300);
  return 0;
 }
 EGL.setErrorCode(12288);
 switch (attribute) {
 case 12320:
  HEAP32[value >> 2] = 32;
  return 1;
 case 12321:
  HEAP32[value >> 2] = 8;
  return 1;
 case 12322:
  HEAP32[value >> 2] = 8;
  return 1;
 case 12323:
  HEAP32[value >> 2] = 8;
  return 1;
 case 12324:
  HEAP32[value >> 2] = 8;
  return 1;
 case 12325:
  HEAP32[value >> 2] = 24;
  return 1;
 case 12326:
  HEAP32[value >> 2] = 8;
  return 1;
 case 12327:
  HEAP32[value >> 2] = 12344;
  return 1;
 case 12328:
  HEAP32[value >> 2] = 62002;
  return 1;
 case 12329:
  HEAP32[value >> 2] = 0;
  return 1;
 case 12330:
  HEAP32[value >> 2] = 4096;
  return 1;
 case 12331:
  HEAP32[value >> 2] = 16777216;
  return 1;
 case 12332:
  HEAP32[value >> 2] = 4096;
  return 1;
 case 12333:
  HEAP32[value >> 2] = 0;
  return 1;
 case 12334:
  HEAP32[value >> 2] = 0;
  return 1;
 case 12335:
  HEAP32[value >> 2] = 12344;
  return 1;
 case 12337:
  HEAP32[value >> 2] = 4;
  return 1;
 case 12338:
  HEAP32[value >> 2] = 1;
  return 1;
 case 12339:
  HEAP32[value >> 2] = 4;
  return 1;
 case 12340:
  HEAP32[value >> 2] = 12344;
  return 1;
 case 12341:
 case 12342:
 case 12343:
  HEAP32[value >> 2] = -1;
  return 1;
 case 12345:
 case 12346:
  HEAP32[value >> 2] = 0;
  return 1;
 case 12347:
 case 12348:
  HEAP32[value >> 2] = 1;
  return 1;
 case 12349:
 case 12350:
  HEAP32[value >> 2] = 0;
  return 1;
 case 12351:
  HEAP32[value >> 2] = 12430;
  return 1;
 case 12352:
  HEAP32[value >> 2] = 4;
  return 1;
 case 12354:
  HEAP32[value >> 2] = 0;
  return 1;
 default:
  EGL.setErrorCode(12292);
  return 0;
 }
}
Module["_eglGetConfigAttrib"] = _eglGetConfigAttrib;
function _eglCreateWindowSurface(display, config, win, attrib_list) {
 if (display != 62e3) {
  EGL.setErrorCode(12296);
  return 0;
 }
 if (config != 62002) {
  EGL.setErrorCode(12293);
  return 0;
 }
 EGL.setErrorCode(12288);
 return 62006;
}
Module["_eglCreateWindowSurface"] = _eglCreateWindowSurface;
function _eglDestroySurface(display, surface) {
 if (display != 62e3) {
  EGL.setErrorCode(12296);
  return 0;
 }
 if (surface != 62006) {
  EGL.setErrorCode(12301);
  return 1;
 }
 if (EGL.currentReadSurface == surface) {
  EGL.currentReadSurface = 0;
 }
 if (EGL.currentDrawSurface == surface) {
  EGL.currentDrawSurface = 0;
 }
 EGL.setErrorCode(12288);
 return 1;
}
Module["_eglDestroySurface"] = _eglDestroySurface;
function _eglCreateContext(display, config, hmm, contextAttribs) {
 if (display != 62e3) {
  EGL.setErrorCode(12296);
  return 0;
 }
 var glesContextVersion = 1;
 for (;;) {
  var param = HEAP32[contextAttribs >> 2];
  if (param == 12440) {
   glesContextVersion = HEAP32[contextAttribs + 4 >> 2];
  } else if (param == 12344) {
   break;
  } else {
   EGL.setErrorCode(12292);
   return 0;
  }
  contextAttribs += 8;
 }
 if (glesContextVersion != 2) {
  EGL.setErrorCode(12293);
  return 0;
 }
 _glutInitDisplayMode(178);
 EGL.windowID = _glutCreateWindow();
 if (EGL.windowID != 0) {
  EGL.setErrorCode(12288);
  return 62004;
 } else {
  EGL.setErrorCode(12297);
  return 0;
 }
}
Module["_eglCreateContext"] = _eglCreateContext;
function _eglDestroyContext(display, context) {
 if (display != 62e3) {
  EGL.setErrorCode(12296);
  return 0;
 }
 if (context != 62004) {
  EGL.setErrorCode(12294);
  return 0;
 }
 EGL.setErrorCode(12288);
 return 1;
}
Module["_eglDestroyContext"] = _eglDestroyContext;
function _eglQuerySurface(display, surface, attribute, value) {
 if (display != 62e3) {
  EGL.setErrorCode(12296);
  return 0;
 }
 if (surface != 62006) {
  EGL.setErrorCode(12301);
  return 0;
 }
 if (!value) {
  EGL.setErrorCode(12300);
  return 0;
 }
 EGL.setErrorCode(12288);
 switch (attribute) {
 case 12328:
  HEAP32[value >> 2] = 62002;
  return 1;
 case 12376:
  return 1;
 case 12375:
  HEAP32[value >> 2] = Module.canvas.width;
  return 1;
 case 12374:
  HEAP32[value >> 2] = Module.canvas.height;
  return 1;
 case 12432:
  HEAP32[value >> 2] = -1;
  return 1;
 case 12433:
  HEAP32[value >> 2] = -1;
  return 1;
 case 12434:
  HEAP32[value >> 2] = -1;
  return 1;
 case 12422:
  HEAP32[value >> 2] = 12420;
  return 1;
 case 12441:
  HEAP32[value >> 2] = 12442;
  return 1;
 case 12435:
  HEAP32[value >> 2] = 12437;
  return 1;
 case 12416:
 case 12417:
 case 12418:
 case 12419:
  return 1;
 default:
  EGL.setErrorCode(12292);
  return 0;
 }
}
Module["_eglQuerySurface"] = _eglQuerySurface;
function _eglQueryContext(display, context, attribute, value) {
 if (display != 62e3) {
  EGL.setErrorCode(12296);
  return 0;
 }
 if (context != 62004) {
  EGL.setErrorCode(12294);
  return 0;
 }
 if (!value) {
  EGL.setErrorCode(12300);
  return 0;
 }
 EGL.setErrorCode(12288);
 switch (attribute) {
 case 12328:
  HEAP32[value >> 2] = 62002;
  return 1;
 case 12439:
  HEAP32[value >> 2] = 12448;
  return 1;
 case 12440:
  HEAP32[value >> 2] = 2;
  return 1;
 case 12422:
  HEAP32[value >> 2] = 12420;
  return 1;
 default:
  EGL.setErrorCode(12292);
  return 0;
 }
}
Module["_eglQueryContext"] = _eglQueryContext;
function _eglGetError() {
 return EGL.errorCode;
}
Module["_eglGetError"] = _eglGetError;
function _eglQueryString(display, name) {
 if (display != 62e3) {
  EGL.setErrorCode(12296);
  return 0;
 }
 EGL.setErrorCode(12288);
 if (EGL.stringCache[name]) return EGL.stringCache[name];
 var ret;
 switch (name) {
 case 12371:
  ret = allocate(intArrayFromString("Emscripten"), "i8", ALLOC_NORMAL);
  break;
 case 12372:
  ret = allocate(intArrayFromString("1.4 Emscripten EGL"), "i8", ALLOC_NORMAL);
  break;
 case 12373:
  ret = allocate(intArrayFromString(""), "i8", ALLOC_NORMAL);
  break;
 case 12429:
  ret = allocate(intArrayFromString("OpenGL_ES"), "i8", ALLOC_NORMAL);
  break;
 default:
  EGL.setErrorCode(12300);
  return 0;
 }
 EGL.stringCache[name] = ret;
 return ret;
}
Module["_eglQueryString"] = _eglQueryString;
function _eglBindAPI(api) {
 if (api == 12448) {
  EGL.setErrorCode(12288);
  return 1;
 } else {
  EGL.setErrorCode(12300);
  return 0;
 }
}
Module["_eglBindAPI"] = _eglBindAPI;
function _eglQueryAPI() {
 EGL.setErrorCode(12288);
 return 12448;
}
Module["_eglQueryAPI"] = _eglQueryAPI;
function _eglWaitNative(nativeEngineId) {
 EGL.setErrorCode(12288);
 return 1;
}
Module["_eglWaitNative"] = _eglWaitNative;
function _eglWaitGL() {
 return _eglWaitClient.apply(null, arguments);
}
Module["_eglWaitGL"] = _eglWaitGL;
function _eglSwapInterval(display, interval) {
 if (display != 62e3) {
  EGL.setErrorCode(12296);
  return 0;
 }
 if (interval == 0) _emscripten_set_main_loop_timing(0, 0); else _emscripten_set_main_loop_timing(1, interval);
 EGL.setErrorCode(12288);
 return 1;
}
Module["_eglSwapInterval"] = _eglSwapInterval;
function _eglMakeCurrent(display, draw, read, context) {
 if (display != 62e3) {
  EGL.setErrorCode(12296);
  return 0;
 }
 if (context != 0 && context != 62004) {
  EGL.setErrorCode(12294);
  return 0;
 }
 if (read != 0 && read != 62006 || draw != 0 && draw != 62006) {
  EGL.setErrorCode(12301);
  return 0;
 }
 EGL.currentContext = context;
 EGL.currentDrawSurface = draw;
 EGL.currentReadSurface = read;
 EGL.setErrorCode(12288);
 return 1;
}
Module["_eglMakeCurrent"] = _eglMakeCurrent;
function _eglGetCurrentContext() {
 return EGL.currentContext;
}
Module["_eglGetCurrentContext"] = _eglGetCurrentContext;
function _eglGetCurrentSurface(readdraw) {
 if (readdraw == 12378) {
  return EGL.currentReadSurface;
 } else if (readdraw == 12377) {
  return EGL.currentDrawSurface;
 } else {
  EGL.setErrorCode(12300);
  return 0;
 }
}
Module["_eglGetCurrentSurface"] = _eglGetCurrentSurface;
function _eglGetCurrentDisplay() {
 return EGL.currentContext ? 62e3 : 0;
}
Module["_eglGetCurrentDisplay"] = _eglGetCurrentDisplay;
function _eglSwapBuffers() {
 if (!EGL.defaultDisplayInitialized) {
  EGL.setErrorCode(12289);
 } else if (!Module.ctx) {
  EGL.setErrorCode(12290);
 } else if (Module.ctx.isContextLost()) {
  EGL.setErrorCode(12302);
 } else {
  EGL.setErrorCode(12288);
  return 1;
 }
 return 0;
}
Module["_eglSwapBuffers"] = _eglSwapBuffers;
function _eglGetProcAddress(name_) {
 return _emscripten_GetProcAddress(name_);
}
Module["_eglGetProcAddress"] = _eglGetProcAddress;
function _eglReleaseThread() {
 EGL.currentContext = 0;
 EGL.currentReadSurface = 0;
 EGL.currentDrawSurface = 0;
 EGL.setErrorCode(12288);
 return 1;
}
Module["_eglReleaseThread"] = _eglReleaseThread;
var AL = {
 contexts: [],
 currentContext: null,
 alcErr: 0,
 stringCache: {},
 alcStringCache: {},
 QUEUE_INTERVAL: 25,
 QUEUE_LOOKAHEAD: 100,
 newSrcId: 1,
 updateSources: function updateSources(context) {
  if (Browser.mainLoop.timingMode == 1 && document["visibilityState"] != "visible") return;
  for (var srcId in context.src) {
   AL.updateSource(context.src[srcId]);
  }
 },
 updateSource: function updateSource(src) {
  if (Browser.mainLoop.timingMode == 1 && document["visibilityState"] != "visible") return;
  if (src.state !== 4114) {
   return;
  }
  var currentTime = AL.currentContext.ctx.currentTime;
  var startTime = src.bufferPosition;
  for (var i = src.buffersPlayed; i < src.queue.length; i++) {
   var entry = src.queue[i];
   var startOffset = (startTime - currentTime) / src.playbackRate;
   var endTime;
   if (entry.src) endTime = startTime + entry.src.duration; else endTime = startTime + entry.buffer.duration / src.playbackRate;
   if (currentTime >= endTime) {
    src.bufferPosition = endTime;
    src.buffersPlayed = i + 1;
    if (src.buffersPlayed >= src.queue.length) {
     if (src.loop) {
      AL.setSourceState(src, 4114);
     } else {
      AL.setSourceState(src, 4116);
     }
    }
   } else if (startOffset < AL.QUEUE_LOOKAHEAD / 1e3 && !entry.src) {
    var offset = Math.abs(Math.min(startOffset, 0));
    entry.src = AL.currentContext.ctx.createBufferSource();
    entry.src.buffer = entry.buffer;
    entry.src.connect(src.gain);
    entry.src.playbackRate.value = src.playbackRate;
    entry.src.duration = entry.buffer.duration / src.playbackRate;
    if (typeof entry.src.start !== "undefined") {
     entry.src.start(startTime, offset);
    } else if (typeof entry.src.noteOn !== "undefined") {
     entry.src.noteOn(startTime);
    }
   }
   startTime = endTime;
  }
 },
 setSourceState: function setSourceState(src, state) {
  if (state === 4114) {
   if (src.state !== 4115) {
    src.state = 4114;
    src.bufferPosition = AL.currentContext.ctx.currentTime;
    src.buffersPlayed = 0;
   } else {
    src.state = 4114;
    src.bufferPosition = AL.currentContext.ctx.currentTime - src.bufferPosition;
   }
   AL.stopSourceQueue(src);
   AL.updateSource(src);
  } else if (state === 4115) {
   if (src.state === 4114) {
    src.state = 4115;
    src.bufferPosition = AL.currentContext.ctx.currentTime - src.bufferPosition;
    AL.stopSourceQueue(src);
   }
  } else if (state === 4116) {
   if (src.state !== 4113) {
    src.state = 4116;
    src.buffersPlayed = src.queue.length;
    AL.stopSourceQueue(src);
   }
  } else if (state == 4113) {
   if (src.state !== 4113) {
    src.state = 4113;
    src.bufferPosition = 0;
    src.buffersPlayed = 0;
   }
  }
 },
 stopSourceQueue: function stopSourceQueue(src) {
  for (var i = 0; i < src.queue.length; i++) {
   var entry = src.queue[i];
   if (entry.src) {
    entry.src.stop(0);
    entry.src = null;
   }
  }
 }
};
Module["AL"] = AL;
function _alcProcessContext(context) {}
Module["_alcProcessContext"] = _alcProcessContext;
function _alcSuspendContext(context) {}
Module["_alcSuspendContext"] = _alcSuspendContext;
function _alcMakeContextCurrent(context) {
 if (context == 0) {
  AL.currentContext = null;
  return 0;
 } else {
  AL.currentContext = AL.contexts[context - 1];
  return 1;
 }
}
Module["_alcMakeContextCurrent"] = _alcMakeContextCurrent;
function _alcGetContextsDevice(context) {
 if (context <= AL.contexts.length && context > 0) {
  return 1;
 }
 return 0;
}
Module["_alcGetContextsDevice"] = _alcGetContextsDevice;
function _alcGetCurrentContext() {
 for (var i = 0; i < AL.contexts.length; ++i) {
  if (AL.contexts[i] == AL.currentContext) {
   return i + 1;
  }
 }
 return 0;
}
Module["_alcGetCurrentContext"] = _alcGetCurrentContext;
function _alcDestroyContext(context) {
 clearInterval(AL.contexts[context - 1].interval);
}
Module["_alcDestroyContext"] = _alcDestroyContext;
function _alcCloseDevice(device) {}
Module["_alcCloseDevice"] = _alcCloseDevice;
function _alcOpenDevice(deviceName) {
 if (typeof AudioContext !== "undefined" || typeof webkitAudioContext !== "undefined") {
  return 1;
 } else {
  return 0;
 }
}
Module["_alcOpenDevice"] = _alcOpenDevice;
function _alcCreateContext(device, attrList) {
 if (device != 1) {
  return 0;
 }
 if (attrList) {
  return 0;
 }
 var ctx;
 try {
  ctx = new AudioContext;
 } catch (e) {
  try {
   ctx = new webkitAudioContext;
  } catch (e) {}
 }
 if (ctx) {
  if (typeof ctx.createGain === "undefined") ctx.createGain = ctx.createGainNode;
  var gain = ctx.createGain();
  gain.connect(ctx.destination);
  ctx.listener._position = [ 0, 0, 0 ];
  ctx.listener._velocity = [ 0, 0, 0 ];
  ctx.listener._orientation = [ 0, 0, 0, 0, 0, 0 ];
  var context = {
   ctx: ctx,
   err: 0,
   src: {},
   buf: [],
   interval: setInterval((function() {
    AL.updateSources(context);
   }), AL.QUEUE_INTERVAL),
   gain: gain
  };
  AL.contexts.push(context);
  return AL.contexts.length;
 } else {
  return 0;
 }
}
Module["_alcCreateContext"] = _alcCreateContext;
function _alGetError() {
 if (!AL.currentContext) {
  return 40964;
 } else {
  var err = AL.currentContext.err;
  AL.currentContext.err = 0;
  return err;
 }
}
Module["_alGetError"] = _alGetError;
function _alcGetError(device) {
 var err = AL.alcErr;
 AL.alcErr = 0;
 return err;
}
Module["_alcGetError"] = _alcGetError;
function _alcGetIntegerv(device, param, size, data) {
 if (size == 0 || !data) {
  AL.currentContext.err = 40963;
  return;
 }
 switch (param) {
 case 4096:
  HEAP32[data >> 2] = 1;
  break;
 case 4097:
  HEAP32[data >> 2] = 1;
  break;
 case 4098:
  if (!device) {
   AL.alcErr = 40961;
   return 0;
  }
  HEAP32[data >> 2] = 1;
  break;
 case 4099:
  if (!device) {
   AL.alcErr = 40961;
   return 0;
  }
  HEAP32[data >> 2] = 0;
  break;
 case 131075:
  if (!device) {
   AL.currentContext.err = 40961;
   return 0;
  }
  HEAP32[data >> 2] = 1;
 default:
  AL.alcErr = 40963;
  break;
 }
}
Module["_alcGetIntegerv"] = _alcGetIntegerv;
function _alDeleteSources(count, sources) {
 if (!AL.currentContext) {
  return;
 }
 for (var i = 0; i < count; ++i) {
  var sourceIdx = HEAP32[sources + i * 4 >> 2];
  delete AL.currentContext.src[sourceIdx];
 }
}
Module["_alDeleteSources"] = _alDeleteSources;
function _alGenSources(count, sources) {
 if (!AL.currentContext) {
  return;
 }
 for (var i = 0; i < count; ++i) {
  var gain = AL.currentContext.ctx.createGain();
  gain.connect(AL.currentContext.gain);
  AL.currentContext.src[AL.newSrcId] = {
   state: 4113,
   queue: [],
   loop: false,
   playbackRate: 1,
   _position: [ 0, 0, 0 ],
   _velocity: [ 0, 0, 0 ],
   _direction: [ 0, 0, 0 ],
   get refDistance() {
    return this._refDistance || 1;
   },
   set refDistance(val) {
    this._refDistance = val;
    if (this.panner) this.panner.refDistance = val;
   },
   get maxDistance() {
    return this._maxDistance || 1e4;
   },
   set maxDistance(val) {
    this._maxDistance = val;
    if (this.panner) this.panner.maxDistance = val;
   },
   get rolloffFactor() {
    return this._rolloffFactor || 1;
   },
   set rolloffFactor(val) {
    this._rolloffFactor = val;
    if (this.panner) this.panner.rolloffFactor = val;
   },
   get position() {
    return this._position;
   },
   set position(val) {
    this._position[0] = val[0];
    this._position[1] = val[1];
    this._position[2] = val[2];
    if (this.panner) this.panner.setPosition(val[0], val[1], val[2]);
   },
   get velocity() {
    return this._velocity;
   },
   set velocity(val) {
    this._velocity[0] = val[0];
    this._velocity[1] = val[1];
    this._velocity[2] = val[2];
    if (this.panner) this.panner.setVelocity(val[0], val[1], val[2]);
   },
   get direction() {
    return this._direction;
   },
   set direction(val) {
    this._direction[0] = val[0];
    this._direction[1] = val[1];
    this._direction[2] = val[2];
    if (this.panner) this.panner.setOrientation(val[0], val[1], val[2]);
   },
   get coneOuterGain() {
    return this._coneOuterGain || 0;
   },
   set coneOuterGain(val) {
    this._coneOuterGain = val;
    if (this.panner) this.panner.coneOuterGain = val;
   },
   get coneInnerAngle() {
    return this._coneInnerAngle || 360;
   },
   set coneInnerAngle(val) {
    this._coneInnerAngle = val;
    if (this.panner) this.panner.coneInnerAngle = val;
   },
   get coneOuterAngle() {
    return this._coneOuterAngle || 360;
   },
   set coneOuterAngle(val) {
    this._coneOuterAngle = val;
    if (this.panner) this.panner.coneOuterAngle = val;
   },
   gain: gain,
   panner: null,
   buffersPlayed: 0,
   bufferPosition: 0
  };
  HEAP32[sources + i * 4 >> 2] = AL.newSrcId;
  AL.newSrcId++;
 }
}
Module["_alGenSources"] = _alGenSources;
function _alIsSource(sourceId) {
 if (!AL.currentContext) {
  return false;
 }
 if (!AL.currentContext.src[sourceId]) {
  return false;
 } else {
  return true;
 }
}
Module["_alIsSource"] = _alIsSource;
function _alSourcei(source, param, value) {
 if (!AL.currentContext) {
  return;
 }
 var src = AL.currentContext.src[source];
 if (!src) {
  AL.currentContext.err = 40961;
  return;
 }
 switch (param) {
 case 4097:
  src.coneInnerAngle = value;
  break;
 case 4098:
  src.coneOuterAngle = value;
  break;
 case 4103:
  src.loop = value === 1;
  break;
 case 4105:
  var buffer = AL.currentContext.buf[value - 1];
  if (value == 0) {
   src.queue = [];
  } else {
   src.queue = [ {
    buffer: buffer
   } ];
  }
  AL.updateSource(src);
  break;
 case 514:
  if (value === 1) {
   if (src.panner) {
    src.panner = null;
    src.gain.disconnect();
    src.gain.connect(AL.currentContext.gain);
   }
  } else if (value === 0) {
   if (!src.panner) {
    var panner = src.panner = AL.currentContext.ctx.createPanner();
    panner.panningModel = "equalpower";
    panner.distanceModel = "linear";
    panner.refDistance = src.refDistance;
    panner.maxDistance = src.maxDistance;
    panner.rolloffFactor = src.rolloffFactor;
    panner.setPosition(src.position[0], src.position[1], src.position[2]);
    panner.setVelocity(src.velocity[0], src.velocity[1], src.velocity[2]);
    panner.connect(AL.currentContext.gain);
    src.gain.disconnect();
    src.gain.connect(panner);
   }
  } else {
   AL.currentContext.err = 40963;
  }
  break;
 default:
  AL.currentContext.err = 40962;
  break;
 }
}
Module["_alSourcei"] = _alSourcei;
function _alSourcef(source, param, value) {
 if (!AL.currentContext) {
  return;
 }
 var src = AL.currentContext.src[source];
 if (!src) {
  AL.currentContext.err = 40961;
  return;
 }
 switch (param) {
 case 4099:
  if (value <= 0) {
   AL.currentContext.err = 40963;
   return;
  }
  src.playbackRate = value;
  if (src.state === 4114) {
   var entry = src.queue[src.buffersPlayed];
   var currentTime = AL.currentContext.ctx.currentTime;
   var oldrate = entry.src.playbackRate.value;
   var offset = currentTime - src.bufferPosition;
   entry.src.duration = (entry.src.duration - offset) * oldrate / src.playbackRate;
   entry.src.playbackRate.value = src.playbackRate;
   src.bufferPosition = currentTime;
   for (var k = src.buffersPlayed + 1; k < src.queue.length; k++) {
    var entry = src.queue[k];
    if (entry.src) {
     entry.src.stop();
     entry.src = null;
    }
   }
   AL.updateSource(src);
  }
  break;
 case 4106:
  src.gain.gain.value = value;
  break;
 case 4131:
  src.maxDistance = value;
  break;
 case 4129:
  src.rolloffFactor = value;
  break;
 case 4130:
  src.coneOuterGain = value;
  break;
 case 4097:
  src.coneInnerAngle = value;
  break;
 case 4098:
  src.coneOuterAngle = value;
  break;
 case 4128:
  src.refDistance = value;
  break;
 default:
  AL.currentContext.err = 40962;
  break;
 }
}
Module["_alSourcef"] = _alSourcef;
function _alSource3i(source, param, v1, v2, v3) {
 _alSource3f(source, param, v1, v2, v3);
}
Module["_alSource3i"] = _alSource3i;
function _alSource3f(source, param, v1, v2, v3) {
 if (!AL.currentContext) {
  return;
 }
 var src = AL.currentContext.src[source];
 if (!src) {
  AL.currentContext.err = 40961;
  return;
 }
 switch (param) {
 case 4100:
  src.position[0] = v1;
  src.position[1] = v2;
  src.position[2] = v3;
  break;
 case 4101:
  src.direction[0] = v1;
  src.direction[1] = v2;
  src.direction[2] = v3;
  break;
 case 4102:
  src.velocity[0] = v1;
  src.velocity[1] = v2;
  src.velocity[2] = v3;
  break;
 default:
  AL.currentContext.err = 40962;
  break;
 }
}
Module["_alSource3f"] = _alSource3f;
function _alSourcefv(source, param, value) {
 _alSource3f(source, param, HEAPF32[value >> 2], HEAPF32[value + 4 >> 2], HEAPF32[value + 8 >> 2]);
}
Module["_alSourcefv"] = _alSourcefv;
function _alSourceQueueBuffers(source, count, buffers) {
 if (!AL.currentContext) {
  return;
 }
 var src = AL.currentContext.src[source];
 if (!src) {
  AL.currentContext.err = 40961;
  return;
 }
 for (var i = 0; i < count; ++i) {
  var bufferIdx = HEAP32[buffers + i * 4 >> 2];
  if (bufferIdx > AL.currentContext.buf.length) {
   AL.currentContext.err = 40961;
   return;
  }
 }
 for (var i = 0; i < count; ++i) {
  var bufferIdx = HEAP32[buffers + i * 4 >> 2];
  var buffer = AL.currentContext.buf[bufferIdx - 1];
  src.queue.push({
   buffer: buffer,
   src: null
  });
 }
 AL.updateSource(src);
}
Module["_alSourceQueueBuffers"] = _alSourceQueueBuffers;
function _alSourceUnqueueBuffers(source, count, buffers) {
 if (!AL.currentContext) {
  return;
 }
 var src = AL.currentContext.src[source];
 if (!src) {
  AL.currentContext.err = 40961;
  return;
 }
 if (count > src.buffersPlayed) {
  AL.currentContext.err = 40963;
  return;
 }
 for (var i = 0; i < count; i++) {
  var entry = src.queue.shift();
  for (var j = 0; j < AL.currentContext.buf.length; j++) {
   var b = AL.currentContext.buf[j];
   if (b && b == entry.buffer) {
    HEAP32[buffers + i * 4 >> 2] = j + 1;
    break;
   }
  }
  src.buffersPlayed--;
 }
 AL.updateSource(src);
}
Module["_alSourceUnqueueBuffers"] = _alSourceUnqueueBuffers;
function _alDeleteBuffers(count, buffers) {
 if (!AL.currentContext) {
  return;
 }
 if (count > AL.currentContext.buf.length) {
  AL.currentContext.err = 40963;
  return;
 }
 for (var i = 0; i < count; ++i) {
  var bufferIdx = HEAP32[buffers + i * 4 >> 2] - 1;
  if (bufferIdx >= AL.currentContext.buf.length || !AL.currentContext.buf[bufferIdx]) {
   AL.currentContext.err = 40961;
   return;
  }
  var buffer = AL.currentContext.buf[bufferIdx];
  for (var srcId in AL.currentContext.src) {
   var src = AL.currentContext.src[srcId];
   if (!src) {
    continue;
   }
   for (var k = 0; k < src.queue.length; k++) {
    if (buffer === src.queue[k].buffer) {
     AL.currentContext.err = 40964;
     return;
    }
   }
  }
 }
 for (var i = 0; i < count; ++i) {
  var bufferIdx = HEAP32[buffers + i * 4 >> 2] - 1;
  delete AL.currentContext.buf[bufferIdx];
 }
}
Module["_alDeleteBuffers"] = _alDeleteBuffers;
function _alGenBuffers(count, buffers) {
 if (!AL.currentContext) {
  return;
 }
 for (var i = 0; i < count; ++i) {
  AL.currentContext.buf.push(null);
  HEAP32[buffers + i * 4 >> 2] = AL.currentContext.buf.length;
 }
}
Module["_alGenBuffers"] = _alGenBuffers;
function _alIsBuffer(bufferId) {
 if (!AL.currentContext) {
  return false;
 }
 if (bufferId > AL.currentContext.buf.length) {
  return false;
 }
 if (!AL.currentContext.buf[bufferId - 1]) {
  return false;
 } else {
  return true;
 }
}
Module["_alIsBuffer"] = _alIsBuffer;
function _alBufferData(buffer, format, data, size, freq) {
 if (!AL.currentContext) {
  return;
 }
 if (buffer > AL.currentContext.buf.length) {
  return;
 }
 var channels, bytes;
 switch (format) {
 case 4352:
  bytes = 1;
  channels = 1;
  break;
 case 4353:
  bytes = 2;
  channels = 1;
  break;
 case 4354:
  bytes = 1;
  channels = 2;
  break;
 case 4355:
  bytes = 2;
  channels = 2;
  break;
 case 65552:
  bytes = 4;
  channels = 1;
  break;
 case 65553:
  bytes = 4;
  channels = 2;
  break;
 default:
  return;
 }
 try {
  AL.currentContext.buf[buffer - 1] = AL.currentContext.ctx.createBuffer(channels, size / (bytes * channels), freq);
  AL.currentContext.buf[buffer - 1].bytesPerSample = bytes;
 } catch (e) {
  AL.currentContext.err = 40963;
  return;
 }
 var buf = new Array(channels);
 for (var i = 0; i < channels; ++i) {
  buf[i] = AL.currentContext.buf[buffer - 1].getChannelData(i);
 }
 for (var i = 0; i < size / (bytes * channels); ++i) {
  for (var j = 0; j < channels; ++j) {
   switch (bytes) {
   case 1:
    var val = HEAP8[data + (i * channels + j) >> 0] & 255;
    buf[j][i] = -1 + val * (2 / 256);
    break;
   case 2:
    var val = HEAP16[data + 2 * (i * channels + j) >> 1];
    buf[j][i] = val / 32768;
    break;
   case 4:
    buf[j][i] = HEAPF32[data + 4 * (i * channels + j) >> 2];
    break;
   }
  }
 }
}
Module["_alBufferData"] = _alBufferData;
function _alGetBufferi(buffer, param, value) {
 if (!AL.currentContext) {
  return;
 }
 var buf = AL.currentContext.buf[buffer - 1];
 if (!buf) {
  AL.currentContext.err = 40961;
  return;
 }
 switch (param) {
 case 8193:
  HEAP32[value >> 2] = buf.sampleRate;
  break;
 case 8194:
  HEAP32[value >> 2] = buf.bytesPerSample * 8;
  break;
 case 8195:
  HEAP32[value >> 2] = buf.numberOfChannels;
  break;
 case 8196:
  HEAP32[value >> 2] = buf.length * buf.bytesPerSample * buf.numberOfChannels;
  break;
 default:
  AL.currentContext.err = 40962;
  break;
 }
}
Module["_alGetBufferi"] = _alGetBufferi;
function _alSourcePlay(source) {
 if (!AL.currentContext) {
  return;
 }
 var src = AL.currentContext.src[source];
 if (!src) {
  AL.currentContext.err = 40961;
  return;
 }
 AL.setSourceState(src, 4114);
}
Module["_alSourcePlay"] = _alSourcePlay;
function _alSourceStop(source) {
 if (!AL.currentContext) {
  return;
 }
 var src = AL.currentContext.src[source];
 if (!src) {
  AL.currentContext.err = 40961;
  return;
 }
 AL.setSourceState(src, 4116);
}
Module["_alSourceStop"] = _alSourceStop;
function _alSourceRewind(source) {
 if (!AL.currentContext) {
  return;
 }
 var src = AL.currentContext.src[source];
 if (!src) {
  AL.currentContext.err = 40961;
  return;
 }
 AL.setSourceState(src, 4116);
 AL.setSourceState(src, 4113);
}
Module["_alSourceRewind"] = _alSourceRewind;
function _alSourcePause(source) {
 if (!AL.currentContext) {
  return;
 }
 var src = AL.currentContext.src[source];
 if (!src) {
  AL.currentContext.err = 40961;
  return;
 }
 AL.setSourceState(src, 4115);
}
Module["_alSourcePause"] = _alSourcePause;
function _alGetSourcei(source, param, value) {
 if (!AL.currentContext) {
  return;
 }
 var src = AL.currentContext.src[source];
 if (!src) {
  AL.currentContext.err = 40961;
  return;
 }
 AL.updateSource(src);
 switch (param) {
 case 514:
  HEAP32[value >> 2] = src.panner ? 1 : 0;
  break;
 case 4097:
  HEAP32[value >> 2] = src.coneInnerAngle;
  break;
 case 4098:
  HEAP32[value >> 2] = src.coneOuterAngle;
  break;
 case 4103:
  HEAP32[value >> 2] = src.loop;
  break;
 case 4105:
  if (!src.queue.length) {
   HEAP32[value >> 2] = 0;
  } else {
   var buffer = src.queue[src.buffersPlayed].buffer;
   for (var i = 0; i < AL.currentContext.buf.length; ++i) {
    if (buffer == AL.currentContext.buf[i]) {
     HEAP32[value >> 2] = i + 1;
     return;
    }
   }
   HEAP32[value >> 2] = 0;
  }
  break;
 case 4112:
  HEAP32[value >> 2] = src.state;
  break;
 case 4117:
  HEAP32[value >> 2] = src.queue.length;
  break;
 case 4118:
  if (src.loop) {
   HEAP32[value >> 2] = 0;
  } else {
   HEAP32[value >> 2] = src.buffersPlayed;
  }
  break;
 default:
  AL.currentContext.err = 40962;
  break;
 }
}
Module["_alGetSourcei"] = _alGetSourcei;
function _alGetSourceiv(source, param, values) {
 if (!AL.currentContext) {
  return;
 }
 var src = AL.currentContext.src[source];
 if (!src) {
  AL.currentContext.err = 40961;
  return;
 }
 switch (param) {
 case 514:
 case 4097:
 case 4098:
 case 4103:
 case 4105:
 case 4112:
 case 4117:
 case 4118:
  _alGetSourcei(source, param, values);
  break;
 default:
  AL.currentContext.err = 40962;
  break;
 }
}
Module["_alGetSourceiv"] = _alGetSourceiv;
function _alGetSourcef(source, param, value) {
 if (!AL.currentContext) {
  return;
 }
 var src = AL.currentContext.src[source];
 if (!src) {
  AL.currentContext.err = 40961;
  return;
 }
 switch (param) {
 case 4099:
  HEAPF32[value >> 2] = src.playbackRate;
  break;
 case 4106:
  HEAPF32[value >> 2] = src.gain.gain.value;
  break;
 case 4131:
  HEAPF32[value >> 2] = src.maxDistance;
  break;
 case 4129:
  HEAPF32[value >> 2] = src.rolloffFactor;
  break;
 case 4130:
  HEAPF32[value >> 2] = src.coneOuterGain;
  break;
 case 4097:
  HEAPF32[value >> 2] = src.coneInnerAngle;
  break;
 case 4098:
  HEAPF32[value >> 2] = src.coneOuterAngle;
  break;
 case 4128:
  HEAPF32[value >> 2] = src.refDistance;
  break;
 default:
  AL.currentContext.err = 40962;
  break;
 }
}
Module["_alGetSourcef"] = _alGetSourcef;
function _alGetSourcefv(source, param, values) {
 if (!AL.currentContext) {
  return;
 }
 var src = AL.currentContext.src[source];
 if (!src) {
  AL.currentContext.err = 40961;
  return;
 }
 switch (param) {
 case 4099:
 case 4106:
 case 4109:
 case 4110:
 case 4131:
 case 4129:
 case 4130:
 case 4097:
 case 4098:
 case 4128:
 case 4132:
 case 4133:
 case 4134:
  _alGetSourcef(source, param, values);
  break;
 case 4100:
  var position = src.position;
  HEAPF32[values >> 2] = position[0];
  HEAPF32[values + 4 >> 2] = position[1];
  HEAPF32[values + 8 >> 2] = position[2];
  break;
 case 4101:
  var direction = src.direction;
  HEAPF32[values >> 2] = direction[0];
  HEAPF32[values + 4 >> 2] = direction[1];
  HEAPF32[values + 8 >> 2] = direction[2];
  break;
 case 4102:
  var velocity = src.velocity;
  HEAPF32[values >> 2] = velocity[0];
  HEAPF32[values + 4 >> 2] = velocity[1];
  HEAPF32[values + 8 >> 2] = velocity[2];
  break;
 default:
  AL.currentContext.err = 40962;
  break;
 }
}
Module["_alGetSourcefv"] = _alGetSourcefv;
function _alDistanceModel(model) {
 if (model !== 0) {}
}
Module["_alDistanceModel"] = _alDistanceModel;
function _alGetListenerf(pname, value) {
 if (!AL.currentContext) {
  return;
 }
 switch (pname) {
 case 4106:
  HEAPF32[value >> 2] = AL.currentContext.gain.gain.value;
  break;
 default:
  AL.currentContext.err = 40962;
  break;
 }
}
Module["_alGetListenerf"] = _alGetListenerf;
function _alGetListenerfv(pname, values) {
 if (!AL.currentContext) {
  return;
 }
 switch (pname) {
 case 4100:
  var position = AL.currentContext.ctx.listener._position;
  HEAPF32[values >> 2] = position[0];
  HEAPF32[values + 4 >> 2] = position[1];
  HEAPF32[values + 8 >> 2] = position[2];
  break;
 case 4102:
  var velocity = AL.currentContext.ctx.listener._velocity;
  HEAPF32[values >> 2] = velocity[0];
  HEAPF32[values + 4 >> 2] = velocity[1];
  HEAPF32[values + 8 >> 2] = velocity[2];
  break;
 case 4111:
  var orientation = AL.currentContext.ctx.listener._orientation;
  HEAPF32[values >> 2] = orientation[0];
  HEAPF32[values + 4 >> 2] = orientation[1];
  HEAPF32[values + 8 >> 2] = orientation[2];
  HEAPF32[values + 12 >> 2] = orientation[3];
  HEAPF32[values + 16 >> 2] = orientation[4];
  HEAPF32[values + 20 >> 2] = orientation[5];
  break;
 default:
  AL.currentContext.err = 40962;
  break;
 }
}
Module["_alGetListenerfv"] = _alGetListenerfv;
function _alGetListeneri(pname, value) {
 if (!AL.currentContext) {
  return;
 }
 switch (pname) {
 default:
  AL.currentContext.err = 40962;
  break;
 }
}
Module["_alGetListeneri"] = _alGetListeneri;
function _alListenerf(param, value) {
 if (!AL.currentContext) {
  return;
 }
 switch (param) {
 case 4106:
  AL.currentContext.gain.gain.value = value;
  break;
 default:
  AL.currentContext.err = 40962;
  break;
 }
}
Module["_alListenerf"] = _alListenerf;
function _alEnable(param) {
 if (!AL.currentContext) {
  return;
 }
 switch (param) {
 default:
  AL.currentContext.err = 40962;
  break;
 }
}
Module["_alEnable"] = _alEnable;
function _alDisable(param) {
 if (!AL.currentContext) {
  return;
 }
 switch (pname) {
 default:
  AL.currentContext.err = 40962;
  break;
 }
}
Module["_alDisable"] = _alDisable;
function _alListener3f(param, v1, v2, v3) {
 if (!AL.currentContext) {
  return;
 }
 switch (param) {
 case 4100:
  AL.currentContext.ctx.listener._position[0] = v1;
  AL.currentContext.ctx.listener._position[1] = v2;
  AL.currentContext.ctx.listener._position[2] = v3;
  AL.currentContext.ctx.listener.setPosition(v1, v2, v3);
  break;
 case 4102:
  AL.currentContext.ctx.listener._velocity[0] = v1;
  AL.currentContext.ctx.listener._velocity[1] = v2;
  AL.currentContext.ctx.listener._velocity[2] = v3;
  AL.currentContext.ctx.listener.setVelocity(v1, v2, v3);
  break;
 default:
  AL.currentContext.err = 40962;
  break;
 }
}
Module["_alListener3f"] = _alListener3f;
function _alListenerfv(param, values) {
 if (!AL.currentContext) {
  return;
 }
 switch (param) {
 case 4100:
  var x = HEAPF32[values >> 2];
  var y = HEAPF32[values + 4 >> 2];
  var z = HEAPF32[values + 8 >> 2];
  AL.currentContext.ctx.listener._position[0] = x;
  AL.currentContext.ctx.listener._position[1] = y;
  AL.currentContext.ctx.listener._position[2] = z;
  AL.currentContext.ctx.listener.setPosition(x, y, z);
  break;
 case 4102:
  var x = HEAPF32[values >> 2];
  var y = HEAPF32[values + 4 >> 2];
  var z = HEAPF32[values + 8 >> 2];
  AL.currentContext.ctx.listener._velocity[0] = x;
  AL.currentContext.ctx.listener._velocity[1] = y;
  AL.currentContext.ctx.listener._velocity[2] = z;
  AL.currentContext.ctx.listener.setVelocity(x, y, z);
  break;
 case 4111:
  var x = HEAPF32[values >> 2];
  var y = HEAPF32[values + 4 >> 2];
  var z = HEAPF32[values + 8 >> 2];
  var x2 = HEAPF32[values + 12 >> 2];
  var y2 = HEAPF32[values + 16 >> 2];
  var z2 = HEAPF32[values + 20 >> 2];
  AL.currentContext.ctx.listener._orientation[0] = x;
  AL.currentContext.ctx.listener._orientation[1] = y;
  AL.currentContext.ctx.listener._orientation[2] = z;
  AL.currentContext.ctx.listener._orientation[3] = x2;
  AL.currentContext.ctx.listener._orientation[4] = y2;
  AL.currentContext.ctx.listener._orientation[5] = z2;
  AL.currentContext.ctx.listener.setOrientation(x, y, z, x2, y2, z2);
  break;
 default:
  AL.currentContext.err = 40962;
  break;
 }
}
Module["_alListenerfv"] = _alListenerfv;
function _alIsExtensionPresent(extName) {
 extName = Pointer_stringify(extName);
 if (extName == "AL_EXT_float32") return 1;
 return 0;
}
Module["_alIsExtensionPresent"] = _alIsExtensionPresent;
function _alcIsExtensionPresent(device, extName) {
 return 0;
}
Module["_alcIsExtensionPresent"] = _alcIsExtensionPresent;
function _alGetString(param) {
 if (AL.stringCache[param]) return AL.stringCache[param];
 var ret;
 switch (param) {
 case 0:
  ret = "No Error";
  break;
 case 40961:
  ret = "Invalid Name";
  break;
 case 40962:
  ret = "Invalid Enum";
  break;
 case 40963:
  ret = "Invalid Value";
  break;
 case 40964:
  ret = "Invalid Operation";
  break;
 case 40965:
  ret = "Out of Memory";
  break;
 case 45057:
  ret = "Emscripten";
  break;
 case 45058:
  ret = "1.1";
  break;
 case 45059:
  ret = "WebAudio";
  break;
 case 45060:
  ret = "AL_EXT_float32";
  break;
 default:
  AL.currentContext.err = 40962;
  return 0;
 }
 ret = allocate(intArrayFromString(ret), "i8", ALLOC_NORMAL);
 AL.stringCache[param] = ret;
 return ret;
}
Module["_alGetString"] = _alGetString;
function _alGetProcAddress(fname) {
 return 0;
}
Module["_alGetProcAddress"] = _alGetProcAddress;
function _alcGetString(device, param) {
 if (AL.alcStringCache[param]) return AL.alcStringCache[param];
 var ret;
 switch (param) {
 case 0:
  ret = "No Error";
  break;
 case 40961:
  ret = "Invalid Device";
  break;
 case 40962:
  ret = "Invalid Context";
  break;
 case 40963:
  ret = "Invalid Enum";
  break;
 case 40964:
  ret = "Invalid Value";
  break;
 case 40965:
  ret = "Out of Memory";
  break;
 case 4100:
  if (typeof AudioContext !== "undefined" || typeof webkitAudioContext !== "undefined") {
   ret = "Device";
  } else {
   return 0;
  }
  break;
 case 4101:
  if (typeof AudioContext !== "undefined" || typeof webkitAudioContext !== "undefined") {
   ret = "Device ";
  } else {
   ret = " ";
  }
  break;
 case 785:
  return 0;
  break;
 case 784:
  ret = " ";
  break;
 case 4102:
  if (!device) {
   AL.alcErr = 40961;
   return 0;
  }
  ret = "";
  break;
 default:
  AL.alcErr = 40963;
  return 0;
 }
 ret = allocate(intArrayFromString(ret), "i8", ALLOC_NORMAL);
 AL.alcStringCache[param] = ret;
 return ret;
}
Module["_alcGetString"] = _alcGetString;
function _alcGetProcAddress(device, fname) {
 return 0;
}
Module["_alcGetProcAddress"] = _alcGetProcAddress;
function _alGetEnumValue(name) {
 name = Pointer_stringify(name);
 if (name == "AL_FORMAT_MONO_FLOAT32") return 65552;
 if (name == "AL_FORMAT_STEREO_FLOAT32") return 65553;
 AL.currentContext.err = 40963;
 return 0;
}
Module["_alGetEnumValue"] = _alGetEnumValue;
function _alSpeedOfSound(value) {
 Runtime.warnOnce("alSpeedOfSound() is not yet implemented! Ignoring all calls to it.");
}
Module["_alSpeedOfSound"] = _alSpeedOfSound;
function _alDopplerFactor(value) {
 Runtime.warnOnce("alDopplerFactor() is not yet implemented! Ignoring all calls to it.");
}
Module["_alDopplerFactor"] = _alDopplerFactor;
function _alDopplerVelocity(value) {
 Runtime.warnOnce("alDopplerVelocity() is not yet implemented! Ignoring all calls to it.");
}
Module["_alDopplerVelocity"] = _alDopplerVelocity;
var GLFW = {
 Window: (function(id, width, height, title, monitor, share) {
  this.id = id;
  this.x = 0;
  this.y = 0;
  this.fullscreen = false;
  this.storedX = 0;
  this.storedY = 0;
  this.width = width;
  this.height = height;
  this.storedWidth = width;
  this.storedHeight = height;
  this.title = title;
  this.monitor = monitor;
  this.share = share;
  this.attributes = GLFW.hints;
  this.inputModes = {
   208897: 212993,
   208898: 0,
   208899: 0
  };
  this.buttons = 0;
  this.keys = new Array;
  this.shouldClose = 0;
  this.title = null;
  this.windowPosFunc = null;
  this.windowSizeFunc = null;
  this.windowCloseFunc = null;
  this.windowRefreshFunc = null;
  this.windowFocusFunc = null;
  this.windowIconifyFunc = null;
  this.framebufferSizeFunc = null;
  this.mouseButtonFunc = null;
  this.cursorPosFunc = null;
  this.cursorEnterFunc = null;
  this.scrollFunc = null;
  this.keyFunc = null;
  this.charFunc = null;
  this.userptr = null;
 }),
 WindowFromId: (function(id) {
  if (id <= 0 || !GLFW.windows) return null;
  return GLFW.windows[id - 1];
 }),
 errorFunc: null,
 monitorFunc: null,
 active: null,
 windows: null,
 monitors: null,
 monitorString: null,
 versionString: null,
 initialTime: null,
 extensions: null,
 hints: null,
 defaultHints: {
  131073: 0,
  131074: 0,
  131075: 1,
  131076: 1,
  131077: 1,
  135169: 8,
  135170: 8,
  135171: 8,
  135172: 8,
  135173: 24,
  135174: 8,
  135175: 0,
  135176: 0,
  135177: 0,
  135178: 0,
  135179: 0,
  135180: 0,
  135181: 0,
  135182: 0,
  135183: 0,
  139265: 196609,
  139266: 1,
  139267: 0,
  139268: 0,
  139269: 0,
  139270: 0,
  139271: 0,
  139272: 0
 },
 DOMToGLFWKeyCode: (function(keycode) {
  switch (keycode) {
  case 32:
   return 32;
  case 222:
   return 39;
  case 188:
   return 44;
  case 173:
   return 45;
  case 190:
   return 46;
  case 191:
   return 47;
  case 48:
   return 48;
  case 49:
   return 49;
  case 50:
   return 50;
  case 51:
   return 51;
  case 52:
   return 52;
  case 53:
   return 53;
  case 54:
   return 54;
  case 55:
   return 55;
  case 56:
   return 56;
  case 57:
   return 57;
  case 59:
   return 59;
  case 97:
   return 61;
  case 65:
   return 65;
  case 66:
   return 66;
  case 67:
   return 67;
  case 68:
   return 68;
  case 69:
   return 69;
  case 70:
   return 70;
  case 71:
   return 71;
  case 72:
   return 72;
  case 73:
   return 73;
  case 74:
   return 74;
  case 75:
   return 75;
  case 76:
   return 76;
  case 77:
   return 77;
  case 78:
   return 78;
  case 79:
   return 79;
  case 80:
   return 80;
  case 81:
   return 81;
  case 82:
   return 82;
  case 83:
   return 83;
  case 84:
   return 84;
  case 85:
   return 85;
  case 86:
   return 86;
  case 87:
   return 87;
  case 88:
   return 88;
  case 89:
   return 89;
  case 90:
   return 90;
  case 219:
   return 91;
  case 220:
   return 92;
  case 221:
   return 93;
  case 192:
   return 94;
  case 27:
   return 256 + 1;
  case 112:
   return 256 + 2;
  case 113:
   return 256 + 3;
  case 114:
   return 256 + 4;
  case 115:
   return 256 + 5;
  case 116:
   return 256 + 6;
  case 117:
   return 256 + 7;
  case 118:
   return 256 + 8;
  case 119:
   return 256 + 9;
  case 120:
   return 256 + 10;
  case 121:
   return 256 + 11;
  case 122:
   return 256 + 12;
  case 123:
   return 256 + 13;
  case 124:
   return 256 + 14;
  case 125:
   return 256 + 15;
  case 126:
   return 256 + 16;
  case 127:
   return 256 + 17;
  case 128:
   return 256 + 18;
  case 129:
   return 256 + 19;
  case 130:
   return 256 + 20;
  case 131:
   return 256 + 21;
  case 132:
   return 256 + 22;
  case 133:
   return 256 + 23;
  case 134:
   return 256 + 24;
  case 135:
   return 256 + 25;
  case 136:
   return 256 + 26;
  case 39:
   return 256 + 27;
  case 37:
   return 256 + 28;
  case 40:
   return 256 + 29;
  case 38:
   return 256 + 30;
  case 16:
   return 256 + 31;
  case 17:
   return 256 + 33;
  case 18:
   return 256 + 35;
  case 9:
   return 256 + 37;
  case 13:
   return 256 + 38;
  case 8:
   return 256 + 39;
  case 45:
   return 256 + 40;
  case 46:
   return 256 + 41;
  case 33:
   return 256 + 42;
  case 34:
   return 256 + 43;
  case 36:
   return 256 + 44;
  case 35:
   return 256 + 45;
  case 96:
   return 256 + 46;
  case 97:
   return 256 + 47;
  case 98:
   return 256 + 48;
  case 99:
   return 256 + 49;
  case 100:
   return 256 + 50;
  case 101:
   return 256 + 51;
  case 102:
   return 256 + 52;
  case 103:
   return 256 + 53;
  case 104:
   return 256 + 54;
  case 105:
   return 256 + 55;
  case 111:
   return 256 + 56;
  case 106:
   return 256 + 57;
  case 109:
   return 256 + 58;
  case 107:
   return 256 + 59;
  case 110:
   return 256 + 60;
  case 144:
   return 256 + 63;
  case 20:
   return 256 + 64;
  case 145:
   return 256 + 65;
  case 19:
   return 256 + 66;
  case 91:
   return 256 + 67;
  case 93:
   return 256 + 69;
  default:
   return -1;
  }
 }),
 getModBits: (function(win) {
  var mod = 0;
  if (win.keys[340]) mod |= 1;
  if (win.keys[341]) mod |= 2;
  if (win.keys[342]) mod |= 4;
  if (win.keys[343]) mod |= 8;
  return mod;
 }),
 onKeyPress: (function(event) {
  if (!GLFW.active || !GLFW.active.charFunc) return;
  var charCode = event.charCode;
  if (charCode == 0 || charCode >= 0 && charCode <= 31) return;
  Runtime.dynCall("vii", GLFW.active.charFunc, [ charCode, 1 ]);
 }),
 onKeyChanged: (function(event, status) {
  if (!GLFW.active) return;
  var key = GLFW.DOMToGLFWKeyCode(event.keyCode);
  if (key == -1) return;
  GLFW.active.keys[key] = status;
  if (!GLFW.active.keyFunc) return;
  Runtime.dynCall("vii", GLFW.active.keyFunc, [ key, status ]);
 }),
 onKeydown: (function(event) {
  GLFW.onKeyChanged(event, 1);
  if (event.keyCode === 8 || event.keyCode === 9) {
   event.preventDefault();
  }
 }),
 onKeyup: (function(event) {
  GLFW.onKeyChanged(event, 0);
 }),
 onMousemove: (function(event) {
  if (!GLFW.active) return;
  Browser.calculateMouseEvent(event);
  if (event.target != Module["canvas"] || !GLFW.active.cursorPosFunc) return;
  Runtime.dynCall("vii", GLFW.active.cursorPosFunc, [ Browser.mouseX, Browser.mouseY ]);
 }),
 onMouseenter: (function(event) {
  if (!GLFW.active) return;
  if (event.target != Module["canvas"] || !GLFW.active.cursorEnterFunc) return;
 }),
 onMouseleave: (function(event) {
  if (!GLFW.active) return;
  if (event.target != Module["canvas"] || !GLFW.active.cursorEnterFunc) return;
 }),
 onMouseButtonChanged: (function(event, status) {
  if (!GLFW.active || !GLFW.active.mouseButtonFunc) return;
  Browser.calculateMouseEvent(event);
  if (event.target != Module["canvas"]) return;
  if (status == 1) {
   try {
    event.target.setCapture();
   } catch (e) {}
  }
  var eventButton = event["button"];
  if (eventButton > 0) {
   if (eventButton == 1) {
    eventButton = 2;
   } else {
    eventButton = 1;
   }
  }
  Runtime.dynCall("vii", GLFW.active.mouseButtonFunc, [ eventButton, status ]);
 }),
 onMouseButtonDown: (function(event) {
  if (!GLFW.active) return;
  GLFW.active.buttons |= 1 << event["button"];
  GLFW.onMouseButtonChanged(event, 1);
 }),
 onMouseButtonUp: (function(event) {
  if (!GLFW.active) return;
  GLFW.active.buttons &= ~(1 << event["button"]);
  GLFW.onMouseButtonChanged(event, 0);
 }),
 onMouseWheel: (function(event) {
  var delta = -Browser.getMouseWheelDelta(event);
  delta = delta == 0 ? 0 : delta > 0 ? Math.max(delta, 1) : Math.min(delta, -1);
  GLFW.wheelPos += delta;
  if (!GLFW.active || !GLFW.active.scrollFunc || event.target != Module["canvas"]) return;
  Runtime.dynCall("vi", GLFW.active.scrollFunc, [ GLFW.wheelPos ]);
  event.preventDefault();
 }),
 onCanvasResize: (function(width, height) {
  if (!GLFW.active) return;
  var resizeNeeded = true;
  if (document["fullscreen"] || document["fullScreen"] || document["mozFullScreen"] || document["webkitIsFullScreen"]) {
   GLFW.active.storedX = GLFW.active.x;
   GLFW.active.storedY = GLFW.active.y;
   GLFW.active.storedWidth = GLFW.active.width;
   GLFW.active.storedHeight = GLFW.active.height;
   GLFW.active.x = GLFW.active.y = 0;
   GLFW.active.width = screen.width;
   GLFW.active.height = screen.height;
   GLFW.active.fullscreen = true;
  } else if (GLFW.active.fullscreen == true) {
   GLFW.active.x = GLFW.active.storedX;
   GLFW.active.y = GLFW.active.storedY;
   GLFW.active.width = GLFW.active.storedWidth;
   GLFW.active.height = GLFW.active.storedHeight;
   GLFW.active.fullscreen = false;
  } else if (GLFW.active.width != width || GLFW.active.height != height) {
   GLFW.active.width = width;
   GLFW.active.height = height;
  } else {
   resizeNeeded = false;
  }
  if (resizeNeeded) {
   Browser.setCanvasSize(GLFW.active.width, GLFW.active.height);
   GLFW.onWindowSizeChanged();
   GLFW.onFramebufferSizeChanged();
  }
 }),
 onWindowSizeChanged: (function() {
  if (!GLFW.active) return;
  if (!GLFW.active.windowSizeFunc) return;
  Runtime.dynCall("vii", GLFW.active.windowSizeFunc, [ GLFW.active.width, GLFW.active.height ]);
 }),
 onFramebufferSizeChanged: (function() {
  if (!GLFW.active) return;
  if (!GLFW.active.framebufferSizeFunc) return;
 }),
 requestFullscreen: (function() {
  var RFS = Module["canvas"]["requestFullscreen"] || Module["canvas"]["mozRequestFullScreen"] || Module["canvas"]["webkitRequestFullScreen"] || (function() {});
  RFS.apply(Module["canvas"], []);
 }),
 requestFullScreen: (function() {
  Module.printErr("GLFW.requestFullScreen() is deprecated. Please call GLFW.requestFullscreen instead.");
  GLFW.requestFullScreen = (function() {
   return GLFW.requestFullscreen();
  });
  return GLFW.requestFullscreen();
 }),
 exitFullscreen: (function() {
  var CFS = document["exitFullscreen"] || document["cancelFullScreen"] || document["mozCancelFullScreen"] || document["webkitCancelFullScreen"] || (function() {});
  CFS.apply(document, []);
 }),
 cancelFullScreen: (function() {
  Module.printErr("GLFW.cancelFullScreen() is deprecated. Please call GLFW.exitFullscreen instead.");
  GLFW.cancelFullScreen = (function() {
   return GLFW.exitFullscreen();
  });
  return GLFW.exitFullscreen();
 }),
 getTime: (function() {
  return _emscripten_get_now() / 1e3;
 }),
 setWindowTitle: (function(winid, title) {
  var win = GLFW.WindowFromId(winid);
  if (!win) return;
  win.title = Pointer_stringify(title);
  if (GLFW.active.id == win.id) {
   document.title = win.title;
  }
 }),
 setKeyCallback: (function(winid, cbfun) {
  var win = GLFW.WindowFromId(winid);
  if (!win) return;
  win.keyFunc = cbfun;
 }),
 setCharCallback: (function(winid, cbfun) {
  var win = GLFW.WindowFromId(winid);
  if (!win) return;
  win.charFunc = cbfun;
 }),
 setMouseButtonCallback: (function(winid, cbfun) {
  var win = GLFW.WindowFromId(winid);
  if (!win) return;
  win.mouseButtonFunc = cbfun;
 }),
 setCursorPosCallback: (function(winid, cbfun) {
  var win = GLFW.WindowFromId(winid);
  if (!win) return;
  win.cursorPosFunc = cbfun;
 }),
 setScrollCallback: (function(winid, cbfun) {
  var win = GLFW.WindowFromId(winid);
  if (!win) return;
  win.scrollFunc = cbfun;
 }),
 setWindowSizeCallback: (function(winid, cbfun) {
  var win = GLFW.WindowFromId(winid);
  if (!win) return;
  win.windowSizeFunc = cbfun;
  if (!win.windowSizeFunc) return;
  Runtime.dynCall("vii", win.windowSizeFunc, [ win.width, win.height ]);
 }),
 setWindowCloseCallback: (function(winid, cbfun) {
  var win = GLFW.WindowFromId(winid);
  if (!win) return;
  win.windowCloseFunc = cbfun;
 }),
 setWindowRefreshCallback: (function(winid, cbfun) {
  var win = GLFW.WindowFromId(winid);
  if (!win) return;
  win.windowRefreshFunc = cbfun;
 }),
 onClickRequestPointerLock: (function(e) {
  if (!Browser.pointerLock && Module["canvas"].requestPointerLock) {
   Module["canvas"].requestPointerLock();
   e.preventDefault();
  }
 }),
 setInputMode: (function(winid, mode, value) {
  var win = GLFW.WindowFromId(winid);
  if (!win) return;
  switch (mode) {
  case 208897:
   {
    switch (value) {
    case 212993:
     {
      win.inputModes[mode] = value;
      Module["canvas"].removeEventListener("click", GLFW.onClickRequestPointerLock, true);
      Module["canvas"].exitPointerLock();
      break;
     }
    case 212994:
     {
      console.log("glfwSetInputMode called with GLFW_CURSOR_HIDDEN value not implemented.");
      break;
     }
    case 212995:
     {
      win.inputModes[mode] = value;
      Module["canvas"].addEventListener("click", GLFW.onClickRequestPointerLock, true);
      Module["canvas"].requestPointerLock();
      break;
     }
    default:
     {
      console.log("glfwSetInputMode called with unknown value parameter value: " + value + ".");
      break;
     }
    }
    break;
   }
  case 208898:
   {
    console.log("glfwSetInputMode called with GLFW_STICKY_KEYS mode not implemented.");
    break;
   }
  case 208899:
   {
    console.log("glfwSetInputMode called with GLFW_STICKY_MOUSE_BUTTONS mode not implemented.");
    break;
   }
  default:
   {
    console.log("glfwSetInputMode called with unknown mode parameter value: " + mode + ".");
    break;
   }
  }
 }),
 getKey: (function(winid, key) {
  var win = GLFW.WindowFromId(winid);
  if (!win) return 0;
  return win.keys[key];
 }),
 getMouseButton: (function(winid, button) {
  var win = GLFW.WindowFromId(winid);
  if (!win) return 0;
  return (win.buttons & 1 << button) > 0;
 }),
 getCursorPos: (function(winid, x, y) {
  setValue(x, Browser.mouseX, "double");
  setValue(y, Browser.mouseY, "double");
 }),
 getMousePos: (function(winid, x, y) {
  setValue(x, Browser.mouseX, "i32");
  setValue(y, Browser.mouseY, "i32");
 }),
 setCursorPos: (function(winid, x, y) {}),
 getWindowPos: (function(winid, x, y) {
  var wx = 0;
  var wy = 0;
  var win = GLFW.WindowFromId(winid);
  if (win) {
   wx = win.x;
   wy = win.y;
  }
  setValue(x, wx, "i32");
  setValue(y, wy, "i32");
 }),
 setWindowPos: (function(winid, x, y) {
  var win = GLFW.WindowFromId(winid);
  if (!win) return;
  win.x = x;
  win.y = y;
 }),
 getWindowSize: (function(winid, width, height) {
  var ww = 0;
  var wh = 0;
  var win = GLFW.WindowFromId(winid);
  if (win) {
   ww = win.width;
   wh = win.height;
  }
  setValue(width, ww, "i32");
  setValue(height, wh, "i32");
 }),
 setWindowSize: (function(winid, width, height) {
  var win = GLFW.WindowFromId(winid);
  if (!win) return;
  if (GLFW.active.id == win.id) {
   if (width == screen.width && height == screen.height) {
    GLFW.requestFullscreen();
   } else {
    GLFW.exitFullscreen();
    Browser.setCanvasSize(width, height);
    win.width = width;
    win.height = height;
   }
  }
  if (!win.windowSizeFunc) return;
  Runtime.dynCall("vii", win.windowSizeFunc, [ width, height ]);
 }),
 createWindow: (function(width, height, title, monitor, share) {
  var i, id;
  for (i = 0; i < GLFW.windows.length && GLFW.windows[i] !== null; i++) ;
  if (i > 0) throw "glfwCreateWindow only supports one window at time currently";
  id = i + 1;
  if (width <= 0 || height <= 0) return 0;
  if (monitor) {
   GLFW.requestFullscreen();
  } else {
   Browser.setCanvasSize(width, height);
  }
  for (i = 0; i < GLFW.windows.length && GLFW.windows[i] == null; i++) ;
  if (i == GLFW.windows.length) {
   var contextAttributes = {
    antialias: GLFW.hints[135181] > 1,
    depth: GLFW.hints[135173] > 0,
    stencil: GLFW.hints[135174] > 0,
    alpha: GLFW.hints[135172] > 0
   };
   Module.ctx = Browser.createContext(Module["canvas"], true, true, contextAttributes);
  }
  if (!Module.ctx) return 0;
  var win = new GLFW.Window(id, width, height, title, monitor, share);
  if (id - 1 == GLFW.windows.length) {
   GLFW.windows.push(win);
  } else {
   GLFW.windows[id - 1] = win;
  }
  GLFW.active = win;
  return win.id;
 }),
 destroyWindow: (function(winid) {
  var win = GLFW.WindowFromId(winid);
  if (!win) return;
  GLFW.windows[win.id - 1] = null;
  if (GLFW.active.id == win.id) GLFW.active = null;
  for (var i = 0; i < GLFW.windows.length; i++) if (GLFW.windows[i] !== null) return;
  Module.ctx = Browser.destroyContext(Module["canvas"], true, true);
 }),
 swapBuffers: (function(winid) {}),
 GLFW2ParamToGLFW3Param: (function(param) {
  table = {
   196609: 0,
   196610: 0,
   196611: 0,
   196612: 0,
   196613: 0,
   196614: 0,
   131073: 0,
   131074: 0,
   131075: 0,
   131076: 0,
   131077: 135169,
   131078: 135170,
   131079: 135171,
   131080: 135172,
   131081: 135173,
   131082: 135174,
   131083: 135183,
   131084: 135175,
   131085: 135176,
   131086: 135177,
   131087: 135178,
   131088: 135179,
   131089: 135180,
   131090: 0,
   131091: 135181,
   131092: 139266,
   131093: 139267,
   131094: 139270,
   131095: 139271,
   131096: 139272
  };
  return table[param];
 })
};
Module["GLFW"] = GLFW;
function _glfwInit() {
 if (GLFW.windows) return 1;
 GLFW.initialTime = GLFW.getTime();
 GLFW.hints = GLFW.defaultHints;
 GLFW.windows = new Array;
 GLFW.active = null;
 window.addEventListener("keydown", GLFW.onKeydown, true);
 window.addEventListener("keypress", GLFW.onKeyPress, true);
 window.addEventListener("keyup", GLFW.onKeyup, true);
 Module["canvas"].addEventListener("mousemove", GLFW.onMousemove, true);
 Module["canvas"].addEventListener("mousedown", GLFW.onMouseButtonDown, true);
 Module["canvas"].addEventListener("mouseup", GLFW.onMouseButtonUp, true);
 Module["canvas"].addEventListener("wheel", GLFW.onMouseWheel, true);
 Module["canvas"].addEventListener("mousewheel", GLFW.onMouseWheel, true);
 Module["canvas"].addEventListener("mouseenter", GLFW.onMouseenter, true);
 Module["canvas"].addEventListener("mouseleave", GLFW.onMouseleave, true);
 Browser.resizeListeners.push((function(width, height) {
  GLFW.onCanvasResize(width, height);
 }));
 return 1;
}
Module["_glfwInit"] = _glfwInit;
function _glfwTerminate() {
 window.removeEventListener("keydown", GLFW.onKeydown, true);
 window.removeEventListener("keypress", GLFW.onKeyPress, true);
 window.removeEventListener("keyup", GLFW.onKeyup, true);
 Module["canvas"].removeEventListener("mousemove", GLFW.onMousemove, true);
 Module["canvas"].removeEventListener("mousedown", GLFW.onMouseButtonDown, true);
 Module["canvas"].removeEventListener("mouseup", GLFW.onMouseButtonUp, true);
 Module["canvas"].removeEventListener("wheel", GLFW.onMouseWheel, true);
 Module["canvas"].removeEventListener("mousewheel", GLFW.onMouseWheel, true);
 Module["canvas"].removeEventListener("mouseenter", GLFW.onMouseenter, true);
 Module["canvas"].removeEventListener("mouseleave", GLFW.onMouseleave, true);
 Module["canvas"].width = Module["canvas"].height = 1;
 GLFW.windows = null;
 GLFW.active = null;
}
Module["_glfwTerminate"] = _glfwTerminate;
function _glfwGetVersion(major, minor, rev) {
 setValue(major, 2, "i32");
 setValue(minor, 7, "i32");
 setValue(rev, 7, "i32");
}
Module["_glfwGetVersion"] = _glfwGetVersion;
function _glfwPollEvents() {}
Module["_glfwPollEvents"] = _glfwPollEvents;
function _glfwWaitEvents() {}
Module["_glfwWaitEvents"] = _glfwWaitEvents;
function _glfwGetTime() {
 return GLFW.getTime() - GLFW.initialTime;
}
Module["_glfwGetTime"] = _glfwGetTime;
function _glfwSetTime(time) {
 GLFW.initialTime = GLFW.getTime() + time;
}
Module["_glfwSetTime"] = _glfwSetTime;
function _glfwExtensionSupported(extension) {
 if (!GLFW.extensions) {
  GLFW.extensions = Pointer_stringify(_glGetString(7939)).split(" ");
 }
 if (GLFW.extensions.indexOf(extension) != -1) return 1;
 return GLFW.extensions.indexOf("GL_" + extension) != -1;
}
Module["_glfwExtensionSupported"] = _glfwExtensionSupported;
function _glfwGetProcAddress(procname) {
 return _emscripten_GetProcAddress(procname);
}
Module["_glfwGetProcAddress"] = _glfwGetProcAddress;
function _glfwSwapInterval(interval) {
 interval = Math.abs(interval);
 if (interval == 0) _emscripten_set_main_loop_timing(0, 0); else _emscripten_set_main_loop_timing(1, interval);
}
Module["_glfwSwapInterval"] = _glfwSwapInterval;
function _glfwOpenWindow(width, height, redbits, greenbits, bluebits, alphabits, depthbits, stencilbits, mode) {
 GLFW.hints[135169] = redbits;
 GLFW.hints[135170] = greenbits;
 GLFW.hints[135171] = bluebits;
 GLFW.hints[135172] = alphabits;
 GLFW.hints[135173] = depthbits;
 GLFW.hints[135174] = stencilbits;
 GLFW.createWindow(width, height, "GLFW2 Window", 0, 0);
 return 1;
}
Module["_glfwOpenWindow"] = _glfwOpenWindow;
function _glfwCloseWindow() {
 GLFW.destroyWindow(GLFW.active.id);
}
Module["_glfwCloseWindow"] = _glfwCloseWindow;
function _glfwOpenWindowHint(target, hint) {
 target = GLFW.GLFW2ParamToGLFW3Param(target);
 GLFW.hints[target] = hint;
}
Module["_glfwOpenWindowHint"] = _glfwOpenWindowHint;
function _glfwGetWindowSize(width, height) {
 GLFW.getWindowSize(GLFW.active.id, width, height);
}
Module["_glfwGetWindowSize"] = _glfwGetWindowSize;
function _glfwSetWindowSize(width, height) {
 GLFW.setWindowSize(GLFW.active.id, width, height);
}
Module["_glfwSetWindowSize"] = _glfwSetWindowSize;
function _glfwGetWindowPos(x, y) {
 GLFW.getWindowPos(GLFW.active.id, x, y);
}
Module["_glfwGetWindowPos"] = _glfwGetWindowPos;
function _glfwSetWindowPos(x, y) {
 GLFW.setWindowPos(GLFW.active.id, x, y);
}
Module["_glfwSetWindowPos"] = _glfwSetWindowPos;
function _glfwSetWindowTitle(title) {
 GLFW.setWindowTitle(GLFW.active.id, title);
}
Module["_glfwSetWindowTitle"] = _glfwSetWindowTitle;
function _glfwIconifyWindow() {
 GLFW.iconifyWindow(GLFW.active.id);
}
Module["_glfwIconifyWindow"] = _glfwIconifyWindow;
function _glfwRestoreWindow() {
 GLFW.restoreWindow(GLFW.active.id);
}
Module["_glfwRestoreWindow"] = _glfwRestoreWindow;
function _glfwSwapBuffers() {
 GLFW.swapBuffers(GLFW.active.id);
}
Module["_glfwSwapBuffers"] = _glfwSwapBuffers;
function _glfwGetWindowParam(param) {
 param = GLFW.GLFW2ParamToGLFW3Param(param);
 return GLFW.hints[param];
}
Module["_glfwGetWindowParam"] = _glfwGetWindowParam;
function _glfwSetWindowSizeCallback(cbfun) {
 GLFW.setWindowSizeCallback(GLFW.active.id, cbfun);
}
Module["_glfwSetWindowSizeCallback"] = _glfwSetWindowSizeCallback;
function _glfwSetWindowCloseCallback(cbfun) {
 GLFW.setWindowCloseCallback(GLFW.active.id, cbfun);
}
Module["_glfwSetWindowCloseCallback"] = _glfwSetWindowCloseCallback;
function _glfwSetWindowRefreshCallback(cbfun) {
 GLFW.setWindowRefreshCallback(GLFW.active.id, cbfun);
}
Module["_glfwSetWindowRefreshCallback"] = _glfwSetWindowRefreshCallback;
function _glfwGetKey(key) {
 return GLFW.getKey(GLFW.active.id, key);
}
Module["_glfwGetKey"] = _glfwGetKey;
function _glfwGetMouseButton(button) {
 return GLFW.getMouseButton(GLFW.active.id, button);
}
Module["_glfwGetMouseButton"] = _glfwGetMouseButton;
function _glfwGetMousePos(x, y) {
 GLFW.getMousePos(GLFW.active.id, x, y);
}
Module["_glfwGetMousePos"] = _glfwGetMousePos;
function _glfwSetMousePos(x, y) {
 GLFW.setCursorPos(GLFW.active.id, x, y);
}
Module["_glfwSetMousePos"] = _glfwSetMousePos;
function _glfwGetMouseWheel() {
 return 0;
}
Module["_glfwGetMouseWheel"] = _glfwGetMouseWheel;
function _glfwSetMouseWheel(pos) {}
Module["_glfwSetMouseWheel"] = _glfwSetMouseWheel;
function _glfwSetKeyCallback(cbfun) {
 GLFW.setKeyCallback(GLFW.active.id, cbfun);
}
Module["_glfwSetKeyCallback"] = _glfwSetKeyCallback;
function _glfwSetCharCallback(cbfun) {
 GLFW.setCharCallback(GLFW.active.id, cbfun);
}
Module["_glfwSetCharCallback"] = _glfwSetCharCallback;
function _glfwSetMouseButtonCallback(cbfun) {
 GLFW.setMouseButtonCallback(GLFW.active.id, cbfun);
}
Module["_glfwSetMouseButtonCallback"] = _glfwSetMouseButtonCallback;
function _glfwSetMousePosCallback(cbfun) {
 GLFW.setCursorPosCallback(GLFW.active.id, cbfun);
}
Module["_glfwSetMousePosCallback"] = _glfwSetMousePosCallback;
function _glfwSetMouseWheelCallback(cbfun) {
 GLFW.setScrollCallback(GLFW.active.id, cbfun);
}
Module["_glfwSetMouseWheelCallback"] = _glfwSetMouseWheelCallback;
function _glfwGetDesktopMode(mode) {
 throw "glfwGetDesktopMode is not implemented.";
}
Module["_glfwGetDesktopMode"] = _glfwGetDesktopMode;
var _sleep = undefined;
function _glfwSleep(time) {
 _sleep(time);
}
Module["_glfwSleep"] = _glfwSleep;
function _glfwEnable(target) {
 target = GLFW.GLFW2ParamToGLFW3Param(target);
 GLFW.hints[target] = false;
}
Module["_glfwEnable"] = _glfwEnable;
function _glfwDisable(target) {
 target = GLFW.GLFW2ParamToGLFW3Param(target);
 GLFW.hints[target] = true;
}
Module["_glfwDisable"] = _glfwDisable;
function _glfwGetGLVersion(major, minor, rev) {
 setValue(major, 0, "i32");
 setValue(minor, 0, "i32");
 setValue(rev, 1, "i32");
}
Module["_glfwGetGLVersion"] = _glfwGetGLVersion;
function _glfwCreateThread(fun, arg) {
 var str = "v";
 for (var i in arg) {
  str += "i";
 }
 Runtime.dynCall(str, fun, arg);
 return 0;
}
Module["_glfwCreateThread"] = _glfwCreateThread;
function _glfwDestroyThread(ID) {}
Module["_glfwDestroyThread"] = _glfwDestroyThread;
function _glfwWaitThread(ID, waitmode) {}
Module["_glfwWaitThread"] = _glfwWaitThread;
function _glfwGetThreadID() {
 return 0;
}
Module["_glfwGetThreadID"] = _glfwGetThreadID;
function _glfwCreateMutex() {
 throw "glfwCreateMutex is not implemented.";
}
Module["_glfwCreateMutex"] = _glfwCreateMutex;
function _glfwDestroyMutex(mutex) {
 throw "glfwDestroyMutex is not implemented.";
}
Module["_glfwDestroyMutex"] = _glfwDestroyMutex;
function _glfwLockMutex(mutex) {
 throw "glfwLockMutex is not implemented.";
}
Module["_glfwLockMutex"] = _glfwLockMutex;
function _glfwUnlockMutex(mutex) {
 throw "glfwUnlockMutex is not implemented.";
}
Module["_glfwUnlockMutex"] = _glfwUnlockMutex;
function _glfwCreateCond() {
 throw "glfwCreateCond is not implemented.";
}
Module["_glfwCreateCond"] = _glfwCreateCond;
function _glfwDestroyCond(cond) {
 throw "glfwDestroyCond is not implemented.";
}
Module["_glfwDestroyCond"] = _glfwDestroyCond;
function _glfwWaitCond(cond, mutex, timeout) {
 throw "glfwWaitCond is not implemented.";
}
Module["_glfwWaitCond"] = _glfwWaitCond;
function _glfwSignalCond(cond) {
 throw "glfwSignalCond is not implemented.";
}
Module["_glfwSignalCond"] = _glfwSignalCond;
function _glfwBroadcastCond(cond) {
 throw "glfwBroadcastCond is not implemented.";
}
Module["_glfwBroadcastCond"] = _glfwBroadcastCond;
function _glfwGetNumberOfProcessors() {
 return 1;
}
Module["_glfwGetNumberOfProcessors"] = _glfwGetNumberOfProcessors;
function _glfwReadImage(name, img, flags) {
 throw "glfwReadImage is not implemented.";
}
Module["_glfwReadImage"] = _glfwReadImage;
function _glfwReadMemoryImage(data, size, img, flags) {
 throw "glfwReadMemoryImage is not implemented.";
}
Module["_glfwReadMemoryImage"] = _glfwReadMemoryImage;
function _glfwFreeImage(img) {
 throw "glfwFreeImage is not implemented.";
}
Module["_glfwFreeImage"] = _glfwFreeImage;
function _glfwLoadTexture2D(name, flags) {
 throw "glfwLoadTexture2D is not implemented.";
}
Module["_glfwLoadTexture2D"] = _glfwLoadTexture2D;
function _glfwLoadMemoryTexture2D(data, size, flags) {
 throw "glfwLoadMemoryTexture2D is not implemented.";
}
Module["_glfwLoadMemoryTexture2D"] = _glfwLoadMemoryTexture2D;
function _glfwLoadTextureImage2D(img, flags) {
 throw "glfwLoadTextureImage2D is not implemented.";
}
Module["_glfwLoadTextureImage2D"] = _glfwLoadTextureImage2D;
function _uuid_clear(uu) {
 _memset(uu, 0, 16);
}
Module["_uuid_clear"] = _uuid_clear;
var _memcmp = undefined;
function _uuid_compare(uu1, uu2) {
 return _memcmp(uu1, uu2, 16);
}
Module["_uuid_compare"] = _uuid_compare;
function _uuid_copy(dst, src) {
 _memcpy(dst, src, 16);
}
Module["_uuid_copy"] = _uuid_copy;
function _uuid_generate(out) {
 var uuid = null;
 if (ENVIRONMENT_IS_NODE) {
  try {
   var rb = require("crypto").randomBytes;
   uuid = rb(16);
  } catch (e) {}
 } else if (ENVIRONMENT_IS_WEB && typeof window.crypto !== "undefined" && typeof window.crypto.getRandomValues !== "undefined") {
  uuid = new Uint8Array(16);
  window.crypto.getRandomValues(uuid);
 }
 if (!uuid) {
  uuid = new Array(16);
  var d = (new Date).getTime();
  for (var i = 0; i < 16; i++) {
   var r = (d + Math.random() * 256) % 256 | 0;
   d = d / 256 | 0;
   uuid[i] = r;
  }
 }
 uuid[6] = uuid[6] & 15 | 64;
 uuid[8] = uuid[8] & 127 | 128;
 writeArrayToMemory(uuid, out);
}
Module["_uuid_generate"] = _uuid_generate;
function _uuid_is_null(uu) {
 for (var i = 0; i < 4; i++, uu = uu + 4 | 0) {
  var val = HEAP32[uu >> 2];
  if (val) {
   return 0;
  }
 }
 return 1;
}
Module["_uuid_is_null"] = _uuid_is_null;
function _uuid_parse(inp, uu) {
 var inp = Pointer_stringify(inp);
 if (inp.length === 36) {
  var i = 0;
  var uuid = new Array(16);
  inp.toLowerCase().replace(/[0-9a-f]{2}/g, (function(byte) {
   if (i < 16) {
    uuid[i++] = parseInt(byte, 16);
   }
  }));
  if (i < 16) {
   return -1;
  } else {
   writeArrayToMemory(uuid, uu);
   return 0;
  }
 } else {
  return -1;
 }
}
Module["_uuid_parse"] = _uuid_parse;
function _uuid_unparse(uu, out, upper) {
 var i = 0;
 var uuid = "xxxx-xx-xx-xx-xxxxxx".replace(/[x]/g, (function(c) {
  var r = upper ? HEAPU8[uu + i >> 0].toString(16).toUpperCase() : HEAPU8[uu + i >> 0].toString(16);
  r = r.length === 1 ? "0" + r : r;
  i++;
  return r;
 }));
 writeStringToMemory(uuid, out);
}
Module["_uuid_unparse"] = _uuid_unparse;
function _uuid_unparse_lower(uu, out) {
 _uuid_unparse(uu, out);
}
Module["_uuid_unparse_lower"] = _uuid_unparse_lower;
function _uuid_unparse_upper(uu, out) {
 _uuid_unparse(uu, out, true);
}
Module["_uuid_unparse_upper"] = _uuid_unparse_upper;
function _uuid_type(uu) {
 return 4;
}
Module["_uuid_type"] = _uuid_type;
function _uuid_variant(uu) {
 return 1;
}
Module["_uuid_variant"] = _uuid_variant;
var GLEW = {
 isLinaroFork: 1,
 extensions: null,
 error: {
  0: null,
  1: null,
  2: null,
  3: null,
  4: null,
  5: null,
  6: null,
  7: null,
  8: null
 },
 version: {
  1: null,
  2: null,
  3: null,
  4: null
 },
 errorStringConstantFromCode: (function(error) {
  if (GLEW.isLinaroFork) {
   switch (error) {
   case 4:
    return "OpenGL ES lib expected, found OpenGL lib";
   case 5:
    return "OpenGL lib expected, found OpenGL ES lib";
   case 6:
    return "Missing EGL version";
   case 7:
    return "EGL 1.1 and up are supported";
   default:
    break;
   }
  }
  switch (error) {
  case 0:
   return "No error";
  case 1:
   return "Missing GL version";
  case 2:
   return "GL 1.1 and up are supported";
  case 3:
   return "GLX 1.2 and up are supported";
  default:
   return null;
  }
 }),
 errorString: (function(error) {
  if (!GLEW.error[error]) {
   var string = GLEW.errorStringConstantFromCode(error);
   if (!string) {
    string = "Unknown error";
    error = 8;
   }
   GLEW.error[error] = allocate(intArrayFromString(string), "i8", ALLOC_NORMAL);
  }
  return GLEW.error[error];
 }),
 versionStringConstantFromCode: (function(name) {
  switch (name) {
  case 1:
   return "1.10.0";
  case 2:
   return "1";
  case 3:
   return "10";
  case 4:
   return "0";
  default:
   return null;
  }
 }),
 versionString: (function(name) {
  if (!GLEW.version[name]) {
   var string = GLEW.versionStringConstantFromCode(name);
   if (!string) return 0;
   GLEW.version[name] = allocate(intArrayFromString(string), "i8", ALLOC_NORMAL);
  }
  return GLEW.version[name];
 }),
 extensionIsSupported: (function(name) {
  if (!GLEW.extensions) {
   GLEW.extensions = Pointer_stringify(_glGetString(7939)).split(" ");
  }
  if (GLEW.extensions.indexOf(name) != -1) return 1;
  return GLEW.extensions.indexOf("GL_" + name) != -1;
 })
};
Module["GLEW"] = GLEW;
function _glewInit() {
 return 0;
}
Module["_glewInit"] = _glewInit;
function _glewIsSupported(name) {
 var exts = Pointer_stringify(name).split(" ");
 for (var i in exts) {
  if (!GLEW.extensionIsSupported(exts[i])) return 0;
 }
 return 1;
}
Module["_glewIsSupported"] = _glewIsSupported;
function _glewGetExtension(name) {
 return GLEW.extensionIsSupported(Pointer_stringify(name));
}
Module["_glewGetExtension"] = _glewGetExtension;
function _glewGetErrorString(error) {
 return GLEW.errorString(error);
}
Module["_glewGetErrorString"] = _glewGetErrorString;
function _glewGetString(name) {
 return GLEW.versionString(name);
}
Module["_glewGetString"] = _glewGetString;
function _emscripten_set_click_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerMouseEventCallback(target, userData, useCapture, callbackfunc, 4, "click");
 return 0;
}
Module["_emscripten_set_click_callback"] = _emscripten_set_click_callback;
function _emscripten_set_mouseenter_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerMouseEventCallback(target, userData, useCapture, callbackfunc, 33, "mouseenter");
 return 0;
}
Module["_emscripten_set_mouseenter_callback"] = _emscripten_set_mouseenter_callback;
function _emscripten_set_mouseleave_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerMouseEventCallback(target, userData, useCapture, callbackfunc, 34, "mouseleave");
 return 0;
}
Module["_emscripten_set_mouseleave_callback"] = _emscripten_set_mouseleave_callback;
function _emscripten_set_mouseover_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerMouseEventCallback(target, userData, useCapture, callbackfunc, 35, "mouseover");
 return 0;
}
Module["_emscripten_set_mouseover_callback"] = _emscripten_set_mouseover_callback;
function _emscripten_set_mouseout_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerMouseEventCallback(target, userData, useCapture, callbackfunc, 36, "mouseout");
 return 0;
}
Module["_emscripten_set_mouseout_callback"] = _emscripten_set_mouseout_callback;
function _emscripten_get_mouse_status(mouseState) {
 if (!JSEvents.mouseEvent) return -7;
 HEAP32.set(HEAP32.subarray(JSEvents.mouseEvent, 72), mouseState);
 return 0;
}
Module["_emscripten_get_mouse_status"] = _emscripten_get_mouse_status;
function _emscripten_set_resize_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerUiEventCallback(target, userData, useCapture, callbackfunc, 10, "resize");
 return 0;
}
Module["_emscripten_set_resize_callback"] = _emscripten_set_resize_callback;
function _emscripten_set_scroll_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerUiEventCallback(target, userData, useCapture, callbackfunc, 11, "scroll");
 return 0;
}
Module["_emscripten_set_scroll_callback"] = _emscripten_set_scroll_callback;
function _emscripten_set_focusin_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerFocusEventCallback(target, userData, useCapture, callbackfunc, 14, "focusin");
 return 0;
}
Module["_emscripten_set_focusin_callback"] = _emscripten_set_focusin_callback;
function _emscripten_set_focusout_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerFocusEventCallback(target, userData, useCapture, callbackfunc, 15, "focusout");
 return 0;
}
Module["_emscripten_set_focusout_callback"] = _emscripten_set_focusout_callback;
function _emscripten_get_deviceorientation_status(orientationState) {
 if (!JSEvents.deviceOrientationEvent) return -7;
 HEAP32.set(HEAP32.subarray(JSEvents.deviceOrientationEvent, 40), orientationState);
 return 0;
}
Module["_emscripten_get_deviceorientation_status"] = _emscripten_get_deviceorientation_status;
function _emscripten_get_devicemotion_status(motionState) {
 if (!JSEvents.deviceMotionEvent) return -7;
 HEAP32.set(HEAP32.subarray(JSEvents.deviceMotionEvent, 80), motionState);
 return 0;
}
Module["_emscripten_get_devicemotion_status"] = _emscripten_get_devicemotion_status;
function _emscripten_set_orientationchange_callback(userData, useCapture, callbackfunc) {
 if (!window.screen || !window.screen.addEventListener) return -1;
 JSEvents.registerOrientationChangeEventCallback(window.screen, userData, useCapture, callbackfunc, 18, "orientationchange");
 return 0;
}
Module["_emscripten_set_orientationchange_callback"] = _emscripten_set_orientationchange_callback;
function _emscripten_get_orientation_status(orientationChangeEvent) {
 if (!JSEvents.screenOrientation() && typeof window.orientation === "undefined") return -1;
 JSEvents.fillOrientationChangeEventData(orientationChangeEvent);
 return 0;
}
Module["_emscripten_get_orientation_status"] = _emscripten_get_orientation_status;
function _emscripten_lock_orientation(allowedOrientations) {
 var orientations = [];
 if (allowedOrientations & 1) orientations.push("portrait-primary");
 if (allowedOrientations & 2) orientations.push("portrait-secondary");
 if (allowedOrientations & 4) orientations.push("landscape-primary");
 if (allowedOrientations & 8) orientations.push("landscape-secondary");
 var succeeded;
 if (window.screen.lockOrientation) {
  succeeded = window.screen.lockOrientation(orientations);
 } else if (window.screen.mozLockOrientation) {
  succeeded = window.screen.mozLockOrientation(orientations);
 } else if (window.screen.webkitLockOrientation) {
  succeeded = window.screen.webkitLockOrientation(orientations);
 } else if (window.screen.msLockOrientation) {
  succeeded = window.screen.msLockOrientation(orientations);
 } else {
  return -1;
 }
 if (succeeded) {
  return 0;
 } else {
  return -6;
 }
}
Module["_emscripten_lock_orientation"] = _emscripten_lock_orientation;
function _emscripten_unlock_orientation() {
 if (window.screen.unlockOrientation) {
  window.screen.unlockOrientation();
 } else if (window.screen.mozUnlockOrientation) {
  window.screen.mozUnlockOrientation();
 } else if (window.screen.webkitUnlockOrientation) {
  window.screen.webkitUnlockOrientation();
 } else if (window.screen.msUnlockOrientation) {
  window.screen.msUnlockOrientation();
 } else {
  return -1;
 }
 return 0;
}
Module["_emscripten_unlock_orientation"] = _emscripten_unlock_orientation;
function __registerRestoreOldStyle(canvas) {
 var oldWidth = canvas.width;
 var oldHeight = canvas.height;
 var oldCssWidth = canvas.style.width;
 var oldCssHeight = canvas.style.height;
 var oldBackgroundColor = canvas.style.backgroundColor;
 var oldDocumentBackgroundColor = document.body.style.backgroundColor;
 var oldPaddingLeft = canvas.style.paddingLeft;
 var oldPaddingRight = canvas.style.paddingRight;
 var oldPaddingTop = canvas.style.paddingTop;
 var oldPaddingBottom = canvas.style.paddingBottom;
 var oldMarginLeft = canvas.style.marginLeft;
 var oldMarginRight = canvas.style.marginRight;
 var oldMarginTop = canvas.style.marginTop;
 var oldMarginBottom = canvas.style.marginBottom;
 var oldDocumentBodyMargin = document.body.style.margin;
 var oldDocumentOverflow = document.documentElement.style.overflow;
 var oldDocumentScroll = document.body.scroll;
 var oldImageRendering = canvas.style.imageRendering;
 function restoreOldStyle() {
  var fullscreenElement = document.fullscreenElement || document.mozFullScreenElement || document.webkitFullscreenElement || document.msFullscreenElement;
  if (!fullscreenElement) {
   document.removeEventListener("fullscreenchange", restoreOldStyle);
   document.removeEventListener("mozfullscreenchange", restoreOldStyle);
   document.removeEventListener("webkitfullscreenchange", restoreOldStyle);
   document.removeEventListener("MSFullscreenChange", restoreOldStyle);
   canvas.width = oldWidth;
   canvas.height = oldHeight;
   canvas.style.width = oldCssWidth;
   canvas.style.height = oldCssHeight;
   canvas.style.backgroundColor = oldBackgroundColor;
   if (!oldDocumentBackgroundColor) document.body.style.backgroundColor = "white";
   document.body.style.backgroundColor = oldDocumentBackgroundColor;
   canvas.style.paddingLeft = oldPaddingLeft;
   canvas.style.paddingRight = oldPaddingRight;
   canvas.style.paddingTop = oldPaddingTop;
   canvas.style.paddingBottom = oldPaddingBottom;
   canvas.style.marginLeft = oldMarginLeft;
   canvas.style.marginRight = oldMarginRight;
   canvas.style.marginTop = oldMarginTop;
   canvas.style.marginBottom = oldMarginBottom;
   document.body.style.margin = oldDocumentBodyMargin;
   document.documentElement.style.overflow = oldDocumentOverflow;
   document.body.scroll = oldDocumentScroll;
   canvas.style.imageRendering = oldImageRendering;
   if (canvas.GLctxObject) canvas.GLctxObject.GLctx.viewport(0, 0, oldWidth, oldHeight);
   if (__currentFullscreenStrategy.canvasResizedCallback) {
    Runtime.dynCall("iiii", __currentFullscreenStrategy.canvasResizedCallback, [ 37, 0, __currentFullscreenStrategy.canvasResizedCallbackUserData ]);
   }
  }
 }
 document.addEventListener("fullscreenchange", restoreOldStyle);
 document.addEventListener("mozfullscreenchange", restoreOldStyle);
 document.addEventListener("webkitfullscreenchange", restoreOldStyle);
 document.addEventListener("MSFullscreenChange", restoreOldStyle);
 return restoreOldStyle;
}
Module["__registerRestoreOldStyle"] = __registerRestoreOldStyle;
function __hideEverythingExceptGivenElement(onlyVisibleElement) {
 var child = onlyVisibleElement;
 var parent = child.parentNode;
 var hiddenElements = [];
 while (child != document.body) {
  var children = parent.children;
  for (var i = 0; i < children.length; ++i) {
   if (children[i] != child) {
    hiddenElements.push({
     node: children[i],
     displayState: children[i].style.display
    });
    children[i].style.display = "none";
   }
  }
  child = parent;
  parent = parent.parentNode;
 }
 return hiddenElements;
}
Module["__hideEverythingExceptGivenElement"] = __hideEverythingExceptGivenElement;
function __restoreHiddenElements(hiddenElements) {
 for (var i = 0; i < hiddenElements.length; ++i) {
  hiddenElements[i].node.style.display = hiddenElements[i].displayState;
 }
}
Module["__restoreHiddenElements"] = __restoreHiddenElements;
var __restoreOldWindowedStyle = null;
Module["__restoreOldWindowedStyle"] = __restoreOldWindowedStyle;
function __softFullscreenResizeWebGLRenderTarget() {
 var inHiDPIFullscreenMode = __currentFullscreenStrategy.canvasResolutionScaleMode == 2;
 var inAspectRatioFixedFullscreenMode = __currentFullscreenStrategy.scaleMode == 2;
 var inPixelPerfectFullscreenMode = __currentFullscreenStrategy.canvasResolutionScaleMode != 0;
 var inCenteredWithoutScalingFullscreenMode = __currentFullscreenStrategy.scaleMode == 3;
 var screenWidth = inHiDPIFullscreenMode ? Math.round(window.innerWidth * window.devicePixelRatio) : window.innerWidth;
 var screenHeight = inHiDPIFullscreenMode ? Math.round(window.innerHeight * window.devicePixelRatio) : window.innerHeight;
 var w = screenWidth;
 var h = screenHeight;
 var canvas = __currentFullscreenStrategy.target;
 var x = canvas.width;
 var y = canvas.height;
 var topMargin;
 if (inAspectRatioFixedFullscreenMode) {
  if (w * y < x * h) h = w * y / x | 0; else if (w * y > x * h) w = h * x / y | 0;
  topMargin = (screenHeight - h) / 2 | 0;
 }
 if (inPixelPerfectFullscreenMode) {
  canvas.width = w;
  canvas.height = h;
  if (canvas.GLctxObject) canvas.GLctxObject.GLctx.viewport(0, 0, canvas.width, canvas.height);
 }
 if (inHiDPIFullscreenMode) {
  topMargin /= window.devicePixelRatio;
  w /= window.devicePixelRatio;
  h /= window.devicePixelRatio;
  w = Math.round(w * 1e4) / 1e4;
  h = Math.round(h * 1e4) / 1e4;
  topMargin = Math.round(topMargin * 1e4) / 1e4;
 }
 if (inCenteredWithoutScalingFullscreenMode) {
  var t = (window.innerHeight - parseInt(canvas.style.height)) / 2;
  var b = (window.innerWidth - parseInt(canvas.style.width)) / 2;
  __setLetterbox(canvas, t, b);
 } else {
  canvas.style.width = w + "px";
  canvas.style.height = h + "px";
  var b = (window.innerWidth - w) / 2;
  __setLetterbox(canvas, topMargin, b);
 }
 if (!inCenteredWithoutScalingFullscreenMode && __currentFullscreenStrategy.canvasResizedCallback) {
  Runtime.dynCall("iiii", __currentFullscreenStrategy.canvasResizedCallback, [ 37, 0, __currentFullscreenStrategy.canvasResizedCallbackUserData ]);
 }
}
Module["__softFullscreenResizeWebGLRenderTarget"] = __softFullscreenResizeWebGLRenderTarget;
function _emscripten_request_fullscreen_strategy(target, deferUntilInEventHandler, fullscreenStrategy) {
 var strategy = {};
 strategy.scaleMode = HEAP32[fullscreenStrategy >> 2];
 strategy.canvasResolutionScaleMode = HEAP32[fullscreenStrategy + 4 >> 2];
 strategy.filteringMode = HEAP32[fullscreenStrategy + 8 >> 2];
 strategy.deferUntilInEventHandler = deferUntilInEventHandler;
 strategy.canvasResizedCallback = HEAP32[fullscreenStrategy + 12 >> 2];
 strategy.canvasResizedCallbackUserData = HEAP32[fullscreenStrategy + 16 >> 2];
 __currentFullscreenStrategy = strategy;
 return _emscripten_do_request_fullscreen(target, strategy);
}
Module["_emscripten_request_fullscreen_strategy"] = _emscripten_request_fullscreen_strategy;
function _emscripten_enter_soft_fullscreen(target, fullscreenStrategy) {
 if (!target) target = "#canvas";
 target = JSEvents.findEventTarget(target);
 if (!target) return -4;
 var strategy = {};
 strategy.scaleMode = HEAP32[fullscreenStrategy >> 2];
 strategy.canvasResolutionScaleMode = HEAP32[fullscreenStrategy + 4 >> 2];
 strategy.filteringMode = HEAP32[fullscreenStrategy + 8 >> 2];
 strategy.canvasResizedCallback = HEAP32[fullscreenStrategy + 12 >> 2];
 strategy.canvasResizedCallbackUserData = HEAP32[fullscreenStrategy + 16 >> 2];
 strategy.target = target;
 strategy.softFullscreen = true;
 var restoreOldStyle = JSEvents.resizeCanvasForFullscreen(target, strategy);
 document.documentElement.style.overflow = "hidden";
 document.body.scroll = "no";
 document.body.style.margin = "0px";
 var hiddenElements = __hideEverythingExceptGivenElement(target);
 function restoreWindowedState() {
  restoreOldStyle();
  __restoreHiddenElements(hiddenElements);
  window.removeEventListener("resize", __softFullscreenResizeWebGLRenderTarget);
  if (strategy.canvasResizedCallback) {
   Runtime.dynCall("iiii", strategy.canvasResizedCallback, [ 37, 0, strategy.canvasResizedCallbackUserData ]);
  }
 }
 __restoreOldWindowedStyle = restoreWindowedState;
 __currentFullscreenStrategy = strategy;
 window.addEventListener("resize", __softFullscreenResizeWebGLRenderTarget);
 if (strategy.canvasResizedCallback) {
  Runtime.dynCall("iiii", strategy.canvasResizedCallback, [ 37, 0, strategy.canvasResizedCallbackUserData ]);
 }
 return 0;
}
Module["_emscripten_enter_soft_fullscreen"] = _emscripten_enter_soft_fullscreen;
function _emscripten_exit_soft_fullscreen() {
 if (__restoreOldWindowedStyle) __restoreOldWindowedStyle();
 __restoreOldWindowedStyle = null;
 return 0;
}
Module["_emscripten_exit_soft_fullscreen"] = _emscripten_exit_soft_fullscreen;
function _emscripten_set_pointerlockchange_callback(target, userData, useCapture, callbackfunc) {
 if (!document.body.requestPointerLock && !document.body.mozRequestPointerLock && !document.body.webkitRequestPointerLock && !document.body.msRequestPointerLock) {
  return -1;
 }
 if (!target) target = document; else {
  target = JSEvents.findEventTarget(target);
  if (!target) return -4;
 }
 JSEvents.registerPointerlockChangeEventCallback(target, userData, useCapture, callbackfunc, 20, "pointerlockchange");
 JSEvents.registerPointerlockChangeEventCallback(target, userData, useCapture, callbackfunc, 20, "mozpointerlockchange");
 JSEvents.registerPointerlockChangeEventCallback(target, userData, useCapture, callbackfunc, 20, "webkitpointerlockchange");
 JSEvents.registerPointerlockChangeEventCallback(target, userData, useCapture, callbackfunc, 20, "mspointerlockchange");
 return 0;
}
Module["_emscripten_set_pointerlockchange_callback"] = _emscripten_set_pointerlockchange_callback;
function _emscripten_set_pointerlockerror_callback(target, userData, useCapture, callbackfunc) {
 if (!document.body.requestPointerLock && !document.body.mozRequestPointerLock && !document.body.webkitRequestPointerLock && !document.body.msRequestPointerLock) {
  return -1;
 }
 if (!target) target = document; else {
  target = JSEvents.findEventTarget(target);
  if (!target) return -4;
 }
 JSEvents.registerPointerlockErrorEventCallback(target, userData, useCapture, callbackfunc, 38, "pointerlockerror");
 JSEvents.registerPointerlockErrorEventCallback(target, userData, useCapture, callbackfunc, 38, "mozpointerlockerror");
 JSEvents.registerPointerlockErrorEventCallback(target, userData, useCapture, callbackfunc, 38, "webkitpointerlockerror");
 JSEvents.registerPointerlockErrorEventCallback(target, userData, useCapture, callbackfunc, 38, "mspointerlockerror");
 return 0;
}
Module["_emscripten_set_pointerlockerror_callback"] = _emscripten_set_pointerlockerror_callback;
function _emscripten_vibrate(msecs) {
 if (!navigator.vibrate) return -1;
 navigator.vibrate(msecs);
 return 0;
}
Module["_emscripten_vibrate"] = _emscripten_vibrate;
function _emscripten_vibrate_pattern(msecsArray, numEntries) {
 if (!navigator.vibrate) return -1;
 var vibrateList = [];
 for (var i = 0; i < numEntries; ++i) {
  var msecs = HEAP32[msecsArray + i * 4 >> 2];
  vibrateList.push(msecs);
 }
 navigator.vibrate(vibrateList);
 return 0;
}
Module["_emscripten_vibrate_pattern"] = _emscripten_vibrate_pattern;
function _emscripten_set_visibilitychange_callback(userData, useCapture, callbackfunc) {
 JSEvents.registerVisibilityChangeEventCallback(document, userData, useCapture, callbackfunc, 21, "visibilitychange");
 return 0;
}
Module["_emscripten_set_visibilitychange_callback"] = _emscripten_set_visibilitychange_callback;
function _emscripten_get_visibility_status(visibilityStatus) {
 if (typeof document.visibilityState === "undefined" && typeof document.hidden === "undefined") {
  return -1;
 }
 JSEvents.fillVisibilityChangeEventData(visibilityStatus);
 return 0;
}
Module["_emscripten_get_visibility_status"] = _emscripten_get_visibility_status;
function _emscripten_set_gamepadconnected_callback(userData, useCapture, callbackfunc) {
 if (!navigator.getGamepads && !navigator.webkitGetGamepads) return -1;
 JSEvents.registerGamepadEventCallback(window, userData, useCapture, callbackfunc, 26, "gamepadconnected");
 return 0;
}
Module["_emscripten_set_gamepadconnected_callback"] = _emscripten_set_gamepadconnected_callback;
function _emscripten_set_gamepaddisconnected_callback(userData, useCapture, callbackfunc) {
 if (!navigator.getGamepads && !navigator.webkitGetGamepads) return -1;
 JSEvents.registerGamepadEventCallback(window, userData, useCapture, callbackfunc, 27, "gamepaddisconnected");
 return 0;
}
Module["_emscripten_set_gamepaddisconnected_callback"] = _emscripten_set_gamepaddisconnected_callback;
function _emscripten_set_beforeunload_callback(userData, callbackfunc) {
 if (typeof window.onbeforeunload === "undefined") return -1;
 JSEvents.registerBeforeUnloadEventCallback(window, userData, true, callbackfunc, 28, "beforeunload");
 return 0;
}
Module["_emscripten_set_beforeunload_callback"] = _emscripten_set_beforeunload_callback;
function _emscripten_set_batterychargingchange_callback(userData, callbackfunc) {
 if (!JSEvents.battery()) return -1;
 JSEvents.registerBatteryEventCallback(JSEvents.battery(), userData, true, callbackfunc, 29, "chargingchange");
 return 0;
}
Module["_emscripten_set_batterychargingchange_callback"] = _emscripten_set_batterychargingchange_callback;
function _emscripten_set_batterylevelchange_callback(userData, callbackfunc) {
 if (!JSEvents.battery()) return -1;
 JSEvents.registerBatteryEventCallback(JSEvents.battery(), userData, true, callbackfunc, 30, "levelchange");
 return 0;
}
Module["_emscripten_set_batterylevelchange_callback"] = _emscripten_set_batterylevelchange_callback;
function _emscripten_get_battery_status(batteryState) {
 if (!JSEvents.battery()) return -1;
 JSEvents.fillBatteryEventData(batteryState, JSEvents.battery());
 return 0;
}
Module["_emscripten_get_battery_status"] = _emscripten_get_battery_status;
function _emscripten_webgl_commit_frame() {
 if (!GL.currentContext || !GL.currentContext.GLctx) {
  return -3;
 }
 if (!GL.currentContext.GLctx.commit) {
  return -1;
 }
 if (!GL.currentContext.attributes.explicitSwapControl) {
  return -3;
 }
 GL.currentContext.GLctx.commit();
 return 0;
}
Module["_emscripten_webgl_commit_frame"] = _emscripten_webgl_commit_frame;
function _emscripten_set_webglcontextlost_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerWebGlEventCallback(target, userData, useCapture, callbackfunc, 31, "webglcontextlost");
 return 0;
}
Module["_emscripten_set_webglcontextlost_callback"] = _emscripten_set_webglcontextlost_callback;
function _emscripten_set_webglcontextrestored_callback(target, userData, useCapture, callbackfunc) {
 JSEvents.registerWebGlEventCallback(target, userData, useCapture, callbackfunc, 32, "webglcontextrestored");
 return 0;
}
Module["_emscripten_set_webglcontextrestored_callback"] = _emscripten_set_webglcontextrestored_callback;
function _emscripten_is_webgl_context_lost(target) {
 if (!Module["ctx"]) return true;
 return Module["ctx"].isContextLost();
}
Module["_emscripten_is_webgl_context_lost"] = _emscripten_is_webgl_context_lost;
function _emscripten_set_element_css_size(target, width, height) {
 if (!target) {
  target = Module["canvas"];
 } else {
  target = JSEvents.findEventTarget(target);
 }
 if (!target) return -4;
 target.style.setProperty("width", width + "px");
 target.style.setProperty("height", height + "px");
 return 0;
}
Module["_emscripten_set_element_css_size"] = _emscripten_set_element_css_size;
function _emscripten_get_element_css_size(target, width, height) {
 if (!target) {
  target = Module["canvas"];
 } else {
  target = JSEvents.findEventTarget(target);
 }
 if (!target) return -4;
 if (target.getBoundingClientRect) {
  var rect = target.getBoundingClientRect();
  HEAPF64[width >> 3] = rect.right - rect.left;
  HEAPF64[height >> 3] = rect.bottom - rect.top;
 } else {
  HEAPF64[width >> 3] = target.clientWidth;
  HEAPF64[height >> 3] = target.clientHeight;
 }
 return 0;
}
Module["_emscripten_get_element_css_size"] = _emscripten_get_element_css_size;
var __sigalrm_handler = 0;
Module["__sigalrm_handler"] = __sigalrm_handler;
function _signal(sig, func) {
 if (sig == 14) {
  __sigalrm_handler = func;
 } else {
  Module.printErr("Calling stub instead of signal()");
 }
 return 0;
}
Module["_signal"] = _signal;
function _sigemptyset(set) {
 HEAP32[set >> 2] = 0;
 return 0;
}
Module["_sigemptyset"] = _sigemptyset;
function _sigfillset(set) {
 HEAP32[set >> 2] = -1 >>> 0;
 return 0;
}
Module["_sigfillset"] = _sigfillset;
function _sigaddset(set, signum) {
 HEAP32[set >> 2] = HEAP32[set >> 2] | 1 << signum - 1;
 return 0;
}
Module["_sigaddset"] = _sigaddset;
function _sigdelset(set, signum) {
 HEAP32[set >> 2] = HEAP32[set >> 2] & ~(1 << signum - 1);
 return 0;
}
Module["_sigdelset"] = _sigdelset;
function _sigismember(set, signum) {
 return HEAP32[set >> 2] & 1 << signum - 1;
}
Module["_sigismember"] = _sigismember;
function _sigaction(signum, act, oldact) {
 Module.printErr("Calling stub instead of sigaction()");
 return 0;
}
Module["_sigaction"] = _sigaction;
function _sigprocmask() {
 Module.printErr("Calling stub instead of sigprocmask()");
 return 0;
}
Module["_sigprocmask"] = _sigprocmask;
function ___libc_current_sigrtmin() {
 Module.printErr("Calling stub instead of __libc_current_sigrtmin");
 return 0;
}
Module["___libc_current_sigrtmin"] = ___libc_current_sigrtmin;
function ___libc_current_sigrtmax() {
 Module.printErr("Calling stub instead of __libc_current_sigrtmax");
 return 0;
}
Module["___libc_current_sigrtmax"] = ___libc_current_sigrtmax;
function _killpg() {
 Module.printErr("Calling stub instead of killpg()");
 ___setErrNo(ERRNO_CODES.EPERM);
 return -1;
}
Module["_killpg"] = _killpg;
function _siginterrupt() {
 Module.printErr("Calling stub instead of siginterrupt()");
 return 0;
}
Module["_siginterrupt"] = _siginterrupt;
function _raise(sig) {
 Module.printErr("Calling stub instead of raise()");
 ___setErrNo(ERRNO_CODES.ENOSYS);
 Runtime.warnOnce("raise() returning an error as we do not support it");
 return -1;
}
Module["_raise"] = _raise;
function _alarm(seconds) {
 setTimeout((function() {
  if (__sigalrm_handler) Runtime.dynCall("vi", __sigalrm_handler, [ 0 ]);
 }), seconds * 1e3);
}
Module["_alarm"] = _alarm;
function _ualarm() {
 throw "ualarm() is not implemented yet";
}
Module["_ualarm"] = _ualarm;
function _getitimer() {
 throw "getitimer() is not implemented yet";
}
Module["_getitimer"] = _getitimer;
function _pause() {
 Module.printErr("Calling stub instead of pause()");
 ___setErrNo(ERRNO_CODES.EINTR);
 return -1;
}
Module["_pause"] = _pause;
function _sigpending(set) {
 HEAP32[set >> 2] = 0;
 return 0;
}
Module["_sigpending"] = _sigpending;
var IDBStore = {
 indexedDB: (function() {
  if (typeof indexedDB !== "undefined") return indexedDB;
  var ret = null;
  if (typeof window === "object") ret = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
  assert(ret, "IDBStore used, but indexedDB not supported");
  return ret;
 }),
 DB_VERSION: 22,
 DB_STORE_NAME: "FILE_DATA",
 dbs: {},
 blobs: [ 0 ],
 getDB: (function(name, callback) {
  var db = IDBStore.dbs[name];
  if (db) {
   return callback(null, db);
  }
  var req;
  try {
   req = IDBStore.indexedDB().open(name, IDBStore.DB_VERSION);
  } catch (e) {
   return callback(e);
  }
  req.onupgradeneeded = (function(e) {
   var db = e.target.result;
   var transaction = e.target.transaction;
   var fileStore;
   if (db.objectStoreNames.contains(IDBStore.DB_STORE_NAME)) {
    fileStore = transaction.objectStore(IDBStore.DB_STORE_NAME);
   } else {
    fileStore = db.createObjectStore(IDBStore.DB_STORE_NAME);
   }
  });
  req.onsuccess = (function() {
   db = req.result;
   IDBStore.dbs[name] = db;
   callback(null, db);
  });
  req.onerror = (function(e) {
   callback(this.error);
   e.preventDefault();
  });
 }),
 getStore: (function(dbName, type, callback) {
  IDBStore.getDB(dbName, (function(error, db) {
   var transaction = db.transaction([ IDBStore.DB_STORE_NAME ], type);
   transaction.onerror = (function(e) {
    callback(this.error || "unknown error");
    e.preventDefault();
   });
   var store = transaction.objectStore(IDBStore.DB_STORE_NAME);
   callback(null, store);
  }));
 }),
 getFile: (function(dbName, id, callback) {
  IDBStore.getStore(dbName, "readonly", (function(err, store) {
   if (err) return callback(err);
   var req = store.get(id);
   req.onsuccess = (function(event) {
    var result = event.target.result;
    if (!result) {
     return callback("file " + id + " not found");
    } else {
     return callback(null, result);
    }
   });
   req.onerror = (function(error) {
    callback(error);
   });
  }));
 }),
 setFile: (function(dbName, id, data, callback) {
  IDBStore.getStore(dbName, "readwrite", (function(err, store) {
   if (err) return callback(err);
   var req = store.put(data, id);
   req.onsuccess = (function(event) {
    callback();
   });
   req.onerror = (function(error) {
    callback(error);
   });
  }));
 }),
 deleteFile: (function(dbName, id, callback) {
  IDBStore.getStore(dbName, "readwrite", (function(err, store) {
   if (err) return callback(err);
   var req = store.delete(id);
   req.onsuccess = (function(event) {
    callback();
   });
   req.onerror = (function(error) {
    callback(error);
   });
  }));
 }),
 existsFile: (function(dbName, id, callback) {
  IDBStore.getStore(dbName, "readonly", (function(err, store) {
   if (err) return callback(err);
   var req = store.count(id);
   req.onsuccess = (function(event) {
    callback(null, event.target.result > 0);
   });
   req.onerror = (function(error) {
    callback(error);
   });
  }));
 })
};
Module["IDBStore"] = IDBStore;
function _emscripten_idb_async_load(db, id, arg, onload, onerror) {
 IDBStore.getFile(Pointer_stringify(db), Pointer_stringify(id), (function(error, byteArray) {
  if (error) {
   if (onerror) Runtime.dynCall("vi", onerror, [ arg ]);
   return;
  }
  var buffer = _malloc(byteArray.length);
  HEAPU8.set(byteArray, buffer);
  Runtime.dynCall("viii", onload, [ arg, buffer, byteArray.length ]);
  _free(buffer);
 }));
}
Module["_emscripten_idb_async_load"] = _emscripten_idb_async_load;
function _emscripten_idb_async_store(db, id, ptr, num, arg, onstore, onerror) {
 IDBStore.setFile(Pointer_stringify(db), Pointer_stringify(id), new Uint8Array(HEAPU8.subarray(ptr, ptr + num)), (function(error) {
  if (error) {
   if (onerror) Runtime.dynCall("vi", onerror, [ arg ]);
   return;
  }
  if (onstore) Runtime.dynCall("vi", onstore, [ arg ]);
 }));
}
Module["_emscripten_idb_async_store"] = _emscripten_idb_async_store;
function _emscripten_idb_async_delete(db, id, arg, ondelete, onerror) {
 IDBStore.deleteFile(Pointer_stringify(db), Pointer_stringify(id), (function(error) {
  if (error) {
   if (onerror) Runtime.dynCall("vi", onerror, [ arg ]);
   return;
  }
  if (ondelete) Runtime.dynCall("vi", ondelete, [ arg ]);
 }));
}
Module["_emscripten_idb_async_delete"] = _emscripten_idb_async_delete;
function _emscripten_idb_async_exists(db, id, arg, oncheck, onerror) {
 IDBStore.existsFile(Pointer_stringify(db), Pointer_stringify(id), (function(error, exists) {
  if (error) {
   if (onerror) Runtime.dynCall("vi", onerror, [ arg ]);
   return;
  }
  if (oncheck) Runtime.dynCall("vii", oncheck, [ arg, exists ]);
 }));
}
Module["_emscripten_idb_async_exists"] = _emscripten_idb_async_exists;
function _emscripten_idb_load() {
 throw "Please compile your program with async support in order to use synchronous operations like emscripten_idb_load, etc.";
}
Module["_emscripten_idb_load"] = _emscripten_idb_load;
function _emscripten_idb_store() {
 throw "Please compile your program with async support in order to use synchronous operations like emscripten_idb_store, etc.";
}
Module["_emscripten_idb_store"] = _emscripten_idb_store;
function _emscripten_idb_delete() {
 throw "Please compile your program with async support in order to use synchronous operations like emscripten_idb_delete, etc.";
}
Module["_emscripten_idb_delete"] = _emscripten_idb_delete;
function _emscripten_idb_exists() {
 throw "Please compile your program with async support in order to use synchronous operations like emscripten_idb_exists, etc.";
}
Module["_emscripten_idb_exists"] = _emscripten_idb_exists;
function _emscripten_sleep() {
 throw "Please compile your program with async support in order to use asynchronous operations like emscripten_sleep";
}
Module["_emscripten_sleep"] = _emscripten_sleep;
function _emscripten_coroutine_create() {
 throw "Please compile your program with async support in order to use asynchronous operations like emscripten_coroutine_create";
}
Module["_emscripten_coroutine_create"] = _emscripten_coroutine_create;
function _emscripten_coroutine_next() {
 throw "Please compile your program with async support in order to use asynchronous operations like emscripten_coroutine_next";
}
Module["_emscripten_coroutine_next"] = _emscripten_coroutine_next;
function _emscripten_yield() {
 throw "Please compile your program with async support in order to use asynchronous operations like emscripten_yield";
}
Module["_emscripten_yield"] = _emscripten_yield;
var WebVR = {
 DEVICE_TYPE_UNKNOWN: 0,
 DEVICE_TYPE_HMD: 1,
 DEVICE_TYPE_SENSOR: 2,
 EYE_LEFT: 0,
 EYE_RIGHT: 1,
 initialized: false,
 ready: false,
 devices: [],
 deviceHardwareIds: {},
 nextHardwareDeviceId: 1,
 getDevicesPromise: null,
 selectedHMD: null,
 selectedHMDId: 0,
 init: (function() {
  if (WebVR.initialized) return;
  WebVR.initialized = true;
  if (!navigator.getVRDevices) {
   WebVR.ready = true;
   WebVR.devices = [];
   return;
  }
  navigator.getVRDevices().then((function(devs) {
   WebVR.ready = true;
   WebVR.devices = devs;
  }), (function() {
   console.log("Emscripten WebVR getVRDevices() hit error callback");
   WebVR.ready = true;
   WebVR.devices = [];
  }));
 }),
 getDeviceByID: (function(deviceId) {
  if (deviceId < 1 || deviceId > WebVR.devices.length) {
   console.log("library_vr getDeviceByID invalid device id at: " + stackTrace());
   return null;
  }
  return WebVR.devices[deviceId - 1];
 })
};
Module["WebVR"] = WebVR;
function _emscripten_vr_init() {
 WebVR.init();
}
Module["_emscripten_vr_init"] = _emscripten_vr_init;
function _emscripten_vr_ready() {
 return WebVR.ready ? 1 : 0;
}
Module["_emscripten_vr_ready"] = _emscripten_vr_ready;
function _emscripten_vr_count_devices() {
 return WebVR.devices.length;
}
Module["_emscripten_vr_count_devices"] = _emscripten_vr_count_devices;
function _emscripten_vr_get_device_id(deviceIndex) {
 if (deviceIndex < 0 || deviceIndex >= WebVR.devices.length) {
  return -1;
 }
 return deviceIndex + 1;
}
Module["_emscripten_vr_get_device_id"] = _emscripten_vr_get_device_id;
function _emscripten_vr_get_device_hwid(deviceId) {
 var dev = WebVR.getDeviceByID(deviceId);
 if (!dev) return -1;
 if (!WebVR.deviceHardwareIds[dev.hardwareUnitId]) {
  WebVR.deviceHardwareIds[dev.hardwareUnitId] = WebVR.nextHardwareDeviceId++;
 }
 return WebVR.deviceHardwareIds[dev.hardwareUnitId];
}
Module["_emscripten_vr_get_device_hwid"] = _emscripten_vr_get_device_hwid;
function _emscripten_vr_get_device_name(deviceId) {
 var dev = WebVR.getDeviceByID(deviceId);
 var devName;
 devName = dev ? dev.deviceName : "";
 buf = _malloc(devName.length + 1);
 writeStringToMemory(devName, buf);
 return buf;
}
Module["_emscripten_vr_get_device_name"] = _emscripten_vr_get_device_name;
function _emscripten_vr_get_device_type(deviceId) {
 var dev = WebVR.getDeviceByID(deviceId);
 if (!dev) return -1;
 if (dev instanceof HMDVRDevice) {
  return WebVR.DEVICE_TYPE_HMD;
 }
 if (dev instanceof PositionSensorVRDevice) {
  return WebVR.DEVICE_TYPE_SENSOR;
 }
 return WebVR.DEVICE_TYPE_UNKNOWN;
}
Module["_emscripten_vr_get_device_type"] = _emscripten_vr_get_device_type;
function _emscripten_vr_select_hmd_device(deviceId) {
 if (deviceId == 0) {
  WebVR.selectedHMD = null;
  WebVR.selectedHMDId = 0;
  return 1;
 }
 var dev = WebVR.getDeviceByID(deviceId);
 if (!dev || !(dev instanceof HMDVRDevice)) {
  console.log("Trying to call emscripten_vr_select_hmd_device on invalid or non-HMD device ID!");
  return 0;
 }
 WebVR.selectedHMD = dev;
 WebVR.selectedHMDId = deviceId;
 return 1;
}
Module["_emscripten_vr_select_hmd_device"] = _emscripten_vr_select_hmd_device;
function _emscripten_vr_get_selected_hmd_device() {
 return WebVR.selectedHMDId;
}
Module["_emscripten_vr_get_selected_hmd_device"] = _emscripten_vr_get_selected_hmd_device;
function _emscripten_vr_hmd_get_eye_parameters(deviceId, whichEye, eyeParamsPtr) {
 if (!eyeParamsPtr) return 0;
 var dev = WebVR.getDeviceByID(deviceId);
 if (!dev) return 0;
 var params = dev.getEyeParameters(whichEye == WebVR.EYE_LEFT ? "left" : "right");
 HEAPF64[eyeParamsPtr >> 3] = params.minimumFieldOfView.upDegrees;
 HEAPF64[eyeParamsPtr + 16 >> 3] = params.minimumFieldOfView.downDegrees;
 HEAPF64[eyeParamsPtr + 24 >> 3] = params.minimumFieldOfView.leftDegrees;
 HEAPF64[eyeParamsPtr + 8 >> 3] = params.minimumFieldOfView.rightDegrees;
 HEAPF64[eyeParamsPtr + 32 >> 3] = params.maximumFieldOfView.upDegrees;
 HEAPF64[eyeParamsPtr + 48 >> 3] = params.maximumFieldOfView.downDegrees;
 HEAPF64[eyeParamsPtr + 56 >> 3] = params.maximumFieldOfView.leftDegrees;
 HEAPF64[eyeParamsPtr + 40 >> 3] = params.maximumFieldOfView.rightDegrees;
 HEAPF64[eyeParamsPtr + 64 >> 3] = params.recommendedFieldOfView.upDegrees;
 HEAPF64[eyeParamsPtr + 80 >> 3] = params.recommendedFieldOfView.downDegrees;
 HEAPF64[eyeParamsPtr + 88 >> 3] = params.recommendedFieldOfView.leftDegrees;
 HEAPF64[eyeParamsPtr + 72 >> 3] = params.recommendedFieldOfView.rightDegrees;
 HEAPF64[eyeParamsPtr + 96 >> 3] = params.eyeTranslation.x;
 HEAPF64[eyeParamsPtr + 104 >> 3] = params.eyeTranslation.y;
 HEAPF64[eyeParamsPtr + 112 >> 3] = params.eyeTranslation.z;
 HEAPF64[eyeParamsPtr + 120 >> 3] = params.eyeTranslation.w;
 HEAPF64[eyeParamsPtr + 128 >> 3] = params.currentFieldOfView.upDegrees;
 HEAPF64[eyeParamsPtr + 144 >> 3] = params.currentFieldOfView.downDegrees;
 HEAPF64[eyeParamsPtr + 152 >> 3] = params.currentFieldOfView.leftDegrees;
 HEAPF64[eyeParamsPtr + 136 >> 3] = params.currentFieldOfView.rightDegrees;
 HEAP32[eyeParamsPtr + 160 >> 2] = params.renderRect.x;
 HEAP32[eyeParamsPtr + 164 >> 2] = params.renderRect.y;
 HEAP32[eyeParamsPtr + 168 >> 2] = params.renderRect.width;
 HEAP32[eyeParamsPtr + 172 >> 2] = params.renderRect.height;
 return 1;
}
Module["_emscripten_vr_hmd_get_eye_parameters"] = _emscripten_vr_hmd_get_eye_parameters;
function _emscripten_vr_hmd_set_fov(deviceId, leftFovPtr, rightFovPtr, zNear, zFar) {
 if (!leftFovPtr || !rightFovPtr) return 0;
 var dev = WebVR.getDeviceByID(deviceId);
 if (!dev) return 0;
 var leftFov = {
  upDegrees: HEAPF64[leftFovPtr >> 3],
  downDegrees: HEAPF64[leftFovPtr + 16 >> 3],
  leftDegrees: HEAPF64[leftFovPtr + 24 >> 3],
  rightDegrees: HEAPF64[leftFovPtr + 8 >> 3]
 };
 var rightFov = {
  upDegrees: HEAPF64[rightFovPtr >> 3],
  downDegrees: HEAPF64[rightFovPtr + 16 >> 3],
  leftDegrees: HEAPF64[rightFovPtr + 24 >> 3],
  rightDegrees: HEAPF64[rightFovPtr + 8 >> 3]
 };
 dev.setFieldOfView(leftFov, rightFov, zNear, zFar);
 return 1;
}
Module["_emscripten_vr_hmd_set_fov"] = _emscripten_vr_hmd_set_fov;
function _emscripten_vr_sensor_get_state(deviceId, immediate, statePtr) {
 if (!statePtr) return 0;
 var dev = WebVR.getDeviceByID(deviceId);
 if (!dev) return 0;
 var state = immediate ? dev.getImmediateState : dev.getState();
 HEAPF64[statePtr >> 3] = state.timeStamp;
 HEAP32[statePtr + 8 >> 2] = state.hasPosition ? 1 : 0;
 if (state.hasPosition) {
  HEAPF64[statePtr + 16 >> 3] = state.position.x;
  HEAPF64[statePtr + 24 >> 3] = state.position.y;
  HEAPF64[statePtr + 32 >> 3] = state.position.z;
  HEAPF64[statePtr + 48 >> 3] = state.linearVelocity.x;
  HEAPF64[statePtr + 56 >> 3] = state.linearVelocity.y;
  HEAPF64[statePtr + 64 >> 3] = state.linearVelocity.z;
  HEAPF64[statePtr + 80 >> 3] = state.linearAcceleration.x;
  HEAPF64[statePtr + 88 >> 3] = state.linearAcceleration.y;
  HEAPF64[statePtr + 96 >> 3] = state.linearAcceleration.z;
 }
 HEAP32[statePtr + 112 >> 2] = state.hasOrientation ? 1 : 0;
 if (state.hasOrientation) {
  HEAPF64[statePtr + 120 >> 3] = state.orientation.x;
  HEAPF64[statePtr + 128 >> 3] = state.orientation.y;
  HEAPF64[statePtr + 136 >> 3] = state.orientation.z;
  HEAPF64[statePtr + 144 >> 3] = state.orientation.w;
  HEAPF64[statePtr + 152 >> 3] = state.angularVelocity.x;
  HEAPF64[statePtr + 160 >> 3] = state.angularVelocity.y;
  HEAPF64[statePtr + 168 >> 3] = state.angularVelocity.z;
  HEAPF64[statePtr + 176 >> 3] = state.angularVelocity.w;
  HEAPF64[statePtr + 184 >> 3] = state.angularAcceleration.x;
  HEAPF64[statePtr + 192 >> 3] = state.angularAcceleration.y;
  HEAPF64[statePtr + 200 >> 3] = state.angularAcceleration.z;
  HEAPF64[statePtr + 208 >> 3] = state.angularAcceleration.w;
 }
 return 1;
}
Module["_emscripten_vr_sensor_get_state"] = _emscripten_vr_sensor_get_state;
function _emscripten_vr_sensor_zero(deviceId) {
 var dev = WebVR.getDeviceByID(deviceId);
 if (!dev) return 0;
 dev.resetSensor();
 return 1;
}
Module["_emscripten_vr_sensor_zero"] = _emscripten_vr_sensor_zero;
function _JS_SystemInfo_GetBrowserVersion() {
 return systemInfo.get().browserVersion;
}
Module["_JS_SystemInfo_GetBrowserVersion"] = _JS_SystemInfo_GetBrowserVersion;
function _JS_UNETWebSockets_HostsContainingMessagesCleanHost(hostId) {
 for (i = 0; i < UNETWebSocketsInstances.hostsContainingMessages.length; i++) {
  if (UNETWebSocketsInstances.hostsContainingMessages[i].id == hostId) UNETWebSocketsInstances.hostsContainingMessages[i] = null;
 }
 var socket = UNETWebSocketsInstances.hostsContainingMessages[0];
 if (socket == null) return;
 if (socket.messages.length == 0) {
  socket.inQueue = false;
 } else {
  UNETWebSocketsInstances.hostsContainingMessages.push(socket);
 }
 UNETWebSocketsInstances.hostsContainingMessages.shift();
}
Module["_JS_UNETWebSockets_HostsContainingMessagesCleanHost"] = _JS_UNETWebSockets_HostsContainingMessagesCleanHost;
function _JS_UNETWebSockets_HostsContainingMessagesPush(socket) {
 if (socket.inQueue == false) {
  UNETWebSocketsInstances.hostsContainingMessages.push(socket);
  socket.inQueue = true;
 }
}
Module["_JS_UNETWebSockets_HostsContainingMessagesPush"] = _JS_UNETWebSockets_HostsContainingMessagesPush;
var UNETWebSocketsInstances = {
 hosts: [ undefined, undefined, undefined, undefined, undefined, undefined, undefined, undefined, undefined, undefined, undefined, undefined, undefined, undefined, undefined ],
 hostsContainingMessages: [],
 HostStates: {
  Created: 0,
  Opening: 1,
  Connected: 2,
  Closing: 3,
  Closed: 4
 },
 EventTypes: {
  DataEvent: 0,
  ConnectEvent: 1,
  DisconnectEvent: 2,
  Nothing: 3
 }
};
Module["UNETWebSocketsInstances"] = UNETWebSocketsInstances;
function _JS_UNETWebSockets_SocketCreate(hostId, url) {
 var str = Pointer_stringify(url);
 var socket = {
  socket: new WebSocket(str, [ "unitygame" ]),
  buffer: new Uint8Array(0),
  error: null,
  id: hostId,
  state: UNETWebSocketsInstances.HostStates.Created,
  inQueue: false,
  messages: []
 };
 socket.socket.onopen = (function() {
  socket.state = UNETWebSocketsInstances.HostStates.Opening;
  _JS_UNETWebSockets_HostsContainingMessagesPush(socket);
 });
 socket.socket.onmessage = (function(e) {
  if (e.data instanceof Blob) {
   var reader = new FileReader;
   reader.addEventListener("loadend", (function() {
    var array = new Uint8Array(reader.result);
    _JS_UNETWebSockets_HostsContainingMessagesPush(socket);
    socket.messages.push(array);
   }));
   reader.readAsArrayBuffer(e.data);
  }
 });
 socket.socket.onclose = (function(e) {
  if (socket.state == UNETWebSocketsInstances.HostStates.Closed) return;
  socket.state = UNETWebSocketsInstances.HostStates.Closing;
  _JS_UNETWebSockets_HostsContainingMessagesPush(socket);
 });
 socket.socket.onerror = (function(e) {
  console.log("Error: " + e.data + " socket will be closed");
  socket.state = UNETWebSocketsInstances.HostStates.Closing;
  _JS_UNETWebSockets_HostsContainingMessagesPush(socket);
 });
 UNETWebSocketsInstances.hosts[socket.id] = socket;
}
Module["_JS_UNETWebSockets_SocketCreate"] = _JS_UNETWebSockets_SocketCreate;
function _JS_UNETWebSockets_SocketClose(hostId) {
 var socket = UNETWebSocketsInstances.hosts[hostId];
 socket.state = UNETWebSocketsInstances.HostStates.Closed;
 if (socket.socket != null) socket.socket.close();
 UNETWebSocketsInstances.hosts[hostId] = null;
 _JS_UNETWebSockets_HostsContainingMessagesCleanHost(hostId);
}
Module["_JS_UNETWebSockets_SocketClose"] = _JS_UNETWebSockets_SocketClose;
function _JS_UNETWebSockets_SocketSend(hostId, ptr, length) {
 var socket = UNETWebSocketsInstances.hosts[hostId];
 if (socket == 0 || socket.socket.readyState != 1 || socket.state != UNETWebSocketsInstances.HostStates.Connected) return;
 socket.socket.send(HEAPU8.buffer.slice(ptr, ptr + length));
}
Module["_JS_UNETWebSockets_SocketSend"] = _JS_UNETWebSockets_SocketSend;
function _JS_UNETWebSockets_SocketRecvEvntType() {
 if (UNETWebSocketsInstances.hostsContainingMessages.length == 0) return UNETWebSocketsInstances.EventTypes.Nothing;
 while (UNETWebSocketsInstances.hostsContainingMessages.length != 0) {
  if (UNETWebSocketsInstances.hostsContainingMessages[0] == null) UNETWebSocketsInstances.hostsContainingMessages.shift(); else if (UNETWebSocketsInstances.hostsContainingMessages[0].state == UNETWebSocketsInstances.HostStates.Closed) UNETWebSocketsInstances.hostsContainingMessages.shift(); else if (UNETWebSocketsInstances.hostsContainingMessages[0].state == UNETWebSocketsInstances.HostStates.Opening) break; else if (UNETWebSocketsInstances.hostsContainingMessages[0].state == UNETWebSocketsInstances.HostStates.Closing) break; else if (UNETWebSocketsInstances.hostsContainingMessages[0].messages.length == 0) {
   UNETWebSocketsInstances.hostsContainingMessages[0].inQueue = false;
   UNETWebSocketsInstances.hostsContainingMessages.shift();
  } else break;
 }
 if (UNETWebSocketsInstances.hostsContainingMessages.length == 0) return UNETWebSocketsInstances.EventTypes.Nothing; else if (UNETWebSocketsInstances.hostsContainingMessages[0].state == UNETWebSocketsInstances.HostStates.Opening) return UNETWebSocketsInstances.EventTypes.ConnectEvent; else if (UNETWebSocketsInstances.hostsContainingMessages[0].state == UNETWebSocketsInstances.HostStates.Closing && UNETWebSocketsInstances.hostsContainingMessages[0].messages.length == 0) return UNETWebSocketsInstances.EventTypes.DisconnectEvent; else return UNETWebSocketsInstances.EventTypes.DataEvent;
}
Module["_JS_UNETWebSockets_SocketRecvEvntType"] = _JS_UNETWebSockets_SocketRecvEvntType;
function _JS_UNETWebSockets_SocketRecvEvntHost() {
 return UNETWebSocketsInstances.hostsContainingMessages[0].id;
}
Module["_JS_UNETWebSockets_SocketRecvEvntHost"] = _JS_UNETWebSockets_SocketRecvEvntHost;
function _JS_UNETWebSockets_SocketRecvEvntBuffLength() {
 return UNETWebSocketsInstances.hostsContainingMessages[0].messages[0].length;
}
Module["_JS_UNETWebSockets_SocketRecvEvntBuffLength"] = _JS_UNETWebSockets_SocketRecvEvntBuffLength;
function _JS_UNETWebSockets_SocketRecvEvntBuff(ptr, length) {
 HEAPU8.set(UNETWebSocketsInstances.hostsContainingMessages[0].messages[0], ptr);
}
Module["_JS_UNETWebSockets_SocketRecvEvntBuff"] = _JS_UNETWebSockets_SocketRecvEvntBuff;
function _JS_UNETWebSockets_SocketCleanEvnt() {
 var host = UNETWebSocketsInstances.hostsContainingMessages.shift();
 host.inQueue = false;
 if (host.state == UNETWebSocketsInstances.HostStates.Opening) {
  host.state = UNETWebSocketsInstances.HostStates.Connected;
  if (host.messages.length != 0) _JS_UNETWebSockets_HostsContainingMessagesPush(host);
 } else if (host.state == UNETWebSocketsInstances.HostStates.Closing) {
  if (host.messages.length == 0) UNETWebSocketsInstances.hosts[host.id] = null; else {
   host.messages.shift();
   if (host.messages.length != 0) _JS_UNETWebSockets_HostsContainingMessagesPush(host);
  }
 } else {
  host.messages.shift();
  if (host.messages.length != 0) _JS_UNETWebSockets_HostsContainingMessagesPush(host);
 }
}
Module["_JS_UNETWebSockets_SocketCleanEvnt"] = _JS_UNETWebSockets_SocketCleanEvnt;
function _JS_UNETWebSockets_SocketRecvEvntTypeFromHost(hostId) {
 var evnt = UNETWebSocketsInstances.EventTypes.Nothing;
 if (UNETWebSocketsInstances.hosts[hostId].state == UNETWebSocketsInstances.HostStates.Opening) evnt = UNETWebSocketsInstances.EventTypes.ConnectEvent; else if (UNETWebSocketsInstances.hosts[hostId].messages.length != 0) evnt = UNETWebSocketsInstances.EventTypes.DataEvent; else if (UNETWebSocketsInstances.hosts[hostId].state == UNETWebSocketsInstances.HostStates.Closing) evnt = UNETWebSocketsInstances.EventTypes.DisconnectEvent;
 return evnt;
}
Module["_JS_UNETWebSockets_SocketRecvEvntTypeFromHost"] = _JS_UNETWebSockets_SocketRecvEvntTypeFromHost;
function _JS_UNETWebSockets_SocketRecvEvntBuffLengthFromHost(hostId) {
 return UNETWebSocketsInstances.hosts[hostId].messages[0].length;
}
Module["_JS_UNETWebSockets_SocketRecvEvntBuffLengthFromHost"] = _JS_UNETWebSockets_SocketRecvEvntBuffLengthFromHost;
function _JS_UNETWebSockets_SocketRecvEvntBuffFromHost(hostId, ptr, length) {
 HEAPU8.set(UNETWebSocketsInstances.hosts[hostId].messages[0], ptr);
}
Module["_JS_UNETWebSockets_SocketRecvEvntBuffFromHost"] = _JS_UNETWebSockets_SocketRecvEvntBuffFromHost;
function _JS_UNETWebSockets_SocketCleanEvntFromHost(hostId) {
 if (UNETWebSocketsInstances.hosts[hostId].state == UNETWebSocketsInstances.HostStates.Opening) UNETWebSocketsInstances.hosts[hostId].state = UNETWebSocketsInstances.HostStates.Connected; else if (UNETWebSocketsInstances.hosts[hostId].messages.length != 0) UNETWebSocketsInstances.hosts[hostId].messages.shift(); else if (UNETWebSocketsInstances.hosts[hostId].state == UNETWebSocketsInstances.HostStates.Closing) {
  UNETWebSocketsInstances.hosts[hostId].state = UNETWebSocketsInstances.HostStates.Closed;
  UNETWebSocketsInstances.hosts[hostId] = null;
  _JS_UNETWebSockets_HostsContainingMessagesCleanHost(hostId);
 }
}
Module["_JS_UNETWebSockets_SocketCleanEvntFromHost"] = _JS_UNETWebSockets_SocketCleanEvntFromHost;
function _JS_UNETWebSockets_AddHost() {
 var placeHolderSocket = {
  socket: null,
  buffer: new Uint8Array(0),
  error: null,
  id: -1,
  state: UNETWebSocketsInstances.HostStates.Closed,
  messages: []
 };
 for (i = 0; i < UNETWebSocketsInstances.hosts.length; i++) {
  if (UNETWebSocketsInstances.hosts[i] == null) {
   placeHolderSocket.id = i;
   UNETWebSocketsInstances.hosts[i] = placeHolderSocket;
   return i;
  }
 }
 return -1;
}
Module["_JS_UNETWebSockets_AddHost"] = _JS_UNETWebSockets_AddHost;
function _JS_UNETWebSockets_IsHostCorrect(i) {
 if (i < UNETWebSocketsInstances.hosts.length && UNETWebSocketsInstances.hosts[i] != null && UNETWebSocketsInstances.hosts[i].socket != null) {
  return true;
 }
 return false;
}
Module["_JS_UNETWebSockets_IsHostCorrect"] = _JS_UNETWebSockets_IsHostCorrect;
function _JS_UNETWebSockets_IsHostReadyToConnect(i) {
 if (i < UNETWebSocketsInstances.hosts.length && UNETWebSocketsInstances.hosts[i] != null && UNETWebSocketsInstances.hosts[i].socket == null) {
  return true;
 }
 return false;
}
Module["_JS_UNETWebSockets_IsHostReadyToConnect"] = _JS_UNETWebSockets_IsHostReadyToConnect;
function _JS_UNETWebSockets_SocketStop() {
 for (i = 0; i < UNETWebSocketsInstances.hosts.length; i++) {
  if (UNETWebSocketsInstances.hosts[i] != null && UNETWebSocketsInstances.hosts[i].socket != null) {
   var socket = UNETWebSocketsInstances.hosts[i];
   socket.socket.close();
   UNETWebSocketsInstances.hosts[i] = null;
  }
 }
 UNETWebSocketsInstances.hosts = new Array(UNETWebSocketsInstances.hosts.length);
 UNETWebSocketsInstances.hostsContainingMessages = new Array;
}
Module["_JS_UNETWebSockets_SocketStop"] = _JS_UNETWebSockets_SocketStop;
function _emscripten_has_threading_support() {
 return 0;
}
Module["_emscripten_has_threading_support"] = _emscripten_has_threading_support;
function _emscripten_num_logical_cores() {
 return 1;
}
Module["_emscripten_num_logical_cores"] = _emscripten_num_logical_cores;
function _emscripten_force_num_logical_cores(cores) {}
Module["_emscripten_force_num_logical_cores"] = _emscripten_force_num_logical_cores;
function _emscripten_is_main_runtime_thread() {
 return 1;
}
Module["_emscripten_is_main_runtime_thread"] = _emscripten_is_main_runtime_thread;
function _emscripten_is_main_browser_thread() {
 return !ENVIRONMENT_IS_WORKER;
}
Module["_emscripten_is_main_browser_thread"] = _emscripten_is_main_browser_thread;
function _emscripten_main_thread_process_queued_calls() {}
Module["_emscripten_main_thread_process_queued_calls"] = _emscripten_main_thread_process_queued_calls;
function _pthread_mutexattr_setpshared(attr, pshared) {
 return 0;
}
Module["_pthread_mutexattr_setpshared"] = _pthread_mutexattr_setpshared;
function _pthread_condattr_init() {
 return 0;
}
Module["_pthread_condattr_init"] = _pthread_condattr_init;
function _pthread_condattr_destroy() {
 return 0;
}
Module["_pthread_condattr_destroy"] = _pthread_condattr_destroy;
function _pthread_condattr_setclock() {
 return 0;
}
Module["_pthread_condattr_setclock"] = _pthread_condattr_setclock;
function _pthread_condattr_setpshared() {
 return 0;
}
Module["_pthread_condattr_setpshared"] = _pthread_condattr_setpshared;
function _pthread_condattr_getclock() {
 return 0;
}
Module["_pthread_condattr_getclock"] = _pthread_condattr_getclock;
function _pthread_condattr_getpshared() {
 return 0;
}
Module["_pthread_condattr_getpshared"] = _pthread_condattr_getpshared;
function _pthread_getattr_np(thread, attr) {
 return 0;
}
Module["_pthread_getattr_np"] = _pthread_getattr_np;
function _pthread_attr_getstack(attr, stackaddr, stacksize) {
 HEAP32[stackaddr >> 2] = STACK_BASE;
 HEAP32[stacksize >> 2] = TOTAL_STACK;
 return 0;
}
Module["_pthread_attr_getstack"] = _pthread_attr_getstack;
function _pthread_rwlock_init() {
 return 0;
}
Module["_pthread_rwlock_init"] = _pthread_rwlock_init;
function _pthread_rwlock_destroy() {
 return 0;
}
Module["_pthread_rwlock_destroy"] = _pthread_rwlock_destroy;
function _pthread_rwlock_rdlock() {
 return 0;
}
Module["_pthread_rwlock_rdlock"] = _pthread_rwlock_rdlock;
function _pthread_rwlock_tryrdlock() {
 return 0;
}
Module["_pthread_rwlock_tryrdlock"] = _pthread_rwlock_tryrdlock;
function _pthread_rwlock_timedrdlock() {
 return 0;
}
Module["_pthread_rwlock_timedrdlock"] = _pthread_rwlock_timedrdlock;
function _pthread_rwlock_wrlock() {
 return 0;
}
Module["_pthread_rwlock_wrlock"] = _pthread_rwlock_wrlock;
function _pthread_rwlock_trywrlock() {
 return 0;
}
Module["_pthread_rwlock_trywrlock"] = _pthread_rwlock_trywrlock;
function _pthread_rwlock_timedwrlock() {
 return 0;
}
Module["_pthread_rwlock_timedwrlock"] = _pthread_rwlock_timedwrlock;
function _pthread_rwlock_unlock() {
 return 0;
}
Module["_pthread_rwlock_unlock"] = _pthread_rwlock_unlock;
function _pthread_rwlockattr_init() {
 return 0;
}
Module["_pthread_rwlockattr_init"] = _pthread_rwlockattr_init;
function _pthread_rwlockattr_destroy() {
 return 0;
}
Module["_pthread_rwlockattr_destroy"] = _pthread_rwlockattr_destroy;
function _pthread_rwlockattr_setpshared() {
 return 0;
}
Module["_pthread_rwlockattr_setpshared"] = _pthread_rwlockattr_setpshared;
function _pthread_rwlockattr_getpshared() {
 return 0;
}
Module["_pthread_rwlockattr_getpshared"] = _pthread_rwlockattr_getpshared;
function _pthread_spin_init() {
 return 0;
}
Module["_pthread_spin_init"] = _pthread_spin_init;
function _pthread_spin_destroy() {
 return 0;
}
Module["_pthread_spin_destroy"] = _pthread_spin_destroy;
function _pthread_spin_lock() {
 return 0;
}
Module["_pthread_spin_lock"] = _pthread_spin_lock;
function _pthread_spin_trylock() {
 return 0;
}
Module["_pthread_spin_trylock"] = _pthread_spin_trylock;
function _pthread_spin_unlock() {
 return 0;
}
Module["_pthread_spin_unlock"] = _pthread_spin_unlock;
function _pthread_attr_setdetachstate() {}
Module["_pthread_attr_setdetachstate"] = _pthread_attr_setdetachstate;
function _pthread_equal() {}
Module["_pthread_equal"] = _pthread_equal;
function _llvm_memory_barrier() {}
Module["_llvm_memory_barrier"] = _llvm_memory_barrier;
function _llvm_atomic_load_add_i32_p0i32(ptr, delta) {
 var ret = HEAP32[ptr >> 2];
 HEAP32[ptr >> 2] = ret + delta;
 return ret;
}
Module["_llvm_atomic_load_add_i32_p0i32"] = _llvm_atomic_load_add_i32_p0i32;
function ___atomic_is_lock_free(size, ptr) {
 return size <= 4 && (size & size - 1) == 0 && (ptr & size - 1) == 0;
}
Module["___atomic_is_lock_free"] = ___atomic_is_lock_free;
function ___atomic_load_8(ptr, memmodel) {
 return (Runtime.setTempRet0(HEAP32[ptr + 4 >> 2]), HEAP32[ptr >> 2]) | 0;
}
Module["___atomic_load_8"] = ___atomic_load_8;
function ___atomic_store_8(ptr, vall, valh, memmodel) {
 HEAP32[ptr >> 2] = vall;
 HEAP32[ptr + 4 >> 2] = valh;
}
Module["___atomic_store_8"] = ___atomic_store_8;
function ___atomic_exchange_8(ptr, vall, valh, memmodel) {
 var l = HEAP32[ptr >> 2];
 var h = HEAP32[ptr + 4 >> 2];
 HEAP32[ptr >> 2] = vall;
 HEAP32[ptr + 4 >> 2] = valh;
 return (Runtime.setTempRet0(h), l) | 0;
}
Module["___atomic_exchange_8"] = ___atomic_exchange_8;
function ___atomic_compare_exchange_8(ptr, expected, desiredl, desiredh, weak, success_memmodel, failure_memmodel) {
 var pl = HEAP32[ptr >> 2];
 var ph = HEAP32[ptr + 4 >> 2];
 var el = HEAP32[expected >> 2];
 var eh = HEAP32[expected + 4 >> 2];
 if (pl === el && ph === eh) {
  HEAP32[ptr >> 2] = desiredl;
  HEAP32[ptr + 4 >> 2] = desiredh;
  return 1;
 } else {
  HEAP32[expected >> 2] = pl;
  HEAP32[expected + 4 >> 2] = ph;
  return 0;
 }
}
Module["___atomic_compare_exchange_8"] = ___atomic_compare_exchange_8;
function ___atomic_fetch_add_8(ptr, vall, valh, memmodel) {
 var l = HEAP32[ptr >> 2];
 var h = HEAP32[ptr + 4 >> 2];
 HEAP32[ptr >> 2] = _i64Add(l, h, vall, valh);
 HEAP32[ptr + 4 >> 2] = Runtime["getTempRet0"]();
 return (Runtime.setTempRet0(h), l) | 0;
}
Module["___atomic_fetch_add_8"] = ___atomic_fetch_add_8;
function ___atomic_fetch_sub_8(ptr, vall, valh, memmodel) {
 var l = HEAP32[ptr >> 2];
 var h = HEAP32[ptr + 4 >> 2];
 HEAP32[ptr >> 2] = _i64Subtract(l, h, vall, valh);
 HEAP32[ptr + 4 >> 2] = Runtime["getTempRet0"]();
 return (Runtime.setTempRet0(h), l) | 0;
}
Module["___atomic_fetch_sub_8"] = ___atomic_fetch_sub_8;
function ___atomic_fetch_and_8(ptr, vall, valh, memmodel) {
 var l = HEAP32[ptr >> 2];
 var h = HEAP32[ptr + 4 >> 2];
 HEAP32[ptr >> 2] = l & vall;
 HEAP32[ptr + 4 >> 2] = h & valh;
 return (Runtime.setTempRet0(h), l) | 0;
}
Module["___atomic_fetch_and_8"] = ___atomic_fetch_and_8;
function ___atomic_fetch_or_8(ptr, vall, valh, memmodel) {
 var l = HEAP32[ptr >> 2];
 var h = HEAP32[ptr + 4 >> 2];
 HEAP32[ptr >> 2] = l | vall;
 HEAP32[ptr + 4 >> 2] = h | valh;
 return (Runtime.setTempRet0(h), l) | 0;
}
Module["___atomic_fetch_or_8"] = ___atomic_fetch_or_8;
function ___atomic_fetch_xor_8(ptr, vall, valh, memmodel) {
 var l = HEAP32[ptr >> 2];
 var h = HEAP32[ptr + 4 >> 2];
 HEAP32[ptr >> 2] = l ^ vall;
 HEAP32[ptr + 4 >> 2] = h ^ valh;
 return (Runtime.setTempRet0(h), l) | 0;
}
Module["___atomic_fetch_xor_8"] = ___atomic_fetch_xor_8;
function _emscripten_atomic_add_u32() {
 return _llvm_atomic_load_add_i32_p0i32.apply(null, arguments);
}
Module["_emscripten_atomic_add_u32"] = _emscripten_atomic_add_u32;
function _emscripten_atomic_load_u64() {
 return ___atomic_load_8.apply(null, arguments);
}
Module["_emscripten_atomic_load_u64"] = _emscripten_atomic_load_u64;
function _emscripten_atomic_store_u64() {
 return ___atomic_store_8.apply(null, arguments);
}
Module["_emscripten_atomic_store_u64"] = _emscripten_atomic_store_u64;
function _emscripten_atomic_cas_u64() {
 return ___atomic_compare_exchange_8.apply(null, arguments);
}
Module["_emscripten_atomic_cas_u64"] = _emscripten_atomic_cas_u64;
function _emscripten_atomic_exchange_u64() {
 return ___atomic_exchange_8.apply(null, arguments);
}
Module["_emscripten_atomic_exchange_u64"] = _emscripten_atomic_exchange_u64;
function __emscripten_atomic_fetch_and_add_u64() {
 return ___atomic_fetch_add_8.apply(null, arguments);
}
Module["__emscripten_atomic_fetch_and_add_u64"] = __emscripten_atomic_fetch_and_add_u64;
function __emscripten_atomic_fetch_and_sub_u64() {
 return ___atomic_fetch_sub_8.apply(null, arguments);
}
Module["__emscripten_atomic_fetch_and_sub_u64"] = __emscripten_atomic_fetch_and_sub_u64;
function __emscripten_atomic_fetch_and_and_u64() {
 return ___atomic_fetch_and_8.apply(null, arguments);
}
Module["__emscripten_atomic_fetch_and_and_u64"] = __emscripten_atomic_fetch_and_and_u64;
function __emscripten_atomic_fetch_and_or_u64() {
 return ___atomic_fetch_or_8.apply(null, arguments);
}
Module["__emscripten_atomic_fetch_and_or_u64"] = __emscripten_atomic_fetch_and_or_u64;
function __emscripten_atomic_fetch_and_xor_u64() {
 return ___atomic_fetch_xor_8.apply(null, arguments);
}
Module["__emscripten_atomic_fetch_and_xor_u64"] = __emscripten_atomic_fetch_and_xor_u64;
var GLctx;
GL.init();
Module["requestFullScreen"] = function Module_requestFullScreen(lockPointer, resizeCanvas, vrDevice) {
 Module.printErr("Module.requestFullScreen is deprecated. Please call Module.requestFullscreen instead.");
 Module["requestFullScreen"] = Module["requestFullscreen"];
 Browser.requestFullScreen(lockPointer, resizeCanvas, vrDevice);
};
Module["requestFullscreen"] = function Module_requestFullscreen(lockPointer, resizeCanvas, vrDevice) {
 Browser.requestFullscreen(lockPointer, resizeCanvas, vrDevice);
};
Module["requestAnimationFrame"] = function Module_requestAnimationFrame(func) {
 Browser.requestAnimationFrame(func);
};
Module["setCanvasSize"] = function Module_setCanvasSize(width, height, noUpdates) {
 Browser.setCanvasSize(width, height, noUpdates);
};
Module["pauseMainLoop"] = function Module_pauseMainLoop() {
 Browser.mainLoop.pause();
};
Module["resumeMainLoop"] = function Module_resumeMainLoop() {
 Browser.mainLoop.resume();
};
Module["getUserMedia"] = function Module_getUserMedia() {
 Browser.getUserMedia();
};
Module["createContext"] = function Module_createContext(canvas, useWebGL, setInModule, webGLContextAttributes) {
 return Browser.createContext(canvas, useWebGL, setInModule, webGLContextAttributes);
};
if (ENVIRONMENT_IS_NODE) {
 _emscripten_get_now = function _emscripten_get_now_actual() {
  var t = process["hrtime"]();
  return t[0] * 1e3 + t[1] / 1e6;
 };
} else if (typeof dateNow !== "undefined") {
 _emscripten_get_now = dateNow;
} else if (typeof self === "object" && self["performance"] && typeof self["performance"]["now"] === "function") {
 _emscripten_get_now = (function() {
  return self["performance"]["now"]();
 });
} else if (typeof performance === "object" && typeof performance["now"] === "function") {
 _emscripten_get_now = (function() {
  return performance["now"]();
 });
} else {
 _emscripten_get_now = Date.now;
}
FS.staticInit();
__ATINIT__.unshift((function() {
 if (!Module["noFSInit"] && !FS.init.initialized) FS.init();
}));
__ATMAIN__.push((function() {
 FS.ignorePermissions = false;
}));
__ATEXIT__.push((function() {
 FS.quit();
}));
Module["FS_createFolder"] = FS.createFolder;
Module["FS_createPath"] = FS.createPath;
Module["FS_createDataFile"] = FS.createDataFile;
Module["FS_createPreloadedFile"] = FS.createPreloadedFile;
Module["FS_createLazyFile"] = FS.createLazyFile;
Module["FS_createLink"] = FS.createLink;
Module["FS_createDevice"] = FS.createDevice;
Module["FS_unlink"] = FS.unlink;
__ATINIT__.unshift((function() {
 TTY.init();
}));
__ATEXIT__.push((function() {
 TTY.shutdown();
}));
if (ENVIRONMENT_IS_NODE) {
 var fs = require("fs");
 var NODEJS_PATH = require("path");
 NODEFS.staticInit();
}
___buildEnvironment(ENV);
__ATINIT__.push((function() {
 SOCKFS.root = FS.mount(SOCKFS, {}, null);
}));
STACK_BASE = STACKTOP = Runtime.alignMemory(STATICTOP);
staticSealed = true;
STACK_MAX = STACK_BASE + TOTAL_STACK;
DYNAMIC_BASE = DYNAMICTOP = Runtime.alignMemory(STACK_MAX);
assert(DYNAMIC_BASE < TOTAL_MEMORY, "TOTAL_MEMORY not big enough for stack");
function nullFunc_viiifiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiifiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiiid(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiiid'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_fiff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'fiff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiififii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiififii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vifiiiiiiiiiiiiiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vifiiiiiiiiiiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiiiiiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_fff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'fff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_fiiiiiifiiiiiif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'fiiiiiifiiiiiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiifiif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiifiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiifii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiifii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiffi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiffi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vidd(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vidd'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiiiiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_fif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'fif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viifiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viifiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_fii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'fii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiiiiff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiiiiff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiiiiifiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiiiiifiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_di(x) {
 Module["printErr"]("Invalid function pointer called with signature 'di'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiifiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiifiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiiif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viffff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viffff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vfff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vfff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vififfi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vififfi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_dii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'dii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiifiiff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiifiiff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iifff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iifff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iifii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iifii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vdddddd(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vdddddd'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiiiiiiiiiffffii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiiiiiiiiiffffii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vdd(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vdd'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vfii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vfii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vifiiiiiiiiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vifiiiiiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiiiif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiiiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vifififfi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vifififfi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiifii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiifii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiiiiiiiiiiiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiiiiiiiiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vifiiiiiiiiiiiiiiiiiiiiiiiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vifiiiiiiiiiiiiiiiiiiiiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viffi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viffi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiifiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiifiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vifi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vifi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vifff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vifff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viifififfi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viifififfi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_fiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'fiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiiifffiiifii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiiifffiiifii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iifiiff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iifiiff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iifiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iifiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_fiif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'fiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiifiiiif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiifiiiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiidiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiidiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiifiifii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiifiifii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiiiiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiiiffiiiiiiiiiffffiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiiiffiiiiiiiiiffffiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_diii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'diii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iifififf(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iifififf'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiiiiiiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiiiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiid(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiid'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiiifiif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiiifiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vid(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vid'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiidi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiidi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiifififf(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiifififf'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiiifii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiiifii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiifiififf(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiifiififf'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_d(x) {
 Module["printErr"]("Invalid function pointer called with signature 'd'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiifififfi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiifififfi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viifii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viifii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_fi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'fi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viifif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viifif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_fiiiiiiiifiiiif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'fiiiiiiiifiiiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiifiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiifiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiififf(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiififf'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vifiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vifiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiiifiiiiif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiiifiiiiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiiiiiiiiiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiiiiiiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiiiiiiiffffii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiiiiiiiffffii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiiff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiiff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vifiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vifiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vifii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vifii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiiiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_fiiiif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'fiiiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiifii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiifii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_f(x) {
 Module["printErr"]("Invalid function pointer called with signature 'f'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vffff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vffff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_v(x) {
 Module["printErr"]("Invalid function pointer called with signature 'v'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viid(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viid'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiifi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiifi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiifififf(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiifififf'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vd(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vd'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vf(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vf'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiiiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_ii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'ii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viifi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viifi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiifiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiifiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiifiiiiif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiifiiiiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiifiiff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiifiiff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iifi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iifi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_if(x) {
 Module["printErr"]("Invalid function pointer called with signature 'if'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vffffi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vffffi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vifiiiiiiiiiiiiiiiiiiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vifiiiiiiiiiiiiiiiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiffii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiffii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iifiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iifiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiifi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiifi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viifff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viifff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iifiififf(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iifiififf'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiffi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiffi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiid(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiid'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiif(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiiffi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiiffi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vffffffi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vffffffi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viiifi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viiifi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiifiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiifiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_ff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'ff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiifiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiifiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiifiififf(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiifiififf'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viififfi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viififfi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viffffffffffffiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viffffffffffffiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vfi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vfi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iififf(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iififf'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_i(x) {
 Module["printErr"]("Invalid function pointer called with signature 'i'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiififf(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiififf'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_vifffff(x) {
 Module["printErr"]("Invalid function pointer called with signature 'vifffff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_iiiiiiiii(x) {
 Module["printErr"]("Invalid function pointer called with signature 'iiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
function nullFunc_viffffi(x) {
 Module["printErr"]("Invalid function pointer called with signature 'viffffi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
 Module["printErr"]("Build with ASSERTIONS=2 for more info.");
 abort(x);
}
var gb = Runtime.GLOBAL_BASE, fb = 0;
var setTempRet0 = Runtime.setTempRet0, getTempRet0 = Runtime.getTempRet0;
function invoke_viiifiii(index, a1, a2, a3, a4, a5, a6, a7) {
 try {
  Module["dynCall_viiifiii"](index, a1, a2, a3, a4, a5, a6, a7);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_viiifiii(x, a0, a1, a2, a3, a4, a5, a6) {
 if (x < 0 || x >= FUNCTION_TABLE_viiifiii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'viiifiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_viiifiii[x](a0, a1, a2, a3, a4, a5, a6);
}
function invoke_iiiiiid(index, a1, a2, a3, a4, a5, a6) {
 try {
  return Module["dynCall_iiiiiid"](index, a1, a2, a3, a4, a5, a6);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_iiiiiid(x, a0, a1, a2, a3, a4, a5) {
 if (x < 0 || x >= FUNCTION_TABLE_iiiiiid.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'iiiiiid'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_iiiiiid[x](a0, a1, a2, a3, a4, a5);
}
function invoke_fiff(index, a1, a2, a3) {
 try {
  return Module["dynCall_fiff"](index, a1, a2, a3);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_fiff(x, a0, a1, a2) {
 if (x < 0 || x >= FUNCTION_TABLE_fiff.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'fiff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_fiff[x](a0, a1, a2);
}
function invoke_iiififii(index, a1, a2, a3, a4, a5, a6, a7) {
 try {
  return Module["dynCall_iiififii"](index, a1, a2, a3, a4, a5, a6, a7);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_iiififii(x, a0, a1, a2, a3, a4, a5, a6) {
 if (x < 0 || x >= FUNCTION_TABLE_iiififii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'iiififii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_iiififii[x](a0, a1, a2, a3, a4, a5, a6);
}
function invoke_iiiiiii(index, a1, a2, a3, a4, a5, a6) {
 try {
  return Module["dynCall_iiiiiii"](index, a1, a2, a3, a4, a5, a6);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_iiiiiii(x, a0, a1, a2, a3, a4, a5) {
 if (x < 0 || x >= FUNCTION_TABLE_iiiiiii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'iiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_iiiiiii[x](a0, a1, a2, a3, a4, a5);
}
function invoke_vifiiiiiiiiiiiiiiiiii(index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20) {
 try {
  Module["dynCall_vifiiiiiiiiiiiiiiiiii"](index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_vifiiiiiiiiiiiiiiiiii(x, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19) {
 if (x < 0 || x >= FUNCTION_TABLE_vifiiiiiiiiiiiiiiiiii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'vifiiiiiiiiiiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_vifiiiiiiiiiiiiiiiiii[x](a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19);
}
function invoke_viiiiiiiiiii(index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11) {
 try {
  Module["dynCall_viiiiiiiiiii"](index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_viiiiiiiiiii(x, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10) {
 if (x < 0 || x >= FUNCTION_TABLE_viiiiiiiiiii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'viiiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_viiiiiiiiiii[x](a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
}
function invoke_fff(index, a1, a2) {
 try {
  return Module["dynCall_fff"](index, a1, a2);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_fff(x, a0, a1) {
 if (x < 0 || x >= FUNCTION_TABLE_fff.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'fff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_fff[x](a0, a1);
}
function invoke_fiiiiiifiiiiiif(index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14) {
 try {
  return Module["dynCall_fiiiiiifiiiiiif"](index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_fiiiiiifiiiiiif(x, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13) {
 if (x < 0 || x >= FUNCTION_TABLE_fiiiiiifiiiiiif.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'fiiiiiifiiiiiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_fiiiiiifiiiiiif[x](a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13);
}
function invoke_iiiiifiif(index, a1, a2, a3, a4, a5, a6, a7, a8) {
 try {
  return Module["dynCall_iiiiifiif"](index, a1, a2, a3, a4, a5, a6, a7, a8);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_iiiiifiif(x, a0, a1, a2, a3, a4, a5, a6, a7) {
 if (x < 0 || x >= FUNCTION_TABLE_iiiiifiif.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'iiiiifiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_iiiiifiif[x](a0, a1, a2, a3, a4, a5, a6, a7);
}
function invoke_iiiiifii(index, a1, a2, a3, a4, a5, a6, a7) {
 try {
  return Module["dynCall_iiiiifii"](index, a1, a2, a3, a4, a5, a6, a7);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_iiiiifii(x, a0, a1, a2, a3, a4, a5, a6) {
 if (x < 0 || x >= FUNCTION_TABLE_iiiiifii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'iiiiifii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_iiiiifii[x](a0, a1, a2, a3, a4, a5, a6);
}
function invoke_iiffi(index, a1, a2, a3, a4) {
 try {
  return Module["dynCall_iiffi"](index, a1, a2, a3, a4);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_iiffi(x, a0, a1, a2, a3) {
 if (x < 0 || x >= FUNCTION_TABLE_iiffi.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'iiffi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_iiffi[x](a0, a1, a2, a3);
}
function invoke_vidd(index, a1, a2, a3) {
 try {
  Module["dynCall_vidd"](index, a1, a2, a3);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_vidd(x, a0, a1, a2) {
 if (x < 0 || x >= FUNCTION_TABLE_vidd.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'vidd'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_vidd[x](a0, a1, a2);
}
function invoke_iiiiiiiiiiii(index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11) {
 try {
  return Module["dynCall_iiiiiiiiiiii"](index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_iiiiiiiiiiii(x, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10) {
 if (x < 0 || x >= FUNCTION_TABLE_iiiiiiiiiiii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'iiiiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_iiiiiiiiiiii[x](a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
}
function invoke_fif(index, a1, a2) {
 try {
  return Module["dynCall_fif"](index, a1, a2);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_fif(x, a0, a1) {
 if (x < 0 || x >= FUNCTION_TABLE_fif.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'fif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_fif[x](a0, a1);
}
function invoke_viifiii(index, a1, a2, a3, a4, a5, a6) {
 try {
  Module["dynCall_viifiii"](index, a1, a2, a3, a4, a5, a6);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_viifiii(x, a0, a1, a2, a3, a4, a5) {
 if (x < 0 || x >= FUNCTION_TABLE_viifiii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'viifiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_viifiii[x](a0, a1, a2, a3, a4, a5);
}
function invoke_fii(index, a1, a2) {
 try {
  return Module["dynCall_fii"](index, a1, a2);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_fii(x, a0, a1) {
 if (x < 0 || x >= FUNCTION_TABLE_fii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'fii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_fii[x](a0, a1);
}
function invoke_viiiiiff(index, a1, a2, a3, a4, a5, a6, a7) {
 try {
  Module["dynCall_viiiiiff"](index, a1, a2, a3, a4, a5, a6, a7);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_viiiiiff(x, a0, a1, a2, a3, a4, a5, a6) {
 if (x < 0 || x >= FUNCTION_TABLE_viiiiiff.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'viiiiiff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_viiiiiff[x](a0, a1, a2, a3, a4, a5, a6);
}
function invoke_viiiiiifiii(index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10) {
 try {
  Module["dynCall_viiiiiifiii"](index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_viiiiiifiii(x, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9) {
 if (x < 0 || x >= FUNCTION_TABLE_viiiiiifiii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'viiiiiifiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_viiiiiifiii[x](a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
}
function invoke_di(index, a1) {
 try {
  return Module["dynCall_di"](index, a1);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_di(x, a0) {
 if (x < 0 || x >= FUNCTION_TABLE_di.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'di'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_di[x](a0);
}
function invoke_viff(index, a1, a2, a3) {
 try {
  Module["dynCall_viff"](index, a1, a2, a3);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_viff(x, a0, a1, a2) {
 if (x < 0 || x >= FUNCTION_TABLE_viff.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'viff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_viff[x](a0, a1, a2);
}
function invoke_iiifiii(index, a1, a2, a3, a4, a5, a6) {
 try {
  return Module["dynCall_iiifiii"](index, a1, a2, a3, a4, a5, a6);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_iiifiii(x, a0, a1, a2, a3, a4, a5) {
 if (x < 0 || x >= FUNCTION_TABLE_iiifiii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'iiifiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_iiifiii[x](a0, a1, a2, a3, a4, a5);
}
function invoke_viiiif(index, a1, a2, a3, a4, a5) {
 try {
  Module["dynCall_viiiif"](index, a1, a2, a3, a4, a5);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_viiiif(x, a0, a1, a2, a3, a4) {
 if (x < 0 || x >= FUNCTION_TABLE_viiiif.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'viiiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_viiiif[x](a0, a1, a2, a3, a4);
}
function invoke_viffff(index, a1, a2, a3, a4, a5) {
 try {
  Module["dynCall_viffff"](index, a1, a2, a3, a4, a5);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_viffff(x, a0, a1, a2, a3, a4) {
 if (x < 0 || x >= FUNCTION_TABLE_viffff.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'viffff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_viffff[x](a0, a1, a2, a3, a4);
}
function invoke_vfff(index, a1, a2, a3) {
 try {
  Module["dynCall_vfff"](index, a1, a2, a3);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_vfff(x, a0, a1, a2) {
 if (x < 0 || x >= FUNCTION_TABLE_vfff.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'vfff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_vfff[x](a0, a1, a2);
}
function invoke_vififfi(index, a1, a2, a3, a4, a5, a6) {
 try {
  Module["dynCall_vififfi"](index, a1, a2, a3, a4, a5, a6);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_vififfi(x, a0, a1, a2, a3, a4, a5) {
 if (x < 0 || x >= FUNCTION_TABLE_vififfi.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'vififfi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_vififfi[x](a0, a1, a2, a3, a4, a5);
}
function invoke_dii(index, a1, a2) {
 try {
  return Module["dynCall_dii"](index, a1, a2);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_dii(x, a0, a1) {
 if (x < 0 || x >= FUNCTION_TABLE_dii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'dii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_dii[x](a0, a1);
}
function invoke_iiifiiff(index, a1, a2, a3, a4, a5, a6, a7) {
 try {
  return Module["dynCall_iiifiiff"](index, a1, a2, a3, a4, a5, a6, a7);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_iiifiiff(x, a0, a1, a2, a3, a4, a5, a6) {
 if (x < 0 || x >= FUNCTION_TABLE_iiifiiff.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'iiifiiff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_iiifiiff[x](a0, a1, a2, a3, a4, a5, a6);
}
function invoke_viiiiii(index, a1, a2, a3, a4, a5, a6) {
 try {
  Module["dynCall_viiiiii"](index, a1, a2, a3, a4, a5, a6);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_viiiiii(x, a0, a1, a2, a3, a4, a5) {
 if (x < 0 || x >= FUNCTION_TABLE_viiiiii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'viiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_viiiiii[x](a0, a1, a2, a3, a4, a5);
}
function invoke_iifff(index, a1, a2, a3, a4) {
 try {
  return Module["dynCall_iifff"](index, a1, a2, a3, a4);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_iifff(x, a0, a1, a2, a3) {
 if (x < 0 || x >= FUNCTION_TABLE_iifff.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'iifff'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_iifff[x](a0, a1, a2, a3);
}
function invoke_iifii(index, a1, a2, a3, a4) {
 try {
  return Module["dynCall_iifii"](index, a1, a2, a3, a4);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_iifii(x, a0, a1, a2, a3) {
 if (x < 0 || x >= FUNCTION_TABLE_iifii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'iifii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_iifii[x](a0, a1, a2, a3);
}
function invoke_iiiiiiiiii(index, a1, a2, a3, a4, a5, a6, a7, a8, a9) {
 try {
  return Module["dynCall_iiiiiiiiii"](index, a1, a2, a3, a4, a5, a6, a7, a8, a9);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_iiiiiiiiii(x, a0, a1, a2, a3, a4, a5, a6, a7, a8) {
 if (x < 0 || x >= FUNCTION_TABLE_iiiiiiiiii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'iiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_iiiiiiiiii[x](a0, a1, a2, a3, a4, a5, a6, a7, a8);
}
function invoke_vdddddd(index, a1, a2, a3, a4, a5, a6) {
 try {
  Module["dynCall_vdddddd"](index, a1, a2, a3, a4, a5, a6);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_vdddddd(x, a0, a1, a2, a3, a4, a5) {
 if (x < 0 || x >= FUNCTION_TABLE_vdddddd.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'vdddddd'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_vdddddd[x](a0, a1, a2, a3, a4, a5);
}
function invoke_iiiiiiiiiiiiffffii(index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17) {
 try {
  return Module["dynCall_iiiiiiiiiiiiffffii"](index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_iiiiiiiiiiiiffffii(x, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16) {
 if (x < 0 || x >= FUNCTION_TABLE_iiiiiiiiiiiiffffii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'iiiiiiiiiiiiffffii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_iiiiiiiiiiiiffffii[x](a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16);
}
function invoke_vdd(index, a1, a2) {
 try {
  Module["dynCall_vdd"](index, a1, a2);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_vdd(x, a0, a1) {
 if (x < 0 || x >= FUNCTION_TABLE_vdd.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'vdd'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_vdd[x](a0, a1);
}
function invoke_iiiif(index, a1, a2, a3, a4) {
 try {
  return Module["dynCall_iiiif"](index, a1, a2, a3, a4);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_iiiif(x, a0, a1, a2, a3) {
 if (x < 0 || x >= FUNCTION_TABLE_iiiif.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'iiiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_iiiif[x](a0, a1, a2, a3);
}
function invoke_iiiiiiii(index, a1, a2, a3, a4, a5, a6, a7) {
 try {
  return Module["dynCall_iiiiiiii"](index, a1, a2, a3, a4, a5, a6, a7);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_iiiiiiii(x, a0, a1, a2, a3, a4, a5, a6) {
 if (x < 0 || x >= FUNCTION_TABLE_iiiiiiii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'iiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_iiiiiiii[x](a0, a1, a2, a3, a4, a5, a6);
}
function invoke_vfii(index, a1, a2, a3) {
 try {
  Module["dynCall_vfii"](index, a1, a2, a3);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_vfii(x, a0, a1, a2) {
 if (x < 0 || x >= FUNCTION_TABLE_vfii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'vfii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_vfii[x](a0, a1, a2);
}
function invoke_vifiiiiiiiiiiiii(index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15) {
 try {
  Module["dynCall_vifiiiiiiiiiiiii"](index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_vifiiiiiiiiiiiii(x, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14) {
 if (x < 0 || x >= FUNCTION_TABLE_vifiiiiiiiiiiiii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'vifiiiiiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_vifiiiiiiiiiiiii[x](a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14);
}
function invoke_viiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii(index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27, a28, a29, a30, a31, a32, a33, a34) {
 try {
  Module["dynCall_viiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii"](index, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27, a28, a29, a30, a31, a32, a33, a34);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_viiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii(x, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27, a28, a29, a30, a31, a32, a33) {
 if (x < 0 || x >= FUNCTION_TABLE_viiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'viiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_viiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii[x](a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27, a28, a29, a30, a31, a32, a33);
}
function invoke_iiiiiiif(index, a1, a2, a3, a4, a5, a6, a7) {
 try {
  return Module["dynCall_iiiiiiif"](index, a1, a2, a3, a4, a5, a6, a7);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_iiiiiiif(x, a0, a1, a2, a3, a4, a5, a6) {
 if (x < 0 || x >= FUNCTION_TABLE_iiiiiiif.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'iiiiiiif'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_iiiiiiif[x](a0, a1, a2, a3, a4, a5, a6);
}
function invoke_iiiii(index, a1, a2, a3, a4) {
 try {
  return Module["dynCall_iiiii"](index, a1, a2, a3, a4);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_iiiii(x, a0, a1, a2, a3) {
 if (x < 0 || x >= FUNCTION_TABLE_iiiii.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'iiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_iiiii[x](a0, a1, a2, a3);
}
function invoke_vifififfi(index, a1, a2, a3, a4, a5, a6, a7, a8) {
 try {
  Module["dynCall_vifififfi"](index, a1, a2, a3, a4, a5, a6, a7, a8);
 } catch (e) {
  if (typeof e !== "number" && e !== "longjmp") throw e;
  asm["setThrew"](1, 0);
 }
}
function ftCall_vifififfi(x, a0, a1, a2, a3, a4, a5, a6, a7) {
 if (x < 0 || x >= FUNCTION_TABLE_vifififfi.length) {
  Module.printErr("Function table mask error (out of range)");
  Module["printErr"]("Invalid function pointer called with signature 'vifififfi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");
  Module["printErr"]("Build with ASSERTIONS=2 for more info.");
  abort(x);
 }
 return FUNCTION_TABLE_vifififfi[x](a0, a1, a2, a3, a4, a5, a6