"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Capture = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const matcher_1 = require("./matcher");
const type_1 = require("./private/type");
/**
 * Capture values while matching templates.
 *
 * Using an instance of this class within a Matcher will capture the matching value.
 * The `as*()` APIs on the instance can be used to get the captured value.
 *
 * @stability stable
 */
class Capture extends matcher_1.Matcher {
    /**
     * @stability stable
     */
    constructor() {
        super();
        this.value = null;
        this.name = 'Capture';
    }
    /**
     * Test whether a target matches the provided pattern.
     *
     * Every Matcher must implement this method.
     * This method will be invoked by the assertions framework. Do not call this method directly.
     *
     * @stability stable
     */
    test(actual) {
        this.value = actual;
        const result = new matcher_1.MatchResult(actual);
        if (actual == null) {
            result.push(this, [], `Can only capture non-nullish values. Found ${actual}`);
        }
        return result;
    }
    /**
     * Retrieve the captured value as a string.
     *
     * An error is generated if no value is captured or if the value is not a string.
     *
     * @stability stable
     */
    asString() {
        this.checkNotNull();
        if (type_1.getType(this.value) === 'string') {
            return this.value;
        }
        this.reportIncorrectType('string');
    }
    /**
     * Retrieve the captured value as a number.
     *
     * An error is generated if no value is captured or if the value is not a number.
     *
     * @stability stable
     */
    asNumber() {
        this.checkNotNull();
        if (type_1.getType(this.value) === 'number') {
            return this.value;
        }
        this.reportIncorrectType('number');
    }
    /**
     * Retrieve the captured value as a boolean.
     *
     * An error is generated if no value is captured or if the value is not a boolean.
     *
     * @stability stable
     */
    asBoolean() {
        this.checkNotNull();
        if (type_1.getType(this.value) === 'boolean') {
            return this.value;
        }
        this.reportIncorrectType('boolean');
    }
    /**
     * Retrieve the captured value as an array.
     *
     * An error is generated if no value is captured or if the value is not an array.
     *
     * @stability stable
     */
    asArray() {
        this.checkNotNull();
        if (type_1.getType(this.value) === 'array') {
            return this.value;
        }
        this.reportIncorrectType('array');
    }
    /**
     * Retrieve the captured value as a JSON object.
     *
     * An error is generated if no value is captured or if the value is not an object.
     *
     * @stability stable
     */
    asObject() {
        this.checkNotNull();
        if (type_1.getType(this.value) === 'object') {
            return this.value;
        }
        this.reportIncorrectType('object');
    }
    checkNotNull() {
        if (this.value == null) {
            throw new Error('No value captured');
        }
    }
    reportIncorrectType(expected) {
        throw new Error(`Captured value is expected to be ${expected} but found ${type_1.getType(this.value)}. ` +
            `Value is ${JSON.stringify(this.value, undefined, 2)}`);
    }
}
exports.Capture = Capture;
_a = JSII_RTTI_SYMBOL_1;
Capture[_a] = { fqn: "@aws-cdk/assertions.Capture", version: "1.134.0" };
//# sourceMappingURL=data:application/json;base64,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