"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchResult = exports.Matcher = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents a matcher that can perform special data matching capabilities between a given pattern and a target.
 *
 * @stability stable
 */
class Matcher {
    /**
     * Check whether the provided object is a subtype of the `IMatcher`.
     *
     * @stability stable
     */
    static isMatcher(x) {
        return x && x instanceof Matcher;
    }
}
exports.Matcher = Matcher;
_a = JSII_RTTI_SYMBOL_1;
Matcher[_a] = { fqn: "@aws-cdk/assertions.Matcher", version: "1.134.0" };
/**
 * The result of `Match.test()`.
 *
 * @stability stable
 */
class MatchResult {
    /**
     * @stability stable
     */
    constructor(target) {
        this.failures = [];
        this.target = target;
    }
    /**
     * Push a new failure into this result at a specific path.
     *
     * If the failure occurred at root of the match tree, set the path to an empty list.
     * If it occurs in the 5th index of an array nested within the 'foo' key of an object,
     * set the path as `['/foo', '[5]']`.
     *
     * @param path the path at which the failure occurred.
     * @param message the failure.
     * @stability stable
     */
    push(matcher, path, message) {
        jsiiDeprecationWarnings._aws_cdk_assertions_Matcher(matcher);
        this.failures.push({ matcher, path, message });
        return this;
    }
    /**
     * Does the result contain any failures.
     *
     * If not, the result is a success
     *
     * @stability stable
     */
    hasFailed() {
        return this.failures.length !== 0;
    }
    /**
     * The number of failures.
     *
     * @stability stable
     */
    get failCount() {
        return this.failures.length;
    }
    /**
     * Compose the results of a previous match as a subtree.
     *
     * @param id the id of the parent tree.
     * @stability stable
     */
    compose(id, inner) {
        jsiiDeprecationWarnings._aws_cdk_assertions_MatchResult(inner);
        const innerF = inner.failures;
        this.failures.push(...innerF.map(f => {
            return { path: [id, ...f.path], message: f.message, matcher: f.matcher };
        }));
        return this;
    }
    /**
     * Get the list of failures as human readable strings.
     *
     * @stability stable
     */
    toHumanStrings() {
        return this.failures.map(r => {
            const loc = r.path.length === 0 ? '' : ` at ${r.path.join('')}`;
            return '' + r.message + loc + ` (using ${r.matcher.name} matcher)`;
        });
    }
}
exports.MatchResult = MatchResult;
_b = JSII_RTTI_SYMBOL_1;
MatchResult[_b] = { fqn: "@aws-cdk/assertions.MatchResult", version: "1.134.0" };
//# sourceMappingURL=data:application/json;base64,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