import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GcpSecretRolesetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Path where the GCP secrets engine is mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#backend GcpSecretRoleset#backend}
    */
    readonly backend: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#id GcpSecretRoleset#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#namespace GcpSecretRoleset#namespace}
    */
    readonly namespace?: string;
    /**
    * Name of the GCP project that this roleset's service account will belong to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#project GcpSecretRoleset#project}
    */
    readonly project: string;
    /**
    * Name of the RoleSet to create
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#roleset GcpSecretRoleset#roleset}
    */
    readonly roleset: string;
    /**
    * Type of secret generated for this role set. Defaults to `access_token`. Accepted values: `access_token`, `service_account_key`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#secret_type GcpSecretRoleset#secret_type}
    */
    readonly secretType?: string;
    /**
    * List of OAuth scopes to assign to `access_token` secrets generated under this role set (`access_token` role sets only)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#token_scopes GcpSecretRoleset#token_scopes}
    */
    readonly tokenScopes?: string[];
    /**
    * binding block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#binding GcpSecretRoleset#binding}
    */
    readonly binding: GcpSecretRolesetBinding[] | cdktf.IResolvable;
}
export interface GcpSecretRolesetBinding {
    /**
    * Resource name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#resource GcpSecretRoleset#resource}
    */
    readonly resource: string;
    /**
    * List of roles to apply to the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset#roles GcpSecretRoleset#roles}
    */
    readonly roles: string[];
}
export declare function gcpSecretRolesetBindingToTerraform(struct?: GcpSecretRolesetBinding | cdktf.IResolvable): any;
export declare class GcpSecretRolesetBindingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GcpSecretRolesetBinding | cdktf.IResolvable | undefined;
    set internalValue(value: GcpSecretRolesetBinding | cdktf.IResolvable | undefined);
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    get rolesInput(): string[] | undefined;
}
export declare class GcpSecretRolesetBindingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GcpSecretRolesetBinding[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GcpSecretRolesetBindingOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset vault_gcp_secret_roleset}
*/
export declare class GcpSecretRoleset extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_gcp_secret_roleset";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/gcp_secret_roleset vault_gcp_secret_roleset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GcpSecretRolesetConfig
    */
    constructor(scope: Construct, id: string, config: GcpSecretRolesetConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _roleset?;
    get roleset(): string;
    set roleset(value: string);
    get rolesetInput(): string | undefined;
    private _secretType?;
    get secretType(): string;
    set secretType(value: string);
    resetSecretType(): void;
    get secretTypeInput(): string | undefined;
    get serviceAccountEmail(): string;
    private _tokenScopes?;
    get tokenScopes(): string[];
    set tokenScopes(value: string[]);
    resetTokenScopes(): void;
    get tokenScopesInput(): string[] | undefined;
    private _binding;
    get binding(): GcpSecretRolesetBindingList;
    putBinding(value: GcpSecretRolesetBinding[] | cdktf.IResolvable): void;
    get bindingInput(): cdktf.IResolvable | GcpSecretRolesetBinding[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
