import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OktaAuthBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Okta url. Examples: oktapreview.com, okta.com (default)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#base_url OktaAuthBackend#base_url}
    */
    readonly baseUrl?: string;
    /**
    * When true, requests by Okta for a MFA check will be bypassed. This also disallows certain status checks on the account, such as whether the password is expired.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#bypass_okta_mfa OktaAuthBackend#bypass_okta_mfa}
    */
    readonly bypassOktaMfa?: boolean | cdktf.IResolvable;
    /**
    * The description of the auth backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#description OktaAuthBackend#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#group OktaAuthBackend#group}
    */
    readonly group?: OktaAuthBackendGroup[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#id OktaAuthBackend#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Maximum duration after which authentication will be expired
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#max_ttl OktaAuthBackend#max_ttl}
    */
    readonly maxTtl?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#namespace OktaAuthBackend#namespace}
    */
    readonly namespace?: string;
    /**
    * The Okta organization. This will be the first part of the url https://XXX.okta.com.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#organization OktaAuthBackend#organization}
    */
    readonly organization: string;
    /**
    * path to mount the backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#path OktaAuthBackend#path}
    */
    readonly path?: string;
    /**
    * The Okta API token. This is required to query Okta for user group membership. If this is not supplied only locally configured groups will be enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#token OktaAuthBackend#token}
    */
    readonly token?: string;
    /**
    * Duration after which authentication will be expired
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#ttl OktaAuthBackend#ttl}
    */
    readonly ttl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#user OktaAuthBackend#user}
    */
    readonly user?: OktaAuthBackendUser[] | cdktf.IResolvable;
}
export interface OktaAuthBackendGroup {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#group_name OktaAuthBackend#group_name}
    */
    readonly groupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#policies OktaAuthBackend#policies}
    */
    readonly policies?: string[];
}
export declare function oktaAuthBackendGroupToTerraform(struct?: OktaAuthBackendGroup | cdktf.IResolvable): any;
export declare class OktaAuthBackendGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OktaAuthBackendGroup | cdktf.IResolvable | undefined;
    set internalValue(value: OktaAuthBackendGroup | cdktf.IResolvable | undefined);
    private _groupName?;
    get groupName(): string;
    set groupName(value: string);
    resetGroupName(): void;
    get groupNameInput(): string | undefined;
    private _policies?;
    get policies(): string[];
    set policies(value: string[]);
    resetPolicies(): void;
    get policiesInput(): string[] | undefined;
}
export declare class OktaAuthBackendGroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OktaAuthBackendGroup[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OktaAuthBackendGroupOutputReference;
}
export interface OktaAuthBackendUser {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#groups OktaAuthBackend#groups}
    */
    readonly groups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#policies OktaAuthBackend#policies}
    */
    readonly policies?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend#username OktaAuthBackend#username}
    */
    readonly username?: string;
}
export declare function oktaAuthBackendUserToTerraform(struct?: OktaAuthBackendUser | cdktf.IResolvable): any;
export declare class OktaAuthBackendUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OktaAuthBackendUser | cdktf.IResolvable | undefined;
    set internalValue(value: OktaAuthBackendUser | cdktf.IResolvable | undefined);
    private _groups?;
    get groups(): string[];
    set groups(value: string[]);
    resetGroups(): void;
    get groupsInput(): string[] | undefined;
    private _policies?;
    get policies(): string[];
    set policies(value: string[]);
    resetPolicies(): void;
    get policiesInput(): string[] | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export declare class OktaAuthBackendUserList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OktaAuthBackendUser[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OktaAuthBackendUserOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend vault_okta_auth_backend}
*/
export declare class OktaAuthBackend extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_okta_auth_backend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/okta_auth_backend vault_okta_auth_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OktaAuthBackendConfig
    */
    constructor(scope: Construct, id: string, config: OktaAuthBackendConfig);
    get accessor(): string;
    private _baseUrl?;
    get baseUrl(): string;
    set baseUrl(value: string);
    resetBaseUrl(): void;
    get baseUrlInput(): string | undefined;
    private _bypassOktaMfa?;
    get bypassOktaMfa(): boolean | cdktf.IResolvable;
    set bypassOktaMfa(value: boolean | cdktf.IResolvable);
    resetBypassOktaMfa(): void;
    get bypassOktaMfaInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _group;
    get group(): OktaAuthBackendGroupList;
    putGroup(value: OktaAuthBackendGroup[] | cdktf.IResolvable): void;
    resetGroup(): void;
    get groupInput(): cdktf.IResolvable | OktaAuthBackendGroup[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxTtl?;
    get maxTtl(): string;
    set maxTtl(value: string);
    resetMaxTtl(): void;
    get maxTtlInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _token?;
    get token(): string;
    set token(value: string);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _user;
    get user(): OktaAuthBackendUserList;
    putUser(value: OktaAuthBackendUser[] | cdktf.IResolvable): void;
    resetUser(): void;
    get userInput(): cdktf.IResolvable | OktaAuthBackendUser[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
