import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RabbitmqSecretBackendRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The path of the Rabbitmq Secret Backend the role belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#backend RabbitmqSecretBackendRole#backend}
    */
    readonly backend: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#id RabbitmqSecretBackendRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Unique name for the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#name RabbitmqSecretBackendRole#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#namespace RabbitmqSecretBackendRole#namespace}
    */
    readonly namespace?: string;
    /**
    * Specifies a comma-separated RabbitMQ management tags.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#tags RabbitmqSecretBackendRole#tags}
    */
    readonly tags?: string;
    /**
    * vhost block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#vhost RabbitmqSecretBackendRole#vhost}
    */
    readonly vhost?: RabbitmqSecretBackendRoleVhost[] | cdktf.IResolvable;
    /**
    * vhost_topic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#vhost_topic RabbitmqSecretBackendRole#vhost_topic}
    */
    readonly vhostTopic?: RabbitmqSecretBackendRoleVhostTopic[] | cdktf.IResolvable;
}
export interface RabbitmqSecretBackendRoleVhost {
    /**
    * The configure permissions for this vhost.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#configure RabbitmqSecretBackendRole#configure}
    */
    readonly configure: string;
    /**
    * The vhost to set permissions for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#host RabbitmqSecretBackendRole#host}
    */
    readonly host: string;
    /**
    * The read permissions for this vhost.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#read RabbitmqSecretBackendRole#read}
    */
    readonly read: string;
    /**
    * The write permissions for this vhost.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#write RabbitmqSecretBackendRole#write}
    */
    readonly write: string;
}
export declare function rabbitmqSecretBackendRoleVhostToTerraform(struct?: RabbitmqSecretBackendRoleVhost | cdktf.IResolvable): any;
export declare class RabbitmqSecretBackendRoleVhostOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RabbitmqSecretBackendRoleVhost | cdktf.IResolvable | undefined;
    set internalValue(value: RabbitmqSecretBackendRoleVhost | cdktf.IResolvable | undefined);
    private _configure?;
    get configure(): string;
    set configure(value: string);
    get configureInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    get readInput(): string | undefined;
    private _write?;
    get write(): string;
    set write(value: string);
    get writeInput(): string | undefined;
}
export declare class RabbitmqSecretBackendRoleVhostList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: RabbitmqSecretBackendRoleVhost[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RabbitmqSecretBackendRoleVhostOutputReference;
}
export interface RabbitmqSecretBackendRoleVhostTopicVhost {
    /**
    * The read permissions for this vhost.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#read RabbitmqSecretBackendRole#read}
    */
    readonly read: string;
    /**
    * The vhost to set permissions for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#topic RabbitmqSecretBackendRole#topic}
    */
    readonly topic: string;
    /**
    * The write permissions for this vhost.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#write RabbitmqSecretBackendRole#write}
    */
    readonly write: string;
}
export declare function rabbitmqSecretBackendRoleVhostTopicVhostToTerraform(struct?: RabbitmqSecretBackendRoleVhostTopicVhost | cdktf.IResolvable): any;
export declare class RabbitmqSecretBackendRoleVhostTopicVhostOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RabbitmqSecretBackendRoleVhostTopicVhost | cdktf.IResolvable | undefined;
    set internalValue(value: RabbitmqSecretBackendRoleVhostTopicVhost | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    get readInput(): string | undefined;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
    private _write?;
    get write(): string;
    set write(value: string);
    get writeInput(): string | undefined;
}
export declare class RabbitmqSecretBackendRoleVhostTopicVhostList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: RabbitmqSecretBackendRoleVhostTopicVhost[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RabbitmqSecretBackendRoleVhostTopicVhostOutputReference;
}
export interface RabbitmqSecretBackendRoleVhostTopic {
    /**
    * The vhost to set permissions for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#host RabbitmqSecretBackendRole#host}
    */
    readonly host: string;
    /**
    * vhost block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role#vhost RabbitmqSecretBackendRole#vhost}
    */
    readonly vhost?: RabbitmqSecretBackendRoleVhostTopicVhost[] | cdktf.IResolvable;
}
export declare function rabbitmqSecretBackendRoleVhostTopicToTerraform(struct?: RabbitmqSecretBackendRoleVhostTopic | cdktf.IResolvable): any;
export declare class RabbitmqSecretBackendRoleVhostTopicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RabbitmqSecretBackendRoleVhostTopic | cdktf.IResolvable | undefined;
    set internalValue(value: RabbitmqSecretBackendRoleVhostTopic | cdktf.IResolvable | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _vhost;
    get vhost(): RabbitmqSecretBackendRoleVhostTopicVhostList;
    putVhost(value: RabbitmqSecretBackendRoleVhostTopicVhost[] | cdktf.IResolvable): void;
    resetVhost(): void;
    get vhostInput(): cdktf.IResolvable | RabbitmqSecretBackendRoleVhostTopicVhost[] | undefined;
}
export declare class RabbitmqSecretBackendRoleVhostTopicList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: RabbitmqSecretBackendRoleVhostTopic[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RabbitmqSecretBackendRoleVhostTopicOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role vault_rabbitmq_secret_backend_role}
*/
export declare class RabbitmqSecretBackendRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_rabbitmq_secret_backend_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend_role vault_rabbitmq_secret_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RabbitmqSecretBackendRoleConfig
    */
    constructor(scope: Construct, id: string, config: RabbitmqSecretBackendRoleConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _tags?;
    get tags(): string;
    set tags(value: string);
    resetTags(): void;
    get tagsInput(): string | undefined;
    private _vhost;
    get vhost(): RabbitmqSecretBackendRoleVhostList;
    putVhost(value: RabbitmqSecretBackendRoleVhost[] | cdktf.IResolvable): void;
    resetVhost(): void;
    get vhostInput(): cdktf.IResolvable | RabbitmqSecretBackendRoleVhost[] | undefined;
    private _vhostTopic;
    get vhostTopic(): RabbitmqSecretBackendRoleVhostTopicList;
    putVhostTopic(value: RabbitmqSecretBackendRoleVhostTopic[] | cdktf.IResolvable): void;
    resetVhostTopic(): void;
    get vhostTopicInput(): cdktf.IResolvable | RabbitmqSecretBackendRoleVhostTopic[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
