###################################
#            Register             #
###################################

# General
ADR = 0x39
ID = 0x92
ENABLE = 0x80
STATUS = 0x93
IFORCE = 0xE4
AICLEAR = 0xE7

# Config and Control
CONFIG1 = 0x8D
CONFIG2 = 0x90
CONFIG3 = 0x9F
CONTROL = 0x8F
WTIME = 0x83
PERS = 0x8C

# Proximity
PILT = 0x89
PIHT = 0x8B
PPULSE = 0x8E
PDATA = 0x9C
PICLEAR = 0xE5

# RGB
ATIME = 0x81
AILTL = 0x84
AIHTL = 0x86
CDATAL = 0x94
RDATAL = 0x96
GDATAL = 0x98
BDATAL = 0x9A
CICLEAR = 0xE6

# Gesture
GPENTH = 0xA0
GEXTH = 0xA1
GCONF1 = 0xA2
GCONF2 = 0xA3
GPULSE = 0xA6
GCONF3 = 0xAA
GCONF4 = 0xAB
GFLVL = 0xAE
GSTATUS = 0xAF
GFIFO = 0xFC


###################################
#             Values              #
###################################

# General
OFF = 0x00
ENABLE_PON = 0x01
ENABLE_WEN = 0x08

WTIME_VALUE = lambda t: max(0, min(255, int(256 - t / 2.78)))
WTIME_RESET = 0xFF

CONFIG1_WLONG = 0x02

LDRIVE_100 = 0x00
LDRIVE_50 = 0x40
LDRIVE_25 = 0x80
LDRIVE_12_5 = 0xC0
LDRIVE_RESET = 0x00

LEDBOOST_100 = 0x00
LEDBOOST_150 = 0x10
LEDBOOST_200 = 0x20
LEDBOOST_300 = 0x30
LEDBOOST_RESET = 0x00

ID_VALUE = 0xAB

# Proximity
ENABLE_PEN = 0x04
ENABLE_PIEN = 0x20

PGAIN_1 = 0x00
PGAIN_2 = 0x04
PGAIN_4 = 0x08
PGAIN_8 = 0x0C
PGAIN_RESET = 0x00

PPLEN_4 = 0x00
PPLEN_8 = 0x40
PPLEN_16 = 0x80
PPLEN_32 = 0xC0
PPULSE_RESET = 0x40

STATUS_PINT = 0x20
STATUS_PVALID = 0x02

# RGB
ENABLE_AEN = 0x02
ENABLE_AIEN = 0x10

ATIME_VALUE = lambda t: max(0, min(255, int(256 - t / 2.78)))
ATIME_RESET = 0xFF

AGAIN_1 = 0x00
AGAIN_4 = 0x01
AGAIN_16 = 0x02
AGAIN_64 = 0x03
AGAIN_RESET = 0x00

STATUS_AINT = 0x10
STATUS_AVALID = 0x01

# Gesture
ENABLE_GEN = 0x40

GFIFOTH_1 = 0x00
GFIFOTH_4 = 0x40
GFIFOTH_8 = 0x80
GFIFOTH_16 = 0xC0
GFIFOTH_RESET = 0x00

GGAIN_1 = 0x00
GGAIN_2 = 0x20
GGAIN_4 = 0x40
GGAIN_8 = 0x60
GGAIN_RESET = 0x00

GLDRIVE_100 = 0x00
GLDRIVE_50 = 0x08
GLDRIVE_25 = 0x10
GLDRIVE_12_5 = 0x18

GWTIME_0 = 0x00
GWTIME_28 = 0x01
GWTIME_56 = 0x02
GWTIME_84 = 0x03
GWTIME_140 = 0x04
GWTIME_224 = 0x05
GWTIME_308 = 0x06
GWTIME_392 = 0x07
GWTIME_RESET = 0x00

GPLEN_4 = 0x00
GPLEN_8 = 0x40
GPLEN_16 = 0x80
GPLEN_31 = 0xC0
GPLEN_RESET = 0x40

GPULSE_VALUE = lambda p: max(0, min(255, p - 1))
GPULSE_RESET = 0x00

GDIMS_ALL = 0x00
GDIMS_UD = 0x01
GDIMS_LR = 0x02
GDIMS_RESET = 0x00

GCONF4_GIEN = 0x02
GCONF4_GMODE = 0x01

STATUS_GINT = 0x04
GSTATUS_GFOV = 0x02
GSTATUS_GVALID = 0x01


###################################
#             Default             #
###################################

# General
CONFIG1_DEFAULT = 0x60
CONFIG2_DEFAULT = 0x01
CONFIG3_DEFAULT = 0x00
WTIME_DEFAULT = 0xF6
LDRIVE_DEFAULT = LDRIVE_100
LEDBOOST_DEFAULT = LEDBOOST_100
PERS_DEFAULT = 0x11

# Proximiy
PPULSE_DEFAULT = 0x87
PGAIN_DEFAULT = PGAIN_4
PILT_DEFAULT = 0x00
PIHT_DEFAULT = 0x32

# RGB
ATIME_DEFAULT = 0xDB
AGAIN_DEFAULT = AGAIN_64
AILT_DEFAULT = 0xFF
AIHT_DEFAULT = 0x00

# Gesture
G_PPULSE_DEFAULT = 0x89
GPENTH_DEFAULT = 0x28
GEXTH_DEFAULT = 0x1E
GCONF1_DEFAULT = 0x40
GGAIN_DEFAULT = GGAIN_8
GLDRIVE_DEFAULT = GLDRIVE_100
GWTIME_DEFAULT = GWTIME_28
GPULSE_DEFAULT = 0xC9
GCONF3_DEFAULT = 0x00
GIEN_DEFAULT = 0x00


###################################
#              Masks              #
###################################

# General
LDRIVE_MASK = 0x3F
LEDBOOST_MASK = 0xCF

# Proximity
PGAIN_MASK = 0xF3
PPLEN_MASK = 0x3F

# RGB
AGAIN_MASK = 0xFC

# Gesture
GFIFOTH_MASK = 0x3F
GGAIN_MASK = 0x9F
GLDRIVE_MASK = 0xE7
GWTIME_MASK = 0xF8
GPLEN_MASK = 0x3F
GPULSE_MASK = 0xC0
GDIMS_MASK = 0xFC
