/*
 * Decompiled with CFR 0.152.
 */
package com.pagesetup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class PageSetupFormatter {
    File excelFile;
    Workbook workbook;

    public PageSetupFormatter(File excelFile) throws IOException, FileNotFoundException {
        this.excelFile = excelFile;
        FileInputStream fileInputStream = new FileInputStream(excelFile);
        this.workbook = excelFile.getName().toLowerCase().endsWith(".xls") ? new HSSFWorkbook(fileInputStream) : new XSSFWorkbook(fileInputStream);
    }

    public Sheet getSheet(String sheetName) {
        return this.workbook.getSheet(sheetName);
    }

    public Sheet getSheet(Integer index) {
        return this.workbook.getSheetAt(index);
    }

    public void setFitColumnsToWidth(Sheet sheet) {
        sheet.getPrintSetup().setFitHeight((short)0);
        sheet.getPrintSetup().setFitWidth((short)1);
    }

    public void setFitColumnsToWidth(String sheetName) {
        Sheet sheet = this.workbook.getSheet(sheetName);
        sheet.getPrintSetup().setFitHeight((short)0);
        sheet.getPrintSetup().setFitWidth((short)1);
    }

    public void setFitToPage(String sheetName) {
        Sheet sheet = this.workbook.getSheet(sheetName);
        sheet.getPrintSetup().setFitHeight((short)1);
        sheet.getPrintSetup().setFitWidth((short)1);
    }

    public void setFitToPage(Sheet sheet) {
        sheet.getPrintSetup().setFitHeight((short)1);
        sheet.getPrintSetup().setFitWidth((short)1);
    }

    public void setRepeatingRange(Sheet sheet, String cellRange) {
        sheet.setRepeatingRows(CellRangeAddress.valueOf(cellRange));
    }

    public void setRepeatingRange(String sheetName, String cellRange) {
        Sheet sheet = this.workbook.getSheet(sheetName);
        sheet.setRepeatingRows(CellRangeAddress.valueOf(cellRange));
    }

    public void setLeftHeaderForSheet(Sheet sheet, String formatText) {
        sheet.getHeader().setLeft(formatText);
    }

    public void setCenterHeaderForSheet(Sheet sheet, String formatText) {
        sheet.getHeader().setCenter(formatText);
    }

    public void setRightHeaderForSheet(Sheet sheet, String formatText) {
        sheet.getHeader().setRight(formatText);
    }

    public void setLeftFooterForSheet(Sheet sheet, String formatText) {
        sheet.getFooter().setLeft(formatText);
    }

    public void setCenterFooterForSheet(Sheet sheet, String formatText) {
        sheet.getFooter().setCenter(formatText);
    }

    public void setRightFooterForSheet(Sheet sheet, String formatText) {
        sheet.getFooter().setRight(formatText);
    }

    public void writeToFile(String file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.workbook.write(fileOutputStream);
    }

    public Iterator<Sheet> getAllSheets() {
        return this.workbook.iterator();
    }

    public ArrayList<String> getAllSheetNames() {
        ArrayList<String> sheetNames = new ArrayList<String>();
        for (Sheet sheet : this.workbook) {
            sheetNames.add(sheet.getSheetName());
        }
        return sheetNames;
    }
}

