"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Amplifybackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [amplifybackend](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplifyadmin.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Amplifybackend extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [amplifybackend](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplifyadmin.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'amplifybackend';
        this.accessLevelList = {
            Write: [
                'CloneBackend',
                'CreateBackend',
                'CreateBackendAPI',
                'CreateBackendAuth',
                'CreateBackendConfig',
                'CreateToken',
                'DeleteBackend',
                'DeleteBackendAPI',
                'DeleteBackendAuth',
                'DeleteToken',
                'GenerateBackendAPIModels',
                'ImportBackendAuth',
                'RemoveAllBackends',
                'RemoveBackendConfig',
                'UpdateBackendAPI',
                'UpdateBackendAuth',
                'UpdateBackendConfig',
                'UpdateBackendJob'
            ],
            Read: [
                'GetBackend',
                'GetBackendAPI',
                'GetBackendAPIModels',
                'GetBackendAuth',
                'GetBackendJob',
                'GetToken'
            ],
            List: [
                'ListBackendJobs'
            ]
        };
    }
    /**
     * Grants permission to clone an existing Amplify Admin backend environment into a new Amplify Admin backend enviroment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-environments-backendenvironmentname-clone.html#CloneBackend
     */
    toCloneBackend() {
        return this.to('CloneBackend');
    }
    /**
     * Grants permission to create a new Amplify Admin backend environment by Amplify appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend.html#CreateBackend
     */
    toCreateBackend() {
        return this.to('CreateBackend');
    }
    /**
     * Grants permission to create an API for an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api.html#CreateBackendAPI
     */
    toCreateBackendAPI() {
        return this.to('CreateBackendAPI');
    }
    /**
     * Grants permission to create an auth resource for an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth.html#CreateBackendAuth
     */
    toCreateBackendAuth() {
        return this.to('CreateBackendAuth');
    }
    /**
     * Grants permission to create a new Amplify Admin backend config by Amplify appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config.html#CreateBackendConfig
     */
    toCreateBackendConfig() {
        return this.to('CreateBackendConfig');
    }
    /**
     * Grants permission to create an Amplify Admin challenge token by appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-challenge.html#CreateToken
     */
    toCreateToken() {
        return this.to('CreateToken');
    }
    /**
     * Grants permission to delete an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-environments-backendenvironmentname-remove.html#DeleteBackend
     */
    toDeleteBackend() {
        return this.to('DeleteBackend');
    }
    /**
     * Grants permission to delete an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-remove.html#DeleteBackendAPI
     */
    toDeleteBackendAPI() {
        return this.to('DeleteBackendAPI');
    }
    /**
     * Grants permission to delete an auth resource of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname-remove.html#DeleteBackendAuth
     */
    toDeleteBackendAuth() {
        return this.to('DeleteBackendAuth');
    }
    /**
     * Grants permission to delete an Amplify Admin challenge token by appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-challenge-sessionid-remove.html#DeleteToken
     */
    toDeleteToken() {
        return this.to('DeleteToken');
    }
    /**
     * Grants permission to generate models for an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-generatemodels.html#GenerateBackendAPIModels
     */
    toGenerateBackendAPIModels() {
        return this.to('GenerateBackendAPIModels');
    }
    /**
     * Grants permission to retrieve an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-details.html#GetBackend
     */
    toGetBackend() {
        return this.to('GetBackend');
    }
    /**
     * Grants permission to retrieve an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-details.html#GetBackendAPI
     */
    toGetBackendAPI() {
        return this.to('GetBackendAPI');
    }
    /**
     * Grants permission to retrieve models for an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-getmodels.html#GetBackendAPIModels
     */
    toGetBackendAPIModels() {
        return this.to('GetBackendAPIModels');
    }
    /**
     * Grants permission to retrieve an auth resource of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname-details.html#GetBackendAuth
     */
    toGetBackendAuth() {
        return this.to('GetBackendAuth');
    }
    /**
     * Grants permission to retrieve a job of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname-jobid.html#GetBackendJob
     */
    toGetBackendJob() {
        return this.to('GetBackendJob');
    }
    /**
     * Grants permission to retrieve an Amplify Admin challenge token by appId
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-challenge-sessionid.html#GetToken
     */
    toGetToken() {
        return this.to('GetToken');
    }
    /**
     * Grants permission to import an existing auth resource of an Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname.html#ImportBackendAuth
     */
    toImportBackendAuth() {
        return this.to('ImportBackendAuth');
    }
    /**
     * Grants permission to retrieve the jobs of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname.html#ListBackendJobs
     */
    toListBackendJobs() {
        return this.to('ListBackendJobs');
    }
    /**
     * Grants permission to delete all existing Amplify Admin backend environments by appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-remove.html#RemoveAllBackends
     */
    toRemoveAllBackends() {
        return this.to('RemoveAllBackends');
    }
    /**
     * Grants permission to delete an Amplify Admin backend config by Amplify appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config-remove.html#RemoveBackendConfig
     */
    toRemoveBackendConfig() {
        return this.to('RemoveBackendConfig');
    }
    /**
     * Grants permission to update an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname.html#UpdateBackendAPI
     */
    toUpdateBackendAPI() {
        return this.to('UpdateBackendAPI');
    }
    /**
     * Grants permission to update an auth resource of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname.html#UpdateBackendAuth
     */
    toUpdateBackendAuth() {
        return this.to('UpdateBackendAuth');
    }
    /**
     * Grants permission to update an Amplify Admin backend config by Amplify appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config-update.html#UpdateBackendConfig
     */
    toUpdateBackendConfig() {
        return this.to('UpdateBackendConfig');
    }
    /**
     * Grants permission to update a job of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname-jobid.html#UpdateBackendJob
     */
    toUpdateBackendJob() {
        return this.to('UpdateBackendJob');
    }
    /**
     * Adds a resource of type backend to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onBackend(appId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}`);
    }
    /**
     * Adds a resource of type environment to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-details.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onEnvironment(appId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/environments`);
    }
    /**
     * Adds a resource of type api to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onApi(appId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/api`);
    }
    /**
     * Adds a resource of type auth to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onAuth(appId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/auth`);
    }
    /**
     * Adds a resource of type job to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onJob(appId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/job`);
    }
    /**
     * Adds a resource of type config to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onConfig(appId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/config`);
    }
    /**
     * Adds a resource of type token to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-token.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onToken(appId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/token`);
    }
}
exports.Amplifybackend = Amplifybackend;
_a = JSII_RTTI_SYMBOL_1;
Amplifybackend[_a] = { fqn: "iam-floyd.Amplifybackend", version: "0.320.0" };
//# sourceMappingURL=data:application/json;base64,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