"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Comprehendmedical = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehendmedical.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Comprehendmedical extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehendmedical.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'comprehendmedical';
        this.accessLevelList = {
            Read: [
                'DescribeEntitiesDetectionV2Job',
                'DescribeICD10CMInferenceJob',
                'DescribePHIDetectionJob',
                'DescribeRxNormInferenceJob',
                'DetectEntitiesV2',
                'DetectPHI',
                'InferICD10CM',
                'InferRxNorm',
                'ListEntitiesDetectionV2Jobs',
                'ListICD10CMInferenceJobs',
                'ListPHIDetectionJobs',
                'ListRxNormInferenceJobs'
            ],
            Write: [
                'StartEntitiesDetectionV2Job',
                'StartICD10CMInferenceJob',
                'StartPHIDetectionJob',
                'StartRxNormInferenceJob',
                'StopEntitiesDetectionV2Job',
                'StopICD10CMInferenceJob',
                'StopPHIDetectionJob',
                'StopRxNormInferenceJob'
            ]
        };
    }
    /**
     * Grants permission to describe the properties of a medical entity detection job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DescribeEntitiesDetectionV2Job.html
     */
    toDescribeEntitiesDetectionV2Job() {
        return this.to('DescribeEntitiesDetectionV2Job');
    }
    /**
     * Grants permission to describe the properties of an ICD-10-CM linking job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DescribeICD10CMInferenceJob.html
     */
    toDescribeICD10CMInferenceJob() {
        return this.to('DescribeICD10CMInferenceJob');
    }
    /**
     * Grants permission to describe the properties of a PHI entity detection job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DescribePHIDetectionJob.html
     */
    toDescribePHIDetectionJob() {
        return this.to('DescribePHIDetectionJob');
    }
    /**
     * Grants permission to describe the properties of an RxNorm linking job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DescribeRxNormInferenceJob.html
     */
    toDescribeRxNormInferenceJob() {
        return this.to('DescribeRxNormInferenceJob');
    }
    /**
     * Grants permission to detect the named medical entities, and their relationships and traits within the given text document
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DetectEntitiesV2.html
     */
    toDetectEntitiesV2() {
        return this.to('DetectEntitiesV2');
    }
    /**
     * Grants permission to detect the protected health information (PHI) entities within the given text document
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_DetectPHI.html
     */
    toDetectPHI() {
        return this.to('DetectPHI');
    }
    /**
     * Grants permission to detect the medical condition entities within the given text document and link them to ICD-10-CM codes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_InferICD10CM.html
     */
    toInferICD10CM() {
        return this.to('InferICD10CM');
    }
    /**
     * Grants permission to detect the medication entities within the given text document and link them to RxCUI concept identifiers from the National Library of Medicine RxNorm database
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_InferRxNorm.html
     */
    toInferRxNorm() {
        return this.to('InferRxNorm');
    }
    /**
     * Grants permission to list the medical entity detection jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_ListEntitiesDetectionV2Jobs.html
     */
    toListEntitiesDetectionV2Jobs() {
        return this.to('ListEntitiesDetectionV2Jobs');
    }
    /**
     * Grants permission to list the ICD-10-CM linking jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_ListICD10CMInferenceJobs.html
     */
    toListICD10CMInferenceJobs() {
        return this.to('ListICD10CMInferenceJobs');
    }
    /**
     * Grants permission to list the PHI entity detection jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_ListPHIDetectionJobs.html
     */
    toListPHIDetectionJobs() {
        return this.to('ListPHIDetectionJobs');
    }
    /**
     * Grants permission to list the RxNorm linking jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_ListRxNormInferenceJobs.html
     */
    toListRxNormInferenceJobs() {
        return this.to('ListRxNormInferenceJobs');
    }
    /**
     * Grants permission to start an asynchronous medical entity detection job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StartEntitiesDetectionV2Job.html
     */
    toStartEntitiesDetectionV2Job() {
        return this.to('StartEntitiesDetectionV2Job');
    }
    /**
     * Grants permission to start an asynchronous ICD-10-CM linking job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StartICD10CMInferenceJob.html
     */
    toStartICD10CMInferenceJob() {
        return this.to('StartICD10CMInferenceJob');
    }
    /**
     * Grants permission to start an asynchronous PHI entity detection job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StartPHIDetectionJob.html
     */
    toStartPHIDetectionJob() {
        return this.to('StartPHIDetectionJob');
    }
    /**
     * Grants permission to start an asynchronous RxNorm linking job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StartRxNormInferenceJob.html
     */
    toStartRxNormInferenceJob() {
        return this.to('StartRxNormInferenceJob');
    }
    /**
     * Grants permission to stop a medical entity detection job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StopEntitiesDetectionV2Job.html
     */
    toStopEntitiesDetectionV2Job() {
        return this.to('StopEntitiesDetectionV2Job');
    }
    /**
     * Grants permission to stop an ICD-10-CM linking job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StopICD10CMInferenceJob.html
     */
    toStopICD10CMInferenceJob() {
        return this.to('StopICD10CMInferenceJob');
    }
    /**
     * Grants permission to stop a PHI entity detection job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StopPHIDetectionJob.html
     */
    toStopPHIDetectionJob() {
        return this.to('StopPHIDetectionJob');
    }
    /**
     * Grants permission to stop an RxNorm linking job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_medical_StopRxNormInferenceJob.html
     */
    toStopRxNormInferenceJob() {
        return this.to('StopRxNormInferenceJob');
    }
}
exports.Comprehendmedical = Comprehendmedical;
_a = JSII_RTTI_SYMBOL_1;
Comprehendmedical[_a] = { fqn: "iam-floyd.Comprehendmedical", version: "0.320.0" };
//# sourceMappingURL=data:application/json;base64,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