"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Connect = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [connect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Connect extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [connect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'connect';
        this.accessLevelList = {
            Write: [
                'AssociateApprovedOrigin',
                'AssociateBot',
                'AssociateCustomerProfilesDomain',
                'AssociateDefaultVocabulary',
                'AssociateInstanceStorageConfig',
                'AssociateLambdaFunction',
                'AssociateLexBot',
                'AssociateQueueQuickConnects',
                'AssociateRoutingProfileQueues',
                'AssociateSecurityKey',
                'CreateAgentStatus',
                'CreateContactFlow',
                'CreateContactFlowModule',
                'CreateHoursOfOperation',
                'CreateInstance',
                'CreateIntegrationAssociation',
                'CreateQueue',
                'CreateQuickConnect',
                'CreateRoutingProfile',
                'CreateSecurityProfile',
                'CreateUseCase',
                'CreateUser',
                'CreateUserHierarchyGroup',
                'CreateVocabulary',
                'DeleteContactFlow',
                'DeleteContactFlowModule',
                'DeleteHoursOfOperation',
                'DeleteInstance',
                'DeleteIntegrationAssociation',
                'DeleteQuickConnect',
                'DeleteSecurityProfile',
                'DeleteUseCase',
                'DeleteUser',
                'DeleteUserHierarchyGroup',
                'DeleteVocabulary',
                'DisassociateApprovedOrigin',
                'DisassociateBot',
                'DisassociateCustomerProfilesDomain',
                'DisassociateInstanceStorageConfig',
                'DisassociateLambdaFunction',
                'DisassociateLexBot',
                'DisassociateQueueQuickConnects',
                'DisassociateRoutingProfileQueues',
                'DisassociateSecurityKey',
                'GetFederationTokens',
                'ResumeContactRecording',
                'StartChatContact',
                'StartContactRecording',
                'StartOutboundVoiceContact',
                'StartTaskContact',
                'StopContact',
                'StopContactRecording',
                'SuspendContactRecording',
                'UpdateAgentStatus',
                'UpdateContact',
                'UpdateContactAttributes',
                'UpdateContactFlowContent',
                'UpdateContactFlowMetadata',
                'UpdateContactFlowModuleMetadata',
                'UpdateContactFlowName',
                'UpdateContactSchedule',
                'UpdateHoursOfOperation',
                'UpdateInstanceAttribute',
                'UpdateInstanceStorageConfig',
                'UpdateQueueHoursOfOperation',
                'UpdateQueueMaxContacts',
                'UpdateQueueName',
                'UpdateQueueOutboundCallerConfig',
                'UpdateQueueStatus',
                'UpdateQuickConnectConfig',
                'UpdateQuickConnectName',
                'UpdateRoutingProfileConcurrency',
                'UpdateRoutingProfileDefaultOutboundQueue',
                'UpdateRoutingProfileName',
                'UpdateRoutingProfileQueues',
                'UpdateSecurityProfile',
                'UpdateUserHierarchy',
                'UpdateUserHierarchyGroupName',
                'UpdateUserHierarchyStructure',
                'UpdateUserIdentityInfo',
                'UpdateUserPhoneConfig',
                'UpdateUserRoutingProfile',
                'UpdateUserSecurityProfiles',
                'UpdatedescribeContent'
            ],
            Read: [
                'DescribeAgentStatus',
                'DescribeContact',
                'DescribeContactFlow',
                'DescribeContactFlowModule',
                'DescribeHoursOfOperation',
                'DescribeInstance',
                'DescribeInstanceAttribute',
                'DescribeInstanceStorageConfig',
                'DescribeQueue',
                'DescribeQuickConnect',
                'DescribeRoutingProfile',
                'DescribeSecurityProfile',
                'DescribeUser',
                'DescribeUserHierarchyGroup',
                'DescribeUserHierarchyStructure',
                'DescribeVocabulary',
                'GetContactAttributes',
                'GetCurrentMetricData',
                'GetFederationToken',
                'GetMetricData',
                'ListRealtimeContactAnalysisSegments',
                'ListTagsForResource'
            ],
            List: [
                'ListAgentStatuses',
                'ListApprovedOrigins',
                'ListBots',
                'ListContactFlowModules',
                'ListContactFlows',
                'ListContactReferences',
                'ListDefaultVocabularies',
                'ListHoursOfOperations',
                'ListInstanceAttributes',
                'ListInstanceStorageConfigs',
                'ListInstances',
                'ListIntegrationAssociations',
                'ListLambdaFunctions',
                'ListLexBots',
                'ListPhoneNumbers',
                'ListPrompts',
                'ListQueueQuickConnects',
                'ListQueues',
                'ListQuickConnects',
                'ListRoutingProfileQueues',
                'ListRoutingProfiles',
                'ListSecurityKeys',
                'ListSecurityProfilePermissions',
                'ListSecurityProfiles',
                'ListUseCases',
                'ListUserHierarchyGroups',
                'ListUsers',
                'SearchVocabularies'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to associate approved origin for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateApprovedOrigin() {
        return this.to('AssociateApprovedOrigin');
    }
    /**
     * Grants permission to associate a Lex bot for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - lex:CreateResourcePolicy
     * - lex:DescribeBotAlias
     * - lex:GetBot
     * - lex:UpdateResourcePolicy
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateBot() {
        return this.to('AssociateBot');
    }
    /**
     * Grants permission to associate a Customer Profiles domain for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - profile:GetDomain
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateCustomerProfilesDomain() {
        return this.to('AssociateCustomerProfilesDomain');
    }
    /**
     * Grants permission to default vocabulary for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     */
    toAssociateDefaultVocabulary() {
        return this.to('AssociateDefaultVocabulary');
    }
    /**
     * Grants permission to associate instance storage for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStorageResourceType()
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     * - firehose:DescribeDeliveryStream
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - kinesis:DescribeStream
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - s3:GetBucketAcl
     * - s3:GetBucketLocation
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateInstanceStorageConfig() {
        return this.to('AssociateInstanceStorageConfig');
    }
    /**
     * Grants permission to associate a Lambda function for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - lambda:AddPermission
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateLambdaFunction() {
        return this.to('AssociateLambdaFunction');
    }
    /**
     * Grants permission to associate a Lex bot for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - lex:GetBot
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateLexBot() {
        return this.to('AssociateLexBot');
    }
    /**
     * Grants permission to associate quick connects with a queue in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_AssociateQueueQuickConnects.html
     */
    toAssociateQueueQuickConnects() {
        return this.to('AssociateQueueQuickConnects');
    }
    /**
     * Grants permission to associate queues with a routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_AssociateRoutingProfileQueues.html
     */
    toAssociateRoutingProfileQueues() {
        return this.to('AssociateRoutingProfileQueues');
    }
    /**
     * Grants permission to associate a security key for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateSecurityKey() {
        return this.to('AssociateSecurityKey');
    }
    /**
     * Grants permission to create agent status in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateAgentStatus.html
     */
    toCreateAgentStatus() {
        return this.to('CreateAgentStatus');
    }
    /**
     * Grants permission to create a contact flow in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateContactFlow.html
     */
    toCreateContactFlow() {
        return this.to('CreateContactFlow');
    }
    /**
     * Grants permission to create a contact flow module in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateContactFlowModule.html
     */
    toCreateContactFlowModule() {
        return this.to('CreateContactFlowModule');
    }
    /**
     * Grants permission to create hours of operation in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateHoursOfOperation.html
     */
    toCreateHoursOfOperation() {
        return this.to('CreateHoursOfOperation');
    }
    /**
     * Grants permission to create a new Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ds:AuthorizeApplication
     * - ds:CheckAlias
     * - ds:CreateAlias
     * - ds:CreateDirectory
     * - ds:CreateIdentityPoolDirectory
     * - ds:DeleteDirectory
     * - ds:DescribeDirectories
     * - ds:UnauthorizeApplication
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toCreateInstance() {
        return this.to('CreateInstance');
    }
    /**
     * Grants permission to create an integration association with an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - app-integrations:CreateEventIntegrationAssociation
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     * - events:PutRule
     * - events:PutTargets
     * - mobiletargeting:GetApp
     * - voiceid:DescribeDomain
     * - wisdom:GetAssistant
     * - wisdom:GetKnowledgeBase
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateIntegrationAssociation.html
     */
    toCreateIntegrationAssociation() {
        return this.to('CreateIntegrationAssociation');
    }
    /**
     * Grants permission to create a queue in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateQueue.html
     */
    toCreateQueue() {
        return this.to('CreateQueue');
    }
    /**
     * Grants permission to create a quick connect in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateQuickConnect.html
     */
    toCreateQuickConnect() {
        return this.to('CreateQuickConnect');
    }
    /**
     * Grants permission to create a routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateRoutingProfile.html
     */
    toCreateRoutingProfile() {
        return this.to('CreateRoutingProfile');
    }
    /**
     * Grants permission to create a security profile for the specified Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateSecurityProfile.html
     */
    toCreateSecurityProfile() {
        return this.to('CreateSecurityProfile');
    }
    /**
     * Grants permission to create a use case for an integration association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateUseCase.html
     */
    toCreateUseCase() {
        return this.to('CreateUseCase');
    }
    /**
     * Grants permission to create a user for the specified Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateUser.html
     */
    toCreateUser() {
        return this.to('CreateUser');
    }
    /**
     * Grants permission to create a user hierarchy group in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateUserHierarchyGroup.html
     */
    toCreateUserHierarchyGroup() {
        return this.to('CreateUserHierarchyGroup');
    }
    /**
     * Grants permission to create a vocabulary in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateVocabulary.html
     */
    toCreateVocabulary() {
        return this.to('CreateVocabulary');
    }
    /**
     * Grants permission to delete a contact flow in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteContactFlow.html
     */
    toDeleteContactFlow() {
        return this.to('DeleteContactFlow');
    }
    /**
     * Grants permission to delete a contact flow module in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteContactFlowModule.html
     */
    toDeleteContactFlowModule() {
        return this.to('DeleteContactFlowModule');
    }
    /**
     * Grants permission to delete hours of operation in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteHoursOfOperation.html
     */
    toDeleteHoursOfOperation() {
        return this.to('DeleteHoursOfOperation');
    }
    /**
     * Grants permission to delete an Amazon Connect instance. When you remove an instance, the link to an existing AWS directory is also removed
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ds:DeleteDirectory
     * - ds:DescribeDirectories
     * - ds:UnauthorizeApplication
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDeleteInstance() {
        return this.to('DeleteInstance');
    }
    /**
     * Grants permission to delete an integration association from an Amazon Connect instance. The association must not have any use cases associated with it
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - app-integrations:DeleteEventIntegrationAssociation
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     * - events:DeleteRule
     * - events:ListTargetsByRule
     * - events:RemoveTargets
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteIntegrationAssociation.html
     */
    toDeleteIntegrationAssociation() {
        return this.to('DeleteIntegrationAssociation');
    }
    /**
     * Grants permission to delete a quick connect in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteQuickConnect.html
     */
    toDeleteQuickConnect() {
        return this.to('DeleteQuickConnect');
    }
    /**
     * Grants permission to delete a security profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteSecurityProfile.html
     */
    toDeleteSecurityProfile() {
        return this.to('DeleteSecurityProfile');
    }
    /**
     * Grants permission to delete a use case from an integration association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteUseCase.html
     */
    toDeleteUseCase() {
        return this.to('DeleteUseCase');
    }
    /**
     * Grants permission to delete a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteUser.html
     */
    toDeleteUser() {
        return this.to('DeleteUser');
    }
    /**
     * Grants permission to delete a user hierarchy group in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteUserHierarchyGroup.html
     */
    toDeleteUserHierarchyGroup() {
        return this.to('DeleteUserHierarchyGroup');
    }
    /**
     * Grants permission to delete a vocabulary in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteVocabulary.html
     */
    toDeleteVocabulary() {
        return this.to('DeleteVocabulary');
    }
    /**
     * Grants permission to describe agent status in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeAgentStatus.html
     */
    toDescribeAgentStatus() {
        return this.to('DescribeAgentStatus');
    }
    /**
     * Grants permission to describe a contact in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeContact.html
     */
    toDescribeContact() {
        return this.to('DescribeContact');
    }
    /**
     * Grants permission to describe a contact flow in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeContactFlow.html
     */
    toDescribeContactFlow() {
        return this.to('DescribeContactFlow');
    }
    /**
     * Grants permission to describe a contact flow module in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeContactFlowModule.html
     */
    toDescribeContactFlowModule() {
        return this.to('DescribeContactFlowModule');
    }
    /**
     * Grants permission to describe hours of operation in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeHoursOfOperation.html
     */
    toDescribeHoursOfOperation() {
        return this.to('DescribeHoursOfOperation');
    }
    /**
     * Grants permission to view details of an Amazon Connect instance and is also required to create an instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDescribeInstance() {
        return this.to('DescribeInstance');
    }
    /**
     * Grants permission to view the attribute details of an existing Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAttributeType()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDescribeInstanceAttribute() {
        return this.to('DescribeInstanceAttribute');
    }
    /**
     * Grants permission to view the instance storage configuration for an existing Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifStorageResourceType()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDescribeInstanceStorageConfig() {
        return this.to('DescribeInstanceStorageConfig');
    }
    /**
     * Grants permission to describe a queue in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeQueue.html
     */
    toDescribeQueue() {
        return this.to('DescribeQueue');
    }
    /**
     * Grants permission to describe a quick connect in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeQuickConnect.html
     */
    toDescribeQuickConnect() {
        return this.to('DescribeQuickConnect');
    }
    /**
     * Grants permission to describe a routing profile in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeRoutingProfile.html
     */
    toDescribeRoutingProfile() {
        return this.to('DescribeRoutingProfile');
    }
    /**
     * Grants permission to describe a security profile in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeSecurityProfile.html
     */
    toDescribeSecurityProfile() {
        return this.to('DescribeSecurityProfile');
    }
    /**
     * Grants permission to describe a user in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeUser.html
     */
    toDescribeUser() {
        return this.to('DescribeUser');
    }
    /**
     * Grants permission to describe a hierarchy group for an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeUserHierarchyGroup.html
     */
    toDescribeUserHierarchyGroup() {
        return this.to('DescribeUserHierarchyGroup');
    }
    /**
     * Grants permission to describe the hierarchy structure for an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeUserHierarchyStructure.html
     */
    toDescribeUserHierarchyStructure() {
        return this.to('DescribeUserHierarchyStructure');
    }
    /**
     * Grants permission to describe a vocabulary in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeVocabulary.html
     */
    toDescribeVocabulary() {
        return this.to('DescribeVocabulary');
    }
    /**
     * Grants permission to disassociate approved origin for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateApprovedOrigin() {
        return this.to('DisassociateApprovedOrigin');
    }
    /**
     * Grants permission to disassociate a Lex bot for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - lex:DeleteResourcePolicy
     * - lex:UpdateResourcePolicy
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateBot() {
        return this.to('DisassociateBot');
    }
    /**
     * Grants permission to disassociate a Customer Profiles domain for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:DeleteRolePolicy
     * - iam:DetachRolePolicy
     * - iam:GetPolicy
     * - iam:GetPolicyVersion
     * - iam:GetRolePolicy
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateCustomerProfilesDomain() {
        return this.to('DisassociateCustomerProfilesDomain');
    }
    /**
     * Grants permission to disassociate instance storage for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStorageResourceType()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateInstanceStorageConfig() {
        return this.to('DisassociateInstanceStorageConfig');
    }
    /**
     * Grants permission to disassociate a Lambda function for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - lambda:RemovePermission
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateLambdaFunction() {
        return this.to('DisassociateLambdaFunction');
    }
    /**
     * Grants permission to disassociate a Lex bot for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateLexBot() {
        return this.to('DisassociateLexBot');
    }
    /**
     * Grants permission to disassociate quick connects from a queue in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DisassociateQueueQuickConnects.html
     */
    toDisassociateQueueQuickConnects() {
        return this.to('DisassociateQueueQuickConnects');
    }
    /**
     * Grants permission to disassociate queues from a routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DisassociateRoutingProfileQueues.html
     */
    toDisassociateRoutingProfileQueues() {
        return this.to('DisassociateRoutingProfileQueues');
    }
    /**
     * Grants permission to disassociate the security key for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateSecurityKey() {
        return this.to('DisassociateSecurityKey');
    }
    /**
     * Grants permission to retrieve the contact attributes for the specified contact
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_GetContactAttributes.html
     */
    toGetContactAttributes() {
        return this.to('GetContactAttributes');
    }
    /**
     * Grants permission to retrieve current metric data for the queues in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_GetCurrentMetricData.html
     */
    toGetCurrentMetricData() {
        return this.to('GetCurrentMetricData');
    }
    /**
     * Grants permission to federate into an Amazon Connect instance when using SAML-based authentication for identity management
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_GetFederationToken.html
     */
    toGetFederationToken() {
        return this.to('GetFederationToken');
    }
    /**
     * Grants permission to federate into an Amazon Connect instance (Log in for emergency access functionality in the Amazon Connect console)
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - connect:DescribeInstance
     * - connect:ListInstances
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/emergency-admin-login.html
     */
    toGetFederationTokens() {
        return this.to('GetFederationTokens');
    }
    /**
     * Grants permission to retrieve historical metric data for queues in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricData.html
     */
    toGetMetricData() {
        return this.to('GetMetricData');
    }
    /**
     * Grants permission to list agent statuses in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListAgentStatuses.html
     */
    toListAgentStatuses() {
        return this.to('ListAgentStatuses');
    }
    /**
     * Grants permission to view approved origins of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListApprovedOrigins() {
        return this.to('ListApprovedOrigins');
    }
    /**
     * Grants permission to view the Lex bots of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListBots() {
        return this.to('ListBots');
    }
    /**
     * Grants permission to list contact flow module resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListContactFlowModules.html
     */
    toListContactFlowModules() {
        return this.to('ListContactFlowModules');
    }
    /**
     * Grants permission to list contact flow resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListContactFlows.html
     */
    toListContactFlows() {
        return this.to('ListContactFlows');
    }
    /**
     * Grants permission to list references associated with a contact in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListContactReferences.html
     */
    toListContactReferences() {
        return this.to('ListContactReferences');
    }
    /**
     * Grants permission to list default vocabularies associated with a Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListDefaultVocabularies.html
     */
    toListDefaultVocabularies() {
        return this.to('ListDefaultVocabularies');
    }
    /**
     * Grants permission to list hours of operation resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListHoursOfOperations.html
     */
    toListHoursOfOperations() {
        return this.to('ListHoursOfOperations');
    }
    /**
     * Grants permission to view the attributes of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListInstanceAttributes() {
        return this.to('ListInstanceAttributes');
    }
    /**
     * Grants permission to view storage configurations of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListInstanceStorageConfigs() {
        return this.to('ListInstanceStorageConfigs');
    }
    /**
     * Grants permission to view the Amazon Connect instances associated with an AWS account
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListInstances() {
        return this.to('ListInstances');
    }
    /**
     * Grants permission to list summary information about the integration associations for the specified Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListIntegrationAssociations.html
     */
    toListIntegrationAssociations() {
        return this.to('ListIntegrationAssociations');
    }
    /**
     * Grants permission to view the Lambda functions of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListLambdaFunctions() {
        return this.to('ListLambdaFunctions');
    }
    /**
     * Grants permission to view the Lex bots of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListLexBots() {
        return this.to('ListLexBots');
    }
    /**
     * Grants permission to list phone number resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbers.html
     */
    toListPhoneNumbers() {
        return this.to('ListPhoneNumbers');
    }
    /**
     * Grants permission to list prompt resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPrompts.html
     */
    toListPrompts() {
        return this.to('ListPrompts');
    }
    /**
     * Grants permission to list quick connect resources in a queue in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListQueueQuickConnects.html
     */
    toListQueueQuickConnects() {
        return this.to('ListQueueQuickConnects');
    }
    /**
     * Grants permission to list queue resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListQueues.html
     */
    toListQueues() {
        return this.to('ListQueues');
    }
    /**
     * Grants permission to list quick connect resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListQuickConnects.html
     */
    toListQuickConnects() {
        return this.to('ListQuickConnects');
    }
    /**
     * Grants permission to list the analysis segments for a real-time analysis session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/contact-lens/latest/APIReference/API_ListRealtimeContactAnalysisSegments.html
     */
    toListRealtimeContactAnalysisSegments() {
        return this.to('ListRealtimeContactAnalysisSegments');
    }
    /**
     * Grants permission to list queue resources in a routing profile in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListRoutingProfileQueues.html
     */
    toListRoutingProfileQueues() {
        return this.to('ListRoutingProfileQueues');
    }
    /**
     * Grants permission to list routing profile resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListRoutingProfiles.html
     */
    toListRoutingProfiles() {
        return this.to('ListRoutingProfiles');
    }
    /**
     * Grants permission to view the security keys of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListSecurityKeys() {
        return this.to('ListSecurityKeys');
    }
    /**
     * Grants permission to list permissions associated with security profile in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListSecurityProfilePermissions.html
     */
    toListSecurityProfilePermissions() {
        return this.to('ListSecurityProfilePermissions');
    }
    /**
     * Grants permission to list security profile resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListSecurityProfiles.html
     */
    toListSecurityProfiles() {
        return this.to('ListSecurityProfiles');
    }
    /**
     * Grants permission to list tags for an Amazon Connect resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list the use cases of an integration association
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListUseCases.html
     */
    toListUseCases() {
        return this.to('ListUseCases');
    }
    /**
     * Grants permission to list the hierarchy group resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListUserHierarchyGroups.html
     */
    toListUserHierarchyGroups() {
        return this.to('ListUserHierarchyGroups');
    }
    /**
     * Grants permission to list user resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListUsers.html
     */
    toListUsers() {
        return this.to('ListUsers');
    }
    /**
     * Grants permission to resume recording for the specified contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ResumeContactRecording.html
     */
    toResumeContactRecording() {
        return this.to('ResumeContactRecording');
    }
    /**
     * Grants permission to search vocabularies in a Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchVocabularies.html
     */
    toSearchVocabularies() {
        return this.to('SearchVocabularies');
    }
    /**
     * Grants permission to initiate a chat using the Amazon Connect API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StartChatContact.html
     */
    toStartChatContact() {
        return this.to('StartChatContact');
    }
    /**
     * Grants permission to start recording for the specified contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactRecording.html
     */
    toStartContactRecording() {
        return this.to('StartContactRecording');
    }
    /**
     * Grants permission to initiate outbound calls using the Amazon Connect API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StartOutboundVoiceContact.html
     */
    toStartOutboundVoiceContact() {
        return this.to('StartOutboundVoiceContact');
    }
    /**
     * Grants permission to initiate a task using the Amazon Connect API
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StartTaskContact.html
     */
    toStartTaskContact() {
        return this.to('StartTaskContact');
    }
    /**
     * Grants permission to stop contacts that were initiated using the Amazon Connect API. If you use this operation on an active contact the contact ends, even if the agent is active on a call with a customer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StopContact.html
     */
    toStopContact() {
        return this.to('StopContact');
    }
    /**
     * Grants permission to stop recording for the specified contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StopContactRecording.html
     */
    toStopContactRecording() {
        return this.to('StopContactRecording');
    }
    /**
     * Grants permission to suspend recording for the specified contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_SuspendContactRecording.html
     */
    toSuspendContactRecording() {
        return this.to('SuspendContactRecording');
    }
    /**
     * Grants permission to tag an Amazon Connect resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag an Amazon Connect resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update agent status in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateAgentStatus.html
     */
    toUpdateAgentStatus() {
        return this.to('UpdateAgentStatus');
    }
    /**
     * Grants permission to update a contact in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContact.html
     */
    toUpdateContact() {
        return this.to('UpdateContact');
    }
    /**
     * Grants permission to create or update the contact attributes associated with the specified contact
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactAttributes.html
     */
    toUpdateContactAttributes() {
        return this.to('UpdateContactAttributes');
    }
    /**
     * Grants permission to update contact flow content in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactFlowContent.html
     */
    toUpdateContactFlowContent() {
        return this.to('UpdateContactFlowContent');
    }
    /**
     * Grants permission to update the metadata of a contact flow in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactFlowMetadata.html
     */
    toUpdateContactFlowMetadata() {
        return this.to('UpdateContactFlowMetadata');
    }
    /**
     * Grants permission to update the metadata of a contact flow module in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactFlowModuleMetadata.html
     */
    toUpdateContactFlowModuleMetadata() {
        return this.to('UpdateContactFlowModuleMetadata');
    }
    /**
     * Grants permission to update the name and description of a contact flow in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactFlowName.html
     */
    toUpdateContactFlowName() {
        return this.to('UpdateContactFlowName');
    }
    /**
     * Grants permission to update the schedule of a contact that is already scheduled in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactSchedule.html
     */
    toUpdateContactSchedule() {
        return this.to('UpdateContactSchedule');
    }
    /**
     * Grants permission to update hours of operation in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateHoursOfOperation.html
     */
    toUpdateHoursOfOperation() {
        return this.to('UpdateHoursOfOperation');
    }
    /**
     * Grants permission to update the attribute for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAttributeType()
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - logs:CreateLogGroup
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toUpdateInstanceAttribute() {
        return this.to('UpdateInstanceAttribute');
    }
    /**
     * Grants permission to update the storage configuration for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStorageResourceType()
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     * - firehose:DescribeDeliveryStream
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - kinesis:DescribeStream
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - s3:GetBucketAcl
     * - s3:GetBucketLocation
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toUpdateInstanceStorageConfig() {
        return this.to('UpdateInstanceStorageConfig');
    }
    /**
     * Grants permission to update queue hours of operation in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQueueHoursOfOperation.html
     */
    toUpdateQueueHoursOfOperation() {
        return this.to('UpdateQueueHoursOfOperation');
    }
    /**
     * Grants permission to update queue capacity in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQueueMaxContacts.html
     */
    toUpdateQueueMaxContacts() {
        return this.to('UpdateQueueMaxContacts');
    }
    /**
     * Grants permission to update a queue name and description in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQueueName.html
     */
    toUpdateQueueName() {
        return this.to('UpdateQueueName');
    }
    /**
     * Grants permission to update queue outbound caller config in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQueueOutboundCallerConfig.html
     */
    toUpdateQueueOutboundCallerConfig() {
        return this.to('UpdateQueueOutboundCallerConfig');
    }
    /**
     * Grants permission to update queue status in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQueueStatus.html
     */
    toUpdateQueueStatus() {
        return this.to('UpdateQueueStatus');
    }
    /**
     * Grants permission to update the configuration of a quick connect in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQuickConnectConfig.html
     */
    toUpdateQuickConnectConfig() {
        return this.to('UpdateQuickConnectConfig');
    }
    /**
     * Grants permission to update a quick connect name and description in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQuickConnectName.html
     */
    toUpdateQuickConnectName() {
        return this.to('UpdateQuickConnectName');
    }
    /**
     * Grants permission to update the concurrency in a routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateRoutingProfileConcurrency.html
     */
    toUpdateRoutingProfileConcurrency() {
        return this.to('UpdateRoutingProfileConcurrency');
    }
    /**
     * Grants permission to update the outbound queue in a routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateRoutingProfileDefaultOutboundQueue.html
     */
    toUpdateRoutingProfileDefaultOutboundQueue() {
        return this.to('UpdateRoutingProfileDefaultOutboundQueue');
    }
    /**
     * Grants permission to update a routing profile name and description in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateRoutingProfileName.html
     */
    toUpdateRoutingProfileName() {
        return this.to('UpdateRoutingProfileName');
    }
    /**
     * Grants permission to update the queues in routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateRoutingProfileQueues.html
     */
    toUpdateRoutingProfileQueues() {
        return this.to('UpdateRoutingProfileQueues');
    }
    /**
     * Grants permission to update a security profile group for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateSecurityProfile.html
     */
    toUpdateSecurityProfile() {
        return this.to('UpdateSecurityProfile');
    }
    /**
     * Grants permission to update a hierarchy group for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserHierarchy.html
     */
    toUpdateUserHierarchy() {
        return this.to('UpdateUserHierarchy');
    }
    /**
     * Grants permission to update a user hierarchy group name in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserHierarchyGroupName.html
     */
    toUpdateUserHierarchyGroupName() {
        return this.to('UpdateUserHierarchyGroupName');
    }
    /**
     * Grants permission to update user hierarchy structure in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserHierarchyStructure.html
     */
    toUpdateUserHierarchyStructure() {
        return this.to('UpdateUserHierarchyStructure');
    }
    /**
     * Grants permission to update identity information for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserIdentityInfo.html
     */
    toUpdateUserIdentityInfo() {
        return this.to('UpdateUserIdentityInfo');
    }
    /**
     * Grants permission to update phone configuration settings for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserPhoneConfig.html
     */
    toUpdateUserPhoneConfig() {
        return this.to('UpdateUserPhoneConfig');
    }
    /**
     * Grants permission to update a routing profile for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserRoutingProfile.html
     */
    toUpdateUserRoutingProfile() {
        return this.to('UpdateUserRoutingProfile');
    }
    /**
     * Grants permission to update security profiles for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserSecurityProfiles.html
     */
    toUpdateUserSecurityProfiles() {
        return this.to('UpdateUserSecurityProfiles');
    }
    /**
     * Grants permission to update contact flow module content in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatedescribeContent.html
     */
    toUpdatedescribeContent() {
        return this.to('UpdatedescribeContent');
    }
    /**
     * Adds a resource of type instance to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-instances.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onInstance(instanceId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}`);
    }
    /**
     * Adds a resource of type contact to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/connect-contact-attributes.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param contactId - Identifier for the contactId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onContact(instanceId, contactId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/contact/${contactId}`);
    }
    /**
     * Adds a resource of type user to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/connect-agents.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param userId - Identifier for the userId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onUser(instanceId, userId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/agent/${userId}`);
    }
    /**
     * Adds a resource of type routing-profile to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param routingProfileId - Identifier for the routingProfileId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRoutingProfile(instanceId, routingProfileId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/routing-profile/${routingProfileId}`);
    }
    /**
     * Adds a resource of type security-profile to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param securityProfileId - Identifier for the securityProfileId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSecurityProfile(instanceId, securityProfileId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/security-profile/${securityProfileId}`);
    }
    /**
     * Adds a resource of type hierarchy-group to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param hierarchyGroupId - Identifier for the hierarchyGroupId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onHierarchyGroup(instanceId, hierarchyGroupId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/agent-group/${hierarchyGroupId}`);
    }
    /**
     * Adds a resource of type queue to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/API_Queue.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param queueId - Identifier for the queueId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onQueue(instanceId, queueId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/queue/${queueId}`);
    }
    /**
     * Adds a resource of type wildcard-queue to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/API_Queue.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onWildcardQueue(instanceId, resourceName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/queue/${resourceName}`);
    }
    /**
     * Adds a resource of type quick-connect to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/quick-connects.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param quickConnectId - Identifier for the quickConnectId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onQuickConnect(instanceId, quickConnectId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/transfer-destination/${quickConnectId}`);
    }
    /**
     * Adds a resource of type wildcard-quick-connect to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/quick-connects.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onWildcardQuickConnect(instanceId, resourceName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/transfer-destination/${resourceName}`);
    }
    /**
     * Adds a resource of type contact-flow to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/connect-contact-flows.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param contactFlowId - Identifier for the contactFlowId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onContactFlow(instanceId, contactFlowId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/contact-flow/${contactFlowId}`);
    }
    /**
     * Adds a resource of type contact-flow-module to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/contact-flow-modules.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param contactFlowModuleId - Identifier for the contactFlowModuleId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onContactFlowModule(instanceId, contactFlowModuleId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/flow-module/${contactFlowModuleId}`);
    }
    /**
     * Adds a resource of type wildcard-contact-flow to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/connect-contact-flows.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onWildcardContactFlow(instanceId, resourceName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/contact-flow/${resourceName}`);
    }
    /**
     * Adds a resource of type hours-of-operation to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/API_HoursOfOperation.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param hoursOfOperationId - Identifier for the hoursOfOperationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onHoursOfOperation(instanceId, hoursOfOperationId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/operating-hours/${hoursOfOperationId}`);
    }
    /**
     * Adds a resource of type agent-status to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/agent-status.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param agentStatusId - Identifier for the agentStatusId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAgentStatus(instanceId, agentStatusId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/agent-status/${agentStatusId}`);
    }
    /**
     * Adds a resource of type wildcard-agent-status to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/agent-status.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onWildcardAgentStatus(instanceId, resourceName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/agent-status/${resourceName}`);
    }
    /**
     * Adds a resource of type phone-number to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param phoneNumberId - Identifier for the phoneNumberId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onPhoneNumber(instanceId, phoneNumberId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/phone-numbers/${phoneNumberId}`);
    }
    /**
     * Adds a resource of type wildcard-phone-number to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onWildcardPhoneNumber(instanceId, resourceName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/phone-numbers/${resourceName}`);
    }
    /**
     * Adds a resource of type integration-association to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/API_IntegrationAssociationSummary.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param integrationAssociationId - Identifier for the integrationAssociationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIntegrationAssociation(instanceId, integrationAssociationId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/integration-association/${integrationAssociationId}`);
    }
    /**
     * Adds a resource of type use-case to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/API_UseCase.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param useCaseId - Identifier for the useCaseId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onUseCase(instanceId, useCaseId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/use-case/${useCaseId}`);
    }
    /**
     * Adds a resource of type vocabulary to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/API_Vocabulary.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param vocabularyId - Identifier for the vocabularyId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVocabulary(instanceId, vocabularyId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/vocabulary/${vocabularyId}`);
    }
    /**
     * Filters access by the attribute type of the Amazon Connect instance
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toDescribeInstanceAttribute()
     * - .toUpdateInstanceAttribute()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAttributeType(value, operator) {
        return this.if(`AttributeType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by restricting federation into specified Amazon Connect instances
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toAssociateApprovedOrigin()
     * - .toAssociateBot()
     * - .toAssociateDefaultVocabulary()
     * - .toAssociateInstanceStorageConfig()
     * - .toAssociateLambdaFunction()
     * - .toAssociateLexBot()
     * - .toAssociateQueueQuickConnects()
     * - .toAssociateRoutingProfileQueues()
     * - .toAssociateSecurityKey()
     * - .toCreateAgentStatus()
     * - .toCreateContactFlow()
     * - .toCreateContactFlowModule()
     * - .toCreateHoursOfOperation()
     * - .toCreateIntegrationAssociation()
     * - .toCreateQueue()
     * - .toCreateQuickConnect()
     * - .toCreateRoutingProfile()
     * - .toCreateSecurityProfile()
     * - .toCreateUseCase()
     * - .toCreateUser()
     * - .toCreateUserHierarchyGroup()
     * - .toCreateVocabulary()
     * - .toDeleteContactFlow()
     * - .toDeleteContactFlowModule()
     * - .toDeleteHoursOfOperation()
     * - .toDeleteInstance()
     * - .toDeleteIntegrationAssociation()
     * - .toDeleteQuickConnect()
     * - .toDeleteSecurityProfile()
     * - .toDeleteUseCase()
     * - .toDeleteUser()
     * - .toDeleteUserHierarchyGroup()
     * - .toDeleteVocabulary()
     * - .toDescribeAgentStatus()
     * - .toDescribeContact()
     * - .toDescribeContactFlow()
     * - .toDescribeContactFlowModule()
     * - .toDescribeHoursOfOperation()
     * - .toDescribeInstance()
     * - .toDescribeInstanceAttribute()
     * - .toDescribeInstanceStorageConfig()
     * - .toDescribeQueue()
     * - .toDescribeQuickConnect()
     * - .toDescribeRoutingProfile()
     * - .toDescribeSecurityProfile()
     * - .toDescribeUser()
     * - .toDescribeUserHierarchyGroup()
     * - .toDescribeUserHierarchyStructure()
     * - .toDescribeVocabulary()
     * - .toDisassociateApprovedOrigin()
     * - .toDisassociateBot()
     * - .toDisassociateInstanceStorageConfig()
     * - .toDisassociateLambdaFunction()
     * - .toDisassociateLexBot()
     * - .toDisassociateQueueQuickConnects()
     * - .toDisassociateRoutingProfileQueues()
     * - .toDisassociateSecurityKey()
     * - .toGetContactAttributes()
     * - .toGetCurrentMetricData()
     * - .toGetFederationToken()
     * - .toGetMetricData()
     * - .toListApprovedOrigins()
     * - .toListBots()
     * - .toListContactReferences()
     * - .toListDefaultVocabularies()
     * - .toListHoursOfOperations()
     * - .toListInstanceAttributes()
     * - .toListInstanceStorageConfigs()
     * - .toListIntegrationAssociations()
     * - .toListLambdaFunctions()
     * - .toListLexBots()
     * - .toListPrompts()
     * - .toListQueueQuickConnects()
     * - .toListRoutingProfileQueues()
     * - .toListRoutingProfiles()
     * - .toListSecurityKeys()
     * - .toListSecurityProfilePermissions()
     * - .toListSecurityProfiles()
     * - .toListUseCases()
     * - .toListUserHierarchyGroups()
     * - .toListUsers()
     * - .toSearchVocabularies()
     * - .toStartTaskContact()
     * - .toStopContact()
     * - .toUpdateAgentStatus()
     * - .toUpdateContact()
     * - .toUpdateContactAttributes()
     * - .toUpdateContactFlowContent()
     * - .toUpdateContactFlowMetadata()
     * - .toUpdateContactFlowModuleMetadata()
     * - .toUpdateContactFlowName()
     * - .toUpdateContactSchedule()
     * - .toUpdateHoursOfOperation()
     * - .toUpdateInstanceAttribute()
     * - .toUpdateInstanceStorageConfig()
     * - .toUpdateQueueHoursOfOperation()
     * - .toUpdateQueueMaxContacts()
     * - .toUpdateQueueName()
     * - .toUpdateQueueOutboundCallerConfig()
     * - .toUpdateQueueStatus()
     * - .toUpdateQuickConnectConfig()
     * - .toUpdateQuickConnectName()
     * - .toUpdateRoutingProfileConcurrency()
     * - .toUpdateRoutingProfileDefaultOutboundQueue()
     * - .toUpdateRoutingProfileName()
     * - .toUpdateRoutingProfileQueues()
     * - .toUpdateSecurityProfile()
     * - .toUpdateUserHierarchy()
     * - .toUpdateUserHierarchyGroupName()
     * - .toUpdateUserHierarchyStructure()
     * - .toUpdateUserIdentityInfo()
     * - .toUpdateUserPhoneConfig()
     * - .toUpdateUserRoutingProfile()
     * - .toUpdateUserSecurityProfiles()
     * - .toUpdatedescribeContent()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifInstanceId(value, operator) {
        return this.if(`InstanceId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by restricting the storage resource type of the Amazon Connect instance storage configuration
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toAssociateInstanceStorageConfig()
     * - .toDescribeInstanceStorageConfig()
     * - .toDisassociateInstanceStorageConfig()
     * - .toUpdateInstanceStorageConfig()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifStorageResourceType(value, operator) {
        return this.if(`StorageResourceType`, value, operator || 'StringLike');
    }
}
exports.Connect = Connect;
_a = JSII_RTTI_SYMBOL_1;
Connect[_a] = { fqn: "iam-floyd.Connect", version: "0.320.0" };
//# sourceMappingURL=data:application/json;base64,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