"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Controltower = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [controltower](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontroltower.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Controltower extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [controltower](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontroltower.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'controltower';
        this.accessLevelList = {
            Write: [
                'CreateManagedAccount',
                'DeregisterManagedAccount',
                'DeregisterOrganizationalUnit',
                'DisableGuardrail',
                'EnableGuardrail',
                'ManageOrganizationalUnit',
                'SetupLandingZone',
                'UpdateAccountFactoryConfig'
            ],
            Read: [
                'DescribeAccountFactoryConfig',
                'DescribeCoreService',
                'DescribeGuardrail',
                'DescribeGuardrailForTarget',
                'DescribeManagedAccount',
                'DescribeManagedOrganizationalUnit',
                'DescribeSingleSignOn',
                'GetAvailableUpdates',
                'GetGuardrailComplianceStatus',
                'GetHomeRegion',
                'GetLandingZoneStatus'
            ],
            List: [
                'ListDirectoryGroups',
                'ListEnabledGuardrails',
                'ListGuardrailViolations',
                'ListGuardrails',
                'ListGuardrailsForTarget',
                'ListManagedAccounts',
                'ListManagedAccountsForGuardrail',
                'ListManagedAccountsForParent',
                'ListManagedOrganizationalUnits',
                'ListManagedOrganizationalUnitsForGuardrail'
            ]
        };
    }
    /**
     * Grants permission to create an account managed by AWS Control Tower.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toCreateManagedAccount() {
        return this.to('CreateManagedAccount');
    }
    /**
     * Grants permission to deregister an account created through the account factory from AWS Control Tower.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDeregisterManagedAccount() {
        return this.to('DeregisterManagedAccount');
    }
    /**
     * Grants permission to deregister an organizational unit from AWS Control Tower management.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toDeregisterOrganizationalUnit() {
        return this.to('DeregisterOrganizationalUnit');
    }
    /**
     * Grants permission to describe the current account factory configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDescribeAccountFactoryConfig() {
        return this.to('DescribeAccountFactoryConfig');
    }
    /**
     * Grants permission to describe resources managed by core accounts in AWS Control Tower.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html#what-shared
     */
    toDescribeCoreService() {
        return this.to('DescribeCoreService');
    }
    /**
     * Grants permission to describe a guardrail.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toDescribeGuardrail() {
        return this.to('DescribeGuardrail');
    }
    /**
     * Grants permission to describe a guardrail for a organizational unit.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toDescribeGuardrailForTarget() {
        return this.to('DescribeGuardrailForTarget');
    }
    /**
     * Grants permission to describe an account created through account factory.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDescribeManagedAccount() {
        return this.to('DescribeManagedAccount');
    }
    /**
     * Grants permission to describe an AWS Organizations organizational unit managed by AWS Control Tower.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toDescribeManagedOrganizationalUnit() {
        return this.to('DescribeManagedOrganizationalUnit');
    }
    /**
     * Grants permission to describe the current AWS Control Tower SSO configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/sso.html
     */
    toDescribeSingleSignOn() {
        return this.to('DescribeSingleSignOn');
    }
    /**
     * Grants permission to disable a guardrail from an organizational unit.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html#enable-guardrails
     */
    toDisableGuardrail() {
        return this.to('DisableGuardrail');
    }
    /**
     * Grants permission to enable a guardrail to an organizational unit.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html#enable-guardrails
     */
    toEnableGuardrail() {
        return this.to('EnableGuardrail');
    }
    /**
     * Grants permission to list available updates for the current AWS Control Tower deployment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/configuration-updates.html
     */
    toGetAvailableUpdates() {
        return this.to('GetAvailableUpdates');
    }
    /**
     * Grants permission to get the current compliance status of a guardrail.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toGetGuardrailComplianceStatus() {
        return this.to('GetGuardrailComplianceStatus');
    }
    /**
     * Grants permission to get the home region of the AWS Control Tower setup.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html#region-how
     */
    toGetHomeRegion() {
        return this.to('GetHomeRegion');
    }
    /**
     * Grants permission to get the current status of the landing zone setup.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-with-control-tower.html#step-two
     */
    toGetLandingZoneStatus() {
        return this.to('GetLandingZoneStatus');
    }
    /**
     * Grants permission to list the current directory groups available through SSO.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/sso.html
     */
    toListDirectoryGroups() {
        return this.to('ListDirectoryGroups');
    }
    /**
     * Grants permission to list currently enabled guardrails.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toListEnabledGuardrails() {
        return this.to('ListEnabledGuardrails');
    }
    /**
     * Grants permission to list existing guardrail violations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toListGuardrailViolations() {
        return this.to('ListGuardrailViolations');
    }
    /**
     * Grants permission to list all available guardrails.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toListGuardrails() {
        return this.to('ListGuardrails');
    }
    /**
     * Grants permission to list guardrails and their current state for a organizational unit.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toListGuardrailsForTarget() {
        return this.to('ListGuardrailsForTarget');
    }
    /**
     * Grants permission to list accounts managed through AWS Control Tower.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccounts() {
        return this.to('ListManagedAccounts');
    }
    /**
     * Grants permission to list managed accounts with a specified guardrail applied.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccountsForGuardrail() {
        return this.to('ListManagedAccountsForGuardrail');
    }
    /**
     * Grants permission to list managed accounts under an organizational unit.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccountsForParent() {
        return this.to('ListManagedAccountsForParent');
    }
    /**
     * Grants permission to list organizational units managed by AWS Control Tower.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toListManagedOrganizationalUnits() {
        return this.to('ListManagedOrganizationalUnits');
    }
    /**
     * Grants permission to list managed organizational units that have a specified guardrail applied.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toListManagedOrganizationalUnitsForGuardrail() {
        return this.to('ListManagedOrganizationalUnitsForGuardrail');
    }
    /**
     * Grants permission to set up an organizational unit to be managed by AWS Control Tower.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toManageOrganizationalUnit() {
        return this.to('ManageOrganizationalUnit');
    }
    /**
     * Grants permission to set up or update AWS Control Tower landing zone.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-with-control-tower.html#step-two
     */
    toSetupLandingZone() {
        return this.to('SetupLandingZone');
    }
    /**
     * Grants permission to update the account factory configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toUpdateAccountFactoryConfig() {
        return this.to('UpdateAccountFactoryConfig');
    }
}
exports.Controltower = Controltower;
_a = JSII_RTTI_SYMBOL_1;
Controltower[_a] = { fqn: "iam-floyd.Controltower", version: "0.320.0" };
//# sourceMappingURL=data:application/json;base64,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