"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevopsGuru = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [devops-guru](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondevopsguru.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class DevopsGuru extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [devops-guru](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondevopsguru.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'devops-guru';
        this.accessLevelList = {
            Write: [
                'AddNotificationChannel',
                'PutFeedback',
                'RemoveNotificationChannel',
                'UpdateResourceCollection',
                'UpdateServiceIntegration'
            ],
            Read: [
                'DescribeAccountHealth',
                'DescribeAccountOverview',
                'DescribeAnomaly',
                'DescribeFeedback',
                'DescribeInsight',
                'DescribeOrganizationHealth',
                'DescribeOrganizationOverview',
                'DescribeOrganizationResourceCollectionHealth',
                'DescribeResourceCollectionHealth',
                'DescribeServiceIntegration',
                'GetCostEstimation',
                'GetResourceCollection',
                'StartCostEstimation'
            ],
            List: [
                'ListAnomaliesForInsight',
                'ListEvents',
                'ListInsights',
                'ListNotificationChannels',
                'ListOrganizationInsights',
                'ListRecommendations',
                'SearchInsights',
                'SearchOrganizationInsights'
            ]
        };
    }
    /**
     * Grants permission to add a notification channel to DevOps Guru
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sns:GetTopicAttributes
     * - sns:SetTopicAttributes
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_AddNotificationChannel.html
     */
    toAddNotificationChannel() {
        return this.to('AddNotificationChannel');
    }
    /**
     * Grants permission to view the health of operations in your AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeAccountHealth.html
     */
    toDescribeAccountHealth() {
        return this.to('DescribeAccountHealth');
    }
    /**
     * Grants permission to view the health of operations within a time range in your AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeAccountOverview.html
     */
    toDescribeAccountOverview() {
        return this.to('DescribeAccountOverview');
    }
    /**
     * Grants permission to list the details of a specified anomaly
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeAnomaly.html
     */
    toDescribeAnomaly() {
        return this.to('DescribeAnomaly');
    }
    /**
     * Grants permission to view the feedback details of a specified insight
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeFeedback.html
     */
    toDescribeFeedback() {
        return this.to('DescribeFeedback');
    }
    /**
     * Grants permission to list the details of a specified insight
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeInsight.html
     */
    toDescribeInsight() {
        return this.to('DescribeInsight');
    }
    /**
     * Grants permission to view the health of operations in your organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeOrganizationAccountHealth.html
     */
    toDescribeOrganizationHealth() {
        return this.to('DescribeOrganizationHealth');
    }
    /**
     * Grants permission to view the health of operations within a time range in your organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeOrganizationOverview.html
     */
    toDescribeOrganizationOverview() {
        return this.to('DescribeOrganizationOverview');
    }
    /**
     * Grants permission to view the health of operations for each AWS CloudFormation stack or AWS Services or accounts specified in DevOps Guru in your organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeOrganizationResourceCollectionHealth.html
     */
    toDescribeOrganizationResourceCollectionHealth() {
        return this.to('DescribeOrganizationResourceCollectionHealth');
    }
    /**
     * Grants permission to view the health of operations for each AWS CloudFormation stack specified in DevOps Guru
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeResourceCollectionHealth.html
     */
    toDescribeResourceCollectionHealth() {
        return this.to('DescribeResourceCollectionHealth');
    }
    /**
     * Grants permission to view the integration status of services that can be integrated with DevOps Guru
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_DescribeServiceIntegration.html
     */
    toDescribeServiceIntegration() {
        return this.to('DescribeServiceIntegration');
    }
    /**
     * Grants permission to list service resource cost estimates
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_GetCostEstimation.html
     */
    toGetCostEstimation() {
        return this.to('GetCostEstimation');
    }
    /**
     * Grants permission to list AWS CloudFormation stacks that DevOps Guru is configured to use
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_GetResourceCollection.html
     */
    toGetResourceCollection() {
        return this.to('GetResourceCollection');
    }
    /**
     * Grants permission to list anomalies of a given insight in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListAnomaliesForInsight.html
     */
    toListAnomaliesForInsight() {
        return this.to('ListAnomaliesForInsight');
    }
    /**
     * Grants permission to list resource events that are evaluated by DevOps Guru
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListEvents.html
     */
    toListEvents() {
        return this.to('ListEvents');
    }
    /**
     * Grants permission to list insights in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListInsights.html
     */
    toListInsights() {
        return this.to('ListInsights');
    }
    /**
     * Grants permission to list notification channels configured for DevOps Guru in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListNotificationChannels.html
     */
    toListNotificationChannels() {
        return this.to('ListNotificationChannels');
    }
    /**
     * Grants permission to list insights in your organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListOrganizationInsights.html
     */
    toListOrganizationInsights() {
        return this.to('ListOrganizationInsights');
    }
    /**
     * Grants permission to list a specified insight's recommendations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_ListRecommendations.html
     */
    toListRecommendations() {
        return this.to('ListRecommendations');
    }
    /**
     * Grants permission to submit a feedback to DevOps Guru
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PutFeedback.html
     */
    toPutFeedback() {
        return this.to('PutFeedback');
    }
    /**
     * Grants permission to remove a notification channel from DevOps Guru
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sns:GetTopicAttributes
     * - sns:SetTopicAttributes
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_RemoveNotificationChannel.html
     */
    toRemoveNotificationChannel() {
        return this.to('RemoveNotificationChannel');
    }
    /**
     * Grants permission to search insights in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_SearchInsights.html
     */
    toSearchInsights() {
        return this.to('SearchInsights');
    }
    /**
     * Grants permission to search insights in your organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_SearchOrganizationInsights.html
     */
    toSearchOrganizationInsights() {
        return this.to('SearchOrganizationInsights');
    }
    /**
     * Grants permission to start the creation of an estimate of the monthly cost
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_StartCostEstimation.html
     */
    toStartCostEstimation() {
        return this.to('StartCostEstimation');
    }
    /**
     * Grants permission to update the list of AWS CloudFormation stacks that are used to specify which AWS resources in your account are analyzed by DevOps Guru
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_UpdateResourceCollection.html
     */
    toUpdateResourceCollection() {
        return this.to('UpdateResourceCollection');
    }
    /**
     * Grants permission to enable or disable a service that integrates with DevOps Guru
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_UpdateServiceIntegration.html
     */
    toUpdateServiceIntegration() {
        return this.to('UpdateServiceIntegration');
    }
    /**
     * Adds a resource of type topic to the statement
     *
     * https://docs.aws.amazon.com/devops-guru/latest/userguide/CreateTopic.html
     *
     * @param topicName - Identifier for the topicName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onTopic(topicName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:sns:${region || '*'}:${account || '*'}:${topicName}`);
    }
}
exports.DevopsGuru = DevopsGuru;
_a = JSII_RTTI_SYMBOL_1;
DevopsGuru[_a] = { fqn: "iam-floyd.DevopsGuru", version: "0.320.0" };
//# sourceMappingURL=data:application/json;base64,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