import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [proton](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsproton.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Proton extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [proton](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsproton.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to reject an environment account connection request from another environment account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_AcceptEnvironmentAccountConnection.html
     */
    toAcceptEnvironmentAccountConnection(): this;
    /**
     * Grants permission to cancel an environment deployment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifEnvironmentTemplate()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CancelEnvironmentDeployment.html
     */
    toCancelEnvironmentDeployment(): this;
    /**
     * Grants permission to cancel a service instance deployment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceTemplate()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CancelServiceInstanceDeployment.html
     */
    toCancelServiceInstanceDeployment(): this;
    /**
     * Grants permission to cancel a service pipeline deployment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceTemplate()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CancelServicePipelineDeployment.html
     */
    toCancelServicePipelineDeployment(): this;
    /**
     * Grants permission to create an environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifEnvironmentTemplate()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironment.html
     */
    toCreateEnvironment(): this;
    /**
     * Grants permission to create an environment account connection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironmentAccountConnection.html
     */
    toCreateEnvironmentAccountConnection(): this;
    /**
     * Grants permission to create an environment template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironmentTemplate.html
     */
    toCreateEnvironmentTemplate(): this;
    /**
     * Grants permission to create an environment template major version. DEPRECATED - use CreateEnvironmentTemplateVersion instead
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironmentTemplateMajorVersion.html
     */
    toCreateEnvironmentTemplateMajorVersion(): this;
    /**
     * Grants permission to create an environment template minor version. DEPRECATED - use CreateEnvironmentTemplateVersion instead
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironmentTemplateMinorVersion.html
     */
    toCreateEnvironmentTemplateMinorVersion(): this;
    /**
     * Grants permission to create an environment template version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateEnvironmentTemplateVersion.html
     */
    toCreateEnvironmentTemplateVersion(): this;
    /**
     * Grants permission to create a repository
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateRepository.html
     */
    toCreateRepository(): this;
    /**
     * Grants permission to create a service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifServiceTemplate()
     *
     * Dependent actions:
     * - codestar-connections:PassConnection
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateService.html
     */
    toCreateService(): this;
    /**
     * Grants permission to create a service template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateServiceTemplate.html
     */
    toCreateServiceTemplate(): this;
    /**
     * Grants permission to create a service template major version. DEPRECATED - use CreateServiceTemplateVersion instead
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateServiceTemplateMajorVersion.html
     */
    toCreateServiceTemplateMajorVersion(): this;
    /**
     * Grants permission to create a service template minor version. DEPRECATED - use CreateServiceTemplateVersion instead
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateServiceTemplateMinorVersion.html
     */
    toCreateServiceTemplateMinorVersion(): this;
    /**
     * Grants permission to create a service template version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateServiceTemplateVersion.html
     */
    toCreateServiceTemplateVersion(): this;
    /**
     * Grants permission to create a template sync config
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateTemplateSyncConfig.html
     */
    toCreateTemplateSyncConfig(): this;
    /**
     * Grants permission to delete account roles. DEPRECATED - use UpdateAccountSettings instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteAccountRoles.html
     */
    toDeleteAccountRoles(): this;
    /**
     * Grants permission to delete an environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifEnvironmentTemplate()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironment.html
     */
    toDeleteEnvironment(): this;
    /**
     * Grants permission to delete an environment account connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironmentAccountConnection.html
     */
    toDeleteEnvironmentAccountConnection(): this;
    /**
     * Grants permission to delete an environment template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironmentTemplate.html
     */
    toDeleteEnvironmentTemplate(): this;
    /**
     * Grants permission to delete an environment template major version. DEPRECATED - use DeleteEnvironmentTemplateVersion instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironmentTemplateMajorVersion.html
     */
    toDeleteEnvironmentTemplateMajorVersion(): this;
    /**
     * Grants permission to delete an environment template minor version. DEPRECATED - use DeleteEnvironmentTemplateVersion instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironmentTemplateMinorVersion.html
     */
    toDeleteEnvironmentTemplateMinorVersion(): this;
    /**
     * Grants permission to delete an environment template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteEnvironmentTemplateVersion.html
     */
    toDeleteEnvironmentTemplateVersion(): this;
    /**
     * Grants permission to delete a repository
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteRepository.html
     */
    toDeleteRepository(): this;
    /**
     * Grants permission to delete a service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceTemplate()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteService.html
     */
    toDeleteService(): this;
    /**
     * Grants permission to delete a service template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteServiceTemplate.html
     */
    toDeleteServiceTemplate(): this;
    /**
     * Grants permission to delete a service template major version. DEPRECATED - use DeleteServiceTemplateVersion instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteServiceTemplateMajorVersion.html
     */
    toDeleteServiceTemplateMajorVersion(): this;
    /**
     * Grants permission to delete a service template minor version. DEPRECATED - use DeleteServiceTemplateVersion instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteServiceTemplateMinorVersion.html
     */
    toDeleteServiceTemplateMinorVersion(): this;
    /**
     * Grants permission to delete a service template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteServiceTemplateVersion.html
     */
    toDeleteServiceTemplateVersion(): this;
    /**
     * Grants permission to delete a TemplateSyncConfig
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_DeleteTemplateSyncConfig.html
     */
    toDeleteTemplateSyncConfig(): this;
    /**
     * Grants permission to get account roles. DEPRECATED - use GetAccountSettings instead
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetAccountRoles.html
     */
    toGetAccountRoles(): this;
    /**
     * Grants permission to describe the account settings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetAccountRoles.html
     */
    toGetAccountSettings(): this;
    /**
     * Grants permission to describe an environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironment.html
     */
    toGetEnvironment(): this;
    /**
     * Grants permission to describe an environment account connection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironmentAccountConnection.html
     */
    toGetEnvironmentAccountConnection(): this;
    /**
     * Grants permission to describe an environment template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironmentTemplate.html
     */
    toGetEnvironmentTemplate(): this;
    /**
     * Grants permission to get an environment template major version. DEPRECATED - use GetEnvironmentTemplateVersion instead
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironmentTemplateMajorVersion.html
     */
    toGetEnvironmentTemplateMajorVersion(): this;
    /**
     * Grants permission to get an environment template minor version. DEPRECATED - use GetEnvironmentTemplateVersion instead
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironmentTemplateMinorVersion.html
     */
    toGetEnvironmentTemplateMinorVersion(): this;
    /**
     * Grants permission to describe an environment template version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetEnvironmentTemplateVersion.html
     */
    toGetEnvironmentTemplateVersion(): this;
    /**
     * Grants permission to describe a repository
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetRepository.html
     */
    toGetRepository(): this;
    /**
     * Grants permission to get the latest sync status for a repository
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetRepositorySyncStatus.html
     */
    toGetRepositorySyncStatus(): this;
    /**
     * Grants permission to describe a service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetService.html
     */
    toGetService(): this;
    /**
     * Grants permission to describe a service instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceInstance.html
     */
    toGetServiceInstance(): this;
    /**
     * Grants permission to describe a service template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceTemplate.html
     */
    toGetServiceTemplate(): this;
    /**
     * Grants permission to get a service template major version. DEPRECATED - use GetServiceTemplateVersion instead
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceTemplateMajorVersion.html
     */
    toGetServiceTemplateMajorVersion(): this;
    /**
     * Grants permission to get a service template minor version. DEPRECATED - use GetServiceTemplateVersion instead
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceTemplateMinorVersion.html
     */
    toGetServiceTemplateMinorVersion(): this;
    /**
     * Grants permission to describe a service template version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetServiceTemplateVersion.html
     */
    toGetServiceTemplateVersion(): this;
    /**
     * Grants permission to describe a TemplateSyncConfig
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetTemplateSyncConfig.html
     */
    toGetTemplateSyncConfig(): this;
    /**
     * Grants permission to describe the sync status of a template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_GetTemplateSyncStatus.html
     */
    toGetTemplateSyncStatus(): this;
    /**
     * Grants permission to list environment account connections
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentAccountConnections.html
     */
    toListEnvironmentAccountConnections(): this;
    /**
     * Grants permission to list environment outputs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentOutputs.html
     */
    toListEnvironmentOutputs(): this;
    /**
     * Grants permission to list environment provisioned resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentProvisionedResources.html
     */
    toListEnvironmentProvisionedResources(): this;
    /**
     * Grants permission to list environment template major versions. DEPRECATED - use ListEnvironmentTemplateVersions instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentTemplateMajorVersions.html
     */
    toListEnvironmentTemplateMajorVersions(): this;
    /**
     * Grants permission to list an environment template minor versions. DEPRECATED - use ListEnvironmentTemplateVersions instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentTemplateMinorVersions.html
     */
    toListEnvironmentTemplateMinorVersions(): this;
    /**
     * Grants permission to list environment template versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentTemplateVersions.html
     */
    toListEnvironmentTemplateVersions(): this;
    /**
     * Grants permission to list environment templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironmentTemplates.html
     */
    toListEnvironmentTemplates(): this;
    /**
     * Grants permission to list environments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListEnvironments.html
     */
    toListEnvironments(): this;
    /**
     * Grants permission to list repositories
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListRepositories.html
     */
    toListRepositories(): this;
    /**
     * Grants permission to list repository sync definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListRepositorySyncDefinitions.html
     */
    toListRepositorySyncDefinitions(): this;
    /**
     * Grants permission to list service instance outputs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceInstanceOutputs.html
     */
    toListServiceInstanceOutputs(): this;
    /**
     * Grants permission to list service instance provisioned resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceInstanceProvisionedResources.html
     */
    toListServiceInstanceProvisionedResources(): this;
    /**
     * Grants permission to list service instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceInstances.html
     */
    toListServiceInstances(): this;
    /**
     * Grants permission to list service pipeline outputs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServicePipelineOutputs.html
     */
    toListServicePipelineOutputs(): this;
    /**
     * Grants permission to list service pipeline provisioned resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServicePipelineProvisionedResources.html
     */
    toListServicePipelineProvisionedResources(): this;
    /**
     * Grants permission to list service template major versions. DEPRECATED - use ListServiceTemplateVersions instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceTemplateMajorVersions.html
     */
    toListServiceTemplateMajorVersions(): this;
    /**
     * Grants permission to list service template minor versions. DEPRECATED - use ListServiceTemplateVersions instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceTemplateMinorVersions.html
     */
    toListServiceTemplateMinorVersions(): this;
    /**
     * Grants permission to list service template versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceTemplateVersions.html
     */
    toListServiceTemplateVersions(): this;
    /**
     * Grants permission to list service templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServiceTemplates.html
     */
    toListServiceTemplates(): this;
    /**
     * Grants permission to list services
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListServices.html
     */
    toListServices(): this;
    /**
     * Grants permission to list tags of a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to reject an environment account connection request from another environment account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_RejectEnvironmentAccountConnection.html
     */
    toRejectEnvironmentAccountConnection(): this;
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update account roles. DEPRECATED - use UpdateAccountSettings instead
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateAccountRoles.html
     */
    toUpdateAccountRoles(): this;
    /**
     * Grants permission to update the account settings
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateAccountRoles.html
     */
    toUpdateAccountSettings(): this;
    /**
     * Grants permission to update an environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifEnvironmentTemplate()
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironment.html
     */
    toUpdateEnvironment(): this;
    /**
     * Grants permission to update an environment account connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironmentAccountConnection.html
     */
    toUpdateEnvironmentAccountConnection(): this;
    /**
     * Grants permission to update an environment template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironmentTemplate.html
     */
    toUpdateEnvironmentTemplate(): this;
    /**
     * Grants permission to update an environment template major version. DEPRECATED - use UpdateEnvironmentTemplateVersion instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironmentTemplateMajorVersion.html
     */
    toUpdateEnvironmentTemplateMajorVersion(): this;
    /**
     * Grants permission to update an environment template minor version. DEPRECATED - use UpdateEnvironmentTemplateVersion instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironmentTemplateMinorVersion.html
     */
    toUpdateEnvironmentTemplateMinorVersion(): this;
    /**
     * Grants permission to update an environment template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateEnvironmentTemplateVersion.html
     */
    toUpdateEnvironmentTemplateVersion(): this;
    /**
     * Grants permission to update a repository
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateRepository.html
     */
    toUpdateRepository(): this;
    /**
     * Grants permission to update a service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceTemplate()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateService.html
     */
    toUpdateService(): this;
    /**
     * Grants permission to update a service instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceTemplate()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServiceInstance.html
     */
    toUpdateServiceInstance(): this;
    /**
     * Grants permission to update a service pipeline
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifServiceTemplate()
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServicePipeline.html
     */
    toUpdateServicePipeline(): this;
    /**
     * Grants permission to update a service template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServiceTemplate.html
     */
    toUpdateServiceTemplate(): this;
    /**
     * Grants permission to update a service template major version. DEPRECATED - use UpdateServiceTemplateVersion instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServiceTemplateMajorVersion.html
     */
    toUpdateServiceTemplateMajorVersion(): this;
    /**
     * Grants permission to create a service template minor version. DEPRECATED - use UpdateServiceTemplateVersion instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServiceTemplateMinorVersion.html
     */
    toUpdateServiceTemplateMinorVersion(): this;
    /**
     * Grants permission to update a service template version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateServiceTemplateVersion.html
     */
    toUpdateServiceTemplateVersion(): this;
    /**
     * Grants permission to update a TemplateSyncConfig
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/proton/latest/APIReference/API_UpdateTemplateSyncConfig.html
     */
    toUpdateTemplateSyncConfig(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type environment-template to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-templates.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironmentTemplate(name: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type environment-template-version to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-templates.html
     *
     * @param templateName - Identifier for the templateName.
     * @param majorVersion - Identifier for the majorVersion.
     * @param minorVersion - Identifier for the minorVersion.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironmentTemplateVersion(templateName: string, majorVersion: string, minorVersion: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type environment-template-major-version to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-templates.html
     *
     * @param templateName - Identifier for the templateName.
     * @param majorVersionId - Identifier for the majorVersionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironmentTemplateMajorVersion(templateName: string, majorVersionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type environment-template-minor-version to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-templates.html
     *
     * @param templateName - Identifier for the templateName.
     * @param majorVersionId - Identifier for the majorVersionId.
     * @param minorVersionId - Identifier for the minorVersionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironmentTemplateMinorVersion(templateName: string, majorVersionId: string, minorVersionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type service-template to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/managing-svc-templates.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onServiceTemplate(name: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type service-template-version to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/managing-svc-templates.html
     *
     * @param templateName - Identifier for the templateName.
     * @param majorVersion - Identifier for the majorVersion.
     * @param minorVersion - Identifier for the minorVersion.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onServiceTemplateVersion(templateName: string, majorVersion: string, minorVersion: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type service-template-major-version to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/managing-svc-templates.html
     *
     * @param templateName - Identifier for the templateName.
     * @param majorVersionId - Identifier for the majorVersionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onServiceTemplateMajorVersion(templateName: string, majorVersionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type service-template-minor-version to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/managing-svc-templates.html
     *
     * @param templateName - Identifier for the templateName.
     * @param majorVersionId - Identifier for the majorVersionId.
     * @param minorVersionId - Identifier for the minorVersionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onServiceTemplateMinorVersion(templateName: string, majorVersionId: string, minorVersionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type environment to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironment(name: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type service to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-services.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onService(name: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type service-instance to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-services.html
     *
     * @param serviceName - Identifier for the serviceName.
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onServiceInstance(serviceName: string, name: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type environment-account-connection to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html
     *
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironmentAccountConnection(id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type repository to the statement
     *
     * https://docs.aws.amazon.com/proton/latest/adminguide/ag-repositories.html
     *
     * @param provider - Identifier for the provider.
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onRepository(provider: string, name: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters actions based on specified environment template related to resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html
     *
     * Applies to actions:
     * - .toCancelEnvironmentDeployment()
     * - .toCreateEnvironment()
     * - .toDeleteEnvironment()
     * - .toUpdateEnvironment()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifEnvironmentTemplate(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters actions based on specified service template related to resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html
     *
     * Applies to actions:
     * - .toCancelServiceInstanceDeployment()
     * - .toCancelServicePipelineDeployment()
     * - .toCreateService()
     * - .toDeleteService()
     * - .toUpdateService()
     * - .toUpdateServiceInstance()
     * - .toUpdateServicePipeline()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifServiceTemplate(value: string | string[], operator?: Operator | string): this;
}
