"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route53RecoveryCluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [route53-recovery-cluster](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53recoverycluster.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Route53RecoveryCluster extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [route53-recovery-cluster](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53recoverycluster.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'route53-recovery-cluster';
        this.accessLevelList = {
            Read: [
                'GetRoutingControlState'
            ],
            Write: [
                'UpdateRoutingControlState',
                'UpdateRoutingControlStates'
            ]
        };
    }
    /**
     * Grants permission to get a routing control state
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/routing-control/latest/APIReference/API_GetRoutingControlState.html
     */
    toGetRoutingControlState() {
        return this.to('GetRoutingControlState');
    }
    /**
     * Grants permission to update a routing control state
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAllowSafetyRulesOverrides()
     *
     * https://docs.aws.amazon.com/routing-control/latest/APIReference/API_UpdateRoutingControlState.html
     */
    toUpdateRoutingControlState() {
        return this.to('UpdateRoutingControlState');
    }
    /**
     * Grants permission to update a batch of routing control states
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAllowSafetyRulesOverrides()
     *
     * https://docs.aws.amazon.com/routing-control/latest/APIReference/API_UpdateRoutingControlStates.html
     */
    toUpdateRoutingControlStates() {
        return this.to('UpdateRoutingControlStates');
    }
    /**
     * Adds a resource of type routingcontrol to the statement
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/routingcontrol.html
     *
     * @param controlPanelId - Identifier for the controlPanelId.
     * @param routingControlId - Identifier for the routingControlId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onRoutingcontrol(controlPanelId, routingControlId, account, partition) {
        return this.on(`arn:${partition || 'aws'}:route53-recovery-control::${account || '*'}:controlpanel/${controlPanelId}/routingcontrol/${routingControlId}`);
    }
    /**
     * Override safety rules to allow routing control state updates
     *
     * https://docs.aws.amazon.com/routing-control/latest/APIReference/API_UpdateRoutingControlState.html
     *
     * Applies to actions:
     * - .toUpdateRoutingControlState()
     * - .toUpdateRoutingControlStates()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifAllowSafetyRulesOverrides(value) {
        return this.if(`AllowSafetyRulesOverrides`, (typeof value !== 'undefined' ? value : true), 'Bool');
    }
}
exports.Route53RecoveryCluster = Route53RecoveryCluster;
_a = JSII_RTTI_SYMBOL_1;
Route53RecoveryCluster[_a] = { fqn: "iam-floyd.Route53RecoveryCluster", version: "0.320.0" };
//# sourceMappingURL=data:application/json;base64,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