# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'AutoscalingPolicyBasicAlgorithmArgs',
    'AutoscalingPolicyBasicAlgorithmYarnConfigArgs',
    'AutoscalingPolicySecondaryWorkerConfigArgs',
    'AutoscalingPolicyWorkerConfigArgs',
    'ClusterClusterConfigArgs',
    'ClusterClusterConfigAutoscalingConfigArgs',
    'ClusterClusterConfigEncryptionConfigArgs',
    'ClusterClusterConfigEndpointConfigArgs',
    'ClusterClusterConfigGceClusterConfigArgs',
    'ClusterClusterConfigGceClusterConfigShieldedInstanceConfigArgs',
    'ClusterClusterConfigInitializationActionArgs',
    'ClusterClusterConfigLifecycleConfigArgs',
    'ClusterClusterConfigMasterConfigArgs',
    'ClusterClusterConfigMasterConfigAcceleratorArgs',
    'ClusterClusterConfigMasterConfigDiskConfigArgs',
    'ClusterClusterConfigMetastoreConfigArgs',
    'ClusterClusterConfigPreemptibleWorkerConfigArgs',
    'ClusterClusterConfigPreemptibleWorkerConfigDiskConfigArgs',
    'ClusterClusterConfigSecurityConfigArgs',
    'ClusterClusterConfigSecurityConfigKerberosConfigArgs',
    'ClusterClusterConfigSoftwareConfigArgs',
    'ClusterClusterConfigWorkerConfigArgs',
    'ClusterClusterConfigWorkerConfigAcceleratorArgs',
    'ClusterClusterConfigWorkerConfigDiskConfigArgs',
    'ClusterIAMBindingConditionArgs',
    'ClusterIAMMemberConditionArgs',
    'JobHadoopConfigArgs',
    'JobHadoopConfigLoggingConfigArgs',
    'JobHiveConfigArgs',
    'JobIAMBindingConditionArgs',
    'JobIAMMemberConditionArgs',
    'JobPigConfigArgs',
    'JobPigConfigLoggingConfigArgs',
    'JobPlacementArgs',
    'JobPysparkConfigArgs',
    'JobPysparkConfigLoggingConfigArgs',
    'JobReferenceArgs',
    'JobSchedulingArgs',
    'JobSparkConfigArgs',
    'JobSparkConfigLoggingConfigArgs',
    'JobSparksqlConfigArgs',
    'JobSparksqlConfigLoggingConfigArgs',
    'JobStatusArgs',
    'MetastoreServiceHiveMetastoreConfigArgs',
    'MetastoreServiceHiveMetastoreConfigKerberosConfigArgs',
    'MetastoreServiceHiveMetastoreConfigKerberosConfigKeytabArgs',
    'MetastoreServiceMaintenanceWindowArgs',
    'WorkflowTemplateJobArgs',
    'WorkflowTemplateJobHadoopJobArgs',
    'WorkflowTemplateJobHadoopJobLoggingConfigArgs',
    'WorkflowTemplateJobHiveJobArgs',
    'WorkflowTemplateJobHiveJobQueryListArgs',
    'WorkflowTemplateJobPigJobArgs',
    'WorkflowTemplateJobPigJobLoggingConfigArgs',
    'WorkflowTemplateJobPigJobQueryListArgs',
    'WorkflowTemplateJobPrestoJobArgs',
    'WorkflowTemplateJobPrestoJobLoggingConfigArgs',
    'WorkflowTemplateJobPrestoJobQueryListArgs',
    'WorkflowTemplateJobPysparkJobArgs',
    'WorkflowTemplateJobPysparkJobLoggingConfigArgs',
    'WorkflowTemplateJobSchedulingArgs',
    'WorkflowTemplateJobSparkJobArgs',
    'WorkflowTemplateJobSparkJobLoggingConfigArgs',
    'WorkflowTemplateJobSparkRJobArgs',
    'WorkflowTemplateJobSparkRJobLoggingConfigArgs',
    'WorkflowTemplateJobSparkSqlJobArgs',
    'WorkflowTemplateJobSparkSqlJobLoggingConfigArgs',
    'WorkflowTemplateJobSparkSqlJobQueryListArgs',
    'WorkflowTemplateParameterArgs',
    'WorkflowTemplateParameterValidationArgs',
    'WorkflowTemplateParameterValidationRegexArgs',
    'WorkflowTemplateParameterValidationValuesArgs',
    'WorkflowTemplatePlacementArgs',
    'WorkflowTemplatePlacementClusterSelectorArgs',
    'WorkflowTemplatePlacementManagedClusterArgs',
    'WorkflowTemplatePlacementManagedClusterConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigEncryptionConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigEndpointConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityArgs',
    'WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityArgs',
    'WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTargetArgs',
    'WorkflowTemplatePlacementManagedClusterConfigInitializationActionArgs',
    'WorkflowTemplatePlacementManagedClusterConfigLifecycleConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigMasterConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigMasterConfigAcceleratorArgs',
    'WorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigMetastoreConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAcceleratorArgs',
    'WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigSecurityConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigSoftwareConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigWorkerConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigWorkerConfigAcceleratorArgs',
    'WorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigArgs',
    'WorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfigArgs',
]

@pulumi.input_type
class AutoscalingPolicyBasicAlgorithmArgs:
    def __init__(__self__, *,
                 yarn_config: pulumi.Input['AutoscalingPolicyBasicAlgorithmYarnConfigArgs'],
                 cooldown_period: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['AutoscalingPolicyBasicAlgorithmYarnConfigArgs'] yarn_config: YARN autoscaling configuration.
               Structure is documented below.
        :param pulumi.Input[str] cooldown_period: Duration between scaling events. A scaling period starts after the
               update operation from the previous event has completed.
               Bounds: [2m, 1d]. Default: 2m.
        """
        pulumi.set(__self__, "yarn_config", yarn_config)
        if cooldown_period is not None:
            pulumi.set(__self__, "cooldown_period", cooldown_period)

    @property
    @pulumi.getter(name="yarnConfig")
    def yarn_config(self) -> pulumi.Input['AutoscalingPolicyBasicAlgorithmYarnConfigArgs']:
        """
        YARN autoscaling configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "yarn_config")

    @yarn_config.setter
    def yarn_config(self, value: pulumi.Input['AutoscalingPolicyBasicAlgorithmYarnConfigArgs']):
        pulumi.set(self, "yarn_config", value)

    @property
    @pulumi.getter(name="cooldownPeriod")
    def cooldown_period(self) -> Optional[pulumi.Input[str]]:
        """
        Duration between scaling events. A scaling period starts after the
        update operation from the previous event has completed.
        Bounds: [2m, 1d]. Default: 2m.
        """
        return pulumi.get(self, "cooldown_period")

    @cooldown_period.setter
    def cooldown_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cooldown_period", value)


@pulumi.input_type
class AutoscalingPolicyBasicAlgorithmYarnConfigArgs:
    def __init__(__self__, *,
                 graceful_decommission_timeout: pulumi.Input[str],
                 scale_down_factor: pulumi.Input[float],
                 scale_up_factor: pulumi.Input[float],
                 scale_down_min_worker_fraction: Optional[pulumi.Input[float]] = None,
                 scale_up_min_worker_fraction: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] graceful_decommission_timeout: Timeout for YARN graceful decommissioning of Node Managers. Specifies the
               duration to wait for jobs to complete before forcefully removing workers
               (and potentially interrupting jobs). Only applicable to downscaling operations.
               Bounds: [0s, 1d].
        :param pulumi.Input[float] scale_down_factor: Fraction of average pending memory in the last cooldown period for which to
               remove workers. A scale-down factor of 1 will result in scaling down so that there
               is no available memory remaining after the update (more aggressive scaling).
               A scale-down factor of 0 disables removing workers, which can be beneficial for
               autoscaling a single job.
               Bounds: [0.0, 1.0].
        :param pulumi.Input[float] scale_up_factor: Fraction of average pending memory in the last cooldown period for which to
               add workers. A scale-up factor of 1.0 will result in scaling up so that there
               is no pending memory remaining after the update (more aggressive scaling).
               A scale-up factor closer to 0 will result in a smaller magnitude of scaling up
               (less aggressive scaling).
               Bounds: [0.0, 1.0].
        :param pulumi.Input[float] scale_down_min_worker_fraction: Minimum scale-down threshold as a fraction of total cluster size before scaling occurs.
               For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must
               recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0
               means the autoscaler will scale down on any recommended change.
               Bounds: [0.0, 1.0]. Default: 0.0.
        :param pulumi.Input[float] scale_up_min_worker_fraction: Minimum scale-up threshold as a fraction of total cluster size before scaling
               occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler
               must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of
               0 means the autoscaler will scale up on any recommended change.
               Bounds: [0.0, 1.0]. Default: 0.0.
        """
        pulumi.set(__self__, "graceful_decommission_timeout", graceful_decommission_timeout)
        pulumi.set(__self__, "scale_down_factor", scale_down_factor)
        pulumi.set(__self__, "scale_up_factor", scale_up_factor)
        if scale_down_min_worker_fraction is not None:
            pulumi.set(__self__, "scale_down_min_worker_fraction", scale_down_min_worker_fraction)
        if scale_up_min_worker_fraction is not None:
            pulumi.set(__self__, "scale_up_min_worker_fraction", scale_up_min_worker_fraction)

    @property
    @pulumi.getter(name="gracefulDecommissionTimeout")
    def graceful_decommission_timeout(self) -> pulumi.Input[str]:
        """
        Timeout for YARN graceful decommissioning of Node Managers. Specifies the
        duration to wait for jobs to complete before forcefully removing workers
        (and potentially interrupting jobs). Only applicable to downscaling operations.
        Bounds: [0s, 1d].
        """
        return pulumi.get(self, "graceful_decommission_timeout")

    @graceful_decommission_timeout.setter
    def graceful_decommission_timeout(self, value: pulumi.Input[str]):
        pulumi.set(self, "graceful_decommission_timeout", value)

    @property
    @pulumi.getter(name="scaleDownFactor")
    def scale_down_factor(self) -> pulumi.Input[float]:
        """
        Fraction of average pending memory in the last cooldown period for which to
        remove workers. A scale-down factor of 1 will result in scaling down so that there
        is no available memory remaining after the update (more aggressive scaling).
        A scale-down factor of 0 disables removing workers, which can be beneficial for
        autoscaling a single job.
        Bounds: [0.0, 1.0].
        """
        return pulumi.get(self, "scale_down_factor")

    @scale_down_factor.setter
    def scale_down_factor(self, value: pulumi.Input[float]):
        pulumi.set(self, "scale_down_factor", value)

    @property
    @pulumi.getter(name="scaleUpFactor")
    def scale_up_factor(self) -> pulumi.Input[float]:
        """
        Fraction of average pending memory in the last cooldown period for which to
        add workers. A scale-up factor of 1.0 will result in scaling up so that there
        is no pending memory remaining after the update (more aggressive scaling).
        A scale-up factor closer to 0 will result in a smaller magnitude of scaling up
        (less aggressive scaling).
        Bounds: [0.0, 1.0].
        """
        return pulumi.get(self, "scale_up_factor")

    @scale_up_factor.setter
    def scale_up_factor(self, value: pulumi.Input[float]):
        pulumi.set(self, "scale_up_factor", value)

    @property
    @pulumi.getter(name="scaleDownMinWorkerFraction")
    def scale_down_min_worker_fraction(self) -> Optional[pulumi.Input[float]]:
        """
        Minimum scale-down threshold as a fraction of total cluster size before scaling occurs.
        For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must
        recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0
        means the autoscaler will scale down on any recommended change.
        Bounds: [0.0, 1.0]. Default: 0.0.
        """
        return pulumi.get(self, "scale_down_min_worker_fraction")

    @scale_down_min_worker_fraction.setter
    def scale_down_min_worker_fraction(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "scale_down_min_worker_fraction", value)

    @property
    @pulumi.getter(name="scaleUpMinWorkerFraction")
    def scale_up_min_worker_fraction(self) -> Optional[pulumi.Input[float]]:
        """
        Minimum scale-up threshold as a fraction of total cluster size before scaling
        occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler
        must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of
        0 means the autoscaler will scale up on any recommended change.
        Bounds: [0.0, 1.0]. Default: 0.0.
        """
        return pulumi.get(self, "scale_up_min_worker_fraction")

    @scale_up_min_worker_fraction.setter
    def scale_up_min_worker_fraction(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "scale_up_min_worker_fraction", value)


@pulumi.input_type
class AutoscalingPolicySecondaryWorkerConfigArgs:
    def __init__(__self__, *,
                 max_instances: Optional[pulumi.Input[int]] = None,
                 min_instances: Optional[pulumi.Input[int]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] max_instances: Maximum number of instances for this group. Note that by default, clusters will not use
               secondary workers. Required for secondary workers if the minimum secondary instances is set.
               Bounds: [minInstances, ). Defaults to 0.
        :param pulumi.Input[int] min_instances: Minimum number of instances for this group. Bounds: [0, maxInstances]. Defaults to 0.
        :param pulumi.Input[int] weight: Weight for the instance group, which is used to determine the fraction of total workers
               in the cluster from this instance group. For example, if primary workers have weight 2,
               and secondary workers have weight 1, the cluster will have approximately 2 primary workers
               for each secondary worker.
               The cluster may not reach the specified balance if constrained by min/max bounds or other
               autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
               primary workers will be added. The cluster can also be out of balance when created.
               If weight is not set on any instance group, the cluster will default to equal weight for
               all groups: the cluster will attempt to maintain an equal number of workers in each group
               within the configured size bounds for each group. If weight is set for one group only,
               the cluster will default to zero weight on the unset group. For example if weight is set
               only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of instances for this group. Note that by default, clusters will not use
        secondary workers. Required for secondary workers if the minimum secondary instances is set.
        Bounds: [minInstances, ). Defaults to 0.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instances", value)

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of instances for this group. Bounds: [0, maxInstances]. Defaults to 0.
        """
        return pulumi.get(self, "min_instances")

    @min_instances.setter
    def min_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instances", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        Weight for the instance group, which is used to determine the fraction of total workers
        in the cluster from this instance group. For example, if primary workers have weight 2,
        and secondary workers have weight 1, the cluster will have approximately 2 primary workers
        for each secondary worker.
        The cluster may not reach the specified balance if constrained by min/max bounds or other
        autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
        primary workers will be added. The cluster can also be out of balance when created.
        If weight is not set on any instance group, the cluster will default to equal weight for
        all groups: the cluster will attempt to maintain an equal number of workers in each group
        within the configured size bounds for each group. If weight is set for one group only,
        the cluster will default to zero weight on the unset group. For example if weight is set
        only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class AutoscalingPolicyWorkerConfigArgs:
    def __init__(__self__, *,
                 max_instances: pulumi.Input[int],
                 min_instances: Optional[pulumi.Input[int]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] max_instances: Maximum number of instances for this group. Note that by default, clusters will not use
               secondary workers. Required for secondary workers if the minimum secondary instances is set.
               Bounds: [minInstances, ). Defaults to 0.
        :param pulumi.Input[int] min_instances: Minimum number of instances for this group. Bounds: [0, maxInstances]. Defaults to 0.
        :param pulumi.Input[int] weight: Weight for the instance group, which is used to determine the fraction of total workers
               in the cluster from this instance group. For example, if primary workers have weight 2,
               and secondary workers have weight 1, the cluster will have approximately 2 primary workers
               for each secondary worker.
               The cluster may not reach the specified balance if constrained by min/max bounds or other
               autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
               primary workers will be added. The cluster can also be out of balance when created.
               If weight is not set on any instance group, the cluster will default to equal weight for
               all groups: the cluster will attempt to maintain an equal number of workers in each group
               within the configured size bounds for each group. If weight is set for one group only,
               the cluster will default to zero weight on the unset group. For example if weight is set
               only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> pulumi.Input[int]:
        """
        Maximum number of instances for this group. Note that by default, clusters will not use
        secondary workers. Required for secondary workers if the minimum secondary instances is set.
        Bounds: [minInstances, ). Defaults to 0.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_instances", value)

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of instances for this group. Bounds: [0, maxInstances]. Defaults to 0.
        """
        return pulumi.get(self, "min_instances")

    @min_instances.setter
    def min_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instances", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        Weight for the instance group, which is used to determine the fraction of total workers
        in the cluster from this instance group. For example, if primary workers have weight 2,
        and secondary workers have weight 1, the cluster will have approximately 2 primary workers
        for each secondary worker.
        The cluster may not reach the specified balance if constrained by min/max bounds or other
        autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
        primary workers will be added. The cluster can also be out of balance when created.
        If weight is not set on any instance group, the cluster will default to equal weight for
        all groups: the cluster will attempt to maintain an equal number of workers in each group
        within the configured size bounds for each group. If weight is set for one group only,
        the cluster will default to zero weight on the unset group. For example if weight is set
        only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class ClusterClusterConfigArgs:
    def __init__(__self__, *,
                 autoscaling_config: Optional[pulumi.Input['ClusterClusterConfigAutoscalingConfigArgs']] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 encryption_config: Optional[pulumi.Input['ClusterClusterConfigEncryptionConfigArgs']] = None,
                 endpoint_config: Optional[pulumi.Input['ClusterClusterConfigEndpointConfigArgs']] = None,
                 gce_cluster_config: Optional[pulumi.Input['ClusterClusterConfigGceClusterConfigArgs']] = None,
                 initialization_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterConfigInitializationActionArgs']]]] = None,
                 lifecycle_config: Optional[pulumi.Input['ClusterClusterConfigLifecycleConfigArgs']] = None,
                 master_config: Optional[pulumi.Input['ClusterClusterConfigMasterConfigArgs']] = None,
                 metastore_config: Optional[pulumi.Input['ClusterClusterConfigMetastoreConfigArgs']] = None,
                 preemptible_worker_config: Optional[pulumi.Input['ClusterClusterConfigPreemptibleWorkerConfigArgs']] = None,
                 security_config: Optional[pulumi.Input['ClusterClusterConfigSecurityConfigArgs']] = None,
                 software_config: Optional[pulumi.Input['ClusterClusterConfigSoftwareConfigArgs']] = None,
                 staging_bucket: Optional[pulumi.Input[str]] = None,
                 temp_bucket: Optional[pulumi.Input[str]] = None,
                 worker_config: Optional[pulumi.Input['ClusterClusterConfigWorkerConfigArgs']] = None):
        """
        :param pulumi.Input['ClusterClusterConfigAutoscalingConfigArgs'] autoscaling_config: The autoscaling policy config associated with the cluster.
               Note that once set, if `autoscaling_config` is the only field set in `cluster_config`, it can
               only be removed by setting `policy_uri = ""`, rather than removing the whole block.
               Structure defined below.
        :param pulumi.Input['ClusterClusterConfigEncryptionConfigArgs'] encryption_config: The Customer managed encryption keys settings for the cluster.
               Structure defined below.
        :param pulumi.Input['ClusterClusterConfigEndpointConfigArgs'] endpoint_config: The config settings for port access on the cluster.
               Structure defined below.
        :param pulumi.Input['ClusterClusterConfigGceClusterConfigArgs'] gce_cluster_config: Common config settings for resources of Google Compute Engine cluster
               instances, applicable to all instances in the cluster. Structure defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterClusterConfigInitializationActionArgs']]] initialization_actions: Commands to execute on each node after config is completed.
               You can specify multiple versions of these. Structure defined below.
        :param pulumi.Input['ClusterClusterConfigLifecycleConfigArgs'] lifecycle_config: The settings for auto deletion cluster schedule.
               Structure defined below.
        :param pulumi.Input['ClusterClusterConfigMasterConfigArgs'] master_config: The Google Compute Engine config settings for the master instances
               in a cluster. Structure defined below.
        :param pulumi.Input['ClusterClusterConfigMetastoreConfigArgs'] metastore_config: The config setting for metastore service with the cluster.
               Structure defined below.
               - - -
        :param pulumi.Input['ClusterClusterConfigPreemptibleWorkerConfigArgs'] preemptible_worker_config: The Google Compute Engine config settings for the additional
               instances in a cluster. Structure defined below.
               * **NOTE** : `preemptible_worker_config` is
               an alias for the api's [secondaryWorkerConfig](https://cloud.google.com/dataproc/docs/reference/rest/v1/ClusterConfig#InstanceGroupConfig). The name doesn't necessarily mean it is preemptible and is named as
               such for legacy/compatibility reasons.
        :param pulumi.Input['ClusterClusterConfigSecurityConfigArgs'] security_config: Security related configuration. Structure defined below.
        :param pulumi.Input['ClusterClusterConfigSoftwareConfigArgs'] software_config: The config settings for software inside the cluster.
               Structure defined below.
        :param pulumi.Input[str] staging_bucket: The Cloud Storage staging bucket used to stage files,
               such as Hadoop jars, between client machines and the cluster.
               Note: If you don't explicitly specify a `staging_bucket`
               then GCP will auto create / assign one for you. However, you are not guaranteed
               an auto generated bucket which is solely dedicated to your cluster; it may be shared
               with other clusters in the same region/zone also choosing to use the auto generation
               option.
        :param pulumi.Input[str] temp_bucket: The Cloud Storage temp bucket used to store ephemeral cluster
               and jobs data, such as Spark and MapReduce history files.
               Note: If you don't explicitly specify a `temp_bucket` then GCP will auto create / assign one for you.
        :param pulumi.Input['ClusterClusterConfigWorkerConfigArgs'] worker_config: The Google Compute Engine config settings for the worker instances
               in a cluster. Structure defined below.
        """
        if autoscaling_config is not None:
            pulumi.set(__self__, "autoscaling_config", autoscaling_config)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if endpoint_config is not None:
            pulumi.set(__self__, "endpoint_config", endpoint_config)
        if gce_cluster_config is not None:
            pulumi.set(__self__, "gce_cluster_config", gce_cluster_config)
        if initialization_actions is not None:
            pulumi.set(__self__, "initialization_actions", initialization_actions)
        if lifecycle_config is not None:
            pulumi.set(__self__, "lifecycle_config", lifecycle_config)
        if master_config is not None:
            pulumi.set(__self__, "master_config", master_config)
        if metastore_config is not None:
            pulumi.set(__self__, "metastore_config", metastore_config)
        if preemptible_worker_config is not None:
            pulumi.set(__self__, "preemptible_worker_config", preemptible_worker_config)
        if security_config is not None:
            pulumi.set(__self__, "security_config", security_config)
        if software_config is not None:
            pulumi.set(__self__, "software_config", software_config)
        if staging_bucket is not None:
            pulumi.set(__self__, "staging_bucket", staging_bucket)
        if temp_bucket is not None:
            pulumi.set(__self__, "temp_bucket", temp_bucket)
        if worker_config is not None:
            pulumi.set(__self__, "worker_config", worker_config)

    @property
    @pulumi.getter(name="autoscalingConfig")
    def autoscaling_config(self) -> Optional[pulumi.Input['ClusterClusterConfigAutoscalingConfigArgs']]:
        """
        The autoscaling policy config associated with the cluster.
        Note that once set, if `autoscaling_config` is the only field set in `cluster_config`, it can
        only be removed by setting `policy_uri = ""`, rather than removing the whole block.
        Structure defined below.
        """
        return pulumi.get(self, "autoscaling_config")

    @autoscaling_config.setter
    def autoscaling_config(self, value: Optional[pulumi.Input['ClusterClusterConfigAutoscalingConfigArgs']]):
        pulumi.set(self, "autoscaling_config", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['ClusterClusterConfigEncryptionConfigArgs']]:
        """
        The Customer managed encryption keys settings for the cluster.
        Structure defined below.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['ClusterClusterConfigEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> Optional[pulumi.Input['ClusterClusterConfigEndpointConfigArgs']]:
        """
        The config settings for port access on the cluster.
        Structure defined below.
        """
        return pulumi.get(self, "endpoint_config")

    @endpoint_config.setter
    def endpoint_config(self, value: Optional[pulumi.Input['ClusterClusterConfigEndpointConfigArgs']]):
        pulumi.set(self, "endpoint_config", value)

    @property
    @pulumi.getter(name="gceClusterConfig")
    def gce_cluster_config(self) -> Optional[pulumi.Input['ClusterClusterConfigGceClusterConfigArgs']]:
        """
        Common config settings for resources of Google Compute Engine cluster
        instances, applicable to all instances in the cluster. Structure defined below.
        """
        return pulumi.get(self, "gce_cluster_config")

    @gce_cluster_config.setter
    def gce_cluster_config(self, value: Optional[pulumi.Input['ClusterClusterConfigGceClusterConfigArgs']]):
        pulumi.set(self, "gce_cluster_config", value)

    @property
    @pulumi.getter(name="initializationActions")
    def initialization_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterConfigInitializationActionArgs']]]]:
        """
        Commands to execute on each node after config is completed.
        You can specify multiple versions of these. Structure defined below.
        """
        return pulumi.get(self, "initialization_actions")

    @initialization_actions.setter
    def initialization_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterConfigInitializationActionArgs']]]]):
        pulumi.set(self, "initialization_actions", value)

    @property
    @pulumi.getter(name="lifecycleConfig")
    def lifecycle_config(self) -> Optional[pulumi.Input['ClusterClusterConfigLifecycleConfigArgs']]:
        """
        The settings for auto deletion cluster schedule.
        Structure defined below.
        """
        return pulumi.get(self, "lifecycle_config")

    @lifecycle_config.setter
    def lifecycle_config(self, value: Optional[pulumi.Input['ClusterClusterConfigLifecycleConfigArgs']]):
        pulumi.set(self, "lifecycle_config", value)

    @property
    @pulumi.getter(name="masterConfig")
    def master_config(self) -> Optional[pulumi.Input['ClusterClusterConfigMasterConfigArgs']]:
        """
        The Google Compute Engine config settings for the master instances
        in a cluster. Structure defined below.
        """
        return pulumi.get(self, "master_config")

    @master_config.setter
    def master_config(self, value: Optional[pulumi.Input['ClusterClusterConfigMasterConfigArgs']]):
        pulumi.set(self, "master_config", value)

    @property
    @pulumi.getter(name="metastoreConfig")
    def metastore_config(self) -> Optional[pulumi.Input['ClusterClusterConfigMetastoreConfigArgs']]:
        """
        The config setting for metastore service with the cluster.
        Structure defined below.
        - - -
        """
        return pulumi.get(self, "metastore_config")

    @metastore_config.setter
    def metastore_config(self, value: Optional[pulumi.Input['ClusterClusterConfigMetastoreConfigArgs']]):
        pulumi.set(self, "metastore_config", value)

    @property
    @pulumi.getter(name="preemptibleWorkerConfig")
    def preemptible_worker_config(self) -> Optional[pulumi.Input['ClusterClusterConfigPreemptibleWorkerConfigArgs']]:
        """
        The Google Compute Engine config settings for the additional
        instances in a cluster. Structure defined below.
        * **NOTE** : `preemptible_worker_config` is
        an alias for the api's [secondaryWorkerConfig](https://cloud.google.com/dataproc/docs/reference/rest/v1/ClusterConfig#InstanceGroupConfig). The name doesn't necessarily mean it is preemptible and is named as
        such for legacy/compatibility reasons.
        """
        return pulumi.get(self, "preemptible_worker_config")

    @preemptible_worker_config.setter
    def preemptible_worker_config(self, value: Optional[pulumi.Input['ClusterClusterConfigPreemptibleWorkerConfigArgs']]):
        pulumi.set(self, "preemptible_worker_config", value)

    @property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> Optional[pulumi.Input['ClusterClusterConfigSecurityConfigArgs']]:
        """
        Security related configuration. Structure defined below.
        """
        return pulumi.get(self, "security_config")

    @security_config.setter
    def security_config(self, value: Optional[pulumi.Input['ClusterClusterConfigSecurityConfigArgs']]):
        pulumi.set(self, "security_config", value)

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> Optional[pulumi.Input['ClusterClusterConfigSoftwareConfigArgs']]:
        """
        The config settings for software inside the cluster.
        Structure defined below.
        """
        return pulumi.get(self, "software_config")

    @software_config.setter
    def software_config(self, value: Optional[pulumi.Input['ClusterClusterConfigSoftwareConfigArgs']]):
        pulumi.set(self, "software_config", value)

    @property
    @pulumi.getter(name="stagingBucket")
    def staging_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage staging bucket used to stage files,
        such as Hadoop jars, between client machines and the cluster.
        Note: If you don't explicitly specify a `staging_bucket`
        then GCP will auto create / assign one for you. However, you are not guaranteed
        an auto generated bucket which is solely dedicated to your cluster; it may be shared
        with other clusters in the same region/zone also choosing to use the auto generation
        option.
        """
        return pulumi.get(self, "staging_bucket")

    @staging_bucket.setter
    def staging_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "staging_bucket", value)

    @property
    @pulumi.getter(name="tempBucket")
    def temp_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage temp bucket used to store ephemeral cluster
        and jobs data, such as Spark and MapReduce history files.
        Note: If you don't explicitly specify a `temp_bucket` then GCP will auto create / assign one for you.
        """
        return pulumi.get(self, "temp_bucket")

    @temp_bucket.setter
    def temp_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "temp_bucket", value)

    @property
    @pulumi.getter(name="workerConfig")
    def worker_config(self) -> Optional[pulumi.Input['ClusterClusterConfigWorkerConfigArgs']]:
        """
        The Google Compute Engine config settings for the worker instances
        in a cluster. Structure defined below.
        """
        return pulumi.get(self, "worker_config")

    @worker_config.setter
    def worker_config(self, value: Optional[pulumi.Input['ClusterClusterConfigWorkerConfigArgs']]):
        pulumi.set(self, "worker_config", value)


@pulumi.input_type
class ClusterClusterConfigAutoscalingConfigArgs:
    def __init__(__self__, *,
                 policy_uri: pulumi.Input[str]):
        """
        :param pulumi.Input[str] policy_uri: The autoscaling policy used by the cluster.
        """
        pulumi.set(__self__, "policy_uri", policy_uri)

    @property
    @pulumi.getter(name="policyUri")
    def policy_uri(self) -> pulumi.Input[str]:
        """
        The autoscaling policy used by the cluster.
        """
        return pulumi.get(self, "policy_uri")

    @policy_uri.setter
    def policy_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_uri", value)


@pulumi.input_type
class ClusterClusterConfigEncryptionConfigArgs:
    def __init__(__self__, *,
                 kms_key_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] kms_key_name: The Cloud KMS key name to use for PD disk encryption for
               all instances in the cluster.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Input[str]:
        """
        The Cloud KMS key name to use for PD disk encryption for
        all instances in the cluster.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_name", value)


@pulumi.input_type
class ClusterClusterConfigEndpointConfigArgs:
    def __init__(__self__, *,
                 enable_http_port_access: pulumi.Input[bool],
                 http_ports: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[bool] enable_http_port_access: The flag to enable http access to specific ports
               on the cluster from external sources (aka Component Gateway). Defaults to false.
        """
        pulumi.set(__self__, "enable_http_port_access", enable_http_port_access)
        if http_ports is not None:
            pulumi.set(__self__, "http_ports", http_ports)

    @property
    @pulumi.getter(name="enableHttpPortAccess")
    def enable_http_port_access(self) -> pulumi.Input[bool]:
        """
        The flag to enable http access to specific ports
        on the cluster from external sources (aka Component Gateway). Defaults to false.
        """
        return pulumi.get(self, "enable_http_port_access")

    @enable_http_port_access.setter
    def enable_http_port_access(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_http_port_access", value)

    @property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        return pulumi.get(self, "http_ports")

    @http_ports.setter
    def http_ports(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "http_ports", value)


@pulumi.input_type
class ClusterClusterConfigGceClusterConfigArgs:
    def __init__(__self__, *,
                 internal_ip_only: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 service_account_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shielded_instance_config: Optional[pulumi.Input['ClusterClusterConfigGceClusterConfigShieldedInstanceConfigArgs']] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] internal_ip_only: By default, clusters are not restricted to internal IP addresses,
               and will have ephemeral external IP addresses assigned to each instance. If set to true, all
               instances in the cluster will only have internal IP addresses. Note: Private Google Access
               (also known as `privateIpGoogleAccess`) must be enabled on the subnetwork that the cluster
               will be launched in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: A map of the Compute Engine metadata entries to add to all instances
               (see [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        :param pulumi.Input[str] network: The name or self_link of the Google Compute Engine
               network to the cluster will be part of. Conflicts with `subnetwork`.
               If neither is specified, this defaults to the "default" network.
        :param pulumi.Input[str] service_account: The service account to be used by the Node VMs.
               If not specified, the "default" service account is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_account_scopes: The set of Google API scopes
               to be made available on all of the node VMs under the `service_account`
               specified. Both OAuth2 URLs and gcloud
               short names are supported. To allow full access to all Cloud APIs, use the
               `cloud-platform` scope. See a complete list of scopes [here](https://cloud.google.com/sdk/gcloud/reference/alpha/compute/instances/set-scopes#--scopes).
        :param pulumi.Input['ClusterClusterConfigGceClusterConfigShieldedInstanceConfigArgs'] shielded_instance_config: Shielded Instance Config for clusters using [Compute Engine Shielded VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
        :param pulumi.Input[str] subnetwork: The name or self_link of the Google Compute Engine
               subnetwork the cluster will be part of. Conflicts with `network`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of instance tags applied to instances in the cluster.
               Tags are used to identify valid sources or targets for network firewalls.
        :param pulumi.Input[str] zone: The GCP zone where your data is stored and used (i.e. where
               the master and the worker nodes will be created in). If `region` is set to 'global' (default)
               then `zone` is mandatory, otherwise GCP is able to make use of [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/auto-zone)
               to determine this automatically for you.
               Note: This setting additionally determines and restricts
               which computing resources are available for use with other configs such as
               `cluster_config.master_config.machine_type` and `cluster_config.worker_config.machine_type`.
        """
        if internal_ip_only is not None:
            pulumi.set(__self__, "internal_ip_only", internal_ip_only)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if service_account_scopes is not None:
            pulumi.set(__self__, "service_account_scopes", service_account_scopes)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="internalIpOnly")
    def internal_ip_only(self) -> Optional[pulumi.Input[bool]]:
        """
        By default, clusters are not restricted to internal IP addresses,
        and will have ephemeral external IP addresses assigned to each instance. If set to true, all
        instances in the cluster will only have internal IP addresses. Note: Private Google Access
        (also known as `privateIpGoogleAccess`) must be enabled on the subnetwork that the cluster
        will be launched in.
        """
        return pulumi.get(self, "internal_ip_only")

    @internal_ip_only.setter
    def internal_ip_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "internal_ip_only", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of the Compute Engine metadata entries to add to all instances
        (see [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The name or self_link of the Google Compute Engine
        network to the cluster will be part of. Conflicts with `subnetwork`.
        If neither is specified, this defaults to the "default" network.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        The service account to be used by the Node VMs.
        If not specified, the "default" service account is used.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="serviceAccountScopes")
    def service_account_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of Google API scopes
        to be made available on all of the node VMs under the `service_account`
        specified. Both OAuth2 URLs and gcloud
        short names are supported. To allow full access to all Cloud APIs, use the
        `cloud-platform` scope. See a complete list of scopes [here](https://cloud.google.com/sdk/gcloud/reference/alpha/compute/instances/set-scopes#--scopes).
        """
        return pulumi.get(self, "service_account_scopes")

    @service_account_scopes.setter
    def service_account_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_account_scopes", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['ClusterClusterConfigGceClusterConfigShieldedInstanceConfigArgs']]:
        """
        Shielded Instance Config for clusters using [Compute Engine Shielded VMs](https://cloud.google.com/security/shielded-cloud/shielded-vm).
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['ClusterClusterConfigGceClusterConfigShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        The name or self_link of the Google Compute Engine
        subnetwork the cluster will be part of. Conflicts with `network`.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of instance tags applied to instances in the cluster.
        Tags are used to identify valid sources or targets for network firewalls.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The GCP zone where your data is stored and used (i.e. where
        the master and the worker nodes will be created in). If `region` is set to 'global' (default)
        then `zone` is mandatory, otherwise GCP is able to make use of [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/auto-zone)
        to determine this automatically for you.
        Note: This setting additionally determines and restricts
        which computing resources are available for use with other configs such as
        `cluster_config.master_config.machine_type` and `cluster_config.worker_config.machine_type`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class ClusterClusterConfigGceClusterConfigShieldedInstanceConfigArgs:
    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[pulumi.Input[bool]] = None,
                 enable_secure_boot: Optional[pulumi.Input[bool]] = None,
                 enable_vtpm: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] enable_integrity_monitoring: Defines whether instances have integrity monitoring enabled.
        :param pulumi.Input[bool] enable_secure_boot: Defines whether instances have Secure Boot enabled.
        :param pulumi.Input[bool] enable_vtpm: Defines whether instances have the [vTPM](https://cloud.google.com/security/shielded-cloud/shielded-vm#vtpm) enabled.
        """
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        if enable_vtpm is not None:
            pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether instances have integrity monitoring enabled.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @enable_integrity_monitoring.setter
    def enable_integrity_monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_integrity_monitoring", value)

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether instances have Secure Boot enabled.
        """
        return pulumi.get(self, "enable_secure_boot")

    @enable_secure_boot.setter
    def enable_secure_boot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_secure_boot", value)

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether instances have the [vTPM](https://cloud.google.com/security/shielded-cloud/shielded-vm#vtpm) enabled.
        """
        return pulumi.get(self, "enable_vtpm")

    @enable_vtpm.setter
    def enable_vtpm(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vtpm", value)


@pulumi.input_type
class ClusterClusterConfigInitializationActionArgs:
    def __init__(__self__, *,
                 script: pulumi.Input[str],
                 timeout_sec: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] script: The script to be executed during initialization of the cluster.
               The script must be a GCS file with a gs:// prefix.
        :param pulumi.Input[int] timeout_sec: The maximum duration (in seconds) which `script` is
               allowed to take to execute its action. GCP will default to a predetermined
               computed value if not set (currently 300).
        """
        pulumi.set(__self__, "script", script)
        if timeout_sec is not None:
            pulumi.set(__self__, "timeout_sec", timeout_sec)

    @property
    @pulumi.getter
    def script(self) -> pulumi.Input[str]:
        """
        The script to be executed during initialization of the cluster.
        The script must be a GCS file with a gs:// prefix.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: pulumi.Input[str]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum duration (in seconds) which `script` is
        allowed to take to execute its action. GCP will default to a predetermined
        computed value if not set (currently 300).
        """
        return pulumi.get(self, "timeout_sec")

    @timeout_sec.setter
    def timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_sec", value)


@pulumi.input_type
class ClusterClusterConfigLifecycleConfigArgs:
    def __init__(__self__, *,
                 auto_delete_time: Optional[pulumi.Input[str]] = None,
                 idle_delete_ttl: Optional[pulumi.Input[str]] = None,
                 idle_start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] auto_delete_time: The time when cluster will be auto-deleted.
               A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
               Example: "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] idle_delete_ttl: The duration to keep the cluster alive while idling
               (no jobs running). After this TTL, the cluster will be deleted. Valid range: [10m, 14d].
        """
        if auto_delete_time is not None:
            pulumi.set(__self__, "auto_delete_time", auto_delete_time)
        if idle_delete_ttl is not None:
            pulumi.set(__self__, "idle_delete_ttl", idle_delete_ttl)
        if idle_start_time is not None:
            pulumi.set(__self__, "idle_start_time", idle_start_time)

    @property
    @pulumi.getter(name="autoDeleteTime")
    def auto_delete_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when cluster will be auto-deleted.
        A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "auto_delete_time")

    @auto_delete_time.setter
    def auto_delete_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_delete_time", value)

    @property
    @pulumi.getter(name="idleDeleteTtl")
    def idle_delete_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        The duration to keep the cluster alive while idling
        (no jobs running). After this TTL, the cluster will be deleted. Valid range: [10m, 14d].
        """
        return pulumi.get(self, "idle_delete_ttl")

    @idle_delete_ttl.setter
    def idle_delete_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idle_delete_ttl", value)

    @property
    @pulumi.getter(name="idleStartTime")
    def idle_start_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "idle_start_time")

    @idle_start_time.setter
    def idle_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idle_start_time", value)


@pulumi.input_type
class ClusterClusterConfigMasterConfigArgs:
    def __init__(__self__, *,
                 accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterConfigMasterConfigAcceleratorArgs']]]] = None,
                 disk_config: Optional[pulumi.Input['ClusterClusterConfigMasterConfigDiskConfigArgs']] = None,
                 image_uri: Optional[pulumi.Input[str]] = None,
                 instance_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 num_instances: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ClusterClusterConfigMasterConfigAcceleratorArgs']]] accelerators: The Compute Engine accelerator configuration for these instances. Can be specified multiple times.
        :param pulumi.Input['ClusterClusterConfigMasterConfigDiskConfigArgs'] disk_config: Disk Config
        :param pulumi.Input[str] image_uri: The URI for the image to use for this worker.  See [the guide](https://cloud.google.com/dataproc/docs/guides/dataproc-images)
               for more information.
        :param pulumi.Input[str] machine_type: The name of a Google Compute Engine machine type
               to create for the worker nodes. If not specified, GCP will default to a predetermined
               computed value (currently `n1-standard-4`).
        :param pulumi.Input[str] min_cpu_platform: The name of a minimum generation of CPU family
               for the master. If not specified, GCP will default to a predetermined computed value
               for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
               for details about which CPU families are available (and defaulted) for each zone.
        :param pulumi.Input[int] num_instances: Specifies the number of preemptible nodes to create.
               Defaults to 0.
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterConfigMasterConfigAcceleratorArgs']]]]:
        """
        The Compute Engine accelerator configuration for these instances. Can be specified multiple times.
        """
        return pulumi.get(self, "accelerators")

    @accelerators.setter
    def accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterConfigMasterConfigAcceleratorArgs']]]]):
        pulumi.set(self, "accelerators", value)

    @property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional[pulumi.Input['ClusterClusterConfigMasterConfigDiskConfigArgs']]:
        """
        Disk Config
        """
        return pulumi.get(self, "disk_config")

    @disk_config.setter
    def disk_config(self, value: Optional[pulumi.Input['ClusterClusterConfigMasterConfigDiskConfigArgs']]):
        pulumi.set(self, "disk_config", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI for the image to use for this worker.  See [the guide](https://cloud.google.com/dataproc/docs/guides/dataproc-images)
        for more information.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_uri", value)

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "instance_names")

    @instance_names.setter
    def instance_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_names", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a Google Compute Engine machine type
        to create for the worker nodes. If not specified, GCP will default to a predetermined
        computed value (currently `n1-standard-4`).
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a minimum generation of CPU family
        for the master. If not specified, GCP will default to a predetermined computed value
        for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        for details about which CPU families are available (and defaulted) for each zone.
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of preemptible nodes to create.
        Defaults to 0.
        """
        return pulumi.get(self, "num_instances")

    @num_instances.setter
    def num_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_instances", value)


@pulumi.input_type
class ClusterClusterConfigMasterConfigAcceleratorArgs:
    def __init__(__self__, *,
                 accelerator_count: pulumi.Input[int],
                 accelerator_type: pulumi.Input[str]):
        """
        :param pulumi.Input[int] accelerator_count: The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.
        :param pulumi.Input[str] accelerator_type: The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        pulumi.set(__self__, "accelerator_count", accelerator_count)
        pulumi.set(__self__, "accelerator_type", accelerator_type)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> pulumi.Input[int]:
        """
        The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.
        """
        return pulumi.get(self, "accelerator_count")

    @accelerator_count.setter
    def accelerator_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "accelerator_count", value)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> pulumi.Input[str]:
        """
        The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "accelerator_type", value)


@pulumi.input_type
class ClusterClusterConfigMasterConfigDiskConfigArgs:
    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 boot_disk_type: Optional[pulumi.Input[str]] = None,
                 num_local_ssds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] boot_disk_size_gb: Size of the primary disk attached to each preemptible worker node, specified
               in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
               computed value if not set (currently 500GB). Note: If SSDs are not
               attached, it also contains the HDFS data blocks and Hadoop working directories.
        :param pulumi.Input[str] boot_disk_type: The disk type of the primary disk attached to each preemptible worker node.
               One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        :param pulumi.Input[int] num_local_ssds: The amount of local SSD disks that will be
               attached to each preemptible worker node. Defaults to 0.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the primary disk attached to each preemptible worker node, specified
        in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
        computed value if not set (currently 500GB). Note: If SSDs are not
        attached, it also contains the HDFS data blocks and Hadoop working directories.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @boot_disk_size_gb.setter
    def boot_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "boot_disk_size_gb", value)

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The disk type of the primary disk attached to each preemptible worker node.
        One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        """
        return pulumi.get(self, "boot_disk_type")

    @boot_disk_type.setter
    def boot_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_disk_type", value)

    @property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of local SSD disks that will be
        attached to each preemptible worker node. Defaults to 0.
        """
        return pulumi.get(self, "num_local_ssds")

    @num_local_ssds.setter
    def num_local_ssds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_local_ssds", value)


@pulumi.input_type
class ClusterClusterConfigMetastoreConfigArgs:
    def __init__(__self__, *,
                 dataproc_metastore_service: pulumi.Input[str]):
        """
        :param pulumi.Input[str] dataproc_metastore_service: Resource name of an existing Dataproc Metastore service.
        """
        pulumi.set(__self__, "dataproc_metastore_service", dataproc_metastore_service)

    @property
    @pulumi.getter(name="dataprocMetastoreService")
    def dataproc_metastore_service(self) -> pulumi.Input[str]:
        """
        Resource name of an existing Dataproc Metastore service.
        """
        return pulumi.get(self, "dataproc_metastore_service")

    @dataproc_metastore_service.setter
    def dataproc_metastore_service(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataproc_metastore_service", value)


@pulumi.input_type
class ClusterClusterConfigPreemptibleWorkerConfigArgs:
    def __init__(__self__, *,
                 disk_config: Optional[pulumi.Input['ClusterClusterConfigPreemptibleWorkerConfigDiskConfigArgs']] = None,
                 instance_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 num_instances: Optional[pulumi.Input[int]] = None,
                 preemptibility: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['ClusterClusterConfigPreemptibleWorkerConfigDiskConfigArgs'] disk_config: Disk Config
        :param pulumi.Input[int] num_instances: Specifies the number of preemptible nodes to create.
               Defaults to 0.
        :param pulumi.Input[str] preemptibility: Specifies the preemptibility of the secondary workers. The default value is `PREEMPTIBLE`
               Accepted values are:
               * PREEMPTIBILITY_UNSPECIFIED
               * NON_PREEMPTIBLE
               * PREEMPTIBLE
        """
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)
        if preemptibility is not None:
            pulumi.set(__self__, "preemptibility", preemptibility)

    @property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional[pulumi.Input['ClusterClusterConfigPreemptibleWorkerConfigDiskConfigArgs']]:
        """
        Disk Config
        """
        return pulumi.get(self, "disk_config")

    @disk_config.setter
    def disk_config(self, value: Optional[pulumi.Input['ClusterClusterConfigPreemptibleWorkerConfigDiskConfigArgs']]):
        pulumi.set(self, "disk_config", value)

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "instance_names")

    @instance_names.setter
    def instance_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_names", value)

    @property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of preemptible nodes to create.
        Defaults to 0.
        """
        return pulumi.get(self, "num_instances")

    @num_instances.setter
    def num_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_instances", value)

    @property
    @pulumi.getter
    def preemptibility(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the preemptibility of the secondary workers. The default value is `PREEMPTIBLE`
        Accepted values are:
        * PREEMPTIBILITY_UNSPECIFIED
        * NON_PREEMPTIBLE
        * PREEMPTIBLE
        """
        return pulumi.get(self, "preemptibility")

    @preemptibility.setter
    def preemptibility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preemptibility", value)


@pulumi.input_type
class ClusterClusterConfigPreemptibleWorkerConfigDiskConfigArgs:
    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 boot_disk_type: Optional[pulumi.Input[str]] = None,
                 num_local_ssds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] boot_disk_size_gb: Size of the primary disk attached to each preemptible worker node, specified
               in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
               computed value if not set (currently 500GB). Note: If SSDs are not
               attached, it also contains the HDFS data blocks and Hadoop working directories.
        :param pulumi.Input[str] boot_disk_type: The disk type of the primary disk attached to each preemptible worker node.
               One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        :param pulumi.Input[int] num_local_ssds: The amount of local SSD disks that will be
               attached to each preemptible worker node. Defaults to 0.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the primary disk attached to each preemptible worker node, specified
        in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
        computed value if not set (currently 500GB). Note: If SSDs are not
        attached, it also contains the HDFS data blocks and Hadoop working directories.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @boot_disk_size_gb.setter
    def boot_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "boot_disk_size_gb", value)

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The disk type of the primary disk attached to each preemptible worker node.
        One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        """
        return pulumi.get(self, "boot_disk_type")

    @boot_disk_type.setter
    def boot_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_disk_type", value)

    @property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of local SSD disks that will be
        attached to each preemptible worker node. Defaults to 0.
        """
        return pulumi.get(self, "num_local_ssds")

    @num_local_ssds.setter
    def num_local_ssds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_local_ssds", value)


@pulumi.input_type
class ClusterClusterConfigSecurityConfigArgs:
    def __init__(__self__, *,
                 kerberos_config: pulumi.Input['ClusterClusterConfigSecurityConfigKerberosConfigArgs']):
        """
        :param pulumi.Input['ClusterClusterConfigSecurityConfigKerberosConfigArgs'] kerberos_config: Kerberos Configuration
        """
        pulumi.set(__self__, "kerberos_config", kerberos_config)

    @property
    @pulumi.getter(name="kerberosConfig")
    def kerberos_config(self) -> pulumi.Input['ClusterClusterConfigSecurityConfigKerberosConfigArgs']:
        """
        Kerberos Configuration
        """
        return pulumi.get(self, "kerberos_config")

    @kerberos_config.setter
    def kerberos_config(self, value: pulumi.Input['ClusterClusterConfigSecurityConfigKerberosConfigArgs']):
        pulumi.set(self, "kerberos_config", value)


@pulumi.input_type
class ClusterClusterConfigSecurityConfigKerberosConfigArgs:
    def __init__(__self__, *,
                 kms_key_uri: pulumi.Input[str],
                 root_principal_password_uri: pulumi.Input[str],
                 cross_realm_trust_admin_server: Optional[pulumi.Input[str]] = None,
                 cross_realm_trust_kdc: Optional[pulumi.Input[str]] = None,
                 cross_realm_trust_realm: Optional[pulumi.Input[str]] = None,
                 cross_realm_trust_shared_password_uri: Optional[pulumi.Input[str]] = None,
                 enable_kerberos: Optional[pulumi.Input[bool]] = None,
                 kdc_db_key_uri: Optional[pulumi.Input[str]] = None,
                 key_password_uri: Optional[pulumi.Input[str]] = None,
                 keystore_password_uri: Optional[pulumi.Input[str]] = None,
                 keystore_uri: Optional[pulumi.Input[str]] = None,
                 realm: Optional[pulumi.Input[str]] = None,
                 tgt_lifetime_hours: Optional[pulumi.Input[int]] = None,
                 truststore_password_uri: Optional[pulumi.Input[str]] = None,
                 truststore_uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kms_key_uri: The URI of the KMS key used to encrypt various sensitive files.
        :param pulumi.Input[str] root_principal_password_uri: The Cloud Storage URI of a KMS encrypted file
               containing the root principal password.
        :param pulumi.Input[str] cross_realm_trust_admin_server: The admin server (IP or hostname) for the
               remote trusted realm in a cross realm trust relationship.
        :param pulumi.Input[str] cross_realm_trust_kdc: The KDC (IP or hostname) for the
               remote trusted realm in a cross realm trust relationship.
        :param pulumi.Input[str] cross_realm_trust_realm: The remote realm the Dataproc on-cluster KDC will
               trust, should the user enable cross realm trust.
        :param pulumi.Input[str] cross_realm_trust_shared_password_uri: The Cloud Storage URI of a KMS
               encrypted file containing the shared password between the on-cluster Kerberos realm
               and the remote trusted realm, in a cross realm trust relationship.
        :param pulumi.Input[bool] enable_kerberos: Flag to indicate whether to Kerberize the cluster.
        :param pulumi.Input[str] kdc_db_key_uri: The Cloud Storage URI of a KMS encrypted file containing
               the master key of the KDC database.
        :param pulumi.Input[str] key_password_uri: The Cloud Storage URI of a KMS encrypted file containing
               the password to the user provided key. For the self-signed certificate, this password
               is generated by Dataproc.
        :param pulumi.Input[str] keystore_password_uri: The Cloud Storage URI of a KMS encrypted file containing
               the password to the user provided keystore. For the self-signed certificated, the password
               is generated by Dataproc.
        :param pulumi.Input[str] keystore_uri: The Cloud Storage URI of the keystore file used for SSL encryption.
               If not provided, Dataproc will provide a self-signed certificate.
        :param pulumi.Input[str] realm: The name of the on-cluster Kerberos realm. If not specified, the
               uppercased domain of hostnames will be the realm.
        :param pulumi.Input[int] tgt_lifetime_hours: The lifetime of the ticket granting ticket, in hours.
        :param pulumi.Input[str] truststore_password_uri: The Cloud Storage URI of a KMS encrypted file
               containing the password to the user provided truststore. For the self-signed
               certificate, this password is generated by Dataproc.
        :param pulumi.Input[str] truststore_uri: The Cloud Storage URI of the truststore file used for
               SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        pulumi.set(__self__, "kms_key_uri", kms_key_uri)
        pulumi.set(__self__, "root_principal_password_uri", root_principal_password_uri)
        if cross_realm_trust_admin_server is not None:
            pulumi.set(__self__, "cross_realm_trust_admin_server", cross_realm_trust_admin_server)
        if cross_realm_trust_kdc is not None:
            pulumi.set(__self__, "cross_realm_trust_kdc", cross_realm_trust_kdc)
        if cross_realm_trust_realm is not None:
            pulumi.set(__self__, "cross_realm_trust_realm", cross_realm_trust_realm)
        if cross_realm_trust_shared_password_uri is not None:
            pulumi.set(__self__, "cross_realm_trust_shared_password_uri", cross_realm_trust_shared_password_uri)
        if enable_kerberos is not None:
            pulumi.set(__self__, "enable_kerberos", enable_kerberos)
        if kdc_db_key_uri is not None:
            pulumi.set(__self__, "kdc_db_key_uri", kdc_db_key_uri)
        if key_password_uri is not None:
            pulumi.set(__self__, "key_password_uri", key_password_uri)
        if keystore_password_uri is not None:
            pulumi.set(__self__, "keystore_password_uri", keystore_password_uri)
        if keystore_uri is not None:
            pulumi.set(__self__, "keystore_uri", keystore_uri)
        if realm is not None:
            pulumi.set(__self__, "realm", realm)
        if tgt_lifetime_hours is not None:
            pulumi.set(__self__, "tgt_lifetime_hours", tgt_lifetime_hours)
        if truststore_password_uri is not None:
            pulumi.set(__self__, "truststore_password_uri", truststore_password_uri)
        if truststore_uri is not None:
            pulumi.set(__self__, "truststore_uri", truststore_uri)

    @property
    @pulumi.getter(name="kmsKeyUri")
    def kms_key_uri(self) -> pulumi.Input[str]:
        """
        The URI of the KMS key used to encrypt various sensitive files.
        """
        return pulumi.get(self, "kms_key_uri")

    @kms_key_uri.setter
    def kms_key_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_uri", value)

    @property
    @pulumi.getter(name="rootPrincipalPasswordUri")
    def root_principal_password_uri(self) -> pulumi.Input[str]:
        """
        The Cloud Storage URI of a KMS encrypted file
        containing the root principal password.
        """
        return pulumi.get(self, "root_principal_password_uri")

    @root_principal_password_uri.setter
    def root_principal_password_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "root_principal_password_uri", value)

    @property
    @pulumi.getter(name="crossRealmTrustAdminServer")
    def cross_realm_trust_admin_server(self) -> Optional[pulumi.Input[str]]:
        """
        The admin server (IP or hostname) for the
        remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_admin_server")

    @cross_realm_trust_admin_server.setter
    def cross_realm_trust_admin_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_realm_trust_admin_server", value)

    @property
    @pulumi.getter(name="crossRealmTrustKdc")
    def cross_realm_trust_kdc(self) -> Optional[pulumi.Input[str]]:
        """
        The KDC (IP or hostname) for the
        remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_kdc")

    @cross_realm_trust_kdc.setter
    def cross_realm_trust_kdc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_realm_trust_kdc", value)

    @property
    @pulumi.getter(name="crossRealmTrustRealm")
    def cross_realm_trust_realm(self) -> Optional[pulumi.Input[str]]:
        """
        The remote realm the Dataproc on-cluster KDC will
        trust, should the user enable cross realm trust.
        """
        return pulumi.get(self, "cross_realm_trust_realm")

    @cross_realm_trust_realm.setter
    def cross_realm_trust_realm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_realm_trust_realm", value)

    @property
    @pulumi.getter(name="crossRealmTrustSharedPasswordUri")
    def cross_realm_trust_shared_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage URI of a KMS
        encrypted file containing the shared password between the on-cluster Kerberos realm
        and the remote trusted realm, in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_shared_password_uri")

    @cross_realm_trust_shared_password_uri.setter
    def cross_realm_trust_shared_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_realm_trust_shared_password_uri", value)

    @property
    @pulumi.getter(name="enableKerberos")
    def enable_kerberos(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to indicate whether to Kerberize the cluster.
        """
        return pulumi.get(self, "enable_kerberos")

    @enable_kerberos.setter
    def enable_kerberos(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_kerberos", value)

    @property
    @pulumi.getter(name="kdcDbKeyUri")
    def kdc_db_key_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage URI of a KMS encrypted file containing
        the master key of the KDC database.
        """
        return pulumi.get(self, "kdc_db_key_uri")

    @kdc_db_key_uri.setter
    def kdc_db_key_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kdc_db_key_uri", value)

    @property
    @pulumi.getter(name="keyPasswordUri")
    def key_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage URI of a KMS encrypted file containing
        the password to the user provided key. For the self-signed certificate, this password
        is generated by Dataproc.
        """
        return pulumi.get(self, "key_password_uri")

    @key_password_uri.setter
    def key_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_password_uri", value)

    @property
    @pulumi.getter(name="keystorePasswordUri")
    def keystore_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage URI of a KMS encrypted file containing
        the password to the user provided keystore. For the self-signed certificated, the password
        is generated by Dataproc.
        """
        return pulumi.get(self, "keystore_password_uri")

    @keystore_password_uri.setter
    def keystore_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keystore_password_uri", value)

    @property
    @pulumi.getter(name="keystoreUri")
    def keystore_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage URI of the keystore file used for SSL encryption.
        If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "keystore_uri")

    @keystore_uri.setter
    def keystore_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keystore_uri", value)

    @property
    @pulumi.getter
    def realm(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the on-cluster Kerberos realm. If not specified, the
        uppercased domain of hostnames will be the realm.
        """
        return pulumi.get(self, "realm")

    @realm.setter
    def realm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "realm", value)

    @property
    @pulumi.getter(name="tgtLifetimeHours")
    def tgt_lifetime_hours(self) -> Optional[pulumi.Input[int]]:
        """
        The lifetime of the ticket granting ticket, in hours.
        """
        return pulumi.get(self, "tgt_lifetime_hours")

    @tgt_lifetime_hours.setter
    def tgt_lifetime_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tgt_lifetime_hours", value)

    @property
    @pulumi.getter(name="truststorePasswordUri")
    def truststore_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage URI of a KMS encrypted file
        containing the password to the user provided truststore. For the self-signed
        certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "truststore_password_uri")

    @truststore_password_uri.setter
    def truststore_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "truststore_password_uri", value)

    @property
    @pulumi.getter(name="truststoreUri")
    def truststore_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage URI of the truststore file used for
        SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "truststore_uri")

    @truststore_uri.setter
    def truststore_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "truststore_uri", value)


@pulumi.input_type
class ClusterClusterConfigSoftwareConfigArgs:
    def __init__(__self__, *,
                 image_version: Optional[pulumi.Input[str]] = None,
                 optional_components: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 override_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[str] image_version: The Cloud Dataproc image version to use
               for the cluster - this controls the sets of software versions
               installed onto the nodes when you create clusters. If not specified, defaults to the
               latest version. For a list of valid versions see
               [Cloud Dataproc versions](https://cloud.google.com/dataproc/docs/concepts/dataproc-versions)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] optional_components: The set of optional components to activate on the cluster.
               Accepted values are:
               * ANACONDA
               * DRUID
               * FLINK
               * HBASE
               * HIVE_WEBHCAT
               * JUPYTER
               * PRESTO
               * RANGER
               * SOLR
               * ZEPPELIN
               * ZOOKEEPER
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] override_properties: A list of override and additional properties (key/value pairs)
               used to modify various aspects of the common configuration files used when creating
               a cluster. For a list of valid properties please see
               [Cluster properties](https://cloud.google.com/dataproc/docs/concepts/cluster-properties)
        """
        if image_version is not None:
            pulumi.set(__self__, "image_version", image_version)
        if optional_components is not None:
            pulumi.set(__self__, "optional_components", optional_components)
        if override_properties is not None:
            pulumi.set(__self__, "override_properties", override_properties)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Dataproc image version to use
        for the cluster - this controls the sets of software versions
        installed onto the nodes when you create clusters. If not specified, defaults to the
        latest version. For a list of valid versions see
        [Cloud Dataproc versions](https://cloud.google.com/dataproc/docs/concepts/dataproc-versions)
        """
        return pulumi.get(self, "image_version")

    @image_version.setter
    def image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_version", value)

    @property
    @pulumi.getter(name="optionalComponents")
    def optional_components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of optional components to activate on the cluster.
        Accepted values are:
        * ANACONDA
        * DRUID
        * FLINK
        * HBASE
        * HIVE_WEBHCAT
        * JUPYTER
        * PRESTO
        * RANGER
        * SOLR
        * ZEPPELIN
        * ZOOKEEPER
        """
        return pulumi.get(self, "optional_components")

    @optional_components.setter
    def optional_components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "optional_components", value)

    @property
    @pulumi.getter(name="overrideProperties")
    def override_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A list of override and additional properties (key/value pairs)
        used to modify various aspects of the common configuration files used when creating
        a cluster. For a list of valid properties please see
        [Cluster properties](https://cloud.google.com/dataproc/docs/concepts/cluster-properties)
        """
        return pulumi.get(self, "override_properties")

    @override_properties.setter
    def override_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "override_properties", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class ClusterClusterConfigWorkerConfigArgs:
    def __init__(__self__, *,
                 accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterConfigWorkerConfigAcceleratorArgs']]]] = None,
                 disk_config: Optional[pulumi.Input['ClusterClusterConfigWorkerConfigDiskConfigArgs']] = None,
                 image_uri: Optional[pulumi.Input[str]] = None,
                 instance_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 num_instances: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ClusterClusterConfigWorkerConfigAcceleratorArgs']]] accelerators: The Compute Engine accelerator configuration for these instances. Can be specified multiple times.
        :param pulumi.Input['ClusterClusterConfigWorkerConfigDiskConfigArgs'] disk_config: Disk Config
        :param pulumi.Input[str] image_uri: The URI for the image to use for this worker.  See [the guide](https://cloud.google.com/dataproc/docs/guides/dataproc-images)
               for more information.
        :param pulumi.Input[str] machine_type: The name of a Google Compute Engine machine type
               to create for the worker nodes. If not specified, GCP will default to a predetermined
               computed value (currently `n1-standard-4`).
        :param pulumi.Input[str] min_cpu_platform: The name of a minimum generation of CPU family
               for the master. If not specified, GCP will default to a predetermined computed value
               for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
               for details about which CPU families are available (and defaulted) for each zone.
        :param pulumi.Input[int] num_instances: Specifies the number of preemptible nodes to create.
               Defaults to 0.
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterConfigWorkerConfigAcceleratorArgs']]]]:
        """
        The Compute Engine accelerator configuration for these instances. Can be specified multiple times.
        """
        return pulumi.get(self, "accelerators")

    @accelerators.setter
    def accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterConfigWorkerConfigAcceleratorArgs']]]]):
        pulumi.set(self, "accelerators", value)

    @property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional[pulumi.Input['ClusterClusterConfigWorkerConfigDiskConfigArgs']]:
        """
        Disk Config
        """
        return pulumi.get(self, "disk_config")

    @disk_config.setter
    def disk_config(self, value: Optional[pulumi.Input['ClusterClusterConfigWorkerConfigDiskConfigArgs']]):
        pulumi.set(self, "disk_config", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI for the image to use for this worker.  See [the guide](https://cloud.google.com/dataproc/docs/guides/dataproc-images)
        for more information.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_uri", value)

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "instance_names")

    @instance_names.setter
    def instance_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_names", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a Google Compute Engine machine type
        to create for the worker nodes. If not specified, GCP will default to a predetermined
        computed value (currently `n1-standard-4`).
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a minimum generation of CPU family
        for the master. If not specified, GCP will default to a predetermined computed value
        for each zone. See [the guide](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        for details about which CPU families are available (and defaulted) for each zone.
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of preemptible nodes to create.
        Defaults to 0.
        """
        return pulumi.get(self, "num_instances")

    @num_instances.setter
    def num_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_instances", value)


@pulumi.input_type
class ClusterClusterConfigWorkerConfigAcceleratorArgs:
    def __init__(__self__, *,
                 accelerator_count: pulumi.Input[int],
                 accelerator_type: pulumi.Input[str]):
        """
        :param pulumi.Input[int] accelerator_count: The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.
        :param pulumi.Input[str] accelerator_type: The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        pulumi.set(__self__, "accelerator_count", accelerator_count)
        pulumi.set(__self__, "accelerator_type", accelerator_type)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> pulumi.Input[int]:
        """
        The number of the accelerator cards of this type exposed to this instance. Often restricted to one of `1`, `2`, `4`, or `8`.
        """
        return pulumi.get(self, "accelerator_count")

    @accelerator_count.setter
    def accelerator_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "accelerator_count", value)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> pulumi.Input[str]:
        """
        The short name of the accelerator type to expose to this instance. For example, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "accelerator_type", value)


@pulumi.input_type
class ClusterClusterConfigWorkerConfigDiskConfigArgs:
    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 boot_disk_type: Optional[pulumi.Input[str]] = None,
                 num_local_ssds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] boot_disk_size_gb: Size of the primary disk attached to each preemptible worker node, specified
               in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
               computed value if not set (currently 500GB). Note: If SSDs are not
               attached, it also contains the HDFS data blocks and Hadoop working directories.
        :param pulumi.Input[str] boot_disk_type: The disk type of the primary disk attached to each preemptible worker node.
               One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        :param pulumi.Input[int] num_local_ssds: The amount of local SSD disks that will be
               attached to each preemptible worker node. Defaults to 0.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the primary disk attached to each preemptible worker node, specified
        in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined
        computed value if not set (currently 500GB). Note: If SSDs are not
        attached, it also contains the HDFS data blocks and Hadoop working directories.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @boot_disk_size_gb.setter
    def boot_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "boot_disk_size_gb", value)

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The disk type of the primary disk attached to each preemptible worker node.
        One of `"pd-ssd"` or `"pd-standard"`. Defaults to `"pd-standard"`.
        """
        return pulumi.get(self, "boot_disk_type")

    @boot_disk_type.setter
    def boot_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_disk_type", value)

    @property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of local SSD disks that will be
        attached to each preemptible worker node. Defaults to 0.
        """
        return pulumi.get(self, "num_local_ssds")

    @num_local_ssds.setter
    def num_local_ssds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_local_ssds", value)


@pulumi.input_type
class ClusterIAMBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class ClusterIAMMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class JobHadoopConfigArgs:
    def __init__(__self__, *,
                 archive_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['JobHadoopConfigLoggingConfigArgs']] = None,
                 main_class: Optional[pulumi.Input[str]] = None,
                 main_jar_file_uri: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] archive_uris: HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_uris: HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input[str] main_class: The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`. Conflicts with `main_jar_file_uri`
        :param pulumi.Input[str] main_jar_file_uri: The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'. Conflicts with `main_class`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_jar_file_uri is not None:
            pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @archive_uris.setter
    def archive_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "archive_uris", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @file_uris.setter
    def file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "file_uris", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['JobHadoopConfigLoggingConfigArgs']]:
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['JobHadoopConfigLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`. Conflicts with `main_jar_file_uri`
        """
        return pulumi.get(self, "main_class")

    @main_class.setter
    def main_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_class", value)

    @property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'. Conflicts with `main_class`
        """
        return pulumi.get(self, "main_jar_file_uri")

    @main_jar_file_uri.setter
    def main_jar_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_jar_file_uri", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class JobHadoopConfigLoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class JobHiveConfigArgs:
    def __init__(__self__, *,
                 continue_on_failure: Optional[pulumi.Input[bool]] = None,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 query_file_uri: Optional[pulumi.Input[str]] = None,
                 query_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 script_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[bool] continue_on_failure: Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        :param pulumi.Input[str] query_file_uri: The HCFS URI of the script that contains SQL queries.
               Conflicts with `query_list`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] query_lists: The list of SQL queries or statements to execute as part of the job.
               Conflicts with `query_file_uri`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] script_variables: Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        """
        return pulumi.get(self, "continue_on_failure")

    @continue_on_failure.setter
    def continue_on_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continue_on_failure", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the script that contains SQL queries.
        Conflicts with `query_list`
        """
        return pulumi.get(self, "query_file_uri")

    @query_file_uri.setter
    def query_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_file_uri", value)

    @property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of SQL queries or statements to execute as part of the job.
        Conflicts with `query_file_uri`
        """
        return pulumi.get(self, "query_lists")

    @query_lists.setter
    def query_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "query_lists", value)

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        return pulumi.get(self, "script_variables")

    @script_variables.setter
    def script_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "script_variables", value)


@pulumi.input_type
class JobIAMBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class JobIAMMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class JobPigConfigArgs:
    def __init__(__self__, *,
                 continue_on_failure: Optional[pulumi.Input[bool]] = None,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['JobPigConfigLoggingConfigArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 query_file_uri: Optional[pulumi.Input[str]] = None,
                 query_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 script_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[bool] continue_on_failure: Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        :param pulumi.Input[str] query_file_uri: The HCFS URI of the script that contains SQL queries.
               Conflicts with `query_list`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] query_lists: The list of SQL queries or statements to execute as part of the job.
               Conflicts with `query_file_uri`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] script_variables: Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
        """
        return pulumi.get(self, "continue_on_failure")

    @continue_on_failure.setter
    def continue_on_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continue_on_failure", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['JobPigConfigLoggingConfigArgs']]:
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['JobPigConfigLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the script that contains SQL queries.
        Conflicts with `query_list`
        """
        return pulumi.get(self, "query_file_uri")

    @query_file_uri.setter
    def query_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_file_uri", value)

    @property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of SQL queries or statements to execute as part of the job.
        Conflicts with `query_file_uri`
        """
        return pulumi.get(self, "query_lists")

    @query_lists.setter
    def query_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "query_lists", value)

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        return pulumi.get(self, "script_variables")

    @script_variables.setter
    def script_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "script_variables", value)


@pulumi.input_type
class JobPigConfigLoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class JobPlacementArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[str],
                 cluster_uuid: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_uuid is not None:
            pulumi.set(__self__, "cluster_uuid", cluster_uuid)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cluster_uuid")

    @cluster_uuid.setter
    def cluster_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_uuid", value)


@pulumi.input_type
class JobPysparkConfigArgs:
    def __init__(__self__, *,
                 main_python_file_uri: pulumi.Input[str],
                 archive_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['JobPysparkConfigLoggingConfigArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 python_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] main_python_file_uri: The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] archive_uris: HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_uris: HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] python_file_uris: HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        pulumi.set(__self__, "main_python_file_uri", main_python_file_uri)
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if python_file_uris is not None:
            pulumi.set(__self__, "python_file_uris", python_file_uris)

    @property
    @pulumi.getter(name="mainPythonFileUri")
    def main_python_file_uri(self) -> pulumi.Input[str]:
        """
        The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        """
        return pulumi.get(self, "main_python_file_uri")

    @main_python_file_uri.setter
    def main_python_file_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "main_python_file_uri", value)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @archive_uris.setter
    def archive_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "archive_uris", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @file_uris.setter
    def file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "file_uris", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['JobPysparkConfigLoggingConfigArgs']]:
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['JobPysparkConfigLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="pythonFileUris")
    def python_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        return pulumi.get(self, "python_file_uris")

    @python_file_uris.setter
    def python_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "python_file_uris", value)


@pulumi.input_type
class JobPysparkConfigLoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class JobReferenceArgs:
    def __init__(__self__, *,
                 job_id: Optional[pulumi.Input[str]] = None):
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_id", value)


@pulumi.input_type
class JobSchedulingArgs:
    def __init__(__self__, *,
                 max_failures_per_hour: pulumi.Input[int],
                 max_failures_total: pulumi.Input[int]):
        pulumi.set(__self__, "max_failures_per_hour", max_failures_per_hour)
        pulumi.set(__self__, "max_failures_total", max_failures_total)

    @property
    @pulumi.getter(name="maxFailuresPerHour")
    def max_failures_per_hour(self) -> pulumi.Input[int]:
        return pulumi.get(self, "max_failures_per_hour")

    @max_failures_per_hour.setter
    def max_failures_per_hour(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_failures_per_hour", value)

    @property
    @pulumi.getter(name="maxFailuresTotal")
    def max_failures_total(self) -> pulumi.Input[int]:
        return pulumi.get(self, "max_failures_total")

    @max_failures_total.setter
    def max_failures_total(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_failures_total", value)


@pulumi.input_type
class JobSparkConfigArgs:
    def __init__(__self__, *,
                 archive_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['JobSparkConfigLoggingConfigArgs']] = None,
                 main_class: Optional[pulumi.Input[str]] = None,
                 main_jar_file_uri: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] archive_uris: HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_uris: HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input[str] main_class: The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`. Conflicts with `main_jar_file_uri`
        :param pulumi.Input[str] main_jar_file_uri: The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'. Conflicts with `main_class`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_jar_file_uri is not None:
            pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @archive_uris.setter
    def archive_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "archive_uris", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        HCFS URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @file_uris.setter
    def file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "file_uris", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['JobSparkConfigLoggingConfigArgs']]:
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['JobSparkConfigLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`. Conflicts with `main_jar_file_uri`
        """
        return pulumi.get(self, "main_class")

    @main_class.setter
    def main_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_class", value)

    @property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'. Conflicts with `main_class`
        """
        return pulumi.get(self, "main_jar_file_uri")

    @main_jar_file_uri.setter
    def main_jar_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_jar_file_uri", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class JobSparkConfigLoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class JobSparksqlConfigArgs:
    def __init__(__self__, *,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['JobSparksqlConfigLoggingConfigArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 query_file_uri: Optional[pulumi.Input[str]] = None,
                 query_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 script_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        :param pulumi.Input[str] query_file_uri: The HCFS URI of the script that contains SQL queries.
               Conflicts with `query_list`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] query_lists: The list of SQL queries or statements to execute as part of the job.
               Conflicts with `query_file_uri`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] script_variables: Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_lists is not None:
            pulumi.set(__self__, "query_lists", query_lists)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['JobSparksqlConfigLoggingConfigArgs']]:
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['JobSparksqlConfigLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the script that contains SQL queries.
        Conflicts with `query_list`
        """
        return pulumi.get(self, "query_file_uri")

    @query_file_uri.setter
    def query_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_file_uri", value)

    @property
    @pulumi.getter(name="queryLists")
    def query_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of SQL queries or statements to execute as part of the job.
        Conflicts with `query_file_uri`
        """
        return pulumi.get(self, "query_lists")

    @query_lists.setter
    def query_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "query_lists", value)

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping of query variable names to values (equivalent to the Spark SQL command: `SET name="value";`).
        """
        return pulumi.get(self, "script_variables")

    @script_variables.setter
    def script_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "script_variables", value)


@pulumi.input_type
class JobSparksqlConfigLoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class JobStatusArgs:
    def __init__(__self__, *,
                 details: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 state_start_time: Optional[pulumi.Input[str]] = None,
                 substate: Optional[pulumi.Input[str]] = None):
        if details is not None:
            pulumi.set(__self__, "details", details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_start_time is not None:
            pulumi.set(__self__, "state_start_time", state_start_time)
        if substate is not None:
            pulumi.set(__self__, "substate", substate)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateStartTime")
    def state_start_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state_start_time")

    @state_start_time.setter
    def state_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_start_time", value)

    @property
    @pulumi.getter
    def substate(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "substate")

    @substate.setter
    def substate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "substate", value)


@pulumi.input_type
class MetastoreServiceHiveMetastoreConfigArgs:
    def __init__(__self__, *,
                 version: pulumi.Input[str],
                 config_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 kerberos_config: Optional[pulumi.Input['MetastoreServiceHiveMetastoreConfigKerberosConfigArgs']] = None):
        """
        :param pulumi.Input[str] version: The Hive metastore schema version.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] config_overrides: A mapping of Hive metastore configuration key-value pairs to apply to the Hive metastore (configured in hive-site.xml).
               The mappings override system defaults (some keys cannot be overridden)
        :param pulumi.Input['MetastoreServiceHiveMetastoreConfigKerberosConfigArgs'] kerberos_config: Information used to configure the Hive metastore service as a service principal in a Kerberos realm.
               Structure is documented below.
        """
        pulumi.set(__self__, "version", version)
        if config_overrides is not None:
            pulumi.set(__self__, "config_overrides", config_overrides)
        if kerberos_config is not None:
            pulumi.set(__self__, "kerberos_config", kerberos_config)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        The Hive metastore schema version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="configOverrides")
    def config_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of Hive metastore configuration key-value pairs to apply to the Hive metastore (configured in hive-site.xml).
        The mappings override system defaults (some keys cannot be overridden)
        """
        return pulumi.get(self, "config_overrides")

    @config_overrides.setter
    def config_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "config_overrides", value)

    @property
    @pulumi.getter(name="kerberosConfig")
    def kerberos_config(self) -> Optional[pulumi.Input['MetastoreServiceHiveMetastoreConfigKerberosConfigArgs']]:
        """
        Information used to configure the Hive metastore service as a service principal in a Kerberos realm.
        Structure is documented below.
        """
        return pulumi.get(self, "kerberos_config")

    @kerberos_config.setter
    def kerberos_config(self, value: Optional[pulumi.Input['MetastoreServiceHiveMetastoreConfigKerberosConfigArgs']]):
        pulumi.set(self, "kerberos_config", value)


@pulumi.input_type
class MetastoreServiceHiveMetastoreConfigKerberosConfigArgs:
    def __init__(__self__, *,
                 keytab: pulumi.Input['MetastoreServiceHiveMetastoreConfigKerberosConfigKeytabArgs'],
                 krb5_config_gcs_uri: pulumi.Input[str],
                 principal: pulumi.Input[str]):
        """
        :param pulumi.Input['MetastoreServiceHiveMetastoreConfigKerberosConfigKeytabArgs'] keytab: A Kerberos keytab file that can be used to authenticate a service principal with a Kerberos Key Distribution Center (KDC).
               Structure is documented below.
        :param pulumi.Input[str] krb5_config_gcs_uri: A Cloud Storage URI that specifies the path to a krb5.conf file. It is of the form gs://{bucket_name}/path/to/krb5.conf, although the file does not need to be named krb5.conf explicitly.
        :param pulumi.Input[str] principal: A Kerberos principal that exists in the both the keytab the KDC to authenticate as. A typical principal is of the form "primary/instance@REALM", but there is no exact format.
        """
        pulumi.set(__self__, "keytab", keytab)
        pulumi.set(__self__, "krb5_config_gcs_uri", krb5_config_gcs_uri)
        pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def keytab(self) -> pulumi.Input['MetastoreServiceHiveMetastoreConfigKerberosConfigKeytabArgs']:
        """
        A Kerberos keytab file that can be used to authenticate a service principal with a Kerberos Key Distribution Center (KDC).
        Structure is documented below.
        """
        return pulumi.get(self, "keytab")

    @keytab.setter
    def keytab(self, value: pulumi.Input['MetastoreServiceHiveMetastoreConfigKerberosConfigKeytabArgs']):
        pulumi.set(self, "keytab", value)

    @property
    @pulumi.getter(name="krb5ConfigGcsUri")
    def krb5_config_gcs_uri(self) -> pulumi.Input[str]:
        """
        A Cloud Storage URI that specifies the path to a krb5.conf file. It is of the form gs://{bucket_name}/path/to/krb5.conf, although the file does not need to be named krb5.conf explicitly.
        """
        return pulumi.get(self, "krb5_config_gcs_uri")

    @krb5_config_gcs_uri.setter
    def krb5_config_gcs_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "krb5_config_gcs_uri", value)

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Input[str]:
        """
        A Kerberos principal that exists in the both the keytab the KDC to authenticate as. A typical principal is of the form "primary/instance@REALM", but there is no exact format.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal", value)


@pulumi.input_type
class MetastoreServiceHiveMetastoreConfigKerberosConfigKeytabArgs:
    def __init__(__self__, *,
                 cloud_secret: pulumi.Input[str]):
        """
        :param pulumi.Input[str] cloud_secret: The relative resource name of a Secret Manager secret version, in the following form:
               "projects/{projectNumber}/secrets/{secret_id}/versions/{version_id}".
        """
        pulumi.set(__self__, "cloud_secret", cloud_secret)

    @property
    @pulumi.getter(name="cloudSecret")
    def cloud_secret(self) -> pulumi.Input[str]:
        """
        The relative resource name of a Secret Manager secret version, in the following form:
        "projects/{projectNumber}/secrets/{secret_id}/versions/{version_id}".
        """
        return pulumi.get(self, "cloud_secret")

    @cloud_secret.setter
    def cloud_secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloud_secret", value)


@pulumi.input_type
class MetastoreServiceMaintenanceWindowArgs:
    def __init__(__self__, *,
                 day_of_week: pulumi.Input[str],
                 hour_of_day: pulumi.Input[int]):
        """
        :param pulumi.Input[str] day_of_week: The day of week, when the window starts.
               Possible values are `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, and `SUNDAY`.
        :param pulumi.Input[int] hour_of_day: The hour of day (0-23) when the window starts.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "hour_of_day", hour_of_day)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> pulumi.Input[str]:
        """
        The day of week, when the window starts.
        Possible values are `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, and `SUNDAY`.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: pulumi.Input[str]):
        pulumi.set(self, "day_of_week", value)

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> pulumi.Input[int]:
        """
        The hour of day (0-23) when the window starts.
        """
        return pulumi.get(self, "hour_of_day")

    @hour_of_day.setter
    def hour_of_day(self, value: pulumi.Input[int]):
        pulumi.set(self, "hour_of_day", value)


@pulumi.input_type
class WorkflowTemplateJobArgs:
    def __init__(__self__, *,
                 step_id: pulumi.Input[str],
                 hadoop_job: Optional[pulumi.Input['WorkflowTemplateJobHadoopJobArgs']] = None,
                 hive_job: Optional[pulumi.Input['WorkflowTemplateJobHiveJobArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 pig_job: Optional[pulumi.Input['WorkflowTemplateJobPigJobArgs']] = None,
                 prerequisite_step_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 presto_job: Optional[pulumi.Input['WorkflowTemplateJobPrestoJobArgs']] = None,
                 pyspark_job: Optional[pulumi.Input['WorkflowTemplateJobPysparkJobArgs']] = None,
                 scheduling: Optional[pulumi.Input['WorkflowTemplateJobSchedulingArgs']] = None,
                 spark_job: Optional[pulumi.Input['WorkflowTemplateJobSparkJobArgs']] = None,
                 spark_r_job: Optional[pulumi.Input['WorkflowTemplateJobSparkRJobArgs']] = None,
                 spark_sql_job: Optional[pulumi.Input['WorkflowTemplateJobSparkSqlJobArgs']] = None):
        """
        :param pulumi.Input[str] step_id: Required. The step id. The id must be unique among all jobs within the template. The step id is used as prefix for job id, as job `goog-dataproc-workflow-step-id` label, and in field from other steps. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between 3 and 50 characters.
        :param pulumi.Input['WorkflowTemplateJobHadoopJobArgs'] hadoop_job: Optional. Job is a Hadoop job.
        :param pulumi.Input['WorkflowTemplateJobHiveJobArgs'] hive_job: Optional. Job is a Hive job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. The labels to associate with this cluster. Label keys must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: {0,63} No more than 32 labels can be associated with a given cluster.
        :param pulumi.Input['WorkflowTemplateJobPigJobArgs'] pig_job: Optional. Job is a Pig job.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prerequisite_step_ids: Optional. The optional list of prerequisite job step_ids. If not specified, the job will start at the beginning of workflow.
        :param pulumi.Input['WorkflowTemplateJobPrestoJobArgs'] presto_job: Optional. Job is a Presto job.
        :param pulumi.Input['WorkflowTemplateJobPysparkJobArgs'] pyspark_job: Optional. Job is a PySpark job.
        :param pulumi.Input['WorkflowTemplateJobSchedulingArgs'] scheduling: Optional. Job scheduling configuration.
        :param pulumi.Input['WorkflowTemplateJobSparkJobArgs'] spark_job: Optional. Job is a Spark job.
        :param pulumi.Input['WorkflowTemplateJobSparkRJobArgs'] spark_r_job: Optional. Job is a SparkR job.
        :param pulumi.Input['WorkflowTemplateJobSparkSqlJobArgs'] spark_sql_job: Optional. Job is a SparkSql job.
        """
        pulumi.set(__self__, "step_id", step_id)
        if hadoop_job is not None:
            pulumi.set(__self__, "hadoop_job", hadoop_job)
        if hive_job is not None:
            pulumi.set(__self__, "hive_job", hive_job)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if pig_job is not None:
            pulumi.set(__self__, "pig_job", pig_job)
        if prerequisite_step_ids is not None:
            pulumi.set(__self__, "prerequisite_step_ids", prerequisite_step_ids)
        if presto_job is not None:
            pulumi.set(__self__, "presto_job", presto_job)
        if pyspark_job is not None:
            pulumi.set(__self__, "pyspark_job", pyspark_job)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if spark_job is not None:
            pulumi.set(__self__, "spark_job", spark_job)
        if spark_r_job is not None:
            pulumi.set(__self__, "spark_r_job", spark_r_job)
        if spark_sql_job is not None:
            pulumi.set(__self__, "spark_sql_job", spark_sql_job)

    @property
    @pulumi.getter(name="stepId")
    def step_id(self) -> pulumi.Input[str]:
        """
        Required. The step id. The id must be unique among all jobs within the template. The step id is used as prefix for job id, as job `goog-dataproc-workflow-step-id` label, and in field from other steps. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between 3 and 50 characters.
        """
        return pulumi.get(self, "step_id")

    @step_id.setter
    def step_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "step_id", value)

    @property
    @pulumi.getter(name="hadoopJob")
    def hadoop_job(self) -> Optional[pulumi.Input['WorkflowTemplateJobHadoopJobArgs']]:
        """
        Optional. Job is a Hadoop job.
        """
        return pulumi.get(self, "hadoop_job")

    @hadoop_job.setter
    def hadoop_job(self, value: Optional[pulumi.Input['WorkflowTemplateJobHadoopJobArgs']]):
        pulumi.set(self, "hadoop_job", value)

    @property
    @pulumi.getter(name="hiveJob")
    def hive_job(self) -> Optional[pulumi.Input['WorkflowTemplateJobHiveJobArgs']]:
        """
        Optional. Job is a Hive job.
        """
        return pulumi.get(self, "hive_job")

    @hive_job.setter
    def hive_job(self, value: Optional[pulumi.Input['WorkflowTemplateJobHiveJobArgs']]):
        pulumi.set(self, "hive_job", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The labels to associate with this cluster. Label keys must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: {0,63} No more than 32 labels can be associated with a given cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="pigJob")
    def pig_job(self) -> Optional[pulumi.Input['WorkflowTemplateJobPigJobArgs']]:
        """
        Optional. Job is a Pig job.
        """
        return pulumi.get(self, "pig_job")

    @pig_job.setter
    def pig_job(self, value: Optional[pulumi.Input['WorkflowTemplateJobPigJobArgs']]):
        pulumi.set(self, "pig_job", value)

    @property
    @pulumi.getter(name="prerequisiteStepIds")
    def prerequisite_step_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The optional list of prerequisite job step_ids. If not specified, the job will start at the beginning of workflow.
        """
        return pulumi.get(self, "prerequisite_step_ids")

    @prerequisite_step_ids.setter
    def prerequisite_step_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prerequisite_step_ids", value)

    @property
    @pulumi.getter(name="prestoJob")
    def presto_job(self) -> Optional[pulumi.Input['WorkflowTemplateJobPrestoJobArgs']]:
        """
        Optional. Job is a Presto job.
        """
        return pulumi.get(self, "presto_job")

    @presto_job.setter
    def presto_job(self, value: Optional[pulumi.Input['WorkflowTemplateJobPrestoJobArgs']]):
        pulumi.set(self, "presto_job", value)

    @property
    @pulumi.getter(name="pysparkJob")
    def pyspark_job(self) -> Optional[pulumi.Input['WorkflowTemplateJobPysparkJobArgs']]:
        """
        Optional. Job is a PySpark job.
        """
        return pulumi.get(self, "pyspark_job")

    @pyspark_job.setter
    def pyspark_job(self, value: Optional[pulumi.Input['WorkflowTemplateJobPysparkJobArgs']]):
        pulumi.set(self, "pyspark_job", value)

    @property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['WorkflowTemplateJobSchedulingArgs']]:
        """
        Optional. Job scheduling configuration.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['WorkflowTemplateJobSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @property
    @pulumi.getter(name="sparkJob")
    def spark_job(self) -> Optional[pulumi.Input['WorkflowTemplateJobSparkJobArgs']]:
        """
        Optional. Job is a Spark job.
        """
        return pulumi.get(self, "spark_job")

    @spark_job.setter
    def spark_job(self, value: Optional[pulumi.Input['WorkflowTemplateJobSparkJobArgs']]):
        pulumi.set(self, "spark_job", value)

    @property
    @pulumi.getter(name="sparkRJob")
    def spark_r_job(self) -> Optional[pulumi.Input['WorkflowTemplateJobSparkRJobArgs']]:
        """
        Optional. Job is a SparkR job.
        """
        return pulumi.get(self, "spark_r_job")

    @spark_r_job.setter
    def spark_r_job(self, value: Optional[pulumi.Input['WorkflowTemplateJobSparkRJobArgs']]):
        pulumi.set(self, "spark_r_job", value)

    @property
    @pulumi.getter(name="sparkSqlJob")
    def spark_sql_job(self) -> Optional[pulumi.Input['WorkflowTemplateJobSparkSqlJobArgs']]:
        """
        Optional. Job is a SparkSql job.
        """
        return pulumi.get(self, "spark_sql_job")

    @spark_sql_job.setter
    def spark_sql_job(self, value: Optional[pulumi.Input['WorkflowTemplateJobSparkSqlJobArgs']]):
        pulumi.set(self, "spark_sql_job", value)


@pulumi.input_type
class WorkflowTemplateJobHadoopJobArgs:
    def __init__(__self__, *,
                 archive_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['WorkflowTemplateJobHadoopJobLoggingConfigArgs']] = None,
                 main_class: Optional[pulumi.Input[str]] = None,
                 main_jar_file_uri: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] archive_uris: Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Optional. The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_uris: Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input['WorkflowTemplateJobHadoopJobLoggingConfigArgs'] logging_config: Optional. The runtime log config for job execution.
        :param pulumi.Input[str] main_class: The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in `jar_file_uris`.
        :param pulumi.Input[str] main_jar_file_uri: The HCFS URI of the jar file that contains the main class.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_jar_file_uri is not None:
            pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @archive_uris.setter
    def archive_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "archive_uris", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @file_uris.setter
    def file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "file_uris", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['WorkflowTemplateJobHadoopJobLoggingConfigArgs']]:
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['WorkflowTemplateJobHadoopJobLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in `jar_file_uris`.
        """
        return pulumi.get(self, "main_class")

    @main_class.setter
    def main_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_class", value)

    @property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the jar file that contains the main class.
        """
        return pulumi.get(self, "main_jar_file_uri")

    @main_jar_file_uri.setter
    def main_jar_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_jar_file_uri", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class WorkflowTemplateJobHadoopJobLoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] driver_log_levels: The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        if driver_log_levels is not None:
            pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class WorkflowTemplateJobHiveJobArgs:
    def __init__(__self__, *,
                 continue_on_failure: Optional[pulumi.Input[bool]] = None,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 query_file_uri: Optional[pulumi.Input[str]] = None,
                 query_list: Optional[pulumi.Input['WorkflowTemplateJobHiveJobQueryListArgs']] = None,
                 script_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[bool] continue_on_failure: Optional. Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        :param pulumi.Input[str] query_file_uri: The HCFS URI of the script that contains SQL queries.
        :param pulumi.Input['WorkflowTemplateJobHiveJobQueryListArgs'] query_list: A list of queries.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] script_variables: Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET `name="value";`).
        """
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_list is not None:
            pulumi.set(__self__, "query_list", query_list)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
        """
        return pulumi.get(self, "continue_on_failure")

    @continue_on_failure.setter
    def continue_on_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continue_on_failure", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the script that contains SQL queries.
        """
        return pulumi.get(self, "query_file_uri")

    @query_file_uri.setter
    def query_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_file_uri", value)

    @property
    @pulumi.getter(name="queryList")
    def query_list(self) -> Optional[pulumi.Input['WorkflowTemplateJobHiveJobQueryListArgs']]:
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    @query_list.setter
    def query_list(self, value: Optional[pulumi.Input['WorkflowTemplateJobHiveJobQueryListArgs']]):
        pulumi.set(self, "query_list", value)

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET `name="value";`).
        """
        return pulumi.get(self, "script_variables")

    @script_variables.setter
    def script_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "script_variables", value)


@pulumi.input_type
class WorkflowTemplateJobHiveJobQueryListArgs:
    def __init__(__self__, *,
                 queries: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] queries: Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": } }
        """
        pulumi.set(__self__, "queries", queries)

    @property
    @pulumi.getter
    def queries(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": } }
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "queries", value)


@pulumi.input_type
class WorkflowTemplateJobPigJobArgs:
    def __init__(__self__, *,
                 continue_on_failure: Optional[pulumi.Input[bool]] = None,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['WorkflowTemplateJobPigJobLoggingConfigArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 query_file_uri: Optional[pulumi.Input[str]] = None,
                 query_list: Optional[pulumi.Input['WorkflowTemplateJobPigJobQueryListArgs']] = None,
                 script_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[bool] continue_on_failure: Optional. Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input['WorkflowTemplateJobPigJobLoggingConfigArgs'] logging_config: Optional. The runtime log config for job execution.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        :param pulumi.Input[str] query_file_uri: The HCFS URI of the script that contains SQL queries.
        :param pulumi.Input['WorkflowTemplateJobPigJobQueryListArgs'] query_list: A list of queries.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] script_variables: Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET `name="value";`).
        """
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_list is not None:
            pulumi.set(__self__, "query_list", query_list)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
        """
        return pulumi.get(self, "continue_on_failure")

    @continue_on_failure.setter
    def continue_on_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continue_on_failure", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['WorkflowTemplateJobPigJobLoggingConfigArgs']]:
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['WorkflowTemplateJobPigJobLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the script that contains SQL queries.
        """
        return pulumi.get(self, "query_file_uri")

    @query_file_uri.setter
    def query_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_file_uri", value)

    @property
    @pulumi.getter(name="queryList")
    def query_list(self) -> Optional[pulumi.Input['WorkflowTemplateJobPigJobQueryListArgs']]:
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    @query_list.setter
    def query_list(self, value: Optional[pulumi.Input['WorkflowTemplateJobPigJobQueryListArgs']]):
        pulumi.set(self, "query_list", value)

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET `name="value";`).
        """
        return pulumi.get(self, "script_variables")

    @script_variables.setter
    def script_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "script_variables", value)


@pulumi.input_type
class WorkflowTemplateJobPigJobLoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] driver_log_levels: The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        if driver_log_levels is not None:
            pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class WorkflowTemplateJobPigJobQueryListArgs:
    def __init__(__self__, *,
                 queries: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] queries: Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": } }
        """
        pulumi.set(__self__, "queries", queries)

    @property
    @pulumi.getter
    def queries(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": } }
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "queries", value)


@pulumi.input_type
class WorkflowTemplateJobPrestoJobArgs:
    def __init__(__self__, *,
                 client_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 continue_on_failure: Optional[pulumi.Input[bool]] = None,
                 logging_config: Optional[pulumi.Input['WorkflowTemplateJobPrestoJobLoggingConfigArgs']] = None,
                 output_format: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 query_file_uri: Optional[pulumi.Input[str]] = None,
                 query_list: Optional[pulumi.Input['WorkflowTemplateJobPrestoJobQueryListArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] client_tags: Optional. Presto client tags to attach to this query
        :param pulumi.Input[bool] continue_on_failure: Optional. Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
        :param pulumi.Input['WorkflowTemplateJobPrestoJobLoggingConfigArgs'] logging_config: Optional. The runtime log config for job execution.
        :param pulumi.Input[str] output_format: Optional. The format in which query output will be displayed. See the Presto documentation for supported output formats
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        :param pulumi.Input[str] query_file_uri: The HCFS URI of the script that contains SQL queries.
        :param pulumi.Input['WorkflowTemplateJobPrestoJobQueryListArgs'] query_list: A list of queries.
        """
        if client_tags is not None:
            pulumi.set(__self__, "client_tags", client_tags)
        if continue_on_failure is not None:
            pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if output_format is not None:
            pulumi.set(__self__, "output_format", output_format)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_list is not None:
            pulumi.set(__self__, "query_list", query_list)

    @property
    @pulumi.getter(name="clientTags")
    def client_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. Presto client tags to attach to this query
        """
        return pulumi.get(self, "client_tags")

    @client_tags.setter
    def client_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "client_tags", value)

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
        """
        return pulumi.get(self, "continue_on_failure")

    @continue_on_failure.setter
    def continue_on_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continue_on_failure", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['WorkflowTemplateJobPrestoJobLoggingConfigArgs']]:
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['WorkflowTemplateJobPrestoJobLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The format in which query output will be displayed. See the Presto documentation for supported output formats
        """
        return pulumi.get(self, "output_format")

    @output_format.setter
    def output_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_format", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the script that contains SQL queries.
        """
        return pulumi.get(self, "query_file_uri")

    @query_file_uri.setter
    def query_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_file_uri", value)

    @property
    @pulumi.getter(name="queryList")
    def query_list(self) -> Optional[pulumi.Input['WorkflowTemplateJobPrestoJobQueryListArgs']]:
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    @query_list.setter
    def query_list(self, value: Optional[pulumi.Input['WorkflowTemplateJobPrestoJobQueryListArgs']]):
        pulumi.set(self, "query_list", value)


@pulumi.input_type
class WorkflowTemplateJobPrestoJobLoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] driver_log_levels: The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        if driver_log_levels is not None:
            pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class WorkflowTemplateJobPrestoJobQueryListArgs:
    def __init__(__self__, *,
                 queries: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] queries: Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": } }
        """
        pulumi.set(__self__, "queries", queries)

    @property
    @pulumi.getter
    def queries(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": } }
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "queries", value)


@pulumi.input_type
class WorkflowTemplateJobPysparkJobArgs:
    def __init__(__self__, *,
                 main_python_file_uri: pulumi.Input[str],
                 archive_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['WorkflowTemplateJobPysparkJobLoggingConfigArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 python_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] main_python_file_uri: Required. The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] archive_uris: Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Optional. The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_uris: Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input['WorkflowTemplateJobPysparkJobLoggingConfigArgs'] logging_config: Optional. The runtime log config for job execution.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] python_file_uris: Optional. HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        pulumi.set(__self__, "main_python_file_uri", main_python_file_uri)
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if python_file_uris is not None:
            pulumi.set(__self__, "python_file_uris", python_file_uris)

    @property
    @pulumi.getter(name="mainPythonFileUri")
    def main_python_file_uri(self) -> pulumi.Input[str]:
        """
        Required. The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        """
        return pulumi.get(self, "main_python_file_uri")

    @main_python_file_uri.setter
    def main_python_file_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "main_python_file_uri", value)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @archive_uris.setter
    def archive_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "archive_uris", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @file_uris.setter
    def file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "file_uris", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['WorkflowTemplateJobPysparkJobLoggingConfigArgs']]:
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['WorkflowTemplateJobPysparkJobLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="pythonFileUris")
    def python_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        return pulumi.get(self, "python_file_uris")

    @python_file_uris.setter
    def python_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "python_file_uris", value)


@pulumi.input_type
class WorkflowTemplateJobPysparkJobLoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] driver_log_levels: The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        if driver_log_levels is not None:
            pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class WorkflowTemplateJobSchedulingArgs:
    def __init__(__self__, *,
                 max_failures_per_hour: Optional[pulumi.Input[int]] = None,
                 max_failures_total: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] max_failures_per_hour: Optional. Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. A job may be reported as thrashing if driver exits with non-zero code 4 times within 10 minute window. Maximum value is 10.
        :param pulumi.Input[int] max_failures_total: Optional. Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. Maximum value is 240
        """
        if max_failures_per_hour is not None:
            pulumi.set(__self__, "max_failures_per_hour", max_failures_per_hour)
        if max_failures_total is not None:
            pulumi.set(__self__, "max_failures_total", max_failures_total)

    @property
    @pulumi.getter(name="maxFailuresPerHour")
    def max_failures_per_hour(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. A job may be reported as thrashing if driver exits with non-zero code 4 times within 10 minute window. Maximum value is 10.
        """
        return pulumi.get(self, "max_failures_per_hour")

    @max_failures_per_hour.setter
    def max_failures_per_hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_failures_per_hour", value)

    @property
    @pulumi.getter(name="maxFailuresTotal")
    def max_failures_total(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. Maximum value is 240
        """
        return pulumi.get(self, "max_failures_total")

    @max_failures_total.setter
    def max_failures_total(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_failures_total", value)


@pulumi.input_type
class WorkflowTemplateJobSparkJobArgs:
    def __init__(__self__, *,
                 archive_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['WorkflowTemplateJobSparkJobLoggingConfigArgs']] = None,
                 main_class: Optional[pulumi.Input[str]] = None,
                 main_jar_file_uri: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] archive_uris: Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Optional. The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_uris: Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input['WorkflowTemplateJobSparkJobLoggingConfigArgs'] logging_config: Optional. The runtime log config for job execution.
        :param pulumi.Input[str] main_class: The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in `jar_file_uris`.
        :param pulumi.Input[str] main_jar_file_uri: The HCFS URI of the jar file that contains the main class.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if main_jar_file_uri is not None:
            pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @archive_uris.setter
    def archive_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "archive_uris", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @file_uris.setter
    def file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "file_uris", value)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['WorkflowTemplateJobSparkJobLoggingConfigArgs']]:
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['WorkflowTemplateJobSparkJobLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in `jar_file_uris`.
        """
        return pulumi.get(self, "main_class")

    @main_class.setter
    def main_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_class", value)

    @property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the jar file that contains the main class.
        """
        return pulumi.get(self, "main_jar_file_uri")

    @main_jar_file_uri.setter
    def main_jar_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_jar_file_uri", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class WorkflowTemplateJobSparkJobLoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] driver_log_levels: The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        if driver_log_levels is not None:
            pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class WorkflowTemplateJobSparkRJobArgs:
    def __init__(__self__, *,
                 main_r_file_uri: pulumi.Input[str],
                 archive_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['WorkflowTemplateJobSparkRJobLoggingConfigArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] main_r_file_uri: Required. The HCFS URI of the main R file to use as the driver. Must be a .R file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] archive_uris: Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Optional. The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_uris: Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        :param pulumi.Input['WorkflowTemplateJobSparkRJobLoggingConfigArgs'] logging_config: Optional. The runtime log config for job execution.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        pulumi.set(__self__, "main_r_file_uri", main_r_file_uri)
        if archive_uris is not None:
            pulumi.set(__self__, "archive_uris", archive_uris)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if file_uris is not None:
            pulumi.set(__self__, "file_uris", file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="mainRFileUri")
    def main_r_file_uri(self) -> pulumi.Input[str]:
        """
        Required. The HCFS URI of the main R file to use as the driver. Must be a .R file.
        """
        return pulumi.get(self, "main_r_file_uri")

    @main_r_file_uri.setter
    def main_r_file_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "main_r_file_uri", value)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @archive_uris.setter
    def archive_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "archive_uris", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @file_uris.setter
    def file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['WorkflowTemplateJobSparkRJobLoggingConfigArgs']]:
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['WorkflowTemplateJobSparkRJobLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class WorkflowTemplateJobSparkRJobLoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] driver_log_levels: The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        if driver_log_levels is not None:
            pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class WorkflowTemplateJobSparkSqlJobArgs:
    def __init__(__self__, *,
                 jar_file_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['WorkflowTemplateJobSparkSqlJobLoggingConfigArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 query_file_uri: Optional[pulumi.Input[str]] = None,
                 query_list: Optional[pulumi.Input['WorkflowTemplateJobSparkSqlJobQueryListArgs']] = None,
                 script_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jar_file_uris: Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param pulumi.Input['WorkflowTemplateJobSparkSqlJobLoggingConfigArgs'] logging_config: Optional. The runtime log config for job execution.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        :param pulumi.Input[str] query_file_uri: The HCFS URI of the script that contains SQL queries.
        :param pulumi.Input['WorkflowTemplateJobSparkSqlJobQueryListArgs'] query_list: A list of queries.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] script_variables: Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET `name="value";`).
        """
        if jar_file_uris is not None:
            pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if query_file_uri is not None:
            pulumi.set(__self__, "query_file_uri", query_file_uri)
        if query_list is not None:
            pulumi.set(__self__, "query_list", query_list)
        if script_variables is not None:
            pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @jar_file_uris.setter
    def jar_file_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jar_file_uris", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['WorkflowTemplateJobSparkSqlJobLoggingConfigArgs']]:
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['WorkflowTemplateJobSparkSqlJobLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The HCFS URI of the script that contains SQL queries.
        """
        return pulumi.get(self, "query_file_uri")

    @query_file_uri.setter
    def query_file_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_file_uri", value)

    @property
    @pulumi.getter(name="queryList")
    def query_list(self) -> Optional[pulumi.Input['WorkflowTemplateJobSparkSqlJobQueryListArgs']]:
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    @query_list.setter
    def query_list(self, value: Optional[pulumi.Input['WorkflowTemplateJobSparkSqlJobQueryListArgs']]):
        pulumi.set(self, "query_list", value)

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET `name="value";`).
        """
        return pulumi.get(self, "script_variables")

    @script_variables.setter
    def script_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "script_variables", value)


@pulumi.input_type
class WorkflowTemplateJobSparkSqlJobLoggingConfigArgs:
    def __init__(__self__, *,
                 driver_log_levels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] driver_log_levels: The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        if driver_log_levels is not None:
            pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "driver_log_levels")

    @driver_log_levels.setter
    def driver_log_levels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "driver_log_levels", value)


@pulumi.input_type
class WorkflowTemplateJobSparkSqlJobQueryListArgs:
    def __init__(__self__, *,
                 queries: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] queries: Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": } }
        """
        pulumi.set(__self__, "queries", queries)

    @property
    @pulumi.getter
    def queries(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": } }
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "queries", value)


@pulumi.input_type
class WorkflowTemplateParameterArgs:
    def __init__(__self__, *,
                 fields: pulumi.Input[Sequence[pulumi.Input[str]]],
                 name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 validation: Optional[pulumi.Input['WorkflowTemplateParameterValidationArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fields: Required. Paths to all fields that the parameter replaces. A field is allowed to appear in at most one parameter's list of field paths. A field path is similar in syntax to a .sparkJob.args
        :param pulumi.Input[str] name: Required. Parameter name. The parameter name is used as the key, and paired with the parameter value, which are passed to the template when the template is instantiated. The name must contain only capital letters (A-Z), numbers (0-9), and underscores (_), and must not start with a number. The maximum length is 40 characters.
        :param pulumi.Input[str] description: Optional. Brief description of the parameter. Must not exceed 1024 characters.
        :param pulumi.Input['WorkflowTemplateParameterValidationArgs'] validation: Optional. Validation rules to be applied to this parameter's value.
        """
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)

    @property
    @pulumi.getter
    def fields(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Required. Paths to all fields that the parameter replaces. A field is allowed to appear in at most one parameter's list of field paths. A field path is similar in syntax to a .sparkJob.args
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Required. Parameter name. The parameter name is used as the key, and paired with the parameter value, which are passed to the template when the template is instantiated. The name must contain only capital letters (A-Z), numbers (0-9), and underscores (_), and must not start with a number. The maximum length is 40 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Brief description of the parameter. Must not exceed 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def validation(self) -> Optional[pulumi.Input['WorkflowTemplateParameterValidationArgs']]:
        """
        Optional. Validation rules to be applied to this parameter's value.
        """
        return pulumi.get(self, "validation")

    @validation.setter
    def validation(self, value: Optional[pulumi.Input['WorkflowTemplateParameterValidationArgs']]):
        pulumi.set(self, "validation", value)


@pulumi.input_type
class WorkflowTemplateParameterValidationArgs:
    def __init__(__self__, *,
                 regex: Optional[pulumi.Input['WorkflowTemplateParameterValidationRegexArgs']] = None,
                 values: Optional[pulumi.Input['WorkflowTemplateParameterValidationValuesArgs']] = None):
        """
        :param pulumi.Input['WorkflowTemplateParameterValidationRegexArgs'] regex: Validation based on regular expressions.
        :param pulumi.Input['WorkflowTemplateParameterValidationValuesArgs'] values: Optional. Corresponds to the label values of reservation resource.
        """
        if regex is not None:
            pulumi.set(__self__, "regex", regex)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input['WorkflowTemplateParameterValidationRegexArgs']]:
        """
        Validation based on regular expressions.
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input['WorkflowTemplateParameterValidationRegexArgs']]):
        pulumi.set(self, "regex", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input['WorkflowTemplateParameterValidationValuesArgs']]:
        """
        Optional. Corresponds to the label values of reservation resource.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input['WorkflowTemplateParameterValidationValuesArgs']]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class WorkflowTemplateParameterValidationRegexArgs:
    def __init__(__self__, *,
                 regexes: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regexes: Required. RE2 regular expressions used to validate the parameter's value. The value must match the regex in its entirety (substring matches are not sufficient).
        """
        pulumi.set(__self__, "regexes", regexes)

    @property
    @pulumi.getter
    def regexes(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Required. RE2 regular expressions used to validate the parameter's value. The value must match the regex in its entirety (substring matches are not sufficient).
        """
        return pulumi.get(self, "regexes")

    @regexes.setter
    def regexes(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "regexes", value)


@pulumi.input_type
class WorkflowTemplateParameterValidationValuesArgs:
    def __init__(__self__, *,
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: Optional. Corresponds to the label values of reservation resource.
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Optional. Corresponds to the label values of reservation resource.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class WorkflowTemplatePlacementArgs:
    def __init__(__self__, *,
                 cluster_selector: Optional[pulumi.Input['WorkflowTemplatePlacementClusterSelectorArgs']] = None,
                 managed_cluster: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterArgs']] = None):
        """
        :param pulumi.Input['WorkflowTemplatePlacementClusterSelectorArgs'] cluster_selector: Optional. A selector that chooses target cluster for jobs based on metadata. The selector is evaluated at the time each job is submitted.
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterArgs'] managed_cluster: A cluster that is managed by the workflow.
        """
        if cluster_selector is not None:
            pulumi.set(__self__, "cluster_selector", cluster_selector)
        if managed_cluster is not None:
            pulumi.set(__self__, "managed_cluster", managed_cluster)

    @property
    @pulumi.getter(name="clusterSelector")
    def cluster_selector(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementClusterSelectorArgs']]:
        """
        Optional. A selector that chooses target cluster for jobs based on metadata. The selector is evaluated at the time each job is submitted.
        """
        return pulumi.get(self, "cluster_selector")

    @cluster_selector.setter
    def cluster_selector(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementClusterSelectorArgs']]):
        pulumi.set(self, "cluster_selector", value)

    @property
    @pulumi.getter(name="managedCluster")
    def managed_cluster(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterArgs']]:
        """
        A cluster that is managed by the workflow.
        """
        return pulumi.get(self, "managed_cluster")

    @managed_cluster.setter
    def managed_cluster(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterArgs']]):
        pulumi.set(self, "managed_cluster", value)


@pulumi.input_type
class WorkflowTemplatePlacementClusterSelectorArgs:
    def __init__(__self__, *,
                 cluster_labels: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] cluster_labels: Required. The cluster labels. Cluster must have all labels to match.
        :param pulumi.Input[str] zone: Optional. The zone where the Compute Engine cluster will be located. On a create request, it is required in the "global" region. If omitted in a non-global Dataproc region, the service will pick a zone in the corresponding Compute Engine region. On a get request, zone will always be present. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/` * `us-central1-f`
        """
        pulumi.set(__self__, "cluster_labels", cluster_labels)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="clusterLabels")
    def cluster_labels(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        Required. The cluster labels. Cluster must have all labels to match.
        """
        return pulumi.get(self, "cluster_labels")

    @cluster_labels.setter
    def cluster_labels(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "cluster_labels", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The zone where the Compute Engine cluster will be located. On a create request, it is required in the "global" region. If omitted in a non-global Dataproc region, the service will pick a zone in the corresponding Compute Engine region. On a get request, zone will always be present. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/` * `us-central1-f`
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[str],
                 config: pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigArgs'],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] cluster_name: Required. The cluster name prefix. A unique cluster name will be formed by appending a random suffix. The name must contain only lower-case letters (a-z), numbers (0-9), and hyphens (-). Must begin with a letter. Cannot begin or end with hyphen. Must consist of between 2 and 35 characters.
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigArgs'] config: Required. The cluster configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. The labels to associate with this cluster. Label keys must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: {0,63} No more than 32 labels can be associated with a given cluster.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "config", config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[str]:
        """
        Required. The cluster name prefix. A unique cluster name will be formed by appending a random suffix. The name must contain only lower-case letters (a-z), numbers (0-9), and hyphens (-). Must begin with a letter. Cannot begin or end with hyphen. Must consist of between 2 and 35 characters.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigArgs']:
        """
        Required. The cluster configuration.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigArgs']):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The labels to associate with this cluster. Label keys must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: {0,63} No more than 32 labels can be associated with a given cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigArgs:
    def __init__(__self__, *,
                 autoscaling_config: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigArgs']] = None,
                 encryption_config: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigEncryptionConfigArgs']] = None,
                 endpoint_config: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigEndpointConfigArgs']] = None,
                 gce_cluster_config: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigArgs']] = None,
                 gke_cluster_config: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigArgs']] = None,
                 initialization_actions: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigInitializationActionArgs']]]] = None,
                 lifecycle_config: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigLifecycleConfigArgs']] = None,
                 master_config: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMasterConfigArgs']] = None,
                 metastore_config: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMetastoreConfigArgs']] = None,
                 secondary_worker_config: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigArgs']] = None,
                 security_config: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecurityConfigArgs']] = None,
                 software_config: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSoftwareConfigArgs']] = None,
                 staging_bucket: Optional[pulumi.Input[str]] = None,
                 temp_bucket: Optional[pulumi.Input[str]] = None,
                 worker_config: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigArgs']] = None):
        """
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigArgs'] autoscaling_config: Optional. Autoscaling config for the policy associated with the cluster. Cluster does not autoscale if this field is unset.
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigEncryptionConfigArgs'] encryption_config: Optional. Encryption settings for the cluster.
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigEndpointConfigArgs'] endpoint_config: Optional. Port/endpoint configuration for this cluster
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigArgs'] gce_cluster_config: Optional. The shared Compute Engine config settings for all instances in a cluster.
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigArgs'] gke_cluster_config: Optional. The Kubernetes Engine config for Dataproc clusters deployed to Kubernetes. Setting this is considered mutually exclusive with Compute Engine-based options such as `gce_cluster_config`, `master_config`, `worker_config`, `secondary_worker_config`, and `autoscaling_config`.
        :param pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigInitializationActionArgs']]] initialization_actions: Optional. Commands to execute on each node after config is completed. By default, executables are run on master and all worker nodes. You can test a node's `role` metadata to run an executable on a master or worker node, as shown below using `curl` (you can also use `wget`): ROLE=$(curl -H Metadata-Flavor:Google http://metadata/computeMetadata/v1/instance/attributes/dataproc-role) if ; then ... master specific actions ... else ... worker specific actions ... fi
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigLifecycleConfigArgs'] lifecycle_config: Optional. Lifecycle setting for the cluster.
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMasterConfigArgs'] master_config: Optional. The Compute Engine config settings for additional worker instances in a cluster.
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMetastoreConfigArgs'] metastore_config: Optional. Metastore configuration.
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigArgs'] secondary_worker_config: Optional. The Compute Engine config settings for additional worker instances in a cluster.
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecurityConfigArgs'] security_config: Optional. Security settings for the cluster.
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSoftwareConfigArgs'] software_config: Optional. The config settings for software inside the cluster.
        :param pulumi.Input[str] staging_bucket: Optional. A Cloud Storage bucket used to stage job dependencies, config files, and job driver console output. If you do not specify a staging bucket, Cloud Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's staging bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket (see (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
        :param pulumi.Input[str] temp_bucket: Optional. A Cloud Storage bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files. If you do not specify a temp bucket, Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's temp bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket. The default bucket has a TTL of 90 days, but you can use any TTL (or none) if you specify a bucket.
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigArgs'] worker_config: Optional. The Compute Engine config settings for additional worker instances in a cluster.
        """
        if autoscaling_config is not None:
            pulumi.set(__self__, "autoscaling_config", autoscaling_config)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if endpoint_config is not None:
            pulumi.set(__self__, "endpoint_config", endpoint_config)
        if gce_cluster_config is not None:
            pulumi.set(__self__, "gce_cluster_config", gce_cluster_config)
        if gke_cluster_config is not None:
            pulumi.set(__self__, "gke_cluster_config", gke_cluster_config)
        if initialization_actions is not None:
            pulumi.set(__self__, "initialization_actions", initialization_actions)
        if lifecycle_config is not None:
            pulumi.set(__self__, "lifecycle_config", lifecycle_config)
        if master_config is not None:
            pulumi.set(__self__, "master_config", master_config)
        if metastore_config is not None:
            pulumi.set(__self__, "metastore_config", metastore_config)
        if secondary_worker_config is not None:
            pulumi.set(__self__, "secondary_worker_config", secondary_worker_config)
        if security_config is not None:
            pulumi.set(__self__, "security_config", security_config)
        if software_config is not None:
            pulumi.set(__self__, "software_config", software_config)
        if staging_bucket is not None:
            pulumi.set(__self__, "staging_bucket", staging_bucket)
        if temp_bucket is not None:
            pulumi.set(__self__, "temp_bucket", temp_bucket)
        if worker_config is not None:
            pulumi.set(__self__, "worker_config", worker_config)

    @property
    @pulumi.getter(name="autoscalingConfig")
    def autoscaling_config(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigArgs']]:
        """
        Optional. Autoscaling config for the policy associated with the cluster. Cluster does not autoscale if this field is unset.
        """
        return pulumi.get(self, "autoscaling_config")

    @autoscaling_config.setter
    def autoscaling_config(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigArgs']]):
        pulumi.set(self, "autoscaling_config", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigEncryptionConfigArgs']]:
        """
        Optional. Encryption settings for the cluster.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigEndpointConfigArgs']]:
        """
        Optional. Port/endpoint configuration for this cluster
        """
        return pulumi.get(self, "endpoint_config")

    @endpoint_config.setter
    def endpoint_config(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigEndpointConfigArgs']]):
        pulumi.set(self, "endpoint_config", value)

    @property
    @pulumi.getter(name="gceClusterConfig")
    def gce_cluster_config(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigArgs']]:
        """
        Optional. The shared Compute Engine config settings for all instances in a cluster.
        """
        return pulumi.get(self, "gce_cluster_config")

    @gce_cluster_config.setter
    def gce_cluster_config(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigArgs']]):
        pulumi.set(self, "gce_cluster_config", value)

    @property
    @pulumi.getter(name="gkeClusterConfig")
    def gke_cluster_config(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigArgs']]:
        """
        Optional. The Kubernetes Engine config for Dataproc clusters deployed to Kubernetes. Setting this is considered mutually exclusive with Compute Engine-based options such as `gce_cluster_config`, `master_config`, `worker_config`, `secondary_worker_config`, and `autoscaling_config`.
        """
        return pulumi.get(self, "gke_cluster_config")

    @gke_cluster_config.setter
    def gke_cluster_config(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigArgs']]):
        pulumi.set(self, "gke_cluster_config", value)

    @property
    @pulumi.getter(name="initializationActions")
    def initialization_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigInitializationActionArgs']]]]:
        """
        Optional. Commands to execute on each node after config is completed. By default, executables are run on master and all worker nodes. You can test a node's `role` metadata to run an executable on a master or worker node, as shown below using `curl` (you can also use `wget`): ROLE=$(curl -H Metadata-Flavor:Google http://metadata/computeMetadata/v1/instance/attributes/dataproc-role) if ; then ... master specific actions ... else ... worker specific actions ... fi
        """
        return pulumi.get(self, "initialization_actions")

    @initialization_actions.setter
    def initialization_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigInitializationActionArgs']]]]):
        pulumi.set(self, "initialization_actions", value)

    @property
    @pulumi.getter(name="lifecycleConfig")
    def lifecycle_config(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigLifecycleConfigArgs']]:
        """
        Optional. Lifecycle setting for the cluster.
        """
        return pulumi.get(self, "lifecycle_config")

    @lifecycle_config.setter
    def lifecycle_config(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigLifecycleConfigArgs']]):
        pulumi.set(self, "lifecycle_config", value)

    @property
    @pulumi.getter(name="masterConfig")
    def master_config(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMasterConfigArgs']]:
        """
        Optional. The Compute Engine config settings for additional worker instances in a cluster.
        """
        return pulumi.get(self, "master_config")

    @master_config.setter
    def master_config(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMasterConfigArgs']]):
        pulumi.set(self, "master_config", value)

    @property
    @pulumi.getter(name="metastoreConfig")
    def metastore_config(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMetastoreConfigArgs']]:
        """
        Optional. Metastore configuration.
        """
        return pulumi.get(self, "metastore_config")

    @metastore_config.setter
    def metastore_config(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMetastoreConfigArgs']]):
        pulumi.set(self, "metastore_config", value)

    @property
    @pulumi.getter(name="secondaryWorkerConfig")
    def secondary_worker_config(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigArgs']]:
        """
        Optional. The Compute Engine config settings for additional worker instances in a cluster.
        """
        return pulumi.get(self, "secondary_worker_config")

    @secondary_worker_config.setter
    def secondary_worker_config(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigArgs']]):
        pulumi.set(self, "secondary_worker_config", value)

    @property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecurityConfigArgs']]:
        """
        Optional. Security settings for the cluster.
        """
        return pulumi.get(self, "security_config")

    @security_config.setter
    def security_config(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecurityConfigArgs']]):
        pulumi.set(self, "security_config", value)

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSoftwareConfigArgs']]:
        """
        Optional. The config settings for software inside the cluster.
        """
        return pulumi.get(self, "software_config")

    @software_config.setter
    def software_config(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSoftwareConfigArgs']]):
        pulumi.set(self, "software_config", value)

    @property
    @pulumi.getter(name="stagingBucket")
    def staging_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A Cloud Storage bucket used to stage job dependencies, config files, and job driver console output. If you do not specify a staging bucket, Cloud Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's staging bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket (see (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
        """
        return pulumi.get(self, "staging_bucket")

    @staging_bucket.setter
    def staging_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "staging_bucket", value)

    @property
    @pulumi.getter(name="tempBucket")
    def temp_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A Cloud Storage bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files. If you do not specify a temp bucket, Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's temp bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket. The default bucket has a TTL of 90 days, but you can use any TTL (or none) if you specify a bucket.
        """
        return pulumi.get(self, "temp_bucket")

    @temp_bucket.setter
    def temp_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "temp_bucket", value)

    @property
    @pulumi.getter(name="workerConfig")
    def worker_config(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigArgs']]:
        """
        Optional. The Compute Engine config settings for additional worker instances in a cluster.
        """
        return pulumi.get(self, "worker_config")

    @worker_config.setter
    def worker_config(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigArgs']]):
        pulumi.set(self, "worker_config", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigArgs:
    def __init__(__self__, *,
                 policy: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] policy: Optional. The autoscaling policy used by the cluster. Only resource names including projectid and location (region) are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/` Note that the policy must be in the same project and Dataproc region.
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The autoscaling policy used by the cluster. Only resource names including projectid and location (region) are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/` Note that the policy must be in the same project and Dataproc region.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigEncryptionConfigArgs:
    def __init__(__self__, *,
                 gce_pd_kms_key_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] gce_pd_kms_key_name: Optional. The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
        """
        if gce_pd_kms_key_name is not None:
            pulumi.set(__self__, "gce_pd_kms_key_name", gce_pd_kms_key_name)

    @property
    @pulumi.getter(name="gcePdKmsKeyName")
    def gce_pd_kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
        """
        return pulumi.get(self, "gce_pd_kms_key_name")

    @gce_pd_kms_key_name.setter
    def gce_pd_kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gce_pd_kms_key_name", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigEndpointConfigArgs:
    def __init__(__self__, *,
                 enable_http_port_access: Optional[pulumi.Input[bool]] = None,
                 http_ports: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[bool] enable_http_port_access: Optional. If true, enable http access to specific ports on the cluster from external sources. Defaults to false.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] http_ports: -
               Output only. The map of port descriptions to URLs. Will only be populated if enable_http_port_access is true.
        """
        if enable_http_port_access is not None:
            pulumi.set(__self__, "enable_http_port_access", enable_http_port_access)
        if http_ports is not None:
            pulumi.set(__self__, "http_ports", http_ports)

    @property
    @pulumi.getter(name="enableHttpPortAccess")
    def enable_http_port_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If true, enable http access to specific ports on the cluster from external sources. Defaults to false.
        """
        return pulumi.get(self, "enable_http_port_access")

    @enable_http_port_access.setter
    def enable_http_port_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_http_port_access", value)

    @property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        -
        Output only. The map of port descriptions to URLs. Will only be populated if enable_http_port_access is true.
        """
        return pulumi.get(self, "http_ports")

    @http_ports.setter
    def http_ports(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "http_ports", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigArgs:
    def __init__(__self__, *,
                 internal_ip_only: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 node_group_affinity: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityArgs']] = None,
                 private_ipv6_google_access: Optional[pulumi.Input[str]] = None,
                 reservation_affinity: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityArgs']] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 service_account_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] internal_ip_only: Optional. If true, all instances in the cluster will only have internal IP addresses. By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance. This `internal_ip_only` restriction can only be enabled for subnetwork enabled networks, and all off-cluster dependencies must be configured to be accessible without external IP addresses.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: The Compute Engine metadata entries to add to all instances (see (https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        :param pulumi.Input[str] network: Optional. The Compute Engine network to be used for machine communications. Cannot be specified with subnetwork_uri. If neither `network_uri` nor `subnetwork_uri` is specified, the "default" network of the project is used, if it exists. Cannot be a "Custom Subnet Network" (see /regions/global/default` * `default`
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityArgs'] node_group_affinity: Optional. Node Group Affinity for sole-tenant clusters.
        :param pulumi.Input[str] private_ipv6_google_access: Optional. The type of IPv6 access for a cluster. Possible values: PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED, INHERIT_FROM_SUBNETWORK, OUTBOUND, BIDIRECTIONAL
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityArgs'] reservation_affinity: Optional. Reservation Affinity for consuming Zonal reservation.
        :param pulumi.Input[str] service_account: Optional. The (https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_account_scopes: Optional. The URIs of service account scopes to be included in Compute Engine instances. The following base set of scopes is always included: * https://www.googleapis.com/auth/cloud.useraccounts.readonly * https://www.googleapis.com/auth/devstorage.read_write * https://www.googleapis.com/auth/logging.write If no scopes are specified, the following defaults are also provided: * https://www.googleapis.com/auth/bigquery * https://www.googleapis.com/auth/bigtable.admin.table * https://www.googleapis.com/auth/bigtable.data * https://www.googleapis.com/auth/devstorage.full_control
        :param pulumi.Input[str] subnetwork: Optional. The Compute Engine subnetwork to be used for machine communications. Cannot be specified with network_uri. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects//regions/us-east1/subnetworks/sub0` * `sub0`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The Compute Engine tags to add to all instances (see (https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        :param pulumi.Input[str] zone: Optional. The zone where the Compute Engine cluster will be located. On a create request, it is required in the "global" region. If omitted in a non-global Dataproc region, the service will pick a zone in the corresponding Compute Engine region. On a get request, zone will always be present. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/` * `us-central1-f`
        """
        if internal_ip_only is not None:
            pulumi.set(__self__, "internal_ip_only", internal_ip_only)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if node_group_affinity is not None:
            pulumi.set(__self__, "node_group_affinity", node_group_affinity)
        if private_ipv6_google_access is not None:
            pulumi.set(__self__, "private_ipv6_google_access", private_ipv6_google_access)
        if reservation_affinity is not None:
            pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if service_account_scopes is not None:
            pulumi.set(__self__, "service_account_scopes", service_account_scopes)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="internalIpOnly")
    def internal_ip_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If true, all instances in the cluster will only have internal IP addresses. By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance. This `internal_ip_only` restriction can only be enabled for subnetwork enabled networks, and all off-cluster dependencies must be configured to be accessible without external IP addresses.
        """
        return pulumi.get(self, "internal_ip_only")

    @internal_ip_only.setter
    def internal_ip_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "internal_ip_only", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The Compute Engine metadata entries to add to all instances (see (https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine network to be used for machine communications. Cannot be specified with subnetwork_uri. If neither `network_uri` nor `subnetwork_uri` is specified, the "default" network of the project is used, if it exists. Cannot be a "Custom Subnet Network" (see /regions/global/default` * `default`
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="nodeGroupAffinity")
    def node_group_affinity(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityArgs']]:
        """
        Optional. Node Group Affinity for sole-tenant clusters.
        """
        return pulumi.get(self, "node_group_affinity")

    @node_group_affinity.setter
    def node_group_affinity(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityArgs']]):
        pulumi.set(self, "node_group_affinity", value)

    @property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The type of IPv6 access for a cluster. Possible values: PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED, INHERIT_FROM_SUBNETWORK, OUTBOUND, BIDIRECTIONAL
        """
        return pulumi.get(self, "private_ipv6_google_access")

    @private_ipv6_google_access.setter
    def private_ipv6_google_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ipv6_google_access", value)

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityArgs']]:
        """
        Optional. Reservation Affinity for consuming Zonal reservation.
        """
        return pulumi.get(self, "reservation_affinity")

    @reservation_affinity.setter
    def reservation_affinity(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityArgs']]):
        pulumi.set(self, "reservation_affinity", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The (https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="serviceAccountScopes")
    def service_account_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The URIs of service account scopes to be included in Compute Engine instances. The following base set of scopes is always included: * https://www.googleapis.com/auth/cloud.useraccounts.readonly * https://www.googleapis.com/auth/devstorage.read_write * https://www.googleapis.com/auth/logging.write If no scopes are specified, the following defaults are also provided: * https://www.googleapis.com/auth/bigquery * https://www.googleapis.com/auth/bigtable.admin.table * https://www.googleapis.com/auth/bigtable.data * https://www.googleapis.com/auth/devstorage.full_control
        """
        return pulumi.get(self, "service_account_scopes")

    @service_account_scopes.setter
    def service_account_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_account_scopes", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine subnetwork to be used for machine communications. Cannot be specified with network_uri. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects//regions/us-east1/subnetworks/sub0` * `sub0`
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Compute Engine tags to add to all instances (see (https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The zone where the Compute Engine cluster will be located. On a create request, it is required in the "global" region. If omitted in a non-global Dataproc region, the service will pick a zone in the corresponding Compute Engine region. On a get request, zone will always be present. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/` * `us-central1-f`
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityArgs:
    def __init__(__self__, *,
                 node_group: pulumi.Input[str]):
        """
        :param pulumi.Input[str] node_group: Required. The URI of a sole-tenant /zones/us-central1-a/nodeGroups/node-group-1` * `node-group-1`
        """
        pulumi.set(__self__, "node_group", node_group)

    @property
    @pulumi.getter(name="nodeGroup")
    def node_group(self) -> pulumi.Input[str]:
        """
        Required. The URI of a sole-tenant /zones/us-central1-a/nodeGroups/node-group-1` * `node-group-1`
        """
        return pulumi.get(self, "node_group")

    @node_group.setter
    def node_group(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_group", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityArgs:
    def __init__(__self__, *,
                 consume_reservation_type: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] consume_reservation_type: Optional. Type of reservation to consume Possible values: TYPE_UNSPECIFIED, NO_RESERVATION, ANY_RESERVATION, SPECIFIC_RESERVATION
        :param pulumi.Input[str] key: Optional. Corresponds to the label key of reservation resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: Optional. Corresponds to the label values of reservation resource.
        """
        if consume_reservation_type is not None:
            pulumi.set(__self__, "consume_reservation_type", consume_reservation_type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="consumeReservationType")
    def consume_reservation_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Type of reservation to consume Possible values: TYPE_UNSPECIFIED, NO_RESERVATION, ANY_RESERVATION, SPECIFIC_RESERVATION
        """
        return pulumi.get(self, "consume_reservation_type")

    @consume_reservation_type.setter
    def consume_reservation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consume_reservation_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Corresponds to the label key of reservation resource.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. Corresponds to the label values of reservation resource.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigArgs:
    def __init__(__self__, *,
                 namespaced_gke_deployment_target: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTargetArgs']] = None):
        """
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTargetArgs'] namespaced_gke_deployment_target: Optional. A target for the deployment.
        """
        if namespaced_gke_deployment_target is not None:
            pulumi.set(__self__, "namespaced_gke_deployment_target", namespaced_gke_deployment_target)

    @property
    @pulumi.getter(name="namespacedGkeDeploymentTarget")
    def namespaced_gke_deployment_target(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTargetArgs']]:
        """
        Optional. A target for the deployment.
        """
        return pulumi.get(self, "namespaced_gke_deployment_target")

    @namespaced_gke_deployment_target.setter
    def namespaced_gke_deployment_target(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTargetArgs']]):
        pulumi.set(self, "namespaced_gke_deployment_target", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigGkeClusterConfigNamespacedGkeDeploymentTargetArgs:
    def __init__(__self__, *,
                 cluster_namespace: Optional[pulumi.Input[str]] = None,
                 target_gke_cluster: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cluster_namespace: Optional. A namespace within the GKE cluster to deploy into.
        :param pulumi.Input[str] target_gke_cluster: Optional. The target GKE cluster to deploy to. Format: 'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        if cluster_namespace is not None:
            pulumi.set(__self__, "cluster_namespace", cluster_namespace)
        if target_gke_cluster is not None:
            pulumi.set(__self__, "target_gke_cluster", target_gke_cluster)

    @property
    @pulumi.getter(name="clusterNamespace")
    def cluster_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A namespace within the GKE cluster to deploy into.
        """
        return pulumi.get(self, "cluster_namespace")

    @cluster_namespace.setter
    def cluster_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_namespace", value)

    @property
    @pulumi.getter(name="targetGkeCluster")
    def target_gke_cluster(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The target GKE cluster to deploy to. Format: 'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        return pulumi.get(self, "target_gke_cluster")

    @target_gke_cluster.setter
    def target_gke_cluster(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_gke_cluster", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigInitializationActionArgs:
    def __init__(__self__, *,
                 executable_file: Optional[pulumi.Input[str]] = None,
                 execution_timeout: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] executable_file: Required. Cloud Storage URI of executable file.
        :param pulumi.Input[str] execution_timeout: Optional. Amount of time executable has to complete. Default is 10 minutes (see JSON representation of (https://developers.google.com/protocol-buffers/docs/proto3#json)). Cluster creation fails with an explanatory error message (the name of the executable that caused the error and the exceeded timeout period) if the executable is not completed at end of the timeout period.
        """
        if executable_file is not None:
            pulumi.set(__self__, "executable_file", executable_file)
        if execution_timeout is not None:
            pulumi.set(__self__, "execution_timeout", execution_timeout)

    @property
    @pulumi.getter(name="executableFile")
    def executable_file(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Cloud Storage URI of executable file.
        """
        return pulumi.get(self, "executable_file")

    @executable_file.setter
    def executable_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "executable_file", value)

    @property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Amount of time executable has to complete. Default is 10 minutes (see JSON representation of (https://developers.google.com/protocol-buffers/docs/proto3#json)). Cluster creation fails with an explanatory error message (the name of the executable that caused the error and the exceeded timeout period) if the executable is not completed at end of the timeout period.
        """
        return pulumi.get(self, "execution_timeout")

    @execution_timeout.setter
    def execution_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_timeout", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigLifecycleConfigArgs:
    def __init__(__self__, *,
                 auto_delete_time: Optional[pulumi.Input[str]] = None,
                 auto_delete_ttl: Optional[pulumi.Input[str]] = None,
                 idle_delete_ttl: Optional[pulumi.Input[str]] = None,
                 idle_start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] auto_delete_time: Optional. The time when cluster will be auto-deleted (see JSON representation of (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        :param pulumi.Input[str] auto_delete_ttl: Optional. The lifetime duration of cluster. The cluster will be auto-deleted at the end of this period. Minimum value is 10 minutes; maximum value is 14 days (see JSON representation of (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        :param pulumi.Input[str] idle_delete_ttl: Optional. The duration to keep the cluster alive while idling (when no jobs are running). Passing this threshold will cause the cluster to be deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON representation of (https://developers.google.com/protocol-buffers/docs/proto3#json).
        :param pulumi.Input[str] idle_start_time: -
               Output only. The time when cluster became idle (most recent job finished) and became eligible for deletion due to idleness (see JSON representation of (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        if auto_delete_time is not None:
            pulumi.set(__self__, "auto_delete_time", auto_delete_time)
        if auto_delete_ttl is not None:
            pulumi.set(__self__, "auto_delete_ttl", auto_delete_ttl)
        if idle_delete_ttl is not None:
            pulumi.set(__self__, "idle_delete_ttl", idle_delete_ttl)
        if idle_start_time is not None:
            pulumi.set(__self__, "idle_start_time", idle_start_time)

    @property
    @pulumi.getter(name="autoDeleteTime")
    def auto_delete_time(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The time when cluster will be auto-deleted (see JSON representation of (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "auto_delete_time")

    @auto_delete_time.setter
    def auto_delete_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_delete_time", value)

    @property
    @pulumi.getter(name="autoDeleteTtl")
    def auto_delete_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The lifetime duration of cluster. The cluster will be auto-deleted at the end of this period. Minimum value is 10 minutes; maximum value is 14 days (see JSON representation of (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "auto_delete_ttl")

    @auto_delete_ttl.setter
    def auto_delete_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_delete_ttl", value)

    @property
    @pulumi.getter(name="idleDeleteTtl")
    def idle_delete_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The duration to keep the cluster alive while idling (when no jobs are running). Passing this threshold will cause the cluster to be deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON representation of (https://developers.google.com/protocol-buffers/docs/proto3#json).
        """
        return pulumi.get(self, "idle_delete_ttl")

    @idle_delete_ttl.setter
    def idle_delete_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idle_delete_ttl", value)

    @property
    @pulumi.getter(name="idleStartTime")
    def idle_start_time(self) -> Optional[pulumi.Input[str]]:
        """
        -
        Output only. The time when cluster became idle (most recent job finished) and became eligible for deletion due to idleness (see JSON representation of (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "idle_start_time")

    @idle_start_time.setter
    def idle_start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idle_start_time", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigMasterConfigArgs:
    def __init__(__self__, *,
                 accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMasterConfigAcceleratorArgs']]]] = None,
                 disk_config: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigArgs']] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 instance_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_preemptible: Optional[pulumi.Input[bool]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 managed_group_configs: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfigArgs']]]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 num_instances: Optional[pulumi.Input[int]] = None,
                 preemptibility: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMasterConfigAcceleratorArgs']]] accelerators: Optional. The Compute Engine accelerator configuration for these instances.
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigArgs'] disk_config: Optional. Disk option config settings.
        :param pulumi.Input[str] image: Optional. The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_names: -
               Output only. The list of instance names. Dataproc derives the names from `cluster_name`, `num_instances`, and the instance group.
        :param pulumi.Input[bool] is_preemptible: -
               Output only. Specifies that this instance group contains preemptible instances.
        :param pulumi.Input[str] machine_type: Optional. The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/(https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
        :param pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfigArgs']]] managed_group_configs: -
               Output only. The config for Compute Engine Instance Group Manager that manages this group. This is only used for preemptible instance groups.
        :param pulumi.Input[str] min_cpu_platform: Optional. Specifies the minimum cpu platform for the Instance Group. See (https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        :param pulumi.Input[int] num_instances: Optional. The number of VM instances in the instance group. For master instance groups, must be set to 1.
        :param pulumi.Input[str] preemptibility: Optional. Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if is_preemptible is not None:
            pulumi.set(__self__, "is_preemptible", is_preemptible)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if managed_group_configs is not None:
            pulumi.set(__self__, "managed_group_configs", managed_group_configs)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)
        if preemptibility is not None:
            pulumi.set(__self__, "preemptibility", preemptibility)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMasterConfigAcceleratorArgs']]]]:
        """
        Optional. The Compute Engine accelerator configuration for these instances.
        """
        return pulumi.get(self, "accelerators")

    @accelerators.setter
    def accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMasterConfigAcceleratorArgs']]]]):
        pulumi.set(self, "accelerators", value)

    @property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigArgs']]:
        """
        Optional. Disk option config settings.
        """
        return pulumi.get(self, "disk_config")

    @disk_config.setter
    def disk_config(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigArgs']]):
        pulumi.set(self, "disk_config", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        -
        Output only. The list of instance names. Dataproc derives the names from `cluster_name`, `num_instances`, and the instance group.
        """
        return pulumi.get(self, "instance_names")

    @instance_names.setter
    def instance_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_names", value)

    @property
    @pulumi.getter(name="isPreemptible")
    def is_preemptible(self) -> Optional[pulumi.Input[bool]]:
        """
        -
        Output only. Specifies that this instance group contains preemptible instances.
        """
        return pulumi.get(self, "is_preemptible")

    @is_preemptible.setter
    def is_preemptible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_preemptible", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/(https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="managedGroupConfigs")
    def managed_group_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfigArgs']]]]:
        """
        -
        Output only. The config for Compute Engine Instance Group Manager that manages this group. This is only used for preemptible instance groups.
        """
        return pulumi.get(self, "managed_group_configs")

    @managed_group_configs.setter
    def managed_group_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfigArgs']]]]):
        pulumi.set(self, "managed_group_configs", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Specifies the minimum cpu platform for the Instance Group. See (https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of VM instances in the instance group. For master instance groups, must be set to 1.
        """
        return pulumi.get(self, "num_instances")

    @num_instances.setter
    def num_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_instances", value)

    @property
    @pulumi.getter
    def preemptibility(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
        """
        return pulumi.get(self, "preemptibility")

    @preemptibility.setter
    def preemptibility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preemptibility", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigMasterConfigAcceleratorArgs:
    def __init__(__self__, *,
                 accelerator_count: Optional[pulumi.Input[int]] = None,
                 accelerator_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] accelerator_count: The number of the accelerator cards of this type exposed to this instance.
        :param pulumi.Input[str] accelerator_type: Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
        """
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of the accelerator cards of this type exposed to this instance.
        """
        return pulumi.get(self, "accelerator_count")

    @accelerator_count.setter
    def accelerator_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "accelerator_count", value)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[pulumi.Input[str]]:
        """
        Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accelerator_type", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigArgs:
    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 boot_disk_type: Optional[pulumi.Input[str]] = None,
                 num_local_ssds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] boot_disk_size_gb: Optional. Size in GB of the boot disk (default is 500GB).
        :param pulumi.Input[str] boot_disk_type: Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-ssd" (Persistent Disk Solid State Drive) or "pd-standard" (Persistent Disk Hard Disk Drive).
        :param pulumi.Input[int] num_local_ssds: Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Size in GB of the boot disk (default is 500GB).
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @boot_disk_size_gb.setter
    def boot_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "boot_disk_size_gb", value)

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-ssd" (Persistent Disk Solid State Drive) or "pd-standard" (Persistent Disk Hard Disk Drive).
        """
        return pulumi.get(self, "boot_disk_type")

    @boot_disk_type.setter
    def boot_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_disk_type", value)

    @property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        return pulumi.get(self, "num_local_ssds")

    @num_local_ssds.setter
    def num_local_ssds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_local_ssds", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigMasterConfigManagedGroupConfigArgs:
    def __init__(__self__, *,
                 instance_group_manager_name: Optional[pulumi.Input[str]] = None,
                 instance_template_name: Optional[pulumi.Input[str]] = None):
        if instance_group_manager_name is not None:
            pulumi.set(__self__, "instance_group_manager_name", instance_group_manager_name)
        if instance_template_name is not None:
            pulumi.set(__self__, "instance_template_name", instance_template_name)

    @property
    @pulumi.getter(name="instanceGroupManagerName")
    def instance_group_manager_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "instance_group_manager_name")

    @instance_group_manager_name.setter
    def instance_group_manager_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_group_manager_name", value)

    @property
    @pulumi.getter(name="instanceTemplateName")
    def instance_template_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "instance_template_name")

    @instance_template_name.setter
    def instance_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_template_name", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigMetastoreConfigArgs:
    def __init__(__self__, *,
                 dataproc_metastore_service: pulumi.Input[str]):
        """
        :param pulumi.Input[str] dataproc_metastore_service: Required. Resource name of an existing Dataproc Metastore service. Example: * `projects/`
        """
        pulumi.set(__self__, "dataproc_metastore_service", dataproc_metastore_service)

    @property
    @pulumi.getter(name="dataprocMetastoreService")
    def dataproc_metastore_service(self) -> pulumi.Input[str]:
        """
        Required. Resource name of an existing Dataproc Metastore service. Example: * `projects/`
        """
        return pulumi.get(self, "dataproc_metastore_service")

    @dataproc_metastore_service.setter
    def dataproc_metastore_service(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataproc_metastore_service", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigArgs:
    def __init__(__self__, *,
                 accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAcceleratorArgs']]]] = None,
                 disk_config: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigArgs']] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 instance_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_preemptible: Optional[pulumi.Input[bool]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 managed_group_configs: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfigArgs']]]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 num_instances: Optional[pulumi.Input[int]] = None,
                 preemptibility: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAcceleratorArgs']]] accelerators: Optional. The Compute Engine accelerator configuration for these instances.
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigArgs'] disk_config: Optional. Disk option config settings.
        :param pulumi.Input[str] image: Optional. The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_names: -
               Output only. The list of instance names. Dataproc derives the names from `cluster_name`, `num_instances`, and the instance group.
        :param pulumi.Input[bool] is_preemptible: -
               Output only. Specifies that this instance group contains preemptible instances.
        :param pulumi.Input[str] machine_type: Optional. The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/(https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
        :param pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfigArgs']]] managed_group_configs: -
               Output only. The config for Compute Engine Instance Group Manager that manages this group. This is only used for preemptible instance groups.
        :param pulumi.Input[str] min_cpu_platform: Optional. Specifies the minimum cpu platform for the Instance Group. See (https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        :param pulumi.Input[int] num_instances: Optional. The number of VM instances in the instance group. For master instance groups, must be set to 1.
        :param pulumi.Input[str] preemptibility: Optional. Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if is_preemptible is not None:
            pulumi.set(__self__, "is_preemptible", is_preemptible)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if managed_group_configs is not None:
            pulumi.set(__self__, "managed_group_configs", managed_group_configs)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)
        if preemptibility is not None:
            pulumi.set(__self__, "preemptibility", preemptibility)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAcceleratorArgs']]]]:
        """
        Optional. The Compute Engine accelerator configuration for these instances.
        """
        return pulumi.get(self, "accelerators")

    @accelerators.setter
    def accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAcceleratorArgs']]]]):
        pulumi.set(self, "accelerators", value)

    @property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigArgs']]:
        """
        Optional. Disk option config settings.
        """
        return pulumi.get(self, "disk_config")

    @disk_config.setter
    def disk_config(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigArgs']]):
        pulumi.set(self, "disk_config", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        -
        Output only. The list of instance names. Dataproc derives the names from `cluster_name`, `num_instances`, and the instance group.
        """
        return pulumi.get(self, "instance_names")

    @instance_names.setter
    def instance_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_names", value)

    @property
    @pulumi.getter(name="isPreemptible")
    def is_preemptible(self) -> Optional[pulumi.Input[bool]]:
        """
        -
        Output only. Specifies that this instance group contains preemptible instances.
        """
        return pulumi.get(self, "is_preemptible")

    @is_preemptible.setter
    def is_preemptible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_preemptible", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/(https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="managedGroupConfigs")
    def managed_group_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfigArgs']]]]:
        """
        -
        Output only. The config for Compute Engine Instance Group Manager that manages this group. This is only used for preemptible instance groups.
        """
        return pulumi.get(self, "managed_group_configs")

    @managed_group_configs.setter
    def managed_group_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfigArgs']]]]):
        pulumi.set(self, "managed_group_configs", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Specifies the minimum cpu platform for the Instance Group. See (https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of VM instances in the instance group. For master instance groups, must be set to 1.
        """
        return pulumi.get(self, "num_instances")

    @num_instances.setter
    def num_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_instances", value)

    @property
    @pulumi.getter
    def preemptibility(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
        """
        return pulumi.get(self, "preemptibility")

    @preemptibility.setter
    def preemptibility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preemptibility", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAcceleratorArgs:
    def __init__(__self__, *,
                 accelerator_count: Optional[pulumi.Input[int]] = None,
                 accelerator_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] accelerator_count: The number of the accelerator cards of this type exposed to this instance.
        :param pulumi.Input[str] accelerator_type: Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
        """
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of the accelerator cards of this type exposed to this instance.
        """
        return pulumi.get(self, "accelerator_count")

    @accelerator_count.setter
    def accelerator_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "accelerator_count", value)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[pulumi.Input[str]]:
        """
        Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accelerator_type", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigArgs:
    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 boot_disk_type: Optional[pulumi.Input[str]] = None,
                 num_local_ssds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] boot_disk_size_gb: Optional. Size in GB of the boot disk (default is 500GB).
        :param pulumi.Input[str] boot_disk_type: Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-ssd" (Persistent Disk Solid State Drive) or "pd-standard" (Persistent Disk Hard Disk Drive).
        :param pulumi.Input[int] num_local_ssds: Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Size in GB of the boot disk (default is 500GB).
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @boot_disk_size_gb.setter
    def boot_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "boot_disk_size_gb", value)

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-ssd" (Persistent Disk Solid State Drive) or "pd-standard" (Persistent Disk Hard Disk Drive).
        """
        return pulumi.get(self, "boot_disk_type")

    @boot_disk_type.setter
    def boot_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_disk_type", value)

    @property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        return pulumi.get(self, "num_local_ssds")

    @num_local_ssds.setter
    def num_local_ssds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_local_ssds", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigManagedGroupConfigArgs:
    def __init__(__self__, *,
                 instance_group_manager_name: Optional[pulumi.Input[str]] = None,
                 instance_template_name: Optional[pulumi.Input[str]] = None):
        if instance_group_manager_name is not None:
            pulumi.set(__self__, "instance_group_manager_name", instance_group_manager_name)
        if instance_template_name is not None:
            pulumi.set(__self__, "instance_template_name", instance_template_name)

    @property
    @pulumi.getter(name="instanceGroupManagerName")
    def instance_group_manager_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "instance_group_manager_name")

    @instance_group_manager_name.setter
    def instance_group_manager_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_group_manager_name", value)

    @property
    @pulumi.getter(name="instanceTemplateName")
    def instance_template_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "instance_template_name")

    @instance_template_name.setter
    def instance_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_template_name", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigSecurityConfigArgs:
    def __init__(__self__, *,
                 kerberos_config: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigArgs']] = None):
        """
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigArgs'] kerberos_config: Kerberos related configuration.
        """
        if kerberos_config is not None:
            pulumi.set(__self__, "kerberos_config", kerberos_config)

    @property
    @pulumi.getter(name="kerberosConfig")
    def kerberos_config(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigArgs']]:
        """
        Kerberos related configuration.
        """
        return pulumi.get(self, "kerberos_config")

    @kerberos_config.setter
    def kerberos_config(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigArgs']]):
        pulumi.set(self, "kerberos_config", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigArgs:
    def __init__(__self__, *,
                 cross_realm_trust_admin_server: Optional[pulumi.Input[str]] = None,
                 cross_realm_trust_kdc: Optional[pulumi.Input[str]] = None,
                 cross_realm_trust_realm: Optional[pulumi.Input[str]] = None,
                 cross_realm_trust_shared_password: Optional[pulumi.Input[str]] = None,
                 enable_kerberos: Optional[pulumi.Input[bool]] = None,
                 kdc_db_key: Optional[pulumi.Input[str]] = None,
                 key_password: Optional[pulumi.Input[str]] = None,
                 keystore: Optional[pulumi.Input[str]] = None,
                 keystore_password: Optional[pulumi.Input[str]] = None,
                 kms_key: Optional[pulumi.Input[str]] = None,
                 realm: Optional[pulumi.Input[str]] = None,
                 root_principal_password: Optional[pulumi.Input[str]] = None,
                 tgt_lifetime_hours: Optional[pulumi.Input[int]] = None,
                 truststore: Optional[pulumi.Input[str]] = None,
                 truststore_password: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cross_realm_trust_admin_server: Optional. The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        :param pulumi.Input[str] cross_realm_trust_kdc: Optional. The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        :param pulumi.Input[str] cross_realm_trust_realm: Optional. The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
        :param pulumi.Input[str] cross_realm_trust_shared_password: Optional. The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
        :param pulumi.Input[bool] enable_kerberos: Optional. Flag to indicate whether to Kerberize the cluster (default: false). Set this field to true to enable Kerberos on a cluster.
        :param pulumi.Input[str] kdc_db_key: Optional. The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
        :param pulumi.Input[str] key_password: Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key. For the self-signed certificate, this password is generated by Dataproc.
        :param pulumi.Input[str] keystore: Optional. The Cloud Storage URI of the keystore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        :param pulumi.Input[str] keystore_password: Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided keystore. For the self-signed certificate, this password is generated by Dataproc.
        :param pulumi.Input[str] kms_key: Optional. The uri of the KMS key used to encrypt various sensitive files.
        :param pulumi.Input[str] realm: Optional. The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
        :param pulumi.Input[str] root_principal_password: Optional. The Cloud Storage URI of a KMS encrypted file containing the root principal password.
        :param pulumi.Input[int] tgt_lifetime_hours: Optional. The lifetime of the ticket granting ticket, in hours. If not specified, or user specifies 0, then default value 10 will be used.
        :param pulumi.Input[str] truststore: Optional. The Cloud Storage URI of the truststore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        :param pulumi.Input[str] truststore_password: Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore. For the self-signed certificate, this password is generated by Dataproc.
        """
        if cross_realm_trust_admin_server is not None:
            pulumi.set(__self__, "cross_realm_trust_admin_server", cross_realm_trust_admin_server)
        if cross_realm_trust_kdc is not None:
            pulumi.set(__self__, "cross_realm_trust_kdc", cross_realm_trust_kdc)
        if cross_realm_trust_realm is not None:
            pulumi.set(__self__, "cross_realm_trust_realm", cross_realm_trust_realm)
        if cross_realm_trust_shared_password is not None:
            pulumi.set(__self__, "cross_realm_trust_shared_password", cross_realm_trust_shared_password)
        if enable_kerberos is not None:
            pulumi.set(__self__, "enable_kerberos", enable_kerberos)
        if kdc_db_key is not None:
            pulumi.set(__self__, "kdc_db_key", kdc_db_key)
        if key_password is not None:
            pulumi.set(__self__, "key_password", key_password)
        if keystore is not None:
            pulumi.set(__self__, "keystore", keystore)
        if keystore_password is not None:
            pulumi.set(__self__, "keystore_password", keystore_password)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if realm is not None:
            pulumi.set(__self__, "realm", realm)
        if root_principal_password is not None:
            pulumi.set(__self__, "root_principal_password", root_principal_password)
        if tgt_lifetime_hours is not None:
            pulumi.set(__self__, "tgt_lifetime_hours", tgt_lifetime_hours)
        if truststore is not None:
            pulumi.set(__self__, "truststore", truststore)
        if truststore_password is not None:
            pulumi.set(__self__, "truststore_password", truststore_password)

    @property
    @pulumi.getter(name="crossRealmTrustAdminServer")
    def cross_realm_trust_admin_server(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_admin_server")

    @cross_realm_trust_admin_server.setter
    def cross_realm_trust_admin_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_realm_trust_admin_server", value)

    @property
    @pulumi.getter(name="crossRealmTrustKdc")
    def cross_realm_trust_kdc(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_kdc")

    @cross_realm_trust_kdc.setter
    def cross_realm_trust_kdc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_realm_trust_kdc", value)

    @property
    @pulumi.getter(name="crossRealmTrustRealm")
    def cross_realm_trust_realm(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
        """
        return pulumi.get(self, "cross_realm_trust_realm")

    @cross_realm_trust_realm.setter
    def cross_realm_trust_realm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_realm_trust_realm", value)

    @property
    @pulumi.getter(name="crossRealmTrustSharedPassword")
    def cross_realm_trust_shared_password(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_shared_password")

    @cross_realm_trust_shared_password.setter
    def cross_realm_trust_shared_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_realm_trust_shared_password", value)

    @property
    @pulumi.getter(name="enableKerberos")
    def enable_kerberos(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Flag to indicate whether to Kerberize the cluster (default: false). Set this field to true to enable Kerberos on a cluster.
        """
        return pulumi.get(self, "enable_kerberos")

    @enable_kerberos.setter
    def enable_kerberos(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_kerberos", value)

    @property
    @pulumi.getter(name="kdcDbKey")
    def kdc_db_key(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
        """
        return pulumi.get(self, "kdc_db_key")

    @kdc_db_key.setter
    def kdc_db_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kdc_db_key", value)

    @property
    @pulumi.getter(name="keyPassword")
    def key_password(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key. For the self-signed certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "key_password")

    @key_password.setter
    def key_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_password", value)

    @property
    @pulumi.getter
    def keystore(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud Storage URI of the keystore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "keystore")

    @keystore.setter
    def keystore(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keystore", value)

    @property
    @pulumi.getter(name="keystorePassword")
    def keystore_password(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided keystore. For the self-signed certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "keystore_password")

    @keystore_password.setter
    def keystore_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keystore_password", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The uri of the KMS key used to encrypt various sensitive files.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key", value)

    @property
    @pulumi.getter
    def realm(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
        """
        return pulumi.get(self, "realm")

    @realm.setter
    def realm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "realm", value)

    @property
    @pulumi.getter(name="rootPrincipalPassword")
    def root_principal_password(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the root principal password.
        """
        return pulumi.get(self, "root_principal_password")

    @root_principal_password.setter
    def root_principal_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_principal_password", value)

    @property
    @pulumi.getter(name="tgtLifetimeHours")
    def tgt_lifetime_hours(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The lifetime of the ticket granting ticket, in hours. If not specified, or user specifies 0, then default value 10 will be used.
        """
        return pulumi.get(self, "tgt_lifetime_hours")

    @tgt_lifetime_hours.setter
    def tgt_lifetime_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tgt_lifetime_hours", value)

    @property
    @pulumi.getter
    def truststore(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud Storage URI of the truststore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "truststore")

    @truststore.setter
    def truststore(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "truststore", value)

    @property
    @pulumi.getter(name="truststorePassword")
    def truststore_password(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore. For the self-signed certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "truststore_password")

    @truststore_password.setter
    def truststore_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "truststore_password", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigSoftwareConfigArgs:
    def __init__(__self__, *,
                 image_version: Optional[pulumi.Input[str]] = None,
                 optional_components: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] image_version: Optional. The version of software inside the cluster. It must be one of the supported (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#other_versions). If unspecified, it defaults to the latest Debian version.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        if image_version is not None:
            pulumi.set(__self__, "image_version", image_version)
        if optional_components is not None:
            pulumi.set(__self__, "optional_components", optional_components)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The version of software inside the cluster. It must be one of the supported (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#other_versions). If unspecified, it defaults to the latest Debian version.
        """
        return pulumi.get(self, "image_version")

    @image_version.setter
    def image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_version", value)

    @property
    @pulumi.getter(name="optionalComponents")
    def optional_components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "optional_components")

    @optional_components.setter
    def optional_components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "optional_components", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigWorkerConfigArgs:
    def __init__(__self__, *,
                 accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigAcceleratorArgs']]]] = None,
                 disk_config: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigArgs']] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 instance_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_preemptible: Optional[pulumi.Input[bool]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 managed_group_configs: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfigArgs']]]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 num_instances: Optional[pulumi.Input[int]] = None,
                 preemptibility: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigAcceleratorArgs']]] accelerators: Optional. The Compute Engine accelerator configuration for these instances.
        :param pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigArgs'] disk_config: Optional. Disk option config settings.
        :param pulumi.Input[str] image: Optional. The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_names: -
               Output only. The list of instance names. Dataproc derives the names from `cluster_name`, `num_instances`, and the instance group.
        :param pulumi.Input[bool] is_preemptible: -
               Output only. Specifies that this instance group contains preemptible instances.
        :param pulumi.Input[str] machine_type: Optional. The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/(https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
        :param pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfigArgs']]] managed_group_configs: -
               Output only. The config for Compute Engine Instance Group Manager that manages this group. This is only used for preemptible instance groups.
        :param pulumi.Input[str] min_cpu_platform: Optional. Specifies the minimum cpu platform for the Instance Group. See (https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        :param pulumi.Input[int] num_instances: Optional. The number of VM instances in the instance group. For master instance groups, must be set to 1.
        :param pulumi.Input[str] preemptibility: Optional. Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if disk_config is not None:
            pulumi.set(__self__, "disk_config", disk_config)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if is_preemptible is not None:
            pulumi.set(__self__, "is_preemptible", is_preemptible)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if managed_group_configs is not None:
            pulumi.set(__self__, "managed_group_configs", managed_group_configs)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if num_instances is not None:
            pulumi.set(__self__, "num_instances", num_instances)
        if preemptibility is not None:
            pulumi.set(__self__, "preemptibility", preemptibility)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigAcceleratorArgs']]]]:
        """
        Optional. The Compute Engine accelerator configuration for these instances.
        """
        return pulumi.get(self, "accelerators")

    @accelerators.setter
    def accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigAcceleratorArgs']]]]):
        pulumi.set(self, "accelerators", value)

    @property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigArgs']]:
        """
        Optional. Disk option config settings.
        """
        return pulumi.get(self, "disk_config")

    @disk_config.setter
    def disk_config(self, value: Optional[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigArgs']]):
        pulumi.set(self, "disk_config", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        -
        Output only. The list of instance names. Dataproc derives the names from `cluster_name`, `num_instances`, and the instance group.
        """
        return pulumi.get(self, "instance_names")

    @instance_names.setter
    def instance_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_names", value)

    @property
    @pulumi.getter(name="isPreemptible")
    def is_preemptible(self) -> Optional[pulumi.Input[bool]]:
        """
        -
        Output only. Specifies that this instance group contains preemptible instances.
        """
        return pulumi.get(self, "is_preemptible")

    @is_preemptible.setter
    def is_preemptible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_preemptible", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/(https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="managedGroupConfigs")
    def managed_group_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfigArgs']]]]:
        """
        -
        Output only. The config for Compute Engine Instance Group Manager that manages this group. This is only used for preemptible instance groups.
        """
        return pulumi.get(self, "managed_group_configs")

    @managed_group_configs.setter
    def managed_group_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfigArgs']]]]):
        pulumi.set(self, "managed_group_configs", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Specifies the minimum cpu platform for the Instance Group. See (https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of VM instances in the instance group. For master instance groups, must be set to 1.
        """
        return pulumi.get(self, "num_instances")

    @num_instances.setter
    def num_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_instances", value)

    @property
    @pulumi.getter
    def preemptibility(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
        """
        return pulumi.get(self, "preemptibility")

    @preemptibility.setter
    def preemptibility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preemptibility", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigWorkerConfigAcceleratorArgs:
    def __init__(__self__, *,
                 accelerator_count: Optional[pulumi.Input[int]] = None,
                 accelerator_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] accelerator_count: The number of the accelerator cards of this type exposed to this instance.
        :param pulumi.Input[str] accelerator_type: Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
        """
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of the accelerator cards of this type exposed to this instance.
        """
        return pulumi.get(self, "accelerator_count")

    @accelerator_count.setter
    def accelerator_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "accelerator_count", value)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[pulumi.Input[str]]:
        """
        Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "accelerator_type")

    @accelerator_type.setter
    def accelerator_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accelerator_type", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigArgs:
    def __init__(__self__, *,
                 boot_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 boot_disk_type: Optional[pulumi.Input[str]] = None,
                 num_local_ssds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] boot_disk_size_gb: Optional. Size in GB of the boot disk (default is 500GB).
        :param pulumi.Input[str] boot_disk_type: Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-ssd" (Persistent Disk Solid State Drive) or "pd-standard" (Persistent Disk Hard Disk Drive).
        :param pulumi.Input[int] num_local_ssds: Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if boot_disk_type is not None:
            pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        if num_local_ssds is not None:
            pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Size in GB of the boot disk (default is 500GB).
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @boot_disk_size_gb.setter
    def boot_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "boot_disk_size_gb", value)

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-ssd" (Persistent Disk Solid State Drive) or "pd-standard" (Persistent Disk Hard Disk Drive).
        """
        return pulumi.get(self, "boot_disk_type")

    @boot_disk_type.setter
    def boot_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_disk_type", value)

    @property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        return pulumi.get(self, "num_local_ssds")

    @num_local_ssds.setter
    def num_local_ssds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_local_ssds", value)


@pulumi.input_type
class WorkflowTemplatePlacementManagedClusterConfigWorkerConfigManagedGroupConfigArgs:
    def __init__(__self__, *,
                 instance_group_manager_name: Optional[pulumi.Input[str]] = None,
                 instance_template_name: Optional[pulumi.Input[str]] = None):
        if instance_group_manager_name is not None:
            pulumi.set(__self__, "instance_group_manager_name", instance_group_manager_name)
        if instance_template_name is not None:
            pulumi.set(__self__, "instance_template_name", instance_template_name)

    @property
    @pulumi.getter(name="instanceGroupManagerName")
    def instance_group_manager_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "instance_group_manager_name")

    @instance_group_manager_name.setter
    def instance_group_manager_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_group_manager_name", value)

    @property
    @pulumi.getter(name="instanceTemplateName")
    def instance_template_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "instance_template_name")

    @instance_template_name.setter
    def instance_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_template_name", value)


