# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResponsePolicyArgs', 'ResponsePolicy']

@pulumi.input_type
class ResponsePolicyArgs:
    def __init__(__self__, *,
                 response_policy_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePolicyNetworkArgs']]]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ResponsePolicy resource.
        :param pulumi.Input[str] response_policy_name: The user assigned name for this Response Policy, such as `myresponsepolicy`.
        :param pulumi.Input[str] description: The description of the response policy, such as `My new response policy`.
        :param pulumi.Input[Sequence[pulumi.Input['ResponsePolicyNetworkArgs']]] networks: The list of network names specifying networks to which this policy is applied.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "response_policy_name", response_policy_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="responsePolicyName")
    def response_policy_name(self) -> pulumi.Input[str]:
        """
        The user assigned name for this Response Policy, such as `myresponsepolicy`.
        """
        return pulumi.get(self, "response_policy_name")

    @response_policy_name.setter
    def response_policy_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "response_policy_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the response policy, such as `My new response policy`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePolicyNetworkArgs']]]]:
        """
        The list of network names specifying networks to which this policy is applied.
        Structure is documented below.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePolicyNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ResponsePolicyState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePolicyNetworkArgs']]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 response_policy_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ResponsePolicy resources.
        :param pulumi.Input[str] description: The description of the response policy, such as `My new response policy`.
        :param pulumi.Input[Sequence[pulumi.Input['ResponsePolicyNetworkArgs']]] networks: The list of network names specifying networks to which this policy is applied.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] response_policy_name: The user assigned name for this Response Policy, such as `myresponsepolicy`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if response_policy_name is not None:
            pulumi.set(__self__, "response_policy_name", response_policy_name)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the response policy, such as `My new response policy`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePolicyNetworkArgs']]]]:
        """
        The list of network names specifying networks to which this policy is applied.
        Structure is documented below.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResponsePolicyNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="responsePolicyName")
    def response_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user assigned name for this Response Policy, such as `myresponsepolicy`.
        """
        return pulumi.get(self, "response_policy_name")

    @response_policy_name.setter
    def response_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_policy_name", value)


class ResponsePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ResponsePolicyNetworkArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 response_policy_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Dns Response Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_1 = gcp.compute.Network("network-1", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        network_2 = gcp.compute.Network("network-2", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        example_response_policy = gcp.dns.ResponsePolicy("example-response-policy",
            response_policy_name="example-response-policy",
            networks=[
                gcp.dns.ResponsePolicyNetworkArgs(
                    network_url=network_1.id,
                ),
                gcp.dns.ResponsePolicyNetworkArgs(
                    network_url=network_2.id,
                ),
            ],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        ResponsePolicy can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:dns/responsePolicy:ResponsePolicy default projects/{{project}}/responsePolicies/{{response_policy_name}}
        ```

        ```sh
         $ pulumi import gcp:dns/responsePolicy:ResponsePolicy default {{project}}/{{response_policy_name}}
        ```

        ```sh
         $ pulumi import gcp:dns/responsePolicy:ResponsePolicy default {{response_policy_name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the response policy, such as `My new response policy`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ResponsePolicyNetworkArgs']]]] networks: The list of network names specifying networks to which this policy is applied.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] response_policy_name: The user assigned name for this Response Policy, such as `myresponsepolicy`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResponsePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Dns Response Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_1 = gcp.compute.Network("network-1", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        network_2 = gcp.compute.Network("network-2", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        example_response_policy = gcp.dns.ResponsePolicy("example-response-policy",
            response_policy_name="example-response-policy",
            networks=[
                gcp.dns.ResponsePolicyNetworkArgs(
                    network_url=network_1.id,
                ),
                gcp.dns.ResponsePolicyNetworkArgs(
                    network_url=network_2.id,
                ),
            ],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        ResponsePolicy can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:dns/responsePolicy:ResponsePolicy default projects/{{project}}/responsePolicies/{{response_policy_name}}
        ```

        ```sh
         $ pulumi import gcp:dns/responsePolicy:ResponsePolicy default {{project}}/{{response_policy_name}}
        ```

        ```sh
         $ pulumi import gcp:dns/responsePolicy:ResponsePolicy default {{response_policy_name}}
        ```

        :param str resource_name: The name of the resource.
        :param ResponsePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResponsePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ResponsePolicyNetworkArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 response_policy_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResponsePolicyArgs.__new__(ResponsePolicyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["networks"] = networks
            __props__.__dict__["project"] = project
            if response_policy_name is None and not opts.urn:
                raise TypeError("Missing required property 'response_policy_name'")
            __props__.__dict__["response_policy_name"] = response_policy_name
        super(ResponsePolicy, __self__).__init__(
            'gcp:dns/responsePolicy:ResponsePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ResponsePolicyNetworkArgs']]]]] = None,
            project: Optional[pulumi.Input[str]] = None,
            response_policy_name: Optional[pulumi.Input[str]] = None) -> 'ResponsePolicy':
        """
        Get an existing ResponsePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the response policy, such as `My new response policy`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ResponsePolicyNetworkArgs']]]] networks: The list of network names specifying networks to which this policy is applied.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] response_policy_name: The user assigned name for this Response Policy, such as `myresponsepolicy`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResponsePolicyState.__new__(_ResponsePolicyState)

        __props__.__dict__["description"] = description
        __props__.__dict__["networks"] = networks
        __props__.__dict__["project"] = project
        __props__.__dict__["response_policy_name"] = response_policy_name
        return ResponsePolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the response policy, such as `My new response policy`.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Optional[Sequence['outputs.ResponsePolicyNetwork']]]:
        """
        The list of network names specifying networks to which this policy is applied.
        Structure is documented below.
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="responsePolicyName")
    def response_policy_name(self) -> pulumi.Output[str]:
        """
        The user assigned name for this Response Policy, such as `myresponsepolicy`.
        """
        return pulumi.get(self, "response_policy_name")

