# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'EdgeCacheKeysetPublicKeyArgs',
    'EdgeCacheOriginTimeoutArgs',
    'EdgeCacheServiceLogConfigArgs',
    'EdgeCacheServiceRoutingArgs',
    'EdgeCacheServiceRoutingHostRuleArgs',
    'EdgeCacheServiceRoutingPathMatcherArgs',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleArgs',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionArgs',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAddArgs',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemoveArgs',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAddArgs',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemoveArgs',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatchArgs',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatchArgs',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionArgs',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyArgs',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyArgs',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyArgs',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteArgs',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirectArgs',
]

@pulumi.input_type
class EdgeCacheKeysetPublicKeyArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] id: The ID of the public key. The ID must be 1-63 characters long, and comply with RFC1035.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]*
               which means the first character must be a letter, and all following characters must be a dash, underscore, letter or digit.
        :param pulumi.Input[str] value: The base64-encoded value of the Ed25519 public key. The base64 encoding can be padded (44 bytes) or unpadded (43 bytes).
               Representations or encodings of the public key other than this will be rejected with an error.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The ID of the public key. The ID must be 1-63 characters long, and comply with RFC1035.
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]*
        which means the first character must be a letter, and all following characters must be a dash, underscore, letter or digit.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The base64-encoded value of the Ed25519 public key. The base64 encoding can be padded (44 bytes) or unpadded (43 bytes).
        Representations or encodings of the public key other than this will be rejected with an error.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class EdgeCacheOriginTimeoutArgs:
    def __init__(__self__, *,
                 connect_timeout: Optional[pulumi.Input[str]] = None,
                 max_attempts_timeout: Optional[pulumi.Input[str]] = None,
                 read_timeout: Optional[pulumi.Input[str]] = None,
                 response_timeout: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] connect_timeout: The maximum duration to wait for a single origin connection to be established, including DNS lookup, TLS handshake and TCP/QUIC connection establishment.
               Defaults to 5 seconds. The timeout must be a value between 1s and 15s.
               The connectTimeout capped by the deadline set by the request's maxAttemptsTimeout.  The last connection attempt may have a smaller connectTimeout in order to adhere to the overall maxAttemptsTimeout.
        :param pulumi.Input[str] max_attempts_timeout: The maximum time across all connection attempts to the origin, including failover origins, before returning an error to the client. A HTTP 504 will be returned if the timeout is reached before a response is returned.
               Defaults to 15 seconds. The timeout must be a value between 1s and 30s.
               If a failoverOrigin is specified, the maxAttemptsTimeout of the first configured origin sets the deadline for all connection attempts across all failoverOrigins.
        :param pulumi.Input[str] read_timeout: The maximum duration to wait between reads of a single HTTP connection/stream.
               Defaults to 15 seconds.  The timeout must be a value between 1s and 30s.
               The readTimeout is capped by the responseTimeout.  All reads of the HTTP connection/stream must be completed by the deadline set by the responseTimeout.
               If the response headers have already been written to the connection, the response will be truncated and logged.
        :param pulumi.Input[str] response_timeout: The maximum duration to wait for the last byte of a response to arrive when reading from the HTTP connection/stream.
               Defaults to 30 seconds. The timeout must be a value between 1s and 120s.
               The responseTimeout starts after the connection has been established.
               This also applies to HTTP Chunked Transfer Encoding responses, and/or when an open-ended Range request is made to the origin. Origins that take longer to write additional bytes to the response than the configured responseTimeout will result in an error being returned to the client.
               If the response headers have already been written to the connection, the response will be truncated and logged.
        """
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if max_attempts_timeout is not None:
            pulumi.set(__self__, "max_attempts_timeout", max_attempts_timeout)
        if read_timeout is not None:
            pulumi.set(__self__, "read_timeout", read_timeout)
        if response_timeout is not None:
            pulumi.set(__self__, "response_timeout", response_timeout)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum duration to wait for a single origin connection to be established, including DNS lookup, TLS handshake and TCP/QUIC connection establishment.
        Defaults to 5 seconds. The timeout must be a value between 1s and 15s.
        The connectTimeout capped by the deadline set by the request's maxAttemptsTimeout.  The last connection attempt may have a smaller connectTimeout in order to adhere to the overall maxAttemptsTimeout.
        """
        return pulumi.get(self, "connect_timeout")

    @connect_timeout.setter
    def connect_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connect_timeout", value)

    @property
    @pulumi.getter(name="maxAttemptsTimeout")
    def max_attempts_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum time across all connection attempts to the origin, including failover origins, before returning an error to the client. A HTTP 504 will be returned if the timeout is reached before a response is returned.
        Defaults to 15 seconds. The timeout must be a value between 1s and 30s.
        If a failoverOrigin is specified, the maxAttemptsTimeout of the first configured origin sets the deadline for all connection attempts across all failoverOrigins.
        """
        return pulumi.get(self, "max_attempts_timeout")

    @max_attempts_timeout.setter
    def max_attempts_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_attempts_timeout", value)

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum duration to wait between reads of a single HTTP connection/stream.
        Defaults to 15 seconds.  The timeout must be a value between 1s and 30s.
        The readTimeout is capped by the responseTimeout.  All reads of the HTTP connection/stream must be completed by the deadline set by the responseTimeout.
        If the response headers have already been written to the connection, the response will be truncated and logged.
        """
        return pulumi.get(self, "read_timeout")

    @read_timeout.setter
    def read_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "read_timeout", value)

    @property
    @pulumi.getter(name="responseTimeout")
    def response_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum duration to wait for the last byte of a response to arrive when reading from the HTTP connection/stream.
        Defaults to 30 seconds. The timeout must be a value between 1s and 120s.
        The responseTimeout starts after the connection has been established.
        This also applies to HTTP Chunked Transfer Encoding responses, and/or when an open-ended Range request is made to the origin. Origins that take longer to write additional bytes to the response than the configured responseTimeout will result in an error being returned to the client.
        If the response headers have already been written to the connection, the response will be truncated and logged.
        """
        return pulumi.get(self, "response_timeout")

    @response_timeout.setter
    def response_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_timeout", value)


@pulumi.input_type
class EdgeCacheServiceLogConfigArgs:
    def __init__(__self__, *,
                 enable: Optional[pulumi.Input[bool]] = None,
                 sample_rate: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[bool] enable: Specifies whether to enable logging for traffic served by this service.
        :param pulumi.Input[float] sample_rate: Configures the sampling rate of requests, where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0, and the value of the field must be in [0, 1].
               This field can only be specified if logging is enabled for this service.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if sample_rate is not None:
            pulumi.set(__self__, "sample_rate", sample_rate)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable logging for traffic served by this service.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="sampleRate")
    def sample_rate(self) -> Optional[pulumi.Input[float]]:
        """
        Configures the sampling rate of requests, where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0, and the value of the field must be in [0, 1].
        This field can only be specified if logging is enabled for this service.
        """
        return pulumi.get(self, "sample_rate")

    @sample_rate.setter
    def sample_rate(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "sample_rate", value)


@pulumi.input_type
class EdgeCacheServiceRoutingArgs:
    def __init__(__self__, *,
                 host_rules: pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingHostRuleArgs']]],
                 path_matchers: pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingHostRuleArgs']]] host_rules: The list of hostRules to match against. These rules define which hostnames the EdgeCacheService will match against, and which route configurations apply.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherArgs']]] path_matchers: The name of the pathMatcher associated with this hostRule.
        """
        pulumi.set(__self__, "host_rules", host_rules)
        pulumi.set(__self__, "path_matchers", path_matchers)

    @property
    @pulumi.getter(name="hostRules")
    def host_rules(self) -> pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingHostRuleArgs']]]:
        """
        The list of hostRules to match against. These rules define which hostnames the EdgeCacheService will match against, and which route configurations apply.
        Structure is documented below.
        """
        return pulumi.get(self, "host_rules")

    @host_rules.setter
    def host_rules(self, value: pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingHostRuleArgs']]]):
        pulumi.set(self, "host_rules", value)

    @property
    @pulumi.getter(name="pathMatchers")
    def path_matchers(self) -> pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherArgs']]]:
        """
        The name of the pathMatcher associated with this hostRule.
        """
        return pulumi.get(self, "path_matchers")

    @path_matchers.setter
    def path_matchers(self, value: pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherArgs']]]):
        pulumi.set(self, "path_matchers", value)


@pulumi.input_type
class EdgeCacheServiceRoutingHostRuleArgs:
    def __init__(__self__, *,
                 hosts: pulumi.Input[Sequence[pulumi.Input[str]]],
                 path_matcher: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hosts: The list of host patterns to match.
               Host patterns must be valid hostnames. Ports are not allowed. Wildcard hosts are supported in the suffix or prefix form. * matches any string of ([a-z0-9-.]*). It does not match the empty string.
               When multiple hosts are specified, hosts are matched in the following priority:
               1. Exact domain names: ``www.foo.com``.
               2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
               3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
               4. Special wildcard ``*`` matching any domain.
               Notes:
               The wildcard will not match the empty string. e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``. The longest wildcards match first. Only a single host in the entire service can match on ``*``. A domain must be unique across all configured hosts within a service.
               Hosts are matched against the HTTP Host header, or for HTTP/2 and HTTP/3, the ":authority" header, from the incoming request.
               You may specify up to 10 hosts.
        :param pulumi.Input[str] path_matcher: The name of the pathMatcher associated with this hostRule.
        :param pulumi.Input[str] description: A human-readable description of the resource.
        """
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "path_matcher", path_matcher)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def hosts(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of host patterns to match.
        Host patterns must be valid hostnames. Ports are not allowed. Wildcard hosts are supported in the suffix or prefix form. * matches any string of ([a-z0-9-.]*). It does not match the empty string.
        When multiple hosts are specified, hosts are matched in the following priority:
        1. Exact domain names: ``www.foo.com``.
        2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
        3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
        4. Special wildcard ``*`` matching any domain.
        Notes:
        The wildcard will not match the empty string. e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``. The longest wildcards match first. Only a single host in the entire service can match on ``*``. A domain must be unique across all configured hosts within a service.
        Hosts are matched against the HTTP Host header, or for HTTP/2 and HTTP/3, the ":authority" header, from the incoming request.
        You may specify up to 10 hosts.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter(name="pathMatcher")
    def path_matcher(self) -> pulumi.Input[str]:
        """
        The name of the pathMatcher associated with this hostRule.
        """
        return pulumi.get(self, "path_matcher")

    @path_matcher.setter
    def path_matcher(self, value: pulumi.Input[str]):
        pulumi.set(self, "path_matcher", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class EdgeCacheServiceRoutingPathMatcherArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 route_rules: pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleArgs']]],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleArgs']]] route_rules: The routeRules to match against. routeRules support advanced routing behaviour, and can match on paths, headers and query parameters, as well as status codes and HTTP methods.
               Structure is documented below.
        :param pulumi.Input[str] description: A human-readable description of the resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "route_rules", route_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="routeRules")
    def route_rules(self) -> pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleArgs']]]:
        """
        The routeRules to match against. routeRules support advanced routing behaviour, and can match on paths, headers and query parameters, as well as status codes and HTTP methods.
        Structure is documented below.
        """
        return pulumi.get(self, "route_rules")

    @route_rules.setter
    def route_rules(self, value: pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleArgs']]]):
        pulumi.set(self, "route_rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleArgs:
    def __init__(__self__, *,
                 match_rules: pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs']]],
                 priority: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 header_action: Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionArgs']] = None,
                 origin: Optional[pulumi.Input[str]] = None,
                 route_action: Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionArgs']] = None,
                 url_redirect: Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirectArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs']]] match_rules: The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates
               within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
               Structure is documented below.
        :param pulumi.Input[str] priority: The priority of this route rule, where 1 is the highest priority.
               You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number between 1 and 999 inclusive.
               Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers
               to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
        :param pulumi.Input[str] description: A human-readable description of the resource.
        :param pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionArgs'] header_action: The header actions, including adding & removing headers, for requests that match this route.
               Structure is documented below.
        :param pulumi.Input[str] origin: The Origin resource that requests to this route should fetch from when a matching response is not in cache. Origins can be defined as short names ("my-origin") or fully-qualified resource URLs - e.g. "networkservices.googleapis.com/projects/my-project/global/edgecacheorigins/my-origin"
               Only one of origin or urlRedirect can be set.
        :param pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionArgs'] route_action: In response to a matching path, the routeAction performs advanced routing actions like URL rewrites, header transformations, etc. prior to forwarding the request to the selected origin.
               Structure is documented below.
        :param pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirectArgs'] url_redirect: The URL redirect configuration for requests that match this route.
               Structure is documented below.
        """
        pulumi.set(__self__, "match_rules", match_rules)
        pulumi.set(__self__, "priority", priority)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if header_action is not None:
            pulumi.set(__self__, "header_action", header_action)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if route_action is not None:
            pulumi.set(__self__, "route_action", route_action)
        if url_redirect is not None:
            pulumi.set(__self__, "url_redirect", url_redirect)

    @property
    @pulumi.getter(name="matchRules")
    def match_rules(self) -> pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs']]]:
        """
        The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates
        within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
        Structure is documented below.
        """
        return pulumi.get(self, "match_rules")

    @match_rules.setter
    def match_rules(self, value: pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs']]]):
        pulumi.set(self, "match_rules", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[str]:
        """
        The priority of this route rule, where 1 is the highest priority.
        You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number between 1 and 999 inclusive.
        Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers
        to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[str]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionArgs']]:
        """
        The header actions, including adding & removing headers, for requests that match this route.
        Structure is documented below.
        """
        return pulumi.get(self, "header_action")

    @header_action.setter
    def header_action(self, value: Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionArgs']]):
        pulumi.set(self, "header_action", value)

    @property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input[str]]:
        """
        The Origin resource that requests to this route should fetch from when a matching response is not in cache. Origins can be defined as short names ("my-origin") or fully-qualified resource URLs - e.g. "networkservices.googleapis.com/projects/my-project/global/edgecacheorigins/my-origin"
        Only one of origin or urlRedirect can be set.
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "origin", value)

    @property
    @pulumi.getter(name="routeAction")
    def route_action(self) -> Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionArgs']]:
        """
        In response to a matching path, the routeAction performs advanced routing actions like URL rewrites, header transformations, etc. prior to forwarding the request to the selected origin.
        Structure is documented below.
        """
        return pulumi.get(self, "route_action")

    @route_action.setter
    def route_action(self, value: Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionArgs']]):
        pulumi.set(self, "route_action", value)

    @property
    @pulumi.getter(name="urlRedirect")
    def url_redirect(self) -> Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirectArgs']]:
        """
        The URL redirect configuration for requests that match this route.
        Structure is documented below.
        """
        return pulumi.get(self, "url_redirect")

    @url_redirect.setter
    def url_redirect(self, value: Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirectArgs']]):
        pulumi.set(self, "url_redirect", value)


@pulumi.input_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionArgs:
    def __init__(__self__, *,
                 request_header_to_adds: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAddArgs']]]] = None,
                 request_header_to_removes: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemoveArgs']]]] = None,
                 response_header_to_adds: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAddArgs']]]] = None,
                 response_header_to_removes: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemoveArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAddArgs']]] request_header_to_adds: Describes a header to add.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemoveArgs']]] request_header_to_removes: A list of header names for headers that need to be removed from the request prior to forwarding the request to the origin.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAddArgs']]] response_header_to_adds: Headers to add to the response prior to sending it back to the client.
               Response headers are only sent to the client, and do not have an effect on the cache serving the response.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemoveArgs']]] response_header_to_removes: A list of header names for headers that need to be removed from the request prior to forwarding the request to the origin.
               Structure is documented below.
        """
        if request_header_to_adds is not None:
            pulumi.set(__self__, "request_header_to_adds", request_header_to_adds)
        if request_header_to_removes is not None:
            pulumi.set(__self__, "request_header_to_removes", request_header_to_removes)
        if response_header_to_adds is not None:
            pulumi.set(__self__, "response_header_to_adds", response_header_to_adds)
        if response_header_to_removes is not None:
            pulumi.set(__self__, "response_header_to_removes", response_header_to_removes)

    @property
    @pulumi.getter(name="requestHeaderToAdds")
    def request_header_to_adds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAddArgs']]]]:
        """
        Describes a header to add.
        Structure is documented below.
        """
        return pulumi.get(self, "request_header_to_adds")

    @request_header_to_adds.setter
    def request_header_to_adds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAddArgs']]]]):
        pulumi.set(self, "request_header_to_adds", value)

    @property
    @pulumi.getter(name="requestHeaderToRemoves")
    def request_header_to_removes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemoveArgs']]]]:
        """
        A list of header names for headers that need to be removed from the request prior to forwarding the request to the origin.
        Structure is documented below.
        """
        return pulumi.get(self, "request_header_to_removes")

    @request_header_to_removes.setter
    def request_header_to_removes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemoveArgs']]]]):
        pulumi.set(self, "request_header_to_removes", value)

    @property
    @pulumi.getter(name="responseHeaderToAdds")
    def response_header_to_adds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAddArgs']]]]:
        """
        Headers to add to the response prior to sending it back to the client.
        Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        Structure is documented below.
        """
        return pulumi.get(self, "response_header_to_adds")

    @response_header_to_adds.setter
    def response_header_to_adds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAddArgs']]]]):
        pulumi.set(self, "response_header_to_adds", value)

    @property
    @pulumi.getter(name="responseHeaderToRemoves")
    def response_header_to_removes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemoveArgs']]]]:
        """
        A list of header names for headers that need to be removed from the request prior to forwarding the request to the origin.
        Structure is documented below.
        """
        return pulumi.get(self, "response_header_to_removes")

    @response_header_to_removes.setter
    def response_header_to_removes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemoveArgs']]]]):
        pulumi.set(self, "response_header_to_removes", value)


@pulumi.input_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAddArgs:
    def __init__(__self__, *,
                 header_name: pulumi.Input[str],
                 header_value: pulumi.Input[str],
                 replace: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] header_name: Headers to remove from the response prior to sending it back to the client.
               Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        :param pulumi.Input[str] header_value: The value of the header to add.
        :param pulumi.Input[bool] replace: Whether to replace all existing headers with the same name.
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "header_value", header_value)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> pulumi.Input[str]:
        """
        Headers to remove from the response prior to sending it back to the client.
        Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> pulumi.Input[str]:
        """
        The value of the header to add.
        """
        return pulumi.get(self, "header_value")

    @header_value.setter
    def header_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "header_value", value)

    @property
    @pulumi.getter
    def replace(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to replace all existing headers with the same name.
        """
        return pulumi.get(self, "replace")

    @replace.setter
    def replace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replace", value)


@pulumi.input_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemoveArgs:
    def __init__(__self__, *,
                 header_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] header_name: Headers to remove from the response prior to sending it back to the client.
               Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        """
        pulumi.set(__self__, "header_name", header_name)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> pulumi.Input[str]:
        """
        Headers to remove from the response prior to sending it back to the client.
        Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "header_name", value)


@pulumi.input_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAddArgs:
    def __init__(__self__, *,
                 header_name: pulumi.Input[str],
                 header_value: pulumi.Input[str],
                 replace: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] header_name: Headers to remove from the response prior to sending it back to the client.
               Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        :param pulumi.Input[str] header_value: The value of the header to add.
        :param pulumi.Input[bool] replace: Whether to replace all existing headers with the same name.
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "header_value", header_value)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> pulumi.Input[str]:
        """
        Headers to remove from the response prior to sending it back to the client.
        Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> pulumi.Input[str]:
        """
        The value of the header to add.
        """
        return pulumi.get(self, "header_value")

    @header_value.setter
    def header_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "header_value", value)

    @property
    @pulumi.getter
    def replace(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to replace all existing headers with the same name.
        """
        return pulumi.get(self, "replace")

    @replace.setter
    def replace(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replace", value)


@pulumi.input_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemoveArgs:
    def __init__(__self__, *,
                 header_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] header_name: Headers to remove from the response prior to sending it back to the client.
               Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        """
        pulumi.set(__self__, "header_name", header_name)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> pulumi.Input[str]:
        """
        Headers to remove from the response prior to sending it back to the client.
        Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "header_name", value)


@pulumi.input_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs:
    def __init__(__self__, *,
                 full_path_match: Optional[pulumi.Input[str]] = None,
                 header_matches: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatchArgs']]]] = None,
                 ignore_case: Optional[pulumi.Input[bool]] = None,
                 path_template_match: Optional[pulumi.Input[str]] = None,
                 prefix_match: Optional[pulumi.Input[str]] = None,
                 query_parameter_matches: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatchArgs']]]] = None):
        """
        :param pulumi.Input[str] full_path_match: For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatchArgs']]] header_matches: Specifies a list of header match criteria, all of which must match corresponding headers in the request.
               Structure is documented below.
        :param pulumi.Input[bool] ignore_case: Specifies that prefixMatch and fullPathMatch matches are case sensitive.
        :param pulumi.Input[str] path_template_match: For satisfying the matchRule condition, the path of the request
               must match the wildcard pattern specified in pathTemplateMatch
               after removing any query parameters and anchor that may be part
               of the original URL.
               pathTemplateMatch must be between 1 and 255 characters
               (inclusive).  The pattern specified by pathTemplateMatch may
               have at most 5 wildcard operators and at most 5 variable
               captures in total.
        :param pulumi.Input[str] prefix_match: The value of the header must start with the contents of prefixMatch.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatchArgs']]] query_parameter_matches: Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request.
               Structure is documented below.
        """
        if full_path_match is not None:
            pulumi.set(__self__, "full_path_match", full_path_match)
        if header_matches is not None:
            pulumi.set(__self__, "header_matches", header_matches)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if path_template_match is not None:
            pulumi.set(__self__, "path_template_match", path_template_match)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)
        if query_parameter_matches is not None:
            pulumi.set(__self__, "query_parameter_matches", query_parameter_matches)

    @property
    @pulumi.getter(name="fullPathMatch")
    def full_path_match(self) -> Optional[pulumi.Input[str]]:
        """
        For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL.
        """
        return pulumi.get(self, "full_path_match")

    @full_path_match.setter
    def full_path_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_path_match", value)

    @property
    @pulumi.getter(name="headerMatches")
    def header_matches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatchArgs']]]]:
        """
        Specifies a list of header match criteria, all of which must match corresponding headers in the request.
        Structure is documented below.
        """
        return pulumi.get(self, "header_matches")

    @header_matches.setter
    def header_matches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatchArgs']]]]):
        pulumi.set(self, "header_matches", value)

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies that prefixMatch and fullPathMatch matches are case sensitive.
        """
        return pulumi.get(self, "ignore_case")

    @ignore_case.setter
    def ignore_case(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_case", value)

    @property
    @pulumi.getter(name="pathTemplateMatch")
    def path_template_match(self) -> Optional[pulumi.Input[str]]:
        """
        For satisfying the matchRule condition, the path of the request
        must match the wildcard pattern specified in pathTemplateMatch
        after removing any query parameters and anchor that may be part
        of the original URL.
        pathTemplateMatch must be between 1 and 255 characters
        (inclusive).  The pattern specified by pathTemplateMatch may
        have at most 5 wildcard operators and at most 5 variable
        captures in total.
        """
        return pulumi.get(self, "path_template_match")

    @path_template_match.setter
    def path_template_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_template_match", value)

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the header must start with the contents of prefixMatch.
        """
        return pulumi.get(self, "prefix_match")

    @prefix_match.setter
    def prefix_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix_match", value)

    @property
    @pulumi.getter(name="queryParameterMatches")
    def query_parameter_matches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatchArgs']]]]:
        """
        Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request.
        Structure is documented below.
        """
        return pulumi.get(self, "query_parameter_matches")

    @query_parameter_matches.setter
    def query_parameter_matches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatchArgs']]]]):
        pulumi.set(self, "query_parameter_matches", value)


@pulumi.input_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatchArgs:
    def __init__(__self__, *,
                 header_name: pulumi.Input[str],
                 exact_match: Optional[pulumi.Input[str]] = None,
                 invert_match: Optional[pulumi.Input[bool]] = None,
                 prefix_match: Optional[pulumi.Input[str]] = None,
                 present_match: Optional[pulumi.Input[bool]] = None,
                 suffix_match: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] header_name: Headers to remove from the response prior to sending it back to the client.
               Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        :param pulumi.Input[str] exact_match: The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch.
        :param pulumi.Input[bool] invert_match: If set to false (default), the headerMatch is considered a match if the match criteria above are met.
               If set to true, the headerMatch is considered a match if the match criteria above are NOT met.
        :param pulumi.Input[str] prefix_match: The value of the header must start with the contents of prefixMatch.
        :param pulumi.Input[bool] present_match: Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not.
        :param pulumi.Input[str] suffix_match: The value of the header must end with the contents of suffixMatch.
        """
        pulumi.set(__self__, "header_name", header_name)
        if exact_match is not None:
            pulumi.set(__self__, "exact_match", exact_match)
        if invert_match is not None:
            pulumi.set(__self__, "invert_match", invert_match)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)
        if present_match is not None:
            pulumi.set(__self__, "present_match", present_match)
        if suffix_match is not None:
            pulumi.set(__self__, "suffix_match", suffix_match)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> pulumi.Input[str]:
        """
        Headers to remove from the response prior to sending it back to the client.
        Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter(name="exactMatch")
    def exact_match(self) -> Optional[pulumi.Input[str]]:
        """
        The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch.
        """
        return pulumi.get(self, "exact_match")

    @exact_match.setter
    def exact_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exact_match", value)

    @property
    @pulumi.getter(name="invertMatch")
    def invert_match(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to false (default), the headerMatch is considered a match if the match criteria above are met.
        If set to true, the headerMatch is considered a match if the match criteria above are NOT met.
        """
        return pulumi.get(self, "invert_match")

    @invert_match.setter
    def invert_match(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invert_match", value)

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the header must start with the contents of prefixMatch.
        """
        return pulumi.get(self, "prefix_match")

    @prefix_match.setter
    def prefix_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix_match", value)

    @property
    @pulumi.getter(name="presentMatch")
    def present_match(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not.
        """
        return pulumi.get(self, "present_match")

    @present_match.setter
    def present_match(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "present_match", value)

    @property
    @pulumi.getter(name="suffixMatch")
    def suffix_match(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the header must end with the contents of suffixMatch.
        """
        return pulumi.get(self, "suffix_match")

    @suffix_match.setter
    def suffix_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "suffix_match", value)


@pulumi.input_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatchArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 exact_match: Optional[pulumi.Input[str]] = None,
                 present_match: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] name: The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        :param pulumi.Input[str] exact_match: The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch.
        :param pulumi.Input[bool] present_match: Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not.
        """
        pulumi.set(__self__, "name", name)
        if exact_match is not None:
            pulumi.set(__self__, "exact_match", exact_match)
        if present_match is not None:
            pulumi.set(__self__, "present_match", present_match)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="exactMatch")
    def exact_match(self) -> Optional[pulumi.Input[str]]:
        """
        The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch.
        """
        return pulumi.get(self, "exact_match")

    @exact_match.setter
    def exact_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exact_match", value)

    @property
    @pulumi.getter(name="presentMatch")
    def present_match(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not.
        """
        return pulumi.get(self, "present_match")

    @present_match.setter
    def present_match(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "present_match", value)


@pulumi.input_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionArgs:
    def __init__(__self__, *,
                 cdn_policy: Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyArgs']] = None,
                 cors_policy: Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyArgs']] = None,
                 url_rewrite: Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteArgs']] = None):
        """
        :param pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyArgs'] cdn_policy: The policy to use for defining caching and signed request behaviour for requests that match this route.
               Structure is documented below.
        :param pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyArgs'] cors_policy: CORSPolicy defines Cross-Origin-Resource-Sharing configuration, including which CORS response headers will be set.
               Structure is documented below.
        :param pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteArgs'] url_rewrite: The URL rewrite configuration for requests that match this route.
               Structure is documented below.
        """
        if cdn_policy is not None:
            pulumi.set(__self__, "cdn_policy", cdn_policy)
        if cors_policy is not None:
            pulumi.set(__self__, "cors_policy", cors_policy)
        if url_rewrite is not None:
            pulumi.set(__self__, "url_rewrite", url_rewrite)

    @property
    @pulumi.getter(name="cdnPolicy")
    def cdn_policy(self) -> Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyArgs']]:
        """
        The policy to use for defining caching and signed request behaviour for requests that match this route.
        Structure is documented below.
        """
        return pulumi.get(self, "cdn_policy")

    @cdn_policy.setter
    def cdn_policy(self, value: Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyArgs']]):
        pulumi.set(self, "cdn_policy", value)

    @property
    @pulumi.getter(name="corsPolicy")
    def cors_policy(self) -> Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyArgs']]:
        """
        CORSPolicy defines Cross-Origin-Resource-Sharing configuration, including which CORS response headers will be set.
        Structure is documented below.
        """
        return pulumi.get(self, "cors_policy")

    @cors_policy.setter
    def cors_policy(self, value: Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyArgs']]):
        pulumi.set(self, "cors_policy", value)

    @property
    @pulumi.getter(name="urlRewrite")
    def url_rewrite(self) -> Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteArgs']]:
        """
        The URL rewrite configuration for requests that match this route.
        Structure is documented below.
        """
        return pulumi.get(self, "url_rewrite")

    @url_rewrite.setter
    def url_rewrite(self, value: Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteArgs']]):
        pulumi.set(self, "url_rewrite", value)


@pulumi.input_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyArgs:
    def __init__(__self__, *,
                 cache_key_policy: Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyArgs']] = None,
                 cache_mode: Optional[pulumi.Input[str]] = None,
                 client_ttl: Optional[pulumi.Input[str]] = None,
                 default_ttl: Optional[pulumi.Input[str]] = None,
                 max_ttl: Optional[pulumi.Input[str]] = None,
                 negative_caching: Optional[pulumi.Input[bool]] = None,
                 negative_caching_policy: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 signed_request_keyset: Optional[pulumi.Input[str]] = None,
                 signed_request_mode: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyArgs'] cache_key_policy: Defines the request parameters that contribute to the cache key.
               Structure is documented below.
        :param pulumi.Input[str] cache_mode: Cache modes allow users to control the behaviour of the cache, what content it should cache automatically, whether to respect origin headers, or whether to unconditionally cache all responses.
               For all cache modes, Cache-Control headers will be passed to the client. Use clientTtl to override what is sent to the client.
               Possible values are `CACHE_ALL_STATIC`, `USE_ORIGIN_HEADERS`, `FORCE_CACHE_ALL`, and `BYPASS_CACHE`.
        :param pulumi.Input[str] client_ttl: Specifies a separate client (e.g. browser client) TTL, separate from the TTL used by the edge caches. Leaving this empty will use the same cache TTL for both the CDN and the client-facing response.
               - The TTL must be > 0 and <= 86400s (1 day)
               - The clientTtl cannot be larger than the defaultTtl (if set)
               - Fractions of a second are not allowed.
               Omit this field to use the defaultTtl, or the max-age set by the origin, as the client-facing TTL.
               When the cache mode is set to "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
               A duration in seconds terminated by 's'. Example: "3s".
        :param pulumi.Input[str] default_ttl: Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age).
               Defaults to 3600s (1 hour).
               - The TTL must be >= 0 and <= 31,536,000 seconds (1 year)
               - Setting a TTL of "0" means "always revalidate" (equivalent to must-revalidate)
               - The value of defaultTTL cannot be set to a value greater than that of maxTTL.
               - Fractions of a second are not allowed.
               - When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses.
               Note that infrequently accessed objects may be evicted from the cache before the defined TTL. Objects that expire will be revalidated with the origin.
               When the cache mode is set to "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
               A duration in seconds terminated by 's'. Example: "3s".
        :param pulumi.Input[str] max_ttl: Specifies the maximum allowed TTL for cached content served by this origin.
               Defaults to 86400s (1 day).
               Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTtl seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive.
               - The TTL must be >= 0 and <= 31,536,000 seconds (1 year)
               - Setting a TTL of "0" means "always revalidate"
               - The value of maxTtl must be equal to or greater than defaultTtl.
               - Fractions of a second are not allowed.
               When the cache mode is set to "USE_ORIGIN_HEADERS", "FORCE_CACHE_ALL", or "BYPASS_CACHE", you must omit this field.
               A duration in seconds terminated by 's'. Example: "3s".
        :param pulumi.Input[bool] negative_caching: Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency.
               By default, the CDNPolicy will apply the following default TTLs to these status codes:
               - HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m
               - HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s
               - HTTP 405 (Method Not Found), 414 (URI Too Long), 501 (Not Implemented): 60s
               These defaults can be overridden in negativeCachingPolicy
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] negative_caching_policy: Sets a cache TTL for the specified HTTP status code. negativeCaching must be enabled to configure negativeCachingPolicy.
               - Omitting the policy and leaving negativeCaching enabled will use the default TTLs for each status code, defined in negativeCaching.
               - TTLs must be >= 0 (where 0 is "always revalidate") and <= 86400s (1 day)
               Note that when specifying an explicit negativeCachingPolicy, you should take care to specify a cache TTL for all response codes that you wish to cache. The CDNPolicy will not apply any default negative caching when a policy exists.
        :param pulumi.Input[str] signed_request_keyset: The EdgeCacheKeyset containing the set of public keys used to validate signed requests at the edge.
        :param pulumi.Input[str] signed_request_mode: Whether to enforce signed requests. The default value is DISABLED, which means all content is public, and does not authorize access.
               You must also set a signedRequestKeyset to enable signed requests.
               When set to REQUIRE_SIGNATURES, all matching requests will have their signature validated. Requests that were not signed with the corresponding private key, or that are otherwise invalid (expired, do not match the signature, IP address, or header) will be rejected with a HTTP 403 and (if enabled) logged.
               Possible values are `DISABLED` and `REQUIRE_SIGNATURES`.
        """
        if cache_key_policy is not None:
            pulumi.set(__self__, "cache_key_policy", cache_key_policy)
        if cache_mode is not None:
            pulumi.set(__self__, "cache_mode", cache_mode)
        if client_ttl is not None:
            pulumi.set(__self__, "client_ttl", client_ttl)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if negative_caching is not None:
            pulumi.set(__self__, "negative_caching", negative_caching)
        if negative_caching_policy is not None:
            pulumi.set(__self__, "negative_caching_policy", negative_caching_policy)
        if signed_request_keyset is not None:
            pulumi.set(__self__, "signed_request_keyset", signed_request_keyset)
        if signed_request_mode is not None:
            pulumi.set(__self__, "signed_request_mode", signed_request_mode)

    @property
    @pulumi.getter(name="cacheKeyPolicy")
    def cache_key_policy(self) -> Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyArgs']]:
        """
        Defines the request parameters that contribute to the cache key.
        Structure is documented below.
        """
        return pulumi.get(self, "cache_key_policy")

    @cache_key_policy.setter
    def cache_key_policy(self, value: Optional[pulumi.Input['EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyArgs']]):
        pulumi.set(self, "cache_key_policy", value)

    @property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Cache modes allow users to control the behaviour of the cache, what content it should cache automatically, whether to respect origin headers, or whether to unconditionally cache all responses.
        For all cache modes, Cache-Control headers will be passed to the client. Use clientTtl to override what is sent to the client.
        Possible values are `CACHE_ALL_STATIC`, `USE_ORIGIN_HEADERS`, `FORCE_CACHE_ALL`, and `BYPASS_CACHE`.
        """
        return pulumi.get(self, "cache_mode")

    @cache_mode.setter
    def cache_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_mode", value)

    @property
    @pulumi.getter(name="clientTtl")
    def client_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a separate client (e.g. browser client) TTL, separate from the TTL used by the edge caches. Leaving this empty will use the same cache TTL for both the CDN and the client-facing response.
        - The TTL must be > 0 and <= 86400s (1 day)
        - The clientTtl cannot be larger than the defaultTtl (if set)
        - Fractions of a second are not allowed.
        Omit this field to use the defaultTtl, or the max-age set by the origin, as the client-facing TTL.
        When the cache mode is set to "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
        A duration in seconds terminated by 's'. Example: "3s".
        """
        return pulumi.get(self, "client_ttl")

    @client_ttl.setter
    def client_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_ttl", value)

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age).
        Defaults to 3600s (1 hour).
        - The TTL must be >= 0 and <= 31,536,000 seconds (1 year)
        - Setting a TTL of "0" means "always revalidate" (equivalent to must-revalidate)
        - The value of defaultTTL cannot be set to a value greater than that of maxTTL.
        - Fractions of a second are not allowed.
        - When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses.
        Note that infrequently accessed objects may be evicted from the cache before the defined TTL. Objects that expire will be revalidated with the origin.
        When the cache mode is set to "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
        A duration in seconds terminated by 's'. Example: "3s".
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_ttl", value)

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the maximum allowed TTL for cached content served by this origin.
        Defaults to 86400s (1 day).
        Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTtl seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive.
        - The TTL must be >= 0 and <= 31,536,000 seconds (1 year)
        - Setting a TTL of "0" means "always revalidate"
        - The value of maxTtl must be equal to or greater than defaultTtl.
        - Fractions of a second are not allowed.
        When the cache mode is set to "USE_ORIGIN_HEADERS", "FORCE_CACHE_ALL", or "BYPASS_CACHE", you must omit this field.
        A duration in seconds terminated by 's'. Example: "3s".
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_ttl", value)

    @property
    @pulumi.getter(name="negativeCaching")
    def negative_caching(self) -> Optional[pulumi.Input[bool]]:
        """
        Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency.
        By default, the CDNPolicy will apply the following default TTLs to these status codes:
        - HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m
        - HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s
        - HTTP 405 (Method Not Found), 414 (URI Too Long), 501 (Not Implemented): 60s
        These defaults can be overridden in negativeCachingPolicy
        """
        return pulumi.get(self, "negative_caching")

    @negative_caching.setter
    def negative_caching(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negative_caching", value)

    @property
    @pulumi.getter(name="negativeCachingPolicy")
    def negative_caching_policy(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Sets a cache TTL for the specified HTTP status code. negativeCaching must be enabled to configure negativeCachingPolicy.
        - Omitting the policy and leaving negativeCaching enabled will use the default TTLs for each status code, defined in negativeCaching.
        - TTLs must be >= 0 (where 0 is "always revalidate") and <= 86400s (1 day)
        Note that when specifying an explicit negativeCachingPolicy, you should take care to specify a cache TTL for all response codes that you wish to cache. The CDNPolicy will not apply any default negative caching when a policy exists.
        """
        return pulumi.get(self, "negative_caching_policy")

    @negative_caching_policy.setter
    def negative_caching_policy(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "negative_caching_policy", value)

    @property
    @pulumi.getter(name="signedRequestKeyset")
    def signed_request_keyset(self) -> Optional[pulumi.Input[str]]:
        """
        The EdgeCacheKeyset containing the set of public keys used to validate signed requests at the edge.
        """
        return pulumi.get(self, "signed_request_keyset")

    @signed_request_keyset.setter
    def signed_request_keyset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signed_request_keyset", value)

    @property
    @pulumi.getter(name="signedRequestMode")
    def signed_request_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to enforce signed requests. The default value is DISABLED, which means all content is public, and does not authorize access.
        You must also set a signedRequestKeyset to enable signed requests.
        When set to REQUIRE_SIGNATURES, all matching requests will have their signature validated. Requests that were not signed with the corresponding private key, or that are otherwise invalid (expired, do not match the signature, IP address, or header) will be rejected with a HTTP 403 and (if enabled) logged.
        Possible values are `DISABLED` and `REQUIRE_SIGNATURES`.
        """
        return pulumi.get(self, "signed_request_mode")

    @signed_request_mode.setter
    def signed_request_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signed_request_mode", value)


@pulumi.input_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyArgs:
    def __init__(__self__, *,
                 exclude_host: Optional[pulumi.Input[bool]] = None,
                 exclude_query_string: Optional[pulumi.Input[bool]] = None,
                 excluded_query_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 include_protocol: Optional[pulumi.Input[bool]] = None,
                 included_header_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 included_query_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[bool] exclude_host: If true, requests to different hosts will be cached separately.
               Note: this should only be enabled if hosts share the same origin and content. Removing the host from the cache key may inadvertently result in different objects being cached than intended, depending on which route the first user matched.
        :param pulumi.Input[bool] exclude_query_string: If true, exclude query string parameters from the cache key
               If false (the default), include the query string parameters in
               the cache key according to includeQueryParameters and
               excludeQueryParameters. If neither includeQueryParameters nor
               excludeQueryParameters is set, the entire query string will be
               included.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_query_parameters: Names of query string parameters to exclude from cache keys. All other parameters will be included.
               Either specify includedQueryParameters or excludedQueryParameters, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        :param pulumi.Input[bool] include_protocol: If true, http and https requests will be cached separately.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] included_header_names: Names of HTTP request headers to include in cache keys. The value of the header field will be used as part of the cache key.
               - Header names must be valid HTTP RFC 7230 header field values.
               - Header field names are case insensitive
               - To include the HTTP method, use ":method"
               Note that specifying several headers, and/or headers that have a large range of values (e.g. per-user) will dramatically impact the cache hit rate, and may result in a higher eviction rate and reduced performance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] included_query_parameters: Names of query string parameters to include in cache keys. All other parameters will be excluded.
               Either specify includedQueryParameters or excludedQueryParameters, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        if exclude_host is not None:
            pulumi.set(__self__, "exclude_host", exclude_host)
        if exclude_query_string is not None:
            pulumi.set(__self__, "exclude_query_string", exclude_query_string)
        if excluded_query_parameters is not None:
            pulumi.set(__self__, "excluded_query_parameters", excluded_query_parameters)
        if include_protocol is not None:
            pulumi.set(__self__, "include_protocol", include_protocol)
        if included_header_names is not None:
            pulumi.set(__self__, "included_header_names", included_header_names)
        if included_query_parameters is not None:
            pulumi.set(__self__, "included_query_parameters", included_query_parameters)

    @property
    @pulumi.getter(name="excludeHost")
    def exclude_host(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, requests to different hosts will be cached separately.
        Note: this should only be enabled if hosts share the same origin and content. Removing the host from the cache key may inadvertently result in different objects being cached than intended, depending on which route the first user matched.
        """
        return pulumi.get(self, "exclude_host")

    @exclude_host.setter
    def exclude_host(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_host", value)

    @property
    @pulumi.getter(name="excludeQueryString")
    def exclude_query_string(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, exclude query string parameters from the cache key
        If false (the default), include the query string parameters in
        the cache key according to includeQueryParameters and
        excludeQueryParameters. If neither includeQueryParameters nor
        excludeQueryParameters is set, the entire query string will be
        included.
        """
        return pulumi.get(self, "exclude_query_string")

    @exclude_query_string.setter
    def exclude_query_string(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_query_string", value)

    @property
    @pulumi.getter(name="excludedQueryParameters")
    def excluded_query_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Names of query string parameters to exclude from cache keys. All other parameters will be included.
        Either specify includedQueryParameters or excludedQueryParameters, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        return pulumi.get(self, "excluded_query_parameters")

    @excluded_query_parameters.setter
    def excluded_query_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_query_parameters", value)

    @property
    @pulumi.getter(name="includeProtocol")
    def include_protocol(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, http and https requests will be cached separately.
        """
        return pulumi.get(self, "include_protocol")

    @include_protocol.setter
    def include_protocol(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_protocol", value)

    @property
    @pulumi.getter(name="includedHeaderNames")
    def included_header_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Names of HTTP request headers to include in cache keys. The value of the header field will be used as part of the cache key.
        - Header names must be valid HTTP RFC 7230 header field values.
        - Header field names are case insensitive
        - To include the HTTP method, use ":method"
        Note that specifying several headers, and/or headers that have a large range of values (e.g. per-user) will dramatically impact the cache hit rate, and may result in a higher eviction rate and reduced performance.
        """
        return pulumi.get(self, "included_header_names")

    @included_header_names.setter
    def included_header_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "included_header_names", value)

    @property
    @pulumi.getter(name="includedQueryParameters")
    def included_query_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Names of query string parameters to include in cache keys. All other parameters will be excluded.
        Either specify includedQueryParameters or excludedQueryParameters, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        return pulumi.get(self, "included_query_parameters")

    @included_query_parameters.setter
    def included_query_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "included_query_parameters", value)


@pulumi.input_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyArgs:
    def __init__(__self__, *,
                 max_age: pulumi.Input[str],
                 allow_credentials: Optional[pulumi.Input[bool]] = None,
                 allow_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allow_methods: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allow_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 expose_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] max_age: Specifies how long results of a preflight request can be cached by a client in seconds. Note that many browser clients enforce a maximum TTL of 600s (10 minutes).
               - Setting the value to -1 forces a pre-flight check for all requests (not recommended)
               - A maximum TTL of 86400s can be set, but note that (as above) some clients may force pre-flight checks at a more regular interval.
               - This translates to the Access-Control-Max-Age header.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[bool] allow_credentials: In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
               This translates to the Access-Control-Allow-Credentials response header.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_headers: Specifies the content for the Access-Control-Allow-Headers response header.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_methods: Specifies the content for the Access-Control-Allow-Methods response header.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_origins: Specifies the list of origins that will be allowed to do CORS requests.
               This translates to the Access-Control-Allow-Origin response header.
        :param pulumi.Input[bool] disabled: If true, specifies the CORS policy is disabled. The default value is false, which indicates that the CORS policy is in effect.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expose_headers: Specifies the content for the Access-Control-Allow-Headers response header.
        """
        pulumi.set(__self__, "max_age", max_age)
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> pulumi.Input[str]:
        """
        Specifies how long results of a preflight request can be cached by a client in seconds. Note that many browser clients enforce a maximum TTL of 600s (10 minutes).
        - Setting the value to -1 forces a pre-flight check for all requests (not recommended)
        - A maximum TTL of 86400s can be set, but note that (as above) some clients may force pre-flight checks at a more regular interval.
        - This translates to the Access-Control-Max-Age header.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "max_age")

    @max_age.setter
    def max_age(self, value: pulumi.Input[str]):
        pulumi.set(self, "max_age", value)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[pulumi.Input[bool]]:
        """
        In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
        This translates to the Access-Control-Allow-Credentials response header.
        """
        return pulumi.get(self, "allow_credentials")

    @allow_credentials.setter
    def allow_credentials(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_credentials", value)

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the content for the Access-Control-Allow-Headers response header.
        """
        return pulumi.get(self, "allow_headers")

    @allow_headers.setter
    def allow_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_headers", value)

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the content for the Access-Control-Allow-Methods response header.
        """
        return pulumi.get(self, "allow_methods")

    @allow_methods.setter
    def allow_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_methods", value)

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the list of origins that will be allowed to do CORS requests.
        This translates to the Access-Control-Allow-Origin response header.
        """
        return pulumi.get(self, "allow_origins")

    @allow_origins.setter
    def allow_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_origins", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, specifies the CORS policy is disabled. The default value is false, which indicates that the CORS policy is in effect.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the content for the Access-Control-Allow-Headers response header.
        """
        return pulumi.get(self, "expose_headers")

    @expose_headers.setter
    def expose_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "expose_headers", value)


@pulumi.input_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteArgs:
    def __init__(__self__, *,
                 host_rewrite: Optional[pulumi.Input[str]] = None,
                 path_prefix_rewrite: Optional[pulumi.Input[str]] = None,
                 path_template_rewrite: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] host_rewrite: Prior to forwarding the request to the selected origin, the request's host header is replaced with contents of hostRewrite.
        :param pulumi.Input[str] path_prefix_rewrite: Prior to forwarding the request to the selected origin, the matching portion of the request's path is replaced by pathPrefixRewrite.
        :param pulumi.Input[str] path_template_rewrite: Prior to forwarding the request to the selected origin, if the
               request matched a pathTemplateMatch, the matching portion of the
               request's path is replaced re-written using the pattern specified
               by pathTemplateRewrite.
               pathTemplateRewrite must be between 1 and 255 characters
               (inclusive), must start with a '/', and must only use variables
               captured by the route's pathTemplate matchers.
               pathTemplateRewrite may only be used when all of a route's
               MatchRules specify pathTemplate.
               Only one of pathPrefixRewrite and pathTemplateRewrite may be
               specified.
        """
        if host_rewrite is not None:
            pulumi.set(__self__, "host_rewrite", host_rewrite)
        if path_prefix_rewrite is not None:
            pulumi.set(__self__, "path_prefix_rewrite", path_prefix_rewrite)
        if path_template_rewrite is not None:
            pulumi.set(__self__, "path_template_rewrite", path_template_rewrite)

    @property
    @pulumi.getter(name="hostRewrite")
    def host_rewrite(self) -> Optional[pulumi.Input[str]]:
        """
        Prior to forwarding the request to the selected origin, the request's host header is replaced with contents of hostRewrite.
        """
        return pulumi.get(self, "host_rewrite")

    @host_rewrite.setter
    def host_rewrite(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_rewrite", value)

    @property
    @pulumi.getter(name="pathPrefixRewrite")
    def path_prefix_rewrite(self) -> Optional[pulumi.Input[str]]:
        """
        Prior to forwarding the request to the selected origin, the matching portion of the request's path is replaced by pathPrefixRewrite.
        """
        return pulumi.get(self, "path_prefix_rewrite")

    @path_prefix_rewrite.setter
    def path_prefix_rewrite(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_prefix_rewrite", value)

    @property
    @pulumi.getter(name="pathTemplateRewrite")
    def path_template_rewrite(self) -> Optional[pulumi.Input[str]]:
        """
        Prior to forwarding the request to the selected origin, if the
        request matched a pathTemplateMatch, the matching portion of the
        request's path is replaced re-written using the pattern specified
        by pathTemplateRewrite.
        pathTemplateRewrite must be between 1 and 255 characters
        (inclusive), must start with a '/', and must only use variables
        captured by the route's pathTemplate matchers.
        pathTemplateRewrite may only be used when all of a route's
        MatchRules specify pathTemplate.
        Only one of pathPrefixRewrite and pathTemplateRewrite may be
        specified.
        """
        return pulumi.get(self, "path_template_rewrite")

    @path_template_rewrite.setter
    def path_template_rewrite(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_template_rewrite", value)


@pulumi.input_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirectArgs:
    def __init__(__self__, *,
                 host_redirect: Optional[pulumi.Input[str]] = None,
                 https_redirect: Optional[pulumi.Input[bool]] = None,
                 path_redirect: Optional[pulumi.Input[str]] = None,
                 prefix_redirect: Optional[pulumi.Input[str]] = None,
                 redirect_response_code: Optional[pulumi.Input[str]] = None,
                 strip_query: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] host_redirect: The host that will be used in the redirect response instead of the one that was supplied in the request.
        :param pulumi.Input[bool] https_redirect: If set to true, the URL scheme in the redirected request is set to https. If set to false, the URL scheme of the redirected request will remain the same as that of the request.
               This can only be set if there is at least one (1) edgeSslCertificate set on the service.
        :param pulumi.Input[str] path_redirect: The path that will be used in the redirect response instead of the one that was supplied in the request.
               pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
               The path value must be between 1 and 1024 characters.
        :param pulumi.Input[str] prefix_redirect: The prefix that replaces the prefixMatch specified in the routeRule, retaining the remaining portion of the URL before redirecting the request.
               prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
        :param pulumi.Input[str] redirect_response_code: The HTTP Status code to use for this RedirectAction.
               The supported values are:
               - `MOVED_PERMANENTLY_DEFAULT`, which is the default value and corresponds to 301.
               - `FOUND`, which corresponds to 302.
        :param pulumi.Input[bool] strip_query: If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request. If set to false, the query portion of the original URL is retained.
        """
        if host_redirect is not None:
            pulumi.set(__self__, "host_redirect", host_redirect)
        if https_redirect is not None:
            pulumi.set(__self__, "https_redirect", https_redirect)
        if path_redirect is not None:
            pulumi.set(__self__, "path_redirect", path_redirect)
        if prefix_redirect is not None:
            pulumi.set(__self__, "prefix_redirect", prefix_redirect)
        if redirect_response_code is not None:
            pulumi.set(__self__, "redirect_response_code", redirect_response_code)
        if strip_query is not None:
            pulumi.set(__self__, "strip_query", strip_query)

    @property
    @pulumi.getter(name="hostRedirect")
    def host_redirect(self) -> Optional[pulumi.Input[str]]:
        """
        The host that will be used in the redirect response instead of the one that was supplied in the request.
        """
        return pulumi.get(self, "host_redirect")

    @host_redirect.setter
    def host_redirect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_redirect", value)

    @property
    @pulumi.getter(name="httpsRedirect")
    def https_redirect(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, the URL scheme in the redirected request is set to https. If set to false, the URL scheme of the redirected request will remain the same as that of the request.
        This can only be set if there is at least one (1) edgeSslCertificate set on the service.
        """
        return pulumi.get(self, "https_redirect")

    @https_redirect.setter
    def https_redirect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "https_redirect", value)

    @property
    @pulumi.getter(name="pathRedirect")
    def path_redirect(self) -> Optional[pulumi.Input[str]]:
        """
        The path that will be used in the redirect response instead of the one that was supplied in the request.
        pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
        The path value must be between 1 and 1024 characters.
        """
        return pulumi.get(self, "path_redirect")

    @path_redirect.setter
    def path_redirect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_redirect", value)

    @property
    @pulumi.getter(name="prefixRedirect")
    def prefix_redirect(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix that replaces the prefixMatch specified in the routeRule, retaining the remaining portion of the URL before redirecting the request.
        prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
        """
        return pulumi.get(self, "prefix_redirect")

    @prefix_redirect.setter
    def prefix_redirect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix_redirect", value)

    @property
    @pulumi.getter(name="redirectResponseCode")
    def redirect_response_code(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP Status code to use for this RedirectAction.
        The supported values are:
        - `MOVED_PERMANENTLY_DEFAULT`, which is the default value and corresponds to 301.
        - `FOUND`, which corresponds to 302.
        """
        return pulumi.get(self, "redirect_response_code")

    @redirect_response_code.setter
    def redirect_response_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect_response_code", value)

    @property
    @pulumi.getter(name="stripQuery")
    def strip_query(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request. If set to false, the query portion of the original URL is retained.
        """
        return pulumi.get(self, "strip_query")

    @strip_query.setter
    def strip_query(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strip_query", value)


