# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'BucketCorArgs',
    'BucketEncryptionArgs',
    'BucketIAMBindingConditionArgs',
    'BucketIAMMemberConditionArgs',
    'BucketLifecycleRuleArgs',
    'BucketLifecycleRuleActionArgs',
    'BucketLifecycleRuleConditionArgs',
    'BucketLoggingArgs',
    'BucketObjectCustomerEncryptionArgs',
    'BucketRetentionPolicyArgs',
    'BucketVersioningArgs',
    'BucketWebsiteArgs',
    'DefaultObjectAccessControlProjectTeamArgs',
    'ObjectAccessControlProjectTeamArgs',
    'TransferJobScheduleArgs',
    'TransferJobScheduleScheduleEndDateArgs',
    'TransferJobScheduleScheduleStartDateArgs',
    'TransferJobScheduleStartTimeOfDayArgs',
    'TransferJobTransferSpecArgs',
    'TransferJobTransferSpecAwsS3DataSourceArgs',
    'TransferJobTransferSpecAwsS3DataSourceAwsAccessKeyArgs',
    'TransferJobTransferSpecAzureBlobStorageDataSourceArgs',
    'TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsArgs',
    'TransferJobTransferSpecGcsDataSinkArgs',
    'TransferJobTransferSpecGcsDataSourceArgs',
    'TransferJobTransferSpecHttpDataSourceArgs',
    'TransferJobTransferSpecObjectConditionsArgs',
    'TransferJobTransferSpecPosixDataSinkArgs',
    'TransferJobTransferSpecPosixDataSourceArgs',
    'TransferJobTransferSpecTransferOptionsArgs',
]

@pulumi.input_type
class BucketCorArgs:
    def __init__(__self__, *,
                 max_age_seconds: Optional[pulumi.Input[int]] = None,
                 methods: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[int] max_age_seconds: The value, in seconds, to return in the [Access-Control-Max-Age header](https://www.w3.org/TR/cors/#access-control-max-age-response-header) used in preflight responses.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] methods: The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] origins: The list of [Origins](https://tools.ietf.org/html/rfc6454) eligible to receive CORS response headers. Note: "*" is permitted in the list of origins, and means "any Origin".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_headers: The list of HTTP headers other than the [simple response headers](https://www.w3.org/TR/cors/#simple-response-header) to give permission for the user-agent to share across domains.
        """
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if origins is not None:
            pulumi.set(__self__, "origins", origins)
        if response_headers is not None:
            pulumi.set(__self__, "response_headers", response_headers)

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The value, in seconds, to return in the [Access-Control-Max-Age header](https://www.w3.org/TR/cors/#access-control-max-age-response-header) used in preflight responses.
        """
        return pulumi.get(self, "max_age_seconds")

    @max_age_seconds.setter
    def max_age_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_age_seconds", value)

    @property
    @pulumi.getter
    def methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
        """
        return pulumi.get(self, "methods")

    @methods.setter
    def methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "methods", value)

    @property
    @pulumi.getter
    def origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of [Origins](https://tools.ietf.org/html/rfc6454) eligible to receive CORS response headers. Note: "*" is permitted in the list of origins, and means "any Origin".
        """
        return pulumi.get(self, "origins")

    @origins.setter
    def origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "origins", value)

    @property
    @pulumi.getter(name="responseHeaders")
    def response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of HTTP headers other than the [simple response headers](https://www.w3.org/TR/cors/#simple-response-header) to give permission for the user-agent to share across domains.
        """
        return pulumi.get(self, "response_headers")

    @response_headers.setter
    def response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "response_headers", value)


@pulumi.input_type
class BucketEncryptionArgs:
    def __init__(__self__, *,
                 default_kms_key_name: pulumi.Input[str]):
        pulumi.set(__self__, "default_kms_key_name", default_kms_key_name)

    @property
    @pulumi.getter(name="defaultKmsKeyName")
    def default_kms_key_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "default_kms_key_name")

    @default_kms_key_name.setter
    def default_kms_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_kms_key_name", value)


@pulumi.input_type
class BucketIAMBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] title: A title for the expression, i.e. a short string describing its purpose.
        :param pulumi.Input[str] description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class BucketIAMMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] title: A title for the expression, i.e. a short string describing its purpose.
        :param pulumi.Input[str] description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class BucketLifecycleRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['BucketLifecycleRuleActionArgs'],
                 condition: pulumi.Input['BucketLifecycleRuleConditionArgs']):
        """
        :param pulumi.Input['BucketLifecycleRuleActionArgs'] action: The Lifecycle Rule's action configuration. A single block of this type is supported. Structure is documented below.
        :param pulumi.Input['BucketLifecycleRuleConditionArgs'] condition: The Lifecycle Rule's condition configuration. A single block of this type is supported. Structure is documented below.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input['BucketLifecycleRuleActionArgs']:
        """
        The Lifecycle Rule's action configuration. A single block of this type is supported. Structure is documented below.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['BucketLifecycleRuleActionArgs']):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input['BucketLifecycleRuleConditionArgs']:
        """
        The Lifecycle Rule's condition configuration. A single block of this type is supported. Structure is documented below.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input['BucketLifecycleRuleConditionArgs']):
        pulumi.set(self, "condition", value)


@pulumi.input_type
class BucketLifecycleRuleActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 storage_class: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The type of the action of this Lifecycle Rule. Supported values include: `Delete` and `SetStorageClass`.
        :param pulumi.Input[str] storage_class: The target [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of objects affected by this Lifecycle Rule. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`.
        """
        pulumi.set(__self__, "type", type)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the action of this Lifecycle Rule. Supported values include: `Delete` and `SetStorageClass`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        The target [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of objects affected by this Lifecycle Rule. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_class", value)


@pulumi.input_type
class BucketLifecycleRuleConditionArgs:
    def __init__(__self__, *,
                 age: Optional[pulumi.Input[int]] = None,
                 created_before: Optional[pulumi.Input[str]] = None,
                 custom_time_before: Optional[pulumi.Input[str]] = None,
                 days_since_custom_time: Optional[pulumi.Input[int]] = None,
                 days_since_noncurrent_time: Optional[pulumi.Input[int]] = None,
                 matches_storage_classes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 noncurrent_time_before: Optional[pulumi.Input[str]] = None,
                 num_newer_versions: Optional[pulumi.Input[int]] = None,
                 with_state: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] age: Minimum age of an object in days to satisfy this condition.
        :param pulumi.Input[str] created_before: A date in the RFC 3339 format YYYY-MM-DD. This condition is satisfied when an object is created before midnight of the specified date in UTC.
        :param pulumi.Input[str] custom_time_before: A date in the RFC 3339 format YYYY-MM-DD. This condition is satisfied when the customTime metadata for the object is set to an earlier date than the date used in this lifecycle condition.
        :param pulumi.Input[int] days_since_custom_time: Days since the date set in the `customTime` metadata for the object. This condition is satisfied when the current date and time is at least the specified number of days after the `customTime`.
        :param pulumi.Input[int] days_since_noncurrent_time: Relevant only for versioned objects. Number of days elapsed since the noncurrent timestamp of an object.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] matches_storage_classes: [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of objects to satisfy this condition. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`, `DURABLE_REDUCED_AVAILABILITY`.
        :param pulumi.Input[str] noncurrent_time_before: Relevant only for versioned objects. The date in RFC 3339 (e.g. `2017-06-13`) when the object became nonconcurrent.
        :param pulumi.Input[int] num_newer_versions: Relevant only for versioned objects. The number of newer versions of an object to satisfy this condition.
        :param pulumi.Input[str] with_state: Match to live and/or archived objects. Unversioned buckets have only live objects. Supported values include: `"LIVE"`, `"ARCHIVED"`, `"ANY"`.
        """
        if age is not None:
            pulumi.set(__self__, "age", age)
        if created_before is not None:
            pulumi.set(__self__, "created_before", created_before)
        if custom_time_before is not None:
            pulumi.set(__self__, "custom_time_before", custom_time_before)
        if days_since_custom_time is not None:
            pulumi.set(__self__, "days_since_custom_time", days_since_custom_time)
        if days_since_noncurrent_time is not None:
            pulumi.set(__self__, "days_since_noncurrent_time", days_since_noncurrent_time)
        if matches_storage_classes is not None:
            pulumi.set(__self__, "matches_storage_classes", matches_storage_classes)
        if noncurrent_time_before is not None:
            pulumi.set(__self__, "noncurrent_time_before", noncurrent_time_before)
        if num_newer_versions is not None:
            pulumi.set(__self__, "num_newer_versions", num_newer_versions)
        if with_state is not None:
            pulumi.set(__self__, "with_state", with_state)

    @property
    @pulumi.getter
    def age(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum age of an object in days to satisfy this condition.
        """
        return pulumi.get(self, "age")

    @age.setter
    def age(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "age", value)

    @property
    @pulumi.getter(name="createdBefore")
    def created_before(self) -> Optional[pulumi.Input[str]]:
        """
        A date in the RFC 3339 format YYYY-MM-DD. This condition is satisfied when an object is created before midnight of the specified date in UTC.
        """
        return pulumi.get(self, "created_before")

    @created_before.setter
    def created_before(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_before", value)

    @property
    @pulumi.getter(name="customTimeBefore")
    def custom_time_before(self) -> Optional[pulumi.Input[str]]:
        """
        A date in the RFC 3339 format YYYY-MM-DD. This condition is satisfied when the customTime metadata for the object is set to an earlier date than the date used in this lifecycle condition.
        """
        return pulumi.get(self, "custom_time_before")

    @custom_time_before.setter
    def custom_time_before(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_time_before", value)

    @property
    @pulumi.getter(name="daysSinceCustomTime")
    def days_since_custom_time(self) -> Optional[pulumi.Input[int]]:
        """
        Days since the date set in the `customTime` metadata for the object. This condition is satisfied when the current date and time is at least the specified number of days after the `customTime`.
        """
        return pulumi.get(self, "days_since_custom_time")

    @days_since_custom_time.setter
    def days_since_custom_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days_since_custom_time", value)

    @property
    @pulumi.getter(name="daysSinceNoncurrentTime")
    def days_since_noncurrent_time(self) -> Optional[pulumi.Input[int]]:
        """
        Relevant only for versioned objects. Number of days elapsed since the noncurrent timestamp of an object.
        """
        return pulumi.get(self, "days_since_noncurrent_time")

    @days_since_noncurrent_time.setter
    def days_since_noncurrent_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days_since_noncurrent_time", value)

    @property
    @pulumi.getter(name="matchesStorageClasses")
    def matches_storage_classes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of objects to satisfy this condition. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`, `DURABLE_REDUCED_AVAILABILITY`.
        """
        return pulumi.get(self, "matches_storage_classes")

    @matches_storage_classes.setter
    def matches_storage_classes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "matches_storage_classes", value)

    @property
    @pulumi.getter(name="noncurrentTimeBefore")
    def noncurrent_time_before(self) -> Optional[pulumi.Input[str]]:
        """
        Relevant only for versioned objects. The date in RFC 3339 (e.g. `2017-06-13`) when the object became nonconcurrent.
        """
        return pulumi.get(self, "noncurrent_time_before")

    @noncurrent_time_before.setter
    def noncurrent_time_before(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "noncurrent_time_before", value)

    @property
    @pulumi.getter(name="numNewerVersions")
    def num_newer_versions(self) -> Optional[pulumi.Input[int]]:
        """
        Relevant only for versioned objects. The number of newer versions of an object to satisfy this condition.
        """
        return pulumi.get(self, "num_newer_versions")

    @num_newer_versions.setter
    def num_newer_versions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_newer_versions", value)

    @property
    @pulumi.getter(name="withState")
    def with_state(self) -> Optional[pulumi.Input[str]]:
        """
        Match to live and/or archived objects. Unversioned buckets have only live objects. Supported values include: `"LIVE"`, `"ARCHIVED"`, `"ANY"`.
        """
        return pulumi.get(self, "with_state")

    @with_state.setter
    def with_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "with_state", value)


@pulumi.input_type
class BucketLoggingArgs:
    def __init__(__self__, *,
                 log_bucket: pulumi.Input[str],
                 log_object_prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] log_bucket: The bucket that will receive log objects.
        :param pulumi.Input[str] log_object_prefix: The object prefix for log objects. If it's not provided,
               by default GCS sets this to this bucket's name.
        """
        pulumi.set(__self__, "log_bucket", log_bucket)
        if log_object_prefix is not None:
            pulumi.set(__self__, "log_object_prefix", log_object_prefix)

    @property
    @pulumi.getter(name="logBucket")
    def log_bucket(self) -> pulumi.Input[str]:
        """
        The bucket that will receive log objects.
        """
        return pulumi.get(self, "log_bucket")

    @log_bucket.setter
    def log_bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_bucket", value)

    @property
    @pulumi.getter(name="logObjectPrefix")
    def log_object_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The object prefix for log objects. If it's not provided,
        by default GCS sets this to this bucket's name.
        """
        return pulumi.get(self, "log_object_prefix")

    @log_object_prefix.setter
    def log_object_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_object_prefix", value)


@pulumi.input_type
class BucketObjectCustomerEncryptionArgs:
    def __init__(__self__, *,
                 encryption_key: pulumi.Input[str],
                 encryption_algorithm: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] encryption_key: Base64 encoded Customer-Supplied Encryption Key.
        :param pulumi.Input[str] encryption_algorithm: Encryption algorithm. Default: AES256
        """
        pulumi.set(__self__, "encryption_key", encryption_key)
        if encryption_algorithm is not None:
            pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Input[str]:
        """
        Base64 encoded Customer-Supplied Encryption Key.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Encryption algorithm. Default: AES256
        """
        return pulumi.get(self, "encryption_algorithm")

    @encryption_algorithm.setter
    def encryption_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_algorithm", value)


@pulumi.input_type
class BucketRetentionPolicyArgs:
    def __init__(__self__, *,
                 retention_period: pulumi.Input[int],
                 is_locked: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[int] retention_period: The period of time, in seconds, that objects in the bucket must be retained and cannot be deleted, overwritten, or archived. The value must be less than 2,147,483,647 seconds.
        :param pulumi.Input[bool] is_locked: If set to `true`, the bucket will be [locked](https://cloud.google.com/storage/docs/using-bucket-lock#lock-bucket) and permanently restrict edits to the bucket's retention policy.  Caution: Locking a bucket is an irreversible action.
        """
        pulumi.set(__self__, "retention_period", retention_period)
        if is_locked is not None:
            pulumi.set(__self__, "is_locked", is_locked)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> pulumi.Input[int]:
        """
        The period of time, in seconds, that objects in the bucket must be retained and cannot be deleted, overwritten, or archived. The value must be less than 2,147,483,647 seconds.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: pulumi.Input[int]):
        pulumi.set(self, "retention_period", value)

    @property
    @pulumi.getter(name="isLocked")
    def is_locked(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, the bucket will be [locked](https://cloud.google.com/storage/docs/using-bucket-lock#lock-bucket) and permanently restrict edits to the bucket's retention policy.  Caution: Locking a bucket is an irreversible action.
        """
        return pulumi.get(self, "is_locked")

    @is_locked.setter
    def is_locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_locked", value)


@pulumi.input_type
class BucketVersioningArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] enabled: While set to `true`, versioning is fully enabled for this bucket.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        While set to `true`, versioning is fully enabled for this bucket.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class BucketWebsiteArgs:
    def __init__(__self__, *,
                 main_page_suffix: Optional[pulumi.Input[str]] = None,
                 not_found_page: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] main_page_suffix: Behaves as the bucket's directory index where
               missing objects are treated as potential directories.
        :param pulumi.Input[str] not_found_page: The custom object to return when a requested
               resource is not found.
        """
        if main_page_suffix is not None:
            pulumi.set(__self__, "main_page_suffix", main_page_suffix)
        if not_found_page is not None:
            pulumi.set(__self__, "not_found_page", not_found_page)

    @property
    @pulumi.getter(name="mainPageSuffix")
    def main_page_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Behaves as the bucket's directory index where
        missing objects are treated as potential directories.
        """
        return pulumi.get(self, "main_page_suffix")

    @main_page_suffix.setter
    def main_page_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_page_suffix", value)

    @property
    @pulumi.getter(name="notFoundPage")
    def not_found_page(self) -> Optional[pulumi.Input[str]]:
        """
        The custom object to return when a requested
        resource is not found.
        """
        return pulumi.get(self, "not_found_page")

    @not_found_page.setter
    def not_found_page(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "not_found_page", value)


@pulumi.input_type
class DefaultObjectAccessControlProjectTeamArgs:
    def __init__(__self__, *,
                 project_number: Optional[pulumi.Input[str]] = None,
                 team: Optional[pulumi.Input[str]] = None):
        if project_number is not None:
            pulumi.set(__self__, "project_number", project_number)
        if team is not None:
            pulumi.set(__self__, "team", team)

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project_number")

    @project_number.setter
    def project_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_number", value)

    @property
    @pulumi.getter
    def team(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "team")

    @team.setter
    def team(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team", value)


@pulumi.input_type
class ObjectAccessControlProjectTeamArgs:
    def __init__(__self__, *,
                 project_number: Optional[pulumi.Input[str]] = None,
                 team: Optional[pulumi.Input[str]] = None):
        if project_number is not None:
            pulumi.set(__self__, "project_number", project_number)
        if team is not None:
            pulumi.set(__self__, "team", team)

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project_number")

    @project_number.setter
    def project_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_number", value)

    @property
    @pulumi.getter
    def team(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "team")

    @team.setter
    def team(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team", value)


@pulumi.input_type
class TransferJobScheduleArgs:
    def __init__(__self__, *,
                 schedule_start_date: pulumi.Input['TransferJobScheduleScheduleStartDateArgs'],
                 schedule_end_date: Optional[pulumi.Input['TransferJobScheduleScheduleEndDateArgs']] = None,
                 start_time_of_day: Optional[pulumi.Input['TransferJobScheduleStartTimeOfDayArgs']] = None):
        """
        :param pulumi.Input['TransferJobScheduleScheduleStartDateArgs'] schedule_start_date: The first day the recurring transfer is scheduled to run. If `schedule_start_date` is in the past, the transfer will run for the first time on the following day. Structure documented below.
        :param pulumi.Input['TransferJobScheduleScheduleEndDateArgs'] schedule_end_date: The last day the recurring transfer will be run. If `schedule_end_date` is the same as `schedule_start_date`, the transfer will be executed only once. Structure documented below.
        :param pulumi.Input['TransferJobScheduleStartTimeOfDayArgs'] start_time_of_day: The time in UTC at which the transfer will be scheduled to start in a day. Transfers may start later than this time. If not specified, recurring and one-time transfers that are scheduled to run today will run immediately; recurring transfers that are scheduled to run on a future date will start at approximately midnight UTC on that date. Note that when configuring a transfer with the Cloud Platform Console, the transfer's start time in a day is specified in your local timezone. Structure documented below.
        """
        pulumi.set(__self__, "schedule_start_date", schedule_start_date)
        if schedule_end_date is not None:
            pulumi.set(__self__, "schedule_end_date", schedule_end_date)
        if start_time_of_day is not None:
            pulumi.set(__self__, "start_time_of_day", start_time_of_day)

    @property
    @pulumi.getter(name="scheduleStartDate")
    def schedule_start_date(self) -> pulumi.Input['TransferJobScheduleScheduleStartDateArgs']:
        """
        The first day the recurring transfer is scheduled to run. If `schedule_start_date` is in the past, the transfer will run for the first time on the following day. Structure documented below.
        """
        return pulumi.get(self, "schedule_start_date")

    @schedule_start_date.setter
    def schedule_start_date(self, value: pulumi.Input['TransferJobScheduleScheduleStartDateArgs']):
        pulumi.set(self, "schedule_start_date", value)

    @property
    @pulumi.getter(name="scheduleEndDate")
    def schedule_end_date(self) -> Optional[pulumi.Input['TransferJobScheduleScheduleEndDateArgs']]:
        """
        The last day the recurring transfer will be run. If `schedule_end_date` is the same as `schedule_start_date`, the transfer will be executed only once. Structure documented below.
        """
        return pulumi.get(self, "schedule_end_date")

    @schedule_end_date.setter
    def schedule_end_date(self, value: Optional[pulumi.Input['TransferJobScheduleScheduleEndDateArgs']]):
        pulumi.set(self, "schedule_end_date", value)

    @property
    @pulumi.getter(name="startTimeOfDay")
    def start_time_of_day(self) -> Optional[pulumi.Input['TransferJobScheduleStartTimeOfDayArgs']]:
        """
        The time in UTC at which the transfer will be scheduled to start in a day. Transfers may start later than this time. If not specified, recurring and one-time transfers that are scheduled to run today will run immediately; recurring transfers that are scheduled to run on a future date will start at approximately midnight UTC on that date. Note that when configuring a transfer with the Cloud Platform Console, the transfer's start time in a day is specified in your local timezone. Structure documented below.
        """
        return pulumi.get(self, "start_time_of_day")

    @start_time_of_day.setter
    def start_time_of_day(self, value: Optional[pulumi.Input['TransferJobScheduleStartTimeOfDayArgs']]):
        pulumi.set(self, "start_time_of_day", value)


@pulumi.input_type
class TransferJobScheduleScheduleEndDateArgs:
    def __init__(__self__, *,
                 day: pulumi.Input[int],
                 month: pulumi.Input[int],
                 year: pulumi.Input[int]):
        """
        :param pulumi.Input[int] day: Day of month. Must be from 1 to 31 and valid for the year and month.
        :param pulumi.Input[int] month: Month of year. Must be from 1 to 12.
        :param pulumi.Input[int] year: Year of date. Must be from 1 to 9999.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> pulumi.Input[int]:
        """
        Day of month. Must be from 1 to 31 and valid for the year and month.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: pulumi.Input[int]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter
    def month(self) -> pulumi.Input[int]:
        """
        Month of year. Must be from 1 to 12.
        """
        return pulumi.get(self, "month")

    @month.setter
    def month(self, value: pulumi.Input[int]):
        pulumi.set(self, "month", value)

    @property
    @pulumi.getter
    def year(self) -> pulumi.Input[int]:
        """
        Year of date. Must be from 1 to 9999.
        """
        return pulumi.get(self, "year")

    @year.setter
    def year(self, value: pulumi.Input[int]):
        pulumi.set(self, "year", value)


@pulumi.input_type
class TransferJobScheduleScheduleStartDateArgs:
    def __init__(__self__, *,
                 day: pulumi.Input[int],
                 month: pulumi.Input[int],
                 year: pulumi.Input[int]):
        """
        :param pulumi.Input[int] day: Day of month. Must be from 1 to 31 and valid for the year and month.
        :param pulumi.Input[int] month: Month of year. Must be from 1 to 12.
        :param pulumi.Input[int] year: Year of date. Must be from 1 to 9999.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> pulumi.Input[int]:
        """
        Day of month. Must be from 1 to 31 and valid for the year and month.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: pulumi.Input[int]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter
    def month(self) -> pulumi.Input[int]:
        """
        Month of year. Must be from 1 to 12.
        """
        return pulumi.get(self, "month")

    @month.setter
    def month(self, value: pulumi.Input[int]):
        pulumi.set(self, "month", value)

    @property
    @pulumi.getter
    def year(self) -> pulumi.Input[int]:
        """
        Year of date. Must be from 1 to 9999.
        """
        return pulumi.get(self, "year")

    @year.setter
    def year(self, value: pulumi.Input[int]):
        pulumi.set(self, "year", value)


@pulumi.input_type
class TransferJobScheduleStartTimeOfDayArgs:
    def __init__(__self__, *,
                 hours: pulumi.Input[int],
                 minutes: pulumi.Input[int],
                 nanos: pulumi.Input[int],
                 seconds: pulumi.Input[int]):
        """
        :param pulumi.Input[int] hours: Hours of day in 24 hour format. Should be from 0 to 23
        :param pulumi.Input[int] minutes: Minutes of hour of day. Must be from 0 to 59.
        :param pulumi.Input[int] nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param pulumi.Input[int] seconds: Seconds of minutes of the time. Must normally be from 0 to 59.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> pulumi.Input[int]:
        """
        Hours of day in 24 hour format. Should be from 0 to 23
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: pulumi.Input[int]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> pulumi.Input[int]:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: pulumi.Input[int]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter
    def nanos(self) -> pulumi.Input[int]:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @nanos.setter
    def nanos(self, value: pulumi.Input[int]):
        pulumi.set(self, "nanos", value)

    @property
    @pulumi.getter
    def seconds(self) -> pulumi.Input[int]:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        """
        return pulumi.get(self, "seconds")

    @seconds.setter
    def seconds(self, value: pulumi.Input[int]):
        pulumi.set(self, "seconds", value)


@pulumi.input_type
class TransferJobTransferSpecArgs:
    def __init__(__self__, *,
                 aws_s3_data_source: Optional[pulumi.Input['TransferJobTransferSpecAwsS3DataSourceArgs']] = None,
                 azure_blob_storage_data_source: Optional[pulumi.Input['TransferJobTransferSpecAzureBlobStorageDataSourceArgs']] = None,
                 gcs_data_sink: Optional[pulumi.Input['TransferJobTransferSpecGcsDataSinkArgs']] = None,
                 gcs_data_source: Optional[pulumi.Input['TransferJobTransferSpecGcsDataSourceArgs']] = None,
                 http_data_source: Optional[pulumi.Input['TransferJobTransferSpecHttpDataSourceArgs']] = None,
                 object_conditions: Optional[pulumi.Input['TransferJobTransferSpecObjectConditionsArgs']] = None,
                 posix_data_sink: Optional[pulumi.Input['TransferJobTransferSpecPosixDataSinkArgs']] = None,
                 posix_data_source: Optional[pulumi.Input['TransferJobTransferSpecPosixDataSourceArgs']] = None,
                 transfer_options: Optional[pulumi.Input['TransferJobTransferSpecTransferOptionsArgs']] = None):
        """
        :param pulumi.Input['TransferJobTransferSpecAwsS3DataSourceArgs'] aws_s3_data_source: An AWS S3 data source. Structure documented below.
        :param pulumi.Input['TransferJobTransferSpecAzureBlobStorageDataSourceArgs'] azure_blob_storage_data_source: An Azure Blob Storage data source. Structure documented below.
        :param pulumi.Input['TransferJobTransferSpecGcsDataSinkArgs'] gcs_data_sink: A Google Cloud Storage data sink. Structure documented below.
        :param pulumi.Input['TransferJobTransferSpecGcsDataSourceArgs'] gcs_data_source: A Google Cloud Storage data source. Structure documented below.
        :param pulumi.Input['TransferJobTransferSpecHttpDataSourceArgs'] http_data_source: A HTTP URL data source. Structure documented below.
        :param pulumi.Input['TransferJobTransferSpecObjectConditionsArgs'] object_conditions: Only objects that satisfy these object conditions are included in the set of data source and data sink objects. Object conditions based on objects' `last_modification_time` do not exclude objects in a data sink. Structure documented below.
        :param pulumi.Input['TransferJobTransferSpecPosixDataSinkArgs'] posix_data_sink: A POSIX data sink. Structure documented below.
        :param pulumi.Input['TransferJobTransferSpecPosixDataSourceArgs'] posix_data_source: A POSIX filesystem data source. Structure documented below.
        :param pulumi.Input['TransferJobTransferSpecTransferOptionsArgs'] transfer_options: Characteristics of how to treat files from datasource and sink during job. If the option `delete_objects_unique_in_sink` is true, object conditions based on objects' `last_modification_time` are ignored and do not exclude objects in a data source or a data sink. Structure documented below.
        """
        if aws_s3_data_source is not None:
            pulumi.set(__self__, "aws_s3_data_source", aws_s3_data_source)
        if azure_blob_storage_data_source is not None:
            pulumi.set(__self__, "azure_blob_storage_data_source", azure_blob_storage_data_source)
        if gcs_data_sink is not None:
            pulumi.set(__self__, "gcs_data_sink", gcs_data_sink)
        if gcs_data_source is not None:
            pulumi.set(__self__, "gcs_data_source", gcs_data_source)
        if http_data_source is not None:
            pulumi.set(__self__, "http_data_source", http_data_source)
        if object_conditions is not None:
            pulumi.set(__self__, "object_conditions", object_conditions)
        if posix_data_sink is not None:
            pulumi.set(__self__, "posix_data_sink", posix_data_sink)
        if posix_data_source is not None:
            pulumi.set(__self__, "posix_data_source", posix_data_source)
        if transfer_options is not None:
            pulumi.set(__self__, "transfer_options", transfer_options)

    @property
    @pulumi.getter(name="awsS3DataSource")
    def aws_s3_data_source(self) -> Optional[pulumi.Input['TransferJobTransferSpecAwsS3DataSourceArgs']]:
        """
        An AWS S3 data source. Structure documented below.
        """
        return pulumi.get(self, "aws_s3_data_source")

    @aws_s3_data_source.setter
    def aws_s3_data_source(self, value: Optional[pulumi.Input['TransferJobTransferSpecAwsS3DataSourceArgs']]):
        pulumi.set(self, "aws_s3_data_source", value)

    @property
    @pulumi.getter(name="azureBlobStorageDataSource")
    def azure_blob_storage_data_source(self) -> Optional[pulumi.Input['TransferJobTransferSpecAzureBlobStorageDataSourceArgs']]:
        """
        An Azure Blob Storage data source. Structure documented below.
        """
        return pulumi.get(self, "azure_blob_storage_data_source")

    @azure_blob_storage_data_source.setter
    def azure_blob_storage_data_source(self, value: Optional[pulumi.Input['TransferJobTransferSpecAzureBlobStorageDataSourceArgs']]):
        pulumi.set(self, "azure_blob_storage_data_source", value)

    @property
    @pulumi.getter(name="gcsDataSink")
    def gcs_data_sink(self) -> Optional[pulumi.Input['TransferJobTransferSpecGcsDataSinkArgs']]:
        """
        A Google Cloud Storage data sink. Structure documented below.
        """
        return pulumi.get(self, "gcs_data_sink")

    @gcs_data_sink.setter
    def gcs_data_sink(self, value: Optional[pulumi.Input['TransferJobTransferSpecGcsDataSinkArgs']]):
        pulumi.set(self, "gcs_data_sink", value)

    @property
    @pulumi.getter(name="gcsDataSource")
    def gcs_data_source(self) -> Optional[pulumi.Input['TransferJobTransferSpecGcsDataSourceArgs']]:
        """
        A Google Cloud Storage data source. Structure documented below.
        """
        return pulumi.get(self, "gcs_data_source")

    @gcs_data_source.setter
    def gcs_data_source(self, value: Optional[pulumi.Input['TransferJobTransferSpecGcsDataSourceArgs']]):
        pulumi.set(self, "gcs_data_source", value)

    @property
    @pulumi.getter(name="httpDataSource")
    def http_data_source(self) -> Optional[pulumi.Input['TransferJobTransferSpecHttpDataSourceArgs']]:
        """
        A HTTP URL data source. Structure documented below.
        """
        return pulumi.get(self, "http_data_source")

    @http_data_source.setter
    def http_data_source(self, value: Optional[pulumi.Input['TransferJobTransferSpecHttpDataSourceArgs']]):
        pulumi.set(self, "http_data_source", value)

    @property
    @pulumi.getter(name="objectConditions")
    def object_conditions(self) -> Optional[pulumi.Input['TransferJobTransferSpecObjectConditionsArgs']]:
        """
        Only objects that satisfy these object conditions are included in the set of data source and data sink objects. Object conditions based on objects' `last_modification_time` do not exclude objects in a data sink. Structure documented below.
        """
        return pulumi.get(self, "object_conditions")

    @object_conditions.setter
    def object_conditions(self, value: Optional[pulumi.Input['TransferJobTransferSpecObjectConditionsArgs']]):
        pulumi.set(self, "object_conditions", value)

    @property
    @pulumi.getter(name="posixDataSink")
    def posix_data_sink(self) -> Optional[pulumi.Input['TransferJobTransferSpecPosixDataSinkArgs']]:
        """
        A POSIX data sink. Structure documented below.
        """
        return pulumi.get(self, "posix_data_sink")

    @posix_data_sink.setter
    def posix_data_sink(self, value: Optional[pulumi.Input['TransferJobTransferSpecPosixDataSinkArgs']]):
        pulumi.set(self, "posix_data_sink", value)

    @property
    @pulumi.getter(name="posixDataSource")
    def posix_data_source(self) -> Optional[pulumi.Input['TransferJobTransferSpecPosixDataSourceArgs']]:
        """
        A POSIX filesystem data source. Structure documented below.
        """
        return pulumi.get(self, "posix_data_source")

    @posix_data_source.setter
    def posix_data_source(self, value: Optional[pulumi.Input['TransferJobTransferSpecPosixDataSourceArgs']]):
        pulumi.set(self, "posix_data_source", value)

    @property
    @pulumi.getter(name="transferOptions")
    def transfer_options(self) -> Optional[pulumi.Input['TransferJobTransferSpecTransferOptionsArgs']]:
        """
        Characteristics of how to treat files from datasource and sink during job. If the option `delete_objects_unique_in_sink` is true, object conditions based on objects' `last_modification_time` are ignored and do not exclude objects in a data source or a data sink. Structure documented below.
        """
        return pulumi.get(self, "transfer_options")

    @transfer_options.setter
    def transfer_options(self, value: Optional[pulumi.Input['TransferJobTransferSpecTransferOptionsArgs']]):
        pulumi.set(self, "transfer_options", value)


@pulumi.input_type
class TransferJobTransferSpecAwsS3DataSourceArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 aws_access_key: Optional[pulumi.Input['TransferJobTransferSpecAwsS3DataSourceAwsAccessKeyArgs']] = None,
                 role_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket_name: S3 Bucket name.
        :param pulumi.Input['TransferJobTransferSpecAwsS3DataSourceAwsAccessKeyArgs'] aws_access_key: AWS credentials block.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the role to support temporary credentials via 'AssumeRoleWithWebIdentity'. For more information about ARNs, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns). When a role ARN is provided, Transfer Service fetches temporary credentials for the session using a 'AssumeRoleWithWebIdentity' call for the provided role using the [GoogleServiceAccount][] for this project.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if aws_access_key is not None:
            pulumi.set(__self__, "aws_access_key", aws_access_key)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        S3 Bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="awsAccessKey")
    def aws_access_key(self) -> Optional[pulumi.Input['TransferJobTransferSpecAwsS3DataSourceAwsAccessKeyArgs']]:
        """
        AWS credentials block.
        """
        return pulumi.get(self, "aws_access_key")

    @aws_access_key.setter
    def aws_access_key(self, value: Optional[pulumi.Input['TransferJobTransferSpecAwsS3DataSourceAwsAccessKeyArgs']]):
        pulumi.set(self, "aws_access_key", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the role to support temporary credentials via 'AssumeRoleWithWebIdentity'. For more information about ARNs, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns). When a role ARN is provided, Transfer Service fetches temporary credentials for the session using a 'AssumeRoleWithWebIdentity' call for the provided role using the [GoogleServiceAccount][] for this project.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)


@pulumi.input_type
class TransferJobTransferSpecAwsS3DataSourceAwsAccessKeyArgs:
    def __init__(__self__, *,
                 access_key_id: pulumi.Input[str],
                 secret_access_key: pulumi.Input[str]):
        """
        :param pulumi.Input[str] access_key_id: AWS Key ID.
        :param pulumi.Input[str] secret_access_key: AWS Secret Access Key.
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "secret_access_key", secret_access_key)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> pulumi.Input[str]:
        """
        AWS Key ID.
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_key_id", value)

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> pulumi.Input[str]:
        """
        AWS Secret Access Key.
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_access_key", value)


@pulumi.input_type
class TransferJobTransferSpecAzureBlobStorageDataSourceArgs:
    def __init__(__self__, *,
                 azure_credentials: pulumi.Input['TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsArgs'],
                 container: pulumi.Input[str],
                 storage_account: pulumi.Input[str],
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsArgs'] azure_credentials: Credentials used to authenticate API requests to Azure block.
        :param pulumi.Input[str] container: The container to transfer from the Azure Storage account.`
        :param pulumi.Input[str] storage_account: The name of the Azure Storage account.
        :param pulumi.Input[str] path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        pulumi.set(__self__, "azure_credentials", azure_credentials)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "storage_account", storage_account)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="azureCredentials")
    def azure_credentials(self) -> pulumi.Input['TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsArgs']:
        """
        Credentials used to authenticate API requests to Azure block.
        """
        return pulumi.get(self, "azure_credentials")

    @azure_credentials.setter
    def azure_credentials(self, value: pulumi.Input['TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsArgs']):
        pulumi.set(self, "azure_credentials", value)

    @property
    @pulumi.getter
    def container(self) -> pulumi.Input[str]:
        """
        The container to transfer from the Azure Storage account.`
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: pulumi.Input[str]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="storageAccount")
    def storage_account(self) -> pulumi.Input[str]:
        """
        The name of the Azure Storage account.
        """
        return pulumi.get(self, "storage_account")

    @storage_account.setter
    def storage_account(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_account", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsArgs:
    def __init__(__self__, *,
                 sas_token: pulumi.Input[str]):
        """
        :param pulumi.Input[str] sas_token: Azure shared access signature. See [Grant limited access to Azure Storage resources using shared access signatures (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
        """
        pulumi.set(__self__, "sas_token", sas_token)

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> pulumi.Input[str]:
        """
        Azure shared access signature. See [Grant limited access to Azure Storage resources using shared access signatures (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
        """
        return pulumi.get(self, "sas_token")

    @sas_token.setter
    def sas_token(self, value: pulumi.Input[str]):
        pulumi.set(self, "sas_token", value)


@pulumi.input_type
class TransferJobTransferSpecGcsDataSinkArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket_name: S3 Bucket name.
        :param pulumi.Input[str] path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        S3 Bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class TransferJobTransferSpecGcsDataSourceArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket_name: S3 Bucket name.
        :param pulumi.Input[str] path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        S3 Bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class TransferJobTransferSpecHttpDataSourceArgs:
    def __init__(__self__, *,
                 list_url: pulumi.Input[str]):
        """
        :param pulumi.Input[str] list_url: The URL that points to the file that stores the object list entries. This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
        """
        pulumi.set(__self__, "list_url", list_url)

    @property
    @pulumi.getter(name="listUrl")
    def list_url(self) -> pulumi.Input[str]:
        """
        The URL that points to the file that stores the object list entries. This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
        """
        return pulumi.get(self, "list_url")

    @list_url.setter
    def list_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "list_url", value)


@pulumi.input_type
class TransferJobTransferSpecObjectConditionsArgs:
    def __init__(__self__, *,
                 exclude_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 include_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_time_elapsed_since_last_modification: Optional[pulumi.Input[str]] = None,
                 min_time_elapsed_since_last_modification: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclude_prefixes: `exclude_prefixes` must follow the requirements described for `include_prefixes`. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] include_prefixes: If `include_prefixes` is specified, objects that satisfy the object conditions must have names that start with one of the `include_prefixes` and that do not start with any of the `exclude_prefixes`. If `include_prefixes` is not specified, all objects except those that have names starting with one of the `exclude_prefixes` must satisfy the object conditions. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        :param pulumi.Input[str] max_time_elapsed_since_last_modification: A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[str] min_time_elapsed_since_last_modification: A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if exclude_prefixes is not None:
            pulumi.set(__self__, "exclude_prefixes", exclude_prefixes)
        if include_prefixes is not None:
            pulumi.set(__self__, "include_prefixes", include_prefixes)
        if max_time_elapsed_since_last_modification is not None:
            pulumi.set(__self__, "max_time_elapsed_since_last_modification", max_time_elapsed_since_last_modification)
        if min_time_elapsed_since_last_modification is not None:
            pulumi.set(__self__, "min_time_elapsed_since_last_modification", min_time_elapsed_since_last_modification)

    @property
    @pulumi.getter(name="excludePrefixes")
    def exclude_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        `exclude_prefixes` must follow the requirements described for `include_prefixes`. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        """
        return pulumi.get(self, "exclude_prefixes")

    @exclude_prefixes.setter
    def exclude_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclude_prefixes", value)

    @property
    @pulumi.getter(name="includePrefixes")
    def include_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If `include_prefixes` is specified, objects that satisfy the object conditions must have names that start with one of the `include_prefixes` and that do not start with any of the `exclude_prefixes`. If `include_prefixes` is not specified, all objects except those that have names starting with one of the `exclude_prefixes` must satisfy the object conditions. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        """
        return pulumi.get(self, "include_prefixes")

    @include_prefixes.setter
    def include_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "include_prefixes", value)

    @property
    @pulumi.getter(name="maxTimeElapsedSinceLastModification")
    def max_time_elapsed_since_last_modification(self) -> Optional[pulumi.Input[str]]:
        """
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "max_time_elapsed_since_last_modification")

    @max_time_elapsed_since_last_modification.setter
    def max_time_elapsed_since_last_modification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_time_elapsed_since_last_modification", value)

    @property
    @pulumi.getter(name="minTimeElapsedSinceLastModification")
    def min_time_elapsed_since_last_modification(self) -> Optional[pulumi.Input[str]]:
        """
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "min_time_elapsed_since_last_modification")

    @min_time_elapsed_since_last_modification.setter
    def min_time_elapsed_since_last_modification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_time_elapsed_since_last_modification", value)


@pulumi.input_type
class TransferJobTransferSpecPosixDataSinkArgs:
    def __init__(__self__, *,
                 root_directory: pulumi.Input[str]):
        """
        :param pulumi.Input[str] root_directory: Root directory path to the filesystem.
        """
        pulumi.set(__self__, "root_directory", root_directory)

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> pulumi.Input[str]:
        """
        Root directory path to the filesystem.
        """
        return pulumi.get(self, "root_directory")

    @root_directory.setter
    def root_directory(self, value: pulumi.Input[str]):
        pulumi.set(self, "root_directory", value)


@pulumi.input_type
class TransferJobTransferSpecPosixDataSourceArgs:
    def __init__(__self__, *,
                 root_directory: pulumi.Input[str]):
        """
        :param pulumi.Input[str] root_directory: Root directory path to the filesystem.
        """
        pulumi.set(__self__, "root_directory", root_directory)

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> pulumi.Input[str]:
        """
        Root directory path to the filesystem.
        """
        return pulumi.get(self, "root_directory")

    @root_directory.setter
    def root_directory(self, value: pulumi.Input[str]):
        pulumi.set(self, "root_directory", value)


@pulumi.input_type
class TransferJobTransferSpecTransferOptionsArgs:
    def __init__(__self__, *,
                 delete_objects_from_source_after_transfer: Optional[pulumi.Input[bool]] = None,
                 delete_objects_unique_in_sink: Optional[pulumi.Input[bool]] = None,
                 overwrite_objects_already_existing_in_sink: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] delete_objects_from_source_after_transfer: Whether objects should be deleted from the source after they are transferred to the sink. Note that this option and `delete_objects_unique_in_sink` are mutually exclusive.
        :param pulumi.Input[bool] delete_objects_unique_in_sink: Whether objects that exist only in the sink should be deleted. Note that this option and
               `delete_objects_from_source_after_transfer` are mutually exclusive.
        :param pulumi.Input[bool] overwrite_objects_already_existing_in_sink: Whether overwriting objects that already exist in the sink is allowed.
        """
        if delete_objects_from_source_after_transfer is not None:
            pulumi.set(__self__, "delete_objects_from_source_after_transfer", delete_objects_from_source_after_transfer)
        if delete_objects_unique_in_sink is not None:
            pulumi.set(__self__, "delete_objects_unique_in_sink", delete_objects_unique_in_sink)
        if overwrite_objects_already_existing_in_sink is not None:
            pulumi.set(__self__, "overwrite_objects_already_existing_in_sink", overwrite_objects_already_existing_in_sink)

    @property
    @pulumi.getter(name="deleteObjectsFromSourceAfterTransfer")
    def delete_objects_from_source_after_transfer(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether objects should be deleted from the source after they are transferred to the sink. Note that this option and `delete_objects_unique_in_sink` are mutually exclusive.
        """
        return pulumi.get(self, "delete_objects_from_source_after_transfer")

    @delete_objects_from_source_after_transfer.setter
    def delete_objects_from_source_after_transfer(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_objects_from_source_after_transfer", value)

    @property
    @pulumi.getter(name="deleteObjectsUniqueInSink")
    def delete_objects_unique_in_sink(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether objects that exist only in the sink should be deleted. Note that this option and
        `delete_objects_from_source_after_transfer` are mutually exclusive.
        """
        return pulumi.get(self, "delete_objects_unique_in_sink")

    @delete_objects_unique_in_sink.setter
    def delete_objects_unique_in_sink(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_objects_unique_in_sink", value)

    @property
    @pulumi.getter(name="overwriteObjectsAlreadyExistingInSink")
    def overwrite_objects_already_existing_in_sink(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether overwriting objects that already exist in the sink is allowed.
        """
        return pulumi.get(self, "overwrite_objects_already_existing_in_sink")

    @overwrite_objects_already_existing_in_sink.setter
    def overwrite_objects_already_existing_in_sink(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "overwrite_objects_already_existing_in_sink", value)


