import { Annotation, AnnotationView } from "./annotation";
import { ColumnDataSource } from "../sources/column_data_source";
import { TeeHead } from "./arrow_head";
import { LineVector } from "../../core/property_mixins";
import * as p from "../../core/properties";
export class WhiskerView extends AnnotationView {
    initialize() {
        super.initialize();
        this.set_data(this.model.source);
    }
    connect_signals() {
        super.connect_signals();
        this.connect(this.model.source.streaming, () => this.set_data(this.model.source));
        this.connect(this.model.source.patching, () => this.set_data(this.model.source));
        this.connect(this.model.source.change, () => this.set_data(this.model.source));
    }
    set_data(source) {
        super.set_data(source);
        this.visuals.warm_cache(source);
        this.plot_view.request_render();
    }
    _map_data() {
        const { frame } = this.plot_view;
        const dim = this.model.dimension;
        const xscale = this.coordinates.x_scale;
        const yscale = this.coordinates.y_scale;
        const limit_scale = dim == "height" ? yscale : xscale;
        const base_scale = dim == "height" ? xscale : yscale;
        const limit_view = dim == "height" ? frame.yview : frame.xview;
        const base_view = dim == "height" ? frame.xview : frame.yview;
        let _lower_sx;
        if (this.model.properties.lower.units == "data")
            _lower_sx = limit_scale.v_compute(this._lower);
        else
            _lower_sx = limit_view.v_compute(this._lower);
        let _upper_sx;
        if (this.model.properties.upper.units == "data")
            _upper_sx = limit_scale.v_compute(this._upper);
        else
            _upper_sx = limit_view.v_compute(this._upper);
        let _base_sx;
        if (this.model.properties.base.units == "data")
            _base_sx = base_scale.v_compute(this._base);
        else
            _base_sx = base_view.v_compute(this._base);
        const [i, j] = dim == 'height' ? [1, 0] : [0, 1];
        const _lower = [_lower_sx, _base_sx];
        const _upper = [_upper_sx, _base_sx];
        this._lower_sx = _lower[i];
        this._lower_sy = _lower[j];
        this._upper_sx = _upper[i];
        this._upper_sy = _upper[j];
    }
    _render() {
        this._map_data();
        const { ctx } = this.layer;
        if (this.visuals.line.doit) {
            for (let i = 0, end = this._lower_sx.length; i < end; i++) {
                this.visuals.line.set_vectorize(ctx, i);
                ctx.beginPath();
                ctx.moveTo(this._lower_sx[i], this._lower_sy[i]);
                ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
                ctx.stroke();
            }
        }
        const angle = this.model.dimension == "height" ? 0 : Math.PI / 2;
        if (this.model.lower_head != null) {
            for (let i = 0, end = this._lower_sx.length; i < end; i++) {
                ctx.save();
                ctx.translate(this._lower_sx[i], this._lower_sy[i]);
                ctx.rotate(angle + Math.PI);
                this.model.lower_head.render(ctx, i);
                ctx.restore();
            }
        }
        if (this.model.upper_head != null) {
            for (let i = 0, end = this._upper_sx.length; i < end; i++) {
                ctx.save();
                ctx.translate(this._upper_sx[i], this._upper_sy[i]);
                ctx.rotate(angle);
                this.model.upper_head.render(ctx, i);
                ctx.restore();
            }
        }
    }
}
WhiskerView.__name__ = "WhiskerView";
export class Whisker extends Annotation {
    constructor(attrs) {
        super(attrs);
    }
    static init_Whisker() {
        this.prototype.default_view = WhiskerView;
        this.mixins(LineVector);
        this.define({
            lower: [p.DistanceSpec],
            lower_head: [p.Instance, () => new TeeHead({ level: "underlay", size: 10 })],
            upper: [p.DistanceSpec],
            upper_head: [p.Instance, () => new TeeHead({ level: "underlay", size: 10 })],
            base: [p.DistanceSpec],
            dimension: [p.Dimension, 'height'],
            source: [p.Instance, () => new ColumnDataSource()],
        });
        this.override({
            level: 'underlay',
        });
    }
}
Whisker.__name__ = "Whisker";
Whisker.init_Whisker();
//# sourceMappingURL=whisker.js.map