                __                      __                                          
         _____ / /_ _____ __  __ _____ / /_ __  __ _____ ___         ____ ___   ___ 
        / ___// __// ___// / / // ___// __// / / // ___// _ \       / __ `__ \ / _ \
       (__  )/ /_ / /   / /_/ // /__ / /_ / /_/ // /   /  __/      / / / / / //  __/
      /____/ \__//_/    \__,_/ \___/ \__/ \__,_//_/    \___/______/_/ /_/ /_/ \___/ 
                                                           /_____/                 
### Helping newbies and pros in creating a starting structure for python projects, following some of the general guidelines and principles widely used.  
  

## Table of Contents
- [Quick start](#quick-start)
- [Examples](#examples)
- [Author](#author)
- [Inspiration and background](#inspiration-and-background)
- [Copyright and license](#copyright-and-license)

## Quick start
### Instalation:
- pip:  
    `pip install structure_me`
- github:  
    `git clone https://github.com/the-marcos/structure_me.git`

### General Guidance
The usage should be rather straight forward. Following Django's default approach
and using setuptools to package your software, with the intent to hosting it in
pypi.
These are the steps I recommend:
1. Create a root folder for your project, by default the same as your project's
name. See the [Examples](#examples) section below for a sample tree of how your
folder structure should look like after running the program.

2. Navigate to the root folder you created and run the script following the recipe
described in the [Examples](#examples) section below.

3. I recommend using the --verbose argument as it will create files with descriptions
that are easy to follow along. If you know what you are doing, or feeling adventurous
be my guest to generate empty files and populating them yourselves.

4. Create a repository in github, and clone it to the root folder of your project.
It is a good idea to have github start a repo with a .gitignore. This file is not
generated by default, and I do not intend in creating it this way. Let github do the
work.

5. GO DEVELOP YOUR IDEAS!

6. Once you are ready to ship an alpha or beta version of your software, ensure
you have setuptools installed and follow along the instructions [here](https://packaging.python.org/guides/distributing-packages-using-setuptools/).

## Examples
Example usage can be checked by running:  
`structure_me -h`

There are two predefined ways of running this program:
  
1. Verbose files: create folder/file structures with **django** like comments
on the files making it easier for new users to create their first programs.
  
`structure_me -n <project_name> -v`

NOTE: as of version 0.52a0 the comments provided are not super comprehensive, but
give a decent number of pointers on setup.py. Most of the work is still in your
hands.

2. Simple: create a simple folder/file structure. No comments.

`structure_me -n <project_name>`

Considering you follow the guidance and execute the above commands in a folder 
named 'project_name' a succesful execution will generate the following folder tree:  
```
project_name 
    ├── data/ 
    ├── examples/  
    │   └── example.py  
    ├── src/  
    │    └── project_name  
    │        └── __init__.py  
    ├── tests/  
    │   └── __init__.py  
    ├── LICENSE.txt  
    ├── MANIFEST.in
    ├── README.MD  
    ├── setup.cfg
    └── setup.py  
```

## Author

**Marcos Paterson**
- <https://github.com/the-marcos>


## Inspiration and background

In May 2020, while in the initial steps of learning django, I was amazed to
see how easy it was to create a new project/app, and that django had a functionality
that would create an entire folder structure and the baseline files with helpful
tips along the way.

Then started the search to find a similar package that would do just that. Create
a baseline/boiler plate folder and file structure, so I could dig into the core 
of the development, without worrying about having the structure around it.

I found none. That would fit my needs. Simple. Straight Forward. So here we go!
If by any chance you know of other more fitted alternatives, I'd love to hear about it.

Inspirations:
- <https://packaging.python.org/guides/distributing-packages-using-setuptools/>
- <https://github.com/yngvem/python-project-structure>
- <https://the-hitchhikers-guide-to-packaging.readthedocs.io>


## Copyright and license

Code and documentation copyright 2020 [the-marcos](https://github.com/the-marcos). 
Code released under the [MIT License](https://github.com/the-marcos/structure_me/blob/master/LICENSE).