import re

from openvariant.plugins.context import Context
from openvariant.plugins.plugin import Plugin


class Get_afContext(Context):
    """
    Get_afContext class generated by OpenVariant

    Attributes
    -------
    row : dict
        Main method to execute data transformation in each row.
    field_name : str
        Name of the corresponding column that was described on the annotation schema.
    file_path : str
        Path of the Input file that is being parsed.
    """

    def __init__(self, row: dict, field_name: str, file_path: str) -> None:
        super().__init__(row, field_name, file_path)


class Get_afPlugin(Plugin):
    """
    This plugin get alternate allele frequency of a sample in a .vcf.
    It will be in located in 'subAF' field and will get the float number with regexp.

    Methods
    -------
    run(context: Get_afContext)
        Main method to execute data transformation in each row.
    """

    def run(self, context: Get_afContext) -> str:
        """ Extract allele frequency from the input row.

        Parameters
        -------
        context : Get_afContext
            Representation of the row to be parsed.

        Returns
        -------
        float or int or str
            The value of the field transformed.
        """
        res = re.findall(r";AF_raw=[+-]?(\d+(\.\d*)?|\.\d+)([eE][+-]?\d+)?;", context.row["subAF"])
        try:
            context.row[context.field_name] = float(res[0][0] + res[0][2])
        except Exception:
            context.row[context.field_name] = float('nan')
        return str(context.row[context.field_name])
