import * as ec2 from '@aws-cdk/aws-ec2';
import * as eks from '@aws-cdk/aws-eks';
import * as iam from '@aws-cdk/aws-iam';
import { StackProps, Construct, Resource, ResourceProps } from '@aws-cdk/core';
import { ILaunchtemplate } from './launch-template';
/**
 * @stability stable
 */
export declare enum BlockDuration {
    /**
     * @stability stable
     */
    ONE_HOUR = 60,
    /**
     * @stability stable
     */
    TWO_HOURS = 120,
    /**
     * @stability stable
     */
    THREE_HOURS = 180,
    /**
     * @stability stable
     */
    FOUR_HOURS = 240,
    /**
     * @stability stable
     */
    FIVE_HOURS = 300,
    /**
     * @stability stable
     */
    SIX_HOURS = 360
}
/**
 * @stability stable
 */
export declare enum InstanceInterruptionBehavior {
    /**
     * @stability stable
     */
    HIBERNATE = "hibernate",
    /**
     * @stability stable
     */
    STOP = "stop",
    /**
     * @stability stable
     */
    TERMINATE = "terminate"
}
/**
 * @stability stable
 */
export interface EksSpotClusterProps extends StackProps {
    /**
     * @stability stable
     */
    readonly clusterAttributes?: eks.ClusterAttributes;
    /**
     * @stability stable
     */
    readonly clusterVersion: eks.KubernetesVersion;
    /**
     * @stability stable
     */
    readonly instanceRole?: iam.IRole;
    /**
     * @stability stable
     */
    readonly instanceInterruptionBehavior?: InstanceInterruptionBehavior;
    /**
     * @stability stable
     */
    readonly kubectlEnabled?: boolean;
    /**
     * Specify a custom AMI ID for your spot fleet.
     *
     * By default the Amazon EKS-optimized
     * AMI will be selected.
     *
     * @default - none
     * @stability stable
     */
    readonly customAmiId?: string;
}
/**
 * @stability stable
 */
export declare class EksSpotCluster extends Resource {
    /**
     * @stability stable
     */
    readonly cluster: eks.Cluster;
    /**
     * @stability stable
     */
    readonly clusterVersion: eks.KubernetesVersion;
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: EksSpotClusterProps);
    /**
     * @stability stable
     */
    addSpotFleet(id: string, props: BaseSpotFleetProps): void;
    /**
     * @stability stable
     */
    addDays(date: Date, days: number): Date;
    /**
     * @stability stable
     */
    addHours(date: Date, hours: number): Date;
    /**
     * @stability stable
     */
    addMinutes(date: Date, minutes: number): Date;
}
/**
 * @stability stable
 */
export interface BaseSpotFleetProps extends ResourceProps {
    /**
     * @stability stable
     */
    readonly defaultInstanceType?: ec2.InstanceType;
    /**
     * @stability stable
     */
    readonly blockDuration?: BlockDuration;
    /**
     * @stability stable
     */
    readonly instanceInterruptionBehavior?: InstanceInterruptionBehavior;
    /**
     * @stability stable
     */
    readonly instanceRole?: iam.Role;
    /**
     * @stability stable
     */
    readonly targetCapacity?: number;
    /**
     * @stability stable
     */
    readonly mapRole?: boolean;
    /**
     * @stability stable
     */
    readonly bootstrapEnabled?: boolean;
    /**
     * @stability stable
     */
    readonly validFrom?: string;
    /**
     * @stability stable
     */
    readonly validUntil?: string;
    /**
     * @stability stable
     */
    readonly terminateInstancesWithExpiration?: boolean;
    /**
     * @stability stable
     */
    readonly customAmiId?: string;
}
/**
 * @stability stable
 */
export interface SpotFleetProps extends BaseSpotFleetProps {
    /**
     * @stability stable
     */
    readonly cluster: EksSpotCluster;
    /**
     * @stability stable
     */
    readonly launchTemplate?: ILaunchtemplate;
}
/**
 * @stability stable
 */
export declare class SpotFleet extends Resource {
    /**
     * @stability stable
     */
    readonly instanceRole: iam.IRole;
    /**
     * @stability stable
     */
    readonly clusterStack: EksSpotCluster;
    /**
     * @stability stable
     */
    readonly defaultInstanceType: ec2.InstanceType;
    /**
     * @stability stable
     */
    readonly targetCapacity?: number;
    /**
     * @stability stable
     */
    readonly spotFleetId: string;
    /**
     * @stability stable
     */
    readonly launchTemplate: ILaunchtemplate;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: SpotFleetProps);
}
