Ext.ns('Ext.m3');

/**
 * @class Ext.ux.form.MultiSelectColumnFilter
 * @extends Ext.ux.form.MultiSelectField
 *
 * Колоночный фильтр для выбора множества значений.
 * Фильтр отправляет запрос на сервер при сворачивании комбобокса при условии,
 * что предыдущее состояние фильтра было изменено. В самом поле комбобокса
 * текстовое значение не отображается.
 */
Ext.m3.MultiSelectColumnFilter = Ext.extend(Ext.m3.MultiSelectField, {
    collapse : function(){
        if(!this.isExpanded()){
            return;
        }
        this.list.hide();
        Ext.getDoc().un('mousewheel', this.collapseIf, this);
        Ext.getDoc().un('mousedown', this.collapseIf, this);
        this.fireEvent('collapse', this);
        if (this.prevValue != this.value) {
            this.fireEvent("select", this, this.checkedItems);
        }
    },
    onSelect : function (record, checkedIndex) {
        var index;

        index = this.findCheckedRecord(record);

        if (this.fireEvent("beforeselect", this, record, checkedIndex) !== false) {
			if (index === -1) {
			    this.checkedItems.push(record);
			} else {
			    this.checkedItems.remove( this.checkedItems[index]);
			}

            this.refreshItem(record);
			this.setValue(this.getValue());
        }
	},
    getText : function () {
		var value = [];
		Ext.each(this.checkedItems, function (record) {
			value.push(record.get(this.displayField));
		}, this);

		if (value.length > 1 && this.multipleDisplayValue){
			return this.multipleDisplayValue;
		} else {
			return '';
		}
	},
    setValue:function(v) {

        if (!v || v === '[]'){
            this.hideClearBtn();
        }
        else {
            this.showClearBtn();
        }
        this.prevValue = this.value;
        this.value = this.getValue();

        this.setRawValue(this.getText());
        if (this.hiddenField) {
            this.hiddenField.value = this.value;
        }
        if (this.el) {
            this.el.removeClass(this.emptyClass);
        }
    },
    triggerBlur: function () {
        if (this.focusClass) {
            this.el.removeClass(this.focusClass);
        }
        if (this.wrap) {
            this.wrap.removeClass(this.wrapFocusClass);
        }
        this.validate();
    }
});

Ext.reg('m3-multiselect-column-filter', Ext.m3.MultiSelectColumnFilter );