# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../pts/api/llm/03_caching.pct.py.

# %% auto 0
__all__ = ['get_cache_key']

# %% ../../../pts/api/llm/03_caching.pct.py 3
try:
    from pathlib import Path
    from typing import Dict, Union, Callable, Coroutine
    from adulib.caching import get_cache, clear_cache_key, is_in_cache
    from diskcache import ENOVAL
except ImportError as e:
    raise ImportError(f"Install adulib[llm] to use this API.") from e

# %% ../../../pts/api/llm/03_caching.pct.py 6
def get_cache_key(
    model: str, func_name, content: any, key_prefix: Union[str, None]=None, include_model_in_cache_key: bool=True
) -> tuple:
    return ('adulib.llm', func_name, key_prefix, model if include_model_in_cache_key else '', content)

# %% ../../../pts/api/llm/03_caching.pct.py 7
def _cache_execute(
    cache_key: tuple,
    execute_func: Callable,
    cache_enabled: bool=True,
    cache_path: Union[str, Path, None]=None,
):
    if not cache_enabled: return execute_func()
    cache = get_cache(cache_path)
    result = cache.get(cache_key, default=ENOVAL, retry=True)
    retrieved_from_cache = True
    if result is ENOVAL:
        result = execute_func()
        cache.set(cache_key, result)
        retrieved_from_cache = False
    return retrieved_from_cache, result

# %% ../../../pts/api/llm/03_caching.pct.py 8
async def _async_cache_execute(
    cache_key: tuple,
    execute_func: Callable,
    cache_enabled: bool=True,
    cache_path: Union[str, Path, None]=None,
):
    if not cache_enabled: return execute_func()
    cache = get_cache(cache_path)
    result = cache.get(cache_key, default=ENOVAL, retry=True)
    retrieved_from_cache = True
    if result is ENOVAL:
        result = await execute_func()
        cache.set(cache_key, result)
        retrieved_from_cache = False
    return retrieved_from_cache, result
