"""See the [`litellm` documention](https://docs.litellm.ai/docs/text_completion)."""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../pts/api/llm/07_text_completions.pct.py.

# %% auto 0
__all__ = ['text_completion', 'sig', 'async_text_completion']

# %% ../../../pts/api/llm/07_text_completions.pct.py 3
import inspect
from inspect import Parameter
try:
    import litellm
    import functools
    from adulib.llm._utils import _llm_func_factory, _llm_async_func_factory
    from adulib.llm.tokens import token_counter
except ImportError as e:
    raise ImportError(f"Install adulib[llm] to use this API.") from e

# %% ../../../pts/api/llm/07_text_completions.pct.py 8
text_completion = _llm_func_factory(
    func=litellm.text_completion,
    func_name="text_completion",
    func_cache_name="text_completion",
    retrieve_log_data=lambda model, func_kwargs, response, cache_args: {
        "method": "text_completion",
        "input_tokens": token_counter(model=model, text=func_kwargs['prompt'], **cache_args),
        "output_tokens": sum([token_counter(model=model, text=c.text, **cache_args) for c in response.choices]),
        "cost": response._hidden_params['response_cost'],
    }
)

text_completion.__doc__ = """
This function is a wrapper around a corresponding function in the `litellm` library, see [this](https://docs.litellm.ai/docs/text_completion) for a full list of the available arguments.
""".strip()

sig = inspect.signature(text_completion)
sig = sig.replace(parameters=[
    Parameter("model", Parameter.POSITIONAL_OR_KEYWORD, annotation=str),
    Parameter("prompt", Parameter.POSITIONAL_OR_KEYWORD, annotation=str),
    *sig.parameters.values()
])
text_completion.__signature__ = sig

# %% ../../../pts/api/llm/07_text_completions.pct.py 11
async_text_completion = _llm_async_func_factory(
    func=functools.wraps(litellm.text_completion)(litellm.atext_completion), # This is needed as 'litellm.atext_completion' lacks the right signature
    func_name="async_text_completion",
    func_cache_name="text_completion",
    retrieve_log_data=lambda model, func_kwargs, response, cache_args: {
        "method": "text_completion",
        "input_tokens": token_counter(model=model, text=func_kwargs['prompt'], **cache_args),
        "output_tokens": sum([token_counter(model=model, text=c.text, **cache_args) for c in response.choices]),
        "cost": response._hidden_params['response_cost'],
    }
)

async_text_completion.__doc__ = """
This function is a wrapper around a corresponding function in the `litellm` library, see [this](https://docs.litellm.ai/docs/text_completion) for a full list of the available arguments.
""".strip()

sig = inspect.signature(async_text_completion)
sig = sig.replace(parameters=[
    Parameter("model", Parameter.POSITIONAL_OR_KEYWORD, annotation=str),
    Parameter("prompt", Parameter.POSITIONAL_OR_KEYWORD, annotation=str),
    *sig.parameters.values()
])
async_text_completion.__signature__ = sig
