# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../pts/api/utils/02_pipes.pct.py.

# %% auto 0
__all__ = ['psum', 'pmin', 'pmax', 'pabs', 'padd', 'psub', 'pmul', 'pdiv', 'pmod', 'ptype', 'plist', 'ptuple', 'pdict', 'pset',
           'pint', 'pfloat', 'pstr', 'pbool', 'pjoin', 'psplit', 'pstrip', 'plstrip', 'prstrip', 'pupper', 'plower',
           'pbind', 'ppartial', 'papply', 'pcall', 'pflatten', 'plen', 'pmap', 'puniq', 'ptranspose', 'pfilter',
           'psort', 'pt', 'penumerate', 'pzip', 'pslice', 'pbatched', 'pchain', 'pchain_with', 'pdedup', 'pgroupby',
           'ppermutations', 'preverse', 'pskip_while', 'ptail', 'ptake', 'ptake_while', 'ptraverse', 'pget', 'pgetattr',
           'ptee', 'pshow', 'pwrite', 'pread']

# %% ../../../pts/api/utils/02_pipes.pct.py 3
import pipe

# %% ../../../pts/api/utils/02_pipes.pct.py 5
psum = pipe.Pipe(lambda x, start=0: sum(x, start=start))
pmin = pipe.Pipe(lambda x, key=(lambda y:y): min(x, key=key))
pmax = pipe.Pipe(lambda x, key=(lambda y:y): max(x, key=key))
pabs = pipe.Pipe(lambda x: abs(x))
padd = pipe.Pipe(lambda x, y: x + y)
psub = pipe.Pipe(lambda x, y: x - y)
pmul = pipe.Pipe(lambda x, y: x * y)
pdiv = pipe.Pipe(lambda x, y: x / y)
pmod = pipe.Pipe(lambda x, y: x % y)

# %% ../../../pts/api/utils/02_pipes.pct.py 10
ptype = pipe.Pipe(lambda x, typ: typ(x))
plist = pipe.Pipe(lambda x: list(x))
ptuple = pipe.Pipe(lambda x: tuple(x))
pdict = pipe.Pipe(lambda x: dict(x))
pset = pipe.Pipe(lambda x: set(x))
pint = pipe.Pipe(lambda x: int(x))
pfloat = pipe.Pipe(lambda x: float(x))
pstr = pipe.Pipe(lambda x: str(x))
pbool = pipe.Pipe(lambda x: bool(x))

# %% ../../../pts/api/utils/02_pipes.pct.py 13
pjoin = pipe.Pipe(lambda x, sep: sep.join(str(i) for i in x))
psplit = pipe.Pipe(lambda x, sep=None, maxsplit=-1: x.split(sep, maxsplit=maxsplit))
pstrip = pipe.Pipe(lambda x, chars=None: x.strip(chars))
plstrip = pipe.Pipe(lambda x, chars=None: x.lstrip(chars))
prstrip = pipe.Pipe(lambda x, chars=None: x.rstrip(chars))
pupper = pipe.Pipe(lambda x: x.upper())
plower = pipe.Pipe(lambda x: x.lower())

# %% ../../../pts/api/utils/02_pipes.pct.py 16
pbind = pipe.Pipe(lambda x, f, *args, **kwargs: lambda *args2, **kwargs2: f(x, *args, *args2, **kwargs, **kwargs2))
ppartial = pipe.Pipe(lambda f, *args, **kwargs: lambda *args2, **kwargs2: f(*args, *args2, **kwargs, **kwargs2))
papply = pipe.Pipe(lambda x, f: f(x))
pcall = pipe.Pipe(lambda f, *args, **kwargs: f(*args, **kwargs))

# %% ../../../pts/api/utils/02_pipes.pct.py 21
def _pflatten_helper(lst, curr_level, levels=None):
    """Helper function to flatten a nested list."""
    if levels is not None and curr_level > levels:
        yield lst
        return
    for item in lst:
        if isinstance(item, list):
            yield from _pflatten_helper(item, curr_level+1, levels)
        else:
            yield item

pflatten = pipe.Pipe(lambda x, levels=None: _pflatten_helper(x, 0, levels))
plen = pipe.Pipe(lambda x: len(x))

# %% ../../../pts/api/utils/02_pipes.pct.py 22
pmap = pipe.map
puniq = pipe.uniq
ptranspose = pipe.transpose
pfilter = pipe.filter
psort = pipe.sort
pt = pipe.t
penumerate = pipe.enumerate
pzip = pipe.izip
pslice = pipe.islice

pbatched = pipe.batched
pchain = pipe.chain
pchain_with = pipe.chain_with
pdedup = pipe.dedup
pgroupby = pipe.groupby
ppermutations = pipe.permutations
preverse = pipe.reverse
pskip_while = pipe.skip_while
ptail = pipe.tail
ptake = pipe.take
ptake_while = pipe.take_while
ptraverse = pipe.traverse

# %% ../../../pts/api/utils/02_pipes.pct.py 26
pget = pipe.Pipe(lambda x, k: x[k])
pgetattr = pipe.Pipe(lambda x, k: getattr(x, k))
ptee = pipe.tee

# %% ../../../pts/api/utils/02_pipes.pct.py 30
@pipe.Pipe
def pwrite(content, file_path=None, mode='w'):
    import tempfile
    if file_path is None:
        file_path = tempfile.NamedTemporaryFile(delete=False).name
    with open(file_path, mode) as f:
        f.write(content)
    return file_path
    
@pipe.Pipe
def pread(file_path, mode='r'):
    with open(file_path, mode) as f:
        return f.read()
    
pshow = pipe.Pipe(lambda x: print(x) or x)  # Returns x for chaining
