#!/usr/bin/env python3

# SPDX-FileCopyrightText: © 2022 Decompollaborate
# SPDX-License-Identifier: MIT

from __future__ import annotations

from ... import common

from ..MipsFileBase import FileBase

class SectionBase(FileBase):
    def checkWordIsASymbolReference(self, word: int) -> bool:
        if word < self.context.totalVramStart or word >= self.context.totalVramEnd:
            return False
        if self.context.isAddressBanned(word):
            return False

        if self.getSymbol(word, tryPlusOffset=True, checkUpperLimit=True) is not None:
            return False

        self.addPointerInDataReference(word)
        return True

    def processStaticRelocs(self) -> None:
        for i in range(self.sizew):
            word = self.words[i]
            vrom = self.getVromOffset(i*4)
            relocInfo = self.context.globalRelocationOverrides.get(vrom)
            if relocInfo is None or relocInfo.staticReference is None:
                continue

            relocVram = relocInfo.staticReference.sectionVram + word
            sectionType = relocInfo.staticReference.sectionType
            if self.sectionType == common.FileSectionType.Rodata and sectionType == common.FileSectionType.Text:
                contextSym = self.addJumpTableLabel(relocVram, isAutogenerated=True)
            else:
                contextSym = self.addSymbol(relocVram, sectionType=sectionType, isAutogenerated=True)
            contextSym._isStatic = True

    def blankOutDifferences(self, other: FileBase) -> bool:
        if not common.GlobalConfig.REMOVE_POINTERS:
            return False

        was_updated = False
        if len(common.GlobalConfig.IGNORE_WORD_LIST) > 0:
            min_len = min(self.sizew, other.sizew)
            for i in range(min_len):
                for upperByte in common.GlobalConfig.IGNORE_WORD_LIST:
                    word = upperByte << 24
                    if ((self.words[i] >> 24) & 0xFF) == upperByte and ((other.words[i] >> 24) & 0xFF) == upperByte:
                        self.words[i] = word
                        other.words[i] = word
                        was_updated = True

        return was_updated
