"""
Constants for use in normalizing data, etc.

Variances for
1. Analysis file fields
2. GFS Forecast Fields
3. ERA5 Reanalysis Fields

where the variance is the variance in the 3 hour change for a variable averaged across all lat/lon and pressure levels
and time for (~100 random temporal frames, more the better)

Min/Max/Mean/Stddev for all those plus each type of observation in observation files

"""

ANALYSIS_MEANS = []
ANALYSIS_STD = []
ANALYSIS_MAX = []
ANALYSIS_MIN = []
ANALYSIS_VARIANCE = []


REANALYSIS_MEANS = []
REANALYSIS_STD = []
REANALYSIS_MAX = []
REANALYSIS_MIN = []
REANALYSIS_VARIANCE = []

LANDSEA_MEAN = {
    "cl": 0.005749,
    "cvh": 0.08282,
    "cvl": 0.1114,
    "slt": 0.6747,
    "sr": 0.0001,
    "tvh": 1.607,
    "tvl": 1.256,
    "z": 3.717e03,
}
LANDSEA_STD = {
    "cl": 0.0513,
    "cvh": 0.2523,
    "cvl": 0.2887,
    "slt": 1.185,
    "sr": 0.0,
    "tvh": 4.833,
    "tvl": 3.408,
    "z": 8.375e03,
}

SOLAR_STD = 403.1591444098585
SOLAR_MEAN = 299.97745340056
SOLAR_MAX = 1414.8996356465245
SOLAR_MIN = 0.0

FORECAST_MEANS = {'4LFTX.surface': 5.5574564933776855,
                  'ABSV.0.01_mb': -2.4563853457948426e-06,
                  'ABSV.0.02_mb': -2.723998704823316e-06,
                  'ABSV.0.04_mb': -3.233461484342115e-06,
                  'ABSV.0.07_mb': -3.793657015194185e-06,
                  'ABSV.0.1_mb': -4.199140676064417e-06,
                  'ABSV.0.2_mb': -5.079377842776012e-06,
                  'ABSV.0.4_mb': -5.572976988332812e-06,
                  'ABSV.0.7_mb': -5.727518328058068e-06,
                  'ABSV.1000_mb': 2.1305062603005354e-08,
                  'ABSV.100_mb': -1.0269882295688149e-06,
                  'ABSV.10_mb': -3.24287748298957e-06,
                  'ABSV.150_mb': -7.363660188275389e-07,
                  'ABSV.15_mb': -2.8319248031039024e-06,
                  'ABSV.1_mb': -5.688156306860037e-06,
                  'ABSV.200_mb': -6.104638714532484e-07,
                  'ABSV.20_mb': -2.5167473722831346e-06,
                  'ABSV.250_mb': -5.33344064024277e-07,
                  'ABSV.2_mb': -5.154664904694073e-06,
                  'ABSV.300_mb': -5.132546903041657e-07,
                  'ABSV.30_mb': -2.1414571165223606e-06,
                  'ABSV.350_mb': -4.995804374630097e-07,
                  'ABSV.3_mb': -4.689083198172739e-06,
                  'ABSV.400_mb': -4.548704453100072e-07,
                  'ABSV.40_mb': -1.8623383084559464e-06,
                  'ABSV.450_mb': -3.945673654470738e-07,
                  'ABSV.500_mb': -3.028104913482821e-07,
                  'ABSV.50_mb': -1.5965607644830015e-06,
                  'ABSV.550_mb': -1.9440041398866015e-07,
                  'ABSV.5_mb': -4.165398877375992e-06,
                  'ABSV.600_mb': -8.062749401460678e-08,
                  'ABSV.650_mb': 4.661326880039951e-09,
                  'ABSV.700_mb': 4.1924767657519624e-08,
                  'ABSV.70_mb': -1.2930811408295995e-06,
                  'ABSV.750_mb': 3.8085225639861164e-08,
                  'ABSV.7_mb': -3.7515526400966337e-06,
                  'ABSV.800_mb': 3.494816169791193e-08,
                  'ABSV.850_mb': 3.805589443572899e-08,
                  'ABSV.900_mb': 4.4466432314038684e-08,
                  'ABSV.925_mb': 4.430591360460312e-08,
                  'ABSV.950_mb': 3.175079044126505e-08,
                  'ABSV.975_mb': 1.564107598994724e-08,
                  'APTMP.2_m_above_ground': 275.7706604003906,
                  'CAPE.180-0_mb_above_ground': 139.2410125732422,
                  'CAPE.255-0_mb_above_ground': 180.7931671142578,
                  'CAPE.90-0_mb_above_ground': 103.31766510009766,
                  'CAPE.surface': 178.60882568359375,
                  'CFRZR.surface': 0.0006392152281478047,
                  'CICEP.surface': 2.6308662199880928e-05,
                  'CIN.180-0_mb_above_ground': -9.787450790405273,
                  'CIN.255-0_mb_above_ground': -9.51684284210205,
                  'CIN.90-0_mb_above_ground': -9.655198097229004,
                  'CIN.surface': -10.662747383117676,
                  'CLMR.1000_mb': 1.3575898947237874e-06,
                  'CLMR.100_mb': 4.0822956010610816e-29,
                  'CLMR.150_mb': 9.754599065210645e-22,
                  'CLMR.1_hybrid_level': 4.1589605643821415e-06,
                  'CLMR.200_mb': 1.8726065836860428e-11,
                  'CLMR.250_mb': 2.1801223049067175e-09,
                  'CLMR.300_mb': 6.251779538501978e-09,
                  'CLMR.350_mb': 1.3992867309298163e-08,
                  'CLMR.400_mb': 4.2773798725193046e-08,
                  'CLMR.450_mb': 2.3723364961369953e-07,
                  'CLMR.500_mb': 1.4558909242623486e-06,
                  'CLMR.50_mb': 0.0,
                  'CLMR.550_mb': 4.632370746548986e-06,
                  'CLMR.600_mb': 5.663445335812867e-06,
                  'CLMR.650_mb': 4.951943992637098e-06,
                  'CLMR.700_mb': 6.611540356971091e-06,
                  'CLMR.750_mb': 8.743088983464986e-06,
                  'CLMR.800_mb': 1.0847259545698762e-05,
                  'CLMR.850_mb': 1.6234431313932873e-05,
                  'CLMR.900_mb': 1.5380761396954767e-05,
                  'CLMR.925_mb': 1.2242657248862088e-05,
                  'CLMR.950_mb': 8.93428205017699e-06,
                  'CLMR.975_mb': 5.106481239636196e-06,
                  'CNWAT.surface': 0.0833016112446785,
                  'CPOFP.surface': -31.864530563354492,
                  'CRAIN.surface': 0.144229456782341,
                  'CSNOW.surface': 0.08344096690416336,
                  'CWAT.entire_atmosphere_considered_as_a_single_layer': 0.08105769753456116,
                  'DPT.2_m_above_ground': 273.78570556640625,
                  'DZDT.0.01_mb': -0.024787377566099167,
                  'DZDT.0.02_mb': -0.015519878827035427,
                  'DZDT.0.04_mb': -0.015757041051983833,
                  'DZDT.0.07_mb': -0.014030049555003643,
                  'DZDT.0.1_mb': -0.012989562936127186,
                  'DZDT.0.2_mb': -0.01104752253741026,
                  'DZDT.0.4_mb': -0.008832070976495743,
                  'DZDT.0.7_mb': -0.0067473226226866245,
                  'DZDT.1000_mb': -0.0024166337680071592,
                  'DZDT.100_mb': -0.0007485238602384925,
                  'DZDT.10_mb': -0.0008468537125736475,
                  'DZDT.150_mb': -0.000621348328422755,
                  'DZDT.15_mb': -0.0006713758921250701,
                  'DZDT.1_mb': -0.0054601156152784824,
                  'DZDT.200_mb': -0.0004519341164268553,
                  'DZDT.20_mb': -0.0006409050547517836,
                  'DZDT.250_mb': -0.000339686666848138,
                  'DZDT.2_mb': -0.00333634065464139,
                  'DZDT.300_mb': -0.00026825221721082926,
                  'DZDT.30_mb': -0.0006524292984977365,
                  'DZDT.350_mb': -0.00021673266019206494,
                  'DZDT.3_mb': -0.0023687798529863358,
                  'DZDT.400_mb': -0.00017804536037147045,
                  'DZDT.40_mb': -0.0006671398878097534,
                  'DZDT.450_mb': -0.0001595727080712095,
                  'DZDT.500_mb': -0.00015400639676954597,
                  'DZDT.50_mb': -0.0007084378739818931,
                  'DZDT.550_mb': -0.00015292268653865904,
                  'DZDT.5_mb': -0.0014948101015761495,
                  'DZDT.600_mb': -0.00014775298768654466,
                  'DZDT.650_mb': -0.00020740095351357013,
                  'DZDT.700_mb': -0.0004413160204421729,
                  'DZDT.70_mb': -0.0007552619790658355,
                  'DZDT.750_mb': -0.0007330107036978006,
                  'DZDT.7_mb': -0.0011016796343028545,
                  'DZDT.800_mb': -0.0010617674561217427,
                  'DZDT.850_mb': -0.001414045225828886,
                  'DZDT.900_mb': -0.0018236094620078802,
                  'DZDT.925_mb': -0.002045141998678446,
                  'DZDT.950_mb': -0.002261215355247259,
                  'DZDT.975_mb': -0.002405689097940922,
                  'FLDCP.surface': 0.2872394025325775,
                  'FRICV.surface': 0.29881027340888977,
                  'GRLE.1000_mb': 1.3337869475549269e-08,
                  'GRLE.100_mb': 6.337624647301254e-09,
                  'GRLE.150_mb': 3.1212120887857964e-08,
                  'GRLE.1_hybrid_level': 4.240220263795891e-08,
                  'GRLE.200_mb': 8.499431913833178e-08,
                  'GRLE.250_mb': 1.557212669922592e-07,
                  'GRLE.300_mb': 2.3761863587878906e-07,
                  'GRLE.350_mb': 3.2908315006352495e-07,
                  'GRLE.400_mb': 4.3470532773426385e-07,
                  'GRLE.450_mb': 5.635685056404327e-07,
                  'GRLE.500_mb': 7.236831152113155e-07,
                  'GRLE.50_mb': 3.737985920793108e-09,
                  'GRLE.550_mb': 8.022161068765854e-07,
                  'GRLE.600_mb': 4.161652782386227e-07,
                  'GRLE.650_mb': 3.0658631544611126e-07,
                  'GRLE.700_mb': 2.2739257588000328e-07,
                  'GRLE.750_mb': 1.663997863943223e-07,
                  'GRLE.800_mb': 1.2962799189608631e-07,
                  'GRLE.850_mb': 1.1010584444193228e-07,
                  'GRLE.900_mb': 8.836712339643782e-08,
                  'GRLE.925_mb': 7.542241320379617e-08,
                  'GRLE.950_mb': 6.005458175195599e-08,
                  'GRLE.975_mb': 3.640555235051579e-08,
                  'GUST.surface': 8.165311813354492,
                  'HCDC.high_cloud_layer': 36.26137161254883,
                  'HGT.0.01_mb': 78030.234375,
                  'HGT.0.02_mb': 74260.453125,
                  'HGT.0.04_mb': 70047.8046875,
                  'HGT.0.07_mb': 66439.7578125,
                  'HGT.0.1_mb': 64051.52734375,
                  'HGT.0.2_mb': 59184.90234375,
                  'HGT.0.4_mb': 54034.5234375,
                  'HGT.0.7_mb': 49748.8203125,
                  'HGT.0C_isotherm': 2415.9296875,
                  'HGT.1000_mb': 83.84851837158203,
                  'HGT.100_mb': 16078.8671875,
                  'HGT.10_mb': 30551.849609375,
                  'HGT.150_mb': 13587.9443359375,
                  'HGT.15_mb': 27910.314453125,
                  'HGT.1_mb': 47004.21484375,
                  'HGT.200_mb': 11776.7421875,
                  'HGT.20_mb': 26065.66015625,
                  'HGT.250_mb': 10340.70703125,
                  'HGT.2_mb': 41763.71484375,
                  'HGT.300_mb': 9136.0458984375,
                  'HGT.30_mb': 23501.16015625,
                  'HGT.350_mb': 8086.06689453125,
                  'HGT.3_mb': 38806.56640625,
                  'HGT.400_mb': 7149.62744140625,
                  'HGT.40_mb': 21702.40625,
                  'HGT.450_mb': 6302.26904296875,
                  'HGT.500_mb': 5527.5205078125,
                  'HGT.50_mb': 20317.861328125,
                  'HGT.550_mb': 4813.4111328125,
                  'HGT.5_mb': 35212.9765625,
                  'HGT.600_mb': 4150.91943359375,
                  'HGT.650_mb': 3533.227294921875,
                  'HGT.700_mb': 2954.72998046875,
                  'HGT.70_mb': 18249.5546875,
                  'HGT.750_mb': 2410.350341796875,
                  'HGT.7_mb': 32923.140625,
                  'HGT.800_mb': 1896.0850830078125,
                  'HGT.850_mb': 1408.842529296875,
                  'HGT.900_mb': 946.0070190429688,
                  'HGT.925_mb': 722.9406127929688,
                  'HGT.950_mb': 505.03900146484375,
                  'HGT.975_mb': 292.037109375,
                  'HGT.PV2e06Km2kgs_surface': 12750.609375,
                  'HGT.PVNeg2e06Km2kgs_surface': 12486.150390625,
                  'HGT.cloud_ceiling': 10579.0478515625,
                  'HGT.highest_tropospheric_freezing_level': 2465.071044921875,
                  'HGT.max_wind': 11588.40625,
                  'HGT.surface': 380.3205261230469,
                  'HGT.tropopause': 12344.8466796875,
                  'HINDEX.surface': 3.432063579559326,
                  'HLCY.3000-0_m_above_ground': 47.683433532714844,
                  'HPBL.surface': 616.8294067382812,
                  'ICAHT.max_wind': 11614.923828125,
                  'ICAHT.tropopause': 12422.560546875,
                  'ICEC.surface': 0.11526550352573395,
                  'ICEG.10_m_above_mean_sea_level': 2.612669725010619e-08,
                  'ICETK.surface': 0.1470668911933899,
                  'ICETMP.surface': 260.5045166015625,
                  'ICMR.1000_mb': 3.7587258816529356e-07,
                  'ICMR.100_mb': 1.4660911595854031e-08,
                  'ICMR.150_mb': 3.2896284096750605e-07,
                  'ICMR.1_hybrid_level': 1.8353800896875327e-06,
                  'ICMR.200_mb': 1.250230297955568e-06,
                  'ICMR.250_mb': 2.7600758585322183e-06,
                  'ICMR.300_mb': 4.329786861489993e-06,
                  'ICMR.350_mb': 5.54082680537249e-06,
                  'ICMR.400_mb': 6.365059562085662e-06,
                  'ICMR.450_mb': 6.833149200247135e-06,
                  'ICMR.500_mb': 7.015687060629716e-06,
                  'ICMR.50_mb': 8.441946586223992e-10,
                  'ICMR.550_mb': 6.688756002404261e-06,
                  'ICMR.600_mb': 5.749686351919081e-06,
                  'ICMR.650_mb': 5.325375695974799e-06,
                  'ICMR.700_mb': 4.815994543605484e-06,
                  'ICMR.750_mb': 4.341067779023433e-06,
                  'ICMR.800_mb': 3.923653366655344e-06,
                  'ICMR.850_mb': 3.4792255974025466e-06,
                  'ICMR.900_mb': 2.8774800284736557e-06,
                  'ICMR.925_mb': 2.5115748485404765e-06,
                  'ICMR.950_mb': 2.019245584961027e-06,
                  'ICMR.975_mb': 1.1242415212109336e-06,
                  'LAND.surface': 0.33806732296943665,
                  'LCDC.low_cloud_layer': 43.08974838256836,
                  'LFTX.surface': 9.898327827453613,
                  'MCDC.middle_cloud_layer': 34.02609634399414,
                  'MSLET.mean_sea_level': 100994.59375,
                  'O3MR.0.01_mb': 2.9262344014568953e-07,
                  'O3MR.0.02_mb': 3.892362485657941e-07,
                  'O3MR.0.04_mb': 5.57938051315432e-07,
                  'O3MR.0.07_mb': 6.950827469154319e-07,
                  'O3MR.0.1_mb': 8.33137278277718e-07,
                  'O3MR.0.2_mb': 1.4821215472693439e-06,
                  'O3MR.0.4_mb': 2.47783214035735e-06,
                  'O3MR.0.7_mb': 3.839809323835652e-06,
                  'O3MR.1000_mb': 5.7350746374140726e-08,
                  'O3MR.100_mb': 1.0697048082874971e-06,
                  'O3MR.10_mb': 1.2116141078877263e-05,
                  'O3MR.150_mb': 5.320032983036072e-07,
                  'O3MR.15_mb': 1.053525284078205e-05,
                  'O3MR.1_mb': 5.173442787054228e-06,
                  'O3MR.200_mb': 3.0137488238324295e-07,
                  'O3MR.20_mb': 9.116623914451338e-06,
                  'O3MR.250_mb': 1.7397563567556062e-07,
                  'O3MR.2_mb': 8.427452485193498e-06,
                  'O3MR.300_mb': 1.135426188625388e-07,
                  'O3MR.30_mb': 6.78989135849406e-06,
                  'O3MR.350_mb': 9.347062501774417e-08,
                  'O3MR.3_mb': 1.0252029824187048e-05,
                  'O3MR.400_mb': 8.64171596504093e-08,
                  'O3MR.40_mb': 5.097045232105302e-06,
                  'O3MR.450_mb': 8.250868432924108e-08,
                  'O3MR.500_mb': 7.944485247435296e-08,
                  'O3MR.50_mb': 3.819603080046363e-06,
                  'O3MR.550_mb': 7.704574045419577e-08,
                  'O3MR.5_mb': 1.1772064681281336e-05,
                  'O3MR.600_mb': 7.480298336304259e-08,
                  'O3MR.650_mb': 7.253566280951418e-08,
                  'O3MR.700_mb': 7.013415626033748e-08,
                  'O3MR.70_mb': 2.1587750325124944e-06,
                  'O3MR.750_mb': 6.738056868016429e-08,
                  'O3MR.7_mb': 1.2411738680384587e-05,
                  'O3MR.800_mb': 6.452157919056845e-08,
                  'O3MR.850_mb': 6.175676503517025e-08,
                  'O3MR.900_mb': 5.95352851462394e-08,
                  'O3MR.925_mb': 5.8694588744856446e-08,
                  'O3MR.950_mb': 5.8052972207178755e-08,
                  'O3MR.975_mb': 5.7608016135191065e-08,
                  'PLPL.255-0_mb_above_ground': 79681.7421875,
                  'POT.0.995_sigma_level': 282.68292236328125,
                  'PRATE.surface': 2.8869195375591516e-05,
                  'PRES.80_m_above_ground': 95635.3046875,
                  'PRES.PV2e06Km2kgs_surface': 19891.3515625,
                  'PRES.PVNeg2e06Km2kgs_surface': 20109.6328125,
                  'PRES.max_wind': 22251.619140625,
                  'PRES.surface': 96570.8359375,
                  'PRES.tropopause': 19729.388671875,
                  'PRMSL.mean_sea_level': 101016.8203125,
                  'PWAT.entire_atmosphere_considered_as_a_single_layer': 19.35736083984375,
                  'REFC.entire_atmosphere': -10.51606273651123,
                  'REFD.1000_m_above_ground': -12.866655349731445,
                  'REFD.1_hybrid_level': -12.562503814697266,
                  'REFD.2_hybrid_level': -12.557109832763672,
                  'REFD.4000_m_above_ground': -17.70831298828125,
                  'RH.0.01_mb': 0.066157266497612,
                  'RH.0.02_mb': 0.017351636663079262,
                  'RH.0.04_mb': 0.003630490740761161,
                  'RH.0.07_mb': 4.753236680699047e-06,
                  'RH.0.1_mb': 1.3059431580586534e-07,
                  'RH.0.2_mb': 0.0,
                  'RH.0.33-1_sigma_layer': 60.37097930908203,
                  'RH.0.44-0.72_sigma_layer': 52.730777740478516,
                  'RH.0.44-1_sigma_layer': 63.745933532714844,
                  'RH.0.4_mb': 0.0,
                  'RH.0.72-0.94_sigma_layer': 67.51569366455078,
                  'RH.0.7_mb': 0.0,
                  'RH.0.995_sigma_level': 74.31459045410156,
                  'RH.0C_isotherm': 65.18244171142578,
                  'RH.1000_mb': 75.55570983886719,
                  'RH.100_mb': 19.893918991088867,
                  'RH.10_mb': 0.796770453453064,
                  'RH.150_mb': 23.644371032714844,
                  'RH.15_mb': 1.4456530809402466,
                  'RH.1_mb': 7.082120667689651e-09,
                  'RH.200_mb': 34.098690032958984,
                  'RH.20_mb': 1.960776925086975,
                  'RH.250_mb': 47.13636016845703,
                  'RH.2_m_above_ground': 77.31654357910156,
                  'RH.2_mb': 0.00106833188328892,
                  'RH.30-0_mb_above_ground': 74.64241027832031,
                  'RH.300_mb': 53.30008316040039,
                  'RH.30_mb': 2.778388500213623,
                  'RH.350_mb': 53.72929000854492,
                  'RH.3_mb': 0.011915251612663269,
                  'RH.400_mb': 52.49028015136719,
                  'RH.40_mb': 3.8132009506225586,
                  'RH.450_mb': 51.586360931396484,
                  'RH.500_mb': 51.473548889160156,
                  'RH.50_mb': 5.161365032196045,
                  'RH.550_mb': 52.13166809082031,
                  'RH.5_mb': 0.0911223441362381,
                  'RH.600_mb': 53.17437744140625,
                  'RH.650_mb': 54.559852600097656,
                  'RH.700_mb': 56.49724197387695,
                  'RH.70_mb': 9.128311157226562,
                  'RH.750_mb': 59.176395416259766,
                  'RH.7_mb': 0.3316384553909302,
                  'RH.800_mb': 63.23972702026367,
                  'RH.850_mb': 69.72074890136719,
                  'RH.900_mb': 75.75147247314453,
                  'RH.925_mb': 77.70819091796875,
                  'RH.950_mb': 78.08557891845703,
                  'RH.975_mb': 77.10420227050781,
                  'RH.entire_atmosphere_considered_as_a_single_layer': 28.983980178833008,
                  'RH.highest_tropospheric_freezing_level': 63.29145431518555,
                  'RWMR.1000_mb': 1.4562457408828777e-06,
                  'RWMR.100_mb': 2.2373902730521422e-09,
                  'RWMR.150_mb': 3.5015257360271335e-09,
                  'RWMR.1_hybrid_level': 2.625182332849363e-06,
                  'RWMR.200_mb': 4.575401835182902e-09,
                  'RWMR.250_mb': 5.808988845501517e-09,
                  'RWMR.300_mb': 6.6389458375226695e-09,
                  'RWMR.350_mb': 7.023812642614757e-09,
                  'RWMR.400_mb': 7.237403565341083e-09,
                  'RWMR.450_mb': 7.74077602017087e-09,
                  'RWMR.500_mb': 2.206750693289905e-08,
                  'RWMR.50_mb': 4.4736228610453566e-10,
                  'RWMR.550_mb': 2.9156581149436533e-07,
                  'RWMR.600_mb': 1.3824314919475e-06,
                  'RWMR.650_mb': 1.4351753634400666e-06,
                  'RWMR.700_mb': 1.7176197388835135e-06,
                  'RWMR.750_mb': 1.9759531824092846e-06,
                  'RWMR.800_mb': 2.2102678940427722e-06,
                  'RWMR.850_mb': 2.538806711527286e-06,
                  'RWMR.900_mb': 2.7281341772322776e-06,
                  'RWMR.925_mb': 2.6775394417200005e-06,
                  'RWMR.950_mb': 2.5696749617054593e-06,
                  'RWMR.975_mb': 2.302449956914643e-06,
                  'SFCR.surface': 0.12640289962291718,
                  'SNMR.1000_mb': 1.4829441852270975e-07,
                  'SNMR.100_mb': 6.989169243354354e-09,
                  'SNMR.150_mb': 3.9467984436214465e-08,
                  'SNMR.1_hybrid_level': 1.047631826622819e-06,
                  'SNMR.200_mb': 1.4711704920955526e-07,
                  'SNMR.250_mb': 3.6923941593158816e-07,
                  'SNMR.300_mb': 7.603725293847674e-07,
                  'SNMR.350_mb': 1.3602909803012153e-06,
                  'SNMR.400_mb': 2.086606855300488e-06,
                  'SNMR.450_mb': 2.8517156351881567e-06,
                  'SNMR.500_mb': 3.5582199870987097e-06,
                  'SNMR.50_mb': 3.5622045313488115e-09,
                  'SNMR.550_mb': 3.85468501917785e-06,
                  'SNMR.600_mb': 2.950656153188902e-06,
                  'SNMR.650_mb': 2.891662234105752e-06,
                  'SNMR.700_mb': 2.728293338805088e-06,
                  'SNMR.750_mb': 2.47816296905512e-06,
                  'SNMR.800_mb': 2.196993591496721e-06,
                  'SNMR.850_mb': 1.911938852572348e-06,
                  'SNMR.900_mb': 1.614099346625153e-06,
                  'SNMR.925_mb': 1.4519881688102032e-06,
                  'SNMR.950_mb': 1.215205884363968e-06,
                  'SNMR.975_mb': 6.213454639691918e-07,
                  'SNOD.surface': 0.3510982096195221,
                  'SOILL.0-0.1_m_below_ground': 0.46133214235305786,
                  'SOILL.0.1-0.4_m_below_ground': 0.47632190585136414,
                  'SOILL.0.4-1_m_below_ground': 0.47123509645462036,
                  'SOILL.1-2_m_below_ground': 0.48924383521080017,
                  'SOILW.0-0.1_m_below_ground': 0.48102623224258423,
                  'SOILW.0.1-0.4_m_below_ground': 0.4936733543872833,
                  'SOILW.0.4-1_m_below_ground': 0.49116259813308716,
                  'SOILW.1-2_m_below_ground': 0.5215790271759033,
                  'SOTYP.surface': 3.165964365005493,
                  'SPFH.0.01_mb': 2.719807525863871e-06,
                  'SPFH.0.02_mb': 2.809486431942787e-06,
                  'SPFH.0.04_mb': 3.1291524464904796e-06,
                  'SPFH.0.07_mb': 3.3388139399903594e-06,
                  'SPFH.0.1_mb': 3.395116436877288e-06,
                  'SPFH.0.2_mb': 3.4071545087499544e-06,
                  'SPFH.0.4_mb': 3.3595936201891163e-06,
                  'SPFH.0.7_mb': 3.29491513184621e-06,
                  'SPFH.1000_mb': 0.007283107377588749,
                  'SPFH.100_mb': 1.928354549818323e-06,
                  'SPFH.10_mb': 2.323519083802239e-06,
                  'SPFH.150_mb': 4.347993581177434e-06,
                  'SPFH.15_mb': 2.143034862456261e-06,
                  'SPFH.1_mb': 3.2294713037117617e-06,
                  'SPFH.200_mb': 1.8401753550278954e-05,
                  'SPFH.20_mb': 2.0292911813157843e-06,
                  'SPFH.250_mb': 6.055368430679664e-05,
                  'SPFH.2_m_above_ground': 0.007396920584142208,
                  'SPFH.2_mb': 3.015424681507284e-06,
                  'SPFH.30-0_mb_above_ground': 0.006923413369804621,
                  'SPFH.300_mb': 0.000141948476084508,
                  'SPFH.30_mb': 1.8904664784713532e-06,
                  'SPFH.350_mb': 0.00026935484493151307,
                  'SPFH.3_mb': 2.849727934517432e-06,
                  'SPFH.400_mb': 0.00044797229929827154,
                  'SPFH.40_mb': 1.8228056433144957e-06,
                  'SPFH.450_mb': 0.0006841268623247743,
                  'SPFH.500_mb': 0.0009791896445676684,
                  'SPFH.50_mb': 1.7851106122179772e-06,
                  'SPFH.550_mb': 0.0013380401069298387,
                  'SPFH.5_mb': 2.6279958547092974e-06,
                  'SPFH.600_mb': 0.0017464470583945513,
                  'SPFH.650_mb': 0.0021898136474192142,
                  'SPFH.700_mb': 0.0026846993714571,
                  'SPFH.70_mb': 1.7782707573132939e-06,
                  'SPFH.750_mb': 0.003252421971410513,
                  'SPFH.7_mb': 2.4865671548468526e-06,
                  'SPFH.800_mb': 0.0039387051947414875,
                  'SPFH.80_m_above_ground': 0.0069496287032961845,
                  'SPFH.850_mb': 0.004838217049837112,
                  'SPFH.900_mb': 0.005828666500747204,
                  'SPFH.925_mb': 0.006332406308501959,
                  'SPFH.950_mb': 0.00674228323623538,
                  'SPFH.975_mb': 0.007035978138446808,
                  'SUNSD.surface': 7509.400390625,
                  'TCDC.1000_mb': 3.350968599319458,
                  'TCDC.100_mb': 1.0690135955810547,
                  'TCDC.150_mb': 3.5162315368652344,
                  'TCDC.200_mb': 7.6165947914123535,
                  'TCDC.250_mb': 12.624226570129395,
                  'TCDC.300_mb': 15.41524600982666,
                  'TCDC.350_mb': 16.509410858154297,
                  'TCDC.400_mb': 16.50069236755371,
                  'TCDC.450_mb': 16.135894775390625,
                  'TCDC.500_mb': 15.78121280670166,
                  'TCDC.50_mb': 0.15508222579956055,
                  'TCDC.550_mb': 15.527510643005371,
                  'TCDC.600_mb': 14.77937126159668,
                  'TCDC.650_mb': 13.471718788146973,
                  'TCDC.700_mb': 12.089424133300781,
                  'TCDC.750_mb': 12.047636985778809,
                  'TCDC.800_mb': 12.65523910522461,
                  'TCDC.850_mb': 14.626729011535645,
                  'TCDC.900_mb': 14.35248851776123,
                  'TCDC.925_mb': 13.159822463989258,
                  'TCDC.950_mb': 11.324460983276367,
                  'TCDC.975_mb': 8.050597190856934,
                  'TCDC.entire_atmosphere': 66.88426971435547,
                  'TMP.0.01_mb': 179.43202209472656,
                  'TMP.0.02_mb': 197.93629455566406,
                  'TMP.0.04_mb': 214.81700134277344,
                  'TMP.0.07_mb': 224.9519500732422,
                  'TMP.0.1_mb': 232.0176239013672,
                  'TMP.0.2_mb': 247.16024780273438,
                  'TMP.0.4_mb': 259.04791259765625,
                  'TMP.0.7_mb': 263.005615234375,
                  'TMP.0.995_sigma_level': 279.3004150390625,
                  'TMP.1000_mb': 281.29913330078125,
                  'TMP.100_m_above_ground': 279.24322509765625,
                  'TMP.100_mb': 207.81802368164062,
                  'TMP.10_mb': 224.85594177246094,
                  'TMP.150_mb': 212.7047119140625,
                  'TMP.15_mb': 220.44363403320312,
                  'TMP.1829_m_above_mean_sea_level': 276.0357666015625,
                  'TMP.1_mb': 262.23291015625,
                  'TMP.200_mb': 217.52230834960938,
                  'TMP.20_mb': 217.73968505859375,
                  'TMP.250_mb': 222.62100219726562,
                  'TMP.2743_m_above_mean_sea_level': 270.72711181640625,
                  'TMP.2_m_above_ground': 279.3106689453125,
                  'TMP.2_mb': 253.0123748779297,
                  'TMP.30-0_mb_above_ground': 279.18572998046875,
                  'TMP.300_mb': 229.2122344970703,
                  'TMP.30_mb': 214.55270385742188,
                  'TMP.350_mb': 236.27603149414062,
                  'TMP.3658_m_above_mean_sea_level': 264.6911315917969,
                  'TMP.3_mb': 245.3492431640625,
                  'TMP.400_mb': 242.8138427734375,
                  'TMP.40_mb': 212.69044494628906,
                  'TMP.450_mb': 248.5659942626953,
                  'TMP.500_mb': 253.58802795410156,
                  'TMP.50_mb': 211.24122619628906,
                  'TMP.550_mb': 257.965087890625,
                  'TMP.5_mb': 235.52369689941406,
                  'TMP.600_mb': 261.7254333496094,
                  'TMP.650_mb': 264.8844299316406,
                  'TMP.700_mb': 267.7388610839844,
                  'TMP.70_mb': 208.72998046875,
                  'TMP.750_mb': 270.44561767578125,
                  'TMP.7_mb': 229.6839599609375,
                  'TMP.800_mb': 272.85296630859375,
                  'TMP.80_m_above_ground': 279.27978515625,
                  'TMP.850_mb': 274.8920593261719,
                  'TMP.900_mb': 276.797607421875,
                  'TMP.925_mb': 277.7903747558594,
                  'TMP.950_mb': 278.8636169433594,
                  'TMP.975_mb': 280.020263671875,
                  'TMP.PV2e06Km2kgs_surface': 210.53985595703125,
                  'TMP.PVNeg2e06Km2kgs_surface': 208.3433837890625,
                  'TMP.max_wind': 217.28863525390625,
                  'TMP.surface': 279.6814880371094,
                  'TMP.tropopause': 207.74168395996094,
                  'TOZNE.entire_atmosphere_considered_as_a_single_layer': 295.311279296875,
                  'TSOIL.0-0.1_m_below_ground': 270.48345947265625,
                  'TSOIL.0.1-0.4_m_below_ground': 270.51641845703125,
                  'TSOIL.0.4-1_m_below_ground': 270.2599792480469,
                  'TSOIL.1-2_m_below_ground': 269.6739501953125,
                  'UGRD.0.01_mb': 5.302773952484131,
                  'UGRD.0.02_mb': 5.303124904632568,
                  'UGRD.0.04_mb': 6.615498065948486,
                  'UGRD.0.07_mb': 9.34668254852295,
                  'UGRD.0.1_mb': 11.104997634887695,
                  'UGRD.0.2_mb': 13.326855659484863,
                  'UGRD.0.4_mb': 15.184036254882812,
                  'UGRD.0.7_mb': 17.02631378173828,
                  'UGRD.0.995_sigma_level': 0.15632317960262299,
                  'UGRD.1000_mb': 0.14209102094173431,
                  'UGRD.100_m_above_ground': 0.20563001930713654,
                  'UGRD.100_mb': 10.684046745300293,
                  'UGRD.10_m_above_ground': 0.09924869239330292,
                  'UGRD.10_mb': 7.75432014465332,
                  'UGRD.150_mb': 13.665441513061523,
                  'UGRD.15_mb': 5.1938371658325195,
                  'UGRD.1829_m_above_mean_sea_level': 2.387120008468628,
                  'UGRD.1_mb': 17.598007202148438,
                  'UGRD.200_mb': 14.160537719726562,
                  'UGRD.20_m_above_ground': 0.11910069733858109,
                  'UGRD.20_mb': 4.223875522613525,
                  'UGRD.250_mb': 13.247207641601562,
                  'UGRD.2743_m_above_mean_sea_level': 3.4181957244873047,
                  'UGRD.2_mb': 17.36669921875,
                  'UGRD.30-0_mb_above_ground': 0.22199353575706482,
                  'UGRD.300_mb': 11.744734764099121,
                  'UGRD.30_m_above_ground': 0.13977080583572388,
                  'UGRD.30_mb': 4.633049011230469,
                  'UGRD.350_mb': 10.229377746582031,
                  'UGRD.3658_m_above_mean_sea_level': 4.420628070831299,
                  'UGRD.3_mb': 16.02313995361328,
                  'UGRD.400_mb': 8.871583938598633,
                  'UGRD.40_m_above_ground': 0.14822322130203247,
                  'UGRD.40_mb': 6.178291320800781,
                  'UGRD.450_mb': 7.692761421203613,
                  'UGRD.500_mb': 6.677542686462402,
                  'UGRD.50_m_above_ground': 0.16038429737091064,
                  'UGRD.50_mb': 7.545408248901367,
                  'UGRD.550_mb': 5.773837566375732,
                  'UGRD.5_mb': 12.696409225463867,
                  'UGRD.600_mb': 4.950896739959717,
                  'UGRD.650_mb': 4.192191123962402,
                  'UGRD.700_mb': 3.5148556232452393,
                  'UGRD.70_mb': 8.725064277648926,
                  'UGRD.750_mb': 2.8782904148101807,
                  'UGRD.7_mb': 10.343632698059082,
                  'UGRD.800_mb': 2.2464358806610107,
                  'UGRD.80_m_above_ground': 0.18783928453922272,
                  'UGRD.850_mb': 1.6236872673034668,
                  'UGRD.900_mb': 1.0923585891723633,
                  'UGRD.925_mb': 0.8731704950332642,
                  'UGRD.950_mb': 0.6736690998077393,
                  'UGRD.975_mb': 0.4360916316509247,
                  'UGRD.PV2e06Km2kgs_surface': 8.299591064453125,
                  'UGRD.PVNeg2e06Km2kgs_surface': 12.937704086303711,
                  'UGRD.max_wind': 16.118837356567383,
                  'UGRD.planetary_boundary_layer': 0.4470789432525635,
                  'UGRD.tropopause': 11.943513870239258,
                  'USTM.6000-0_m_above_ground': 2.2526657581329346,
                  'VEG.surface': 21.337934494018555,
                  'VGRD.0.01_mb': -4.647756099700928,
                  'VGRD.0.02_mb': -4.425092697143555,
                  'VGRD.0.04_mb': -2.62363338470459,
                  'VGRD.0.07_mb': -1.6232023239135742,
                  'VGRD.0.1_mb': -1.3147670030593872,
                  'VGRD.0.2_mb': -0.8945381045341492,
                  'VGRD.0.4_mb': -0.6411399841308594,
                  'VGRD.0.7_mb': -0.3244401812553406,
                  'VGRD.0.995_sigma_level': 0.30271053314208984,
                  'VGRD.1000_mb': 0.2750866711139679,
                  'VGRD.100_m_above_ground': 0.3151736259460449,
                  'VGRD.100_mb': -0.05894904211163521,
                  'VGRD.10_m_above_ground': 0.2596607506275177,
                  'VGRD.10_mb': -0.029179269447922707,
                  'VGRD.150_mb': -0.21233539283275604,
                  'VGRD.15_mb': -0.009521757252514362,
                  'VGRD.1829_m_above_mean_sea_level': 0.10154138505458832,
                  'VGRD.1_mb': -0.20155219733715057,
                  'VGRD.200_mb': -0.19348503649234772,
                  'VGRD.20_m_above_ground': 0.2719937562942505,
                  'VGRD.20_mb': -0.027650965377688408,
                  'VGRD.250_mb': -0.14048585295677185,
                  'VGRD.2743_m_above_mean_sea_level': 0.015649178996682167,
                  'VGRD.2_mb': -0.06376004964113235,
                  'VGRD.30-0_mb_above_ground': 0.29215720295906067,
                  'VGRD.300_mb': -0.0696013867855072,
                  'VGRD.30_m_above_ground': 0.28734272718429565,
                  'VGRD.30_mb': -0.016170546412467957,
                  'VGRD.350_mb': -0.028043054044246674,
                  'VGRD.3658_m_above_mean_sea_level': -0.031984537839889526,
                  'VGRD.3_mb': -0.020691493526101112,
                  'VGRD.400_mb': -0.030288228765130043,
                  'VGRD.40_m_above_ground': 0.29622164368629456,
                  'VGRD.40_mb': -0.026963520795106888,
                  'VGRD.450_mb': -0.04405616968870163,
                  'VGRD.500_mb': -0.05674489960074425,
                  'VGRD.50_m_above_ground': 0.3020903170108795,
                  'VGRD.50_mb': -0.030684322118759155,
                  'VGRD.550_mb': -0.05302828550338745,
                  'VGRD.5_mb': -0.010705975815653801,
                  'VGRD.600_mb': -0.04208378121256828,
                  'VGRD.650_mb': -0.02159280516207218,
                  'VGRD.700_mb': 0.030768923461437225,
                  'VGRD.70_mb': -0.018396634608507156,
                  'VGRD.750_mb': 0.08324325084686279,
                  'VGRD.7_mb': -0.024244436994194984,
                  'VGRD.800_mb': 0.1580999195575714,
                  'VGRD.80_m_above_ground': 0.3124154806137085,
                  'VGRD.850_mb': 0.24584726989269257,
                  'VGRD.900_mb': 0.31510308384895325,
                  'VGRD.925_mb': 0.3263362944126129,
                  'VGRD.950_mb': 0.31461769342422485,
                  'VGRD.975_mb': 0.28521233797073364,
                  'VGRD.PV2e06Km2kgs_surface': -0.5658929347991943,
                  'VGRD.PVNeg2e06Km2kgs_surface': 0.22053921222686768,
                  'VGRD.max_wind': -0.3838859498500824,
                  'VGRD.planetary_boundary_layer': 0.3176780045032501,
                  'VGRD.tropopause': -0.09009042382240295,
                  'VIS.surface': 20076.044921875,
                  'VRATE.planetary_boundary_layer': 6117.869140625,
                  'VSTM.6000-0_m_above_ground': -3.024580717086792,
                  'VVEL.0.01_mb': 6.071755251468858e-06,
                  'VVEL.0.02_mb': 5.311665518092923e-06,
                  'VVEL.0.04_mb': 9.997542292694561e-06,
                  'VVEL.0.07_mb': 1.4660193301097024e-05,
                  'VVEL.0.1_mb': 1.8852406356018037e-05,
                  'VVEL.0.2_mb': 3.0168213925207965e-05,
                  'VVEL.0.4_mb': 4.634593642549589e-05,
                  'VVEL.0.7_mb': 6.161342025734484e-05,
                  'VVEL.0.995_sigma_level': 0.030270550400018692,
                  'VVEL.1000_mb': 0.027492370456457138,
                  'VVEL.100_mb': 0.0012627188116312027,
                  'VVEL.10_mb': 0.00012404588051140308,
                  'VVEL.150_mb': 0.0014976186212152243,
                  'VVEL.15_mb': 0.00014910908066667616,
                  'VVEL.1_mb': 7.184039714047685e-05,
                  'VVEL.200_mb': 0.0014198926510289311,
                  'VVEL.20_mb': 0.00019313742814119905,
                  'VVEL.250_mb': 0.0013598421355709434,
                  'VVEL.2_mb': 9.09643858904019e-05,
                  'VVEL.300_mb': 0.0013450873084366322,
                  'VVEL.30_mb': 0.0003051271487493068,
                  'VVEL.350_mb': 0.001325989724136889,
                  'VVEL.3_mb': 9.905815386446193e-05,
                  'VVEL.400_mb': 0.0012943386100232601,
                  'VVEL.40_mb': 0.00042483594734221697,
                  'VVEL.450_mb': 0.0013208375312387943,
                  'VVEL.500_mb': 0.0013906506355851889,
                  'VVEL.50_mb': 0.000575380923692137,
                  'VVEL.550_mb': 0.0014719002647325397,
                  'VVEL.5_mb': 0.00010748708882601932,
                  'VVEL.600_mb': 0.001550321583636105,
                  'VVEL.650_mb': 0.0022460026666522026,
                  'VVEL.700_mb': 0.004734458867460489,
                  'VVEL.70_mb': 0.0008846214041113853,
                  'VVEL.750_mb': 0.00787372700870037,
                  'VVEL.7_mb': 0.00011199490108992904,
                  'VVEL.800_mb': 0.01156277023255825,
                  'VVEL.850_mb': 0.015599653124809265,
                  'VVEL.900_mb': 0.020395660772919655,
                  'VVEL.925_mb': 0.02302153781056404,
                  'VVEL.950_mb': 0.025597048923373222,
                  'VVEL.975_mb': 0.027351295575499535,
                  'VWSH.PV2e06Km2kgs_surface': -0.0019878000020980835,
                  'VWSH.PVNeg2e06Km2kgs_surface': -0.0019008874660357833,
                  'VWSH.tropopause': -0.0019187068101018667,
                  'WEASD.surface': 48.580108642578125,
                  'WILT.surface': 0.05623394995927811}
FORECAST_STD = {'4LFTX.surface': 6.375093460083008,
                'ABSV.0.01_mb': 0.00011718904715962708,
                'ABSV.0.02_mb': 0.00012297787179704756,
                'ABSV.0.04_mb': 0.00014005278353579342,
                'ABSV.0.07_mb': 0.00014876604836899787,
                'ABSV.0.1_mb': 0.00014146060857456177,
                'ABSV.0.2_mb': 0.00013001399929635227,
                'ABSV.0.4_mb': 0.0001236105599673465,
                'ABSV.0.7_mb': 0.00012142966443207115,
                'ABSV.1000_mb': 0.00011752310092560947,
                'ABSV.100_mb': 0.00011658792936941609,
                'ABSV.10_mb': 0.00011606980842771009,
                'ABSV.150_mb': 0.00011972359789069742,
                'ABSV.15_mb': 0.00011487126175779849,
                'ABSV.1_mb': 0.00012001903814962134,
                'ABSV.200_mb': 0.00012476698611862957,
                'ABSV.20_mb': 0.00011381821241229773,
                'ABSV.250_mb': 0.00013208476593717933,
                'ABSV.2_mb': 0.00011890594760188833,
                'ABSV.300_mb': 0.00013803511683363467,
                'ABSV.30_mb': 0.00011280669423285872,
                'ABSV.350_mb': 0.00013656086230184883,
                'ABSV.3_mb': 0.00011720742622856051,
                'ABSV.400_mb': 0.00013311197108123451,
                'ABSV.40_mb': 0.000113885551400017,
                'ABSV.450_mb': 0.00012922281166538596,
                'ABSV.500_mb': 0.0001254356757272035,
                'ABSV.50_mb': 0.00011339028424117714,
                'ABSV.550_mb': 0.000123024990898557,
                'ABSV.5_mb': 0.00011638283467618749,
                'ABSV.600_mb': 0.00012160770711489022,
                'ABSV.650_mb': 0.00012118332961108536,
                'ABSV.700_mb': 0.00012148252426413819,
                'ABSV.70_mb': 0.00011377331975381821,
                'ABSV.750_mb': 0.00012203436199342832,
                'ABSV.7_mb': 0.00011595244723139331,
                'ABSV.800_mb': 0.00012291781604290009,
                'ABSV.850_mb': 0.00012394027726259083,
                'ABSV.900_mb': 0.00012452909140847623,
                'ABSV.925_mb': 0.00012456599506549537,
                'ABSV.950_mb': 0.00012372253695502877,
                'ABSV.975_mb': 0.0001211378476000391,
                'APTMP.2_m_above_ground': 27.300865173339844,
                'CAPE.180-0_mb_above_ground': 350.0282897949219,
                'CAPE.255-0_mb_above_ground': 433.7242736816406,
                'CAPE.90-0_mb_above_ground': 282.5855712890625,
                'CAPE.surface': 431.6639099121094,
                'CFRZR.surface': 0.025274623185396194,
                'CICEP.surface': 0.005129129160195589,
                'CIN.180-0_mb_above_ground': 40.94698715209961,
                'CIN.255-0_mb_above_ground': 41.55531311035156,
                'CIN.90-0_mb_above_ground': 38.668819427490234,
                'CIN.surface': 46.418251037597656,
                'CLMR.1000_mb': 1.7726044461596757e-05,
                'CLMR.100_mb': 0.0,
                'CLMR.150_mb': 1.1877387153975418e-17,
                'CLMR.1_hybrid_level': 3.91912653867621e-05,
                'CLMR.200_mb': 2.5368962042193743e-08,
                'CLMR.250_mb': 4.97716087011213e-07,
                'CLMR.300_mb': 1.021189177663473e-06,
                'CLMR.350_mb': 1.6613007574051153e-06,
                'CLMR.400_mb': 3.17285162054759e-06,
                'CLMR.450_mb': 8.137649274431169e-06,
                'CLMR.500_mb': 2.1797619410790503e-05,
                'CLMR.50_mb': 0.0,
                'CLMR.550_mb': 4.2936851968988776e-05,
                'CLMR.600_mb': 4.6088811359368265e-05,
                'CLMR.650_mb': 4.223572977934964e-05,
                'CLMR.700_mb': 4.860455010202713e-05,
                'CLMR.750_mb': 5.424376649898477e-05,
                'CLMR.800_mb': 5.7796343753580004e-05,
                'CLMR.850_mb': 6.796966044930741e-05,
                'CLMR.900_mb': 6.389721238519996e-05,
                'CLMR.925_mb': 5.545200110645965e-05,
                'CLMR.950_mb': 4.64124750578776e-05,
                'CLMR.975_mb': 3.4430926461936906e-05,
                'CNWAT.surface': 0.1640477329492569,
                'CPOFP.surface': 38.17919158935547,
                'CRAIN.surface': 0.3513222336769104,
                'CSNOW.surface': 0.2765475809574127,
                'CWAT.entire_atmosphere_considered_as_a_single_layer': 0.20076964795589447,
                'DPT.2_m_above_ground': 22.060508728027344,
                'DZDT.0.01_mb': 0.08916423469781876,
                'DZDT.0.02_mb': 0.31290361285209656,
                'DZDT.0.04_mb': 0.3912360668182373,
                'DZDT.0.07_mb': 0.3231354355812073,
                'DZDT.0.1_mb': 0.2828764021396637,
                'DZDT.0.2_mb': 0.2506212592124939,
                'DZDT.0.4_mb': 0.20278720557689667,
                'DZDT.0.7_mb': 0.1610543131828308,
                'DZDT.1000_mb': 0.017175868153572083,
                'DZDT.100_mb': 0.0256130862981081,
                'DZDT.10_mb': 0.05308319628238678,
                'DZDT.150_mb': 0.03305297717452049,
                'DZDT.15_mb': 0.045907340943813324,
                'DZDT.1_mb': 0.13454373180866241,
                'DZDT.200_mb': 0.03926388546824455,
                'DZDT.20_mb': 0.040519800037145615,
                'DZDT.250_mb': 0.04374256730079651,
                'DZDT.2_mb': 0.10524740070104599,
                'DZDT.300_mb': 0.046232618391513824,
                'DZDT.30_mb': 0.03322726488113403,
                'DZDT.350_mb': 0.04605087265372276,
                'DZDT.3_mb': 0.08665450662374496,
                'DZDT.400_mb': 0.04487378150224686,
                'DZDT.40_mb': 0.030520068481564522,
                'DZDT.450_mb': 0.04309994727373123,
                'DZDT.500_mb': 0.041137512773275375,
                'DZDT.50_mb': 0.027072632685303688,
                'DZDT.550_mb': 0.03963368013501167,
                'DZDT.5_mb': 0.07317211478948593,
                'DZDT.600_mb': 0.03882230073213577,
                'DZDT.650_mb': 0.03821524605154991,
                'DZDT.700_mb': 0.03761128708720207,
                'DZDT.70_mb': 0.0244029238820076,
                'DZDT.750_mb': 0.03674072399735451,
                'DZDT.7_mb': 0.06075604632496834,
                'DZDT.800_mb': 0.03514358773827553,
                'DZDT.850_mb': 0.03244686871767044,
                'DZDT.900_mb': 0.028053194284439087,
                'DZDT.925_mb': 0.025057977065443993,
                'DZDT.950_mb': 0.02175026759505272,
                'DZDT.975_mb': 0.018836282193660736,
                'FLDCP.surface': 0.04094677045941353,
                'FRICV.surface': 0.17815439403057098,
                'GRLE.1000_mb': 4.882921302851173e-07,
                'GRLE.100_mb': 8.715083481547481e-07,
                'GRLE.150_mb': 6.12464555160841e-06,
                'GRLE.1_hybrid_level': 1.913959067678661e-06,
                'GRLE.200_mb': 1.1843293577840086e-05,
                'GRLE.250_mb': 1.74309425347019e-05,
                'GRLE.300_mb': 2.208215300925076e-05,
                'GRLE.350_mb': 2.55990289588226e-05,
                'GRLE.400_mb': 2.8416417990229093e-05,
                'GRLE.450_mb': 3.056368586840108e-05,
                'GRLE.500_mb': 3.125513831037097e-05,
                'GRLE.50_mb': 1.947889849418516e-09,
                'GRLE.550_mb': 2.7528480131877586e-05,
                'GRLE.600_mb': 1.7732510968926363e-05,
                'GRLE.650_mb': 1.3172773833503015e-05,
                'GRLE.700_mb': 9.059715921466704e-06,
                'GRLE.750_mb': 6.389865120581817e-06,
                'GRLE.800_mb': 4.736882146971766e-06,
                'GRLE.850_mb': 3.5001678497792454e-06,
                'GRLE.900_mb': 2.5987524168158416e-06,
                'GRLE.925_mb': 2.2373999399860622e-06,
                'GRLE.950_mb': 1.8577030687083607e-06,
                'GRLE.975_mb': 1.2463632401704672e-06,
                'GUST.surface': 5.284334182739258,
                'HCDC.high_cloud_layer': 42.93070602416992,
                'HGT.0.01_mb': 1123.7640380859375,
                'HGT.0.02_mb': 1177.9677734375,
                'HGT.0.04_mb': 1313.0972900390625,
                'HGT.0.07_mb': 1472.0675048828125,
                'HGT.0.1_mb': 1578.4171142578125,
                'HGT.0.2_mb': 1759.787109375,
                'HGT.0.4_mb': 1874.5631103515625,
                'HGT.0.7_mb': 1885.6226806640625,
                'HGT.0C_isotherm': 2080.787109375,
                'HGT.1000_mb': 112.97335815429688,
                'HGT.100_mb': 620.5552978515625,
                'HGT.10_mb': 1164.8953857421875,
                'HGT.150_mb': 629.5719604492188,
                'HGT.15_mb': 1034.378662109375,
                'HGT.1_mb': 1842.9981689453125,
                'HGT.200_mb': 618.2514038085938,
                'HGT.20_mb': 943.5953369140625,
                'HGT.250_mb': 583.9107666015625,
                'HGT.2_mb': 1665.25390625,
                'HGT.300_mb': 536.1240844726562,
                'HGT.30_mb': 822.7099609375,
                'HGT.350_mb': 485.82879638671875,
                'HGT.3_mb': 1540.340576171875,
                'HGT.400_mb': 438.5798034667969,
                'HGT.40_mb': 745.5488891601562,
                'HGT.450_mb': 395.6790771484375,
                'HGT.500_mb': 357.03668212890625,
                'HGT.50_mb': 693.8172607421875,
                'HGT.550_mb': 322.0881652832031,
                'HGT.5_mb': 1383.9468994140625,
                'HGT.600_mb': 289.9405517578125,
                'HGT.650_mb': 259.27069091796875,
                'HGT.700_mb': 229.61741638183594,
                'HGT.70_mb': 637.9595336914062,
                'HGT.750_mb': 201.8413543701172,
                'HGT.7_mb': 1279.0169677734375,
                'HGT.800_mb': 176.5595703125,
                'HGT.850_mb': 154.39761352539062,
                'HGT.900_mb': 136.07579040527344,
                'HGT.925_mb': 128.51763916015625,
                'HGT.950_mb': 122.09329223632812,
                'HGT.975_mb': 116.88359832763672,
                'HGT.PV2e06Km2kgs_surface': 3563.71826171875,
                'HGT.PVNeg2e06Km2kgs_surface': 3834.818115234375,
                'HGT.cloud_ceiling': 9098.7216796875,
                'HGT.highest_tropospheric_freezing_level': 2058.8935546875,
                'HGT.max_wind': 2777.261962890625,
                'HGT.surface': 853.698974609375,
                'HGT.tropopause': 3144.041015625,
                'HINDEX.surface': 1.3838348388671875,
                'HLCY.3000-0_m_above_ground': 68.7801742553711,
                'HPBL.surface': 562.0670776367188,
                'ICAHT.max_wind': 2652.989013671875,
                'ICAHT.tropopause': 2763.018798828125,
                'ICEC.surface': 0.3096162676811218,
                'ICEG.10_m_above_mean_sea_level': 6.740463618370995e-07,
                'ICETK.surface': 0.4637010395526886,
                'ICETMP.surface': 11.101191520690918,
                'ICMR.1000_mb': 3.710409373525181e-06,
                'ICMR.100_mb': 1.7419665709894616e-06,
                'ICMR.150_mb': 7.067517344694352e-06,
                'ICMR.1_hybrid_level': 8.593438906245865e-06,
                'ICMR.200_mb': 1.1988210644631181e-05,
                'ICMR.250_mb': 1.8342656403547153e-05,
                'ICMR.300_mb': 2.393048634985462e-05,
                'ICMR.350_mb': 2.7187965315533802e-05,
                'ICMR.400_mb': 2.8654001653194427e-05,
                'ICMR.450_mb': 2.8847714929725043e-05,
                'ICMR.500_mb': 2.807379132718779e-05,
                'ICMR.50_mb': 8.397653239455849e-09,
                'ICMR.550_mb': 2.5996614567702636e-05,
                'ICMR.600_mb': 2.3448526917491108e-05,
                'ICMR.650_mb': 2.1834222934558056e-05,
                'ICMR.700_mb': 2.0093035345780663e-05,
                'ICMR.750_mb': 1.8324593838769943e-05,
                'ICMR.800_mb': 1.6665015209582634e-05,
                'ICMR.850_mb': 1.4902456314302981e-05,
                'ICMR.900_mb': 1.298224651691271e-05,
                'ICMR.925_mb': 1.1927675586775877e-05,
                'ICMR.950_mb': 1.0306001968274359e-05,
                'ICMR.975_mb': 7.168687261582818e-06,
                'LAND.surface': 0.4730515480041504,
                'LCDC.low_cloud_layer': 44.406028747558594,
                'LFTX.surface': 10.396241188049316,
                'MCDC.middle_cloud_layer': 43.330875396728516,
                'MSLET.mean_sea_level': 1437.9874267578125,
                'O3MR.0.01_mb': 5.664334068455901e-08,
                'O3MR.0.02_mb': 5.724457707856345e-08,
                'O3MR.0.04_mb': 8.60129460988901e-08,
                'O3MR.0.07_mb': 1.2202674781747191e-07,
                'O3MR.0.1_mb': 1.2938059512634936e-07,
                'O3MR.0.2_mb': 1.3851253299890232e-07,
                'O3MR.0.4_mb': 2.6807995823219244e-07,
                'O3MR.0.7_mb': 4.806089464182151e-07,
                'O3MR.1000_mb': 1.2716487418629185e-08,
                'O3MR.100_mb': 7.995789133019571e-07,
                'O3MR.10_mb': 3.2945008570095524e-06,
                'O3MR.150_mb': 4.717490469374752e-07,
                'O3MR.15_mb': 2.9294149044289952e-06,
                'O3MR.1_mb': 6.809772798987979e-07,
                'O3MR.200_mb': 2.7861628382197523e-07,
                'O3MR.20_mb': 2.330833240193897e-06,
                'O3MR.250_mb': 1.6255773971352028e-07,
                'O3MR.2_mb': 1.019252977130236e-06,
                'O3MR.300_mb': 8.209638480138892e-08,
                'O3MR.30_mb': 1.2433034726200276e-06,
                'O3MR.350_mb': 4.5812438287384794e-08,
                'O3MR.3_mb': 1.3297280929691624e-06,
                'O3MR.400_mb': 3.260344527689085e-08,
                'O3MR.40_mb': 8.556726243114099e-07,
                'O3MR.450_mb': 2.6426159038805963e-08,
                'O3MR.500_mb': 2.2389276210788012e-08,
                'O3MR.50_mb': 9.204724733535841e-07,
                'O3MR.550_mb': 1.974033914109441e-08,
                'O3MR.5_mb': 2.135060412911116e-06,
                'O3MR.600_mb': 1.7964143950166545e-08,
                'O3MR.650_mb': 1.6659136292673793e-08,
                'O3MR.700_mb': 1.5559971089373903e-08,
                'O3MR.70_mb': 1.0481110166438157e-06,
                'O3MR.750_mb': 1.4408268356191911e-08,
                'O3MR.7_mb': 2.8366644073685165e-06,
                'O3MR.800_mb': 1.3409621857363163e-08,
                'O3MR.850_mb': 1.2723650577584067e-08,
                'O3MR.900_mb': 1.2425372730717754e-08,
                'O3MR.925_mb': 1.2417752159876727e-08,
                'O3MR.950_mb': 1.2473555521808066e-08,
                'O3MR.975_mb': 1.2579377539623238e-08,
                'PLPL.255-0_mb_above_ground': 18729.080078125,
                'POT.0.995_sigma_level': 17.383525848388672,
                'PRATE.surface': 0.00013768671487923712,
                'PRES.80_m_above_ground': 9709.859375,
                'PRES.PV2e06Km2kgs_surface': 9907.4970703125,
                'PRES.PVNeg2e06Km2kgs_surface': 10092.73828125,
                'PRES.max_wind': 9176.2666015625,
                'PRES.surface': 9766.2177734375,
                'PRES.tropopause': 7965.79052734375,
                'PRMSL.mean_sea_level': 1438.5679931640625,
                'PWAT.entire_atmosphere_considered_as_a_single_layer': 16.60167694091797,
                'REFC.entire_atmosphere': 14.329595565795898,
                'REFD.1000_m_above_ground': 12.58059310913086,
                'REFD.1_hybrid_level': 12.726173400878906,
                'REFD.2_hybrid_level': 12.717830657958984,
                'REFD.4000_m_above_ground': 8.325715065002441,
                'RH.0.01_mb': 0.047317471355199814,
                'RH.0.02_mb': 0.05087132006883621,
                'RH.0.04_mb': 0.02176937460899353,
                'RH.0.07_mb': 0.0008744093938730657,
                'RH.0.1_mb': 0.00011913249909412116,
                'RH.0.2_mb': 0.0,
                'RH.0.33-1_sigma_layer': 23.06828498840332,
                'RH.0.44-0.72_sigma_layer': 29.86492156982422,
                'RH.0.44-1_sigma_layer': 21.700136184692383,
                'RH.0.4_mb': 0.0,
                'RH.0.72-0.94_sigma_layer': 22.806604385375977,
                'RH.0.7_mb': 0.0,
                'RH.0.995_sigma_level': 19.772912979125977,
                'RH.0C_isotherm': 32.50086975097656,
                'RH.1000_mb': 19.496505737304688,
                'RH.100_mb': 25.332656860351562,
                'RH.10_mb': 2.9410488605499268,
                'RH.150_mb': 28.909893035888672,
                'RH.15_mb': 4.780122756958008,
                'RH.1_mb': 2.6612242436385714e-05,
                'RH.200_mb': 32.33512878417969,
                'RH.20_mb': 6.359000205993652,
                'RH.250_mb': 33.22666549682617,
                'RH.2_m_above_ground': 19.042369842529297,
                'RH.2_mb': 0.010507507249712944,
                'RH.30-0_mb_above_ground': 20.009822845458984,
                'RH.300_mb': 32.9070930480957,
                'RH.30_mb': 8.747615814208984,
                'RH.350_mb': 33.683040618896484,
                'RH.3_mb': 0.04579653590917587,
                'RH.400_mb': 34.25663375854492,
                'RH.40_mb': 10.779611587524414,
                'RH.450_mb': 34.39698791503906,
                'RH.500_mb': 34.33683395385742,
                'RH.50_mb': 12.83346176147461,
                'RH.550_mb': 34.07932662963867,
                'RH.5_mb': 0.3541453182697296,
                'RH.600_mb': 33.51411056518555,
                'RH.650_mb': 32.776187896728516,
                'RH.700_mb': 31.952045440673828,
                'RH.70_mb': 14.49750804901123,
                'RH.750_mb': 30.899288177490234,
                'RH.7_mb': 1.3726543188095093,
                'RH.800_mb': 29.174428939819336,
                'RH.850_mb': 26.566360473632812,
                'RH.900_mb': 23.852252960205078,
                'RH.925_mb': 22.840152740478516,
                'RH.950_mb': 21.524181365966797,
                'RH.975_mb': 20.17323112487793,
                'RH.entire_atmosphere_considered_as_a_single_layer': 16.486698150634766,
                'RH.highest_tropospheric_freezing_level': 32.902069091796875,
                'RWMR.1000_mb': 1.5998271919670515e-05,
                'RWMR.100_mb': 2.0337453943142236e-09,
                'RWMR.150_mb': 2.380112551492175e-09,
                'RWMR.1_hybrid_level': 2.1867263058084063e-05,
                'RWMR.200_mb': 2.1609769529362666e-09,
                'RWMR.250_mb': 1.6132866154094927e-09,
                'RWMR.300_mb': 9.955447577425502e-10,
                'RWMR.350_mb': 2.86426882212254e-09,
                'RWMR.400_mb': 9.76838610000641e-09,
                'RWMR.450_mb': 7.089293063700097e-08,
                'RWMR.500_mb': 2.8465431114454987e-06,
                'RWMR.50_mb': 6.096997906546164e-10,
                'RWMR.550_mb': 1.0820241186593194e-05,
                'RWMR.600_mb': 2.344783024454955e-05,
                'RWMR.650_mb': 2.1891788492212072e-05,
                'RWMR.700_mb': 2.3067233996698633e-05,
                'RWMR.750_mb': 2.3539705580333248e-05,
                'RWMR.800_mb': 2.3414242605213076e-05,
                'RWMR.850_mb': 2.3094264179235324e-05,
                'RWMR.900_mb': 2.2343036107486114e-05,
                'RWMR.925_mb': 2.179999864893034e-05,
                'RWMR.950_mb': 2.114276503561996e-05,
                'RWMR.975_mb': 1.9754575987462886e-05,
                'SFCR.surface': 0.4234353005886078,
                'SNMR.1000_mb': 4.420213826961117e-06,
                'SNMR.100_mb': 5.586536531154707e-07,
                'SNMR.150_mb': 3.5867435599357123e-06,
                'SNMR.1_hybrid_level': 1.3038710676482879e-05,
                'SNMR.200_mb': 7.159012511692708e-06,
                'SNMR.250_mb': 1.1419209840823896e-05,
                'SNMR.300_mb': 1.697473089734558e-05,
                'SNMR.350_mb': 2.3052441974868998e-05,
                'SNMR.400_mb': 2.8704893338726833e-05,
                'SNMR.450_mb': 3.322271004435606e-05,
                'SNMR.500_mb': 3.5968158044852316e-05,
                'SNMR.50_mb': 1.851809261488313e-09,
                'SNMR.550_mb': 3.508818190312013e-05,
                'SNMR.600_mb': 2.9035161787760444e-05,
                'SNMR.650_mb': 2.7731899535865523e-05,
                'SNMR.700_mb': 2.5818371796049178e-05,
                'SNMR.750_mb': 2.3581153072882444e-05,
                'SNMR.800_mb': 2.1344530978240073e-05,
                'SNMR.850_mb': 1.9068011170020327e-05,
                'SNMR.900_mb': 1.692545811238233e-05,
                'SNMR.925_mb': 1.5860046914895065e-05,
                'SNMR.950_mb': 1.4269443454395514e-05,
                'SNMR.975_mb': 9.739684173837304e-06,
                'SNOD.surface': 0.4776531159877777,
                'SOILL.0-0.1_m_below_ground': 0.3943862020969391,
                'SOILL.0.1-0.4_m_below_ground': 0.3818660378456116,
                'SOILL.0.4-1_m_below_ground': 0.3857265114784241,
                'SOILL.1-2_m_below_ground': 0.37126392126083374,
                'SOILW.0-0.1_m_below_ground': 0.3838261663913727,
                'SOILW.0.1-0.4_m_below_ground': 0.3711322247982025,
                'SOILW.0.4-1_m_below_ground': 0.3732883334159851,
                'SOILW.1-2_m_below_ground': 0.35062655806541443,
                'SOTYP.surface': 5.341075897216797,
                'SPFH.0.01_mb': 3.87983163818717e-07,
                'SPFH.0.02_mb': 3.843665012936981e-07,
                'SPFH.0.04_mb': 3.8138705349410884e-07,
                'SPFH.0.07_mb': 3.8040329286559427e-07,
                'SPFH.0.1_mb': 3.629099865065655e-07,
                'SPFH.0.2_mb': 3.2445299780192727e-07,
                'SPFH.0.4_mb': 3.011455191881396e-07,
                'SPFH.0.7_mb': 3.069855267767707e-07,
                'SPFH.1000_mb': 0.005715635605156422,
                'SPFH.100_mb': 5.560826252803963e-07,
                'SPFH.10_mb': 5.193907668399333e-07,
                'SPFH.150_mb': 3.70415568795579e-06,
                'SPFH.15_mb': 6.014337827764393e-07,
                'SPFH.1_mb': 3.204898462172423e-07,
                'SPFH.200_mb': 2.252449849038385e-05,
                'SPFH.20_mb': 6.484613095381064e-07,
                'SPFH.250_mb': 7.891240966273472e-05,
                'SPFH.2_m_above_ground': 0.005969010293483734,
                'SPFH.2_mb': 3.651169890872552e-07,
                'SPFH.30-0_mb_above_ground': 0.00556357204914093,
                'SPFH.300_mb': 0.00019166838319506496,
                'SPFH.30_mb': 6.81187941609096e-07,
                'SPFH.350_mb': 0.0003684538824018091,
                'SPFH.3_mb': 3.9112748595471203e-07,
                'SPFH.400_mb': 0.0006084701744839549,
                'SPFH.40_mb': 6.560852057191369e-07,
                'SPFH.450_mb': 0.000900850398465991,
                'SPFH.500_mb': 0.0012302449904382229,
                'SPFH.50_mb': 6.031473844814172e-07,
                'SPFH.550_mb': 0.0015923124738037586,
                'SPFH.5_mb': 4.331702712079277e-07,
                'SPFH.600_mb': 0.001960118068382144,
                'SPFH.650_mb': 0.002318319398909807,
                'SPFH.700_mb': 0.0026922253891825676,
                'SPFH.70_mb': 5.235161779637565e-07,
                'SPFH.750_mb': 0.0030904016457498074,
                'SPFH.7_mb': 4.650383687021531e-07,
                'SPFH.800_mb': 0.003511082148179412,
                'SPFH.80_m_above_ground': 0.005580939818173647,
                'SPFH.850_mb': 0.004020177759230137,
                'SPFH.900_mb': 0.0046648792922496796,
                'SPFH.925_mb': 0.00508032226935029,
                'SPFH.950_mb': 0.00539824366569519,
                'SPFH.975_mb': 0.0055817412212491035,
                'SUNSD.surface': 7625.7060546875,
                'TCDC.1000_mb': 14.105179786682129,
                'TCDC.100_mb': 7.411805629730225,
                'TCDC.150_mb': 15.330533981323242,
                'TCDC.200_mb': 22.983287811279297,
                'TCDC.250_mb': 28.824092864990234,
                'TCDC.300_mb': 31.95635986328125,
                'TCDC.350_mb': 32.81898880004883,
                'TCDC.400_mb': 33.04826354980469,
                'TCDC.450_mb': 32.884681701660156,
                'TCDC.500_mb': 32.636966705322266,
                'TCDC.50_mb': 2.7554855346679688,
                'TCDC.550_mb': 32.52949523925781,
                'TCDC.600_mb': 32.00978469848633,
                'TCDC.650_mb': 30.715621948242188,
                'TCDC.700_mb': 29.175474166870117,
                'TCDC.750_mb': 29.050762176513672,
                'TCDC.800_mb': 29.543521881103516,
                'TCDC.850_mb': 31.123783111572266,
                'TCDC.900_mb': 30.582948684692383,
                'TCDC.925_mb': 29.29720115661621,
                'TCDC.950_mb': 27.445362091064453,
                'TCDC.975_mb': 23.200490951538086,
                'TCDC.entire_atmosphere': 41.080909729003906,
                'TMP.0.01_mb': 6.121960163116455,
                'TMP.0.02_mb': 8.458681106567383,
                'TMP.0.04_mb': 11.884819030761719,
                'TMP.0.07_mb': 13.02905559539795,
                'TMP.0.1_mb': 12.737600326538086,
                'TMP.0.2_mb': 11.058592796325684,
                'TMP.0.4_mb': 8.471590995788574,
                'TMP.0.7_mb': 8.105033874511719,
                'TMP.0.995_sigma_level': 21.245702743530273,
                'TMP.1000_mb': 18.517038345336914,
                'TMP.100_m_above_ground': 20.555999755859375,
                'TMP.100_mb': 11.65457820892334,
                'TMP.10_mb': 12.64991283416748,
                'TMP.150_mb': 8.884990692138672,
                'TMP.15_mb': 12.036783218383789,
                'TMP.1829_m_above_mean_sea_level': 13.532020568847656,
                'TMP.1_mb': 9.957804679870605,
                'TMP.200_mb': 7.584775447845459,
                'TMP.20_mb': 11.433536529541016,
                'TMP.250_mb': 8.966486930847168,
                'TMP.2743_m_above_mean_sea_level': 14.225176811218262,
                'TMP.2_m_above_ground': 21.86735725402832,
                'TMP.2_mb': 13.662699699401855,
                'TMP.30-0_mb_above_ground': 20.2614803314209,
                'TMP.300_mb': 11.017512321472168,
                'TMP.30_mb': 10.499985694885254,
                'TMP.350_mb': 12.231257438659668,
                'TMP.3658_m_above_mean_sea_level': 14.83853530883789,
                'TMP.3_mb': 13.651447296142578,
                'TMP.400_mb': 12.78172492980957,
                'TMP.40_mb': 9.956388473510742,
                'TMP.450_mb': 12.97878646850586,
                'TMP.500_mb': 13.030519485473633,
                'TMP.50_mb': 9.699442863464355,
                'TMP.550_mb': 13.092047691345215,
                'TMP.5_mb': 13.189885139465332,
                'TMP.600_mb': 13.576823234558105,
                'TMP.650_mb': 14.693063735961914,
                'TMP.700_mb': 15.670036315917969,
                'TMP.70_mb': 10.45693302154541,
                'TMP.750_mb': 16.178386688232422,
                'TMP.7_mb': 12.943881034851074,
                'TMP.800_mb': 16.560314178466797,
                'TMP.80_m_above_ground': 20.762496948242188,
                'TMP.850_mb': 16.81626319885254,
                'TMP.900_mb': 17.06770133972168,
                'TMP.925_mb': 17.270263671875,
                'TMP.950_mb': 17.605741500854492,
                'TMP.975_mb': 18.070194244384766,
                'TMP.PV2e06Km2kgs_surface': 12.322633743286133,
                'TMP.PVNeg2e06Km2kgs_surface': 11.251023292541504,
                'TMP.max_wind': 12.972728729248047,
                'TMP.surface': 23.230709075927734,
                'TMP.tropopause': 11.067811965942383,
                'TOZNE.entire_atmosphere_considered_as_a_single_layer': 50.27402114868164,
                'TSOIL.0-0.1_m_below_ground': 23.469934463500977,
                'TSOIL.0.1-0.4_m_below_ground': 22.387672424316406,
                'TSOIL.0.4-1_m_below_ground': 21.815454483032227,
                'TSOIL.1-2_m_below_ground': 21.548477172851562,
                'UGRD.0.01_mb': 31.852096557617188,
                'UGRD.0.02_mb': 32.26128387451172,
                'UGRD.0.04_mb': 31.925880432128906,
                'UGRD.0.07_mb': 33.94340896606445,
                'UGRD.0.1_mb': 34.7666015625,
                'UGRD.0.2_mb': 36.41104507446289,
                'UGRD.0.4_mb': 38.026668548583984,
                'UGRD.0.7_mb': 37.01361083984375,
                'UGRD.0.995_sigma_level': 6.628929615020752,
                'UGRD.1000_mb': 6.254582405090332,
                'UGRD.100_m_above_ground': 7.125791072845459,
                'UGRD.100_mb': 13.995875358581543,
                'UGRD.10_m_above_ground': 5.643049716949463,
                'UGRD.10_mb': 27.246957778930664,
                'UGRD.150_mb': 16.008480072021484,
                'UGRD.15_mb': 26.119110107421875,
                'UGRD.1829_m_above_mean_sea_level': 8.629815101623535,
                'UGRD.1_mb': 35.617061614990234,
                'UGRD.200_mb': 17.531810760498047,
                'UGRD.20_m_above_ground': 5.93121862411499,
                'UGRD.20_mb': 24.70725440979004,
                'UGRD.250_mb': 17.699602127075195,
                'UGRD.2743_m_above_mean_sea_level': 9.080644607543945,
                'UGRD.2_mb': 31.90812873840332,
                'UGRD.30-0_mb_above_ground': 7.080918788909912,
                'UGRD.300_mb': 16.70412826538086,
                'UGRD.30_m_above_ground': 6.264061450958252,
                'UGRD.30_mb': 21.263816833496094,
                'UGRD.350_mb': 15.240815162658691,
                'UGRD.3658_m_above_mean_sea_level': 9.744725227355957,
                'UGRD.3_mb': 29.63623809814453,
                'UGRD.400_mb': 13.816243171691895,
                'UGRD.40_m_above_ground': 6.454153537750244,
                'UGRD.40_mb': 18.22516441345215,
                'UGRD.450_mb': 12.605430603027344,
                'UGRD.500_mb': 11.554732322692871,
                'UGRD.50_m_above_ground': 6.6175456047058105,
                'UGRD.50_mb': 16.031728744506836,
                'UGRD.550_mb': 10.734885215759277,
                'UGRD.5_mb': 28.62490463256836,
                'UGRD.600_mb': 10.090584754943848,
                'UGRD.650_mb': 9.539139747619629,
                'UGRD.700_mb': 9.033895492553711,
                'UGRD.70_mb': 14.086054801940918,
                'UGRD.750_mb': 8.623554229736328,
                'UGRD.7_mb': 28.145580291748047,
                'UGRD.800_mb': 8.346558570861816,
                'UGRD.80_m_above_ground': 6.960296154022217,
                'UGRD.850_mb': 8.233945846557617,
                'UGRD.900_mb': 8.151549339294434,
                'UGRD.925_mb': 7.992728233337402,
                'UGRD.950_mb': 7.660031318664551,
                'UGRD.975_mb': 7.060336112976074,
                'UGRD.PV2e06Km2kgs_surface': 16.86548614501953,
                'UGRD.PVNeg2e06Km2kgs_surface': 18.183021545410156,
                'UGRD.max_wind': 21.91623878479004,
                'UGRD.planetary_boundary_layer': 7.562756061553955,
                'UGRD.tropopause': 17.913503646850586,
                'USTM.6000-0_m_above_ground': 9.64213752746582,
                'VEG.surface': 27.559675216674805,
                'VGRD.0.01_mb': 22.435888290405273,
                'VGRD.0.02_mb': 21.295469284057617,
                'VGRD.0.04_mb': 16.098106384277344,
                'VGRD.0.07_mb': 16.475631713867188,
                'VGRD.0.1_mb': 15.694666862487793,
                'VGRD.0.2_mb': 13.896254539489746,
                'VGRD.0.4_mb': 12.759893417358398,
                'VGRD.0.7_mb': 11.801229476928711,
                'VGRD.0.995_sigma_level': 5.650755882263184,
                'VGRD.1000_mb': 5.3141326904296875,
                'VGRD.100_m_above_ground': 6.160138130187988,
                'VGRD.100_mb': 7.117500305175781,
                'VGRD.10_m_above_ground': 4.7686052322387695,
                'VGRD.10_mb': 7.729941368103027,
                'VGRD.150_mb': 9.534989356994629,
                'VGRD.15_mb': 7.067671775817871,
                'VGRD.1829_m_above_mean_sea_level': 6.4013848304748535,
                'VGRD.1_mb': 11.230049133300781,
                'VGRD.200_mb': 11.995176315307617,
                'VGRD.20_m_above_ground': 5.01689338684082,
                'VGRD.20_mb': 6.598365306854248,
                'VGRD.250_mb': 13.494633674621582,
                'VGRD.2743_m_above_mean_sea_level': 6.846492290496826,
                'VGRD.2_mb': 10.102170944213867,
                'VGRD.30-0_mb_above_ground': 6.1055378913879395,
                'VGRD.300_mb': 13.363096237182617,
                'VGRD.30_m_above_ground': 5.323554039001465,
                'VGRD.30_mb': 6.0225510597229,
                'VGRD.350_mb': 12.359692573547363,
                'VGRD.3658_m_above_mean_sea_level': 7.474217891693115,
                'VGRD.3_mb': 9.271191596984863,
                'VGRD.400_mb': 11.179974555969238,
                'VGRD.40_m_above_ground': 5.504513740539551,
                'VGRD.40_mb': 5.834985733032227,
                'VGRD.450_mb': 10.099275588989258,
                'VGRD.500_mb': 9.141146659851074,
                'VGRD.50_m_above_ground': 5.662200450897217,
                'VGRD.50_mb': 5.729454040527344,
                'VGRD.550_mb': 8.381239891052246,
                'VGRD.5_mb': 8.696433067321777,
                'VGRD.600_mb': 7.778042793273926,
                'VGRD.650_mb': 7.2828168869018555,
                'VGRD.700_mb': 6.804196834564209,
                'VGRD.70_mb': 5.971688747406006,
                'VGRD.750_mb': 6.4489617347717285,
                'VGRD.7_mb': 8.2565279006958,
                'VGRD.800_mb': 6.230226516723633,
                'VGRD.80_m_above_ground': 5.998281955718994,
                'VGRD.850_mb': 6.179982662200928,
                'VGRD.900_mb': 6.316215991973877,
                'VGRD.925_mb': 6.380063533782959,
                'VGRD.950_mb': 6.315990447998047,
                'VGRD.975_mb': 5.967782497406006,
                'VGRD.PV2e06Km2kgs_surface': 12.62997817993164,
                'VGRD.PVNeg2e06Km2kgs_surface': 12.565796852111816,
                'VGRD.max_wind': 16.02404022216797,
                'VGRD.planetary_boundary_layer': 6.237730503082275,
                'VGRD.tropopause': 13.1109619140625,
                'VIS.surface': 7959.7431640625,
                'VRATE.planetary_boundary_layer': 8053.73193359375,
                'VSTM.6000-0_m_above_ground': 7.899003028869629,
                'VVEL.0.01_mb': 2.2483833163278177e-05,
                'VVEL.0.02_mb': 0.00011201341840205714,
                'VVEL.0.04_mb': 0.0002559483691584319,
                'VVEL.0.07_mb': 0.00035672655212692916,
                'VVEL.0.1_mb': 0.0004377398290671408,
                'VVEL.0.2_mb': 0.00072413997258991,
                'VVEL.0.4_mb': 0.0011203710455447435,
                'VVEL.0.7_mb': 0.001525576924905181,
                'VVEL.0.995_sigma_level': 0.2312760204076767,
                'VVEL.1000_mb': 0.19908760488033295,
                'VVEL.100_mb': 0.04581908881664276,
                'VVEL.10_mb': 0.008779609575867653,
                'VVEL.150_mb': 0.0894058346748352,
                'VVEL.15_mb': 0.011477732099592686,
                'VVEL.1_mb': 0.0018720029620453715,
                'VVEL.200_mb': 0.13660098612308502,
                'VVEL.20_mb': 0.01366003230214119,
                'VVEL.250_mb': 0.18229617178440094,
                'VVEL.2_mb': 0.003039367962628603,
                'VVEL.300_mb': 0.22251199185848236,
                'VVEL.30_mb': 0.017045246437191963,
                'VVEL.350_mb': 0.25044822692871094,
                'VVEL.3_mb': 0.003963772673159838,
                'VVEL.400_mb': 0.27217337489128113,
                'VVEL.40_mb': 0.02097274735569954,
                'VVEL.450_mb': 0.2884689271450043,
                'VVEL.500_mb': 0.30128633975982666,
                'VVEL.50_mb': 0.023441340774297714,
                'VVEL.550_mb': 0.3153200149536133,
                'VVEL.5_mb': 0.005708987824618816,
                'VVEL.600_mb': 0.33282217383384705,
                'VVEL.650_mb': 0.3502602279186249,
                'VVEL.700_mb': 0.36641985177993774,
                'VVEL.70_mb': 0.029935728758573532,
                'VVEL.750_mb': 0.3786264657974243,
                'VVEL.7_mb': 0.006899831350892782,
                'VVEL.800_mb': 0.38146835565567017,
                'VVEL.850_mb': 0.3691926896572113,
                'VVEL.900_mb': 0.331728458404541,
                'VVEL.925_mb': 0.2998879551887512,
                'VVEL.950_mb': 0.2607569992542267,
                'VVEL.975_mb': 0.22285230457782745,
                'VWSH.PV2e06Km2kgs_surface': 0.007947995327413082,
                'VWSH.PVNeg2e06Km2kgs_surface': 0.007856409065425396,
                'VWSH.tropopause': 0.007448150776326656,
                'WEASD.surface': 56.9973258972168,
                'WILT.surface': 0.029414065182209015}
FORECAST_MAX = {'4LFTX.surface': 36.88194274902344,
                'ABSV.0.01_mb': 0.001759265665896237,
                'ABSV.0.02_mb': 0.002476446097716689,
                'ABSV.0.04_mb': 0.0027371225878596306,
                'ABSV.0.07_mb': 0.003875494236126542,
                'ABSV.0.1_mb': 0.004353685770183802,
                'ABSV.0.2_mb': 0.004096536431461573,
                'ABSV.0.4_mb': 0.0043334877118468285,
                'ABSV.0.7_mb': 0.004351399838924408,
                'ABSV.1000_mb': 0.0030886295717209578,
                'ABSV.100_mb': 0.0026267170906066895,
                'ABSV.10_mb': 0.001707154093310237,
                'ABSV.150_mb': 0.002932971576228738,
                'ABSV.15_mb': 0.00210009072907269,
                'ABSV.1_mb': 0.004104017745703459,
                'ABSV.200_mb': 0.004007386509329081,
                'ABSV.20_mb': 0.0020087312441319227,
                'ABSV.250_mb': 0.0027201268821954727,
                'ABSV.2_mb': 0.0026563608553260565,
                'ABSV.300_mb': 0.002604580717161298,
                'ABSV.30_mb': 0.0012023757444694638,
                'ABSV.350_mb': 0.0025808396749198437,
                'ABSV.3_mb': 0.0023041153326630592,
                'ABSV.400_mb': 0.002863628324121237,
                'ABSV.40_mb': 0.0013694989029318094,
                'ABSV.450_mb': 0.00320107932202518,
                'ABSV.500_mb': 0.0033719378989189863,
                'ABSV.50_mb': 0.001296374248340726,
                'ABSV.550_mb': 0.0033782143145799637,
                'ABSV.5_mb': 0.0017438153736293316,
                'ABSV.600_mb': 0.003351242747157812,
                'ABSV.650_mb': 0.0033648114185780287,
                'ABSV.700_mb': 0.0033591485116630793,
                'ABSV.70_mb': 0.0018139868043363094,
                'ABSV.750_mb': 0.0037426911294460297,
                'ABSV.7_mb': 0.001756498939357698,
                'ABSV.800_mb': 0.0037298088427633047,
                'ABSV.850_mb': 0.0041748639196157455,
                'ABSV.900_mb': 0.004318606108427048,
                'ABSV.925_mb': 0.003977993503212929,
                'ABSV.950_mb': 0.0037718310486525297,
                'ABSV.975_mb': 0.003614903660491109,
                'APTMP.2_m_above_ground': 325.83868408203125,
                'CAPE.180-0_mb_above_ground': 5298.0,
                'CAPE.255-0_mb_above_ground': 5515.0,
                'CAPE.90-0_mb_above_ground': 4866.0,
                'CAPE.surface': 5515.0,
                'CFRZR.surface': 1.0,
                'CICEP.surface': 1.0,
                'CIN.180-0_mb_above_ground': 0.4881591796875,
                'CIN.255-0_mb_above_ground': 0.4962158203125,
                'CIN.90-0_mb_above_ground': 0.49261474609375,
                'CIN.surface': 0.49951171875,
                'CLMR.1000_mb': 0.0011722400086000562,
                'CLMR.100_mb': 4.488599933590194e-23,
                'CLMR.150_mb': 1.995040011014762e-13,
                'CLMR.1_hybrid_level': 0.002046040026471019,
                'CLMR.200_mb': 0.00014286799705587327,
                'CLMR.250_mb': 0.0008113600197248161,
                'CLMR.300_mb': 0.0009925400372594595,
                'CLMR.350_mb': 0.0013337599812075496,
                'CLMR.400_mb': 0.001490960014052689,
                'CLMR.450_mb': 0.0016126000555232167,
                'CLMR.500_mb': 0.0016239599790424109,
                'CLMR.50_mb': 0.0,
                'CLMR.550_mb': 0.0015604400541633368,
                'CLMR.600_mb': 0.0014254800044000149,
                'CLMR.650_mb': 0.0013503199443221092,
                'CLMR.700_mb': 0.0012716799974441528,
                'CLMR.750_mb': 0.0012583599891513586,
                'CLMR.800_mb': 0.0012507200008258224,
                'CLMR.850_mb': 0.0015577200101688504,
                'CLMR.900_mb': 0.0012088000075891614,
                'CLMR.925_mb': 0.0012092400575056672,
                'CLMR.950_mb': 0.001164000015705824,
                'CLMR.975_mb': 0.0012791199842467904,
                'CNWAT.surface': 0.5,
                'CPOFP.surface': 99.99999237060547,
                'CRAIN.surface': 1.0,
                'CSNOW.surface': 1.0,
                'CWAT.entire_atmosphere_considered_as_a_single_layer': 7.389599800109863,
                'DPT.2_m_above_ground': 303.29998779296875,
                'DZDT.0.01_mb': 13.193480491638184,
                'DZDT.0.02_mb': 8.585831642150879,
                'DZDT.0.04_mb': 13.73444938659668,
                'DZDT.0.07_mb': 14.378007888793945,
                'DZDT.0.1_mb': 12.913107872009277,
                'DZDT.0.2_mb': 15.839191436767578,
                'DZDT.0.4_mb': 15.105798721313477,
                'DZDT.0.7_mb': 13.890300750732422,
                'DZDT.1000_mb': 0.9421142339706421,
                'DZDT.100_mb': 2.8028016090393066,
                'DZDT.10_mb': 2.785512924194336,
                'DZDT.150_mb': 6.817618370056152,
                'DZDT.15_mb': 2.3394711017608643,
                'DZDT.1_mb': 9.785075187683105,
                'DZDT.200_mb': 7.7948408126831055,
                'DZDT.20_mb': 2.572664737701416,
                'DZDT.250_mb': 7.6213202476501465,
                'DZDT.2_mb': 6.238028526306152,
                'DZDT.300_mb': 7.247934341430664,
                'DZDT.30_mb': 2.0468926429748535,
                'DZDT.350_mb': 6.7328667640686035,
                'DZDT.3_mb': 4.950672626495361,
                'DZDT.400_mb': 6.224076271057129,
                'DZDT.40_mb': 2.177241325378418,
                'DZDT.450_mb': 5.605541229248047,
                'DZDT.500_mb': 5.24175500869751,
                'DZDT.50_mb': 1.8477450609207153,
                'DZDT.550_mb': 5.1219401359558105,
                'DZDT.5_mb': 4.1867899894714355,
                'DZDT.600_mb': 4.926044940948486,
                'DZDT.650_mb': 4.660046100616455,
                'DZDT.700_mb': 4.313749313354492,
                'DZDT.70_mb': 1.6325820684432983,
                'DZDT.750_mb': 3.860106945037842,
                'DZDT.7_mb': 3.1544787883758545,
                'DZDT.800_mb': 3.2660295963287354,
                'DZDT.850_mb': 2.53979754447937,
                'DZDT.900_mb': 1.7189432382583618,
                'DZDT.925_mb': 1.2933349609375,
                'DZDT.950_mb': 0.9421142339706421,
                'DZDT.975_mb': 0.9421142339706421,
                'FLDCP.surface': 0.4193999767303467,
                'FRICV.surface': 3.2780001163482666,
                'GRLE.1000_mb': 0.0008012800244614482,
                'GRLE.100_mb': 0.0036440829280763865,
                'GRLE.150_mb': 0.00726800411939621,
                'GRLE.1_hybrid_level': 0.0017833600286394358,
                'GRLE.200_mb': 0.008920322172343731,
                'GRLE.250_mb': 0.010927201248705387,
                'GRLE.300_mb': 0.011309401132166386,
                'GRLE.350_mb': 0.010257400572299957,
                'GRLE.400_mb': 0.009413120336830616,
                'GRLE.450_mb': 0.009257280267775059,
                'GRLE.500_mb': 0.008563360199332237,
                'GRLE.50_mb': 8.08366795723714e-09,
                'GRLE.550_mb': 0.007382879965007305,
                'GRLE.600_mb': 0.006402720231562853,
                'GRLE.650_mb': 0.005563680082559586,
                'GRLE.700_mb': 0.004575040191411972,
                'GRLE.750_mb': 0.004366640001535416,
                'GRLE.800_mb': 0.002693840069696307,
                'GRLE.850_mb': 0.002262759953737259,
                'GRLE.900_mb': 0.0018821200355887413,
                'GRLE.925_mb': 0.0018757999641820788,
                'GRLE.950_mb': 0.001469279988668859,
                'GRLE.975_mb': 0.0011452400358393788,
                'GUST.surface': 65.01434326171875,
                'HCDC.high_cloud_layer': 100.0,
                'HGT.0.01_mb': 80653.4375,
                'HGT.0.02_mb': 76962.9765625,
                'HGT.0.04_mb': 72950.2265625,
                'HGT.0.07_mb': 69659.703125,
                'HGT.0.1_mb': 67413.4765625,
                'HGT.0.2_mb': 62688.19140625,
                'HGT.0.4_mb': 57513.10546875,
                'HGT.0.7_mb': 53036.953125,
                'HGT.0C_isotherm': 7539.35986328125,
                'HGT.1000_mb': 701.3851318359375,
                'HGT.100_mb': 17018.962890625,
                'HGT.10_mb': 32175.572265625,
                'HGT.150_mb': 14592.6279296875,
                'HGT.15_mb': 29324.005859375,
                'HGT.1_mb': 50118.76171875,
                'HGT.200_mb': 12725.365234375,
                'HGT.20_mb': 27344.0546875,
                'HGT.250_mb': 11184.2490234375,
                'HGT.2_mb': 44396.23828125,
                'HGT.300_mb': 9864.8623046875,
                'HGT.30_mb': 24619.064453125,
                'HGT.350_mb': 8710.193359375,
                'HGT.3_mb': 41147.5390625,
                'HGT.400_mb': 7695.71044921875,
                'HGT.40_mb': 22705.716796875,
                'HGT.450_mb': 6805.349609375,
                'HGT.500_mb': 5993.26611328125,
                'HGT.50_mb': 21238.240234375,
                'HGT.550_mb': 5246.05615234375,
                'HGT.5_mb': 37234.4453125,
                'HGT.600_mb': 4545.7197265625,
                'HGT.650_mb': 3891.6796875,
                'HGT.700_mb': 3315.373779296875,
                'HGT.70_mb': 19127.27734375,
                'HGT.750_mb': 2800.650390625,
                'HGT.7_mb': 34742.94140625,
                'HGT.800_mb': 2337.437255859375,
                'HGT.850_mb': 1900.1243896484375,
                'HGT.900_mb': 1482.973388671875,
                'HGT.925_mb': 1281.30859375,
                'HGT.950_mb': 1083.95751953125,
                'HGT.975_mb': 890.7070922851562,
                'HGT.PV2e06Km2kgs_surface': 20212.63671875,
                'HGT.PVNeg2e06Km2kgs_surface': 20349.412109375,
                'HGT.cloud_ceiling': 20000.279296875,
                'HGT.highest_tropospheric_freezing_level': 7540.7998046875,
                'HGT.max_wind': 16774.896484375,
                'HGT.surface': 5917.8193359375,
                'HGT.tropopause': 19279.154296875,
                'HINDEX.surface': 6.0,
                'HLCY.3000-0_m_above_ground': 2317.7216796875,
                'HPBL.surface': 6757.5615234375,
                'ICAHT.max_wind': 15928.400390625,
                'ICAHT.tropopause': 20282.8046875,
                'ICEC.surface': 1.0,
                'ICEG.10_m_above_mean_sea_level': 0.0004123999970033765,
                'ICETK.surface': 5.03000020980835,
                'ICETMP.surface': 273.1542663574219,
                'ICMR.1000_mb': 0.00014014399494044483,
                'ICMR.100_mb': 0.001264740014448762,
                'ICMR.150_mb': 0.0017279599560424685,
                'ICMR.1_hybrid_level': 0.00043276799260638654,
                'ICMR.200_mb': 0.0018901999574154615,
                'ICMR.250_mb': 0.0014953999780118465,
                'ICMR.300_mb': 0.0014166400069370866,
                'ICMR.350_mb': 0.0012175400042906404,
                'ICMR.400_mb': 0.00113215995952487,
                'ICMR.450_mb': 0.0009978200541809201,
                'ICMR.500_mb': 0.0009235839825123549,
                'ICMR.50_mb': 1.0254400422127219e-06,
                'ICMR.550_mb': 0.0008406559936702251,
                'ICMR.600_mb': 0.0007483679801225662,
                'ICMR.650_mb': 0.0007039200281724334,
                'ICMR.700_mb': 0.0006608479889109731,
                'ICMR.750_mb': 0.0005896639777347445,
                'ICMR.800_mb': 0.0004871599958278239,
                'ICMR.850_mb': 0.00040123998769558966,
                'ICMR.900_mb': 0.0003274240007158369,
                'ICMR.925_mb': 0.0002795599866658449,
                'ICMR.950_mb': 0.00022876799630466849,
                'ICMR.975_mb': 0.00018706799892242998,
                'LAND.surface': 1.0,
                'LCDC.low_cloud_layer': 100.0,
                'LFTX.surface': 58.49500274658203,
                'MCDC.middle_cloud_layer': 100.0,
                'MSLET.mean_sea_level': 109399.734375,
                'O3MR.0.01_mb': 7.54031759697682e-07,
                'O3MR.0.02_mb': 1.00960050986032e-06,
                'O3MR.0.04_mb': 1.3319332765604486e-06,
                'O3MR.0.07_mb': 1.8728054556049756e-06,
                'O3MR.0.1_mb': 2.113488562827115e-06,
                'O3MR.0.2_mb': 3.0902349408279406e-06,
                'O3MR.0.4_mb': 4.916006673738593e-06,
                'O3MR.0.7_mb': 1.1487237316032406e-05,
                'O3MR.1000_mb': 1.7364743598591303e-07,
                'O3MR.100_mb': 4.7451144382648636e-06,
                'O3MR.10_mb': 1.939532558026258e-05,
                'O3MR.150_mb': 2.938868647106574e-06,
                'O3MR.15_mb': 1.5913050447124988e-05,
                'O3MR.1_mb': 1.1620056284300517e-05,
                'O3MR.200_mb': 1.8990822354680859e-06,
                'O3MR.20_mb': 1.4072042176849209e-05,
                'O3MR.250_mb': 1.2460089919841266e-06,
                'O3MR.2_mb': 1.3989616491016932e-05,
                'O3MR.300_mb': 9.602944146536174e-07,
                'O3MR.30_mb': 1.0258036127197556e-05,
                'O3MR.350_mb': 7.312274306059408e-07,
                'O3MR.3_mb': 1.6138606952154078e-05,
                'O3MR.400_mb': 5.917148087064561e-07,
                'O3MR.40_mb': 8.836354936647695e-06,
                'O3MR.450_mb': 4.708808774012141e-07,
                'O3MR.500_mb': 4.1108822301794135e-07,
                'O3MR.50_mb': 7.712807928328402e-06,
                'O3MR.550_mb': 3.4856975617003627e-07,
                'O3MR.5_mb': 1.577346665726509e-05,
                'O3MR.600_mb': 2.9822291480741114e-07,
                'O3MR.650_mb': 2.6171974809585663e-07,
                'O3MR.700_mb': 2.2410982580822747e-07,
                'O3MR.70_mb': 6.431337169487961e-06,
                'O3MR.750_mb': 2.0142938694789336e-07,
                'O3MR.7_mb': 1.7637310520512983e-05,
                'O3MR.800_mb': 1.7633183801990526e-07,
                'O3MR.850_mb': 1.7364746440762246e-07,
                'O3MR.900_mb': 1.7365024973514664e-07,
                'O3MR.925_mb': 1.7365016447001835e-07,
                'O3MR.950_mb': 1.736564740895119e-07,
                'O3MR.975_mb': 1.7364807547437522e-07,
                'PLPL.255-0_mb_above_ground': 100000.546875,
                'POT.0.995_sigma_level': 347.3280029296875,
                'PRATE.surface': 0.03150239959359169,
                'PRES.80_m_above_ground': 105893.96875,
                'PRES.PV2e06Km2kgs_surface': 82589.3359375,
                'PRES.PVNeg2e06Km2kgs_surface': 83070.9453125,
                'PRES.max_wind': 50000.17578125,
                'PRES.surface': 106909.0390625,
                'PRES.tropopause': 50000.05859375,
                'PRMSL.mean_sea_level': 110054.5390625,
                'PWAT.entire_atmosphere_considered_as_a_single_layer': 89.18968200683594,
                'REFC.entire_atmosphere': 55.769996643066406,
                'REFD.1000_m_above_ground': 55.659996032714844,
                'REFD.1_hybrid_level': 55.6199951171875,
                'REFD.2_hybrid_level': 55.62999725341797,
                'REFD.4000_m_above_ground': 53.13999557495117,
                'RH.0.01_mb': 0.10000000149011612,
                'RH.0.02_mb': 0.20000000298023224,
                'RH.0.04_mb': 0.5,
                'RH.0.07_mb': 0.800000011920929,
                'RH.0.1_mb': 0.20000000298023224,
                'RH.0.2_mb': 0.0,
                'RH.0.33-1_sigma_layer': 100.0,
                'RH.0.44-0.72_sigma_layer': 100.0,
                'RH.0.44-1_sigma_layer': 100.0,
                'RH.0.4_mb': 0.0,
                'RH.0.72-0.94_sigma_layer': 100.0,
                'RH.0.7_mb': 0.0,
                'RH.0.995_sigma_level': 100.0,
                'RH.0C_isotherm': 100.0,
                'RH.1000_mb': 100.0,
                'RH.100_mb': 100.0,
                'RH.10_mb': 42.599998474121094,
                'RH.150_mb': 100.0,
                'RH.15_mb': 55.099998474121094,
                'RH.1_mb': 0.10000000149011612,
                'RH.200_mb': 100.0,
                'RH.20_mb': 65.9000015258789,
                'RH.250_mb': 100.0,
                'RH.2_m_above_ground': 100.0,
                'RH.2_mb': 1.2999999523162842,
                'RH.30-0_mb_above_ground': 100.0,
                'RH.300_mb': 100.0,
                'RH.30_mb': 94.30000305175781,
                'RH.350_mb': 100.0,
                'RH.3_mb': 4.300000190734863,
                'RH.400_mb': 100.0,
                'RH.40_mb': 100.0,
                'RH.450_mb': 100.0,
                'RH.500_mb': 100.0,
                'RH.50_mb': 100.0,
                'RH.550_mb': 100.0,
                'RH.5_mb': 30.899999618530273,
                'RH.600_mb': 100.0,
                'RH.650_mb': 100.0,
                'RH.700_mb': 100.0,
                'RH.70_mb': 100.0,
                'RH.750_mb': 100.0,
                'RH.7_mb': 51.900001525878906,
                'RH.800_mb': 100.0,
                'RH.850_mb': 100.0,
                'RH.900_mb': 100.0,
                'RH.925_mb': 100.0,
                'RH.950_mb': 100.0,
                'RH.975_mb': 100.0,
                'RH.entire_atmosphere_considered_as_a_single_layer': 81.5999984741211,
                'RH.highest_tropospheric_freezing_level': 100.0,
                'RWMR.1000_mb': 0.0036663999781012535,
                'RWMR.100_mb': 4.961911059808699e-08,
                'RWMR.150_mb': 6.251740813922879e-08,
                'RWMR.1_hybrid_level': 0.004540400113910437,
                'RWMR.200_mb': 6.489120352171085e-08,
                'RWMR.250_mb': 8.580099830624022e-08,
                'RWMR.300_mb': 1.3851115454599494e-06,
                'RWMR.350_mb': 9.80041477305349e-06,
                'RWMR.400_mb': 4.054879900650121e-05,
                'RWMR.450_mb': 0.0005560800200328231,
                'RWMR.500_mb': 0.003470879979431629,
                'RWMR.50_mb': 4.30176250176828e-09,
                'RWMR.550_mb': 0.005687519907951355,
                'RWMR.600_mb': 0.004934079945087433,
                'RWMR.650_mb': 0.005145280156284571,
                'RWMR.700_mb': 0.004962559789419174,
                'RWMR.750_mb': 0.005131680052727461,
                'RWMR.800_mb': 0.0051556797698140144,
                'RWMR.850_mb': 0.005095200147479773,
                'RWMR.900_mb': 0.004944480024278164,
                'RWMR.925_mb': 0.004850239958614111,
                'RWMR.950_mb': 0.004748799838125706,
                'RWMR.975_mb': 0.004635680001229048,
                'SFCR.surface': 2.6529600620269775,
                'SNMR.1000_mb': 0.0009092160034924746,
                'SNMR.100_mb': 0.0010372829856351018,
                'SNMR.150_mb': 0.001903763273730874,
                'SNMR.1_hybrid_level': 0.001611800049431622,
                'SNMR.200_mb': 0.002338681137189269,
                'SNMR.250_mb': 0.0023753601126372814,
                'SNMR.300_mb': 0.0022732000797986984,
                'SNMR.350_mb': 0.002124520018696785,
                'SNMR.400_mb': 0.0020382399670779705,
                'SNMR.450_mb': 0.0019829999655485153,
                'SNMR.500_mb': 0.0017265599453821778,
                'SNMR.50_mb': 7.703415683124604e-09,
                'SNMR.550_mb': 0.001635399996303022,
                'SNMR.600_mb': 0.0016611600294709206,
                'SNMR.650_mb': 0.0013929599663242698,
                'SNMR.700_mb': 0.001323999953456223,
                'SNMR.750_mb': 0.0012467600172385573,
                'SNMR.800_mb': 0.0012935199774801731,
                'SNMR.850_mb': 0.0011458200169727206,
                'SNMR.900_mb': 0.001658800058066845,
                'SNMR.925_mb': 0.0011247600195929408,
                'SNMR.950_mb': 0.0015725999837741256,
                'SNMR.975_mb': 0.001100120018236339,
                'SNOD.surface': 6.371520042419434,
                'SOILL.0-0.1_m_below_ground': 1.0,
                'SOILL.0.1-0.4_m_below_ground': 1.0004853010177612,
                'SOILL.0.4-1_m_below_ground': 1.0002726316452026,
                'SOILL.1-2_m_below_ground': 1.0,
                'SOILW.0-0.1_m_below_ground': 1.0,
                'SOILW.0.1-0.4_m_below_ground': 1.0004853010177612,
                'SOILW.0.4-1_m_below_ground': 1.0002726316452026,
                'SOILW.1-2_m_below_ground': 1.0,
                'SOTYP.surface': 16.0,
                'SPFH.0.01_mb': 4.820516551262699e-06,
                'SPFH.0.02_mb': 3.911382009391673e-06,
                'SPFH.0.04_mb': 4.039989562443225e-06,
                'SPFH.0.07_mb': 4.106809683435131e-06,
                'SPFH.0.1_mb': 4.1217476791644e-06,
                'SPFH.0.2_mb': 4.0613585952087305e-06,
                'SPFH.0.4_mb': 4.01075203626533e-06,
                'SPFH.0.7_mb': 3.988800017395988e-06,
                'SPFH.1000_mb': 0.04835778847336769,
                'SPFH.100_mb': 1.3740490430791397e-05,
                'SPFH.10_mb': 3.5019565984839574e-06,
                'SPFH.150_mb': 0.00010546694829827175,
                'SPFH.15_mb': 3.846331765089417e-06,
                'SPFH.1_mb': 3.998143711214652e-06,
                'SPFH.200_mb': 0.000525146082509309,
                'SPFH.20_mb': 3.5212451621191576e-06,
                'SPFH.250_mb': 0.0015431599458679557,
                'SPFH.2_m_above_ground': 0.02722543478012085,
                'SPFH.2_mb': 4.071424882567953e-06,
                'SPFH.30-0_mb_above_ground': 0.024013804271817207,
                'SPFH.300_mb': 0.0030038226395845413,
                'SPFH.30_mb': 3.597013574108132e-06,
                'SPFH.350_mb': 0.004961828701198101,
                'SPFH.3_mb': 4.0430063563690055e-06,
                'SPFH.400_mb': 0.006360213737934828,
                'SPFH.40_mb': 3.593348083086312e-06,
                'SPFH.450_mb': 0.008123589679598808,
                'SPFH.500_mb': 0.00969909317791462,
                'SPFH.50_mb': 4.063042069901712e-06,
                'SPFH.550_mb': 0.012505577877163887,
                'SPFH.5_mb': 3.93266964238137e-06,
                'SPFH.600_mb': 0.015623953193426132,
                'SPFH.650_mb': 0.019014833495020866,
                'SPFH.700_mb': 0.02265060879290104,
                'SPFH.70_mb': 3.257896241848357e-05,
                'SPFH.750_mb': 0.02650710754096508,
                'SPFH.7_mb': 3.815911895799218e-06,
                'SPFH.800_mb': 0.030561165884137154,
                'SPFH.80_m_above_ground': 0.024651190266013145,
                'SPFH.850_mb': 0.03479110449552536,
                'SPFH.900_mb': 0.039178911596536636,
                'SPFH.925_mb': 0.041425615549087524,
                'SPFH.950_mb': 0.0437057688832283,
                'SPFH.975_mb': 0.04601670801639557,
                'SUNSD.surface': 21600.0,
                'TCDC.1000_mb': 100.0,
                'TCDC.100_mb': 100.0,
                'TCDC.150_mb': 100.0,
                'TCDC.200_mb': 100.0,
                'TCDC.250_mb': 100.0,
                'TCDC.300_mb': 100.0,
                'TCDC.350_mb': 100.0,
                'TCDC.400_mb': 100.0,
                'TCDC.450_mb': 100.0,
                'TCDC.500_mb': 100.0,
                'TCDC.50_mb': 100.0,
                'TCDC.550_mb': 100.0,
                'TCDC.600_mb': 100.0,
                'TCDC.650_mb': 100.0,
                'TCDC.700_mb': 100.0,
                'TCDC.750_mb': 100.0,
                'TCDC.800_mb': 100.0,
                'TCDC.850_mb': 100.0,
                'TCDC.900_mb': 100.0,
                'TCDC.925_mb': 100.0,
                'TCDC.950_mb': 100.0,
                'TCDC.975_mb': 100.0,
                'TCDC.entire_atmosphere': 100.0,
                'TMP.0.01_mb': 199.63253784179688,
                'TMP.0.02_mb': 227.11004638671875,
                'TMP.0.04_mb': 264.2533874511719,
                'TMP.0.07_mb': 294.5732421875,
                'TMP.0.1_mb': 298.23236083984375,
                'TMP.0.2_mb': 308.034423828125,
                'TMP.0.4_mb': 312.4897766113281,
                'TMP.0.7_mb': 322.724365234375,
                'TMP.0.995_sigma_level': 322.6998291015625,
                'TMP.1000_mb': 326.80645751953125,
                'TMP.100_m_above_ground': 322.202880859375,
                'TMP.100_mb': 239.2621307373047,
                'TMP.10_mb': 257.0765075683594,
                'TMP.150_mb': 239.12966918945312,
                'TMP.15_mb': 250.2648468017578,
                'TMP.1829_m_above_mean_sea_level': 310.3109130859375,
                'TMP.1_mb': 315.6114807128906,
                'TMP.200_mb': 243.4665985107422,
                'TMP.20_mb': 246.8524627685547,
                'TMP.250_mb': 249.0885009765625,
                'TMP.2743_m_above_mean_sea_level': 302.9286193847656,
                'TMP.2_m_above_ground': 324.4722900390625,
                'TMP.2_mb': 293.124755859375,
                'TMP.30-0_mb_above_ground': 321.8292236328125,
                'TMP.300_mb': 261.5205993652344,
                'TMP.30_mb': 241.71688842773438,
                'TMP.350_mb': 271.0068359375,
                'TMP.3658_m_above_mean_sea_level': 298.0400085449219,
                'TMP.3_mb': 286.10107421875,
                'TMP.400_mb': 274.9149169921875,
                'TMP.40_mb': 240.6255340576172,
                'TMP.450_mb': 279.3899230957031,
                'TMP.500_mb': 284.6868591308594,
                'TMP.50_mb': 238.43380737304688,
                'TMP.550_mb': 292.7994384765625,
                'TMP.5_mb': 269.7367248535156,
                'TMP.600_mb': 298.33758544921875,
                'TMP.650_mb': 302.8138122558594,
                'TMP.700_mb': 306.9567565917969,
                'TMP.70_mb': 239.03294372558594,
                'TMP.750_mb': 310.7879943847656,
                'TMP.7_mb': 263.36517333984375,
                'TMP.800_mb': 314.38800048828125,
                'TMP.80_m_above_ground': 322.40130615234375,
                'TMP.850_mb': 317.7762756347656,
                'TMP.900_mb': 320.88800048828125,
                'TMP.925_mb': 322.38800048828125,
                'TMP.950_mb': 323.88800048828125,
                'TMP.975_mb': 325.38800048828125,
                'TMP.PV2e06Km2kgs_surface': 292.20001220703125,
                'TMP.PVNeg2e06Km2kgs_surface': 294.3240661621094,
                'TMP.max_wind': 280.9801025390625,
                'TMP.surface': 351.3723449707031,
                'TMP.tropopause': 274.4873046875,
                'TOZNE.entire_atmosphere_considered_as_a_single_layer': 545.0839233398438,
                'TSOIL.0-0.1_m_below_ground': 329.29998779296875,
                'TSOIL.0.1-0.4_m_below_ground': 319.5,
                'TSOIL.0.4-1_m_below_ground': 316.187744140625,
                'TSOIL.1-2_m_below_ground': 313.5157775878906,
                'UGRD.0.01_mb': 303.285400390625,
                'UGRD.0.02_mb': 277.1309814453125,
                'UGRD.0.04_mb': 234.1947784423828,
                'UGRD.0.07_mb': 217.95155334472656,
                'UGRD.0.1_mb': 201.88778686523438,
                'UGRD.0.2_mb': 201.39947509765625,
                'UGRD.0.4_mb': 209.2893524169922,
                'UGRD.0.7_mb': 198.56861877441406,
                'UGRD.0.995_sigma_level': 65.13652038574219,
                'UGRD.1000_mb': 54.866825103759766,
                'UGRD.100_m_above_ground': 69.07756042480469,
                'UGRD.100_mb': 82.47203063964844,
                'UGRD.10_m_above_ground': 57.912330627441406,
                'UGRD.10_mb': 124.58000183105469,
                'UGRD.150_mb': 96.92352294921875,
                'UGRD.15_mb': 117.22663116455078,
                'UGRD.1829_m_above_mean_sea_level': 75.40437316894531,
                'UGRD.1_mb': 194.1729278564453,
                'UGRD.200_mb': 106.22189331054688,
                'UGRD.20_m_above_ground': 57.664649963378906,
                'UGRD.20_mb': 109.51615905761719,
                'UGRD.250_mb': 112.3420181274414,
                'UGRD.2743_m_above_mean_sea_level': 72.55804443359375,
                'UGRD.2_mb': 179.75515747070312,
                'UGRD.30-0_mb_above_ground': 69.23222351074219,
                'UGRD.300_mb': 111.14623260498047,
                'UGRD.30_m_above_ground': 60.7979736328125,
                'UGRD.30_mb': 97.30419158935547,
                'UGRD.350_mb': 96.07508850097656,
                'UGRD.3658_m_above_mean_sea_level': 72.09004211425781,
                'UGRD.3_mb': 145.07424926757812,
                'UGRD.400_mb': 87.56961059570312,
                'UGRD.40_m_above_ground': 62.839393615722656,
                'UGRD.40_mb': 89.74266815185547,
                'UGRD.450_mb': 82.62784576416016,
                'UGRD.500_mb': 77.42507934570312,
                'UGRD.50_m_above_ground': 64.3808364868164,
                'UGRD.50_mb': 84.42051696777344,
                'UGRD.550_mb': 75.93658447265625,
                'UGRD.5_mb': 147.74649047851562,
                'UGRD.600_mb': 70.53302001953125,
                'UGRD.650_mb': 72.83863830566406,
                'UGRD.700_mb': 72.59561920166016,
                'UGRD.70_mb': 82.51210021972656,
                'UGRD.750_mb': 74.880615234375,
                'UGRD.7_mb': 134.90675354003906,
                'UGRD.800_mb': 77.21314239501953,
                'UGRD.80_m_above_ground': 67.69322204589844,
                'UGRD.850_mb': 78.40721130371094,
                'UGRD.900_mb': 76.2816390991211,
                'UGRD.925_mb': 74.07009887695312,
                'UGRD.950_mb': 62.769248962402344,
                'UGRD.975_mb': 54.866825103759766,
                'UGRD.PV2e06Km2kgs_surface': 106.46453094482422,
                'UGRD.PVNeg2e06Km2kgs_surface': 111.25552368164062,
                'UGRD.max_wind': 113.79589080810547,
                'UGRD.planetary_boundary_layer': 72.61103820800781,
                'UGRD.tropopause': 104.890380859375,
                'USTM.6000-0_m_above_ground': 62.65808868408203,
                'VEG.surface': 99.0,
                'VGRD.0.01_mb': 108.00041961669922,
                'VGRD.0.02_mb': 102.4366226196289,
                'VGRD.0.04_mb': 89.2871322631836,
                'VGRD.0.07_mb': 99.81434631347656,
                'VGRD.0.1_mb': 111.37715148925781,
                'VGRD.0.2_mb': 125.15899658203125,
                'VGRD.0.4_mb': 122.99824523925781,
                'VGRD.0.7_mb': 124.7661361694336,
                'VGRD.0.995_sigma_level': 65.48775482177734,
                'VGRD.1000_mb': 54.524906158447266,
                'VGRD.100_m_above_ground': 69.15370178222656,
                'VGRD.100_mb': 42.55021667480469,
                'VGRD.10_m_above_ground': 57.962013244628906,
                'VGRD.10_mb': 76.77037048339844,
                'VGRD.150_mb': 56.63032531738281,
                'VGRD.15_mb': 71.5710220336914,
                'VGRD.1829_m_above_mean_sea_level': 78.4531478881836,
                'VGRD.1_mb': 115.18017578125,
                'VGRD.200_mb': 85.52254486083984,
                'VGRD.20_m_above_ground': 57.45409393310547,
                'VGRD.20_mb': 63.366844177246094,
                'VGRD.250_mb': 89.68959045410156,
                'VGRD.2743_m_above_mean_sea_level': 73.97579193115234,
                'VGRD.2_mb': 104.48048400878906,
                'VGRD.30-0_mb_above_ground': 69.46553039550781,
                'VGRD.300_mb': 85.79582214355469,
                'VGRD.30_m_above_ground': 60.82511520385742,
                'VGRD.30_mb': 53.779563903808594,
                'VGRD.350_mb': 83.01457977294922,
                'VGRD.3658_m_above_mean_sea_level': 67.82827758789062,
                'VGRD.3_mb': 100.16679382324219,
                'VGRD.400_mb': 75.99034118652344,
                'VGRD.40_m_above_ground': 62.849998474121094,
                'VGRD.40_mb': 47.71159744262695,
                'VGRD.450_mb': 69.80325317382812,
                'VGRD.500_mb': 63.812599182128906,
                'VGRD.50_m_above_ground': 64.42530059814453,
                'VGRD.50_mb': 47.35272979736328,
                'VGRD.550_mb': 65.86299133300781,
                'VGRD.5_mb': 91.38014221191406,
                'VGRD.600_mb': 67.20310974121094,
                'VGRD.650_mb': 70.60523986816406,
                'VGRD.700_mb': 73.93534088134766,
                'VGRD.70_mb': 41.681453704833984,
                'VGRD.750_mb': 76.97781372070312,
                'VGRD.7_mb': 81.24922180175781,
                'VGRD.800_mb': 80.1917953491211,
                'VGRD.80_m_above_ground': 67.7955322265625,
                'VGRD.850_mb': 80.72845458984375,
                'VGRD.900_mb': 77.49579620361328,
                'VGRD.925_mb': 73.39371490478516,
                'VGRD.950_mb': 63.946136474609375,
                'VGRD.975_mb': 54.524906158447266,
                'VGRD.PV2e06Km2kgs_surface': 90.41468811035156,
                'VGRD.PVNeg2e06Km2kgs_surface': 90.0000991821289,
                'VGRD.max_wind': 92.65167236328125,
                'VGRD.planetary_boundary_layer': 76.39295959472656,
                'VGRD.tropopause': 88.19380187988281,
                'VIS.surface': 24135.736328125,
                'VRATE.planetary_boundary_layer': 248000.046875,
                'VSTM.6000-0_m_above_ground': 64.66368103027344,
                'VVEL.0.01_mb': 0.004073510877788067,
                'VVEL.0.02_mb': 0.0048090131022036076,
                'VVEL.0.04_mb': 0.017133386805653572,
                'VVEL.0.07_mb': 0.038804393261671066,
                'VVEL.0.1_mb': 0.05760100856423378,
                'VVEL.0.2_mb': 0.11225013434886932,
                'VVEL.0.4_mb': 0.15448172390460968,
                'VVEL.0.7_mb': 0.1426328718662262,
                'VVEL.0.995_sigma_level': 17.582565307617188,
                'VVEL.1000_mb': 13.45222282409668,
                'VVEL.100_mb': 3.5155746936798096,
                'VVEL.10_mb': 0.6393690705299377,
                'VVEL.150_mb': 6.48388147354126,
                'VVEL.15_mb': 0.9422246813774109,
                'VVEL.1_mb': 0.13175630569458008,
                'VVEL.200_mb': 10.035222053527832,
                'VVEL.20_mb': 1.1645197868347168,
                'VVEL.250_mb': 11.752093315124512,
                'VVEL.2_mb': 0.2196855992078781,
                'VVEL.300_mb': 14.627593994140625,
                'VVEL.30_mb': 1.2882988452911377,
                'VVEL.350_mb': 18.35112762451172,
                'VVEL.3_mb': 0.3023500144481659,
                'VVEL.400_mb': 18.481496810913086,
                'VVEL.40_mb': 1.5306097269058228,
                'VVEL.450_mb': 19.495161056518555,
                'VVEL.500_mb': 22.469680786132812,
                'VVEL.50_mb': 1.6551058292388916,
                'VVEL.550_mb': 24.560646057128906,
                'VVEL.5_mb': 0.4728863835334778,
                'VVEL.600_mb': 24.68425941467285,
                'VVEL.650_mb': 25.103782653808594,
                'VVEL.700_mb': 25.956130981445312,
                'VVEL.70_mb': 2.5369396209716797,
                'VVEL.750_mb': 25.59684181213379,
                'VVEL.7_mb': 0.4843332767486572,
                'VVEL.800_mb': 23.998268127441406,
                'VVEL.850_mb': 24.022428512573242,
                'VVEL.900_mb': 20.898990631103516,
                'VVEL.925_mb': 17.92314338684082,
                'VVEL.950_mb': 13.820192337036133,
                'VVEL.975_mb': 13.452251434326172,
                'VWSH.PV2e06Km2kgs_surface': 0.10677246749401093,
                'VWSH.PVNeg2e06Km2kgs_surface': 0.10869086533784866,
                'VWSH.tropopause': 0.1088864877820015,
                'WEASD.surface': 812.7360229492188,
                'WILT.surface': 0.3969999849796295}
FORECAST_MIN = {'4LFTX.surface': -30.430912017822266,
                'ABSV.0.01_mb': -0.0027479631826281548,
                'ABSV.0.02_mb': -0.00338944885879755,
                'ABSV.0.04_mb': -0.003742694854736328,
                'ABSV.0.07_mb': -0.004424387123435736,
                'ABSV.0.1_mb': -0.004841282498091459,
                'ABSV.0.2_mb': -0.004692219663411379,
                'ABSV.0.4_mb': -0.0038081705570220947,
                'ABSV.0.7_mb': -0.0046986001543700695,
                'ABSV.1000_mb': -0.003734981408342719,
                'ABSV.100_mb': -0.0027162828482687473,
                'ABSV.10_mb': -0.0021508459467440844,
                'ABSV.150_mb': -0.0024764786940068007,
                'ABSV.15_mb': -0.0016349093057215214,
                'ABSV.1_mb': -0.004743982572108507,
                'ABSV.200_mb': -0.002725847065448761,
                'ABSV.20_mb': -0.0012761837569996715,
                'ABSV.250_mb': -0.0025744272861629725,
                'ABSV.2_mb': -0.003704794216901064,
                'ABSV.300_mb': -0.002391601912677288,
                'ABSV.30_mb': -0.0013446243247017264,
                'ABSV.350_mb': -0.00277600041590631,
                'ABSV.3_mb': -0.0027223124634474516,
                'ABSV.400_mb': -0.0028385622426867485,
                'ABSV.40_mb': -0.0012948779622092843,
                'ABSV.450_mb': -0.0028372611850500107,
                'ABSV.500_mb': -0.002822582609951496,
                'ABSV.50_mb': -0.0010043808724731207,
                'ABSV.550_mb': -0.002796107903122902,
                'ABSV.5_mb': -0.002586184535175562,
                'ABSV.600_mb': -0.0028964346274733543,
                'ABSV.650_mb': -0.0031767715699970722,
                'ABSV.700_mb': -0.0033003846183419228,
                'ABSV.70_mb': -0.0014889906160533428,
                'ABSV.750_mb': -0.003137596882879734,
                'ABSV.7_mb': -0.002566603245213628,
                'ABSV.800_mb': -0.004247190430760384,
                'ABSV.850_mb': -0.004226507153362036,
                'ABSV.900_mb': -0.003912043292075396,
                'ABSV.925_mb': -0.004026217386126518,
                'ABSV.950_mb': -0.004090641625225544,
                'ABSV.975_mb': -0.003964850679039955,
                'APTMP.2_m_above_ground': 177.3914794921875,
                'CAPE.180-0_mb_above_ground': 0.0,
                'CAPE.255-0_mb_above_ground': 0.0,
                'CAPE.90-0_mb_above_ground': 0.0,
                'CAPE.surface': 0.0,
                'CFRZR.surface': 0.0,
                'CICEP.surface': 0.0,
                'CIN.180-0_mb_above_ground': -2738.40771484375,
                'CIN.255-0_mb_above_ground': -2446.781005859375,
                'CIN.90-0_mb_above_ground': -3186.77880859375,
                'CIN.surface': -2517.068359375,
                'CLMR.1000_mb': 0.0,
                'CLMR.100_mb': 0.0,
                'CLMR.150_mb': 0.0,
                'CLMR.1_hybrid_level': 0.0,
                'CLMR.200_mb': 0.0,
                'CLMR.250_mb': 0.0,
                'CLMR.300_mb': 0.0,
                'CLMR.350_mb': 0.0,
                'CLMR.400_mb': 0.0,
                'CLMR.450_mb': 0.0,
                'CLMR.500_mb': 0.0,
                'CLMR.50_mb': 0.0,
                'CLMR.550_mb': 0.0,
                'CLMR.600_mb': 0.0,
                'CLMR.650_mb': 0.0,
                'CLMR.700_mb': 0.0,
                'CLMR.750_mb': 0.0,
                'CLMR.800_mb': 0.0,
                'CLMR.850_mb': 0.0,
                'CLMR.900_mb': 0.0,
                'CLMR.925_mb': 0.0,
                'CLMR.950_mb': 0.0,
                'CLMR.975_mb': 0.0,
                'CNWAT.surface': 0.0,
                'CPOFP.surface': -50.00000762939453,
                'CRAIN.surface': 0.0,
                'CSNOW.surface': 0.0,
                'CWAT.entire_atmosphere_considered_as_a_single_layer': 0.0,
                'DPT.2_m_above_ground': 192.09999084472656,
                'DZDT.0.01_mb': -15.331786155700684,
                'DZDT.0.02_mb': -12.331024169921875,
                'DZDT.0.04_mb': -22.362224578857422,
                'DZDT.0.07_mb': -29.995742797851562,
                'DZDT.0.1_mb': -32.57429504394531,
                'DZDT.0.2_mb': -33.213409423828125,
                'DZDT.0.4_mb': -20.9757137298584,
                'DZDT.0.7_mb': -11.438026428222656,
                'DZDT.1000_mb': -1.2663921117782593,
                'DZDT.100_mb': -2.1169843673706055,
                'DZDT.10_mb': -3.3995203971862793,
                'DZDT.150_mb': -2.2126896381378174,
                'DZDT.15_mb': -3.4459590911865234,
                'DZDT.1_mb': -9.663914680480957,
                'DZDT.200_mb': -2.4257423877716064,
                'DZDT.20_mb': -3.1224124431610107,
                'DZDT.250_mb': -2.3022677898406982,
                'DZDT.2_mb': -6.568981170654297,
                'DZDT.300_mb': -2.304657220840454,
                'DZDT.30_mb': -2.34781813621521,
                'DZDT.350_mb': -2.511892557144165,
                'DZDT.3_mb': -6.125333786010742,
                'DZDT.400_mb': -2.649721622467041,
                'DZDT.40_mb': -2.1279616355895996,
                'DZDT.450_mb': -2.790262222290039,
                'DZDT.500_mb': -2.727804660797119,
                'DZDT.50_mb': -1.8110347986221313,
                'DZDT.550_mb': -2.7716164588928223,
                'DZDT.5_mb': -5.647082328796387,
                'DZDT.600_mb': -2.781126022338867,
                'DZDT.650_mb': -2.678157329559326,
                'DZDT.700_mb': -2.4539082050323486,
                'DZDT.70_mb': -2.0103025436401367,
                'DZDT.750_mb': -2.1823582649230957,
                'DZDT.7_mb': -4.115588665008545,
                'DZDT.800_mb': -2.222048282623291,
                'DZDT.850_mb': -2.1017136573791504,
                'DZDT.900_mb': -1.7362381219863892,
                'DZDT.925_mb': -1.4515728950500488,
                'DZDT.950_mb': -1.2663921117782593,
                'DZDT.975_mb': -1.2663921117782593,
                'FLDCP.surface': 0.11589998751878738,
                'FRICV.surface': 0.006999998819082975,
                'GRLE.1000_mb': 0.0,
                'GRLE.100_mb': 1.1348864070725995e-09,
                'GRLE.150_mb': 3.0124969185862938e-09,
                'GRLE.1_hybrid_level': 0.0,
                'GRLE.200_mb': 7.259264855896674e-10,
                'GRLE.250_mb': 1.5493911709185682e-10,
                'GRLE.300_mb': 7.589122386075786e-11,
                'GRLE.350_mb': 1.540014101485132e-12,
                'GRLE.400_mb': 7.085318117806827e-13,
                'GRLE.450_mb': 1.1876114498083716e-26,
                'GRLE.500_mb': 0.0,
                'GRLE.50_mb': 9.225781943955624e-11,
                'GRLE.550_mb': 0.0,
                'GRLE.600_mb': 0.0,
                'GRLE.650_mb': 0.0,
                'GRLE.700_mb': 0.0,
                'GRLE.750_mb': 0.0,
                'GRLE.800_mb': 0.0,
                'GRLE.850_mb': 0.0,
                'GRLE.900_mb': 0.0,
                'GRLE.925_mb': 0.0,
                'GRLE.950_mb': 0.0,
                'GRLE.975_mb': 0.0,
                'GUST.surface': 0.0,
                'HCDC.high_cloud_layer': 0.0,
                'HGT.0.01_mb': 72588.59375,
                'HGT.0.02_mb': 69279.890625,
                'HGT.0.04_mb': 65078.296875,
                'HGT.0.07_mb': 61048.2734375,
                'HGT.0.1_mb': 58335.90625,
                'HGT.0.2_mb': 52972.8046875,
                'HGT.0.4_mb': 47560.09375,
                'HGT.0.7_mb': 43310.796875,
                'HGT.0C_isotherm': 0.0,
                'HGT.1000_mb': -719.6376342773438,
                'HGT.100_mb': 14296.625,
                'HGT.10_mb': 26672.5,
                'HGT.150_mb': 12005.4765625,
                'HGT.15_mb': 24515.6484375,
                'HGT.1_mb': 40746.28515625,
                'HGT.200_mb': 10347.5791015625,
                'HGT.20_mb': 23008.759765625,
                'HGT.250_mb': 9027.306640625,
                'HGT.2_mb': 36173.19921875,
                'HGT.300_mb': 7912.0751953125,
                'HGT.30_mb': 20803.265625,
                'HGT.350_mb': 6927.853515625,
                'HGT.3_mb': 33642.390625,
                'HGT.400_mb': 6053.1669921875,
                'HGT.40_mb': 19279.54296875,
                'HGT.450_mb': 5278.42578125,
                'HGT.500_mb': 4582.544921875,
                'HGT.50_mb': 18084.650390625,
                'HGT.550_mb': 3948.1904296875,
                'HGT.5_mb': 30568.921875,
                'HGT.600_mb': 3332.828125,
                'HGT.650_mb': 2756.246337890625,
                'HGT.700_mb': 2211.791259765625,
                'HGT.70_mb': 16261.9150390625,
                'HGT.750_mb': 1687.9541015625,
                'HGT.7_mb': 28648.626953125,
                'HGT.800_mb': 1184.8843994140625,
                'HGT.850_mb': 707.1567993164062,
                'HGT.900_mb': 218.0714111328125,
                'HGT.925_mb': -25.15810775756836,
                'HGT.950_mb': -262.71124267578125,
                'HGT.975_mb': -494.1130065917969,
                'HGT.PV2e06Km2kgs_surface': 1516.973388671875,
                'HGT.PVNeg2e06Km2kgs_surface': 1506.8861083984375,
                'HGT.cloud_ceiling': 0.807385265827179,
                'HGT.highest_tropospheric_freezing_level': 0.0,
                'HGT.max_wind': 4598.0771484375,
                'HGT.surface': -355.140625,
                'HGT.tropopause': 4586.68115234375,
                'HINDEX.surface': 2.0,
                'HLCY.3000-0_m_above_ground': -1384.1328125,
                'HPBL.surface': 7.151925563812256,
                'ICAHT.max_wind': 5574.39013671875,
                'ICAHT.tropopause': 5574.4326171875,
                'ICEC.surface': 0.0,
                'ICEG.10_m_above_mean_sea_level': 0.0,
                'ICETK.surface': 0.0,
                'ICETMP.surface': 218.31813049316406,
                'ICMR.1000_mb': 0.0,
                'ICMR.100_mb': 0.0,
                'ICMR.150_mb': 0.0,
                'ICMR.1_hybrid_level': 0.0,
                'ICMR.200_mb': 0.0,
                'ICMR.250_mb': 0.0,
                'ICMR.300_mb': 0.0,
                'ICMR.350_mb': 0.0,
                'ICMR.400_mb': 0.0,
                'ICMR.450_mb': 0.0,
                'ICMR.500_mb': 0.0,
                'ICMR.50_mb': 0.0,
                'ICMR.550_mb': 0.0,
                'ICMR.600_mb': 0.0,
                'ICMR.650_mb': 0.0,
                'ICMR.700_mb': 0.0,
                'ICMR.750_mb': 0.0,
                'ICMR.800_mb': 0.0,
                'ICMR.850_mb': 0.0,
                'ICMR.900_mb': 0.0,
                'ICMR.925_mb': 0.0,
                'ICMR.950_mb': 0.0,
                'ICMR.975_mb': 0.0,
                'LAND.surface': 0.0,
                'LCDC.low_cloud_layer': 0.0,
                'LFTX.surface': -16.2030086517334,
                'MCDC.middle_cloud_layer': 0.0,
                'MSLET.mean_sea_level': 92239.234375,
                'O3MR.0.01_mb': 8.384899530256007e-08,
                'O3MR.0.02_mb': 1.7701340482290107e-07,
                'O3MR.0.04_mb': 2.082153258697872e-07,
                'O3MR.0.07_mb': 2.0603332373525518e-08,
                'O3MR.0.1_mb': 4.396918029669905e-08,
                'O3MR.0.2_mb': 2.3289692308026133e-07,
                'O3MR.0.4_mb': -2.000000165480742e-09,
                'O3MR.0.7_mb': -1.554611905874026e-08,
                'O3MR.1000_mb': 2.0484575813384254e-08,
                'O3MR.100_mb': -1.7163822585430921e-09,
                'O3MR.10_mb': 3.6641067708842456e-06,
                'O3MR.150_mb': -9.985595683659199e-10,
                'O3MR.15_mb': 3.0062178666412365e-06,
                'O3MR.1_mb': -5.311477924152541e-09,
                'O3MR.200_mb': -6.552255404912444e-10,
                'O3MR.20_mb': 1.5231390761982766e-06,
                'O3MR.250_mb': -3.9929687334350206e-10,
                'O3MR.2_mb': 8.561407867091475e-07,
                'O3MR.300_mb': -2.8999999623913197e-10,
                'O3MR.30_mb': 2.2006274775776546e-06,
                'O3MR.350_mb': -2.1354247536908844e-10,
                'O3MR.3_mb': 2.2860665183088713e-07,
                'O3MR.400_mb': -1.0408203465761545e-10,
                'O3MR.40_mb': 1.4576701232726919e-06,
                'O3MR.450_mb': -1.3353711192376494e-10,
                'O3MR.500_mb': 4.4795722686785666e-11,
                'O3MR.50_mb': 3.8266315982582455e-07,
                'O3MR.550_mb': 1.1284433387714898e-09,
                'O3MR.5_mb': 3.130084564872959e-07,
                'O3MR.600_mb': 3.25953952717839e-09,
                'O3MR.650_mb': 5.6460662811730344e-09,
                'O3MR.700_mb': 9.936421463407896e-09,
                'O3MR.70_mb': -3.023923111911131e-09,
                'O3MR.750_mb': 1.492982093509454e-08,
                'O3MR.7_mb': 3.405883035156876e-06,
                'O3MR.800_mb': 1.748156108760668e-08,
                'O3MR.850_mb': 2.8795238193879413e-08,
                'O3MR.900_mb': 2.842436508387891e-08,
                'O3MR.925_mb': 2.5941160330944513e-08,
                'O3MR.950_mb': 2.281229427580911e-08,
                'O3MR.975_mb': 1.9648213722689434e-08,
                'PLPL.255-0_mb_above_ground': 18063.16015625,
                'POT.0.995_sigma_level': 216.9386749267578,
                'PRATE.surface': 0.0,
                'PRES.80_m_above_ground': 47231.08984375,
                'PRES.PV2e06Km2kgs_surface': 5710.93212890625,
                'PRES.PVNeg2e06Km2kgs_surface': 5710.93212890625,
                'PRES.max_wind': 10403.978515625,
                'PRES.surface': 47746.96875,
                'PRES.tropopause': 5236.50048828125,
                'PRMSL.mean_sea_level': 92239.078125,
                'PWAT.entire_atmosphere_considered_as_a_single_layer': 0.04542497545480728,
                'REFC.entire_atmosphere': -20.000003814697266,
                'REFD.1000_m_above_ground': -20.000003814697266,
                'REFD.1_hybrid_level': -20.000003814697266,
                'REFD.2_hybrid_level': -20.000003814697266,
                'REFD.4000_m_above_ground': -20.000003814697266,
                'RH.0.01_mb': 0.0,
                'RH.0.02_mb': 0.0,
                'RH.0.04_mb': 0.0,
                'RH.0.07_mb': 0.0,
                'RH.0.1_mb': 0.0,
                'RH.0.2_mb': 0.0,
                'RH.0.33-1_sigma_layer': 1.399999976158142,
                'RH.0.44-0.72_sigma_layer': 0.0,
                'RH.0.44-1_sigma_layer': 1.600000023841858,
                'RH.0.4_mb': 0.0,
                'RH.0.72-0.94_sigma_layer': 0.0,
                'RH.0.7_mb': 0.0,
                'RH.0.995_sigma_level': 0.0,
                'RH.0C_isotherm': 1.0,
                'RH.1000_mb': 0.0,
                'RH.100_mb': 0.0,
                'RH.10_mb': 0.0,
                'RH.150_mb': 0.0,
                'RH.15_mb': 0.0,
                'RH.1_mb': 0.0,
                'RH.200_mb': 0.0,
                'RH.20_mb': 0.0,
                'RH.250_mb': 0.0,
                'RH.2_m_above_ground': 1.0,
                'RH.2_mb': 0.0,
                'RH.30-0_mb_above_ground': 1.0,
                'RH.300_mb': 0.0,
                'RH.30_mb': 0.0,
                'RH.350_mb': 0.0,
                'RH.3_mb': 0.0,
                'RH.400_mb': 0.0,
                'RH.40_mb': 0.0,
                'RH.450_mb': 0.0,
                'RH.500_mb': 0.0,
                'RH.50_mb': 0.0,
                'RH.550_mb': 0.0,
                'RH.5_mb': 0.0,
                'RH.600_mb': 0.0,
                'RH.650_mb': 0.0,
                'RH.700_mb': 0.0,
                'RH.70_mb': 0.0,
                'RH.750_mb': 0.0,
                'RH.7_mb': 0.0,
                'RH.800_mb': 0.0,
                'RH.850_mb': 0.0,
                'RH.900_mb': 0.0,
                'RH.925_mb': 0.0,
                'RH.950_mb': 0.0,
                'RH.975_mb': 0.0,
                'RH.entire_atmosphere_considered_as_a_single_layer': 0.10000000149011612,
                'RH.highest_tropospheric_freezing_level': 1.0,
                'RWMR.1000_mb': 0.0,
                'RWMR.100_mb': 5.485036470159743e-12,
                'RWMR.150_mb': 5.385971616617136e-13,
                'RWMR.1_hybrid_level': 0.0,
                'RWMR.200_mb': 4.7408414000083e-12,
                'RWMR.250_mb': 4.9580769177770545e-12,
                'RWMR.300_mb': 0.0,
                'RWMR.350_mb': 0.0,
                'RWMR.400_mb': 0.0,
                'RWMR.450_mb': 0.0,
                'RWMR.500_mb': 0.0,
                'RWMR.50_mb': 4.2412393042035035e-12,
                'RWMR.550_mb': 0.0,
                'RWMR.600_mb': 0.0,
                'RWMR.650_mb': 0.0,
                'RWMR.700_mb': 0.0,
                'RWMR.750_mb': 0.0,
                'RWMR.800_mb': 0.0,
                'RWMR.850_mb': 0.0,
                'RWMR.900_mb': 0.0,
                'RWMR.925_mb': 0.0,
                'RWMR.950_mb': 0.0,
                'RWMR.975_mb': 0.0,
                'SFCR.surface': 9.999998695775503e-08,
                'SNMR.1000_mb': 0.0,
                'SNMR.100_mb': 1.0766738611778237e-09,
                'SNMR.150_mb': 1.3429896084105053e-09,
                'SNMR.1_hybrid_level': 0.0,
                'SNMR.200_mb': 5.363585131590298e-10,
                'SNMR.250_mb': 1.4521714451591616e-13,
                'SNMR.300_mb': 0.0,
                'SNMR.350_mb': 0.0,
                'SNMR.400_mb': 0.0,
                'SNMR.450_mb': 0.0,
                'SNMR.500_mb': 0.0,
                'SNMR.50_mb': 9.091605246425161e-11,
                'SNMR.550_mb': 0.0,
                'SNMR.600_mb': 0.0,
                'SNMR.650_mb': 0.0,
                'SNMR.700_mb': 0.0,
                'SNMR.750_mb': 0.0,
                'SNMR.800_mb': 0.0,
                'SNMR.850_mb': 0.0,
                'SNMR.900_mb': 0.0,
                'SNMR.925_mb': 0.0,
                'SNMR.950_mb': 0.0,
                'SNMR.975_mb': 0.0,
                'SNOD.surface': 0.0,
                'SOILL.0-0.1_m_below_ground': 0.019999997690320015,
                'SOILL.0.1-0.4_m_below_ground': 0.019999997690320015,
                'SOILL.0.4-1_m_below_ground': 0.019999997690320015,
                'SOILL.1-2_m_below_ground': 0.026000000536441803,
                'SOILW.0-0.1_m_below_ground': 0.019999997690320015,
                'SOILW.0.1-0.4_m_below_ground': 0.019999997690320015,
                'SOILW.0.4-1_m_below_ground': 0.019999997690320015,
                'SOILW.1-2_m_below_ground': 0.026000000536441803,
                'SOTYP.surface': 0.0,
                'SPFH.0.01_mb': 3.188938446641032e-09,
                'SPFH.0.02_mb': 6.495216808843907e-09,
                'SPFH.0.04_mb': 2.018171052498019e-08,
                'SPFH.0.07_mb': 4.477454140783266e-08,
                'SPFH.0.1_mb': 7.820915470801992e-08,
                'SPFH.0.2_mb': 3.271873083576793e-07,
                'SPFH.0.4_mb': 3.792302436522732e-07,
                'SPFH.0.7_mb': 6.467475088811625e-08,
                'SPFH.1000_mb': 1.9817298912983006e-09,
                'SPFH.100_mb': 3.6134645622909467e-12,
                'SPFH.10_mb': 1.3003942367362242e-10,
                'SPFH.150_mb': 1.6677166592149462e-11,
                'SPFH.15_mb': 1.21457829904692e-10,
                'SPFH.1_mb': 2.3524053816004198e-08,
                'SPFH.200_mb': 2.7443724376352563e-11,
                'SPFH.20_mb': 8.199656925667043e-11,
                'SPFH.250_mb': 2.703110305035672e-11,
                'SPFH.2_m_above_ground': 9.9999988758398e-13,
                'SPFH.2_mb': 2.3997424047905724e-09,
                'SPFH.30-0_mb_above_ground': 5.845781743119005e-06,
                'SPFH.300_mb': 5.406723332934682e-11,
                'SPFH.30_mb': 5.6685843519144186e-11,
                'SPFH.350_mb': 1.1155028983855786e-10,
                'SPFH.3_mb': 1.5001321296281844e-09,
                'SPFH.400_mb': 1.7227370918693197e-10,
                'SPFH.40_mb': 6.251978795779323e-11,
                'SPFH.450_mb': 2.4031171497185255e-10,
                'SPFH.500_mb': 4.015930366030318e-10,
                'SPFH.50_mb': 4.6256602714844774e-11,
                'SPFH.550_mb': 5.844869588322865e-10,
                'SPFH.5_mb': 4.177767298774171e-10,
                'SPFH.600_mb': 9.005369783210426e-10,
                'SPFH.650_mb': 9.999915340230814e-10,
                'SPFH.700_mb': 7.761566389596908e-11,
                'SPFH.70_mb': 5.406368061566802e-12,
                'SPFH.750_mb': 2.2404826605093575e-10,
                'SPFH.7_mb': 2.4044077839846523e-10,
                'SPFH.800_mb': 1.000071137013947e-09,
                'SPFH.80_m_above_ground': 6.862293844278611e-07,
                'SPFH.850_mb': 3.219742805704584e-10,
                'SPFH.900_mb': 1.371594171573065e-09,
                'SPFH.925_mb': 1.5146977005997542e-09,
                'SPFH.950_mb': 1.6642947020528709e-09,
                'SPFH.975_mb': 1.8200995155481792e-09,
                'SUNSD.surface': 0.0,
                'TCDC.1000_mb': 0.0,
                'TCDC.100_mb': 0.0,
                'TCDC.150_mb': 0.0,
                'TCDC.200_mb': 0.0,
                'TCDC.250_mb': 0.0,
                'TCDC.300_mb': 0.0,
                'TCDC.350_mb': 0.0,
                'TCDC.400_mb': 0.0,
                'TCDC.450_mb': 0.0,
                'TCDC.500_mb': 0.0,
                'TCDC.50_mb': 0.0,
                'TCDC.550_mb': 0.0,
                'TCDC.600_mb': 0.0,
                'TCDC.650_mb': 0.0,
                'TCDC.700_mb': 0.0,
                'TCDC.750_mb': 0.0,
                'TCDC.800_mb': 0.0,
                'TCDC.850_mb': 0.0,
                'TCDC.900_mb': 0.0,
                'TCDC.925_mb': 0.0,
                'TCDC.950_mb': 0.0,
                'TCDC.975_mb': 0.0,
                'TCDC.entire_atmosphere': 0.0,
                'TMP.0.01_mb': 141.9280242919922,
                'TMP.0.02_mb': 156.13844299316406,
                'TMP.0.04_mb': 161.22341918945312,
                'TMP.0.07_mb': 177.49700927734375,
                'TMP.0.1_mb': 188.93304443359375,
                'TMP.0.2_mb': 204.85577392578125,
                'TMP.0.4_mb': 218.06024169921875,
                'TMP.0.7_mb': 217.78138732910156,
                'TMP.0.995_sigma_level': 201.587890625,
                'TMP.1000_mb': 214.61907958984375,
                'TMP.100_m_above_ground': 207.3450927734375,
                'TMP.100_mb': 182.2279815673828,
                'TMP.10_mb': 177.4144287109375,
                'TMP.150_mb': 182.11489868164062,
                'TMP.15_mb': 175.4311981201172,
                'TMP.1829_m_above_mean_sea_level': 210.7964324951172,
                'TMP.1_mb': 209.6688232421875,
                'TMP.200_mb': 189.0931396484375,
                'TMP.20_mb': 174.36630249023438,
                'TMP.250_mb': 196.5697479248047,
                'TMP.2743_m_above_mean_sea_level': 210.6172332763672,
                'TMP.2_m_above_ground': 196.35098266601562,
                'TMP.2_mb': 194.75405883789062,
                'TMP.30-0_mb_above_ground': 209.36831665039062,
                'TMP.300_mb': 202.5095672607422,
                'TMP.30_mb': 174.88299560546875,
                'TMP.350_mb': 205.78085327148438,
                'TMP.3658_m_above_mean_sea_level': 201.42120361328125,
                'TMP.3_mb': 189.9233856201172,
                'TMP.400_mb': 210.7182159423828,
                'TMP.40_mb': 175.42642211914062,
                'TMP.450_mb': 214.2729949951172,
                'TMP.500_mb': 215.40859985351562,
                'TMP.50_mb': 177.23675537109375,
                'TMP.550_mb': 215.93670654296875,
                'TMP.5_mb': 180.7358856201172,
                'TMP.600_mb': 200.31788635253906,
                'TMP.650_mb': 199.89703369140625,
                'TMP.700_mb': 202.88914489746094,
                'TMP.70_mb': 180.24380493164062,
                'TMP.750_mb': 205.57154846191406,
                'TMP.7_mb': 178.81582641601562,
                'TMP.800_mb': 208.11154174804688,
                'TMP.80_m_above_ground': 205.8450927734375,
                'TMP.850_mb': 210.53155517578125,
                'TMP.900_mb': 212.8450927734375,
                'TMP.925_mb': 213.96597290039062,
                'TMP.950_mb': 215.0450897216797,
                'TMP.975_mb': 215.18626403808594,
                'TMP.PV2e06Km2kgs_surface': 179.09474182128906,
                'TMP.PVNeg2e06Km2kgs_surface': 176.73452758789062,
                'TMP.max_wind': 183.0302734375,
                'TMP.surface': 190.5634765625,
                'TMP.tropopause': 174.42111206054688,
                'TOZNE.entire_atmosphere_considered_as_a_single_layer': 102.99858093261719,
                'TSOIL.0-0.1_m_below_ground': 215.20901489257812,
                'TSOIL.0.1-0.4_m_below_ground': 216.8193359375,
                'TSOIL.0.4-1_m_below_ground': 217.95773315429688,
                'TSOIL.1-2_m_below_ground': 218.94580078125,
                'UGRD.0.01_mb': -169.09646606445312,
                'UGRD.0.02_mb': -151.4097442626953,
                'UGRD.0.04_mb': -122.40446472167969,
                'UGRD.0.07_mb': -119.84806823730469,
                'UGRD.0.1_mb': -117.1570816040039,
                'UGRD.0.2_mb': -125.14100646972656,
                'UGRD.0.4_mb': -101.76065063476562,
                'UGRD.0.7_mb': -89.26913452148438,
                'UGRD.0.995_sigma_level': -65.03331756591797,
                'UGRD.1000_mb': -54.228492736816406,
                'UGRD.100_m_above_ground': -68.77961730957031,
                'UGRD.100_mb': -53.2033805847168,
                'UGRD.10_m_above_ground': -56.69977951049805,
                'UGRD.10_mb': -51.12577819824219,
                'UGRD.150_mb': -60.6086540222168,
                'UGRD.15_mb': -52.44810485839844,
                'UGRD.1829_m_above_mean_sea_level': -77.34002685546875,
                'UGRD.1_mb': -85.22940826416016,
                'UGRD.200_mb': -69.92955780029297,
                'UGRD.20_m_above_ground': -57.120697021484375,
                'UGRD.20_mb': -53.20521926879883,
                'UGRD.250_mb': -67.5984878540039,
                'UGRD.2743_m_above_mean_sea_level': -72.54425811767578,
                'UGRD.2_mb': -68.75662231445312,
                'UGRD.30-0_mb_above_ground': -69.07308959960938,
                'UGRD.300_mb': -61.02923583984375,
                'UGRD.30_m_above_ground': -60.3901252746582,
                'UGRD.30_mb': -41.39746856689453,
                'UGRD.350_mb': -64.51741027832031,
                'UGRD.3658_m_above_mean_sea_level': -73.6586685180664,
                'UGRD.3_mb': -59.80073165893555,
                'UGRD.400_mb': -69.03018951416016,
                'UGRD.40_m_above_ground': -62.527862548828125,
                'UGRD.40_mb': -37.70568084716797,
                'UGRD.450_mb': -69.69503784179688,
                'UGRD.500_mb': -72.17578125,
                'UGRD.50_m_above_ground': -64.05582427978516,
                'UGRD.50_mb': -37.57133102416992,
                'UGRD.550_mb': -74.1376953125,
                'UGRD.5_mb': -54.499996185302734,
                'UGRD.600_mb': -74.20645904541016,
                'UGRD.650_mb': -72.92044067382812,
                'UGRD.700_mb': -72.84362030029297,
                'UGRD.70_mb': -45.15977478027344,
                'UGRD.750_mb': -75.94637298583984,
                'UGRD.7_mb': -56.00954055786133,
                'UGRD.800_mb': -79.2239990234375,
                'UGRD.80_m_above_ground': -67.33671569824219,
                'UGRD.850_mb': -79.3478775024414,
                'UGRD.900_mb': -76.29304504394531,
                'UGRD.925_mb': -73.70442199707031,
                'UGRD.950_mb': -63.30243682861328,
                'UGRD.975_mb': -54.228492736816406,
                'UGRD.PV2e06Km2kgs_surface': -61.177757263183594,
                'UGRD.PVNeg2e06Km2kgs_surface': -57.74784469604492,
                'UGRD.max_wind': -71.31039428710938,
                'UGRD.planetary_boundary_layer': -74.8733139038086,
                'UGRD.tropopause': -59.620323181152344,
                'USTM.6000-0_m_above_ground': -64.36068725585938,
                'VEG.surface': 0.0,
                'VGRD.0.01_mb': -136.74050903320312,
                'VGRD.0.02_mb': -128.3406982421875,
                'VGRD.0.04_mb': -101.23258972167969,
                'VGRD.0.07_mb': -120.56056213378906,
                'VGRD.0.1_mb': -117.70103454589844,
                'VGRD.0.2_mb': -125.14100646972656,
                'VGRD.0.4_mb': -118.57768249511719,
                'VGRD.0.7_mb': -128.5011444091797,
                'VGRD.0.995_sigma_level': -61.8953742980957,
                'VGRD.1000_mb': -51.11976623535156,
                'VGRD.100_m_above_ground': -65.69871520996094,
                'VGRD.100_mb': -45.181827545166016,
                'VGRD.10_m_above_ground': -55.009681701660156,
                'VGRD.10_mb': -84.87703704833984,
                'VGRD.150_mb': -64.07294464111328,
                'VGRD.15_mb': -74.00932312011719,
                'VGRD.1829_m_above_mean_sea_level': -75.34420776367188,
                'VGRD.1_mb': -131.77012634277344,
                'VGRD.200_mb': -75.41145324707031,
                'VGRD.20_m_above_ground': -54.0284309387207,
                'VGRD.20_mb': -69.09970092773438,
                'VGRD.250_mb': -80.47913360595703,
                'VGRD.2743_m_above_mean_sea_level': -71.65353393554688,
                'VGRD.2_mb': -114.84771728515625,
                'VGRD.30-0_mb_above_ground': -66.12470245361328,
                'VGRD.300_mb': -80.8149642944336,
                'VGRD.30_m_above_ground': -57.29096221923828,
                'VGRD.30_mb': -61.3204345703125,
                'VGRD.350_mb': -79.86722564697266,
                'VGRD.3658_m_above_mean_sea_level': -65.42285919189453,
                'VGRD.3_mb': -95.39141845703125,
                'VGRD.400_mb': -76.44413757324219,
                'VGRD.40_m_above_ground': -59.41570281982422,
                'VGRD.40_mb': -53.523162841796875,
                'VGRD.450_mb': -70.97784423828125,
                'VGRD.500_mb': -66.89959716796875,
                'VGRD.50_m_above_ground': -60.90288162231445,
                'VGRD.50_mb': -49.690277099609375,
                'VGRD.550_mb': -63.28522872924805,
                'VGRD.5_mb': -95.08988189697266,
                'VGRD.600_mb': -64.55165100097656,
                'VGRD.650_mb': -67.93083953857422,
                'VGRD.700_mb': -71.98690795898438,
                'VGRD.70_mb': -44.639320373535156,
                'VGRD.750_mb': -74.6881103515625,
                'VGRD.7_mb': -93.9000473022461,
                'VGRD.800_mb': -75.30683898925781,
                'VGRD.80_m_above_ground': -64.31908416748047,
                'VGRD.850_mb': -74.11135864257812,
                'VGRD.900_mb': -73.87925720214844,
                'VGRD.925_mb': -70.10486602783203,
                'VGRD.950_mb': -61.86384963989258,
                'VGRD.975_mb': -51.11976623535156,
                'VGRD.PV2e06Km2kgs_surface': -78.65520477294922,
                'VGRD.PVNeg2e06Km2kgs_surface': -80.05914306640625,
                'VGRD.max_wind': -82.91300201416016,
                'VGRD.planetary_boundary_layer': -70.8072280883789,
                'VGRD.tropopause': -77.4338150024414,
                'VIS.surface': 15.692286491394043,
                'VRATE.planetary_boundary_layer': 0.0,
                'VSTM.6000-0_m_above_ground': -59.79972457885742,
                'VVEL.0.01_mb': -0.003682768438011408,
                'VVEL.0.02_mb': -0.0035841288045048714,
                'VVEL.0.04_mb': -0.010303978808224201,
                'VVEL.0.07_mb': -0.018010612577199936,
                'VVEL.0.1_mb': -0.02400905452668667,
                'VVEL.0.2_mb': -0.06254161149263382,
                'VVEL.0.4_mb': -0.09606032073497772,
                'VVEL.0.7_mb': -0.12811179459095,
                'VVEL.0.995_sigma_level': -14.277606010437012,
                'VVEL.1000_mb': -12.476078033447266,
                'VVEL.100_mb': -7.533298492431641,
                'VVEL.10_mb': -0.5004966259002686,
                'VVEL.150_mb': -19.32602310180664,
                'VVEL.15_mb': -0.678623378276825,
                'VVEL.1_mb': -0.1237468272447586,
                'VVEL.200_mb': -30.633174896240234,
                'VVEL.20_mb': -0.992418646812439,
                'VVEL.250_mb': -37.93580627441406,
                'VVEL.2_mb': -0.19521072506904602,
                'VVEL.300_mb': -41.55324935913086,
                'VVEL.30_mb': -1.0931512117385864,
                'VVEL.350_mb': -42.527381896972656,
                'VVEL.3_mb': -0.24926133453845978,
                'VVEL.400_mb': -42.605098724365234,
                'VVEL.40_mb': -1.4513099193572998,
                'VVEL.450_mb': -45.23634338378906,
                'VVEL.500_mb': -46.4029426574707,
                'VVEL.50_mb': -1.6289223432540894,
                'VVEL.550_mb': -45.93501281738281,
                'VVEL.5_mb': -0.34052586555480957,
                'VVEL.600_mb': -44.08354187011719,
                'VVEL.650_mb': -44.2235107421875,
                'VVEL.700_mb': -43.722572326660156,
                'VVEL.70_mb': -2.055903911590576,
                'VVEL.750_mb': -41.47764587402344,
                'VVEL.7_mb': -0.38472992181777954,
                'VVEL.800_mb': -37.00529861450195,
                'VVEL.850_mb': -32.66230010986328,
                'VVEL.900_mb': -22.49657440185547,
                'VVEL.925_mb': -17.199811935424805,
                'VVEL.950_mb': -12.476078033447266,
                'VVEL.975_mb': -12.476078033447266,
                'VWSH.PV2e06Km2kgs_surface': -0.12022002041339874,
                'VWSH.PVNeg2e06Km2kgs_surface': -0.11598154902458191,
                'VWSH.tropopause': -0.11271902918815613,
                'WEASD.surface': 0.0,
                'WILT.surface': 0.011799998581409454}

FORECAST_DIFF_MEANS = {'4LFTX.surface': -0.004270300734788179,
                       'ABSV.0.01_mb': 1.012707713243799e-07,
                       'ABSV.0.02_mb': 9.613897589133558e-08,
                       'ABSV.0.04_mb': 5.37567608205336e-08,
                       'ABSV.0.07_mb': 4.063329939185678e-08,
                       'ABSV.0.1_mb': 5.8334727270903386e-08,
                       'ABSV.0.2_mb': 7.339630059277624e-08,
                       'ABSV.0.4_mb': 5.938894531709593e-08,
                       'ABSV.0.7_mb': 3.8178637140617866e-08,
                       'ABSV.1000_mb': -3.0741631462660735e-09,
                       'ABSV.100_mb': 4.561424571392081e-09,
                       'ABSV.10_mb': 3.86827014864366e-09,
                       'ABSV.150_mb': -1.492872492292463e-09,
                       'ABSV.15_mb': 5.364030553067778e-09,
                       'ABSV.1_mb': 2.0637752840002577e-08,
                       'ABSV.200_mb': 9.400707767781569e-09,
                       'ABSV.20_mb': -2.183011327261397e-09,
                       'ABSV.250_mb': 1.4968449590924138e-08,
                       'ABSV.2_mb': 2.521999675764164e-08,
                       'ABSV.300_mb': 1.0956981988385905e-08,
                       'ABSV.30_mb': 5.404976466394373e-09,
                       'ABSV.350_mb': 6.1884928292954555e-09,
                       'ABSV.3_mb': 7.226651277392193e-09,
                       'ABSV.400_mb': 8.528870942825506e-10,
                       'ABSV.40_mb': 5.587419416031025e-09,
                       'ABSV.450_mb': -2.019965528177181e-09,
                       'ABSV.500_mb': 7.095952297975217e-11,
                       'ABSV.50_mb': 5.232642763530748e-09,
                       'ABSV.550_mb': 1.435938590255148e-09,
                       'ABSV.5_mb': 1.026555906946669e-08,
                       'ABSV.600_mb': 7.949061964218629e-10,
                       'ABSV.650_mb': -2.653513409001107e-09,
                       'ABSV.700_mb': 3.786935209859621e-10,
                       'ABSV.70_mb': 2.7734385898980918e-09,
                       'ABSV.750_mb': -1.4102260470494343e-09,
                       'ABSV.7_mb': 1.2551319095166491e-08,
                       'ABSV.800_mb': -2.973331802991197e-09,
                       'ABSV.850_mb': -3.611692278582268e-09,
                       'ABSV.900_mb': -3.35100103221464e-09,
                       'ABSV.925_mb': -3.098131973189311e-09,
                       'ABSV.950_mb': -3.840333384630412e-09,
                       'ABSV.975_mb': -3.7197851465720078e-09,
                       'APTMP.2_m_above_ground': -0.0038128099404275417,
                       'CAPE.180-0_mb_above_ground': -0.2776302695274353,
                       'CAPE.255-0_mb_above_ground': -0.2676713466644287,
                       'CAPE.90-0_mb_above_ground': -0.2523823380470276,
                       'CAPE.surface': -0.25710687041282654,
                       'CFRZR.surface': -6.076990757719614e-06,
                       'CICEP.surface': -5.643565145874163e-06,
                       'CIN.180-0_mb_above_ground': 0.01948234811425209,
                       'CIN.255-0_mb_above_ground': 0.020263181999325752,
                       'CIN.90-0_mb_above_ground': 0.02819650247693062,
                       'CIN.surface': 0.00943751260638237,
                       'CLMR.1000_mb': 1.0782019721489178e-08,
                       'CLMR.100_mb': -3.831335052112504e-31,
                       'CLMR.150_mb': -7.40441943083523e-29,
                       'CLMR.1_hybrid_level': 2.0631869546150483e-08,
                       'CLMR.200_mb': 1.907303931762347e-13,
                       'CLMR.250_mb': 1.0012185525098971e-11,
                       'CLMR.300_mb': 5.045828772171079e-12,
                       'CLMR.350_mb': 3.684644603318965e-11,
                       'CLMR.400_mb': 5.02815705738513e-11,
                       'CLMR.450_mb': 1.2197779453160251e-09,
                       'CLMR.500_mb': 1.1056734194880846e-08,
                       'CLMR.50_mb': 0.0,
                       'CLMR.550_mb': 3.800488457272877e-08,
                       'CLMR.600_mb': 3.8375606692397923e-08,
                       'CLMR.650_mb': 3.056659636513359e-08,
                       'CLMR.700_mb': 2.829593981346079e-08,
                       'CLMR.750_mb': 2.1342208000874052e-08,
                       'CLMR.800_mb': 2.413186983574178e-08,
                       'CLMR.850_mb': 2.1208879985579188e-08,
                       'CLMR.900_mb': -7.773371391017747e-10,
                       'CLMR.925_mb': -1.130729554432719e-08,
                       'CLMR.950_mb': -2.076332172862294e-08,
                       'CLMR.975_mb': 4.417585408589275e-09,
                       'CNWAT.surface': -0.00012481438170652837,
                       'CPOFP.surface': 0.007416673004627228,
                       'CRAIN.surface': 0.00013275771925691515,
                       'CSNOW.surface': 8.867169526638463e-06,
                       'CWAT.entire_atmosphere_considered_as_a_single_layer': 0.00022171747696120292,
                       'DPT.2_m_above_ground': -0.00394068518653512,
                       'DZDT.0.01_mb': -0.0003009417559951544,
                       'DZDT.0.02_mb': -0.00023100968974176794,
                       'DZDT.0.04_mb': -0.0001307553320657462,
                       'DZDT.0.07_mb': -2.7029860575567e-05,
                       'DZDT.0.1_mb': -2.6617286494001746e-05,
                       'DZDT.0.2_mb': -3.946598371840082e-05,
                       'DZDT.0.4_mb': 2.0417317045939853e-06,
                       'DZDT.0.7_mb': 3.1629773729946464e-05,
                       'DZDT.1000_mb': 3.5516475236363476e-06,
                       'DZDT.100_mb': 9.951369975169655e-06,
                       'DZDT.10_mb': 1.6076302927103825e-05,
                       'DZDT.150_mb': 5.367423000279814e-06,
                       'DZDT.15_mb': 1.4375797036336735e-05,
                       'DZDT.1_mb': 1.880843410617672e-05,
                       'DZDT.200_mb': 4.160876414971426e-06,
                       'DZDT.20_mb': 1.5295581761165522e-05,
                       'DZDT.250_mb': 4.141898898524232e-06,
                       'DZDT.2_mb': 2.825533738359809e-05,
                       'DZDT.300_mb': 3.203577762178611e-06,
                       'DZDT.30_mb': 1.1595710020628758e-05,
                       'DZDT.350_mb': 1.875033376563806e-06,
                       'DZDT.3_mb': 2.3069513190421276e-05,
                       'DZDT.400_mb': 9.736345418787096e-07,
                       'DZDT.40_mb': 1.0523713172005955e-05,
                       'DZDT.450_mb': 8.592682547714503e-07,
                       'DZDT.500_mb': -2.2810134225892398e-07,
                       'DZDT.50_mb': 1.1911482943105511e-05,
                       'DZDT.550_mb': -1.5689415704400744e-06,
                       'DZDT.5_mb': 9.243881322618108e-06,
                       'DZDT.600_mb': -1.331221255895798e-06,
                       'DZDT.650_mb': -1.6675728602422168e-06,
                       'DZDT.700_mb': -6.260992790885211e-07,
                       'DZDT.70_mb': 1.3237901839602273e-05,
                       'DZDT.750_mb': 2.1203730682373134e-07,
                       'DZDT.7_mb': 1.3170080819691066e-05,
                       'DZDT.800_mb': 1.1177650094396085e-06,
                       'DZDT.850_mb': 1.796893684513634e-06,
                       'DZDT.900_mb': 1.6396753608205472e-06,
                       'DZDT.925_mb': 1.6604592474322999e-06,
                       'DZDT.950_mb': 2.212770141341025e-06,
                       'DZDT.975_mb': 3.2124378321896074e-06,
                       'FLDCP.surface': -2.6487233739658222e-08,
                       'FRICV.surface': -0.0001194103024317883,
                       'GRLE.1000_mb': 6.873008412400239e-11,
                       'GRLE.100_mb': 5.453445334202556e-11,
                       'GRLE.150_mb': 2.7401872437771146e-10,
                       'GRLE.1_hybrid_level': 1.7839176316702954e-11,
                       'GRLE.200_mb': 5.00362140609667e-10,
                       'GRLE.250_mb': 7.585131966969527e-10,
                       'GRLE.300_mb': 1.1609909700283083e-09,
                       'GRLE.350_mb': 1.5691909993620357e-09,
                       'GRLE.400_mb': 1.6917616196820973e-09,
                       'GRLE.450_mb': 1.5114828277873471e-09,
                       'GRLE.500_mb': 1.4539595083462586e-09,
                       'GRLE.50_mb': 8.053764767720559e-14,
                       'GRLE.550_mb': 1.7312327127427807e-09,
                       'GRLE.600_mb': -3.4448502383988e-10,
                       'GRLE.650_mb': 1.9452087163251974e-10,
                       'GRLE.700_mb': 3.33185257161972e-10,
                       'GRLE.750_mb': 5.0460702283317e-10,
                       'GRLE.800_mb': 4.367008976657871e-10,
                       'GRLE.850_mb': 8.71326483187218e-11,
                       'GRLE.900_mb': 9.375609316686351e-11,
                       'GRLE.925_mb': 8.677622509445371e-11,
                       'GRLE.950_mb': -3.662407876969809e-11,
                       'GRLE.975_mb': -3.195272102463065e-10,
                       'GUST.surface': -0.0036643201019614935,
                       'HCDC.high_cloud_layer': 0.02362056076526642,
                       'HGT.0.01_mb': -0.0140953678637743,
                       'HGT.0.02_mb': 2.526156187057495,
                       'HGT.0.04_mb': 5.382329940795898,
                       'HGT.0.07_mb': 6.702187538146973,
                       'HGT.0.1_mb': 7.05533504486084,
                       'HGT.0.2_mb': 7.3162407875061035,
                       'HGT.0.4_mb': 6.802091121673584,
                       'HGT.0.7_mb': 5.514425277709961,
                       'HGT.0C_isotherm': 0.4577646851539612,
                       'HGT.1000_mb': 0.2576216459274292,
                       'HGT.100_mb': -0.07974879443645477,
                       'HGT.10_mb': -0.11389719694852829,
                       'HGT.150_mb': -0.04644734784960747,
                       'HGT.15_mb': -0.17237603664398193,
                       'HGT.1_mb': 4.343949794769287,
                       'HGT.200_mb': 0.05887987092137337,
                       'HGT.20_mb': -0.1773812621831894,
                       'HGT.250_mb': 0.1551133394241333,
                       'HGT.2_mb': 2.050703525543213,
                       'HGT.300_mb': 0.20082053542137146,
                       'HGT.30_mb': -0.16660627722740173,
                       'HGT.350_mb': 0.2216712385416031,
                       'HGT.3_mb': 1.0678340196609497,
                       'HGT.400_mb': 0.23480819165706635,
                       'HGT.40_mb': -0.13437235355377197,
                       'HGT.450_mb': 0.24548950791358948,
                       'HGT.500_mb': 0.25352993607521057,
                       'HGT.50_mb': -0.10571625828742981,
                       'HGT.550_mb': 0.25738725066185,
                       'HGT.5_mb': 0.28974929451942444,
                       'HGT.600_mb': 0.2574498653411865,
                       'HGT.650_mb': 0.2566153407096863,
                       'HGT.700_mb': 0.25458788871765137,
                       'HGT.70_mb': -0.07580751180648804,
                       'HGT.750_mb': 0.2548031508922577,
                       'HGT.7_mb': 0.02685244008898735,
                       'HGT.800_mb': 0.2566249966621399,
                       'HGT.850_mb': 0.2579844295978546,
                       'HGT.900_mb': 0.2573854327201843,
                       'HGT.925_mb': 0.2569890320301056,
                       'HGT.950_mb': 0.2565078139305115,
                       'HGT.975_mb': 0.25616034865379333,
                       'HGT.PV2e06Km2kgs_surface': -4.801962852478027,
                       'HGT.PVNeg2e06Km2kgs_surface': -5.614409923553467,
                       'HGT.cloud_ceiling': -70.77620697021484,
                       'HGT.highest_tropospheric_freezing_level': -0.07828786969184875,
                       'HGT.max_wind': -0.20198653638362885,
                       'HGT.surface': 0.0,
                       'HGT.tropopause': 0.22622117400169373,
                       'HINDEX.surface': 0.001198896556161344,
                       'HLCY.3000-0_m_above_ground': -0.03796669840812683,
                       'HPBL.surface': -0.4222676455974579,
                       'ICAHT.max_wind': -0.35408174991607666,
                       'ICAHT.tropopause': -0.04587944597005844,
                       'ICEC.surface': 0.0,
                       'ICEG.10_m_above_mean_sea_level': 2.760471018437016e-10,
                       'ICETK.surface': -1.2243857781868428e-05,
                       'ICETMP.surface': -0.030997246503829956,
                       'ICMR.1000_mb': 2.516392871854123e-09,
                       'ICMR.100_mb': 5.108844597367934e-11,
                       'ICMR.150_mb': 3.401986248263711e-09,
                       'ICMR.1_hybrid_level': -1.8304532334312285e-09,
                       'ICMR.200_mb': 1.1688832124434612e-08,
                       'ICMR.250_mb': 1.8284829650383472e-08,
                       'ICMR.300_mb': 2.0536319311759144e-08,
                       'ICMR.350_mb': 2.0014681467728224e-08,
                       'ICMR.400_mb': 2.0264506517264635e-08,
                       'ICMR.450_mb': 2.0420239721374855e-08,
                       'ICMR.500_mb': 2.0805751788088855e-08,
                       'ICMR.50_mb': -1.2844538800627081e-11,
                       'ICMR.550_mb': 1.8371155263707806e-08,
                       'ICMR.600_mb': 1.266795734977677e-08,
                       'ICMR.650_mb': 1.2789469039375945e-08,
                       'ICMR.700_mb': 9.316463156494592e-09,
                       'ICMR.750_mb': 6.4429732660187256e-09,
                       'ICMR.800_mb': 3.3075442384955522e-09,
                       'ICMR.850_mb': 2.5780031442934614e-09,
                       'ICMR.900_mb': 1.946186101164926e-09,
                       'ICMR.925_mb': 2.4295926381867616e-10,
                       'ICMR.950_mb': -6.287014797656809e-10,
                       'ICMR.975_mb': -6.624709114610994e-10,
                       'LAND.surface': 0.0,
                       'LCDC.low_cloud_layer': -0.0664130300283432,
                       'LFTX.surface': 0.0010654065990820527,
                       'MCDC.middle_cloud_layer': 0.04421597346663475,
                       'MSLET.mean_sea_level': 3.560657262802124,
                       'O3MR.0.01_mb': 2.3559697595598728e-11,
                       'O3MR.0.02_mb': 1.0038987002802813e-10,
                       'O3MR.0.04_mb': 1.196853033347267e-10,
                       'O3MR.0.07_mb': 5.07878877842316e-11,
                       'O3MR.0.1_mb': -4.049555829555018e-11,
                       'O3MR.0.2_mb': -4.2604600403173265e-10,
                       'O3MR.0.4_mb': -8.337923129708713e-10,
                       'O3MR.0.7_mb': -1.7176814415265085e-09,
                       'O3MR.1000_mb': 9.098004467855692e-13,
                       'O3MR.100_mb': 1.990459741474382e-10,
                       'O3MR.10_mb': 4.984698209753446e-10,
                       'O3MR.150_mb': 2.3024710610330956e-11,
                       'O3MR.15_mb': 2.315497932281474e-10,
                       'O3MR.1_mb': -3.124516201324923e-09,
                       'O3MR.200_mb': 1.4185326524529529e-11,
                       'O3MR.20_mb': 6.280767017585731e-10,
                       'O3MR.250_mb': -1.365793589336306e-10,
                       'O3MR.2_mb': -3.152146321738769e-09,
                       'O3MR.300_mb': -7.144345531839846e-11,
                       'O3MR.30_mb': 5.946305253745621e-11,
                       'O3MR.350_mb': -2.339085869440538e-11,
                       'O3MR.3_mb': -2.8073108282455905e-09,
                       'O3MR.400_mb': 2.105092792789587e-12,
                       'O3MR.40_mb': -5.944302688964953e-11,
                       'O3MR.450_mb': 1.815260268489549e-11,
                       'O3MR.500_mb': 2.2329785590025075e-11,
                       'O3MR.50_mb': 1.874597560513891e-10,
                       'O3MR.550_mb': 1.685236498960574e-11,
                       'O3MR.5_mb': -1.926999448897959e-09,
                       'O3MR.600_mb': 9.960413570320181e-12,
                       'O3MR.650_mb': 6.446869080245499e-12,
                       'O3MR.700_mb': 5.373427397481478e-12,
                       'O3MR.70_mb': 3.2565475316381765e-10,
                       'O3MR.750_mb': 4.107842538347839e-12,
                       'O3MR.7_mb': -4.779655560227525e-10,
                       'O3MR.800_mb': 1.970339256335274e-12,
                       'O3MR.850_mb': 2.1789579689179828e-12,
                       'O3MR.900_mb': 3.1542901970937898e-12,
                       'O3MR.925_mb': 2.6232876548099027e-12,
                       'O3MR.950_mb': 2.493129617683887e-12,
                       'O3MR.975_mb': 1.9119805565182002e-12,
                       'PLPL.255-0_mb_above_ground': 1.6030089855194092,
                       'POT.0.995_sigma_level': -0.006210416089743376,
                       'PRATE.surface': 4.290363264658481e-08,
                       'PRES.80_m_above_ground': 2.7498934268951416,
                       'PRES.PV2e06Km2kgs_surface': 14.020344734191895,
                       'PRES.PVNeg2e06Km2kgs_surface': 18.83201026916504,
                       'PRES.max_wind': 3.100292921066284,
                       'PRES.surface': 2.7935266494750977,
                       'PRES.tropopause': -3.3280720710754395,
                       'PRMSL.mean_sea_level': 3.5805294513702393,
                       'PWAT.entire_atmosphere_considered_as_a_single_layer': 0.02024807408452034,
                       'REFC.entire_atmosphere': 0.0060662636533379555,
                       'REFD.1000_m_above_ground': 0.010915928520262241,
                       'REFD.1_hybrid_level': 0.0076492661610245705,
                       'REFD.2_hybrid_level': 0.007345000747591257,
                       'REFD.4000_m_above_ground': 0.012802517972886562,
                       'RH.0.01_mb': 0.0005082757561467588,
                       'RH.0.02_mb': 0.0007671251660212874,
                       'RH.0.04_mb': 0.00019051834533456713,
                       'RH.0.07_mb': 1.5341469179475098e-06,
                       'RH.0.1_mb': 1.655447512405317e-08,
                       'RH.0.2_mb': 0.0,
                       'RH.0.33-1_sigma_layer': 0.04888824746012688,
                       'RH.0.44-0.72_sigma_layer': 0.07272068411111832,
                       'RH.0.44-1_sigma_layer': 0.03890933468937874,
                       'RH.0.4_mb': 0.0,
                       'RH.0.72-0.94_sigma_layer': 0.027126049622893333,
                       'RH.0.7_mb': 0.0,
                       'RH.0.995_sigma_level': 0.01401371881365776,
                       'RH.0C_isotherm': 0.06803315877914429,
                       'RH.1000_mb': 0.0036976714618504047,
                       'RH.100_mb': -0.02002529241144657,
                       'RH.10_mb': -0.003960553091019392,
                       'RH.150_mb': 0.03432504087686539,
                       'RH.15_mb': -0.0031592734158039093,
                       'RH.1_mb': 4.036592420166512e-16,
                       'RH.200_mb': 0.06110181659460068,
                       'RH.20_mb': 0.003750154282897711,
                       'RH.250_mb': 0.07238519936800003,
                       'RH.2_m_above_ground': 0.009738845750689507,
                       'RH.2_mb': -9.493801189819351e-05,
                       'RH.30-0_mb_above_ground': 0.004717867821455002,
                       'RH.300_mb': 0.07823846489191055,
                       'RH.30_mb': 0.009532139636576176,
                       'RH.350_mb': 0.089761883020401,
                       'RH.3_mb': -0.0003291932516731322,
                       'RH.400_mb': 0.09728619456291199,
                       'RH.40_mb': 0.011037970893085003,
                       'RH.450_mb': 0.09510812163352966,
                       'RH.500_mb': 0.09339982271194458,
                       'RH.50_mb': 0.007493643090128899,
                       'RH.550_mb': 0.08607340604066849,
                       'RH.5_mb': -0.0016368691576644778,
                       'RH.600_mb': 0.07013251632452011,
                       'RH.650_mb': 0.06076310575008392,
                       'RH.700_mb': 0.051826030015945435,
                       'RH.70_mb': 0.003585121827200055,
                       'RH.750_mb': 0.039931781589984894,
                       'RH.7_mb': -0.0038555809296667576,
                       'RH.800_mb': 0.04107653722167015,
                       'RH.850_mb': 0.02409450337290764,
                       'RH.900_mb': 0.004852749407291412,
                       'RH.925_mb': 0.00908330362290144,
                       'RH.950_mb': 0.003699077060446143,
                       'RH.975_mb': -0.0017346158856526017,
                       'RH.entire_atmosphere_considered_as_a_single_layer': -0.004877053201198578,
                       'RH.highest_tropospheric_freezing_level': 0.08401080220937729,
                       'RWMR.1000_mb': 1.4761026845278025e-09,
                       'RWMR.100_mb': 3.0383105699329643e-14,
                       'RWMR.150_mb': 3.582240298664885e-13,
                       'RWMR.1_hybrid_level': 9.117326449370466e-09,
                       'RWMR.200_mb': -1.1322214189422516e-13,
                       'RWMR.250_mb': 7.657059665142074e-13,
                       'RWMR.300_mb': 1.612877447701097e-13,
                       'RWMR.350_mb': 1.7694850305057658e-13,
                       'RWMR.400_mb': -8.452626077369574e-13,
                       'RWMR.450_mb': 4.967093576724313e-12,
                       'RWMR.500_mb': 1.0248915605082232e-10,
                       'RWMR.50_mb': -1.1222292761953537e-13,
                       'RWMR.550_mb': 2.398894194399759e-09,
                       'RWMR.600_mb': 1.0188172083758218e-08,
                       'RWMR.650_mb': 7.99033816889505e-09,
                       'RWMR.700_mb': 7.206495400424728e-09,
                       'RWMR.750_mb': 7.794495715529592e-09,
                       'RWMR.800_mb': 9.44009581616001e-09,
                       'RWMR.850_mb': 1.0334186839600079e-08,
                       'RWMR.900_mb': 8.961681174923797e-09,
                       'RWMR.925_mb': 8.27713098061622e-09,
                       'RWMR.950_mb': 6.9669359170632106e-09,
                       'RWMR.975_mb': 4.7408565961859495e-09,
                       'SFCR.surface': -7.707737381679181e-07,
                       'SNMR.1000_mb': -4.900409592001331e-11,
                       'SNMR.100_mb': 1.1051121823202337e-11,
                       'SNMR.150_mb': 4.6424053490312644e-10,
                       'SNMR.1_hybrid_level': 5.713241879590214e-09,
                       'SNMR.200_mb': 8.639437498736413e-10,
                       'SNMR.250_mb': 2.721831204866021e-09,
                       'SNMR.300_mb': 6.020818066332367e-09,
                       'SNMR.350_mb': 8.934818218619967e-09,
                       'SNMR.400_mb': 1.0663314675696256e-08,
                       'SNMR.450_mb': 1.1799030197323646e-08,
                       'SNMR.500_mb': 1.3000137855101457e-08,
                       'SNMR.50_mb': 5.486972028535646e-14,
                       'SNMR.550_mb': 1.2367297408388822e-08,
                       'SNMR.600_mb': 3.2791593884695658e-09,
                       'SNMR.650_mb': 7.0688543907238e-09,
                       'SNMR.700_mb': 1.2470179555634786e-08,
                       'SNMR.750_mb': 1.3866104708881721e-08,
                       'SNMR.800_mb': 1.1915425091046927e-08,
                       'SNMR.850_mb': 8.704984288954165e-09,
                       'SNMR.900_mb': 7.898904641479021e-09,
                       'SNMR.925_mb': 7.454823425234736e-09,
                       'SNMR.950_mb': 6.658786855240351e-09,
                       'SNMR.975_mb': 1.377253089351882e-09,
                       'SNOD.surface': -0.00021842554269824177,
                       'SOILL.0-0.1_m_below_ground': 4.335659832577221e-05,
                       'SOILL.0.1-0.4_m_below_ground': 7.178839041444007e-06,
                       'SOILL.0.4-1_m_below_ground': -7.88498866199916e-08,
                       'SOILL.1-2_m_below_ground': -2.534844725232688e-07,
                       'SOILW.0-0.1_m_below_ground': -5.083116047899239e-05,
                       'SOILW.0.1-0.4_m_below_ground': -1.9272292774985544e-05,
                       'SOILW.0.4-1_m_below_ground': -1.6536474504391663e-05,
                       'SOILW.1-2_m_below_ground': -4.55151530331932e-06,
                       'SOTYP.surface': 0.0,
                       'SPFH.0.01_mb': 4.537182629604786e-09,
                       'SPFH.0.02_mb': 4.990664770332387e-09,
                       'SPFH.0.04_mb': 1.5060587221782384e-09,
                       'SPFH.0.07_mb': 1.2311450470203766e-10,
                       'SPFH.0.1_mb': 2.89328366820385e-10,
                       'SPFH.0.2_mb': 6.187275136682047e-10,
                       'SPFH.0.4_mb': 6.074460934257786e-10,
                       'SPFH.0.7_mb': 4.863690561407452e-10,
                       'SPFH.1000_mb': 1.5309086620618473e-06,
                       'SPFH.100_mb': 5.78997350064725e-10,
                       'SPFH.10_mb': 1.433528209332513e-11,
                       'SPFH.150_mb': 5.22188736695739e-10,
                       'SPFH.15_mb': -1.7418714040595695e-11,
                       'SPFH.1_mb': 4.3505629654383426e-10,
                       'SPFH.200_mb': 9.53327727870601e-09,
                       'SPFH.20_mb': 6.257273865717394e-11,
                       'SPFH.250_mb': 8.58692246197279e-08,
                       'SPFH.2_m_above_ground': 9.384860391037364e-07,
                       'SPFH.2_mb': 3.5922750885042376e-10,
                       'SPFH.30-0_mb_above_ground': 1.4869700635244953e-06,
                       'SPFH.300_mb': 3.682592364384618e-07,
                       'SPFH.30_mb': 1.5575517264831973e-10,
                       'SPFH.350_mb': 9.684265478426823e-07,
                       'SPFH.3_mb': 3.3414079836369126e-10,
                       'SPFH.400_mb': 1.7988338640861912e-06,
                       'SPFH.40_mb': 1.4006183712833575e-10,
                       'SPFH.450_mb': 2.8032857244397746e-06,
                       'SPFH.500_mb': 3.7454180983331753e-06,
                       'SPFH.50_mb': 5.303317160421095e-11,
                       'SPFH.550_mb': 4.200519015284954e-06,
                       'SPFH.5_mb': 2.5424123917261454e-10,
                       'SPFH.600_mb': 4.487548267206876e-06,
                       'SPFH.650_mb': 4.658338639274007e-06,
                       'SPFH.700_mb': 4.29771353083197e-06,
                       'SPFH.70_mb': 8.194488143598022e-11,
                       'SPFH.750_mb': 3.6514354633254698e-06,
                       'SPFH.7_mb': 1.2378598146511877e-10,
                       'SPFH.800_mb': 3.7186066492722603e-06,
                       'SPFH.80_m_above_ground': 1.3877107676307787e-06,
                       'SPFH.850_mb': 2.5219917461072328e-06,
                       'SPFH.900_mb': 9.009198151943565e-07,
                       'SPFH.925_mb': 1.3899494888391928e-06,
                       'SPFH.950_mb': 1.7880403220260632e-06,
                       'SPFH.975_mb': 1.7256448927582824e-06,
                       'SUNSD.surface': 318.5795593261719,
                       'TCDC.1000_mb': -0.012854021973907948,
                       'TCDC.100_mb': -0.01252327673137188,
                       'TCDC.150_mb': 0.010967738926410675,
                       'TCDC.200_mb': 0.031799446791410446,
                       'TCDC.250_mb': 0.04264000430703163,
                       'TCDC.300_mb': 0.04012405872344971,
                       'TCDC.350_mb': 0.03602732717990875,
                       'TCDC.400_mb': 0.03505050018429756,
                       'TCDC.450_mb': 0.03471551090478897,
                       'TCDC.500_mb': 0.03600519523024559,
                       'TCDC.50_mb': 0.0037033511325716972,
                       'TCDC.550_mb': 0.03900446370244026,
                       'TCDC.600_mb': 0.03467598930001259,
                       'TCDC.650_mb': 0.02329070493578911,
                       'TCDC.700_mb': 0.015189542435109615,
                       'TCDC.750_mb': 0.008832317776978016,
                       'TCDC.800_mb': 0.007832186296582222,
                       'TCDC.850_mb': 0.017214110121130943,
                       'TCDC.900_mb': 0.00664158072322607,
                       'TCDC.925_mb': -0.0004221618873998523,
                       'TCDC.950_mb': -0.022871775552630424,
                       'TCDC.975_mb': -0.02656298503279686,
                       'TCDC.entire_atmosphere': -0.035212691873311996,
                       'TMP.0.01_mb': -0.10619357973337173,
                       'TMP.0.02_mb': -0.16137319803237915,
                       'TMP.0.04_mb': -0.1131967306137085,
                       'TMP.0.07_mb': -0.047867219895124435,
                       'TMP.0.1_mb': -0.02574053779244423,
                       'TMP.0.2_mb': -7.334918336709961e-05,
                       'TMP.0.4_mb': 0.053737666457891464,
                       'TMP.0.7_mb': 0.10074916481971741,
                       'TMP.0.995_sigma_level': -0.003664680989459157,
                       'TMP.1000_mb': -0.0018726307898759842,
                       'TMP.100_m_above_ground': -0.0004445863305591047,
                       'TMP.100_mb': 0.0021858334075659513,
                       'TMP.10_mb': 0.008729980327188969,
                       'TMP.150_mb': -0.00838168989866972,
                       'TMP.15_mb': 0.0017120796255767345,
                       'TMP.1829_m_above_mean_sea_level': 0.002908392809331417,
                       'TMP.1_mb': 0.11915861070156097,
                       'TMP.200_mb': -0.01575014926493168,
                       'TMP.20_mb': 6.057238351786509e-05,
                       'TMP.250_mb': -0.011735585518181324,
                       'TMP.2743_m_above_mean_sea_level': 0.0020449096336960793,
                       'TMP.2_m_above_ground': -0.003901371266692877,
                       'TMP.2_mb': 0.09749185293912888,
                       'TMP.30-0_mb_above_ground': -0.0002549694909248501,
                       'TMP.300_mb': -0.005955314729362726,
                       'TMP.30_mb': -0.0023280621971935034,
                       'TMP.350_mb': -0.0039015880320221186,
                       'TMP.3658_m_above_mean_sea_level': 0.0008241707109846175,
                       'TMP.3_mb': 0.06955172121524811,
                       'TMP.400_mb': -0.003425192553550005,
                       'TMP.40_mb': -0.004648867528885603,
                       'TMP.450_mb': -0.0034064629580825567,
                       'TMP.500_mb': -0.0026933890767395496,
                       'TMP.50_mb': -0.003771539544686675,
                       'TMP.550_mb': -0.0013287479523569345,
                       'TMP.5_mb': 0.03577893227338791,
                       'TMP.600_mb': -0.00038604295696131885,
                       'TMP.650_mb': 0.00014068956079427153,
                       'TMP.700_mb': -0.00030539146973751485,
                       'TMP.70_mb': -0.00242401659488678,
                       'TMP.750_mb': -0.0010996899800375104,
                       'TMP.7_mb': 0.01945437490940094,
                       'TMP.800_mb': -0.001722839311696589,
                       'TMP.80_m_above_ground': -0.001484437845647335,
                       'TMP.850_mb': -0.00048599796718917787,
                       'TMP.900_mb': 0.0007460825145244598,
                       'TMP.925_mb': 0.0006296070059761405,
                       'TMP.950_mb': 0.0012161198537796736,
                       'TMP.975_mb': 0.0007044244557619095,
                       'TMP.PV2e06Km2kgs_surface': 0.007640821393579245,
                       'TMP.PVNeg2e06Km2kgs_surface': 0.009945756755769253,
                       'TMP.max_wind': -0.009108039550483227,
                       'TMP.surface': -0.0017400749493390322,
                       'TMP.tropopause': -0.00015264545800164342,
                       'TOZNE.entire_atmosphere_considered_as_a_single_layer': 0.0015621250495314598,
                       'TSOIL.0-0.1_m_below_ground': 0.005314151756465435,
                       'TSOIL.0.1-0.4_m_below_ground': 0.0032757518347352743,
                       'TSOIL.0.4-1_m_below_ground': 0.0017519139219075441,
                       'TSOIL.1-2_m_below_ground': 0.000993108144029975,
                       'UGRD.0.01_mb': -0.02234594337642193,
                       'UGRD.0.02_mb': -0.02031794562935829,
                       'UGRD.0.04_mb': -0.028356024995446205,
                       'UGRD.0.07_mb': -0.02823147177696228,
                       'UGRD.0.1_mb': -0.045367531478405,
                       'UGRD.0.2_mb': -0.06118034943938255,
                       'UGRD.0.4_mb': -0.07129373401403427,
                       'UGRD.0.7_mb': -0.03666146472096443,
                       'UGRD.0.995_sigma_level': -0.0071721733547747135,
                       'UGRD.1000_mb': -0.006170141976326704,
                       'UGRD.100_m_above_ground': -0.008441323414444923,
                       'UGRD.100_mb': -0.0015566381625831127,
                       'UGRD.10_m_above_ground': -0.005615572445094585,
                       'UGRD.10_mb': 0.017307884991168976,
                       'UGRD.150_mb': -0.002065758453682065,
                       'UGRD.15_mb': 0.01211612205952406,
                       'UGRD.1829_m_above_mean_sea_level': -0.012426906265318394,
                       'UGRD.1_mb': -0.01852951943874359,
                       'UGRD.200_mb': -0.002441411605104804,
                       'UGRD.20_m_above_ground': -0.006090952083468437,
                       'UGRD.20_mb': 0.0107628358528018,
                       'UGRD.250_mb': 0.0007196527440100908,
                       'UGRD.2743_m_above_mean_sea_level': -0.01244858093559742,
                       'UGRD.2_mb': -0.004027244634926319,
                       'UGRD.30-0_mb_above_ground': -0.008479978889226913,
                       'UGRD.300_mb': -0.0008379657519981265,
                       'UGRD.30_m_above_ground': -0.0066262963227927685,
                       'UGRD.30_mb': -0.0003520487807691097,
                       'UGRD.350_mb': -0.006137436255812645,
                       'UGRD.3658_m_above_mean_sea_level': -0.013828108087182045,
                       'UGRD.3_mb': 0.01654074154794216,
                       'UGRD.400_mb': -0.010378675535321236,
                       'UGRD.40_m_above_ground': -0.0069701834581792355,
                       'UGRD.40_mb': -0.005833669565618038,
                       'UGRD.450_mb': -0.012338370084762573,
                       'UGRD.500_mb': -0.011551089584827423,
                       'UGRD.50_m_above_ground': -0.007307265419512987,
                       'UGRD.50_mb': -0.006021288223564625,
                       'UGRD.550_mb': -0.012161522172391415,
                       'UGRD.5_mb': 0.020555131137371063,
                       'UGRD.600_mb': -0.012549073435366154,
                       'UGRD.650_mb': -0.011773056350648403,
                       'UGRD.700_mb': -0.01198277436196804,
                       'UGRD.70_mb': 0.0025889126118272543,
                       'UGRD.750_mb': -0.011412452906370163,
                       'UGRD.7_mb': 0.015151187777519226,
                       'UGRD.800_mb': -0.011020810343325138,
                       'UGRD.80_m_above_ground': -0.008073213510215282,
                       'UGRD.850_mb': -0.010833235457539558,
                       'UGRD.900_mb': -0.01105566881597042,
                       'UGRD.925_mb': -0.01088798139244318,
                       'UGRD.950_mb': -0.009913241490721703,
                       'UGRD.975_mb': -0.0077225943095982075,
                       'UGRD.PV2e06Km2kgs_surface': -0.013476821593940258,
                       'UGRD.PVNeg2e06Km2kgs_surface': -0.006950373761355877,
                       'UGRD.max_wind': -0.01904112845659256,
                       'UGRD.planetary_boundary_layer': -0.007906843908131123,
                       'UGRD.tropopause': -0.000929103116504848,
                       'USTM.6000-0_m_above_ground': -0.010745752602815628,
                       'VEG.surface': 0.007806877605617046,
                       'VGRD.0.01_mb': -0.0327279195189476,
                       'VGRD.0.02_mb': -0.047404687851667404,
                       'VGRD.0.04_mb': -0.03719502314925194,
                       'VGRD.0.07_mb': 0.0010199908865615726,
                       'VGRD.0.1_mb': 0.005251633003354073,
                       'VGRD.0.2_mb': 0.01778336986899376,
                       'VGRD.0.4_mb': 0.017922790721058846,
                       'VGRD.0.7_mb': 0.013325072824954987,
                       'VGRD.0.995_sigma_level': 0.0002876341750379652,
                       'VGRD.1000_mb': -0.00017957290401682258,
                       'VGRD.100_m_above_ground': 0.00032377176103182137,
                       'VGRD.100_mb': -0.0014104369329288602,
                       'VGRD.10_m_above_ground': 0.00010141904931515455,
                       'VGRD.10_mb': 0.0032272569369524717,
                       'VGRD.150_mb': 0.0012144973734393716,
                       'VGRD.15_mb': -0.00024285643303301185,
                       'VGRD.1829_m_above_mean_sea_level': -0.0006497412105090916,
                       'VGRD.1_mb': -0.003329325933009386,
                       'VGRD.200_mb': -0.003254384035244584,
                       'VGRD.20_m_above_ground': 0.00017844657122623175,
                       'VGRD.20_mb': -0.0038450858555734158,
                       'VGRD.250_mb': -0.0027796225622296333,
                       'VGRD.2743_m_above_mean_sea_level': -0.0019262786954641342,
                       'VGRD.2_mb': 0.0020993321668356657,
                       'VGRD.30-0_mb_above_ground': 0.00038133046473376453,
                       'VGRD.300_mb': -0.00020332475833129138,
                       'VGRD.30_m_above_ground': 0.00025331112556159496,
                       'VGRD.30_mb': 0.00020710199896711856,
                       'VGRD.350_mb': -5.9853911807294935e-05,
                       'VGRD.3658_m_above_mean_sea_level': 0.0008465611608698964,
                       'VGRD.3_mb': -0.0007598957163281739,
                       'VGRD.400_mb': 0.002015252597630024,
                       'VGRD.40_m_above_ground': 0.00032010438735596836,
                       'VGRD.40_mb': -0.00038702759775333107,
                       'VGRD.450_mb': 0.0027447689790278673,
                       'VGRD.500_mb': 0.002650879556313157,
                       'VGRD.50_m_above_ground': 0.00033882827847264707,
                       'VGRD.50_mb': -0.0031287253368645906,
                       'VGRD.550_mb': 0.002243666211143136,
                       'VGRD.5_mb': -0.0026478637009859085,
                       'VGRD.600_mb': 0.0014746758388355374,
                       'VGRD.650_mb': 0.00014297653979156166,
                       'VGRD.700_mb': -0.00017211631347890943,
                       'VGRD.70_mb': 0.004100202117115259,
                       'VGRD.750_mb': 8.287537639262155e-05,
                       'VGRD.7_mb': 0.000464920187368989,
                       'VGRD.800_mb': 0.0002132561494363472,
                       'VGRD.80_m_above_ground': 0.00034412884269841015,
                       'VGRD.850_mb': 4.321188316680491e-05,
                       'VGRD.900_mb': -3.112809281446971e-05,
                       'VGRD.925_mb': -0.0002691304835025221,
                       'VGRD.950_mb': -0.00035546772414818406,
                       'VGRD.975_mb': -0.0005383611423894763,
                       'VGRD.PV2e06Km2kgs_surface': -0.019005220383405685,
                       'VGRD.PVNeg2e06Km2kgs_surface': 0.010493488982319832,
                       'VGRD.max_wind': -0.0037500127218663692,
                       'VGRD.planetary_boundary_layer': 0.000557602965272963,
                       'VGRD.tropopause': -0.0020721787586808205,
                       'VIS.surface': 5.997822284698486,
                       'VRATE.planetary_boundary_layer': -2.958582878112793,
                       'VSTM.6000-0_m_above_ground': 0.0014604863245040178,
                       'VVEL.0.01_mb': 7.959506120869264e-08,
                       'VVEL.0.02_mb': 8.591534594870609e-08,
                       'VVEL.0.04_mb': 8.776116544595425e-08,
                       'VVEL.0.07_mb': 3.66088812597809e-08,
                       'VVEL.0.1_mb': 5.299035876760172e-08,
                       'VVEL.0.2_mb': 1.080463576386137e-07,
                       'VVEL.0.4_mb': -3.642038848283846e-08,
                       'VVEL.0.7_mb': -3.223735802748706e-07,
                       'VVEL.0.995_sigma_level': -2.8282591301831417e-05,
                       'VVEL.1000_mb': -3.0905113817425445e-05,
                       'VVEL.100_mb': -1.6800788216642104e-05,
                       'VVEL.10_mb': -2.5049848773051053e-06,
                       'VVEL.150_mb': -1.4467344954027794e-05,
                       'VVEL.15_mb': -3.6517826629278716e-06,
                       'VVEL.1_mb': -3.0274304663180374e-07,
                       'VVEL.200_mb': -1.4731614101037849e-05,
                       'VVEL.20_mb': -5.274511295283446e-06,
                       'VVEL.250_mb': -1.706739749351982e-05,
                       'VVEL.2_mb': -7.637327144038863e-07,
                       'VVEL.300_mb': -1.443827659386443e-05,
                       'VVEL.30_mb': -5.888080977456411e-06,
                       'VVEL.350_mb': -9.198927727993578e-06,
                       'VVEL.3_mb': -9.767047686182195e-07,
                       'VVEL.400_mb': -5.194544428377412e-06,
                       'VVEL.40_mb': -7.3721030275919475e-06,
                       'VVEL.450_mb': -5.543006864172639e-06,
                       'VVEL.500_mb': 1.2929377817272325e-06,
                       'VVEL.50_mb': -1.0173862392548472e-05,
                       'VVEL.550_mb': 1.1359651580278296e-05,
                       'VVEL.5_mb': -6.663859721811605e-07,
                       'VVEL.600_mb': 1.1277101293671876e-05,
                       'VVEL.650_mb': 1.4474829185928684e-05,
                       'VVEL.700_mb': 5.031401542510139e-06,
                       'VVEL.70_mb': -1.5447634723386727e-05,
                       'VVEL.750_mb': -4.692080608492688e-07,
                       'VVEL.7_mb': -1.4445978422372718e-06,
                       'VVEL.800_mb': -7.201726930361474e-06,
                       'VVEL.850_mb': -1.155318932433147e-05,
                       'VVEL.900_mb': -9.01356997928815e-06,
                       'VVEL.925_mb': -8.228188562497962e-06,
                       'VVEL.950_mb': -1.4221092897059862e-05,
                       'VVEL.975_mb': -2.6589030312607065e-05,
                       'VWSH.PV2e06Km2kgs_surface': 3.090425025220611e-06,
                       'VWSH.PVNeg2e06Km2kgs_surface': -2.1715181901527103e-06,
                       'VWSH.tropopause': 2.329283006474725e-06,
                       'WEASD.surface': 0.009397598914802074,
                       'WILT.surface': -8.632069636860251e-08}
FORECAST_DIFF_STD = {'4LFTX.surface': 1.3126723766326904,
                     'ABSV.0.01_mb': 6.025715993018821e-05,
                     'ABSV.0.02_mb': 8.243643242167309e-05,
                     'ABSV.0.04_mb': 0.00012628610420506448,
                     'ABSV.0.07_mb': 0.0001421966153429821,
                     'ABSV.0.1_mb': 0.0001238495169673115,
                     'ABSV.0.2_mb': 9.0011817519553e-05,
                     'ABSV.0.4_mb': 6.37647754047066e-05,
                     'ABSV.0.7_mb': 4.9300786486128345e-05,
                     'ABSV.1000_mb': 5.302311183186248e-05,
                     'ABSV.100_mb': 4.888962575932965e-05,
                     'ABSV.10_mb': 3.504535197862424e-05,
                     'ABSV.150_mb': 5.712999700335786e-05,
                     'ABSV.15_mb': 3.4499291359679773e-05,
                     'ABSV.1_mb': 4.0574675949756056e-05,
                     'ABSV.200_mb': 6.65217376081273e-05,
                     'ABSV.20_mb': 3.230563743272796e-05,
                     'ABSV.250_mb': 8.03296934464015e-05,
                     'ABSV.2_mb': 3.751561962417327e-05,
                     'ABSV.300_mb': 9.480520384386182e-05,
                     'ABSV.30_mb': 3.005628241226077e-05,
                     'ABSV.350_mb': 9.430803038412705e-05,
                     'ABSV.3_mb': 3.161398853990249e-05,
                     'ABSV.400_mb': 8.967773464974016e-05,
                     'ABSV.40_mb': 3.533154813339934e-05,
                     'ABSV.450_mb': 8.334207814186811e-05,
                     'ABSV.500_mb': 7.655758236069232e-05,
                     'ABSV.50_mb': 3.257774005760439e-05,
                     'ABSV.550_mb': 7.256241224240512e-05,
                     'ABSV.5_mb': 3.252559690736234e-05,
                     'ABSV.600_mb': 7.013651338638738e-05,
                     'ABSV.650_mb': 6.871317600598559e-05,
                     'ABSV.700_mb': 6.811608909629285e-05,
                     'ABSV.70_mb': 3.5554887290345505e-05,
                     'ABSV.750_mb': 6.772426422685385e-05,
                     'ABSV.7_mb': 3.157796891173348e-05,
                     'ABSV.800_mb': 6.77152638672851e-05,
                     'ABSV.850_mb': 6.810222839703783e-05,
                     'ABSV.900_mb': 6.768203456886113e-05,
                     'ABSV.925_mb': 6.710697925882414e-05,
                     'ABSV.950_mb': 6.516787107102573e-05,
                     'ABSV.975_mb': 6.000008579576388e-05,
                     'APTMP.2_m_above_ground': 1.9943170547485352,
                     'CAPE.180-0_mb_above_ground': 99.20938110351562,
                     'CAPE.255-0_mb_above_ground': 129.62892150878906,
                     'CAPE.90-0_mb_above_ground': 89.5424575805664,
                     'CAPE.surface': 132.51158142089844,
                     'CFRZR.surface': 0.026185540482401848,
                     'CICEP.surface': 0.011858818121254444,
                     'CIN.180-0_mb_above_ground': 27.997838973999023,
                     'CIN.255-0_mb_above_ground': 27.636171340942383,
                     'CIN.90-0_mb_above_ground': 26.619770050048828,
                     'CIN.surface': 31.495723724365234,
                     'CLMR.1000_mb': 1.5805322618689388e-05,
                     'CLMR.100_mb': 8.167467217424063e-18,
                     'CLMR.150_mb': 0.0,
                     'CLMR.1_hybrid_level': 3.652245504781604e-05,
                     'CLMR.200_mb': 5.7958162713589445e-09,
                     'CLMR.250_mb': 6.446854285968584e-07,
                     'CLMR.300_mb': 1.3633684829983395e-06,
                     'CLMR.350_mb': 2.1786520392197417e-06,
                     'CLMR.400_mb': 3.869953161483863e-06,
                     'CLMR.450_mb': 9.563678759150207e-06,
                     'CLMR.500_mb': 2.394286093476694e-05,
                     'CLMR.50_mb': 0.0,
                     'CLMR.550_mb': 4.287582851247862e-05,
                     'CLMR.600_mb': 4.655531301978044e-05,
                     'CLMR.650_mb': 4.632549826055765e-05,
                     'CLMR.700_mb': 5.147464980836958e-05,
                     'CLMR.750_mb': 5.477818922372535e-05,
                     'CLMR.800_mb': 5.763446824857965e-05,
                     'CLMR.850_mb': 6.584564835065976e-05,
                     'CLMR.900_mb': 6.058227882022038e-05,
                     'CLMR.925_mb': 5.151651203050278e-05,
                     'CLMR.950_mb': 4.2131625377805904e-05,
                     'CLMR.975_mb': 3.174399535055272e-05,
                     'CNWAT.surface': 0.06156281754374504,
                     'CPOFP.surface': 32.09545135498047,
                     'CRAIN.surface': 0.3744134306907654,
                     'CSNOW.surface': 0.22809778153896332,
                     'CWAT.entire_atmosphere_considered_as_a_single_layer': 0.16364936530590057,
                     'DPT.2_m_above_ground': 1.4916988611221313,
                     'DZDT.0.01_mb': 0.11979974061250687,
                     'DZDT.0.02_mb': 0.4713699519634247,
                     'DZDT.0.04_mb': 0.6171557903289795,
                     'DZDT.0.07_mb': 0.5101528167724609,
                     'DZDT.0.1_mb': 0.4362751543521881,
                     'DZDT.0.2_mb': 0.3718782961368561,
                     'DZDT.0.4_mb': 0.2929699718952179,
                     'DZDT.0.7_mb': 0.22942958772182465,
                     'DZDT.1000_mb': 0.009140235371887684,
                     'DZDT.100_mb': 0.03152940422296524,
                     'DZDT.10_mb': 0.06986287236213684,
                     'DZDT.150_mb': 0.03995269164443016,
                     'DZDT.15_mb': 0.06024634465575218,
                     'DZDT.1_mb': 0.19060340523719788,
                     'DZDT.200_mb': 0.047389350831508636,
                     'DZDT.20_mb': 0.053066838532686234,
                     'DZDT.250_mb': 0.052174270153045654,
                     'DZDT.2_mb': 0.144645556807518,
                     'DZDT.300_mb': 0.054591115564107895,
                     'DZDT.30_mb': 0.04313211143016815,
                     'DZDT.350_mb': 0.05371413752436638,
                     'DZDT.3_mb': 0.11729931831359863,
                     'DZDT.400_mb': 0.051879651844501495,
                     'DZDT.40_mb': 0.039460696280002594,
                     'DZDT.450_mb': 0.04960590973496437,
                     'DZDT.500_mb': 0.04754148796200752,
                     'DZDT.50_mb': 0.034688644111156464,
                     'DZDT.550_mb': 0.04645247012376785,
                     'DZDT.5_mb': 0.09765986353158951,
                     'DZDT.600_mb': 0.04628695175051689,
                     'DZDT.650_mb': 0.046078700572252274,
                     'DZDT.700_mb': 0.04543713480234146,
                     'DZDT.70_mb': 0.030831634998321533,
                     'DZDT.750_mb': 0.0439150370657444,
                     'DZDT.7_mb': 0.0805961936712265,
                     'DZDT.800_mb': 0.041130948811769485,
                     'DZDT.850_mb': 0.03660784289240837,
                     'DZDT.900_mb': 0.029425224289298058,
                     'DZDT.925_mb': 0.024463478475809097,
                     'DZDT.950_mb': 0.018692217767238617,
                     'DZDT.975_mb': 0.01299199927598238,
                     'FLDCP.surface': 5.513138148671715e-06,
                     'FRICV.surface': 0.08233615756034851,
                     'GRLE.1000_mb': 5.35809476787108e-07,
                     'GRLE.100_mb': 1.0868387789741973e-06,
                     'GRLE.150_mb': 7.798554179316852e-06,
                     'GRLE.1_hybrid_level': 1.9981675905000884e-06,
                     'GRLE.200_mb': 1.546903331473004e-05,
                     'GRLE.250_mb': 2.3094422431313433e-05,
                     'GRLE.300_mb': 2.9355425795074552e-05,
                     'GRLE.350_mb': 3.3825905120465904e-05,
                     'GRLE.400_mb': 3.714219565154053e-05,
                     'GRLE.450_mb': 3.9498765545431525e-05,
                     'GRLE.500_mb': 4.0409009670838714e-05,
                     'GRLE.50_mb': 1.6572479499821213e-10,
                     'GRLE.550_mb': 3.66024614777416e-05,
                     'GRLE.600_mb': 2.4799393941066228e-05,
                     'GRLE.650_mb': 1.837573836382944e-05,
                     'GRLE.700_mb': 1.2579695066960994e-05,
                     'GRLE.750_mb': 9.122731171373744e-06,
                     'GRLE.800_mb': 6.893856607348425e-06,
                     'GRLE.850_mb': 4.972771421307698e-06,
                     'GRLE.900_mb': 3.4464865166228265e-06,
                     'GRLE.925_mb': 2.82419273389678e-06,
                     'GRLE.950_mb': 2.2452632038039155e-06,
                     'GRLE.975_mb': 1.540733251204074e-06,
                     'GUST.surface': 1.8890324831008911,
                     'HCDC.high_cloud_layer': 33.46564483642578,
                     'HGT.0.01_mb': 268.94366455078125,
                     'HGT.0.02_mb': 234.68234252929688,
                     'HGT.0.04_mb': 171.59848022460938,
                     'HGT.0.07_mb': 146.12245178222656,
                     'HGT.0.1_mb': 136.43795776367188,
                     'HGT.0.2_mb': 117.61910247802734,
                     'HGT.0.4_mb': 98.854248046875,
                     'HGT.0.7_mb': 82.81489562988281,
                     'HGT.0C_isotherm': 179.16488647460938,
                     'HGT.1000_mb': 13.923280715942383,
                     'HGT.100_mb': 11.271500587463379,
                     'HGT.10_mb': 21.764097213745117,
                     'HGT.150_mb': 12.21389102935791,
                     'HGT.15_mb': 18.452104568481445,
                     'HGT.1_mb': 71.9330062866211,
                     'HGT.200_mb': 14.67599105834961,
                     'HGT.20_mb': 16.618999481201172,
                     'HGT.250_mb': 17.351703643798828,
                     'HGT.2_mb': 49.82088851928711,
                     'HGT.300_mb': 18.34412384033203,
                     'HGT.30_mb': 14.54012680053711,
                     'HGT.350_mb': 17.826446533203125,
                     'HGT.3_mb': 39.259037017822266,
                     'HGT.400_mb': 16.626502990722656,
                     'HGT.40_mb': 13.328652381896973,
                     'HGT.450_mb': 15.288420677185059,
                     'HGT.500_mb': 14.063136100769043,
                     'HGT.50_mb': 12.538455963134766,
                     'HGT.550_mb': 13.050878524780273,
                     'HGT.5_mb': 29.756872177124023,
                     'HGT.600_mb': 12.278088569641113,
                     'HGT.650_mb': 11.740633964538574,
                     'HGT.700_mb': 11.443319320678711,
                     'HGT.70_mb': 11.622735977172852,
                     'HGT.750_mb': 11.383077621459961,
                     'HGT.7_mb': 25.432281494140625,
                     'HGT.800_mb': 11.548686981201172,
                     'HGT.850_mb': 11.928025245666504,
                     'HGT.900_mb': 12.499444007873535,
                     'HGT.925_mb': 12.837666511535645,
                     'HGT.950_mb': 13.200100898742676,
                     'HGT.975_mb': 13.574112892150879,
                     'HGT.PV2e06Km2kgs_surface': 1177.294921875,
                     'HGT.PVNeg2e06Km2kgs_surface': 1240.6376953125,
                     'HGT.cloud_ceiling': 7066.38427734375,
                     'HGT.highest_tropospheric_freezing_level': 156.55899047851562,
                     'HGT.max_wind': 1782.688232421875,
                     'HGT.surface': 0.0,
                     'HGT.tropopause': 663.77978515625,
                     'HINDEX.surface': 0.6418148875236511,
                     'HLCY.3000-0_m_above_ground': 42.27859115600586,
                     'HPBL.surface': 385.61309814453125,
                     'ICAHT.max_wind': 1802.5616455078125,
                     'ICAHT.tropopause': 686.8045043945312,
                     'ICEC.surface': 0.0,
                     'ICEG.10_m_above_mean_sea_level': 2.729447032834287e-07,
                     'ICETK.surface': 0.0010316855041310191,
                     'ICETMP.surface': 2.109239101409912,
                     'ICMR.1000_mb': 2.7322359983372735e-06,
                     'ICMR.100_mb': 1.7971041188502568e-06,
                     'ICMR.150_mb': 7.124430794647196e-06,
                     'ICMR.1_hybrid_level': 6.356639005389297e-06,
                     'ICMR.200_mb': 1.2152903764217626e-05,
                     'ICMR.250_mb': 1.8772614566842094e-05,
                     'ICMR.300_mb': 2.4489965653629042e-05,
                     'ICMR.350_mb': 2.7669309929478914e-05,
                     'ICMR.400_mb': 2.903807944676373e-05,
                     'ICMR.450_mb': 2.9169821573304944e-05,
                     'ICMR.500_mb': 2.832600148394704e-05,
                     'ICMR.50_mb': 6.395226126443276e-09,
                     'ICMR.550_mb': 2.626786044856999e-05,
                     'ICMR.600_mb': 2.3395514290314168e-05,
                     'ICMR.650_mb': 2.139396565326024e-05,
                     'ICMR.700_mb': 1.9264141883468255e-05,
                     'ICMR.750_mb': 1.7185706383315846e-05,
                     'ICMR.800_mb': 1.52204684127355e-05,
                     'ICMR.850_mb': 1.324194272456225e-05,
                     'ICMR.900_mb': 1.1168787750648335e-05,
                     'ICMR.925_mb': 1.0061961802421138e-05,
                     'ICMR.950_mb': 8.686854926054366e-06,
                     'ICMR.975_mb': 6.262442184379324e-06,
                     'LAND.surface': 0.0,
                     'LCDC.low_cloud_layer': 28.931262969970703,
                     'LFTX.surface': 1.5783942937850952,
                     'MCDC.middle_cloud_layer': 31.050201416015625,
                     'MSLET.mean_sea_level': 172.13661193847656,
                     'O3MR.0.01_mb': 1.4995880093238156e-08,
                     'O3MR.0.02_mb': 2.1162779972883072e-08,
                     'O3MR.0.04_mb': 3.423702921168115e-08,
                     'O3MR.0.07_mb': 3.672899495654747e-08,
                     'O3MR.0.1_mb': 5.343714448713399e-08,
                     'O3MR.0.2_mb': 7.309425598123198e-08,
                     'O3MR.0.4_mb': 1.0755503865311766e-07,
                     'O3MR.0.7_mb': 1.9034736453704681e-07,
                     'O3MR.1000_mb': 1.4486577493144637e-09,
                     'O3MR.100_mb': 1.530384992065592e-07,
                     'O3MR.10_mb': 2.4370240225835005e-07,
                     'O3MR.150_mb': 9.857161131776593e-08,
                     'O3MR.15_mb': 2.6325338353672123e-07,
                     'O3MR.1_mb': 2.7256777457296266e-07,
                     'O3MR.200_mb': 5.720102080886136e-08,
                     'O3MR.20_mb': 2.7481772235660173e-07,
                     'O3MR.250_mb': 4.394346930780557e-08,
                     'O3MR.2_mb': 3.739617113751592e-07,
                     'O3MR.300_mb': 3.2264193094988514e-08,
                     'O3MR.30_mb': 2.1530628657728812e-07,
                     'O3MR.350_mb': 2.0197010286437944e-08,
                     'O3MR.3_mb': 3.442996217017935e-07,
                     'O3MR.400_mb': 1.3852831770577723e-08,
                     'O3MR.40_mb': 2.1045818243692338e-07,
                     'O3MR.450_mb': 1.0502570368942088e-08,
                     'O3MR.500_mb': 8.171967103010047e-09,
                     'O3MR.50_mb': 1.7784010708510323e-07,
                     'O3MR.550_mb': 6.195366886174725e-09,
                     'O3MR.5_mb': 3.248236737363186e-07,
                     'O3MR.600_mb': 4.759767247008995e-09,
                     'O3MR.650_mb': 3.808800386195799e-09,
                     'O3MR.700_mb': 3.1809956890782587e-09,
                     'O3MR.70_mb': 1.7011052477755584e-07,
                     'O3MR.750_mb': 2.7297404336934505e-09,
                     'O3MR.7_mb': 2.6375576567261305e-07,
                     'O3MR.800_mb': 2.3571296026148048e-09,
                     'O3MR.850_mb': 2.009164612459813e-09,
                     'O3MR.900_mb': 1.7027451670870164e-09,
                     'O3MR.925_mb': 1.5986402202017302e-09,
                     'O3MR.950_mb': 1.5197513247855454e-09,
                     'O3MR.975_mb': 1.4676234671995303e-09,
                     'PLPL.255-0_mb_above_ground': 5698.53466796875,
                     'POT.0.995_sigma_level': 1.450036644935608,
                     'PRATE.surface': 0.00014938136155251414,
                     'PRES.80_m_above_ground': 142.10118103027344,
                     'PRES.PV2e06Km2kgs_surface': 3626.6982421875,
                     'PRES.PVNeg2e06Km2kgs_surface': 4036.42431640625,
                     'PRES.max_wind': 6465.345703125,
                     'PRES.surface': 144.45956420898438,
                     'PRES.tropopause': 1971.22021484375,
                     'PRMSL.mean_sea_level': 175.8999481201172,
                     'PWAT.entire_atmosphere_considered_as_a_single_layer': 1.8925563097000122,
                     'REFC.entire_atmosphere': 12.581792831420898,
                     'REFD.1000_m_above_ground': 11.665071487426758,
                     'REFD.1_hybrid_level': 11.815576553344727,
                     'REFD.2_hybrid_level': 11.800586700439453,
                     'REFD.4000_m_above_ground': 7.969400882720947,
                     'RH.0.01_mb': 0.03562730923295021,
                     'RH.0.02_mb': 0.03589727357029915,
                     'RH.0.04_mb': 0.02251049503684044,
                     'RH.0.07_mb': 0.0015470752259716392,
                     'RH.0.1_mb': 0.00042556526022963226,
                     'RH.0.2_mb': 0.0,
                     'RH.0.33-1_sigma_layer': 8.916050910949707,
                     'RH.0.44-0.72_sigma_layer': 12.957554817199707,
                     'RH.0.44-1_sigma_layer': 7.492092132568359,
                     'RH.0.4_mb': 0.0,
                     'RH.0.72-0.94_sigma_layer': 9.044565200805664,
                     'RH.0.7_mb': 0.0,
                     'RH.0.995_sigma_level': 6.4876275062561035,
                     'RH.0C_isotherm': 12.318730354309082,
                     'RH.1000_mb': 6.571123123168945,
                     'RH.100_mb': 4.9412736892700195,
                     'RH.10_mb': 0.6829763650894165,
                     'RH.150_mb': 8.224861145019531,
                     'RH.15_mb': 1.1545311212539673,
                     'RH.1_mb': 8.914111094782129e-05,
                     'RH.200_mb': 12.888049125671387,
                     'RH.20_mb': 1.5948933362960815,
                     'RH.250_mb': 16.399322509765625,
                     'RH.2_m_above_ground': 6.289666175842285,
                     'RH.2_mb': 0.010170303285121918,
                     'RH.30-0_mb_above_ground': 6.530277729034424,
                     'RH.300_mb': 18.5360164642334,
                     'RH.30_mb': 2.038987636566162,
                     'RH.350_mb': 19.222536087036133,
                     'RH.3_mb': 0.023668210953474045,
                     'RH.400_mb': 19.591779708862305,
                     'RH.40_mb': 2.1178500652313232,
                     'RH.450_mb': 19.556821823120117,
                     'RH.500_mb': 19.178199768066406,
                     'RH.50_mb': 2.094541311264038,
                     'RH.550_mb': 18.584211349487305,
                     'RH.5_mb': 0.1104130744934082,
                     'RH.600_mb': 17.78485679626465,
                     'RH.650_mb': 16.920106887817383,
                     'RH.700_mb': 16.067285537719727,
                     'RH.70_mb': 2.5120623111724854,
                     'RH.750_mb': 15.08820629119873,
                     'RH.7_mb': 0.35890883207321167,
                     'RH.800_mb': 14.070599555969238,
                     'RH.850_mb': 12.3797607421875,
                     'RH.900_mb': 9.777444839477539,
                     'RH.925_mb': 8.666075706481934,
                     'RH.950_mb': 7.808280944824219,
                     'RH.975_mb': 7.069617748260498,
                     'RH.entire_atmosphere_considered_as_a_single_layer': 3.716282606124878,
                     'RH.highest_tropospheric_freezing_level': 12.491055488586426,
                     'RWMR.1000_mb': 1.8144848581869155e-05,
                     'RWMR.100_mb': 1.8496743026119589e-10,
                     'RWMR.150_mb': 2.971700663323418e-10,
                     'RWMR.1_hybrid_level': 2.476369081705343e-05,
                     'RWMR.200_mb': 4.448232060472179e-10,
                     'RWMR.250_mb': 5.519351642391257e-10,
                     'RWMR.300_mb': 5.462972851866255e-10,
                     'RWMR.350_mb': 3.209152721339592e-09,
                     'RWMR.400_mb': 1.0723809396040451e-08,
                     'RWMR.450_mb': 4.727094093937012e-08,
                     'RWMR.500_mb': 1.3370830629355623e-06,
                     'RWMR.50_mb': 5.407925496303534e-11,
                     'RWMR.550_mb': 9.835000128077809e-06,
                     'RWMR.600_mb': 2.522257091186475e-05,
                     'RWMR.650_mb': 2.4394126739935018e-05,
                     'RWMR.700_mb': 2.6052020984934643e-05,
                     'RWMR.750_mb': 2.630646849866025e-05,
                     'RWMR.800_mb': 2.6249481379636563e-05,
                     'RWMR.850_mb': 2.5803292373893782e-05,
                     'RWMR.900_mb': 2.4955439585028216e-05,
                     'RWMR.925_mb': 2.4340799427591264e-05,
                     'RWMR.950_mb': 2.351051807636395e-05,
                     'RWMR.975_mb': 2.225532261945773e-05,
                     'SFCR.surface': 0.00011045699648093432,
                     'SNMR.1000_mb': 4.1245466491091065e-06,
                     'SNMR.100_mb': 6.464239277192974e-07,
                     'SNMR.150_mb': 4.258077751728706e-06,
                     'SNMR.1_hybrid_level': 1.2532274013210554e-05,
                     'SNMR.200_mb': 8.640130545245484e-06,
                     'SNMR.250_mb': 1.3848243725078646e-05,
                     'SNMR.300_mb': 2.0427196432137862e-05,
                     'SNMR.350_mb': 2.7263053198112175e-05,
                     'SNMR.400_mb': 3.3331387385260314e-05,
                     'SNMR.450_mb': 3.791599738178775e-05,
                     'SNMR.500_mb': 4.056760735693388e-05,
                     'SNMR.50_mb': 1.5746504100633274e-10,
                     'SNMR.550_mb': 4.0186674596043304e-05,
                     'SNMR.600_mb': 3.4443775803083554e-05,
                     'SNMR.650_mb': 3.28627647832036e-05,
                     'SNMR.700_mb': 3.0306442567962222e-05,
                     'SNMR.750_mb': 2.75652164418716e-05,
                     'SNMR.800_mb': 2.4455575839965604e-05,
                     'SNMR.850_mb': 2.1639643819071352e-05,
                     'SNMR.900_mb': 1.8815901057678275e-05,
                     'SNMR.925_mb': 1.727005837892648e-05,
                     'SNMR.950_mb': 1.5504394468734972e-05,
                     'SNMR.975_mb': 1.128464919020189e-05,
                     'SNOD.surface': 0.022343305870890617,
                     'SOILL.0-0.1_m_below_ground': 0.005466379225254059,
                     'SOILL.0.1-0.4_m_below_ground': 0.0014944709837436676,
                     'SOILL.0.4-1_m_below_ground': 0.000519513851031661,
                     'SOILL.1-2_m_below_ground': 0.00023747615341562778,
                     'SOILW.0-0.1_m_below_ground': 0.004555790685117245,
                     'SOILW.0.1-0.4_m_below_ground': 0.0014813693705946207,
                     'SOILW.0.4-1_m_below_ground': 0.0005185832851566374,
                     'SOILW.1-2_m_below_ground': 0.00022552869631908834,
                     'SOTYP.surface': 0.0,
                     'SPFH.0.01_mb': 1.0611382350589338e-07,
                     'SPFH.0.02_mb': 1.128733870814358e-07,
                     'SPFH.0.04_mb': 1.0091710578308266e-07,
                     'SPFH.0.07_mb': 8.222236402843919e-08,
                     'SPFH.0.1_mb': 8.785535499100661e-08,
                     'SPFH.0.2_mb': 1.043239308273769e-07,
                     'SPFH.0.4_mb': 1.1689015622096122e-07,
                     'SPFH.0.7_mb': 1.0917362658346974e-07,
                     'SPFH.1000_mb': 0.0005832104943692684,
                     'SPFH.100_mb': 1.033741767741958e-07,
                     'SPFH.10_mb': 9.26032512893471e-08,
                     'SPFH.150_mb': 1.0803793202285306e-06,
                     'SPFH.15_mb': 8.38366887023767e-08,
                     'SPFH.1_mb': 1.0174052533784561e-07,
                     'SPFH.200_mb': 7.950880899443291e-06,
                     'SPFH.20_mb': 7.180680228202618e-08,
                     'SPFH.250_mb': 2.836959538399242e-05,
                     'SPFH.2_m_above_ground': 0.0004908806295134127,
                     'SPFH.2_mb': 1.0234917624529771e-07,
                     'SPFH.30-0_mb_above_ground': 0.0004929894930683076,
                     'SPFH.300_mb': 6.5130356233567e-05,
                     'SPFH.30_mb': 5.992522744691087e-08,
                     'SPFH.350_mb': 0.00011382390948710963,
                     'SPFH.3_mb': 9.36925701466862e-08,
                     'SPFH.400_mb': 0.0001807641237974167,
                     'SPFH.40_mb': 6.124184892541962e-08,
                     'SPFH.450_mb': 0.00026108877500519156,
                     'SPFH.500_mb': 0.00034748835605569184,
                     'SPFH.50_mb': 5.9324307244423835e-08,
                     'SPFH.550_mb': 0.00043743065907619894,
                     'SPFH.5_mb': 9.856838545374558e-08,
                     'SPFH.600_mb': 0.0005226543289609253,
                     'SPFH.650_mb': 0.0006043044268153608,
                     'SPFH.700_mb': 0.0006828680634498596,
                     'SPFH.70_mb': 6.500592775182668e-08,
                     'SPFH.750_mb': 0.0007568215951323509,
                     'SPFH.7_mb': 9.212620000198513e-08,
                     'SPFH.800_mb': 0.0008281983318738639,
                     'SPFH.80_m_above_ground': 0.0005001156823709607,
                     'SPFH.850_mb': 0.0008413195610046387,
                     'SPFH.900_mb': 0.0007116968045011163,
                     'SPFH.925_mb': 0.0006512640975415707,
                     'SPFH.950_mb': 0.0006132667185738683,
                     'SPFH.975_mb': 0.0005856022471562028,
                     'SUNSD.surface': 8055.39306640625,
                     'TCDC.1000_mb': 9.529267311096191,
                     'TCDC.100_mb': 6.37180757522583,
                     'TCDC.150_mb': 13.360718727111816,
                     'TCDC.200_mb': 19.957563400268555,
                     'TCDC.250_mb': 25.42363739013672,
                     'TCDC.300_mb': 28.724252700805664,
                     'TCDC.350_mb': 28.691665649414062,
                     'TCDC.400_mb': 28.330381393432617,
                     'TCDC.450_mb': 27.594276428222656,
                     'TCDC.500_mb': 26.81031608581543,
                     'TCDC.50_mb': 3.052053689956665,
                     'TCDC.550_mb': 26.106515884399414,
                     'TCDC.600_mb': 25.211578369140625,
                     'TCDC.650_mb': 24.094505310058594,
                     'TCDC.700_mb': 23.431854248046875,
                     'TCDC.750_mb': 23.18967056274414,
                     'TCDC.800_mb': 23.29502296447754,
                     'TCDC.850_mb': 24.386993408203125,
                     'TCDC.900_mb': 23.210506439208984,
                     'TCDC.925_mb': 21.354877471923828,
                     'TCDC.950_mb': 19.241613388061523,
                     'TCDC.975_mb': 16.0972843170166,
                     'TCDC.entire_atmosphere': 31.529314041137695,
                     'TMP.0.01_mb': 2.3576998710632324,
                     'TMP.0.02_mb': 5.330291271209717,
                     'TMP.0.04_mb': 6.59458065032959,
                     'TMP.0.07_mb': 5.473371982574463,
                     'TMP.0.1_mb': 4.547154903411865,
                     'TMP.0.2_mb': 3.820164442062378,
                     'TMP.0.4_mb': 3.401130437850952,
                     'TMP.0.7_mb': 3.1682283878326416,
                     'TMP.0.995_sigma_level': 1.3855791091918945,
                     'TMP.1000_mb': 1.5354387760162354,
                     'TMP.100_m_above_ground': 1.2550705671310425,
                     'TMP.100_mb': 0.8163179159164429,
                     'TMP.10_mb': 1.3957089185714722,
                     'TMP.150_mb': 0.7831538319587708,
                     'TMP.15_mb': 1.2375743389129639,
                     'TMP.1829_m_above_mean_sea_level': 0.9667922258377075,
                     'TMP.1_mb': 2.9829652309417725,
                     'TMP.200_mb': 1.0002816915512085,
                     'TMP.20_mb': 1.1221261024475098,
                     'TMP.250_mb': 0.9788451194763184,
                     'TMP.2743_m_above_mean_sea_level': 0.8612518310546875,
                     'TMP.2_m_above_ground': 1.7251733541488647,
                     'TMP.2_mb': 2.7613039016723633,
                     'TMP.30-0_mb_above_ground': 1.1908063888549805,
                     'TMP.300_mb': 0.846965491771698,
                     'TMP.30_mb': 0.96248459815979,
                     'TMP.350_mb': 0.7998833656311035,
                     'TMP.3658_m_above_mean_sea_level': 0.8586789965629578,
                     'TMP.3_mb': 2.306368589401245,
                     'TMP.400_mb': 0.8407983779907227,
                     'TMP.40_mb': 0.9858638644218445,
                     'TMP.450_mb': 0.8686642646789551,
                     'TMP.500_mb': 0.8739417195320129,
                     'TMP.50_mb': 0.9079774022102356,
                     'TMP.550_mb': 0.8665658831596375,
                     'TMP.5_mb': 1.9857054948806763,
                     'TMP.600_mb': 0.8582693934440613,
                     'TMP.650_mb': 0.8785778284072876,
                     'TMP.700_mb': 0.918483555316925,
                     'TMP.70_mb': 0.891213059425354,
                     'TMP.750_mb': 0.970400333404541,
                     'TMP.7_mb': 1.6177154779434204,
                     'TMP.800_mb': 1.054888129234314,
                     'TMP.80_m_above_ground': 1.287895917892456,
                     'TMP.850_mb': 1.151529312133789,
                     'TMP.900_mb': 1.2515878677368164,
                     'TMP.925_mb': 1.3104321956634521,
                     'TMP.950_mb': 1.3812589645385742,
                     'TMP.975_mb': 1.4678864479064941,
                     'TMP.PV2e06Km2kgs_surface': 4.54359245300293,
                     'TMP.PVNeg2e06Km2kgs_surface': 4.927225589752197,
                     'TMP.max_wind': 8.678179740905762,
                     'TMP.surface': 3.1143198013305664,
                     'TMP.tropopause': 2.300882339477539,
                     'TOZNE.entire_atmosphere_considered_as_a_single_layer': 5.158444881439209,
                     'TSOIL.0-0.1_m_below_ground': 1.1629301309585571,
                     'TSOIL.0.1-0.4_m_below_ground': 0.056478675454854965,
                     'TSOIL.0.4-1_m_below_ground': 0.009394054301083088,
                     'TSOIL.1-2_m_below_ground': 0.005746344570070505,
                     'UGRD.0.01_mb': 21.685237884521484,
                     'UGRD.0.02_mb': 21.240161895751953,
                     'UGRD.0.04_mb': 16.044408798217773,
                     'UGRD.0.07_mb': 16.479087829589844,
                     'UGRD.0.1_mb': 15.366540908813477,
                     'UGRD.0.2_mb': 12.072515487670898,
                     'UGRD.0.4_mb': 9.106413841247559,
                     'UGRD.0.7_mb': 7.487508773803711,
                     'UGRD.0.995_sigma_level': 1.9241883754730225,
                     'UGRD.1000_mb': 1.7261849641799927,
                     'UGRD.100_m_above_ground': 2.051438570022583,
                     'UGRD.100_mb': 2.1185836791992188,
                     'UGRD.10_m_above_ground': 1.6234010457992554,
                     'UGRD.10_mb': 2.7566254138946533,
                     'UGRD.150_mb': 2.342501401901245,
                     'UGRD.15_mb': 2.4567291736602783,
                     'UGRD.1829_m_above_mean_sea_level': 2.1432478427886963,
                     'UGRD.1_mb': 6.37865686416626,
                     'UGRD.200_mb': 2.930337905883789,
                     'UGRD.20_m_above_ground': 1.698306679725647,
                     'UGRD.20_mb': 2.2392659187316895,
                     'UGRD.250_mb': 3.6138665676116943,
                     'UGRD.2743_m_above_mean_sea_level': 2.171060800552368,
                     'UGRD.2_mb': 5.3070454597473145,
                     'UGRD.30-0_mb_above_ground': 2.0206475257873535,
                     'UGRD.300_mb': 3.9382483959198,
                     'UGRD.30_m_above_ground': 1.800986886024475,
                     'UGRD.30_mb': 1.983029842376709,
                     'UGRD.350_mb': 3.780447244644165,
                     'UGRD.3658_m_above_mean_sea_level': 2.299196243286133,
                     'UGRD.3_mb': 4.275155544281006,
                     'UGRD.400_mb': 3.462639808654785,
                     'UGRD.40_m_above_ground': 1.8571009635925293,
                     'UGRD.40_mb': 2.062417984008789,
                     'UGRD.450_mb': 3.1225249767303467,
                     'UGRD.500_mb': 2.803178548812866,
                     'UGRD.50_m_above_ground': 1.9054051637649536,
                     'UGRD.50_mb': 1.9198352098464966,
                     'UGRD.550_mb': 2.563570976257324,
                     'UGRD.5_mb': 3.6815345287323,
                     'UGRD.600_mb': 2.378328561782837,
                     'UGRD.650_mb': 2.2381958961486816,
                     'UGRD.700_mb': 2.1433513164520264,
                     'UGRD.70_mb': 1.9325062036514282,
                     'UGRD.750_mb': 2.0861549377441406,
                     'UGRD.7_mb': 3.083186388015747,
                     'UGRD.800_mb': 2.066535711288452,
                     'UGRD.80_m_above_ground': 2.0047788619995117,
                     'UGRD.850_mb': 2.0966498851776123,
                     'UGRD.900_mb': 2.153477907180786,
                     'UGRD.925_mb': 2.1677725315093994,
                     'UGRD.950_mb': 2.121701717376709,
                     'UGRD.975_mb': 1.9531890153884888,
                     'UGRD.PV2e06Km2kgs_surface': 6.480360507965088,
                     'UGRD.PVNeg2e06Km2kgs_surface': 6.812502384185791,
                     'UGRD.max_wind': 4.991430282592773,
                     'UGRD.planetary_boundary_layer': 2.1461222171783447,
                     'UGRD.tropopause': 4.609044075012207,
                     'USTM.6000-0_m_above_ground': 2.8028602600097656,
                     'VEG.surface': 0.1132546216249466,
                     'VGRD.0.01_mb': 24.092172622680664,
                     'VGRD.0.02_mb': 22.72625732421875,
                     'VGRD.0.04_mb': 16.636323928833008,
                     'VGRD.0.07_mb': 17.318599700927734,
                     'VGRD.0.1_mb': 16.091096878051758,
                     'VGRD.0.2_mb': 12.790432929992676,
                     'VGRD.0.4_mb': 9.889575004577637,
                     'VGRD.0.7_mb': 8.215861320495605,
                     'VGRD.0.995_sigma_level': 2.146742820739746,
                     'VGRD.1000_mb': 1.9460422992706299,
                     'VGRD.100_m_above_ground': 2.2865097522735596,
                     'VGRD.100_mb': 2.254072904586792,
                     'VGRD.10_m_above_ground': 1.8189765214920044,
                     'VGRD.10_mb': 3.104269504547119,
                     'VGRD.150_mb': 2.5445609092712402,
                     'VGRD.15_mb': 2.79770565032959,
                     'VGRD.1829_m_above_mean_sea_level': 2.3559842109680176,
                     'VGRD.1_mb': 7.129713535308838,
                     'VGRD.200_mb': 3.3101422786712646,
                     'VGRD.20_m_above_ground': 1.9033616781234741,
                     'VGRD.20_mb': 2.5512542724609375,
                     'VGRD.250_mb': 4.213156223297119,
                     'VGRD.2743_m_above_mean_sea_level': 2.4142000675201416,
                     'VGRD.2_mb': 5.913712978363037,
                     'VGRD.30-0_mb_above_ground': 2.2594778537750244,
                     'VGRD.300_mb': 4.655564308166504,
                     'VGRD.30_m_above_ground': 2.014226198196411,
                     'VGRD.30_mb': 2.2234466075897217,
                     'VGRD.350_mb': 4.508290767669678,
                     'VGRD.3658_m_above_mean_sea_level': 2.6045210361480713,
                     'VGRD.3_mb': 4.751557350158691,
                     'VGRD.400_mb': 4.129066467285156,
                     'VGRD.40_m_above_ground': 2.0748422145843506,
                     'VGRD.40_mb': 2.2714719772338867,
                     'VGRD.450_mb': 3.7020628452301025,
                     'VGRD.500_mb': 3.291260004043579,
                     'VGRD.50_m_above_ground': 2.1270265579223633,
                     'VGRD.50_mb': 2.108316421508789,
                     'VGRD.550_mb': 2.9658749103546143,
                     'VGRD.5_mb': 4.042256832122803,
                     'VGRD.600_mb': 2.714275598526001,
                     'VGRD.650_mb': 2.5226550102233887,
                     'VGRD.700_mb': 2.3859822750091553,
                     'VGRD.70_mb': 2.104966163635254,
                     'VGRD.750_mb': 2.300346612930298,
                     'VGRD.7_mb': 3.4170761108398438,
                     'VGRD.800_mb': 2.2716948986053467,
                     'VGRD.80_m_above_ground': 2.2352938652038574,
                     'VGRD.850_mb': 2.308073043823242,
                     'VGRD.900_mb': 2.3950555324554443,
                     'VGRD.925_mb': 2.4271531105041504,
                     'VGRD.950_mb': 2.392284870147705,
                     'VGRD.975_mb': 2.2206835746765137,
                     'VGRD.PV2e06Km2kgs_surface': 5.384926795959473,
                     'VGRD.PVNeg2e06Km2kgs_surface': 6.044037342071533,
                     'VGRD.max_wind': 5.876047611236572,
                     'VGRD.planetary_boundary_layer': 2.3759260177612305,
                     'VGRD.tropopause': 4.708921909332275,
                     'VIS.surface': 5516.421875,
                     'VRATE.planetary_boundary_layer': 3573.51123046875,
                     'VSTM.6000-0_m_above_ground': 2.8110616207122803,
                     'VVEL.0.01_mb': 3.0533898097928613e-05,
                     'VVEL.0.02_mb': 0.00016920780763030052,
                     'VVEL.0.04_mb': 0.000403095968067646,
                     'VVEL.0.07_mb': 0.0005584102473221719,
                     'VVEL.0.1_mb': 0.0006693670293316245,
                     'VVEL.0.2_mb': 0.001069940160959959,
                     'VVEL.0.4_mb': 0.0016183974221348763,
                     'VVEL.0.7_mb': 0.002183426171541214,
                     'VVEL.0.995_sigma_level': 0.11188916862010956,
                     'VVEL.1000_mb': 0.10407687723636627,
                     'VVEL.100_mb': 0.057047244161367416,
                     'VVEL.10_mb': 0.011669526807963848,
                     'VVEL.150_mb': 0.11009373515844345,
                     'VVEL.15_mb': 0.015177921392023563,
                     'VVEL.1_mb': 0.0026675837580114603,
                     'VVEL.200_mb': 0.16872967779636383,
                     'VVEL.20_mb': 0.01799676939845085,
                     'VVEL.250_mb': 0.22326506674289703,
                     'VVEL.2_mb': 0.004219644702970982,
                     'VVEL.300_mb': 0.2696385979652405,
                     'VVEL.30_mb': 0.02224869653582573,
                     'VVEL.350_mb': 0.2993161678314209,
                     'VVEL.3_mb': 0.0054264431819319725,
                     'VVEL.400_mb': 0.3218150734901428,
                     'VVEL.40_mb': 0.02727026864886284,
                     'VVEL.450_mb': 0.3390040397644043,
                     'VVEL.500_mb': 0.355040043592453,
                     'VVEL.50_mb': 0.030225222930312157,
                     'VVEL.550_mb': 0.3762670159339905,
                     'VVEL.5_mb': 0.007705315016210079,
                     'VVEL.600_mb': 0.4032500684261322,
                     'VVEL.650_mb': 0.4282698631286621,
                     'VVEL.700_mb': 0.447853684425354,
                     'VVEL.70_mb': 0.03813190758228302,
                     'VVEL.750_mb': 0.45715224742889404,
                     'VVEL.7_mb': 0.009251944720745087,
                     'VVEL.800_mb': 0.450928270816803,
                     'VVEL.850_mb': 0.4216623604297638,
                     'VVEL.900_mb': 0.35480746626853943,
                     'VVEL.925_mb': 0.3008720278739929,
                     'VVEL.950_mb': 0.2326974719762802,
                     'VVEL.975_mb': 0.1595100462436676,
                     'VWSH.PV2e06Km2kgs_surface': 0.009113934822380543,
                     'VWSH.PVNeg2e06Km2kgs_surface': 0.009044907987117767,
                     'VWSH.tropopause': 0.007434805389493704,
                     'WEASD.surface': 0.34822970628738403,
                     'WILT.surface': 1.6381925888708793e-05}
FORECAST_DIFF_MAX = {'4LFTX.surface': 18.125593185424805,
                     'ABSV.0.01_mb': 0.002631894312798977,
                     'ABSV.0.02_mb': 0.0033181447070091963,
                     'ABSV.0.04_mb': 0.004139278084039688,
                     'ABSV.0.07_mb': 0.004908137954771519,
                     'ABSV.0.1_mb': 0.005923405289649963,
                     'ABSV.0.2_mb': 0.006591344252228737,
                     'ABSV.0.4_mb': 0.00520835118368268,
                     'ABSV.0.7_mb': 0.005262495018541813,
                     'ABSV.1000_mb': 0.004697193391621113,
                     'ABSV.100_mb': 0.003136246930807829,
                     'ABSV.10_mb': 0.003636768087744713,
                     'ABSV.150_mb': 0.003666472155600786,
                     'ABSV.15_mb': 0.0023917509242892265,
                     'ABSV.1_mb': 0.005530088674277067,
                     'ABSV.200_mb': 0.0032988963648676872,
                     'ABSV.20_mb': 0.0024807078298181295,
                     'ABSV.250_mb': 0.003006997285410762,
                     'ABSV.2_mb': 0.0052748192101716995,
                     'ABSV.300_mb': 0.0024818582460284233,
                     'ABSV.30_mb': 0.0023722155019640923,
                     'ABSV.350_mb': 0.0023664787877351046,
                     'ABSV.3_mb': 0.0036852892953902483,
                     'ABSV.400_mb': 0.0022848814260214567,
                     'ABSV.40_mb': 0.0018736764322966337,
                     'ABSV.450_mb': 0.002665449632331729,
                     'ABSV.500_mb': 0.0028011088725179434,
                     'ABSV.50_mb': 0.0015830660704523325,
                     'ABSV.550_mb': 0.002691542496904731,
                     'ABSV.5_mb': 0.005698293913155794,
                     'ABSV.600_mb': 0.0025965392123907804,
                     'ABSV.650_mb': 0.0026500653475522995,
                     'ABSV.700_mb': 0.002829666016623378,
                     'ABSV.70_mb': 0.0017092650523409247,
                     'ABSV.750_mb': 0.003026044461876154,
                     'ABSV.7_mb': 0.0038712790701538324,
                     'ABSV.800_mb': 0.0032074337359517813,
                     'ABSV.850_mb': 0.0033644302748143673,
                     'ABSV.900_mb': 0.0038157296366989613,
                     'ABSV.925_mb': 0.0038961139507591724,
                     'ABSV.950_mb': 0.0039517516270279884,
                     'ABSV.975_mb': 0.0038297928404062986,
                     'APTMP.2_m_above_ground': 35.24940490722656,
                     'CAPE.180-0_mb_above_ground': 3795.0,
                     'CAPE.255-0_mb_above_ground': 3855.0,
                     'CAPE.90-0_mb_above_ground': 3211.0,
                     'CAPE.surface': 3883.0,
                     'CFRZR.surface': 1.0,
                     'CICEP.surface': 1.0,
                     'CIN.180-0_mb_above_ground': 3096.86083984375,
                     'CIN.255-0_mb_above_ground': 2435.46630859375,
                     'CIN.90-0_mb_above_ground': 3693.392822265625,
                     'CIN.surface': 2223.9091796875,
                     'CLMR.1000_mb': 0.00110317999497056,
                     'CLMR.100_mb': 1.0526800107600251e-13,
                     'CLMR.150_mb': 2.7514400571987585e-22,
                     'CLMR.1_hybrid_level': 0.0019020000472664833,
                     'CLMR.200_mb': 4.094079849892296e-05,
                     'CLMR.250_mb': 0.0007655840017832816,
                     'CLMR.300_mb': 0.0010419200407341123,
                     'CLMR.350_mb': 0.001288959989324212,
                     'CLMR.400_mb': 0.001684800023213029,
                     'CLMR.450_mb': 0.001850640051998198,
                     'CLMR.500_mb': 0.0016300799325108528,
                     'CLMR.50_mb': 0.0,
                     'CLMR.550_mb': 0.0014782799407839775,
                     'CLMR.600_mb': 0.0015102399047464132,
                     'CLMR.650_mb': 0.0013125200057402253,
                     'CLMR.700_mb': 0.001225879997946322,
                     'CLMR.750_mb': 0.0012422000290825963,
                     'CLMR.800_mb': 0.0012184199877083302,
                     'CLMR.850_mb': 0.0012744199484586716,
                     'CLMR.900_mb': 0.0012088000075891614,
                     'CLMR.925_mb': 0.001154972007498145,
                     'CLMR.950_mb': 0.0010852999985218048,
                     'CLMR.975_mb': 0.0012486400082707405,
                     'CNWAT.surface': 0.5,
                     'CPOFP.surface': 150.0,
                     'CRAIN.surface': 1.0,
                     'CSNOW.surface': 1.0,
                     'CWAT.entire_atmosphere_considered_as_a_single_layer': 6.68943977355957,
                     'DPT.2_m_above_ground': 57.901275634765625,
                     'DZDT.0.01_mb': 10.93808650970459,
                     'DZDT.0.02_mb': 9.818832397460938,
                     'DZDT.0.04_mb': 21.775251388549805,
                     'DZDT.0.07_mb': 31.82977867126465,
                     'DZDT.0.1_mb': 30.54334259033203,
                     'DZDT.0.2_mb': 23.086299896240234,
                     'DZDT.0.4_mb': 21.436960220336914,
                     'DZDT.0.7_mb': 17.577455520629883,
                     'DZDT.1000_mb': 1.0317506790161133,
                     'DZDT.100_mb': 3.7436790466308594,
                     'DZDT.10_mb': 4.49088191986084,
                     'DZDT.150_mb': 7.382983207702637,
                     'DZDT.15_mb': 4.467055320739746,
                     'DZDT.1_mb': 9.445456504821777,
                     'DZDT.200_mb': 7.2963786125183105,
                     'DZDT.20_mb': 3.7756762504577637,
                     'DZDT.250_mb': 7.088931083679199,
                     'DZDT.2_mb': 6.771231174468994,
                     'DZDT.300_mb': 6.794839859008789,
                     'DZDT.30_mb': 3.2052600383758545,
                     'DZDT.350_mb': 6.44780969619751,
                     'DZDT.3_mb': 6.3678178787231445,
                     'DZDT.400_mb': 6.058089733123779,
                     'DZDT.40_mb': 3.072742223739624,
                     'DZDT.450_mb': 5.589741230010986,
                     'DZDT.500_mb': 5.161552429199219,
                     'DZDT.50_mb': 2.316467761993408,
                     'DZDT.550_mb': 4.948431491851807,
                     'DZDT.5_mb': 5.085907936096191,
                     'DZDT.600_mb': 4.576639175415039,
                     'DZDT.650_mb': 4.0919294357299805,
                     'DZDT.700_mb': 3.570099115371704,
                     'DZDT.70_mb': 2.1752171516418457,
                     'DZDT.750_mb': 3.0831117630004883,
                     'DZDT.7_mb': 4.747385025024414,
                     'DZDT.800_mb': 2.5612411499023438,
                     'DZDT.850_mb': 2.0008411407470703,
                     'DZDT.900_mb': 1.628544807434082,
                     'DZDT.925_mb': 1.318097710609436,
                     'DZDT.950_mb': 1.0317506790161133,
                     'DZDT.975_mb': 1.0317506790161133,
                     'FLDCP.surface': 0.0025999844074249268,
                     'FRICV.surface': 1.913232684135437,
                     'GRLE.1000_mb': 0.0005329535924829543,
                     'GRLE.100_mb': 0.005001080222427845,
                     'GRLE.150_mb': 0.007462719921022654,
                     'GRLE.1_hybrid_level': 0.002049200003966689,
                     'GRLE.200_mb': 0.008761119097471237,
                     'GRLE.250_mb': 0.01017959788441658,
                     'GRLE.300_mb': 0.010962200351059437,
                     'GRLE.350_mb': 0.0104226004332304,
                     'GRLE.400_mb': 0.010254199616611004,
                     'GRLE.450_mb': 0.00948335975408554,
                     'GRLE.500_mb': 0.008402720093727112,
                     'GRLE.50_mb': 9.051755789357685e-09,
                     'GRLE.550_mb': 0.007403519935905933,
                     'GRLE.600_mb': 0.006401920225471258,
                     'GRLE.650_mb': 0.0053214398212730885,
                     'GRLE.700_mb': 0.004641999956220388,
                     'GRLE.750_mb': 0.0036460000555962324,
                     'GRLE.800_mb': 0.0025556001346558332,
                     'GRLE.850_mb': 0.0023752800188958645,
                     'GRLE.900_mb': 0.00170131993945688,
                     'GRLE.925_mb': 0.001716200029477477,
                     'GRLE.950_mb': 0.001629880047403276,
                     'GRLE.975_mb': 0.0011607520282268524,
                     'GUST.surface': 36.81990051269531,
                     'HCDC.high_cloud_layer': 100.0,
                     'HGT.0.01_mb': 3143.890625,
                     'HGT.0.02_mb': 2832.421875,
                     'HGT.0.04_mb': 2240.265625,
                     'HGT.0.07_mb': 1472.1875,
                     'HGT.0.1_mb': 1072.87109375,
                     'HGT.0.2_mb': 1142.546875,
                     'HGT.0.4_mb': 1064.84765625,
                     'HGT.0.7_mb': 908.62890625,
                     'HGT.0C_isotherm': 4563.2001953125,
                     'HGT.1000_mb': 317.87066650390625,
                     'HGT.100_mb': 107.576171875,
                     'HGT.10_mb': 306.9375,
                     'HGT.150_mb': 120.63671875,
                     'HGT.15_mb': 176.53125,
                     'HGT.1_mb': 934.53125,
                     'HGT.200_mb': 140.576171875,
                     'HGT.20_mb': 172.5,
                     'HGT.250_mb': 167.4453125,
                     'HGT.2_mb': 827.69140625,
                     'HGT.300_mb': 177.814453125,
                     'HGT.30_mb': 144.25,
                     'HGT.350_mb': 186.431640625,
                     'HGT.3_mb': 622.53515625,
                     'HGT.400_mb': 176.68408203125,
                     'HGT.40_mb': 134.1015625,
                     'HGT.450_mb': 203.64453125,
                     'HGT.500_mb': 223.75537109375,
                     'HGT.50_mb': 144.76953125,
                     'HGT.550_mb': 236.9716796875,
                     'HGT.5_mb': 438.51171875,
                     'HGT.600_mb': 248.099365234375,
                     'HGT.650_mb': 258.56396484375,
                     'HGT.700_mb': 268.118408203125,
                     'HGT.70_mb': 116.962890625,
                     'HGT.750_mb': 276.591552734375,
                     'HGT.7_mb': 406.0703125,
                     'HGT.800_mb': 284.74755859375,
                     'HGT.850_mb': 292.5501708984375,
                     'HGT.900_mb': 300.2867431640625,
                     'HGT.925_mb': 304.0949401855469,
                     'HGT.950_mb': 307.8252868652344,
                     'HGT.975_mb': 310.92974853515625,
                     'HGT.PV2e06Km2kgs_surface': 17891.77734375,
                     'HGT.PVNeg2e06Km2kgs_surface': 18015.87109375,
                     'HGT.cloud_ceiling': 19998.2421875,
                     'HGT.highest_tropospheric_freezing_level': 3462.239990234375,
                     'HGT.max_wind': 10833.0302734375,
                     'HGT.surface': 0.0,
                     'HGT.tropopause': 13669.46875,
                     'HINDEX.surface': 4.0,
                     'HLCY.3000-0_m_above_ground': 2150.31494140625,
                     'HPBL.surface': 6165.607421875,
                     'ICAHT.max_wind': 10342.658203125,
                     'ICAHT.tropopause': 14697.357421875,
                     'ICEC.surface': 0.0,
                     'ICEG.10_m_above_mean_sea_level': 0.00019999999494757503,
                     'ICETK.surface': 0.10000014305114746,
                     'ICETMP.surface': 23.05828857421875,
                     'ICMR.1000_mb': 0.0001528839929960668,
                     'ICMR.100_mb': 0.0014793600421398878,
                     'ICMR.150_mb': 0.0017622399609535933,
                     'ICMR.1_hybrid_level': 0.0002920480037573725,
                     'ICMR.200_mb': 0.0017281200271099806,
                     'ICMR.250_mb': 0.0017865800764411688,
                     'ICMR.300_mb': 0.001350519945845008,
                     'ICMR.350_mb': 0.0012704799883067608,
                     'ICMR.400_mb': 0.0011399600189179182,
                     'ICMR.450_mb': 0.0009754999773576856,
                     'ICMR.500_mb': 0.0008874399936757982,
                     'ICMR.50_mb': 1.109680056288198e-06,
                     'ICMR.550_mb': 0.0008340800413861871,
                     'ICMR.600_mb': 0.0007570720044896007,
                     'ICMR.650_mb': 0.0006570240366272628,
                     'ICMR.700_mb': 0.0006244319956749678,
                     'ICMR.750_mb': 0.0005637120339088142,
                     'ICMR.800_mb': 0.0004948559799231589,
                     'ICMR.850_mb': 0.0004057999758515507,
                     'ICMR.900_mb': 0.00035099999513477087,
                     'ICMR.925_mb': 0.00030525997863151133,
                     'ICMR.950_mb': 0.0002509720216039568,
                     'ICMR.975_mb': 0.0002318399929208681,
                     'LAND.surface': 0.0,
                     'LCDC.low_cloud_layer': 100.0,
                     'LFTX.surface': 23.838579177856445,
                     'MCDC.middle_cloud_layer': 100.0,
                     'MSLET.mean_sea_level': 3381.984375,
                     'O3MR.0.01_mb': 4.715740260508028e-07,
                     'O3MR.0.02_mb': 4.441788519216061e-07,
                     'O3MR.0.04_mb': 5.885628979740432e-07,
                     'O3MR.0.07_mb': 7.867863018873322e-07,
                     'O3MR.0.1_mb': 9.926566235662904e-07,
                     'O3MR.0.2_mb': 1.128950771089876e-06,
                     'O3MR.0.4_mb': 2.4363807824556716e-06,
                     'O3MR.0.7_mb': 5.5811929087212775e-06,
                     'O3MR.1000_mb': 4.5925482083930547e-08,
                     'O3MR.100_mb': 2.887663640649407e-06,
                     'O3MR.10_mb': 4.158281626587268e-06,
                     'O3MR.150_mb': 1.7567738268553512e-06,
                     'O3MR.15_mb': 5.23936341778608e-06,
                     'O3MR.1_mb': 6.602698249480454e-06,
                     'O3MR.200_mb': 1.1833958524221089e-06,
                     'O3MR.20_mb': 4.387556600704556e-06,
                     'O3MR.250_mb': 7.103807320163469e-07,
                     'O3MR.2_mb': 7.364174962276593e-06,
                     'O3MR.300_mb': 6.635852969338885e-07,
                     'O3MR.30_mb': 3.696937255881494e-06,
                     'O3MR.350_mb': 5.384520136431092e-07,
                     'O3MR.3_mb': 6.730857876391383e-06,
                     'O3MR.400_mb': 4.2147328827013553e-07,
                     'O3MR.40_mb': 2.585209131211741e-06,
                     'O3MR.450_mb': 3.3367945206919103e-07,
                     'O3MR.500_mb': 2.726482080106507e-07,
                     'O3MR.50_mb': 2.9974637527629966e-06,
                     'O3MR.550_mb': 2.4230095618804626e-07,
                     'O3MR.5_mb': 2.4436571038677357e-05,
                     'O3MR.600_mb': 2.078347733913688e-07,
                     'O3MR.650_mb': 1.5291428212549363e-07,
                     'O3MR.700_mb': 1.138187997185014e-07,
                     'O3MR.70_mb': 3.7866457205382176e-06,
                     'O3MR.750_mb': 8.399630502253785e-08,
                     'O3MR.7_mb': 6.64951176077011e-06,
                     'O3MR.800_mb': 6.793958817752355e-08,
                     'O3MR.850_mb': 6.156052023698066e-08,
                     'O3MR.900_mb': 5.689401305630781e-08,
                     'O3MR.925_mb': 5.8947801306885594e-08,
                     'O3MR.950_mb': 4.594214431108412e-08,
                     'O3MR.975_mb': 4.592615709952952e-08,
                     'PLPL.255-0_mb_above_ground': 31486.8515625,
                     'POT.0.995_sigma_level': 19.975128173828125,
                     'PRATE.surface': 0.027159199118614197,
                     'PRES.80_m_above_ground': 3346.0390625,
                     'PRES.PV2e06Km2kgs_surface': 75490.359375,
                     'PRES.PVNeg2e06Km2kgs_surface': 75254.40625,
                     'PRES.max_wind': 39567.48046875,
                     'PRES.surface': 3381.4140625,
                     'PRES.tropopause': 44758.40234375,
                     'PRMSL.mean_sea_level': 4219.7890625,
                     'PWAT.entire_atmosphere_considered_as_a_single_layer': 33.27484893798828,
                     'REFC.entire_atmosphere': 74.75,
                     'REFD.1000_m_above_ground': 72.41999816894531,
                     'REFD.1_hybrid_level': 72.88999938964844,
                     'REFD.2_hybrid_level': 72.8800048828125,
                     'REFD.4000_m_above_ground': 72.22999572753906,
                     'RH.0.01_mb': 0.10000000149011612,
                     'RH.0.02_mb': 0.20000000298023224,
                     'RH.0.04_mb': 0.5,
                     'RH.0.07_mb': 0.800000011920929,
                     'RH.0.1_mb': 0.4000000059604645,
                     'RH.0.2_mb': 0.0,
                     'RH.0.33-1_sigma_layer': 86.0999984741211,
                     'RH.0.44-0.72_sigma_layer': 98.69999694824219,
                     'RH.0.44-1_sigma_layer': 87.0999984741211,
                     'RH.0.4_mb': 0.0,
                     'RH.0.72-0.94_sigma_layer': 96.0999984741211,
                     'RH.0.7_mb': 0.0,
                     'RH.0.995_sigma_level': 87.4000015258789,
                     'RH.0C_isotherm': 99.0,
                     'RH.1000_mb': 87.10000610351562,
                     'RH.100_mb': 81.9000015258789,
                     'RH.10_mb': 37.20000076293945,
                     'RH.150_mb': 98.5,
                     'RH.15_mb': 41.900001525878906,
                     'RH.1_mb': 0.10000000149011612,
                     'RH.200_mb': 100.0,
                     'RH.20_mb': 57.5,
                     'RH.250_mb': 100.0,
                     'RH.2_m_above_ground': 85.19999694824219,
                     'RH.2_mb': 3.1000001430511475,
                     'RH.30-0_mb_above_ground': 93.5,
                     'RH.300_mb': 100.0,
                     'RH.30_mb': 77.4000015258789,
                     'RH.350_mb': 100.0,
                     'RH.3_mb': 5.099999904632568,
                     'RH.400_mb': 100.0,
                     'RH.40_mb': 85.79999542236328,
                     'RH.450_mb': 100.0,
                     'RH.500_mb': 100.0,
                     'RH.50_mb': 78.80000305175781,
                     'RH.550_mb': 100.0,
                     'RH.5_mb': 24.399999618530273,
                     'RH.600_mb': 100.0,
                     'RH.650_mb': 100.0,
                     'RH.700_mb': 100.0,
                     'RH.70_mb': 88.70000457763672,
                     'RH.750_mb': 100.0,
                     'RH.7_mb': 28.900001525878906,
                     'RH.800_mb': 100.0,
                     'RH.850_mb': 100.0,
                     'RH.900_mb': 99.20000457763672,
                     'RH.925_mb': 98.4000015258789,
                     'RH.950_mb': 97.19999694824219,
                     'RH.975_mb': 97.30000305175781,
                     'RH.entire_atmosphere_considered_as_a_single_layer': 58.099998474121094,
                     'RH.highest_tropospheric_freezing_level': 99.0,
                     'RWMR.1000_mb': 0.0034692399203777313,
                     'RWMR.100_mb': 1.7483616332469865e-08,
                     'RWMR.150_mb': 5.091512278454502e-08,
                     'RWMR.1_hybrid_level': 0.003749920055270195,
                     'RWMR.200_mb': 5.763784827195195e-08,
                     'RWMR.250_mb': 7.07191247784067e-08,
                     'RWMR.300_mb': 4.7081388743208663e-07,
                     'RWMR.350_mb': 1.2638457519642543e-05,
                     'RWMR.400_mb': 1.5166861885518301e-05,
                     'RWMR.450_mb': 0.00012169385445304215,
                     'RWMR.500_mb': 0.0021665042731910944,
                     'RWMR.50_mb': 1.627175394425251e-09,
                     'RWMR.550_mb': 0.003547040047124028,
                     'RWMR.600_mb': 0.005061119794845581,
                     'RWMR.650_mb': 0.004779359791427851,
                     'RWMR.700_mb': 0.004201839677989483,
                     'RWMR.750_mb': 0.004272960126399994,
                     'RWMR.800_mb': 0.004321040119975805,
                     'RWMR.850_mb': 0.004249279852956533,
                     'RWMR.900_mb': 0.004101680126041174,
                     'RWMR.925_mb': 0.004018639679998159,
                     'RWMR.950_mb': 0.0039289603009819984,
                     'RWMR.975_mb': 0.003836400108411908,
                     'SFCR.surface': 0.010000000707805157,
                     'SNMR.1000_mb': 0.0008616800187155604,
                     'SNMR.100_mb': 0.0011276559671387076,
                     'SNMR.150_mb': 0.0013928395928815007,
                     'SNMR.1_hybrid_level': 0.0013235999504104257,
                     'SNMR.200_mb': 0.00217115948908031,
                     'SNMR.250_mb': 0.002481440082192421,
                     'SNMR.300_mb': 0.0024061999283730984,
                     'SNMR.350_mb': 0.002435839967802167,
                     'SNMR.400_mb': 0.0021804398857057095,
                     'SNMR.450_mb': 0.0020071999169886112,
                     'SNMR.500_mb': 0.0016960400389507413,
                     'SNMR.50_mb': 7.203551977141842e-09,
                     'SNMR.550_mb': 0.0016045200172811747,
                     'SNMR.600_mb': 0.0014508400345221162,
                     'SNMR.650_mb': 0.0013395600253716111,
                     'SNMR.700_mb': 0.0012748399749398232,
                     'SNMR.750_mb': 0.0012587800156325102,
                     'SNMR.800_mb': 0.0013204000424593687,
                     'SNMR.850_mb': 0.0010712000075727701,
                     'SNMR.900_mb': 0.0011565199820324779,
                     'SNMR.925_mb': 0.0010751360096037388,
                     'SNMR.950_mb': 0.001123495982028544,
                     'SNMR.975_mb': 0.0010382720502093434,
                     'SNOD.surface': 0.5980799794197083,
                     'SOILL.0-0.1_m_below_ground': 0.3319999873638153,
                     'SOILL.0.1-0.4_m_below_ground': 0.2619999945163727,
                     'SOILL.0.4-1_m_below_ground': 0.1420000046491623,
                     'SOILL.1-2_m_below_ground': 0.07400000095367432,
                     'SOILW.0-0.1_m_below_ground': 0.3319999873638153,
                     'SOILW.0.1-0.4_m_below_ground': 0.2619999945163727,
                     'SOILW.0.4-1_m_below_ground': 0.1420000046491623,
                     'SOILW.1-2_m_below_ground': 0.07400000095367432,
                     'SOTYP.surface': 0.0,
                     'SPFH.0.01_mb': 3.586768571040011e-06,
                     'SPFH.0.02_mb': 3.6771439226868097e-06,
                     'SPFH.0.04_mb': 3.859945536532905e-06,
                     'SPFH.0.07_mb': 3.822070539172273e-06,
                     'SPFH.0.1_mb': 3.702019967022352e-06,
                     'SPFH.0.2_mb': 3.242112143198028e-06,
                     'SPFH.0.4_mb': 3.0748994959139964e-06,
                     'SPFH.0.7_mb': 3.232268227293389e-06,
                     'SPFH.1000_mb': 0.02346324548125267,
                     'SPFH.100_mb': 1.1866856766573619e-05,
                     'SPFH.10_mb': 3.0398700801015366e-06,
                     'SPFH.150_mb': 6.159885379020125e-05,
                     'SPFH.15_mb': 2.8576760087162256e-06,
                     'SPFH.1_mb': 3.3108883599197725e-06,
                     'SPFH.200_mb': 0.00026003411039710045,
                     'SPFH.20_mb': 2.8161678073956864e-06,
                     'SPFH.250_mb': 0.0008529330953024328,
                     'SPFH.2_m_above_ground': 0.015068268403410912,
                     'SPFH.2_mb': 3.7199006328592077e-06,
                     'SPFH.30-0_mb_above_ground': 0.014083742164075375,
                     'SPFH.300_mb': 0.002037753351032734,
                     'SPFH.30_mb': 2.635932560224319e-06,
                     'SPFH.350_mb': 0.003274927381426096,
                     'SPFH.3_mb': 3.6342064504424343e-06,
                     'SPFH.400_mb': 0.004399632103741169,
                     'SPFH.40_mb': 2.543971504564979e-06,
                     'SPFH.450_mb': 0.006046161521226168,
                     'SPFH.500_mb': 0.006544322241097689,
                     'SPFH.50_mb': 1.9431698092375882e-05,
                     'SPFH.550_mb': 0.0077219754457473755,
                     'SPFH.5_mb': 3.5546186154533643e-06,
                     'SPFH.600_mb': 0.008653811179101467,
                     'SPFH.650_mb': 0.009754796512424946,
                     'SPFH.700_mb': 0.010419458150863647,
                     'SPFH.70_mb': 1.5871146388235502e-05,
                     'SPFH.750_mb': 0.012146049179136753,
                     'SPFH.7_mb': 3.493250915198587e-06,
                     'SPFH.800_mb': 0.014184905216097832,
                     'SPFH.80_m_above_ground': 0.015750577673316002,
                     'SPFH.850_mb': 0.01634475216269493,
                     'SPFH.900_mb': 0.018616555258631706,
                     'SPFH.925_mb': 0.019792187958955765,
                     'SPFH.950_mb': 0.020992077887058258,
                     'SPFH.975_mb': 0.022215597331523895,
                     'SUNSD.surface': 10801.0,
                     'TCDC.1000_mb': 100.0,
                     'TCDC.100_mb': 100.0,
                     'TCDC.150_mb': 100.0,
                     'TCDC.200_mb': 100.0,
                     'TCDC.250_mb': 100.0,
                     'TCDC.300_mb': 100.0,
                     'TCDC.350_mb': 100.0,
                     'TCDC.400_mb': 100.0,
                     'TCDC.450_mb': 100.0,
                     'TCDC.500_mb': 100.0,
                     'TCDC.50_mb': 100.0,
                     'TCDC.550_mb': 100.0,
                     'TCDC.600_mb': 100.0,
                     'TCDC.650_mb': 100.0,
                     'TCDC.700_mb': 100.0,
                     'TCDC.750_mb': 100.0,
                     'TCDC.800_mb': 100.0,
                     'TCDC.850_mb': 100.0,
                     'TCDC.900_mb': 100.0,
                     'TCDC.925_mb': 100.0,
                     'TCDC.950_mb': 100.0,
                     'TCDC.975_mb': 100.0,
                     'TCDC.entire_atmosphere': 100.0,
                     'TMP.0.01_mb': 28.40093994140625,
                     'TMP.0.02_mb': 46.23614501953125,
                     'TMP.0.04_mb': 64.76353454589844,
                     'TMP.0.07_mb': 61.81132507324219,
                     'TMP.0.1_mb': 63.292572021484375,
                     'TMP.0.2_mb': 62.50160217285156,
                     'TMP.0.4_mb': 55.77839660644531,
                     'TMP.0.7_mb': 56.12031555175781,
                     'TMP.0.995_sigma_level': 18.676849365234375,
                     'TMP.1000_mb': 23.171722412109375,
                     'TMP.100_m_above_ground': 18.399993896484375,
                     'TMP.100_mb': 16.709060668945312,
                     'TMP.10_mb': 22.299057006835938,
                     'TMP.150_mb': 15.8009033203125,
                     'TMP.15_mb': 18.671707153320312,
                     'TMP.1829_m_above_mean_sea_level': 14.964202880859375,
                     'TMP.1_mb': 44.41796875,
                     'TMP.200_mb': 14.875640869140625,
                     'TMP.20_mb': 17.402420043945312,
                     'TMP.250_mb': 16.51239013671875,
                     'TMP.2743_m_above_mean_sea_level': 14.752975463867188,
                     'TMP.2_m_above_ground': 23.921676635742188,
                     'TMP.2_mb': 51.2061767578125,
                     'TMP.30-0_mb_above_ground': 18.30078125,
                     'TMP.300_mb': 16.634063720703125,
                     'TMP.30_mb': 17.620315551757812,
                     'TMP.350_mb': 14.442947387695312,
                     'TMP.3658_m_above_mean_sea_level': 14.695556640625,
                     'TMP.3_mb': 41.85426330566406,
                     'TMP.400_mb': 13.468185424804688,
                     'TMP.40_mb': 14.030868530273438,
                     'TMP.450_mb': 14.687911987304688,
                     'TMP.500_mb': 14.212265014648438,
                     'TMP.50_mb': 14.09869384765625,
                     'TMP.550_mb': 17.050613403320312,
                     'TMP.5_mb': 38.53282165527344,
                     'TMP.600_mb': 19.706008911132812,
                     'TMP.650_mb': 19.993515014648438,
                     'TMP.700_mb': 20.2442626953125,
                     'TMP.70_mb': 20.434906005859375,
                     'TMP.750_mb': 20.4747314453125,
                     'TMP.7_mb': 23.841415405273438,
                     'TMP.800_mb': 20.6649169921875,
                     'TMP.80_m_above_ground': 18.402587890625,
                     'TMP.850_mb': 22.516876220703125,
                     'TMP.900_mb': 22.767929077148438,
                     'TMP.925_mb': 22.882461547851562,
                     'TMP.950_mb': 22.997909545898438,
                     'TMP.975_mb': 23.116958618164062,
                     'TMP.PV2e06Km2kgs_surface': 98.42231750488281,
                     'TMP.PVNeg2e06Km2kgs_surface': 98.96597290039062,
                     'TMP.max_wind': 84.07876586914062,
                     'TMP.surface': 37.64898681640625,
                     'TMP.tropopause': 76.32827758789062,
                     'TOZNE.entire_atmosphere_considered_as_a_single_layer': 92.03948974609375,
                     'TSOIL.0-0.1_m_below_ground': 11.6380615234375,
                     'TSOIL.0.1-0.4_m_below_ground': 2.010009765625,
                     'TSOIL.0.4-1_m_below_ground': 0.17193603515625,
                     'TSOIL.1-2_m_below_ground': 0.060028076171875,
                     'UGRD.0.01_mb': 211.77955627441406,
                     'UGRD.0.02_mb': 205.92062377929688,
                     'UGRD.0.04_mb': 154.195556640625,
                     'UGRD.0.07_mb': 135.483154296875,
                     'UGRD.0.1_mb': 146.99200439453125,
                     'UGRD.0.2_mb': 146.41314697265625,
                     'UGRD.0.4_mb': 133.41941833496094,
                     'UGRD.0.7_mb': 125.19096374511719,
                     'UGRD.0.995_sigma_level': 59.01681137084961,
                     'UGRD.1000_mb': 49.56956100463867,
                     'UGRD.100_m_above_ground': 62.83436965942383,
                     'UGRD.100_mb': 54.71441650390625,
                     'UGRD.10_m_above_ground': 51.32102966308594,
                     'UGRD.10_mb': 51.564815521240234,
                     'UGRD.150_mb': 46.520164489746094,
                     'UGRD.15_mb': 36.67009735107422,
                     'UGRD.1829_m_above_mean_sea_level': 58.44329071044922,
                     'UGRD.1_mb': 102.88461303710938,
                     'UGRD.200_mb': 49.43223571777344,
                     'UGRD.20_m_above_ground': 52.5506591796875,
                     'UGRD.20_mb': 50.39271926879883,
                     'UGRD.250_mb': 67.28775024414062,
                     'UGRD.2743_m_above_mean_sea_level': 57.531227111816406,
                     'UGRD.2_mb': 97.51185607910156,
                     'UGRD.30-0_mb_above_ground': 62.56573486328125,
                     'UGRD.300_mb': 66.30523681640625,
                     'UGRD.30_m_above_ground': 55.58555603027344,
                     'UGRD.30_mb': 35.215633392333984,
                     'UGRD.350_mb': 63.31383514404297,
                     'UGRD.3658_m_above_mean_sea_level': 52.11595916748047,
                     'UGRD.3_mb': 82.23007202148438,
                     'UGRD.400_mb': 58.17995834350586,
                     'UGRD.40_m_above_ground': 57.26095199584961,
                     'UGRD.40_mb': 29.732452392578125,
                     'UGRD.450_mb': 51.2109375,
                     'UGRD.500_mb': 47.22601318359375,
                     'UGRD.50_m_above_ground': 58.74461364746094,
                     'UGRD.50_mb': 27.539682388305664,
                     'UGRD.550_mb': 46.86212921142578,
                     'UGRD.5_mb': 61.52499771118164,
                     'UGRD.600_mb': 47.92829513549805,
                     'UGRD.650_mb': 52.39904022216797,
                     'UGRD.700_mb': 56.90531921386719,
                     'UGRD.70_mb': 28.028852462768555,
                     'UGRD.750_mb': 55.92859649658203,
                     'UGRD.7_mb': 62.38838195800781,
                     'UGRD.800_mb': 57.48130798339844,
                     'UGRD.80_m_above_ground': 61.596595764160156,
                     'UGRD.850_mb': 67.83033752441406,
                     'UGRD.900_mb': 67.69282531738281,
                     'UGRD.925_mb': 70.1024169921875,
                     'UGRD.950_mb': 67.22605895996094,
                     'UGRD.975_mb': 59.896820068359375,
                     'UGRD.PV2e06Km2kgs_surface': 87.76675415039062,
                     'UGRD.PVNeg2e06Km2kgs_surface': 86.28178405761719,
                     'UGRD.max_wind': 82.37673950195312,
                     'UGRD.planetary_boundary_layer': 64.3605728149414,
                     'UGRD.tropopause': 70.73137664794922,
                     'USTM.6000-0_m_above_ground': 51.395973205566406,
                     'VEG.surface': 2.3000030517578125,
                     'VGRD.0.01_mb': 155.31272888183594,
                     'VGRD.0.02_mb': 140.61703491210938,
                     'VGRD.0.04_mb': 118.86079406738281,
                     'VGRD.0.07_mb': 124.54621887207031,
                     'VGRD.0.1_mb': 110.0694580078125,
                     'VGRD.0.2_mb': 100.70065307617188,
                     'VGRD.0.4_mb': 90.72100830078125,
                     'VGRD.0.7_mb': 95.35831451416016,
                     'VGRD.0.995_sigma_level': 59.97898864746094,
                     'VGRD.1000_mb': 51.17951202392578,
                     'VGRD.100_m_above_ground': 63.24536895751953,
                     'VGRD.100_mb': 43.722312927246094,
                     'VGRD.10_m_above_ground': 52.147918701171875,
                     'VGRD.10_mb': 40.20417785644531,
                     'VGRD.150_mb': 49.333309173583984,
                     'VGRD.15_mb': 28.808969497680664,
                     'VGRD.1829_m_above_mean_sea_level': 62.901920318603516,
                     'VGRD.1_mb': 92.2905502319336,
                     'VGRD.200_mb': 57.293548583984375,
                     'VGRD.20_m_above_ground': 53.18124008178711,
                     'VGRD.20_mb': 37.182533264160156,
                     'VGRD.250_mb': 66.60144805908203,
                     'VGRD.2743_m_above_mean_sea_level': 59.42354202270508,
                     'VGRD.2_mb': 82.73554992675781,
                     'VGRD.30-0_mb_above_ground': 62.781333923339844,
                     'VGRD.300_mb': 82.64964294433594,
                     'VGRD.30_m_above_ground': 55.96978759765625,
                     'VGRD.30_mb': 29.32110023498535,
                     'VGRD.350_mb': 101.09928131103516,
                     'VGRD.3658_m_above_mean_sea_level': 56.10468292236328,
                     'VGRD.3_mb': 75.5891342163086,
                     'VGRD.400_mb': 100.08196258544922,
                     'VGRD.40_m_above_ground': 57.84511184692383,
                     'VGRD.40_mb': 29.059207916259766,
                     'VGRD.450_mb': 93.423095703125,
                     'VGRD.500_mb': 81.13493347167969,
                     'VGRD.50_m_above_ground': 59.2175407409668,
                     'VGRD.50_mb': 29.341800689697266,
                     'VGRD.550_mb': 69.69515991210938,
                     'VGRD.5_mb': 54.506935119628906,
                     'VGRD.600_mb': 60.94965362548828,
                     'VGRD.650_mb': 56.176239013671875,
                     'VGRD.700_mb': 58.52985382080078,
                     'VGRD.70_mb': 34.251182556152344,
                     'VGRD.750_mb': 60.11085891723633,
                     'VGRD.7_mb': 53.659339904785156,
                     'VGRD.800_mb': 63.42332077026367,
                     'VGRD.80_m_above_ground': 62.040489196777344,
                     'VGRD.850_mb': 65.2305908203125,
                     'VGRD.900_mb': 68.91371154785156,
                     'VGRD.925_mb': 69.76022338867188,
                     'VGRD.950_mb': 69.43519592285156,
                     'VGRD.975_mb': 66.08795166015625,
                     'VGRD.PV2e06Km2kgs_surface': 73.47386932373047,
                     'VGRD.PVNeg2e06Km2kgs_surface': 84.85733032226562,
                     'VGRD.max_wind': 103.26702880859375,
                     'VGRD.planetary_boundary_layer': 66.74078369140625,
                     'VGRD.tropopause': 74.80692291259766,
                     'VIS.surface': 24114.478515625,
                     'VRATE.planetary_boundary_layer': 146000.0,
                     'VSTM.6000-0_m_above_ground': 56.47290802001953,
                     'VVEL.0.01_mb': 0.0040095108561217785,
                     'VVEL.0.02_mb': 0.00489443214610219,
                     'VVEL.0.04_mb': 0.016353869810700417,
                     'VVEL.0.07_mb': 0.03744598850607872,
                     'VVEL.0.1_mb': 0.053355079144239426,
                     'VVEL.0.2_mb': 0.07129305601119995,
                     'VVEL.0.4_mb': 0.12464386224746704,
                     'VVEL.0.7_mb': 0.1710047721862793,
                     'VVEL.0.995_sigma_level': 12.541711807250977,
                     'VVEL.1000_mb': 9.51446533203125,
                     'VVEL.100_mb': 11.333382606506348,
                     'VVEL.10_mb': 0.700727105140686,
                     'VVEL.150_mb': 26.38214683532715,
                     'VVEL.15_mb': 1.1995142698287964,
                     'VVEL.1_mb': 0.21297642588615417,
                     'VVEL.200_mb': 32.812294006347656,
                     'VVEL.20_mb': 1.3387041091918945,
                     'VVEL.250_mb': 37.28593826293945,
                     'VVEL.2_mb': 0.29872119426727295,
                     'VVEL.300_mb': 40.77818298339844,
                     'VVEL.30_mb': 1.5222172737121582,
                     'VVEL.350_mb': 44.0899772644043,
                     'VVEL.3_mb': 0.39455604553222656,
                     'VVEL.400_mb': 46.50054931640625,
                     'VVEL.40_mb': 1.5748908519744873,
                     'VVEL.450_mb': 46.28952407836914,
                     'VVEL.500_mb': 43.92531967163086,
                     'VVEL.50_mb': 2.1125199794769287,
                     'VVEL.550_mb': 40.97178268432617,
                     'VVEL.5_mb': 0.4668888449668884,
                     'VVEL.600_mb': 42.75829315185547,
                     'VVEL.650_mb': 42.46519088745117,
                     'VVEL.700_mb': 40.53398895263672,
                     'VVEL.70_mb': 2.671006679534912,
                     'VVEL.750_mb': 36.893062591552734,
                     'VVEL.7_mb': 0.5895137786865234,
                     'VVEL.800_mb': 31.415334701538086,
                     'VVEL.850_mb': 24.927249908447266,
                     'VVEL.900_mb': 18.53434944152832,
                     'VVEL.925_mb': 15.020877838134766,
                     'VVEL.950_mb': 11.304717063903809,
                     'VVEL.975_mb': 9.513252258300781,
                     'VWSH.PV2e06Km2kgs_surface': 0.1412809193134308,
                     'VWSH.PVNeg2e06Km2kgs_surface': 0.1379464864730835,
                     'VWSH.tropopause': 0.13525967299938202,
                     'WEASD.surface': 51.5359992980957,
                     'WILT.surface': 0.004500001668930054}
FORECAST_DIFF_MIN = {'4LFTX.surface': -19.72224998474121,
                     'ABSV.0.01_mb': -0.002463428769260645,
                     'ABSV.0.02_mb': -0.0026119141839444637,
                     'ABSV.0.04_mb': -0.004528461489826441,
                     'ABSV.0.07_mb': -0.005725424736738205,
                     'ABSV.0.1_mb': -0.00784227903932333,
                     'ABSV.0.2_mb': -0.008138989098370075,
                     'ABSV.0.4_mb': -0.006691649090498686,
                     'ABSV.0.7_mb': -0.0046936278231441975,
                     'ABSV.1000_mb': -0.00491680670529604,
                     'ABSV.100_mb': -0.002766867633908987,
                     'ABSV.10_mb': -0.003545232117176056,
                     'ABSV.150_mb': -0.0026073025073856115,
                     'ABSV.15_mb': -0.0025844171177595854,
                     'ABSV.1_mb': -0.004549911245703697,
                     'ABSV.200_mb': -0.0023845338728278875,
                     'ABSV.20_mb': -0.0028492207638919353,
                     'ABSV.250_mb': -0.0030810292810201645,
                     'ABSV.2_mb': -0.0071651809848845005,
                     'ABSV.300_mb': -0.0024686031974852085,
                     'ABSV.30_mb': -0.0017707842634990811,
                     'ABSV.350_mb': -0.0025561705697327852,
                     'ABSV.3_mb': -0.0036445874720811844,
                     'ABSV.400_mb': -0.002387041924521327,
                     'ABSV.40_mb': -0.001410948927514255,
                     'ABSV.450_mb': -0.0024385503493249416,
                     'ABSV.500_mb': -0.002616891171783209,
                     'ABSV.50_mb': -0.0016129338182508945,
                     'ABSV.550_mb': -0.0029264187905937433,
                     'ABSV.5_mb': -0.006033552344888449,
                     'ABSV.600_mb': -0.0032787576783448458,
                     'ABSV.650_mb': -0.0034777019172906876,
                     'ABSV.700_mb': -0.003507733577862382,
                     'ABSV.70_mb': -0.00178053742274642,
                     'ABSV.750_mb': -0.003367624944075942,
                     'ABSV.7_mb': -0.003108703065663576,
                     'ABSV.800_mb': -0.0032865984831005335,
                     'ABSV.850_mb': -0.00343856168910861,
                     'ABSV.900_mb': -0.003891389351338148,
                     'ABSV.925_mb': -0.003990439232438803,
                     'ABSV.950_mb': -0.004035654477775097,
                     'ABSV.975_mb': -0.003909999504685402,
                     'APTMP.2_m_above_ground': -36.12815856933594,
                     'CAPE.180-0_mb_above_ground': -3745.0,
                     'CAPE.255-0_mb_above_ground': -4406.0,
                     'CAPE.90-0_mb_above_ground': -3868.0,
                     'CAPE.surface': -4740.0,
                     'CFRZR.surface': -1.0,
                     'CICEP.surface': -1.0,
                     'CIN.180-0_mb_above_ground': -3115.606689453125,
                     'CIN.255-0_mb_above_ground': -2604.64697265625,
                     'CIN.90-0_mb_above_ground': -3775.853515625,
                     'CIN.surface': -2315.816162109375,
                     'CLMR.1000_mb': -0.0010330199729651213,
                     'CLMR.100_mb': -1.0526800107600251e-13,
                     'CLMR.150_mb': -2.7514400571987585e-22,
                     'CLMR.1_hybrid_level': -0.0017316399607807398,
                     'CLMR.200_mb': -4.094079849892296e-05,
                     'CLMR.250_mb': -0.0007655840017832816,
                     'CLMR.300_mb': -0.0010419200407341123,
                     'CLMR.350_mb': -0.001288959989324212,
                     'CLMR.400_mb': -0.001684800023213029,
                     'CLMR.450_mb': -0.001850640051998198,
                     'CLMR.500_mb': -0.001620320021174848,
                     'CLMR.50_mb': 0.0,
                     'CLMR.550_mb': -0.0014904799172654748,
                     'CLMR.600_mb': -0.0015062199672684073,
                     'CLMR.650_mb': -0.0012552000116556883,
                     'CLMR.700_mb': -0.0011896600481122732,
                     'CLMR.750_mb': -0.0011973800137639046,
                     'CLMR.800_mb': -0.0012184199877083302,
                     'CLMR.850_mb': -0.0012125199427828193,
                     'CLMR.900_mb': -0.0012021800503134727,
                     'CLMR.925_mb': -0.001163859968073666,
                     'CLMR.950_mb': -0.0010473399888724089,
                     'CLMR.975_mb': -0.001087479991838336,
                     'CNWAT.surface': -0.5,
                     'CPOFP.surface': -150.0,
                     'CRAIN.surface': -1.0,
                     'CSNOW.surface': -1.0,
                     'CWAT.entire_atmosphere_considered_as_a_single_layer': -6.680879592895508,
                     'DPT.2_m_above_ground': -56.542449951171875,
                     'DZDT.0.01_mb': -11.835406303405762,
                     'DZDT.0.02_mb': -10.357695579528809,
                     'DZDT.0.04_mb': -20.134906768798828,
                     'DZDT.0.07_mb': -28.103456497192383,
                     'DZDT.0.1_mb': -30.035114288330078,
                     'DZDT.0.2_mb': -24.072166442871094,
                     'DZDT.0.4_mb': -23.622039794921875,
                     'DZDT.0.7_mb': -16.86393928527832,
                     'DZDT.1000_mb': -0.8972687721252441,
                     'DZDT.100_mb': -3.764458417892456,
                     'DZDT.10_mb': -3.919875144958496,
                     'DZDT.150_mb': -6.878611087799072,
                     'DZDT.15_mb': -4.422532081604004,
                     'DZDT.1_mb': -12.408648490905762,
                     'DZDT.200_mb': -6.784226417541504,
                     'DZDT.20_mb': -3.5416624546051025,
                     'DZDT.250_mb': -6.938621997833252,
                     'DZDT.2_mb': -8.296363830566406,
                     'DZDT.300_mb': -6.744225025177002,
                     'DZDT.30_mb': -2.630289316177368,
                     'DZDT.350_mb': -6.5522871017456055,
                     'DZDT.3_mb': -8.49594497680664,
                     'DZDT.400_mb': -6.201003074645996,
                     'DZDT.40_mb': -2.1052446365356445,
                     'DZDT.450_mb': -5.898669242858887,
                     'DZDT.500_mb': -5.223843574523926,
                     'DZDT.50_mb': -2.411503314971924,
                     'DZDT.550_mb': -5.002318859100342,
                     'DZDT.5_mb': -5.487509727478027,
                     'DZDT.600_mb': -4.674792766571045,
                     'DZDT.650_mb': -4.186266899108887,
                     'DZDT.700_mb': -3.608410596847534,
                     'DZDT.70_mb': -2.0347776412963867,
                     'DZDT.750_mb': -3.030512809753418,
                     'DZDT.7_mb': -4.483044624328613,
                     'DZDT.800_mb': -2.478209972381592,
                     'DZDT.850_mb': -1.933058738708496,
                     'DZDT.900_mb': -1.464558720588684,
                     'DZDT.925_mb': -1.160050868988037,
                     'DZDT.950_mb': -0.8972687721252441,
                     'DZDT.975_mb': -0.8972687721252441,
                     'FLDCP.surface': -0.001900017261505127,
                     'FRICV.surface': -1.9337671995162964,
                     'GRLE.1000_mb': -0.0005329599953256547,
                     'GRLE.100_mb': -0.005001100245863199,
                     'GRLE.150_mb': -0.007583520375192165,
                     'GRLE.1_hybrid_level': -0.002049200003966689,
                     'GRLE.200_mb': -0.008887839503586292,
                     'GRLE.250_mb': -0.010177398100495338,
                     'GRLE.300_mb': -0.010962201282382011,
                     'GRLE.350_mb': -0.01042131893336773,
                     'GRLE.400_mb': -0.010252919048070908,
                     'GRLE.450_mb': -0.009482080116868019,
                     'GRLE.500_mb': -0.00840080063790083,
                     'GRLE.50_mb': -8.77889494432793e-09,
                     'GRLE.550_mb': -0.0072396802715957165,
                     'GRLE.600_mb': -0.00651552015915513,
                     'GRLE.650_mb': -0.005076160188764334,
                     'GRLE.700_mb': -0.004427520092576742,
                     'GRLE.750_mb': -0.003723680041730404,
                     'GRLE.800_mb': -0.002554000122472644,
                     'GRLE.850_mb': -0.0023842400405555964,
                     'GRLE.900_mb': -0.001741599990054965,
                     'GRLE.925_mb': -0.001716200029477477,
                     'GRLE.950_mb': -0.001629880047403276,
                     'GRLE.975_mb': -0.001162879983894527,
                     'GUST.surface': -37.7892951965332,
                     'HCDC.high_cloud_layer': -100.0,
                     'HGT.0.01_mb': -3183.5859375,
                     'HGT.0.02_mb': -3071.3515625,
                     'HGT.0.04_mb': -2484.484375,
                     'HGT.0.07_mb': -1669.140625,
                     'HGT.0.1_mb': -1226.2890625,
                     'HGT.0.2_mb': -1746.33984375,
                     'HGT.0.4_mb': -1843.296875,
                     'HGT.0.7_mb': -1399.671875,
                     'HGT.0C_isotherm': -4839.83984375,
                     'HGT.1000_mb': -317.58135986328125,
                     'HGT.100_mb': -102.560546875,
                     'HGT.10_mb': -397.14453125,
                     'HGT.150_mb': -123.3701171875,
                     'HGT.15_mb': -291.837890625,
                     'HGT.1_mb': -1165.2890625,
                     'HGT.200_mb': -171.5390625,
                     'HGT.20_mb': -193.4453125,
                     'HGT.250_mb': -244.65625,
                     'HGT.2_mb': -807.98046875,
                     'HGT.300_mb': -299.5869140625,
                     'HGT.30_mb': -164.7890625,
                     'HGT.350_mb': -321.6708984375,
                     'HGT.3_mb': -586.421875,
                     'HGT.400_mb': -311.11083984375,
                     'HGT.40_mb': -134.53125,
                     'HGT.450_mb': -281.275390625,
                     'HGT.500_mb': -246.76513671875,
                     'HGT.50_mb': -121.521484375,
                     'HGT.550_mb': -216.13037109375,
                     'HGT.5_mb': -476.296875,
                     'HGT.600_mb': -186.37109375,
                     'HGT.650_mb': -174.280029296875,
                     'HGT.700_mb': -177.69775390625,
                     'HGT.70_mb': -113.55859375,
                     'HGT.750_mb': -180.579833984375,
                     'HGT.7_mb': -429.392578125,
                     'HGT.800_mb': -194.437744140625,
                     'HGT.850_mb': -227.363525390625,
                     'HGT.900_mb': -258.760009765625,
                     'HGT.925_mb': -273.92486572265625,
                     'HGT.950_mb': -288.78338623046875,
                     'HGT.975_mb': -303.32061767578125,
                     'HGT.PV2e06Km2kgs_surface': -17904.056640625,
                     'HGT.PVNeg2e06Km2kgs_surface': -18029.962890625,
                     'HGT.cloud_ceiling': -19998.494140625,
                     'HGT.highest_tropospheric_freezing_level': -3418.079833984375,
                     'HGT.max_wind': -10848.7177734375,
                     'HGT.surface': 0.0,
                     'HGT.tropopause': -13518.7421875,
                     'HINDEX.surface': -4.0,
                     'HLCY.3000-0_m_above_ground': -2273.534912109375,
                     'HPBL.surface': -6711.2333984375,
                     'ICAHT.max_wind': -10342.12109375,
                     'ICAHT.tropopause': -14707.0927734375,
                     'ICEC.surface': 0.0,
                     'ICEG.10_m_above_mean_sea_level': -0.00021230000129435211,
                     'ICETK.surface': -0.0599999874830246,
                     'ICETMP.surface': -22.106353759765625,
                     'ICMR.1000_mb': -0.00013765599578619003,
                     'ICMR.100_mb': -0.0014788000844419003,
                     'ICMR.150_mb': -0.0017429599538445473,
                     'ICMR.1_hybrid_level': -0.0003332319902256131,
                     'ICMR.200_mb': -0.00162240001372993,
                     'ICMR.250_mb': -0.0017890799790620804,
                     'ICMR.300_mb': -0.001354640000499785,
                     'ICMR.350_mb': -0.001257259980775416,
                     'ICMR.400_mb': -0.001109680044464767,
                     'ICMR.450_mb': -0.0009775999933481216,
                     'ICMR.500_mb': -0.0008695360156707466,
                     'ICMR.50_mb': -1.2272720368855516e-06,
                     'ICMR.550_mb': -0.0008131840149872005,
                     'ICMR.600_mb': -0.0007394399726763368,
                     'ICMR.650_mb': -0.0006574720027856529,
                     'ICMR.700_mb': -0.0006371199851855636,
                     'ICMR.750_mb': -0.0005671519902534783,
                     'ICMR.800_mb': -0.0004744559992104769,
                     'ICMR.850_mb': -0.0003869920037686825,
                     'ICMR.900_mb': -0.00031386400223709643,
                     'ICMR.925_mb': -0.0002680879842955619,
                     'ICMR.950_mb': -0.00020786799723282456,
                     'ICMR.975_mb': -0.0002318399929208681,
                     'LAND.surface': 0.0,
                     'LCDC.low_cloud_layer': -100.0,
                     'LFTX.surface': -24.30722999572754,
                     'MCDC.middle_cloud_layer': -100.0,
                     'MSLET.mean_sea_level': -2401.078125,
                     'O3MR.0.01_mb': -3.731973947651568e-07,
                     'O3MR.0.02_mb': -4.915978024655487e-07,
                     'O3MR.0.04_mb': -6.757873052265495e-07,
                     'O3MR.0.07_mb': -8.589188382757129e-07,
                     'O3MR.0.1_mb': -1.1038240472771577e-06,
                     'O3MR.0.2_mb': -1.3193491668062052e-06,
                     'O3MR.0.4_mb': -2.495095714039053e-06,
                     'O3MR.0.7_mb': -4.741605152958073e-06,
                     'O3MR.1000_mb': -4.5090605027553465e-08,
                     'O3MR.100_mb': -2.943536401289748e-06,
                     'O3MR.10_mb': -5.9686030908778775e-06,
                     'O3MR.150_mb': -2.0990401026210748e-06,
                     'O3MR.15_mb': -5.405713181971805e-06,
                     'O3MR.1_mb': -6.782302079955116e-06,
                     'O3MR.200_mb': -1.0679805200197734e-06,
                     'O3MR.20_mb': -4.8454799070896115e-06,
                     'O3MR.250_mb': -7.311706440304988e-07,
                     'O3MR.2_mb': -7.67382425692631e-06,
                     'O3MR.300_mb': -6.441143227675639e-07,
                     'O3MR.30_mb': -2.773566393443616e-06,
                     'O3MR.350_mb': -5.481014113684068e-07,
                     'O3MR.3_mb': -9.807142305362504e-06,
                     'O3MR.400_mb': -4.522067058587709e-07,
                     'O3MR.40_mb': -3.0192072699719574e-06,
                     'O3MR.450_mb': -3.4717334074230166e-07,
                     'O3MR.500_mb': -2.900317781495687e-07,
                     'O3MR.50_mb': -3.638690941443201e-06,
                     'O3MR.550_mb': -2.341090521440492e-07,
                     'O3MR.5_mb': -2.0495075659709983e-05,
                     'O3MR.600_mb': -2.106929315459638e-07,
                     'O3MR.650_mb': -1.4576562534784898e-07,
                     'O3MR.700_mb': -8.634995651846111e-08,
                     'O3MR.70_mb': -3.688072411023313e-06,
                     'O3MR.750_mb': -6.830830301396418e-08,
                     'O3MR.7_mb': -6.364887212839676e-06,
                     'O3MR.800_mb': -6.69777264761251e-08,
                     'O3MR.850_mb': -6.188494694470137e-08,
                     'O3MR.900_mb': -6.120973239376326e-08,
                     'O3MR.925_mb': -5.360645616292459e-08,
                     'O3MR.950_mb': -5.595028795823964e-08,
                     'O3MR.975_mb': -4.5090512656997817e-08,
                     'PLPL.255-0_mb_above_ground': -31159.7265625,
                     'POT.0.995_sigma_level': -25.343231201171875,
                     'PRATE.surface': -0.03333279862999916,
                     'PRES.80_m_above_ground': -2240.2265625,
                     'PRES.PV2e06Km2kgs_surface': -74971.2109375,
                     'PRES.PVNeg2e06Km2kgs_surface': -74963.203125,
                     'PRES.max_wind': -39575.2421875,
                     'PRES.surface': -2260.3125,
                     'PRES.tropopause': -44690.40234375,
                     'PRMSL.mean_sea_level': -4542.3359375,
                     'PWAT.entire_atmosphere_considered_as_a_single_layer': -37.13714599609375,
                     'REFC.entire_atmosphere': -74.05000305175781,
                     'REFD.1000_m_above_ground': -74.30000305175781,
                     'REFD.1_hybrid_level': -74.31999969482422,
                     'REFD.2_hybrid_level': -74.33000183105469,
                     'REFD.4000_m_above_ground': -72.22999572753906,
                     'RH.0.01_mb': -0.10000000149011612,
                     'RH.0.02_mb': -0.20000000298023224,
                     'RH.0.04_mb': -0.5,
                     'RH.0.07_mb': -0.800000011920929,
                     'RH.0.1_mb': -0.4000000059604645,
                     'RH.0.2_mb': 0.0,
                     'RH.0.33-1_sigma_layer': -88.79999542236328,
                     'RH.0.44-0.72_sigma_layer': -99.4000015258789,
                     'RH.0.44-1_sigma_layer': -85.5,
                     'RH.0.4_mb': 0.0,
                     'RH.0.72-0.94_sigma_layer': -95.5,
                     'RH.0.7_mb': 0.0,
                     'RH.0.995_sigma_level': -82.0,
                     'RH.0C_isotherm': -99.0,
                     'RH.1000_mb': -81.9000015258789,
                     'RH.100_mb': -96.0,
                     'RH.10_mb': -32.89999771118164,
                     'RH.150_mb': -100.0,
                     'RH.15_mb': -40.70000076293945,
                     'RH.1_mb': -0.10000000149011612,
                     'RH.200_mb': -100.0,
                     'RH.20_mb': -56.0,
                     'RH.250_mb': -100.0,
                     'RH.2_m_above_ground': -98.0999984741211,
                     'RH.2_mb': -3.200000047683716,
                     'RH.30-0_mb_above_ground': -79.69999694824219,
                     'RH.300_mb': -100.0,
                     'RH.30_mb': -76.5,
                     'RH.350_mb': -100.0,
                     'RH.3_mb': -5.0,
                     'RH.400_mb': -100.0,
                     'RH.40_mb': -79.60000610351562,
                     'RH.450_mb': -100.0,
                     'RH.500_mb': -100.0,
                     'RH.50_mb': -59.39999771118164,
                     'RH.550_mb': -100.0,
                     'RH.5_mb': -26.799999237060547,
                     'RH.600_mb': -100.0,
                     'RH.650_mb': -100.0,
                     'RH.700_mb': -100.0,
                     'RH.70_mb': -83.30000305175781,
                     'RH.750_mb': -100.0,
                     'RH.7_mb': -33.599998474121094,
                     'RH.800_mb': -100.0,
                     'RH.850_mb': -100.0,
                     'RH.900_mb': -99.69999694824219,
                     'RH.925_mb': -97.10000610351562,
                     'RH.950_mb': -97.0,
                     'RH.975_mb': -92.4000015258789,
                     'RH.entire_atmosphere_considered_as_a_single_layer': -60.29999923706055,
                     'RH.highest_tropospheric_freezing_level': -99.0,
                     'RWMR.1000_mb': -0.0034690399188548326,
                     'RWMR.100_mb': -1.649666003800121e-08,
                     'RWMR.150_mb': -5.054829443906783e-08,
                     'RWMR.1_hybrid_level': -0.004381360020488501,
                     'RWMR.200_mb': -6.001578611858349e-08,
                     'RWMR.250_mb': -7.329606432904257e-08,
                     'RWMR.300_mb': -4.711711483196268e-07,
                     'RWMR.350_mb': -1.2637874533538707e-05,
                     'RWMR.400_mb': -2.8363483579596505e-05,
                     'RWMR.450_mb': -0.00012277759378775954,
                     'RWMR.500_mb': -0.0021670798305422068,
                     'RWMR.50_mb': -1.923691428373786e-09,
                     'RWMR.550_mb': -0.0037299999967217445,
                     'RWMR.600_mb': -0.005084479693323374,
                     'RWMR.650_mb': -0.004832640290260315,
                     'RWMR.700_mb': -0.005067920312285423,
                     'RWMR.750_mb': -0.0051453597843647,
                     'RWMR.800_mb': -0.005071519874036312,
                     'RWMR.850_mb': -0.004969120025634766,
                     'RWMR.900_mb': -0.004784639924764633,
                     'RWMR.925_mb': -0.0046804798766970634,
                     'RWMR.950_mb': -0.00457039987668395,
                     'RWMR.975_mb': -0.004450399894267321,
                     'SFCR.surface': -0.010000000707805157,
                     'SNMR.1000_mb': -0.0010060879867523909,
                     'SNMR.100_mb': -0.0011276534060016274,
                     'SNMR.150_mb': -0.001392699428834021,
                     'SNMR.1_hybrid_level': -0.0014439999358728528,
                     'SNMR.200_mb': -0.002138039330020547,
                     'SNMR.250_mb': -0.0024672800209373236,
                     'SNMR.300_mb': -0.002394279930740595,
                     'SNMR.350_mb': -0.0023945600260049105,
                     'SNMR.400_mb': -0.002126519801095128,
                     'SNMR.450_mb': -0.0020454400219023228,
                     'SNMR.500_mb': -0.0018921600421890616,
                     'SNMR.50_mb': -6.925018780634673e-09,
                     'SNMR.550_mb': -0.0016151199815794826,
                     'SNMR.600_mb': -0.0014519999967887998,
                     'SNMR.650_mb': -0.0013653599889948964,
                     'SNMR.700_mb': -0.0013113999739289284,
                     'SNMR.750_mb': -0.0015212399885058403,
                     'SNMR.800_mb': -0.0013204000424593687,
                     'SNMR.850_mb': -0.0011636200360953808,
                     'SNMR.900_mb': -0.001100927940569818,
                     'SNMR.925_mb': -0.0010234119836241007,
                     'SNMR.950_mb': -0.001300767995417118,
                     'SNMR.975_mb': -0.001166176050901413,
                     'SNOD.surface': -0.49959999322891235,
                     'SOILL.0-0.1_m_below_ground': -0.1080000102519989,
                     'SOILL.0.1-0.4_m_below_ground': -0.05300000309944153,
                     'SOILL.0.4-1_m_below_ground': -0.02899998426437378,
                     'SOILL.1-2_m_below_ground': -0.006999999284744263,
                     'SOILW.0-0.1_m_below_ground': -0.1080000102519989,
                     'SOILW.0.1-0.4_m_below_ground': -0.05300000309944153,
                     'SOILW.0.4-1_m_below_ground': -0.02899998426437378,
                     'SOILW.1-2_m_below_ground': -0.006999999284744263,
                     'SOTYP.surface': 0.0,
                     'SPFH.0.01_mb': -3.602873903219006e-06,
                     'SPFH.0.02_mb': -3.718822426890256e-06,
                     'SPFH.0.04_mb': -3.850732809951296e-06,
                     'SPFH.0.07_mb': -3.83088718081126e-06,
                     'SPFH.0.1_mb': -3.709505108417943e-06,
                     'SPFH.0.2_mb': -3.251019506933517e-06,
                     'SPFH.0.4_mb': -2.9240318326628767e-06,
                     'SPFH.0.7_mb': -3.299522404631716e-06,
                     'SPFH.1000_mb': -0.018408089876174927,
                     'SPFH.100_mb': -1.4409820323635358e-05,
                     'SPFH.10_mb': -3.043029209948145e-06,
                     'SPFH.150_mb': -6.122246850281954e-05,
                     'SPFH.15_mb': -2.8757935979228932e-06,
                     'SPFH.1_mb': -3.377644588908879e-06,
                     'SPFH.200_mb': -0.000260434317169711,
                     'SPFH.20_mb': -2.7899668566533364e-06,
                     'SPFH.250_mb': -0.000797158689238131,
                     'SPFH.2_m_above_ground': -0.016041580587625504,
                     'SPFH.2_mb': -3.6470319173531607e-06,
                     'SPFH.30-0_mb_above_ground': -0.01593804359436035,
                     'SPFH.300_mb': -0.0018753964686766267,
                     'SPFH.30_mb': -2.640541879372904e-06,
                     'SPFH.350_mb': -0.0030029388144612312,
                     'SPFH.3_mb': -3.681462430904503e-06,
                     'SPFH.400_mb': -0.00447124894708395,
                     'SPFH.40_mb': -2.528693585190922e-06,
                     'SPFH.450_mb': -0.005523093976080418,
                     'SPFH.500_mb': -0.006831750739365816,
                     'SPFH.50_mb': -1.9475928638712503e-05,
                     'SPFH.550_mb': -0.007565823849290609,
                     'SPFH.5_mb': -3.172704509779578e-06,
                     'SPFH.600_mb': -0.008618216961622238,
                     'SPFH.650_mb': -0.009983358904719353,
                     'SPFH.700_mb': -0.010043914429843426,
                     'SPFH.70_mb': -1.606706064194441e-05,
                     'SPFH.750_mb': -0.011393805034458637,
                     'SPFH.7_mb': -3.1360582397610415e-06,
                     'SPFH.800_mb': -0.011796174570918083,
                     'SPFH.80_m_above_ground': -0.016070356592535973,
                     'SPFH.850_mb': -0.013021259568631649,
                     'SPFH.900_mb': -0.01475194189697504,
                     'SPFH.925_mb': -0.015642890706658363,
                     'SPFH.950_mb': -0.01654905267059803,
                     'SPFH.975_mb': -0.01747140660881996,
                     'SUNSD.surface': -21600.0,
                     'TCDC.1000_mb': -100.0,
                     'TCDC.100_mb': -100.0,
                     'TCDC.150_mb': -100.0,
                     'TCDC.200_mb': -100.0,
                     'TCDC.250_mb': -100.0,
                     'TCDC.300_mb': -100.0,
                     'TCDC.350_mb': -100.0,
                     'TCDC.400_mb': -100.0,
                     'TCDC.450_mb': -100.0,
                     'TCDC.500_mb': -100.0,
                     'TCDC.50_mb': -100.0,
                     'TCDC.550_mb': -100.0,
                     'TCDC.600_mb': -100.0,
                     'TCDC.650_mb': -100.0,
                     'TCDC.700_mb': -100.0,
                     'TCDC.750_mb': -100.0,
                     'TCDC.800_mb': -100.0,
                     'TCDC.850_mb': -100.0,
                     'TCDC.900_mb': -100.0,
                     'TCDC.925_mb': -100.0,
                     'TCDC.950_mb': -100.0,
                     'TCDC.975_mb': -100.0,
                     'TCDC.entire_atmosphere': -100.0,
                     'TMP.0.01_mb': -30.291183471679688,
                     'TMP.0.02_mb': -45.56895446777344,
                     'TMP.0.04_mb': -63.54911804199219,
                     'TMP.0.07_mb': -72.68096923828125,
                     'TMP.0.1_mb': -57.27418518066406,
                     'TMP.0.2_mb': -48.87835693359375,
                     'TMP.0.4_mb': -57.34307861328125,
                     'TMP.0.7_mb': -58.78173828125,
                     'TMP.0.995_sigma_level': -24.899993896484375,
                     'TMP.1000_mb': -25.567718505859375,
                     'TMP.100_m_above_ground': -21.948684692382812,
                     'TMP.100_mb': -15.371719360351562,
                     'TMP.10_mb': -21.88055419921875,
                     'TMP.150_mb': -14.511428833007812,
                     'TMP.15_mb': -18.612899780273438,
                     'TMP.1829_m_above_mean_sea_level': -18.246673583984375,
                     'TMP.1_mb': -60.551483154296875,
                     'TMP.200_mb': -20.954025268554688,
                     'TMP.20_mb': -16.695663452148438,
                     'TMP.250_mb': -16.131256103515625,
                     'TMP.2743_m_above_mean_sea_level': -14.872222900390625,
                     'TMP.2_m_above_ground': -25.211593627929688,
                     'TMP.2_mb': -49.837890625,
                     'TMP.30-0_mb_above_ground': -21.27783203125,
                     'TMP.300_mb': -16.069305419921875,
                     'TMP.30_mb': -16.619094848632812,
                     'TMP.350_mb': -12.310531616210938,
                     'TMP.3658_m_above_mean_sea_level': -16.24127197265625,
                     'TMP.3_mb': -35.48866271972656,
                     'TMP.400_mb': -14.030487060546875,
                     'TMP.40_mb': -13.29345703125,
                     'TMP.450_mb': -17.241958618164062,
                     'TMP.500_mb': -18.266998291015625,
                     'TMP.50_mb': -11.548416137695312,
                     'TMP.550_mb': -17.749374389648438,
                     'TMP.5_mb': -30.925262451171875,
                     'TMP.600_mb': -15.695968627929688,
                     'TMP.650_mb': -16.2288818359375,
                     'TMP.700_mb': -16.137298583984375,
                     'TMP.70_mb': -13.983673095703125,
                     'TMP.750_mb': -16.335906982421875,
                     'TMP.7_mb': -27.981094360351562,
                     'TMP.800_mb': -16.815338134765625,
                     'TMP.80_m_above_ground': -21.900009155273438,
                     'TMP.850_mb': -24.790679931640625,
                     'TMP.900_mb': -25.052200317382812,
                     'TMP.925_mb': -25.190689086914062,
                     'TMP.950_mb': -25.322174072265625,
                     'TMP.975_mb': -25.445571899414062,
                     'TMP.PV2e06Km2kgs_surface': -101.83908081054688,
                     'TMP.PVNeg2e06Km2kgs_surface': -102.97329711914062,
                     'TMP.max_wind': -85.90861511230469,
                     'TMP.surface': -44.657562255859375,
                     'TMP.tropopause': -79.00064086914062,
                     'TOZNE.entire_atmosphere_considered_as_a_single_layer': -90.7679443359375,
                     'TSOIL.0-0.1_m_below_ground': -9.010345458984375,
                     'TSOIL.0.1-0.4_m_below_ground': -1.6180419921875,
                     'TSOIL.0.4-1_m_below_ground': -0.1300048828125,
                     'TSOIL.1-2_m_below_ground': -0.05999755859375,
                     'UGRD.0.01_mb': -230.8359375,
                     'UGRD.0.02_mb': -231.79144287109375,
                     'UGRD.0.04_mb': -155.79220581054688,
                     'UGRD.0.07_mb': -121.60701751708984,
                     'UGRD.0.1_mb': -137.33074951171875,
                     'UGRD.0.2_mb': -141.79954528808594,
                     'UGRD.0.4_mb': -126.45891571044922,
                     'UGRD.0.7_mb': -153.55796813964844,
                     'UGRD.0.995_sigma_level': -36.96052932739258,
                     'UGRD.1000_mb': -33.370147705078125,
                     'UGRD.100_m_above_ground': -39.121376037597656,
                     'UGRD.100_mb': -62.90848159790039,
                     'UGRD.10_m_above_ground': -36.032493591308594,
                     'UGRD.10_mb': -40.38355255126953,
                     'UGRD.150_mb': -48.11371612548828,
                     'UGRD.15_mb': -56.28565216064453,
                     'UGRD.1829_m_above_mean_sea_level': -42.29595184326172,
                     'UGRD.1_mb': -129.21336364746094,
                     'UGRD.200_mb': -58.223297119140625,
                     'UGRD.20_m_above_ground': -32.759578704833984,
                     'UGRD.20_mb': -44.771202087402344,
                     'UGRD.250_mb': -60.76608657836914,
                     'UGRD.2743_m_above_mean_sea_level': -35.797454833984375,
                     'UGRD.2_mb': -112.48279571533203,
                     'UGRD.30-0_mb_above_ground': -38.97823715209961,
                     'UGRD.300_mb': -63.11699676513672,
                     'UGRD.30_m_above_ground': -34.310150146484375,
                     'UGRD.30_mb': -28.732162475585938,
                     'UGRD.350_mb': -64.51809692382812,
                     'UGRD.3658_m_above_mean_sea_level': -37.32244110107422,
                     'UGRD.3_mb': -83.52528381347656,
                     'UGRD.400_mb': -76.20425415039062,
                     'UGRD.40_m_above_ground': -35.40859603881836,
                     'UGRD.40_mb': -28.487869262695312,
                     'UGRD.450_mb': -77.55137634277344,
                     'UGRD.500_mb': -66.2034683227539,
                     'UGRD.50_m_above_ground': -36.26953887939453,
                     'UGRD.50_mb': -25.196582794189453,
                     'UGRD.550_mb': -47.1983757019043,
                     'UGRD.5_mb': -68.5079116821289,
                     'UGRD.600_mb': -38.312015533447266,
                     'UGRD.650_mb': -37.54807662963867,
                     'UGRD.700_mb': -37.293968200683594,
                     'UGRD.70_mb': -29.292083740234375,
                     'UGRD.750_mb': -42.99345779418945,
                     'UGRD.7_mb': -55.64460372924805,
                     'UGRD.800_mb': -42.58202362060547,
                     'UGRD.80_m_above_ground': -38.23686599731445,
                     'UGRD.850_mb': -42.88677215576172,
                     'UGRD.900_mb': -42.512672424316406,
                     'UGRD.925_mb': -41.64985275268555,
                     'UGRD.950_mb': -42.00796127319336,
                     'UGRD.975_mb': -40.97896957397461,
                     'UGRD.PV2e06Km2kgs_surface': -78.69041442871094,
                     'UGRD.PVNeg2e06Km2kgs_surface': -93.96708679199219,
                     'UGRD.max_wind': -92.11111450195312,
                     'UGRD.planetary_boundary_layer': -40.678489685058594,
                     'UGRD.tropopause': -69.56543731689453,
                     'USTM.6000-0_m_above_ground': -35.358802795410156,
                     'VEG.surface': -2.0999984741210938,
                     'VGRD.0.01_mb': -154.78660583496094,
                     'VGRD.0.02_mb': -151.76109313964844,
                     'VGRD.0.04_mb': -114.89002990722656,
                     'VGRD.0.07_mb': -114.32966613769531,
                     'VGRD.0.1_mb': -119.617919921875,
                     'VGRD.0.2_mb': -117.32833099365234,
                     'VGRD.0.4_mb': -104.70134735107422,
                     'VGRD.0.7_mb': -102.43362426757812,
                     'VGRD.0.995_sigma_level': -64.451171875,
                     'VGRD.1000_mb': -54.69330596923828,
                     'VGRD.100_m_above_ground': -67.98492431640625,
                     'VGRD.100_mb': -40.42768478393555,
                     'VGRD.10_m_above_ground': -58.56178283691406,
                     'VGRD.10_mb': -55.785499572753906,
                     'VGRD.150_mb': -46.163330078125,
                     'VGRD.15_mb': -30.934202194213867,
                     'VGRD.1829_m_above_mean_sea_level': -65.48372650146484,
                     'VGRD.1_mb': -99.14148712158203,
                     'VGRD.200_mb': -55.898399353027344,
                     'VGRD.20_m_above_ground': -57.301265716552734,
                     'VGRD.20_mb': -28.051557540893555,
                     'VGRD.250_mb': -68.59370422363281,
                     'VGRD.2743_m_above_mean_sea_level': -58.72404479980469,
                     'VGRD.2_mb': -90.91612243652344,
                     'VGRD.30-0_mb_above_ground': -68.23963165283203,
                     'VGRD.300_mb': -94.99256896972656,
                     'VGRD.30_m_above_ground': -60.20366287231445,
                     'VGRD.30_mb': -23.161821365356445,
                     'VGRD.350_mb': -78.46941375732422,
                     'VGRD.3658_m_above_mean_sea_level': -55.82218933105469,
                     'VGRD.3_mb': -100.6712646484375,
                     'VGRD.400_mb': -65.62509155273438,
                     'VGRD.40_m_above_ground': -61.95607376098633,
                     'VGRD.40_mb': -26.588293075561523,
                     'VGRD.450_mb': -62.283302307128906,
                     'VGRD.500_mb': -60.21959686279297,
                     'VGRD.50_m_above_ground': -63.15202713012695,
                     'VGRD.50_mb': -26.47679328918457,
                     'VGRD.550_mb': -56.98752212524414,
                     'VGRD.5_mb': -68.7287826538086,
                     'VGRD.600_mb': -55.626956939697266,
                     'VGRD.650_mb': -56.95798110961914,
                     'VGRD.700_mb': -58.682945251464844,
                     'VGRD.70_mb': -27.434391021728516,
                     'VGRD.750_mb': -62.05119705200195,
                     'VGRD.7_mb': -66.43992614746094,
                     'VGRD.800_mb': -67.48545837402344,
                     'VGRD.80_m_above_ground': -66.58503723144531,
                     'VGRD.850_mb': -71.8134994506836,
                     'VGRD.900_mb': -74.55805969238281,
                     'VGRD.925_mb': -73.73943328857422,
                     'VGRD.950_mb': -72.647216796875,
                     'VGRD.975_mb': -66.05687713623047,
                     'VGRD.PV2e06Km2kgs_surface': -93.51454162597656,
                     'VGRD.PVNeg2e06Km2kgs_surface': -80.74588775634766,
                     'VGRD.max_wind': -100.32905578613281,
                     'VGRD.planetary_boundary_layer': -71.5125732421875,
                     'VGRD.tropopause': -65.38629913330078,
                     'VIS.surface': -24118.720703125,
                     'VRATE.planetary_boundary_layer': -138000.0,
                     'VSTM.6000-0_m_above_ground': -65.10274505615234,
                     'VVEL.0.01_mb': -0.0037325737066566944,
                     'VVEL.0.02_mb': -0.004407117143273354,
                     'VVEL.0.04_mb': -0.016945498064160347,
                     'VVEL.0.07_mb': -0.0414542555809021,
                     'VVEL.0.1_mb': -0.055402472615242004,
                     'VVEL.0.2_mb': -0.07090873271226883,
                     'VVEL.0.4_mb': -0.12510612607002258,
                     'VVEL.0.7_mb': -0.16124121844768524,
                     'VVEL.0.995_sigma_level': -12.251025199890137,
                     'VVEL.1000_mb': -9.766329765319824,
                     'VVEL.100_mb': -11.13910961151123,
                     'VVEL.10_mb': -0.8483023643493652,
                     'VVEL.150_mb': -27.728919982910156,
                     'VVEL.15_mb': -1.20867919921875,
                     'VVEL.1_mb': -0.14490768313407898,
                     'VVEL.200_mb': -34.94490432739258,
                     'VVEL.20_mb': -1.4886586666107178,
                     'VVEL.250_mb': -39.615211486816406,
                     'VVEL.2_mb': -0.21752163767814636,
                     'VVEL.300_mb': -43.96821594238281,
                     'VVEL.30_mb': -1.7788617610931396,
                     'VVEL.350_mb': -46.41978454589844,
                     'VVEL.3_mb': -0.32890784740448,
                     'VVEL.400_mb': -47.05172348022461,
                     'VVEL.40_mb': -2.2691597938537598,
                     'VVEL.450_mb': -46.944602966308594,
                     'VVEL.500_mb': -47.38836669921875,
                     'VVEL.50_mb': -2.070756673812866,
                     'VVEL.550_mb': -46.328285217285156,
                     'VVEL.5_mb': -0.5220466256141663,
                     'VVEL.600_mb': -43.10481262207031,
                     'VVEL.650_mb': -42.02998352050781,
                     'VVEL.700_mb': -40.69791793823242,
                     'VVEL.70_mb': -2.67041015625,
                     'VVEL.750_mb': -37.03816223144531,
                     'VVEL.7_mb': -0.6354957818984985,
                     'VVEL.800_mb': -32.23765182495117,
                     'VVEL.850_mb': -25.921388626098633,
                     'VVEL.900_mb': -19.82457160949707,
                     'VVEL.925_mb': -16.568405151367188,
                     'VVEL.950_mb': -12.389676094055176,
                     'VVEL.975_mb': -11.345786094665527,
                     'VWSH.PV2e06Km2kgs_surface': -0.15002265572547913,
                     'VWSH.PVNeg2e06Km2kgs_surface': -0.1640121191740036,
                     'VWSH.tropopause': -0.1294960230588913,
                     'WEASD.surface': -12.248001098632812,
                     'WILT.surface': -0.004800006747245789}
