# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['whos_there', 'whos_there.senders', 'whos_there.utils']

package_data = \
{'': ['*']}

install_requires = \
['python-telegram-bot>=13.7,<14.0',
 'pytorch-lightning>=1.5.0,<2.0.0',
 'requests>=2.25.1,<3.0.0']

setup_kwargs = {
    'name': 'whos-there',
    'version': '0.1.4',
    'description': 'The spiritual successor to knockknock for PyTorch Lightning, get notified when your training ends',
    'long_description': '# Who\'s there?\n\n<div align="center">\n\n<!--- BADGES: START --->\n[![PyPI - Package Version](https://img.shields.io/pypi/v/whos-there?logo=pypi&style=flat&color=orange)][#pypi-package]\n[![Conda - Platform](https://img.shields.io/conda/pn/conda-forge/whos-there?logo=anaconda&style=flat)][#conda-forge-package]\n[![Conda (channel only)](https://img.shields.io/conda/vn/conda-forge/whos-there?logo=anaconda&style=flat&color=orange)][#conda-forge-package]\n\n[![Build](https://github.com/twsl/whos-there/actions/workflows/build.yml/badge.svg)][#github-workflows-build]\n[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/whos-there?logo=pypi&style=flat&color=blue)][#pypi-package]\n[![Dependencies Status](https://img.shields.io/badge/dependencies-up%20to%20date-brightgreen.svg)](https://github.com/twsl/whos-there/pulls?utf8=%E2%9C%93&q=is%3Apr%20author%3Aapp%2Fdependabot)\n\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![Security: bandit](https://img.shields.io/badge/security-bandit-green.svg)](https://github.com/PyCQA/bandit)\n[![Pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)][#github-pre-commit]\n[![Semantic Versions](https://img.shields.io/badge/%20%20%F0%9F%93%A6%F0%9F%9A%80-semantic--versions-e10079.svg)][#github-releases]\n[![GitHub - License](https://img.shields.io/github/license/twsl/whos-there?logo=github&style=flat&color=green)][#github-license]\n\n[#github-license]: https://github.com/twsl/whos-there/blob/main/LICENSE\n[#pypi-package]: https://pypi.org/project/whos-there/\n[#conda-forge-package]: https://anaconda.org/conda-forge/whos-there\n[#github-pre-commit]: https://github.com/twsl/whos-there/blob/master/.pre-commit-config.yaml\n[#github-releases]: https://github.com/twsl/whos-there/releases\n[#github-workflows-build]: https://github.com/twsl/whos-there/actions/workflows/build.yml\n<!--- BADGES: END --->\n    \nThe spiritual successor to [knockknock](https://github.com/huggingface/knockknock) for [PyTorch Lightning](https://github.com/PyTorchLightning/pytorch-lightning), to get a notification when your training is complete or when it crashes during the process with a single callback.\n\n</div>\n\n## 🚀 Features\n\n- Supports E-Mail, Discord, Slack, Teams, Telegram\n\n## 🎯 Installation\n\nYou can install `whos-there` with `pip` or `poetry` or `conda`.\n\n**with pip**\n\n```bash\npip install -U whos-there\n```\n\n**with poetry**\n\n```bash\npoetry add whos-there\n```\n\n**with conda**\n\n```sh\nconda install -c conda-forge whos-there\n```\n\n## 🤯 How to use it\n\n```python\nfrom whos_there.callback import NotificationCallback\nfrom whos_there.senders.debug import DebugSender\n\ntrainer = pl.Trainer(\n    callbacks=[\n        NotificationCallback(senders=[\n            # Add your senders here\n            DebugSender(),\n        ])\n    ]\n)\n```\n\n### E-Mail\nRequires your e-mail provider specific SMTP settings.\n\n```python\nfrom whos_there.senders.email import EmailSender\n# ...\nEmailSender(\n    host="smtp.example.de",\n    port=587,\n    sender_email="from@example.com",\n    password="*********",\n    recipient_emails=[\n        "to1@example.com",\n        "to2@example.com",\n    ]\n)\n```\n\n### Discord\nRequires your Discord channel\'s [webhook URL](https://support.discordapp.com/hc/en-us/articles/228383668-Intro-to-Webhooks).\n\n```python\nfrom whos_there.senders.discord import DiscordSender\n# ...\nDiscordSender(\n    webhook_url="https://discord.com/api/webhooks/XXXXXXXXXXXXXX/XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"\n)\n```\n\n### Slack\nRequires your Slack room [webhook URL](https://api.slack.com/incoming-webhooks#create_a_webhook) and optionally your [user id](https://api.slack.com/methods/users.identity) (if you want to tag yourself or someone else).\n\n```python\nfrom whos_there.senders.slack import SlackSender\n# ...\nSlackSender(\n    webhook_url="https://hooks.slack.com/services/T00000000/B00000000/XXXXXXXXXXXXXXXXXXXXXXXX",\n    channel="channel_name",\n    user_mentions=[\n        "XXXXXXXX"\n    ]\n)\n```\n\n### Teams\nRequires your Team Channel [webhook URL](https://docs.microsoft.com/en-us/microsoftteams/platform/concepts/connectors/connectors-using).\n\n```python\nfrom whos_there.senders.teams import TeamsSender\n# ...\nTeamsSender(\n    webhook_url="https://XXXXX.webhook.office.com/",\n    user_mentions=[\n        "twsl"\n    ]\n)\n```\n\n### Telegram\nYou can also use Telegram Messenger to get notifications. You\'ll first have to create your own notification bot by following the three steps provided by Telegram [here](https://core.telegram.org/bots#6-botfather) and save your API access `TOKEN`.\nTelegram bots are shy and can\'t send the first message so you\'ll have to do the first step. By sending the first message, you\'ll be able to get the `chat_id` required (identification of your messaging room) by visiting `https://api.telegram.org/bot<YourBOTToken>/getUpdates` and get the `int` under the key `message[\'chat\'][\'id\']`.\n\n```python\nfrom whos_there.senders.telegram import TelegramSender\n# ...\nTelegramSender(\n    chat_id=1234567890,\n    token="XXXXXXX:XXXXXXXXXXXXXXXXXXXXXXXXXXX"\n)\n```\n\n## 🛡 License\n\n[![License](https://img.shields.io/github/license/twsl/whos-there)](https://github.com/twsl/whos-there/blob/master/LICENSE)\n\nThis project is licensed under the terms of the MIT license. See [LICENSE](https://github.com/twsl/whos-there/blob/master/LICENSE) for more details.\n\n## 🏅 Credits\n\nThis project was generated with [![🚀 Your next Python package needs a bleeding-edge project structure.](https://img.shields.io/badge/python--package--template-%F0%9F%9A%80-brightgreen)](https://github.com/TezRomacH/python-package-template)\n\nBig thanks to [knockknock](https://github.com/huggingface/knockknock) for the idea and code snippets.\n',
    'author': 'twsl',
    'author_email': '45483159+twsl@users.noreply.github.com',
    'maintainer': 'twsl',
    'maintainer_email': '45483159+twsl@users.noreply.github.com',
    'url': 'https://github.com/twsl/whos-there',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
