# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Tag(pulumi.CustomResource):
    column: pulumi.Output[str]
    """
    Resources like Entry can have schemas associated with them. This scope allows users to attach tags to an
    individual column based on that schema.
    For attaching a tag to a nested column, use `.` to separate the column names. Example:
    `outer_column.inner_column`
    """
    fields: pulumi.Output[list]
    """
    This maps the ID of a tag field to the value of and additional information about that field.
    Valid field IDs are defined by the tag's template. A tag must have at least 1 field and at most 500 fields.  Structure is documented below.

      * `boolValue` (`bool`) - Holds the value for a tag field with boolean type.
      * `display_name` (`str`) - -
        The display name of this field
      * `doubleValue` (`float`) - Holds the value for a tag field with double type.
      * `enumValue` (`str`) - Holds the value for a tag field with enum type. This value must be one of the allowed values in the definition of this enum.  Structure is documented below.
      * `fieldName` (`str`) - The identifier for this object. Format specified above.
      * `order` (`float`) - -
        The order of this field with respect to other fields in this tag. For example, a higher value can indicate
        a more important field. The value can be negative. Multiple fields can have the same order, and field orders
        within a tag do not have to be sequential.
      * `stringValue` (`str`) - Holds the value for a tag field with string type.
      * `timestampValue` (`str`) - Holds the value for a tag field with timestamp type.
    """
    name: pulumi.Output[str]
    """
    The resource name of the tag in URL format. Example:
    projects/{project_id}/locations/{location}/entrygroups/{entryGroupId}/entries/{entryId}/tags/{tag_id} or
    projects/{project_id}/locations/{location}/entrygroups/{entryGroupId}/tags/{tag_id} where tag_id is a system-generated
    identifier. Note that this Tag may not actually be stored in the location in this name.
    """
    parent: pulumi.Output[str]
    """
    The name of the parent this tag is attached to. This can be the name of an entry or an entry group. If an entry group, the tag will be attached to
    all entries in that group.
    """
    template: pulumi.Output[str]
    """
    The resource name of the tag template that this tag uses. Example:
    projects/{project_id}/locations/{location}/tagTemplates/{tagTemplateId}
    This field cannot be modified after creation.
    """
    template_displayname: pulumi.Output[str]
    """
    The display name of the tag template.
    """
    def __init__(__self__, resource_name, opts=None, column=None, fields=None, parent=None, template=None, __props__=None, __name__=None, __opts__=None):
        """
        Tags are used to attach custom metadata to Data Catalog resources. Tags conform to the specifications within their tag template.

        See [Data Catalog IAM](https://cloud.google.com/data-catalog/docs/concepts/iam) for information on the permissions needed to create or view tags.


        To get more information about Tag, see:

        * [API documentation](https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.tags)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/data-catalog/docs)

        ## Example Usage

        ### Data Catalog Entry Tag Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        entry_group = gcp.datacatalog.EntryGroup("entryGroup", entry_group_id="my_entry_group")
        entry = gcp.datacatalog.Entry("entry",
            entry_group=entry_group.id,
            entry_id="my_entry",
            user_specified_type="my_custom_type",
            user_specified_system="SomethingExternal")
        tag_template = gcp.datacatalog.TagTemplate("tagTemplate",
            tag_template_id="my_template",
            region="us-central1",
            display_name="Demo Tag Template",
            fields=[
                {
                    "fieldId": "source",
                    "display_name": "Source of data asset",
                    "type": {
                        "primitiveType": "STRING",
                    },
                    "isRequired": True,
                },
                {
                    "fieldId": "num_rows",
                    "display_name": "Number of rows in the data asset",
                    "type": {
                        "primitiveType": "DOUBLE",
                    },
                },
                {
                    "fieldId": "pii_type",
                    "display_name": "PII type",
                    "type": {
                        "enum_type": {
                            "allowed_values": [
                                {
                                    "display_name": "EMAIL",
                                },
                                {
                                    "display_name": "SOCIAL SECURITY NUMBER",
                                },
                                {
                                    "display_name": "NONE",
                                },
                            ],
                        },
                    },
                },
            ],
            force_delete="false")
        basic_tag = gcp.datacatalog.Tag("basicTag",
            parent=entry.id,
            template=tag_template.id,
            fields=[{
                "fieldName": "source",
                "stringValue": "my-string",
            }])
        ```

        ### Data Catalog Entry Group Tag

        ```python
        import pulumi
        import pulumi_gcp as gcp

        entry_group = gcp.datacatalog.EntryGroup("entryGroup", entry_group_id="my_entry_group")
        first_entry = gcp.datacatalog.Entry("firstEntry",
            entry_group=entry_group.id,
            entry_id="first_entry",
            user_specified_type="my_custom_type",
            user_specified_system="SomethingExternal")
        second_entry = gcp.datacatalog.Entry("secondEntry",
            entry_group=entry_group.id,
            entry_id="second_entry",
            user_specified_type="another_custom_type",
            user_specified_system="SomethingElseExternal")
        tag_template = gcp.datacatalog.TagTemplate("tagTemplate",
            tag_template_id="my_template",
            region="us-central1",
            display_name="Demo Tag Template",
            fields=[
                {
                    "fieldId": "source",
                    "display_name": "Source of data asset",
                    "type": {
                        "primitiveType": "STRING",
                    },
                    "isRequired": True,
                },
                {
                    "fieldId": "num_rows",
                    "display_name": "Number of rows in the data asset",
                    "type": {
                        "primitiveType": "DOUBLE",
                    },
                },
                {
                    "fieldId": "pii_type",
                    "display_name": "PII type",
                    "type": {
                        "enum_type": {
                            "allowed_values": [
                                {
                                    "display_name": "EMAIL",
                                },
                                {
                                    "display_name": "SOCIAL SECURITY NUMBER",
                                },
                                {
                                    "display_name": "NONE",
                                },
                            ],
                        },
                    },
                },
            ],
            force_delete="false")
        entry_group_tag = gcp.datacatalog.Tag("entryGroupTag",
            parent=entry_group.id,
            template=tag_template.id,
            fields=[{
                "fieldName": "source",
                "stringValue": "my-string",
            }])
        ```

        ### Data Catalog Entry Tag Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        entry_group = gcp.datacatalog.EntryGroup("entryGroup", entry_group_id="my_entry_group")
        entry = gcp.datacatalog.Entry("entry",
            entry_group=entry_group.id,
            entry_id="my_entry",
            user_specified_type="my_custom_type",
            user_specified_system="SomethingExternal",
            schema=\"\"\"{
          "columns": [
            {
              "column": "first_name",
              "description": "First name",
              "mode": "REQUIRED",
              "type": "STRING"
            },
            {
              "column": "last_name",
              "description": "Last name",
              "mode": "REQUIRED",
              "type": "STRING"
            },
            {
              "column": "address",
              "description": "Address",
              "mode": "REPEATED",
              "subcolumns": [
                {
                  "column": "city",
                  "description": "City",
                  "mode": "NULLABLE",
                  "type": "STRING"
                },
                {
                  "column": "state",
                  "description": "State",
                  "mode": "NULLABLE",
                  "type": "STRING"
                }
              ],
              "type": "RECORD"
            }
          ]
        }
        \"\"\")
        tag_template = gcp.datacatalog.TagTemplate("tagTemplate",
            tag_template_id="my_template",
            region="us-central1",
            display_name="Demo Tag Template",
            fields=[
                {
                    "fieldId": "source",
                    "display_name": "Source of data asset",
                    "type": {
                        "primitiveType": "STRING",
                    },
                    "isRequired": True,
                },
                {
                    "fieldId": "num_rows",
                    "display_name": "Number of rows in the data asset",
                    "type": {
                        "primitiveType": "DOUBLE",
                    },
                },
                {
                    "fieldId": "pii_type",
                    "display_name": "PII type",
                    "type": {
                        "enum_type": {
                            "allowed_values": [
                                {
                                    "display_name": "EMAIL",
                                },
                                {
                                    "display_name": "SOCIAL SECURITY NUMBER",
                                },
                                {
                                    "display_name": "NONE",
                                },
                            ],
                        },
                    },
                },
            ],
            force_delete="false")
        basic_tag = gcp.datacatalog.Tag("basicTag",
            parent=entry.id,
            template=tag_template.id,
            fields=[
                {
                    "fieldName": "source",
                    "stringValue": "my-string",
                },
                {
                    "fieldName": "num_rows",
                    "doubleValue": 5,
                },
                {
                    "fieldName": "pii_type",
                    "enumValue": "EMAIL",
                },
            ],
            column="address")
        second_tag = gcp.datacatalog.Tag("second-tag",
            parent=entry.id,
            template=tag_template.id,
            fields=[
                {
                    "fieldName": "source",
                    "stringValue": "my-string",
                },
                {
                    "fieldName": "pii_type",
                    "enumValue": "NONE",
                },
            ],
            column="first_name")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] column: Resources like Entry can have schemas associated with them. This scope allows users to attach tags to an
               individual column based on that schema.
               For attaching a tag to a nested column, use `.` to separate the column names. Example:
               `outer_column.inner_column`
        :param pulumi.Input[list] fields: This maps the ID of a tag field to the value of and additional information about that field.
               Valid field IDs are defined by the tag's template. A tag must have at least 1 field and at most 500 fields.  Structure is documented below.
        :param pulumi.Input[str] parent: The name of the parent this tag is attached to. This can be the name of an entry or an entry group. If an entry group, the tag will be attached to
               all entries in that group.
        :param pulumi.Input[str] template: The resource name of the tag template that this tag uses. Example:
               projects/{project_id}/locations/{location}/tagTemplates/{tagTemplateId}
               This field cannot be modified after creation.

        The **fields** object supports the following:

          * `boolValue` (`pulumi.Input[bool]`) - Holds the value for a tag field with boolean type.
          * `display_name` (`pulumi.Input[str]`) - -
            The display name of this field
          * `doubleValue` (`pulumi.Input[float]`) - Holds the value for a tag field with double type.
          * `enumValue` (`pulumi.Input[str]`) - Holds the value for a tag field with enum type. This value must be one of the allowed values in the definition of this enum.  Structure is documented below.
          * `fieldName` (`pulumi.Input[str]`) - The identifier for this object. Format specified above.
          * `order` (`pulumi.Input[float]`) - -
            The order of this field with respect to other fields in this tag. For example, a higher value can indicate
            a more important field. The value can be negative. Multiple fields can have the same order, and field orders
            within a tag do not have to be sequential.
          * `stringValue` (`pulumi.Input[str]`) - Holds the value for a tag field with string type.
          * `timestampValue` (`pulumi.Input[str]`) - Holds the value for a tag field with timestamp type.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['column'] = column
            if fields is None:
                raise TypeError("Missing required property 'fields'")
            __props__['fields'] = fields
            __props__['parent'] = parent
            if template is None:
                raise TypeError("Missing required property 'template'")
            __props__['template'] = template
            __props__['name'] = None
            __props__['template_displayname'] = None
        super(Tag, __self__).__init__(
            'gcp:datacatalog/tag:Tag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, column=None, fields=None, name=None, parent=None, template=None, template_displayname=None):
        """
        Get an existing Tag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] column: Resources like Entry can have schemas associated with them. This scope allows users to attach tags to an
               individual column based on that schema.
               For attaching a tag to a nested column, use `.` to separate the column names. Example:
               `outer_column.inner_column`
        :param pulumi.Input[list] fields: This maps the ID of a tag field to the value of and additional information about that field.
               Valid field IDs are defined by the tag's template. A tag must have at least 1 field and at most 500 fields.  Structure is documented below.
        :param pulumi.Input[str] name: The resource name of the tag in URL format. Example:
               projects/{project_id}/locations/{location}/entrygroups/{entryGroupId}/entries/{entryId}/tags/{tag_id} or
               projects/{project_id}/locations/{location}/entrygroups/{entryGroupId}/tags/{tag_id} where tag_id is a system-generated
               identifier. Note that this Tag may not actually be stored in the location in this name.
        :param pulumi.Input[str] parent: The name of the parent this tag is attached to. This can be the name of an entry or an entry group. If an entry group, the tag will be attached to
               all entries in that group.
        :param pulumi.Input[str] template: The resource name of the tag template that this tag uses. Example:
               projects/{project_id}/locations/{location}/tagTemplates/{tagTemplateId}
               This field cannot be modified after creation.
        :param pulumi.Input[str] template_displayname: The display name of the tag template.

        The **fields** object supports the following:

          * `boolValue` (`pulumi.Input[bool]`) - Holds the value for a tag field with boolean type.
          * `display_name` (`pulumi.Input[str]`) - -
            The display name of this field
          * `doubleValue` (`pulumi.Input[float]`) - Holds the value for a tag field with double type.
          * `enumValue` (`pulumi.Input[str]`) - Holds the value for a tag field with enum type. This value must be one of the allowed values in the definition of this enum.  Structure is documented below.
          * `fieldName` (`pulumi.Input[str]`) - The identifier for this object. Format specified above.
          * `order` (`pulumi.Input[float]`) - -
            The order of this field with respect to other fields in this tag. For example, a higher value can indicate
            a more important field. The value can be negative. Multiple fields can have the same order, and field orders
            within a tag do not have to be sequential.
          * `stringValue` (`pulumi.Input[str]`) - Holds the value for a tag field with string type.
          * `timestampValue` (`pulumi.Input[str]`) - Holds the value for a tag field with timestamp type.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["column"] = column
        __props__["fields"] = fields
        __props__["name"] = name
        __props__["parent"] = parent
        __props__["template"] = template
        __props__["template_displayname"] = template_displayname
        return Tag(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

