# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Hl7Store(pulumi.CustomResource):
    dataset: pulumi.Output[str]
    """
    Identifies the dataset addressed by this request. Must be in the format
    'projects/{project}/locations/{location}/datasets/{dataset}'
    """
    labels: pulumi.Output[dict]
    """
    User-supplied key-value pairs used to organize HL7v2 stores.
    Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
    conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
    Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
    bytes, and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
    No more than 64 labels can be associated with a given store.
    An object containing a list of "key": value pairs.
    Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    """
    name: pulumi.Output[str]
    """
    The resource name for the Hl7V2Store.
    ** Changing this property may recreate the Hl7v2 store (removing all data) **
    """
    notification_config: pulumi.Output[dict]
    """
    -
    (Optional, Deprecated)
    A nested object resource  Structure is documented below.

      * `pubsubTopic` (`str`) - The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
        PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
        It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
        was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
        project. cloud-healthcare@system.gserviceaccount.com must have publisher permissions on the given
        Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
    """
    notification_configs: pulumi.Output[list]
    """
    A list of notification configs. Each configuration uses a filter to determine whether to publish a
    message (both Ingest & Create) on the corresponding notification destination. Only the message name
    is sent as part of the notification. Supplied by the client.  Structure is documented below.

      * `filter` (`str`) - Restricts notifications sent for messages matching a filter. If this is empty, all messages
        are matched. Syntax: https://cloud.google.com/appengine/docs/standard/python/search/query_strings
        Fields/functions available for filtering are:
        * messageType, from the MSH-9.1 field. For example, NOT messageType = "ADT".
        * send_date or sendDate, the YYYY-MM-DD date the message was sent in the dataset's timeZone, from the MSH-7 segment. For example, send_date < "2017-01-02".
        * sendTime, the timestamp when the message was sent, using the RFC3339 time format for comparisons, from the MSH-7 segment. For example, sendTime < "2017-01-02T00:00:00-05:00".
        * sendFacility, the care center that the message came from, from the MSH-4 segment. For example, sendFacility = "ABC".
        * PatientId(value, type), which matches if the message lists a patient having an ID of the given value and type in the PID-2, PID-3, or PID-4 segments. For example, PatientId("123456", "MRN").
        * labels.x, a string value of the label with key x as set using the Message.labels map. For example, labels."priority"="high". The operator :* can be used to assert the existence of a label. For example, labels."priority":*.
      * `pubsubTopic` (`str`) - The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
        PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
        It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
        was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
        project. cloud-healthcare@system.gserviceaccount.com must have publisher permissions on the given
        Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
    """
    parser_config: pulumi.Output[dict]
    """
    A nested object resource  Structure is documented below.

      * `allowNullHeader` (`bool`) - Determines whether messages with no header are allowed.
      * `schema` (`str`) - JSON encoded string for schemas used to parse messages in this
        store if schematized parsing is desired.
      * `segmentTerminator` (`str`) - Byte(s) to be used as the segment terminator. If this is unset, '\r' will be used as segment terminator.
        A base64-encoded string.
    """
    self_link: pulumi.Output[str]
    """
    The fully qualified name of this dataset
    """
    def __init__(__self__, resource_name, opts=None, dataset=None, labels=None, name=None, notification_config=None, notification_configs=None, parser_config=None, __props__=None, __name__=None, __opts__=None):
        """
        A Hl7V2Store is a datastore inside a Healthcare dataset that conforms to the FHIR (https://www.hl7.org/hl7V2/STU3/)
        standard for Healthcare information exchange

        To get more information about Hl7V2Store, see:

        * [API documentation](https://cloud.google.com/healthcare/docs/reference/rest/v1/projects.locations.datasets.hl7V2Stores)
        * How-to Guides
            * [Creating a HL7v2 Store](https://cloud.google.com/healthcare/docs/how-tos/hl7v2)

        ## Example Usage

        ### Healthcare Hl7 V2 Store Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        topic = gcp.pubsub.Topic("topic")
        dataset = gcp.healthcare.Dataset("dataset", location="us-central1")
        default = gcp.healthcare.Hl7Store("default",
            dataset=dataset.id,
            notification_configs=[{
                "pubsubTopic": topic.id,
            }],
            labels={
                "label1": "labelvalue1",
            })
        ```

        ### Healthcare Hl7 V2 Store Parser Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dataset = gcp.healthcare.Dataset("dataset", location="us-central1")
        default = gcp.healthcare.Hl7Store("default",
            dataset=dataset.id,
            parser_config={
                "allowNullHeader": False,
                "segmentTerminator": "Jw==",
                "schema": \"\"\"{
          "schemas": [{
            "messageSchemaConfigs": {
              "ADT_A01": {
                "name": "ADT_A01",
                "minOccurs": 1,
                "maxOccurs": 1,
                "members": [{
                    "segment": {
                      "type": "MSH",
                      "minOccurs": 1,
                      "maxOccurs": 1
                    }
                  },
                  {
                    "segment": {
                      "type": "EVN",
                      "minOccurs": 1,
                      "maxOccurs": 1
                    }
                  },
                  {
                    "segment": {
                      "type": "PID",
                      "minOccurs": 1,
                      "maxOccurs": 1
                    }
                  },
                  {
                    "segment": {
                      "type": "ZPD",
                      "minOccurs": 1,
                      "maxOccurs": 1
                    }
                  },
                  {
                    "segment": {
                      "type": "OBX"
                    }
                  },
                  {
                    "group": {
                      "name": "PROCEDURE",
                      "members": [{
                          "segment": {
                            "type": "PR1",
                            "minOccurs": 1,
                            "maxOccurs": 1
                          }
                        },
                        {
                          "segment": {
                            "type": "ROL"
                          }
                        }
                      ]
                    }
                  },
                  {
                    "segment": {
                      "type": "PDA",
                      "maxOccurs": 1
                    }
                  }
                ]
              }
            }
          }],
          "types": [{
            "type": [{
                "name": "ZPD",
                "primitive": "VARIES"
              }

            ]
          }],
          "ignoreMinOccurs": true
        }
        \"\"\",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dataset: Identifies the dataset addressed by this request. Must be in the format
               'projects/{project}/locations/{location}/datasets/{dataset}'
        :param pulumi.Input[dict] labels: User-supplied key-value pairs used to organize HL7v2 stores.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
               conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
               Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
               bytes, and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
               No more than 64 labels can be associated with a given store.
               An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] name: The resource name for the Hl7V2Store.
               ** Changing this property may recreate the Hl7v2 store (removing all data) **
        :param pulumi.Input[dict] notification_config: -
               (Optional, Deprecated)
               A nested object resource  Structure is documented below.
        :param pulumi.Input[list] notification_configs: A list of notification configs. Each configuration uses a filter to determine whether to publish a
               message (both Ingest & Create) on the corresponding notification destination. Only the message name
               is sent as part of the notification. Supplied by the client.  Structure is documented below.
        :param pulumi.Input[dict] parser_config: A nested object resource  Structure is documented below.

        The **notification_config** object supports the following:

          * `pubsubTopic` (`pulumi.Input[str]`) - The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
            PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
            It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
            was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
            project. cloud-healthcare@system.gserviceaccount.com must have publisher permissions on the given
            Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.

        The **notification_configs** object supports the following:

          * `filter` (`pulumi.Input[str]`) - Restricts notifications sent for messages matching a filter. If this is empty, all messages
            are matched. Syntax: https://cloud.google.com/appengine/docs/standard/python/search/query_strings
            Fields/functions available for filtering are:
            * messageType, from the MSH-9.1 field. For example, NOT messageType = "ADT".
            * send_date or sendDate, the YYYY-MM-DD date the message was sent in the dataset's timeZone, from the MSH-7 segment. For example, send_date < "2017-01-02".
            * sendTime, the timestamp when the message was sent, using the RFC3339 time format for comparisons, from the MSH-7 segment. For example, sendTime < "2017-01-02T00:00:00-05:00".
            * sendFacility, the care center that the message came from, from the MSH-4 segment. For example, sendFacility = "ABC".
            * PatientId(value, type), which matches if the message lists a patient having an ID of the given value and type in the PID-2, PID-3, or PID-4 segments. For example, PatientId("123456", "MRN").
            * labels.x, a string value of the label with key x as set using the Message.labels map. For example, labels."priority"="high". The operator :* can be used to assert the existence of a label. For example, labels."priority":*.
          * `pubsubTopic` (`pulumi.Input[str]`) - The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
            PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
            It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
            was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
            project. cloud-healthcare@system.gserviceaccount.com must have publisher permissions on the given
            Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.

        The **parser_config** object supports the following:

          * `allowNullHeader` (`pulumi.Input[bool]`) - Determines whether messages with no header are allowed.
          * `schema` (`pulumi.Input[str]`) - JSON encoded string for schemas used to parse messages in this
            store if schematized parsing is desired.
          * `segmentTerminator` (`pulumi.Input[str]`) - Byte(s) to be used as the segment terminator. If this is unset, '\r' will be used as segment terminator.
            A base64-encoded string.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if dataset is None:
                raise TypeError("Missing required property 'dataset'")
            __props__['dataset'] = dataset
            __props__['labels'] = labels
            __props__['name'] = name
            if notification_config is not None:
                warnings.warn("This field has been replaced by notificationConfigs", DeprecationWarning)
                pulumi.log.warn("notification_config is deprecated: This field has been replaced by notificationConfigs")
            __props__['notification_config'] = notification_config
            __props__['notification_configs'] = notification_configs
            __props__['parser_config'] = parser_config
            __props__['self_link'] = None
        super(Hl7Store, __self__).__init__(
            'gcp:healthcare/hl7Store:Hl7Store',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, dataset=None, labels=None, name=None, notification_config=None, notification_configs=None, parser_config=None, self_link=None):
        """
        Get an existing Hl7Store resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dataset: Identifies the dataset addressed by this request. Must be in the format
               'projects/{project}/locations/{location}/datasets/{dataset}'
        :param pulumi.Input[dict] labels: User-supplied key-value pairs used to organize HL7v2 stores.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
               conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
               Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
               bytes, and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
               No more than 64 labels can be associated with a given store.
               An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] name: The resource name for the Hl7V2Store.
               ** Changing this property may recreate the Hl7v2 store (removing all data) **
        :param pulumi.Input[dict] notification_config: -
               (Optional, Deprecated)
               A nested object resource  Structure is documented below.
        :param pulumi.Input[list] notification_configs: A list of notification configs. Each configuration uses a filter to determine whether to publish a
               message (both Ingest & Create) on the corresponding notification destination. Only the message name
               is sent as part of the notification. Supplied by the client.  Structure is documented below.
        :param pulumi.Input[dict] parser_config: A nested object resource  Structure is documented below.
        :param pulumi.Input[str] self_link: The fully qualified name of this dataset

        The **notification_config** object supports the following:

          * `pubsubTopic` (`pulumi.Input[str]`) - The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
            PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
            It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
            was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
            project. cloud-healthcare@system.gserviceaccount.com must have publisher permissions on the given
            Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.

        The **notification_configs** object supports the following:

          * `filter` (`pulumi.Input[str]`) - Restricts notifications sent for messages matching a filter. If this is empty, all messages
            are matched. Syntax: https://cloud.google.com/appengine/docs/standard/python/search/query_strings
            Fields/functions available for filtering are:
            * messageType, from the MSH-9.1 field. For example, NOT messageType = "ADT".
            * send_date or sendDate, the YYYY-MM-DD date the message was sent in the dataset's timeZone, from the MSH-7 segment. For example, send_date < "2017-01-02".
            * sendTime, the timestamp when the message was sent, using the RFC3339 time format for comparisons, from the MSH-7 segment. For example, sendTime < "2017-01-02T00:00:00-05:00".
            * sendFacility, the care center that the message came from, from the MSH-4 segment. For example, sendFacility = "ABC".
            * PatientId(value, type), which matches if the message lists a patient having an ID of the given value and type in the PID-2, PID-3, or PID-4 segments. For example, PatientId("123456", "MRN").
            * labels.x, a string value of the label with key x as set using the Message.labels map. For example, labels."priority"="high". The operator :* can be used to assert the existence of a label. For example, labels."priority":*.
          * `pubsubTopic` (`pulumi.Input[str]`) - The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
            PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
            It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
            was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
            project. cloud-healthcare@system.gserviceaccount.com must have publisher permissions on the given
            Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.

        The **parser_config** object supports the following:

          * `allowNullHeader` (`pulumi.Input[bool]`) - Determines whether messages with no header are allowed.
          * `schema` (`pulumi.Input[str]`) - JSON encoded string for schemas used to parse messages in this
            store if schematized parsing is desired.
          * `segmentTerminator` (`pulumi.Input[str]`) - Byte(s) to be used as the segment terminator. If this is unset, '\r' will be used as segment terminator.
            A base64-encoded string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["dataset"] = dataset
        __props__["labels"] = labels
        __props__["name"] = name
        __props__["notification_config"] = notification_config
        __props__["notification_configs"] = notification_configs
        __props__["parser_config"] = parser_config
        __props__["self_link"] = self_link
        return Hl7Store(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

