# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Instance(pulumi.CustomResource):
    authorized_network: pulumi.Output[str]
    """
    The full name of the GCE network to connect the instance to.  If not provided,
    'default' will be used.
    """
    create_time: pulumi.Output[str]
    """
    Creation timestamp in RFC3339 text format.
    """
    display_name: pulumi.Output[str]
    """
    A user-visible name for the instance.
    """
    labels: pulumi.Output[dict]
    """
    Resource labels to represent user-provided metadata.
    """
    memcache_parameters: pulumi.Output[dict]
    """
    User-specified parameters for this memcache instance.  Structure is documented below.

      * `id` (`str`) - -
        This is a unique ID associated with this set of parameters.
      * `params` (`dict`) - User-defined set of parameters to use in the memcache process.
    """
    name: pulumi.Output[str]
    """
    The resource name of the instance.
    """
    node_config: pulumi.Output[dict]
    """
    Configuration for memcache nodes.  Structure is documented below.

      * `cpuCount` (`float`) - Number of CPUs per node.
      * `memorySizeMb` (`float`) - Memory size in Mebibytes for each memcache node.
    """
    node_count: pulumi.Output[float]
    """
    Number of nodes in the memcache instance.
    """
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs.
    If it is not provided, the provider project is used.
    """
    region: pulumi.Output[str]
    """
    The name of the Memcache region of the instance.
    """
    zones: pulumi.Output[list]
    """
    Zones where memcache nodes should be provisioned.  If not
    provided, all zones will be used.
    """
    def __init__(__self__, resource_name, opts=None, authorized_network=None, display_name=None, labels=None, memcache_parameters=None, name=None, node_config=None, node_count=None, project=None, region=None, zones=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a Instance resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authorized_network: The full name of the GCE network to connect the instance to.  If not provided,
               'default' will be used.
        :param pulumi.Input[str] display_name: A user-visible name for the instance.
        :param pulumi.Input[dict] labels: Resource labels to represent user-provided metadata.
        :param pulumi.Input[dict] memcache_parameters: User-specified parameters for this memcache instance.  Structure is documented below.
        :param pulumi.Input[str] name: The resource name of the instance.
        :param pulumi.Input[dict] node_config: Configuration for memcache nodes.  Structure is documented below.
        :param pulumi.Input[float] node_count: Number of nodes in the memcache instance.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The name of the Memcache region of the instance.
        :param pulumi.Input[list] zones: Zones where memcache nodes should be provisioned.  If not
               provided, all zones will be used.

        The **memcache_parameters** object supports the following:

          * `id` (`pulumi.Input[str]`) - -
            This is a unique ID associated with this set of parameters.
          * `params` (`pulumi.Input[dict]`) - User-defined set of parameters to use in the memcache process.

        The **node_config** object supports the following:

          * `cpuCount` (`pulumi.Input[float]`) - Number of CPUs per node.
          * `memorySizeMb` (`pulumi.Input[float]`) - Memory size in Mebibytes for each memcache node.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['authorized_network'] = authorized_network
            __props__['display_name'] = display_name
            __props__['labels'] = labels
            __props__['memcache_parameters'] = memcache_parameters
            __props__['name'] = name
            if node_config is None:
                raise TypeError("Missing required property 'node_config'")
            __props__['node_config'] = node_config
            if node_count is None:
                raise TypeError("Missing required property 'node_count'")
            __props__['node_count'] = node_count
            __props__['project'] = project
            if region is None:
                raise TypeError("Missing required property 'region'")
            __props__['region'] = region
            __props__['zones'] = zones
            __props__['create_time'] = None
        super(Instance, __self__).__init__(
            'gcp:memcache/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, authorized_network=None, create_time=None, display_name=None, labels=None, memcache_parameters=None, name=None, node_config=None, node_count=None, project=None, region=None, zones=None):
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authorized_network: The full name of the GCE network to connect the instance to.  If not provided,
               'default' will be used.
        :param pulumi.Input[str] create_time: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] display_name: A user-visible name for the instance.
        :param pulumi.Input[dict] labels: Resource labels to represent user-provided metadata.
        :param pulumi.Input[dict] memcache_parameters: User-specified parameters for this memcache instance.  Structure is documented below.
        :param pulumi.Input[str] name: The resource name of the instance.
        :param pulumi.Input[dict] node_config: Configuration for memcache nodes.  Structure is documented below.
        :param pulumi.Input[float] node_count: Number of nodes in the memcache instance.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The name of the Memcache region of the instance.
        :param pulumi.Input[list] zones: Zones where memcache nodes should be provisioned.  If not
               provided, all zones will be used.

        The **memcache_parameters** object supports the following:

          * `id` (`pulumi.Input[str]`) - -
            This is a unique ID associated with this set of parameters.
          * `params` (`pulumi.Input[dict]`) - User-defined set of parameters to use in the memcache process.

        The **node_config** object supports the following:

          * `cpuCount` (`pulumi.Input[float]`) - Number of CPUs per node.
          * `memorySizeMb` (`pulumi.Input[float]`) - Memory size in Mebibytes for each memcache node.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["authorized_network"] = authorized_network
        __props__["create_time"] = create_time
        __props__["display_name"] = display_name
        __props__["labels"] = labels
        __props__["memcache_parameters"] = memcache_parameters
        __props__["name"] = name
        __props__["node_config"] = node_config
        __props__["node_count"] = node_count
        __props__["project"] = project
        __props__["region"] = region
        __props__["zones"] = zones
        return Instance(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

