import pytest
from parsr import Char, Many


def test_many():
    a = Char("a")
    b = Char("b")
    x = Char("x")

    xs = Many(x)
    assert xs("") == []
    assert xs("a") == []
    assert xs("x") == ["x"]
    assert xs("xxxxx") == ["x", "x", "x", "x", "x"]
    assert xs("xxxxb") == ["x", "x", "x", "x"]

    ab = Many(a + b)
    assert ab("") == []
    assert ab("ba") == []
    assert ab("ab") == [["a", "b"]]
    assert ab("ababab") == [["a", "b"], ["a", "b"], ["a", "b"]]

    ab = Many(a | b)
    assert ab("aababb") == ["a", "a", "b", "a", "b", "b"]


def test_many1():
    a = Char("a")
    b = Char("b")
    x = Char("x")

    xs = Many(x, lower=1)
    with pytest.raises(Exception):
        xs("")

    with pytest.raises(Exception):
        xs("a")

    assert xs("x") == ["x"]
    assert xs("xxxxx") == ["x", "x", "x", "x", "x"]
    assert xs("xxxxb") == ["x", "x", "x", "x"]

    ab = Many(a + b, lower=1)
    with pytest.raises(Exception):
        ab("")

    with pytest.raises(Exception):
        ab("ba")

    assert ab("ab") == [["a", "b"]]
    assert ab("ababab") == [["a", "b"], ["a", "b"], ["a", "b"]]

    ab = Many(a | b, lower=1)
    assert ab("aababb") == ["a", "a", "b", "a", "b", "b"]


def test_many_upper():
    a = Char("a")
    b = Char("b")

    ab = Many(a | b, upper=2)
    assert len(ab("a")) == 1
    assert len(ab("ab")) == 2
    with pytest.raises(Exception):
        ab("aba")
