# Generated by Django 2.1.15 on 2020-06-24 15:39

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import filer.fields.image
import mixins.fields


class Migration(migrations.Migration):

    dependencies = [
        ("news", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Category",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(default=django.utils.timezone.now)),
                (
                    "updated_at",
                    mixins.fields.AutoDateTimeField(default=django.utils.timezone.now),
                ),
                ("name", models.CharField(max_length=255)),
                ("slug", models.SlugField(max_length=255, unique=True)),
            ],
            options={
                "verbose_name": "Category",
                "verbose_name_plural": "Categories",
                "ordering": ["name"],
            },
        ),
        migrations.AlterModelOptions(
            name="author",
            options={
                "ordering": ["name", "-created_at"],
                "verbose_name": "Author",
                "verbose_name_plural": "Authors",
            },
        ),
        migrations.RenameField(
            model_name="author", old_name="first_name", new_name="name",
        ),
        migrations.RemoveField(model_name="author", name="last_name",),
        migrations.AlterField(
            model_name="article",
            name="photo",
            field=filer.fields.image.FilerImageField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="news_article_images",
                to=settings.FILER_IMAGE_MODEL,
            ),
        ),
    ]
