# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SignonPolicyRuleArgs', 'SignonPolicyRule']

@pulumi.input_type
class SignonPolicyRuleArgs:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input[str]] = None,
                 authtype: Optional[pulumi.Input[str]] = None,
                 behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 factor_sequences: Optional[pulumi.Input[Sequence[pulumi.Input['SignonPolicyRuleFactorSequenceArgs']]]] = None,
                 identity_provider: Optional[pulumi.Input[str]] = None,
                 identity_provider_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mfa_lifetime: Optional[pulumi.Input[int]] = None,
                 mfa_prompt: Optional[pulumi.Input[str]] = None,
                 mfa_remember_device: Optional[pulumi.Input[bool]] = None,
                 mfa_required: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_connection: Optional[pulumi.Input[str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 policyid: Optional[pulumi.Input[str]] = None,
                 primary_factor: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 risc_level: Optional[pulumi.Input[str]] = None,
                 session_idle: Optional[pulumi.Input[int]] = None,
                 session_lifetime: Optional[pulumi.Input[int]] = None,
                 session_persistent: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a SignonPolicyRule resource.
        :param pulumi.Input[str] access: Allow or deny access based on the rule conditions: ALLOW, DENY or CHALLENGE.
        :param pulumi.Input[str] authtype: Authentication entrypoint: ANY, RADIUS or LDAP_INTERFACE
        :param pulumi.Input[Sequence[pulumi.Input[str]]] behaviors: List of behavior IDs
        :param pulumi.Input[str] identity_provider: Apply rule based on the IdP used: ANY, OKTA or SPECIFIC_IDP.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identity_provider_ids: When identity_provider is SPECIFIC_IDP then this is the list of IdP IDs to apply the rule on
        :param pulumi.Input[int] mfa_lifetime: Elapsed time before the next MFA challenge
        :param pulumi.Input[str] mfa_prompt: Prompt for MFA based on the device used, a factor session lifetime, or every sign-on attempt: DEVICE, SESSION or ALWAYS
        :param pulumi.Input[bool] mfa_remember_device: Remember MFA device.
        :param pulumi.Input[bool] mfa_required: Require MFA.
        :param pulumi.Input[str] name: Policy Rule Name
        :param pulumi.Input[str] network_connection: Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_excludes: The zones to exclude
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_includes: The zones to include
        :param pulumi.Input[str] policy_id: Policy ID of the Rule
        :param pulumi.Input[str] policyid: Policy ID of the Rule
        :param pulumi.Input[str] primary_factor: Primary factor.
        :param pulumi.Input[int] priority: Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an
               invalid priority is provided. API defaults it to the last (lowest) if not there.
        :param pulumi.Input[str] risc_level: Risc level: ANY, LOW, MEDIUM or HIGH
        :param pulumi.Input[int] session_idle: Max minutes a session can be idle.
        :param pulumi.Input[int] session_lifetime: Max minutes a session is active: Disable = 0.
        :param pulumi.Input[bool] session_persistent: Whether session cookies will last across browser sessions. Okta Administrators can never have persistent session
               cookies.
        :param pulumi.Input[str] status: Policy Rule Status: ACTIVE or INACTIVE.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_excludeds: Set of User IDs to Exclude
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if authtype is not None:
            pulumi.set(__self__, "authtype", authtype)
        if behaviors is not None:
            pulumi.set(__self__, "behaviors", behaviors)
        if factor_sequences is not None:
            pulumi.set(__self__, "factor_sequences", factor_sequences)
        if identity_provider is not None:
            pulumi.set(__self__, "identity_provider", identity_provider)
        if identity_provider_ids is not None:
            pulumi.set(__self__, "identity_provider_ids", identity_provider_ids)
        if mfa_lifetime is not None:
            pulumi.set(__self__, "mfa_lifetime", mfa_lifetime)
        if mfa_prompt is not None:
            pulumi.set(__self__, "mfa_prompt", mfa_prompt)
        if mfa_remember_device is not None:
            pulumi.set(__self__, "mfa_remember_device", mfa_remember_device)
        if mfa_required is not None:
            pulumi.set(__self__, "mfa_required", mfa_required)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_connection is not None:
            pulumi.set(__self__, "network_connection", network_connection)
        if network_excludes is not None:
            pulumi.set(__self__, "network_excludes", network_excludes)
        if network_includes is not None:
            pulumi.set(__self__, "network_includes", network_includes)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policyid is not None:
            warnings.warn("""Because of incorrect naming, 'policyid' field will be deprecated and then removed in the next versions of the provider. Please use 'policy_id' instead""", DeprecationWarning)
            pulumi.log.warn("""policyid is deprecated: Because of incorrect naming, 'policyid' field will be deprecated and then removed in the next versions of the provider. Please use 'policy_id' instead""")
        if policyid is not None:
            pulumi.set(__self__, "policyid", policyid)
        if primary_factor is not None:
            pulumi.set(__self__, "primary_factor", primary_factor)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if risc_level is not None:
            pulumi.set(__self__, "risc_level", risc_level)
        if session_idle is not None:
            pulumi.set(__self__, "session_idle", session_idle)
        if session_lifetime is not None:
            pulumi.set(__self__, "session_lifetime", session_lifetime)
        if session_persistent is not None:
            pulumi.set(__self__, "session_persistent", session_persistent)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if users_excludeds is not None:
            pulumi.set(__self__, "users_excludeds", users_excludeds)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[str]]:
        """
        Allow or deny access based on the rule conditions: ALLOW, DENY or CHALLENGE.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter
    def authtype(self) -> Optional[pulumi.Input[str]]:
        """
        Authentication entrypoint: ANY, RADIUS or LDAP_INTERFACE
        """
        return pulumi.get(self, "authtype")

    @authtype.setter
    def authtype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authtype", value)

    @property
    @pulumi.getter
    def behaviors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of behavior IDs
        """
        return pulumi.get(self, "behaviors")

    @behaviors.setter
    def behaviors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "behaviors", value)

    @property
    @pulumi.getter(name="factorSequences")
    def factor_sequences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SignonPolicyRuleFactorSequenceArgs']]]]:
        return pulumi.get(self, "factor_sequences")

    @factor_sequences.setter
    def factor_sequences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SignonPolicyRuleFactorSequenceArgs']]]]):
        pulumi.set(self, "factor_sequences", value)

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> Optional[pulumi.Input[str]]:
        """
        Apply rule based on the IdP used: ANY, OKTA or SPECIFIC_IDP.
        """
        return pulumi.get(self, "identity_provider")

    @identity_provider.setter
    def identity_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_provider", value)

    @property
    @pulumi.getter(name="identityProviderIds")
    def identity_provider_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        When identity_provider is SPECIFIC_IDP then this is the list of IdP IDs to apply the rule on
        """
        return pulumi.get(self, "identity_provider_ids")

    @identity_provider_ids.setter
    def identity_provider_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "identity_provider_ids", value)

    @property
    @pulumi.getter(name="mfaLifetime")
    def mfa_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        Elapsed time before the next MFA challenge
        """
        return pulumi.get(self, "mfa_lifetime")

    @mfa_lifetime.setter
    def mfa_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mfa_lifetime", value)

    @property
    @pulumi.getter(name="mfaPrompt")
    def mfa_prompt(self) -> Optional[pulumi.Input[str]]:
        """
        Prompt for MFA based on the device used, a factor session lifetime, or every sign-on attempt: DEVICE, SESSION or ALWAYS
        """
        return pulumi.get(self, "mfa_prompt")

    @mfa_prompt.setter
    def mfa_prompt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mfa_prompt", value)

    @property
    @pulumi.getter(name="mfaRememberDevice")
    def mfa_remember_device(self) -> Optional[pulumi.Input[bool]]:
        """
        Remember MFA device.
        """
        return pulumi.get(self, "mfa_remember_device")

    @mfa_remember_device.setter
    def mfa_remember_device(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mfa_remember_device", value)

    @property
    @pulumi.getter(name="mfaRequired")
    def mfa_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Require MFA.
        """
        return pulumi.get(self, "mfa_required")

    @mfa_required.setter
    def mfa_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mfa_required", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Policy Rule Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConnection")
    def network_connection(self) -> Optional[pulumi.Input[str]]:
        """
        Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
        """
        return pulumi.get(self, "network_connection")

    @network_connection.setter
    def network_connection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_connection", value)

    @property
    @pulumi.getter(name="networkExcludes")
    def network_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The zones to exclude
        """
        return pulumi.get(self, "network_excludes")

    @network_excludes.setter
    def network_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_excludes", value)

    @property
    @pulumi.getter(name="networkIncludes")
    def network_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The zones to include
        """
        return pulumi.get(self, "network_includes")

    @network_includes.setter
    def network_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_includes", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Policy ID of the Rule
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def policyid(self) -> Optional[pulumi.Input[str]]:
        """
        Policy ID of the Rule
        """
        return pulumi.get(self, "policyid")

    @policyid.setter
    def policyid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policyid", value)

    @property
    @pulumi.getter(name="primaryFactor")
    def primary_factor(self) -> Optional[pulumi.Input[str]]:
        """
        Primary factor.
        """
        return pulumi.get(self, "primary_factor")

    @primary_factor.setter
    def primary_factor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_factor", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an
        invalid priority is provided. API defaults it to the last (lowest) if not there.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="riscLevel")
    def risc_level(self) -> Optional[pulumi.Input[str]]:
        """
        Risc level: ANY, LOW, MEDIUM or HIGH
        """
        return pulumi.get(self, "risc_level")

    @risc_level.setter
    def risc_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "risc_level", value)

    @property
    @pulumi.getter(name="sessionIdle")
    def session_idle(self) -> Optional[pulumi.Input[int]]:
        """
        Max minutes a session can be idle.
        """
        return pulumi.get(self, "session_idle")

    @session_idle.setter
    def session_idle(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_idle", value)

    @property
    @pulumi.getter(name="sessionLifetime")
    def session_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        Max minutes a session is active: Disable = 0.
        """
        return pulumi.get(self, "session_lifetime")

    @session_lifetime.setter
    def session_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_lifetime", value)

    @property
    @pulumi.getter(name="sessionPersistent")
    def session_persistent(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether session cookies will last across browser sessions. Okta Administrators can never have persistent session
        cookies.
        """
        return pulumi.get(self, "session_persistent")

    @session_persistent.setter
    def session_persistent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "session_persistent", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Policy Rule Status: ACTIVE or INACTIVE.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="usersExcludeds")
    def users_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of User IDs to Exclude
        """
        return pulumi.get(self, "users_excludeds")

    @users_excludeds.setter
    def users_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users_excludeds", value)


@pulumi.input_type
class _SignonPolicyRuleState:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input[str]] = None,
                 authtype: Optional[pulumi.Input[str]] = None,
                 behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 factor_sequences: Optional[pulumi.Input[Sequence[pulumi.Input['SignonPolicyRuleFactorSequenceArgs']]]] = None,
                 identity_provider: Optional[pulumi.Input[str]] = None,
                 identity_provider_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mfa_lifetime: Optional[pulumi.Input[int]] = None,
                 mfa_prompt: Optional[pulumi.Input[str]] = None,
                 mfa_remember_device: Optional[pulumi.Input[bool]] = None,
                 mfa_required: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_connection: Optional[pulumi.Input[str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 policyid: Optional[pulumi.Input[str]] = None,
                 primary_factor: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 risc_level: Optional[pulumi.Input[str]] = None,
                 session_idle: Optional[pulumi.Input[int]] = None,
                 session_lifetime: Optional[pulumi.Input[int]] = None,
                 session_persistent: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering SignonPolicyRule resources.
        :param pulumi.Input[str] access: Allow or deny access based on the rule conditions: ALLOW, DENY or CHALLENGE.
        :param pulumi.Input[str] authtype: Authentication entrypoint: ANY, RADIUS or LDAP_INTERFACE
        :param pulumi.Input[Sequence[pulumi.Input[str]]] behaviors: List of behavior IDs
        :param pulumi.Input[str] identity_provider: Apply rule based on the IdP used: ANY, OKTA or SPECIFIC_IDP.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identity_provider_ids: When identity_provider is SPECIFIC_IDP then this is the list of IdP IDs to apply the rule on
        :param pulumi.Input[int] mfa_lifetime: Elapsed time before the next MFA challenge
        :param pulumi.Input[str] mfa_prompt: Prompt for MFA based on the device used, a factor session lifetime, or every sign-on attempt: DEVICE, SESSION or ALWAYS
        :param pulumi.Input[bool] mfa_remember_device: Remember MFA device.
        :param pulumi.Input[bool] mfa_required: Require MFA.
        :param pulumi.Input[str] name: Policy Rule Name
        :param pulumi.Input[str] network_connection: Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_excludes: The zones to exclude
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_includes: The zones to include
        :param pulumi.Input[str] policy_id: Policy ID of the Rule
        :param pulumi.Input[str] policyid: Policy ID of the Rule
        :param pulumi.Input[str] primary_factor: Primary factor.
        :param pulumi.Input[int] priority: Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an
               invalid priority is provided. API defaults it to the last (lowest) if not there.
        :param pulumi.Input[str] risc_level: Risc level: ANY, LOW, MEDIUM or HIGH
        :param pulumi.Input[int] session_idle: Max minutes a session can be idle.
        :param pulumi.Input[int] session_lifetime: Max minutes a session is active: Disable = 0.
        :param pulumi.Input[bool] session_persistent: Whether session cookies will last across browser sessions. Okta Administrators can never have persistent session
               cookies.
        :param pulumi.Input[str] status: Policy Rule Status: ACTIVE or INACTIVE.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_excludeds: Set of User IDs to Exclude
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if authtype is not None:
            pulumi.set(__self__, "authtype", authtype)
        if behaviors is not None:
            pulumi.set(__self__, "behaviors", behaviors)
        if factor_sequences is not None:
            pulumi.set(__self__, "factor_sequences", factor_sequences)
        if identity_provider is not None:
            pulumi.set(__self__, "identity_provider", identity_provider)
        if identity_provider_ids is not None:
            pulumi.set(__self__, "identity_provider_ids", identity_provider_ids)
        if mfa_lifetime is not None:
            pulumi.set(__self__, "mfa_lifetime", mfa_lifetime)
        if mfa_prompt is not None:
            pulumi.set(__self__, "mfa_prompt", mfa_prompt)
        if mfa_remember_device is not None:
            pulumi.set(__self__, "mfa_remember_device", mfa_remember_device)
        if mfa_required is not None:
            pulumi.set(__self__, "mfa_required", mfa_required)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_connection is not None:
            pulumi.set(__self__, "network_connection", network_connection)
        if network_excludes is not None:
            pulumi.set(__self__, "network_excludes", network_excludes)
        if network_includes is not None:
            pulumi.set(__self__, "network_includes", network_includes)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policyid is not None:
            warnings.warn("""Because of incorrect naming, 'policyid' field will be deprecated and then removed in the next versions of the provider. Please use 'policy_id' instead""", DeprecationWarning)
            pulumi.log.warn("""policyid is deprecated: Because of incorrect naming, 'policyid' field will be deprecated and then removed in the next versions of the provider. Please use 'policy_id' instead""")
        if policyid is not None:
            pulumi.set(__self__, "policyid", policyid)
        if primary_factor is not None:
            pulumi.set(__self__, "primary_factor", primary_factor)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if risc_level is not None:
            pulumi.set(__self__, "risc_level", risc_level)
        if session_idle is not None:
            pulumi.set(__self__, "session_idle", session_idle)
        if session_lifetime is not None:
            pulumi.set(__self__, "session_lifetime", session_lifetime)
        if session_persistent is not None:
            pulumi.set(__self__, "session_persistent", session_persistent)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if users_excludeds is not None:
            pulumi.set(__self__, "users_excludeds", users_excludeds)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[str]]:
        """
        Allow or deny access based on the rule conditions: ALLOW, DENY or CHALLENGE.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter
    def authtype(self) -> Optional[pulumi.Input[str]]:
        """
        Authentication entrypoint: ANY, RADIUS or LDAP_INTERFACE
        """
        return pulumi.get(self, "authtype")

    @authtype.setter
    def authtype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authtype", value)

    @property
    @pulumi.getter
    def behaviors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of behavior IDs
        """
        return pulumi.get(self, "behaviors")

    @behaviors.setter
    def behaviors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "behaviors", value)

    @property
    @pulumi.getter(name="factorSequences")
    def factor_sequences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SignonPolicyRuleFactorSequenceArgs']]]]:
        return pulumi.get(self, "factor_sequences")

    @factor_sequences.setter
    def factor_sequences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SignonPolicyRuleFactorSequenceArgs']]]]):
        pulumi.set(self, "factor_sequences", value)

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> Optional[pulumi.Input[str]]:
        """
        Apply rule based on the IdP used: ANY, OKTA or SPECIFIC_IDP.
        """
        return pulumi.get(self, "identity_provider")

    @identity_provider.setter
    def identity_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_provider", value)

    @property
    @pulumi.getter(name="identityProviderIds")
    def identity_provider_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        When identity_provider is SPECIFIC_IDP then this is the list of IdP IDs to apply the rule on
        """
        return pulumi.get(self, "identity_provider_ids")

    @identity_provider_ids.setter
    def identity_provider_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "identity_provider_ids", value)

    @property
    @pulumi.getter(name="mfaLifetime")
    def mfa_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        Elapsed time before the next MFA challenge
        """
        return pulumi.get(self, "mfa_lifetime")

    @mfa_lifetime.setter
    def mfa_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mfa_lifetime", value)

    @property
    @pulumi.getter(name="mfaPrompt")
    def mfa_prompt(self) -> Optional[pulumi.Input[str]]:
        """
        Prompt for MFA based on the device used, a factor session lifetime, or every sign-on attempt: DEVICE, SESSION or ALWAYS
        """
        return pulumi.get(self, "mfa_prompt")

    @mfa_prompt.setter
    def mfa_prompt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mfa_prompt", value)

    @property
    @pulumi.getter(name="mfaRememberDevice")
    def mfa_remember_device(self) -> Optional[pulumi.Input[bool]]:
        """
        Remember MFA device.
        """
        return pulumi.get(self, "mfa_remember_device")

    @mfa_remember_device.setter
    def mfa_remember_device(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mfa_remember_device", value)

    @property
    @pulumi.getter(name="mfaRequired")
    def mfa_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Require MFA.
        """
        return pulumi.get(self, "mfa_required")

    @mfa_required.setter
    def mfa_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mfa_required", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Policy Rule Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConnection")
    def network_connection(self) -> Optional[pulumi.Input[str]]:
        """
        Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
        """
        return pulumi.get(self, "network_connection")

    @network_connection.setter
    def network_connection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_connection", value)

    @property
    @pulumi.getter(name="networkExcludes")
    def network_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The zones to exclude
        """
        return pulumi.get(self, "network_excludes")

    @network_excludes.setter
    def network_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_excludes", value)

    @property
    @pulumi.getter(name="networkIncludes")
    def network_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The zones to include
        """
        return pulumi.get(self, "network_includes")

    @network_includes.setter
    def network_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_includes", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Policy ID of the Rule
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def policyid(self) -> Optional[pulumi.Input[str]]:
        """
        Policy ID of the Rule
        """
        return pulumi.get(self, "policyid")

    @policyid.setter
    def policyid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policyid", value)

    @property
    @pulumi.getter(name="primaryFactor")
    def primary_factor(self) -> Optional[pulumi.Input[str]]:
        """
        Primary factor.
        """
        return pulumi.get(self, "primary_factor")

    @primary_factor.setter
    def primary_factor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_factor", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an
        invalid priority is provided. API defaults it to the last (lowest) if not there.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="riscLevel")
    def risc_level(self) -> Optional[pulumi.Input[str]]:
        """
        Risc level: ANY, LOW, MEDIUM or HIGH
        """
        return pulumi.get(self, "risc_level")

    @risc_level.setter
    def risc_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "risc_level", value)

    @property
    @pulumi.getter(name="sessionIdle")
    def session_idle(self) -> Optional[pulumi.Input[int]]:
        """
        Max minutes a session can be idle.
        """
        return pulumi.get(self, "session_idle")

    @session_idle.setter
    def session_idle(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_idle", value)

    @property
    @pulumi.getter(name="sessionLifetime")
    def session_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        Max minutes a session is active: Disable = 0.
        """
        return pulumi.get(self, "session_lifetime")

    @session_lifetime.setter
    def session_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_lifetime", value)

    @property
    @pulumi.getter(name="sessionPersistent")
    def session_persistent(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether session cookies will last across browser sessions. Okta Administrators can never have persistent session
        cookies.
        """
        return pulumi.get(self, "session_persistent")

    @session_persistent.setter
    def session_persistent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "session_persistent", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Policy Rule Status: ACTIVE or INACTIVE.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="usersExcludeds")
    def users_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of User IDs to Exclude
        """
        return pulumi.get(self, "users_excludeds")

    @users_excludeds.setter
    def users_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users_excludeds", value)


warnings.warn("""Deprecated. Use policy.RuleSignon instead. This resource will be removed in version 4.0 of this provider.""", DeprecationWarning)


class SignonPolicyRule(pulumi.CustomResource):
    warnings.warn("""Deprecated. Use policy.RuleSignon instead. This resource will be removed in version 4.0 of this provider.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[str]] = None,
                 authtype: Optional[pulumi.Input[str]] = None,
                 behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 factor_sequences: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SignonPolicyRuleFactorSequenceArgs']]]]] = None,
                 identity_provider: Optional[pulumi.Input[str]] = None,
                 identity_provider_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mfa_lifetime: Optional[pulumi.Input[int]] = None,
                 mfa_prompt: Optional[pulumi.Input[str]] = None,
                 mfa_remember_device: Optional[pulumi.Input[bool]] = None,
                 mfa_required: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_connection: Optional[pulumi.Input[str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 policyid: Optional[pulumi.Input[str]] = None,
                 primary_factor: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 risc_level: Optional[pulumi.Input[str]] = None,
                 session_idle: Optional[pulumi.Input[int]] = None,
                 session_lifetime: Optional[pulumi.Input[int]] = None,
                 session_persistent: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Create a SignonPolicyRule resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access: Allow or deny access based on the rule conditions: ALLOW, DENY or CHALLENGE.
        :param pulumi.Input[str] authtype: Authentication entrypoint: ANY, RADIUS or LDAP_INTERFACE
        :param pulumi.Input[Sequence[pulumi.Input[str]]] behaviors: List of behavior IDs
        :param pulumi.Input[str] identity_provider: Apply rule based on the IdP used: ANY, OKTA or SPECIFIC_IDP.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identity_provider_ids: When identity_provider is SPECIFIC_IDP then this is the list of IdP IDs to apply the rule on
        :param pulumi.Input[int] mfa_lifetime: Elapsed time before the next MFA challenge
        :param pulumi.Input[str] mfa_prompt: Prompt for MFA based on the device used, a factor session lifetime, or every sign-on attempt: DEVICE, SESSION or ALWAYS
        :param pulumi.Input[bool] mfa_remember_device: Remember MFA device.
        :param pulumi.Input[bool] mfa_required: Require MFA.
        :param pulumi.Input[str] name: Policy Rule Name
        :param pulumi.Input[str] network_connection: Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_excludes: The zones to exclude
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_includes: The zones to include
        :param pulumi.Input[str] policy_id: Policy ID of the Rule
        :param pulumi.Input[str] policyid: Policy ID of the Rule
        :param pulumi.Input[str] primary_factor: Primary factor.
        :param pulumi.Input[int] priority: Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an
               invalid priority is provided. API defaults it to the last (lowest) if not there.
        :param pulumi.Input[str] risc_level: Risc level: ANY, LOW, MEDIUM or HIGH
        :param pulumi.Input[int] session_idle: Max minutes a session can be idle.
        :param pulumi.Input[int] session_lifetime: Max minutes a session is active: Disable = 0.
        :param pulumi.Input[bool] session_persistent: Whether session cookies will last across browser sessions. Okta Administrators can never have persistent session
               cookies.
        :param pulumi.Input[str] status: Policy Rule Status: ACTIVE or INACTIVE.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_excludeds: Set of User IDs to Exclude
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SignonPolicyRuleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a SignonPolicyRule resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SignonPolicyRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SignonPolicyRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[str]] = None,
                 authtype: Optional[pulumi.Input[str]] = None,
                 behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 factor_sequences: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SignonPolicyRuleFactorSequenceArgs']]]]] = None,
                 identity_provider: Optional[pulumi.Input[str]] = None,
                 identity_provider_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mfa_lifetime: Optional[pulumi.Input[int]] = None,
                 mfa_prompt: Optional[pulumi.Input[str]] = None,
                 mfa_remember_device: Optional[pulumi.Input[bool]] = None,
                 mfa_required: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_connection: Optional[pulumi.Input[str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 policyid: Optional[pulumi.Input[str]] = None,
                 primary_factor: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 risc_level: Optional[pulumi.Input[str]] = None,
                 session_idle: Optional[pulumi.Input[int]] = None,
                 session_lifetime: Optional[pulumi.Input[int]] = None,
                 session_persistent: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        pulumi.log.warn("""SignonPolicyRule is deprecated: Deprecated. Use policy.RuleSignon instead. This resource will be removed in version 4.0 of this provider.""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SignonPolicyRuleArgs.__new__(SignonPolicyRuleArgs)

            __props__.__dict__["access"] = access
            __props__.__dict__["authtype"] = authtype
            __props__.__dict__["behaviors"] = behaviors
            __props__.__dict__["factor_sequences"] = factor_sequences
            __props__.__dict__["identity_provider"] = identity_provider
            __props__.__dict__["identity_provider_ids"] = identity_provider_ids
            __props__.__dict__["mfa_lifetime"] = mfa_lifetime
            __props__.__dict__["mfa_prompt"] = mfa_prompt
            __props__.__dict__["mfa_remember_device"] = mfa_remember_device
            __props__.__dict__["mfa_required"] = mfa_required
            __props__.__dict__["name"] = name
            __props__.__dict__["network_connection"] = network_connection
            __props__.__dict__["network_excludes"] = network_excludes
            __props__.__dict__["network_includes"] = network_includes
            __props__.__dict__["policy_id"] = policy_id
            if policyid is not None and not opts.urn:
                warnings.warn("""Because of incorrect naming, 'policyid' field will be deprecated and then removed in the next versions of the provider. Please use 'policy_id' instead""", DeprecationWarning)
                pulumi.log.warn("""policyid is deprecated: Because of incorrect naming, 'policyid' field will be deprecated and then removed in the next versions of the provider. Please use 'policy_id' instead""")
            __props__.__dict__["policyid"] = policyid
            __props__.__dict__["primary_factor"] = primary_factor
            __props__.__dict__["priority"] = priority
            __props__.__dict__["risc_level"] = risc_level
            __props__.__dict__["session_idle"] = session_idle
            __props__.__dict__["session_lifetime"] = session_lifetime
            __props__.__dict__["session_persistent"] = session_persistent
            __props__.__dict__["status"] = status
            __props__.__dict__["users_excludeds"] = users_excludeds
        super(SignonPolicyRule, __self__).__init__(
            'okta:deprecated/signonPolicyRule:SignonPolicyRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access: Optional[pulumi.Input[str]] = None,
            authtype: Optional[pulumi.Input[str]] = None,
            behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            factor_sequences: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SignonPolicyRuleFactorSequenceArgs']]]]] = None,
            identity_provider: Optional[pulumi.Input[str]] = None,
            identity_provider_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            mfa_lifetime: Optional[pulumi.Input[int]] = None,
            mfa_prompt: Optional[pulumi.Input[str]] = None,
            mfa_remember_device: Optional[pulumi.Input[bool]] = None,
            mfa_required: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_connection: Optional[pulumi.Input[str]] = None,
            network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            policyid: Optional[pulumi.Input[str]] = None,
            primary_factor: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            risc_level: Optional[pulumi.Input[str]] = None,
            session_idle: Optional[pulumi.Input[int]] = None,
            session_lifetime: Optional[pulumi.Input[int]] = None,
            session_persistent: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'SignonPolicyRule':
        """
        Get an existing SignonPolicyRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access: Allow or deny access based on the rule conditions: ALLOW, DENY or CHALLENGE.
        :param pulumi.Input[str] authtype: Authentication entrypoint: ANY, RADIUS or LDAP_INTERFACE
        :param pulumi.Input[Sequence[pulumi.Input[str]]] behaviors: List of behavior IDs
        :param pulumi.Input[str] identity_provider: Apply rule based on the IdP used: ANY, OKTA or SPECIFIC_IDP.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identity_provider_ids: When identity_provider is SPECIFIC_IDP then this is the list of IdP IDs to apply the rule on
        :param pulumi.Input[int] mfa_lifetime: Elapsed time before the next MFA challenge
        :param pulumi.Input[str] mfa_prompt: Prompt for MFA based on the device used, a factor session lifetime, or every sign-on attempt: DEVICE, SESSION or ALWAYS
        :param pulumi.Input[bool] mfa_remember_device: Remember MFA device.
        :param pulumi.Input[bool] mfa_required: Require MFA.
        :param pulumi.Input[str] name: Policy Rule Name
        :param pulumi.Input[str] network_connection: Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_excludes: The zones to exclude
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_includes: The zones to include
        :param pulumi.Input[str] policy_id: Policy ID of the Rule
        :param pulumi.Input[str] policyid: Policy ID of the Rule
        :param pulumi.Input[str] primary_factor: Primary factor.
        :param pulumi.Input[int] priority: Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an
               invalid priority is provided. API defaults it to the last (lowest) if not there.
        :param pulumi.Input[str] risc_level: Risc level: ANY, LOW, MEDIUM or HIGH
        :param pulumi.Input[int] session_idle: Max minutes a session can be idle.
        :param pulumi.Input[int] session_lifetime: Max minutes a session is active: Disable = 0.
        :param pulumi.Input[bool] session_persistent: Whether session cookies will last across browser sessions. Okta Administrators can never have persistent session
               cookies.
        :param pulumi.Input[str] status: Policy Rule Status: ACTIVE or INACTIVE.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users_excludeds: Set of User IDs to Exclude
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SignonPolicyRuleState.__new__(_SignonPolicyRuleState)

        __props__.__dict__["access"] = access
        __props__.__dict__["authtype"] = authtype
        __props__.__dict__["behaviors"] = behaviors
        __props__.__dict__["factor_sequences"] = factor_sequences
        __props__.__dict__["identity_provider"] = identity_provider
        __props__.__dict__["identity_provider_ids"] = identity_provider_ids
        __props__.__dict__["mfa_lifetime"] = mfa_lifetime
        __props__.__dict__["mfa_prompt"] = mfa_prompt
        __props__.__dict__["mfa_remember_device"] = mfa_remember_device
        __props__.__dict__["mfa_required"] = mfa_required
        __props__.__dict__["name"] = name
        __props__.__dict__["network_connection"] = network_connection
        __props__.__dict__["network_excludes"] = network_excludes
        __props__.__dict__["network_includes"] = network_includes
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["policyid"] = policyid
        __props__.__dict__["primary_factor"] = primary_factor
        __props__.__dict__["priority"] = priority
        __props__.__dict__["risc_level"] = risc_level
        __props__.__dict__["session_idle"] = session_idle
        __props__.__dict__["session_lifetime"] = session_lifetime
        __props__.__dict__["session_persistent"] = session_persistent
        __props__.__dict__["status"] = status
        __props__.__dict__["users_excludeds"] = users_excludeds
        return SignonPolicyRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Output[Optional[str]]:
        """
        Allow or deny access based on the rule conditions: ALLOW, DENY or CHALLENGE.
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def authtype(self) -> pulumi.Output[Optional[str]]:
        """
        Authentication entrypoint: ANY, RADIUS or LDAP_INTERFACE
        """
        return pulumi.get(self, "authtype")

    @property
    @pulumi.getter
    def behaviors(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of behavior IDs
        """
        return pulumi.get(self, "behaviors")

    @property
    @pulumi.getter(name="factorSequences")
    def factor_sequences(self) -> pulumi.Output[Optional[Sequence['outputs.SignonPolicyRuleFactorSequence']]]:
        return pulumi.get(self, "factor_sequences")

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> pulumi.Output[Optional[str]]:
        """
        Apply rule based on the IdP used: ANY, OKTA or SPECIFIC_IDP.
        """
        return pulumi.get(self, "identity_provider")

    @property
    @pulumi.getter(name="identityProviderIds")
    def identity_provider_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        When identity_provider is SPECIFIC_IDP then this is the list of IdP IDs to apply the rule on
        """
        return pulumi.get(self, "identity_provider_ids")

    @property
    @pulumi.getter(name="mfaLifetime")
    def mfa_lifetime(self) -> pulumi.Output[Optional[int]]:
        """
        Elapsed time before the next MFA challenge
        """
        return pulumi.get(self, "mfa_lifetime")

    @property
    @pulumi.getter(name="mfaPrompt")
    def mfa_prompt(self) -> pulumi.Output[Optional[str]]:
        """
        Prompt for MFA based on the device used, a factor session lifetime, or every sign-on attempt: DEVICE, SESSION or ALWAYS
        """
        return pulumi.get(self, "mfa_prompt")

    @property
    @pulumi.getter(name="mfaRememberDevice")
    def mfa_remember_device(self) -> pulumi.Output[Optional[bool]]:
        """
        Remember MFA device.
        """
        return pulumi.get(self, "mfa_remember_device")

    @property
    @pulumi.getter(name="mfaRequired")
    def mfa_required(self) -> pulumi.Output[Optional[bool]]:
        """
        Require MFA.
        """
        return pulumi.get(self, "mfa_required")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Policy Rule Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkConnection")
    def network_connection(self) -> pulumi.Output[Optional[str]]:
        """
        Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
        """
        return pulumi.get(self, "network_connection")

    @property
    @pulumi.getter(name="networkExcludes")
    def network_excludes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The zones to exclude
        """
        return pulumi.get(self, "network_excludes")

    @property
    @pulumi.getter(name="networkIncludes")
    def network_includes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The zones to include
        """
        return pulumi.get(self, "network_includes")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[Optional[str]]:
        """
        Policy ID of the Rule
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def policyid(self) -> pulumi.Output[Optional[str]]:
        """
        Policy ID of the Rule
        """
        return pulumi.get(self, "policyid")

    @property
    @pulumi.getter(name="primaryFactor")
    def primary_factor(self) -> pulumi.Output[str]:
        """
        Primary factor.
        """
        return pulumi.get(self, "primary_factor")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[int]]:
        """
        Policy Rule Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an
        invalid priority is provided. API defaults it to the last (lowest) if not there.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="riscLevel")
    def risc_level(self) -> pulumi.Output[Optional[str]]:
        """
        Risc level: ANY, LOW, MEDIUM or HIGH
        """
        return pulumi.get(self, "risc_level")

    @property
    @pulumi.getter(name="sessionIdle")
    def session_idle(self) -> pulumi.Output[Optional[int]]:
        """
        Max minutes a session can be idle.
        """
        return pulumi.get(self, "session_idle")

    @property
    @pulumi.getter(name="sessionLifetime")
    def session_lifetime(self) -> pulumi.Output[Optional[int]]:
        """
        Max minutes a session is active: Disable = 0.
        """
        return pulumi.get(self, "session_lifetime")

    @property
    @pulumi.getter(name="sessionPersistent")
    def session_persistent(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether session cookies will last across browser sessions. Okta Administrators can never have persistent session
        cookies.
        """
        return pulumi.get(self, "session_persistent")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        Policy Rule Status: ACTIVE or INACTIVE.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="usersExcludeds")
    def users_excludeds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Set of User IDs to Exclude
        """
        return pulumi.get(self, "users_excludeds")

