# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainArgs', 'Domain']

@pulumi.input_type
class DomainArgs:
    def __init__(__self__, *,
                 certificate_source_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 verify: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Domain resource.
        :param pulumi.Input[str] certificate_source_type: Certificate source type that indicates whether the certificate is provided by the user or Okta. Accepted values: `MANUAL`, `OKTA_MANAGED`. Default value = `MANUAL`
        :param pulumi.Input[str] name: Custom Domain name.
        :param pulumi.Input[bool] verify: Indicates whether the domain should be verified.
               - `DEPRECATED`: Please use `DomainVerification` resource instead.
        """
        if certificate_source_type is not None:
            pulumi.set(__self__, "certificate_source_type", certificate_source_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if verify is not None:
            warnings.warn("""The direct validation for the domain resource is deprecated, please use the `okta_domain_verification` resource for this functionality.""", DeprecationWarning)
            pulumi.log.warn("""verify is deprecated: The direct validation for the domain resource is deprecated, please use the `okta_domain_verification` resource for this functionality.""")
        if verify is not None:
            pulumi.set(__self__, "verify", verify)

    @property
    @pulumi.getter(name="certificateSourceType")
    def certificate_source_type(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate source type that indicates whether the certificate is provided by the user or Okta. Accepted values: `MANUAL`, `OKTA_MANAGED`. Default value = `MANUAL`
        """
        return pulumi.get(self, "certificate_source_type")

    @certificate_source_type.setter
    def certificate_source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_source_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Custom Domain name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def verify(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the domain should be verified.
        - `DEPRECATED`: Please use `DomainVerification` resource instead.
        """
        return pulumi.get(self, "verify")

    @verify.setter
    def verify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "verify", value)


@pulumi.input_type
class _DomainState:
    def __init__(__self__, *,
                 certificate_source_type: Optional[pulumi.Input[str]] = None,
                 dns_records: Optional[pulumi.Input[Sequence[pulumi.Input['DomainDnsRecordArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 validation_status: Optional[pulumi.Input[str]] = None,
                 verify: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Domain resources.
        :param pulumi.Input[str] certificate_source_type: Certificate source type that indicates whether the certificate is provided by the user or Okta. Accepted values: `MANUAL`, `OKTA_MANAGED`. Default value = `MANUAL`
        :param pulumi.Input[Sequence[pulumi.Input['DomainDnsRecordArgs']]] dns_records: TXT and CNAME records to be registered for the Domain.
        :param pulumi.Input[str] name: Custom Domain name.
        :param pulumi.Input[str] validation_status: Status of the domain.
        :param pulumi.Input[bool] verify: Indicates whether the domain should be verified.
               - `DEPRECATED`: Please use `DomainVerification` resource instead.
        """
        if certificate_source_type is not None:
            pulumi.set(__self__, "certificate_source_type", certificate_source_type)
        if dns_records is not None:
            pulumi.set(__self__, "dns_records", dns_records)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if validation_status is not None:
            pulumi.set(__self__, "validation_status", validation_status)
        if verify is not None:
            warnings.warn("""The direct validation for the domain resource is deprecated, please use the `okta_domain_verification` resource for this functionality.""", DeprecationWarning)
            pulumi.log.warn("""verify is deprecated: The direct validation for the domain resource is deprecated, please use the `okta_domain_verification` resource for this functionality.""")
        if verify is not None:
            pulumi.set(__self__, "verify", verify)

    @property
    @pulumi.getter(name="certificateSourceType")
    def certificate_source_type(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate source type that indicates whether the certificate is provided by the user or Okta. Accepted values: `MANUAL`, `OKTA_MANAGED`. Default value = `MANUAL`
        """
        return pulumi.get(self, "certificate_source_type")

    @certificate_source_type.setter
    def certificate_source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_source_type", value)

    @property
    @pulumi.getter(name="dnsRecords")
    def dns_records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainDnsRecordArgs']]]]:
        """
        TXT and CNAME records to be registered for the Domain.
        """
        return pulumi.get(self, "dns_records")

    @dns_records.setter
    def dns_records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainDnsRecordArgs']]]]):
        pulumi.set(self, "dns_records", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Custom Domain name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="validationStatus")
    def validation_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the domain.
        """
        return pulumi.get(self, "validation_status")

    @validation_status.setter
    def validation_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "validation_status", value)

    @property
    @pulumi.getter
    def verify(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the domain should be verified.
        - `DEPRECATED`: Please use `DomainVerification` resource instead.
        """
        return pulumi.get(self, "verify")

    @verify.setter
    def verify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "verify", value)


class Domain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_source_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 verify: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Manages custom domain for your organization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.Domain("example")
        ```

        ## Import

        Okta Admin Role Targets can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:index/domain:Domain example &#60;domain_id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_source_type: Certificate source type that indicates whether the certificate is provided by the user or Okta. Accepted values: `MANUAL`, `OKTA_MANAGED`. Default value = `MANUAL`
        :param pulumi.Input[str] name: Custom Domain name.
        :param pulumi.Input[bool] verify: Indicates whether the domain should be verified.
               - `DEPRECATED`: Please use `DomainVerification` resource instead.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DomainArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages custom domain for your organization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.Domain("example")
        ```

        ## Import

        Okta Admin Role Targets can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:index/domain:Domain example &#60;domain_id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param DomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_source_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 verify: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainArgs.__new__(DomainArgs)

            __props__.__dict__["certificate_source_type"] = certificate_source_type
            __props__.__dict__["name"] = name
            if verify is not None and not opts.urn:
                warnings.warn("""The direct validation for the domain resource is deprecated, please use the `okta_domain_verification` resource for this functionality.""", DeprecationWarning)
                pulumi.log.warn("""verify is deprecated: The direct validation for the domain resource is deprecated, please use the `okta_domain_verification` resource for this functionality.""")
            __props__.__dict__["verify"] = verify
            __props__.__dict__["dns_records"] = None
            __props__.__dict__["validation_status"] = None
        super(Domain, __self__).__init__(
            'okta:index/domain:Domain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_source_type: Optional[pulumi.Input[str]] = None,
            dns_records: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainDnsRecordArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            validation_status: Optional[pulumi.Input[str]] = None,
            verify: Optional[pulumi.Input[bool]] = None) -> 'Domain':
        """
        Get an existing Domain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_source_type: Certificate source type that indicates whether the certificate is provided by the user or Okta. Accepted values: `MANUAL`, `OKTA_MANAGED`. Default value = `MANUAL`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainDnsRecordArgs']]]] dns_records: TXT and CNAME records to be registered for the Domain.
        :param pulumi.Input[str] name: Custom Domain name.
        :param pulumi.Input[str] validation_status: Status of the domain.
        :param pulumi.Input[bool] verify: Indicates whether the domain should be verified.
               - `DEPRECATED`: Please use `DomainVerification` resource instead.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainState.__new__(_DomainState)

        __props__.__dict__["certificate_source_type"] = certificate_source_type
        __props__.__dict__["dns_records"] = dns_records
        __props__.__dict__["name"] = name
        __props__.__dict__["validation_status"] = validation_status
        __props__.__dict__["verify"] = verify
        return Domain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateSourceType")
    def certificate_source_type(self) -> pulumi.Output[Optional[str]]:
        """
        Certificate source type that indicates whether the certificate is provided by the user or Okta. Accepted values: `MANUAL`, `OKTA_MANAGED`. Default value = `MANUAL`
        """
        return pulumi.get(self, "certificate_source_type")

    @property
    @pulumi.getter(name="dnsRecords")
    def dns_records(self) -> pulumi.Output[Sequence['outputs.DomainDnsRecord']]:
        """
        TXT and CNAME records to be registered for the Domain.
        """
        return pulumi.get(self, "dns_records")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Custom Domain name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="validationStatus")
    def validation_status(self) -> pulumi.Output[str]:
        """
        Status of the domain.
        """
        return pulumi.get(self, "validation_status")

    @property
    @pulumi.getter
    def verify(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the domain should be verified.
        - `DEPRECATED`: Please use `DomainVerification` resource instead.
        """
        return pulumi.get(self, "verify")

