# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetAuthServerClaimResult',
    'AwaitableGetAuthServerClaimResult',
    'get_auth_server_claim',
    'get_auth_server_claim_output',
]

@pulumi.output_type
class GetAuthServerClaimResult:
    """
    A collection of values returned by getAuthServerClaim.
    """
    def __init__(__self__, always_include_in_token=None, auth_server_id=None, claim_type=None, id=None, name=None, scopes=None, status=None, value=None, value_type=None):
        if always_include_in_token and not isinstance(always_include_in_token, bool):
            raise TypeError("Expected argument 'always_include_in_token' to be a bool")
        pulumi.set(__self__, "always_include_in_token", always_include_in_token)
        if auth_server_id and not isinstance(auth_server_id, str):
            raise TypeError("Expected argument 'auth_server_id' to be a str")
        pulumi.set(__self__, "auth_server_id", auth_server_id)
        if claim_type and not isinstance(claim_type, str):
            raise TypeError("Expected argument 'claim_type' to be a str")
        pulumi.set(__self__, "claim_type", claim_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if scopes and not isinstance(scopes, list):
            raise TypeError("Expected argument 'scopes' to be a list")
        pulumi.set(__self__, "scopes", scopes)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if value and not isinstance(value, str):
            raise TypeError("Expected argument 'value' to be a str")
        pulumi.set(__self__, "value", value)
        if value_type and not isinstance(value_type, str):
            raise TypeError("Expected argument 'value_type' to be a str")
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter(name="alwaysIncludeInToken")
    def always_include_in_token(self) -> bool:
        """
        Specifies whether to include Claims in the token.
        """
        return pulumi.get(self, "always_include_in_token")

    @property
    @pulumi.getter(name="authServerId")
    def auth_server_id(self) -> str:
        return pulumi.get(self, "auth_server_id")

    @property
    @pulumi.getter(name="claimType")
    def claim_type(self) -> str:
        """
        Specifies whether the Claim is for an access token (`"RESOURCE"`) or ID token (`"IDENTITY"`).
        """
        return pulumi.get(self, "claim_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID of the claim.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the claim.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def scopes(self) -> Sequence[str]:
        """
        Specifies the scopes for this Claim.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the claim.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the claim
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        Specifies whether the Claim is an Okta EL expression (`"EXPRESSION"`), a set of groups (`"GROUPS"`), or a system claim (`"SYSTEM"`)
        """
        return pulumi.get(self, "value_type")


class AwaitableGetAuthServerClaimResult(GetAuthServerClaimResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthServerClaimResult(
            always_include_in_token=self.always_include_in_token,
            auth_server_id=self.auth_server_id,
            claim_type=self.claim_type,
            id=self.id,
            name=self.name,
            scopes=self.scopes,
            status=self.status,
            value=self.value,
            value_type=self.value_type)


def get_auth_server_claim(auth_server_id: Optional[str] = None,
                          id: Optional[str] = None,
                          name: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthServerClaimResult:
    """
    Use this data source to retrieve authorization server claim from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_auth_server_claim(auth_server_id="default",
        name="birthdate")
    ```


    :param str auth_server_id: Auth server ID.
    :param str id: ID of the claim. Conflicts with `name`.
    :param str name: Name of the claim. Conflicts with `id`.
    """
    __args__ = dict()
    __args__['authServerId'] = auth_server_id
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getAuthServerClaim:getAuthServerClaim', __args__, opts=opts, typ=GetAuthServerClaimResult).value

    return AwaitableGetAuthServerClaimResult(
        always_include_in_token=__ret__.always_include_in_token,
        auth_server_id=__ret__.auth_server_id,
        claim_type=__ret__.claim_type,
        id=__ret__.id,
        name=__ret__.name,
        scopes=__ret__.scopes,
        status=__ret__.status,
        value=__ret__.value,
        value_type=__ret__.value_type)


@_utilities.lift_output_func(get_auth_server_claim)
def get_auth_server_claim_output(auth_server_id: Optional[pulumi.Input[str]] = None,
                                 id: Optional[pulumi.Input[Optional[str]]] = None,
                                 name: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAuthServerClaimResult]:
    """
    Use this data source to retrieve authorization server claim from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    test = okta.get_auth_server_claim(auth_server_id="default",
        name="birthdate")
    ```


    :param str auth_server_id: Auth server ID.
    :param str id: ID of the claim. Conflicts with `name`.
    :param str name: Name of the claim. Conflicts with `id`.
    """
    ...
